/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','./Toolbar','./CheckBox','./SearchField','./List','./StandardListItem','sap/ui/base/ManagedObject','sap/ui/base/EventProvider','sap/ui/Device','sap/ui/core/InvisibleText','./ViewSettingsDialogRenderer'],function(q,l,C,I,T,a,S,L,b,M,E,D,c,V){"use strict";var d=l.ListMode;var e=l.ListType;var f=l.StringFilterOperator;var g="-list-item";var h=C.extend("sap.m.ViewSettingsDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Behavior",defaultValue:null},sortDescending:{type:"boolean",group:"Behavior",defaultValue:false},groupDescending:{type:"boolean",group:"Behavior",defaultValue:false},filterSearchOperator:{type:"sap.m.StringFilterOperator",group:"Behavior",defaultValue:f.StartsWith}},aggregations:{sortItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"sortItem",bindable:"bindable"},groupItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"groupItem",bindable:"bindable"},filterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"filterItem",bindable:"bindable"},presetFilterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"presetFilterItem",bindable:"bindable"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{selectedSortItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedGroupItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedPresetFilterItem:{type:"sap.m.ViewSettingsItem",multiple:false}},events:{confirm:{parameters:{sortItem:{type:"sap.m.ViewSettingsItem"},sortDescending:{type:"boolean"},groupItem:{type:"sap.m.ViewSettingsItem"},groupDescending:{type:"boolean"},presetFilterItem:{type:"sap.m.ViewSettingsItem"},filterItems:{type:"sap.m.ViewSettingsItem[]"},filterKeys:{type:"object",deprecated:true},filterCompoundKeys:{type:"object"},filterString:{type:"string"}}},cancel:{},resetFilters:{},filterDetailPageOpened:{parameters:{parentFilterItem:{type:"sap.m.ViewSettingsFilterItem"}}}}}});h.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sDialogWidth="350px";this._sDialogHeight="434px";this._bAppendedToUIArea=false;this._showSubHeader=false;this._filterDetailList=undefined;this._vContentPage=-1;this._oContentItem=null;this._oPreviousState={};this._sCustomTabsButtonsIdPrefix='-custom-button-';this._sTitleLabelId=this.getId()+"-title";this._aggregationToListItems("sortItems",{text:{listProp:"title"},selected:{}},{type:e.Active},{mode:d.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){var k=j.getParameter('listItem'),x=this.getSortItems(),y=this._getVSItem(k),i;y.setProperty('selected',j.getParameter('selected'),true,false);this.setAssociation('selectedSortItem',y,true);for(i=0;i<x.length;i++){if(y!==x[i]){x[i].setProperty('selected',false,true,false);}}}.bind(this)});};h.prototype.exit=function(){this._rb=null;this._sDialogWidth=null;this._sDialogHeight=null;this._bAppendedToUIArea=null;this._showSubHeader=null;this._vContentPage=null;this._oContentItem=null;this._oPreviousState=null;this._sortContent=null;this._groupContent=null;this._filterContent=null;this._sCustomTabsButtonsIdPrefix=null;this._fnFilterSearchCallback=null;if(this._bAppendedToUIArea&&this._dialog){var i=sap.ui.getCore().getStaticAreaRef();i=sap.ui.getCore().getUIArea(i);i.removeContent(this._dialog,true);}if(this._dialog){this._dialog.destroy();this._dialog=null;}if(this._navContainer){this._navContainer.destroy();this._navContainer=null;}if(this._titleLabel){this._titleLabel.destroy();this._titleLabel=null;}if(this._page1){this._page1.destroy();this._page1=null;}if(this._header){this._header.destroy();this._header=null;}if(this._resetButton){this._resetButton.destroy();this._resetButton=null;}if(this._subHeader){this._subHeader.destroy();this._subHeader=null;}if(this._segmentedButton){this._segmentedButton.destroy();this._segmentedButton=null;}if(this._sortButton){this._sortButton.destroy();this._sortButton=null;}if(this._groupButton){this._groupButton.destroy();this._groupButton=null;}if(this._filterButton){this._filterButton.destroy();this._filterButton=null;}if(this._sortList){this._sortList.destroy();this._sortList=null;}if(this._ariaSortListInvisibleText){this._ariaSortListInvisibleText.destroy();this._ariaSortListInvisibleText=null;}if(this._sortOrderList){this._sortOrderList.destroy();this._sortOrderList=null;this._ariaSortOrderInvisibleText.destroy();this._ariaSortOrderInvisibleText=null;}if(this._oGroupingNoneItem){this._oGroupingNoneItem.destroy();this._oGroupingNoneItem=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;this._ariaGroupListInvisibleText.destroy();this._ariaGroupListInvisibleText=null;}if(this._groupOrderList){this._groupOrderList.destroy();this._groupOrderList=null;this._ariaGroupOrderInvisibleText.destroy();this._ariaGroupOrderInvisibleText=null;}if(this._presetFilterList){this._presetFilterList.destroy();this._presetFilterList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._page2){this._page2.destroy();this._page2=null;}if(this._detailTitleLabel){this._detailTitleLabel.destroy();this._detailTitleLabel=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}if(this._oStringFilter){this._oStringFilter=null;}};h.prototype._aggregationToListItems=function(i,j,k,x){var y=this._getListType(i),z="_"+y+"List";if(!this.mToList){this.mToList={};}this.mToList[y]={"itemPropertyMap":j,"listItemOptions":k,"listOptions":x,"listName":z};};h.prototype._getListType=function(i){return i.replace('Items','');};h.prototype._createList=function(i){var j=this.getId()+"-"+i+"list",k=new L(j,this.mToList[i].listOptions);this[this.mToList[i].listName]=k;return k;};h.prototype._getList=function(i){if(!this.mToList||!this.mToList[i]){return;}return this[this.mToList[i].listName];};h.prototype._createListItem=function(i,j){var O=this.mToList[i].listItemOptions,k=this.mToList[i].itemPropertyMap,x;for(var P in k){if(k.hasOwnProperty(P)){x=k[P].listProp||P;O[x]=this._createListItemPropertyValue(i,P,j);}}return new b(O).data('item',j);};h.prototype._createListItemPropertyValue=function(i,P,j){var k=j.getMetadata().getAllProperties()[P].get(j),x=this.mToList[i].itemPropertyMap[P].fn;return x?x(k):k;};h.prototype._getListItem=function(i,j){var k=this._getList(i).getItems().filter(function(x){return x.data('item')===j;});return k.length?k[0]:null;};h.prototype._getVSItem=function(i){return i.data('item');};h.prototype.addCustomTab=function(i){var j=i.getId();if(j==='sort'||j==='filter'||j==='group'){throw'Id "'+j+'" is reserved and cannot be used as custom tab id.';}this.addAggregation('customTabs',i);return this;};h.prototype.invalidate=function(){if(this._dialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._dialog.invalidate(arguments);}};h.prototype.addStyleClass=function(){var i=this._getDialog();i.addStyleClass.apply(i,arguments);return this;};h.prototype.removeStyleClass=function(){var i=this._getDialog();i.removeStyleClass.apply(i,arguments);return this;};h.prototype.toggleStyleClass=function(){var i=this._getDialog();i.toggleStyleClass.apply(i,arguments);return this;};h.prototype.hasStyleClass=function(){var i=this._getDialog();return i.hasStyleClass.apply(i,arguments);};h.prototype.getDomRef=function(){if(this._dialog){return this._dialog.getDomRef.apply(this._dialog,arguments);}else{return null;}};h.prototype.setTitle=function(i){this._getTitleLabel().setText(i);this.setProperty("title",i,true);return this;};h.prototype.addAggregation=function(i,O,j){C.prototype.addAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var x=this._createListItem(k,O);var y=this._getList(k);if(!y){y=this._createList(k);}y.addItem(x);this._attachItemPropertyChange(k,O);}else{this._attachItemEventHandlers(i,O);}return this;};h.prototype.insertAggregation=function(i,O,j,k){C.prototype.insertAggregation.apply(this,arguments);var x=this._getListType(i);if(this.mToList[x]){var y=this._createListItem(x,O);var z=this._getList(x);if(!z){z=this._createList(x);}z.insertItem(y,j);this._attachItemPropertyChange(x,O);}else{this._attachItemEventHandlers(i,O);}return this;};h.prototype.removeAggregation=function(i,O,j){o.call(this,i,O);var R=C.prototype.removeAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var x=this._getListItem(k,R);var y=this._getList(k);var z=y.removeItem(x);z.destroy();this._detachItemPropertyChange(R);}return R;};h.prototype.removeAllAggregation=function(i,j){o.call(this);var R=C.prototype.removeAllAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var x=this._getList(k);if(x){var y=x.removeAllItems();y.forEach(function(z){z.destroy();});}R.forEach(function(z){this._detachItemPropertyChange(z);},this);}return R;};h.prototype.destroyAggregation=function(i,j){o.call(this);C.prototype.destroyAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var x=this._getList(k);if(x){x.destroyItems();}}return this;};h.prototype._detachItemPropertyChange=function(i){delete E.getEventList(i)["itemPropertyChanged"];};h.prototype._attachItemPropertyChange=function(i,j){j.attachEvent('itemPropertyChanged',function fnHandleItemPropertyChanged(k){var x,P,y,z,B,F;x=this._getListItem(i,j);P=k.getParameter('propertyKey');if(!this.mToList[i].itemPropertyMap[P]){return;}y=this.mToList[i].itemPropertyMap[P].listProp||P;z=k.getParameter('propertyValue');B=this.mToList[i].itemPropertyMap[P].fn;F=B?B(z):z;x.getMetadata().getAllProperties()[y].set(x,F);},this);};h.prototype._attachItemEventHandlers=function(i,O){if(i!=='groupItems'&&i!=='filterItems'){return this;}var j=i.replace('Items','');j=j.charAt(0).toUpperCase()+j.slice(1);O.attachEvent('itemPropertyChanged',function(i,k){if(i==='filterItems'&&k.getParameter('changedItem').getParent().getMetadata().getName()==='sap.m.ViewSettingsFilterItem'){if(k.getParameter('propertyKey')!=='selected'){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}else{if(this._filterDetailList){var x=this._filterDetailList.getItems();x.forEach(function(y){if(y.data('item').getId()===k.getParameter('changedItem').getId()){y.setSelected(k.getParameter('propertyValue'));}});this._updateSelectAllCheckBoxState();}}this._updateFilterCounters();}else{if(typeof this['_init'+j+'Content']==='function'){this['_init'+j+'Content']();}if(typeof this['_init'+j+'Items']==='function'){this['_init'+j+'Items']();}}}.bind(this,i));O.attachEvent('filterDetailItemsAggregationChange',function(k){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}.bind(this));return this;};h.prototype._setFilterDetailTitle=function(i){this._getDetailTitleLabel().setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")+" "+i.getText());};h.prototype.updateAggregation=function(i){C.prototype.updateAggregation.apply(this,arguments);if(i!=='groupItems'&&i!=='filterItems'){return this;}var j=i.replace('Items','');j=j.charAt(0).toUpperCase()+j.slice(1);if(typeof this['_init'+j+'Content']==='function'){this['_init'+j+'Content']();}if(typeof this['_init'+j+'Items']==='function'){this['_init'+j+'Items']();}};h.prototype.addSortItem=function(i){this.addAggregation("sortItems",i);if(i.getSelected()){this.setSelectedSortItem(i);}return this;};h.prototype.addGroupItem=function(i){this.addAggregation("groupItems",i);if(i.getSelected()){this.setSelectedGroupItem(i);}return this;};h.prototype.addPresetFilterItem=function(i){this.addAggregation("presetFilterItems",i);if(i.getSelected()){this.setSelectedPresetFilterItem(i);}return this;};h.prototype.setSelectedSortItem=function(j){var k=this.getSortItems(),i=0,x=n(j,k,"Could not set selected sort item. Item is not found: '"+j+"'");if(v(x)){for(i=0;i<k.length;i++){if(k[i].getId()!==x.getId()){k[i].setProperty('selected',false,true);}}if(x.getProperty('selected')!==true){x.setProperty('selected',true,true);}if(this._getDialog().isOpen()){this._updateListSelection(this._sortList,x);}this.setAssociation("selectedSortItem",x,true);}return this;};h.prototype.setSelectedGroupItem=function(j){var k=this.getGroupItems(),i=0,x=n(j,k,"Could not set selected group item. Item is not found: '"+j+"'");if(!x&&!j){x=this._oGroupingNoneItem;}if(v(x)){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}x.setProperty('selected',true,true);if(this._getDialog().isOpen()){this._updateListSelection(this._groupList,x);}this.setAssociation("selectedGroupItem",x,true);}return this;};h.prototype.setSelectedPresetFilterItem=function(j){var k=this.getPresetFilterItems(),i=0,x=n(j,k,"Could not set selected preset filter item. Item is not found: '"+j+"'");if(v(x)){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}x.setProperty('selected',true,true);this._clearSelectedFilters();this.setAssociation("selectedPresetFilterItem",x,true);}return this;};h.prototype.open=function(P){if(!this.getParent()&&!this._bAppendedToUIArea){var i=sap.ui.getCore().getStaticAreaRef();i=sap.ui.getCore().getUIArea(i);i.addContent(this._getDialog(),true);this._bAppendedToUIArea=true;}if(P&&this._vContentPage===3){q.sap.delayedCall(0,this._getNavContainer(),"to",[this._getPage1().getId(),"show"]);}this._initDialogContent(P);this._oPreviousState={sortItem:sap.ui.getCore().byId(this.getSelectedSortItem()),sortDescending:this.getSortDescending(),groupItem:sap.ui.getCore().byId(this.getSelectedGroupItem()),groupDescending:this.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(this.getSelectedPresetFilterItem()),filterKeys:this.getSelectedFilterKeys(),filterCompoundKeys:this.getSelectedFilterCompoundKeys(),navPage:this._getNavContainer().getCurrentPage(),contentPage:this._vContentPage,contentItem:this._oContentItem};if(D.system.desktop){this._getDialog().attachEventOnce("afterOpen",function(){var j=this._getNavContainer().getCurrentPage(),$;if(j){$=j.$("cont").firstFocusableDomRef();if($){if(q($).hasClass('sapMListUl')){var k=q($).find('.sapMLIB');k.length&&k[0].focus();return;}$.focus();}}},this);}this._getDialog().open();return this;};h.prototype.getSelectedFilterItems=function(){var k=[],F=this.getFilterItems(),x,y=true,i=0,j;for(;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getSelected()){k.push(F[i]);}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){x=F[i].getItems();y=F[i].getMultiSelect();for(j=0;j<x.length;j++){if(x[j].getSelected()){k.push(x[j]);if(!y){break;}}}}}return k;};h.prototype.getSelectedFilterString=function(){var F="",k,P=this.getSelectedPresetFilterItem(),x=this.getFilterItems(),y,z=true,i=0,j;if(P){F=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+sap.ui.getCore().byId(P).getText());}else{for(;i<x.length;i++){if(x[i]instanceof sap.m.ViewSettingsCustomItem){if(x[i].getSelected()){F+=x[i].getText()+", ";}}else if(x[i]instanceof sap.m.ViewSettingsFilterItem){y=x[i].getItems();z=x[i].getMultiSelect();k="";for(j=0;j<y.length;j++){if(y[j].getSelected()){k+=y[j].getText()+", ";if(!z){break;}}}k=k.substring(0,k.length-2);if(k){k=" ("+k+")";F+=x[i].getText()+k+", ";}}}F=F.substring(0,F.length-2);if(F){F=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+F);}}return F;};h.prototype.getSelectedFilterKeys=function(){var j={},k=this.getSelectedFilterItems(),i=0;for(;i<k.length;i++){j[k[i].getKey()]=k[i].getSelected();}return j;};h.prototype.getSelectedFilterCompoundKeys=function(){var j={},k=this.getSelectedFilterItems(),i,K,P,F;for(i=0;i<k.length;i++){F=k[i];if(F instanceof sap.m.ViewSettingsCustomItem){K=F.getKey();j[K]=F.getSelected();}else{K=F.getKey();P=F.getParent().getKey();if(!j[P]){j[P]={};}j[P][K]=F.getSelected();}}return j;};h.prototype.setSelectedFilterKeys=function(x){var F=this.getFilterItems(),y={},z,B,i,j,k;if(Object.keys(x).length){this._clearPresetFilter();}for(var K in x){z=null;if(x.hasOwnProperty(K)){for(i=0;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getKey()===K){z=F[i];F[i].setProperty('selected',x[K],true);}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){y=F[i].getItems();B=F[i].getMultiSelect();for(j=0;j<y.length;j++){if(y[j].getKey()===K){z=y[j];if(!B){for(k=0;k<y.length;k++){y[k].setProperty('selected',false,true);}}break;}}}if(z){break;}}if(z===null){q.sap.log.warning('Cannot set state for key "'+K+'" because there is no filter with these keys');continue;}z.setProperty('selected',x[K],true);}}return this;};h.prototype.setSelectedFilterCompoundKeys=function(i){var F=this.getFilterItems();var G=function(F,B,K){if(!B.hasOwnProperty(K)){return;}var z=m(F,K);return z;};if(Object.keys(i).length){this._clearPresetFilter();}for(var P in i){var j=G(F,i,P);if(!j){q.sap.log.warning('No filter with key "'+P);continue;}if(j instanceof sap.m.ViewSettingsCustomItem){j.setProperty('selected',i[P],true);}else if(j instanceof sap.m.ViewSettingsFilterItem){var k=i[P];var x=j.getItems();var y=j.getMultiSelect();for(var K in k){var z=G(x,k,K);if(!z){q.sap.log.warning('No filter with key "'+K);continue;}if(!y){x.forEach(function(B){B.setProperty('selected',false,true);});}z.setProperty('selected',k[K],true);}}}return this;};h.prototype._getDialog=function(){var i=this;if(this._dialog===undefined){this._dialog=new sap.m.Dialog(this.getId()+"-dialog",{ariaLabelledBy:this._sTitleLabelId,showHeader:false,stretch:D.system.phone,verticalScrolling:true,horizontalScrolling:false,contentWidth:this._sDialogWidth,contentHeight:this._sDialogHeight,content:this._getNavContainer(),beginButton:new sap.m.Button(this.getId()+"-acceptbutton",{text:this._rb.getText("VIEWSETTINGS_ACCEPT")}).attachPress(this._onConfirm,this),endButton:new sap.m.Button(this.getId()+"-cancelbutton",{text:this._rb.getText("VIEWSETTINGS_CANCEL")}).attachPress(this._onCancel,this)}).addStyleClass("sapMVSD");this.addDependent(this._dialog);var j=this._dialog.onsapescape;this._dialog.onsapescape=function(k){if(j){j.call(i._dialog,k);}i._onCancel();};this._dialog.onsapentermodifiers=function(k){if(k.shiftKey&&!k.ctrlKey&&!k.altKey){i._pressBackButton();}};}return this._dialog;};h.prototype._getNavContainer=function(){if(this._navContainer===undefined){this._navContainer=new sap.m.NavContainer(this.getId()+'-navcontainer',{pages:[]});}return this._navContainer;};h.prototype._getTitleLabel=function(){if(this._titleLabel===undefined){this._titleLabel=new sap.m.Label(this._sTitleLabelId,{text:this._rb.getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._titleLabel;};h.prototype._getResetButton=function(){var i=this;if(this._resetButton===undefined){this._resetButton=new sap.m.Button(this.getId()+"-resetbutton",{icon:I.getIconURI("clear-filter"),press:function(){i._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});}return this._resetButton;};h.prototype._getDetailTitleLabel=function(){if(this._detailTitleLabel===undefined){this._detailTitleLabel=new sap.m.Label(this.getId()+"-detailtitle",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")}).addStyleClass("sapMVSDTitle");}return this._detailTitleLabel;};h.prototype._getHeader=function(){if(this._header===undefined){this._header=new sap.m.Bar({contentMiddle:[this._getTitleLabel()]}).addStyleClass("sapMVSDBar");}return this._header;};h.prototype._getSubHeader=function(){if(this._subHeader===undefined){this._subHeader=new sap.m.Bar({contentLeft:[this._getSegmentedButton()]}).addStyleClass("sapMVSDBar");}return this._subHeader;};h.prototype._getSegmentedButton=function(){var j=this,k=this.getCustomTabs(),x=k.length,i=0;if(this._segmentedButton===undefined){this._segmentedButton=new sap.m.SegmentedButton({select:function(y){var z=y.getParameter('id');if(z===j.getId()+"-sortbutton"){j._switchToPage(0);}else if(z===j.getId()+"-groupbutton"){j._switchToPage(1);}else if(z===j.getId()+"-filterbutton"){j._switchToPage(2);}else{for(i=0;i<x;i++){var B=k[i],F=j.getId()+j._sCustomTabsButtonsIdPrefix+B.getId();if(!j._isEmptyTab(B)&&z===F){j._switchToPage(B.getId());break;}}}q.sap.log.info('press event segmented: '+y.getParameter('id'));}}).addStyleClass("sapMVSDSeg");this._segmentedButton._bPreventWidthRecalculationOnAfterRendering=true;}return this._segmentedButton;};h.prototype._getSortButton=function(){if(this._sortButton===undefined){this._sortButton=new sap.m.Button(this.getId()+"-sortbutton",{icon:I.getIconURI("sort"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});}return this._sortButton;};h.prototype._getGroupButton=function(){if(this._groupButton===undefined){this._groupButton=new sap.m.Button(this.getId()+"-groupbutton",{icon:I.getIconURI("group-2"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});}return this._groupButton;};h.prototype._getFilterButton=function(){if(this._filterButton===undefined){this._filterButton=new sap.m.Button(this.getId()+"-filterbutton",{icon:I.getIconURI("filter"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")});}return this._filterButton;};h.prototype._getPage1=function(i){if(this._page1===undefined&&!i){this._page1=new sap.m.Page(this.getId()+'-page1',{title:this._rb.getText("VIEWSETTINGS_TITLE"),customHeader:this._getHeader()});this._getNavContainer().addPage(this._page1);}return this._page1;};h.prototype._getPage2=function(){var i=this,j,B,k;if(this._page2===undefined){B=new sap.m.Button(this.getId()+"-backbutton",{icon:I.getIconURI("nav-back"),press:[this._pressBackButton,this]});k=new sap.m.Button(this.getId()+"-detailresetbutton",{icon:I.getIconURI("clear-filter"),press:function(){i._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});j=new sap.m.Bar({contentLeft:[B],contentMiddle:[this._getDetailTitleLabel()],contentRight:[k]}).addStyleClass("sapMVSDBar");this._page2=new sap.m.Page(this.getId()+'-page2',{title:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),customHeader:j});this._getNavContainer().addPage(this._page2);}return this._page2;};h.prototype._initFilterDetailItems=function(k){var x;var y=k.getMultiSelect();var z=k.getItems();var B=this;if(this._filterDetailList){this._filterDetailList.destroy();}this._getPage2().removeAllAggregation('content');this._filterDetailList=new L({mode:(y?d.MultiSelect:d.SingleSelectLeft),includeItemInSelection:true,selectionChange:function(F){var G,H=F.getParameter("listItems"),J,i=0,N;B._clearPresetFilter();if(y){this._updateSelectAllCheckBoxState();}if(H.length>1&&y){J=k.getItems();for(;i<J.length;i++){for(var j=0;j<H.length;j++){if(J[i].getKey()===H[j].getCustomData()[0].getValue().getKey()){J[i].setProperty('selected',H[j].getSelected(),true);}}}}else{G=F.getParameter("listItem").data("item");if(!k.getMultiSelect()){J=k.getItems();for(;i<J.length;i++){if(J[i].getId()!==G.getId()){J[i].setProperty('selected',false,true);}}}N=F.getParameter("listItem").getSelected();if(G.getProperty('selected')!==N){G.setProperty('selected',N,true);}}}.bind(this)});for(var i=0;i<z.length;i++){x=new b({title:M.escapeSettingsValue(z[i].getText()),type:e.Active,selected:z[i].getSelected()}).data("item",z[i]);this._filterDetailList.addItem(x);}this._filterSearchField=this._getFilterSearchField(this._filterDetailList);this._getPage2().addContent(this._filterSearchField.addStyleClass('sapMVSDFilterSearchField'));this._getPage2().getCustomHeader().addStyleClass('sapMVSDBarWithSearch');if(y){this._selectAllCheckBox=this._createSelectAllCheckbox(z,this._filterDetailList);this._filterDetailList.setHeaderToolbar(new T({content:[this._selectAllCheckBox]}).addStyleClass('sapMVSDFilterHeaderToolbar'));}this._getPage2().addContent(this._filterDetailList);};h.prototype._initSortContent=function(){var i=this;if(this._sortContent){return;}this._vContentPage=-1;this._ariaSortOrderInvisibleText=new c(this.getId()+"-sortOrderLabel",{text:this._rb.getText("VIEWSETTINGS_SORT_DIRECTION").concat(":")});this._sortOrderList=new L(this.getId()+"-sortorderlist",{mode:d.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){i.setProperty('sortDescending',j.getParameter("listItem").data("item"),true);},ariaLabelledBy:this._ariaSortOrderInvisibleText}).addStyleClass("sapMVSDUpperList");this._sortOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._sortOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaSortListInvisibleText=new c(this.getId()+"-sortListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_SORT").concat(":")});this._sortList.addAriaLabelledBy(this._ariaSortListInvisibleText);this._sortContent=[this._ariaSortOrderInvisibleText,this._sortOrderList,this._ariaSortListInvisibleText,this._sortList];};h.prototype._initGroupItems=function(){var i,H,G=this.getGroupItems();this._groupList.destroyItems();if(!!G.length){G.forEach(function(j){i=new b({id:j.getId()+g,title:M.escapeSettingsValue(j.getText()),type:e.Active,selected:j.getSelected()}).data("item",j);this._groupList.addItem(i);},this);if(!this._oGroupingNoneItem||this._oGroupingNoneItem.bIsDestroyed){H=!!this.getSelectedGroupItem();this._oGroupingNoneItem=new sap.m.ViewSettingsItem({text:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!H,itemPropertyChanged:function(){this._initGroupContent();this._initGroupItems();}.bind(this)});!H&&this.setAssociation("selectedGroupItem",this._oGroupingNoneItem,true);}i=new b({id:this._oGroupingNoneItem.getId()+g,title:this._oGroupingNoneItem.getText(),type:e.Active,selected:this._oGroupingNoneItem.getSelected()}).data("item",this._oGroupingNoneItem);this._groupList.addItem(i);}};h.prototype._initGroupContent=function(){var i=this;if(this._groupContent){return;}this._vContentPage=-1;this._ariaGroupOrderInvisibleText=new c(this.getId()+"-groupOrderLabel",{text:this._rb.getText("VIEWSETTINGS_GROUP_DIRECTION").concat(":")});this._groupOrderList=new L(this.getId()+"-grouporderlist",{mode:d.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){i.setProperty('groupDescending',j.getParameter("listItem").data("item"),true);},ariaLabelledBy:this._ariaGroupOrderInvisibleText}).addStyleClass("sapMVSDUpperList");this._groupOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._groupOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaGroupListInvisibleText=new c(this.getId()+"-groupListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_GROUP").concat(":")});this._groupList=new L(this.getId()+"-grouplist",{mode:d.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){var k=j.getParameter("listItem").data("item");i.setSelectedGroupItem(k);},ariaLabelledBy:this._ariaGroupListInvisibleText});this._groupContent=[this._ariaGroupOrderInvisibleText,this._groupOrderList,this._ariaGroupListInvisibleText,this._groupList];};h.prototype._initFilterItems=function(){var P,F,i,j=this;this._presetFilterList.destroyItems();P=this.getPresetFilterItems();if(P.length){P.forEach(function(k){i=new b({id:k.getId()+g,title:M.escapeSettingsValue(k.getText()),type:e.Active,selected:k.getSelected()}).data("item",k);this._presetFilterList.addItem(i);},this);}if(P.length){i=new b({id:this._presetFilterList.getId()+"-none"+g,title:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!!this.getSelectedPresetFilterItem()});this._presetFilterList.addItem(i);}this._filterList.destroyItems();F=this.getFilterItems();if(F.length){F.forEach(function(k){i=new b({id:k.getId()+g,title:M.escapeSettingsValue(k.getText()),type:e.Active,press:(function(k){return function(x){if(j._navContainer.getCurrentPage().getId()!==j.getId()+'-page2'){j._switchToPage(3,k);j._prevSelectedFilterItem=this;q.sap.delayedCall(0,j._navContainer,"to",[j.getId()+'-page2',"slide"]);}if(D.system.desktop&&j._filterDetailList&&j._filterDetailList.getItems()[0]){j._getNavContainer().attachEventOnce("afterNavigate",function(){j._filterDetailList.getItems()[0].focus();});}};}(k))}).data("item",k);this._filterList.addItem(i);},this);}};h.prototype._initFilterContent=function(){var i=this;if(this._filterContent){return;}this._vContentPage=-1;this._presetFilterList=new L(this.getId()+"-predefinedfilterlist",{mode:d.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){var k=j.getParameter("listItem").data("item");if(k){k.setProperty('selected',j.getParameter("listItem").getSelected(),true);}i.setAssociation("selectedPresetFilterItem",k,true);i._clearSelectedFilters();}}).addStyleClass("sapMVSDUpperList");this._filterList=new L(this.getId()+"-filterlist",{});this._filterContent=[this._presetFilterList,this._filterList];};h.prototype._initDialogContent=function(P){var i=!!this.getSortItems().length,G=!!this.getGroupItems().length,j=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length;if(i){this._initSortContent();}if(G){this._initGroupContent();this._initGroupItems();}if(j||F){this._initFilterContent();this._initFilterItems();}this._updateDialogState(P);this._updateListSelections();};h.prototype._getTabButton=function(i,B){var j=B+i.getId(),k=sap.ui.getCore().byId(j);if(k){return k;}else{return new sap.m.Button({id:j,icon:i.getIcon(),tooltip:i.getTooltip()});}};h.prototype._updateDialogState=function(P){var i=!!this.getSortItems().length,G=!!this.getGroupItems().length,j=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length,k=!!this.getCustomTabs().length,x=this._getSegmentedButton(),y=null,z=false,B={"sort":0,"group":1,"filter":2};x.removeAllButtons();if(this._filterContent){this._presetFilterList.setVisible(true);this._filterList.setVisible(true);}if(i){x.addButton(this._getSortButton());}if(j||F){x.addButton(this._getFilterButton());if(!j){this._presetFilterList.setVisible(false);this._presetFilterList.addStyleClass("sapMVSDUpperList");}if(!F){this._filterList.setVisible(false);this._presetFilterList.removeStyleClass("sapMVSDUpperList");}}if(G){x.addButton(this._getGroupButton());}if(k){this.getCustomTabs().forEach(function(J){if(!this._isEmptyTab(J)){var K=this.getId()+this._sCustomTabsButtonsIdPrefix,N=this._getTabButton(J,K);x.addButton(N);}}.bind(this));}this._showSubHeader=this._hasSubHeader();if(P===undefined&&this._vContentPage!==-1){P=this._vContentPage;switch(P){case 0:P='sort';break;case 1:P='group';break;case 2:P='filter';break;}}if(P===this._vContentPage&&this._vContentPage===3){this._vContentPage=-1;this._switchToPage(3,this._oContentItem);}else{P=this._determineValidPageId(P);for(var H in B){if(P===H){z=true;y=this.getId()+'-'+P+'button';P=B[H];break;}}if(!z){y=this.getId()+this._sCustomTabsButtonsIdPrefix+P;}this._getSegmentedButton().setSelectedButton(y);this._switchToPage(P);if(this._getNavContainer().getCurrentPage()!==this._getPage1()){this._getNavContainer().to(this._getPage1().getId());}}};h.prototype._determineValidPageId=function(P){var i='sort',H=false,j=[];j=this._fetchValidPagesIds();if(j.length){i=j[0];}else{q.sap.log.warning('No available pages to load - missing items.');}if(!P){P=i;}else{j.filter(function(k){if(k===P){H=true;return false;}return true;});if(!H){P=i;}}return P;};h.prototype._fetchValidPagesIds=function(){var i,j=this.getCustomTabs(),k=j.length,x=[];var P=['sort','filter','group'];P.forEach(function(z){if(this._isValidPredefinedPageId(z)){x.push(z);}},this);for(i=0;i<k;i++){var y=j[i];if(!this._isEmptyTab(y)){x.push(y.getId());}}return x;};h.prototype._isEmptyTab=function(i){return!(i.getContent().length||this._vContentPage===i.getId()&&this._getPage1().getContent().length);};h.prototype._isValidPredefinedPageId=function(N){if(!N){q.sap.log.warning('Missing mandatory parameter.');return false;}var H=false;switch(N){case'sort':H=!!this.getSortItems().length;break;case'filter':H=!!this.getFilterItems().length||!!this.getPresetFilterItems().length;break;case'group':H=!!this.getGroupItems().length;break;}return H;};h.prototype._pressBackButton=function(){var i=this;if(this._vContentPage===3){this._updateFilterCounters();this._getNavContainer().attachEvent("afterNavigate",function(){if(i._prevSelectedFilterItem){i._prevSelectedFilterItem.focus();}});q.sap.delayedCall(0,this._getNavContainer(),'back');this._switchToPage(2);this._segmentedButton.setSelectedButton(this._filterButton);}};h.prototype.setModel=function(i,N){if(this._vContentPage===3&&this._oContentItem){r.call(this);}return M.prototype.setModel.call(this,i,N);};h.prototype.removeFilterItem=function(F){var i="";if(this._vContentPage===3&&this._oContentItem){if(typeof(F)==="object"){i=F.getId();}else if(typeof(F)==="string"){i=F;}else if(typeof(F)==="number"){i=this.getFilterItems()[F].getId();}if(this._oContentItem.getId()===i){r.call(this);}}return this.removeAggregation('filterItems',F);};h.prototype.removeAllFilterItems=function(){if(this._vContentPage===3&&this._oContentItem){r.call(this);}return this.removeAllAggregation('filterItems');};h.prototype.setFilterSearchCallback=function(i){this._fnFilterSearchCallback=i;return this;};h.prototype._switchToPage=function(W,j){var i=0,k=this._getTitleLabel(),R=this._getResetButton(),H=this._getHeader(),x=this._getSubHeader();if(this._vContentPage===W&&W!==3){if(H.getContentRight().length===0&&x.getContentRight().length===0){this._addResetButtonToPage1();}return false;}this._getPage2().getCustomHeader().removeStyleClass('sapMVSDBarWithSearch');if(p.call(this)){o.call(this);}H.removeAllContentRight();x.removeAllContentRight();this._vContentPage=W;this._oContentItem=j;if(W!==3){this._getPage1().removeAllAggregation("content",true);this._addResetButtonToPage1();}else if(W===3){this._getPage2().removeAllAggregation("content",true);}if(this.getTitle()){k.setText(this.getTitle());}else{k.setText(this._rb.getText("VIEWSETTINGS_TITLE"));}switch(W){case 1:R.setVisible(false);if(!this._showSubHeader&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_GROUP"));}for(;i<this._groupContent.length;i++){this._getPage1().addContent(this._groupContent[i]);}break;case 2:R.setVisible(!!this.getFilterItems().length);if(!this._showSubHeader&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTER"));}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();for(;i<this._filterContent.length;i++){this._getPage1().addContent(this._filterContent[i]);}break;case 3:this._setFilterDetailTitle(j);if(j instanceof sap.m.ViewSettingsCustomItem&&j.getCustomControl()){this._clearPresetFilter();this._getPage2().addContent(j.getCustomControl());}else if(j instanceof sap.m.ViewSettingsFilterItem&&j.getItems()){this._initFilterDetailItems(j);}break;case 0:R.setVisible(false);if(!this._getPage1().getSubHeader()&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_SORT"));}if(this._sortContent){for(;i<this._sortContent.length;i++){this._getPage1().addContent(this._sortContent[i]);}}break;default:R.setVisible(false);this._getPage1().removeAllAggregation("content",true);var y="VIEWSETTINGS_TITLE";var z=this.getCustomTabs();if(z.length<2){y=z[0].getTitle();}if(!this._getPage1().getSubHeader()&&!this.getTitle()){k.setText(y);}z.forEach(function(B){if(B.getId()===W){B.getContent().forEach(function(F){this._getPage1().addContent(F);},this);}},this);break;}if(W===3){this.fireFilterDetailPageOpened({parentFilterItem:j});}};h.prototype._createSelectAllCheckbox=function(F,i){var j=false;if(F&&F.length!==0){j=F.every(function(x){return x.getSelected();});}var k=new a({text:this._rb.getText("COLUMNSPANEL_SELECT_ALL"),selected:j,select:function(x){var y=x.getParameter('selected');i.getItems().filter(function(z){return z.getVisible();}).forEach(function(z){var B=z.data("item");B.setSelected(y);});}});return k;};h.prototype._updateSelectAllCheckBoxState=function(){var i=false,j=this._filterDetailList.getItems(),k=[];if(!this._selectAllCheckBox){return;}if(j&&j.length!==0){k=j.filter(function(x){return x.getVisible();});}if(k.length!==0){i=k.every(function(x){return x.getSelected();});}this._selectAllCheckBox.setSelected(i);};h.prototype._getFilterSearchField=function(F){var i=this,j=new S({liveChange:function(k){var Q=k.getParameter('newValue'),x=i._getStringFilter();F.getItems().forEach(function(y){var z=x(Q,y.getTitle());y.setVisible(z);});i._updateSelectAllCheckBoxState();}});return j;};h.prototype._getStringFilter=function(){if(this._fnFilterSearchCallback){return this._fnFilterSearchCallback;}if(!this._oStringFilter||this._oStringFilter.sOperator!==this.getFilterSearchOperator()){this._oStringFilter=new s(this.getFilterSearchOperator());}return this._oStringFilter.filter.bind(this._oStringFilter);};h.prototype._updateListSelections=function(){this._updateListSelection(this._sortList,sap.ui.getCore().byId(this.getSelectedSortItem()));this._updateListSelection(this._sortOrderList,this.getSortDescending());this._updateListSelection(this._groupList,sap.ui.getCore().byId(this.getSelectedGroupItem()));this._updateListSelection(this._groupOrderList,this.getGroupDescending());this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();};h.prototype._updateListSelection=function(j,k){var x,i=0;if(!j){return false;}x=j.getItems();j.removeSelections();for(;i<x.length;i++){if(x[i].data("item")===k||x[i].data("item")===null){j.setSelectedItem(x[i],(k&&k.getSelected?k.getSelected():true));return true;}}return false;};h.prototype._updateFilterCounters=function(){var k=(this._filterList?this._filterList.getItems():[]),x,y,F=0,i=0,j;for(;i<k.length;i++){x=k[i].data("item");F=0;if(x){if(x instanceof sap.m.ViewSettingsCustomItem){F=x.getFilterCount();}else if(x instanceof sap.m.ViewSettingsFilterItem){F=0;y=x.getItems();for(j=0;j<y.length;j++){if(y[j].getSelected()){F++;}}}}k[i].setCounter(F);}};h.prototype._clearSelectedFilters=function(){var k=this.getFilterItems(),x,i=0,j;for(;i<k.length;i++){if(k[i]instanceof sap.m.ViewSettingsFilterItem){x=k[i].getItems();for(j=0;j<x.length;j++){x[j].setProperty('selected',false,true);}}k[i].setProperty('selected',false,true);}if(this._vContentPage===2&&this._getDialog().isOpen()){this._updateFilterCounters();}};h.prototype._clearPresetFilter=function(){if(this.getSelectedPresetFilterItem()){this.setSelectedPresetFilterItem(null);}};h.prototype._calculateNumberOfPages=function(){var i=0,j=!!this.getSortItems().length,G=!!this.getGroupItems().length,P=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length;if(j){i++;}if(P||F){i++;}if(G){i++;}this.getCustomTabs().forEach(function(k){if(!this._isEmptyTab(k)){i++;}},this);return i;};h.prototype._hasSubHeader=function(){return!(this._calculateNumberOfPages()<2);};function r(){this._vContentPage=2;this._oContentItem=null;this._navContainer.to(this._getPage1().getId(),"show");}function m(j,k){var i,x;for(i=0;i<j.length;i++){if(j[i].getKey()===k){x=j[i];break;}}return x;}function n(i,j,k){var x;if(typeof i==="string"){x=m(j,i);if(!x){q.sap.log.error(k);}}else{x=i;}return x;}function v(i){return i&&i instanceof sap.m.ViewSettingsItem;}h.prototype._onConfirm=function(i){var j=this._getDialog(),k=this,x=function(){var y,G,z=k.getSelectedGroupItem();if(!k._oGroupingNoneItem||z!=k._oGroupingNoneItem.getId()){G=sap.ui.getCore().byId(z);}y={sortItem:sap.ui.getCore().byId(k.getSelectedSortItem()),sortDescending:k.getSortDescending(),groupItem:G,groupDescending:k.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(k.getSelectedPresetFilterItem()),filterItems:k.getSelectedFilterItems(),filterKeys:k.getSelectedFilterKeys(),filterCompoundKeys:k.getSelectedFilterCompoundKeys(),filterString:k.getSelectedFilterString()};k._dialog.detachAfterClose(x);k.fireConfirm(y);};j.attachAfterClose(x);j.close();};h.prototype._onCancel=function(i){var j=this,k=this._getDialog(),x=function(){j.setSelectedSortItem(j._oPreviousState.sortItem);j.setSortDescending(j._oPreviousState.sortDescending);j.setSelectedGroupItem(j._oPreviousState.groupItem);j.setGroupDescending(j._oPreviousState.groupDescending);j.setSelectedPresetFilterItem(j._oPreviousState.presetFilterItem);j._clearSelectedFilters();j.setSelectedFilterCompoundKeys(j._oPreviousState.filterCompoundKeys);if(j._navContainer.getCurrentPage()!==j._oPreviousState.navPage){q.sap.delayedCall(0,j._navContainer,"to",[j._oPreviousState.navPage.getId(),"show"]);}j._switchToPage(j._oPreviousState.contentPage,j._oPreviousState.contentItem);j._dialog.detachAfterClose(x);j.fireCancel();};k.attachAfterClose(x);k.close();};h.prototype._onClearFilters=function(){this._clearSelectedFilters();this._clearPresetFilter();this.fireResetFilters();this._updateFilterCounters();if(this._vContentPage===3){q.sap.delayedCall(0,this._getNavContainer(),'to',[this._getPage1().getId()]);this._switchToPage(2);this._getSegmentedButton().setSelectedButton(this._getFilterButton());}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));};h.prototype._addResetButtonToPage1=function(){var H=this._getHeader(),i=this._getSubHeader(),R=this._getResetButton();if(this._showSubHeader){if(!this._getPage1().getSubHeader()){this._getPage1().setSubHeader(i);}i.addContentRight(R);}else{if(this._getPage1().getSubHeader()){this._getPage1().setSubHeader();}H.addContentRight(R);}};h.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};function o(i,j){if(!this._getPage1(true)){return;}if(i==='customTabs'&&j){if(j.getMetadata().getName()===this.getMetadata().getManagedAggregation(i).type&&this._vContentPage===j.getId()){var P=this._getPage1().getContent();P.forEach(function(k){j.addAggregation('content',k,true);});}}else if(!i&&!j){var P=this._getPage1().getContent();this.getCustomTabs().forEach(function(j){if(this._vContentPage===j.getId()){P.forEach(function(k){j.addAggregation('content',k,true);});}},this);}}function p(){var P=[-1,0,1,2,3];return(this._getPage1().getContent().length&&P.indexOf(this._vContentPage)===-1);}h.prototype.setBusy=function(B){this._getDialog().setBusy(B);return this;};var s=function(O){this.sOperator=O||f.StartsWith;switch(this.sOperator){case f.Equals:this.fnOperator=t;break;case f.Contains:this.fnOperator=u;break;case f.StartsWith:this.fnOperator=w;break;case f.AnyWordStartsWith:this.fnOperator=A;break;default:q.sap.log.warning("Unknown string compare operator. Use values from sap.m.StringFilterOperator. Default operator should be used.");this.fnOperator=u;break;}};s.prototype.filter=function(Q,i){if(!Q){return true;}if(!i){return false;}i=i.toLowerCase();Q=Q.toLowerCase();return this.fnOperator(Q,i);};function t(Q,i){return i===Q;}function u(Q,i){return i.indexOf(Q)>-1;}function w(Q,i){return i.indexOf(Q)===0;}function A(Q,i){var j=new RegExp(".*\\b"+Q+".*");return j.test(i);}return h;});
