/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/delegate/ScrollEnablement","./WizardProgressNavigator","./Button","sap/ui/Device","./WizardRenderer"],function(q,l,C,S,W,B,D,a){"use strict";var b=l.ButtonType;var c=C.extend("sap.m.Wizard",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Wizard.designtime",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},showNextButton:{type:"boolean",group:"Behavior",defaultValue:true},finishButtonText:{type:"string",group:"Appearance",defaultValue:"Review"},enableBranching:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"steps",aggregations:{steps:{type:"sap.m.WizardStep",multiple:true,singularName:"step"},_progressNavigator:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{
/**
					 * This association controls the current activated step of the wizard (meaning the last step)
					 * For example if we have A->B->C->D steps, we are on step A and we setCurrentStep(C) A,B and C are going to be activated. D will still remain unvisited.
					 * The parameter needs to be a Wizard step that is part of the current Wizard
					 * @since 1.50
					 */
currentStep:{type:"sap.m.WizardStep",multiple:false}},events:{stepActivate:{parameters:{index:{type:"int"}}},complete:{parameters:{}}}}});c.CONSTANTS={MINIMUM_STEPS:3,MAXIMUM_STEPS:8,ANIMATION_TIME:300,SCROLL_OFFSET:16};c.prototype.init=function(){this._stepCount=0;this._stepPath=[];this._scrollLocked=false;this._scroller=this._initScrollEnablement();this._resourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._initProgressNavigator();};c.prototype.onBeforeRendering=function(){if(!this._isMinStepCountReached()||this._isMaxStepCountExceeded()){q.sap.log.error("The Wizard is supposed to handle from 3 to 8 steps.");}this._initNextButton();this._saveInitialValidatedState();var s=this._getStartingStep();if(s&&this._stepPath.indexOf(s)<0){this._activateStep(s);this._updateProgressNavigator();this._setNextButtonPosition();}};c.prototype.onAfterRendering=function(){if(!this.getCurrentStep()){this.setAssociation("currentStep",this.getSteps()[0],true);}var s=sap.ui.getCore().byId(this.getCurrentStep());this._activateAllPreceedingSteps(s);this._attachScrollHandler();};c.prototype.exit=function(){var d=this.getDomRef("step-container");if(d){d.onscroll=null;}this._scroller.destroy();this._scroller=null;this._stepPath=null;this._stepCount=null;this._scrollLocked=null;this._resourceBundle=null;};c.prototype.validateStep=function(s){if(!this._containsStep(s)){q.sap.log.error("The wizard does not contain this step");return this;}s.setProperty("validated",true,true);this._updateNextButtonState();return this;};c.prototype.invalidateStep=function(s){if(!this._containsStep(s)){q.sap.log.error("The wizard does not contain this step");return this;}s.setProperty("validated",false,true);this._updateNextButtonState();return this;};c.prototype.nextStep=function(){var d=this._getProgressNavigator().getProgress()-1;var e=this._stepPath[d];this.validateStep(e);this._handleNextButtonPress();return this;};c.prototype.previousStep=function(){var p=this._getProgressNavigator().getProgress()-2;if(p>=0){this.discardProgress(this._stepPath[p]);}return this;};c.prototype.getProgress=function(){return this._getProgressNavigator().getProgress();};c.prototype.getProgressStep=function(){return this._stepPath[this.getProgress()-1];};c.prototype.goToStep=function(s,f){if(!this.getVisible()||this._stepPath.indexOf(s)<0){return this;}var t=this,d={scrollTop:this._getStepScrollOffset(s)},e={queue:false,duration:c.CONSTANTS.ANIMATION_TIME,start:function(){t._scrollLocked=true;},complete:function(){t._scrollLocked=false;var p=t._getProgressNavigator();if(!p){return;}p._updateCurrentStep(t._stepPath.indexOf(s)+1,undefined,true);if(f||f===undefined){t._focusFirstStepElement(s);}}};q(this.getDomRef("step-container")).animate(d,e);return this;};c.prototype.discardProgress=function(s){var p=this.getProgress(),d=this._stepPath,e=this._stepPath.indexOf(s),f=e+1;if(f>p||f<=0){q.sap.log.warning("The given step is either not yet reached, or is not present in the wizard control.");return this;}this._getProgressNavigator().discardProgress(f,true);this._updateNextButtonState();this._setNextButtonPosition();this._restoreInitialValidatedState(f);this._stepPath[e]._markAsLast();for(var i=f;i<d.length;i++){d[i]._deactivate();if(d[i].getSubsequentSteps().length>1){d[i].setNextStep(null);}}if(s.getSubsequentSteps().length>1){s.setNextStep(null);}d.splice(f);this._updateProgressNavigator();this.setAssociation("currentStep",s);return this;};c.prototype.setCurrentStep=function(s){this.setAssociation("currentStep",s,true);var d=(typeof s==="string")?sap.ui.getCore().byId(s):s;if(d&&this._isStepReachable(d)){this._activateAllPreceedingSteps(d);}return this;};c.prototype.setShowNextButton=function(v){this.setProperty("showNextButton",v,true);if(this._getNextButton()){this._getNextButton().setVisible(v);}return this;};c.prototype.setFinishButtonText=function(v){this.setProperty("finishButtonText",v,true);this._updateNextButtonState();return this;};c.prototype.getFinishButtonText=function(){if(this.getProperty("finishButtonText")==="Review"){return this._resourceBundle.getText("WIZARD_FINISH");}else{return this.getProperty("finishButtonText");}};c.prototype.addStep=function(w){if(this._isMaxStepCountExceeded()){q.sap.log.error("The Wizard is supposed to handle up to 8 steps.");return this;}this._incrementStepCount();return this.addAggregation("steps",w);};c.prototype.insertStep=function(w,i){throw new Error("Dynamic step insertion is not yet supported.");};c.prototype.removeStep=function(w){throw new Error("Dynamic step removal is not yet supported.");};c.prototype.removeAllSteps=function(){this._resetStepCount();return this.removeAllAggregation("steps");};c.prototype.destroySteps=function(){this._resetStepCount();this._getProgressNavigator().setStepCount(this._getStepCount());return this.destroyAggregation("steps");};c.prototype._activateAllPreceedingSteps=function(s){if(this._stepPath.indexOf(s)>=0){this.discardProgress(s);return;}while(this.getProgressStep()!==s){this.nextStep();}};c.prototype._isNextStepDetermined=function(){if(!this.getEnableBranching()){return true;}var d=sap.ui.getCore().byId(this.getCurrentStep());return d._getNextStepReference()!==null;};c.prototype._isStepReachable=function(s){if(this.getEnableBranching()){var d=this._getStartingStep();while(d!==s){d=d._getNextStepReference();if(d==null){return false;}}return true;}else{return this.getSteps().indexOf(s)>=0;}};c.prototype._initScrollEnablement=function(){return new S(this,null,{scrollContainerId:this.getId()+"-step-container",horizontal:false,vertical:true});};c.prototype._initProgressNavigator=function(){var t=this,p=new W(this.getId()+"-progressNavigator",{stepChanged:this._handleStepChanged.bind(this)});p._setOnEnter(function(e,s){var d=t._stepPath[s];q.sap.delayedCall(c.CONSTANTS.ANIMATION_TIME,t,function(){this._focusFirstStepElement(d);});});this.setAggregation("_progressNavigator",p);};c.prototype._initNextButton=function(){if(this._getNextButton()){return;}this.setAggregation("_nextButton",this._createNextButton());this._setNextButtonPosition();};c.prototype._createNextButton=function(){var f=this._getStartingStep(),i=(f)?f.getValidated():true,n=new B(this.getId()+"-nextButton",{text:this._resourceBundle.getText("WIZARD_STEP")+" "+2,type:b.Emphasized,enabled:i,press:this._handleNextButtonPress.bind(this),visible:this.getShowNextButton()});n.addStyleClass("sapMWizardNextButton");n.addEventDelegate({onAfterRendering:this._toggleNextButtonVisibility},this);this._nextButton=n;return n;};c.prototype._handleNextButtonPress=function(){var p=this._getProgressNavigator(),d=this._stepPath[this._stepPath.length-1],e=p.getProgress(),s=p.getStepCount(),i=this.getEnableBranching()?d._isLeaf():e===s;if(i){this.fireComplete();}else{var f=this.getProgressStep();f._complete();if(!this._isNextStepDetermined()){throw new Error("The wizard is in branching mode, and the nextStep association is not set.");}if(e===s){p.setStepCount(s+1);p.rerender();}p.incrementProgress();this._handleStepActivated(p.getProgress());this._handleStepChanged(p.getProgress());this.setAssociation("currentStep",this._stepPath[this._stepPath.length-1],true);}this._updateNextButtonState();};c.prototype._toggleNextButtonVisibility=function(){q.sap.delayedCall(0,this,function(){if(this._getNextButton().getEnabled()){this._getNextButton().addStyleClass("sapMWizardNextButtonVisible");}else{this._getNextButton().removeStyleClass("sapMWizardNextButtonVisible");}});};c.prototype._getStepScrollOffset=function(s){var d=s.$().position().top,e=this._scroller.getScrollTop(),p=this._stepPath[this.getProgress()-1],f=0;if(!D.system.phone&&!q.sap.containsOrEquals(p.getDomRef(),this._nextButton.getDomRef())){f=this._nextButton.$().outerHeight();}return(e+d)-(c.CONSTANTS.SCROLL_OFFSET+f);};c.prototype._focusFirstStepElement=function(s){var $=s.$();if($.firstFocusableDomRef()){$.firstFocusableDomRef().focus();}};c.prototype._handleStepChanged=function(e){var p=((typeof e==="number")?e:e.getParameter("current"))-2;var d=this._stepPath[p];var s=this._getNextStep(d,p);var f=D.system.desktop?true:false;this.goToStep(s,f);};c.prototype._handleStepActivated=function(i){var p=i-2,d=this._stepPath[p];var n=this._getNextStep(d,p);this._activateStep(n);this._updateProgressNavigator();this.fireStepActivate({index:i});this._setNextButtonPosition();};c.prototype._isMaxStepCountExceeded=function(){if(this.getEnableBranching()){return false;}var s=this._getStepCount();return s>=c.CONSTANTS.MAXIMUM_STEPS;};c.prototype._isMinStepCountReached=function(){var s=this._getStepCount();return s>=c.CONSTANTS.MINIMUM_STEPS;};c.prototype._getStepCount=function(){return this._stepCount;};c.prototype._incrementStepCount=function(){this._stepCount+=1;this._getProgressNavigator().setStepCount(this._getStepCount());};c.prototype._decrementStepCount=function(){this._stepCount-=1;this._getProgressNavigator().setStepCount(this._getStepCount());};c.prototype._resetStepCount=function(){this._stepCount=0;this._getProgressNavigator().setStepCount(this._getStepCount());};c.prototype._getProgressNavigator=function(){return this.getAggregation("_progressNavigator");};c.prototype._saveInitialValidatedState=function(){if(this._initialValidatedState){return;}this._initialValidatedState=this.getSteps().map(function(s){return s.getValidated();});};c.prototype._restoreInitialValidatedState=function(d){var s=this._stepPath,e=this.getSteps();for(var i=d;i<s.length;i++){var f=s[i];var g=e.indexOf(f);var h=this._initialValidatedState[g];f.setValidated(h);}};c.prototype._getNextStep=function(s,p){if(!this.getEnableBranching()){return this.getSteps()[p+1];}if(p<0){return this._getStartingStep();}var n=s._getNextStepReference();if(n===null){throw new Error("The wizard is in branching mode, and no next step is defined for "+"the current step, please set one.");}if(!this._containsStep(n)){throw new Error("The next step that you have defined is not part of the wizard steps aggregation."+"Please add it to the wizard control.");}var d=s.getSubsequentSteps();if(d.length>0&&!s._containsSubsequentStep(n.getId())){throw new Error("The next step that you have defined is not contained inside the subsequentSteps"+" association of the current step.");}return n;};c.prototype._setNextButtonPosition=function(){if(D.system.phone){return;}var d=this._getNextButton(),p=this._getProgressNavigator().getProgress(),e=this._stepPath[p-2],f=sap.ui.getCore().getConfiguration(),g=this._stepPath[p-1];if(g){g.addContent(d);if(!f.getAnimation()&&e){e.rerender();}}};c.prototype._updateNextButtonState=function(){if(!this._getNextButton()){return;}var i,s=this._getStepCount(),n=this._getNextButton(),p=this.getProgress(),d=this._stepPath[p-1].getValidated();if(this.getEnableBranching()){i=this._stepPath[p-1]._isLeaf();}else{i=p===s;}n.setEnabled(d);if(i){n.setText(this.getFinishButtonText());}else{n.setText(this._resourceBundle.getText("WIZARD_STEP")+" "+(p+1));}};c.prototype._getNextButton=function(){return this._nextButton;};c.prototype._updateProgressNavigator=function(){var p=this._getProgressNavigator(),d=this._getStartingStep(),e=this.getSteps(),s=[d.getTitle()],f=[d.getIcon()],g=[],h=1;if(this.getEnableBranching()){while(!d._isLeaf()&&d._getNextStepReference()!==null){h++;d=d._getNextStepReference();s.push(d.getTitle());g.push(d.getOptional());f.push(d.getIcon());}p.setVaryingStepCount(d._isBranched());p.setStepCount(h);}else{s=e.map(function(i){return i.getTitle();});g=e.map(function(i){return i.getOptional();});f=e.map(function(i){return i.getIcon();});}p.setStepTitles(s);p._stepOptionalIndication=g;p.setStepIcons(f);};c.prototype._getStartingStep=function(){return this.getSteps()[0];};c.prototype._attachScrollHandler=function(){var d=this.getDomRef("step-container");d.onscroll=this._scrollHandler.bind(this);};c.prototype._scrollHandler=function(e){if(this._scrollLocked){return;}var s=e.target.scrollTop,p=this._getProgressNavigator(),d=this._stepPath[p.getCurrentStep()-1].getDomRef();if(!d){return;}var f=d.clientHeight,g=d.offsetTop,h=100;if(s+h>=g+f&&p._isActiveStep(p._currentStep+1)){p.nextStep();}if(s+h<=g){p.previousStep();}};c.prototype._containsStep=function(s){return this.getSteps().some(function(o){return o===s;});};c.prototype._checkCircularReference=function(s){if(this._stepPath.indexOf(s)>=0){throw new Error("The step that you are trying to activate has already been visited. You are creating "+"a loop inside the wizard.");}};c.prototype._activateStep=function(s){this._checkCircularReference(s);this._stepPath.push(s);s._activate();};return c;});
