/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/core/delegate/ItemNavigation',"./CarouselRenderer"],function(q,a,C,R,I,b){"use strict";var c=C.extend("sap.ui.commons.Carousel",{metadata:{library:"sap.ui.commons",properties:{orientation:{type:"sap.ui.commons.enums.Orientation",group:"Misc",defaultValue:sap.ui.commons.enums.Orientation.horizontal},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},defaultItemHeight:{type:"int",group:"Misc",defaultValue:150},defaultItemWidth:{type:"int",group:"Misc",defaultValue:150},animationDuration:{type:"int",group:"Misc",defaultValue:500},visibleItems:{type:"int",group:"Misc",defaultValue:null},handleSize:{type:"int",group:"Misc",defaultValue:22},firstVisibleIndex:{type:"int",group:"Appearance",defaultValue:0}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});c.prototype.init=function(){this._visibleItems=0;this.data("sap-ui-fastnavgroup","true",true);};c.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}this._destroyItemNavigation();};c.prototype.onclick=function(e){var s=this.getId();switch(e.target){case q.sap.byId(s+'-prevbutton')[0]:this.showPrevious();break;case q.sap.byId(s+'-nextbutton')[0]:this.showNext();break;default:return;}};c.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};c.prototype.onAfterRendering=function(){if(this.getOrientation()=="vertical"){this._sAnimationAttribute='margin-top';}else{if(sap.ui.getCore().getConfiguration().getRTL()){this._sAnimationAttribute='margin-right';}else{this._sAnimationAttribute='margin-left';}}this.showElementWithId(this._getItemIdByIndex(this.getFirstVisibleIndex()));this.calculateAndSetSize();this.oDomRef=this.getDomRef();this.sResizeListenerId=R.register(this.oDomRef,q.proxy(this.onresize,this));this._initItemNavigation();};c.prototype._initItemNavigation=function(){var $=this.$("scrolllist");if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.AfterFocus,function(e){var d=this.$("contentarea"),s=this.$("scrolllist");var o=e.getParameter("event");if(o&&o.type=="mousedown"){var f=false;for(var i=0;i<s.children().length;i++){var g=s.children()[i];if(o.target.id==g.id){f=true;break;}}if(!f){o.target.focus();}}if(sap.ui.getCore().getConfiguration().getRTL()){d.scrollLeft(s.width()-d.width());}else{d.scrollLeft(0);}},this);}this._oItemNavigation.setRootDomRef($[0]);this._oItemNavigation.setItemDomRefs($.children());};c.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this._oItemNavigation.destroy();this._oItemNavigation=undefined;}};c.prototype.onThemeChanged=function(e){this.calculateAndSetSize();};c.prototype.onfocusin=function(e){var $=q(e.target);if(!this._bIgnoreFocusIn&&($.hasClass("sapUiCrslBefore")||$.hasClass("sapUiCrslAfter"))){this._leaveActionMode();q(this._oItemNavigation.getFocusedDomRef()||this._oItemNavigation.getRootDomRef()).focus();}};c.prototype.onsaptabnext=function(e){var $=this.$();if(this._bActionMode){if($.find(".sapUiCrslScl").lastFocusableDomRef()===e.target){$.find(".sapUiCrslScl").firstFocusableDomRef().focus();e.preventDefault();e.stopPropagation();}}else{if(this._oItemNavigation.getFocusedDomRef()===e.target){this._bIgnoreFocusIn=true;$.find(".sapUiCrslAfter").focus();this._bIgnoreFocusIn=false;}}};c.prototype.onsaptabprevious=function(e){var $=this.$();if(this._bActionMode){if($.find(".sapUiCrslScl").firstFocusableDomRef()===e.target){$.find(".sapUiCrslScl").lastFocusableDomRef().focus();e.preventDefault();e.stopPropagation();}}else{if(this._oItemNavigation.getFocusedDomRef()===e.target&&q.sap.containsOrEquals($.find(".sapUiCrslScl").get(0),e.target)){this._bIgnoreFocusIn=true;$.find(".sapUiCrslBefore").focus();this._bIgnoreFocusIn=false;}}};c.prototype.onsapescape=function(e){this._leaveActionMode(e);};c.prototype.onsapnext=function(e){var $=q(e.target);var s=this.$("scrolllist");s.stop(true,true);if($.hasClass('sapUiCrslItm')&&$.nextAll(':visible').length<2){this.showNext();e.preventDefault();}};c.prototype.onsapprevious=function(e){var $=q(e.target);var s=this.$("scrolllist");s.stop(true,true);if($.hasClass('sapUiCrslItm')&&$.prevAll(':visible').length<2){this.showPrevious();e.preventDefault();}};c.prototype.onkeydown=function(e){var $=this.$();if(!this._bActionMode&&e.keyCode==q.sap.KeyCodes.F2||e.keyCode==q.sap.KeyCodes.ENTER){if($.find(".sapUiCrslScl li:focus").length>0){this._enterActionMode($.find(".sapUiCrslScl li:focus :sapFocusable").get(0));e.preventDefault();e.stopPropagation();}}else if(this._bActionMode&&e.keyCode==q.sap.KeyCodes.F2){this._leaveActionMode(e);}};c.prototype.onmouseup=function(e){if(this.$().find(".sapUiCrslScl li :focus").length>0){this._enterActionMode(this.$().find(".sapUiCrslScl li :focus").get(0));}else{this._leaveActionMode(e);}};if(sap.ui.Device.support.touch){c.prototype.onswipeleft=function(e){this.showNext();};c.prototype.onswiperight=function(e){this.showPrevious();};}c.prototype._enterActionMode=function(d){if(d&&!this._bActionMode){this._bActionMode=true;this.removeDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","-1");this.$("scrolllist").attr("aria-activedescendant",q(this._oItemNavigation.getFocusedDomRef()).attr("id"));q(d).focus();}};c.prototype._leaveActionMode=function(e){if(this._bActionMode){this._bActionMode=false;this.addDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","0");this.$("scrolllist").removeAttr("aria-activedescendant");if(e){if(q(e.target).closest("li[tabindex=-1]").length>0){var i=q(this._oItemNavigation.aItemDomRefs).index(q(e.target).closest("li[tabindex=-1]").get(0));this._oItemNavigation.focusItem(i,null);}else{if(q.sap.containsOrEquals(this.$().find(".sapUiCrslScl").get(0),e.target)){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}}else{this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}};c.prototype.onresize=function(e){if(!this.getDomRef()){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}return;}this.calculateAndSetSize();};c.prototype.showPrevious=function(){var t=this,A={},s=this.$("scrolllist");var $,d;A[this._sAnimationAttribute]=0;if(s.children('li').length<2){return;}s.stop(true,true);s.css(this._sAnimationAttribute,-this._iMaxWidth);$=s.children('li:last');d=s.children('li:first');this._showAllItems();$.insertBefore(d);s.append($.sapExtendedClone(true));s.animate(A,this.getAnimationDuration(),function(){s.children('li:last').remove();t.setProperty("firstVisibleIndex",t._getContentIndex(s.children('li:first').attr('id')),true);t._hideInvisibleItems();});};c.prototype.showNext=function(){var t=this,A={},s=this._sAnimationAttribute,S=this.$("scrolllist");var $;A[this._sAnimationAttribute]=-this._iMaxWidth;if(S.children('li').length<2){return;}S.stop(true,true);this._showAllItems();$=S.children('li:first');$.appendTo(S);$.sapExtendedClone(true).insertBefore(S.children('li:first'));S.animate(A,this.getAnimationDuration(),function(){S.children('li:first').remove();q(this).css(s,'0px');t.setProperty("firstVisibleIndex",t._getContentIndex(S.children('li:first').attr('id')),true);t._hideInvisibleItems();});};c.prototype.showElementWithId=function(e){this._showAllItems();var s=this.$("scrolllist"),i;e=this.getId()+"-item-"+e;i=s.children('li').index(q.sap.byId(e));s.children('li:lt('+i+')').appendTo(s);this._hideInvisibleItems();};c.prototype.calculateAndSetSize=function(){var s=this.getId();var d=this._getDimensions();var m=d.maxWidth;var e=d.maxHeight;var f;var v=this.getVisibleItems();var M=q.sap.byId(s);var n=q.sap.byId(s+'-nextbutton');var p=q.sap.byId(s+'-prevbutton');var $=q.sap.byId(s+'-contentarea');this._showAllItems();if(this.getContent().length<=0){return;}if(this.getWidth()&&this.getOrientation()=="vertical"){m=M.width();}if(this.getHeight()&&this.getOrientation()=="horizontal"){e=M.height();}this.$().addClass('sapUiCrsl'+q.sap.charToUpperCase(this.getOrientation(),0));if(this.getOrientation()=="horizontal"){f=M.width()-this.getHandleSize()*2-1;$.css('left',this.getHandleSize()+"px").css('right',this.getHandleSize()+"px");if(v==0){v=Math.floor(f/m);}m=f/v;this._iMaxWidth=m;var g=e+"px";$.find('.sapUiCrslItm').css("width",m+"px").css("height",e+"px").css("display","inline-block");p.css("height",e).css("line-height",g);n.css("height",e).css("line-height",g);$.height(e);M.height(e);var V=this.getContent().length<v?this.getContent().length:v;if(this.getWidth()){M.width(this.getWidth());}else{var D=M.width()-(m*V+(this.getHandleSize()*2-1));if(D>5){M.width(m*V+(this.getHandleSize()*2-1));}}}else{f=M.height()-this.getHandleSize()*2-1;$.css('top',this.getHandleSize()+"px").css('bottom',this.getHandleSize()+"px");if(v==0){v=Math.floor(f/e);}e=f/v;this._iMaxWidth=e;$.find('.sapUiCrslItm').css("width",m+"px").css("height",e+"px").css("display","block");p.width(m).after($);n.width(m);$.width(m);M.width(m);}this._visibleItems=v;this._hideInvisibleItems();};c.prototype._getDimensions=function(){var d=this.getContent();var m=0;var f=0;for(var i=0;i<d.length;i++){var g,h;try{g=d[i].getWidth();if(g.substr(-1)=="%"){g=this.getDefaultItemWidth();}}catch(e){g=this.getDefaultItemWidth();}try{h=d[i].getHeight();if(h.substr(-1)=="%"){h=this.getDefaultItemHeight();}}catch(e){h=this.getDefaultItemHeight();}m=Math.max(m,parseInt(g,10));f=Math.max(f,parseInt(h,10));}if(m==0||isNaN(m)){m=this.getDefaultItemWidth();}if(f==0||isNaN(f)){f=this.getDefaultItemHeight();}return{maxWidth:m,maxHeight:f};};c.prototype.getFocusDomRef=function(){return this.$("scrolllist");};c.prototype._showAllItems=function(){var $=this.$("contentarea");$.find('.sapUiCrslItm').show().css("display","inline-block");};c.prototype._hideInvisibleItems=function(){var $=this.$("contentarea");$.find('.sapUiCrslItm:gt('+(this._visibleItems-1)+')').hide();};c.prototype._getContentIndex=function(i){var d=i.split("-item-");return q.inArray(sap.ui.getCore().byId(d[1]),this.getContent());};c.prototype._getItemIdByIndex=function(i){var o=this.getContent()[i];if(!o){return null;}return o.getId();};c.prototype.setFirstVisibleIndex=function(f){if(f>this.getContent().length-1){q.sap.log.warning("The index is invalid. There are less items available in the carousel.");return this;}this.setProperty("firstVisibleIndex",f,true);this.showElementWithId(this._getItemIdByIndex(f));if(this._oItemNavigation){this._oItemNavigation.focusItem(f);}return this;};
//Licensed under the terms of the MIT source code license
(function(o){q.fn.sapExtendedClone=function(){var r=o.apply(this,arguments);var m=this.find('textarea').add(this.filter('textarea'));var d=r.find('textarea').add(r.filter('textarea'));var e=this.find('select').add(this.filter('select'));var f=r.find('select').add(r.filter('select'));for(var i=0,l=m.length;i<l;++i){q(d[i]).val(q(m[i]).val());}for(var i=0,l=e.length;i<l;++i){f[i].selectedIndex=e[i].selectedIndex;}return r;};})(q.fn.clone);return c;},true);
