/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObjectMetadata','sap/ui/core/Manifest','sap/ui/thirdparty/URI','jquery.sap.resources'],function(q,M,b,U){"use strict";var c=window["sap-ui-config"]||{};var s=0;if(c['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(window.location.search)){s=1;}if(c['xx-nosync']===true||c['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(window.location.search)){s=2;}var C=function(a,o){M.apply(this,arguments);};C.prototype=Object.create(M.prototype);C.preprocessClassInfo=function(o){if(o&&typeof o.metadata==="string"){o.metadata={_src:o.metadata};}return o;};C.prototype.applySettings=function(o){var S=this._oStaticInfo=o.metadata;var n=this.getName(),p=n.replace(/\.\w+?$/,"");if(S._src){if(S._src=="component.json"){q.sap.log.warning("Usage of declaration \"metadata: 'component.json'\" is deprecated (component "+n+"). Use \"metadata: 'json'\" instead.");}else if(S._src!="json"){throw new Error("Invalid metadata declaration for component "+n+": \""+S._src+"\"! Use \"metadata: 'json'\" to load metadata from component.json.");}var r=p.replace(/\./g,"/")+"/component.json";q.sap.log.info("The metadata of the component "+n+" is loaded from file "+r+".");try{var R=q.sap.loadResource(r,{dataType:"json"});q.extend(S,R);}catch(e){q.sap.log.error("Failed to load component metadata from \""+r+"\" (component "+n+")! Reason: "+e);}}M.prototype.applySettings.call(this,o);this._sComponentName=p;this._bInitialized=false;this._iInstanceCount=0;var m=S["manifest"];if(m){S.__metadataVersion=2;if(typeof m==="string"&&m==="json"){return;}}else{S.__metadataVersion=1;m={};}this._applyManifest(m);};C.prototype._applyManifest=function(m){if(this._oManifest){q.sap.log.warning("Can't apply manifest to ComponentMetadata as it has already been created.",this.getName(),"sap.ui.core.ComponentMetadata");return;}m["name"]=m["name"]||this.getName();m["sap.app"]=m["sap.app"]||{"id":this.getComponentName()};m["sap.ui5"]=m["sap.ui5"]||{};if(!this.isBaseClass()){m["sap.ui5"]["extends"]=m["sap.ui5"]["extends"]||{};}this._convertLegacyMetadata(this._oStaticInfo,m);this._oManifest=new b(m,{componentName:this.getComponentName(),baseUrl:q.sap.getModulePath(this.getComponentName(),"/"),process:this._oStaticInfo.__metadataVersion===2});};C.prototype.init=function(){if(this._iInstanceCount===0){var p=this.getParent();if(p instanceof C){p.init();}this.getManifestObject().init();this._bInitialized=true;}this._iInstanceCount++;};C.prototype.exit=function(){var i=Math.max(this._iInstanceCount-1,0);if(i===0){this.getManifestObject().exit();var p=this.getParent();if(p instanceof C){p.exit();}this._bInitialized=false;}this._iInstanceCount=i;};C.prototype.onInitComponent=function(i){q.sap.log.error("The function ComponentMetadata#onInitComponent will be removed soon!");};C.prototype.onExitComponent=function(i){q.sap.log.error("The function ComponentMetadata#onExitComponent will be removed soon!");};C.prototype.isBaseClass=function(){return/^sap\.ui\.core\.(UI)?Component$/.test(this.getName());};C.prototype.getMetadataVersion=function(){return this._oStaticInfo.__metadataVersion;};C.prototype.getManifestObject=function(){if(!this._oManifest){var m=this._oStaticInfo["manifest"];if(typeof m==="string"&&m==="json"){var n=this.getName();var p=this.getComponentName();var r=p.replace(/\./g,"/")+"/manifest.json";var i=q.sap.isResourceLoaded(r);if(!i&&s===2){q.sap.log.error("[nosync] Loading manifest of the component "+n+" ignored.",r,"sap.ui.core.ComponentMetadata");m={};}else{if(!i&&s===1){q.sap.log.error("[nosync] The manifest of the component "+n+" is loaded with sync XHR.",r,"sap.ui.core.ComponentMetadata");}else{q.sap.log.info("The manifest of the component "+n+" is loaded from file "+r+".");}try{var R=q.sap.loadResource(r,{dataType:"json"});m=R;}catch(e){q.sap.log.error("Failed to load component manifest from \""+r+"\" (component "+n+")! Reason: "+e);m={};}}this._applyManifest(m);}}return this._oManifest;};C.prototype.getManifest=function(){if(this.getMetadataVersion()===1){return this.getManifestObject().getRawJson();}return this.getManifestObject().getJson();};C.prototype._getManifest=function(){q.sap.log.warning("ComponentMetadata#_getManifest: do not use deprecated functions anymore!");return this.getManifestObject().getJson();};C.prototype.getRawManifest=function(){return this.getManifestObject().getRawJson();};C.prototype._getRawManifest=function(){q.sap.log.warning("ComponentMetadata#_getRawManifest: do not use deprecated functions anymore!");return this.getManifestObject().getRawJson();};C.prototype.getManifestEntry=function(k,m){var d=this.getManifestObject().getEntry(k);if(d!==undefined&&!q.isPlainObject(d)){return d;}var p,P;if(m&&(p=this.getParent())instanceof C){P=p.getManifestEntry(k,m);}if(P||d){d=q.extend(true,{},P,d);}return d;};C.prototype.getCustomEntry=function(k,m){if(!k||k.indexOf(".")<=0){q.sap.log.warning("Component Metadata entries with keys without namespace prefix can not be read via getCustomEntry. Key: "+k+", Component: "+this.getName());return null;}var p,d=this._oStaticInfo[k]||{};if(!q.isPlainObject(d)){q.sap.log.warning("Custom Component Metadata entry with key '"+k+"' must be an object. Component: "+this.getName());return null;}if(m&&(p=this.getParent())instanceof C){return q.extend(true,{},p.getCustomEntry(k,m),d);}return q.extend(true,{},d);};C.prototype.getComponentName=function(){return this._sComponentName;};C.prototype.getDependencies=function(){if(!this._oLegacyDependencies){var d=this.getManifestEntry("/sap.ui5/dependencies"),u=d&&d.minUI5Version||null,l=d&&d.libs||{},m=d&&d.components||{};var L={ui5version:u,libs:[],components:[]};for(var a in l){L.libs.push(a);}for(var e in m){L.components.push(e);}this._oLegacyDependencies=L;}return this._oLegacyDependencies;};C.prototype.getIncludes=function(){if(!this._aLegacyIncludes){var I=[],r=this.getManifestEntry("/sap.ui5/resources")||{},a=r&&r.css||[],j=r&&r.js||[];for(var i=0,l=a.length;i<l;i++){if(a[i]&&a[i].uri){I.push(a[i].uri);}}for(var i=0,l=j.length;i<l;i++){if(j[i]&&j[i].uri){I.push(j[i].uri);}}this._aLegacyIncludes=(I.length>0)?I:null;}return this._aLegacyIncludes;};C.prototype.getUI5Version=function(){return this.getManifestEntry("/sap.ui5/dependencies/minUI5Version");};C.prototype.getComponents=function(){return this.getDependencies().components;};C.prototype.getLibs=function(){return this.getDependencies().libs;};C.prototype.getVersion=function(){return this.getManifestEntry("/sap.app/applicationVersion/version");};C.prototype.getConfig=function(k,d){var m=this.getManifestEntry("/sap.ui5/config",!d);if(!m){return{};}if(!k){return m;}return m.hasOwnProperty(k)?m[k]:{};};C.prototype.getCustomizing=function(d){return this.getManifestEntry("/sap.ui5/extends/extensions",!d);};C.prototype.getModels=function(d){if(!this._oLegacyModels){this._oLegacyModels={};var D=this.getManifestEntry("/sap.ui5/models")||{};for(var a in D){var o=D[a];this._oLegacyModels[a]=o.settings||{};this._oLegacyModels[a].type=o.type;this._oLegacyModels[a].uri=o.uri;}}var p,m=q.extend(true,{},this._oLegacyModels);if(!d&&(p=this.getParent())instanceof C){m=q.extend(true,{},p.getModels(),m);}return m;};C.prototype.handleValidation=function(){return this.getManifestEntry("/sap.ui5/handleValidation");};C.prototype.getServices=function(){q.sap.log.warning("Usage of sap.ui.core.ComponentMetadata.protoype.getServices is deprecated!");return this._oStaticInfo.services||{};};C.prototype._convertLegacyMetadata=function(S,d){var f=function(a,t){var o={};if(a){for(var i=0,l=a.length;i<l;i++){var v=a[i];if(typeof v==="string"){o[v]=typeof t==="function"&&t(v)||{};}}}return o;};var A=d["sap.app"];var u=d["sap.ui5"];for(var n in S){var v=S[n];if(v!==undefined){switch(n){case"name":d[n]=d[n]||v;A["id"]=A["id"]||v;break;case"description":case"keywords":A[n]=A[n]||v;break;case"version":var e=A.applicationVersion=A.applicationVersion||{};e.version=e.version||v;break;case"config":u[n]=u[n]||v;break;case"customizing":var E=u["extends"]=u["extends"]||{};E.extensions=E.extensions||v;break;case"dependencies":if(!u[n]){u[n]={};u[n].minUI5Version=v.ui5version;u[n].libs=f(v.libs);u[n].components=f(v.components);}break;case"includes":if(!u["resources"]){u["resources"]={};if(v&&v.length>0){for(var i=0,l=v.length;i<l;i++){var r=v[i];var m=r.match(/\.(css|js)$/i);if(m){u["resources"][m[1]]=u["resources"][m[1]]||[];u["resources"][m[1]].push({"uri":r});}}}}break;case"handleValidation":if(u[n]===undefined){u[n]=v;}break;case"models":if(!u["models"]){var g={};for(var h in v){var D=v[h];var j={};for(var k in D){var p=D[k];switch(k){case"type":case"uri":j[k]=p;break;default:j.settings=j.settings||{};j.settings[k]=p;}}g[h]=j;}u["models"]=g;}break;}}}};return C;},true);
