/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/library','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/date/UniversalDate','jquery.sap.strings'],function(q,l,L,a,U){"use strict";var C=l.CalendarType;var D=function(){throw new Error();};var c={};D.oDateInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(o,s,g){return o.getDatePattern(s,g);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["FullYear","Quarter","Month","Week","Date"]};D.oDateTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(o,s,g){var S=s.indexOf("/");if(S>0){return o.getCombinedDateTimePattern(s.substr(0,S),s.substr(S+1),g);}else{return o.getCombinedDateTimePattern(s,s,g);}},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};D.oTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(o,s,g){return o.getTimePattern(s,g);},oRequiredParts:{"text":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};D.getInstance=function(F,o){return this.getDateInstance(F,o);};D.getDateInstance=function(F,o){return this.createInstance(F,o,this.oDateInfo);};D.getDateTimeInstance=function(F,o){return this.createInstance(F,o,this.oDateTimeInfo);};D.getTimeInstance=function(F,o){return this.createInstance(F,o,this.oTimeInfo);};function b(F){var P=F.oLocaleData.getIntervalPattern("",F.oFormatOptions.calendarType);P=P.replace(/[^\{\}01 ]/,"-");return P.replace(/\{(0|1)\}/g,F.oFormatOptions.pattern);}D.createInstance=function(F,o,i){var g=Object.create(this.prototype);if(F instanceof L){o=F;F=undefined;}if(!o){o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}g.oLocale=o;g.oLocaleData=a.getInstance(o);g.oFormatOptions=q.extend(false,{},i.oDefaultFormatOptions,F);if(!g.oFormatOptions.calendarType){g.oFormatOptions.calendarType=sap.ui.getCore().getConfiguration().getCalendarType();}if(!g.oFormatOptions.pattern){if(g.oFormatOptions.format){g.oFormatOptions.pattern=g.oLocaleData.getCustomDateTimePattern(g.oFormatOptions.format,g.oFormatOptions.calendarType);}else{g.oFormatOptions.pattern=i.getPattern(g.oLocaleData,g.oFormatOptions.style,g.oFormatOptions.calendarType);}}if(g.oFormatOptions.interval){if(g.oFormatOptions.format){g.intervalPatterns=g.oLocaleData.getCustomIntervalPattern(g.oFormatOptions.format,null,g.oFormatOptions.calendarType);if(typeof g.intervalPatterns==="string"){g.intervalPatterns=[g.intervalPatterns];}g.intervalPatterns.push(g.oLocaleData.getCustomDateTimePattern(g.oFormatOptions.format,g.oFormatOptions.calendarType));}else{g.intervalPatterns=[g.oLocaleData.getCombinedIntervalPattern(g.oFormatOptions.pattern,g.oFormatOptions.calendarType),g.oFormatOptions.pattern];}var s=b(g);g.intervalPatterns.push(s);}if(!g.oFormatOptions.fallback){if(!i.oFallbackFormats){i.oFallbackFormats={};}var h=o.toString(),j=g.oFormatOptions.calendarType,k=h+"-"+j,P,n;if(g.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){k=k+"-"+g.oFormatOptions.pattern;}if(g.oFormatOptions.interval){k=k+"-"+"interval";}if(!i.oFallbackFormats[k]){n=i.aFallbackFormatOptions;if(i.bShortFallbackFormatOptions){P=i.getPattern(g.oLocaleData,"short");n=n.concat(D._createFallbackOptionsWithoutDelimiter(P));}if(g.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){n=D._createFallbackOptionsWithoutDelimiter(g.oFormatOptions.pattern).concat(n);}i.oFallbackFormats[k]=D._createFallbackFormat(n,j,o,i,g.oFormatOptions.interval);}g.aFallbackFormats=i.oFallbackFormats[k];}g.oRequiredParts=i.oRequiredParts;g.aRelativeScales=i.aRelativeScales;g.aRelativeParseScales=i.aRelativeParseScales;g.aIntervalCompareFields=i.aIntervalCompareFields;g.init();return g;};D.prototype.init=function(){var s=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData.getMonths("abbreviated",s);this.aMonthsWide=this.oLocaleData.getMonths("wide",s);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",s);this.aMonthsAbbrevSt=this.oLocaleData.getMonthsStandAlone("abbreviated",s);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",s);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",s);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",s);this.aDaysWide=this.oLocaleData.getDays("wide",s);this.aDaysNarrow=this.oLocaleData.getDays("narrow",s);this.aDaysShort=this.oLocaleData.getDays("short",s);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",s);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",s);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",s);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",s);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",s);this.aQuartersWide=this.oLocaleData.getQuarters("wide",s);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",s);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",s);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",s);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",s);this.aErasNarrow=this.oLocaleData.getEras("narrow",s);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",s);this.aErasWide=this.oLocaleData.getEras("wide",s);this.aDayPeriods=this.oLocaleData.getDayPeriods("abbreviated",s);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray);};D._createFallbackFormat=function(F,s,o,i,I){return F.map(function(g){if(I){g.interval=true;}g.calendarType=s;g.fallback=true;var h=D.createInstance(g,o,i);h.bIsFallback=true;return h;});};D._createFallbackOptionsWithoutDelimiter=function(B){var g=/[^dMyGU]/g,o={regex:/d+/g,replace:"dd"},M={regex:/M+/g,replace:"MM"},y={regex:/[yU]+/g,replace:["yyyy","yy"]};B=B.replace(g,"");B=B.replace(o.regex,o.replace);B=B.replace(M.regex,M.replace);return y.replace.map(function(R){return{pattern:B.replace(y.regex,R),strictParsing:true};});};var p={isNumber:function(i){return i>=48&&i<=57;},findNumbers:function(v,M){var i=0;while(i<M&&this.isNumber(v.charCodeAt(i))){i++;}if(typeof v!=="string"){v=v.toString();}return v.substr(0,i);},findEntry:function(v,g){var F=-1,M=0;for(var j=0;j<g.length;j++){if(g[j]&&g[j].length>M&&v.indexOf(g[j])===0){F=j;M=g[j].length;}}return{index:F,value:F===-1?null:g[F]};},parseTZ:function(v,i){var g=0;var t=v.charAt(0)=="+"?-1:1;var P;g++;P=this.findNumbers(v.substr(g),2);var T=parseInt(P,10);g+=2;if(i){g++;}P=this.findNumbers(v.substr(g),2);g+=2;var h=parseInt(P,10);return{length:g,tzDiff:(h+60*T)*t};},checkValid:function(t,P,F){if(t in F.oRequiredParts&&P){return false;}}};D.prototype.oSymbols={"":{name:"text",format:function(F,o,u,g){return F.value;},parse:function(v,P,F,o){var s;var V=true;var i=0;var g=0;for(;g<P.value.length;g++){s=P.value.charAt(g);if(s!==" "){if(v.charAt(i)!==s){V=false;}i++;}else{while(v.charAt(i)===" "){i++;}}if(!V){break;}}if(V){return{length:i};}else{var h=false;if(o.index<o.formatArray.length-1){h=(o.formatArray[o.index+1].type in F.oRequiredParts);}return{valid:p.checkValid(P.type,h,F)};}}},"G":{name:"era",format:function(F,o,u,g){var E=u?o.getUTCEra():o.getEra();if(F.digits<=3){return g.aErasAbbrev[E];}else if(F.digits===4){return g.aErasWide[E];}else{return g.aErasNarrow[E];}},parse:function(v,P,F,o){var E=[F.aErasWide,F.aErasAbbrev,F.aErasNarrow];for(var i=0;i<E.length;i++){var V=E[i];var g=p.findEntry(v,V);if(g.index!==-1){return{era:g.index,length:g.value.length};}}return{era:F.aErasWide.length-1,valid:p.checkValid(P.type,true,F)};}},"y":{name:"year",format:function(F,o,u,g){var y=u?o.getUTCFullYear():o.getFullYear();var Y=String(y);var s=g.oFormatOptions.calendarType;if(F.digits==2&&Y.length>2){Y=Y.substr(Y.length-2);}if(s!=C.Japanese&&F.digits==1&&y<100){Y=q.sap.padLeft(Y,"0",4);}return q.sap.padLeft(Y,"0",F.digits);},parse:function(v,P,F,o){var s=F.oFormatOptions.calendarType;var g;if(P.digits==1){g=p.findNumbers(v,4);}else if(P.digits==2){g=p.findNumbers(v,2);}else{g=p.findNumbers(v,P.digits);}var y=parseInt(g,10);if(s!=C.Japanese&&g.length<=2){var h=U.getInstance(new Date(),s),i=h.getFullYear(),j=Math.floor(i/100),Y=j*100+y-i;if(Y<-70){y+=(j+1)*100;}else if(Y<30){y+=j*100;}else{y+=(j-1)*100;}}return{length:g.length,valid:p.checkValid(P.type,g==="",F),year:y};}},"Y":{name:"weekYear",format:function(F,o,u,g){var w=u?o.getUTCWeek():o.getWeek();var W=w.year;var s=String(W);var h=g.oFormatOptions.calendarType;if(F.digits==2&&s.length>2){s=s.substr(s.length-2);}if(h!=C.Japanese&&F.digits==1&&W<100){s=q.sap.padLeft(s,"0",4);}return q.sap.padLeft(s,"0",F.digits);},parse:function(v,P,F,o){var s=F.oFormatOptions.calendarType;var g;if(P.digits==1){g=p.findNumbers(v,4);}else if(P.digits==2){g=p.findNumbers(v,2);}else{g=p.findNumbers(v,P.digits);}var y=parseInt(g,10);var w;if(s!=C.Japanese&&g.length<=2){var h=U.getInstance(new Date(),s),i=h.getFullYear(),j=Math.floor(i/100),Y=j*100+w-i;if(Y<-70){w+=(j+1)*100;}else if(Y<30){w+=j*100;}else{w+=(j-1)*100;}}return{length:g.length,valid:p.checkValid(P.type,g==="",F),year:y,weekYear:w};}},"M":{name:"month",format:function(F,o,u,g){var M=u?o.getUTCMonth():o.getMonth();if(F.digits==3){return g.aMonthsAbbrev[M];}else if(F.digits==4){return g.aMonthsWide[M];}else if(F.digits>4){return g.aMonthsNarrow[M];}else{return q.sap.padLeft(String(M+1),"0",F.digits);}},parse:function(v,P,F,o){var M=[F.aMonthsWide,F.aMonthsWideSt,F.aMonthsAbbrev,F.aMonthsAbbrevSt,F.aMonthsNarrow,F.aMonthsNarrowSt];var V;var g;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);g=parseInt(s,10)-1;if(o.strict&&(g>11||g<0)){V=false;}}else{for(var i=0;i<M.length;i++){var h=M[i];var j=p.findEntry(v,h);if(j.index!==-1){return{month:j.index,length:j.value.length};}}V=p.checkValid(P.type,true,F);}return{month:g,length:s?s.length:0,valid:V};}},"L":{name:"monthStandalone",format:function(F,o,u,g){var M=u?o.getUTCMonth():o.getMonth();if(F.digits==3){return g.aMonthsAbbrevSt[M];}else if(F.digits==4){return g.aMonthsWideSt[M];}else if(F.digits>4){return g.aMonthsNarrowSt[M];}else{return q.sap.padLeft(String(M+1),"0",F.digits);}},parse:function(v,P,F,o){var M=[F.aMonthsWide,F.aMonthsWideSt,F.aMonthsAbbrev,F.aMonthsAbbrevSt,F.aMonthsNarrow,F.aMonthsNarrowSt];var V;var g;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);g=parseInt(s,10)-1;if(o.strict&&(g>11||g<0)){V=false;}}else{for(var i=0;i<M.length;i++){var h=M[i];var j=p.findEntry(v,h);if(j.index!==-1){return{month:j.index,length:j.value.length};}}V=p.checkValid(P.type,true,F);}return{month:g,length:s?s.length:0,valid:V};}},"w":{name:"weekInYear",format:function(F,o,u,g){var w=u?o.getUTCWeek():o.getWeek();var W=w.week;var s=String(W+1);if(F.digits<3){s=q.sap.padLeft(s,"0",F.digits);}else{s=g.oLocaleData.getCalendarWeek(F.digits===3?"narrow":"wide",q.sap.padLeft(s,"0",2));}return s;},parse:function(v,P,F,o){var V;var s;var w;var i=0;if(P.digits<3){s=p.findNumbers(v,2);i=s.length;w=parseInt(s,10)-1;V=p.checkValid(P.type,!s,F);}else{s=F.oLocaleData.getCalendarWeek(P.digits===3?"narrow":"wide");s=s.replace("{0}","[0-9]+");var g=new RegExp(s),R=g.exec(v);if(R){i=R[0].length;w=parseInt(R[0],10)-1;}else{V=p.checkValid(P.type,true,F);}}return{length:i,valid:V,week:w};}},"W":{name:"weekInMonth",format:function(F,o,u,g){return"";},parse:function(){return{};}},"D":{name:"dayInYear",format:function(F,o,u,g){},parse:function(){return{};}},"d":{name:"day",format:function(F,o,u,g){var i=u?o.getUTCDate():o.getDate();return q.sap.padLeft(String(i),"0",F.digits);},parse:function(v,P,F,o){var s=p.findNumbers(v,Math.max(P.digits,2));var V=p.checkValid(P.type,s==="",F);var i=parseInt(s,10);if(o.strict&&(i>31||i<1)){V=false;}return{day:i,length:s.length,valid:V};}},"Q":{name:"quarter",format:function(F,o,u,g){var Q=u?o.getUTCQuarter():o.getQuarter();if(F.digits==3){return g.aQuartersAbbrev[Q];}else if(F.digits==4){return g.aQuartersWide[Q];}else if(F.digits>4){return g.aQuartersNarrow[Q];}else{return q.sap.padLeft(String(Q+1),"0",F.digits);}},parse:function(v,P,F,o){var V;var Q;var s;var g=[F.aQuartersWide,F.aQuartersWideSt,F.aQuartersAbbrev,F.aQuartersAbbrevSt,F.aQuartersNarrow,F.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);Q=parseInt(s,10)-1;if(o.strict&&Q>3){V=false;}}else{for(var i=0;i<g.length;i++){var h=g[i];var j=p.findEntry(v,h);if(j.index!==-1){return{quarter:j.index,length:j.value.length};}}V=p.checkValid(P.type,true,F);}return{length:s?s.length:0,quarter:Q,valid:V};}},"q":{name:"quarterStandalone",format:function(F,o,u,g){var Q=u?o.getUTCQuarter():o.getQuarter();if(F.digits==3){return g.aQuartersAbbrevSt[Q];}else if(F.digits==4){return g.aQuartersWideSt[Q];}else if(F.digits>4){return g.aQuartersNarrowSt[Q];}else{return q.sap.padLeft(String(Q+1),"0",F.digits);}},parse:function(v,P,F,o){var V;var Q;var s;var g=[F.aQuartersWide,F.aQuartersWideSt,F.aQuartersAbbrev,F.aQuartersAbbrevSt,F.aQuartersNarrow,F.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);Q=parseInt(s,10)-1;if(o.strict&&Q>3){V=false;}}else{for(var i=0;i<g.length;i++){var h=g[i];var j=p.findEntry(v,h);if(j.index!==-1){return{quarter:j.index,length:j.value.length};}}V=p.checkValid(P.type,true,F);}return{length:s?s.length:0,quarter:Q,valid:V};}},"F":{name:"dayOfWeekInMonth",format:function(F,o,u,g){return"";},parse:function(){return{};}},"E":{name:"dayNameInWeek",format:function(F,o,u,g){var i=u?o.getUTCDay():o.getDay();if(F.digits<4){return g.aDaysAbbrev[i];}else if(F.digits==4){return g.aDaysWide[i];}else if(F.digits==5){return g.aDaysNarrow[i];}else{return g.aDaysShort[i];}},parse:function(v,P,F,o){var g=[F.aDaysWide,F.aDaysWideSt,F.aDaysAbbrev,F.aDaysAbbrevSt,F.aDaysShort,F.aDaysShortSt,F.aDaysNarrow,F.aDaysNarrowSt];for(var i=0;i<g.length;i++){var V=g[i];var h=p.findEntry(v,V);if(h.index!==-1){return{dayNumberOfWeek:F._adaptDayOfWeek(h.index),length:h.value.length};}}}},"c":{name:"dayNameInWeekStandalone",format:function(F,o,u,g){var i=u?o.getUTCDay():o.getDay();if(F.digits<4){return g.aDaysAbbrevSt[i];}else if(F.digits==4){return g.aDaysWideSt[i];}else if(F.digits==5){return g.aDaysNarrowSt[i];}else{return g.aDaysShortSt[i];}},parse:function(v,P,F,o){var g=[F.aDaysWide,F.aDaysWideSt,F.aDaysAbbrev,F.aDaysAbbrevSt,F.aDaysShort,F.aDaysShortSt,F.aDaysNarrow,F.aDaysNarrowSt];for(var i=0;i<g.length;i++){var V=g[i];var h=p.findEntry(v,V);if(h.index!==-1){return{day:h.index,length:h.value.length};}}}},"u":{name:"dayNumberOfWeek",format:function(F,o,u,g){var i=u?o.getUTCDay():o.getDay();return g._adaptDayOfWeek(i);},parse:function(v,P,F,o){var s=p.findNumbers(v,P.digits);return{dayNumberOfWeek:parseInt(s,10),length:s.length};}},"a":{name:"amPmMarker",format:function(F,o,u,g){var i=u?o.getUTCDayPeriod():o.getDayPeriod();return g.aDayPeriods[i];},parse:function(v,P,F,o){var g;var i;var A=F.aDayPeriods[0],s=F.aDayPeriods[1];var h=/[aApP](?:\.)?[mM](?:\.)?/;var M=v.match(h);var V=(M&&M.index===0);if(V){v=M[0].replace(/\./g,"").toLowerCase()+v.substring(M[0].length);A=A.toLowerCase();s=s.toLowerCase();}if(v.indexOf(A)===0){g=false;i=(V?M[0].length:A.length);}else if(v.indexOf(s)===0){g=true;i=(V?M[0].length:s.length);}return{pm:g,length:i};}},"H":{name:"hour0_23",format:function(F,o,u,g){var h=u?o.getUTCHours():o.getHours();return q.sap.padLeft(String(h),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&h>23){V=false;}return{hour:h,length:s.length,valid:V};}},"k":{name:"hour1_24",format:function(F,o,u,g){var h=u?o.getUTCHours():o.getHours();var H=(h===0?"24":String(h));return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(h==24){h=0;}if(o.strict&&h>23){V=false;}return{hour:h,length:s.length,valid:V};}},"K":{name:"hour0_11",format:function(F,o,u,g){var h=u?o.getUTCHours():o.getHours();var H=String(h>11?h-12:h);return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&h>11){V=false;}return{hour:h,length:s.length,valid:V};}},"h":{name:"hour1_12",format:function(F,o,u,g){var h=u?o.getUTCHours():o.getHours();var H;if(h>12){H=String(h-12);}else if(h==0){H="12";}else{H=String(h);}return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var g=o.dateValue.pm;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);var V=p.checkValid(P.type,s==="",F);if(h==12){h=0;g=(g===undefined)?true:g;}if(o.strict&&h>11){V=false;}return{hour:h,length:s.length,pm:g,valid:V};}},"m":{name:"minute",format:function(F,o,u,g){var M=u?o.getUTCMinutes():o.getMinutes();return q.sap.padLeft(String(M),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var M=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&M>59){V=false;}return{length:s.length,minute:M,valid:V};}},"s":{name:"second",format:function(F,o,u,g){var s=u?o.getUTCSeconds():o.getSeconds();return q.sap.padLeft(String(s),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var S=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&S>59){V=false;}return{length:s.length,second:S,valid:V};}},"S":{name:"fractionalsecond",format:function(F,o,u,g){var M=u?o.getUTCMilliseconds():o.getMilliseconds();var s=String(M);var h=q.sap.padLeft(s,"0",3);h=h.substr(0,F.digits);h=q.sap.padRight(h,"0",F.digits);return h;},parse:function(v,P,F,o){var s=p.findNumbers(v,P.digits);var i=s.length;s=s.substr(0,3);s=q.sap.padRight(s,"0",3);var M=parseInt(s,10);return{length:i,millisecond:M};}},"z":{name:"timezoneGeneral",format:function(F,o,u,g){if(F.digits>3&&o.getTimezoneLong()){return o.getTimezoneLong();}else if(o.getTimezoneShort()){return o.getTimezoneShort();}var t="GMT";var T=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(T/60);var M=T%60;if(!u&&T!=0){t+=(P?"-":"+");t+=q.sap.padLeft(String(h),"0",2);t+=":";t+=q.sap.padLeft(String(M),"0",2);}else{t+="Z";}return t;},parse:function(v,P,F,o){var i=0;var t;var T=v.substring(0,3);if(T==="GMT"||T==="UTC"){i=3;}else if(v.substring(0,2)==="UT"){i=2;}else if(v.charAt(0)=="Z"){i=1;t=0;}else{return{error:"cannot be parsed correcly by sap.ui.core.format.DateFormat: The given timezone is not supported!"};}if(v.charAt(0)!="Z"){var g=p.parseTZ(v.substr(i),true);i+=g.length;t=g.tzDiff;}return{length:i,tzDiff:t};}},"Z":{name:"timezoneRFC822",format:function(F,o,u,g){var t=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=q.sap.padLeft(String(h),"0",2);T+=q.sap.padLeft(String(M),"0",2);}return T;},parse:function(v,P,F,o){return p.parseTZ(v,false);}},"X":{name:"timezoneISO8601",format:function(F,o,u,g){var t=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=q.sap.padLeft(String(h),"0",2);T+=":";T+=q.sap.padLeft(String(M),"0",2);}else{T+="Z";}return T;},parse:function(v,P,F,o){if(v.charAt(0)=="Z"){return{length:1,tzDiff:0};}else{return p.parseTZ(v,true);}}}};D.prototype._format=function(j,u){if(this.oFormatOptions.relative){var R=this.formatRelative(j,u,this.oFormatOptions.relativeRange);if(R){return R;}}var s=this.oFormatOptions.calendarType;var o=U.getInstance(j,s);var B=[],P,g,S;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";B.push(this.oSymbols[S].format(P,o,u,this));}g=B.join("");if(sap.ui.getCore().getConfiguration().getOriginInfo()){g=new String(g);g.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern};}return g;};D.prototype.format=function(j,u){if(u===undefined){u=this.oFormatOptions.UTC;}if(Array.isArray(j)){if(!this.oFormatOptions.interval){q.sap.log.error("Non-interval DateFormat can't format more than one date instance.");return"";}if(j.length!==2){q.sap.log.error("Interval DateFormat can only format with 2 date instances but "+j.length+" is given.");return"";}var v=j.every(function(J){return J&&!isNaN(J.getTime());});if(!v){q.sap.log.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return"";}return this._formatInterval(j,u);}else{if(!j||isNaN(j.getTime())){q.sap.log.error("The given date instance isn't valid.");return"";}if(this.oFormatOptions.interval){q.sap.log.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return"";}return this._format(j,u);}};D.prototype._formatInterval=function(j,u){var s=this.oFormatOptions.calendarType;var F=U.getInstance(j[0],s);var t=U.getInstance(j[1],s);var o;var P;var S;var B=[];var g;var h=this._getGreatestDiffField([F,t],u);if(!h){return this._format(j[0],u);}if(this.oFormatOptions.format){g=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,h,s);}else{g=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s);}this.aFormatArray=this.parseCldrDatePattern(g);o=F;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";if(P.repeat){o=t;}B.push(this.oSymbols[S].format(P,o,u,this));}return B.join("");};var f={FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};D.prototype._getGreatestDiffField=function(g,u){var h=false,i={};this.aIntervalCompareFields.forEach(function(F){var G="get"+(u?"UTC":""),M=G+F,s=f[F],v=g[0][M].apply(g[0]),t=g[1][M].apply(g[1]);if(!q.sap.equal(v,t)){h=true;i[s]=true;}});if(h){return i;}return null;};D.prototype._parse=function(v,F,u,s){var I=0,P,S,R;var o={valid:true};var g={formatArray:F,dateValue:o,strict:s};for(var i=0;i<F.length;i++){S=v.substr(I);P=F[i];g.index=i;R=this.oSymbols[P.symbol||""].parse(S,P,this,g)||{};o=q.extend(o,R);if(R.valid===false){break;}I+=R.length||0;}o.index=I;if(o.pm){o.hour+=12;}if(o.quarter!==undefined&&o.month===undefined&&o.day===undefined){o.month=3*o.quarter;o.day=1;}return o;};D.prototype._parseInterval=function(v,s,u,S){var g,R,o;this.intervalPatterns.some(function(P){var F=this.parseCldrDatePattern(P);R=undefined;for(var i=0;i<F.length;i++){if(F[i].repeat){R=i;break;}}if(R===undefined){o=this._parse(v,F,u,S);if(o.index===0||o.index<v.length){o.valid=false;}if(o.valid===false){return;}g=[o,o];return true;}else{g=[];o=this._parse(v,F.slice(0,R),u,S);if(o.valid===false){return;}g.push(o);var h=o.index;o=this._parse(v.substring(h),F.slice(R),u,S);if(o.index===0||o.index+h<v.length){o.valid=false;}if(o.valid===false){return;}g.push(o);return true;}}.bind(this));return g;};var d=function(o,s,u,S){var g,y=typeof o.year==="number"?o.year:1970;if(o.valid){if(u||o.tzDiff!==undefined){g=U.getInstance(new Date(0),s);g.setUTCEra(o.era||U.getCurrentEra(s));g.setUTCFullYear(y);g.setUTCMonth(o.month||0);g.setUTCDate(o.day||1);g.setUTCHours(o.hour||0);g.setUTCMinutes(o.minute||0);g.setUTCSeconds(o.second||0);g.setUTCMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==g.getUTCDate()){o.valid=false;g=undefined;}else{if(o.tzDiff){g.setUTCMinutes((o.minute||0)+o.tzDiff);}if(o.week!==undefined){g.setUTCWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){g.setUTCDate(g.getUTCDate()+o.dayNumberOfWeek-1);}}}}else{g=U.getInstance(new Date(1970,0,1,0,0,0),s);g.setEra(o.era||U.getCurrentEra(s));g.setFullYear(y);g.setMonth(o.month||0);g.setDate(o.day||1);g.setHours(o.hour||0);g.setMinutes(o.minute||0);g.setSeconds(o.second||0);g.setMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==g.getDate()){o.valid=false;g=undefined;}else if(o.week!==undefined){g.setWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){g.setDate(g.getDate()+o.dayNumberOfWeek-1);}}}if(o.valid){g=g.getJSDate();return g;}}return null;};function m(o,g){if(o===g){return o;}var M={};Object.keys(o).forEach(function(k){M[k]=o[k];});Object.keys(g).forEach(function(k){if(!M.hasOwnProperty(k)){M[k]=g[k];}});return M;}D.prototype.parse=function(v,u,s){v=q.trim(v);var o;var g=this.oFormatOptions.calendarType;if(u===undefined){u=this.oFormatOptions.UTC;}if(s===undefined){s=this.oFormatOptions.strictParsing;}if(!this.oFormatOptions.interval){var j=this.parseRelative(v,u);if(j){return j;}o=this._parse(v,this.aFormatArray,u,s);if(o.index===0||o.index<v.length){o.valid=false;}j=d(o,g,u,s);if(j){return j;}}else{var h=this._parseInterval(v,g,u,s);var J,k;if(h&&h.length==2){var n=m(h[0],h[1]);var t=m(h[1],h[0]);J=d(n,g,u,s);k=d(t,g,u,s);if(J&&k){return[J,k];}}}if(!this.bIsFallback){var w;q.each(this.aFallbackFormats,function(i,F){w=F.parse(v,u,s);if(Array.isArray(w)){return!(w[0]&&w[1]);}else{return!w;}});return w;}if(!this.oFormatOptions.interval){return null;}else{return[null,null];}};D.prototype.parseCldrDatePattern=function(P){if(c[P]){return c[P];}var F=[],i,Q=false,o=null,s="",n="",A={},I=false;for(i=0;i<P.length;i++){var g=P.charAt(i),N,h,j;if(Q){if(g=="'"){h=P.charAt(i-1);j=P.charAt(i-2);N=P.charAt(i+1);if(h=="'"&&j!="'"){Q=false;}else if(N=="'"){i+=1;}else{Q=false;continue;}}if(s=="text"){o.value+=g;}else{o={type:"text",value:g};F.push(o);s="text";}}else{if(g=="'"){Q=true;}else if(this.oSymbols[g]){n=this.oSymbols[g].name;if(s==n){o.digits++;}else{o={type:n,symbol:g,digits:1};F.push(o);s=n;if(!I){if(A[n]){o.repeat=true;I=true;}else{A[n]=true;}}}}else{if(s=="text"){o.value+=g;}else{o={type:"text",value:g};F.push(o);s="text";}}}}c[P]=F;return F;};D.prototype.parseRelative=function(v,u){var P,E,g,R,V;if(!v){return null;}P=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var i=0;i<P.length;i++){E=P[i];g=new RegExp("^\\s*"+E.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");R=g.exec(v);if(R){if(E.value!==undefined){return h(E.value,E.scale);}else{V=parseInt(R[1],10);return h(V*E.sign,E.scale);}}}function h(j,s){var t,T=new Date(),J;if(u){t=T.getTime();}else{t=Date.UTC(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours(),T.getMinutes(),T.getSeconds(),T.getMilliseconds());}J=new Date(t);switch(s){case"second":J.setUTCSeconds(J.getUTCSeconds()+j);break;case"minute":J.setUTCMinutes(J.getUTCMinutes()+j);break;case"hour":J.setUTCHours(J.getUTCHours()+j);break;case"day":J.setUTCDate(J.getUTCDate()+j);break;case"week":J.setUTCDate(J.getUTCDate()+j*7);break;case"month":J.setUTCMonth(J.getUTCMonth()+j);break;case"quarter":J.setUTCMonth(J.getUTCMonth()+j*3);break;case"year":J.setUTCFullYear(J.getUTCFullYear()+j);break;}if(u){return J;}else{return new Date(J.getUTCFullYear(),J.getUTCMonth(),J.getUTCDate(),J.getUTCHours(),J.getUTCMinutes(),J.getUTCSeconds(),J.getUTCMilliseconds());}}};D.prototype.formatRelative=function(j,u,R){var t=new Date(),s=this.oFormatOptions.relativeScale||"day",i,P,g;g=(j.getTime()-t.getTime())/1000;if(this.oFormatOptions.relativeScale=="auto"){s=this._getScale(g,this.aRelativeScales);}if(!R){R=this._mRanges[s];}if(s=="year"||s=="month"||s=="day"){t=new Date(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate()));if(u){j=new Date(Date.UTC(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate()));}else{j=new Date(Date.UTC(j.getFullYear(),j.getMonth(),j.getDate()));}}i=this._getDifference(s,[t,j]);if(this.oFormatOptions.relativeScale!="auto"&&(i<R[0]||i>R[1])){return null;}P=this.oLocaleData.getRelativePattern(s,i,g>0,this.oFormatOptions.relativeStyle);return q.sap.formatMessage(P,[Math.abs(i)]);};D.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};D.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592000,quarter:7776000,year:31536000};D.prototype._getScale=function(g,s){var S,t;g=Math.abs(g);for(var i=0;i<s.length;i++){t=s[i];if(g>=this._mScales[t]){S=t;break;}}if(!S){S=s[s.length-1];}return S;};function e(o,s){var F=["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],M;for(var i=s;i<F.length;i++){M="set"+F[s];o[M].apply(o,[0]);}}var r={year:function(F,t){return t.getFullYear()-F.getFullYear();},month:function(F,t){return t.getMonth()-F.getMonth()+(this.year(F,t)*12);},week:function(F,t,o){var i=o._adaptDayOfWeek(F.getDay());var T=o._adaptDayOfWeek(t.getDay());e(F,3);e(t,3);return(t.getTime()-F.getTime()-(T-i)*o._mScales.day*1000)/(o._mScales.week*1000);},day:function(F,t,o){e(F,3);e(t,3);return(t.getTime()-F.getTime())/(o._mScales.day*1000);},hour:function(F,t,o){e(F,4);e(t,4);return(t.getTime()-F.getTime())/(o._mScales.hour*1000);},minute:function(F,t,o){e(F,5);e(t,5);return(t.getTime()-F.getTime())/(o._mScales.minute*1000);},second:function(F,t,o){e(F,6);e(t,6);return(t.getTime()-F.getTime())/(o._mScales.second*1000);}};D.prototype._adaptDayOfWeek=function(i){var F=this.oLocaleData.getFirstDayOfWeek();var g=i-(F-1);if(g<=0){g+=7;}return g;};D.prototype._getDifference=function(s,g){var F=g[0];var t=g[1];return Math.round(r[s](F,t,this));};D.prototype.getAllowedCharacters=function(F){if(this.oFormatOptions.relative){return"";}var A="";var n=false;var g=false;var P;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];switch(P.type){case"text":if(A.indexOf(P.value)<0){A+=P.value;}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!n){A+="0123456789";n=true;}break;case"month":case"monthStandalone":if(P.digits<3){if(!n){A+="0123456789";n=true;}}else{g=true;}break;default:g=true;break;}}if(g){A="";}return A;};return D;},true);
