/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/mvc/Controller','sap/ui/core/library',"./ViewRenderer"],function(q,M,C,a,b,V){"use strict";var c=b.mvc.ViewType;var d=C.extend("sap.ui.core.mvc.View",{metadata:{library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:'sap.ui.core.mvc.Controller',controllerName:'string',preprocessors:'Object',resourceBundleName:'string',resourceBundleUrl:'sap.ui.core.URI',resourceBundleLocale:'string',resourceBundleAlias:'string',type:'string',viewContent:'any',viewData:'any',async:{type:"boolean",defaultValue:false}}}});d._mPreprocessors={};function e(P){P._settings={};for(var s in P){if(s.indexOf("_")!==0){P._settings[s]=P[s];}}}function f(P,A){var i;if(typeof P.preprocessor==="string"){var s=P.preprocessor.replace(/\./g,"/");if(A){return new Promise(function(j,l){sap.ui.require([s],function(i){j(i);});});}else{return sap.ui.requireSync(s);}}else if(typeof P.preprocessor==="function"&&!P.preprocessor.process){i={process:P.preprocessor};}else{i=P.preprocessor;}if(A){return Promise.resolve(i);}else{return i;}}function g(v,t){var L=this.mPreprocessors[t]||[],G=[],i,l,O,P=[];if(d._mPreprocessors[v]&&d._mPreprocessors[v][t]){G=d._mPreprocessors[v][t].map(function(j){return q.extend({},j);});}for(i=0,l=G.length;i<l;i++){if(G[i]._onDemand){O=G[i];}else{P.push(G[i]);}}for(i=0,l=L.length;i<l;i++){var I=!L[i].preprocessor;if(I&&O){P.unshift(q.extend(L[i],O));}else if(!I){P.push(L[i]);}}return P;}function h(v,s){var i=v.getMetadata().getClass();function j(P){P.preprocessor=f(P,s.async);}v.mPreprocessors=q.extend({},s.preprocessors);for(var _ in i.PreprocessorType){var t=i.PreprocessorType[_];if(v.mPreprocessors[t]&&!Array.isArray(v.mPreprocessors[t])){v.mPreprocessors[t]=[v.mPreprocessors[t]];}else if(!v.mPreprocessors[t]){v.mPreprocessors[t]=[];}v.mPreprocessors[t].forEach(e);v.mPreprocessors[t]=g.call(v,i._sType,t);v.mPreprocessors[t].forEach(j);}}function k(v){v.oAsyncState={};v.oAsyncState.promise=null;}var m=function(t,s){if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){var i=s.controller,N=i&&typeof i.getMetadata==="function"&&i.getMetadata().getName(),A=s.async;if(!i&&t.getControllerName){var j=t.getControllerName();if(j){var l=sap.ui.require('sap/ui/core/CustomizingConfiguration');var u=l&&l.getControllerReplacement(j,M._sOwnerId);if(u){j=typeof u==="string"?u:u.controllerName;}i=sap.ui.controller(j,true,A);}}else if(i){var O=M._sOwnerId;if(A){i=a.extendByCustomizing(i,N,A).then(function(i){return a.extendByProvider(i,N,O,A);});}else{i=a.extendByCustomizing(i,N,A);i=a.extendByProvider(i,N,O,A);}}if(i){var v=function(i){t.oController=i;i.oView=t;};if(A){if(!t.oAsyncState){throw new Error("The view "+t.sViewName+" runs in sync mode and therefore cannot use async controller extensions!");}return i.then(v);}else{v(i);}}}else{t.oController={};}};d.prototype._initCompositeSupport=function(s){this.oViewData=s.viewData;this.sViewName=s.viewName;var t=this;h(this,s);if(s.async){k(this);}var i=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(i&&i.hasCustomProperties(this.sViewName,this)){this._fnSettingsPreprocessor=function(s){var I=this.getId();if(i&&I){if(t.isPrefixedId(I)){I=I.substring((t.getId()+"--").length);}var j=i.getCustomProperties(t.sViewName,I,t);if(j){s=q.extend(s,j);}}};}var P=function(j,l){var u=sap.ui.require("sap/ui/core/Component");var O=u&&u.getOwnerComponentFor(t);if(O){if(l){t.fnScopedRunWithOwner=t.fnScopedRunWithOwner||function(v){return O.runAsOwner(v);};}return O.runAsOwner(j);}return j();};var A=function(v){if(v.oController&&v.oController.connectToView){return v.oController.connectToView(v);}};var F=function(){if(t.onControllerConnected){return t.onControllerConnected(t.oController);}};if(this.initViewSettings){if(s.async){this.oAsyncState.promise=this.initViewSettings(s).then(function(){return P(m.bind(null,t,s),true);}).then(function(){return P(F,true);}).then(function(){return A(t);}).then(function(){return t.runPreprocessor("controls",t,false);}).then(function(){return P(t.fireAfterInit.bind(t),true);}).then(function(){return t;});}else{this.initViewSettings(s);m(this,s);F();A(this);this.runPreprocessor("controls",this,true);this.fireAfterInit();}}};d.prototype.getController=function(){return this.oController;};d.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};d.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"--"+i;}return i;};d.prototype.getLocalId=function(i){var P=this.getId()+"--";return(i&&i.indexOf(P)===0)?i.slice(P.length):null;};d.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"--")===0);};d.prototype.getViewData=function(){return this.oViewData;};function n(){this.oAsyncState=null;}d.prototype.exit=function(){this.fireBeforeExit();delete this.oController;delete this.oPreprocessorInfo;if(this.oAsyncState){var D=n.bind(this);this.oAsyncState.promise.then(D,D);}};d.prototype.onAfterRendering=function(){this.fireAfterRendering();};d.prototype.onBeforeRendering=function(){this.fireBeforeRendering();};d.prototype.clone=function(i,l){var s={},K,t;for(K in this.mProperties&&!(this.isBound&&this.isBound(K))){if(this.mProperties.hasOwnProperty(K)){s[K]=this.mProperties[K];}}t=C.prototype.clone.call(this,i,l,{cloneChildren:false,cloneBindings:true});var E,u,j;for(E in t.mEventRegistry){u=t.mEventRegistry[E];for(j=u.length-1;j>=0;j--){if(u[j].oListener===this.getController()){u[j]={oListener:t.getController(),fFunction:u[j].fFunction,oData:u[j].oData};}}}t.applySettings(s);return t;};d.prototype.getPreprocessors=function(){return this.mPreprocessors;};d.prototype.getPreprocessorInfo=function(s){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!s};}if(d._supportInfo){this.oPreprocessorInfo._supportInfo=d._supportInfo;}return this.oPreprocessorInfo;};d.prototype.runPreprocessor=function(t,s,S){var v=this.getPreprocessorInfo(S),P=this.mPreprocessors&&this.mPreprocessors[t]||[],j,A,u;if(!S){A=function(v,w){return function(s){return w.preprocessor.then(function(x){return x.process(s,v,w._settings);});};};u=Promise.resolve(s);}for(var i=0,l=P.length;i<l;i++){if(S&&P[i]._syncSupport===true){j=P[i].preprocessor.process;s=j(s,v,P[i]._settings);}else if(!S){u=u.then(A(v,P[i]));}else{q.sap.log.debug("Async \""+t+"\"-preprocessor was skipped in sync view execution for "+this.getMetadata().getClass()._sType+"View",this.getId());}}return S?s:u;};function o(t,v){if(!d._mPreprocessors[v]){d._mPreprocessors[v]={};}if(!d._mPreprocessors[v][t]){d._mPreprocessors[v][t]=[];}}function p(v,s,t){d._mPreprocessors[s][t].forEach(function(P){if(P._onDemand){q.sap.log.error("Registration for \""+t+"\" failed, only one on-demand-preprocessor allowed",v.getMetadata().getName());return false;}});return true;}d.registerPreprocessor=function(t,P,v,s,O,S){if(typeof O!=="boolean"){S=O;O=false;}if(P){o(t,v);if(O&&!p(this,v,t)){return;}d._mPreprocessors[v][t].push({preprocessor:P,_onDemand:O,_syncSupport:s,_settings:S});q.sap.log.debug("Registered "+(O?"on-demand-":"")+"preprocessor for \""+t+"\""+(s?" with syncSupport":""),this.getMetadata().getName());}else{q.sap.log.error("Registration for \""+t+"\" failed, no preprocessor specified",this.getMetadata().getName());}};d.prototype.hasPreprocessor=function(t){return!!this.mPreprocessors[t].length;};sap.ui.view=function(i,v,t){var j=null,l={};if(typeof i==="object"||typeof i==="string"&&v===undefined){v=i;i=undefined;}if(v){if(typeof v==="string"){l.viewName=v;}else{l=v;}}if(i){l.id=i;}if(t){l.type=t;}var s=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(s){var u=s.getViewReplacement(l.viewName,M._sOwnerId);if(u){q.sap.log.info("Customizing: View replacement for view '"+l.viewName+"' found and applied: "+u.viewName+" (type: "+u.type+")");q.extend(l,u);}else{q.sap.log.debug("Customizing: no View replacement found for view '"+l.viewName+"'.");}}if(!l.type){throw new Error("No view type specified.");}else if(l.type===c.JS){j=r('sap/ui/core/mvc/JSView',l);}else if(l.type===c.JSON){j=r('sap/ui/core/mvc/JSONView',l);}else if(l.type===c.XML){j=r('sap/ui/core/mvc/XMLView',l);}else if(l.type===c.HTML){j=r('sap/ui/core/mvc/HTMLView',l);}else if(l.type===c.Template){j=r('sap/ui/core/mvc/TemplateView',l);}else{throw new Error("Unknown view type "+l.type+" specified.");}return j;};function r(v,i){var j=sap.ui.require(v);if(!j){j=sap.ui.requireSync(v);if(i.async){q.sap.log.warning("sap.ui.view was called without requiring the according view class.");}}return new j(i);}d.prototype.loaded=function(){if(this.oAsyncState&&this.oAsyncState.promise){return this.oAsyncState.promise;}else{return Promise.resolve(this);}};d._resolveEventHandler=function(N,i){var H;if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){switch(N.indexOf('.')){case 0:H=i&&q.sap.getObject(N.slice(1),undefined,i);break;case-1:H=i&&i[N];if(H!=null){break;}default:H=q.sap.getObject(N);}}else{H=function(){};}if(typeof H==="function"){H._sapui_handlerName=N;return[H,i];}};return d;});
