/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/IntervalTrigger','./library',"./IndexLayoutRenderer"],function(q,D,C,I,l,a){"use strict";var b=C.extend("sap.ui.demokit.IndexLayout",{metadata:{library:"sap.ui.demokit",properties:{itemWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'200px'},itemHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'200px'},enableScaling:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});b._MINMARGIN=18;b._DEFAULT_ITEM_HEIGHT=200;b._DEFAULT_ITEM_WIDTH=200;b._pos=null;(function(){b._IntervalTrigger=new I(300);b.prototype.init=function(){this._itemWidth=b._DEFAULT_ITEM_WIDTH;this._itemHeight=b._DEFAULT_ITEM_HEIGHT;this._tilesPerRow;this._width;this._registered=false;this._itemScaleFactor=1;D.media.attachHandler(s,this,D.media.RANGESETS.SAP_STANDARD);};b.prototype.exit=function(){this.onBeforeRendering();D.media.detachHandler(s,this,D.media.RANGESETS.SAP_STANDARD);};b.prototype.setItemWidth=function(i){this.setProperty("itemWidth",i,true);if(!i||i.indexOf("px")<0){this._itemWidth=b._DEFAULT_ITEM_WIDTH;this.setProperty("itemWidth",this._itemWidth,true);}else{this._itemWidth=parseInt(i,10);}_(this);return this;};b.prototype.setItemHeight=function(i){this.setProperty("itemHeight",i,true);if(!i||i.indexOf("px")<0){this._itemHeight=b._DEFAULT_ITEM_HEIGHT;this.setProperty("itemHeight",this._itemHeight,true);}else{this._itemHeight=parseInt(i,10);}_(this);return this;};b.prototype.setEnableScaling=function(e){this.setProperty("enableScaling",e,true);_(this);return this;};b.prototype.onBeforeRendering=function(){if(this._registered){b._IntervalTrigger.removeListener(r,this);this._registered=false;}var m=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD);s.apply(this,[m,true]);};b.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};b.prototype.onAfterRendering=function(){if(!b._pos){var t=null;var S=this.getDomRef().style;if("webkitTransform"in S){t="-webkit-transform";}else if("transform"in S){t="transform";}else if("msTransform"in S){t="-ms-transform";}else if("MozTransform"in S){t="-moz-transform";}if(t){b._pos=function($,x,y){$.css(t,"translate("+x+"px,"+y+"px)");};}else{b._pos=function($,x,y){$.css({top:y+"px",left:x+"px"});};}}if(!this._registered){b._IntervalTrigger.addListener(r,this);this._registered=true;}this.$().toggleClass("sapDkIdxLayoutHidden",false);};b.prototype._scale=function(v){if(!this.getEnableScaling()){return v;}return Math.floor(v*this._itemScaleFactor);};function _(L,n){r.apply(L,[!n]);}function r(i){if(!this.getDomRef()){this.onBeforeRendering();return;}i=i||!this._registered;var L=this.$(),w=L.outerWidth(),h=L.outerHeight(),c=this._height!=h;if(this._width===w&&!c&&!i){return;}this._width=w;this._height=h;var d=this.getContent().length,e=this._scale(this._itemWidth),f=this._scale(this._itemHeight),t=g(this._width,d,e),j=this._tilesPerRow!=t;this._tilesPerRow=t;if(!i){L.toggleClass("sapDkIdxLayoutAnim",true);}if(!j&&!i&&!c){return;}var k=0,m=0;this.$("cntnt").css({"padding-left":b._MINMARGIN+"px","width":(t*e+b._MINMARGIN*2)+"px","height":Math.ceil(d/t)*f}).children().each(function(n){if(n>0&&n%t===0){k=k+f;m=0;}b._pos(q(this),m,k);m=m+e;});if(i){L.css({"padding-top":b._MINMARGIN+"px","padding-bottom":b._MINMARGIN+"px"});}}function g(c,d,e){var t=Math.min(Math.floor((c-2*b._MINMARGIN)/e),d);var f=d%t;if(f==0||d<=t){return t;}function h(x){var n=d%x;return(t-x)*Math.floor(d/x)+(n!=0?(t-n):0);}var j=h(t);var k=[t];var i;for(i=t-1;i>=1;i--){var w=h(i);if(w<j){k=[i];j=w;}else if(w==j){k.push(i);}}for(i=0;i<k.length;i++){var m=d%k[i];if(m==0){return k[i];}else if(i==0||m>j){j=m;t=k[i];}}return t;}function s(m,S){switch(m.name){case"Tablet":this._itemScaleFactor=0.75;break;case"Phone":this._itemScaleFactor=0.5;break;default:this._itemScaleFactor=1;}if(!this.getDomRef()||S){return;}var w=this._scale(this._itemWidth);var h=this._scale(this._itemHeight);this.$("cntnt").children().each(function(){q(this).css({width:w,height:h});});_(this);}C.extend("sap.ui.demokit.IndexLayout._Tile",{metadata:{properties:{"title":"string","description":"string","target":"string","icon":"sap.ui.core.URI","href":"sap.ui.core.URI"},events:{"press":{}}},onclick:function(e){if(!this.getHref()){this.firePress();e.preventDefault();}},renderer:function(R,c){R.write("<a");R.addClass("sapDkIdxLayout_Tile");R.writeClasses();R.writeControlData(c);if(c.getHref()){R.writeAttributeEscaped("href",c.getHref());if(c.getTarget()){R.writeAttributeEscaped("target",c.getTarget());}}else{R.writeAttribute("href","#");}R.writeAttributeEscaped("title",c.getDescription());R.write(">");R.write("<span class='sapDkIdxLayout_TileIcon'>");R.writeIcon(c.getIcon());R.write("</span>");R.write("<span class='sapDkIdxLayout_TileLabel'");R.writeAttributeEscaped("title",c.getTitle());R.write(">");R.writeEscaped(c.getTitle());R.write("</span>");R.write("<span class='sapDkIdxLayout_TileDesc'");R.writeAttributeEscaped("title",c.getDescription());R.write(">");R.writeEscaped(c.getDescription());R.write("</span>");R.write("</a>");}});})();return b;});
