/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/dt/Plugin','sap/ui/dt/DOMUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayRegistry'],function(P,D,O,E,a){"use strict";var b=P.extend("sap.ui.dt.plugin.DragDrop",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});var I=7;var _=false;var p=false;var o;b.prototype._preventScrollOnTouch=function(f){if(p){f.preventDefault();}};b.prototype.init=function(){P.prototype.init.apply(this,arguments);document.addEventListener('touchmove',this._preventScrollOnTouch,true);this._dragScrollHandler=this._dragScroll.bind(this);this._dragLeaveHandler=this._dragLeave.bind(this);this._mScrollIntervals={};};b.prototype.exit=function(){P.prototype.exit.apply(this,arguments);document.removeEventListener('touchmove',this._preventScrollOnTouch);delete this._mElementOverlayDelegate;delete this._mAggregationOverlayDelegate;delete this._dragScrollHandler;};b.prototype.registerElementOverlay=function(f){f.attachEvent("movableChange",this._onMovableChange,this);if(f.isMovable()){this._attachDragEvents(f);}f.attachBrowserEvent("dragover",this._onDragOver,this);f.attachBrowserEvent("dragenter",this._onDragEnter,this);f.attachBrowserEvent("dragleave",this._onDragLeave,this);};b.prototype.registerAggregationOverlay=function(A){A.attachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._attachDragScrollHandler(A);}};b.prototype.deregisterElementOverlay=function(f){f.detachEvent("movableChange",this._onMovableChange,this);this._detachDragEvents(f);f.detachBrowserEvent("dragover",this._onDragOver,this);f.detachBrowserEvent("dragenter",this._onDragEnter,this);f.detachBrowserEvent("dragleave",this._onDragLeave,this);};b.prototype.deregisterAggregationOverlay=function(A){A.detachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._removeDragScrollHandler(A);this._clearScrollIntervalFor(A.$().attr("id"));}};b.prototype._attachDragEvents=function(f){f.attachBrowserEvent("dragstart",this._onDragStart,this);f.attachBrowserEvent("drag",this._onDrag,this);f.attachBrowserEvent("dragend",this._onDragEnd,this);f.attachBrowserEvent("touchstart",this._onTouchStart,this);};b.prototype._detachDragEvents=function(f){f.detachBrowserEvent("dragstart",this._onDragStart,this);f.detachBrowserEvent("drag",this._onDrag,this);f.detachBrowserEvent("dragend",this._onDragEnd,this);f.detachBrowserEvent("touchstart",this._onTouchStart,this);};b.prototype.onMovableChange=function(f){};b.prototype.onDragStart=function(f){};b.prototype.onDragEnd=function(f){};b.prototype.onDrag=function(f){};b.prototype.onDragEnter=function(f){};b.prototype.onDragLeave=function(f){};b.prototype.onDragOver=function(f){};b.prototype.onAggregationDragEnter=function(A){};b.prototype.onAggregationDragOver=function(A){};b.prototype.onAggregationDragLeave=function(A){};b.prototype.onAggregationDrop=function(A){};b.prototype._checkMovable=function(f){if(f.isMovable()||D.getDraggable(f.$())!==undefined){D.setDraggable(f.$(),f.isMovable());}};b.prototype._onMovableChange=function(f){var g=f.getSource();if(g.isMovable()){this._attachDragEvents(g);}else{this._detachDragEvents(g);}this.onMovableChange(g);};b.prototype._onDragStart=function(f){var g=a.getOverlay(f.currentTarget.id);f.stopPropagation();if(sap.ui.Device.browser.firefox&&f&&f.originalEvent&&f.originalEvent.dataTransfer&&f.originalEvent.dataTransfer.setData){f.originalEvent.dataTransfer.setData('text/plain','');}_=true;this.showGhost(g,f);this.onDragStart(g);};b.prototype._attachTouchDragEvents=function(f){f.attachBrowserEvent("touchmove",this._onTouchMove,this);f.attachBrowserEvent("touchend",this._onTouchEnd,this);};b.prototype._detachTouchDragEvents=function(f){f.detachBrowserEvent("touchmove",this._onTouchMove,this);f.detachBrowserEvent("touchend",this._onTouchEnd,this);};b.prototype._onTouchStart=function(f){var t=f.touches[0].pageX;var g=f.touches[0].pageY;var T,h;var i=a.getOverlay(f.currentTarget.id);var j=function(){i.detachBrowserEvent("touchmove",T,this);i.detachBrowserEvent("touchend",h,this);i.detachBrowserEvent("contextmenu",h,this);};var G=function(k,l){var m=t-k;var n=g-l;return Math.sqrt((m*m)+(n*n));};T=function(f){var k=f.touches[0].pageX;var l=f.touches[0].pageY;var m=G(k,l);if(m>I){this.onDragStart(i);j.call(this);this._attachTouchDragEvents(i);}};h=function(f){j.call(this);p=false;};p=true;f.stopPropagation();i.attachBrowserEvent("touchmove",T,this);i.attachBrowserEvent("contextmenu",h,this);i.attachBrowserEvent("touchend",h,this);};b.prototype._getTargetOverlay=function(f){if(f&&E.isInstanceOf(f,"sap.ui.dt.Overlay")){var t;if(E.isInstanceOf(f,"sap.ui.dt.AggregationOverlay")&&f.getTargetZone()){t=f;}else if(O.isInTargetZoneAggregation(f)){t=f;}return t?t:this._getTargetOverlay(f.getParent());}};b.prototype._findTargetOverlayFromCoordinates=function(f,g){var h=document.elementFromPoint(f,g);var i=h?sap.ui.getCore().byId(h.id):undefined;return this._getTargetOverlay(i);};b.prototype._onTouchMove=function(f){var g=a.getOverlay(f.currentTarget.id);this.onDrag(g);var t=f.touches||f.changedTouches;var h=t[0].pageX;var i=t[0].pageY;var T=this._findTargetOverlayFromCoordinates(h,i);if(!T){return;}if(T!==o){if(o){if(E.isInstanceOf(o,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragLeave(o);}else{this.onDragLeave(o);}}o=T;if(E.isInstanceOf(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragEnter(T);}else{this.onDragEnter(T);}}if(E.isInstanceOf(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragOver(T);}else{this.onDragOver(T);}f.stopPropagation();};b.prototype._getValidTargetZoneAggregationOverlay=function(f){if(E.isInstanceOf(f,"sap.ui.dt.AggregationOverlay")&&f.getTargetZone()){return f;}else{return this._getValidTargetZoneAggregationOverlay(f.getParent());}};b.prototype._onTouchEnd=function(f){var g=a.getOverlay(f.currentTarget.id);var A=this._getValidTargetZoneAggregationOverlay(g);if(A){this.onAggregationDrop(A);}this.onDragEnd(g);this._detachTouchDragEvents(g);o=undefined;p=false;};b.prototype.showGhost=function(f,g){if(g&&g.originalEvent&&g.originalEvent.dataTransfer){g.originalEvent.dataTransfer.effectAllowed="move";g.originalEvent.dataTransfer.dropEffect="move";if(!sap.ui.Device.browser.internet_explorer&&!sap.ui.Device.browser.edge&&!sap.ui.Device.browser.msie&&g.originalEvent.dataTransfer.setDragImage){this._$ghost=this.createGhost(f,g);this._$ghost.appendTo("#overlay-container");setTimeout(function(){this._removeGhost();}.bind(this),0);g.originalEvent.dataTransfer.setDragImage(this._$ghost.get(0),g.originalEvent.pageX-f.$().offset().left,g.originalEvent.pageY-f.$().offset().top);}}};b.prototype._removeGhost=function(){this.removeGhost();delete this._$ghost;};b.prototype.removeGhost=function(){var $=this.getGhost();if($){$.remove();}};b.prototype.createGhost=function(f){var g=f.getAssociatedDomRef();var $;if(!g){g=this._getAssociatedDomCopy(f);$=g;}else{$=jQuery("<div></div>");jQuery.makeArray(g).forEach(function(n){D.cloneDOMAndStyles(n,$);});}var h=jQuery("<div></div>").addClass("sapUiDtDragGhostWrapper");return h.append($.addClass("sapUiDtDragGhost"));};b.prototype._getAssociatedDomCopy=function(f){var $=jQuery("<div></div>");f.getAggregationOverlays().forEach(function(A){A.getChildren().forEach(function(C){var g=C.getAssociatedDomRef();if(g){D.cloneDOMAndStyles(g,$);}else{D.cloneDOMAndStyles(this._getAssociatedDomCopy(C),$);}},this);},this);return $;};b.prototype.getGhost=function(){return this._$ghost;};b.prototype._onDragEnd=function(f){_=false;var g=a.getOverlay(f.currentTarget.id);this._removeGhost();this._clearAllScrollIntervals();this.onDragEnd(g);f.stopPropagation();};b.prototype._onDrag=function(f){var g=a.getOverlay(f.currentTarget.id);this.onDrag(g);f.stopPropagation();};b.prototype._onDragEnter=function(f){var g=a.getOverlay(f.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragEnter(g)){f.stopPropagation();}}f.preventDefault();};b.prototype._onDragLeave=function(f){var g=a.getOverlay(f.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragLeave(g)){f.stopPropagation();}}f.preventDefault();};b.prototype._onDragOver=function(f){var g=a.getOverlay(f.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragOver(g)){f.stopPropagation();}}f.preventDefault();};b.prototype._onAggregationTargetZoneChange=function(f){var A=f.getSource();var t=f.getParameter("targetZone");if(t){this._attachAggregationOverlayEvents(A);}else{this._detachAggregationOverlayEvents(A);}};b.prototype._attachAggregationOverlayEvents=function(A){A.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.attachBrowserEvent("dragover",this._onAggregationDragOver,this);A.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.attachBrowserEvent("drop",this._onAggregationDrop,this);};b.prototype._detachAggregationOverlayEvents=function(A){A.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.detachBrowserEvent("dragover",this._onAggregationDragOver,this);A.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.detachBrowserEvent("drop",this._onAggregationDrop,this);};b.prototype._onAggregationDragEnter=function(f){var A=a.getOverlay(f.currentTarget.id);this.onAggregationDragEnter(A);f.preventDefault();f.stopPropagation();};b.prototype._onAggregationDragOver=function(f){var A=a.getOverlay(f.currentTarget.id);this.onAggregationDragOver(A);f.preventDefault();f.stopPropagation();};b.prototype._onAggregationDragLeave=function(f){var A=a.getOverlay(f.currentTarget.id);this.onAggregationDragLeave(A);f.preventDefault();f.stopPropagation();};b.prototype._onAggregationDrop=function(f){var A=a.getOverlay(f.currentTarget.id);this.onAggregationDrop(A);f.preventDefault();f.stopPropagation();};var c=100;var d=20;var e=50;b.prototype._clearScrollInterval=function(s,f){if(this._mScrollIntervals[s]){window.clearInterval(this._mScrollIntervals[s][f]);delete this._mScrollIntervals[s][f];}};b.prototype._clearScrollIntervalFor=function(s){if(this._mScrollIntervals[s]){Object.keys(this._mScrollIntervals[s]).forEach(function(f){this._clearScrollInterval(s,f);},this);}};b.prototype._clearAllScrollIntervals=function(){Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));};b.prototype._checkScroll=function($,s,i){var S;var f;var g=1;if(s==="top"||s==="bottom"){S=$.height();f=$.scrollTop.bind($);}else{S=$.width();f=$.scrollLeft.bind($);}if(s==="top"||s==="left"){g=-1;}var h=Math.floor(S/4);var t=c;if(h<c){t=h;}if(i<t){this._mScrollIntervals[$.attr("id")]=this._mScrollIntervals[$.attr("id")]||{};if(!this._mScrollIntervals[$.attr("id")][s]){this._mScrollIntervals[$.attr("id")][s]=window.setInterval(function(){var j=f();f(j+g*d);},e);}}else{this._clearScrollInterval($.attr("id"),s);}};b.prototype._dragLeave=function(f){var A=a.getOverlay(f.currentTarget.id);this._clearScrollIntervalFor(A.$().attr("id"));};b.prototype._dragScroll=function(f){var A=a.getOverlay(f.currentTarget.id);var $=A.$();var i=f.clientX;var g=f.clientY;var h=$.offset();var H=$.height();var w=$.width();var t=h.top;var l=h.left;var B=t+H;var r=l+w;this._checkScroll($,"bottom",B-g);this._checkScroll($,"top",g-t);this._checkScroll($,"right",r-i);this._checkScroll($,"left",i-l);};b.prototype._attachDragScrollHandler=function(f){var A;if(E.isInstanceOf(f,"sap.ui.dt.AggregationOverlay")){A=f;}else{A=f.srcControl;}if(D.hasScrollBar(A.$())){A.getDomRef().addEventListener("dragover",this._dragScrollHandler,true);A.getDomRef().addEventListener("dragleave",this._dragLeaveHandler,true);}};b.prototype._removeDragScrollHandler=function(f){var A;if(E.isInstanceOf(f,"sap.ui.dt.AggregationOverlay")){A=f;}else{A=f.srcControl;}var g=A.getDomRef();if(g){g.removeEventListener("dragover",this._dragScrollHandler,true);}};b.prototype.isBusy=function(){return _;};return b;},true);
