/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/changeHandler/BaseTreeModifier","sap/ui/base/DataType","sap/ui/core/XMLTemplateProcessor","sap/ui/fl/Utils"],function(B,D,X,U){"use strict";var a={targets:"xmlTree",setVisible:function(c,v){if(v){c.removeAttribute("visible");}else{this.setProperty(c,"visible",v);}},getVisible:function(c){return this.getProperty(c,"visible");},setStashed:function(c,s){if(!s){c.removeAttribute("stashed");}else{this.setProperty(c,"stashed",s);}this.setVisible(c,!s);},getStashed:function(c){return this.getProperty(c,"stashed");},bindProperty:function(c,p,b){c.setAttribute(p,"{"+b+"}");},setProperty:function(c,p,P){c.setAttribute(p,P);},getProperty:function(c,p){var P=this._getControlMetadata(c).getProperty(p);var v=c.getAttribute(p);if(P){var t=P.getType();if(v===null){v=P.getDefaultValue()||t.getDefaultValue();}else{v=t.parseValue(v);}}return v;},setPropertyBinding:function(c,p,P){c.setAttribute(p,P);},getPropertyBinding:function(c,p){return c.getAttribute(p);},createControl:function(c,A,v,s,S){var i,l;if(!this.bySelector(s,A,v)){var C=c.split('.');var n="";if(C.length>1){l=C.pop();n=C.join('.');}var N=v.ownerDocument.createElementNS(n,l);i=this.getControlIdBySelector(s,A);if(i){N.setAttribute("id",i);}if(S){var V;Object.keys(S).forEach(function(k){V=S[k];N.setAttribute(k,V);});}return N;}else{throw new Error("Can't create a control with duplicated id "+i);}},_byId:function(i,v){if(v){if(v.ownerDocument&&v.ownerDocument.getElementById&&v.ownerDocument.getElementById(i)){return v.ownerDocument.getElementById(i);}else{return v.querySelector("[id='"+i+"']");}var n=jQuery.sap.byId(i,v);if(n.length===1){return n[0];}}},getId:function(c){return c.getAttribute("id");},getParent:function(c){var p=c.parentNode;if(!this.getId(p)){p=p.parentNode;}return p;},_getLocalName:function(x){return x.localName||x.baseName||x.nodeName;},getControlType:function(c){var C=c.namespaceURI;C=(C?C+".":"");C+=this._getLocalName(c);return C;},getAllAggregations:function(c){var C=this._getControlMetadata(c);return C.getAllAggregations();},getAggregation:function(p,n){var A=this._findAggregationNode(p,n);var s=this._isSingleValueAggregation(p,n);if(!A){if(s&&this._isAltTypeAggregation(p,n)){return this.getProperty(p,n);}return s?undefined:[];}var c=this._getControlsInAggregation(p,A);if(s){return c[0];}return c;},insertAggregation:function(p,n,o,i,v){var A=this._findAggregationNode(p,n);if(!A){var N=p.namespaceURI;A=this.createControl(N+"."+n,undefined,v);p.appendChild(A);}if(i>=A.childElementCount){A.appendChild(o);}else{var r=this._getControlsInAggregation(p,A)[i];A.insertBefore(o,r);}},removeAggregation:function(p,n,o){var A=this._findAggregationNode(p,n);A.removeChild(o);},removeAllAggregation:function(c,n){var A=this._findAggregationNode(c,n);if(c===A){var C=this._getControlsInAggregation(c,c);C.forEach(function(o){c.removeChild(o);});}else{c.removeChild(A);}},_findAggregationNode:function(p,n){var A;var c=this._children(p);for(var i=0;i<c.length;i++){var N=c[i];if(N.localName===n){A=N;break;}}if(!A&&this._isDefaultAggregation(p,n)){A=p;}return A;},_isDefaultAggregation:function(p,A){var c=this._getControlMetadata(p);var d=c.getDefaultAggregation();return d&&A===d.name;},_isNotNamedAggregationNode:function(p,c){var A=this.getAllAggregations(p);var o=A[c.localName];return p.namespaceURI!==c.namespaceURI||!o;},_isSingleValueAggregation:function(p,A){var m=this.getAllAggregations(p);var o=m[A];return!o.multiple;},_isAltTypeAggregation:function(p,A){var c=this._getControlMetadata(p);var o=c.getAllAggregations()[A];return!!o.altTypes;},_getControlMetadata:function(c){var C=this.getControlType(c);jQuery.sap.require(C);var b=jQuery.sap.getObject(C);return b.getMetadata();},_getControlsInAggregation:function(p,A){var c=Array.prototype.slice.call(this._children(A));return c.filter(this._isNotNamedAggregationNode.bind(this,p));},_children:function(p){if(p.children){return p.children;}else{var c=[];for(var i=0;i<p.childNodes.length;i++){var n=p.childNodes[i];if(n.nodeType===n.ELEMENT_NODE){c.push(n);}}return c;}},getBindingTemplate:function(c,A){var o=this._findAggregationNode(c,A);if(o&&this._children(o).length===1){return this._children(o)[0];}},updateAggregation:function(c,A){},findIndexInParentAggregation:function(c){var p,A,C;p=this.getParent(c);if(!p){return-1;}A=this.getParentAggregationName(c,p);C=this.getAggregation(p,A);if(Array.isArray(C)){return C.indexOf(c);}else{return 0;}},getParentAggregationName:function(c,p){var n,A;if(!p.isSameNode(c.parentNode)){n=false;}else{n=this._isNotNamedAggregationNode(p,c);}if(n){A=this._getControlMetadata(p).getDefaultAggregationName();}else{A=this._getLocalName(c.parentNode);}return A;},findAggregation:function(c,A){var m=this._getControlMetadata(c);var o=m.getAllAggregations();if(o){return o[A];}},validateType:function(c,A,p,f,i){var t=A.type;if(A.multiple===false&&this.getAggregation(p,A.name)&&this.getAggregation(p,A.name).length>0){return false;}var C=sap.ui.xmlfragment({fragmentContent:f});if(!Array.isArray(C)){C=[C];}var r=U.isInstanceOf(C[i],t)||U.hasInterface(C[i],t);C.forEach(function(F){F.destroy();});return r;},instantiateFragment:function(f,c){var F=jQuery.sap.parseXML(f,"application/xml");if(F.parseError.errorCode!==0){throw new Error("The XML Fragment could not be instantiated. Reason: "+F.parseError.reason);}var C=F.documentElement;if(C.localName==="FragmentDefinition"){var N=C.childNodes,b=[];for(var i=0,n=N.length;i<n;i++){if(N[i].nodeType===1){b.push(N[i]);}}for(var j=0,m=b.length;j<m;j++){b[j].setAttribute("id",c+"--"+b[j].getAttribute("id"));}return b;}else{C.setAttribute("id",c+"--"+C.getAttribute("id"));return[C];}},getChangeHandlerModulePath:function(c){if(!c){return undefined;}return c.getAttributeNS("sap.ui.fl","flexibility");}};return jQuery.sap.extend(true,{},B,a);},true);
