/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/SyncPromise","./_Helper"],function(q,S,_){"use strict";var r=/^([^(]*)(\(.*\))$/;function a(m,p,e,D){if(e.$count!==undefined){s(m,p,e,e.$count+D);}}function g(e){return e.$count!==undefined?e.$count:Infinity;}function b(R,p){return p===""||R===p||R.indexOf(p+"/")===0;}function s(m,p,e,v){if(typeof v==="string"){v=parseInt(v,10);}_.updateCache(m,p,e,{$count:v});}function C(R,e,Q,f){this.bActive=true;this.mChangeListeners={};this.sMetaPath=_.getMetaPath("/"+e);this.mPatchRequests={};this.mPostRequests={};this.oRequestor=R;this.bSortExpandSelect=f;this.sResourcePath=e;this.bSentReadRequest=false;this.oTypePromise=undefined;this.setQueryOptions(Q);}C.prototype._delete=function(G,e,p,f){var h=p.split("/"),D=h.pop(),i=h.join("/"),t=this;return this.fetchValue(G,i).then(function(v){var E=D?v[D]:v,H,T=E["@$ui5.transient"];if(T===true){throw new Error("No 'delete' allowed while waiting for server response");}if(T){t.oRequestor.removePost(T,E);return Promise.resolve();}if(E["$ui5.deleting"]){throw new Error("Must not delete twice: "+e);}E["$ui5.deleting"]=true;H={"If-Match":E["@odata.etag"]};e+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return t.oRequestor.request("DELETE",e,G,H)["catch"](function(o){if(o.status!==404){delete E["$ui5.deleting"];throw o;}}).then(function(){if(Array.isArray(v)){if(v[D]!==E){D=v.indexOf(E);}if(D==="-1"){delete v[-1];}else{if(E["@$ui5.predicate"]){delete v.$byPredicate[E["@$ui5.predicate"]];}v.splice(D,1);}a(t.mChangeListeners,i,v,-1);t.iLimit-=1;f(Number(D),v);}else{if(D){v[D]=null;}else{E["$ui5.deleted"]=true;}f();}});});};C.prototype.addByPath=function(m,p,i){if(i){if(!m[p]){m[p]=[i];}else if(m[p].indexOf(i)<0){m[p].push(i);}}};C.prototype.calculateKeyPredicates=function(R,t){function v(I,m){var i,o,p;I.$byPredicate={};for(i=0;i<I.length;i++){o=I[i];e(o,m);p=o["@$ui5.predicate"];if(p){I.$byPredicate[p]=o;}}}function e(i,m){var T=t[m];if(T&&T.$Key){i["@$ui5.predicate"]=_.getKeyPredicate(i,m,t);}Object.keys(i).forEach(function(p){var f=i[p],h=m+"/"+p;if(Array.isArray(f)){v(f,h);}else if(f&&typeof f==="object"){e(f,h);}});}e(R,this.sMetaPath);};C.prototype.checkActive=function(){var e;if(!this.bActive){e=new Error("Response discarded: cache is inactive");e.canceled=true;throw e;}};C.prototype.create=function(G,p,e,E,f,h){var i,t=this;function j(){t.removeByPath(t.mPostRequests,e,E);delete i[-1];f();}function k(){E["@$ui5.transient"]=true;}function l(m,n){E["@$ui5.transient"]=n;t.addByPath(t.mPostRequests,e,E);return t.oRequestor.request("POST",m,n,null,E,k,j).then(function(R){delete E["@$ui5.transient"];a(t.mChangeListeners,e,i,1);t.removeByPath(t.mPostRequests,e,E);_.updateCacheAfterPost(t.mChangeListeners,_.buildPath(e,"-1"),E,R,_.getSelectForPath(t.mQueryOptions,e));t.fetchTypes().then(function(T){E["@$ui5.predicate"]=_.getKeyPredicate(E,_.getMetaPath(_.buildPath(t.sMetaPath,e)),T);});},function(o){if(o.canceled){throw o;}if(h){h(o);}return l(m,t.oRequestor.getGroupSubmitMode(n)==="API"?n:"$parked."+n);});}E=q.extend(true,{},E);i=this.fetchValue("$cached",e).getResult();if(!Array.isArray(i)){throw new Error("Create is only supported for collections; '"+e+"' does not reference a collection");}i[-1]=E;return S.resolve(p).then(function(m){m+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return l(m,G);});};C.prototype.deregisterChange=function(p,l){this.removeByPath(this.mChangeListeners,p,l);};C.prototype.drillDown=function(D,p){var t=this;function e(f){q.sap.log.error("Failed to drill-down into "+p+", invalid segment: "+f,t.toString(),"sap.ui.model.odata.v4.lib._Cache");return undefined;}function m(v,f,i){var h="",j,R,k;if(p[0]!=='('){h+="/";}h+=p.split("/").slice(0,i).join("/");j=t.oRequestor.fetchTypeForPath(t.sMetaPath+_.getMetaPath(h),true).getResult();if(j==="Edm.Stream"){R=v[f+"@odata.mediaReadLink"];k=t.oRequestor.getServiceUrl();if(R){return _.makeAbsolute(R,k);}return k+t.sResourcePath+h;}return e(f);}if(!p){return D;}return p.split("/").reduce(function(v,f,i){var M,o;if(f==="$count"){return Array.isArray(v)?v.$count:e(f);}if(v===undefined||v===null){return undefined;}if(typeof v!=="object"){return e(f);}o=v;M=r.exec(f);if(M){if(M[1]){v=v[M[1]];}if(v){v=v.$byPredicate[M[2]];}}else{v=v[f];}return v===undefined&&f[0]!=="#"?m(o,f,i+1):v;},D);};C.prototype.fetchTypes=function(){var p,t,e=this;function f(B,Q){if(Q&&Q.$expand){Object.keys(Q.$expand).forEach(function(n){var m=B;n.split("/").forEach(function(i){m+="/"+i;h(m);});f(m,Q.$expand[n]);});}}function h(m){p.push(e.oRequestor.fetchTypeForPath(m).then(function(T){t[m]=T;if(T&&T.$Key){T.$Key.forEach(function(k){var i,K;if(typeof k!=="string"){K=k[Object.keys(k)[0]];i=K.lastIndexOf("/");if(i>=0){h(m+"/"+K.slice(0,i));}}});}}));}if(!this.oTypePromise){p=[];t={};h(this.sMetaPath);f(this.sMetaPath,this.mQueryOptions);this.oTypePromise=S.all(p).then(function(){return t;});}return this.oTypePromise;};C.prototype.hasPendingChangesForPath=function(p){return Object.keys(this.mPatchRequests).some(function(R){return b(R,p);})||Object.keys(this.mPostRequests).some(function(R){return b(R,p);});};C.prototype.registerChange=function(p,l){this.addByPath(this.mChangeListeners,p,l);};C.prototype.removeByPath=function(m,p,i){var I=m[p],e;if(I){e=I.indexOf(i);if(e>=0){if(I.length===1){delete m[p];}else{I.splice(e,1);}}}};C.prototype.resetChangesForPath=function(p){var t=this;Object.keys(this.mPatchRequests).forEach(function(R){var i,e;if(b(R,p)){e=t.mPatchRequests[R];for(i=e.length-1;i>=0;i--){t.oRequestor.removePatch(e[i]);}delete t.mPatchRequests[R];}});Object.keys(this.mPostRequests).forEach(function(R){var e,i,T;if(b(R,p)){e=t.mPostRequests[R];for(i=e.length-1;i>=0;i--){T=e[i]["@$ui5.transient"];if(T){t.oRequestor.removePost(T,e[i]);}}delete t.mPostRequests[R];}});};C.prototype.setActive=function(A){this.bActive=A;if(!A){this.mChangeListeners={};}};C.prototype.setQueryOptions=function(Q){if(this.bSentReadRequest){throw new Error("Cannot set query options: Cache has already sent a read request");}this.mQueryOptions=Q;this.sQueryString=this.oRequestor.buildQueryString(this.sMetaPath,Q,false,this.bSortExpandSelect);};C.prototype.toString=function(){return this.oRequestor.getServiceUrl()+this.sResourcePath+this.sQueryString;};C.prototype.update=function(G,p,v,e,E,f,u){var h=p.split("/"),U,t=this;return this.fetchValue(G,f).then(function(o){var F=_.buildPath(f,p),O,i,j,T,k,l=C.makeUpdateData(h,v);function m(){t.removeByPath(t.mPatchRequests,F,i);_.updateCache(t.mChangeListeners,f,o,C.makeUpdateData(h,O));}function n(){i=t.oRequestor.request("PATCH",E,G,{"If-Match":o["@odata.etag"]},l,undefined,m);t.addByPath(t.mPatchRequests,F,i);return i.then(function(w){t.removeByPath(t.mPatchRequests,F,i);_.updateCache(t.mChangeListeners,f,o,w);return w;},function(w){t.removeByPath(t.mPatchRequests,F,i);if(!w.canceled){e(w);if(t.oRequestor.getGroupSubmitMode(G)==="API"){return n();}}throw w;});}if(!o){throw new Error("Cannot update '"+p+"': '"+f+"' does not exist");}T=o["@$ui5.transient"];if(T){if(T===true){throw new Error("No 'update' allowed while waiting for server response");}if(T.indexOf("$parked.")===0){j=T;T=T.slice(8);}if(T!==G){throw new Error("The entity will be created via group '"+T+"'. Cannot patch via group '"+G+"'");}}O=_.drillDown(o,h);_.updateCache(t.mChangeListeners,f,o,l);if(u){U=u.split("/");k=_.drillDown(o,U);if(k===undefined){q.sap.log.debug("Missing value for unit of measure "+_.buildPath(f,u)+" when updating "+F,t.toString(),"sap.ui.model.odata.v4.lib._Cache");}else{q.extend(true,l,C.makeUpdateData(U,k));}}if(T){if(j){o["@$ui5.transient"]=T;t.oRequestor.relocate(j,o,T);}return Promise.resolve({});}E+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return n();});};function c(R,e,Q,f){C.apply(this,arguments);this.sContext=undefined;this.aElements=[];this.aElements.$byPredicate={};this.aElements.$count=undefined;this.aElements.$tail=undefined;this.iLimit=Infinity;this.oSyncPromiseAll=undefined;}c.prototype=Object.create(C.prototype);c.prototype.fetchValue=function(G,p,D,l){var e,t=this;if(!this.oSyncPromiseAll){e=this.aElements.$tail?this.aElements.concat(this.aElements.$tail):this.aElements;this.oSyncPromiseAll=S.all(e);}return this.oSyncPromiseAll.then(function(){t.checkActive();t.registerChange(p,l);return t.drillDown(t.aElements,p);});};c.prototype.fill=function(p,e,E){var i,n=Math.max(this.aElements.length,1024);if(E>n){if(this.aElements.$tail&&p){throw new Error("Cannot fill from "+e+" to "+E+", $tail already in use, # of elements is "+this.aElements.length);}this.aElements.$tail=p;E=this.aElements.length;}for(i=e;i<E;i++){this.aElements[i]=p;}this.oSyncPromiseAll=undefined;};c.prototype.getReadRange=function(e,l,p){var E=this.aElements;function f(e,h){var i;for(i=e;i<h;i+=1){if(E[i]===undefined){return true;}}return false;}if(f(e+l,e+l+p/2)){l+=p;}if(f(Math.max(e-p/2,0),e)){l+=p;e-=p;if(e<0){l+=e;if(isNaN(l)){l=Infinity;}e=0;}}return{length:l,start:e};};c.prototype.read=function(I,l,p,G,D){var i,n,e,E,f=-1,L=this.aElements[-1]?-1:0,R,h=Math.max(I,0),t=this;if(I<L){throw new Error("Illegal index "+I+", must be >= "+L);}if(l<0){throw new Error("Illegal length "+l+", must be >= 0");}if(this.aElements.$tail){return this.aElements.$tail.then(function(){return t.read(I,l,p,G,D);});}R=this.getReadRange(I,l,p);E=Math.min(R.start+R.length,this.iLimit);n=Math.min(E,Math.max(R.start,this.aElements.length)+1);for(i=R.start;i<n;i++){if(this.aElements[i]!==undefined){if(f>=0){this.requestElements(f,i,G,D);D=undefined;f=-1;}}else if(f<0){f=i;}}if(f>=0){this.requestElements(f,E,G,D);}e=this.aElements.slice(h,E);if(this.aElements.$tail){e.push(this.aElements.$tail);}return S.all(e).then(function(){var o;t.checkActive();o={"@odata.context":t.sContext,value:t.aElements.slice(h,E)};o.value.$count=t.aElements.$count;if(I===-1){o.value.unshift(t.aElements[-1]);}return o;});};c.prototype.requestElements=function(e,E,G,D){var f=this.sQueryString?"&":"?",h=E-e,p,R=this.sResourcePath+this.sQueryString,t=this;if(e>0||h<Infinity){R+=f+"$skip="+e;f="&";}if(h<Infinity){R+=f+"$top="+h;}p=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D),this.fetchTypes()]).then(function(j){var k,l,o,i,m,n=j[0],u=n.value.length;if(t.aElements.$tail===p){t.aElements.$tail=undefined;}C.computeCount(n);t.sContext=n["@odata.context"];l=n["@odata.count"];if(l){t.iLimit=parseInt(l,10);s(t.mChangeListeners,"",t.aElements,t.iLimit);}for(i=0;i<u;i++){o=n.value[i];t.aElements[e+i]=o;t.calculateKeyPredicates(o,j[1]);m=o["@$ui5.predicate"];if(m){t.aElements.$byPredicate[m]=o;}}if(u<h){k=Math.min(g(t.aElements),e+u);t.aElements.length=k;if(!l&&k>0&&!t.aElements[k-1]){k=undefined;}s(t.mChangeListeners,"",t.aElements,k);t.iLimit=k;}})["catch"](function(o){t.fill(undefined,e,E);throw o;});this.bSentReadRequest=true;this.fill(p,e,E);};c.prototype.refreshSingle=function(G,i,D){var p=this.aElements[i]["@$ui5.predicate"],o,R=this.sResourcePath+p,Q=q.extend({},this.mQueryOptions),t=this;delete Q["$count"];delete Q["$filter"];delete Q["$sort"];R+=this.oRequestor.buildQueryString(this.sMetaPath,Q,false,this.bSortExpandSelect);o=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D),this.fetchTypes()]).then(function(e){var E=e[0];t.aElements[i]=t.aElements.$byPredicate[p]=E;t.calculateKeyPredicates(E,e[1]);C.computeCount(E);});this.bSentReadRequest=true;return o;};function P(R,e,Q){C.call(this,R,e,Q);this.oPromise=null;}P.prototype=Object.create(C.prototype);P.prototype._delete=function(){throw new Error("Unsupported");};P.prototype.create=function(){throw new Error("Unsupported");};P.prototype.fetchValue=function(G,p,D,l){var t=this;t.registerChange("",l);if(!this.oPromise){this.oPromise=S.resolve(this.oRequestor.request("GET",this.sResourcePath+this.sQueryString,G,undefined,undefined,D,undefined,this.sMetaPath));this.bSentReadRequest=true;}return this.oPromise.then(function(R){t.checkActive();return R.value;});};P.prototype.update=function(){throw new Error("Unsupported");};function d(R,e,Q,f,p,m){C.apply(this,arguments);this.sMetaPath=m||this.sMetaPath;this.bPost=p;this.bPosting=false;this.oPromise=null;}d.prototype=Object.create(C.prototype);d.prototype.fetchValue=function(G,p,D,l){var R=this.sResourcePath+this.sQueryString,t=this;this.registerChange(p,l);if(!this.oPromise){if(this.bPost){throw new Error("Cannot fetch a value before the POST request");}this.oPromise=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D,undefined,this.sMetaPath),this.fetchTypes()]).then(function(e){t.calculateKeyPredicates(e[0],e[1]);C.computeCount(e[0]);return e[0];});this.bSentReadRequest=true;}return this.oPromise.then(function(o){t.checkActive();if(o["$ui5.deleted"]){throw new Error("Cannot read a deleted entity");}return t.drillDown(o,p);});};d.prototype.post=function(G,D,e){var h="POST",t=this;if(!this.bPost){throw new Error("POST request not allowed");}if(this.bPosting){throw new Error("Parallel POST requests not allowed");}if(D){h=D["X-HTTP-Method"]||h;delete D["X-HTTP-Method"];if(this.oRequestor.isActionBodyOptional()&&!Object.keys(D).length){D=undefined;}}this.oPromise=S.resolve(this.oRequestor.request(h,this.sResourcePath+this.sQueryString,G,{"If-Match":e},D).then(function(R){t.bPosting=false;return R;},function(E){t.bPosting=false;throw E;}));this.bPosting=true;return this.oPromise;};C.create=function(R,e,Q,f){return new c(R,e,Q,f);};C.createProperty=function(R,e,Q){return new P(R,e,Q);};C.createSingle=function(R,e,Q,f,p,m){return new d(R,e,Q,f,p,m);};C.computeCount=function(R){if(R&&typeof R==="object"){Object.keys(R).forEach(function(k){var e,v=R[k];if(Array.isArray(v)){v.$count=undefined;e=R[k+"@odata.count"];if(e){s({},"",v,e);}else if(!R[k+"@odata.nextLink"]){s({},"",v,v.length);}v.forEach(C.computeCount);}else{C.computeCount(v);}});}};C.makeUpdateData=function(p,v){return p.reduceRight(function(V,e){var R={};R[e]=V;return R;},v);};return C;},false);
