/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Helper"],function(_){"use strict";function M(){this.aliases={};this.oAnnotatable=null;this.entityContainer=null;this.entitySet=null;this.namespace=null;this.oOperation=null;this.reference=null;this.schema=null;this.type=null;this.result=null;this.url=null;this.xmlns=null;}M.prototype.rCollection=/^Collection\((.*)\)$/;M.prototype.sEdmNamespace="http://docs.oasis-open.org/odata/ns/edm";M.prototype.sEdmxNamespace="http://docs.oasis-open.org/odata/ns/edmx";M.prototype.annotatable=function(t,p,q){var a,A,P;if(typeof t==="string"){a=this.oAnnotatable;if(a){t=_.buildPath(a.path,t);}P=t;A=this.schema.$Annotations;if(A&&A[t]){t=A[t];}}this.oAnnotatable={parent:this.oAnnotatable,path:P,prefix:p||"",qualifiedName:undefined,qualifier:q,target:t};};M.prototype.convertXMLMetadata=function(d,u){var e;jQuery.sap.measure.average("convertXMLMetadata","","sap.ui.model.odata.v4.lib._V4MetadataConverter");e=d.documentElement;if(e.localName!=="Edmx"||e.namespaceURI!==this.sRootNamespace){throw new Error(u+": expected <Edmx> in namespace '"+this.sRootNamespace+"'");}this.result={};this.url=u;this.traverse(e,this.oAliasConfig);this.traverse(e,this.oFullConfig,true);this.finalize();jQuery.sap.measure.end("convertXMLMetadata");return this.result;};M.prototype.getAnnotationValue=function(t,v){var i,V,a;switch(t){case"AnnotationPath":case"NavigationPropertyPath":case"Path":case"PropertyPath":v=this.resolveAliasInPath(v);case"Binary":case"Date":case"DateTimeOffset":case"Decimal":case"Duration":case"Guid":case"TimeOfDay":case"UrlRef":V={};V["$"+t]=v;return V;case"Bool":return v==="true";case"EnumMember":a=v.trim().replace(/ +/g," ").split(" ");for(i=0;i<a.length;i++){a[i]=this.resolveAliasInPath(a[i]);}return{$EnumMember:a.join(" ")};case"Float":if(v==="NaN"||v==="INF"||v==="-INF"){return{$Float:v};}return parseFloat(v);case"Int":V=parseInt(v,10);return _.isSafeInteger(V)?V:{$Int:v};case"String":return v;default:return undefined;}};M.prototype.getInlineAnnotationValue=function(e){var a,A=e.attributes,i,v;for(i=A.length-1;i>=0;i--){a=A.item(i);v=this.getAnnotationValue(a.name,a.value);if(v!==undefined){return v;}}return true;};M.prototype.getOrCreateArray=function(p,P){var r=p[P];if(!r){r=p[P]=[];}return r;};M.prototype.getOrCreateObject=function(p,P){var r=p[P];if(!r){r=p[P]={};}return r;};M.prototype.postProcessAnnotation=function(e,r){var a=this.oAnnotatable.parent;a.target[a.qualifiedName]=r.length?r[0]:this.getInlineAnnotationValue(e);};M.prototype.postProcessApply=function(e,r){var R=this.oAnnotatable.target;R.$Apply=r;R.$Function=this.resolveAlias(e.getAttribute("Function"));return R;};M.prototype.postProcessCastOrIsOf=function(e,r){var n=e.localName,R=this.oAnnotatable.target;R["$"+n]=r[0];this.processTypedCollection(e.getAttribute("Type"),R);this.processFacetAttributes(e,R);return R;};M.prototype.postProcessCollection=function(e,r){return r;};M.prototype.postProcessLabeledElement=function(e,r){var R=this.oAnnotatable.target;R.$LabeledElement=r.length?r[0]:this.getInlineAnnotationValue(e);R.$Name=e.getAttribute("Name");return R;};M.prototype.postProcessLabeledElementReference=function(e,r){return{"$LabeledElementReference":this.resolveAlias(e.textContent)};};M.prototype.postProcessLeaf=function(e,r){return this.getAnnotationValue(e.localName,e.textContent);};M.prototype.postProcessNot=function(e,r){var R=this.oAnnotatable.target;R.$Not=r[0];return R;};M.prototype.postProcessNull=function(e,r){var a=this.oAnnotatable,R=null;if(a.qualifiedName){R=a.target;R.$Null=null;}return R;};M.prototype.postProcessOperation=function(e,r){var R=this.oAnnotatable.target;R["$"+e.localName]=r;return R;};M.prototype.postProcessPropertyValue=function(e,r){return{property:e.getAttribute("Property"),value:r.length?r[0]:this.getInlineAnnotationValue(e)};};M.prototype.postProcessRecord=function(e,r){var i,p,R=this.oAnnotatable.target,t=e.getAttribute("Type");if(t){R.$Type=this.resolveAlias(t);}for(i=0;i<r.length;i++){p=r[i];R[p.property]=p.value;}return R;};M.prototype.postProcessUrlRef=function(e,r){return{$UrlRef:r[0]};};M.prototype.processAlias=function(e){var a=e.getAttribute("Alias");if(a){this.aliases[a]=e.getAttribute("Namespace")+".";}};M.prototype.processAnnotatableExpression=function(e){this.annotatable({});};M.prototype.processAnnotation=function(e){var a=this.oAnnotatable,A,q=a.prefix+"@"+this.resolveAlias(e.getAttribute("Term")),Q=a.qualifier||e.getAttribute("Qualifier");if(Q){q+="#"+Q;}if(typeof a.target==="string"){A=this.getOrCreateObject(this.schema,"$Annotations");a.target=A[a.target]={};}a.qualifiedName=q;a.target[q]=true;this.annotatable(a.target,q);};M.prototype.processAnnotations=function(e){this.annotatable(this.resolveAliasInPath(e.getAttribute("Target")),undefined,e.getAttribute("Qualifier"));};M.prototype.processAttributes=function(e,t,c){var p;for(p in c){var v=c[p](e.getAttribute(p));if(v!==undefined&&v!==null){t["$"+p]=v;}}};M.prototype.processInclude=function(e){var i=this.getOrCreateArray(this.reference,"$Include");i.push(e.getAttribute("Namespace")+".");};M.prototype.processIncludeAnnotations=function(e){var r=this.reference,i={"$TermNamespace":e.getAttribute("TermNamespace")+"."},I=this.getOrCreateArray(r,"$IncludeAnnotations");this.processAttributes(e,i,{"TargetNamespace":function setValue(v){return v?v+".":v;},"Qualifier":this.setValue});I.push(i);};M.prototype.processPropertyValue=function(e){this.annotatable(this.oAnnotatable.target,e.getAttribute("Property"));};M.prototype.processReference=function(e){var r=this.getOrCreateObject(this.result,"$Reference");this.reference=r[e.getAttribute("Uri")]={};this.annotatable(this.reference);};M.prototype.resolveAlias=function(n){var d=n.indexOf("."),N;if(d>=0&&n.indexOf(".",d+1)<0){N=this.aliases[n.slice(0,d)];if(N){return N+n.slice(d+1);}}return n;};M.prototype.resolveAliasInPath=function(p){var a,i,s,t="";if(p.indexOf(".")<0){return p;}a=p.indexOf("@");if(a>=0){t="@"+this.resolveAlias(p.slice(a+1));p=p.slice(0,a);}s=p.split("/");for(i=0;i<s.length;i++){s[i]=this.resolveAlias(s[i]);}return s.join("/")+t;};M.prototype.resolveTargetPath=function(p){var s;if(!p){return p;}p=this.resolveAliasInPath(p);s=p.indexOf("/");if(s>=0&&p.indexOf("/",s+1)<0){if(p.slice(0,s)===this.result.$EntityContainer){return p.slice(s+1);}}return p;};M.prototype.setIfFalse=function(v){return v==="false"?false:undefined;};M.prototype.setIfTrue=function(v){return v==="true"?true:undefined;};M.prototype.setNumber=function(v){return v?parseInt(v,10):undefined;};M.prototype.setValue=function(v){return v;};M.prototype.traverse=function(e,c,u){var a=this.oAnnotatable,C,o=e.childNodes,b,v,i,I,j,n,p=this.xmlns,r,R=[],x=c.__xmlns||this.xmlns;if(x&&x!==e.namespaceURI){return undefined;}this.xmlns=x;if(u){this.processElement(e,c.__processor);}else if(c.__processor){c.__processor.call(this,e);}for(i=0;i<o.length;i++){b=o.item(i);if(b.nodeType===1){n=b.localName;C=c[n];if(!C&&c.__include){I=c.__include;for(j=0;j<I.length;j++){C=I[j][n];if(C){break;}}}if(C){v=this.traverse(b,C,u);if(v!==undefined&&c.__postProcessor){R.push(v);}}}}if(c.__postProcessor){r=c.__postProcessor.call(this,e,R);}this.oAnnotatable=a;this.xmlns=p;return r;};(function($){var a,A,o,e,O;o={"AnnotationPath":{__postProcessor:$.postProcessLeaf},"Binary":{__postProcessor:$.postProcessLeaf},"Bool":{__postProcessor:$.postProcessLeaf},"Date":{__postProcessor:$.postProcessLeaf},"DateTimeOffset":{__postProcessor:$.postProcessLeaf},"Decimal":{__postProcessor:$.postProcessLeaf},"Duration":{__postProcessor:$.postProcessLeaf},"EnumMember":{__postProcessor:$.postProcessLeaf},"Float":{__postProcessor:$.postProcessLeaf},"Guid":{__postProcessor:$.postProcessLeaf},"Int":{__postProcessor:$.postProcessLeaf},"LabeledElementReference":{__postProcessor:$.postProcessLabeledElementReference},"NavigationPropertyPath":{__postProcessor:$.postProcessLeaf},"Path":{__postProcessor:$.postProcessLeaf},"PropertyPath":{__postProcessor:$.postProcessLeaf},"String":{__postProcessor:$.postProcessLeaf},"TimeOfDay":{__postProcessor:$.postProcessLeaf}};e=[o];$.oAnnotationConfig={"Annotation":{__xmlns:$.sEdmNamespace,__processor:$.processAnnotation,__postProcessor:$.postProcessAnnotation,__include:e}};a=[o,$.oAnnotationConfig];O={__processor:$.processAnnotatableExpression,__postProcessor:$.postProcessOperation,__include:a};A={"And":O,"Apply":{__processor:$.processAnnotatableExpression,__postProcessor:$.postProcessApply,__include:a},"Cast":{__processor:$.processAnnotatableExpression,__postProcessor:$.postProcessCastOrIsOf,__include:a},"Collection":{__postProcessor:$.postProcessCollection,__include:e},"Eq":O,"Ge":O,"Gt":O,"If":O,"IsOf":{__processor:$.processAnnotatableExpression,__postProcessor:$.postProcessCastOrIsOf,__include:a},"LabeledElement":{__processor:$.processAnnotatableExpression,__postProcessor:$.postProcessLabeledElement,__include:a},"Le":O,"Lt":O,"Ne":O,"Null":{__processor:$.processAnnotatableExpression,__postProcessor:$.postProcessNull,__include:[$.oAnnotationConfig]},"Not":{__processor:$.processAnnotatableExpression,__postProcessor:$.postProcessNot,__include:a},"Or":O,"Record":{__processor:$.processAnnotatableExpression,__postProcessor:$.postProcessRecord,__include:[$.oAnnotationConfig],"PropertyValue":{__processor:$.processPropertyValue,__postProcessor:$.postProcessPropertyValue,__include:a}},"UrlRef":{__postProcessor:$.postProcessUrlRef,__include:e}};$.oAnnotationsConfig={"Annotations":{__processor:$.processAnnotations,__include:[$.oAnnotationConfig]}};e.push(A);a.push(A);$.oAnnotationConfig.Annotation.Annotation=$.oAnnotationConfig.Annotation;$.oReferenceInclude={"Reference":{__xmlns:$.sEdmxNamespace,__processor:$.processReference,__include:[$.oAnnotationConfig],"Include":{__processor:$.processInclude},"IncludeAnnotations":{__processor:$.processIncludeAnnotations}}};})(M.prototype);return M;},false);
