/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Measurement","./ResourceTimings","./XHRInterceptor","sap/base/util/now","sap/base/log","sap/ui/thirdparty/URI"],function(M,R,X,n,a,U){"use strict";var H=window.location.host,I="INTERACTION",b=[],p=d();function c(u){var i=new U(u).host();return i&&i!==H;}function d(T){return{event:"startup",trigger:"undetermined",component:"undetermined",appVersion:"undetermined",start:T||window.performance.timing.fetchStart,end:0,navigation:0,roundtrip:0,processing:0,duration:0,requests:[],measurements:[],sapStatistics:[],requestTime:0,networkTime:0,bytesSent:0,bytesReceived:0,requestCompression:undefined,busyDuration:0};}function e(i){if(i.start>p.start&&i.end<p.end){return i;}}function f(i){var l,E,u;l=i.startTime>0&&i.startTime<=i.requestStart&&i.requestStart<=i.responseEnd;if(i.encodedBodySize!==undefined&&i.transferSize!==undefined){E=i.encodedBodySize===0;u=i.transferSize<i.encodedBodySize;}return l&&!E&&!u;}function g(i){this.end=i.responseEnd>this.end?i.responseEnd:this.end;p.requestTime+=(i.responseEnd-i.startTime);if(this.roundtripHigherLimit<=i.startTime){p.navigation+=(this.navigationHigherLimit-this.navigationLowerLimit);p.roundtrip+=(this.roundtripHigherLimit-this.roundtripLowerLimit);this.navigationLowerLimit=i.startTime;this.roundtripLowerLimit=i.startTime;}if(i.responseEnd>this.roundtripHigherLimit){this.roundtripHigherLimit=i.responseEnd;}if(i.requestStart>this.navigationHigherLimit){this.navigationHigherLimit=i.requestStart;}}function h(i){var T={start:i[0].startTime,end:i[0].responseEnd,navigationLowerLimit:i[0].startTime,navigationHigherLimit:i[0].requestStart,roundtripLowerLimit:i[0].startTime,roundtripHigherLimit:i[0].responseEnd};i.forEach(g,T);p.navigation+=(T.navigationHigherLimit-T.navigationLowerLimit);p.roundtrip+=(T.roundtripHigherLimit-T.roundtripLowerLimit);if(p.networkTime){var l=p.requestTime-p.networkTime;p.networkTime=l/i.length;}else{p.networkTime=0;}if(p.processing===0){var u=p.start-window.performance.timing.fetchStart;p.duration=T.end-u;p.processing=T.start-u;}}function j(T){if(p){p.end=T;p.duration=p.processing;p.requests=R.getRequestTimings();p.completeRoundtrips=0;p.measurements=M.filterMeasurements(e,true);var i=p.requests.filter(f);if(i.length>0){h(i);}p.completeRoundtrips=i.length;var P=p.processing-p.navigation-p.roundtrip;p.processing=P>-1?P:0;b.push(p);a.info("Interaction step finished: trigger: "+p.trigger+"; duration: "+p.duration+"; requests: "+p.requests.length,"Interaction.js");p=null;}}function k(S){var i,v;if(S){var l,u;l=sap.ui.require("sap/ui/core/Component");while(l&&S&&S.getParent){u=l.getOwnerComponentFor(S);if(u||S instanceof l){u=u||S;var A=u.getManifestEntry("sap.app");i=A&&A.id||u.getMetadata().getName();v=A&&A.applicationVersion&&A.applicationVersion.version;}S=S.getParent();}}return{id:i?i:"undetermined",version:v?v:""};}var m=false,C,o,s=0;function r(){X.register(I,"send",function(){if(this.pendingInteraction){this.pendingInteraction.bytesSent+=arguments[0]?arguments[0].length*2:0;}});X.register(I,"setRequestHeader",function(i,v){if(!this.requestHeaderLength){this.requestHeaderLength=0;}this.requestHeaderLength+=(i.length+v.length+3)*2;});X.register(I,"open",function(){if(!c(arguments[1])){this.addEventListener("readystatechange",q);}this.pendingInteraction=p;});}function q(){if(this.readyState===4&&this.pendingInteraction&&!this.pendingInteraction.completed){var i=this.getResponseHeader("content-length"),l=this.getResponseHeader("content-encoding")==="gzip",F=this.getResponseHeader("sap-perf-fesrec");this.pendingInteraction.bytesReceived+=i?parseInt(i,10):0;this.pendingInteraction.bytesReceived+=this.getAllResponseHeaders().length*2;this.pendingInteraction.bytesSent+=this.requestHeaderLength||0;this.pendingInteraction.requestCompression=l&&(this.pendingInteraction.requestCompression!==false);this.pendingInteraction.networkTime+=F?Math.round(parseFloat(F,10)/1000):0;var S=this.getResponseHeader("sap-statistics");if(S){var T=R.getRequestTimings();this.pendingInteraction.sapStatistics.push({url:this.responseURL,statistics:S,timing:T?T[T.length-1]:undefined});}delete this.requestHeaderLength;delete this.pendingInteraction;}}var t={getAll:function(F){if(F){t.end(true);}return b;},filter:function(F){var u=[];if(F){for(var i=0,l=b.length;i<l;i++){if(F(b[i])){u.push(b[i]);}}}return u;},getPending:function(){return p;},clear:function(){b=[];},start:function(T,S){var i=n();if(p){j(i);}R.clearRequestTimings();var l=k(S);p=d(i);p.event=T;p.component=l.id;p.appVersion=l.version;p.start=i;if(S&&S.getId){p.trigger=S.getId();}a.info("Interaction step started: trigger: "+p.trigger+"; type: "+p.event,"Interaction.js");},end:function(F){if(p){if(!F){p.processing=n()-p.start;}else{j(n());}}},getActive:function(){return m;},setActive:function(A){if(A&&!m){r();}m=A;},notifyStepStart:function(E,F){if(m){if(C||F){var T;if(F){T="startup";}else if(C.originalEvent){T=C.originalEvent.type;}else{T=C.type;}t.start(T,E);var i=t.getAll();var l=i[i.length-1];var P=t.getPending();p=P?P:p;if(t.onInteractionFinished&&l){t.onInteractionFinished(l);}C=null;}}},notifyStepEnd:function(){if(m){if(o){clearTimeout(o);}o=setTimeout(t.end,1);}},notifyEventStart:function(E){C=m?E:null;},notifyScrollEvent:function(E){if(m){if(!s){t.notifyEventStart(E);}else{clearTimeout(s);}s=setTimeout(function(){t.notifyStepStart();s=0;},250);}},notifyEventEnd:function(){if(C){if(C.type.match(/^(mousedown|touchstart|keydown)$/)){t.end(true);}}},onInteractionFinished:null,setStepComponent:function(i){if(m&&p&&i&&!p.stepComponent){p.stepComponent=i;}},addBusyDuration:function(D){if(m&&p){if(!p.busyDuration){p.busyDuration=0;}p.busyDuration+=D;}}};return t;});
