/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/MiniMenu","sap/ui/dt/plugin/TabHandling","sap/ui/fl/FlexControllerFactory","sap/ui/rta/Utils","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/util/UrlParser","sap/ui/rta/appVariant/Feature","sap/ui/Device"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,i,j,k,l,m,n,o,T,p,U,r,s,t,u,v,B,w,x,y,z,E){"use strict";var G="sap-ui-fl-max-layer";var H=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"customFieldUrl":"string","showCreateCustomField":"boolean","showToolbars":{type:"boolean",defaultValue:true},"triggeredFromDialog":{type:"boolean",defaultValue:false},"showWindowUnloadDialog":{type:"boolean",defaultValue:true},"commandStack":{type:"any"},"plugins":{type:"any",defaultValue:{}},"flexSettings":{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},"mode":{type:"string",defaultValue:"adaptation"},"metadataScope":{type:"string",defaultValue:"default"}},events:{"start":{parameters:{editablePluginsCount:{type:"int"}}},"stop":{},"failed":{},"selectionChange":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},"modeChanged":{},"undoRedoStackModified":{}}},_sAppTitle:null,_dependents:null,constructor:function(){M.apply(this,arguments);this._dependents={};this.iEditableOverlaysCount=0;this.addDependent(new v(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}}});H.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var J=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new k({commandFactory:J,multiSelectionRequiredPlugins:[i.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var K=new c({commandFactory:J});this._mDefaultPlugins["dragDrop"]=new b({elementMover:K,commandFactory:J,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:J,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:J,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:J});this._mDefaultPlugins["remove"]=new e({commandFactory:J});this._mDefaultPlugins["cutPaste"]=new d({elementMover:K,commandFactory:J});this._mDefaultPlugins["settings"]=new l({commandFactory:J});this._mDefaultPlugins["combine"]=new i({commandFactory:J});this._mDefaultPlugins["split"]=new j({commandFactory:J});if(y.getParam('sap-ui-rta-minimenu')===true){this._mDefaultPlugins["contextMenu"]=new o({styleClass:U.getRtaStyleClassName()});}else{this._mDefaultPlugins["contextMenu"]=new n({styleClass:U.getRtaStyleClassName()});}this._mDefaultPlugins["tabHandling"]=new T();this._mDefaultPlugins["controlVariant"]=new m({commandFactory:J});}return q.extend({},this._mDefaultPlugins);};H.prototype.addDependent=function(J,N){if(!(N in this._dependents)){if(N){this['get'+q.sap.charToUpperCase(N,0)]=this.getDependent.bind(this,N);}this._dependents[N||J.getId()]=J;}};H.prototype.getDependent=function(N){return this._dependents[N];};H.prototype.getDependents=function(){return this._dependents;};H.prototype._destroyDefaultPlugins=function(J){for(var K in this._mDefaultPlugins){var N=this._mDefaultPlugins[K];if(N&&!N.bIsDestroyed){if(!J||J[K]!==N){N.destroy();}}}if(!J){this._mDefaultPlugins=null;}};H.prototype.onPopupOpen=function(J){if(J.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};H.prototype.onPopupClose=function(J){if(J.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};H.prototype.setPlugins=function(J){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",J);};H.prototype.setFlexSettings=function(J){var K=q.sap.getUriParameters();var N=K.mParams["sap-ui-layer"];J=q.extend({},this.getFlexSettings(),J);if(N&&N.length>0){J.layer=N[0];}U.setRtaStyleClassName(J.layer);this.setProperty("flexSettings",J);};H.prototype.getLayer=function(J){return this.getFlexSettings().layer;};H.prototype._getFlexController=function(){var J=this._oRootControl||sap.ui.getCore().byId(this.getRootControl());return p.createForControl(J);};H.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};H.prototype.start=function(){if(!this._oDesignTime){this._oRootControl=sap.ui.getCore().byId(this.getRootControl());if(!this._oRootControl){var J="Could not start Runtime Adaptation: Root control not found";r.log.error(J);return Promise.reject(J);}return this._handlePersonalizationChangesOnStart().then(function(K){if(K){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(V){if(this.getPlugins()[V].attachElementModified){this.getPlugins()[V].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var N=Object.keys(this.getPlugins());var Q=N.map(function(V){return this.getPlugins()[V];},this);q.sap.measure.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:Q});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}this._oRootControl.addStyleClass("sapUiRtaRoot");this._oDesignTime.attachSelectionChange(function(V){this.fireSelectionChange({selection:V.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});q.sap.measure.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",this.fireFailed);this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function(K){var N=K[0];var Q=K[1];this._createToolsMenu(N,Q);return this.getToolbar().show();}.bind(this));}}.bind(this)).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);}.bind(this)).then(function(){this.getPopupManager().setRta(this);var K=this.getPopupManager().getRelevantPopups();if(K.aDialogs||K.aPopovers){return this.getShowToolbars()&&this.getToolbar().bringToFront();}}.bind(this)).then(function(){x.loadStyles('InPageStyles').then(function(K){var N=K.replace(/%scrollWidth%/g,w.getScrollbarWidth()+'px');w.insertStyles(N);});this._oDesignTime.detachEvent("syncFailed",this.fireFailed);}.bind(this)).catch(function(J){if(J){return Promise.reject(J);}});}};H.prototype._getPublishAndAppVariantSupportVisibility=function(){return s.getInstance().then(function(J){var K=z.isPlatFormEnabled(this._oRootControl,this.getLayer(),this._oSerializer);return[!J.isProductiveSystem()&&!J.hasMergeErrorOccured(),!J.isProductiveSystem()&&K];}.bind(this)).catch(function(J){return false;});};var I=function(J){B.hide();var K=J.stack||J.message||J.status||J;var N=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");q.sap.log.error("Failed to transfer runtime adaptation changes to layered repository",K);var Q=N.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+N.getText("MSG_ERROR_REASON",K);t.error(Q,{styleClass:U.getRtaStyleClassName()});};H.prototype.setCommandStack=function(J){var K=this.getProperty("commandStack");if(K){K.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var N=this.setProperty("commandStack",J);if(J){J.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(J);}return N;};H.prototype.getCommandStack=function(){var J=this.getProperty("commandStack");if(!J){J=new C();this._oInternalCommandStack=J;this.setCommandStack(J);}return J;};H.prototype._onStackModified=function(){var J=this.getCommandStack();var K=J.canUndo();var N=J.canRedo();var Q=U.getUshellContainer();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(K,N);this.getToolbar().setPublishEnabled(this._bChangesExist||K);this.getToolbar().setRestoreEnabled(this._bChangesExist||K);}this.fireUndoRedoStackModified();if(Q){if(K){Q.setDirtyFlag(true);}else{Q.setDirtyFlag(false);}}};H.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};H.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}else{return[];}};H.prototype.stop=function(J,K){return((J)?Promise.resolve():this._serializeToLrep()).then(this._closeToolbar.bind(this)).then(K?Promise.resolve():this._handlePersonalizationChangesOnExit.bind(this)).then(function(){this.fireStop();}.bind(this))['catch'](I);};H.prototype.restore=function(){this._onRestore();};H.prototype.transport=function(){return this._onTransport();};H.prototype.undo=function(){return this._onUndo();};H.prototype.redo=function(){return this._onRedo();};H.prototype.canUndo=function(){return this.getCommandStack().canUndo();};H.prototype.canRedo=function(){return this.getCommandStack().canRedo();};H.prototype._onKeyDown=function(J){var K=E.os.macintosh;var N=O.getOverlayContainer().get(0).contains(document.activeElement);var Q=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var V=document.body===document.activeElement;var W=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((N||Q||V)&&!W){var X=K?J.metaKey:J.ctrlKey;if(J.keyCode===q.sap.KeyCodes.Z&&J.shiftKey===false&&J.altKey===false&&X===true){this._onUndo().then(J.stopPropagation.bind(J));}else if(((K&&J.keyCode===q.sap.KeyCodes.Z&&J.shiftKey===true)||(!K&&J.keyCode===q.sap.KeyCodes.Y&&J.shiftKey===false))&&J.altKey===false&&X===true){this._onRedo().then(J.stopPropagation.bind(J));}}};H.prototype._onUnload=function(){var J=this.getCommandStack();var K=J.canUndo()||J.canRedo();if(K&&this.getShowWindowUnloadDialog()){var N=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return N;}else{window.onbeforeunload=this._oldUnloadHandler;}};H.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands();};H.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};H.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};H.prototype._createToolsMenu=function(J,K){if(!this.getDependent('toolbar')){var N;if(this.getLayer()==="USER"){N=P;}else if(U.getFiori2Renderer()){N=F;}else{N=S;}if(this.getLayer()==="USER"){this.addDependent(new N({textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new N({modeSwitcher:this.getMode(),publishVisible:J,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:z.onGetOverview.bind(null,true),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:z.onSaveAsFromRtaToolbar.bind(null,true,true)}),'toolbar');}var Q;if(K){this.getToolbar().getControl('saveAs').setVisible(K);Q=z.isOverviewExtended();if(Q){this.getToolbar().getControl('appVariantOverview').setVisible(K);}else{this.getToolbar().getControl('manageApps').setVisible(K);}z.isManifestSupported().then(function(V){if(Q){this.getToolbar().getControl('appVariantOverview').setEnabled(V);}else{this.getToolbar().getControl('manageApps').setEnabled(V);}this.getToolbar().getControl('saveAs').setEnabled(V);}.bind(this));}this._checkChangesExist().then(function(V){if(!this.bIsDestroyed){this._bChangesExist=V;this.getToolbar().setPublishEnabled(V);this.getToolbar().setRestoreEnabled(V);}}.bind(this));}};H.prototype._onGetAppVariantOverview=function(J){var K=J.getParameter("item");var N=K.getId()==='keyUser';return z.onGetOverview(N);};H.prototype.exit=function(){q.map(this._dependents,function(K){K.destroy(true);});if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._oRootControl){this._oRootControl.removeStyleClass("sapUiRtaRoot");}this.setCommandStack(null);var J=U.getUshellContainer();if(J){J.setDirtyFlag(false);}window.onbeforeunload=this._oldUnloadHandler;};H.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();return this._getFlexController()._oChangePersistence.transportAllUIChanges(this._oRootControl,U.getRtaStyleClassName(),this.getLayer()).then(function(J){if(J!=="Error"&&J!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");}}.bind(this));}.bind(this))['catch'](I);};H.prototype._deleteChanges=function(){return this._getFlexController().resetChanges(this.getLayer(),"Change.createInitialFileContent",r.getAppComponentForControl(this._oRootControl||sap.ui.getCore().byId(this.getRootControl()))).then(function(){this._reloadPage();}.bind(this))["catch"](function(J){return U._showMessageBox(t.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",J);});};H.prototype._reloadPage=function(){window.location.reload();};H.prototype._showMessageToast=function(J){var K=this._getTextResources().getText(J);u.show(K);};H.needsRestart=function(J){var K=!!window.localStorage.getItem("sap.ui.rta.restart."+J);return K;};H.enableRestart=function(J){window.localStorage.setItem("sap.ui.rta.restart."+J,true);};H.disableRestart=function(J){window.localStorage.removeItem("sap.ui.rta.restart."+J);};H.prototype._onRestore=function(){var J=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var K=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var N=function(Q){if(Q==="OK"){H.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();t.confirm(J,{icon:t.Icon.WARNING,title:K,onClose:N,styleClass:U.getRtaStyleClassName()});};H.prototype._setRenameOnCreatedContainer=function(J,N){var K=function(W){W.setSelected(true);this.getPlugins()["rename"].startEdit(W);};var Q=function(W){var X=W.getSource();if(X.getGeometry()&&X.getGeometry().visible){K.call(this,X);X.detachEvent('geometryChanged',Q,this);}};var V=this.getPlugins()["createContainer"].getCreatedContainerId(J,N);this._oDesignTime.attachEvent("elementOverlayCreated",function(W){var X=W.getParameter("elementOverlay");if(X.getElement().getId()===V){if(!X.getGeometry()||!X.getGeometry().visible){X.attachEvent('geometryChanged',Q,this);}else{K.call(this,X);}}}.bind(this));};H.prototype._handleElementModified=function(J){this._handleStopCutPaste();var K=J.getParameter("action");var N=J.getParameter("newControlId");var Q=J.getParameter("command");if(Q instanceof sap.ui.rta.command.BaseCommand){return this.getCommandStack().pushAndExecute(Q).then(function(){if(K&&N){this._setRenameOnCreatedContainer(K,N);}}.bind(this)).catch(function(V){throw new Error(V);});}return Promise.resolve();};H.prototype._onElementEditableChange=function(J){var K=J.getParameter("editable");if(K){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};H.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};H.prototype._checkChangesExist=function(){if(this._getFlexController().getComponentName().length>0){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer(),includeCtrlVariants:true}).then(function(J){return J.length>0;});}else{return Promise.resolve(false);}};H.prototype._getURLParsedHash=function(){var J=sap.ushell.Container.getService("URLParsing");if(J.parseShellHash&&J.getHash){return J.parseShellHash(J.getHash(window.location.href));}};H.prototype._buildNavigationArguments=function(J){return{target:{semanticObject:J.semanticObject,action:J.action,context:J.contextRaw},params:J.params,appSpecificRoute:J.appSpecificRoute,writeHistory:false};};H.prototype._hasCustomerLayerParameter=function(J){return J.params&&J.params[G]&&J.params[G][0]==="CUSTOMER";};H.prototype._reloadWithoutPersonalizationChanges=function(J,K){if(!this._hasCustomerLayerParameter(J)){if(!J.params){J.params={};}J.params[G]=["CUSTOMER"];H.enableRestart("CUSTOMER");K.toExternal(this._buildNavigationArguments(J));return Promise.resolve(true);}};H.prototype._reloadWithPersonalizationChanges=function(J,K){if(this._hasCustomerLayerParameter(J)){delete J.params[G];K.toExternal(this._buildNavigationArguments(J));return Promise.resolve(true);}};H.prototype._handlePersonalizationMessageBoxOnStart=function(){return U._showMessageBox(t.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS","MSG_PERSONALIZATION_EXISTS");};H.prototype._handlePersonalizationChangesOnStart=function(){var J=U.getUshellContainer();if(J&&this.getLayer()!=="USER"){var K=this._getURLParsedHash();return this._getFlexController().isPersonalized({ignoreMaxLayerParameter:false}).then(function(N){if(N){return this._handlePersonalizationMessageBoxOnStart().then(function(){var Q=sap.ushell.Container.getService("CrossApplicationNavigation");if(Q.toExternal&&K){return this._reloadWithoutPersonalizationChanges(K,Q);}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};H.prototype._handlePersonalizationMessageBoxOnExit=function(){return new Promise(function(J){var K=this._getTextResources().getText("MSG_LOAD_PERSONALIZATION_CHANGES");var N=this._getTextResources().getText("HEADER_LOAD_PERSONALIZATION_CHANGES");var Q=this._getTextResources().getText("MSG_PERSONALIZATION_CONFIRM_BUTTON_TEXT");var V=this._getTextResources().getText("MSG_PERSONALIZATION_CANCEL_BUTTON_TEXT");var W=function(X){if(X===Q){return J(true);}else if(X===V){return J(false);}};t.confirm(K,{icon:t.Icon.QUESTION,title:N,actions:[Q,V],onClose:W,styleClass:U.getRtaStyleClassName()});}.bind(this));};H.prototype._handlePersonalizationChangesOnExit=function(){var J=U.getUshellContainer();if(J&&this.getLayer()!=="USER"){return this._getFlexController().isPersonalized({ignoreMaxLayerParameter:true}).then(function(K){if(K){return this._handlePersonalizationMessageBoxOnExit().then(function(N){if(N){var Q=sap.ushell.Container.getService("CrossApplicationNavigation");var V=this._getURLParsedHash();if(Q.toExternal&&V){return this._reloadWithPersonalizationChanges(V,Q);}}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};H.prototype._onModeChange=function(J){this.setMode(J.getParameter('key'));};H.prototype.setMode=function(N){if(this.getProperty('mode')!==N){var J=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var K=N==='adaptation';if(J){J.setSelectedButton(J.getItems().filter(function(Q){return Q.getKey()===N;}).pop().getId());}this._oDesignTime.setEnabled(K);this.getPlugins()['tabHandling'][K?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',N);this.fireModeChanged({mode:N});}};H.prototype.setMetadataScope=function(J){if(this._oDesignTime){q.sap.log.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',J);};return H;},true);
