/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/rta/command/Stack','sap/ui/rta/command/FlexCommand','sap/ui/rta/command/BaseCommand','sap/ui/rta/command/AppDescriptorCommand','sap/ui/fl/FlexControllerFactory','sap/ui/fl/Utils','sap/ui/rta/ControlTreeModifier','sap/ui/fl/registry/Settings'],function(M,C,F,B,A,a,b,R,S){"use strict";var L=M.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"commandStack":{type:"object"}},aggregations:{}}});L.prototype._lastPromise=Promise.resolve();L.prototype.setCommandStack=function(c){this.setProperty("commandStack",c);c.attachCommandExecuted(function(e){this.handleCommandExecuted(e);}.bind(this));};L.prototype.handleCommandExecuted=function(e){(function(e){var p=e.getParameters();this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var c=this.getCommandStack().getSubCommands(p.command);var f;if(p.undo){c.forEach(function(o){if(!(o instanceof F||o instanceof A)||o.getRuntimeOnly()){return;}var g=o.getPreparedChange();var h=o.getAppComponent();if(o instanceof F){f=a.createForControl(h);var i=R.bySelector(g.getSelector(),h);f.removeFromAppliedChangesOnControl(g,h,i);}else if(o instanceof A){f=this._getAppDescriptorFlexController(h);}f.deleteChange(g,h);}.bind(this));}else{var d=[];c.forEach(function(o){if(o.getRuntimeOnly()){return;}if(o instanceof F){var g=o.getAppComponent();var f=a.createForControl(g);f.addPreparedChange(o.getPreparedChange(),g);}else if(o instanceof A){d.push(o.createAndStoreChange());}});return Promise.all(d);}}.bind(this));}.bind(this))(e);};L.prototype.saveCommands=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var r=sap.ui.getCore().byId(this.getRootControl());if(!r){throw new Error("Can't save commands without root control instance!");}var f=a.createForControl(r);return f.saveAll();}.bind(this)).then(function(){var r=sap.ui.getCore().byId(this.getRootControl());var f=this._getAppDescriptorFlexController(r);return f.saveAll();}.bind(this)).then(function(){jQuery.sap.log.info("UI adaptation successfully transferred changes to layered repository");this.getCommandStack().removeAllCommands();}.bind(this));return this._lastPromise;};L.prototype._getAppDescriptorFlexController=function(c){var o=b.getAppComponentForControl(c);var s=b.getComponentClassName(o).replace(".Component","");var d=b.getAppVersionFromManifest(o.getManifest());return a.create(s,d);};L.prototype._moveChangeToAppVariant=function(r,f){return S.getInstance().then(function(s){var p={reference:r};var n=b.createNamespace(p,"changes");var c=this.getCommandStack().getAllExecutedCommands();c.forEach(function(o){if(o.getPreparedChange&&!o.getRuntimeOnly()){var v=o.getPreparedChange();if(!Array.isArray(v)){v=[v];}v.forEach(function(d){if(s.isAtoEnabled()){d.setRequest("ATO_NOTIFICATION");}d.setNamespace(n);d.setComponent(r);});}});return f.saveAll(true);}.bind(this));};L.prototype._triggerUndoChanges=function(){var c=this.getCommandStack();var p=[];var d=c.getAllExecutedCommands();d.forEach(function(o){p.push(o.undo.bind(o));});p=p.reverse();return b.execPromiseQueueSequentially(p,false,true);};L.prototype._removeCommands=function(f){var c=this.getCommandStack();var d=c.getAllExecutedCommands();d.forEach(function(o){if(o instanceof F){var e=o.getPreparedChange();var g=o.getAppComponent();var h=R.bySelector(e.getSelector(),g);f.removeFromAppliedChangesOnControl(e,g,h);}});c.removeAllCommands();};L.prototype.saveAsCommands=function(r){if(!r){throw new Error("The id of the new app variant is required");}var o=sap.ui.getCore().byId(this.getRootControl());if(!o){throw new Error("Can't save commands without root control instance!");}var c=b.getAppDescriptor(o);if(c["sap.app"].id===r){throw new Error("The id of the app variant should be different from the current app id");}var f=a.createForControl(o);var d=this.getCommandStack();return this._moveChangeToAppVariant(r,f).then(function(){d.detachCommandExecuted(this.handleCommandExecuted.bind(this));return this._triggerUndoChanges();}.bind(this)).then(function(){this._removeCommands(f);d.attachCommandExecuted(this.handleCommandExecuted.bind(this));return true;}.bind(this));};return L;},true);
