/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/UIComponent","sap/ui/core/ComponentContainer","sap/ui/core/mvc/XMLView","sap/ui/rta/command/CommandFactory","sap/ui/dt/DesignTime","sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence","sap/ui/model/Model",'sap/ui/fl/FlexControllerFactory','sap/ui/rta/ControlTreeModifier',"sap/ui/fl/library",'sap/ui/thirdparty/sinon','sap/ui/thirdparty/sinon-qunit'],function(U,C,X,a,D,O,E,b,c,M,F,d){"use strict";var e=function(m,o){if(e._only&&(m.indexOf(e._only)<0)){return;}if(typeof o.xmlView==="string"){o.xmlView={viewContent:o.xmlView};}QUnit.module(m,{});QUnit.test("When using the 'controlEnablingCheck' function to test if your control is ready for UI adaptation at runtime",function(j){j.ok(o.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");j.ok(o.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");j.ok(o.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");j.ok(o.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");var x=new DOMParser().parseFromString(o.xmlView.viewContent,"application/xml").documentElement;j.ok(x.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");j.ok(o.action,"then you provide an action: See the action parameter.");j.ok(o.action.name,"then you provide an action name: See the action.name parameter.");j.ok(o.action.controlId,"then you provide the id of the control to operate the action on: See the action.controlId.");});var f="sap.ui.rta.control.enabling.comp";var S=false;var A=true;var g=U.extend(f,{metadata:{manifest:{"sap.app":{"id":f,"type":"application"}}},createContent:function(){var v=jQuery.extend({},o.xmlView);v.id=this.createId("view");if(v.async===undefined){v.async=this.getComponentData().async;}var V=sap.ui.xmlview(v);return V;}});function h(j){this.oUiComponent=new g({id:"comp",componentData:{async:j}});this.oUiComponentContainer=new C({component:this.oUiComponent});this.oUiComponentContainer.placeAt(o.placeAt||"content");this.oView=this.oUiComponent.getRootControl();if(o.model instanceof M){this.oView.setModel(o.model);}sap.ui.getCore().applyChanges();return this.oView.loaded();}function i(j){this.oControl=this.oView.byId(o.action.controlId);return this.oControl.getMetadata().loadDesignTime(this.oControl).then(function(k){var p;if(o.action.parameter){if(typeof o.action.parameter==="function"){p=o.action.parameter(this.oView);}else{p=o.action.parameter;}}else{p={};}sap.ui.getCore().applyChanges();this.oDesignTime=new D({rootElements:[this.oView]});return new Promise(function(r){this.oDesignTime.attachEventOnce("synced",function(){this.oControlOverlay=O.getOverlay(this.oControl);var l=new a({flexSettings:{layer:o.layer||"CUSTOMER"}});var n=this.oControlOverlay.getDesignTimeMetadata();if(o.action.name==="move"){var q=O.getOverlay(p.movedElements[0].element);var R=q.getRelevantContainer();this.oControl=R;n=q.getParentAggregationOverlay().getDesignTimeMetadata();}else if(o.action.name==="addODataProperty"){var s=n.getActionDataFromAggregations("addODataProperty",this.oControl);j.equal(s.length,1,"there should be only one aggregation with the possibility to do addODataProperty action");var t=this.oControlOverlay.getAggregationOverlay(s[0].aggregation);n=t.getDesignTimeMetadata();}this.oCommand=l.getCommandFor(this.oControl,o.action.name,p,n);j.ok(this.oCommand,"then the registration for action to change type, the registration for change and control type to change handler is available and "+o.action.name+" is a valid action");r();}.bind(this));}.bind(this));}.bind(this));}if(!o.jsOnly){QUnit.module(m+" on async views",{afterEach:function(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();this.oCommand.destroy();}});QUnit.test("When applying the change directly on the XMLView",function(j){var k=[];this.stub(c.prototype,"getChangesForComponent").returns(Promise.resolve(k));this.stub(c.prototype,"getCacheKey").returns(Promise.resolve("etag-123"));return h.call(this,S).then(function(){return i.call(this,j);}.bind(this)).then(function(){var l=this.oCommand.getPreparedChange();k.push(l);this.oUiComponentContainer.destroy();return h.call(this,A);}.bind(this)).then(function(v){o.afterAction(this.oUiComponent,v,j);}.bind(this));});}QUnit.module(m,{beforeEach:function(j){this.sandbox=sinon.sandbox.create();this.sandbox.stub(c.prototype,"getChangesForComponent").returns(Promise.resolve([]));this.sandbox.stub(c.prototype,"getCacheKey").returns(c.NOTAG);return h.call(this,S).then(function(){return i.call(this,j);}.bind(this));},afterEach:function(){this.sandbox.restore();this.oUiComponentContainer.destroy();this.oDesignTime.destroy();this.oCommand.destroy();}});QUnit.test("When executing the underlying command on the control at runtime",function(j){var k=j.async();this.oCommand.execute().then(function(){sap.ui.getCore().applyChanges();o.afterAction(this.oUiComponent,this.oView,j);k();}.bind(this));});QUnit.test("When executing and undoing the command",function(j){var k=j.async();this.oCommand.execute().then(this.oCommand.undo.bind(this.oCommand)).then(function(){var l=this.oCommand.getPreparedChange();if(this.oCommand.getAppComponent){var n=this.oCommand.getAppComponent();var p=d.bySelector(l.getSelector(),n);var q=F.createForControl(n);q.removeFromAppliedChangesOnControl(l,n,p);}}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterUndo(this.oUiComponent,this.oView,j);k();}.bind(this));});QUnit.test("When executing, undoing and redoing the command",function(j){var k=j.async();this.oCommand.execute().then(this.oCommand.undo.bind(this.oCommand)).then(function(){var l=this.oCommand.getPreparedChange();if(this.oCommand.getAppComponent){var n=this.oCommand.getAppComponent();var p=d.bySelector(l.getSelector(),n);var q=F.createForControl(n);return q.removeFromAppliedChangesOnControl(l,n,p);}}.bind(this)).then(this.oCommand.execute.bind(this.oCommand)).then(function(){sap.ui.getCore().applyChanges();o.afterRedo(this.oUiComponent,this.oView,j);k();}.bind(this));});};e.skip=function(){};e.only=function(m){e._only=m;};return e;});
