/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/support/Bootstrap',["jquery.sap.global"],function(q){"use strict";var B={initSupportRules:function(s){sap.ui.require(["sap/ui/support/supportRules/Main"],function(M){if(s[0].toLowerCase()==="true"||s[0].toLowerCase()==="silent"){M.startPlugin(s);if('logSupportInfo'in q.sap.log){q.sap.log.logSupportInfo(true);}}});}};return B;});
sap.ui.predefine('sap/ui/support/library',["sap/ui/core/library"],function(l){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.support",dependencies:["sap.ui.core"],types:["sap.ui.support.Severity"],interfaces:[],controls:[],elements:[],noLibraryCSS:true,version:"1.54.7",extensions:{"sap.ui.support":{internalRules:true}}});sap.ui.support.Severity={Medium:"Medium",High:"High",Low:"Low"};sap.ui.support.Audiences={Control:"Control",Internal:"Internal",Application:"Application"};sap.ui.support.Categories={Accessibility:"Accessibility",Performance:"Performance",Memory:"Memory",Bindings:"Bindings",Consistency:"Consistency",Functionality:"Functionality",Usability:"Usability",DataModel:"DataModel",Usage:"Usage",Other:"Other"};return sap.ui.support;});
sap.ui.predefine('sap/ui/support/supportRules/Analyzer',["jquery.sap.global","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/Constants"],function(q,I,C){"use strict";var A=function(){this.dStartedAt=null;this.dFinishedAt=null;this.iElapsedTime=0;this._iAllowedTimeout=10000;this.reset();};
A.prototype.reset=function(){this._iTotalProgress=0;this._iCompletedRules=0;this._iTotalRules=0;this._bRunning=false;this._aRulePromices=[];};
A.prototype.running=function(){return this._bRunning;};
A.prototype.start=function(r,c,e){var i,t=this;this.dStartedAt=new Date();this._iTotalRules=r.length;this._bRunning=true;r.forEach(function(R){t._aRulePromices.push(new Promise(function(f){try{i=I.createIssueManagerFacade(R);if(R.async){t._runAsyncRule(i,c,e,R,f);}else{R.check(i,c,e);f();t._updateProgress();}}catch(a){t._handleException(a,R.id,f);}}));});return Promise.all(this._aRulePromices).then(function(){t.reset();t.dFinishedAt=new Date();t.iElapsedTime=t.dFinishedAt.getTime()-t.dStartedAt.getTime();});};
A.prototype._handleException=function(e,r,R){var t=e.message||e;var m="["+C.SUPPORT_ASSISTANT_NAME+"] Error while execution rule \""+r+"\": "+t;q.sap.log.error(m);R();this._updateProgress();};
A.prototype._updateProgress=function(){this._iCompletedRules++;this._iTotalProgress=Math.ceil(this._iCompletedRules/this._iTotalRules*100);if(this.onNotifyProgress){this.onNotifyProgress(this._iTotalProgress);}};
A.prototype._runAsyncRule=function(i,c,e,r,R){var t=this,T=false;var a=setTimeout(function(){T=true;t._handleException("Check function timed out",r.id,R);},this._iAllowedTimeout);new Promise(function(f){r.check(i,c,e,f);}).then(function(){if(!T){clearTimeout(a);R();t._updateProgress();}}).catch(function(b){if(!T){clearTimeout(a);t._handleException(b,r.id,R);}});};
A.prototype.getElapsedTimeString=function(){if(!this.iElapsedTime){return"";}var d=new Date(null);d.setHours(0,0,0,0);d.setMilliseconds(this.iElapsedTime);var b=[(d.getHours()<10?"0":"")+d.getHours(),(d.getMinutes()<10?"0":"")+d.getMinutes(),(d.getSeconds()<10?"0":"")+d.getSeconds(),d.getMilliseconds()];return b.join(":");};
return A;},false);
sap.ui.predefine('sap/ui/support/supportRules/Constants',[],function(){"use strict";return{TEMP_RULESETS_NAME:"temporary",SUPPORT_ASSISTANT_NAME:"Support Assistant",LOCAL_STORAGE_TEMP_RULES_KEY:"support-assistant-temprules",LOCAL_STORAGE_SELECTED_RULES_KEY:"support-assistant-selected-rules",LOCAL_STORAGE_SELECTED_CONTEXT_KEY:"support-assistant-settings-selected-context",LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY:"support-assistant-settings-selected-context-components",COOKIE_NAME:"persistence-cookie",SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR:"#bb0000",SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR:"#e78c07",SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR:"#5e696e",SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:"Low",SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:"Medium",SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:"High",SUPPORT_ASSISTANT_EXTENSION:"sap.ui.support",MAX_VISIBLE_ISSUES_FOR_RULE:5};},true);
sap.ui.predefine('sap/ui/support/supportRules/CoreFacade',[],function(){"use strict";var c=null;
function C(o){c=o;return{getMetadata:function(){return c.getMetadata();},getUIAreas:function(){return c.mUIAreas;},getComponents:function(){return c.mObjects.component;},getModels:function(){return c.oModels;}};}
return C;},true);
sap.ui.predefine('sap/ui/support/supportRules/ExecutionScope',["jquery.sap.global"],function(q){"use strict";var c=null,_=null,e=[];var g={setScope:function(){for(var i in c.mElements){e.push(c.mElements[i]);}}};var d={setScope:function(){var p=sap.ui.getCore().byId(_.parentId);e=p.findAggregatedObjects(true);}};var f={setScope:function(){var s={};_.components.forEach(function(a){var b=c.mObjects.component[a],j=b.findAggregatedObjects(true);j.forEach(function(l){s[l.getId()]=l;});});for(var i in s){if(s.hasOwnProperty(i)){e.push(s[i]);}}}};var h={global:g,subtree:d,components:f};
function k(C){var a=C.getParent().getMetadata().getAggregation(C.sParentAggregationName);return!!a;}
function m(C){var r;if(C.getRootControl){r=C.getRootControl();if(r){return[r].concat(r.findAggregatedObjects(true,k));}}return[];}
function n(C){var p=C.sParentAggregationName,P=C.getParent();if(P&&p){var b=P.getBindingInfo(p);if(b&&C instanceof b.template.getMetadata().getClass()){return true;}else{return n(P);}}return false;}
function o(a,b){var r=[];for(var i=0,l=a.length;i<l;i++){for(var j=0,s=b.length;j<s;j++){if(a[i]===b[j]){r.push(a[i]);}}}return r;}
function E(a,b){c=a;e=[];_=b;h[_.type].setScope();return{getElements:function(C){var t=this;var i={"type":null,"public":false,"cloned":true};if(C&&Object.keys(C).length){var j=e;Object.keys(i).forEach(function(p){if(C.hasOwnProperty(p)){switch(p){case"type":var l=t.getElementsByClassName(C["type"]);j=o(j,l);break;case"public":if(C["public"]===true){var r=t.getPublicElements();j=o(j,r);}break;case"cloned":if(!C["cloned"]){j=j.filter(function(s){return(n(s)===false);});}break;}}});return j;}return e;},getPublicElements:function(){var p=[];var C=a.mObjects.component;var u=a.mUIAreas;for(var i in C){p=p.concat(m(C[i]));}for(var j in u){p=p.concat(m(u[j]));}return p;},getElementsByClassName:function(i){if(typeof i==="string"){return e.filter(function(j){return j.getMetadata().getName()===i;});}if(typeof i==="function"){return e.filter(function(j){return j instanceof i;});}},getLoggedObjects:function(t){var l=q.sap.log.getLogEntries(),i=[];l.forEach(function(j){if(!j.supportInfo){return;}var p=e.map(function(v){return v.getId();});var r=!!j.supportInfo.elementId,s=j.supportInfo.type===t||t===undefined,u=!r||q.inArray(j.supportInfo.elementId,p)>-1;if(typeof t==="function"&&t(j)&&u){i.push(j);return;}if(s&&u){i.push(j);}});return i;},_getType:function(){return _.type;},_getContext:function(){return _;}};}
E.possibleScopes=Object.getOwnPropertyNames(h);return E;},true);
sap.ui.predefine('sap/ui/support/supportRules/IssueManager',["jquery.sap.global","sap/ui/base/Object","sap/ui/support/supportRules/Constants"],function(q,B,c){"use strict";var _=[];var a=[];var b=function(i){var e=sap.ui.getCore().byId(i.context.id),f="";if(i.context.id==="WEBPAGE"){f="sap.ui.core";}else if(e){f=e.getMetadata().getName();}return{severity:i.severity,name:i.rule.title,description:i.rule.description,resolution:i.rule.resolution,resolutionUrls:i.rule.resolutionurls,audiences:i.rule.audiences,categories:i.rule.categories,details:i.details,ruleLibName:i.rule.libName,ruleId:i.rule.id,async:i.rule.async===true,minVersion:i.rule.minversion,context:{className:f,id:i.context.id}};};var I={addIssue:function(i){_.push(i);},walkIssues:function(C){_.forEach(C);},clearIssues:function(){_=[];},saveHistory:function(){a.push({issues:_.slice()});},getHistory:function(){return a.slice();},getConvertedHistory:function(){var t=this,i=t.getHistory(),e=[],f=null;i.forEach(function(r){f=t.groupIssues(t.convertToViewModel(r.issues));e.push({issues:f});});return e;},getIssuesModel:function(){var v=[];this.walkIssues(function(i){v.push(b(i));});return v;},getRulesViewModel:function(r,s,i){var e={},f=0,g={},l={},h={},j=q.extend(true,{},r),k=q.extend(true,{},i);for(g in j){e[g]=q.extend(true,{},j[g].ruleset._mRules);l=e[g];Object.defineProperty(l,'selected',{enumerable:false,configurable:true,writable:true,value:false});Object.defineProperty(l,'issueCount',{enumerable:false,configurable:true,writable:true,value:0});for(h in j[g].ruleset._mRules){l[h]=q.extend(true,[],l[h]);Object.defineProperty(l[h],'selected',{enumerable:false,configurable:true,writable:true,value:false});Object.defineProperty(l[h],'issueCount',{enumerable:false,configurable:true,writable:true,value:0});if(s[h]){l[h].selected=true;l.selected=true;}if(k[g]&&k[g][h]){l[h].push.apply(l[h],k[g][h]);f=k[g][h].length;l[h].issueCount=f;l.issueCount+=f;}}}return e;},getTreeTableViewModel:function(r){var i=0,e=0,t={},f,g;f=this.getRulesViewModel(r,[],[]);for(var l in f){t[i]={name:l,type:"lib",rules:[]};for(var h in f[l]){g=f[l][h];t[i][e]={name:g.title,description:g.description,id:g.id,audiences:g.audiences,categories:g.categories,minversion:g.minversion,resolution:g.resolution,title:g.title,libName:l};e++;}i++;}return t;},getIssuesViewModel:function(i){var t={},e=0,f=0,g=0,s,h=0,m=0,l=0;for(var j in i){t[e]={name:j,showAudiences:false,showCategories:false,type:"lib"};for(var r in i[j]){s=this._sortSeverityIssuesByPriority(i[j][r]);t[e][f]={formatedName:i[j][r][0].name+" (<span style=\"color:"+c.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR+";\"> "+s.high+" H, </span> "+"<span style=\"color:"+c.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR+";\"> "+s.medium+" M, </span> "+"<span style=\"color:"+c.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR+";\"> "+s.low+" L) </span>",name:i[j][r][0].name,showAudiences:true,showCategories:true,categories:i[j][r][0].categories.join(", "),audiences:i[j][r][0].audiences.join(", "),issueCount:i[j][r].length,description:i[j][r][0].description,resolution:i[j][r][0].resolution,type:"rule",ruleLibName:i[j][r][0].ruleLibName,ruleId:i[j][r][0].ruleId,selected:i[j][r][0].selected,details:i[j][r][0].details,severity:i[j][r][0].severity};g+=i[j][r].length;f++;h+=s.high;m+=s.medium;l+=s.low;}t[e].formatedName=t[e].name+" ("+"<span style=\"color: "+c.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR+"; \"> "+h+" High, </span> "+"<span style=\"color:  "+c.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR+";\"> "+m+" Medium, </span> "+"<span style=\"color "+c.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR+";\"> "+l+" Low </span>)";t[e].name+=" ("+g+" issues)";t[e].issueCount=g;g=0;f=0;e++;h=0;m=0;l=0;}return t;},_sortSeverityIssuesByPriority:function(i){var h=0,m=0,l=0;i.forEach(function(e){switch(e.severity){case c.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:l++;break;case c.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:m++;break;case c.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:h++;break;}});return{high:h,medium:m,low:l};},clearHistory:function(){a=[];},convertToViewModel:function(o){var v=[];for(var i=0;i<o.length;i++){v.push(b(o[i]));}return v;},groupIssues:function(o){var g={},e={};for(var i=0;i<o.length;i++){e=o[i];if(!g[e.ruleLibName]){g[e.ruleLibName]={};}if(!g[e.ruleLibName][e.ruleId]){g[e.ruleLibName][e.ruleId]=[];}g[e.ruleLibName][e.ruleId].push(e);}return g;},createIssueManagerFacade:function(r){return new d(r);}};var d=function(r){this.oRule=r;};
d.prototype.addIssue=function(i){i.rule=this.oRule;if(!sap.ui.support.Severity[i.severity]){throw"The issue from rule "+this.oRule.title+" does not have proper severity defined. Allowed values can be found"+"in sap.ui.support.Severity";}if(!i.context||!i.context.id){throw"The issue from rule '"+this.oRule.title+"' should provide a context id.";}if(!i.details){throw"The issue from rule '"+this.oRule.title+"' should provide details for the generated issue.";}I.addIssue(i);};
return I;},true);
sap.ui.predefine('sap/ui/support/supportRules/Main',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSetLoader","sap/ui/support/supportRules/report/AnalysisHistoryFormatter"],function(q,M,J,A,C,E,H,a,R,b,I,D,c,d,f,g){"use strict";var h=null;var m=null;
var j=M.extend("sap.ui.support.Main",{constructor:function(){if(!m){var t=this;this._oCore=null;this._oAnalyzer=new A();this._oAnalyzer.onNotifyProgress=function(i){a.publish(c.ON_PROGRESS_UPDATE,{currentProgress:i});};f._initTempRulesLib();M.apply(this,arguments);q.sap.support={analyze:function(o,r){if(f._rulesCreated){return m.analyze(o,r);}return f._oMainPromise.then(function(){return m.analyze(o,r);});},getLastAnalysisHistory:function(){var i=this.getAnalysisHistory();if(q.isArray(i)&&i.length>0){return i[i.length-1];}else{return null;}},getAnalysisHistory:function(){if(t._oAnalyzer.running()){return null;}return I.getHistory();},getFormattedAnalysisHistory:function(){if(t._oAnalyzer.running()){return"";}return g.format(I.getConvertedHistory());}};var e=document.createEvent("CustomEvent");e.initCustomEvent("supportToolLoaded",true,true,{});}else{q.sap.log.warning("Only one support tool allowed");return m;}}});
j.prototype._isInIframe=function(){try{return window.self!==window.top;}catch(e){return true;}};
j.prototype.startPlugin=function(s){if(this._pluginStarted){return;}this._pluginStarted=true;var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(o){t._supportModeConfig=s=s||o.getConfiguration().getSupportMode();t._setCommunicationSubscriptions();var F=t._isInIframe()&&s.indexOf("frame-force-ui")!==-1;t._oCore=o;t._oDataCollector=new D(o);t._oCoreFacade=C(o);t._oExecutionScope=null;t._createCoreSpies();o.attachLibraryChanged(f._onLibraryChanged);if(!s||s.indexOf("silent")===-1||F){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(e){h=e;h.injectFrame(s);a.onMessageChecks.push(function(i){return i.origin===h.getFrameOrigin();});a.onMessageChecks.push(function(i){return i.data._frameIdentifier===h.getFrameIdentifier();});a.onMessageChecks.push(function(i){var k=h.getFrameUrl();k=k.replace(/\.\.\//g,'');return i.data._origin.indexOf(k)>-1;});});}else{f.updateRuleSets();}},stopPlugin:function(){h._stop();t._pluginStarted=false;t._oCore=null;t._oCoreFacade=null;t._oDataCollector=null;t._oExecutionScope=null;}});};
j.prototype._createCoreSpies=function(){var t=this,n=500;this._fnDirtyTimeoutHandle=null;var s=function(N){var o=t._oCore[N];t._oCore[N]=function(){o.apply(t._oCore,arguments);clearTimeout(t._fnDirtyTimeoutHandle);t._fnDirtyTimeoutHandle=setTimeout(function(){a.publish(c.ON_CORE_STATE_CHANGE);},n);};};s("registerElement");s("deregisterElement");};
j.prototype._setCommunicationSubscriptions=function(){if(this._supportModeConfig.indexOf("silent")<0){a.subscribe(c.VERIFY_CREATE_RULE,function(t){var e=R.deserialize(t),i=f.getRuleSet(d.TEMP_RULESETS_NAME).ruleset,r=i.addRule(e);a.publish(c.VERIFY_RULE_CREATE_RESULT,{result:r,newRule:R.serialize(e)});},this);a.subscribe(c.VERIFY_UPDATE_RULE,function(e){var t=R.deserialize(e.updateObj),i=f.getRuleSet(d.TEMP_RULESETS_NAME).ruleset,r=i.updateRule(e.oldId,t);a.publish(c.VERIFY_RULE_UPDATE_RESULT,{result:r,updateRule:R.serialize(t)});},this);a.subscribe(c.OPEN_URL,function(u){var w=window.open(u,"_blank");w.focus();},this);a.subscribe(c.ON_DOWNLOAD_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.downloadReportZip(e);});},this);a.subscribe(c.HIGHLIGHT_ELEMENT,function(i){var $=sap.ui.getCore().byId(i).$();$.css("background-color","red");},this);a.subscribe(c.TREE_ELEMENT_MOUSE_ENTER,function(e){H.highlight(e);},this);a.subscribe(c.TREE_ELEMENT_MOUSE_OUT,function(){H.hideHighLighter();},this);a.subscribe(c.TOGGLE_FRAME_HIDDEN,function(e){h.toggleHide(e);},this);}a.subscribe(c.POST_UI_INFORMATION,function(e){this._oDataCollector.setSupportAssistantLocation(e.location);this._oDataCollector.setSupportAssistantVersion(e.version);},this);a.subscribe(c.GET_AVAILABLE_COMPONENTS,function(){a.publish(c.POST_AVAILABLE_COMPONENTS,Object.keys(this._oCore.mObjects.component));},this);a.subscribe(c.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.selectedRules);},this);a.subscribe(c.ON_INIT_ANALYSIS_CTRL,function(){f.updateRuleSets();},this);a.subscribe(c.ON_SHOW_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.openReport(e);});},this);a.subscribe(c.LOAD_RULESETS,function(e){f.loadAdditionalRuleSets(e.aLibNames);},this);a.subscribe(c.REQUEST_RULES_MODEL,function(e){if(e){a.publish(c.GET_RULES_MODEL,I.getTreeTableViewModel(e));}},this);a.subscribe(c.REQUEST_ISSUES,function(i){if(i){var e=I.groupIssues(i),k=I.getIssuesViewModel(e);a.publish(c.GET_ISSUES,{groupedIssues:e,issuesModel:k});}},this);a.subscribe(c.GET_NON_LOADED_RULE_SETS,function(){f.fetchNonLoadedRuleSets();},this);};
j.prototype.analyze=function(e,r){var t=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return;}e=e||{type:"global"};r=r||f.getAllRuleDescriptors();if(!this._isExecutionScopeValid(e)){return;}a.publish(c.ON_ANALYZE_STARTED);if(e.selectors){this._mapExecutionScope(e);}this._oAnalyzer.reset();this.setExecutionScope(e);I.clearIssues();this._setSelectedRules(r);return this._oAnalyzer.start(this._aSelectedRules,this._oCoreFacade,this._oExecutionScope).then(function(){t._done();});};
j.prototype._isExecutionScopeValid=function(e){var o=sap.ui.getCore(),s=[],k=false,i;if(E.possibleScopes.indexOf(e.type)===-1){q.sap.log.error("Invalid execution scope type. Type must be one of the following: "+E.possibleScopes.join(", "));return false;}if(e.type=="subtree"){if(e.parentId){s.push(e.parentId);}else if(q.isArray(e.selectors)){q.merge(s,e.selectors);}else if(e.selectors){s.push(e.selectors);}for(i=0;i<s.length;i++){if(o.byId(s[i])){k=true;break;}}if(!k){a.publish(c.POST_MESSAGE,{message:"Set a valid element ID."});return false;}}return true;};
j.prototype.setExecutionScope=function(s){this._oExecutionScope=E(this._oCore,s);};
j.prototype._setSelectedRules=function(r){this._aSelectedRules=[];this._oSelectedRulesIds={};if(!r){return;}if(!Array.isArray(r)){r=[r];}r.forEach(function(o){var e,i;if(!o.libName||!o.ruleId){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Invalid Rule Descriptor.");return;}e=f.getRuleSet(o.libName);if(!e||!e.ruleset){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Ruleset for library "+o.libName);return;}i=e.ruleset.getRules();if(!i||!i[o.ruleId]){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Rule with id "+o.ruleId+" for library "+o.libName);return;}this._aSelectedRules.push(i[o.ruleId]);this._oSelectedRulesIds[o.ruleId]=true;},this);};
j.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors;}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0];}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors];}else if(Array.isArray(e.selectors)){e.components=e.selectors;}}delete e.selectors;};
j.prototype._done=function(){var i=I.getIssuesModel(),e=this._createElementTree();a.publish(c.ON_ANALYZE_FINISH,{issues:i,elementTree:e,elapsedTime:this._oAnalyzer.getElapsedTimeString()});I.saveHistory();};
j.prototype._createElementTree=function(){var e=this._copyElementsStructure(),k=[];this._setContextElementReferences(e);for(var i in e){if(e[i].skip){continue;}k.push(e[i]);}return[{content:k,id:"WEBPAGE",name:"WEBPAGE"}];};
j.prototype._setContextElementReferences=function(o){var e=this._oCore.mElements;for(var i in o){var k=o[i],p=e[i]==undefined?undefined:e[i].getParent();if(e[i]instanceof sap.ui.core.ComponentContainer){var l=e[i],n=l.getComponent();if(n){k.content.push(o[n]);o[n].skip=true;}}if(p){var r=p.getId();if(!o[r]){continue;}o[r].content.push(o[i]);o[i].skip=true;}}};
j.prototype._copyElementsStructure=function(){var e={},t=this;var k=function(n,o){for(var i in n){if(n.hasOwnProperty(i)){var r=n[i];var s={content:[],id:r.getId(),name:(o==undefined)?r.getMetadata().getName():o};e[r.getId()]=s;}}};k(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(i){if(i instanceof sap.ui.core.ComponentContainer){var n=i.getComponent(),o=t._oCore.mObjects.component[n];if(o){k([o],"sap-ui-component");}}});switch(this._oExecutionScope._getType()){case"global":k(this._oCoreFacade.getUIAreas(),"sap-ui-area");k(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var p=this._oExecutionScope._getContext().parentId;k([this._oCore.mElements[p]]);break;case"components":var l=this._oExecutionScope._getContext().components;l.forEach(function(i){k([t._oCore.mObjects.component[i]],"sap-ui-component");});break;}return e;};
j.prototype._getReportData=function(r){var i=I.groupIssues(I.getIssuesModel()),e=f.getRuleSets(),s=this._oSelectedRulesIds;return{issues:i,technical:this._oDataCollector.getTechInfoJSON(),application:this._oDataCollector.getAppInfo(),rules:I.getRulesViewModel(e,s,i),scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:r.executionScopes,executionScopeTitle:r.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:r.analysisDurationTitle,name:d.SUPPORT_ASSISTANT_NAME};};
var m=new j();return m;},true);
sap.ui.predefine('sap/ui/support/supportRules/RuleSerializer',[],function(){"use strict";return{serialize:function serializeRule(r){var a=function(k,v){if(typeof v==="function"){return v.toString();}else{return v;}};var b=JSON.stringify(r,a);return b;},deserialize:function(serializedRule,stringifyCheck){var rule;if(typeof serializedRule==='string'){rule=JSON.parse(serializedRule);}else{rule=serializedRule;}if(!stringifyCheck&&rule.check!==undefined){eval("rule.check = "+rule.check);}return rule;}};},true);
sap.ui.predefine('sap/ui/support/supportRules/RuleSet',["jquery.sap.global","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/Constants"],function(q,s,c){"use strict";var r={};var R=function(S){S=S||{};if(!S.name){q.sap.log.error("Please provide a name for the RuleSet.");}if(r[S.name]){return r[S.name];}this._oSettings=S;this._mRules={};r[S.name]=this;};
R.clearAllRuleSets=function(){r={};};
R.prototype.getRules=function(){return this._mRules;};
R.prototype.updateRule=function(a,O){var b=this._verifySettingsObject(O,true);if(b==="success"){delete this._mRules[a];this._mRules[O.id]=O;}return b;};
R.prototype._verifySettingsObject=function(S,u){if(!S.id){q.sap.log.error("Support rule needs an id.");return"Support rule needs an unique id.";}if(!u&&this._mRules[S.id]){q.sap.log.error("Support rule with the id "+S.id+" already exists.");return"Support rule with the id "+S.id+" already exists.";}if(!S.check){q.sap.log.error("Support rule with the id "+S.id+" needs a check function.");return"Support rule with the id "+S.id+" needs a check function.";}if(!S.title){q.sap.log.error("Support rule with the id "+S.id+" needs a title.");return"Support rule with the id "+S.id+" needs a title.";}if(!S.description){q.sap.log.error("Support rule with the id "+S.id+" needs a description.");return"Support rule with the id "+S.id+" needs a description.";}if(!S.resolution&&(!S.resolutionurls||!S.resolutionurls.length>0)){q.sap.log.error("Support rule with the id "+S.id+" needs either a resolution or resolutionurls or should have a ticket handler function");return"Support rule with the id "+S.id+" needs either a resolution or resolutionurls or should have a ticket handler function";}if(!S.audiences||S.audiences.length===0){q.sap.log.error("Support rule with the id "+S.id+" should have an audience. Applying audience ['Control']");S.audiences=[sap.ui.support.Audiences.Control];}if(S.audiences&&S.audiences.forEach){var i=false,a="";S.audiences.forEach(function(b){if(!sap.ui.support.Audiences[b]){i=true;a=b;}});if(i){q.sap.log.error("Audience "+a+" does not exist. Please use the audiences from sap.ui.support.Audiences");return"Audience "+a+" does not exist. Please use the audiences from sap.ui.support.Audiences";}}if(!S.categories||S.categories.length===0){q.sap.log.error("Support rule with the id "+S.id+" should have a category. Applying category ['Performance']");S.categories=["Performance"];}if(S.categories&&S.categories.forEach){var I=false,C="";S.categories.forEach(function(b){if(!sap.ui.support.Categories[b]){I=true;C=b;}});if(I){q.sap.log.error("Category "+C+" does not exist. Please use the categories from sap.ui.support.Categories");return"Category "+C+" does not exist. Please use the categories from sap.ui.support.Categories";}}return"success";};
R.prototype.addRule=function(S){var C=R.versionInfo?R.versionInfo.version:'';var a=S.minversion?S.minversion:'';if(a==='-'){a='';}if(a&&q.sap.Version(C).compareTo(a)<0){return"Rule "+S.id+" should be used with a version >= "+S.minversion;}var b=this._verifySettingsObject(S);if(b==="success"){this._mRules[S.id]=S;S.libName=this._oSettings.name;}return b;};
R.addToTempRules=function(l,t){if(t){t.forEach(function(a){var b=a.id;l[c.TEMP_RULESETS_NAME].RuleSet._mRules[b]=a;});}};
R.storeSelectionOfRules=function(l){var a=R._extractRulesSettingsToSave(l);s.setSelectedRules(a);};
R.loadSelectionOfRules=function(l){var a=s.getSelectedRules();if(!a){return;}for(var i=0;i<l.length;i+=1){var b=l[i].rules;var d=l[i].title;for(var e=0;e<b.length;e+=1){if(a[d]&&a[d].hasOwnProperty(b[e].id)){b[e].selected=a[d][b[e].id].selected;}}}};
R._extractRulesSettingsToSave=function(l){var L={};var a;var b=l.length;var d;var e;var f;for(var g=0;g<b;g+=1){e=l[g].title;L[e]={};a=l[g].rules;d=a.length;for(var h=0;h<d;h+=1){f={};f.id=a[h].id;f.selected=a[h].selected;L[e][f.id]=f;}}return L;};
return R;},true);
sap.ui.predefine('sap/ui/support/supportRules/RuleSetLoader',["jquery.sap.global","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/util/Utils"],function(q,R,C,c,b,d,U){"use strict";var g=(function(){var a;return function(u){if(!a){a=document.createElement('a');}a.href=u;return a.href;};})();var s="sprt";var S=q.sap.getModulePath("sap.ui.support");var f=S.replace('/sap/ui/support','');var A=g(f);var h={};h._mRuleSets={};
h.getRuleSets=function(){return this._mRuleSets;};
h.addRuleSet=function(l,r){this._mRuleSets[l]=r;};
h.getRuleSet=function(l){return this._mRuleSets[l];};
h._fetchSupportRuleSets=function(){var t=this,l=sap.ui.getCore().getLoadedLibraries(),L=this._fetchLibraryNamesWithSupportRules(l);var m=new Promise(function(r){R.versionInfo=sap.ui.getVersionInfo();L.then(function(o){var a=t._fetchLibraryFiles(o,h._fetchRuleSet);Promise.all(a).then(function(){t._bRulesCreated=true;C.publish(c.UPDATE_SUPPORT_RULES,b.serialize(t._mRuleSets));r();});});});return m;};
h.loadAdditionalRuleSets=function(l){var t=this,L=t._fetchLibraryFiles(l,t._fetchRuleSet);Promise.all(L).then(function(){t._bRulesCreated=true;C.publish(c.UPDATE_SUPPORT_RULES,b.serialize(t._mRuleSets));});};
h._fetchLibraryNamesWithSupportRules=function(l){return new Promise(function(m){var L={publicRules:[],internalRules:[]};l=l||{};var a=[];Object.keys(l).forEach(function(e){var M=new Promise(function(r){var i=A+"/"+e.replace(/\./g,'/')+"/.supportrc";q.ajax({type:"GET",dataType:"json",url:i,success:function(j){r({lib:e,rcData:j});},error:function(){r({lib:e,rcData:null});}});});a.push(M);});Promise.all(a).then(function(e){e.forEach(function(i){if(i.rcData){if(i.rcData.publicRules){L.publicRules.push(i.lib);}if(i.rcData.internalRules){L.internalRules.push(i.lib);}}m(L);});});});};
h._fetchLibraryFiles=function(l,p){var a=[],t=this,e=q.sap.getModulePath("sap.ui.support"),i=e.replace("sap/ui/support",""),o=sap.ui.getVersionInfo();if(l.publicRules.length>0){l.publicRules.forEach(function(L){var j=t._registerLibraryPath(L,e,i);if(j){a.push(t._requireRuleSet(j.customizableLibName,p));}});}if(!U.isDistributionOpenUI5(o)&&l.internalRules.length>0){l.internalRules.forEach(function(L){var j=t._registerLibraryPath(L,e,i);if(j){a.push(t._requireRuleSet(j.internalLibName,p));}});}return a;};
h._registerLibraryPath=function(l,a,e){if(this._mRuleSets[l]){return null;}var i=l.replace(/\./g,"/");var j=l;var k=this._getLoadFromSupportOrigin();if(k){j+='.'+s;q.sap.registerModulePath(j,e+l.replace(/\./g,"/"));}var m=j+'.internal';var n=e.replace('resources/','')+'test-resources/'+i+'/internal';q.sap.registerModulePath(m,n);return{internalLibName:m,customizableLibName:j};};
h._requireRuleSet=function(l,p){var t=this;return new Promise(function(r){try{sap.ui.require([l.replace(/\./g,"/")+"/library.support"],function(){p.call(t,l);r();});}catch(e){r();}});};
h._fetchRuleSet=function(l){try{var n,L,o,a=q.sap.getObject(l).library.support;if(!a){throw"The library.support file was not fetched successfully.";}n=l.replace("."+s,"").replace(".internal","");L=q.extend({},a);o=this._mRuleSets[n];if(!(L.ruleset instanceof R)){L=this._createRuleSet(L);}if(o){o.ruleset._mRules=q.extend(o.ruleset._mRules,L.ruleset._mRules);}else{o=L;}this._mRuleSets[n]=o;}catch(e){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Failed to load RuleSet for "+l+" library",e);}};
h._getLoadFromSupportOrigin=function(){var l=false;var a=new window.URI(q.sap.getModulePath("sap.ui.core"));var e=new window.URI(q.sap.getModulePath("sap.ui.support"));if(a.protocol()!==e.protocol()||a.host()!==e.host()){l=true;}return l;};
h.fetchNonLoadedRuleSets=function(){var l=sap.ui.getVersionInfo().libraries,a=[],L=[],o=[];l.forEach(function(i){L.push(i.name);});o={publicRules:L,internalRules:L};var e=h._fetchLibraryFiles(o,function(i){i=i.replace("."+s,"").replace(".internal","");if(a.indexOf(i)<0){a.push(i);}});Promise.all(e).then(function(){C.publish(c.POST_AVAILABLE_LIBRARIES,{libNames:a});});};
h._onLibraryChanged=function(e){var t=this;if(e.getParameter("stereotype")==="library"&&h._bRulesCreated){t._oMainPromise=h._fetchSupportRuleSets();}};
h.updateRuleSets=function(){this._oMainPromise=h._fetchSupportRuleSets();};
h._createRuleSet=function(l){var L={name:l.name,niceName:l.niceName};var r=new R(L);for(var i=0;i<l.ruleset.length;i++){var a=l.ruleset[i];if(q.isArray(a)){for(var k=0;k<a.length;k++){r.addRule(a[k]);}}else{r.addRule(a);}}return{lib:L,ruleset:r};};
h._initTempRulesLib=function(){if(this.getRuleSet(d.TEMP_RULESETS_NAME)){return;}this.addRuleSet(d.TEMP_RULESETS_NAME,{lib:{name:d.TEMP_RULESETS_NAME},ruleset:new R({name:d.TEMP_RULESETS_NAME})});};
h.getAllRules=function(){var r={};Object.keys(this._mRuleSets).map(function(l){r=q.extend(r,this._mRuleSets[l].ruleset.getRules());},this);return r;};
h.getAllRuleDescriptors=function(){var r=this.getAllRules();return Object.keys(r).map(function(a){return{libName:r[a].libName,ruleId:a};});};
return h;},true);
sap.ui.predefine('sap/ui/support/supportRules/Storage',["sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants"],function(R,a){"use strict";
function e(D){return window.btoa(unescape(encodeURIComponent(D)));}
function d(D){return decodeURIComponent(escape(window.atob(D)));}
return{getRules:function(){var r=localStorage.getItem(a.LOCAL_STORAGE_TEMP_RULES_KEY);if(!r){return null;}var t=JSON.parse(d(r));t=t.map(function(b){return R.deserialize(b);});return t;},setRules:function(r){var s=e(JSON.stringify(r));localStorage.setItem(a.LOCAL_STORAGE_TEMP_RULES_KEY,s);},getSelectedRules:function(){var r=localStorage.getItem(a.LOCAL_STORAGE_SELECTED_RULES_KEY);if(!r){return null;}return JSON.parse(r);},setSelectedRules:function(s){localStorage.setItem(a.LOCAL_STORAGE_SELECTED_RULES_KEY,JSON.stringify(s));},setSelectedContext:function(s){localStorage.setItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_KEY,JSON.stringify(s));},getSelectedContext:function(){return JSON.parse(localStorage.getItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_KEY));},setSelectedScopeComponents:function(c){localStorage.setItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY,JSON.stringify(c));},getSelectedScopeComponents:function(){var c=localStorage.getItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);return JSON.parse(c);},removeSelectedRules:function(s){this.setRules(s);},removeAllData:function(){localStorage.removeItem(a.LOCAL_STORAGE_TEMP_RULES_KEY);localStorage.removeItem(a.LOCAL_STORAGE_SELECTED_RULES_KEY);localStorage.removeItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_KEY);localStorage.removeItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);},createPersistenceCookie:function(c,C){document.cookie=c+"="+C;},readPersistenceCookie:function(C){var n=C+"=",b=decodeURIComponent(document.cookie),f=b.split(';'),o="";for(var i=0;i<f.length;i++){var c=f[i];while(c.charAt(0)==' '){c=c.substring(1);}if(c.indexOf(n)==0){o=c.substring(n.length,c.length);return o;}}return o;},deletePersistenceCookie:function(c){document.cookie=c+'=;expires=Thu, 01 Jan 1970 00:00:01 GMT;';}};},true);
sap.ui.predefine('sap/ui/support/supportRules/WCBChannels',[],function(){"use strict";return{ON_CORE_STATE_CHANGE:"ON_CORE_STATE_CHANGE",ON_SHOW_REPORT_REQUEST:"ON_SHOW_REPORT_REQUEST",ON_DOWNLOAD_REPORT_REQUEST:"ON_DOWNLOAD_REPORT_REQUEST",ON_ANALYZE_REQUEST:"ON_ANALYZE_REQUEST",ON_INIT_ANALYSIS_CTRL:"ON_INIT_ANALYSIS_CTRL",ON_PROGRESS_UPDATE:"ON_PROGRESS_UPDATE",ON_ANALYZE_STARTED:"ON_ANALYZE_STARTED",ON_ANALYZE_FINISH:"ON_ANALYZE_FINISH",POST_UI_INFORMATION:"POST_UI_INFORMATION",VERIFY_CREATE_RULE:"VERIFY_CREATE_RULE",VERIFY_RULE_CREATE_RESULT:"VERIFY_RULE_CREATE_RESULT",VERIFY_UPDATE_RULE:"VERIFY_UPDATE_RULE",VERIFY_RULE_UPDATE_RESULT:"VERIFY_RULE_UPDATE_RESULT",POST_AVAILABLE_LIBRARIES:"POST_AVAILABLE_LIBRARIES",LOAD_RULESETS:"LOAD_RULESETS",GET_AVAILABLE_COMPONENTS:"GET_AVAILABLE_COMPONENTS",POST_AVAILABLE_COMPONENTS:"POST_AVAILABLE_COMPONENTS",HIGHLIGHT_ELEMENT:"HIGHLIGHT_ELEMENT",OPEN_URL:"OPEN_URL",TREE_ELEMENT_MOUSE_ENTER:"TREE_ELEMENT_MOUSE_ENTER",TREE_ELEMENT_MOUSE_OUT:"TREE_ELEMENT_MOUSE_OUT",UPDATE_SUPPORT_RULES:"UPDATE_SUPPORT_RULES",EXTERNAL_MODULE_UPLOADED:"EXTERNAL_MODULE_UPLOADED",TOGGLE_FRAME_HIDDEN:"TOGGLE_FRAME_HIDDEN",ENSURE_FRAME_OPENED:"ENSURE_FRAME_OPENED",RESIZE_FRAME:"RESIZE_FRAME",REQUEST_RULES_MODEL:"REQUEST_RULES_MODEL",GET_RULES_MODEL:"GET_RULES_MODEL",REQUEST_ISSUES:"REQUEST_ISSUES",GET_ISSUES:"GET_ISSUES",POST_MESSAGE:"POST_MESSAGE",GET_NON_LOADED_RULE_SETS:"GET_NON_LOADED_RULE_SETS"};},true);
sap.ui.predefine('sap/ui/support/supportRules/WindowCommunicationBus',["jquery.sap.global"],function(q){"use strict";var C={channels:{},onMessageChecks:[]};var o=q.sap.getUriParameters().get("sap-ui-xx-support-origin");var a=o;var f=q.sap.getUriParameters().get("sap-ui-xx-frame-identifier")||'_unnamed_frame_-_use_message_origin_';if(!a){var m=new window.URI(q.sap.getModulePath("sap.ui.support"));var p=m.protocol()===""?window.location.protocol.replace(":",""):m.protocol();var h=m.host()===""?window.location.host:m.host();a=p+"://"+h;}C.origin=a;
C.subscribe=function(c,b,d){if(!this.channels[c]){this.channels[c]=[{callback:b,context:d}];return;}this.channels[c].push({callback:b,context:d});};
C.publish=function(c,P){var r=this._getReceivingWindow(),d={channelName:c,params:P,_frameIdentifier:f,_origin:window.location.href};r.postMessage(d,this.origin);};
C.destroyChanels=function(){C.channels={};};
C._getReceivingWindow=function(){if(window.communicationWindows&&window.communicationWindows.hasOwnProperty("supportTool")){return window.communicationWindows.supportTool;}return window.opener||window.parent;};
C._onmessage=function(e){var c=C.onMessageChecks.every(function(M){return M.call(null,e);});if(!c){q.sap.log.error("Message was received but failed validation");return;}var b=e.data.channelName,d=e.data.params,g=C.channels[b];if(!g){return;}g.forEach(function(i){i.callback.apply(i.context,[d]);});};
if(window.addEventListener){window.addEventListener("message",C._onmessage,false);}else{window.attachEvent("onmessage",C._onmessage);}if(o){C.publish("COMM_BUS_INTERNAL","READY");}return C;},true);
sap.ui.predefine('sap/ui/support/supportRules/report/AnalysisHistoryFormatter',[],function(){"use strict";var _=Array(196).join("-"),a="|";
function f(t,e){var g="",t=t||"";if(!e){e=50;}g=t.replace(/(\r\n|\n|\r)/gm," ").replace(/(\")/gm,"");if(g.length>e){g=g.substring(0,e-3)+"...";}else{while(g.length<e){g+=" ";}}return g;}
function b(r){var t=_+"\n";t+=a+f("rule id: "+r[0].ruleId,193)+a+"\n";t+=a+f("name: "+r[0].name,193)+a+"\n";t+=a+f("library: "+r[0].ruleLibName,193)+a+"\n";t+=a+f("categories: "+r[0].categories.join(", "),193)+a+"\n";t+=a+f("audiences: "+r[0].audiences.join(", "),193)+a+"\n";t+=a+f("description: "+r[0].description,193)+a+"\n";t+=a+f("resolution: "+r[0].resolution,193)+a+"\n";t+=_+"\n";t+=a+f("id",50);t+=a+f("class name",30);t+=a+f("status",10);t+=a+f("details",100);t+=a+"\n";t+=_+"\n";for(var i=0;i<r.length;i++){t+=a+f(r[i].context.id,50);t+=a+f(r[i].context.className,30);t+=a+f(r[i].severity,10);t+=a+f(r[i].details,100);t+=a+"\n";}t+=_+"\n";return t;}
function c(l){var t="";if(!l){return t;}for(var e in l){for(var r in l[e]){t+=b(l[e][r]);}t+="\n";}t+="\n";return t;}
function d(e){var t="";if(!e){return t;}for(var i=0;i<e.length;i++){t+="\n";t+="Run "+(i+1)+"\n";t+=c(e[i].issues);t+="\n";}return t;}
return{format:d};},true);
sap.ui.predefine('sap/ui/support/supportRules/report/Archiver',['jquery.sap.global','sap/ui/thirdparty/jszip','sap/ui/core/util/File'],function(q,J,F){"use strict";var A=function(){this._mData={};};
A.prototype.add=function(n,d,t){if(!n){q.sap.log.error("Archiver: No name was given.");return false;}if(!d){q.sap.log.error("Archiver: No data was given.");return false;}if(typeof d==="string"){this._mData[n]=d;return true;}else if(t){if((t==="json"||t==="har")&&(q.isPlainObject(d)||q.isArray(d))){try{this._mData[n]=JSON.stringify(d);return true;}catch(e){q.sap.log.error("Archiver: JSON data could not be serialized for "+n);}}else{q.sap.log.error("Archiver: JSON data could not be serialized for "+t+". Either the type is unknown or the data has a wrong format.");}}else{q.sap.log.error("Archiver: Data could not be serialized for "+n+". Data is is not a string or has a an invalid type.");return false;}return false;};
A.prototype.download=function(f){var z=new J();if(z){for(var n in this._mData){z.file(n,this._mData[n]);}var c=z.generate({type:"blob"});F.save(c,f,"zip","application/zip");}};
A.prototype.clear=function(){this._mData={};return true;};
A.prototype.hasData=function(n){if(n!==undefined){return this._mData.hasOwnProperty(n);}return Object.keys(this._mData).length>0;};
return A;},true);
sap.ui.predefine('sap/ui/support/supportRules/report/DataCollector',["jquery.sap.global","sap/ui/core/support/ToolsAPI","sap/ui/thirdparty/URI"],function(q,T,U){"use strict";var D=function(c){this._oCore=c;this._oSupportAssistantInfo={location:"",version:{},versionAsString:""};};
D.prototype.setSupportAssistantLocation=function(l){this._oSupportAssistantInfo.location=l;};
D.prototype.setSupportAssistantVersion=function(v){this._oSupportAssistantInfo.version=v;this._oSupportAssistantInfo.versionAsString="not available";if(v){this._oSupportAssistantInfo.versionAsString=q.sap.escapeHTML(v.version||"");this._oSupportAssistantInfo.versionAsString+=" (built at "+q.sap.escapeHTML(v.buildTimestamp||"");this._oSupportAssistantInfo.versionAsString+=", last change "+q.sap.escapeHTML(v.scmRevision||"")+")";}};
D.prototype.getSupportAssistantInfo=function(){return this._oSupportAssistantInfo;};
D.prototype.getAppInfo=function(){var a=[];for(var c in this._oCore.mObjects.component){var b=this._oCore.mObjects.component[c];var s=b.getMetadata().getManifestEntry('sap.app');a.push(s);}return a;};
D.prototype.getTechInfoJSON=function(){var c=T.getFrameworkInformation();var t={sapUi5Version:null,version:c.commonInformation.version,build:c.commonInformation.buildTime,change:c.commonInformation.lastChange,jquery:c.commonInformation.jquery,useragent:c.commonInformation.userAgent,docmode:c.commonInformation.documentMode,debug:c.commonInformation.debugMode,bootconfig:c.configurationBootstrap,config:c.configurationComputed,libraries:c.libraries,loadedLibraries:c.loadedLibraries,modules:c.loadedModules,uriparams:c.URLParameters,appurl:c.commonInformation.applicationHREF,title:c.commonInformation.documentTitle,statistics:c.commonInformation.statistics,resourcePaths:[],themePaths:[],locationsearch:document.location.search,locationhash:document.location.hash,supportAssistant:this._oSupportAssistantInfo};var m=q.sap.getAllDeclaredModules();var r=[];for(var i=0;i<m.length;i++){r.push({moduleName:m[i],relativePath:q.sap.getResourcePath(m[i]),absolutePath:U(q.sap.getResourcePath(m[i])).absoluteTo(document.location.origin+document.location.pathname).toString()});}t.resourcePaths=r;var l=this._oCore.getLoadedLibraries();r=[];for(var n in l){var p=this._oCore._getThemePath(n,this._oCore.oConfiguration.theme);r.push({theme:this._oCore.oConfiguration.theme,library:n,relativePath:p,absolutePath:U(p).absoluteTo(document.location.origin+document.location.pathname).toString()});}t.themePaths=r;try{t.sapUi5Version={version:sap.ui.getVersionInfo(),path:sap.ui.resource("","sap-ui-version.json")};}catch(e){t.sapUi5Version=null;}return t;};
return D;},true);
sap.ui.predefine('sap/ui/support/supportRules/report/IssueRenderer',['jquery.sap.global'],function(q){'use strict';var _=false;
function g(v){if(v){if(q.isArray(v)){return q.sap.escapeHTML(v.join(', '));}else{return q.sap.escapeHTML(v);}}else{return'';}}
function r(f,h,j,l){var m='';var n='';var o=1;var t=0;for(var p in h){var s=h[p];t+=s.length;var u=s[0];n+='<tr id="'+j+'_rule_'+o+'" >';n+='<td>';n+='<div class="expandable-control collapsed-content" data-expandableElement="'+j+'_rule_'+o+'_content">';n+='<div class="expandable-title"> '+o+'. '+g(u.name)+' <span class="rule-issue-number">('+s.length+' issues)</span></div></div>';n+='<div id="'+j+'_rule_'+o+'_content">';n+='<div><span class="sapUiSupportLabel">Description: </span>'+g(u.description)+'</div>';n+='<div><span class="sapUiSupportLabel">Min version: </span>'+g(u.minVersion)+'</div>';n+='<div><span class="sapUiSupportLabel">Async: </span>'+g(u.async.toString())+'</div>';n+='<div><span class="sapUiSupportLabel">Resolution: </span>'+g(u.resolution)+'</div>';n+='<div>';if(u.resolutionUrls){for(var k=0;k<u.resolutionUrls.length;k++){n+='<div><a href="'+g(u.resolutionUrls[k].href)+'" target="_blank">'+g(u.resolutionUrls[k].text)+'</a></div>';}}n+='</div>';n+='<table class="sapUiTable"><tr><th></th><th>Element Id</th><th>Class</th><th>Status</th><th>Details</th></tr>';for(var i=0;i<s.length;i++){n+='<tr class="filterable" data-severity="'+g(s[i].severity)+'"><td>'+(i+1)+'</td><td>'+g(s[i].context.id)+'</td>';n+='<td>'+g(s[i].context.className)+'</td>';n+='<td class="'+g(s[i].severity)+'">'+g(s[i].severity)+'</td>';n+='<td>'+g(s[i].details)+'</td></tr>';}n+='</table>';n+='</div></td>';n+='<td>'+g(u.categories)+'</td>';n+='<td>'+g(u.audiences)+'</td>';n+='</tr>';o++;}var v='collapsed-content';if(l===1){v='expanded-content';}m+='<tr>';m+='<td colspan="100" class="expandable-control '+v+'" data-expandableElement="'+j+'" data-groupName="'+f+'" data-groupNumber="'+l+'">';m+='<span class="sapUiSupportLabel expandable-title"> '+l+'. '+f+' ('+(o-1)+' rules, '+t+' issues)</span>';m+='</td></tr><tbody id="'+j+'">';m+=n;m+='</tbody>';return m;}
function a(f){var h='';var i=1;if(!f){return h;}try{h+='<table class="sapUiTable"><tr><th>Name</th><th>Categories</th><th>Audiences</th></tr>';for(var j in f){h+=r(j,f[j],'group'+i,i);i++;}h+='</table>';}catch(k){q.sap.log.warning('There was a problem extracting issues info.');h='';}return h;}
function b(s,f,i){if(!f){return'';}var h=i?'filter-active':'';return'<div data-severity="'+s+'" class="filter '+h+' '+s+'">'+s+'('+f+')</div>'+' | ';}
function c(f){var h='',s={},j,i,t=0,k=[],l={},m={},n={};if(!f){return h;}try{for(n in f){l=f[n];for(m in l){k=l[m];for(i=0;i<k.length;i++){j=k[i].severity;if(s[j]){s[j]++;}else{s[j]=1;}t++;}}}h+=b('Total',t,true);h+=b('High',s['High'],false);h+=b('Medium',s['Medium'],false);h+=b('Low',s['Low'],false);}catch(o){q.sap.log.warning('There was a problem creating severity filters.');h='';}return h;}
function d(i,f){var h='';if(f){h+='<div class="filters">'+c(i)+'<div>\n';}h+='<div>'+a(i)+'</div>';return'<div>'+h+'</div>';}
function e(i){if(!q("#qunit")||!i){return;}var f=q(this.render(i));q("#qunit").append(f);if(!_){var s=[q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/styles.css'),q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/collapseExpand.css'),q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/filter.css')];var h=q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/collapseExpand.js');var j=q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/filter.js');q.each(s,function(k,v){q('<link>').appendTo('head').attr({type:'text/css',rel:'stylesheet',href:v});});q.getScript(h,function(){window.sapUiSupportReport.collapseExpand.init();});q.getScript(j,function(){window.sapUiSupportReport.filter.init();});_=true;}else{window.sapUiSupportReport.collapseExpand.init();window.sapUiSupportReport.filter.init();}}
return{render:d,renderIssuesForOPA:e};},true);
sap.ui.predefine('sap/ui/support/supportRules/report/ReportProvider',['jquery.sap.global','sap/ui/thirdparty/handlebars','sap/ui/support/supportRules/report/Archiver','sap/ui/support/supportRules/report/IssueRenderer'],function(q,H,A,I){'use strict';var r=q.sap.getResourcePath('sap/ui/support/supportRules/report/resources');var b=[{url:r+'/ReportTemplate.html',type:'template'},{url:r+'/styles.css',type:'css'},{url:r+'/filter.css',type:'css'},{url:r+'/collapseExpand.css',type:'css'},{url:r+'/filter.js',type:'js'},{url:r+'/collapseExpand.js',type:'js'}];var t={line:function(a,i,u,v,w){a.push("<tr><td ",i?"align='right' ":"","valign='top'>","<label class='sapUiSupportLabel'>",q.sap.escapeHTML(v||""),"</label></td><td",u?" class='sapUiSupportTechInfoBorder'":"",">");var x=w;if(q.isFunction(w)){x=w(a);}a.push(q.sap.escapeHTML(x||""));a.push("</td></tr>");},multiline:function(a,u,w,x,y){var z=this;z.line(a,u,w,x,function(a){a.push("<table border='0' cellspacing='0' cellpadding='3'>");q.each(y,function(i,v){var B="";if(v){if(typeof(v)==="string"||typeof(v)==="string"||typeof(v)==="boolean"){B=v;}else if((q.isArray(v)||q.isPlainObject(v))&&window.JSON){B=window.JSON.stringify(v);}}z.line(a,false,false,i,""+B);});a.push("</table>");});},subheader:function(a,i){a.push("<tr class='sapUiSupportTitle'><td valign='top' colspan='2'>","<label class='sapUiSupportLabel'>",q.sap.escapeHTML(i||""),"</label></td></tr>");}};
function g(a){return q.ajax({type:'GET',url:a.url,dataType:'text'}).then(function(i){return{content:i,type:a.type};});}
function c(){var a=[];for(var i=0;i<b.length;i++){a.push(g(b[i]));}return q.when.apply(q,a);}
function d(a){var u='';if(!a){return new H.SafeString(u);}try{a.modules.sort();var w=["<div class='sapUiSupportToolbar'>","<div><div class='sapUiSupportTechInfoCntnt'>","<table border='0' cellpadding='3'>"];t.subheader(w,"Support Assistant Information");t.line(w,true,true,"Location",a.supportAssistant.location);t.line(w,true,true,"Version",a.supportAssistant.versionAsString);t.subheader(w,"Application Information");t.line(w,true,true,"SAPUI5 Version",function(i){var v=a.sapUi5Version;if(v&&v.version){var V=v.version;var y=q.sap.escapeHTML(V.version||"");i.push(y," (built at ",q.sap.escapeHTML(V.buildTimestamp||""),", last change ",q.sap.escapeHTML(V.scmRevision||""),")");}else{i.push("not available");}});t.line(w,true,true,"Core Version",function(i){return a.version+" (built at "+a.build+", last change "+a.change+")";});t.line(w,true,true,"Loaded jQuery Version",function(i){return a.jquery;});t.line(w,true,true,"User Agent",function(i){return a.useragent+(a.docmode?", Document Mode '"+a.docmode+"'":"");});t.line(w,true,true,"Application",a.appurl);t.multiline(w,true,true,"Configuration (bootstrap)",a.bootconfig);t.multiline(w,true,true,"Configuration (computed)",a.config);if(!q.isEmptyObject(a.libraries)){t.multiline(w,true,true,"Libraries",a.libraries);}t.multiline(w,true,true,"Loaded Libraries",a.loadedLibraries);t.line(w,true,true,"Loaded Modules",function(y){q.each(a.modules,function(i,v){if(v.indexOf("sap.ui.core.support")<0){y.push("<span>",q.sap.escapeHTML(v||""),"</span>");if(i<a.modules.length-1){y.push(", ");}}});});t.multiline(w,true,true,"URI Parameters",a.uriparams);w.push("</table></div>");u=w.join('');}catch(x){q.sap.log.warning('There was a problem extracting technical info.');}return new H.SafeString(u);}
function e(v){var a='<td>';if(v){a+=q.sap.escapeHTML(v);}a+='</td>';return a;}
function f(a){var u='';if(!a){return new H.SafeString(u);}u+='<table class="sapUiTable"><tr><th>Component ID</th><th>Type</th><th>Title</th><th>Subtitle</th><th>Application version</th><th>Description</th><th>BCP Component</th></tr>';try{for(var i=0;i<a.length;i++){var v=a[i];u+='<tr>';u+=e(v.id);u+=e(v.type);u+=e(v.title);u+=e(v.subTitle);if(v.applicationVersion){u+=e(v.applicationVersion.version);}else{u+='<td></td>';}u+=e(v.description);u+=e(v.ach);u+='</tr>';}u+='</table>';}catch(w){q.sap.log.warning('There was a problem extracting app info.');u='';}return new H.SafeString(u);}
function h(a){var i='';i+='<div><span class="sapUiSupportLabel">'+a.displayName+'</span>';i+='<span> ('+a.description+')</span></div>';return i;}
function j(a,i){var u='';u+='<div><span class="sapUiSupportLabel">'+i.displayName+' with id:</span> '+a;u+='<span> ('+i.description+')</span></div>';return u;}
function k(a,u){var v='';if(a.length>5){v+='<div class="expandable-control collapsed-content" data-expandableElement="execution-scope-components">';v+='<span class="expandable-title"><span class="sapUiSupportLabel">'+u.displayName+'</span>';v+='<span> ('+u.description+')</span></span></div>';}else{v+='<div><span class="sapUiSupportLabel">'+u.displayName+'</span>';v+='<span> ('+u.description+')</span></div>';}v+='<ol id="execution-scope-components" class="top-margin-xsmall">';for(var i=0;i<a.length;i++){v+='<li>'+a[i]+'</li>';}v+='</ol>';return v;}
function l(a){var i='';try{var u=a.executionScope._getType();var v=a.scopeDisplaySettings.executionScopes[u];var w=a.scopeDisplaySettings.executionScopeTitle;i+='<div class="sapUiSupportLabel">'+w+': </div>';switch(u){case'global':i+=h(v);break;case'subtree':i+=j(a.executionScope._getContext().parentId,v);break;case'components':i+=k(a.executionScope._getContext().components,v);break;}}catch(x){q.sap.log.warning('There was a problem extracting scope info.');i='';}return new H.SafeString(i);}
function m(a){var i='';if(!a){return new H.SafeString(i);}try{var u=1;i+='<table class="sapUiTable"><tbody><tr><th>Name</th><th>Description</th><th>Categories</th><th>Audiences</th></tr></tbody>';for(var v in a){var w=a[v];var x='collapsed-content';if(u===1){x='expanded-content';}var y=a[v].selected?' ('+a[v].issueCount+' issues)':'';var z='<span class="checked" style="'+(a[v].selected?'':'visibility: hidden;')+'"> &#10004; </span>';i+='<tbody><tr><td colspan="100" ';i+='class="expandable-control '+x+'" data-expandableElement="section-selected-rules-group'+u+'">'+z;i+='<span class="sapUiSupportLabel expandable-title"> '+v+y+'</span>';i+='</td></tr></tbody>';var B='';for(var C in w){var D=w[C].selected?' ('+w[C].issueCount+' issues)':'';var E='<span class="checked" style="'+(w[C].selected?'':'visibility: hidden;')+'"> &#10004; </span>';B+='<tr>';B+='<td>'+E+w[C].title+D+'</td>';B+='<td>'+w[C].description+'</td>';B+='<td>'+w[C].categories.join(', ')+'</td>';B+='<td>'+w[C].audiences.join(', ')+'</td>';B+='</tr>';}i+='<tbody id="section-selected-rules-group'+u+'">'+B+'</tbody>';u++;}i+='</table>';}catch(F){q.sap.log.warning('There was a problem extracting selected rules info.');i='';}return new H.SafeString(i);}
function n(b,a){var u='';if(a!=='script'&&a!=='style'){return u;}for(var i=0;i<b.length;i++){switch(a){case'script':u+='<script>'+b[i]+'</script>\n';break;case'style':u+='<style type="text/css">'+b[i]+'</style>\n';break;}}return new H.SafeString(u);}
H.registerHelper('getTechnicalInformation',function(a){return d(a);});H.registerHelper('getRules',function(a){return m(a);});H.registerHelper('getIssues',function(i){return new H.SafeString(I.render(i,true));});H.registerHelper('getAppInfo',function(a){return f(a);});H.registerHelper('getScope',function(a){return l(a);});H.registerHelper('getScripts',function(a){return n(a,'script');});H.registerHelper('getStyles',function(a){return n(a,'style');});
function o(D){return c().then(function(){var a=[],u=[],v='',i,w={},x={};for(i=0;i<arguments.length;i++){switch(arguments[i].type){case'template':v=arguments[i].content;break;case'css':a.push(arguments[i].content);break;case'js':u.push(arguments[i].content);break;}}w=H.compile(v);x={technicalInfo:D.technical,issues:D.issues,appInfo:D.application,rules:D.rules,metadata:{title:D.name+' Analysis Results',title_TechnicalInfo:'Technical Information',title_Issues:'Issues',title_AppInfo:'Application Information',title_SelectedRules:'Available and (<span class="checked">&#10004;</span>) Executed Rules',timestamp:new Date(),scope:D.scope,analysisDuration:D.analysisDuration,analysisDurationTitle:D.analysisDurationTitle,styles:a,scripts:u}};return w(x);});}
function p(D){this.getReportHtml(D).done(function(a){var i='<!DOCTYPE HTML><html><head><title>Report</title></head><body><div id="sap-report-content">'+a+'</div></body></html>';var u={'issues':D.issues};var v={'appInfos':D.application};var w={'technicalInfo':D.technical};var x=new A();x.add('technicalInfo.json',w,'json');x.add('issues.json',u,'json');x.add('appInfos.json',v,'json');x.add('report.html',i);x.download("SupportAssistantReport");x.clear();});}
function s(D){var i='';var a=q('<a style="display: none;"/>');a.on('click',function(){var u=window.open('','_blank');q(u.document).ready(function(){if(u.document.getElementById('sap-report-content')){u.document.getElementById('sap-report-content').innerHtml=i;}else{u.document.write('<div id="sap-report-content">'+i+'</div>');}u.document.title='Report';});});q('body').append(a);this.getReportHtml(D).then(function(u){i=u;a[0].click();a.remove();});}
return{getReportHtml:o,downloadReportZip:p,openReport:s};},true);
sap.ui.predefine('sap/ui/support/supportRules/ui/IFrameController',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants"],function(q,M,C,c,a){"use strict";var i=null;var f;var F;var s;
function b(u){var e=new window.URI(u);var O=(e.protocol()||window.location.protocol.replace(':',''))+'://'+(e.host()||window.location.host);return O;}
function g(){return''+ +new Date();}
function o(u){var t=document.createElement("IFRAME");var e=t.style;t.id="sap-ui-supportToolsFrame";t.src=u;e.width="100%";e.height="28px";e.position="absolute";e.left="0";e.bottom="0";e.border="none";e.zIndex="1001";e.boxShadow="1px -10px 42px -4px #888";document.body.appendChild(t);setInterval(function(){if(t.parentNode.nodeName!=="BODY"){document.body.appendChild(t);window.communicationWindows.supportTool=t.contentWindow;}},1000);window.communicationWindows.supportTool=t.contentWindow;}
function d(u){window.communicationWindows.supportTool=window.open(u,"sapUiSupportTool","width=1024,height=400,status=no,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,scrollbars=no");window.communicationWindows.supportTool.window.onload=function(){window.communicationWindows.supportTool.document.title=a.SUPPORT_ASSISTANT_NAME;};}
var I=M.extend("sap.ui.support.IFrameController",{constructor:function(){if(!i){M.apply(this,arguments);}else{q.sap.log.warning("Only one support tool allowed");return i;}}});
I.prototype._setCommunicationSubscriptions=function(){C.subscribe(c.ENSURE_FRAME_OPENED,function(){if(document.getElementById("sap-ui-supportToolsFrame").style.height==="28px"){this.resizeFrame(true);this.toggleHide();}},this);C.subscribe(c.RESIZE_FRAME,function(p){i.resizeFrame(p.bigger);});};
I.prototype.injectFrame=function(e){F=g();s=q.sap.getModulePath("sap.ui.support.supportRules.ui","/overlay.html?sap-ui-xx-formfactor=compact&sap-ui-xx-support-origin="+window.location.protocol+"//"+window.location.host+"&"+"sap-ui-xx-frame-identifier="+F);f=b(s);window.communicationWindows=window.communicationWindows||{};if(e.indexOf("window")>-1){d(s);}else{o(s);this._setCommunicationSubscriptions();}};
I.prototype.resizeFrame=function(e){var t=document.getElementById("sap-ui-supportToolsFrame").style;if(e){if(t.height==="50%"){t.height="100%";}else if(t.height==="28px"){t.height="50%";}}else{if(t.height==="100%"){t.height="50%";}else if(t.height==="50%"){t.height="28px";}}};
I.prototype.toggleHide=function(h){var t=document.getElementById("sap-ui-supportToolsFrame").style;if(h){this._originalSize={width:t.width,height:t.height};t.width="170px";t.height="28px";}else{if(this._originalSize){t.width=this._originalSize.width;t.height=this._originalSize.height;this._originalSize=null;}}};
I.prototype._stop=function(){this._oCssLink.parentNode.removeChild(this._oCssLink);this._oDomRef.parentNode.removeChild(this._oCssLink);this._oCore=null;};
I.prototype.getFrameOrigin=function(){return f;};
I.prototype.getFrameIdentifier=function(){return F;};
I.prototype.getFrameUrl=function(){return s;};
i=new I();return i;},true);
sap.ui.predefine('sap/ui/support/supportRules/ui/controllers/Analysis.controller',["jquery.sap.global","sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/model/json/JSONModel","sap/m/Panel","sap/m/List","sap/m/ListItemBase","sap/m/StandardListItem","sap/m/InputListItem","sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Label","sap/m/MessageToast","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/Storage"],function($,BaseController,JSONModel,Panel,List,ListItemBase,StandardListItem,InputListItem,Button,Toolbar,ToolbarSpacer,Label,MessageToast,CommunicationBus,channelNames,SharedModel,RuleSerializer,constants,Ruleset,storage){"use strict";return BaseController.extend("sap.ui.support.supportRules.ui.controllers.Analysis",{onInit:function(){this.model=SharedModel;this.setCommunicationSubscriptions();this.tempRulesLoaded=false;this.getView().setModel(this.model);this.treeTable=this.byId("ruleList");this.ruleSetView=this.byId("ruleSetsView");this.rulesViewContainer=this.byId("rulesNavContainer");this.bAdditionalViewLoaded=false;CommunicationBus.subscribe(channelNames.UPDATE_SUPPORT_RULES,function(){if(!this.bAdditionalViewLoaded){CommunicationBus.publish(channelNames.RESIZE_FRAME,{bigger:true});this.bAdditionalViewLoaded=true;this.loadAdditionalUI();}},this);},loadAdditionalUI:function(){this._ruleDetails=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.RuleDetails",this);this.byId("rulesDisplayPage").addContentArea(this._ruleDetails);this._ruleCreateUpdatePages=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.RuleUpdate",this);this._ruleCreateUpdatePages.forEach(function(r){this.byId("rulesNavContainer").insertPage(r);},this);this._updateRuleList();},onAfterRendering:function(){var t=function(){CommunicationBus.publish(channelNames.ON_INIT_ANALYSIS_CTRL);sap.ui.getCore().detachThemeChanged(t);};if(sap.ui.getCore().isThemeApplied()){CommunicationBus.publish(channelNames.ON_INIT_ANALYSIS_CTRL);}else{sap.ui.getCore().attachThemeChanged(t);}},onAsyncSwitch:function(e){var s=e.getSource();if(e.getParameter("selected")){var a=s.getCustomData()[0].getValue()==="true";var r=s.getProperty("groupName")==="asyncContext"?"/newRule":"/editRule";this.model.setProperty(r+"/async",a);this._updateCheckFunction(r,a);}},_updateCheckFunction:function(r,a){var c=this.model.getProperty(r+"/check");if(!c){return;}var m=c.match(/function[^(]*\(([^)]*)\)/);if(!m){return;}var p=m[1].trim().split(/\W+/);p[0]=p[0]||"oIssueManager";p[1]=p[1]||"oCoreFacade";p[2]=p[2]||"oScope";if(a){p[3]=p[3]||"fnResolve";}else{p=p.slice(0,3);}var n=c.replace(/function[^(]*\(([^)]*)\)/,"function ("+p.join(", ")+")");this.model.setProperty(r+"/check",n);},getTemporaryLib:function(){var l=this.model.getProperty("/libraries");for(var i=0;i<l.length;i++){if(l[i].title==constants.TEMP_RULESETS_NAME){return l[i];}}},updateTreeViewTempRulesSelection:function(t){this.treeTable.expand(0);for(var r in t){var R=Number.parseInt(r,10);if(!Number.isInteger(R)){continue;}R++;var a=t[r];if(a.selected){this.treeTable.addSelectionInterval(R,R);}else{this.treeTable.removeSelectionInterval(R,R);}}},setCommunicationSubscriptions:function(){CommunicationBus.subscribe(channelNames.UPDATE_SUPPORT_RULES,this.updatesupportRules,this);CommunicationBus.subscribe(channelNames.VERIFY_RULE_CREATE_RESULT,function(d){var r=d.result,n=RuleSerializer.deserialize(d.newRule,true),t=this.getTemporaryLib(),a=this.model.getProperty('/treeViewModel'),b;if(r=="success"){t.rules.push(n);b=this._syncTreeTableVieModelTempRulesLib(t,a);this._syncTreeTableVieModelTempRulesLib(t,a);if(this.model.getProperty("/persistingSettings")){storage.setRules(t.rules);if(this.showRuleCreatedToast){MessageToast.show('Your temporary rule "'+n.id+'" was persisted in the local storage');this.showRuleCreatedToast=false;}}var e=this.model.getProperty("/newEmptyRule");this.model.setProperty("/newRule",jQuery.extend(true,{},e));this.goToRuleProperties();this.model.setProperty("/selectedRule",n);this.updateTreeViewTempRulesSelection(b);this._updateRuleList();}else{MessageToast.show("Add rule failed because: "+r);}},this);CommunicationBus.subscribe(channelNames.VERIFY_RULE_UPDATE_RESULT,function(d){var r=d.result,u=RuleSerializer.deserialize(d.updateRule,true),t=this;if(r==="success"){var a=this.model.getProperty("/editRuleSource"),b=this.model.getProperty('/treeViewModel');var l=this.model.getProperty('/libraries');l.forEach(function(c,e){if(c.title===constants.TEMP_RULESETS_NAME){c.rules.forEach(function(f,g){if(f.id===a.id){c.rules[g]=u;if(t.model.getProperty("/persistingSettings")){storage.setRules(c.rules);}}});t._syncTreeTableVieModelTempRule(u,b);}});this.model.checkUpdate(true);this.model.setProperty('/selectedRule',u);this.goToRuleProperties();}else{MessageToast.show("Update rule failed because: "+r);}},this);CommunicationBus.subscribe(channelNames.POST_AVAILABLE_LIBRARIES,function(d){this.model.setProperty("/availableLibrariesSet",d.libNames);this.rulesViewContainer.setBusy(false);},this);CommunicationBus.subscribe(channelNames.POST_AVAILABLE_COMPONENTS,function(d){var e=[],m=this.model.getProperty("/executionScopeComponents"),s=storage.getSelectedScopeComponents(),i;for(var c=0;c<d.length;c+=1){e.push({text:d[c]});}if(m&&m.length>0){for(i=0;i<e.length;i++){e[i].selected=this.checkIfComponentIsSelected(e[i],m);}}else if(s&&s.length>0){for(i=0;i<e.length;i++){e[i].selected=this.checkIfComponentIsSelected(e[i],s);}}this.model.setProperty("/executionScopeComponents",e);},this);CommunicationBus.subscribe(channelNames.GET_RULES_MODEL,function(t){var i=this.model.getProperty("/initialRulesLoading");if(i){this.model.setProperty("/initialRulesLoading",false);this.model.setProperty("/treeViewModel",t);this.initializeSelection();}else{this._syncSelections(t);}},this);CommunicationBus.subscribe(channelNames.POST_MESSAGE,function(d){MessageToast.show(d.message);},this);CommunicationBus.subscribe(channelNames.ON_ANALYZE_STARTED,function(d){this.model.setProperty("/showProgressIndicator",true);},this);},checkIfComponentIsSelected:function(c,s){for(var i=0;i<s.length;i+=1){if(s[i].text==c.text&&s[i].selected){return true;}}return false;},onAnalyze:function(){var s=this._getSelectedRules(),e=this._getExecutionContext();if(!s.length>0){MessageToast.show("Select some rules to be analyzed.");return;}if(e.type==="components"&&e.components.length===0){MessageToast.show("Please select some components to be analyzed.");return;}CommunicationBus.publish(channelNames.ON_ANALYZE_REQUEST,{selectedRules:s,executionContext:e});},_getExecutionContext:function(){var c={type:this.model.getProperty("/analyzeContext/key")};if(c.type==="subtree"){c.parentId=this.model.getProperty("/subtreeExecutionContextId");}if(c.type==="components"){var s=sap.ui.getCore().byId("componentsSelectionContainer"),a=s.getContent();c.components=[];a.forEach(function(b){if(b.getSelected()){c.components.push(b.getText());}});}return c;},onSelectedRuleSets:function(e){if(e.getParameter("selectedKey")==="additionalRulesets"){this.rulesViewContainer.setBusyIndicatorDelay(0);this.rulesViewContainer.setBusy(true);CommunicationBus.publish(channelNames.GET_NON_LOADED_RULE_SETS);}},_getSelectedRules:function(){var r=this.getView().getModel().getProperty("/treeViewModel"),R,l,o,s=[];for(l in r){if(Number.isInteger(Number.parseInt(l,10))){for(R in r[l]){o=r[l][R];if(Number.isInteger(Number.parseInt(R,10))&&o.selected){s.push({libName:o.libName,ruleId:o.id});}}}}return s;},_syncTreeTableVieModelTempRulesLib:function(t,a){var b=0,l,r;for(var i in a){l=a[i];if(l.name!==constants.TEMP_RULESETS_NAME){continue;}for(var c in t.rules){r=t.rules[c];l[b]={name:r.title,description:r.description,id:r.id,audiences:r.audiences,categories:r.categories,minversion:r.minversion,resolution:r.resolution,title:r.title,selected:l[b]!==undefined?l[b].selected:l.selected,libName:l.name,check:r.check};b++;}return l;}},_syncTreeTableVieModelTempRule:function(t,a){var r=this.model.getProperty("/editRuleSource");for(var i in a){if(a[i].name===constants.TEMP_RULESETS_NAME){for(var b in a[i]){if(a[i][b].id===r.id){a[i][b]={name:t.title,description:t.description,id:t.id,audiences:t.audiences,categories:t.categories,minversion:t.minversion,resolution:t.resolution,title:t.title,libName:a[i].name,check:t.check};}}}}},_hasSelectedComponent:function(){var a=sap.ui.getCore().byId("componentsSelectionContainer").getContent();function i(c){return c.getSelected();}return a.some(i);},onAnalyzeSettings:function(e){CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);if(!this._settingsPopover){this._settingsPopover=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.AnalyzeSettings",this);this.getView().addDependent(this._settingsPopover);}this._settingsPopover.openBy(e.getSource());},onContextSelect:function(e){if(e.getParameter("selected")){var s=e.getSource(),r=s.getCustomData()[0].getValue(),a=this.model.getProperty("/executionScopes")[r];if(r==="components"&&!this._hasSelectedComponent()){var c=sap.ui.getCore().byId("componentsSelectionContainer").getContent();if(c.length>0){c[0].setSelected(true);this.onScopeComponentSelect(null);}}this.model.setProperty("/analyzeContext",a);}if(storage.readPersistenceCookie(constants.COOKIE_NAME)){this.persistExecutionScope();}},onExecutionContextChange:function(e){var v=e.getSource().getValue();if(v){this.model.setProperty("/subtreeExecutionContextId",v);}if(storage.readPersistenceCookie(constants.COOKIE_NAME)){this.persistExecutionScope();}},onScopeComponentSelect:function(e){var s=this.model.getProperty("/executionScopeComponents");if(storage.readPersistenceCookie(constants.COOKIE_NAME)){storage.setSelectedScopeComponents(s);}},onBeforePopoverOpen:function(){if(this.model.getProperty("/executionScopeComponents").length===0){CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);}},createNewRulePress:function(e){var a=this.model.getProperty("/newEmptyRule");this.model.setProperty("/selectedSetPreviewKey","availableRules");this.model.setProperty("/newRule",jQuery.extend(true,{},a));this.model.setProperty("/tempLink",{href:"",text:""});this.goToCreateRule();},goToRuleProperties:function(){var n=this.byId("rulesNavContainer");n.to(this.byId("rulesDisplayPage"),"show");},createRuleString:function(r){if(!r){return'';}var s="{\n",c=0,k=Object.keys(r).length;for(var a in r){var v=r[a];c++;s+="\t";s+=a+": ";if(a==="check"){s+=v.split("\n").join("\n\t");}else{s+=JSON.stringify(v);}if(c<k){s+=",";}s+="\n";}s+="}";return s;},updateRule:function(){var o=this.model.getProperty("/editRuleSource/id"),u=this.model.getProperty("/editRule");if(this.checkFunctionString(u.check)){CommunicationBus.publish(channelNames.VERIFY_UPDATE_RULE,{oldId:o,updateObj:RuleSerializer.serialize(u)});}},updatesupportRules:function(d){d=RuleSerializer.deserialize(d);CommunicationBus.publish(channelNames.REQUEST_RULES_MODEL,d);var l=[],t=this;for(var i in d){var r=[],a=d[i].ruleset._mRules;for(var j in a){var b=a[j];b.libName=i;b.selected=true;r.push(b);}l.push({title:i,type:"library",rules:r});}var f;if(l[0].rules[0]){f=l[0].rules[0];}else{f=l[1].rules[0];}t.placeTemporaryRulesetAtStart(l);t.model.setProperty("/selectedRuleStringify","");t.model.setProperty("/selectedRule",f);t.model.setProperty("/selectedRuleStringify",t.createRuleString(f));t.model.setProperty("/libraries",l);var c=storage.getRules(),e=t.model.getProperty("/loadingAdditionalRuleSets");if(e){MessageToast.show("Additional rule set(s) loaded!");this.ruleSetView.setSelectedKey("availableRules");}if(c&&!e&&!this.tempRulesLoaded){this.tempRulesLoaded=true;c.forEach(function(g){CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE,RuleSerializer.serialize(g));});}},placeTemporaryRulesetAtStart:function(l){for(var i=0;i<l.length;i++){var r=l[i];if(r.title===constants.TEMP_RULESETS_NAME){var t=r;l.splice(i,1);l.unshift(t);return;}}},addLinkToRule:function(e){var t=this.model.getProperty("/tempLink"),c=jQuery.extend(true,{},t),a=e.getSource().getProperty("text"),r=a==='Add'?"/newRule":"/editRule",u=this.model.getProperty(r+"/resolutionurls");if(u){u.push(c);}else{this.model.setProperty(r+"/resolutionurls","");u.push(c);}this.model.setProperty("/tempLink",{href:"",text:""});this.model.checkUpdate(true,true);},goToCreateRule:function(){var n=this.byId("rulesNavContainer");n.to(sap.ui.getCore().byId("rulesCreatePage"),"show");},checkFunctionString:function(functionString){try{eval("var testAsignedVar = "+functionString);}catch(err){MessageToast.show("Your check function contains errors, and can't be evaluated:"+err);return false;}return true;},addNewRule:function(){var n=this.model.getProperty("/newRule");if(this.checkFunctionString(n.check)){this.showRuleCreatedToast=true;CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE,RuleSerializer.serialize(n));}},rulesToolbarITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var n=this.model.getProperty("/newRule"),s=this.createRuleString(n);this.model.setProperty("/newRuleStringified",s);}},rulesToolbarEditITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var n=this.model.getProperty("/editRule"),s=this.createRuleString(n);this.model.setProperty("/updateRuleStringified",s);}},loadMarkedSupportLibraries:function(){var l=this.byId("availableLibrariesSet"),L=l.getSelectedItems().map(function(i){return i.getTitle();});l.getItems().forEach(function(i){i.setSelected(false);});if(L.length>0){CommunicationBus.publish(channelNames.LOAD_RULESETS,{aLibNames:{publicRules:L,internalRules:L}});this.model.setProperty("/loadingAdditionalRuleSets",true);}else{MessageToast.show("Select additional RuleSet to be loaded.");}},onCellClick:function(e){if(e.getParameter("rowBindingContext")){var s=e.getParameter("rowBindingContext").getObject(),a;if(s.id){a=this.getMainModelFromTreeViewModel(s);var b=this.createRuleString(a);this.model.setProperty("/selectedRuleStringify",b);}this.model.setProperty("/selectedRule",a);}},getMainModelFromTreeViewModel:function(s){var a=this.model.getProperty("/libraries"),m=null;a.forEach(function(l,i){a[i].rules.forEach(function(e){if(s.id===e.id){m=e;}});});return m;},duplicateRule:function(e){var p=e.getSource().getBindingContext().getPath(),s=this.getView().getModel().getProperty(p),a=this.getMainModelFromTreeViewModel(s),b=jQuery.extend(true,{},a);this.model.setProperty("/newRule",b);this.model.checkUpdate(true,false);this.goToCreateRule();},editRule:function(e){var p=e.getSource().getBindingContext().getPath(),s=this.getView().getModel().getProperty(p),a=this.getMainModelFromTreeViewModel(s);this.model.setProperty("/editRuleSource",a);this.model.setProperty("/editRule",jQuery.extend(true,{},a));this.model.checkUpdate(true,true);var n=this.byId("rulesNavContainer");n.to(sap.ui.getCore().byId("ruleUpdatePage"),"show");},deleteTemporaryRule:function(e){var s=this.getObjectOnTreeRow(e),t=this.model.getProperty("/treeViewModel"),m=this.model.getProperty("/libraries"),r=[];m.forEach(function(l,b){if(l.title===constants.TEMP_RULESETS_NAME){l.rules.forEach(function(c,d){if(c.id===s.id){l.rules.splice(d,1);return;}else{r.push(c);}});}});for(var i in t){if(t[i].name===constants.TEMP_RULESETS_NAME){for(var a in t[i]){if(t[i][a].id===s.id){delete t[i][a];}}}}this.model.setProperty("/treeViewModel",t);storage.removeSelectedRules(r);this._updateRuleList();},getObjectOnTreeRow:function(e){var p=e.getSource().getBindingContext().getPath(),s=this.getView().getModel().getProperty(p),l=this.model.getProperty("/libraries");l.forEach(function(a,b){a.rules.forEach(function(r){if(r.id===s.id){s.check=r.check;}});});return s;},onToggleOpenState:function(e){var i=e.getParameter("rowIndex"),r=e.getParameter("rowContext"),E=e.getParameter("expanded"),t=this.treeTable,R=t.getRows(),v=this.getVisualIndex(r),o=R[v],a=o.getModel(),b=o.getBindingContext(),p=b.getPath(),m=a.getProperty(p),k,s,c=i+1;if(!E){return;}for(k in m){if(Number.isInteger(Number.parseInt(k,10))){s=a.getProperty(p+"/"+k+"/selected");if(s){t.addSelectionInterval(c,c);}else{t.removeSelectionInterval(c,c);}c++;}}},onRowSelectionChange:function(e){var i=e.getParameter("rowIndex"),r=e.getParameter("rowContext"),R=e.getParameter("rowIndices"),u=e.getParameter("userInteraction");if(e.getParameter("selectAll")){this.selectAllRows(true);return;}if(i===-1){this.selectAllRows(false);return;}if(!u||R.length!=1||R[0]!=i){return;}var t=this.treeTable,a=t.getRows(),v=this.getVisualIndex(r),o=a[v],b=o.getModel(),B=o.getBindingContext(),p=B.getPath(),m=b.getProperty(p),s=!b.getProperty(p+"/selected"),c,k;b.setProperty(p+"/selected",s);if(this.isRowAGroup(o)){c=this.getChildIndicesRange(o,i);if(!c){return;}for(k in m){if(Number.isInteger(Number.parseInt(k,10))){b.setProperty(p+"/"+k+"/selected",s);}}if(t.isExpanded(i)){if(s){t.addSelectionInterval(c.from,c.to);}else{t.removeSelectionInterval(c.from,c.to);}}}else{this.updateLibrarySelection(p,s);}if(storage.readPersistenceCookie(constants.COOKIE_NAME)){this.persistSelection();}},isRowAGroup:function(r){if(!r){return false;}var R=r.getModel();if(!R){return false;}var b=r.getBindingContext(),p=b.getPath();return R.getProperty(p+"/rules")!==undefined;},getChildIndicesRange:function(r,R){var o=r.getModel(),b=r.getBindingContext(),p=b.getPath(),m=o.getProperty(p),f=R+1,t=R,k;for(k in m){if(Number.isInteger(Number.parseInt(k,10))){t++;}}if(f>t){return;}return{from:f,to:t};},getVisualIndex:function(r){var R=this.treeTable.getRows(),o,i;for(i=0;i<R.length;i++){o=R[i];if(o.getBindingContext()==r){return i;}}},getRowContextIndexByPath:function(p){var r=0,R=this.treeTable.getContextByIndex(r);while(R){if(R.getPath()==p){return r;}r++;R=this.treeTable.getContextByIndex(r);}},initializeSelection:function(){var p=this.model.getProperty("/persistingSettings"),m=this.getView().getModel(),i={},l=[],s;if(p){s=storage.getSelectedRules()||[];if(s.length===0){return;}i=this._buildTreeTableIndex();s.forEach(function(r){var R=i[r.ruleId];if(R){m.setProperty(R.path+"/selected",true);this.treeTable.addSelectionInterval(R.index,R.index);if(i[R.libName]){l[R.libName]=i[R.libName];}}},this);this.updateLibrariesSelection(l);}else{this.treeTable.selectAll();}},selectAllRows:function(s){var m=this.getView().getModel(),t=m.getProperty("/treeViewModel/"),l;for(var i in t){if(Number.isInteger(Number.parseInt(i,10))){m.setProperty("/treeViewModel/"+i+"/selected",s);l=m.getProperty("/treeViewModel/"+i);for(var k in l){if(Number.isInteger(Number.parseInt(k,10))){m.setProperty("/treeViewModel/"+i+"/"+k+"/selected",s);}}}}if(storage.readPersistenceCookie(constants.COOKIE_NAME)){this.persistSelection();}},updateLibrarySelection:function(p,s){var m=this.getView().getModel(),r=this.getRowContextIndexByPath(p),l,a;while(r>=0){a=this.treeTable.getContextByIndex(r);p=a.getPath();l=m.getProperty(p);if(l.type==="lib"){break;}r--;}if(s){for(var i in l){if(Number.isInteger(Number.parseInt(i,10))&&!l[i].selected){return;}}this.treeTable.addSelectionInterval(r,r);}else{this.treeTable.removeSelectionInterval(r,r);}m.setProperty(p+"/selected",s);},updateLibrariesSelection:function(l){var m=this.getView().getModel(),L,b;for(var s in l){L=m.getProperty(l[s].path);b=true;for(var i in L){if(Number.isInteger(Number.parseInt(i,10))){if(!L[i].selected){b=false;break;}}}this.updateLibrarySelection(l[s].path,b);}},_syncSelections:function(n){var I=this._buildTreeTableIndex(),l=[],L={},N;for(var i in n){if(Number.isInteger(Number.parseInt(i,10))){for(var k in n[i]){var r=I[n[i][k].id];if(Number.isInteger(Number.parseInt(k,10))&&r&&r.selected){n[i][k].selected=r.selected;if(l.indexOf(n[i][k].libName)<0){l.push(n[i][k].libName);}}}}}this.model.setProperty("/treeViewModel",n);N=this._buildTreeTableIndex();l.forEach(function(s){if(N[s]){L[s]=N[s];}});for(var K in N){if(N[K].type==="lib"&&!I[K]){L[K]=N[K];}}this.updateLibrariesSelection(L);},_buildTreeTableIndex:function(){var i=0,p=this.treeTable.getBinding().getPath()+'/',m=this.getView().getModel(),I={},l=m.getProperty(p+i),s=0,g=0,r;while(l){I[l.name]={index:g,path:p+i,libName:l.name,type:"lib",selected:l.selected};g++;r=m.getProperty(p+i+'/'+s);while(r){I[r.id]={index:g,path:p+i+'/'+s,libName:r.libName,type:"rule",selected:r.selected};s++;g++;r=m.getProperty(p+i+'/'+s);}i++;l=m.getProperty(p+i);}return I;},_updateRuleList:function(){var r=this.getView().byId("ruleList"),t=this.getTemporaryLib()["rules"];if(!t.length){r.setRowActionCount(1);}else{r.setRowActionCount(2);}}});});
sap.ui.predefine('sap/ui/support/supportRules/ui/controllers/BaseController',["sap/ui/core/mvc/Controller","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/Constants"],function(C,s,c){"use strict";return C.extend("sap.ui.support.supportRules.ui.controllers.BaseController",{onPersistedSettingSelect:function(){var m=this.getView().getModel();if(m.getProperty("/persistingSettings")){s.createPersistenceCookie(c.COOKIE_NAME,true);m.getProperty("/libraries").forEach(function(l){if(l.title==c.TEMP_RULESETS_NAME){s.setRules(l.rules);}});this.persistExecutionScope();this.persistSelection();}else{s.deletePersistenceCookie(c.COOKIE_NAME);this.deletePersistedData();}},persistExecutionScope:function(){var a={analyzeContext:this.model.getProperty("/analyzeContext"),subtreeExecutionContextId:this.model.getProperty("/subtreeExecutionContextId")},b=this.model.getProperty("/executionScopeComponents");s.setSelectedScopeComponents(b);s.setSelectedContext(a);},persistSelection:function(){var m=this.getView().getModel(),S=[],r;for(var i in m.getProperty("/treeViewModel/")){if(Number.isInteger(Number.parseInt(i,10))){for(var k in m.getProperty("/treeViewModel/"+i)){r=m.getProperty("/treeViewModel/"+i+"/"+k);if(Number.isInteger(Number.parseInt(k,10))&&r&&r.selected){S.push({ruleId:r.id,libName:r.libName});}}}}s.setSelectedRules(S);},deletePersistedData:function(){s.deletePersistenceCookie(c.COOKIE_NAME);this.getView().getModel().setProperty("/persistingSettings",false);s.removeAllData();}});});
sap.ui.predefine('sap/ui/support/supportRules/ui/controllers/Issues.controller',["jquery.sap.global","sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/formatter","sap/ui/support/supportRules/Constants","sap/m/OverflowToolbarAssociativePopoverControls"],function($,B,J,C,S,E,I,c,f,a,O){"use strict";var i={severityIcons:{High:"sap-icon://message-error",Medium:"sap-icon://message-warning",Low:"sap-icon://message-information",All:"sap-icon://multiselect-all"}};return B.extend("sap.ui.support.supportRules.ui.controllers.Issues",{ISSUES_LIMIT:1000,formatter:f,onInit:function(){this.model=S;this.setCommunicationSubscriptions();this.getView().setModel(this.model);this.clearFilters();this._initElementTree();this.treeTable=this.byId("issuesList");this.issueTable=this.byId("issueTable");this.toolHeader=this.byId('toolHeader');this.toolHeader.removeStyleClass('sapTntToolHeader sapContrast sapContrastPlus');var t=this.toolHeader._getPopover();t.removeStyleClass('sapTntToolHeaderPopover sapContrast sapContrastPlus');O._mSupportedControls["sap.ui.layout.VerticalLayout"]={canOverflow:true,listenForEvents:[],noInvalidationProps:[]};},setCommunicationSubscriptions:function(){C.subscribe(c.ON_ANALYZE_FINISH,function(d){var t=this;var p={};t.data=d;d.issues.forEach(function(b){if(!b.context||!b.context.id){return;}if(!p[b.context.id]){p[b.context.id]=[b.name];}else{p[b.context.id].push(b.name);}});this.model.setSizeLimit(this.ISSUES_LIMIT);this.model.setProperty("/issues",d.issues);this.model.setProperty('/analyzePressed',true);this.model.setProperty("/issuesCount",this.data.issues.length);this.model.setProperty("/selectedIssue",null);this.elementTree.setData({controls:d.elementTree,issuesIds:p});this.clearFilters();},this);C.subscribe(c.GET_ISSUES,function(d){this.structuredIssuesModel=d.groupedIssues;this.model.setProperty("/issues",d.issuesModel);if(d.issuesModel[0]){this._setSelectedRule(d.issuesModel[0][0]);this.treeTable.setSelectedIndex(1);this.issueTable.setSelectedIndex(0);}},this);},_initElementTree:function(){var t=this;this.elementTree=new E(null,{onIssueCountClicked:function(s){t.clearFilters();t.model.setProperty("/elementFilter",s);t.updateIssuesVisibility();},onHoverChanged:function(h){C.publish(c.TREE_ELEMENT_MOUSE_ENTER,h);},onMouseOut:function(){C.publish(c.TREE_ELEMENT_MOUSE_OUT);}});},onAfterRendering:function(){this.elementTree.setContainerId(this.byId("elementTreeContainer").getId());},clearFilters:function(){this.model.setProperty("/severityFilter","All");this.model.setProperty("/categoryFilter","All");this.model.setProperty("/elementFilter","All");this.model.setProperty("/audienceFilter","All");if(this.data){this.model.setProperty("/issues",this.data.issues);this.setToolbarHeight();}this.updateIssuesVisibility();},clearFiltersAndElementSelection:function(){this.clearFilters();this.elementTree.clearSelection();},onIssuePressed:function(e){var s=this.model.getProperty("/selectedIssue");this.elementTree.setSelectedElement(s.context.id,false);},onRowSelectionChanged:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject(),v=a.MAX_VISIBLE_ISSUES_FOR_RULE;if(s.type==="rule"){this._setSelectedRule(s);}else{this.model.setProperty("/selectedIssue",null);}if(s.issueCount<v){v=s.issueCount;}this.model.setProperty("/visibleRowCount",v);}},openDocumentation:function(e){var l=sap.ui.getCore().byId(e.mParameters.id),u=l.getBindingContext().getProperty("href");C.publish(c.OPEN_URL,u);},updateIssuesVisibility:function(){if(this.data){var b=this.data.issues.filter(this.filterIssueListItems,this);C.publish(c.REQUEST_ISSUES,b);this.model.setProperty("/visibleIssuesCount",b.length);}this.setToolbarHeight();},filterIssueListItems:function(b){var s=this.model.getProperty("/severityFilter"),d=b.severity===s||s==='All',e=this.model.getProperty("/categoryFilter"),g=$.inArray(e,b.categories)>-1||e==='All',h=this.model.getProperty("/elementFilter"),j=h===b.context.id||h==='All',k=this.model.getProperty("/audienceFilter"),l=$.inArray(k,b.audiences)>-1||k==='All';return d&&g&&j&&l;},setToolbarHeight:function(){this.model.setProperty("/filterBarHeight","4rem");},onReportPress:function(e){var o=e.getParameter("item"),b=o.getText(),d=this._getReportData();if(b==='View'){C.publish(c.ON_SHOW_REPORT_REQUEST,d);}else{C.publish(c.ON_DOWNLOAD_REPORT_REQUEST,d);}},_getReportData:function(){return{executionScopes:this.model.getProperty("/executionScopes"),executionScopeTitle:this.model.getProperty("/executionScopeTitle"),analysisDurationTitle:this.model.getProperty("/analysisDurationTitle")};},onRowSelection:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject();this.elementTree.setSelectedElement(s.context.id,false);this.model.setProperty("/selectedIssue/details",s.details);}},_setSelectedRule:function(s){var b,d;if(this.model.getProperty("/visibleIssuesCount")>0){b=this.structuredIssuesModel[s.ruleLibName][s.ruleId];d=jQuery.extend(true,{},s);d.issues=b;d.resolutionUrls=b[0].resolutionUrls;this.issueTable.setSelectedIndex(0);this.model.setProperty("/selectedIssue/details",d.details);this.model.setProperty("/selectedIssue",d);this._setIconAndColorToIssue(d.issues);}else{this.model.setProperty("/selectedIssue",null);}},_setIconAndColorToIssue:function(b){b.forEach(function(e){switch(e.severity){case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:e.severityIcon=i.severityIcons.Low;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR;break;case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:e.severityIcon=i.severityIcons.Medium;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR;break;case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:e.severityIcon=i.severityIcons.High;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR;break;}});}});});
sap.ui.predefine('sap/ui/support/supportRules/ui/controllers/Main.controller',["sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage","sap/ui/thirdparty/URI","sap/m/library"],function(B,J,C,S,c,a,s,U,l){"use strict";return B.extend("sap.ui.support.supportRules.ui.controllers.Main",{onInit:function(){this.model=S;this.getView().setModel(this.model);this.resizeDown();this.setCommunicationSubscriptions();this.initSettingsPopoverModel();this.hidden=false;this.model.setProperty("/hasNoOpener",window.opener?false:true);this.model.setProperty("/constants",a);this.updateShowButton();this._setContextSettings();this.bAdditionalViewLoaded=false;C.subscribe(c.UPDATE_SUPPORT_RULES,function(){if(!this.bAdditionalViewLoaded){this.bAdditionalViewLoaded=true;this.loadAdditionalUI();}},this);},loadAdditionalUI:function(){this._issuesPage=sap.ui.xmlview(this.getView().getId()+"--issues","sap.ui.support.supportRules.ui.views.Issues");this.byId("navCon").insertPage(this._issuesPage);},onAfterRendering:function(){C.publish(c.POST_UI_INFORMATION,{version:sap.ui.getVersionInfo(),location:new U(jQuery.sap.getModulePath("sap.ui.support"),window.location.origin+window.location.pathname).toString()});},initSettingsPopoverModel:function(){var b=new U(sap.ui.resource('sap.ui.support',''),window.location.origin+window.location.pathname)._string,d=sap.ui.version;this.model.setProperty("/supportAssistantOrigin",b);this.model.setProperty("/supportAssistantVersion",d);},copySupportAssistantOriginToClipboard:function(e){var b=this.model.getProperty("/supportAssistantOrigin"),d=function(e){if(e.clipboardData){e.clipboardData.setData('text/plain',b);}else{e.originalEvent.clipboardData.setData('text/plain',b);}e.preventDefault();};if(window.clipboardData){window.clipboardData.setData("text",b);}else{document.addEventListener('copy',d);document.execCommand('copy');document.removeEventListener('copy',d);}},setCommunicationSubscriptions:function(){C.subscribe(c.ON_ANALYZE_FINISH,function(d){this._clearProcessIndicator();this.ensureOpened();this.model.setProperty("/showProgressIndicator",false);this.model.setProperty("/coreStateChanged",false);this.model.setProperty("/lastAnalysisElapsedTime",d.elapsedTime);this.goToIssues();this.model.setProperty("/analyzedFinish",true);},this);C.subscribe(c.ON_PROGRESS_UPDATE,function(d){var b=d.currentProgress,p=this.byId("progressIndicator");p.setDisplayValue(b+"/"+100);this.model.setProperty("/progress",b);},this);C.subscribe(c.ON_CORE_STATE_CHANGE,function(){this.model.setProperty("/coreStateChanged",true);},this);},resizeUp:function(){C.publish(c.RESIZE_FRAME,{bigger:true});},ensureOpened:function(){C.publish(c.ENSURE_FRAME_OPENED);},resizeDown:function(){C.publish(c.RESIZE_FRAME,{bigger:false});},onSettings:function(e){C.publish(c.ENSURE_FRAME_OPENED);if(!this._settingsPopover){this._settingsPopover=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.StorageSettings",this);this.getView().addDependent(this._settingsPopover);}var t=this,o=e.getSource();setTimeout(function(){t._settingsPopover.openBy(o);});},goToAnalysis:function(e){this._setActiveView("analysis");},goToIssues:function(e){this._setActiveView("issues");},_pingUrl:function(u){return jQuery.ajax({type:"HEAD",async:true,context:this,url:u});},_redirectToUrlWithFallback:function(u){this._pingUrl(u).then(function success(){l.URLHelper.redirect(u,true);},function error(){jQuery.sap.log.info("Support Assistant tried to load documentation link in "+u+"but fail");u="https://ui5.sap.com/#/topic/57ccd7d7103640e3a187ed55e1d2c163";l.URLHelper.redirect(u,true);});},goToWiki:function(){var u="",v="",f=sap.ui.getVersionInfo().version,m=jQuery.sap.Version(f).getMajor(),M=jQuery.sap.Version(f).getMinor(),o=window.location.origin;if(M%2!==0){M--;}v+=String(m)+"."+String(M);if(o.indexOf("veui5infra")!==-1){u=o+"/sapui5-sdk-internal/#/topic/57ccd7d7103640e3a187ed55e1d2c163";}else{u=o+"/demokit-"+v+"/#/topic/57ccd7d7103640e3a187ed55e1d2c163";}this._redirectToUrlWithFallback(u);},setRulesLabel:function(b){var d=0;if(b===null){return"Rules ("+d+")";}else{b.forEach(function(e,f){d+=e.rules.length;});return"Rules ("+d+")";}},updateShowButton:function(){this.byId("sapSTShowButtonBar").setVisible(this.hidden);},toggleHide:function(){this.hidden=!this.hidden;this.updateShowButton();C.publish(c.TOGGLE_FRAME_HIDDEN,this.hidden);},_clearProcessIndicator:function(){var p=this.byId("progressIndicator");p.setDisplayValue("None");this.model.setProperty("/progress",0.1);},_setContextSettings:function(){var b=s.readPersistenceCookie(a.COOKIE_NAME);if(b){this.model.setProperty("/persistingSettings",true);var d=s.getSelectedContext();if(d){this.model.setProperty("/analyzeContext",d.analyzeContext);this.model.setProperty("/subtreeExecutionContextId",d.subtreeExecutionContextId);}else{this.model.setProperty("/analyzeContext",this.model.getProperty("/analyzeContext"));this.model.setProperty("/subtreeExecutionContextId","");}}},_setActiveView:function(i){this.byId("issuesBtn").setType(sap.m.ButtonType.Default);this.byId("analysisBtn").setType(sap.m.ButtonType.Default);this.byId(i+"Btn").setType(sap.m.ButtonType.Emphasized);this.byId("navCon").to(this.byId(i),"show");this.ensureOpened();}});});
sap.ui.predefine('sap/ui/support/supportRules/ui/external/ElementTree',["jquery.sap.global"],function(q){"use strict";
function _(h){return(typeof h==="object"&&!Array.isArray(h)&&h!==null);}
function a(o){return"<ul "+o.attributes.join(" ")+">";}
function b(){return"</ul>";}
function c(o,h){var i="<li data-id=\""+o.id+"\" ";if(h){i+="issue";}i+=">";return i;}
function d(){return"</li>";}
function e(h,p){var i="<offset style=\"padding-left:"+p+"px\" >";if(h.content.length>0){i+="<arrow down=\"true\"></arrow>";}else{i+="<place-holder></place-holder>";}i+="</offset>";return i;}
function f(h,n){var s=h.name.split(".");var i=s[s.length-1];var j=h.name.replace(i,"");var k=(n>0)?"showNumbOfIssues":"hideNumbOfIssues";return"<tag data-search=\""+h.name+h.id+"\">"+"&#60;"+"<namespace>"+j+"</namespace>"+i+"<attribute>&#32;id=\"<attribute-value>"+h.id+"</attribute-value>\"</attribute>"+"&#62;"+"</tag>"+"<span class = "+k+">["+n+"  issue(s)] </span>";}
function g(h,p){while(h.nodeName!==p){if(h.nodeName==="CONTROL-TREE"){break;}h=h.parentNode;}return h;}
function E(i,h){var j=_(h);var o;if(j){o=h;}else{o={};}this._ElementTreeContainer=document.getElementById(i);this.onIssueCountClicked=o.onIssueCountClicked?o.onIssueCountClicked:function(){};this.onSelectionChanged=o.onSelectionChanged?o.onSelectionChanged:function(s){};this.onHoverChanged=o.onHoverChanged?o.onHoverChanged:function(k){};this.onMouseOut=o.onMouseOut?o.onMouseOut:function(){};this.onInitialRendering=o.onInitialRendering?o.onInitialRendering:function(){};this.setData(o.data);}
E.prototype.init=function(){if(!this._ElementTreeContainer){return;}this._createHTML();this._createHandlers();this.onInitialRendering();};
E.prototype.getData=function(){return this._data;};
E.prototype.setData=function(h){var o=this.getData();var i=_(h);if(i===false){q.sap.log.warning("The parameter should be an Object");return;}if(JSON.stringify(o)===JSON.stringify(h)){return;}this._data=h;if(this._isFirstRendering===undefined){this.init();this._isFirstRendering=true;}else{this._createTree();}return this;};
E.prototype.setContainerId=function(i){this._ElementTreeContainer=document.getElementById(i);this.init();};
E.prototype.getSelectedElement=function(){return this._selectedElement;};
E.prototype.setSelectedElement=function(h,n){var s;if(typeof h!=="string"){q.sap.log.warning("Please use a valid string parameter");return;}s=this._ElementTreeContainer.querySelector("[data-id="+h+"]");if(s===null){q.sap.log.warning("The selected element is not a child of the ElementTree");return;}this._selectedElement=s;this._selectTreeElement(s,n);return this;};
E.prototype.clearSelection=function(){var s=this._ElementTreeContainer.querySelector("[selected]");if(s){s.removeAttribute("selected");}};
E.prototype._createHTML=function(){var h;h=this._createFilter();h+=this._createTreeContainer();this._ElementTreeContainer.innerHTML=h;this._setReferences();if(this.getData()!==undefined){this._createTree();}};
E.prototype._createFilter=function(){return"<filter>"+"<end>"+"<label><input type=\"checkbox\" issues checked/>Issues</label>"+"<label><input type=\"checkbox\" namespaces checked/>Namespaces</label>"+"<label><input type=\"checkbox\" attributes/>Attributes</label>"+"</end>"+"</filter>";};
E.prototype._createTreeContainer=function(){return"<tree show-namespaces show-problematic-elements></tree>";};
E.prototype._createTree=function(){var h=this.getData().controls;this._treeContainer.innerHTML=this._createTreeHTML(h);};
E.prototype._createTreeHTML=function(h,l){if(h===undefined||h.length===0){return"";}var i="";var n=l||0;var p=++n*10;var t=this;var j=this.getData().issuesIds;h.forEach(function(k){i+=a({attributes:["expanded=\"true\""]});var m=j[k.id]!==undefined?true:false;var o=0;var o=m?j[k.id].length:0;i+=c({id:k.id},m);i+=e(k,p);i+=f(k,o);i+=d();i+=t._createTreeHTML(k.content,n);i+=b();});return i;};
E.prototype._toggleCollapse=function(t){var h=g(t.parentNode,"UL");if(t.getAttribute("right")==="true"){t.removeAttribute("right");t.setAttribute("down","true");h.setAttribute("expanded","true");}else if(t.getAttribute("down")==="true"){t.removeAttribute("down");h.removeAttribute("expanded");t.setAttribute("right","true");}};
E.prototype._selectTreeElement=function(t,n){var h=g(t,"LI");var i=h.attributes["data-id"];if(!i){return;}var j=i.value;if(j===this._ElementTreeContainer.id){return;}this._scrollToElement(h,window);if(n){this.onSelectionChanged(j);}this.clearSelection();h.setAttribute("selected","true");if(n){this.onIssueCountClicked(j);}};
E.prototype._scrollToElement=function(t,w){var h=this._treeContainer.offsetHeight-this._treeContainer.offsetTop+this._treeContainer.scrollTop;if(t.offsetTop>h||t.offsetTop<this._treeContainer.scrollTop){this._treeContainer.scrollTop=t.offsetTop-w.innerHeight/6;}};
E.prototype._searchInTree=function(u){var s=this._ElementTreeContainer.querySelectorAll("[data-search]");var h=u.toLocaleLowerCase();var j;for(var i=0;i<s.length;i++){j=s[i].getAttribute("data-search").toLocaleLowerCase();if(j.indexOf(h)!==-1){s[i].parentNode.setAttribute("matching",true);}else{s[i].parentNode.removeAttribute("matching");}}};
E.prototype._removeAttributesFromSearch=function(){var h=this._treeContainer.querySelectorAll("[matching]");for(var i=0;i<h.length;i++){h[i].removeAttribute("matching");}};
E.prototype._setSearchResultCount=function(h){this._filterContainer.querySelector("results").innerHTML="("+h+")";};
E.prototype._onArrowClick=function(h){var t=h.target;if(t.nodeName==="ARROW"){this._toggleCollapse(t);}else{this._selectTreeElement(t,true);}};
E.prototype._onSearchInput=function(h){var t=h.target;var s;if(t.getAttribute("search")!==null){if(t.value.length!==0){this._searchInTree(t.value);}else{this._removeAttributesFromSearch("matching");}s=this._treeContainer.querySelectorAll("[matching]").length;this._setSearchResultCount(s);}};
E.prototype._onSearchEvent=function(h){var s;if(h.target.value.length===0){this._removeAttributesFromSearch("matching");s=this._treeContainer.querySelectorAll("[matching]").length;this._setSearchResultCount(s);}};
E.prototype._onOptionsChange=function(h){var t=h.target;if(t.getAttribute("filter")!==null){if(t.checked){this._treeContainer.setAttribute("show-filtered-elements",true);}else{this._treeContainer.removeAttribute("show-filtered-elements");}}if(t.getAttribute("issues")!==null){if(t.checked){this._treeContainer.setAttribute("show-problematic-elements",true);}else{this._treeContainer.removeAttribute("show-problematic-elements");}}if(t.getAttribute("namespaces")!==null){if(t.checked){this._treeContainer.setAttribute("show-namespaces",true);}else{this._treeContainer.removeAttribute("show-namespaces");}}if(t.getAttribute("attributes")!==null){if(t.checked){this._treeContainer.setAttribute("show-attributes",true);}else{this._treeContainer.removeAttribute("show-attributes");}}};
E.prototype._onTreeElementMouseHover=function(h){var t=g(h.target,"LI");var i=this._ElementTreeContainer.querySelector("[hover]");if(i){i.removeAttribute("hover");}t.setAttribute("hover","true");var j=t.attributes["data-id"];this.onHoverChanged(j&&j.value);};
E.prototype._onTreeElementMouseOut=function(h){this.onMouseOut();};
E.prototype._createHandlers=function(){this._treeContainer.onclick=this._onArrowClick.bind(this);this._filterContainer.onkeyup=this._onSearchInput.bind(this);this._filterContainer.onsearch=this._onSearchEvent.bind(this);this._filterContainer.onchange=this._onOptionsChange.bind(this);this._ElementTreeContainer.onmouseover=this._onTreeElementMouseHover.bind(this);this._ElementTreeContainer.onmouseout=this._onTreeElementMouseOut.bind(this);};
E.prototype._setReferences=function(){this._filterContainer=this._ElementTreeContainer.querySelector("filter");this._treeContainer=this._ElementTreeContainer.querySelector("tree");};
return E;});
sap.ui.predefine('sap/ui/support/supportRules/ui/external/Highlighter',[],function(){"use strict";var _=null;
function a(){_.style.display="none";}
function b(){_.style.display="block";}
function c(){var h=document.createElement("div");h.style.cssText="box-sizing: border-box;border:1px solid blue;background: rgba(20, 20, 200, 0.4);position: absolute";var d=document.createElement("div");d.id="ui5-highlighter";d.style.cssText="position: fixed;top:0;right:0;bottom:0;left:0;z-index: 1000;overflow: hidden;";d.appendChild(h);document.body.appendChild(d);_=document.getElementById("ui5-highlighter");_.onmouseover=a;}
return{highlight:function(e){var h;var t;var d;if(_===null&&!document.getElementById("ui5-highlighter")){c();}else{b();}h=_.firstElementChild;t=document.getElementById(e);if(t){d=t.getBoundingClientRect();h.style.top=d.top+"px";h.style.left=d.left+"px";h.style.height=d.height+"px";h.style.width=d.width+"px";}return this;},hideHighLighter:a};});
sap.ui.predefine('sap/ui/support/supportRules/ui/models/SharedModel',["sap/ui/support/library","sap/ui/model/json/JSONModel"],function(l,J){"use strict";var A=l.Audiences,C=l.Categories,S=l.Severity,e={global:{key:"global",displayName:"Global",description:"The Rules will be / are executed on the complete application with all loaded elements and components, including all previously loaded pages"},subtree:{key:"subtree",displayName:"Sub-tree",description:"The Rules will be / are executed on the specified sub-tree root element, including all child elements (aggregated sub-elements)"},components:{key:"components",displayName:"Component(s)",description:"The Rules will be / are executed on the selected components from the list of currently loaded components (or fragments)"}};var m=new J({selectedRule:null,libraries:null,selectedIssue:null,issues:[],progress:0.1,showProgressIndicator:false,coreStateChanged:true,analyzePressed:false,selectedRulePreviewKey:"ruleProperties",selectedRuleCreateKey:"ruleProperties",selectedRuleEditKey:"ruleProperties",selectedSetPreviewKey:"availableRules",newRule:{},newRuleStringified:"",updateRuleStringified:"",subtreeExecutionContextId:"",availableComponents:[],audiences:A,categories:C,severities:S,audiencesFilter:["All"].concat(Object.keys(A)),categoriesFilter:["All"].concat(Object.keys(C)),severitiesFilter:["All"].concat(Object.keys(S)),newEmptyRule:{libName:"",id:"",categories:[C.Other],audiences:[A.Internal],title:"",description:"",resolution:"",resolutionurls:[],check:"function (oIssueManager, oCoreFacade, oScope) {\n\t/* \n\t oIssueManager - allows you to add new issues with the addIssue() method \n\t oCoreFacade - gives you access to state of the core: getMetadata(), getUIAreas(), getComponents(), getModels() \n\t oScope - retrieves elements in the scope with these methods: getElements(), getElementsByClassName(className), getLoggedObjects(type) \n\t fnResolve - optional, passed when the rule property async is set to true \n\t*/ \n}",selected:true,async:false},editRule:null,tempLink:{href:"",text:""},resolveDescription:"Make sure to resolve your async rule by using the passed fnResolve function",selectedRuleStringify:"",analyzeContext:e.global,executionScopes:e,executionScopeTitle:"Execution scope",lastAnalysisElapsedTime:"",analysisDurationTitle:"Last analysis duration",costants:"",executionScopeComponents:[],persistingSettings:false,loadingAdditionalRuleSets:false,analyzedFinish:false,selectedRules:true,filteredIssues:null,issuesCount:0,visibleRowCount:5,supportAssistantOrigin:"",supportAssistantVersion:"",initialRulesLoading:true});return m;});
sap.ui.predefine('sap/ui/support/supportRules/ui/models/formatter',[],function(){"use strict";return{resolutionUrl:function(u,U){var s=u.indexOf(U)===u.length-1?"":", \u00a0";return U.text+s;},hasResolutionUrls:function(u){if(u&&u.length>0){return true;}return false;}};});
sap.ui.predefine('sap/ui/support/supportRules/util/RuleValidator',[],function(){'use strict';var R={validateVersion:function(v){if(!v||typeof v!=='string'){return false;}var a=/^\*$|^\-$|^\d\.\d\d$/;if(v.match(a)){return true;}return false;},validateRuleCollection:function(e,E){if(e&&Array.isArray(e)&&e.length){for(var i=0;i<e.length;i++){if(E.hasOwnProperty(e[i])){continue;}else{return false;}}return true;}return false;},validateId:function(i){var a=/^[a-z][a-zA-Z]+$/;if(!i||typeof i!=='string'){return false;}if(i.match(a)&&this.validateStringLength(i,6,50)){return true;}return false;},validateStringLength:function(s,m,M){return m<=s.length&&s.length<=M;}};return R;},false);
sap.ui.predefine('sap/ui/support/supportRules/util/StringAnalyzer',[],function(){"use strict";var S={calculateLevenshteinDistance:function(w,W){var l=w.length;var L=W.length;if(l===0){return L;}if(L===0){return l;}var m=new Array(L+1);var i;for(i=0;i<=L;i++){m[i]=new Array(l+1);m[i][0]=i;}var I;for(I=0;I<=l;I++){m[0][I]=I;}var a=0;var b;var c;for(b=1;b<=L;b++){for(c=1;c<=l;c++){var d=m[b-1][c]+1;var e=m[b][c-1]+1;var s=m[b-1][c-1];if(w[c]!==W[b]){s+=1;}a=Math.min(d,e,s);m[b][c]=a;}}return a;}};return S;},false);
sap.ui.predefine('sap/ui/support/supportRules/util/Utils',[],function(){"use strict";var U={isDistributionOpenUI5:function(v){var r=false,f="";try{f=v.gav?v.gav:v.name;r=f.indexOf('openui5')!==-1?true:false;}catch(e){return r;}return r;}};return U;});
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/support/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/support/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.support","type":"library","embeds":[],"applicationVersion":{"version":"1.54.7"},"title":"UI5 library: sap.ui.support","description":"UI5 library: sap.ui.support","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":[]},"sap.ui5":{"dependencies":{"minUI5Version":"1.54","libs":{"sap.ui.core":{"minVersion":"1.54.7"}}},"library":{"i18n":false,"css":false,"content":{"controls":[],"elements":[],"types":["sap.ui.support.Severity"],"interfaces":[]}}}}',
	"sap/ui/support/supportRules/ui/views/Analysis.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.support.supportRules.ui.controllers.Analysis"\n\t\theight="100%"\n\t\txmlns="sap.ui.table"\n\t\txmlns:m="sap.m"\n\t\txmlns:c="sap.ui.core"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:f="sap.ui.layout.form"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:t="sap.ui.table">\n\t<m:NavContainer\n\t\tid="rulesNavContainer"\n\t\tafterNavigate="onAfterNavigate">\n\t\t<l:Splitter id="rulesDisplayPage">\n\t\t\t<l:contentAreas>\n\t\t\t\t<m:Page\n\t\t\t\t\t\tshowHeader="true">\n\t\t\t\t\t<m:headerContent>\n\t\t\t\t\t\t<m:Bar>\n\t\t\t\t\t\t\t<m:contentLeft>\n\t\t\t\t\t\t\t\t<m:IconTabHeader\n\t\t\t\t\t\t\t\t\t\tid="ruleSetsView"\n\t\t\t\t\t\t\t\t\t\tselect="onSelectedRuleSets"\n\t\t\t\t\t\t\t\t\t\tselectedKey="{/selectedSetPreviewKey}"\n\t\t\t\t\t\t\t\t\t\tclass="customIconTabHeader">\n\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t<m:IconTabFilter key="availableRules" text="Available Rulesets" />\n\t\t\t\t\t\t\t\t\t\t<m:IconTabFilter key="additionalRulesets" text="Additional Rulesets" />\n\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t</m:IconTabHeader>\n\t\t\t\t\t\t\t</m:contentLeft>\n\t\t\t\t\t\t\t<m:contentRight >\n\t\t\t\t\t\t\t\t<m:Button class="supportAnalyzeButton" text="Analyze" press="onAnalyze" type="Emphasized"/>\n\t\t\t\t\t\t\t\t<m:Button class="supportSettingsButton" icon="sap-icon://settings" press="onAnalyzeSettings" type="Emphasized"/>\n\t\t\t\t\t\t\t</m:contentRight>\n\t\t\t\t\t\t</m:Bar>\n\t\t\t\t\t</m:headerContent>\n\t\t\t\t\t<m:subHeader>\n\t\t\t\t\t\t<m:Bar >\n\t\t\t\t\t\t\t<m:contentRight>\n\t\t\t\t\t\t\t\t<m:Button text="Create Rule" icon="sap-icon://add" press="createNewRulePress"/>\n\t\t\t\t\t\t\t\t</m:contentRight>\n\t\t\t\t\t\t\t</m:Bar>\n\t\t\t\t\t\t\t</m:subHeader>\n\t\t\t\t\t\t<t:TreeTable\n\t\t\t\t\t\t\t\tid="ruleList"\n\t\t\t\t\t\t\t\tcollapseRecursive="false"\n\t\t\t\t\t\t\t\tselectionMode="MultiToggle"\n\t\t\t\t\t\t\t\tenableColumnReordering="false"\n\t\t\t\t\t\t\t\texpandFirstLevel="true"\n\t\t\t\t\t\t\t\trows="{path: \'/treeViewModel\'}"\n\t\t\t\t\t\t\t\tcellClick="onCellClick"\n\t\t\t\t\t\t\t\tclass="sapUiSizeCondensed"\n\t\t\t\t\t\t\t\tvisible="{= ${/selectedSetPreviewKey} === \'availableRules\' }"\n\t\t\t\t\t\t\t\tvisibleRowCountMode="Auto"\n\t\t\t\t\t\t\t\tselectionBehavior="RowSelector"\n\t\t\t\t\t\t\t\trowActionCount="1"\n\t\t\t\t\t\t\t\ttoggleOpenState="onToggleOpenState"\n\t\t\t\t\t\t\t\trowSelectionChange="onRowSelectionChange">\n\t\t\t\t\t\t\t<t:columns>\n\t\t\t\t\t\t\t\t<t:Column label="Rules">\n\t\t\t\t\t\t\t\t\t<t:template>\n\t\t\t\t\t\t\t\t\t\t<m:Text text="{name}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t</t:template>\n\t\t\t\t\t\t\t\t</t:Column>\n\t\t\t\t\t\t\t\t<t:Column label="Categories"\n\t\t\t\t\t\t\t\t\t\t  width="10rem">\n\t\t\t\t\t\t\t\t\t<t:template>\n\t\t\t\t\t\t\t\t\t\t<m:Text text="{categories}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t</t:template>\n\t\t\t\t\t\t\t\t</t:Column>\n\t\t\t\t\t\t\t</t:columns>\n\t\t\t\t\t\t\t<t:rowActionTemplate>\n\t\t\t\t\t\t\t\t\t<t:RowAction>\n\t\t\t\t\t\t\t\t\t\t<t:items>\n\t\t\t\t\t\t\t\t\t\t\t<t:RowActionItem icon="sap-icon://edit" text="Edit" press="editRule"  visible="{= ${libName} === \'temporary\'}" />\n\t\t\t\t\t\t\t\t\t\t\t<t:RowActionItem icon="sap-icon://delete" text="Delete" press="deleteTemporaryRule" visible="{= ${libName} === \'temporary\'}" />\n\t\t\t\t\t\t\t\t\t\t\t<t:RowActionItem icon="sap-icon://copy" text="Copy" press="duplicateRule" visible="{= ${libName} !== \'temporary\' &amp;&amp; ${type} !== \'lib\'}" />\n\t\t\t\t\t\t\t\t\t\t</t:items>\n\t\t\t\t\t\t\t\t\t</t:RowAction>\n\t\t\t\t\t\t\t</t:rowActionTemplate>\n\t\t\t\t\t\t</t:TreeTable>\n\t\t\t\t\t<l:VerticalLayout id="librarySetContainer" width="100%" visible="{= ${/selectedSetPreviewKey} === \'additionalRulesets\' }">\n\t\t\t\t\t\t<m:List\n\t\t\t\t\t\t\tid="availableLibrariesSet"\n\t\t\t\t\t\t\tmode = "MultiSelect"\n\t\t\t\t\t\t\tincludeItemInSelection= "true"\n\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\tpath: \'/availableLibrariesSet\'\n\t\t\t\t\t\t\t}">\n\t\t\t\t\t\t\t<m:StandardListItem\n\t\t\t\t\t\t\t\ttitle="{}"/>\n\t\t\t\t\t\t</m:List>\n\t\t\t\t\t\t<m:Button class="customMargin" text="Load" type="Emphasized" press="loadMarkedSupportLibraries" />\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</m:Page>\n\t\t\t</l:contentAreas>\n\t\t</l:Splitter>\n\t</m:NavContainer>\n</mvc:View>\n',
	"sap/ui/support/supportRules/ui/views/AnalyzeSettings.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:l="sap.ui.layout"\n\txmlns:core="sap.ui.core">\n\t<Popover\n\t\ttitle="{/executionScopeTitle}"\n\t\tcontentMinWidth="250px"\n\t\tclass="sapUiContentPadding"\n\t\tbeforeOpen="onBeforePopoverOpen"\n\t\tplacement="Bottom">\n\t\t<content>\n\t\t\t<VBox>\n\t\t\t\t<RadioButton groupName="analyzeContext"\n\t\t\t\t\t\t\t text="{/executionScopes/global/displayName}"\n\t\t\t\t\t\t\t select="onContextSelect"\n\t\t\t\t\t\t\t selected="{= ${/analyzeContext/key} === \'global\'}"\n\t\t\t\t\t\t\t tooltip="{/executionScopes/global/description}">\n\t\t\t\t\t<customData>\n\t\t\t\t\t\t<core:CustomData key="analyzeContext" value="global" />\n\t\t\t\t\t</customData>\n\t\t\t\t</RadioButton>\n\t\t\t\t<RadioButton groupName="analyzeContext"\n\t\t\t\t\t\t\t text="{/executionScopes/subtree/displayName}"\n\t\t\t\t\t\t\t select="onContextSelect"\n\t\t\t\t\t\t\t selected="{= ${/analyzeContext/key} === \'subtree\'}"\n\t\t\t\t\t\t\t tooltip="{/executionScopes/subtree/description}">\n\t\t\t\t\t<customData>\n\t\t\t\t\t\t<core:CustomData key="analyzeContext" value="subtree" />\n\t\t\t\t\t</customData>\n\t\t\t\t</RadioButton>\n\t\t\t\t<l:VerticalLayout\n\t\t\t\t\tclass="sapUiSupportToolSettingsPopoverPadding">\n\t\t\t\t\t<Input\n\t\t\t\t\t\tplaceholder="Input sub-root ID"\n\t\t\t\t\t\tenabled="{= ${/analyzeContext/key} === \'subtree\'}"\n\t\t\t\t\t\tvalue="{/subtreeExecutionContextId}"\n\t\t\t\t\t\twidth="300px"\n\t\t\t\t\t\tliveChange="onExecutionContextChange"/>\n\t\t\t\t</l:VerticalLayout>\n\t\t\t\t<RadioButton groupName="analyzeContext"\n\t\t\t\t\t\t\t text="{/executionScopes/components/displayName}"\n\t\t\t\t\t\t\t select="onContextSelect"\n\t\t\t\t\t\t\t selected="{= ${/analyzeContext/key} === \'components\'}"\n\t\t\t\t\t\t\t tooltip="{/executionScopes/components/description}">\n\t\t\t\t\t<customData>\n\t\t\t\t\t\t<core:CustomData key="analyzeContext" value="components" />\n\t\t\t\t\t</customData>\n\t\t\t\t</RadioButton>\n\t\t\t\t<l:VerticalLayout\n\t\t\t\t\tid="componentsSelectionContainer"\n\t\t\t\t\tcontent="{/executionScopeComponents}"\n\t\t\t\t\tclass="sapUiSupportToolSettingsPopoverPadding">\n\t\t\t\t\t<CheckBox text="{text}"\n\t\t\t\t\t\t\t  enabled="{= ${/analyzeContext/key} === \'components\'}"\n\t\t\t\t\t\t\t  select="onScopeComponentSelect"\n\t\t\t\t\t\t\t  selected="{selected}"\n\t\t\t\t\t/>\n\t\t\t\t</l:VerticalLayout>\n\t\t\t</VBox>\n\t\t</content>\n\t</Popover>\n</core:FragmentDefinition>\n',
	"sap/ui/support/supportRules/ui/views/Issues.view.xml":'<mvc:View\n\txmlns="sap.m"\n\tcontrollerName="sap.ui.support.supportRules.ui.controllers.Issues"\n\theight="100%"\n\txmlns:l="sap.ui.layout"\n\txmlns:tnt="sap.tnt"\n\txmlns:c="sap.ui.core"\n\txmlns:f="sap.ui.layout.form"\n\txmlns:t="sap.ui.table"\n\txmlns:mvc="sap.ui.core.mvc">\n\t<l:Splitter>\n\t\t<l:contentAreas>\n\t\t\t<Page class="sapUiSupportToolIssuesPage">\n\t\t\t\t<customHeader>\n\t\t\t\t\t<Toolbar id="filtersBar" height="{/filterBarHeight}">\n\t\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t\t<tnt:ToolHeader id="toolHeader" class="sapUiSupportToolIssueHeader" height="4rem">\n\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t<l:layoutData>\n\t\t\t\t\t\t\t\t\t\t<OverflowToolbarLayoutData priority="Low" />\n\t\t\t\t\t\t\t\t\t</l:layoutData>\n\t\t\t\t\t\t\t\t\t<Label text="Severity:" class="customMargin" />\n\t\t\t\t\t\t\t\t\t<Select id=\'severityFilter\'\n\t\t\t\t\t\t\t\t\t\t\tchange="updateIssuesVisibility"\n\t\t\t\t\t\t\t\t\t\t\tselectedKey="{/severityFilter}"\n\t\t\t\t\t\t\t\t\t\t\titems="{/severitiesFilter}"\n\t\t\t\t\t\t\t\t\t\t\tclass="customMargin" >\n\t\t\t\t\t\t\t\t\t\t<c:ListItem key="{}" text="{}" />\n\t\t\t\t\t\t\t\t\t</Select>\n\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t<l:layoutData>\n\t\t\t\t\t\t\t\t\t\t<OverflowToolbarLayoutData priority="Low" />\n\t\t\t\t\t\t\t\t\t</l:layoutData>\n\t\t\t\t\t\t\t\t\t<Label text="Category:" class="customMargin" />\n\t\t\t\t\t\t\t\t\t<Select id=\'categoryFilter\'\n\t\t\t\t\t\t\t\t\t\t\tchange="updateIssuesVisibility"\n\t\t\t\t\t\t\t\t\t\t\tselectedKey="{/categoryFilter}"\n\t\t\t\t\t\t\t\t\t\t\titems="{/categoriesFilter}"\n\t\t\t\t\t\t\t\t\t\t\tclass="customMargin">\n\t\t\t\t\t\t\t\t\t\t<c:ListItem key="{}" text="{}" />\n\t\t\t\t\t\t\t\t\t</Select>\n\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t<l:layoutData>\n\t\t\t\t\t\t\t\t\t\t<OverflowToolbarLayoutData priority="Low" />\n\t\t\t\t\t\t\t\t\t</l:layoutData>\n\t\t\t\t\t\t\t\t\t<Label text="Audiences:" class="customMargin" />\n\t\t\t\t\t\t\t\t\t<Select id=\'audiencesFilter\'\n\t\t\t\t\t\t\t\t\t\t\tchange="updateIssuesVisibility"\n\t\t\t\t\t\t\t\t\t\t\tselectedKey="{/audienceFilter}"\n\t\t\t\t\t\t\t\t\t\t\titems="{/audiencesFilter}"\n\t\t\t\t\t\t\t\t\t\t\tclass="customMargin" >\n\t\t\t\t\t\t\t\t\t\t<c:ListItem key="{}" text="{}" />\n\t\t\t\t\t\t\t\t\t</Select>\n\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t<l:layoutData>\n\t\t\t\t\t\t\t\t\t\t<OverflowToolbarLayoutData priority="Low" />\n\t\t\t\t\t\t\t\t\t</l:layoutData>\n\t\t\t\t\t\t\t\t\t<Label text="" class="customMargin" />\n\t\t\t\t\t\t\t\t\t<Button icon="sap-icon://clear-filter"  press="clearFiltersAndElementSelection"></Button>\n\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t<ToolbarSpacer />\n\t\t\t\t\t\t\t\t<tnt:ToolHeaderUtilitySeparator />\n\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t<Label text="" class="customMargin" />\n\t\t\t\t\t\t\t\t\t<MenuButton text="Report" icon="sap-icon://order-status" visible="{= ${/analyzePressed}}">\n\t\t\t\t\t\t\t\t\t\t<menu>\n\t\t\t\t\t\t\t\t\t\t\t<Menu itemSelected="onReportPress">\n\t\t\t\t\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<MenuItem text="View" press="onViewReport"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<MenuItem text="Download" press="onDownloadReport"/>\n\t\t\t\t\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t\t\t\t\t</Menu>\n\t\t\t\t\t\t\t\t\t\t</menu>\n\t\t\t\t\t\t\t\t\t</MenuButton>\n\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t</tnt:ToolHeader>\n\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t</Toolbar>\n\t\t\t\t</customHeader>\n\t\t\t\t<subHeader>\n\t\t\t\t\t<Toolbar\n\t\t\t\t\t\tid="messegeStrip"\n\t\t\t\t\t\theight="{/messegeStripHeight}">\n\t\t\t\t\t\t<FlexBox\n\t\t\t\t\t\t\talignItems="Center"\n\t\t\t\t\t\t\tjustifyContent="Start">\n\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t<Text  text="{= \'Displaying: \' + ${/visibleIssuesCount} + \' out of \' + ${/issuesCount} + \' (scope: \' + ${/analyzeContext/displayName} + \')\' }"/>\n\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t</FlexBox>\n\t\t\t\t\t</Toolbar>\n\t\t\t\t</subHeader>\n\t\t\t\t<t:TreeTable\n\t\t\t\t\tid="issuesList"\n\t\t\t\t\tclass="sapUiSupportToolIssuesTreeTable"\n\t\t\t\t\tselectionMode="Single"\n\t\t\t\t\tselectionBehavior="RowOnly"\n\t\t\t\t\tenableColumnReordering="false"\n\t\t\t\t\texpandFirstLevel="true"\n\t\t\t\t\trows="{path: \'/issues\'}"\n\t\t\t\t\trowSelectionChange="onRowSelectionChanged"\n\t\t\t\t\trowHeight="24"\n\t\t\t\t\tvisibleRowCountMode="Auto">\n\t\t\t\t\t<t:columns>\n\t\t\t\t\t\t<t:Column label="Issues" resizable="false">\n\t\t\t\t\t\t\t<t:template>\n\t\t\t\t\t\t\t\t<FormattedText htmlText="{formatedName}"/>\n\t\t\t\t\t\t\t</t:template>\n\t\t\t\t\t\t</t:Column>\n\t\t\t\t\t</t:columns>\n\t\t\t\t</t:TreeTable>\n\t\t\t</Page>\n\t\t\t<Page enableScrolling="false">\n\t\t\t\t<customHeader>\n\t\t\t\t\t<Bar class="selectedRuleTitle">\n\t\t\t\t\t\t<contentLeft>\n\t\t\t\t\t\t\t<Title text="{/selectedIssue/name}"/>\n\t\t\t\t\t\t</contentLeft>\n\t\t\t\t\t</Bar>\n\t\t\t\t</customHeader>\n\t\t\t\t<content>\n\t\t\t\t\t<Panel visible="{= ${/selectedIssue} !== null}" height="100%">\n\t\t\t\t\t\t<Text text="{/selectedIssue/description}" class="sapUiTinyMarginBeginEnd sapUiTinyMarginBottom" />\n\t\t\t\t\t\t<t:Table\n\t\t\t\t\t\t\trows="{path: \'/selectedIssue/issues\'}"\n\t\t\t\t\t\t\trowHeight="24"\n\t\t\t\t\t\t\tselectionMode="Single"\n\t\t\t\t\t\t\tselectionBehavior="RowOnly"\n\t\t\t\t\t\t\tenableColumnReordering="false"\n\t\t\t\t\t\t\tvisibleRowCount="{/visibleRowCount}"\n\t\t\t\t\t\t\trowSelectionChange="onRowSelection"\n\t\t\t\t\t\t\tid="issueTable">\n\t\t\t\t\t\t\t<t:columns>\n\t\t\t\t\t\t\t\t<t:Column\n\t\t\t\t\t\t\t\t\twidth="35px"\n\t\t\t\t\t\t\t\t\tresizable="false">\n\t\t\t\t\t\t\t\t\t<t:template>\n\t\t\t\t\t\t\t\t\t\t<c:Icon class="issuesSeverityIcon"\n\t\t\t\t\t\t\t\t\t\t\t\tcolor="{severityColor}"\n\t\t\t\t\t\t\t\t\t\t\t\tsrc="{severityIcon}">\n\t\t\t\t\t\t\t\t\t\t\t<c:layoutData>\n\t\t\t\t\t\t\t\t\t\t\t\t<FlexItemData growFactor="1" />\n\t\t\t\t\t\t\t\t\t\t\t</c:layoutData>\n\t\t\t\t\t\t\t\t\t\t</c:Icon>\n\t\t\t\t\t\t\t\t\t</t:template>\n\t\t\t\t\t\t\t\t</t:Column>\n\t\t\t\t\t\t\t\t<t:Column\n\t\t\t\t\t\t\t\t\tsortProperty="context/id"\n\t\t\t\t\t\t\t\t\tfilterProperty="context/id"\n\t\t\t\t\t\t\t\t\tlabel="Control Id"\n\t\t\t\t\t\t\t\t\tresizable="false">\n\t\t\t\t\t\t\t\t\t<t:template>\n\t\t\t\t\t\t\t\t\t\t<Text text="{context/id}" wrapping="false" tooltip="{context/id}"></Text>\n\t\t\t\t\t\t\t\t\t</t:template>\n\t\t\t\t\t\t\t\t</t:Column>\n\t\t\t\t\t\t\t\t<t:Column\n\t\t\t\t\t\t\t\t\tsortProperty="context/className"\n\t\t\t\t\t\t\t\t\tfilterProperty="context/className"\n\t\t\t\t\t\t\t\t\tlabel="Class name"\n\t\t\t\t\t\t\t\t\tresizable="false">\n\t\t\t\t\t\t\t\t\t<t:template>\n\t\t\t\t\t\t\t\t\t\t<Text text="{context/className}" wrapping="false" tooltip="{context/className}"></Text>\n\t\t\t\t\t\t\t\t\t</t:template>\n\t\t\t\t\t\t\t\t</t:Column>\n\t\t\t\t\t\t\t</t:columns>\n\t\t\t\t\t\t</t:Table>\n\t\t\t\t\t\t<f:SimpleForm\n\t\t\t\t\t\t\teditable="true"\n\t\t\t\t\t\t\tvisible="{= ${/visibleIssuesCount} > 0}"\n\t\t\t\t\t\t\tlayout="ResponsiveGridLayout"\n\t\t\t\t\t\t\tbreakpointM="400">\n\t\t\t\t\t\t\t<f:content>\n\t\t\t\t\t\t\t\t<Label text="Details" />\n\t\t\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\t\ttext="{/selectedIssue/details}"\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\tvisible="{= ${/selectedIssue/details} !== \'\'}"/>\n\t\t\t\t\t\t\t\t<Label text="Resolution" />\n\t\t\t\t\t\t\t\t<Text text="{/selectedIssue/resolution}" />\n\t\t\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\t\ttext="URLs"\n\t\t\t\t\t\t\t\t\tvisible="{\n\t\t\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\t\t\t\'/selectedIssue/resolutionUrls\'\n\t\t\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\t\t\tformatter: \'.formatter.hasResolutionUrls\'\n\t\t\t\t\t\t\t\t\t}" />\n\t\t\t\t\t\t\t\t<HBox\n\t\t\t\t\t\t\t\t\twrap="Wrap"\n\t\t\t\t\t\t\t\t\titems="{/selectedIssue/resolutionUrls}">\n\t\t\t\t\t\t\t\t\t<Link text="{\n\t\t\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\t\t\t\'/selectedIssue/resolutionUrls\',\n\t\t\t\t\t\t\t\t\t\t\t\'\'\n\t\t\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\t\t\tformatter: \'.formatter.resolutionUrl\'\n\t\t\t\t\t\t\t\t\t}" press="openDocumentation" />\n\t\t\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t\t</f:content>\n\t\t\t\t\t\t</f:SimpleForm>\n\t\t\t\t\t</Panel>\n\t\t\t\t</content>\n\t\t\t</Page>\n\t\t\t<c:HTML id="elementTreeContainer" content=\'&lt;control-tree&gt;  &lt;/control-tree&gt;\'>\n\t\t\t</c:HTML>\n\t\t</l:contentAreas>\n\t</l:Splitter>\n</mvc:View>\n',
	"sap/ui/support/supportRules/ui/views/Main.view.xml":'<mvc:View\n\t\theight="100%"\n\t\tcontrollerName="sap.ui.support.supportRules.ui.controllers.Main"\n\t\txmlns="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:c= "sap.ui.core">\n\t<Page showHeader="false">\n\t\t<l:FixFlex>\n\t\t\t<l:fixContent>\n\n\t\t\t\t<Bar class="sapContrast" design="SubHeader" id="sapSTShowButtonBar">\n\t\t\t\t\t<contentMiddle>\n\t\t\t\t\t\t<Text text="{/constants/SUPPORT_ASSISTANT_NAME}" class="STCustomHeaderInfo" />\n\t\t\t\t\t\t<c:Icon src="sap-icon://full-screen" press="toggleHide" class="STCustomHeaderInfo" />\n\t\t\t\t\t</contentMiddle>\n\t\t\t\t</Bar>\n\n\t\t\t\t<Bar class="sapContrast" design="SubHeader">\n\t\t\t\t\t<contentLeft>\n\t\t\t\t\t\t<!--<c:Icon src="sap-icon://sap-ui5" />-->\n\t\t\t\t\t\t<Image src="../ui/images/Logo_O_22x22.png" densityAware="false"></Image>\n\t\t\t\t\t\t<Text text="{/constants/SUPPORT_ASSISTANT_NAME}" class="STCustomHeaderInfo" />\n\t\t\t\t\t</contentLeft>\n\n\t\t\t\t\t<contentMiddle>\n\t\t\t\t\t\t<FlexBox\n\t\t\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\t\t\twidth="500px"\n\t\t\t\t\t\t\t\talignItems="Center"\n\t\t\t\t\t\t\t\tjustifyContent="Center">\n\t\t\t\t\t\t\t<ProgressIndicator\n\t\t\t\t\t\t\t\t\tid="progressIndicator"\n\t\t\t\t\t\t\t\t\tpercentValue="{/progress}"\n\t\t\t\t\t\t\t\t\tdisplayValue="None"\n\t\t\t\t\t\t\t\t\tshowValue="true"\n\t\t\t\t\t\t\t\t\tstate="Success"\n\t\t\t\t\t\t\t\t\tvisible="{/showProgressIndicator}">\n\t\t\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t\t\t<FlexItemData growFactor="1" />\n\t\t\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t\t\t</ProgressIndicator>\n\t\t\t\t\t\t\t<Text\tid="coreStateLabel"\n\t\t\t\t\t\t\t\t\tvisible="{= ${/analyzePressed} === true &amp;&amp; ${/coreStateChanged} === true &amp;&amp; ${/showProgressIndicator} === false }"\n\t\t\t\t\t\t\t\t\ttext=\'Application state has changed and issues view is not in sync. Analyze again. \'>\n\t\t\t\t\t\t\t</Text>\n\t\t\t\t\t\t\t<Text\tid="elapsedTimeLabel"\n\t\t\t\t\t\t\t\t\tvisible="{= ${/analyzePressed} === true &amp;&amp; ${/coreStateChanged} === false &amp;&amp; ${/showProgressIndicator} === false }"\n\t\t\t\t\t\t\t\t\ttext=\'{/analysisDurationTitle}: {/lastAnalysisElapsedTime}\'>\n\t\t\t\t\t\t\t</Text>\n\t\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\t\t visible="{= ${/persistingSettings} === true &amp;&amp;  ${/analyzePressed} === false &amp;&amp; ${/showProgressIndicator} === false }"\n\t\t\t\t\t\t\t\t\t text=\'There are settings persisted from your previous session\'>\n\t\t\t\t\t\t\t</Text>\n\t\t\t\t\t\t</FlexBox>\n\t\t\t\t\t</contentMiddle>\n\n\t\t\t\t\t<contentRight>\n\t\t\t\t\t<Toolbar\n\t\t\t\t\t\t\tid="navToolbar">\n\t\t\t\t\t\t\t<Button id="issuesBtn" text="{= \'Issues (\' + ${/issuesCount} + \')\' }" enabled="{= ${/analyzedFinish} === true}" press="goToIssues"/>\n\n\t\t\t\t\t\t\t<Button id="analysisBtn" text="{path: \'/libraries\', formatter: \'.setRulesLabel\'}" press="goToAnalysis" type="Emphasized"/>\n\n\t\t\t\t\t\t\t<c:Icon width="100%" src="sap-icon://settings" press="onSettings" class="STCustomHeaderInfo STHelpIcon sapUiTinyMargin"/>\n\n\t\t\t\t\t\t\t<c:Icon width="100%"  src="sap-icon://sys-help" press="goToWiki" class="STCustomHeaderInfo STHelpIcon sapUiTinyMargin" tooltip="Open Documentation" />\n\n\t\t\t\t\t\t\t<c:Icon width="100%" src="sap-icon://minimize" press="toggleHide" class="STCustomHeaderInfo sapUiTinyMargin" visible="{/hasNoOpener}"/>\n\n\t\t\t\t\t\t\t<Button icon="sap-icon://down" press="resizeDown"  visible="{/hasNoOpener}"/>\n\n\t\t\t\t\t\t\t<Button icon="sap-icon://up" press="resizeUp"  visible="{/hasNoOpener}"/>\n\t\t\t\t\t\t</Toolbar>\n\t\t\t\t\t</contentRight>\n\t\t\t\t</Bar>\n\t\t\t</l:fixContent>\n\n\t\t\t<l:flexContent>\n\t\t\t\t<NavContainer\n\t\t\t\t\tid="navCon">\n\t\t\t\t\t<mvc:XMLView id="analysis" viewName="sap.ui.support.supportRules.ui.views.Analysis" async="true"></mvc:XMLView>\n\t\t\t\t\t<!-- <mvc:XMLView id="issues"  viewName="sap.ui.support.supportRules.ui.views.Issues" async="true"></mvc:XMLView> -->\n\t\t\t\t</NavContainer>\n\t\t\t</l:flexContent>\n\t\t</l:FixFlex>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/support/supportRules/ui/views/RuleDetails.fragment.xml":'<core:FragmentDefinition\n\t\txmlns:m="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:f="sap.ui.layout.form"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:t="sap.ui.table"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:tools="sap.ui.codeeditor">\n\t<m:Page showHeader="false">\n\t\t<m:Bar>\n\t\t\t<m:contentLeft >\n\t\t\t\t<m:Title text="{= ${/selectedRule/libName} + \' > \' + ${/selectedRule/title}}" visible="{= ${/selectedRule} !== undefined}" titleStyle="H6" class="customMarginLeft" />\n\t\t\t</m:contentLeft>\n\t\t\t<m:contentMiddle>\n\t\t\t\t<m:IconTabHeader\n\t\t\t\t\t\tselectedKey="{/selectedRulePreviewKey}"\n\t\t\t\t\t\tclass="customIconTabHeader">\n\t\t\t\t\t<m:items>\n\t\t\t\t\t\t<m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="ruleProperties" text="Rule properties" />\n\t\t\t\t\t\t<m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="checkFunction" text="Check function" />\n\t\t\t\t\t\t<m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="jsonOutput" text="Code" />\n\t\t\t\t\t</m:items>\n\t\t\t\t</m:IconTabHeader>\n\t\t\t</m:contentMiddle>\n\t\t</m:Bar>\n\t\t<f:SimpleForm\n\t\t\t\tvisible="{= ${/selectedRule/type} !== \'library\'  &amp;&amp; ${/selectedRulePreviewKey} === \'ruleProperties\' &amp;&amp; ${/selectedRule} !== undefined}">\n\t\t\t<f:content>\n\t\t\t\t<m:Label text="ID" />\n\t\t\t\t<m:Text text="{/selectedRule/id}" />\n\t\t\t\t<m:Label text="Title" />\n\t\t\t\t<m:Text text="{/selectedRule/title}" />\n\t\t\t\t<m:Label text="Async" />\n\t\t\t\t<m:Text text="{= ${/selectedRule/async} === true }" />\n\t\t\t\t<m:Label text="Audiences" />\n\t\t\t\t<m:Text text="{/selectedRule/audiences}" />\n\t\t\t\t<m:Label text="Categories" />\n\t\t\t\t<m:Text text="{/selectedRule/categories}" />\n\t\t\t\t<m:Label text="Min version" />\n\t\t\t\t<m:Text text="{/selectedRule/minversion}" />\n\t\t\t\t<m:Label text="Description" />\n\t\t\t\t<m:Text text="{/selectedRule/description}" />\n\t\t\t\t<m:Label text="Resolution" />\n\t\t\t\t<m:Text text="{/selectedRule/resolution}" />\n\t\t\t\t<m:Label text="Resolution URLs" />\n\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\tcontent="{/selectedRule/resolutionurls}">\n\t\t\t\t\t<m:Link target="_blank"\n\t\t\t\t\t\t\ttext="{text}"\n\t\t\t\t\t\t\thref="{href}"/>\n\t\t\t\t</l:VerticalLayout>\n\t\t\t</f:content>\n\t\t\t<f:layoutData><l:SplitterLayoutData size="40%" /></f:layoutData>\n\t\t</f:SimpleForm>\n\t\t<m:Panel\n\t\t\t\twidth="100%"\n\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\tvisible="{= ${/selectedRulePreviewKey} === \'checkFunction\' }">\n\t\t\t<tools:CodeEditor\n\t\t\t\t\tid="codeEditorPreview"\n\t\t\t\t\tsyntaxHints="false"\n\t\t\t\t\twidth="100%"\n\t\t\t\t\theight="100%"\n\t\t\t\t\tvalue="{/selectedRule/check}"\n\t\t\t\t\teditable="false">\n\t\t\t</tools:CodeEditor>\n\t\t</m:Panel>\n\t\t<m:Panel\n\t\t\t\t\twidth="100%"\n\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\tvisible="{= ${/selectedRulePreviewKey} === \'jsonOutput\' }">\n\t\t\t<tools:CodeEditor\n\t\t\t\t\tid="codeEditorJson1"\n\t\t\t\t\tsyntaxHints="false"\n\t\t\t\t\twidth="100%"\n\t\t\t\t\theight="100%"\n\t\t\t\t\tvalue="{/selectedRuleStringify}"\n\t\t\t\t\teditable="false"\n\t\t\t\t\ttype="javascript">\n\t\t\t</tools:CodeEditor>\n\t\t</m:Panel>\n\t</m:Page>\n</core:FragmentDefinition>\n',
	"sap/ui/support/supportRules/ui/views/RuleUpdate.fragment.xml":'<c:FragmentDefinition\n\t\txmlns:m="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:f="sap.ui.layout.form"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:t="sap.ui.table"\n\t\txmlns:c="sap.ui.core"\n\t\txmlns:tools="sap.ui.codeeditor">\n\t<m:Page\n\t\t\tid="ruleUpdatePage"\n\t\t\tshowHeader="false">\n\t\t<m:content>\n\t\t\t<m:Bar>\n\t\t\t\t<m:contentLeft>\n\t\t\t\t\t<m:Button\n\t\t\t\t\t\t\ticon="sap-icon://arrow-left"\n\t\t\t\t\t\t\tpress="goToRuleProperties"\n\t\t\t\t\t\t\ttext="Back"/>\n\t\t\t\t</m:contentLeft>\n\t\t\t\t<m:contentMiddle>\n\t\t\t\t\t<m:IconTabHeader\n\t\t\t\t\t\t\tselect="rulesToolbarEditITHSelect"\n\t\t\t\t\t\t\tselectedKey="{/selectedRuleEditKey}"\n\t\t\t\t\t\t\tclass="customIconTabHeader">\n\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t<m:IconTabFilter key="ruleProperties" text="Rule properties" />\n\t\t\t\t\t\t\t<m:IconTabFilter key="checkFunction" text="Check function" />\n\t\t\t\t\t\t\t<m:IconTabFilter key="jsonOutput" text="Code" />\n\t\t\t\t\t\t</m:items>\n\t\t\t\t\t</m:IconTabHeader>\n\t\t\t\t</m:contentMiddle>\n\t\t\t</m:Bar>\n\t\t\t<f:SimpleForm\n\t\t\t\t\tvisible="{= ${/selectedRuleEditKey} === \'ruleProperties\' }"\n\t\t\t\t\teditable="true">\n\t\t\t\t<f:content>\n\t\t\t\t\t<m:Label text="ID" />\n\t\t\t\t\t<m:Input value="{/editRule/id}" required = "true" />\n\t\t\t\t\t<m:Label text="Async" />\n\t\t\t\t\t<m:HBox>\n\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t<m:RadioButton groupName="asyncEditContext" text="true" selected="{= ${/editRule/async} === true }" select="onAsyncSwitch">\n\t\t\t\t\t\t\t\t<m:customData>\n\t\t\t\t\t\t\t\t\t<c:CustomData key="asyncEditContext" value="true" />\n\t\t\t\t\t\t\t\t</m:customData>\n\t\t\t\t\t\t\t</m:RadioButton>\n\t\t\t\t\t\t\t<m:RadioButton groupName="asyncEditContext" text="false" selected="{= ${/editRule/async} !== true }" select="onAsyncSwitch">\n\t\t\t\t\t\t\t\t<m:customData>\n\t\t\t\t\t\t\t\t\t<c:CustomData key="asyncEditContext" value="false" />\n\t\t\t\t\t\t\t\t</m:customData>\n\t\t\t\t\t\t\t</m:RadioButton>\n\t\t\t\t\t\t\t<c:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://message-warning"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBegin sapUiTinyMarginEnd"\n\t\t\t\t\t\t\t\tcolor="#E09D00"\n\t\t\t\t\t\t\t\tvisible="{= ${/editRule/async} === true }">\n\t\t\t\t\t\t\t\t<c:layoutData>\n\t\t\t\t\t\t\t\t\t<m:FlexItemData alignSelf="Center" />\n\t\t\t\t\t\t\t\t</c:layoutData>\n\t\t\t\t\t\t\t</c:Icon>\n\t\t\t\t\t\t\t<m:Text text="{/resolveDescription}" visible="{= ${/editRule/async} === true }">\n\t\t\t\t\t\t\t\t<m:layoutData>\n\t\t\t\t\t\t\t\t\t<m:FlexItemData alignSelf="Center" />\n\t\t\t\t\t\t\t\t</m:layoutData>\n\t\t\t\t\t\t\t</m:Text>\n\t\t\t\t\t\t</m:items>\n\t\t\t\t\t</m:HBox>\n\t\t\t\t\t<m:Label text="Categories" />\n\t\t\t\t\t<m:MultiComboBox selectedKeys="{/editRule/categories}" items="{/categories}"  required = "true">\n\t\t\t\t\t\t<c:Item key="{}" text="{}" />\n\t\t\t\t\t</m:MultiComboBox>\n\t\t\t\t\t<m:Label text="Audiences" />\n\t\t\t\t\t<m:MultiComboBox selectedKeys="{/editRule/audiences}" items="{/audiences}"  required = "true">\n\t\t\t\t\t\t<c:Item key="{}" text="{}" />\n\t\t\t\t\t</m:MultiComboBox>\n\t\t\t\t\t<m:Label text="Title" />\n\t\t\t\t\t<m:Input type="Text" value="{/editRule/title}"  required = "true" />\n\t\t\t\t\t<m:Label text="Description" />\n\t\t\t\t\t<m:TextArea value="{/editRule/description}"  required = "true"/>\n\t\t\t\t\t<m:Label text="Resolution" />\n\t\t\t\t\t<m:TextArea value="{/editRule/resolution}"  required = "true"/>\n\t\t\t\t\t<m:Label text="Min version" />\n\t\t\t\t\t<m:TextArea value="{/editRule/minversion}"  required = "true"/>\n\t\t\t\t\t<m:Label text="Resolution URLS" />\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t\t<m:Input type="text" placeholder="Text" value="{/tempLink/text}" />\n\t\t\t\t\t\t\t<m:Input type="text" placeholder="Href" value="{/tempLink/href}" />\n\t\t\t\t\t\t\t<m:Button text="Add Link" press="addLinkToRule" icon="sap-icon://add" />\n\t\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\t\tcontent="{/editRule/resolutionurls}">\n\t\t\t\t\t\t\t<m:Link text="{text}" href="{href}" target="_blank"/>\n\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</f:content>\n\t\t\t</f:SimpleForm>\n\t\t\t<m:Panel width="100%"\n\t\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\t\tvisible="{= ${/selectedRuleEditKey} === \'checkFunction\' }">\n\t\t\t\t<tools:CodeEditor\n\t\t\t\t\t\tid="codeEditorUpdate"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\tvalue="{/editRule/check}"\n\t\t\t\t\t\teditable="true">\n\t\t\t\t</tools:CodeEditor>\n\t\t\t</m:Panel>\n\t\t\t<m:Panel width="100%"\n\t\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\t\tvisible="{= ${/selectedRuleEditKey} === \'jsonOutput\' }">\n\t\t\t\t<tools:CodeEditor\n\t\t\t\t\t\tsyntaxHints="false"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\tvalue="{/updateRuleStringified}"\n\t\t\t\t\t\teditable="false"\n\t\t\t\t\t\ttype="javascript">\n\t\t\t\t</tools:CodeEditor>\n\t\t\t</m:Panel>\n\t\t</m:content>\n\t\t<m:footer>\n\t\t\t<m:Bar>\n\t\t\t\t<m:contentRight>\n\t\t\t\t\t<m:Button\n\t\t\t\t\t\t\tpress="updateRule"\n\t\t\t\t\t\t\ttext="Update"\n\t\t\t\t\t\t\ttype="Emphasized" />\n\t\t\t\t</m:contentRight>\n\t\t\t</m:Bar>\n\t\t</m:footer>\n\t</m:Page>\n\t<m:Page\n\t\t\tid="rulesCreatePage"\n\t\t\tshowHeader="false">\n\t\t<m:content>\n\t\t\t<m:Bar>\n\t\t\t\t<m:contentLeft>\n\t\t\t\t\t<m:Button\n\t\t\t\t\t\t\ticon="sap-icon://arrow-left"\n\t\t\t\t\t\t\tpress="goToRuleProperties"\n\t\t\t\t\t\t\ttext="Back"/>\n\t\t\t\t</m:contentLeft>\n\t\t\t\t<m:contentMiddle>\n\t\t\t\t\t<m:IconTabHeader\n\t\t\t\t\t\t\tselect="rulesToolbarITHSelect"\n\t\t\t\t\t\t\tselectedKey="{/selectedRuleCreateKey}"\n\t\t\t\t\t\t\tclass="customIconTabHeader">\n\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t<m:IconTabFilter key="ruleProperties" text="Rule properties" />\n\t\t\t\t\t\t\t<m:IconTabFilter key="checkFunction" text="Check function" />\n\t\t\t\t\t\t\t<m:IconTabFilter key="jsonOutput" text="Code" />\n\t\t\t\t\t\t</m:items>\n\t\t\t\t\t</m:IconTabHeader>\n\t\t\t\t</m:contentMiddle>\n\t\t\t</m:Bar>\n\t\t\t<f:SimpleForm\n\t\t\t\t\tvisible="{= ${/selectedRuleCreateKey} === \'ruleProperties\' }"\n\t\t\t\t\teditable="true">\n\t\t\t\t<f:content>\n\t\t\t\t\t<m:Label text="ID" />\n\t\t\t\t\t<m:Input value="{/newRule/id}"  required = "true"/>\n\t\t\t\t\t<m:Label text="Async" />\n\t\t\t\t\t<m:HBox>\n\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t<m:RadioButton groupName="asyncContext" text="true" selected="{= ${/newRule/async} === true }" select="onAsyncSwitch">\n\t\t\t\t\t\t\t\t<m:customData>\n\t\t\t\t\t\t\t\t\t<c:CustomData key="asyncContext" value="true" />\n\t\t\t\t\t\t\t\t</m:customData>\n\t\t\t\t\t\t\t\t<m:layoutData>\n\t\t\t\t\t\t\t\t\t<m:FlexItemData alignSelf="Center" />\n\t\t\t\t\t\t\t\t</m:layoutData>\n\t\t\t\t\t\t\t</m:RadioButton>\n\t\t\t\t\t\t\t<m:RadioButton groupName="asyncContext" text="false" selected="{= ${/newRule/async} !== true }" select="onAsyncSwitch">\n\t\t\t\t\t\t\t\t<m:customData>\n\t\t\t\t\t\t\t\t\t<c:CustomData key="asyncContext" value="false" />\n\t\t\t\t\t\t\t\t</m:customData>\n\t\t\t\t\t\t\t\t<m:layoutData>\n\t\t\t\t\t\t\t\t\t<m:FlexItemData alignSelf="Center" />\n\t\t\t\t\t\t\t\t</m:layoutData>\n\t\t\t\t\t\t\t</m:RadioButton>\n\t\t\t\t\t\t\t<c:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://message-warning"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBegin sapUiTinyMarginEnd"\n\t\t\t\t\t\t\t\tcolor="#E09D00"\n\t\t\t\t\t\t\t\tvisible="{= ${/newRule/async} === true }">\n\t\t\t\t\t\t\t\t<c:layoutData>\n\t\t\t\t\t\t\t\t\t<m:FlexItemData alignSelf="Center" />\n\t\t\t\t\t\t\t\t</c:layoutData>\n\t\t\t\t\t\t\t</c:Icon>\n\t\t\t\t\t\t\t<m:Text text="{/resolveDescription}" visible="{= ${/newRule/async} === true }">\n\t\t\t\t\t\t\t\t<m:layoutData>\n\t\t\t\t\t\t\t\t\t<m:FlexItemData alignSelf="Center" />\n\t\t\t\t\t\t\t\t</m:layoutData>\n\t\t\t\t\t\t\t</m:Text>\n\t\t\t\t\t\t</m:items>\n\t\t\t\t\t</m:HBox>\n\t\t\t\t\t<m:Label text="Categories" />\n\t\t\t\t\t<m:MultiComboBox selectedKeys="{/newRule/categories}" items="{/categories}"  required = "true">\n\t\t\t\t\t\t<c:Item key="{}" text="{}" />\n\t\t\t\t\t</m:MultiComboBox>\n\t\t\t\t\t<m:Label text="Audiences" />\n\t\t\t\t\t<m:MultiComboBox selectedKeys="{/newRule/audiences}" items="{/audiences}"  required = "true">\n\t\t\t\t\t\t<c:Item key="{}" text="{}" />\n\t\t\t\t\t</m:MultiComboBox>\n\t\t\t\t\t<m:Label text="Title" />\n\t\t\t\t\t<m:Input type="Text" value="{/newRule/title}"  required = "true"/>\n\t\t\t\t\t<m:Label text="Description" />\n\t\t\t\t\t<m:TextArea value="{/newRule/description}"  required = "true"/>\n\t\t\t\t\t<m:Label text="Resolution" />\n\t\t\t\t\t<m:TextArea value="{/newRule/resolution}"  required = "true"/>\n\t\t\t\t\t<m:Label text="Min version" />\n\t\t\t\t\t<m:TextArea value="{/newRule/minversion}"  required = "true"/>\n\t\t\t\t\t<m:Label text="Resolution URLS" />\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t\t<m:Input type="text" placeholder="Text" value="{/tempLink/text}" />\n\t\t\t\t\t\t\t<m:Input type="text" placeholder="Href" value="{/tempLink/href}" />\n\t\t\t\t\t\t\t<m:Button text="Add" press="addLinkToRule" icon="sap-icon://add" />\n\t\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\t\tcontent="{/newRule/resolutionurls}">\n\t\t\t\t\t\t\t<m:Link text="{text}" />\n\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</f:content>\n\t\t\t</f:SimpleForm>\n\t\t\t<m:Panel width="100%"\n\t\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\t\tvisible="{= ${/selectedRuleCreateKey} === \'checkFunction\' }">\n\t\t\t\t<tools:CodeEditor\n\t\t\t\t\t\tid="codeEditorCreate"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\tvalue="{/newRule/check}"\n\t\t\t\t\t\teditable="true">\n\t\t\t\t</tools:CodeEditor>\n\t\t\t</m:Panel>\n\t\t\t<m:Panel width="100%"\n\t\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\t\tvisible="{= ${/selectedRuleCreateKey} === \'jsonOutput\' }">\n\t\t\t\t<tools:CodeEditor\n\t\t\t\t\t\tid="codeEditorJson"\n\t\t\t\t\t\tsyntaxHints="false"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\tvalue="{/newRuleStringified}"\n\t\t\t\t\t\teditable="false"\n\t\t\t\t\t\ttype="javascript">\n\t\t\t\t</tools:CodeEditor>\n\t\t\t</m:Panel>\n\t\t</m:content>\n\t\t<m:footer>\n\t\t\t<m:Bar>\n\t\t\t\t<m:contentRight>\n\t\t\t\t\t<m:Button\n\t\t\t\t\t\t\tpress="addNewRule"\n\t\t\t\t\t\t\ttext="Add Rule"\n\t\t\t\t\t\t\ttype="Emphasized" />\n\t\t\t\t</m:contentRight>\n\t\t\t</m:Bar>\n\t\t</m:footer>\n\t</m:Page>\n</c:FragmentDefinition>\n',
	"sap/ui/support/supportRules/ui/views/StorageSettings.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core">\n\t<Popover\n\t\t\ttitle="Settings"\n\t\t\tcontentMinWidth="250px"\n\t\t\tclass="sapUiContentPadding"\n\t\t\tplacement="Bottom">\n\t\t<content>\n\t\t\t<FlexBox\n\t\t\talignContent="Center"\n\t\t\tjustifyContent="Center">\n\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t<CheckBox text="I agree to use local storage persistency for:"\n\t\t\t\t\t\t\t  select= "onPersistedSettingSelect"\n\t\t\t\t\t\t\t  selected="{/persistingSettings}"\n\t\t\t\t\t\t/>\n\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t\t<FlexBox\n\t\t\t\t\t\t\talignContent="Center"\n\t\t\t\t\t\t\tjustifyContent="Start">\n\t\t\t\t\t\t<l:VerticalLayout class="customSettingsPadding">\n\t\t\t\t\t\t\t<Text text="  Execution Scope"></Text>\n\t\t\t\t\t\t\t<Text text="  Temporary Rules"></Text>\n\t\t\t\t\t\t\t<Text text="  Selected Rules"></Text>\n\t\t\t\t\t\t\t<Button text="Delete Persisted Data" press="deletePersistedData"></Button>\n\n\t\t\t\t\t\t\t<l:HorizontalLayout class="customSettingsInfo">\n\t\t\t\t\t\t\t<Text text="Support Assistant Location : \\t" renderWhitespace="true"></Text>\n\t\t\t\t\t\t\t<Link text="Copy" href="#" press="copySupportAssistantOriginToClipboard"></Link>\n\t\t\t\t\t\t\t</l:HorizontalLayout>\n\n\t\t\t\t\t\t\t<Text text="{/supportAssistantOrigin}"></Text>\n\n\t\t\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t\t<Text text="Support Assistant Version : {/supportAssistantVersion}" renderWhitespace="true"></Text>\n\t\t\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t</FlexBox>\n\t\t\t\t</l:VerticalLayout>\n\t\t\t</FlexBox>\n\t\t</content>\n\t</Popover>\n</core:FragmentDefinition>\n',
	"sap/ui/support/supportRules/report/resources/collapseExpand.js":function(){window.sapUiSupportReport=window.sapUiSupportReport||{};window.sapUiSupportReport.collapseExpand=(function(){'use strict';function c(e){var t=this.getAttribute('data-expandableElement');var b=document.getElementById(t);var d=b.classList.contains('collapsed');if(d){b.classList.remove('collapsed');b.classList.add('expanded');this.classList.remove('collapsed-content');this.classList.add('expanded-content');}else{b.classList.remove('expanded');b.classList.add('collapsed');this.classList.remove('expanded-content');this.classList.add('collapsed-content');}}function a(){try{var e=document.getElementsByClassName('expandable-control');if(!e){return;}for(var i=0;i<e.length;i++){e[i].addEventListener('click',c);var b=e[i].getAttribute('data-expandableElement');var d=document.getElementById(b);if(e[i].classList.contains('collapsed-content')){d.classList.add('collapsed');}else{d.classList.add('expanded');}e[i].setAttribute('style','cursor: pointer;');}}catch(f){console.log('There was a problem initializing collapse/expand functionality.');}}return{init:a};}());
},
	"sap/ui/support/supportRules/report/resources/filter.js":function(){window.sapUiSupportReport=window.sapUiSupportReport||{};window.sapUiSupportReport.filter=(function(){'use strict';function u(){var g=document.querySelectorAll('[data-groupName]');for(var i=0;i<g.length;i++){var c=g[i];var d=c.getAttribute('data-expandableElement');var e=c.getAttribute('data-groupName');var h=c.getAttribute('data-groupNumber');var j=document.querySelectorAll('#'+d+' > tr');var n=0;var l=0;for(var k=0;k<j.length;k++){var m=j[k];var o=m.querySelectorAll('tr.filterable:not(.filtered)');var p=o.length;if(p===0){m.classList.add('filtered');}else{l++;n+=p;m.querySelector('span.rule-issue-number').innerText='('+p+' issues)';}}if(l===0){c.classList.add('filtered');}else{c.classList.remove('filtered');c.querySelector('span').innerText=' '+h+'. '+e+' ('+l+' rules, '+n+' issues)';}}}function s(c){if(c.classList.contains('filter-active')){return;}var d=document.getElementsByClassName('filter-active');for(var k=0;k<d.length;k++){d[k].classList.remove('filter-active');}c.classList.add('filter-active');}function r(){var c=document.querySelectorAll('.filtered');for(var i=0;i<c.length;i++){c[i].classList.remove('filtered');}}function f(c){r();if(c==='Total'){return;}var e=document.querySelectorAll('.filterable:not([data-severity="'+c+'"])');for(var i=0;i<e.length;i++){e[i].classList.add('filtered');}}function a(e){s(this);var c=this.getAttribute('data-severity');f(c);u();}function b(){try{var c=document.getElementsByClassName('filter');if(!c){return;}for(var i=0;i<c.length;i++){if(c[i].classList.contains('filter-initialized')){continue;}c[i].addEventListener('click',a);c[i].classList.add('filter-initialized');}}catch(e){console.log('There was a problem initializing filters.');}}return{init:b};}());
}
}});
//# sourceMappingURL=library-preload.js.map