/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/unified/Calendar',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRenderer"],function(q,C,L,a,H,M,b,Y,c,l,D,d,R,e,f){"use strict";
var g=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
g.prototype.init=function(){this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._oYearFormat=d.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();var t=this._createMonth(this.getId()+"--Month0");t.attachEvent("focus",this._handleFocus,this);t.attachEvent("select",n,this);t.attachEvent("_renderMonth",m,this);t.attachEvent("_bindMousemove",o,this);t.attachEvent("_unbindMousemove",p,this);t._bNoThemeChange=true;this.addAggregation("month",t);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(r,this);this._oSelectedMonth;};
g.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};
g.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",i);};
g.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};
g.prototype._initilizeYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",y);};
g.prototype._createMonth=function(i){var t=new M(i,{width:"100%"});t.attachEvent("datehovered",this._handleDateHovered,this);return t;};
g.prototype._handleDateHovered=function(E){var t=this.getAggregation("month"),u=E.getParameter("date1"),v=E.getParameter("date2"),i;for(i=0;i<t.length;i++){t[i]._markDatesBetweenStartAndHoveredDate(u,v);}};
g.prototype.onBeforeRendering=function(){var t=this.getAggregation("month");var u;var v=t[0].getDate();var F=this._getFocusedDate();if(t.length>1&&v){u=c.fromLocalJSDate(v,this.getPrimaryCalendarType());}else if(t.length>1){u=s.call(this,this._getFocusedDate());}else{u=F;}for(var i=0;i<t.length;i++){v=new c(u);if(i>0){v.setDate(1);v.setMonth(v.getMonth()+i);}var w=v;if(F.getYear()===v.getYear()&&F.getMonth()===v.getMonth()){w=F;}t[i].displayDate(w.toLocalJSDate());t[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(u);this._iSize=0;};
g.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){h.call(this);}if(k.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};r.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};
g.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=q.sap.delayedCall(0,this,this._invalidateMonth,[O]);}};
g.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};
g.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};
g.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
g.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};
g.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
g.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
g.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};
g.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
g.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};
g.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
g.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};
g.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};
g.prototype.focusDate=function(i){j.call(this,i,false);return this;};
g.prototype.displayDate=function(i){j.call(this,i,true);return this;};
g.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};
g.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};
g.prototype.setMonths=function(t){this._bDateRangeChanged=undefined;this.setProperty("months",t,false);t=k.call(this);var u=this.getAggregation("month");var i=0;var v;if(u.length<t){for(i=u.length;i<t;i++){v=this._createMonth(this.getId()+"--Month"+i);v.attachEvent("focus",this._handleFocus,this);v.attachEvent("select",n,this);v.attachEvent("_renderMonth",m,this);v.attachEvent("_bindMousemove",o,this);v.attachEvent("_unbindMousemove",p,this);v._bNoThemeChange=true;this.addAggregation("month",v);}}else if(u.length>t){for(i=u.length;i>t;i--){v=this.removeAggregation("month",i-1);v.destroy();}if(t==1){this._bInitMonth=true;}}if(t>1&&u[0].getDate()){u[0].setProperty("date",null,true);}return this;};
g.prototype.setPrimaryCalendarType=function(t){var u=this.getAggregation("month");var v=false;if(u.length>1){v=true;}this.setProperty("primaryCalendarType",t,!v);this._oYearFormat=d.getDateInstance({format:"y",calendarType:t});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,t);}this._oMinDate=new c(this._oMinDate,t);this._oMaxDate=new c(this._oMaxDate,t);for(var i=0;i<u.length;i++){var w=u[i];w.setPrimaryCalendarType(t);}if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("monthPicker");x.setPrimaryCalendarType(t);var y=this.getAggregation("yearPicker");y.setPrimaryCalendarType(t);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&x.getDomRef()){x.$().remove();}if(this.iMode!=2&&y.getDomRef()){y.$().remove();}}}return this;};
g.prototype.setSecondaryCalendarType=function(t){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",t,true);this._oYearFormatSecondary=d.getDateInstance({format:"y",calendarType:t});var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];v.setSecondaryCalendarType(t);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};
g.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};
g.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMinDate.getYear();a._checkYearInValidRange(y);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var t=this.getAggregation("yearPicker");t._oMinDate.setYear(this._oMinDate.getYear());}return this;};
g.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMaxDate.getYear();a._checkYearInValidRange(y);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var t=this.getAggregation("yearPicker");t._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};
g.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){q.sap.log.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};
g.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var t=new e(i);this._oLocaleData=L.getInstance(t);}return this._oLocaleData;};
g.prototype._getShowMonthHeader=function(){var i=k.call(this);if(i>2){return true;}else{return false;}};
g.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);if(w){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};
g.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};
g.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};
g.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};
g.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};
g.prototype.onsaphide=g.prototype.onsapshow;
g.prototype.onsaptabnext=function(E){var t=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){q.sap.focus(t.getDomRef("B2"));}else{q.sap.focus(t.getDomRef("B1"));}if(!this._bPoupupMode){var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var w=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(w.getDomRef()){q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(y.getDomRef()){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){q.sap.focus(t.getDomRef("B2"));E.preventDefault();}};
g.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};
g.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};
g.prototype.onsaptabprevious=function(E){var t=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){q.sap.focus(t.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==t.getId()+"-B1"){var u=this.getAggregation("month");var F;switch(this._iMode){case 0:F=this._getFocusedDate();for(var i=0;i<u.length;i++){var v=u[i];var w=c.fromLocalJSDate(v.getDate(),this.getPrimaryCalendarType());if(F.isSame(w)){v._oItemNavigation.focusItem(v._oItemNavigation.getFocusedIndex());}else{q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("monthPicker");x._oItemNavigation.focusItem(x._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var y=this.getAggregation("yearPicker");y._oItemNavigation.focusItem(y._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==t.getId()+"-B2"){q.sap.focus(t.getDomRef("B1"));E.preventDefault();}};
g.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var t=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<t.length;i++){var u=t[i];q(u._oItemNavigation.getItemDomRefs()[u._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var v=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(v.getDomRef()){q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(y.getDomRef()){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
g.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");q.sap.focus(i.getDomRef("B2"));};
g.prototype.onsapfocusleave=function(E){var t,u,v,y;if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){t=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<t.length;i++){u=t[i];q(u._oItemNavigation.getItemDomRefs()[u._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){v=this.getAggregation("monthPicker");q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){y=this.getAggregation("yearPicker");q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
g.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};
g.prototype.onThemeChanged=function(){var t;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){t=this.getAggregation("monthPicker");this._showMonthPicker(true);t._bNoThemeChange=false;t.onThemeChanged(arguments);t._bNoThemeChange=true;this._bLongMonth=t._bLongMonth;this._hideMonthPicker(true);}var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];v._bNoThemeChange=false;v.onThemeChanged(arguments);v._bNoThemeChange=true;}var w;if(u.length>1){w=c.fromLocalJSDate(u[0].getDate(),this.getPrimaryCalendarType());}else{w=this._getFocusedDate();}this._setHeaderText(w);if(!this._getSucessorsPickerPopup()){h.call(this);}};
g.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};
g.prototype._togglePrevNext=function(i,t){var y=this._oMaxDate.getYear();var u=this._oMinDate.getYear();var v=this._oMaxDate.getMonth();var w=this._oMinDate.getMonth();var x=this.getAggregation("header");var z=k.call(this);var A=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&z>1){A=s.call(this,i);A.setMonth(A.getMonth()+z-1);A.setDate(a._daysInMonth(A));}else{A.setDate(a._daysInMonth(A));}var B=A.getYear();var E=A.getMonth();if(B>y||(B==y&&(!t||E>=v))||(this._iMode==1&&this._getSucessorsPickerPopup())){x.setEnabledNext(false);}else{x.setEnabledNext(true);}if(this._iMode==0&&z>1){A.setMonth(A.getMonth()-z+1);A.setDate(1);}else{A.setDate(1);}B=A.getYear();E=A.getMonth();if(B<u||(B==u&&(!t||E<=w))||(this._iMode==1&&this._getSucessorsPickerPopup())){x.setEnabledPrevious(false);}else{x.setEnabledPrevious(true);}};
g.prototype._togglePrevNexYearPicker=function(){var y=this.getAggregation("yearPicker");var i=y.getYears();var t=c.fromLocalJSDate(y.getFirstRenderedDate());t.setYear(t.getYear()+Math.floor(i/2));var u=this.getAggregation("header");var v=new c(this._oMaxDate,this.getPrimaryCalendarType());v.setYear(v.getYear()-Math.ceil(i/2));v.setMonth(11);v.setDate(31);var w=new c(this._oMinDate,this.getPrimaryCalendarType());w.setYear(w.getYear()+Math.floor(i/2)+1);w.setMonth(0);w.setDate(1);u.setEnabledNext(t.isSameOrBefore(v));u.setEnabledPrevious(t.isSameOrAfter(w));};
g.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var y=this.getAggregation("yearPicker");var t=k.call(this);var u;var v;var S=false;switch(this._iMode){case 0:if(t>1){u=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());u.setDate(1);this._setFocusedDate(u);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);i.setTextButton2(this._oYearFormat.format(F.toUTCJSDate(),true));i.setAriaLabelButton1(this._oYearFormat.format(F.toUTCJSDate(),true));var w=this._getSecondaryCalendarType();if(w){v=new c(F,w);v.setMonth(0);v.setDate(1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(v.toUTCJSDate(),true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};
g.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var y=this.getAggregation("yearPicker");var t=k.call(this);var u;var v;switch(this._iMode){case 0:if(t>1){u=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(u);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+t);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);i.setTextButton2(this._oYearFormat.format(F.toUTCJSDate(),true));i.setAriaLabelButton1(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){v=new c(F,S);v.setMonth(0);v.setDate(1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(v.toUTCJSDate(),true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};
g.prototype._getDisplayedMonths=function(t){var u=[];var v=t.getMonth();var w=k.call(this);if(w>1){for(var i=0;i<w;i++){u.push((v+i)%12);}}else{u.push(v);}return u;};
g.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var t=F.getMonth();var u=c.fromLocalJSDate(i[i.length-1].getDate(),P);u.setDate(a._daysInMonth(u));u=new c(u,S);var E=u.getMonth();return{start:t,end:E};};
g.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};
g.prototype._setDisabledMonths=function(y,i){var t=0;var u=11;if(y==this._oMinDate.getYear()){t=this._oMinDate.getMonth();}if(y==this._oMaxDate.getYear()){u=this._oMaxDate.getMonth();}if(!i){i=this.getAggregation("monthPicker");}i.setMinMax(t,u);};
g.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var t=E.getParameter("restoreOldDate");if(t){if(!q.sap.equal(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};
g.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};
g.prototype._renderMonth=function(S,I,N){var t=this._getFocusedDate();var u=this.getAggregation("month");var F=false;var v;var w;var x;var i=0;for(i=0;i<u.length;i++){v=u[i];if(v.checkDateFocusable(t.toLocalJSDate())){F=true;}if(F||u.length==1){if(!S){v.setDate(t.toLocalJSDate());}else{v.displayDate(t.toLocalJSDate());}break;}}if(!F){x=new c(t,this.getPrimaryCalendarType());if(u.length>1){x=s.call(this,x);for(i=0;i<u.length;i++){v=u[i];w=new c(x,this.getPrimaryCalendarType());w.setMonth(x.getMonth()+i);if(!S&&a._isSameMonthAndYear(w,t)){v.setDate(t.toLocalJSDate());}else{v.displayDate(w.toLocalJSDate());}}}this._updateHeader(x);if(!N){this.fireStartDateChange();}}};
function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}
g.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var t=this._getFocusedDate();var u=this.getAggregation("monthPicker");if(u.getDomRef()){u.$().css("display","");}else{var v=sap.ui.getCore().createRenderManager();var $=this.$("content");v.renderControl(u);v.flush($[0],false,true);v.destroy();}this._showOverlay();if(!S){u.setMonth(t.getMonth());this._setDisabledMonths(t.getYear(),u);if(this._iMode==0){var w=this.getAggregation("month");for(var i=0;i<w.length;i++){var x=w[i];q(x._oItemNavigation.getItemDomRefs()[x._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(t,false);};
g.prototype._hideMonthPicker=function(S){this._iMode=0;var t=this.getAggregation("monthPicker");t.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(k.call(this)>1){var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};
g.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var t=this._getFocusedDate();var y=this.getAggregation("yearPicker");if(y.getDomRef()){y.$().css("display","");}else{var u=sap.ui.getCore().createRenderManager();var $=this.$("content");u.renderControl(y);u.flush($[0],false,true);u.destroy();}this._showOverlay();y.setDate(t.toLocalJSDate());var v;if(k.call(this)==1){v=this.getAggregation("month")[0];var w=v.$("days").find(".sapUiCalItem");if(w.length==28){y.$().addClass("sapUiCalYearNoTop");}else{y.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){v=x[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};
g.prototype._hideYearPicker=function(S){this._iMode=0;var y=this.getAggregation("yearPicker");y.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(k.call(this)>1){var t=this.getAggregation("month");for(var i=0;i<t.length;i++){var u=t[i];q(u._oItemNavigation.getItemDomRefs()[u._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};
function h(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var t=this.getAggregation("month");var u;if(t.length>1){u=c.fromLocalJSDate(t[0].getDate(),this.getPrimaryCalendarType());}else{u=this._getFocusedDate();}this._setHeaderText(u);}}else if(k.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}
g.prototype._focusDate=function(i,O,N){var F;var t=false;var u=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;t=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;t=true;}else{F=i;}if(this._focusDateExtend){u=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(t||O){this._renderMonth(false,I,N);}if(u){this.fireStartDateChange();}};
g.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var t=this.getAggregation("month");if(t){for(var i=0;i<t.length;i++){var u=t[i];u._bDateRangeChanged=true;u._bInvalidateSync=true;u._bNoFocus=true;u.invalidate(O);u._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};
g.prototype._setHeaderText=function(i){var t=this.getAggregation("header");var u=this._getLocaleData();var v=[];var w=[];var x=[];var A;var S=false;var T;var y;var P;var z=this.getPrimaryCalendarType();var B=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){v=u.getMonthsStandAlone("wide",z);}else{S=true;v=u.getMonthsStandAlone("abbreviated",z);w=u.getMonthsStandAlone("wide",z);}if(B){x=u.getMonthsStandAlone("abbreviated",B);var E=this._getDisplayedSecondaryMonths(z,B);if(E.start==E.end){T=x[E.start];}else{P=u.getIntervalPattern();T=P.replace(/\{0\}/,x[E.start]).replace(/\{1\}/,x[E.end]);}}t.setAdditionalTextButton1(T);var F=this._getDisplayedMonths(i);if(F.length>1&&!this._bShowOneMonth){if(!P){P=u.getIntervalPattern();}T=P.replace(/\{0\}/,v[F[0]]).replace(/\{1\}/,v[F[F.length-1]]);A=w.length?P.replace(/\{0\}/,w[F[0]]).replace(/\{1\}/,w[F[F.length-1]]):T;}else{T=v[F[0]];A=w[F[0]]||T;}t.setTextButton1(T);t.setAriaLabelButton1(A);var G=new c(i,z);G.setDate(1);y=this._oYearFormat.format(G.toUTCJSDate(),true);t.setTextButton2(y);t.setAriaLabelButton2(y);if(B){G=new c(G,B);t.setAdditionalTextButton2(this._oYearFormatSecondary.format(G.toUTCJSDate(),true));}else{t.setAdditionalTextButton2();}return{sMonth:T,sYear:y,sAriaLabel:A,bShort:S};};
function j(i,S){if(!i){return;}var t=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=t.getYear();a._checkYearInValidRange(y);if(a._isOutside(t,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(t);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}
function k(){if(D.system.phone){return 1;}else{return this.getMonths();}}
g.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};
g.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};
function m(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}
function n(E){if(k.call(this)>1){var t=this.getAggregation("month");for(var i=0;i<t.length;i++){var u=t[i];if(u.getId()!=E.oSource.getId()){u._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}
function o(E){if(k.call(this)>1){var t=this.getAggregation("month");for(var i=0;i<t.length;i++){var u=t[i];if(u.getId()!=E.oSource.getId()){u._bindMousemove();}}}}
function p(E){if(k.call(this)>1){var t=this.getAggregation("month");for(var i=0;i<t.length;i++){var u=t[i];if(u.getId()!=E.oSource.getId()){u._unbindMousemove();}}}}
g.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),t=i.getMonth();F.setMonth(t);if(t!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};
g.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};
g.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var y=this.getAggregation("yearPicker");var i=c.fromLocalJSDate(y.getDate(),this.getPrimaryCalendarType());i.setMonth(F.getMonth());i.setDate(F.getDate());F=i;this._focusDate(F,true);this._hideYearPicker();};
g.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
g.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
function r(E){var w=E.size.width;if(w<=0){return;}var O=this._iSize;if(w<this._iBreakPointTablet){this._iSize=0;}else if(w<this._iBreakPointDesktop){this._iSize=1;}else if(w<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var t=k.call(this);var u;if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:u=2;break;case 2:u=3;break;case 3:u=4;break;default:u=1;break;}if(t<u){u=t;}if(u>2&&t>u){var v=u;var U=0.0;var x=u;while(v>=2){var y=t%v;if(y==0){x=v;break;}else{var N=y/v;if(N>U){U=N;x=v;}}v--;}u=x;}var W;var z=this.getAggregation("month");if(u>1){W=100/u+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{W="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<z.length;i++){var A=z[i];A.setWidth(W);}}}
function s(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var t=k.call(this);if(t<=12){var u=i.getMonth();u=u-u%t;if(12%t>0&&u+t>11){u=12-t;}F.setMonth(u);}return F;}
return g;});
sap.ui.predefine('sap/ui/unified/CalendarAppointment',['jquery.sap.global','./DateTypeRange','sap/ui/core/format/DateFormat','./library'],function(q,D,a,l){"use strict";
var C=D.extend("sap.ui.unified.CalendarAppointment",{metadata:{library:"sap.ui.unified",properties:{title:{type:"string",group:"Data"},text:{type:"string",group:"Data"},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},tentative:{type:"boolean",group:"Data",defaultValue:false},selected:{type:"boolean",group:"Data",defaultValue:false},key:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
C.prototype.applyFocusInfo=function(f){var p=this.getParent();if(p){p.applyFocusInfo(f);}return this;};
C.prototype._getDateRangeIntersectionText=function(c){var s=this.getStartDate(),e=this.getEndDate()?this.getEndDate():new Date(864000000000000),t,o=new Date(c.getFullYear(),c.getMonth(),c.getDate(),0,0,0),n=new Date(o.getTime()+24*60*60*1000),T=a.getTimeInstance({pattern:"HH:mm"}),r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(s.getTime()>n.getTime()||e.getTime()<o.getTime()){t="";}else if(s.getTime()<o.getTime()&&e.getTime()>n.getTime()){t=r.getText("PLANNINGCALENDAR_ALLDAY");}else if(s.getTime()<o.getTime()){t=r.getText("PLANNINGCALENDAR_UNTIL",[T.format(e)]);}else if(e.getTime()>n.getTime()){t=T.format(s);}else{t=T.format(s)+" - "+T.format(e);}return t;};
C._getComparer=function(d){var O=24*60*60*1000,c=new Date(d.getFullYear(),d.getMonth(),d.getDate(),0,0,0).getTime(),n=c+O;return function(A,o){var s=A.appointment.getStartDate().getTime(),S=o.appointment.getStartDate().getTime(),e=A.appointment.getEndDate()?A.appointment.getEndDate().getTime():864000000000000,E=o.appointment.getEndDate()?o.appointment.getEndDate().getTime():864000000000000,w=s<=c&&e>=n,W=S<=c&&E>=n,r;if((w&&W)||(!w&&!W)){r=s-S;if(r===0){r=E-e;}}else if(w){r=-1;}else{r=1;}return r;};};
C.prototype.setColor=function(c){if(c&&c.match(/^#[0-9a-f]{6}$/i)){q.sap.log.warning("setColor accepts only full hex color value with pound symbol.");}return this.setProperty("color",c);};
C.prototype._getCSSColorForBackground=function(h){return"rgba("+[parseInt(h.substr(1,2),16),parseInt(h.substr(3,2),16),parseInt(h.substr(5,2),16)].join(",")+", 0.2)";};
return C;});
sap.ui.predefine('sap/ui/unified/CalendarDateInterval',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/Device',"./CalendarDateIntervalRenderer"],function(q,C,a,D,M,Y,b,l,c,d){"use strict";
var e=a.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarDateInterval.designtime"}});
e.prototype.init=function(){a.prototype.init.apply(this,arguments);this._iDaysMonthHead=35;};
e.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};
e.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
e.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var h=this.getAggregation("header"),m,y;if(p){if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}h.setVisibleButton2(false);h.detachEvent("pressButton2",this._handleButton2,this);this._setHeaderText(this._getFocusedDate(true));}else{if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}m=this.getAggregation("monthPicker");y=this.getAggregation("yearPicker");m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);y._oMinDate.setYear(this._oMinDate.getYear());y._oMaxDate.setYear(this._oMaxDate.getYear());h.setVisibleButton2(true);h.detachEvent("pressButton2",this._handleButton2,this);h.attachEvent("pressButton2",this._handleButton2,this);}return this;};
e.prototype._createMonthPicker=function(){var m=new M(this.getId()+"--MP");m.attachEvent("select",this._selectMonth,this);m._bNoThemeChange=true;m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",_,this);return m;};
e.prototype._createYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",f,this);return y;};
e.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new a(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",this._handleCalendarPickerDateSelect,this);o.attachEvent("cancel",function(E){this._closeCalendarPicker();},this);this.setAggregation("calendarPicker",o);}return o;};
e.prototype._handleButton1=function(E){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}}};
e.prototype._setHeaderText=function(o){var t=a.prototype._setHeaderText.apply(this,arguments);var T,A,h=this.getAggregation("header");var L=this._getLocaleData();if(this.getPickerPopup()){if(L.oLocale.sLanguage.toLowerCase()==="ja"||L.oLocale.sLanguage.toLowerCase()==="zh"){T=t.sYear+" "+t.sMonth;A=t.sYear+t.sAriaLabel;}else{T=t.sMonth+" "+t.sYear;A=t.sAriaLabel+t.sYear;}h.setTextButton1(T,true);if(t.bShort){h.setAriaLabelButton1(A);}}};
e.prototype._showCalendarPicker=function(){var s=this.getStartDate(),o=this._getCalendarPicker(),S=new sap.ui.unified.DateRange(),E=new Date(s.getTime());E.setDate(E.getDate()+this._getDays()-1);S.setStartDate(s);S.setEndDate(E);o.displayDate(this._getFocusedDate().toLocalJSDate());o.removeAllSelectedDates();o.addSelectedDate(S);o.setMinDate(this.getMinDate());o.setMaxDate(this.getMaxDate());this._openPickerPopup(o);this._showOverlay();};
e.prototype._handleCalendarPickerDateSelect=function(E){var o=this._getCalendarPicker(),n=new b(o._getFocusedDate());this._setStartDate(n);this._setFocusedDate(n);this._closeCalendarPicker();};
e.prototype._closeCalendarPicker=function(s){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!s){this._renderMonth();var m=this.getAggregation("month");for(var i=0;i<m.length;i++){var o=m[i];q(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}};
e.prototype._getDaysLarge=function(){return 10;};
e.prototype._createMonth=function(i){var m=new D(i);return m;};
e.prototype.setStartDate=function(s){C._checkJSDateObject(s);if(q.sap.equal(this.getStartDate(),s)){return this;}var y=s.getFullYear();C._checkYearInValidRange(y);var o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());if(C._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var m=this.getMinDate();if(m&&s.getTime()<m.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m.getTime());}var g=this.getMaxDate();if(g&&s.getTime()>g.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(g.getTime());}this.setProperty("startDate",s,true);o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var h=this.getAggregation("month")[0];h.setStartDate(s);this._updateHeader(o);var i=this._getFocusedDate(true).toLocalJSDate();if(!h.checkDateFocusable(i)){this._setFocusedDate(o);h.displayDate(s);}return this;};
e.prototype.getStartDate=function(){return this.getProperty("startDate");};
e.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var g=Math.ceil(i/3);if(g>12){g=12;}m.setMonths(g);var y=this.getAggregation("yearPicker");var h=Math.floor(i/2);if(h>20){h=20;}y.setYears(h);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
e.prototype._getDays=function(){var i=this.getDays();if(c.system.phone&&i>8){return 8;}else{return i;}};
e.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};
e.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};
e.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;a.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=b.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};
e.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};
e.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
e.prototype.focusDate=function(o){var g=this.getAggregation("month")[0];if(!g.checkDateFocusable(o)){this._focusDateExtend(b.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}a.prototype.focusDate.apply(this,arguments);return this;};
e.prototype._shouldFocusB2OnTabNext=function(E){var h=this.getAggregation("header");return(!this.getPickerPopup()&&E.target.id==h.getId()+"-B1");};
e.prototype._focusOnShiftTab=function(){var h=this.getAggregation("header");if(this.getPickerPopup()){q.sap.focus(h.getDomRef("B1"));}else{q.sap.focus(h.getDomRef("B2"));}};
e.prototype.onsapescape=function(E){if(this.getPickerPopup()){this._closeCalendarPicker();this.fireCancel();}else{if(this._iMode===0){this.fireCancel();}this._closedPickers();}};
e.prototype._focusDateExtend=function(o,O,n){if(O){var g=this._getFocusedDate();var h=this._getStartDate();var i=C._daysBetween(g,h);var N=new b(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-i);this._setStartDate(N,false,true);if(!n){return true;}}return false;};
e.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new b(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new b(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){q.sap.log.warning("end date > maxDate -> start date will be changed",this);var s=new b(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};
e.prototype._togglePrevNext=function(o,g){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return a.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var i=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var h=this._oMinDate.getMonth();var j=this._oMinDate.getDate();var k=this._oMaxDate.getDate();var H=this.getAggregation("header");var n=this._getDays();var p;var s;var E;var r;var t;if(this._iMode==1&&!g){var u=this.getAggregation("monthPicker");var v=u.getMonths();var S=u.getStartMonth();var w=S+v-1;p=o.getYear();if(S==0||(p==i&&S<=h)){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}if(w>10||(p==y&&w>=m)){H.setEnabledNext(false);}else{H.setEnabledNext(true);}return;}s=this._getStartDate();E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+n-1);if(C._isOutside(o,s,E)){s=new b(o,this.getPrimaryCalendarType());E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+n-1);}p=s.getYear();r=s.getMonth();t=s.getDate();if(p<i||(p==i&&(!g||r<h||(r==h&&t<=j)))){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}p=E.getYear();r=E.getMonth();t=E.getDate();if(p>y||(p==y&&(!g||r>m||(r==m&&t>=k)))){H.setEnabledNext(false);}else{H.setEnabledNext(true);}};
e.prototype._shiftStartFocusDates=function(s,F,i){s.setDate(s.getDate()+i);F.setDate(F.getDate()+i);this._setFocusedDate(F);this._setStartDate(s,true);};
e.prototype._handlePrevious=function(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,(i*-1));break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.previousPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()-1);var g=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(g){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.previousPage();this._togglePrevNexYearPicker();}break;}};
e.prototype._handleNext=function(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,i);break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.nextPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()+1);var g=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(g){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.nextPage();this._togglePrevNexYearPicker();}break;}};
e.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getMonth();var g=this._getDays();m.push(i);if(g>this._getDaysLarge()){var E=new b(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+g-1);var h=E.getMonth();while(i!=h){i=(i+1)%12;m.push(i);}}return m;};
e.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new b(this._getStartDate(),s);var g=S.getMonth();var E=new b(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new b(E,s);var h=E.getMonth();return{start:g,end:h};};
e.prototype._openPickerPopup=function(p){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(function(){this._closeCalendarPicker(true);},this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var h=this.getAggregation("header");var g=sap.ui.core.Popup.Dock;this._oPopup.open(0,g.CenterTop,g.CenterTop,h,null,"flipfit",true);};
e.prototype._setStartDate=function(s,S,n){var m=new b(this._oMaxDate,this.getPrimaryCalendarType());m.setDate(m.getDate()-this._getDays()+1);if(m.isBefore(this._oMinDate)){m=new b(this._oMinDate);m.setDate(m.getDate()+this._getDays()-1);}if(s.isBefore(this._oMinDate)){s=new b(this._oMinDate,this.getPrimaryCalendarType());}else if(s.isAfter(m)){s=m;}var L=s.toLocalJSDate();this.setProperty("startDate",L,true);this._oStartDate=s;var o=this.getAggregation("month")[0];o.setStartDate(L);this._updateHeader(s);if(S){var g=this._getFocusedDate().toLocalJSDate();if(!o.checkDateFocusable(g)){this._setFocusedDate(s);o.setDate(L);}else{o.setDate(g);}}if(!n){this.fireStartDateChange();}};
e.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};
function _(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(F);}
function f(E){this._togglePrevNexYearPicker();}
return e;});
sap.ui.predefine('sap/ui/unified/CalendarDateIntervalRenderer',['sap/ui/core/Renderer','./CalendarRenderer'],function(R,C){"use strict";var a=R.extend(C);
a.renderCalContentOverlay=function(){};
a.renderCalContentAndArrowsOverlay=function(r,c,i){if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");}};
a.addAttributes=function(r,c){r.addClass("sapUiCalInt");r.addClass("sapUiCalDateInt");var d=c._getDays();if(d>c._getDaysLarge()){r.addClass("sapUiCalIntLarge");}if(d>c._iDaysMonthHead){r.addClass("sapUiCalIntHead");}};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarLegend',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/Device','./CalendarLegendRenderer'],function(q,C,l,D,a){"use strict";var b=l.CalendarDayType;var S=l.StandardCalendarLegendItem;
var c=C.extend("sap.ui.unified.CalendarLegend",{
metadata:{library:"sap.ui.unified",properties:{standardItems:{type:"string[]",group:"Misc",defaultValue:['Today','Selected','WorkingDay','NonWorkingDay']},columnWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'120px'}},aggregations:{items:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,singularName:"item"},_standardItems:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarLegend.designtime"},
constructor:function(i,s){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){s=i;}if(!s||(s&&!s.standardItems)){this._addStandardItems(this.getStandardItems());}}
});
c.prototype.onAfterRendering=function(){if(D.browser.msie){if(D.browser.version<10){q(".sapUiUnifiedLegendItem").css("width",this.getColumnWidth()+4+"px").css("display","inline-block");}}};
c.prototype.setStandardItems=function(v){var i;if(v&&v.length===1&&v[0]===""){v=[];}if(v&&v.length){v=this.validateProperty("standardItems",v);for(i=0;i<v.length;i++){if(!S[v[i]]){throw new Error("Invalid value '"+v[i]+"'. Property standardItems must contain values from sap.ui.unified.StandardCalendarLegendItem.");}}}this.setProperty("standardItems",v);this._addStandardItems(this.getStandardItems(),true);return this;};
c.prototype._addStandardItems=function(s,r){var i,d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),I=this.getId();if(r){this.destroyAggregation("_standardItems");}for(i=0;i<s.length;i++){var o=new sap.ui.unified.CalendarLegendItem(I+"-"+s[i],{text:d.getText(c._Standard_Items_TextKeys[s[i]])});this.addAggregation("_standardItems",o);}};
c._Standard_Items_TextKeys={"Today":"LEGEND_TODAY","Selected":"LEGEND_SELECTED","WorkingDay":"LEGEND_NORMAL_DAY","NonWorkingDay":"LEGEND_NON_WORKING_DAY"};
c.prototype._getItemType=function(i,I){var t=i.getType(),n,f;if(t&&t!==b.None){return t;}f=this._getUnusedItemTypes(I);n=I.filter(function(d){return!d.getType()||d.getType()===b.None;}).indexOf(i);if(n<0){q.sap.log.error('Legend item is not in the legend',this);return t;}if(f[n]){t=f[n];}else{t="Type"+(Object.keys(b).length+n-f.length-1);}return t;};
c.prototype._getItemByType=function(t){var I,d=this.getItems(),i;for(i=0;i<d.length;i++){if(this._getItemType(d[i],d)===t){I=d[i];break;}}return I;};
c.prototype._getUnusedItemTypes=function(I){var f=q.extend({},b),t,i;delete f[b.None];delete f[b.NonWorking];for(i=0;i<I.length;i++){t=I[i].getType();if(f[t]){delete f[t];}}return Object.keys(f);};
return c;});
sap.ui.predefine('sap/ui/unified/CalendarLegendItem',['sap/ui/core/Element','./library'],function(E,l){"use strict";var C=l.CalendarDayType;
var a=E.extend("sap.ui.unified.CalendarLegendItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.None},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/ui/unified/CalendarLegendRenderer',['sap/ui/core/InvisibleText'],function(I){"use strict";var C={};
C.render=function(r,l){var s=l.getAggregation("_standardItems"),c=l.getItems(),i,a,b;r.write("<div");r.writeControlData(l);r.addClass("sapUiUnifiedLegend");r.writeClasses();r.write(">");this.renderItemsHeader(r,l);if(s||c){r.write("<div");r.addClass("sapUiUnifiedLegendItems");r.writeClasses();b=l.getColumnWidth();r.writeAttribute("style","column-width:"+b+";-moz-column-width:"+b+";-webkit-column-width:"+b+";");r.writeStyles();r.write(">");if(s){a=l.getId().length+1;for(i=0;i<s.length;++i){var d="sapUiUnifiedLegend"+s[i].getId().slice(a);this.renderLegendItem(r,d,s[i],["sapUiUnifiedLegendSquareColor"]);}}if(c){for(i=0;i<c.length;i++){this.renderLegendItem(r,"sapUiCalLegDayType"+l._getItemType(c[i],c).slice(4),c[i],["sapUiUnifiedLegendSquareColor"]);}}r.write("</div>");}this.renderAdditionalContent(r,l);r.write("</div>");};
C.renderLegendItem=function(r,c,i,a){var t=i.getText();var T=i.getTooltip_AsString();r.write("<div");r.writeElementData(i);if(T){r.writeAttributeEscaped('title',T);}r.addClass("sapUiUnifiedLegendItem");r.addClass(c);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUnifiedLegendSquare");r.writeClasses();r.write(">");this.renderColor(r,i.getColor(),a);r.write("</div>");r.write("<div");r.writeAttribute("id",i.getId()+"-Text");r.addClass("sapUiUnifiedLegendDescription");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div></div>");};
C.renderItemsHeader=function(r,l){};
C.renderAdditionalContent=function(r,l){};
C.renderColor=function(r,c,a){r.write("<div");for(var i=0;i<a.length;i++){r.addClass(a[i]);}if(c){r.addStyle("background-color",c);r.writeStyles();}r.writeClasses();r.write("></div>");};
C.addCalendarTypeAccInfo=function(a,t,l){var T,s;if(l){var L=l._getItemByType(t);if(L){T=L.getText();}}if(T){a["label"]=a["label"]?a["label"]+"; "+T:T;}else{s=C.getTypeAriaText(t);if(s){a["describedby"]=a["describedby"]?a["describedby"]+" "+s.getId():s.getId();}}};
C.typeARIATexts={};
C.getTypeAriaText=function(t){var r,T;if(t.indexOf("Type")!==0){return;}if(!C.typeARIATexts[t]){r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");T=r.getText("LEGEND_UNNAMED_TYPE",parseInt(t.slice(4),10).toString());C.typeARIATexts[t]=new I({text:T});C.typeARIATexts[t].toStatic();}return C.typeARIATexts[t];};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarMonthInterval',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./Calendar','./CalendarRenderer',"./CalendarMonthIntervalRenderer"],function(q,D,C,L,a,R,b,c,H,M,Y,d,e,f,g){"use strict";
var h=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
h.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=b.getDateInstance({format:"y"});this._oMinDate=c._minDate();this._oMaxDate=c._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};
h.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};
h.prototype.onBeforeRendering=function(){var J=this.getAggregation("monthsRow");var K=this._getFocusedDate();n.call(this);J.displayDate(K.toLocalJSDate());};
h.prototype._initializeHeader=function(){var J=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});J.attachEvent("pressPrevious",this._handlePrevious,this);J.attachEvent("pressNext",this._handleNext,this);J.attachEvent("pressButton2",u,this);this.setAggregation("header",J);};
h.prototype._initializeMonthsRow=function(){var J=new M(this.getId()+"--MonthsRow");J.attachEvent("focus",x,this);J.attachEvent("select",w,this);J._bNoThemeChange=true;this.setAggregation("monthsRow",J);};
h.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
h.prototype._createYearPicker=function(){var J=new Y(this.getId()+"--YP",{columns:0,years:6});J.attachEvent("select",z,this);J.attachEvent("pageChange",G,this);J._oMinDate.setYear(this._oMinDate.getYear());J._oMaxDate.setYear(this._oMaxDate.getYear());return J;};
h.prototype._getCalendarPicker=function(){var J=this.getAggregation("calendarPicker");if(!J){J=new I(this.getId()+"--Cal");J.setPopupMode(true);J.attachEvent("select",y,this);J.attachEvent("cancel",function(K){this._oPopup.close();},this);this.setAggregation("calendarPicker",J);}return J;};
h.prototype.setStartDate=function(S){c._checkJSDateObject(S);if(q.sap.equal(this.getStartDate(),S)){return this;}var J=S.getFullYear();c._checkYearInValidRange(J);this.setProperty("startDate",S,true);this._oStartDate=d.fromLocalJSDate(S);this._oStartDate.setDate(1);var K=this.getAggregation("monthsRow");K.setStartDate(S);n.call(this);var N=this._getFocusedDate().toLocalJSDate();if(!K.checkDateFocusable(N)){this._setFocusedDate(this._oStartDate);K.displayDate(S);}return this;};
h.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,A);}};
h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var J=this.removeAllAggregation("selectedDates");return J;};
h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var J=this.destroyAggregation("selectedDates");return J;};
h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var J=this.removeAllAggregation("specialDates");return J;};
h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var J=this.destroyAggregation("specialDates");return J;};
h.prototype.setLocale=function(J){if(this._sLocale!=J){this._sLocale=J;this._oLocaleData=undefined;this.invalidate();}return this;};
h.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
h.prototype._getFocusedDate=function(){if(!this._oFocusedDate){k.call(this);}return this._oFocusedDate;};
h.prototype._setFocusedDate=function(J){c._checkCalendarDate(J);this._oFocusedDate=new d(J);};
h.prototype.focusDate=function(J){var K=false;var N=this.getAggregation("monthsRow");if(J&&!N.checkDateFocusable(J)){B.call(this,d.fromLocalJSDate(J));K=true;}t.call(this,J,false);if(K){this.fireStartDateChange();}return this;};
h.prototype.displayDate=function(J){t.call(this,J,true);return this;};
h.prototype.setMonths=function(J){this.setProperty("months",J,true);J=this._getMonths();var K=this.getAggregation("monthsRow");K.setMonths(J);if(!K.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=i.call(this);this._setFocusedDate(this._oStartDate);K.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var N=this.getAggregation("yearPicker");var O=Math.floor(J/2);if(O>20){O=20;}N.setYears(O);}n.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
h.prototype._getMonths=function(){var J=this.getMonths();if(D.system.phone&&J>6){return 6;}else{return J;}};
h.prototype._getLocaleData=function(){if(!this._oLocaleData){var J=this.getLocale();var K=new L(J);this._oLocaleData=a.getInstance(K);}return this._oLocaleData;};
h.prototype.setPickerPopup=function(P){var J;this.setProperty("pickerPopup",P,true);if(P){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}J=this.getAggregation("yearPicker");J.setColumns(0);J.setYears(6);}return this;};
h.prototype.setMinDate=function(J){if(q.sap.equal(J,this.getMinDate())){return this;}if(!J){this._oMinDate=c._minDate();}else{c._checkJSDateObject(J);this._oMinDate=d.fromLocalJSDate(J);this._oMinDate.setDate(1);var K=this._oMinDate.getYear();c._checkYearInValidRange(K);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=d.fromLocalJSDate(J);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){q.sap.log.warning("focused date < minDate -> minDate focused",this);this.focusDate(J);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate set as start date",this);_.call(this,new d(this._oMinDate),true,true);}}this.setProperty("minDate",J,false);if(this.getPickerPopup()){var N=this._getCalendarPicker();N.setMinDate(J);}else{var O=this.getAggregation("yearPicker");O._oMinDate.setYear(this._oMinDate.getYear());}return this;};
h.prototype.setMaxDate=function(J){if(q.sap.equal(J,this.getMaxDate())){return this;}if(!J){this._oMaxDate=c._maxDate();}else{c._checkJSDateObject(J);this._oMaxDate=d.fromLocalJSDate(J);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));var K=this._oMaxDate.getYear();c._checkYearInValidRange(K);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=d.fromLocalJSDate(J);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){q.sap.log.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(J);}}if(this._oStartDate){var N=new d(this._oStartDate);N.setDate(1);N.setMonth(N.getMonth()+this._getMonths());N.setDate(0);if(N.isAfter(this._oMaxDate)){var S=new d(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){q.sap.log.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",J,false);if(this.getPickerPopup()){var O=this._getCalendarPicker();O.setMaxDate(J);}else{var P=this.getAggregation("yearPicker");P._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};
h.prototype.onclick=function(J){if(J.isMarked("delayedMouseEvent")){return;}if(J.target.id==this.getId()+"-cancel"){this.onsapescape(J);}};
h.prototype.onmousedown=function(J){J.preventDefault();J.setMark("cancelAutoClose");};
h.prototype.onsapescape=function(J){if(this.getPickerPopup()){v.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:m.call(this);break;}}};
h.prototype.onsaptabnext=function(J){var K=this.getAggregation("header"),N,O;if(q.sap.containsOrEquals(this.getDomRef("content"),J.target)){q.sap.focus(K.getDomRef("B2"));if(!this._bPoupupMode){O=this.getAggregation("monthsRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){N=this.getAggregation("yearPicker");if(N.getDomRef()){q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}J.preventDefault();}};
h.prototype.onsaptabprevious=function(J){var K=this.getAggregation("header"),N,O;if(q.sap.containsOrEquals(this.getDomRef("content"),J.target)){if(this._bPoupupMode){q.sap.focus(K.getDomRef("B2"));J.preventDefault();}}else if(J.target.id==K.getId()+"-B2"){switch(this._iMode){case 0:N=this.getAggregation("monthsRow");N._oItemNavigation.focusItem(N._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){O=this.getAggregation("yearPicker");O._oItemNavigation.focusItem(O._oItemNavigation.getFocusedIndex());}break;}J.preventDefault();}};
h.prototype.onfocusin=function(J){if(J.target.id==this.getId()+"-end"){var K=this.getAggregation("header"),N,O;q.sap.focus(K.getDomRef("B2"));if(!this._bPoupupMode){N=this.getAggregation("monthsRow");q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){O=this.getAggregation("yearPicker");if(O.getDomRef()){q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
h.prototype.onsapfocusleave=function(J){var K,N;if(!J.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(J.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:K=this.getAggregation("monthsRow");q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){N=this.getAggregation("yearPicker");q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
h.prototype._handlePrevious=function(J){var K,N,S,O;switch(this._iMode){case 0:K=this._getFocusedDate();N=this._getMonths();S=new d(i.call(this));S.setMonth(S.getMonth()-N);K.setMonth(K.getMonth()-N);this._setFocusedDate(K);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){O=this.getAggregation("yearPicker");O.previousPage();p.call(this);}break;}};
h.prototype._handleNext=function(J){var K,N,S,O;switch(this._iMode){case 0:K=this._getFocusedDate();N=this._getMonths();S=new d(i.call(this));S.setMonth(S.getMonth()+N);K.setMonth(K.getMonth()+N);this._setFocusedDate(K);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){O=this.getAggregation("yearPicker");O.nextPage();p.call(this);}break;}};
h.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
h.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
h.prototype._getShowItemHeader=function(){var J=this.getMonths();if(J>this._iDaysMonthsHead){return true;}else{return false;}};
function _(S,J,K){var N=new d(this._oMaxDate);N.setDate(1);N.setMonth(N.getMonth()-this._getMonths()+1);if(N.isBefore(this._oMinDate)){N=new d(this._oMinDate);N.setMonth(N.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new d(this._oMinDate);}else if(S.isAfter(N)){S=N;}S.setDate(1);var O=S.toLocalJSDate();this.setProperty("startDate",O,true);this._oStartDate=S;var P=this.getAggregation("monthsRow");P.setStartDate(O);n.call(this);if(J){var Q=this._getFocusedDate().toLocalJSDate();if(!P.checkDateFocusable(Q)){this._setFocusedDate(S);P.setDate(O);}else{P.setDate(Q);}}if(!K){this.fireStartDateChange();}}
function i(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}
function j(N){var J=this._getFocusedDate();var K=this.getAggregation("monthsRow");if(!N){K.setDate(J.toLocalJSDate());}else{K.displayDate(J.toLocalJSDate());}n.call(this);}
function k(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=d.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new d();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new d(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new d(this._oMaxDate);}}
function l(){var J=this._getFocusedDate();var K=this.getAggregation("yearPicker");if(K.getDomRef()){K.$().css("display","");}else{var N=sap.ui.getCore().createRenderManager();var $=this.$("content");N.renderControl(K);N.flush($[0],false,true);N.destroy();}this._showOverlay();K.setDate(J.toLocalJSDate());if(this._iMode==0){var O=this.getAggregation("monthsRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}p.call(this);this._iMode=1;}
function m(N){this._iMode=0;var J=this.getAggregation("yearPicker");J.$().css("display","none");this._hideOverlay();if(!N){j.call(this);var K=this.getAggregation("monthsRow");q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function n(){r.call(this);o.call(this);}
function o(){var J=new d(i.call(this));var K=this._getMonths();var N=J.getYear();var O=this._oMaxDate.getYear();var P=this._oMinDate.getYear();var Q=J.getMonth();var S=this._oMaxDate.getMonth();var T=this._oMinDate.getMonth();var U=this.getAggregation("header");if(N<P||(N==P&&Q<=T)){U.setEnabledPrevious(false);}else{U.setEnabledPrevious(true);}J.setMonth(J.getMonth()+K-1);N=J.getYear();Q=J.getMonth();if(N>O||(N==O&&Q>=S)){U.setEnabledNext(false);}else{U.setEnabledNext(true);}}
function p(){var J=this.getAggregation("yearPicker");var K=J.getYears();var N=d.fromLocalJSDate(J.getFirstRenderedDate());N.setYear(N.getYear()+Math.floor(K/2));var O=this.getAggregation("header");var P=new d(this._oMaxDate);P.setYear(P.getYear()-Math.ceil(K/2));P.setMonth(11,31);var Q=new d(this._oMinDate);Q.setYear(Q.getYear()+Math.floor(K/2)+1);Q.setMonth(0,1);O.setEnabledNext(!N.isAfter(P));O.setEnabledPrevious(!N.isBefore(Q));}
function r(){var T;var S=i.call(this);var J=this._oYearFormat.format(S.toUTCJSDate(),true);var K=new d(S);K.setMonth(K.getMonth()+this._getMonths()-1);var N=this._oYearFormat.format(K.toUTCJSDate(),true);if(J!=N){var O=this._getLocaleData();var P=O.getIntervalPattern();T=P.replace(/\{0\}/,J).replace(/\{1\}/,N);}else{T=J;}var Q=this.getAggregation("header");Q.setTextButton2(T);}
function s(J,N){var K;var O=false;if(J.isBefore(this._oMinDate)){K=this._oMinDate;O=true;}else if(J.isAfter(this._oMaxDate)){K=this._oMaxDate;O=true;}else{K=J;}this._setFocusedDate(K);if(O||N){B.call(this,K);j.call(this,false);this.fireStartDateChange();}}
function t(J,S){if(!J){return;}var K=d.fromLocalJSDate(J);if(this._oFocusedDate&&this._oFocusedDate.isSame(K)){return;}var N=K.getYear();c._checkYearInValidRange(N);if(c._isOutside(K,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(K);if(this.getDomRef()&&this._iMode==0){j.call(this,S);}}
function u(J){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){l.call(this);}else{m.call(this);}}}
h.prototype._showCalendarPicker=function(){var J=this._getFocusedDate(true).toLocalJSDate();var K=this._getCalendarPicker();var S=new sap.ui.unified.DateRange({startDate:J});K.displayDate(J,false);K.removeAllSelectedDates();K.addSelectedDate(S);K.setMinDate(this.getMinDate());K.setMaxDate(this.getMaxDate());E.call(this,K);this._showOverlay();};
function v(N){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!N){j.call(this);var J=this.getAggregation("monthsRow");q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function w(J){this.fireSelect();}
function x(J){var K=d.fromLocalJSDate(J.getParameter("date"));var N=J.getParameter("notVisible");s.call(this,K,N);}
function y(J){var K=new d(this._getFocusedDate());var N=this._getCalendarPicker();var S=N.getSelectedDates()[0].getStartDate();var O=d.fromLocalJSDate(S);O.setMonth(K.getMonth());O.setDate(K.getDate());s.call(this,O,true);v.call(this);}
function z(J){var K=new d(this._getFocusedDate());var N=this.getAggregation("yearPicker");var O=d.fromLocalJSDate(N.getDate());O.setMonth(K.getMonth());O.setDate(K.getDate());K=O;s.call(this,K,true);m.call(this);}
function A(){this._sInvalidateContent=undefined;var J=this.getAggregation("monthsRow");J._bDateRangeChanged=true;J._bInvalidateSync=true;J.invalidate();J._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}
function B(J){var K=this.getAggregation("monthsRow");var S=i.call(this);var N=K._oItemNavigation.getFocusedIndex();S=new d(J);S.setMonth(S.getMonth()-N);_.call(this,S,false,true);}
function E(P){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(F,this);this._oPopup.onsapescape=function(N){this._oCalendar.onsapescape(N);};}this._oPopup.setContent(P);var J=this.getAggregation("header");var K=sap.ui.core.Popup.Dock;this._oPopup.open(0,K.CenterTop,K.CenterTop,J,null,"flipfit",true);}
function F(J){v.call(this);}
function G(J){p.call(this);}
var I=e.extend("CustomYearPicker",{renderer:R.extend(f)});
I.prototype._initializeHeader=function(){var J=new H(this.getId()+"--Head",{visibleButton1:false});J.attachEvent("pressPrevious",this._handlePrevious,this);J.attachEvent("pressNext",this._handleNext,this);J.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",J);};
I.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);var J=this.getAggregation("header");J.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");this._showYearPicker();};
I.prototype.onThemeChanged=function(){e.prototype.onThemeChanged.apply(this,arguments);var J=this.getAggregation("header");J.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");};
I.prototype._selectYear=function(){var J=this.getAggregation("yearPicker");var K=this.getSelectedDates()[0];if(!K){K=new sap.ui.unified.DateRange();}K.setStartDate(J.getDate());this.addSelectedDate(K);this.fireSelect();};
I.prototype.onsapescape=function(J){this.fireCancel();};
I.prototype._shouldFocusB2OnTabPrevious=function(J){return false;};
return h;});
sap.ui.predefine('sap/ui/unified/CalendarMonthIntervalRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var i=c.getId();var t=c.getTooltip_AsString();var m=c.getAggregation("monthsRow");r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");r.addClass("sapUiCalInt");r.addClass("sapUiCalMonthInt");if(c._getShowItemHeader()){r.addClass("sapUiCalIntHead");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}var w=c.getWidth();if(w&&w!=''){r.addStyle("width",w);r.writeStyles();}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+i+"-content\" class=\"sapUiCalContent\">");r.renderControl(m);r.write("</div>");r.write("<button id=\""+i+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+i+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarOneMonthInterval',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer','sap/ui/unified/calendar/OneMonthDatesRow','sap/ui/core/Renderer','sap/ui/unified/Calendar','sap/ui/unified/CalendarRenderer',"./CalendarOneMonthIntervalRenderer"],function(q,C,a,l,b,c,O,R,d,e,f){"use strict";
var g=b.extend("sap.ui.unified.CalendarOneMonthInterval",{});
g.prototype.init=function(){b.prototype.init.apply(this,arguments);this._bShowOneMonth=true;};
g.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new h(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",function(){var o=this._getCalendarPicker(),i=o._getFocusedDate(),n=C._getFirstDateOfMonth(i);this._setStartDate(n);this._adjustSelectedDate(n,false);this._oFocusDateOneMonth=n;this._closeCalendarPicker(true);this._focusDate(i,false,true);},this);o.attachEvent("cancel",function(E){var o=this._getCalendarPicker(),i=o._getFocusedDate();this._closeCalendarPicker(true);this._oFocusDateOneMonth=i;this._focusDate(i,true);},this);this.setAggregation("calendarPicker",o);}return o;};
g.prototype._createMonth=function(i){return new O(i);};
g.prototype._handleFocus=function(E){var o=!!E.getParameter("_outsideBorder"),D=E.getParameter("date"),i=a.fromLocalJSDate(D),j=a.fromLocalJSDate(this.getStartDate()),I=!C._isSameMonthAndYear(i,j),k,F,s;if(o||I){if(C._isLastDateInMonth(i)){this._oFocusDateOneMonth=i;}else{this._oFocusDateOneMonth=C._getFirstDateOfMonth(i);}k=i.isBefore(j)?-1:1;F=new a(this._getFocusedDate(),this.getPrimaryCalendarType());s=new a(this._getStartDate(),this.getPrimaryCalendarType());b.prototype._shiftStartFocusDates.call(this,F,s,k);}return b.prototype._handleFocus.apply(this,arguments);};
g.prototype._focusDateExtend=function(D,o,n){var i,L;if(!this._oFocusDateOneMonth){return b.prototype._focusDateExtend.apply(this,arguments);}i=this.getAggregation("month")[0];L=this._oFocusDateOneMonth.toLocalJSDate();this._setFocusedDate(this._oFocusDateOneMonth);i._bNoRangeCheck=true;i.setDate(L);i._bNoRangeCheck=false;this._oFocusDateOneMonth=null;return!n;};
g.prototype._setDisplayMode=function(m){this.getAggregation("month")[0].setMode(m);};
g.prototype._shiftStartFocusDates=function(s,F,D){var S=D,o=this.getAggregation("month")[0];if(S!==0){S=S>0?1:-1;}s.setMonth(s.getMonth()+S);F.setYear(s.getYear());F.setMonth(s.getMonth());F.setDate(s.getDate());this._setFocusedDate(F);this._setStartDate(s,true);o.selectDate(s.toLocalJSDate());};
g.prototype._adjustSelectedDate=function(D,u){var m=this.getAggregation("month")[0],s;s=u?C._getFirstDateOfMonth(D):D;if(m.getMode&&m.getMode()<2){this._selectDate(s);}};
g.prototype._selectDate=function(D){var m=this.getAggregation("month")[0],L=D.toLocalJSDate();this.removeAllSelectedDates();this.addSelectedDate(new sap.ui.unified.DateRange({startDate:L}));m.selectDate(L);this._bDateRangeChanged=undefined;};
g.prototype._dateMatchesVisibleRange=function(D){return C._isSameMonthAndYear(a.fromLocalJSDate(this.getStartDate()),a.fromLocalJSDate(D));};
var h=d.extend("CustomMonthPicker",{renderer:R.extend(e)});
h.prototype._initializeHeader=function(){var H=new sap.ui.unified.calendar.Header(this.getId()+"--Head",{visibleButton1:false});H.attachEvent("pressPrevious",this._handlePrevious,this);H.attachEvent("pressNext",this._handleNext,this);H.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",H);};
h.prototype._shouldFocusB2OnTabNext=function(E){return q.sap.containsOrEquals(this.getDomRef("content"),E.target);};
h.prototype.onAfterRendering=function(){this._showMonthPicker();};
h.prototype._selectYear=function(){var y=this.getAggregation("yearPicker");var F=this._getFocusedDate();F.setYear(y.getYear());this._focusDate(F,true);this._showMonthPicker();};
h.prototype._selectMonth=function(){var m=this.getAggregation("monthPicker");var s=this.getSelectedDates()[0];var F=this._getFocusedDate();F.setMonth(m.getMonth());if(!s){s=new sap.ui.unified.DateRange();}s.setStartDate(F.toLocalJSDate());this.addSelectedDate(s);this.fireSelect();};
h.prototype.onsapescape=function(E){this.fireCancel();};
return g;});
sap.ui.predefine('sap/ui/unified/CalendarOneMonthIntervalRenderer',['sap/ui/core/Renderer','./CalendarDateIntervalRenderer'],function(R,C){"use strict";var a=R.extend(C);
a.addAttributes=function(r,c){C.addAttributes.apply(this,arguments);r.addClass("sapUiCalOneMonthInt");};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var I=c.getId();var t=c.getTooltip_AsString();var m=c.getAggregation("month");var w=c.getWidth();r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");if(m.length>1){r.addClass("sapUiCalMulti");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}if(w){r.addClass("sapUiCalWidth");r.addStyle("width",w);r.writeStyles();}if(c._getSecondaryCalendarType()){r.addClass("sapUiCalSecType");}if(this.addAttributes){this.addAttributes(r,c);}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+I+"-content\" class=\"sapUiCalContent\">");for(var i=0;i<m.length;i++){var M=m[i];r.renderControl(M);}this.renderCalContentOverlay(r,c,I);if(!c._bNamesLengthChecked){var o=c.getAggregation("monthPicker");r.renderControl(o);}r.write("</div>");r.write("<button id=\""+I+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+I+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");this.renderCalContentAndArrowsOverlay(r,c,I);r.write("</div>");};
C.renderCalContentOverlay=function(r,c,i){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");};
C.renderCalContentAndArrowsOverlay=function(r,c,i){};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarRow',['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer"],function(q,C,D,L,a,U,l,I,b,R,c,d){"use strict";var e=l.CalendarDayType;var f=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var g=l.CalendarIntervalType;
var h=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:g.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:f.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"},_nonWorkingDates:{type:"sap.ui.unified.DateRange",multiple:true,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});
h.PCROW_FOREIGN_KEY_NAME="relatedToPCRowDateRange";h.AGGR_NONWORKING_DATES_NAME="_nonWorkingDates";
h.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};
h.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};
h.prototype.onBeforeRendering=function(){n.call(this);r.call(this);v.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};
h.prototype.onAfterRendering=function(){w.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};
h.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};
h.prototype.invalidate=function(O){if(O&&O instanceof sap.ui.unified.CalendarAppointment){var j=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){j=true;break;}}if(j){this._aVisibleAppointments=[];}}C.prototype.invalidate.apply(this,arguments);};
h.prototype.setStartDate=function(S){if(!S){S=new Date();}a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};
h.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};
h.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};
h.prototype.setGroupAppointmentsMode=function(i){this.setProperty("groupAppointmentsMode",i);this._aVisibleAppointments=[];return this;};
h.prototype.setAppointmentsReducedHeight=function(i){this.setProperty("appointmentsReducedHeight",i);this._aVisibleAppointments=[];return this;};
h.prototype._getAppointmentReducedHeight=function(i){var j=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!i.getText()){j=true;}return j;};
h.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){E.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var M;for(var i=0;i<V.length;i++){M=V[i].appointment;if(q.sap.containsOrEquals(M.getDomRef(),j.target)){k=true;M.focus();break;}}if(!k){M=this.getFocusedAppointment();if(M){M.focus();}}}};
h.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};
h.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){F.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};
h.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){F.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};
h.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};
h.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};
h.prototype.onsaphome=function(i){H.call(this,i);i.preventDefault();i.stopPropagation();};
h.prototype.onsapend=function(i){H.call(this,i);i.preventDefault();i.stopPropagation();};
h.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(q.sap.containsOrEquals(k.getDomRef(),j.target)){x.call(this,k,!j.ctrlKey);break;}}j.stopPropagation();j.preventDefault();};
h.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var M=false;for(k=0;k<j.length;k++){var N=j[k];if(!this._isOneMonthIntervalOnSmallSizes()&&q.sap.containsOrEquals(N,i.target)){M=true;break;}}if(M){J.call(this,k,i.target);}else{this.onsapselect(i);}};
h.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};
h.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");w.call(this);return this;};
h.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var S=this._getStartDate();var M=S.getTime();var O=this._oUTCEndDate;var P=O.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=P&&i.getTime()>=M){var Q=t.call(this,k,j,S,O,M,i);var T=0;if(this._bRTL){N.css("right",Q+"%");}else{N.css("left",Q+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(k){case g.Hour:T=60000;break;case g.Day:case g.Week:case g.OneMonth:T=1800000;break;default:T=-1;break;}if(T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,this.updateCurrentTimeVisualization);}}}else{N.css("display","none");}return this;};
h.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var M;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){M=k[i];break;}}if(!M){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){M=j[i];break;}}}return M;};
h.prototype.focusAppointment=function(i){if(!i||!(i instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){E.call(this,j);}else{i.focus();}return this;};
h.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var N;var P;var M;for(var i=0;i<k.length;i++){N=k[i];if(N.getStartDate()>j){if(i>0){P=k[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){M=P;}else{M=N;}this.focusAppointment(M);}return this;};
h.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};
h.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};
h.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=m.call(this);var W=j.getWeekendStart();var k=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((W<=k&&i>=W&&i<=k)||(W>k&&(i>=W||i<=k))){N.push(i);}}}else if(!q.isArray(N)){N=[];}return N;};
h.prototype._isOneMonthIntervalOnSmallSizes=function(){return this.getIntervalType()===g.OneMonth&&this.getIntervals()===1;};
h.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=K;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};
h.prototype._setCustomAppointmentsSorterCallback=function(S){this._fnCustomSortedAppointments=S;};
function _(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}
function m(){if(!this._oLocaleData){var i=_.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}
function n(){var S=this.getStartDate();var i;var j=this.getIntervals();var k=this.getIntervalType();this._oUTCStartDate=o.call(this,S);switch(k){case g.Hour:i=new U(this._oUTCStartDate.getTime());i.setUTCHours(i.getUTCHours()+j);this._iMinDelta=this._iHoursMinDelta;break;case g.Day:case g.Week:case g.OneMonth:i=new U(this._oUTCStartDate.getTime());i.setUTCDate(i.getUTCDate()+j);this._iMinDelta=this._iDaysMinDelta;break;case g.Month:i=new U(this._oUTCStartDate.getTime());i.setUTCMonth(i.getUTCMonth()+j);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}i.setUTCMilliseconds(-1);this._iRowSize=i.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/j);this._oUTCEndDate=i;}
function o(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case g.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case g.Day:case g.Week:case g.OneMonth:k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case g.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}
function p(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}
function r(){var O=this._aVisibleAppointments||[];var M=this._getAppointmentsSorted();var N;var P;var Q;var S=this.getIntervals();var T=this.getIntervalType();var V=this._getStartDate();var W=V.getTime();var X=this._oUTCEndDate;var Y=X.getTime();var Z=[];var $=false;var i=0;var j=0;var a1=p.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<M.length;i++){N=M[i];var b1=a._createUniversalUTCDate(N.getStartDate(),undefined,true);b1.setUTCSeconds(0);b1.setUTCMilliseconds(0);var c1=N.getEndDate()?a._createUniversalUTCDate(N.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);c1.setUTCSeconds(0);c1.setUTCMilliseconds(0);var d1=false;if(b1.getTime()<W&&c1.getTime()>=W){b1=new U(W);d1=true;}if(c1.getTime()>Y&&b1.getTime()<=Y){c1=new U(Y);d1=true;}var e1=b1.getUTCHours()*60+b1.getUTCMinutes();b1.setUTCMinutes(b1.getUTCMinutes()-(e1%this._iMinDelta));var f1=(c1.getTime()-b1.getTime())/60000;if(d1&&f1==0){continue;}var g1=0;var h1=0;var i1=-1;P=undefined;Q=undefined;if(b1&&b1.getTime()<=Y&&c1&&c1.getTime()>=W){if(a1&&(T==g.Month)&&((c1.getTime()-b1.getTime())<604800000)){P=s.call(this,b1,N,T,S,V,X,W,Z);var j1=a._createUniversalUTCDate(P.getEndDate(),undefined,true);if(c1.getTime()>j1.getTime()){Q=s.call(this,c1,N,T,S,V,X,W,Z);}}g1=t.call(this,T,S,V,X,W,b1);h1=u.call(this,T,S,V,X,W,c1);for(j=0;j<O.length;j++){var k1=O[j];if(N==k1.appointment){i1=k1.level;}}if(P){P._iBegin=g1;P._iEnd=h1;P._iLevel=i1;if(Q){Q._iBegin=g1;Q._iEnd=h1;Q._iLevel=i1;}continue;}Z.push({appointment:N,begin:g1,end:h1,calculatedEnd:h1,level:i1});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==N.getId()){$=true;}}}var l1=this.getAggregation("groupAppointments",[]);if(l1.length>0){for(i=0;i<Z.length;i++){N=Z[i];if(N.appointment._aAppointments&&N.appointment._aAppointments.length<=1){P=N.appointment;var m1=false;if(P._aAppointments.length==0){m1=true;}else{for(j=0;j<Z.length;j++){if(Z[j].appointment==P._aAppointments[0]){m1=true;break;}}}if(!m1){for(j=0;j<l1.length;j++){Q=l1[j];if(P!=Q){for(var k=0;k<Q._aAppointments.length;k++){if(P._aAppointments[0]==Q._aAppointments[k]){Q._aAppointments.splice(k,1);if(Q._aAppointments.length==1){this.removeAggregation("groupAppointments",Q);Q.destroy();l1=this.getAggregation("groupAppointments",[]);}else{Q.setProperty("title",Q._aAppointments.length,true);}break;}}}}N.begin=P._iBegin;N.end=P._iEnd;N.calculatedEnd=P._iEnd;N.level=P._iLevel;N.appointment=P._aAppointments[0];}else{Z.splice(i,1);i--;}this.removeAggregation("groupAppointments",P);P.destroy();l1=this.getAggregation("groupAppointments",[]);}}}if(!$){if(Z.length>0){this._sFocusedAppointmentId=Z[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=Z;return this._aVisibleAppointments;}
function s(i,k,M,N,S,O,P,V){var Q=this.getAggregation("groupAppointments",[]);var T;var W=m.call(this);var X=W.getFirstDayOfWeek();var Y=i.getUTCDay();var Z=new U(i.getTime());Z.setUTCHours(0);Z.setUTCMinutes(0);Z.setUTCSeconds(0);Z.setUTCMilliseconds(0);if(X<=Y){Z.setDate(Z.getDate()-(Y-X));}else{Z.setDate(Z.getDate()-(7-Y-X));}for(var j=0;j<Q.length;j++){T=Q[j];var $=a._createUniversalUTCDate(T.getStartDate(),undefined,true);if($.getTime()==Z.getTime()){break;}T=undefined;}if(!T){var a1=new U(Z.getTime());a1.setDate(a1.getDate()+7);a1.setMilliseconds(-1);T=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+Q.length,{type:k.getType(),startDate:a._createLocalDate(new Date(Z.getTime()),true),endDate:a._createLocalDate(new Date(a1.getTime()),true)});T._aAppointments=[];this.addAggregation("groupAppointments",T,true);var b1=t.call(this,M,N,S,O,P,Z);var c1=u.call(this,M,N,S,O,P,a1);V.push({appointment:T,begin:b1,end:c1,calculatedEnd:c1,level:-1});}T._aAppointments.push(k);if(T.getType()!=e.None&&T.getType()!=k.getType()){T.setType(e.None);}T.setProperty("title",T._aAppointments.length,true);return T;}
function t(i,j,S,k,M,N){var O=0;if(i!=g.Month){O=100*(N.getTime()-M)/this._iRowSize;}else{var P=new U(N.getTime());P.setUTCDate(1);P.setUTCHours(0);P.setUTCMinutes(0);P.setUTCSeconds(0);P.setUTCMilliseconds(0);var Q=new U(P.getTime());Q.setUTCMonth(Q.getUTCMonth()+1);Q.setMilliseconds(-1);var T=Q.getTime()-P.getTime();var V=(P.getUTCFullYear()-S.getUTCFullYear())*12+P.getUTCMonth()-S.getUTCMonth();O=(100*V/j)+(100*(N.getTime()-P.getTime())/T)/j;}if(O<0){O=0;}O=Math.round(O*100000)/100000;return O;}
function u(i,j,S,k,M,N){var O=0;if(i!=g.Month){O=100-(100*(N.getTime()-M)/this._iRowSize);}else{var P=new U(N.getTime());P.setUTCDate(1);P.setUTCHours(0);P.setUTCMinutes(0);P.setUTCSeconds(0);P.setUTCMilliseconds(0);var Q=new U(P.getTime());Q.setUTCMonth(Q.getUTCMonth()+1);Q.setMilliseconds(-1);var T=Q.getTime()-P.getTime();var V=(P.getUTCFullYear()-S.getUTCFullYear())*12+P.getUTCMonth()-S.getUTCMonth();O=100-((100*V/j)+(100*(N.getTime()-P.getTime())/T)/j);}if(O<0){O=0;}O=Math.round(O*100000)/100000;return O;}
function v(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var M;var N=this.getIntervals();var O=this.getIntervalType();var S=this._getStartDate();var P=S.getTime();var Q=this._oUTCEndDate;var T=Q.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){M=k[i];var W=a._createUniversalUTCDate(M.getStartDate(),undefined,true);W.setUTCSeconds(0);W.setUTCMilliseconds(0);var X=M.getEndDate()?a._createUniversalUTCDate(M.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);X.setUTCSeconds(0);X.setUTCMilliseconds(0);if(W&&W.getTime()<=T&&X&&X.getTime()>=P){var Y=new U(S.getTime());var Z=new U(S.getTime());Z.setUTCMinutes(Z.getUTCMinutes()-1);var $=-1;var a1=-1;for(j=0;j<N;j++){switch(O){case g.Hour:Z.setUTCHours(Z.getUTCHours()+1);if(j>0){Y.setUTCHours(Y.getUTCHours()+1);}break;case g.Day:case g.Week:case g.OneMonth:Z.setUTCDate(Z.getUTCDate()+1);if(j>0){Y.setUTCDate(Y.getUTCDate()+1);}break;case g.Month:Z.setUTCDate(1);Z.setUTCMonth(Z.getUTCMonth()+2);Z.setUTCDate(0);if(j>0){Y.setUTCMonth(Y.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+O+"; "+this);}if(W&&W.getTime()<=Y.getTime()&&X&&X.getTime()>=Z.getTime()){if($<0){$=j;}a1=j;}}if($>=0){V.push({interval:$,appointment:M,last:a1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}
function w(){if(this._isOneMonthIntervalOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var M=this.$("DummyApp");var N=M.outerHeight(true);if(N<=0){return;}var O=M.outerWidth();var P=O/k*100;var Q=Math.ceil(1000*P)/1000;var S;var T;var V=0;var W=0;var i=0;var X=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){V=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){S=this._aVisibleAppointments[i];T=S.appointment.$();var Y=Math.floor(1000*(100-S.calculatedEnd-S.begin))/1000;var Z=false;if(Y<Q){S.end=100-S.begin-P;if(S.end<0){S.end=0;}S.level=-1;Z=true;T.addClass("sapUiCalendarAppSmall");}else if(T.hasClass("sapUiCalendarAppSmall")){S.end=S.calculatedEnd;Z=true;T.removeClass("sapUiCalendarAppSmall");}if(Z){if(this._bRTL){T.css("left",S.end+"%");}else{T.css("right",S.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){S=this._aVisibleAppointments[i];T=S.appointment.$();var a1={};var b1=X&&!this._getAppointmentReducedHeight(S.appointment);if(S.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var c1=this._aVisibleAppointments[j];if(S!=c1&&S.begin<(Math.floor(1000*(100-c1.end))/1000)&&(Math.floor(1000*(100-S.end))/1000)>c1.begin&&c1.level>=0){if(a1[c1.level]){a1[c1.level]++;}else{a1[c1.level]=1;}if(X&&!this._getAppointmentReducedHeight(c1.appointment)){if(a1[c1.level+1]){a1[c1.level+1]++;}else{a1[c1.level+1]=1;}}}}S.level=0;while(a1[S.level]||(b1&&a1[S.level+1])){S.level++;}T.attr("data-sap-level",S.level);}T.css("top",(N*S.level+V)+"px");var d1=S.level;if(b1){d1++;}if(W<d1){W=d1;}}W++;N=N*W+V;if(!this.getHeight()){$.outerHeight(N);}else{var e1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<e1.length;i++){var f1=q(e1[i]);f1.outerHeight(N);}}M.css("display","none");}
function x(j,k){var i=0;var O;var M;var N;var P;var S=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");if(k){var Q=this.getAppointments();var T=this.getAggregation("groupAppointments",[]);q.merge(Q,T);for(i=0;i<Q.length;i++){O=Q[i];if(O.getId()!==j.getId()&&O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==O.getId()){this.aSelectedAppointments.splice(i);}}M=O.$().attr("aria-labelledby");N=M?M.replace(S,""):"";O.$().attr("aria-labelledby",N);}}}if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");this.aSelectedAppointments=this.aSelectedAppointments.filter(function(V){return V!==j.getId();});A(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");A(this,k);this.aSelectedAppointments.push(j.getId());}P=j.$().attr("aria-labelledby")+" "+S;j.$().attr("aria-labelledby",P);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){O=j._aAppointments[i];O.setProperty("selected",true,true);P=O.$().attr("aria-labelledby")+" "+S;O.$().attr("aria-labelledby",P);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}
function y(i){var P=z.call(this);if(P){P["_onRow"+i]();}}
function z(){var P=this;while(P.getParent()!==null){if(P.getMetadata().getName()==="sap.m.PlanningCalendar"){return P;}P=P.getParent();}}
function A(i,j){if(j){y.call(i,"DeselectAppointment");}}
function B(k){var M=this.getAggregation("groupAppointments",[]);var N;var O=false;for(var i=0;i<M.length;i++){var P=M[i]._aAppointments;for(var j=0;j<P.length;j++){if(P[j].getId()==k){N=M[i];O=true;break;}}if(O){break;}}return N;}
function E(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var M;var i=0;M=B.call(this,j);if(M){j=M.getId();M=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){M=V[i].appointment;break;}}if(M){var O=this.getFocusedAppointment().$();var $=M.$();this._sFocusedAppointmentId=M.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){M=k[i];break;}}if(M){this._sFocusedAppointmentId=M.getId();var N=o.call(this,M.getStartDate());this.setStartDate(a._createLocalDate(N,true));if(!q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){q.sap.delayedCall(0,this,function(){this.getFocusedAppointment().focus();});}this.fireStartDateChange();}}}}
function F(j,S){var k=this._sFocusedAppointmentId;var M=this._getAppointmentsSorted();var N=this.getAggregation("groupAppointments",[]);var O;var P=0;var i=0;for(i=0;i<N.length;i++){if(N[i].getId()==k){var Q=N[i]._aAppointments;if(j){k=Q[Q.length-1].getId();}else{k=Q[0].getId();}break;}}for(i=0;i<M.length;i++){if(M[i].getId()==k){P=i;break;}}if(j){P=P+S;}else{P=P-S;}if(P<0){P=0;}else if(P>=M.length){P=M.length-1;}O=M[P];E.call(this,O.getId());}
function H(j){var k=this._getAppointmentsSorted();var M;var S=new U(this._getStartDate());var N=new U(this._oUTCEndDate);var O=this.getIntervalType();var P;var Q;S.setUTCHours(0);N.setUTCHours(0);N.setUTCMinutes(0);N.setUTCSeconds(0);switch(O){case g.Hour:N.setUTCDate(N.getUTCDate()+1);N.setUTCMilliseconds(-1);break;case g.Day:case g.Week:case g.OneMonth:S.setUTCDate(1);N.setUTCMonth(N.getUTCMonth()+1);N.setUTCDate(1);N.setUTCMilliseconds(-1);break;case g.Month:S.setUTCMonth(0);S.setUTCDate(1);N.setUTCFullYear(N.getUTCFullYear()+1);N.setUTCMonth(1);N.setUTCDate(1);N.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+O+"; "+this);}var T=a._createLocalDate(S,true);var V=a._createLocalDate(N,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=T&&k[i].getStartDate()<=V){M=k[i];P=M.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>V){break;}}Q=B.call(this,P);if(Q){M=Q;P=M.getId();}if(P&&P!=this._sFocusedAppointmentId){E.call(this,P);}else if(j._bPlanningCalendar&&M){M.focus();}else{this.fireLeaveRow({type:j.type});}}
function J(i,j){var k=this.getIntervalType();var S=this._getStartDate();var M=new U(S.getTime());var N;var O=false;var P=0;var Q=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){O=true;var T=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");Q=T.length;for(P=0;P<Q;P++){var V=T[P];if(V==j){break;}}}switch(k){case g.Hour:M.setUTCHours(M.getUTCHours()+i);if(O){M.setUTCMinutes(M.getUTCMinutes()+P*60/Q);N=new U(M.getTime());N.setUTCMinutes(N.getUTCMinutes()+60/Q);}else{N=new U(M.getTime());N.setUTCHours(N.getUTCHours()+1);}break;case g.Day:case g.Week:case g.OneMonth:M.setUTCDate(M.getUTCDate()+i);if(O){M.setUTCHours(M.getUTCHours()+P*24/Q);N=new U(M.getTime());N.setUTCHours(N.getUTCHours()+24/Q);}else{N=new U(M.getTime());N.setUTCDate(N.getUTCDate()+1);}break;case g.Month:M.setUTCMonth(M.getUTCMonth()+i);if(O){M.setUTCDate(M.getUTCDate()+P);N=new U(M.getTime());N.setUTCDate(N.getUTCDate()+1);}else{N=new U(M.getTime());N.setUTCMonth(N.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}N.setUTCMilliseconds(N.getUTCMilliseconds()-1);M=a._createLocalDate(M,true);N=a._createLocalDate(N,true);this.fireIntervalSelect({startDate:M,endDate:N,subInterval:O});}
function K(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}
return h;});
sap.ui.predefine('sap/ui/unified/CalendarRowRenderer',['jquery.sap.global','sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarLegendRenderer','sap/ui/Device','sap/ui/unified/library','sap/ui/core/InvisibleText'],function(q,U,C,a,D,l,I){"use strict";var b=l.CalendarDayType;var c=l.CalendarIntervalType;var d=l.CalendarAppointmentVisualization;var e={};
e.render=function(r,R){var t=R.getTooltip_AsString();var v=R.getAppointmentsVisualization();var T=this.getLegendItems(R);r.write("<div");r.writeControlData(R);r.addClass("sapUiCalendarRow");if(!D.system.phone&&R.getAppointmentsReducedHeight()){r.addClass("sapUiCalendarRowAppsRedHeight");}if(v!=d.Standard){r.addClass("sapUiCalendarRowVis"+v);}if(t){r.writeAttributeEscaped("title",t);}var w=R.getWidth();if(w){r.addStyle("width",w);}var h=R.getHeight();if(h){r.addStyle("height",h);}r.writeAccessibilityState(R);r.writeClasses();r.writeStyles();r.write(">");this.renderAppointmentsRow(r,R,T);r.write("</div>");};
e.renderAppointmentsRow=function(r,R,t){var i=R.getId();r.write("<div id=\""+i+"-Apps\" class=\"sapUiCalendarRowApps\">");this.renderBeforeAppointments(r,R);this.renderAppointments(r,R,t);this.renderAfterAppointments(r,R);r.write("</div>");};
e.renderBeforeAppointments=function(r,R){};
e.renderAfterAppointments=function(r,R){};
e.renderAppointments=function(r,R,t){var A=R._getVisibleAppointments();var f=R._getVisibleIntervalHeaders();var s=R._getStartDate();var n=[];var N=[];var S=0;var g=0;var h=[];var j=0;var k=0;var m=R.getIntervals();var o=R.getIntervalType();var w=100/m;var i=0;var p=new U(s);var F=false;var L=false;switch(o){case c.Hour:n=R.getNonWorkingHours()||[];S=s.getUTCHours();g=24;break;case c.Day:case c.Week:case c.OneMonth:n=R._getNonWorkingDays();N=R.getAggregation("_nonWorkingDates");S=s.getUTCDay();g=7;h=R.getNonWorkingHours()||[];j=s.getUTCHours();k=24;break;case c.Month:h=R._getNonWorkingDays();j=s.getUTCDay();k=7;break;default:break;}if(R._isOneMonthIntervalOnSmallSizes()){this.renderSingleDayInterval(r,R,A,t,f,n,S,g,h,j,k,true,true);}else{for(i=0;i<m;i++){if(L){F=true;}else{F=false;}L=false;switch(o){case c.Hour:p.setUTCHours(p.getUTCHours()+1);if(p.getUTCHours()==0){L=true;}break;case c.Day:case c.Week:case c.OneMonth:p.setUTCDate(p.getUTCDate()+1);if(p.getUTCDate()==1){L=true;}break;case c.Month:p.setUTCMonth(p.getUTCMonth()+1);if(p.getUTCMonth()==0){L=true;}break;default:break;}this.renderInterval(r,R,i,w,f,n,N,S,g,h,j,k,F,L);}this.renderIntervalHeaders(r,R,w,f,m);r.write("<div id=\""+R.getId()+"-Now\" class=\"sapUiCalendarRowNow\"></div>");for(i=0;i<A.length;i++){var u=A[i];this.renderAppointment(r,R,u,t);}r.write("<div id=\""+R.getId()+"-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\"></div>");}};
e.renderInterval=function(r,R,f,w,g,n,N,s,h,k,S,m,F,L){var o=R.getId()+"-AppsInt"+f;var i;var p=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||g.length>0);var M=R.getStartDate().getMonth();var t=new Date(R.getStartDate().getFullYear(),M+1,0).getDate();var u=R.getStartDate();var v;var x;var y;r.write("<div id=\""+o+"\"");r.addClass("sapUiCalendarRowAppsInt");r.addStyle("width",w+"%");if(f>=t&&R.getIntervalType()===c.OneMonth){r.addClass("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((f+s)%h==n[i]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}if(N&&N.length){v=new Date(u.getTime());v.setHours(0,0,0);v.setDate(u.getDate()+f);var z=function(K){return K===v.getDay();};for(i=0;i<N.length;i++){if(N[i].getStartDate()){x=new Date(N[i].getStartDate().getTime());}if(N[i].getEndDate()){y=new Date(N[i].getEndDate().getTime());}else{y=new Date(N[i].getStartDate().getTime());y.setHours(23,59,59);}if(v.getTime()>=x.getTime()&&v.getTime()<=y.getTime()){var A=n.some(z);if(!A){r.addClass("sapUiCalendarRowAppsNoWork");}}}}if(!p){r.addClass("sapUiCalendarRowAppsIntNoHead");}if(F){r.addClass("sapUiCalendarRowAppsIntFirst");}if(L){r.addClass("sapUiCalendarRowAppsIntLast");}r.writeClasses();r.writeStyles();r.write(">");if(p){r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");r.writeClasses();r.write(">");r.write("</div>");}if(R.getShowSubIntervals()){var B=R.getIntervalType();var E=0;switch(B){case c.Hour:E=4;break;case c.Day:case c.Week:case c.OneMonth:E=24;break;case c.Month:var G=R._getStartDate();var H=new U(G);H.setUTCMonth(H.getUTCMonth()+f+1,0);E=H.getUTCDate();H.setUTCDate(1);s=H.getUTCDay();break;default:break;}var J=100/E;for(i=0;i<E;i++){r.write("<div");r.addClass("sapUiCalendarRowAppsSubInt");r.addStyle("width",J+"%");for(var j=0;j<k.length;j++){if((i+S)%m==k[j]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}r.writeStyles();r.writeClasses();r.write(">");r.write("</div>");}}r.write("</div>");};
e.renderIntervalHeaders=function(r,R,w,f,g){var s=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||f.length>0);if(s){for(var i=0;i<f.length;i++){var o=f[i],L,h;if(R._bRTL){h=w*o.interval;L=w*(g-o.last-1);}else{L=w*o.interval;h=w*(g-o.last-1);}this.renderIntervalHeader(r,o,R._bRTL,L,h);}}};
e.renderIntervalHeader=function(r,i,R,f,g){var s=i.appointment.getId();r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");if(f!==undefined){r.addStyle("left",f+"%");}if(g!==undefined){r.addStyle("right",g+"%");}r.writeElementData(i.appointment);r.addClass("sapUiCalendarRowAppsIntHeadFirst");if(i.appointment.getSelected()){r.addClass("sapUiCalendarRowAppsIntHeadSel");}if(i.appointment.getTentative()){r.addClass("sapUiCalendarRowAppsIntHeadTent");}var t=i.appointment.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}var T=i.appointment.getType();var h=i.appointment.getColor();if(!h&&T&&T!=b.None){r.addClass("sapUiCalendarRowAppsIntHead"+T);}if(h){if(R){r.addStyle("border-right-color",h);}else{r.addStyle("border-left-color",h);}}r.writeStyles();r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiCalendarIntervalHeaderCont");r.writeClasses();if(h){r.addStyle("background-color",i.appointment._getCSSColorForBackground(h));r.writeStyles();}r.write(">");var j=i.appointment.getIcon();if(j){var k=["sapUiCalendarRowAppsIntHeadIcon"];var A={};A["id"]=s+"-Icon";A["title"]=null;r.writeIcon(j,k,A);}var m=i.appointment.getTitle();if(m){r.write("<span");r.writeAttribute("id",s+"-Title");r.addClass("sapUiCalendarRowAppsIntHeadTitle");r.writeClasses();r.write(">");r.writeEscaped(m,true);r.write("</span>");}var n=i.appointment.getText();if(n){r.write("<span");r.writeAttribute("id",s+"-Text");r.addClass("sapUiCalendarRowAppsIntHeadText");r.writeClasses();r.write(">");r.writeEscaped(n,true);r.write("</span>");}r.write("</div>");r.write("</div>");};
e.renderAppointment=function(r,R,A,t,f){var o=A.appointment;var T=o.getTooltip_AsString();var s=o.getType();var g=o.getColor();var h=o.getTitle();var i=o.getText();var j=o.getIcon();var k=o.getId();var m={labelledby:{value:I.getStaticId("sap.ui.unified","APPOINTMENT")+" "+k+"-Descr",append:true}};var n=R.getAriaLabelledBy();if(n.length>0){m["labelledby"].value=m["labelledby"].value+" "+n.join(" ");}if(h){m["labelledby"].value=m["labelledby"].value+" "+k+"-Title";}if(i){m["labelledby"].value=m["labelledby"].value+" "+k+"-Text";}r.write("<div");r.writeElementData(o);r.addClass("sapUiCalendarApp");if(o.getSelected()){r.addClass("sapUiCalendarAppSel");m["labelledby"].value=m["labelledby"].value+" "+I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");}if(o.getTentative()){r.addClass("sapUiCalendarAppTent");m["labelledby"].value=m["labelledby"].value+" "+I.getStaticId("sap.ui.unified","APPOINTMENT_TENTATIVE");}if(!i){r.addClass("sapUiCalendarAppTitleOnly");}if(j){r.addClass("sapUiCalendarAppWithIcon");}if(!f){if(R._bRTL){r.addStyle("right",A.begin+"%");r.addStyle("left",A.end+"%");}else{r.addStyle("left",A.begin+"%");r.addStyle("right",A.end+"%");}}r.writeAttribute("data-sap-level",A.level);if(R._sFocusedAppointmentId==k){r.writeAttribute("tabindex","0");}else{r.writeAttribute("tabindex","-1");}if(T){r.writeAttributeEscaped("title",T);}if(!g&&s&&s!=b.None){r.addClass("sapUiCalendarApp"+s);}if(g){if(R._bRTL){r.addStyle("border-right-color",g);}else{r.addStyle("border-left-color",g);}}r.writeAccessibilityState(o,m);r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapUiCalendarAppCont");if(g&&R.getAppointmentsVisualization()===d.Filled){r.addStyle("background-color",o._getCSSColorForBackground(g));r.writeStyles();}r.writeClasses();r.write(">");if(j){var p=["sapUiCalendarAppIcon"];var u={};u["id"]=k+"-Icon";u["title"]=null;r.writeIcon(j,p,u);}if(h){r.write("<span");r.writeAttribute("id",k+"-Title");r.addClass("sapUiCalendarAppTitle");r.writeClasses();r.write(">");r.writeEscaped(h,true);r.write("</span>");}if(i){r.write("<span");r.writeAttribute("id",k+"-Text");r.addClass("sapUiCalendarAppText");r.writeClasses();r.write(">");r.writeEscaped(i,true);r.write("</span>");}var v=R._oRb.getText("CALENDAR_START_TIME")+": "+R._oFormatAria.format(o.getStartDate());v=v+"; "+R._oRb.getText("CALENDAR_END_TIME")+": "+R._oFormatAria.format(o.getEndDate());if(T){v=v+"; "+T;}if(s&&s!=b.None){v=v+"; "+this.getAriaTextForType(s,t);}r.write("<span id=\""+k+"-Descr\" class=\"sapUiInvisibleText\">"+v+"</span>");r.write("</div>");r.write("</div>");};
e.renderSingleDayInterval=function(r,R,A,t,f,n,s,N,g,S,h,F,L){var k=1,w=100,m=R.getId()+"-AppsInt"+k,i,o=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||f.length>0),p=R.getStartDate(),M=p.getMonth(),u=new Date(p.getFullYear(),M+1,0).getDate(),v,x=A.concat(R.getIntervalHeaders().filter(function(H){var J=H.getStartDate().getTime(),K=H.getStartDate().getTime(),O=p.getTime(),P=O+1000*60*60*24;return(J>=O&&J<P)||(K>=O&&K<P);}).map(function(H){return{appointment:H,isHeader:true};})).sort(C._getComparer(p)),y;r.write("<div id=\""+m+"\"");r.addClass("sapUiCalendarRowAppsInt");r.addClass("sapUiCalendarMonthRowAppsS");r.addStyle("width",w+"%");if(k>=u&&R.getIntervalType()===c.OneMonth){r.addClass("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((k+s)%N==n[i]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}if(!o){r.addClass("sapUiCalendarRowAppsIntNoHead");}if(F){r.addClass("sapUiCalendarRowAppsIntFirst");}if(L){r.addClass("sapUiCalendarRowAppsIntLast");}r.writeClasses();r.writeStyles();r.write(">");if(o){r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");r.writeClasses();r.write(">");r.write("</div>");}for(i=0;i<x.length;i++){y=x[i];r.write("<div class=\"sapUiCalendarAppContainer\">");r.write("<div class=\"sapUiCalendarAppContainerLeft\">");r.write("<div>"+y.appointment._getDateRangeIntersectionText(p)+"</div>");r.write("</div>");r.write("<div class=\"sapUiCalendarAppContainerRight\">");if(y.isHeader){this.renderIntervalHeader(r,y);}else{this.renderAppointment(r,R,y,t,true);}r.write("</div>");r.write("</div>");}if(A.length===0){r.write("<div class=\"sapUiCalendarNoApps\">");v=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PLANNINGCALENDAR_ROW_NO_APPOINTMENTS");r.write(v);r.write("</div>");}r.write("<div id=\""+R.getId()+"-Now\" class=\"sapUiCalendarRowNow\"></div>");r.write("<div id=\""+R.getId()+"-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\" style='margin:0; height:0px;'></div>");if(R.getShowSubIntervals()){var z=R.getIntervalType();var B=0;switch(z){case c.Hour:B=4;break;case c.Day:case c.Week:case c.OneMonth:B=24;break;case c.Month:var E=new U(p);E.setUTCMonth(E.getUTCMonth()+k+1,0);B=E.getUTCDate();E.setUTCDate(1);s=E.getUTCDay();break;default:break;}var G=100/B;for(i=0;i<B;i++){r.write("<div");r.addClass("sapUiCalendarRowAppsSubInt");r.addStyle("width",G+"%");for(var j=0;j<g.length;j++){if((i+S)%h==g[j]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}r.writeStyles();r.writeClasses();r.write(">");r.write("</div>");}}r.write("</div>");};
e.getLegendItems=function(o){var r=[],L,s=o.getLegend();if(s){L=sap.ui.getCore().byId(s);if(L){r=L.getItems();}else{q.sap.log.error("CalendarLegend with id '"+s+"' does not exist!",o);}}return r;};
e.getAriaTextForType=function(t,L){var T,s,o,i;if(L&&L.length){for(var i=0;i<L.length;i++){o=L[i];if(o.getType()===t){T=o.getText();break;}}}if(!T){s=a.getTypeAriaText(t);if(s){T=s.getText();}}return T;};
return e;},true);
sap.ui.predefine('sap/ui/unified/CalendarTimeInterval',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library','sap/ui/core/format/DateFormat','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/library',"./CalendarTimeIntervalRenderer"],function(q,C,L,a,H,T,D,M,Y,U,l,b,c,d,e,f){"use strict";var g=e.CalendarType;
var h=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
h.prototype.init=function(){this._iMode=0;this._oYearFormat=b.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initilizeMonthPicker();this._initilizeYearPicker();this.setPickerPopup(false);this._iItemsHead=15;};
h.prototype._initializeHeader=function(){var $=new H(this.getId()+"--Head");$.attachEvent("pressPrevious",this._handlePrevious,this);$.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",$);};
h.prototype._initializeTimesRow=function(){var $=new T(this.getId()+"--TimesRow");$.attachEvent("focus",G,this);$.attachEvent("select",F,this);$._bNoThemeChange=true;this.setAggregation("timesRow",$);};
h.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};
h.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
h.prototype._createDatesRow=function(){var $=new D(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});$.attachEvent("focus",K,this);$.attachEvent("select",J,this);$._bNoThemeChange=true;$.getIntervalSelection=function(){return this.getProperty("intervalSelection");};$.getSingleSelection=function(){return this.getProperty("singleSelection");};$.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};$.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};$.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return $;};
h.prototype._createMonthPicker=function(){var $=new M(this.getId()+"--MP",{columns:0,months:6});$.attachEvent("select",N,this);$._bNoThemeChange=true;$.attachEvent("pageChange",X,this);return $;};
h.prototype._createYearPicker=function(){var $=new Y(this.getId()+"--YP",{columns:0,years:6});$.attachEvent("select",O,this);$.attachEvent("pageChange",Z,this);$._oMinDate.setYear(this._oMinDate.getUTCFullYear());$._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return $;};
h.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};
h.prototype.onBeforeRendering=function(){var $=this.getAggregation("timesRow");var a1=this._getFocusedDate();u.call(this);$.displayDate(a._createLocalDate(a1,true));};
h.prototype._getCalendarPicker=function(){var $=this.getAggregation("calendarPicker");if(!$){$=new sap.ui.unified.Calendar(this.getId()+"--Cal",{});$.setPopupMode(true);$.attachEvent("select",I,this);$.attachEvent("cancel",function(a1){this._oPopup.close();},this);this.setAggregation("calendarPicker",$);}return $;};
h.prototype.setStartDate=function($){a._checkJSDateObject($);if(q.sap.equal(this.getStartDate(),$)){return this;}var a1=$.getFullYear();a._checkYearInValidRange(a1);var b1=this.getMinDate();if(b1&&$.getTime()<b1.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);$=new Date(b1);}var c1=this.getMaxDate();if(c1&&$.getTime()>c1.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);$=new Date(c1);}this.setProperty("startDate",$,true);var d1=this.getAggregation("timesRow");d1.setStartDate($);this._oUTCStartDate=new U(d1._getStartDate().getTime());u.call(this);var e1=a._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){this._setFocusedDate(this._oUTCStartDate);d1.displayDate($);}return this;};
h.prototype.invalidate=function($){if(!this._bDateRangeChanged&&(!$||!($ instanceof sap.ui.unified.DateRange))){if(!$||(!($ instanceof D||$ instanceof M||$ instanceof Y||$ instanceof H))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,P);}};
h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var $=this.removeAllAggregation("selectedDates");return $;};
h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var $=this.destroyAggregation("selectedDates");return $;};
h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var $=this.removeAllAggregation("specialDates");return $;};
h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var $=this.destroyAggregation("specialDates");return $;};
h.prototype.setIntervalMinutes=function($){if($>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%$>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",$,false);var a1=this.getAggregation("timesRow");var b1=a._createLocalDate(this._getFocusedDate(),true);if(!a1.checkDateFocusable(b1)){var c1=i.call(this);this._setFocusedDate(c1);a1.setDate(a._createLocalDate(c1,true));}return this;};
h.prototype.setLocale=function($){if(this._sLocale!=$){this._sLocale=$;this._oLocaleData=undefined;this.invalidate();}return this;};
h.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
h.prototype._getFocusedDate=function(){if(!this._oFocusedDate){k.call(this);}return this._oFocusedDate;};
h.prototype._setFocusedDate=function($){if(!($ instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U($.getTime());};
h.prototype.focusDate=function($){var a1=false;var b1=this.getAggregation("timesRow");if(!b1.checkDateFocusable($)){var c1=a._createUniversalUTCDate($,undefined,true);Q.call(this,c1);a1=true;}z.call(this,$,false);if(a1){this.fireStartDateChange();}return this;};
h.prototype.displayDate=function($){z.call(this,$,true);return this;};
h.prototype.setItems=function($){this.setProperty("items",$,true);$=this._getItems();var a1=this.getAggregation("timesRow");a1.setItems($);var b1=a._createLocalDate(this._getFocusedDate(),true);if(!a1.checkDateFocusable(b1)){var c1=i.call(this);this._setFocusedDate(c1);a1.setDate(a._createLocalDate(c1,true));}if(!this.getPickerPopup()){var d1=this.getAggregation("datesRow");var e1=Math.floor($*1.5);if(e1>31){e1=31;}d1.setDays(e1);var f1=this.getAggregation("monthPicker");var g1=Math.floor($/2);if(g1>12){g1=12;}f1.setMonths(g1);var h1=this.getAggregation("yearPicker");var i1=Math.floor($/2);if(i1>20){i1=20;}h1.setYears(i1);}u.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
h.prototype._getItems=function(){var $=this.getItems();if(c.system.phone&&$>6){return 6;}else{return $;}};
h.prototype._getLocaleData=function(){if(!this._oLocaleData){var $=this.getLocale();var a1=new d($);this._oLocaleData=L.getInstance(a1);}return this._oLocaleData;};
h.prototype.setPickerPopup=function($){var a1=this.getAggregation("header"),b1,c1,d1;this.setProperty("pickerPopup",$,true);if(b1){b1.destroy();}if($){a1.setVisibleButton0(false);a1.setVisibleButton1(true);a1.setVisibleButton2(false);a1.detachEvent("pressButton1",B,this);a1.attachEvent("pressButton1",B,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy();}if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{a1.setVisibleButton0(true);a1.setVisibleButton1(true);a1.setVisibleButton2(true);a1.detachEvent("pressButton0",A,this);a1.attachEvent("pressButton0",A,this);a1.detachEvent("pressButton1",B,this);a1.attachEvent("pressButton1",B,this);a1.detachEvent("pressButton2",E,this);a1.attachEvent("pressButton2",E,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}c1=this.getAggregation("monthPicker");d1=this.getAggregation("yearPicker");c1.setColumns(0);c1.setMonths(6);d1.setColumns(0);d1.setYears(6);}return this;};
h.prototype.setMinDate=function($){var a1,b1,c1,d1;if(q.sap.equal($,this.getMinDate())){return this;}if(!$){a._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{a._checkJSDateObject($);this._oMinDate=a._createUniversalUTCDate($,undefined,true);a1=this.getAggregation("timesRow");this._oMinDate=a1._getIntervalStart(this._oMinDate);b1=this._oMinDate.getUTCFullYear();a._checkYearInValidRange(b1);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=a._createUniversalUTCDate($,undefined,true);a._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",a._createLocalDate(this._oMaxDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("focused date < minDate -> minDate focused",this);this.focusDate($);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",$,false);if(this.getPickerPopup()){d1=this._getCalendarPicker();d1.setMinDate($);}else{c1=this.getAggregation("yearPicker");c1._oMinDate.setYear(this._oMinDate.getUTCFullYear());}return this;};
h.prototype.setMaxDate=function($){var a1,b1,c1,d1,e1,f1;if(q.sap.equal($,this.getMaxDate())){return this;}if(!$){a._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{a._checkJSDateObject($);this._oMaxDate=a._createUniversalUTCDate($,undefined,true);a1=this.getAggregation("timesRow");this._oMaxDate=a1._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);b1=this._oMaxDate.getUTCFullYear();a._checkYearInValidRange(b1);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=a._createUniversalUTCDate($,undefined,true);a._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",a._createLocalDate(this._oMinDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("focused date > maxDate -> maxDate focused",this);this.focusDate($);}}if(this._oUTCStartDate){c1=new U(this._oUTCStartDate.getTime());c1.setUTCMinutes(c1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(c1.getTime()>this._oMaxDate.getTime()){d1=new U(this._oMaxDate.getTime());d1.setUTCMinutes(d1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(d1.getTime()>=this._oMinDate.getTime()){q.sap.log.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,d1,true,true);}}}}this.setProperty("maxDate",$,false);if(this.getPickerPopup()){f1=this._getCalendarPicker();f1.setMaxDate($);}else{e1=this.getAggregation("yearPicker");e1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());}return this;};
h.prototype.onclick=function($){if($.isMarked("delayedMouseEvent")){return;}if($.target.id==this.getId()+"-cancel"){this.onsapescape($);}};
h.prototype.onmousedown=function($){$.preventDefault();$.setMark("cancelAutoClose");};
h.prototype.onsapescape=function($){if(this.getPickerPopup()){m.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:o.call(this);break;case 2:r.call(this);break;case 3:t.call(this);break;}}};
h.prototype.onsaptabnext=function($){var a1=this.getAggregation("header"),b1,c1,d1;if(q.sap.containsOrEquals(this.getDomRef("content"),$.target)){if(this.getPickerPopup()){q.sap.focus(a1.getDomRef("B1"));}else{q.sap.focus(a1.getDomRef("B0"));}if(!this._bPoupupMode){d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){b1=this.getAggregation("monthPicker");c1=this.getAggregation("yearPicker");if(b1.getDomRef()){q(b1._oItemNavigation.getItemDomRefs()[b1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(c1.getDomRef()){q(c1._oItemNavigation.getItemDomRefs()[c1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}$.preventDefault();}else if($.target.id==a1.getId()+"-B0"){q.sap.focus(a1.getDomRef("B1"));$.preventDefault();}else if(!this.getPickerPopup()&&($.target.id==a1.getId()+"-B1")){q.sap.focus(a1.getDomRef("B2"));$.preventDefault();}};
h.prototype.onsaptabprevious=function($){var a1=this.getAggregation("header"),b1,c1,d1;if(q.sap.containsOrEquals(this.getDomRef("content"),$.target)){if(this._bPoupupMode){q.sap.focus(a1.getDomRef("B2"));$.preventDefault();}}else if($.target.id==a1.getId()+"-B0"){d1=this.getAggregation("timesRow");switch(this._iMode){case 0:d1._oItemNavigation.focusItem(d1._oItemNavigation.getFocusedIndex());break;case 2:if(!this.getPickerPopup()){b1=this.getAggregation("monthPicker");b1._oItemNavigation.focusItem(b1._oItemNavigation.getFocusedIndex());}break;case 3:if(!this.getPickerPopup()){c1=this.getAggregation("yearPicker");c1._oItemNavigation.focusItem(c1._oItemNavigation.getFocusedIndex());}break;}$.preventDefault();}else if($.target.id==a1.getId()+"-B2"){q.sap.focus(a1.getDomRef("B1"));$.preventDefault();}else if($.target.id==a1.getId()+"-B1"){if(!this.getPickerPopup()){q.sap.focus(a1.getDomRef("B0"));}else{d1=this.getAggregation("timesRow");d1._oItemNavigation.focusItem(d1._oItemNavigation.getFocusedIndex());}$.preventDefault();}};
h.prototype.onfocusin=function($){if($.target.id==this.getId()+"-end"){var a1=this.getAggregation("header"),b1,c1,d1;if(this.getPickerPopup()){q.sap.focus(a1.getDomRef("B1"));}else{q.sap.focus(a1.getDomRef("B2"));}if(!this._bPoupupMode){b1=this.getAggregation("timesRow");q(b1._oItemNavigation.getItemDomRefs()[b1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){c1=this.getAggregation("monthPicker");d1=this.getAggregation("yearPicker");if(c1.getDomRef()){q(c1._oItemNavigation.getItemDomRefs()[c1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(d1.getDomRef()){q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
h.prototype.onsapfocusleave=function($){if(!$.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId($.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var a1,b1,c1;switch(this._iMode){case 0:a1=this.getAggregation("timesRow");q(a1._oItemNavigation.getItemDomRefs()[a1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:if(!this.getPickerPopup()){b1=this.getAggregation("monthPicker");q(b1._oItemNavigation.getItemDomRefs()[b1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 3:if(!this.getPickerPopup()){c1=this.getAggregation("yearPicker");q(c1._oItemNavigation.getItemDomRefs()[c1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
h.prototype._handlePrevious=function($){var a1=this._getFocusedDate(),b1,c1,d1,e1,f1,g1,h1,i1;switch(this._iMode){case 0:b1=this._getItems();c1=new U(i.call(this).getTime());d1=this.getIntervalMinutes();c1.setUTCMinutes(c1.getUTCMinutes()-b1*d1);a1.setUTCMinutes(a1.getUTCMinutes()-b1*d1);this._setFocusedDate(a1);_.call(this,c1,true);break;case 1:if(!this.getPickerPopup()){e1=this.getAggregation("datesRow");f1=a._createUniversalUTCDate(e1.getDate());g1=e1.getDays();if(f1.getUTCDate()<=g1){f1.setUTCDate(1);}else{f1.setUTCDate(f1.getUTCDate()-g1);}R.call(this,f1);}break;case 2:if(!this.getPickerPopup()){h1=this.getAggregation("monthPicker");if(h1.getMonths()<12){h1.previousPage();v.call(this);}else{a1.setUTCFullYear(a1.getUTCFullYear()-1);Q.call(this,a1);this._setFocusedDate(a1);u.call(this);W.call(this,a1.getUTCFullYear(),h1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){i1=this.getAggregation("yearPicker");i1.previousPage();w.call(this);}break;}};
h.prototype._handleNext=function($){var a1=this._getFocusedDate();switch(this._iMode){case 0:var b1=this._getItems();var c1=new U(i.call(this).getTime());var d1=this.getIntervalMinutes();c1.setUTCMinutes(c1.getUTCMinutes()+b1*d1);a1.setUTCMinutes(a1.getUTCMinutes()+b1*d1);this._setFocusedDate(a1);_.call(this,c1,true);break;case 1:if(!this.getPickerPopup()){var e1=this.getAggregation("datesRow");var f1=a._createUniversalUTCDate(e1.getDate());var g1=new U(f1.getTime());g1.setUTCDate(1);g1.setUTCMonth(g1.getUTCMonth()+1);g1.setUTCDate(0);var h1=e1.getDays();if(f1.getUTCDate()+h1>g1.getUTCDate()){f1.setUTCDate(g1.getUTCDate());}else{f1.setUTCDate(f1.getUTCDate()+h1);}R.call(this,f1);}break;case 2:if(!this.getPickerPopup()){var i1=this.getAggregation("monthPicker");if(i1.getMonths()<12){i1.nextPage();v.call(this);}else{a1.setUTCFullYear(a1.getUTCFullYear()+1);Q.call(this,a1);this._setFocusedDate(a1);u.call(this);W.call(this,a1.getUTCFullYear(),i1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){var j1=this.getAggregation("yearPicker");j1.nextPage();w.call(this);}break;}};
h.prototype._getShowItemHeader=function(){var $=this.getItems();if($>this._iItemsHead){return true;}else{return false;}};
function _($,a1,b1){var c1=new U(this._oMaxDate.getTime());c1.setUTCMinutes(c1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(c1.getTime()<this._oMinDate.getTime()){c1=new U(this._oMinDate.getTime());c1.setUTCMinutes(c1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if($.getTime()<this._oMinDate.getTime()){$=new U(this._oMinDate.getTime());}else if($.getTime()>c1.getTime()){$=c1;}var d1=this.getAggregation("timesRow");var e1=a._createLocalDate($,true);d1.setStartDate(e1);this._oUTCStartDate=new U(d1._getStartDate().getTime());e1=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",e1,true);u.call(this);if(a1){var f1=a._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(f1)){this._setFocusedDate($);d1.setDate(e1);}else{d1.setDate(f1);}}if(!b1){this.fireStartDateChange();}}
function i(){if(!this._oUTCStartDate){var $=this.getAggregation("timesRow");$.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U($._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}
function j($){var a1=this._getFocusedDate();var b1=this.getAggregation("timesRow");if(!$){b1.setDate(a._createLocalDate(a1,true));}else{b1.displayDate(a._createLocalDate(a1,true));}u.call(this);}
function k(){var $=this.getSelectedDates();if($&&$[0]&&$[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate($[0].getStartDate(),undefined,true);}else{var a1=new Date();this._oFocusedDate=a._createUniversalUTCDate(a1,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}
h.prototype._showCalendarPicker=function(){var $=a._createLocalDate(this._getFocusedDate(),true);var a1=this._getCalendarPicker();var b1=new sap.ui.unified.DateRange({startDate:$});a1.displayDate($,false);a1.removeAllSelectedDates();a1.addSelectedDate(b1);a1.setMinDate(this.getMinDate());a1.setMaxDate(this.getMaxDate());S.call(this,a1);this._showOverlay();};
h.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
h.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
function m($){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!$){j.call(this);var a1=this.getAggregation("timesRow");q(a1._oItemNavigation.getItemDomRefs()[a1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function n(){if(this._iMode==3){t.call(this,true);}else if(this._iMode==2){r.call(this,true);}var $=this._getFocusedDate();var a1=this._getItems();var b1=this.getAggregation("datesRow");var c1=b1.getSelectedDates()[0];c1.setStartDate(a._createLocalDate($,true));var d1=new U($.getTime());d1.setUTCDate(1);d1.setUTCMonth(d1.getUTCMonth()+1);d1.setUTCDate(0);var e1=d1.getUTCDate();var f1=Math.floor(a1*1.5);if(f1>e1){f1=e1;}b1.setDays(f1);if(b1.getDomRef()){b1.$().css("display","");}else{var g1=sap.ui.getCore().createRenderManager();var h1=this.$("content");g1.renderControl(b1);g1.flush(h1[0],false,true);g1.destroy();}this._showOverlay();R.call(this,$);if(this._iMode==0){var i1=this.getAggregation("timesRow");q(i1._oItemNavigation.getItemDomRefs()[i1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}
function o($){this._iMode=0;var a1=this.getAggregation("datesRow");a1.$().css("display","none");this._hideOverlay();if(!$){j.call(this);var b1=this.getAggregation("timesRow");q(b1._oItemNavigation.getItemDomRefs()[b1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function p(){if(this._iMode==1){o.call(this,true);}else if(this._iMode==3){t.call(this,true);}var $=this._getFocusedDate();var a1=this.getAggregation("monthPicker");if(a1.getDomRef()){a1.$().css("display","");}else{var b1=sap.ui.getCore().createRenderManager();var c1=this.$("content");b1.renderControl(a1);b1.flush(c1[0],false,true);b1.destroy();}this._showOverlay();a1.setMonth($.getUTCMonth());W.call(this,$.getUTCFullYear(),a1);if(this._iMode==0){var d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;v.call(this);}
function r($){this._iMode=0;var a1=this.getAggregation("monthPicker");a1.$().css("display","none");this._hideOverlay();if(!$){j.call(this);var b1=this.getAggregation("timesRow");q(b1._oItemNavigation.getItemDomRefs()[b1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function s(){if(this._iMode==1){o.call(this,true);}else if(this._iMode==2){r.call(this,true);}var $=this._getFocusedDate();var a1=this.getAggregation("yearPicker");if(a1.getDomRef()){a1.$().css("display","");}else{var b1=sap.ui.getCore().createRenderManager();var c1=this.$("content");b1.renderControl(a1);b1.flush(c1[0],false,true);b1.destroy();}this._showOverlay();a1.setDate($.getJSDate());if(this._iMode==0){var d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}w.call(this);this._iMode=3;}
function t($){this._iMode=0;var a1=this.getAggregation("yearPicker");a1.$().css("display","none");this._hideOverlay();if(!$){j.call(this);var b1=this.getAggregation("timesRow");q(b1._oItemNavigation.getItemDomRefs()[b1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function u(){x.call(this);v.call(this,true);}
function v($){var a1=new U(i.call(this).getTime());var b1=this._getItems();var c1=a1.getJSDate().getUTCFullYear();var d1=this._oMaxDate.getJSDate().getUTCFullYear();var e1=this._oMinDate.getJSDate().getUTCFullYear();var f1=a1.getJSDate().getUTCMonth();var g1=this._oMaxDate.getJSDate().getUTCMonth();var h1=this._oMinDate.getJSDate().getUTCMonth();var i1=a1.getJSDate().getUTCDate();var j1=this._oMaxDate.getJSDate().getUTCDate();var k1=this._oMinDate.getJSDate().getUTCDate();var l1=a1.getJSDate().getUTCHours();var m1=this._oMaxDate.getJSDate().getUTCHours();var n1=this._oMinDate.getJSDate().getUTCHours();var o1=a1.getJSDate().getUTCMinutes();var p1=this._oMaxDate.getJSDate().getUTCMinutes();var q1=this._oMinDate.getJSDate().getUTCMinutes();var r1=this.getAggregation("header");if(this._iMode==2&&!$){var s1=this.getAggregation("monthPicker");var t1=s1.getMonths();var u1=s1.getStartMonth();var v1=u1+t1-1;if(u1==0||(c1==e1&&u1<=h1)){r1.setEnabledPrevious(false);}else{r1.setEnabledPrevious(true);}if(v1>10||(c1==d1&&v1>=g1)){r1.setEnabledNext(false);}else{r1.setEnabledNext(true);}return;}if((c1<e1||(c1==e1&&(!$||(f1<h1||(f1==h1&&(i1<k1||(i1==k1&&(l1<n1||(l1==n1&&o1<=q1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){r1.setEnabledPrevious(false);}else{r1.setEnabledPrevious(true);}a1.setUTCMinutes(a1.getUTCMinutes()+(b1)*this.getIntervalMinutes()-1);c1=a1.getJSDate().getUTCFullYear();f1=a1.getJSDate().getUTCMonth();i1=a1.getJSDate().getUTCDate();l1=a1.getJSDate().getUTCHours();o1=a1.getJSDate().getUTCMinutes();if((c1>d1||(c1==d1&&(!$||(f1>g1||(f1==g1&&(i1>j1||(i1==j1&&(l1>m1||(l1==m1&&o1>=p1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){r1.setEnabledNext(false);}else{r1.setEnabledNext(true);}}
function w(){var $=this.getAggregation("yearPicker");var a1=$.getYears();var b1=a._createUniversalUTCDate($.getFirstRenderedDate());b1.setUTCFullYear(b1.getUTCFullYear()+Math.floor(a1/2));var c1=this.getAggregation("header");var d1=new U(this._oMaxDate);d1.setUTCFullYear(d1.getUTCFullYear()-Math.ceil(a1/2));d1.setUTCMonth(11,31);var e1=new U(this._oMinDate);e1.setUTCFullYear(e1.getUTCFullYear()+Math.floor(a1/2)+1);e1.setUTCMonth(0,1);if(b1.getTime()>d1.getTime()){c1.setEnabledNext(false);}else{c1.setEnabledNext(true);}if(b1.getTime()<e1.getTime()){c1.setEnabledPrevious(false);}else{c1.setEnabledPrevious(true);}}
function x(){var $=this.getAggregation("header");var a1;var b1=i.call(this);var c1;var d1=this._getLocaleData();var e1=[];var f1=[];var g1;var h1=false;var i1;var j1=g.Gregorian;var k1=false;if(d1.oLocale.sLanguage.toLowerCase()==="ja"||d1.oLocale.sLanguage.toLowerCase()==="zh"){i1=b.getDateInstance({format:"d"}).format(b1,true);}else{i1=(b1.getUTCDate()).toString();}if(this._bLongMonth||!this._bNamesLengthChecked){e1=d1.getMonthsStandAlone("wide");}else{h1=true;e1=d1.getMonthsStandAlone("abbreviated");f1=d1.getMonthsStandAlone("wide");}var l1=b1.getUTCMonth();a1=e1[l1];if(h1){g1=f1[e1[l1]];}if(!this.getPickerPopup()){$.setTextButton0(i1);$.setTextButton1(a1);$.setTextButton2(this._oYearFormat.format(b1,true));}else{c1=b.getInstance({style:"long",strictParsing:true,relative:k1,calendarType:j1},d1.oLocale);g1=i1=c1.format(a._createLocalDate(b1,true));$.setTextButton1(i1);}if(h1){$.setAriaLabelButton1(g1);}}
function y($,a1){var b1;var c1=false;if($.getTime()<this._oMinDate.getTime()){b1=this._oMinDate;c1=true;}else if($.getTime()>this._oMaxDate.getTime()){b1=this._oMaxDate;c1=true;}else{b1=$;}this._setFocusedDate(b1);if(c1||a1){Q.call(this,b1);j.call(this,false);this.fireStartDateChange();}}
function z($,a1){if($&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=$.getTime())){a._checkJSDateObject($);$=a._createUniversalUTCDate($,undefined,true);var b1=$.getUTCFullYear();a._checkYearInValidRange(b1);if($.getTime()<this._oMinDate.getTime()||$.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate($);if(this.getDomRef()&&this._iMode==0){j.call(this,a1);}}}
function A($){if(this._iMode!=1){n.call(this);}else{o.call(this);}}
function B($){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=2){p.call(this);}else{r.call(this);}}}
function E($){if(this._iMode!=3){s.call(this);}else{t.call(this);}}
function F($){this.fireSelect();}
function G($){var a1=a._createUniversalUTCDate($.getParameter("date"),undefined,true);var b1=$.getParameter("notVisible");y.call(this,a1,b1);}
function I($){var a1=$.getSource(),b1=a1.getSelectedDates()[0].getStartDate();var c1=new U(this._getFocusedDate().getTime());var d1=a._createUniversalUTCDate(b1);c1.setUTCDate(d1.getUTCDate());c1.setUTCMonth(d1.getUTCMonth());c1.setUTCFullYear(d1.getUTCFullYear());y.call(this,c1,true);m.call(this);}
function J($){var a1=new U(this._getFocusedDate().getTime());var b1=$.oSource;var c1=b1.getSelectedDates()[0];var d1=a._createUniversalUTCDate(c1.getStartDate());if(!this.getPickerPopup()||d1.getUTCMonth()==a1.getUTCMonth()){a1.setUTCDate(d1.getUTCDate());a1.setUTCMonth(d1.getUTCMonth());a1.setUTCFullYear(d1.getUTCFullYear());y.call(this,a1,true);o.call(this);}}
function K($){var a1=new U(this._getFocusedDate().getTime());var b1=a._createUniversalUTCDate($.getParameter("date"),undefined,true);var c1=$.getParameter("otherMonth");if(c1&&b1.getUTCMonth()==a1.getUTCMonth()&&b1.getUTCFullYear()==a1.getUTCFullYear()){R.call(this,b1);}}
function N($){var a1=new U(this._getFocusedDate().getTime());var b1=this.getAggregation("monthPicker");var c1=b1.getMonth();a1.setUTCMonth(c1);if(c1!=a1.getUTCMonth()){a1.setUTCDate(0);}y.call(this,a1,true);r.call(this);}
function O($){var a1=new U(this._getFocusedDate().getTime());var b1=this.getAggregation("yearPicker");var c1=a._createUniversalUTCDate(b1.getDate());var d1=a1.getUTCMonth();c1.setUTCMonth(a1.getUTCMonth(),a1.getUTCDate());c1.setUTCHours(a1.getUTCHours());c1.setUTCMinutes(a1.getUTCMinutes());a1=c1;if(d1!=a1.getUTCMonth()){a1.setUTCDate(0);}y.call(this,a1,true);t.call(this);}
function P(){this._sInvalidateContent=undefined;var $=this.getAggregation("timesRow");$._bDateRangeChanged=true;$._bInvalidateSync=true;$.invalidate();$._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}
function Q($){var a1=this.getAggregation("timesRow");var b1=i.call(this);var c1=a1._oItemNavigation.getFocusedIndex();b1=new U($.getTime());b1.setUTCMinutes(b1.getUTCMinutes()-c1*this.getIntervalMinutes());_.call(this,b1,false,true);}
function R($){var a1=this.getAggregation("datesRow");var b1=this.getAggregation("header");if(!this.getPickerPopup()){var c1=new U($.getTime());c1.setUTCDate(1);c1.setUTCMonth(c1.getUTCMonth()+1);c1.setUTCDate(0);var d1=a1.getDays();var e1=new U($.getTime());e1.setUTCDate(1+(Math.ceil($.getUTCDate()/d1)-1)*d1);if(c1.getUTCDate()-e1.getUTCDate()<d1){e1.setUTCDate(c1.getUTCDate()-d1+1);}a1.setStartDate(a._createLocalDate(e1,true));var f1=e1.getJSDate().getUTCFullYear();var g1=this._oMaxDate.getJSDate().getUTCFullYear();var h1=this._oMinDate.getJSDate().getUTCFullYear();var i1=e1.getJSDate().getUTCMonth();var j1=this._oMaxDate.getJSDate().getUTCMonth();var k1=this._oMinDate.getJSDate().getUTCMonth();var l1=e1.getJSDate().getUTCDate();var m1=this._oMaxDate.getJSDate().getUTCDate();var n1=this._oMinDate.getJSDate().getUTCDate();if(l1<=1||(f1==h1&&i1==k1&&l1<=n1)){b1.setEnabledPrevious(false);}else{b1.setEnabledPrevious(true);}if((l1+d1)>=c1.getUTCDate()||(f1==g1&&i1==j1&&l1>=m1)){b1.setEnabledNext(false);}else{b1.setEnabledNext(true);}}else{b1.setEnabledPrevious(false);b1.setEnabledNext(false);}a1.setDate(a._createLocalDate($,true));}
function S($){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(V,this);this._oPopup.onsapescape=function(c1){this._oCalendar.onsapescape(c1);};}this._oPopup.setContent($);var a1=this.getAggregation("header");var b1=sap.ui.core.Popup.Dock;this._oPopup.open(0,b1.CenterTop,b1.CenterTop,a1,null,"flipfit",true);}
function V($){m.call(this);}
function W($,a1){var b1=0;var c1=11;if($==this._oMinDate.getUTCFullYear()){b1=this._oMinDate.getUTCMonth();}if($==this._oMaxDate.getUTCFullYear()){c1=this._oMaxDate.getUTCMonth();}a1.setMinMax(b1,c1);}
function X($){v.call(this);}
function Z($){w.call(this);}
return h;});
sap.ui.predefine('sap/ui/unified/CalendarTimeIntervalRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var i=c.getId();var t=c.getTooltip_AsString();var T=c.getAggregation("timesRow");r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");r.addClass("sapUiCalInt");r.addClass("sapUiCalTimeInt");if(c._getShowItemHeader()){r.addClass("sapUiCalIntHead");}if(c.getPickerPopup()){r.addClass("sapUiCalIntLarge");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}var w=c.getWidth();if(w&&w!=''){r.addStyle("width",w);r.writeStyles();}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+i+"-content\" class=\"sapUiCalContent\">");r.renderControl(T);r.write("</div>");r.write("<button id=\""+i+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+i+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarWeekInterval',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer'],function(C,a,l,b,c){"use strict";
var d=b.extend("sap.ui.unified.CalendarWeekInterval",{renderer:c});
d.prototype._getDaysLarge=function(){return 6;};
d.prototype._handleFocus=function(e){var o=!!e.getParameter("_outsideBorder"),D,f,g;if(o){D=e.getParameter("date");this._oFocusDateWeek=a.fromLocalJSDate(D);f=C._getFirstDateOfWeek(this._oFocusDateWeek);g=this.getAggregation("month")[0];if(g.getDomRef()){this._setStartDate(f,false,true);}}return b.prototype._handleFocus.apply(this,arguments);};
d.prototype._focusDateExtend=function(D,o,n){var e,L;if(!this._oFocusDateWeek){return b.prototype._focusDateExtend.apply(this,arguments);}e=this.getAggregation("month")[0];L=this._oFocusDateWeek.toLocalJSDate();this._setFocusedDate(this._oFocusDateWeek);e.setDate(L);this._oFocusDateWeek=null;return!n;};
d.prototype._dateMatchesVisibleRange=function(D){var i=this.getDays(),o=a.fromLocalJSDate(D),s=a.fromLocalJSDate(this.getStartDate()),e=a.fromLocalJSDate(this.getStartDate());e.setDate(e.getDate()+i);return o.isSameOrAfter(s)&&o.isBefore(e);};
d.prototype._showCalendarPicker=function(){var o=this._getFocusedDate(),e=this._getStartDate(),f=this._getCalendarPicker(),s=new sap.ui.unified.DateRange(),g;g=new a(e);g.setDate(g.getDate()+this._getDays()-1);s.setStartDate(e.toLocalJSDate());s.setEndDate(g.toLocalJSDate());f.displayDate(o.toLocalJSDate(),false);f.removeAllSelectedDates();f.addSelectedDate(s);f.setMinDate(this.getMinDate());f.setMaxDate(this.getMaxDate());this._openPickerPopup(f);this._showOverlay();};
d.prototype._handleCalendarPickerDateSelect=function(e){var o=this._getCalendarPicker(),f=o._getFocusedDate(),F;if(this._dateMatchesVisibleRange(f.toLocalJSDate())){this._oFocusDateWeek=o._getFocusedDate();this._focusDate(this._oFocusDateWeek,false,true);}else{F=C._getFirstDateOfWeek(f);this._setStartDate(F);this._oFocusDateWeek=o._getFocusedDate();this._focusDate(this._oFocusDateWeek,false,true);}this._closeCalendarPicker(true);};
return d;});
sap.ui.predefine('sap/ui/unified/ColorPicker',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/HTML","sap/ui/core/ResizeHandler","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/ui/core/Icon","sap/ui/core/theming/Parameters","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/core/library","./ColorPickerRenderer","sap/ui/Global"],function(q,L,a,H,R,G,b,V,c,I,P,e,D,f,g){"use strict";var h=f.ValueState;var j=L.ColorPickerMode;
var k=a.extend("sap.ui.unified.ColorPicker",{metadata:{library:"sap.ui.unified",properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:j.HSV}},aggregations:{_grid:{type:"sap.ui.layout.Grid",group:"Appearance",multiple:false,visibility:"hidden"},_invisibleTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}}});
var B="",s=sap.ui.resource('sap.ui.unified','img/ColorPicker/Alphaslider_BG.png'),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),o=L.ColorPickerHelper,F=o.factory,l={};Object.defineProperties(l,{RGB:{value:"RGB"},CPResponsiveClass:{value:"sapUnifiedColorPicker"},CPMatrixClass:{value:"sapUiColorPicker-ColorPickerMatrix"},HSLClass:{value:"sapUiColorPickerHSL"},LabelClass:{value:"sapUiColorPicker-ColorPickerLabels"},UnitLabelClass:{value:"sapUiCPUnitLabel"},HEXClass:{value:"sapUiColorPicker-ColorPickerHexField"},LeftColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsLeft"},RightColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsRight"},SliderClass:{value:"sapUiColorPicker-ColorPickerSlider"},AlphaSliderClass:{value:"sapUiColorPicker-ColorPickerAlphaSlider"},OutputSelectorClass:{value:"sapUiColorPickerHSL-RB"},OutputSelectorRowClass:{value:"sapUiColorPicker-RBRow"},CPBoxClass:{value:"sapUiColorPicker-ColorPickerBox"},CPCircleClass:{value:"sapUiColorPicker-ColorPickerCircle"},LastColumnClass:{value:"sapUiColorPicker-ColorPickerLastColumn"},HideForHSVClass:{value:"hideForHSV"},HideForHSLClass:{value:"hideForHSL"},OldColorClass:{value:"sapUiColorPicker-ColorPickerOldColor"},NewColorClass:{value:"sapUiColorPicker-ColorPickerNewColor"},SwatchesClass:{value:"sapUiColorPicker-swatches"},ArrowClass:{value:"sapUiColorPicker-Arrow"},Colors:{value:{aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'00ffff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000000',blanchedalmond:'ffebcd',blue:'0000ff',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'00ffff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgrey:'a9a9a9',darkgreen:'006400',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkslategrey:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dimgrey:'696969',dodgerblue:'1e90ff',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'ff00ff',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',grey:'808080',green:'008000',greenyellow:'adff2f',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgray:'d3d3d3',lightgrey:'d3d3d3',lightgreen:'90ee90',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslategray:'778899',lightslategrey:'778899',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'00ff00',limegreen:'32cd32',linen:'faf0e6',magenta:'ff00ff',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370db',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'db7093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',red:'ff0000',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',slategrey:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',wheat:'f5deb3',white:'ffffff',whitesmoke:'f5f5f5',yellow:'ffff00',yellowgreen:'9acd32',transparent:'00000000'}}});
k.prototype.init=function(){if(D.browser.firefox){B="-moz-linear-gradient";}else if(D.browser.msie){B="-ms-linear-gradient";}else if(D.browser.webkit){B="-webkit-linear-gradient";}else{B="linear-gradient";}this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,oldA:1,hex:"#ffffff",old:"#ffffff"};this.sHexString="ffffff";this.$CPBox=null;this.$CPCur=null;this.RGB={r:0,g:0,b:0};this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this.data("sap-ui-fastnavgroup","true",true);this.bResponsive=o.isResponsive();this._iCPCursorSize=parseInt(P.get("_sap_ui_unified_ColorPicker_CircleSize"),10);this._processChanges=this._processHSVChanges;this._bHSLMode=false;};
var m=a.extend("sap.ui.unified._ColorPickerBox",{
metadata:{events:{select:{parameters:{value:{type:"int"},saturation:{type:"int"}}},resize:{parameters:{size:{type:"int"}}}}},
init:function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();},
exit:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
getWidth:function(){return this.$().width();},
getOffset:function(){return this.$().offset();},
onBeforeRendering:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
onAfterRendering:function(){this._handle=this.$().find("> div."+l.CPCircleClass);this._sResizeListener=R.register(this.getDomRef(),this.handleResize.bind(this));},
handleResize:function(E){this.fireResize({size:E.size.width});},
getHandle:function(){return this._handle;},
ontouchstart:function(E){this.handleTouch(E);},
ontouchend:function(E){this.handleTouch(E);},
ontouchmove:function(E){this.handleTouch(E);},
handleTouch:function(E){var v=this.calculateValuesFromEvent(E);if(v){this.fireSelect(v);}},
calculateValuesFromEvent:function(E){var x=E.offsetX,y=E.offsetY,i,d=i=this.getWidth(),n,O;E.preventDefault&&E.preventDefault();if(!x){n=E.targetTouches?E.targetTouches[0]:E;if(!n||!n.pageX){n=E;if((!n||!n.pageX)&&E.changedTouches){n=E.changedTouches[0];}}if(!n.pageX){return false;}O=this.getOffset();x=n.pageX-O.left;y=n.pageY-O.top;}x=Math.min(Math.max(x,0),d);y=Math.min(Math.max(y,0),i);if(this.bRtl){x=d-x;}return{value:x/d*100,saturation:(1-y/i)*100};},
renderer:function(d,C){d.write("<div");d.addClass(l.CPBoxClass);d.writeControlData(C);d.writeClasses();d.write(">");d.write("<div");d.writeAttribute("id",C.getId()+"-cpCur");d.addClass(l.CPCircleClass);d.writeClasses();d.write("></div>");d.write("</div>");}
});
k.prototype._createRowFromInput=function(i,t,d,u){var T=r.getText(t),n;n=new c({content:[F.createLabel({text:d,tooltip:T,labelFor:i}).addStyleClass(l.LabelClass),i.setTooltip(T)]});if(u){n.addContent(F.createLabel({text:u,labelFor:i}).addStyleClass(l.UnitLabelClass).addStyleClass(l.LabelClass));}return n;};
k.prototype._updateColorStringProperty=function(d,i){var n=this._getCSSColorString();this.setProperty('colorString',n,true);if(i){this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:n});}if(d){this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:n});}};
k.prototype._handleCPBoxSelectEvent=function(E){var v=E.getParameter("value"),d=E.getParameter("saturation");this.oSatField.setValue(d);if(this._bHSLMode){this.oLitField.setValue(v);}else{this.oValField.setValue(v);}this._processChanges();this._updateColorStringProperty(false,true);};
k.prototype._handleCPBoxResizeEvent=function(E){this._iCPBoxSize=E.getParameter("size");this._updateCursorPosition();};
k.prototype._handleCPBoxTouchEndEvent=function(E){this._updateColorStringProperty(true,false);};
k.prototype._createInteractionControls=function(){var i=this.getId(),d,A;this.oCPBox=new m(i+"-cpBox",{select:this._handleCPBoxSelectEvent.bind(this),resize:this._handleCPBoxResizeEvent.bind(this)});this.oCPBox.addDelegate({ontouchend:this._handleCPBoxTouchEndEvent.bind(this)});this.oHexField=F.createInput(i+"-hxF",{value:this.Color.hex.substr(1),change:this._handleHexValueChange.bind(this)}).addStyleClass(l.HEXClass);this.oRedField=F.createInput(i+"-rF",{value:this.Color.r,change:this._handleRedValueChange.bind(this)}).addStyleClass(l.LeftColumnInputClass);this.oGreenField=F.createInput(i+"-gF",{value:this.Color.g,change:this._handleGreenValueChange.bind(this)}).addStyleClass(l.LeftColumnInputClass);this.oBlueField=F.createInput(i+"-bF",{value:this.Color.b,change:this._handleBlueValueChange.bind(this)}).addStyleClass(l.LeftColumnInputClass);this.oHueField=F.createInput(i+"-hF",{value:this.Color.h,change:this._handleHueValueChange.bind(this)}).addStyleClass(l.RightColumnInputClass);this.oSatField=F.createInput(i+"-sF",{value:this.Color.s,change:this._handleSatValueChange.bind(this)}).addStyleClass(l.RightColumnInputClass);this.oLitField=F.createInput(i+"-lF",{value:this.Color.l,change:this._handleLitValueChange.bind(this)}).addStyleClass(l.RightColumnInputClass);this.oAlphaField=F.createInput(i+"-aF",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this)}).addStyleClass(l.RightColumnInputClass);this.oValField=F.createInput(i+"-vF",{value:this.Color.v,change:this._handleValValueChange.bind(this)}).addStyleClass(l.RightColumnInputClass);this.oRGBorHSLRBGroup=F.createRadioButtonGroup({columns:2,buttons:[F.createRadioButtonItem({text:l.RGB}),F.createRadioButtonItem({text:L.ColorPickerMode.HSL})],select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:(this.Color.formatHSL?1:0)}).addStyleClass(l.OutputSelectorClass);d=new e({text:r.getText("COLORPICKER_HUE_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",d,true);this.oSlider=F.createSlider(i+"-hSLD",{max:360,step:1,tooltip:r.getText("COLORPICKER_HUE"),value:parseInt(this.oHueField.getValue(),10)}).addStyleClass(l.SliderClass).addAriaLabelledBy(d);this.oSlider.attachEvent("liveChange","liveChange",this._handleSliderChange.bind(this));this.oSlider.attachEvent("change","change",this._handleSliderChange.bind(this));A=new e({text:r.getText("COLORPICKER_ALPHA_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",A,true);this.oAlphaSlider=F.createSlider(i+"-aSLD",{max:1,value:1,step:0.01,tooltip:r.getText("COLORPICKER_ALPHA")}).addStyleClass(l.AlphaSliderClass).addAriaLabelledBy(A);this.oAlphaSlider.attachEvent("liveChange","liveChange",this._handleAlphaSliderChange.bind(this));this.oAlphaSlider.attachEvent("change","change",this._handleAlphaSliderChange.bind(this));};
k.prototype._createLayout=function(){var i=this.getId(),d;if(this._bLayoutControlsCreated){return;}this._createInteractionControls();this._oLayoutData={oCPBox:new b({span:"L6 M6 S12"}),icOne:new b({span:"L3 M3 S6"}),icTwo:new b({span:"L3 M3 S6"}),swatches:new b({span:"L3 M3 S12"}),rbg:new b({span:"L6 M8 S12"})};d=new G({containerQuery:true,content:[this.oCPBox.setLayoutData(this._oLayoutData.oCPBox),new V({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED","R:"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN","G:"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE","B:"),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","#:")],layoutData:this._oLayoutData.icOne}),new V({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE","H:"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","S:","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","L:","%").addStyleClass(l.HideForHSVClass),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","A:").addStyleClass(l.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE","V:").addStyleClass(l.HideForHSLClass)],layoutData:this._oLayoutData.icTwo}).addStyleClass(l.LastColumnClass),new c({content:[new H({content:["<div id='",i,"-ocBox' class='",l.OldColorClass,"'></div>"].join("")}),new I({backgroundColor:"transparent",src:"sap-icon://arrow-right",tooltip:r.getText("COLORPICKER_NEW_OLD_COLOR")}).addStyleClass(l.HideForHSVClass).addStyleClass(l.ArrowClass),new H({content:["<div id='",i,"-ncBox' class='",l.NewColorClass,"'></div>"].join("")})],layoutData:this._oLayoutData.swatches}).addStyleClass(l.SwatchesClass),new c({content:[F.createLabel({text:"Output:",labelFor:this.oRGBorHSLRBGroup}),this.oRGBorHSLRBGroup],layoutData:this._oLayoutData.rbg}).addStyleClass(l.HideForHSVClass).addStyleClass(l.OutputSelectorRowClass),this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})),this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12"}))]}).addStyleClass(l.CPMatrixClass);this.setAggregation("_grid",d,true);this._bLayoutControlsCreated=true;this._adaptControlToLibrary();};
k.prototype._adaptControlToLibrary=function(){var d;if(!this._bLayoutControlsCreated){return;}d=this.getAggregation("_grid");if(this.bResponsive){if(!D.system.phone&&!q('html').hasClass("sapUiMedia-Std-Phone")){d._setBreakPointTablet(400);}d.addStyleClass(l.CPResponsiveClass);}else{d.setProperty("hSpacing",0,true);d.setProperty("vSpacing",0,true);this._oLayoutData.oCPBox.setSpanS(5);this._oLayoutData.icOne.setSpanS(4);this._oLayoutData.icTwo.setSpanS(3);this._oLayoutData.rbg.setSpanS(8);}this._adaptControlToLibrary=q.noop;};
k.prototype._updateControlVisualState=function(){var d=this.getAggregation("_grid");if(!this._bLayoutControlsCreated){return;}if(this.bResponsive){if(this._bHSLMode){d.addStyleClass(l.HSLClass);this._oLayoutData.swatches.setSpanM(4).setLinebreak(true);}else{d.removeStyleClass(l.HSLClass);this._oLayoutData.swatches.setSpanM(3).setLinebreak(false);}}else{if(this._bHSLMode){d.addStyleClass(l.HSLClass);this._oLayoutData.swatches.setSpanS(4).setLinebreak(true);}else{d.removeStyleClass(l.HSLClass);this._oLayoutData.swatches.setSpanS(3).setLinebreak(false);}}};
k.prototype._processChanges=q.noop;
k.prototype.setMode=function(M,S){switch(M){case L.ColorPickerMode.HSL:this._processChanges=this._processHSLChanges;break;case L.ColorPickerMode.HSV:this._processChanges=this._processHSVChanges;break;default:q.sap.log.error("Control must have a valid mode set to work correct");break;}this._bHSLMode=M===L.ColorPickerMode.HSL;return this.setProperty("mode",M,S);};
k.prototype.onBeforeRendering=function(){this._createLayout();this._updateControlVisualState();this._updateColorString();};
k.prototype._updateColorString=function(){this._parseColorString(this.getColorString());this.oHexField.setValue(this.Color.hex.substr(1));this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(this.Color.a);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0);}else{this.oValField.setValue(this.Color.v);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oAlphaField.setValue(this.Color.a);}this._updateColorStringProperty(true,true);};
k.prototype.isColor=function(C){return this._parseColorString(C,true);};
k.prototype._handleSliderChange=function(E,d){var i=parseInt(this.oSlider.getValue(),10);this.oHueField.setValue(i);this._processChanges();this._updateColorStringProperty(d==="change",d==="liveChange");};
k.prototype._handleAlphaSliderChange=function(E,d){this.Color.a=this.oAlphaSlider.getValue();if(this._bHSLMode){this.oAlphaField.setValue(this.Color.a);}if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(d==="change",d==="liveChange");};
k.prototype._getValueInRange=function(v,M,i){if(isNaN(v)){v=0;}return Math.min(Math.max(v,M),i);};
k.prototype._handleAlphaValueChange=function(){var d=parseFloat(this.oAlphaField.getValue(),10);d=this._getValueInRange(d,0,1);this.Color.a=d;this.oAlphaField.setValue(d);this.oAlphaSlider.setValue(d);if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(true,true);};
k.prototype._handleRGBorHSLValueChange=function(){this.Color.formatHSL=(this.oRGBorHSLRBGroup.getSelectedIndex()===1);this._updateColorStringProperty(true,true);};
k.prototype._handleHueValueChange=function(){var d=parseInt(this.oHueField.getValue(),10);d=this._getValueInRange(d,0,360);this.oHueField.setValue(d);this.oSlider.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
k.prototype._handleSatValueChange=function(){var d=parseInt(this.oSatField.getValue(),10);d=this._getValueInRange(d,0,100);this.oSatField.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
k.prototype._handleValValueChange=function(){var v=parseInt(this.oValField.getValue(),10);v=this._getValueInRange(v,0,100);this.oValField.setValue(v);this._processHSVChanges();this._updateColorStringProperty(true,true);};
k.prototype._handleLitValueChange=function(){var d=parseInt(this.oLitField.getValue(),10);d=this._getValueInRange(d,0,100);this.oLitField.setValue(d);this._processHSLChanges();this._updateColorStringProperty(true,true);};
k.prototype._handleRedValueChange=function(){var d=parseInt(this.oRedField.getValue(),10);d=this._getValueInRange(d,0,255);this.oRedField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
k.prototype._handleGreenValueChange=function(){var d=parseInt(this.oGreenField.getValue(),10);d=this._getValueInRange(d,0,255);this.oGreenField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
k.prototype._handleBlueValueChange=function(){var d=parseInt(this.oBlueField.getValue(),10);d=this._getValueInRange(d,0,255);this.oBlueField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
k.prototype._processHSVChanges=function(){var d=parseInt(this.oHueField.getValue(),10);var i=parseInt(this.oSatField.getValue(),10);var v=parseInt(this.oValField.getValue(),10);this._calculateRGB(d,i,v);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=d;this.Color.s=i;this.Color.v=v;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oValField.setValue(this.Color.v);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
k.prototype._processHSLChanges=function(){var i=parseInt(this.oHueField.getValue(),10),S=parseInt(this.oSatField.getValue(),10),d=parseInt(this.oLitField.getValue(),10);if(i>360){i%=360;}this._calculateRGB(i,S,d);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=i;this.Color.s=S;this.Color.l=d;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oLitField.setValue(this.Color.l);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();};
k.prototype._processRGBChanges=function(){var d=Math.round(parseInt(this.oRedField.getValue(),10)),i=Math.round(parseInt(this.oGreenField.getValue(),10)),n=Math.round(parseInt(this.oBlueField.getValue(),10)),p=(d+i+n)===765;this._calculateHEX(d,i,n);this.oHexField.setValue(this.sHexString);if(this._bHSLMode){this._calculateHSL(d,i,n);this.oLitField.setValue(this.Color.l);}else{if(!p){this._calculateHSV(d,i,n);}this.oValField.setValue(this.Color.v);}if(!p){this.oHueField.setValue(this.Color.h);}this.oSatField.setValue(this.Color.s);this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.Color.r=d;this.Color.g=i;this.Color.b=n;this.Color.hex="#"+this.oHexField.getValue();this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
k.prototype._handleHexValueChange=function(){var d=this.oHexField.getValue().toLowerCase(),i=1,n;if(d.substr(0,1)==='#'){d=d.substr(1);}n=/^([0-9a-fA-F]{8})$/;if(n.test(d)!==false){i=Number((parseInt(d.substr(6,2),16)/255).toFixed(2));d=d.substr(0,6);}n=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(n.test(d)===false){this.oHexField.setValueState(h.Error);this.oSlider.setEnabled(false);this.oAlphaSlider.setEnabled(false);this.oHueField.setEnabled(false);this.oRedField.setEnabled(false);this.oGreenField.setEnabled(false);this.oBlueField.setEnabled(false);this.oSatField.setEnabled(false);if(this._bHSLMode){this.oLitField.setEnabled(false);this.oAlphaField.setEnabled(false);}else{this.oValField.setEnabled(false);}return;}else if(this.oHexField.getValueState()===h.Error){this.oHexField.setValueState(h.None);this.oSlider.setEnabled(true);this.oAlphaSlider.setEnabled(true);this.oHueField.setEnabled(true);this.oRedField.setEnabled(true);this.oGreenField.setEnabled(true);this.oBlueField.setEnabled(true);this.oSatField.setEnabled(true);if(this._bHSLMode){this.oLitField.setEnabled(true);this.oAlphaField.setEnabled(true);}else{this.oValField.setEnabled(true);}}if(d.length===3){d=d.charAt(0)+d.charAt(0)+d.charAt(1)+d.charAt(1)+d.charAt(2)+d.charAt(2);}this._processHexChanges(d);this.oHexField.setValue(d);this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(1);}else{this.oValField.setValue(this.Color.v);}this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.oAlphaSlider.setValue(i);this.Color.a=i;if(this._bHSLMode){this.oAlphaField.setValue(i);}this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();this._updateColorStringProperty(true,true);};
k.prototype._processHexChanges=function(d){this._convertRGB(d);if(this._bHSLMode){this._calculateHSL(this.Color.r,this.Color.g,this.Color.b);}else{this._calculateHSV(this.Color.r,this.Color.g,this.Color.b);}this.Color.hex="#"+d.toLowerCase();};
k.prototype._updateAlphaBackground=function(){var d=[this.Color.r,this.Color.g,this.Color.b].join(","),n=B+"(left,rgba("+d+",0),rgba("+d+",1)),url("+s+")";if(this.lastAlphaSliderGradient!==n){this.oAlphaSlider.$().find(this.bResponsive?".sapMSliderInner":".sapUiSliBar").css("background-image",n);this.lastAlphaSliderGradient=n;}};
k.prototype._updateCursorPosition=function(){var x,y;if(!this._iCPBoxSize){return;}if(this._bHSLMode){x=Math.round(this.oLitField.getValue()*this._iCPBoxSize/100.0);}else{x=Math.round(this.oValField.getValue()*this._iCPBoxSize/100.0);}if(this.bRtl){x=this._iCPBoxSize-x;}y=Math.round((1-this.oSatField.getValue()/100.0)*this._iCPBoxSize);x=Math.round(Math.max(x,0)-this._iCPCursorSize/2.0-1.0);y=Math.round(Math.max(y,0)-this._iCPCursorSize/2.0-1.0);this.$CPCur.css("left",x).css("top",y);};
k.prototype._calculateRGB=function(d,S,v){var n,p,t,M,x,C,i;if(this._bHSLMode){this._calculateRGBAdvanced(d,S,v);return;}d%=360;d/=60;S/=100;v/=100;C=v*S;x=C*(1-Math.abs(d%2-1));M=v-C;n=0;p=0;t=0;i=Math.floor(d);switch(i){case 0:n=C;p=x;break;case 1:n=x;p=C;break;case 2:p=C;t=x;break;case 3:p=x;t=C;break;case 4:n=x;t=C;break;case 5:n=C;t=x;break;default:n=0;t=0;p=0;break;}this.RGB.r=Math.floor((n+M)*255);this.RGB.g=Math.floor((p+M)*255);this.RGB.b=Math.floor((t+M)*255);};
k.prototype._calculateRGBAdvanced=function(d,S,n){var p,t,u,M,v,x,w,y,i;d=this._getValueInRange(d,0,360);if(S>100){S=1;}else if(S<0){S=0;}else{S=S/100;}if(n>100){n=1;}else if(n<0){n=0;}else{n=n/100;}y=S*(1-Math.abs(2*n-1));w=255*(n-0.5*y);x=y*(1-Math.abs((d/60)%2-1));i=Math.floor(d/60);v=w+255*x;M=w+255*y;switch(i){case 0:p=M;t=v;u=w;break;case 1:p=v;t=M;u=w;break;case 2:p=w;t=M;u=v;break;case 3:p=w;t=v;u=M;break;case 4:p=v;t=w;u=M;break;case 5:p=M;t=w;u=v;break;default:p=0;t=0;u=0;break;}this.RGB.r=Math.round(p);this.RGB.g=Math.round(t);this.RGB.b=Math.round(u);};
k.prototype._getCSSColorString=function(){if(this.Color.formatHSL){if(this.Color.a<1){return"hsla("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%, "+this.Color.a+")";}else{return"hsl("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%)";}}if(this.Color.a<1){return"rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+", "+this.Color.a+")";}else{return"rgb("+this.Color.r+","+this.Color.g+","+this.Color.b+")";}};
k.prototype._calculateHEX=function(i,d,n){var p=i.toString(16),t=d.toString(16),u=n.toString(16);if(p.length===1){p='0'+p;}if(t.length===1){t='0'+t;}if(u.length===1){u='0'+u;}this.sHexString=(p+t+u).toLowerCase();};
k.prototype._calculateHSV=function(i,d,n){var p=Math.max(Math.max(i,d),n),t=Math.min(Math.min(i,d),n),u=p-t,v=Math.round(p*100/255),w=p===0.0?0:(100*u/p),x=0;if(w===0){x=0;}else if(i===p){x=60.0*(d-n)/u;}else if(d===p){x=120.0+60.0*(n-i)/u;}else if(n===p){x=240.0+60.0*(i-d)/u;}if(x<0.0){x+=359.9;}x=Math.round(x);w=Math.round(w);this.Color.h=x;this.Color.s=w;this.Color.v=v;};
k.prototype._calculateHSL=function(i,n,p){var t=Math.max(i,n,p),u=Math.min(i,n,p),d=(t-u)/255,v=(t+u)/510,w=1-Math.abs(2*v-1),x=(v===0.0)?0:d/w,y=(w!==0)?x:0,z=0;v=Math.round(v*100);y=Math.round(y*100);if(v===0||y===0||(i+n+p===765)){z=0;}else{var C=t-u;if(t===i){z=((n-p)/C)%6;}if(t===n){z=(p-i)/C+2;}if(t===p){z=(i-n)/C+4;}if(C===0){z=0;}z*=60;if(z<0){z+=360;}}this.Color.h=Math.round(z);this.Color.s=y;this.Color.l=v;};
k.prototype._convertRGB=function(d){this.Color.r=parseInt(d.substr(0,2),16);this.Color.g=parseInt(d.substr(2,2),16);this.Color.b=parseInt(d.substr(4,2),16);};
k.prototype._updateGradientBoxBackground=function(i){if(this._bHSLMode){this._calculateRGBAdvanced(i,100,50);}else{this._calculateRGB(i,100,100);}this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.$CPBox.css('background-color','rgb('+[this.RGB.r,this.RGB.g,this.RGB.b].join(",")+')');};
k.prototype._updateSelColorBackground=function(){this.$("ncBox").css('background-color',this._getCSSColorString());};
k.prototype._parseColorString=function(C,d){var i;if(C.substr(0,1)==='#'){C=C.substr(1);}C=C.trim().toLowerCase();i=this._parseColorName(C);if(i){if(d){return true;}if(i.length===8){this.Color.a=this.Color.oldA=Number((parseInt(i.substr(6,2),16)/255).toFixed(2));i=i.substring(0,6);}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(C)){if(d){return true;}if(C.length===3){i=C[0]+C[0]+C[1]+C[1]+C[2]+C[2];}else{i=C;}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(C.substr(0,3)==='rgb'){return this._parseRGB(C,d);}if(this._bHSLMode){return this._parseHSL(C,d);}else if(C.substr(0,3)==='hsv'){return this._parseHSV(C,d);}return false;};
k.prototype._parseHSV=function(C,d){var i=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),)(((\d{1,2})|(100)),)((\d{1,2})|(100))$/,n,p,S,v;C=C.substr(3).replace("(",'').replace(")",'').split(' ').join('');if(i.test(C)===true){if(d){return true;}n=C.split(",");p=parseInt(n[0],10);S=parseInt(n[1],10);v=parseInt(n[2],10);this._calculateRGB(p,S,v);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=p;this.Color.s=S;this.Color.v=v;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;return true;}return false;};
k.prototype._parseHSL=function(C,d){var i,n=C.substr(0,4),p,t,S,u,A;if(n==="hsla"){p=true;}else if(n==="hsl("){p=false;}else{return false;}C=C.substr(p?4:3).replace("(",'').replace(")",'').split(' ').join('');i=C.split(",");t=parseInt(i[0],10);S=parseFloat(i[1]);u=parseFloat(i[2]);if(p){A=parseFloat(i[3]);}else{if(i[3]&&parseFloat(i[3])>=0){return false;}A=1;}S=(S<1&&S>0)?S*100:S;u=(u<1&&u>0)?u*100:u;if((t>=0&&t<=360)&&(S>=0&&S<=100)&&(u>=0&&u<=100)&&(A>=0&&A<=1)){if(d){return true;}this._calculateRGB(t,S,u);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=t;this.Color.s=S;this.Color.l=u;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.oldA=A;this.Color.formatHSL=true;}else{return false;}return true;};
k.prototype._parseRGB=function(C,d){var v,i,n,p;i=C.substring(0,4);if(i==="rgba"){p=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),)([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1])$/;n=true;}else if(i.substring(0,3)==="rgb"){p=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])))$/;n=false;}else{return false;}C=C.substr(n?4:3).replace("(",'').replace(")",'').split(' ').join('');if(p.test(C)){if(d){return true;}v=C.split(",");this._calculateHEX(parseInt(v[0],10),parseInt(v[1],10),parseInt(v[2],10));this._processHexChanges(this.sHexString);this.Color.old=this.Color.hex;if(n){this.Color.a=this.Color.oldA=parseFloat(v[3]);}return true;}if(this._bHSLMode){this.Color.formatHSL=false;}return false;};
k.prototype._parseColorName=function(C){return l.Colors[C];};
k.prototype.onAfterRendering=function(){var d=this._getCSSColorString();this.$CPBox=this.oCPBox.$();this.$CPCur=this.oCPBox.getHandle();this.$("ncBox").css('background-color',d);this.$("ocBox").css('background-color',d);this._updateGradientBoxBackground(this.Color.h);this._iCPBoxSize=this.oCPBox.getWidth();this._updateCursorPosition();if(this._bHSLMode){this._updateAlphaBackground();}this.oSlider.iShiftGrip=Math.round(q(this.oSlider.oGrip).outerWidth()/2);this.oAlphaSlider.iShiftGrip=Math.round(q(this.oAlphaSlider.oGrip).outerWidth()/2);};
k.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b};};
k.prototype._getConstants=function(){return l;};
return k;});
sap.ui.predefine('sap/ui/unified/ColorPickerRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_grid"));r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/ContentSwitcher',['jquery.sap.global','sap/ui/core/Control','./library',"./ContentSwitcherRenderer"],function(q,C,l,a){"use strict";var b=l.ContentSwitcherAnimation;
var c=C.extend("sap.ui.unified.ContentSwitcher",{metadata:{deprecated:true,library:"sap.ui.unified",properties:{animation:{type:"string",group:"Appearance",defaultValue:'None'},activeContent:{type:"int",group:"Behavior",defaultValue:1}},aggregations:{content1:{type:"sap.ui.core.Control",multiple:true,singularName:"content1"},content2:{type:"sap.ui.core.Control",multiple:true,singularName:"content2"}}}});
(function(w){
c.prototype.init=function(){};
c.prototype.switchContent=function(){this.setActiveContent(this.getActiveContent()==1?2:1);return this;};
c.prototype.onAfterRendering=function(){this._$Contents=[this.$("content1"),this.$("content2")];};
c.prototype._showActiveContent=function(n){if(this._$Contents){this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible",n===1);this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible",n===2);}};
c.prototype.setActiveContent=function(n){n=parseInt(n,10);if(isNaN(n)||n<1){n=1;q.sap.log.warning("setActiveContent argument must be either 1 or 2. Active content set to 1.");}else if(n>2){n=2;q.sap.log.warning("setActiveContent argument must be either 1 or 2. Active content set to 2.");}this.setProperty("activeContent",n,true);this._showActiveContent(n);return this;};
c.prototype.setAnimation=function(A,s){if(typeof(A)!=="string"){A=b.None;q.sap.log.warning("setAnimation argument must be a string. Animation was set to \""+b.None+"\".");}A=A.replace(/[^a-zA-Z0-9]/g,"");var d=this.getProperty("animation");if(A===d){return this;}var D=this.$();if(D[0]){D.toggleClass("sapUiUfdCSwitcherAnimation"+d,false);D.toggleClass("sapUiUfdCSwitcherAnimation"+A,true);}return this.setProperty("animation",A,s);};
})(window);return c;});
sap.ui.predefine('sap/ui/unified/ContentSwitcherRenderer',['jquery.sap.global','sap/ui/unified/library'],function(q,l){"use strict";var C=l.ContentSwitcherAnimation;var a={};
a.render=function(r,c){var i=c.getId();var A=c.getAnimation();if(!sap.ui.getCore().getConfiguration().getAnimation()){A=C.None;}var b=c.getActiveContent();r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdCSwitcher");r.addClass("sapUiUfdCSwitcherAnimation"+q.sap.encodeHTML(A));r.writeClasses();r.write(">");r.write("<section id=\""+i+"-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1"+(b==1?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent1());r.write("</section>");r.write("<section id=\""+i+"-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2"+(b==2?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent2());r.write("</section>");r.write("</div>");};
a.renderContent=function(r,c){for(var i=0;i<c.length;++i){r.renderControl(c[i]);}};
return a;},true);
sap.ui.predefine('sap/ui/unified/Currency',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/format/NumberFormat',"./CurrencyRenderer"],function(q,C,N,a){"use strict";
var b=C.extend("sap.ui.unified.Currency",{metadata:{library:"sap.ui.unified",properties:{value:{type:"float",group:"Appearance",defaultValue:0},stringValue:{type:"string",group:"Appearance",defaultValue:null},currency:{type:"string",group:"Appearance",defaultValue:null},maxPrecision:{type:"int",group:"Appearance",defaultValue:3},useSymbol:{type:"boolean",group:"Appearance",defaultValue:true}},designtime:"sap/ui/unified/designtime/Currency.designtime"}});
b.FIGURE_SPACE='\u2007';b.PUNCTUATION_SPACE='\u2008';
b.prototype.init=function(){this._oFormat=N.getCurrencyInstance({showMeasure:false});};
b.prototype.exit=function(){this._oFormat=null;this._$Value=null;this._$Currency=null;this._sLastCurrency=null;this._iLastCurrencyDigits=null;this._bRenderNoValClass=null;};
b.prototype.onAfterRendering=function(){if(this.$()){this._$Value=this.$().find(".sapUiUfdCurrencyValue");this._$Currency=this.$().find(".sapUiUfdCurrencyCurrency");}};
b.prototype.setValue=function(v){if(this.isBound("value")){this._bRenderNoValClass=v==null;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",this._bRenderNoValClass);}}this.setProperty("value",v,true);this._renderValue();return this;};
b.prototype.unbindProperty=function(p){C.prototype.unbindProperty.apply(this,arguments);if(p==="value"){this._bRenderNoValClass=false;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}};
b.prototype.setCurrency=function(v){var c,r;this.setProperty("currency",v,true);this._renderCurrency();c=this._oFormat.oLocaleData.getCurrencyDigits(v);if(q.isNumeric(this._iLastCurrencyDigits)&&this._iLastCurrencyDigits!==c){r=true;}this._iLastCurrencyDigits=c;if(this._sLastCurrency==="*"||v==="*"){r=true;}this._sLastCurrency=v;if(r){this._renderValue();if(v==="*"&&this.$()){this._bRenderNoValClass=false;this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}return this;};
b.prototype.setUseSymbol=function(v){this.setProperty("useSymbol",v,true);this._renderCurrency();return this;};
b.prototype.setMaxPrecision=function(v){this.setProperty("maxPrecision",v,true);this._renderValue();return this;};
b.prototype._renderValue=function(){if(this._$Value){this._$Value.text(this.getFormattedValue());}};
b.prototype._renderCurrency=function(){if(this._$Currency){this._$Currency.text(this._getCurrency());}};
b.prototype._getCurrency=function(){return this.getUseSymbol()?this.getCurrencySymbol():this.getCurrency();};
b.prototype.getFormattedValue=function(){var c=this.getCurrency(),m,p,i,f;if(c==="*"){return"";}i=this._oFormat.oLocaleData.getCurrencyDigits(c);m=this.getMaxPrecision();m=(m<=0&&i>0?m-1:m);p=m-i;f=this._oFormat.format(this.getStringValue()||this.getValue(),c);if(p==m&&m>0){f+=b.PUNCTUATION_SPACE;}if(p>0){f=q.sap.padRight(f,b.FIGURE_SPACE,f.length+p);}else if(p<0){f=f.substr(0,f.length+p);}return f;};
b.prototype.getCurrencySymbol=function(){return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency());};
b.prototype.getAccessibilityInfo=function(){if(this._bRenderNoValClass){return{};}return{description:(this.getFormattedValue()||"")+" "+(this.getCurrency()||"").trim()};};
return b;});
sap.ui.predefine('sap/ui/unified/CurrencyRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){var t=c.getTooltip_AsString();r.write("<div");r.writeControlData(c);if(t){r.writeAttributeEscaped("title",t);}r.addClass("sapUiUfdCurrency");if(c._bRenderNoValClass){r.addClass("sapUiUfdCurrencyNoVal");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUfdCurrencyAlign");r.writeClasses();r.write(">");r.write("<span");r.writeAttribute("dir","ltr");r.addClass("sapUiUfdCurrencyValue");r.writeClasses();r.write(">");r.writeEscaped(c.getFormattedValue());r.write("</span>");r.write("<span");r.addClass("sapUiUfdCurrencyCurrency");r.writeClasses();r.write(">");r.writeEscaped(c._getCurrency());r.write("</span>");r.write("</div>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/DateRange',['sap/ui/core/Element','./library','sap/ui/unified/calendar/CalendarUtils'],function(E,l,C){"use strict";
var D=E.extend("sap.ui.unified.DateRange",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Misc",defaultValue:null},endDate:{type:"object",group:"Misc",defaultValue:null}}}});
D.prototype.setStartDate=function(d){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("startDate",d);return this;};
D.prototype.setEndDate=function(d){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("endDate",d);return this;};
return D;});
sap.ui.predefine('sap/ui/unified/DateTypeRange',['./DateRange','./library'],function(D,l){"use strict";var C=l.CalendarDayType;
var a=D.extend("sap.ui.unified.DateTypeRange",{metadata:{library:"sap.ui.unified",properties:{type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.Type01}}}});
return a;});
sap.ui.predefine('sap/ui/unified/FileUploader',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/core/LabelEnablement','sap/ui/core/library','sap/ui/Device',"./FileUploaderRenderer",'jquery.sap.keycodes'],function(q,C,a,L,c,D,F){"use strict";var V=c.ValueState;
var b=C.extend("sap.ui.unified.FileUploader",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.unified.IProcessableBlobs"],library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/FileUploader.designtime",properties:{value:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"sap.ui.core.URI",group:"Data",defaultValue:''},name:{type:"string",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:''},uploadOnChange:{type:"boolean",group:"Behavior",defaultValue:false},additionalData:{type:"string",group:"Data",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},buttonText:{type:"string",group:"Misc",defaultValue:null},fileType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},sendXHR:{type:"boolean",group:"Behavior",defaultValue:false},placeholder:{type:"string",group:"Appearance",defaultValue:null},style:{type:"string",group:"Appearance",defaultValue:null},buttonOnly:{type:"boolean",group:"Appearance",defaultValue:false},useMultipart:{type:"boolean",group:"Behavior",defaultValue:true},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconHovered:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconSelected:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},iconOnly:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{parameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"parameter"},headerParameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"headerParameter"},xhrSettings:{type:"sap.ui.unified.FileUploaderXHRSettings",multiple:false}},events:{change:{parameters:{newValue:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{fileName:{type:"string"},response:{type:"string"},readyStateXHR:{type:"string"},status:{type:"string"},responseRaw:{type:"string"},headers:{type:"object"},requestHeaders:{type:"object[]"}}},typeMissmatch:{parameters:{fileName:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"}}},fileSizeExceed:{parameters:{fileName:{type:"string"},fileSize:{type:"string"}}},fileAllowed:{},uploadProgress:{parameters:{lengthComputable:{type:"boolean"},loaded:{type:"float"},total:{type:"float"},fileName:{type:"string"},requestHeaders:{type:"object[]"}}},uploadAborted:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}},filenameLengthExceed:{parameters:{fileName:{type:"string"}}},uploadStart:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}}}}});
b.prototype.init=function(){this.oFilePath=a.FileUploaderHelper.createTextField(this.getId()+"-fu_input");this.oBrowse=a.FileUploaderHelper.createButton();this.oFilePath.setParent(this);this.oBrowse.setParent(this);this.oFileUpload=null;this.bMobileLib=this.oBrowse.getMetadata().getName()=="sap.m.Button";if(!this.getIconOnly()){this.oBrowse.setText(this.getBrowseText());}else{this.oBrowse.setTooltip(this.getBrowseText());}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(!b.prototype._sAccText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");b.prototype._sAccText=r.getText("FILEUPLOAD_ACC");}if(this.oBrowse.addAriaDescribedBy){this.oBrowse.addAriaDescribedBy(this.getId()+"-AccDescr");}}};
b.prototype.setButtonText=function(t){this.setProperty("buttonText",t,false);if(!this.getIconOnly()){this.oBrowse.setText(t||this.getBrowseText());}else{this.oBrowse.setTooltip(t||this.getBrowseText());}return this;};
b.prototype.setIcon=function(i){this.oBrowse.setIcon(i);this.setProperty("icon",i,false);return this;};
b.prototype.setIconHovered=function(i){this.setProperty("iconHovered",i,false);if(this.oBrowse.setIconHovered){this.oBrowse.setIconHovered(i);}return this;};
b.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,false);if(this.oBrowse.setIconSelected){this.oBrowse.setIconSelected(i);}else{this.oBrowse.setActiveIcon(i);}return this;};
b.prototype.setIconFirst=function(i){this.oBrowse.setIconFirst(i);this.setProperty("iconFirst",i,false);return this;};
b.prototype.setIconOnly=function(i){this.setProperty("iconOnly",i,false);if(i){this.oBrowse.setText("");this.oBrowse.setTooltip(this.getButtonText()||this.getBrowseText());}else{this.oBrowse.setText(this.getButtonText()||this.getBrowseText());this.oBrowse.setTooltip("");}return this;};
b.prototype.getIdForLabel=function(){return this.oBrowse.getId();};
b.prototype.setFileType=function(t){var T=this._convertTypesToArray(t);this.setProperty("fileType",T,false);return this;};
b.prototype.setMimeType=function(t){var T=this._convertTypesToArray(t);this.setProperty("mimeType",T,false);return this;};
b.prototype.setTooltip=function(t){var T,s;this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(this.oFileUpload){if(typeof t==="string"){T=this.getTooltip_AsString();s=this.$().find(".sapUiFupInputMask")[0];if(T){this.oFileUpload.setAttribute("title",T);s&&s.setAttribute("title",T);}else{this.oFileUpload.removeAttribute("title");s&&s.removeAttribute("title");}}}return this;};
b.prototype.setXhrSettings=function(x){this.setAggregation("xhrSettings",x,true);return this;};
b.prototype._convertTypesToArray=function(t){if(typeof t==="string"){if(t===""){return[];}else{return t.split(",").map(function(T){return T.trim();});}}return t;};
b.prototype.exit=function(){this.oFilePath.destroy();this.oBrowse.destroy();if(this.oIFrameRef){q(this.oIFrameRef).unbind();sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef);this.oIFrameRef=null;}};
b.prototype.onBeforeRendering=function(){var s=sap.ui.getCore().getStaticAreaRef();q(this.oFileUpload).appendTo(s);q(this.oFileUpload).unbind();};
b.prototype.onAfterRendering=function(){this.prepareFileUploadAndIFrame();this._cacheDOMEls();this._addLabelFeaturesToBrowse();q(this.oFileUpload).change(q.proxy(this.handlechange,this));if(!this.bMobileLib){this.oFilePath.$().attr("tabindex","-1");}else{this.oFilePath.$().find('input').attr("tabindex","-1");}if((!!D.browser.internet_explorer&&D.browser.version==9)){this.oBrowse.$().attr("tabindex","-1");}if(L.isRequired(this)){this.oBrowse.$().attr("aria-required","true");}q.sap.delayedCall(0,this,this._recalculateWidth);this.oFilePath.$().find('input').removeAttr("role").attr("aria-live","polite");if(this.getValueState()==V.Error){this.oBrowse.$().attr("aria-invalid","true");}};
b.prototype._cacheDOMEls=function(){this.FUEl=this.getDomRef("fu");this.FUDataEl=this.getDomRef("fu_data");};
b.prototype.onfocusin=function(e){if(!this.oFilePath.shouldValueStateMessageBeOpened||this.oFilePath.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
b.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this.closeValueStateMessage();}};
b.prototype._recalculateWidth=function(){if(this.getWidth()){if(this.getButtonOnly()&&this.oBrowse.getDomRef()){this.oBrowse.getDomRef().style.width=this.getWidth();}this._resizeDomElements();}};
b.prototype.getFocusDomRef=function(){return this.$("fu").get(0);};
b.prototype._resizeDomElements=function(){var i=this.getId();this._oBrowseDomRef=this.oBrowse.getDomRef();var $=q(this._oBrowseDomRef);var _=$.parent().outerWidth(true);this._oFilePathDomRef=this.oFilePath.getDomRef();var d=this._oFilePathDomRef;var w=this.getWidth();if(w.substr(-1)=="%"&&d){while(d.id!=i){d.style.width="100%";d=d.parentNode;}d.style.width=w;}else{if(d){d.style.width=w;var e=q(this._oFilePathDomRef);var f=e.outerWidth()-_;if(f<0){this.oFilePath.getDomRef().style.width="0px";if(!D.browser.internet_explorer){this.oFileUpload.style.width=$.outerWidth(true);}}else{this.oFilePath.getDomRef().style.width=f+"px";}}}};
b.prototype.onresize=function(){this._recalculateWidth();};
b.prototype.onThemeChanged=function(){this._recalculateWidth();};
b.prototype.setEnabled=function(e){var $=q(this.oFileUpload);this.setProperty("enabled",e,true);this.oFilePath.setEnabled(e);this.oBrowse.setEnabled(e);e?$.removeAttr('disabled'):$.attr('disabled','disabled');this.$().toggleClass("sapUiFupDisabled",!e);return this;};
b.prototype.setValueState=function(v){this.setProperty("valueState",v,true);if(this.oFilePath.setValueState){this.oFilePath.setValueState(v);}else{q.sap.log.warning("Setting the valueState property with the combination of libraries used is not supported.",this);}if(this.oBrowse.getDomRef()){if(v==V.Error){this.oBrowse.$().attr("aria-invalid","true");}else{this.oBrowse.$().removeAttr("aria-invalid");}}if(q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){switch(v){case V.Error:case V.Warning:case V.Success:this.openValueStateMessage();break;default:this.closeValueStateMessage();}}return this;};
b.prototype.setValueStateText=function(v){if(this.oFilePath.setValueStateText){this.oFilePath.setValueStateText(v);}else{q.sap.log.warning("Setting the valueStateText property with the combination of libraries used is not supported.",this);}return this.setProperty("valueStateText",v,true);};
b.prototype.setUploadUrl=function(v,f){this.setProperty("uploadUrl",v,true);var $=this.$("fu_form");$.attr("action",this.getUploadUrl());return this;};
b.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);this.oFilePath.setPlaceholder(p);return this;};
b.prototype.setStyle=function(s){this.setProperty("style",s,true);if(s){if(s=="Transparent"){if(this.oBrowse.setLite){this.oBrowse.setLite(true);}else{this.oBrowse.setType("Transparent");}}else{if(this.oBrowse.setType){this.oBrowse.setType(s);}else{if(s=="Emphasized"){s="Emph";}this.oBrowse.setStyle(s);}}}return this;};
b.prototype.setValue=function(v,f,s){var o=this.getValue();var d;if((o!=v)||this.getSameFilenameAllowed()){var u=this.getUploadOnChange()&&v;this.setProperty("value",v,u);if(this.oFilePath){this.oFilePath.setValue(v);if(this.oBrowse.getDomRef()&&!s&&q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}}var e=this.getDomRef("fu_form"),g=this.getDomRef("fu_input-inner");if(this.oFileUpload&&e&&!v){e.reset();this.getDomRef("fu_input").value="";if(g){g.value="";}q(this.FUDataEl).val(this.getAdditionalData());}if(f){if(window.File){d=this.FUEl.files;}if(!this.getSameFilenameAllowed()||v){this.fireChange({id:this.getId(),newValue:v,files:d});}}if(u){this.upload();}}return this;};
b.prototype.clear=function(){var u=this.getDomRef("fu_form");if(u){u.reset();}return this.setValue("",false,true);};
b.prototype.onmousedown=function(e){if(!this.bMobileLib){this.oBrowse.onmousedown(e);}};
b.prototype.onmouseup=function(e){if(!this.bMobileLib){this.oBrowse.onmouseup(e);}};
b.prototype.onmouseover=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).addClass('sapUiBtnStdHover');this.oBrowse.onmouseover(e);}};
b.prototype.onmouseout=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdHover');this.oBrowse.onmouseout(e);}};
b.prototype.setAdditionalData=function(A){this.setProperty("additionalData",A,true);var o=this.FUDataEl;if(o){A=this.getAdditionalData()||"";o.value=A;}return this;};
b.prototype.sendFiles=function(x,I){var t=this;var A=true;for(var i=0;i<x.length;i++){if(!x[i].bPosted){A=false;break;}}if(A){if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){t.setValue("",true);}return;}var X=x[I];var f=X.file.name?X.file.name:"MultipartFile";if((D.browser.edge||D.browser.internet_explorer)&&X.file.type&&X.xhr.readyState==1){var s=X.file.type;X.xhr.setRequestHeader("Content-Type",s);X.requestHeaders.push({name:"Content-Type",value:s});}var r=X.requestHeaders;var p=function(P){var o={lengthComputable:!!P.lengthComputable,loaded:P.loaded,total:P.total};t.fireUploadProgress({"lengthComputable":o.lengthComputable,"loaded":o.loaded,"total":o.total,"fileName":f,"requestHeaders":r});};X.xhr.upload.addEventListener("progress",p);X.xhr.onreadystatechange=function(){var R;var d;var h={};var P;var H;var e;var g;g=X.xhr.readyState;var S=X.xhr.status;if(X.xhr.readyState==4){if(X.xhr.responseXML){R=X.xhr.responseXML.documentElement.textContent;}d=X.xhr.response;P=X.xhr.getAllResponseHeaders();if(P){H=P.split("\u000d\u000a");for(var i=0;i<H.length;i++){if(H[i]){e=H[i].indexOf("\u003a\u0020");h[H[i].substring(0,e)]=H[i].substring(e+2);}}}t.fireUploadComplete({"fileName":f,"headers":h,"response":R,"responseRaw":d,"readyStateXHR":g,"status":S,"requestHeaders":r});}t._bUploading=false;};if(X.xhr.readyState===0||X.bPosted){I++;t.sendFiles(x,I);}else{X.xhr.send(X.file);X.bPosted=true;I++;t.sendFiles(x,I);}};
b.prototype.upload=function(p){if(!this.getEnabled()){return;}var u=this.getDomRef("fu_form");try{this._bUploading=true;if(this.getSendXHR()&&window.File){var f=this.FUEl.files;if(p){this._sendProcessedFilesWithXHR(f);}else{this._sendFilesWithXHR(f);}}else if(u){u.submit();this._resetValueAfterUploadStart();}}catch(e){q.sap.log.error("File upload failed:\n"+e.message);}};
b.prototype.abort=function(h,H){if(!this.getUseMultipart()){var s=this._aXhr.length-1;for(var i=s;i>-1;i--){if(h&&H){for(var j=0;j<this._aXhr[i].requestHeaders.length;j++){var d=this._aXhr[i].requestHeaders[j].name;var v=this._aXhr[i].requestHeaders[j].value;if(d==h&&v==H){this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);q.sap.log.info("File upload aborted.");break;}}}else{this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);q.sap.log.info("File upload aborted.");}}}else if(this._uploadXHR&&this._uploadXHR.abort){this._uploadXHR.abort();this.fireUploadAborted({"fileName":null,"requestHeaders":null});q.sap.log.info("File upload aborted.");}};
b.prototype.onkeypress=function(e){this.onkeydown(e);};
b.prototype.onclick=function(e){if(this.getSameFilenameAllowed()&&this.getEnabled()){this.setValue("",true);}if(this.oBrowse.getDomRef()&&q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}};
b.prototype.onkeydown=function(e){if(!this.getEnabled()){return;}if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true);}var k=e.keyCode,d=q.sap.KeyCodes;if(k==d.DELETE||k==d.BACKSPACE){if(this.oFileUpload){this.setValue("",true);}}else if(k==d.SPACE||k==d.ENTER){if(!(!!D.browser.internet_explorer&&D.browser.version<=9)&&this.oFileUpload){this.oFileUpload.click();e.preventDefault();e.stopPropagation();}}else if(k!=d.TAB&&k!=d.SHIFT&&k!=d.F6&&k!=d.PAGE_UP&&k!=d.PAGE_DOWN&&k!=d.END&&k!=d.HOME&&k!=d.ARROW_LEFT&&k!=d.ARROW_UP&&k!=d.ARROW_RIGHT&&k!=d.ARROW_DOWN){e.preventDefault();e.stopPropagation();}};
b.prototype._isFilenameTooLong=function(f){var m=this.getMaximumFilenameLength();if(m!==0&&f.length>m){q.sap.log.info("The filename of "+f+" ("+f.length+" characters)  is longer than the maximum of "+m+" characters.");return true;}return false;};
b.prototype.handlechange=function(e){if(this.oFileUpload&&this.getEnabled()){var f=this.getFileType();var s='';var w,n,i,d;var u=this.getDomRef("fu_form");if(window.File){var g=e.target.files;if(this._areFilesAllowed(g)){this.fireFileAllowed();s=this._generateInputValue(g);}else{u.reset();this.setValue("",true,true);return;}}else if(f&&f.length>0){w=true;n=this.oFileUpload.value||"";i=n.lastIndexOf(".");d=n.substring(i+1);for(var l=0;l<f.length;l++){if(d==f[l]){w=false;}}if(w){q.sap.log.info("File: "+n+" is of type "+d+". Allowed types are: "+f+".");this.fireTypeMissmatch({fileName:n,fileType:d});u.reset();this.setValue("",true,true);return;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});u.reset();this.setValue("",true,true);return;}if(n){this.fireFileAllowed();}}var v=this.oFileUpload.value||"";var I=v.lastIndexOf("\\");if(I>=0){v=v.substring(I+1);}if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){v=s;}}if(v||D.browser.chrome){this.setValue(v,true);}}};
b.prototype._sendFilesWithXHR=function(f){var d,h,v,x,X=this.getXhrSettings();if(f.length>0){if(this.getUseMultipart()){d=1;}else{d=f.length;}this._aXhr=this._aXhr||[];for(var j=0;j<d;j++){this._uploadXHR=new window.XMLHttpRequest();x={xhr:this._uploadXHR,requestHeaders:[]};this._aXhr.push(x);x.xhr.open("POST",this.getUploadUrl(),true);if(X){x.xhr.withCredentials=X.getWithCredentials();}if(this.getHeaderParameters()){var H=this.getHeaderParameters();for(var i=0;i<H.length;i++){h=H[i].getName();v=H[i].getValue();x.requestHeaders.push({name:h,value:v});}}var s=f[j].name;var r=x.requestHeaders;x.fileName=s;x.file=f[j];this.fireUploadStart({"fileName":s,"requestHeaders":r});for(var k=0;k<r.length;k++){if(x.xhr.readyState===0){break;}h=r[k].name;v=r[k].value;x.xhr.setRequestHeader(h,v);}}if(this.getUseMultipart()){var e=new window.FormData();var n=this.FUEl.name;for(var l=0;l<f.length;l++){this._appendFileToFormData(e,n,f[l]);}e.append("_charset_","UTF-8");var g=this.FUDataEl.name;if(this.getAdditionalData()){var o=this.getAdditionalData();e.append(g,o);}else{e.append(g,"");}if(this.getParameters()){var p=this.getParameters();for(var m=0;m<p.length;m++){var N=p[m].getName();v=p[m].getValue();e.append(N,v);}}x.file=e;this.sendFiles(this._aXhr,0);}else{this.sendFiles(this._aXhr,0);}this._bUploading=false;this._resetValueAfterUploadStart();}return this;};
b.prototype._appendFileToFormData=function(f,s,o){if(o instanceof window.Blob&&o.name){f.append(s,o,o.name);}else{f.append(s,o);}};
b.prototype._sendProcessedFilesWithXHR=function(f){this.getProcessedBlobsFromArray(f).then(function(B){this._sendFilesWithXHR(B);}.bind(this)).catch(function(r){q.sap.log.error("File upload failed: "+r&&r.message?r.message:"no details available");});return this;};
b.prototype._areFilesAllowed=function(f){var n,w,I,s,t,m=this.getMaximumFileSize(),M=this.getMimeType(),d=this.getFileType();for(var i=0;i<f.length;i++){n=f[i].name;t=f[i].type;if(!t){t="unknown";}var S=((f[i].size/1024)/1024);if(m&&(S>m)){q.sap.log.info("File: "+n+" is of size "+S+" MB which exceeds the file size limit of "+m+" MB.");this.fireFileSizeExceed({fileName:n,fileSize:S});return false;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});return false;}if(M&&M.length>0){var W=true;for(var j=0;j<M.length;j++){if(t==M[j]||M[j]=="*/*"||t.match(M[j])){W=false;}}if(W){q.sap.log.info("File: "+n+" is of type "+t+". Allowed types are: "+M+".");this.fireTypeMissmatch({fileName:n,mimeType:t});return false;}}if(d&&d.length>0){w=true;I=n.lastIndexOf(".");s=n.substring(I+1);for(var k=0;k<d.length;k++){if(s.toLowerCase()==d[k].toLowerCase()){w=false;}}if(w){q.sap.log.info("File: "+n+" is of type "+s+". Allowed types are: "+d+".");this.fireTypeMissmatch({fileName:n,fileType:s});return false;}}}return true;};
b.prototype._sendFilesFromDragAndDrop=function(f){if(this._areFilesAllowed(f)){this._sendFilesWithXHR(f);}return this;};
b.prototype._generateInputValue=function(f){var s="";for(var i=0;i<f.length;i++){s=s+'"'+f[i].name+'" ';}return s;};
b.prototype.getBrowseText=function(){if(!b.prototype._sBrowseText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");b.prototype._sBrowseText=r.getText("FILEUPLOAD_BROWSE");}return b.prototype._sBrowseText?b.prototype._sBrowseText:"Browse...";};
b.prototype.getShortenValue=function(){return this.getValue();};
b.prototype.prepareFileUploadAndIFrame=function(){if(!this.oFileUpload){var f=[];f.push('<input ');f.push('type="file" ');f.push('aria-hidden="true" ');if(this.getName()){if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){f.push('name="'+this.getName()+'[]" ');}}else{f.push('name="'+this.getName()+'" ');}}else{if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){f.push('name="'+this.getId()+'[]" ');}}else{f.push('name="'+this.getId()+'" ');}}f.push('id="'+this.getId()+'-fu" ');if(!(!!D.browser.internet_explorer&&D.browser.version==9)){f.push('tabindex="-1" ');}f.push('size="1" ');if(this.getTooltip_AsString()){f.push('title="'+q.sap.encodeHTML(this.getTooltip_AsString())+'" ');}else if(this.getValue()!==""){f.push('title="'+q.sap.encodeHTML(this.getValue())+'" ');}if(!this.getEnabled()){f.push('disabled="disabled" ');}if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){f.push('multiple ');}}if(this.getMimeType()&&window.File){var m=this.getMimeType();var M=m.join(",");f.push('accept="'+M+'" ');}f.push('>');this.oFileUpload=q(f.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0);}else{q(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"));}if(!this.oIFrameRef){var i=document.createElement("iframe");i.style.display="none";i.id=this.sId+"-frame";sap.ui.getCore().getStaticAreaRef().appendChild(i);i.contentWindow.name=this.sId+"-frame";var t=this;this._bUploading=false;q(i).load(function(e){if(t._bUploading){q.sap.log.info("File uploaded to "+t.getUploadUrl());var r;try{r=t.oIFrameRef.contentDocument.body.innerHTML;}catch(d){}t.fireUploadComplete({"response":r});t._bUploading=false;}});this.oIFrameRef=i;}};
b.prototype.openValueStateMessage=function(){if(this.oFilePath.openValueStateMessage){this.oFilePath.openValueStateMessage();this.oBrowse.$().addAriaDescribedBy(this.oFilePath.getId()+"-message");}};
b.prototype.closeValueStateMessage=function(){if(this.oFilePath.closeValueStateMessage){this.oFilePath.closeValueStateMessage();this.oBrowse.$().removeAriaDescribedBy(this.oFilePath.getId()+"-message");}};
b.prototype._resetValueAfterUploadStart=function(){q.sap.log.info("File uploading to "+this.getUploadUrl());if(this.getSameFilenameAllowed()&&this.getUploadOnChange()&&this.getUseMultipart()){this.setValue("",true);}};
b.prototype._addLabelFeaturesToBrowse=function(){var $;if(this.oBrowse&&this.oBrowse.$().length){$=this.oBrowse.$();$.attr("type', 'button");$.click(function(e){e.preventDefault();this.FUEl.click();}.bind(this));}};
b.prototype.getProcessedBlobsFromArray=function(B){return new Promise(function(r){r(B);});};
return b;});
sap.ui.predefine('sap/ui/unified/FileUploaderParameter',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderParameter",{metadata:{library:"sap.ui.unified",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
return F;});
sap.ui.predefine('sap/ui/unified/FileUploaderRenderer',['jquery.sap.global','sap/ui/unified/library'],function(q,l){"use strict";var F=function(){};
F.render=function(r,f){var a=sap.ui.getCore().getConfiguration().getAccessibility(),e=f.getEnabled();r.write('<div');r.writeControlData(f);r.addClass("sapUiFup");if(f.getButtonOnly()){r.addClass("sapUiFupButtonOnly");}var c=l.FileUploaderHelper.addFormClass();if(c){r.addClass(c);}if(!e){r.addClass("sapUiFupDisabled");}r.writeClasses();r.write('>');r.write('<form style="display:inline-block" encType="multipart/form-data" method="post"');r.writeAttribute('id',f.getId()+'-fu_form');r.writeAttributeEscaped('action',f.getUploadUrl());r.writeAttribute('target',f.getId()+'-frame');r.write('>');r.write('<div ');if(!f.bMobileLib){r.write('class="sapUiFupInp"');}if(a){r.writeAttribute("role","textbox");r.writeAttribute("aria-readonly","true");}r.write('>');if(!f.getButtonOnly()){r.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div>');}else{r.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div style="display:none">');}r.renderControl(f.oFilePath);r.write('</div><div>');r.renderControl(f.oBrowse);var A;var t="";if(f.getTooltip()){t=f.getTooltip_AsString();}var p="";if(f.getPlaceholder()){p=f.getPlaceholder();}var v="";if(f.getValue()){v=f.getValue();}var b="";if(f.getButtonText()){b=f.getButtonText();}else{b=f.getBrowseText();}if(!v){A=t+" "+p+" "+b;}else{A=t+" "+v+" "+b;}r.write('<span id="'+f.getId()+'-AccDescr" class="sapUiInvisibleText" aria-hidden="true">');r.writeEscaped(A+" "+f._sAccText);r.write('</span>');r.write('</div></div></div>');var n=f.getName()||f.getId();r.write('<div class="sapUiFupInputMask"');if(t&&t.length){r.writeAttributeEscaped('title',t);}r.write('>');r.write('<input type="hidden" name="_charset_" aria-hidden="true">');r.write('<input type="hidden" id="'+f.getId()+'-fu_data" aria-hidden="true"');r.writeAttributeEscaped('name',n+'-data');r.writeAttributeEscaped('value',f.getAdditionalData()||"");r.write('>');q.each(f.getParameters(),function(i,P){r.write('<input type="hidden" aria-hidden="true" ');r.writeAttributeEscaped('name',P.getName()||"");r.writeAttributeEscaped('value',P.getValue()||"");r.write('>');});r.write('</div>');r.write('</div>');r.write('</form>');r.write('</div>');};
return F;},true);
sap.ui.predefine('sap/ui/unified/FileUploaderXHRSettings',['sap/ui/core/Element','./library'],function(E){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderXHRSettings",{metadata:{library:"sap.ui.unified",properties:{withCredentials:{type:"boolean",group:"Data",defaultValue:false}}}});
return F;});
sap.ui.predefine('sap/ui/unified/MenuItem',['sap/ui/core/IconPool','./MenuItemBase','./library'],function(I,M,l){"use strict";
var a=M.extend("sap.ui.unified.MenuItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Appearance",defaultValue:''},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''}}}});
I.getIconInfo("","");
a.prototype.render=function(r,i,m,o){var b=r;var s=i.getSubmenu();b.write("<li ");var c="sapUiMnuItm";if(o.iItemNo==1){c+=" sapUiMnuItmFirst";}else if(o.iItemNo==o.iTotalItems){c+=" sapUiMnuItmLast";}if(!m.checkEnabled(i)){c+=" sapUiMnuItmDsbl";}if(i.getStartsSection()){c+=" sapUiMnuItmSepBefore";}b.writeAttribute("class",c);if(i.getTooltip_AsString()){b.writeAttributeEscaped("title",i.getTooltip_AsString());}b.writeElementData(i);if(o.bAccessible){b.writeAccessibilityState(i,{role:"menuitem",disabled:!m.checkEnabled(i),posinset:o.iItemNo,setsize:o.iTotalItems,labelledby:{value:this.getId()+"-txt "+this.getId()+"-scuttxt",append:true}});if(s){b.writeAttribute("aria-haspopup",true);b.writeAttribute("aria-owns",s.getId());}}b.write("><div class=\"sapUiMnuItmL\"></div>");b.write("<div class=\"sapUiMnuItmIco\">");if(i.getIcon()){b.writeIcon(i.getIcon(),null,{title:null});}b.write("</div>");b.write("<div id=\""+this.getId()+"-txt\" class=\"sapUiMnuItmTxt\">");b.writeEscaped(i.getText());b.write("</div>");b.write("<div id=\""+this.getId()+"-scuttxt\" class=\"sapUiMnuItmSCut\"></div>");b.write("<div class=\"sapUiMnuItmSbMnu\">");if(s){b.write("<div class=\"sapUiIconMirrorInRTL\"></div>");}b.write("</div>");b.write("<div class=\"sapUiMnuItmR\"></div>");b.write("</li>");};
a.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);};
return a;});
sap.ui.predefine('sap/ui/unified/MenuItemBase',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var M=E.extend("sap.ui.unified.MenuItemBase",{metadata:{library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"submenu",aggregations:{submenu:{type:"sap.ui.unified.Menu",multiple:false}},events:{select:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
M.prototype.init=function(){};
M.prototype.render=function(r,i,m){var a=r;a.write("<li");a.writeElementData(i);a.write("><div style=\"white-space:nowrap;display:inline-block;padding:1px;color:black;\" id=\""+this.getId()+"-txt\">");a.write(i.getId());if(this.getSubmenu()){a.write("&nbsp;&nbsp;->");}a.write("</div></li>");};
M.prototype.hover=function(h,m){this.$("txt").attr("style",h?"white-space:nowrap;display:inline-block;padding:1px;color:red;":"white-space:nowrap;display:inline-block;padding:1px;color:black;");};
M.prototype.onSubmenuToggle=function(o){this.$().toggleClass("sapUiMnuItmSubMnuOpen",o);};
M.prototype.onAfterRendering=function(){};
M.prototype.onmouseover=function(e){var p=this.getParent();if(p&&p instanceof sap.ui.unified.Menu&&this.getTooltip()instanceof sap.ui.core.TooltipBase){p.onmouseover(e);}};
return M;});
sap.ui.predefine('sap/ui/unified/MenuRenderer',[],function(){"use strict";var M={};
M.render=function(r,m){if(m.oHoveredItem&&m.indexOfItem(m.oHoveredItem)<0){m.oHoveredItem=null;}r.write("<div tabindex=\"-1\" hideFocus=\"true\"");if(m.getTooltip_AsString()){r.writeAttributeEscaped("title",m.getTooltip_AsString());}var a=sap.ui.getCore().getConfiguration().getAccessibility();if(a){r.writeAccessibilityState(m,{role:"menu",disabled:null,labelledby:{value:m.getId()+"-label",append:true}});if(m.oHoveredItem){r.writeAttribute("aria-activedescendant",m.oHoveredItem.getId());}}r.addClass("sapUiMnu");var R=m.getRootMenu();if(R.bUseTopStyle){r.addClass("sapUiMnuTop");}if(R.isCozy()){r.addClass("sapUiSizeCozy");}if(m.bCozySupported){r.addClass("sapUiMnuCozySupport");}r.writeClasses();r.writeControlData(m);r.write(">");M.renderItems(r,m);if(a){r.write("<span id='",m.getId(),"-label' class='sapUiInvisibleText' aria-hidden='true'>");r.writeEscaped(m.getAriaDescription()?m.getAriaDescription():"");r.write("</span>");}r.write("</div>");};
M.renderItems=function(r,m){var I=m.getItems();var a=sap.ui.getCore().getConfiguration().getAccessibility();r.write("<ul class=\"sapUiMnuLst");var h=false;var H=false;for(var b=0;b<I.length;b++){if(I[b].getIcon&&I[b].getIcon()){h=true;}if(I[b].getSubmenu()){H=true;}}if(!h){r.write(" sapUiMnuNoIco");}if(!H){r.write(" sapUiMnuNoSbMnu");}r.write("\">");var n=0;for(var i=0;i<I.length;i++){if(I[i].getVisible()&&I[i].render){n++;}}var c=0;for(var i=0;i<I.length;i++){var o=I[i];if(o.getVisible()&&o.render){c++;if(o.getStartsSection()){r.write("<li ");if(a){r.write("role=\"separator\" ");}r.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");}o.render(r,o,m,{bAccessible:a,iItemNo:c,iTotalItems:n});}}r.write("</ul>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/MenuTextFieldItem',['jquery.sap.global','sap/ui/core/ValueStateSupport','./MenuItemBase','./library','sap/ui/core/library','sap/ui/Device','jquery.sap.events'],function(q,V,M,l,c,D){"use strict";var a=c.ValueState;
var b=M.extend("sap.ui.unified.MenuTextFieldItem",{metadata:{library:"sap.ui.unified",properties:{label:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:a.None}}}});
(function(){
b.prototype.render=function(r,i,m,I){var d=r,e=m.checkEnabled(i),f=i.getId();var C="sapUiMnuItm sapUiMnuTfItm";if(I.iItemNo==1){C+=" sapUiMnuItmFirst";}else if(I.iItemNo==I.iTotalItems){C+=" sapUiMnuItmLast";}if(!m.checkEnabled(i)){C+=" sapUiMnuItmDsbl";}if(i.getStartsSection()){C+=" sapUiMnuItmSepBefore";}d.write("<li ");d.writeAttribute("class",C);d.writeElementData(i);if(I.bAccessible){d.writeAttribute("role","menuitem");d.writeAttribute("aria-disabled",!e);d.writeAttribute("aria-posinset",I.iItemNo);d.writeAttribute("aria-setsize",I.iTotalItems);}d.write("><div class=\"sapUiMnuItmL\"></div>");d.write("<div class=\"sapUiMnuItmIco\">");if(i.getIcon()){d.writeIcon(i.getIcon(),null,{title:null});}d.write("</div>");d.write("<div id=\""+f+"-txt\" class=\"sapUiMnuItmTxt\">");d.write("<label id=\""+f+"-lbl\" class=\"sapUiMnuTfItemLbl\">");d.writeEscaped(i.getLabel()||"");d.write("</label>");d.write("<div id=\""+f+"-str\" class=\"sapUiMnuTfItmStretch\"></div>");d.write("<div class=\"sapUiMnuTfItemWrppr\">");d.write("<input id=\""+f+"-tf\" tabindex=\"-1\"");d.writeAttributeEscaped("value",i.getValue()||"");d.writeAttribute("class",e?"sapUiMnuTfItemTf sapUiMnuTfItemTfEnbl":"sapUiMnuTfItemTf sapUiMnuTfItemTfDsbl");if(!e){d.writeAttribute("disabled","disabled");}if(I.bAccessible){d.writeAccessibilityState(i,{role:"textbox",disabled:!e,multiline:false,autocomplete:"none",labelledby:{value:f+"-lbl",append:true}});}d.write("/></div></div>");d.write("<div class=\"sapUiMnuItmR\"></div>");d.write("</li>");};
b.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);if(h&&m.checkEnabled(this)){m.closeSubmenu(false,true);if(D.browser.msie){q.sap.delayedCall(0,this,function(){this.$("tf").focus();}.bind(this));}else{this.$("tf").focus();}}};
b.prototype.onAfterRendering=function(){this._adaptSizes();this.setValueState(this.getValueState());};
b.prototype.onsapup=function(e){this.getParent().focus();this.getParent().onsapprevious(e);};
b.prototype.onsapdown=function(e){this.getParent().focus();this.getParent().onsapnext(e);};
b.prototype.onsaphome=function(e){if(this._checkCursorPosForNav(false)){this.getParent().focus();this.getParent().onsaphome(e);}};
b.prototype.onsapend=function(e){if(this._checkCursorPosForNav(true)){this.getParent().focus();this.getParent().onsapend(e);}};
b.prototype.onsappageup=function(e){this.getParent().focus();this.getParent().onsappageup(e);};
b.prototype.onsappagedown=function(e){this.getParent().focus();this.getParent().onsappagedown(e);};
b.prototype.onsapescape=function(e){this.getParent().onsapescape(e);};
b.prototype.onkeydown=function(e){e.stopPropagation();};
b.prototype.onclick=function(e){this.getParent().closeSubmenu(false,true);if(!D.system.desktop&&this.getParent().checkEnabled(this)){this.focus();}e.stopPropagation();};
b.prototype.onkeyup=function(e){if(!q.sap.PseudoEvents.sapenter.fnCheck(e)){return;}var v=this.$("tf").val();this.setValue(v);this.getParent().selectItem(this);e.preventDefault();e.stopPropagation();};
b.prototype.setSubmenu=function(m){q.sap.log.warning("The aggregation 'submenu' is not supported for this type of menu item.","","sap.ui.unified.MenuTextFieldItem");return this;};
b.prototype.setLabel=function(L){this.setProperty("label",L,true);this.$("lbl").text(L);this._adaptSizes();return this;};
b.prototype.setValue=function(v){this.setProperty("value",v,true);this.$("tf").val(v);return this;};
b.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var $=this.$("tf");$.toggleClass("sapUiMnuTfItemTfErr",v==a.Error);$.toggleClass("sapUiMnuTfItemTfWarn",v==a.Warning);var t=V.enrichTooltip(this,this.getTooltip_AsString());this.$().attr("title",t?t:"");return this;};
b.prototype.getFocusDomRef=function(){var f=this.$("tf");return f.length?f.get(0):null;};
b.prototype._adaptSizes=function(){var $=this.$("tf");var d=this.$("lbl");var o=d.length?d.get(0).offsetLeft:0;if(sap.ui.getCore().getConfiguration().getRTL()){$.parent().css({"width":"auto","right":(this.$().outerWidth(true)-o+(d.outerWidth(true)-d.outerWidth()))+"px"});}else{$.parent().css({"width":"auto","left":(o+d.outerWidth(true))+"px"});}};
b.prototype._checkCursorPosForNav=function(f){var r=sap.ui.getCore().getConfiguration().getRTL();var B=f?r:!r;var $=this.$("tf");var p=$.cursorPos();var L=$.val().length;if(r){p=L-p;}if((!B&&p!=L)||(B&&p!=0)){return false;}return true;};
}());return b;});
sap.ui.predefine('sap/ui/unified/Shell',['./ShellHeader','./ShellLayout','./library',"./ShellRenderer"],function(S,a,l,b){"use strict";
var c=a.extend("sap.ui.unified.Shell",{metadata:{library:"sap.ui.unified",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},showCurtain:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},showCurtainPane:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},searchVisible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{curtainContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainContent"},curtainPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainPaneContent"},headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headItem",forwarding:{idSuffix:"-header",aggregation:"headItems"}},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headEndItem",forwarding:{idSuffix:"-header",aggregation:"headEndItems"}},search:{type:"sap.ui.core.Control",multiple:false,forwarding:{idSuffix:"-header",aggregation:"search"}},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false,forwarding:{idSuffix:"-header",aggregation:"user"}}}}});
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this._header=new S(this.getId()+"-header");this.setHeader(this._header);};
c.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._header.destroy();delete this._header;};
c.prototype._getSearchWidth=function(){if(this._header===this.getHeader()&&this._header.getDomRef()){var s=this._header.$("hdr-center").children();if(s.length){return s.width();}}return-1;};
c.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._header.setLogo(i);return this;};
c.prototype.getIcon=function(){return this._header.getLogo();};
c.prototype.setSearchVisible=function(s){this.setProperty("searchVisible",s,true);this._header.setSearchVisible(s);return this;};
c.prototype.getSearchVisible=function(){return this._header.getSearchVisible();};
c.prototype.setHeader=function(h){return a.prototype.setHeader.apply(this,[h?h:this._header]);};
c.prototype.destroyHeader=function(){if(this.getHeader()===this._header){return this;}return a.prototype.destroyHeader.apply(this,[]);};
return c;});
sap.ui.predefine('sap/ui/unified/ShellHeadItem',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/IconPool','./library'],function(q,E,I,l){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadItem",{metadata:{library:"sap.ui.unified",properties:{startsSection:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},showSeparator:{type:"boolean",group:"Appearance",defaultValue:true},selected:{type:"boolean",group:"Appearance",defaultValue:false},toggleEnabled:{type:"boolean",group:"Appearance",defaultValue:true},showMarker:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
S.prototype.onclick=function(e){this.firePress();e.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setStartsSection=function(s){s=!!s;this.setProperty("startsSection",s,true);this.$().toggleClass("sapUiUfdShellHeadItmDelim",s);return this;};
S.prototype.setShowSeparator=function(s){s=!!s;this.setProperty("showSeparator",s,true);this.$().toggleClass("sapUiUfdShellHeadItmSep",s);return this;};
function _(){var t=this.$(),T=this.getToggleEnabled(),s=this.getSelected();if(!t.length){return;}if(T){t.toggleClass("sapUiUfdShellHeadItmSel",s);t.attr("aria-pressed",s);}else{t.removeClass("sapUiUfdShellHeadItmSel");t.removeAttr("aria-pressed");}}
S.prototype.setToggleEnabled=function(e){this.setProperty("toggleEnabled",!!e,true);_.apply(this);return this;};
S.prototype.setSelected=function(s){this.setProperty("selected",!!s,true);_.apply(this);return this;};
S.prototype.setVisible=function(v){this.setProperty("visible",!!v);return this;};
S.prototype.setShowMarker=function(m){m=!!m;this.setProperty("showMarker",m,true);this.$().toggleClass("sapUiUfdShellHeadItmMark",m);return this;};
S.prototype.setIcon=function(i){this.setProperty("icon",i,true);if(this.getDomRef()){this._refreshIcon();}return this;};
S.prototype._refreshIcon=function(){var i=q(this.$().children()[0]);var s=this.getIcon();if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").css("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.css("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+q.sap.encodeHTML(s)+"'/>");}}};
return S;});
sap.ui.predefine('sap/ui/unified/ShellHeadUserItem',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/IconPool','./library'],function(q,E,I,l){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadUserItem",{metadata:{library:"sap.ui.unified",properties:{username:{type:"string",group:"Appearance",defaultValue:''},showPopupIndicator:{type:"boolean",group:"Accessibility",defaultValue:true},image:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
I.getIconInfo("","");
S.prototype.onclick=function(e){this.firePress();e.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setImage=function(i){this.setProperty("image",i,true);if(this.getDomRef()){this._refreshImage();}return this;};
S.prototype._refreshImage=function(){var i=this.$("img");var s=this.getImage();if(!s){i.html("").css("style","").css("display","none");}else if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").css("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.css("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+q.sap.encodeHTML(s)+"'/>");}}};
S.prototype._checkAndAdaptWidth=function(s){if(!this.getDomRef()){return false;}var r=this.$(),n=this.$("name");var b=r.width();r.toggleClass("sapUiUfdShellHeadUsrItmLimit",false);var m=240;if(s){m=Math.min(m,0.5*document.documentElement.clientWidth-225);}if(m<n.width()){r.toggleClass("sapUiUfdShellHeadUsrItmLimit",true);}return b!=r.width();};
return S;});
sap.ui.predefine('sap/ui/unified/ShellHeader',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/Device'],function(q,l,C,D){"use strict";
var S=C.extend("sap.ui.unified.ShellHeader",{
metadata:{properties:{logo:{type:"sap.ui.core.URI",defaultValue:""},searchVisible:{type:"boolean",defaultValue:true}},aggregations:{headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},search:{type:"sap.ui.core.Control",multiple:false},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false}}},
renderer:{render:function(r,h){var i=h.getId();r.write("<div");r.writeControlData(h);r.writeAttribute("class","sapUiUfdShellHeader");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write(">");r.write("<div id='",i,"-hdr-begin' class='sapUiUfdShellHeadBegin'>");this.renderHeaderItems(r,h,true);r.write("</div>");r.write("<div id='",i,"-hdr-center' class='sapUiUfdShellHeadCenter'>");this.renderSearch(r,h);r.write("</div>");r.write("<div id='",i,"-hdr-end' class='sapUiUfdShellHeadEnd'>");this.renderHeaderItems(r,h,false);r.write("</div>");r.write("</div>");},renderSearch:function(r,h){var s=h.getSearch();r.write("<div id='",h.getId(),"-hdr-search'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","search");}r.writeAttribute("class","sapUiUfdShellSearch"+(h.getSearchVisible()?"":" sapUiUfdShellHidden"));r.write("><div>");if(s){r.renderControl(s);}r.write("</div></div>");},renderHeaderItems:function(r,h,b){r.write("<div class='sapUiUfdShellHeadContainer'>");var I=b?h.getHeadItems():h.getHeadEndItems();for(var i=0;i<I.length;i++){r.write("<div tabindex='0'");r.writeElementData(I[i]);r.addClass("sapUiUfdShellHeadItm");if(I[i].getStartsSection()){r.addClass("sapUiUfdShellHeadItmDelim");}if(I[i].getShowSeparator()){r.addClass("sapUiUfdShellHeadItmSep");}if(!I[i].getVisible()){r.addClass("sapUiUfdShellHidden");}if(I[i].getSelected()&&I[i].getToggleEnabled()){r.addClass("sapUiUfdShellHeadItmSel");}if(I[i].getShowMarker()){r.addClass("sapUiUfdShellHeadItmMark");}r.writeClasses();var t=I[i].getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(I[i],{role:"button",selected:null,pressed:I[i].getToggleEnabled()?I[i].getSelected():null});}r.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></div>");}var u=h.getUser();if(!b&&u){r.write("<div tabindex='0'");r.writeElementData(u);r.addClass("sapUiUfdShellHeadUsrItm");if(!u.getShowPopupIndicator()){r.addClass("sapUiUfdShellHeadUsrItmWithoutPopup");}r.writeClasses();var t=u.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(u,{role:"button"});if(u.getShowPopupIndicator()){r.writeAttribute("aria-haspopup","true");}}r.write("><span id='",u.getId(),"-img' aria-hidden='true' class='sapUiUfdShellHeadUsrItmImg'></span>");r.write("<span id='"+u.getId()+"-name' class='sapUiUfdShellHeadUsrItmName'");var U=u.getUsername()||"";r.writeAttributeEscaped("title",U);r.write(">");r.writeEscaped(U);r.write("</span><span class='sapUiUfdShellHeadUsrItmExp' aria-hidden='true'></span></div>");}r.write("</div>");if(b){this._renderLogo(r,h);}},_renderLogo:function(r,h){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),L=a.getText("SHELL_LOGO_TOOLTIP"),i=h._getLogo();r.write("<div class='sapUiUfdShellIco'>");r.write("<img id='",h.getId(),"-icon'");r.writeAttributeEscaped("title",L);r.writeAttributeEscaped("alt",L);r.write("src='");r.writeEscaped(i);r.write("' style='",i?"":"display:none;","'/>");r.write("</div>");}}
});
S.prototype.init=function(){var t=this;this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._handleMediaChange=function(p){if(!t.getDomRef()){return;}t._refresh();};D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);this._handleResizeChange=function(p){if(!t.getDomRef()||!t.getUser()){return;}var u=this.getUser();var c=u._checkAndAdaptWidth(!t.$("hdr-search").hasClass("sapUiUfdShellHidden")&&!!t.getSearch());if(c){t._refresh();}};D.resize.attachHandler(this._handleResizeChange,this);this.data("sap-ui-fastnavgroup","true",true);};
S.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);delete this._handleMediaChange;D.resize.detachHandler(this._handleResizeChange,this);delete this._handleResizeChange;};
S.prototype.onAfterRendering=function(){this._refresh();this.$("hdr-center").toggleClass("sapUiUfdShellAnim",!this._noHeadCenterAnim);};
S.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
S.prototype._getLogo=function(){var i=this.getLogo();if(!i){q.sap.require("sap.ui.core.theming.Parameters");i=sap.ui.core.theming.Parameters._getThemeImage(null,true);}return i;};
S.prototype._refresh=function(){function u(I){for(var i=0;i<I.length;i++){I[i]._refreshIcon();}}u(this.getHeadItems());u(this.getHeadEndItems());var U=this.getUser(),a=q("html").hasClass("sapUiMedia-Std-Phone"),s=!this.$("hdr-search").hasClass("sapUiUfdShellHidden"),$=this.$("icon");if(U){U._refreshImage();U._checkAndAdaptWidth(s&&!!this.getSearch());}$.parent().toggleClass("sapUiUfdShellHidden",a&&s&&!!this.getSearch());var w=this.$("hdr-end").outerWidth(),b=this.$("hdr-begin").outerWidth(),c=Math.max(w,b),d=(a&&s?b:c)+"px",e=(a&&s?w:c)+"px";this.$("hdr-center").css({"left":this._rtl?e:d,"right":this._rtl?d:e});};
return S;});
sap.ui.predefine('sap/ui/unified/ShellLayout',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./SplitContainer','./library',"./ShellLayoutRenderer",'jquery.sap.dom','jquery.sap.script'],function(q,D,C,P,a,S,l,b){"use strict";
var c=C.extend("sap.ui.unified.ShellLayout",{metadata:{library:"sap.ui.unified",properties:{showPane:{type:"boolean",group:"Appearance",defaultValue:false},headerHiding:{type:"boolean",group:"Appearance",defaultValue:false},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",forwarding:{idSuffix:"-container",aggregation:"content"}},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent",forwarding:{idSuffix:"-container",aggregation:"secondaryContent"}},header:{type:"sap.ui.core.Control",multiple:false},canvasSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"},curtainSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"}}}});
c._SIDEPANE_WIDTH_PHONE=208;c._SIDEPANE_WIDTH_TABLET=208;c._SIDEPANE_WIDTH_DESKTOP=240;c._HEADER_ALWAYS_VISIBLE=true;c._HEADER_AUTO_CLOSE=true;c._HEADER_TOUCH_TRESHOLD=15;if(D.browser.chrome&&D.browser.version<36){c._HEADER_TOUCH_TRESHOLD=10;}
c.prototype.init=function(){this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._showHeader=true;this._showCurtain=false;this._iHeaderHidingDelay=3000;this._useStrongBG=false;this._cont=new S(this.getId()+"-container");this._cont._bRootContent=true;if(sap.ui.getCore().getConfiguration().getAccessibility()){var t=this;this._cont.addEventDelegate({onAfterRendering:function(){t._cont.$("canvas").attr("role","main");t._cont.$("pane").attr("role","complementary");}});}this.setAggregation("canvasSplitContainer",this._cont,true);this._curtCont=new S(this.getId()+"-curt-container");this._curtCont._bRootContent=true;this.setAggregation("curtainSplitContainer",this._curtCont,true);this._setSidePaneWidth();D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.attachHandler(this._handleResizeChange,this);};
c.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.detachHandler(this._handleResizeChange,this);delete this._cont;delete this._curtCont;};
c.prototype.onAfterRendering=function(){var t=this;function h(B){var e=q.event.fix(B);if(q.sap.containsOrEquals(t.getDomRef("hdr"),e.target)){t._timedHideHeader(e.type==="focus");}}if(window.addEventListener&&!c._HEADER_ALWAYS_VISIBLE){var H=this.getDomRef("hdr");H.addEventListener("focus",h,true);H.addEventListener("blur",h,true);}this._refreshAfterRendering();};
c.prototype.onThemeChanged=function(){this._refreshAfterRendering();};
c.prototype.onfocusin=function(e){var i=this.getId();if(e.target.id===i+"-curt-focusDummyOut"){q.sap.focus(this.$("hdrcntnt").firstFocusableDomRef());}else if(e.target.id===i+"-main-focusDummyOut"){q.sap.focus(this.$("curtcntnt").firstFocusableDomRef());}};
(function(){
function _(s){if(s._startY===undefined||s._currY===undefined){return;}var y=s._currY-s._startY;if(Math.abs(y)>c._HEADER_TOUCH_TRESHOLD){s._doShowHeader(y>0);s._startY=s._currY;}}
if(D.support.touch){c._HEADER_ALWAYS_VISIBLE=false;c.prototype.ontouchstart=function(e){this._startY=e.touches[0].pageY;if(this._startY>2*48){this._startY=undefined;}this._currY=this._startY;};c.prototype.ontouchend=function(e){_(this);this._startY=undefined;this._currY=undefined;};c.prototype.ontouchcancel=c.prototype.ontouchend;c.prototype.ontouchmove=function(e){this._currY=e.touches[0].pageY;_(this);};}})();
c.prototype.setHeaderHiding=function(e){e=!!e;return this._mod(function(r){return this.setProperty("headerHiding",e,r);},function(){this._doShowHeader(!e?true:this._showHeader);});};
c.prototype.setHeaderHidingDelay=function(d){this._iHeaderHidingDelay=d;return this;};
c.prototype.getHeaderHidingDelay=function(){return this._iHeaderHidingDelay;};
c.prototype.getShowPane=function(){return this._cont.getShowSecondaryContent();};
c.prototype.setShowPane=function(s){this._cont.setShowSecondaryContent(s);this.setProperty("showPane",!!s,true);return this;};
c.prototype.setShowCurtainPane=function(s){this._curtCont.setShowSecondaryContent(s);return this;};
c.prototype.getShowCurtainPane=function(){return this._curtCont.getShowSecondaryContent();};
c.prototype.setHeaderVisible=function(h){h=!!h;this.setProperty("headerVisible",h,true);this.$().toggleClass("sapUiUfdShellNoHead",!h);return this;};
c.prototype.setShowCurtain=function(s){s=!!s;return this._mod(function(r){this._showCurtain=s;return this;},function(){this.$("main-focusDummyOut").attr("tabindex",s?0:-1);this.$().toggleClass("sapUiUfdShellCurtainHidden",!s).toggleClass("sapUiUfdShellCurtainVisible",s);if(s){var z=P.getNextZIndex();this.$("curt").css("z-index",z+1);this.$("hdr").css("z-index",z+3);this.$("brand").css("z-index",z+7);this.$().toggleClass("sapUiUfdShellCurtainClosed",false);}this._timedCurtainClosed(s);this._doShowHeader(true);});};
c.prototype.getShowCurtain=function(){return this._showCurtain;};
c.prototype.setHeader=function(h){this.setAggregation("header",h,true);h=this.getHeader();if(this.getDomRef()){if(!h){this.$("hdrcntnt").html("");}else{var r=sap.ui.getCore().createRenderManager();r.renderControl(h);r.flush(this.getDomRef("hdrcntnt"));r.destroy();}}return this;};
c.prototype.destroyHeader=function(){this.destroyAggregation("header",true);this.$("hdrcntnt").html("");return this;};
c.prototype.getCurtainContent=function(){return this._curtCont.getContent();};
c.prototype.insertCurtainContent=function(o,i){this._curtCont.insertContent(o,i);return this;};
c.prototype.addCurtainContent=function(o){this._curtCont.addContent(o);return this;};
c.prototype.removeCurtainContent=function(i){return this._curtCont.removeContent(i);};
c.prototype.removeAllCurtainContent=function(){return this._curtCont.removeAllContent();};
c.prototype.destroyCurtainContent=function(){this._curtCont.destroyContent();return this;};
c.prototype.indexOfCurtainContent=function(o){return this._curtCont.indexOfCurtainContent(o);};
c.prototype.getCurtainPaneContent=function(){return this._curtCont.getSecondaryContent();};
c.prototype.insertCurtainPaneContent=function(o,i){this._curtCont.insertSecondaryContent(o,i);return this;};
c.prototype.addCurtainPaneContent=function(o){this._curtCont.addSecondaryContent(o);return this;};
c.prototype.removeCurtainPaneContent=function(i){return this._curtCont.removeSecondaryContent(i);};
c.prototype.removeAllCurtainPaneContent=function(){return this._curtCont.removeAllSecondaryContent();};
c.prototype.destroyCurtainPaneContent=function(){this._curtCont.destroySecondaryContent();return this;};
c.prototype.indexOfCurtainPaneContent=function(o){return this._curtCont.indexOfSecondaryContent(o);};
c.prototype._setStrongBackground=function(u){this._useStrongBG=!!u;this.$("strgbg").toggleClass("sapUiStrongBackgroundColor",this._useStrongBG);};
c.prototype._mod=function(m,d){var r=!!this.getDomRef();var e=m.apply(this,[r]);if(r&&d){if(d instanceof l._ContentRenderer){d.render();}else{d.apply(this);}}return e;};
c.prototype._doShowHeader=function(s){var w=this._showHeader;this._showHeader=this._isHeaderHidingActive()?!!s:true;this.$().toggleClass("sapUiUfdShellHeadHidden",!this._showHeader).toggleClass("sapUiUfdShellHeadVisible",this._showHeader);if(this._showHeader){this._timedHideHeader();}if(w!=this._showHeader&&this._isHeaderHidingActive()){q.sap.delayedCall(500,this,function(){try{var r=document.createEvent("UIEvents");r.initUIEvent("resize",true,false,window,0);window.dispatchEvent(r);}catch(e){q.sap.log.error(e);}});}};
c.prototype._timedHideHeader=function(d){if(this._headerHidingTimer){q.sap.clearDelayedCall(this._headerHidingTimer);this._headerHidingTimer=null;}if(d||!c._HEADER_AUTO_CLOSE||!this._isHeaderHidingActive()||this._iHeaderHidingDelay<=0){return;}this._headerHidingTimer=q.sap.delayedCall(this._iHeaderHidingDelay,this,function(){if(this._isHeaderHidingActive()&&this._iHeaderHidingDelay>0&&!q.sap.containsOrEquals(this.getDomRef("hdr"),document.activeElement)){this._doShowHeader(false);}});};
c.prototype._timedCurtainClosed=function(d){if(this._curtainClosedTimer){q.sap.clearDelayedCall(this._curtainClosedTimer);this._curtainClosedTimer=null;}if(d){return;}var e=parseInt(a.get("_sap_ui_unified_ShellLayout_AnimDuration"),10);if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){e=0;}this._curtainClosedTimer=q.sap.delayedCall(e,this,function(){this._curtainClosedTimer=null;this.$("curt").css("z-index","");this.$("hdr").css("z-index","");this.$("brand").css("z-index","");this.$().toggleClass("sapUiUfdShellCurtainClosed",true);});};
c.prototype._isHeaderHidingActive=function(){if(c._HEADER_ALWAYS_VISIBLE||this.getShowCurtain()||!this.getHeaderHiding()||l._iNumberOfOpenedShellOverlays>0||!this.getHeaderVisible()){return false;}return true;};
c.prototype._refreshCSSWorkaround=function(){if(!D.browser.webkit||!D.support.touch){return;}if(this._cssWorkaroundTimer){q.sap.clearDelayedCall(this._cssWorkaroundTimer);this._cssWorkaroundTimer=null;}this.$("css").remove();this._cssWorkaroundTimer=q.sap.delayedCall(10,this,function(){this._cssWorkaroundTimer=null;q.sap.log.debug("sap.ui.unified.ShellLayout: CSS Workaround applied.");q("head").append("<link type='text/css' rel='stylesheet' id='"+this.getId()+"-css' href='data:text/css;base64,LnNhcFVpVWZkU2hlbGxDaHJvbWVSZXBhaW50e291dGxpbmUtY29sb3I6aW5pdGlhbDt9'/>");this._cssWorkaroundTimer=q.sap.delayedCall(100,this,function(){this.$("css").remove();});});};
c.prototype._setSidePaneWidth=function(r){if(!r){r=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD).name;}var w=c["_SIDEPANE_WIDTH_"+r.toUpperCase()]+"px";this._cont.setSecondaryContentSize(w);this._curtCont.setSecondaryContentSize(w);};
c.prototype._handleMediaChange=function(p){if(!this.getDomRef()){return false;}this._setSidePaneWidth(p.name);};
c.prototype._handleResizeChange=function(p){};
c.prototype._refreshAfterRendering=function(){var d=this.getDomRef();if(!d){return false;}this._repaint(d);this._timedHideHeader();return true;};
c.prototype._repaint=function(d){if(D.browser.webkit){var e=d.style.display;d.style.display="none";d.offsetHeight;d.style.display=e;this._refreshCSSWorkaround();}};
c.prototype._getSearchWidth=function(){return-1;};
return c;});
sap.ui.predefine('sap/ui/unified/ShellLayoutRenderer',[],function(){"use strict";var S={};
S.render=function(r,s){var i=s.getId();r.write("<div");r.writeControlData(s);r.addClass("sapUiUfdShell");if(s._animation){r.addClass("sapUiUfdShellAnim");}if(!s.getHeaderVisible()){r.addClass("sapUiUfdShellNoHead");}r.addClass("sapUiUfdShellHead"+(s._showHeader?"Visible":"Hidden"));if(s.getShowCurtain()){r.addClass("sapUiUfdShellCurtainVisible");}else{r.addClass("sapUiUfdShellCurtainHidden");r.addClass("sapUiUfdShellCurtainClosed");}r.writeClasses();r.write(">");r.write("<hr id='",i,"-brand' class='sapUiUfdShellBrand'/>");r.write("<header id='",i,"-hdr'  class='sapUiUfdShellHead'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","banner");}r.write("><div><div id='",i,"-hdrcntnt' class='sapUiUfdShellCntnt'>");if(s.getHeader()){r.renderControl(s.getHeader());}r.write("</div>","</div>","</header>");r.write("<section id='",i,"-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");r.write("<div id='",i,"-curtcntnt' class='sapUiUfdShellCntnt'>");r.renderControl(s._curtCont);r.write("</div>");r.write("<span id='",i,"-curt-focusDummyOut' tabindex='0'></span>");r.write("</section>");r.write("<div id='",i,"-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiGlobalBackgroundColor sapUiGlobalBackgroundColorForce'>");r.write("<div id='",i,"-strgbg' class='sapUiUfdShellBG"+(s._useStrongBG?" sapUiStrongBackgroundColor":"")+"'></div>");r.write("<div class='sapUiGlobalBackgroundImage sapUiGlobalBackgroundImageForce sapUiUfdShellBG'></div>");r.renderControl(s._cont);r.write("</div>");r.write("<span id='",i,"-main-focusDummyOut' tabindex='"+(s.getShowCurtain()?0:-1)+"'></span>");r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellOverlay',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','./library','sap/ui/unified/ShellOverlayRenderer','jquery.sap.script'],function(q,D,C,P,l,S){"use strict";
var a=C.extend("sap.ui.unified.ShellOverlay",{metadata:{library:"sap.ui.unified",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},search:{type:"sap.ui.core.Control",multiple:false}},associations:{shell:{type:"sap.ui.unified.ShellLayout",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{closed:{}}}});
a.prototype.open=function(){if(this._getPopup().isOpen()){return;}this._opening=true;this._forceShellHeaderVisible();this._getPopup().setModal(true,P.blStack.length==0&&this._getAnimActive()?"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp":"");this._getPopup().open(0,P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","none");var s=this.getSearch();if(s){s.focus();}this._opening=false;if(this._getAnimActive()){q.sap.delayedCall(50,this,function(){q.sap.byId("sap-ui-blocklayer-popup").toggleClass("sapUiUfdShellOvrlyBlyTp",false);});}q.sap.delayedCall(this._getAnimDuration(true),this,function(){this.$().toggleClass("sapUiUfdShellOvrlyOpening",false);});};
a.prototype.close=function(){if(!this._getPopup().isOpen()){return;}this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",true).toggleClass("sapUiUfdShellOvrlyClosing",true);this._setSearchWidth();q.sap.delayedCall(Math.max(this._getAnimDuration(false)-this._getBLAnimDuration(),0),this,function(){var b=q.sap.byId("sap-ui-blocklayer-popup");if(P.blStack.length==1&&this._getAnimActive()&&b.hasClass("sapUiUfdShellOvrlyBly")){b.toggleClass("sapUiUfdShellOvrlyBlyTp",true);}});q.sap.delayedCall(this._getAnimDuration(false),this,function(){this._getPopup().close(0);this.$().remove();this._forceShellHeaderVisible();this.fireClosed();});};
a.prototype.setShell=function(s){return this.setAssociation("shell",s,true);};
a.prototype.setSearch=function(s){this.setAggregation("search",s,true);if(!!this.getDomRef()){this._headRenderer.render();}return this;};
a.prototype.insertContent=function(c,i){var r=this.insertAggregation("content",c,i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.addContent=function(c){var r=this.addAggregation("content",c,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.destroyContent=function(){var r=this.destroyAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.init=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._opening=false;var t=this;this._headRenderer=new l._ContentRenderer(this,this.getId()+"-hdr-center",function(r){S.renderSearch(r,t);});this._contentRenderer=new l._ContentRenderer(this,this.getId()+"-cntnt",function(r){S.renderContent(r,t);});};
a.prototype.exit=function(){if(this._popup){this._popup.close(0);this._popup.destroy();this._popup=null;}this._getPopup=function(){return null;};this._headRenderer.destroy();delete this._headRenderer;this._contentRenderer.destroy();delete this._contentRenderer;};
a.prototype.onAfterRendering=function(){if(this._opening){this._setSearchWidth();}q.sap.delayedCall(10,this,function(){this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",false);this.$("search").css("width","");});};
a.prototype.onclick=function(e){if(q(e.target).attr("id")===this.getId()+"-close"){this.close();e.preventDefault();}};
a.prototype.onsapspace=a.prototype.onclick;
a.prototype.onThemeChanged=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;};
a.prototype.onfocusin=function(e){var f,d;if(e.target.id==this.getId()+"-focfirst"){f=q(":sapTabbable",this.$("inner"));d=f.get(f.length-1);}else if(e.target.id==this.getId()+"-foclast"){f=q(":sapTabbable",this.$("inner"));d=f.get(0);}if(d){q.sap.focus(d);}};
a.prototype._getAnimDurationThemeParam=function(p,c){var v=parseInt(sap.ui.core.theming.Parameters.get(p),10);if(!this._getAnimActive()&&c){v=0;}return v;};
a.prototype._getAnimDuration=function(o){if((o&&this._animOpenDuration==-1)||(!o&&this._animCloseDuration==-1)){var t=o?"Open":"Close";this["_anim"+t+"Duration"]=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_"+t+"AnimOverAll",true);}return o?this._animOpenDuration:this._animCloseDuration;};
a.prototype._getBLAnimDuration=function(){if(this._animBlockLayerDuration==-1){this._animBlockLayerDuration=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_BlockLayerAnimDuration",true);}return this._animBlockLayerDuration;};
a.prototype._getAnimActive=function(){if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){return false;}return true;};
a.prototype._getPopup=function(){if(!this._popup){this._popup=new P(this,true,false,false);this._popup._applyPosition=function(p){this._$().css("left","0").css("top","0");this._oLastPosition=p;this._oLastOfRect=q(window).rect();};this._popup.attachOpened(function(){l._iNumberOfOpenedShellOverlays++;});this._popup.attachClosed(function(){l._iNumberOfOpenedShellOverlays--;});}return this._popup;};
a.prototype._getShell=function(){var i=this.getShell();if(!i){return;}var s=sap.ui.getCore().byId(i);if(!s||!(s instanceof sap.ui.unified.ShellLayout)){return;}return s;};
a.prototype._forceShellHeaderVisible=function(){var s=this._getShell();if(s){s._doShowHeader(true);}};
a.prototype._getSearchWidth=function(){var s=this._getShell();return s?s._getSearchWidth():-1;};
a.prototype._setSearchWidth=function(){var w=this._getSearchWidth();if(w<=0){return;}var W=w+"px";if(D.browser.safari){var t=this.$("hdr-center").width();if(t>w){W=Math.round((w*100)/t)+"%";}else{W="100%";}}this.$("search").css("width",W);};
return a;});
sap.ui.predefine('sap/ui/unified/ShellOverlayRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdShellOvrly");if(c._opening){r.addClass("sapUiUfdShellOvrlyCntntHidden");r.addClass("sapUiUfdShellOvrlyOpening");}if(c._getAnimActive()){r.addClass("sapUiUfdShellOvrlyAnim");}r.writeClasses();if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(c,{role:"dialog"});}r.write("><span id='",c.getId(),"-focfirst' tabIndex='0'></span><div id='",c.getId(),"-inner'>");r.write("<header class='sapUiUfdShellOvrlyHead'>");r.write("<hr class='sapUiUfdShellOvrlyBrand'/>");r.write("<div class='sapUiUfdShellOvrlyHeadCntnt'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write("><div id='"+c.getId()+"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");S.renderSearch(r,c);r.write("</div>");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),C=a.getText("SHELL_OVERLAY_CLOSE");r.write("<a tabindex='0' href='#' id='"+c.getId()+"-close' class='sapUiUfdShellOvrlyHeadClose'");r.writeAttributeEscaped("title",C);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","button");}r.write(">");r.writeEscaped(C);r.write("</a></div></header>");r.write("<div id='"+c.getId()+"-cntnt' class='sapUiUfdShellOvrlyCntnt'>");S.renderContent(r,c);r.write("</div>");r.write("</div><span id='",c.getId(),"-foclast' tabIndex='0'></span></div>");};
S.renderSearch=function(r,c){var w=c._getSearchWidth();var s="";if(w>0&&c._opening){s="style='width:"+w+"px'";}r.write("<div id='"+c.getId()+"-search' class='sapUiUfdShellOvrlySearch' "+s+"><div>");var o=c.getSearch();if(o){r.renderControl(o);}r.write("</div></div>");};
S.renderContent=function(r,c){r.write("<div>");var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellRenderer',['sap/ui/core/Renderer','./ShellLayoutRenderer'],function(R,S){"use strict";var a=R.extend(S);return a;},true);
sap.ui.predefine('sap/ui/unified/SplitContainer',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/theming/Parameters','./library','sap/ui/core/library',"./SplitContainerRenderer"],function(q,C,P,l,c,S){"use strict";var O=c.Orientation;
var a=C.extend("sap.ui.unified.SplitContainer",{metadata:{library:"sap.ui.unified",properties:{showSecondaryContent:{type:"boolean",group:"Appearance",defaultValue:null},secondaryContentSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px'},secondaryContentWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px',deprecated:true},orientation:{type:"sap.ui.core.Orientation",group:"Appearance",defaultValue:O.Horizontal}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},secondaryContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondaryContent"}}}});
(function(w){
a.prototype.init=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._paneRenderer=new l._ContentRenderer(this,this.getId()+"-panecntnt","secondaryContent");this._canvasRenderer=new l._ContentRenderer(this,this.getId()+"-canvascntnt","content");this._moveContent=true;};
a.prototype.exit=function(){this._paneRenderer.destroy();delete this._paneRenderer;this._canvasRenderer.destroy();delete this._canvasRenderer;if(this._closeContentDelayId){q.sap.clearDelayedCall(this._closeContentDelayId);delete this._closeContentDelayId;}delete this._contentContainer;delete this._secondaryContentContainer;};
a.prototype.onAfterRendering=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._contentContainer=this.$("canvas");this._secondaryContentContainer=this.$("pane");this._applySecondaryContentSize();};
a.prototype._applySecondaryContentSize=function(){if(this.getDomRef()){var v=this.getOrientation()==O.Vertical;var s,o;var d,b;var e=this.getSecondaryContentSize();var f=this.getShowSecondaryContent();if(v){s="height";o="width";d="top";b=this.bRtl?"right":"left";}else{s="width";o="height";d=this.bRtl?"right":"left";b="top";}if(this._closeContentDelayId){q.sap.clearDelayedCall(this._closeContentDelayId);delete this._closeContentDelayId;}this._secondaryContentContainer.css(s,e);this._secondaryContentContainer.css(o,"");this._secondaryContentContainer.css(d,f?"0":"-"+e);this._secondaryContentContainer.css(b,"");if(this._moveContent){this._contentContainer.css(d,f?e:"0");}else{this._contentContainer.css(d,"0");}if(!f){var h=parseInt(P.get("_sap_ui_unified_SplitContainer_AnimationDuration"),10);this._closeContentDelayId=q.sap.delayedCall(h,this,function(){this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",true);});}else{this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",false);}}};
a.prototype._mod=function(m,d){var r=!!this.getDomRef();var b=m.apply(this,[r]);if(r&&d){d.render();}return b;};
a.prototype.setShowSecondaryContent=function(s){var r=this.getDomRef();this.setProperty("showSecondaryContent",!!s,r);this._applySecondaryContentSize();return this;};
a.prototype.setSecondaryContentSize=function(s){this.setProperty("secondaryContentSize",s,true);this._applySecondaryContentSize();return this;};
a.prototype.getSecondaryContentWidth=function(){q.sap.log.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.getSecondaryContentSize.apply(this,arguments);};
a.prototype.setSecondaryContentWidth=function(){q.sap.log.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.setSecondaryContentSize.apply(this,arguments);};
a.prototype.insertContent=function(o,i){return this._mod(function(r){return this.insertAggregation("content",o,i,r);},this._canvasRenderer);};
a.prototype.addContent=function(o){return this._mod(function(r){return this.addAggregation("content",o,r);},this._canvasRenderer);};
a.prototype.removeContent=function(i){return this._mod(function(r){return this.removeAggregation("content",i,r);},this._canvasRenderer);};
a.prototype.removeAllContent=function(){return this._mod(function(r){return this.removeAllAggregation("content",r);},this._canvasRenderer);};
a.prototype.destroyContent=function(){return this._mod(function(r){return this.destroyAggregation("content",r);},this._canvasRenderer);};
a.prototype.insertSecondaryContent=function(o,i){return this._mod(function(r){return this.insertAggregation("secondaryContent",o,i,r);},this._paneRenderer);};
a.prototype.addSecondaryContent=function(o){return this._mod(function(r){return this.addAggregation("secondaryContent",o,r);},this._paneRenderer);};
a.prototype.removeSecondaryContent=function(i){return this._mod(function(r){return this.removeAggregation("secondaryContent",i,r);},this._paneRenderer);};
a.prototype.removeAllSecondaryContent=function(){return this._mod(function(r){return this.removeAllAggregation("secondaryContent",r);},this._paneRenderer);};
a.prototype.destroySecondaryContent=function(){return this._mod(function(r){return this.destroyAggregation("secondaryContent",r);},this._paneRenderer);};
})(window);return a;});
sap.ui.predefine('sap/ui/unified/SplitContainerRenderer',["sap/ui/core/library"],function(c){"use strict";var O=c.Orientation;var S={};
S.render=function(r,C){var i=C.getId();var v=C.getOrientation()==O.Vertical;r.write("<div");r.writeControlData(C);r.addClass("sapUiUfdSpltCont");r.addClass("sapUiUfdSpltCont"+(v?"V":"H"));if(sap.ui.getCore().getConfiguration().getAnimation()){r.addClass("sapUiUfdSpltContAnim");}if(!C.getShowSecondaryContent()){r.addClass("sapUiUfdSpltContPaneHidden");}r.writeClasses();r.write(">");var s=i+"-canvas";r.write("<section id='",s,"' class='sapUiUfdSpltContCanvas'>");this.renderContent(r,s,C.getContent(),C._bRootContent);r.write("</section>");var a=i+"-pane";var w=C.getShowSecondaryContent()?C.getSecondaryContentSize():"0";r.write("<aside id='",a,"' style='width:",w,"'");r.addClass("sapUiUfdSpltContPane");if(!C.getShowSecondaryContent()){r.addClass("sapUiUfdSplitContSecondClosed");}r.writeClasses();r.write(">");this.renderContent(r,a,C.getSecondaryContent(),C._bRootContent);r.write("</aside>");r.write("</div>");};
S.renderContent=function(r,I,C,R){r.write("<div id='",I,"cntnt' class='sapUiUfdSpltContCntnt'");if(R){r.writeAttribute("data-sap-ui-root-content","true");}r.write(">");for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/calendar/CalendarDate',['sap/ui/base/Object','sap/ui/core/date/UniversalDate'],function(B,U){"use strict";
var C=B.extend("sap.ui.unified.calendar.CalendarDate",{constructor:function(){var A=arguments,j,n,s;switch(A.length){case 0:n=new Date();return this.constructor(n.getFullYear(),n.getMonth(),n.getDate());case 1:case 2:if(!(A[0]instanceof C)){throw"Invalid arguments: the first argument must be of type sap.ui.unified.calendar.CalendarDate.";}s=A[1]?A[1]:A[0]._oUDate.sCalendarType;j=new Date(A[0].valueOf());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());j.setHours(j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());this._oUDate=c(j,s);break;case 3:case 4:d(A[0],"Invalid year: "+A[0]);d(A[1],"Invalid month: "+A[1]);d(A[2],"Invalid date: "+A[2]);j=new Date(0,0,1);j.setFullYear(A[0],A[1],A[2]);if(A[3]){s=A[3];}this._oUDate=c(j,s);break;default:throw"Invalid arguments. Accepted arguments are: 1) oCalendarDate, (optional)calendarType"+"or 2) year, month, date, (optional) calendarType"+A;}}});
C.prototype.getYear=function(){return this._oUDate.getUTCFullYear();};
C.prototype.setYear=function(y){d(y,"Invalid year: "+y);this._oUDate.setUTCFullYear(y);return this;};
C.prototype.getMonth=function(){return this._oUDate.getUTCMonth();};
C.prototype.setMonth=function(m){d(m,"Invalid month: "+m);this._oUDate.setUTCMonth(m);return this;};
C.prototype.getDate=function(){return this._oUDate.getUTCDate();};
C.prototype.setDate=function(e){d(e,"Invalid date: "+e);this._oUDate.setUTCDate(e);return this;};
C.prototype.getDay=function(){return this._oUDate.getUTCDay();};
C.prototype.getCalendarType=function(){return this._oUDate.sCalendarType;};
C.prototype.isBefore=function(o){b(o);return this.valueOf()<o.valueOf();};
C.prototype.isAfter=function(o){b(o);return this.valueOf()>o.valueOf();};
C.prototype.isSameOrBefore=function(o){b(o);return this.valueOf()<=o.valueOf();};
C.prototype.isSameOrAfter=function(o){b(o);return this.valueOf()>=o.valueOf();};
C.prototype.isSame=function(o){b(o);return this.valueOf()===o.valueOf();};
C.prototype.toLocalJSDate=function(){var l=new Date(this._oUDate.getTime());l.setFullYear(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate());l.setHours(0,0,0,0);return l;};
C.prototype.toUTCJSDate=function(){var u=new Date(this._oUDate.getTime());u.setUTCHours(0,0,0,0);return u;};
C.prototype.toString=function(){return this._oUDate.sCalendarType+": "+this.getYear()+"/"+(this.getMonth()+1)+"/"+this.getDate();};
C.prototype.valueOf=function(){return this._oUDate.getTime();};
C.fromLocalJSDate=function(j,s){if(jQuery.type(j)!=="date"){throw new Error("Date parameter must be a JavaScript Date object: ["+j+"].");}return new C(j.getFullYear(),j.getMonth(),j.getDate(),s);};
function c(D,s){if(s){return U.getInstance(a(D),s);}else{return new U(a(D).getTime());}}
function a(D){var u=new Date(Date.UTC(0,0,1));u.setUTCFullYear(D.getFullYear(),D.getMonth(),D.getDate());return u;}
function b(o){if(!(o instanceof C)){throw"Invalid calendar date: ["+o+"]. Expected: sap.ui.unified.calendar.CalendarDate";}}
function d(v,m){if(v==undefined||v===Infinity||isNaN(v)){throw m;}}
return C;});
sap.ui.predefine('sap/ui/unified/calendar/CalendarUtils',['jquery.sap.global','sap/ui/core/date/UniversalDate','./CalendarDate','sap/ui/core/Locale','sap/ui/core/LocaleData'],function(q,U,C,L,a){"use strict";var b={};b.MAX_MILLISECONDS=8640000000000000;b.HOURS24=1000*3600*24;
b._createLocalDate=function(d,t){var l;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}l=new Date(m.getUTCFullYear(),m.getUTCMonth(),m.getUTCDate());if(m.getFullYear()<1000){l.setFullYear(m.getFullYear());}if(t){l.setHours(m.getUTCHours());l.setMinutes(m.getUTCMinutes());l.setSeconds(m.getUTCSeconds());l.setMilliseconds(m.getUTCMilliseconds());}}return l;};
b._createUTCDate=function(d,t){var u;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}u=new Date(Date.UTC(m.getFullYear(),m.getMonth(),m.getDate()));if(m.getFullYear()<1000){u.setUTCFullYear(m.getFullYear());}if(t){u.setUTCHours(m.getHours());u.setUTCMinutes(m.getMinutes());u.setUTCSeconds(m.getSeconds());u.setUTCMilliseconds(m.getMilliseconds());}}return u;};
b._createUniversalUTCDate=function(d,c,t){var u;if(c){u=U.getInstance(this._createUTCDate(d,t),c);}else{u=new U(this._createUTCDate(d,t).getTime());}return u;};
b.calculateWeekNumber=function(d,y,l,o){var w=0;var W=0;var f=o.getFirstDayOfWeek();var c=new L(l);if(c&&(c.getLanguage()=='en'&&c.getRegion()=='US')){var j=new U(d.getTime());j.setUTCFullYear(y,0,1);W=j.getUTCDay();var e=new U(d.getTime());e.setUTCDate(e.getUTCDate()-e.getUTCDay()+W);w=Math.round((e.getTime()-j.getTime())/86400000/7)+1;}else{var t=new U(d.getTime());t.setUTCDate(t.getUTCDate()-f);W=t.getUTCDay();t.setUTCDate(t.getUTCDate()-W+4);var F=new U(t.getTime());F.setUTCMonth(0,1);W=F.getUTCDay();var A=0;if(W>4){A=7;}var g=new U(F.getTime());g.setUTCDate(1-W+4+A);w=Math.round((t.getTime()-g.getTime())/86400000/7)+1;}return w;};
b.getFirstDateOfWeek=function(d){var u=new U(d.getTime()),f,F,l=a.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),c=l.getFirstDayOfWeek(),w;w=U.getWeekByDate(u.getCalendarType(),u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate());f=U.getFirstDateOfWeek(u.getCalendarType(),w.year,w.week);F=new U(Date.UTC(f.year,f.month,f.day));while(F.getUTCDay()!==c){F.setUTCDate(F.getUTCDate()-1);}return new U(Date.UTC(F.getUTCFullYear(),F.getUTCMonth(),F.getUTCDate(),d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds())).getJSDate();};
b.getFirstDateOfMonth=function(d){var n=new U(d.getTime());n.setUTCDate(1);return n;};
b._getNumberOfWeeksForYear=function(y){var l=sap.ui.getCore().getConfiguration().getFormatLocale(),o=a.getInstance(new L(l)),c=new Date(Date.UTC(y,0,1)),i=c.getUTCDay(),n=52;if(o.getFirstDayOfWeek()===0){if(i===5||i===6){n=53;}}else{if(i===3||i===4){n=53;}}return n;};
b.monthsDiffer=function(d,D){return(d.getMonth()!==D.getMonth()||d.getFullYear()!==D.getFullYear());};
b.isDateLastInMonth=function(d){var n=new Date(d.getTime()+24*60*60*1000);return n.getUTCDate()<d.getUTCDate();};
b._updateUTCDate=function(d,y,m,D,h,M,s,i){if(q.isNumeric(y)){d.setUTCFullYear(y);}if(q.isNumeric(m)){d.setUTCMonth(m);}if(q.isNumeric(D)){d.setUTCDate(D);}if(q.isNumeric(h)){d.setUTCHours(h);}if(q.isNumeric(M)){d.setUTCMinutes(M);}if(q.isNumeric(s)){d.setUTCSeconds(s);}if(q.isNumeric(i)){d.setUTCMilliseconds(i);}};
b._checkJSDateObject=function(d){if(q.type(d)!=="date"){throw new Error("Date must be a JavaScript date object.");}};
b._checkYearInValidRange=function(y){if(!q.isNumeric(y)||(y<1||y>9999)){throw new Error("Year must be in valid range (between year 0001 and year 9999).");}};
b._isNextMonth=function(d,D){return(d.getMonth()>D.getMonth()&&d.getFullYear()===D.getFullYear())||d.getFullYear()>D.getFullYear();};
b._daysInMonth=function(c){this._checkCalendarDate(c);c=new C(c);c.setDate(1);c.setMonth(c.getMonth()+1);c.setDate(0);return c.getDate();};
b._isLastDateInMonth=function(c){return c.getDate()===b._daysInMonth(c);};
b._getFirstDateOfWeek=function(c){this._checkCalendarDate(c);var j=b.getFirstDateOfWeek(c.toUTCJSDate());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
b._getFirstDateOfMonth=function(c){this._checkCalendarDate(c);var j=b.getFirstDateOfMonth(c.toUTCJSDate()).getJSDate();j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
b._minDate=function(c){return new C(1,0,1,c);};
b._maxDate=function(c){var o=new C(9999,11,1,c);o.setDate(this._daysInMonth(o));return new C(o);};
b._isBetween=function(d,s,e,i){this._checkCalendarDate(d);this._checkCalendarDate(s);this._checkCalendarDate(e);if(i){return d.isSameOrAfter(s)&&d.isSameOrBefore(e);}else{return d.isAfter(s)&&d.isBefore(e);}};
b._daysBetween=function(f,s){this._checkCalendarDate(f);this._checkCalendarDate(s);return Math.ceil((f.valueOf()-s.valueOf())/(this.HOURS24));};
b._isOutside=function(c,s,e){return!this._isBetween(c,s,e,true);};
b._isSameMonthAndYear=function(c,o){this._checkCalendarDate(c);this._checkCalendarDate(o);return c.getYear()===o.getYear()&&c.getMonth()===o.getMonth();};
b._checkCalendarDate=function(c){if(!c||!(c instanceof C)){throw"Invalid calendar date: ["+c+"]. Expected: sap.ui.unified.calendar.CalendarDate";}};
b._getWeek=function(c){this._checkCalendarDate(c);return U.getWeekByDate(c.getCalendarType(),c.getYear(),c.getMonth(),c.getDate());};
return b;},true);
sap.ui.predefine('sap/ui/unified/calendar/DatesRow',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/Month','sap/ui/unified/library',"./DatesRowRenderer"],function(q,C,a,M,l,D){"use strict";
var b=M.extend("sap.ui.unified.calendar.DatesRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true}}}});
b.prototype.init=function(){M.prototype.init.apply(this,arguments);this._iColumns=1;this._aWeekNumbers=[];};
b.prototype.setStartDate=function(s){C._checkJSDateObject(s);var y=s.getFullYear();C._checkYearInValidRange(y);this.setProperty("startDate",s,true);this._oStartDate=a.fromLocalJSDate(s,this.getPrimaryCalendarType());if(this.getDomRef()){var o=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(s);this._bNoRangeCheck=false;if(o&&this.checkDateFocusable(o)){this.displayDate(o);}}return this;};
b.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=a.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oStartDate;};
b.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.setDate.apply(this,arguments);return this;};
b.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.displayDate.apply(this,arguments);return this;};
b.prototype.setPrimaryCalendarType=function(c){M.prototype.setPrimaryCalendarType.apply(this,arguments);if(this._oStartDate){this._oStartDate=new a(this._oStartDate,c);}return this;};
b.prototype.setFirstDayOfWeek=function(f){if(f==-1){return this.setProperty("firstDayOfWeek",f,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
b.prototype._handleBorderReached=function(c){var e=c.getParameter("event");var d=this.getDays();var o=this._getDate();var f=new a(o,this.getPrimaryCalendarType());if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":f.setDate(f.getDate()+1);break;case"sapprevious":case"sappreviousmodifiers":f.setDate(f.getDate()-1);break;case"sappagedown":f.setDate(f.getDate()+d);break;case"sappageup":f.setDate(f.getDate()-d);break;default:break;}this.fireFocus({date:f.toLocalJSDate(),otherMonth:true,_outsideBorder:true});}};
b.prototype.checkDateFocusable=function(d){C._checkJSDateObject(d);if(this._bNoRangeCheck){return false;}var s=this._getStartDate();var e=new a(s,this.getPrimaryCalendarType());e.setDate(e.getDate()+this.getDays());var c=a.fromLocalJSDate(d,this.getPrimaryCalendarType());return c.isSameOrAfter(s)&&c.isBefore(e);};
b.prototype._renderHeader=function(){var s=this._getStartDate();var S=s.getDay();var L=this._getLocaleData();var w=this.$("Names").children();var W=[];if(this._bLongWeekDays||!this._bNamesLengthChecked){W=L.getDaysStandAlone("abbreviated");}else{W=L.getDaysStandAlone("narrow");}var c=L.getDaysStandAlone("wide");var i=0;for(i=0;i<w.length;i++){var $=q(w[i]);$.text(W[(i+S)%7]);$.attr("aria-label",c[(i+S)%7]);}if(this._getShowHeader()){var d=this.$("Head");if(d.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(r,this,L,s);r.flush(d[0]);r.destroy();}}};
b.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay();};
b.prototype.getWeekNumbers=function(){var d=this.getDays(),L=this._getLocale(),o=this._getLocaleData(),c=this.getPrimaryCalendarType(),s=this._getStartDate(),e=new a(s,c),E=new a(s,c).setDate(e.getDate()+d),f=[];while(e.isBefore(E)){f.push(new a(e,c));e.setDate(e.getDate()+1);}this._aWeekNumbers=f.reduce(function(w,g){var W=C.calculateWeekNumber(g.toUTCJSDate(),g.getYear(),L,o);if(!w.length||w[w.length-1].number!==W){w.push({len:0,number:W});}w[w.length-1].len++;return w;},[]);return this._aWeekNumbers;};
b.prototype._getCachedWeekNumbers=function(){return this._aWeekNumbers;};
return b;});
sap.ui.predefine('sap/ui/unified/calendar/DatesRowRenderer',['sap/ui/core/Renderer','sap/ui/unified/calendar/CalendarDate','./MonthRenderer'],function(R,C,M){"use strict";var D=R.extend(M);
D.getStartDate=function(d){return d._getStartDate();};
D.getClass=function(r,d){var c="sapUiCalDatesRow sapUiCalRow";if(!d.getShowDayNamesLine()){c=c+" sapUiCalNoNameLine";}return c;};
D.renderMonth=function(r,d,o){M.renderMonth.apply(this,arguments);this.renderWeekNumbers(r,d);};
D.renderWeekNumbers=function(r,d){var o,i,a,w;if(d.getShowWeekNumbers()&&d.getPrimaryCalendarType()===sap.ui.core.CalendarType.Gregorian){o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");r.write("<div id=\""+d.getId()+"-weeks\"");r.addClass("sapUiCalRowWeekNumbers");r.writeClasses();r.write(">");i=d.getDays();a=100/i;w=d.getWeekNumbers();w.forEach(function(W){r.write("<div");r.addClass('sapUiCalRowWeekNumber');r.writeClasses();r.addStyle("width",W.len*a+"%");r.writeStyles();r.writeAttribute("data-sap-ui-week",W.number);r.write(">"+o.getText('CALENDAR_DATES_ROW_WEEK_NUMBER',[W.number])+"</div>");});r.write("</div>");}};
D.renderHeader=function(r,d,o){var l=d._getLocaleData();var i=d.getId();var a=d.getDays();var w="";if(d._getShowHeader()){r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,d,l,o);r.write("</div>");}w=(100/a)+"%";if(d.getShowDayNamesLine()){r.write("<div id=\""+i+"-Names\" style=\"display: inline;\">");this.renderDayNames(r,d,l,o.getDay(),a,false,w);r.write("</div>");}};
D.renderHeaderLine=function(r,d,l,o){var I=d.getId();var a=d.getDays();var b=new C(o,d.getPrimaryCalendarType());var w="";var m=0;var c=[];var i=0;for(i=0;i<a;i++){m=b.getMonth();if(c.length>0&&c[c.length-1].iMonth==m){c[c.length-1].iDays++;}else{c.push({iMonth:m,iDays:1});}b.setDate(b.getDate()+1);}var e=l.getMonthsStandAlone("wide");for(i=0;i<c.length;i++){var f=c[i];w=(100/a*f.iDays)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(e[f.iMonth]);r.write("</div>");}};
D.renderDays=function(r,d,o){var a=d.getDays();var w=(100/a)+"%";var s=d.getShowDayNamesLine();if(!o){o=d._getFocusedDate();}var h=this.getDayHelper(d,o);if(!s){if(d._bLongWeekDays||!d._bNamesLengthChecked){h.aWeekDays=h.oLocaleData.getDaysStandAlone("abbreviated");}else{h.aWeekDays=h.oLocaleData.getDaysStandAlone("narrow");}h.aWeekDaysWide=h.oLocaleData.getDaysStandAlone("wide");}var b=new C(o,d.getPrimaryCalendarType());for(var i=0;i<a;i++){this.renderDay(r,d,b,h,false,false,i,w,!s);b.setDate(b.getDate()+1);}};
return D;},true);
sap.ui.predefine('sap/ui/unified/calendar/Header',['jquery.sap.global','sap/ui/core/Control','sap/ui/unified/library',"./HeaderRenderer"],function(q,C,l,H){"use strict";
var a=C.extend("sap.ui.unified.calendar.Header",{metadata:{library:"sap.ui.unified",properties:{textButton0:{type:"string",group:"Appearance"},additionalTextButton0:{type:"string",group:"Appearance"},ariaLabelButton0:{type:"string",group:"Misc"},visibleButton0:{type:"boolean",group:"Appearance",defaultValue:false},textButton1:{type:"string",group:"Appearance"},additionalTextButton1:{type:"string",group:"Appearance"},ariaLabelButton1:{type:"string",group:"Misc"},visibleButton1:{type:"boolean",group:"Appearance",defaultValue:true},textButton2:{type:"string",group:"Appearance"},additionalTextButton2:{type:"string",group:"Appearance"},ariaLabelButton2:{type:"string",group:"Misc"},visibleButton2:{type:"boolean",group:"Appearance",defaultValue:true},enabledPrevious:{type:"boolean",group:"Behavior",defaultValue:true},enabledNext:{type:"boolean",group:"Behavior",defaultValue:true}},events:{pressPrevious:{},pressNext:{},pressButton0:{},pressButton1:{},pressButton2:{}}}});
a.prototype.setTextButton0=function(t){_.call(this,0,t);return this;};
a.prototype.setAdditionalTextButton0=function(t){b.call(this,0,t);return this;};
a.prototype.setAriaLabelButton0=function(t){c.call(this,0,t);return this;};
a.prototype.setTextButton1=function(t){_.call(this,1,t);return this;};
a.prototype.setAdditionalTextButton1=function(t){b.call(this,1,t);return this;};
a.prototype.setAriaLabelButton1=function(t){c.call(this,1,t);return this;};
a.prototype.setTextButton2=function(t){_.call(this,2,t);return this;};
a.prototype.setAdditionalTextButton2=function(t){b.call(this,2,t);return this;};
a.prototype.setAriaLabelButton2=function(t){c.call(this,2,t);return this;};
a.prototype.setEnabledPrevious=function(e){this.setProperty("enabledPrevious",e,true);if(this.getDomRef()){if(e){this.$("prev").toggleClass("sapUiCalDsbl",false).removeAttr("disabled");}else{this.$("prev").toggleClass("sapUiCalDsbl",true).attr("disabled","disabled");}}return this;};
a.prototype.setEnabledNext=function(e){this.setProperty("enabledNext",e,true);if(this.getDomRef()){if(e){this.$("next").toggleClass("sapUiCalDsbl",false).removeAttr("disabled");}else{this.$("next").toggleClass("sapUiCalDsbl",true).attr("disabled","disabled");}}return this;};
a.prototype.onclick=function(e){if(e.isMarked("delayedMouseEvent")){return;}if(q.sap.containsOrEquals(this.getDomRef("prev"),e.target)&&this.getEnabledPrevious()){this.firePressPrevious();}else if(q.sap.containsOrEquals(this.getDomRef("next"),e.target)&&this.getEnabledNext()){this.firePressNext();}else if(q.sap.containsOrEquals(this.getDomRef("B0"),e.target)){this.firePressButton0();}else if(q.sap.containsOrEquals(this.getDomRef("B1"),e.target)){this.firePressButton1();}else if(q.sap.containsOrEquals(this.getDomRef("B2"),e.target)){this.firePressButton2();}};
a.prototype.onsapnext=function(e){e.preventDefault();};
function _(B,t){this.setProperty("textButton"+B,t,true);if(this.getDomRef()&&this["getVisibleButton"+B]()){if(this.$("B"+B+"-Text").get(0)){this.$("B"+B+"-Text").text(t);}else{this.$("B"+B).text(t);}}}
function b(B,t){var r=false;var o=this["getAdditionalTextButton"+B]();if(o==t){return;}if((!o&&t)||(o&&!t)){r=true;}this.setProperty("additionalTextButton"+B,t,!r);if(!r&&this.getDomRef()&&this["getVisibleButton"+B]()){this.$("B"+B+"-AddText").text(t);}}
function c(B,t){this.setProperty("ariaLabelButton"+B,t,true);if(this.getDomRef()&&this["getVisibleButton"+B]()){if(t){this.$("B"+B).attr("aria-label",t);}else{this.$("B"+B).removeAttr("aria-label");}}}
return a;});
sap.ui.predefine('sap/ui/unified/calendar/HeaderRenderer',['jquery.sap.global'],function(q){"use strict";var H={};
H.render=function(r,h){var l=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var t=h.getTooltip_AsString();var I=h.getId();var a={};var L=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_NEXT");var s=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_PREV");r.write("<div");r.writeControlData(h);r.addClass("sapUiCalHead");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(h);r.write(">");r.write("<button");r.writeAttributeEscaped('id',I+'-prev');r.writeAttributeEscaped("title",s);r.writeAccessibilityState(null,{label:s});r.addClass("sapUiCalHeadPrev");if(!h.getEnabledPrevious()){r.addClass("sapUiCalDsbl");r.writeAttribute('disabled',"disabled");}r.writeAttribute('tabindex',"-1");r.writeClasses();r.write(">");r.writeIcon("sap-icon://slim-arrow-left",null,{title:null});r.write("</button>");var f=-1;var b=-1;var i=0;var B;for(i=0;i<3;i++){if(h["getVisibleButton"+i]()){if(f<0){f=i;}b=i;}}for(i=0;i<3;i++){if(l.toLowerCase()==="ja"||l.toLowerCase()==="zh"){B=2-i;}else{B=i;}this.renderCalendarButtons(r,h,I,f,b,a,B);}r.write("<button");r.writeAttributeEscaped('id',I+'-next');r.writeAttributeEscaped("title",L);r.writeAccessibilityState(null,{label:L});r.addClass("sapUiCalHeadNext");if(!h.getEnabledNext()){r.addClass("sapUiCalDsbl");r.writeAttribute('disabled',"disabled");}r.writeAttribute('tabindex',"-1");r.writeClasses();r.write(">");r.writeIcon("sap-icon://slim-arrow-right",null,{title:null});r.write("</button>");r.write("</div>");};
H.renderCalendarButtons=function(r,h,I,f,l,a,i){if(h["getVisibleButton"+i]()){r.write("<button");r.writeAttributeEscaped('id',I+'-B'+i);r.addClass("sapUiCalHeadB");r.addClass("sapUiCalHeadB"+i);if(f==i){r.addClass("sapUiCalHeadBFirst");}if(l==i){r.addClass("sapUiCalHeadBLast");}r.writeAttribute('tabindex',"-1");r.writeClasses();if(h["getAriaLabelButton"+i]()){a["label"]=q.sap.encodeHTML(h["getAriaLabelButton"+i]());}r.writeAccessibilityState(null,a);a={};r.write(">");var t=h["getTextButton"+i]()||"";var A=h["getAdditionalTextButton"+i]()||"";if(A){r.write("<span");r.writeAttributeEscaped('id',I+'-B'+i+"-Text");r.addClass("sapUiCalHeadBText");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</span>");r.write("<span");r.writeAttributeEscaped('id',I+'-B'+i+"-AddText");r.addClass("sapUiCalHeadBAddText");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</span>");}else{r.writeEscaped(t);}r.write("</button>");}};
return H;},true);
sap.ui.predefine('sap/ui/unified/calendar/Month',['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthRenderer",'jquery.sap.keycodes'],function(q,C,D,L,I,a,b,l,c,d,e,M){"use strict";var f=d.CalendarType;var g=l.CalendarDayType;
var h=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}}}}});
h.prototype.init=function(){var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._oFormatYyyymmdd=c.getInstance({pattern:"yyyyMMdd",calendarType:f.Gregorian});this._oFormatLong=c.getInstance({style:"long",calendarType:i});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._iColumns=7;this._aVisibleDays=[];};
h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}this._aVisibleDays=null;};
h.prototype.onAfterRendering=function(){_.call(this);u.call(this);};
h.prototype.onmouseover=function(E){var T=q(E.target),S,i,v;if(!this.getIntervalSelection()){return;}S=this.getSelectedDates()[0];if(!S||!S.getStartDate()||S.getEndDate()){return;}if(!T.hasClass('sapUiCalItemText')&&!T.hasClass('sapUiCalItem')){return;}if(T.hasClass('sapUiCalItemText')){T=T.parent();}i=parseInt(this._oFormatYyyymmdd.format(S.getStartDate()),10);v=T.data("sapDay");if(i>v){i=i+v;v=i-v;i=i-v;}if(this.hasListeners("datehovered")){this.fireEvent("datehovered",{date1:i,date2:v});}else{this._markDatesBetweenStartAndHoveredDate(i,v);}};
h.prototype._markDatesBetweenStartAndHoveredDate=function(v,w){var x,$,y,i;x=this.$().find(".sapUiCalItem");for(i=0;i<x.length;i++){$=q(x[i]);y=$.data('sapDay');if(y>v&&y<w){$.addClass('sapUiCalItemSelBetween');}else{$.removeClass('sapUiCalItemSelBetween');}}};
h.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var S=p.call(this,this._getDate());if(!S&&this._oMoveSelectedDate){p.call(this,this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;t.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}}};
h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
h.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};
h.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
h.prototype.setDate=function(i){var v=b.fromLocalJSDate(i,this.getPrimaryCalendarType());n.call(this,v,false);return this;};
h.prototype._setDate=function(i){var v=i.toLocalJSDate();this.setProperty("date",v,true);this._oDate=i;};
h.prototype._getDate=function(){if(!this._oDate){this._oDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oDate;};
h.prototype.displayDate=function(i){var v=b.fromLocalJSDate(i,this.getPrimaryCalendarType());n.call(this,v,true);return this;};
h.prototype.setPrimaryCalendarType=function(i){this.setProperty("primaryCalendarType",i);this._oFormatLong=c.getInstance({style:"long",calendarType:i});if(this._oDate){this._oDate=new b(this._oDate,i);}return this;};
h.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i);this.invalidate();this._oFormatSecondaryLong=c.getInstance({style:"long",calendarType:i});return this;};
h.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};
h.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
h.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var v=new e(i);this._oLocaleData=L.getInstance(v);}return this._oLocaleData;};
h.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var v=new e(i);this._oFormatLong=c.getInstance({style:"long",calendarType:this.getPrimaryCalendarType()},v);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=c.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},v);}}return this._oFormatLong;};
h.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
h.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
h.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
h.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
h.prototype.getDisabledDates=function(){var P=this.getParent();if(P&&P.getDisabledDates){return P.getDisabledDates();}else{return this.getAggregation("disabledDates",[]);}};
h.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowMonthHeader){return P._getShowMonthHeader();}else{return this.getProperty("showHeader");}};
h.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
h.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("legend",[]);}};
h.prototype._getFirstDayOfWeek=function(){var P=this.getParent();var F=0;if(P&&P.getFirstDayOfWeek){F=P.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var i=this._getLocaleData();F=i.getFirstDayOfWeek();}return F;};
h.prototype._getNonWorkingDays=function(){var P=this.getParent();var N;if(P&&P.getNonWorkingDays){N=P.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!q.isArray(N)){N=[];}return N;};
h.prototype._checkDateSelected=function(v){a._checkCalendarDate(v);var S=0;var w=this.getSelectedDates();var T=v.toUTCJSDate().getTime();var x=this.getPrimaryCalendarType();for(var i=0;i<w.length;i++){var R=w[i];var y=R.getStartDate();var z=0;if(y){y=b.fromLocalJSDate(y,x);z=y.toUTCJSDate().getTime();}var E=R.getEndDate();var A=0;if(E){E=b.fromLocalJSDate(E,x);A=E.toUTCJSDate().getTime();}if(T==z&&!E){S=1;break;}else if(T==z&&E){S=2;if(E&&T==A){S=5;}break;}else if(E&&T==A){S=3;break;}else if(E&&T>z&&T<A){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
h.prototype._getDateTypes=function(v){a._checkCalendarDate(v);var T,w,N,x=[];var S=this.getSpecialDates();var y=v.toUTCJSDate().getTime();var z=this.getPrimaryCalendarType();for(var i=0;i<S.length;i++){var R=S[i];var A=R.getStartDate();var B=a.MAX_MILLISECONDS;if(A){A=b.fromLocalJSDate(A,z);B=A.toUTCJSDate().getTime();}var E=R.getEndDate();var F=-a.MAX_MILLISECONDS;if(E){E=b.fromLocalJSDate(E,z);F=E.toUTCJSDate().getTime();}N=R.getType()===g.NonWorking;if((y==B&&!E)||(y>=B&&y<=F)){if(!N&&!T){T={type:R.getType(),tooltip:R.getTooltip_AsString()};x.push(T);}else if(N&&!w){w={type:R.getType(),tooltip:R.getTooltip_AsString()};x.push(w);}if(T&&w){break;}}}return x;};
h.prototype._checkDateEnabled=function(v){a._checkCalendarDate(v);var E=true;var w=this.getDisabledDates();var T=v.toUTCJSDate().getTime();var x=this.getPrimaryCalendarType();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(T<P._oMinDate.valueOf()||T>P._oMaxDate.valueOf()){return false;}}for(var i=0;i<w.length;i++){var R=w[i];var S=R.getStartDate();var y=0;if(S){S=b.fromLocalJSDate(S,x);y=S.toUTCJSDate().getTime();}var z=R.getEndDate();var A=0;if(z){z=b.fromLocalJSDate(z,x);A=z.toUTCJSDate().getTime();}if(z){if(T>y&&T<A){E=false;break;}}else if(T==y){E=false;break;}}return E;};
h.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
h.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(this._sLastTargetId&&this._sLastTargetId==T.attr("id")){return;}this._sLastTargetId=T.attr("id");if(T.hasClass("sapUiCalItem")){var O=this._getDate();if(!q.sap.containsOrEquals(this.getDomRef(),E.target)){var S=this.getSelectedDates();if(S.length>0&&this.getSingleSelection()){var i=S[0].getStartDate();if(i){i=b.fromLocalJSDate(i,this.getPrimaryCalendarType());}var v=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(T.attr("data-sap-day")));if(v.isSameOrAfter(i)){r.call(this,i,v);}else{r.call(this,v,i);}}}else{var F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(T.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F.isSame(O)){if(T.hasClass("sapUiCalItemOtherMonth")){this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}else{this._setDate(F);var w=p.call(this,F,true);if(w){this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}this._bMoveChange=true;}}}}};
h.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
h.prototype.onmouseup=function(E){if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var v=this._oItemNavigation.getItemDomRefs();for(var i=0;i<v.length;i++){var $=q(v[i]);if(!$.hasClass("sapUiCalItemOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F.toUTCJSDate(),true)){$.focus();break;}}}if(this._bMoveChange){var S=p.call(this,F);if(!S&&this._oMoveSelectedDate){p.call(this,this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;t.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)&&E.target.classList.contains("sapUiCalItemText")){var w=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(E.target).parent().attr("data-sap-day")),this.getPrimaryCalendarType());p.call(this,w,false,false);t.call(this);}};
h.prototype.onsapselect=function(E){var S=p.call(this,this._getDate());if(S){t.call(this);}E.stopPropagation();E.preventDefault();};
h.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
h.prototype.onsappageupmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{F.setYear(y-1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
h.prototype.onsappagedownmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{F.setYear(y+1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
h.prototype._updateSelection=function(){var S=this.getSelectedDates();if(S.length>0){var i=this.getPrimaryCalendarType();var v=S.map(function(w){var x=w.getStartDate();if(x){return b.fromLocalJSDate(x,i);}});var E=S[0].getEndDate();if(E){E=b.fromLocalJSDate(E,i);}r.call(this,v,E);}};
h.prototype._isValueInThreshold=function(R,v,T){var i=R-T,U=R+T;return v>=i&&v<=U;};
h.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};
h.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(F){this.fireEvent("_unbindMousemove");}};
h.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().find(".sapUiCalWH");var v=this._getLocaleData();var S=this._getFirstWeekDay();var x=v.getDaysStandAlone("abbreviated",this.getPrimaryCalendarType());for(var i=0;i<w.length;i++){var W=w[i];q(W).text(x[(i+S)%7]);}u.call(this);};
h.prototype._handleBorderReached=function(i){var E=i.getParameter("event");var v=0;var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN){F.setDate(F.getDate()+7);}else{F.setDate(F.getDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP){F.setDate(F.getDate()-7);}else{F.setDate(F.getDate()-1);}break;case"sappagedown":v=F.getMonth()+1;F.setMonth(v);if(v%12!=F.getMonth()){while(v!=F.getMonth()){F.setDate(F.getDate()-1);}}break;case"sappageup":v=F.getMonth()-1;F.setMonth(v);if(v<0){v=11;}if(v!=F.getMonth()){while(v!=F.getMonth()){F.setDate(F.getDate()-1);}}break;default:break;}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}};
h.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);var v=this._getDate();var w=b.fromLocalJSDate(i,this.getPrimaryCalendarType());return a._isSameMonthAndYear(w,v);};
h.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
h.prototype._renderHeader=function(){if(this._getShowHeader()){var i=this._getDate();var v=this._getLocaleData();var w=v.getMonthsStandAlone("wide",this.getPrimaryCalendarType());this.$("Head").text(w[i.getMonth()]);}};
h.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek();};
h.prototype._isMonthNameLong=function(w){var i;var W;for(i=0;i<w.length;i++){W=w[i];if(Math.abs(W.clientWidth-W.scrollWidth)>1){return true;}}return false;};
h.prototype._getVisibleDays=function(S,i){var N,v,w,x,F,y,Y;if(!S){return this._aVisibleDays;}this._aVisibleDays=[];y=this._getFirstDayOfWeek();F=new b(S,this.getPrimaryCalendarType());F.setDate(1);x=F.getDay()-y;if(x<0){x=7+x;}if(x>0){F.setDate(1-x);}v=new b(F);N=(S.getMonth()+1)%12;do{Y=v.getYear();w=new b(v,this.getPrimaryCalendarType());if(i&&Y<1){w._bBeforeFirstYear=true;this._aVisibleDays.push(w);}else if(Y>0&&Y<10000){this._aVisibleDays.push(w);}v.setDate(v.getDate()+1);}while(v.getMonth()!==N||v.getDay()!==y);return this._aVisibleDays;};
function _(){var y=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var v=0;var R=this.$("days").get(0);var w=this.$("days").find(".sapUiCalItem");for(var i=0;i<w.length;i++){var $=q(w[i]);if($.attr("data-sap-day")===y){v=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,j,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,k,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(w);this._oItemNavigation.setFocusedIndex(v);this._oItemNavigation.setPageSize(w.length);}
function j(v){var w=v.getParameter("index");var E=v.getParameter("event");if(!E){return;}var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());var x=false;var y=true;var z=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(z[w]);var A;if($.hasClass("sapUiCalItemOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setDate(1);this._focusDate(F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=z.length-1;i>0;i--){A=q(z[i]);if(!A.hasClass("sapUiCalItemOtherMonth")){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(A.attr("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else{x=true;F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F){F=new b(O);}this._focusDate(O);if(E.type=="mousedown"||(this._sTouchstartYyyyMMdd&&E.type=="focusin"&&this._sTouchstartYyyyMMdd==$.attr("data-sap-day"))){y=false;this.fireFocus({date:O.toLocalJSDate(),otherMonth:false,restoreOldDate:true});}if(E.originalEvent&&E.originalEvent.type=="touchstart"){this._sTouchstartYyyyMMdd=$.attr("data-sap-day");}else{this._sTouchstartYyyyMMdd=undefined;}}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){this._focusDate(F);}else{F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());this._setDate(F);}this._sTouchstartYyyyMMdd=undefined;}if(E.type=="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=$.attr("id");}if(y){this.fireFocus({date:F.toLocalJSDate(),otherMonth:x});}if(E.type=="mousedown"){m.call(this,E,F,w);}}
function k(i){var v=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();if(this.getIntervalSelection()){var w=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=w[v].id;}m.call(this,E,F,v);}}
function m(E,F,i){if(E.button||D.support.touch){return;}var S=p.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}E.preventDefault();E.setMark("cancelAutoClose");}
function n(i,N){a._checkCalendarDate(i);var y=i.getYear();a._checkYearInValidRange(y);var F=true;if(!this.getDate()||!i.isSame(b.fromLocalJSDate(this.getDate(),i.getCalendarType()))){var v=new b(i);F=this.checkDateFocusable(i.toLocalJSDate());this.setProperty("date",i.toLocalJSDate(),true);this._oDate=v;}if(this.getDomRef()){if(F){this._focusDate(this._oDate,true,N);}else{o.call(this,N);}}}
h.prototype._focusDate=function(v,S,w){if(!S){this.setDate(v.toLocalJSDate());}var y=this._oFormatYyyymmdd.format(v.toUTCJSDate(),true);var x=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<x.length;i++){$=q(x[i]);if($.attr("data-sap-day")==y){if(document.activeElement!=x[i]){if(w){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}};
function o(N){var v=this.getRenderer().getStartDate(this);var $=this.$("days");var w=this.$("weeks");var x;var y;var i=0;var z=0;if(this._sLastTargetId){x=this._oItemNavigation.getItemDomRefs();for(i=0;i<x.length;i++){y=q(x[i]);if(y.attr("id")==this._sLastTargetId){z=i;break;}}}if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderDays(R,this,v);R.flush($[0]);if(w.length){this.getRenderer().renderWeekNumbers(R,this);R.flush(w[0]);}R.destroy();}this._renderHeader();this.fireEvent("_renderMonth",{days:$.find(".sapUiCalItem").length});_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}if(this._sLastTargetId){x=this._oItemNavigation.getItemDomRefs();if(z<=x.length-1){y=q(x[z]);this._sLastTargetId=y.attr("id");}}}
function p(v,w){if(!this._checkDateEnabled(v)){return false;}var S=this.getSelectedDates();var x;var y=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var A=this;var z;var B=this.getPrimaryCalendarType();if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){x=S[0];z=x.getStartDate();if(z){z=b.fromLocalJSDate(z,B);}}else{x=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",x,true);}if(this.getIntervalSelection()&&(!x.getEndDate()||w)&&z){var E;if(v.isBefore(z)){E=z;z=v;if(!w){x.setProperty("startDate",z.toLocalJSDate(),true);x.setProperty("endDate",E.toLocalJSDate(),true);}}else if(v.isSameOrAfter(z)){E=v;if(!w){x.setProperty("endDate",E.toLocalJSDate(),true);}}r.call(this,z,E);}else{r.call(this,v);x.setProperty("startDate",v.toLocalJSDate(),true);x.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var F=this._checkDateSelected(v);if(F>0){for(i=0;i<S.length;i++){z=S[i].getStartDate();if(z&&v.isSame(b.fromLocalJSDate(z,B))){A.removeAggregation("selectedDates",i,true);break;}}}else{x=new sap.ui.unified.DateRange({startDate:v.toLocalJSDate()});A.addAggregation("selectedDates",x,true);}Y=this._oFormatYyyymmdd.format(v.toUTCJSDate(),true);for(i=0;i<y.length;i++){$=q(y[i]);if($.attr("data-sap-day")==Y){if(F>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function r(S,E){if(!Array.isArray(S)){S=[S];}var v=this._oItemNavigation.getItemDomRefs();var $;var i=0;var w=false;var x=false;if(!E){var y=S.map(function(A){return this._oFormatYyyymmdd.format(A.toUTCJSDate(),true);},this);for(i=0;i<v.length;i++){$=q(v[i]);w=false;x=false;if(y.indexOf($.attr("data-sap-day"))>-1){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");w=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}s.call(this,$,w,x);}}else{var z;for(i=0;i<v.length;i++){$=q(v[i]);w=false;x=false;z=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),f.Gregorian);if(z.isSame(S[0])){$.addClass("sapUiCalItemSelStart");w=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&z.isSame(E)){$.addClass("sapUiCalItemSelEnd");x=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(z,S[0],E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&z.isSame(E)){$.addClass("sapUiCalItemSelEnd");x=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}s.call(this,$,w,x);}}}
function s($,S,E){if(!this.getIntervalSelection()){return;}var v="";var w=[];var x=this.getId();var y=false;v=$.attr("aria-describedby");if(v){w=v.split(" ");}var z=-1;var A=-1;for(var i=0;i<w.length;i++){var B=w[i];if(B==(x+"-Start")){z=i;}if(B==(x+"-End")){A=i;}}if(z>=0&&!S){w.splice(z,1);y=true;if(A>z){A--;}}if(A>=0&&!E){w.splice(A,1);y=true;}if(z<0&&S){w.push(x+"-Start");y=true;}if(A<0&&E){w.push(x+"-End");y=true;}if(y){v=w.join(" ");$.attr("aria-describedby",v);}}
function t(){if(this._bMouseMove){this._unbindMousemove(true);}this.fireSelect();}
function u(){if(!this._bNamesLengthChecked){var w;var W=this.$().find(".sapUiCalWH");var T=this._isMonthNameLong(W);var i=0;if(T){this._bLongWeekDays=false;var v=this._getLocaleData();var S=this._getFirstWeekDay();var x=v.getDaysStandAlone("narrow",this.getPrimaryCalendarType());for(i=0;i<W.length;i++){w=W[i];q(w).text(x[(i+S)%7]);}}else{this._bLongWeekDays=true;}this._bNamesLengthChecked=true;}}
return h;});
sap.ui.predefine('sap/ui/unified/calendar/MonthPicker',['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/library','sap/ui/core/Locale',"./MonthPickerRenderer"],function(q,C,D,L,I,l,a,M){"use strict";
var c=C.extend("sap.ui.unified.calendar.MonthPicker",{metadata:{library:"sap.ui.unified",properties:{month:{type:"int",group:"Data",defaultValue:0},months:{type:"int",group:"Appearance",defaultValue:12},columns:{type:"int",group:"Appearance",defaultValue:3},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});
c.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._iMinMonth=0;this._iMaxMonth=11;};
c.prototype.onAfterRendering=function(){_.call(this);j.call(this);};
c.prototype.setMonth=function(m){this.setProperty("month",m,true);m=this.getProperty("month");if(m<0||m>11){throw new Error("Property month must be between 0 and 11; "+this);}if(this.getDomRef()){if(this.getMonths()<12){var s=this.getStartMonth();if(m>=s&&m<=s+this.getMonths()-1){h.call(this,m,true);this._oItemNavigation.focusItem(m-s);}else{k.call(this,m);}}else{h.call(this,m,true);this._oItemNavigation.focusItem(m);}}return this;};
c.prototype._getLocale=function(){var p=this.getParent();if(p&&p._getLocale){return p._getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
c.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var o=new a(s);this._oLocaleData=L.getInstance(o);}return this._oLocaleData;};
c.prototype.onsapspace=function(E){E.preventDefault();};
c.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var m=i+this.getStartMonth();if(m>=this._iMinMonth&&m<=this._iMaxMonth){h.call(this,m);this.fireSelect();}};
c.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
c.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){var i=this._oItemNavigation.getFocusedIndex();var m=i+this.getStartMonth();h.call(this,m);this.fireSelect();}};
c.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;var m=this._oItemNavigation.getItemDomRefs();this._bLongMonth=false;var o=this._getLocaleData();var b=o.getMonthsStandAlone("wide",this.getPrimaryCalendarType());for(var i=0;i<m.length;i++){var $=q(m[i]);$.text(b[i]);}j.call(this);};
c.prototype.nextPage=function(){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();m=m+b;if(m>11){m=11;}k.call(this,m);return this;};
c.prototype.previousPage=function(){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();m=m-b;if(m<0){m=0;}k.call(this,m);return this;};
c.prototype.setMinMax=function(m,b){if(m==this._iMinMonth&&b==this._iMaxMonth){return this;}m=parseInt(m,10);if(isNaN(m)||m<0||m>11){m=0;}b=parseInt(b,10);if(isNaN(b)||b<0||b>11){b=11;}if(m<=b){this._iMinMonth=m;this._iMaxMonth=b;}else{this._iMaxMonth=m;this._iMinMonth=b;}if(this.getDomRef()){var n=this._oItemNavigation.getItemDomRefs();var o=this.getId().length+2;for(var i=0;i<n.length;i++){var $=q(n[i]);var p=parseInt($.attr("id").slice(o),10);if(p<this._iMinMonth||p>this._iMaxMonth){$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}else{$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}}}return this;};
c.prototype.getStartMonth=function(){if(this.getMonths()<12){var F=this._oItemNavigation.getItemDomRefs()[0];return parseInt(F.id.slice(this.getId().length+2),10);}else{return 0;}};
c.prototype._isValueInThreshold=function(r,v,t){var i=r-t,u=r+t;return v>=i&&v<=u;};
function _(){var r=this.getDomRef();var b=this.$().find(".sapUiCalItem");var i=this.getColumns();var m=this.getMonths();var n=true;if(m<12){n=false;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,d,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,e,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,g,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(b);this._oItemNavigation.setCycling(n);this._oItemNavigation.setColumns(i,!n);var o=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(o);this._oItemNavigation.setPageSize(b.length);}
function d(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){f.call(this,E,i);}}
function e(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){f.call(this,E,i);}}
function f(E,i){if(E.button||D.support.touch){return;}var m=i+this.getStartMonth();if(m>=this._iMinMonth&&m<=this._iMaxMonth){h.call(this,m);this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}
function g(o){var E=o.getParameter("event");if(E.type){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();switch(E.type){case"sapnext":case"sapnextmodifiers":if(m<11){m++;k.call(this,m,true);}break;case"sapprevious":case"sappreviousmodifiers":if(m>0){m--;k.call(this,m,true);}break;case"sappagedown":if(m<12-b){m=m+b;k.call(this,m,true);}break;case"sappageup":if(m>b){m=m-b;k.call(this,m,true);}break;default:break;}}}
function h(m,n){var b=this._oItemNavigation.getItemDomRefs();var $;var s=this.getId()+"-m"+m;for(var i=0;i<b.length;i++){$=q(b[i]);if($.attr("id")==s){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}if(!n){this.setProperty("month",m,true);}}
function j(){if(!this._bNamesLengthChecked){var i=0;var m=this._oItemNavigation.getItemDomRefs();var t=false;var n=this.getMonths();var B=Math.ceil(12/n);var o=n-1;for(var b=0;b<B;b++){if(n<12){k.call(this,o);o=o+n;if(o>11){o=11;}}for(i=0;i<m.length;i++){var p=m[i];if(Math.abs(p.clientWidth-p.scrollWidth)>1){t=true;break;}}if(t){break;}}if(n<12){o=this.getMonth();k.call(this,o);}if(t){this._bLongMonth=false;var r=this._getLocaleData();var s=this.getPrimaryCalendarType();var u=r.getMonthsStandAlone("abbreviated",s);var v=r.getMonthsStandAlone("wide",s);for(i=0;i<m.length;i++){var $=q(m[i]);$.text(u[i]);$.attr("aria-label",v[i]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function k(m,F){var b=this._oItemNavigation.getItemDomRefs();if(b.legth>11){return;}var n=b.length;var s=Math.floor(m/n)*n;if(s+n>12){s=12-n;}var o=this._getLocaleData();var p=[];var r=[];var t=this.getPrimaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){p=o.getMonthsStandAlone("wide",t);}else{p=o.getMonthsStandAlone("abbreviated",t);r=o.getMonthsStandAlone("wide",t);}var S=this.getMonth();for(var i=0;i<b.length;i++){var u=i+s;var $=q(b[i]);$.text(p[i+s]);$.attr("id",this.getId()+"-m"+(i+s));if(!this._bLongMonth){$.attr("aria-label",r[i+s]);}if(u==S){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if(u<this._iMinMonth||u>this._iMaxMonth){$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}else{$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}}this._oItemNavigation.focusItem(m-s);if(F){this.firePageChange();}}
return c;});
sap.ui.predefine('sap/ui/unified/calendar/MonthPickerRenderer',[],function(){"use strict";var M={};
M.render=function(r,m){var a=m.getMonth();var b=m.getMonths();var s=0;var c=m.getColumns();var t=m.getTooltip_AsString();var l=m._getLocaleData();var I=m.getId();var w="";var d=[];var e=[];var C=m.getPrimaryCalendarType();if(m._bLongMonth||!m._bNamesLengthChecked){d=l.getMonthsStandAlone("wide",C);}else{d=l.getMonthsStandAlone("abbreviated",C);e=l.getMonthsStandAlone("wide",C);}r.write("<div");r.writeControlData(m);r.addClass("sapUiCalMonthPicker");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:"false"});r.write(">");var A;if(b>12){b=12;}else if(b<12){s=Math.floor(a/b)*b;if(s+b>12){s=12-b;}}if(c>0){w=(100/c)+"%";}else{w=(100/b)+"%";}for(var i=0;i<b;i++){var f=i+s;A={role:"gridcell"};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=e[f];}if(c>0&&i%c==0){r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");}r.write("<div");r.writeAttribute("id",I+"-m"+(f));r.addClass("sapUiCalItem");if(f==a){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(f<m._iMinMonth||f>m._iMaxMonth){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.addStyle("width",w);r.writeClasses();r.writeStyles();r.writeAccessibilityState(null,A);r.write(">");r.write(d[f]);r.write("</div>");if(c>0&&((i+1)%c==0)){r.write("</div>");}}r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthRenderer',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend','sap/ui/unified/CalendarLegendRenderer','sap/ui/core/library','sap/ui/unified/library'],function(q,C,a,b,c,d,l){"use strict";var e=l.CalendarDayType;var f=d.CalendarType;var M={};
M.render=function(r,m){var D=this.getStartDate(m);var t=m.getTooltip_AsString();var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var i=m.getId();var A={value:i+"-Descr",append:true};var w=m.getWidth();r.write("<div");r.writeControlData(m);r.addClass(this.getClass(r,m));if(m._getSecondaryCalendarType()){r.addClass("sapUiCalMonthSecType");}r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(w){r.addStyle("width",w);r.writeStyles();}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+g.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+g.getText("CALENDAR_START_DATE")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+g.getText("CALENDAR_END_DATE")+"</span>");}this.renderMonth(r,m,D);r.write("</div>");};
M.getStartDate=function(m){return m._getDate();};
M.getClass=function(r,m){var s="sapUiCalMonthView",g=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(g==f.Islamic||!S){s=s+" sapUiCalNoWeekNum";}return s;};
M.renderMonth=function(r,m,D){var i=m.getId();this.renderHeader(r,m,D);r.write("<div id=\""+i+"-days\" class=\"sapUiCalItems\">");this.renderDays(r,m,D);r.write("</div>");};
M.renderHeader=function(r,m,D){var L=m._getLocaleData();var F=m._getFirstDayOfWeek();var i=m.getId();var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this.renderHeaderLine(r,m,L,D);r.write("<div");r.writeAttribute("id",i+"-CW");r.addStyle("display","none");r.writeStyles();r.writeAccessibilityState(null,{role:"columnheader"});r.write(">");r.write(g.getText("CALENDAR_WEEK"));r.write("</div>");r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.addStyle("overflow","hidden");r.writeStyles();r.write(">");this.renderDayNames(r,m,L,F,7,true,undefined);r.write("</div>");};
M.renderHeaderLine=function(r,m,L,D){C._checkCalendarDate(D);if(m._getShowHeader()){var i=m.getId();var s=m.getPrimaryCalendarType();var g=L.getMonthsStandAlone("wide",s);r.write("<div id=\""+i+"-Head\"class=\"sapUiCalHeadText\" >");r.write(g[D.getMonth()]);r.write("</div>");}};
M.renderDayNames=function(r,m,L,s,D,g,w){var F=m._getFirstDayOfWeek();var I=m.getId();var h="";var j=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=L.getDaysStandAlone("abbreviated",j);}else{W=L.getDaysStandAlone("narrow",j);}var k=L.getDaysStandAlone("wide",j);for(var i=0;i<D;i++){r.write("<div");r.addClass("sapUiCalWH");if(g){h=I+"-WH"+((i+F)%7);}else{h=I+"-WH"+i;}r.writeAttribute("id",h);if(i==0){r.addClass("sapUiCalFirstWDay");}if(w){r.addStyle("width",w);}r.writeAccessibilityState(null,{role:"columnheader",label:k[(i+s)%7]});r.writeClasses();r.writeStyles();r.write(">");r.write(W[(i+s)%7]);r.write("</div>");}};
M.renderDays=function(r,m,D){var w,g,L,h,i,t,s;C._checkCalendarDate(D);if(!D){D=m._getFocusedDate();}t=D.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}h=this.getDayHelper(m,D);g=m._getVisibleDays(D,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==f.Islamic&&s;L=g.length;for(i=0;i<L;i++){this.renderDay(r,m,g[i],h,true,w,-1);}};
M.getDayHelper=function(m,D){var L,s,o=m._getLocaleData(),h={sLocale:m._getLocale(),oLocaleData:o,iMonth:D.getMonth(),iYear:D.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:o.getWeekendStart(),iWeekendEnd:o.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:o.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};s=m.getLegend();if(s&&typeof s==="string"){L=sap.ui.getCore().byId(s);if(L){if(!(L instanceof b)){throw new Error(L+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=L;}else{q.sap.log.warning("CalendarLegend "+s+" does not exist!",m);}}return h;};
M.renderDay=function(r,m,D,h,o,w,n,W,g){C._checkCalendarDate(D);var s=new a(D,h.sSecondaryCalendarType),A={role:"gridcell",selected:false,label:"",describedby:""},B=D._bBeforeFirstYear,j="";var y=m._oFormatYyyymmdd.format(D.toUTCJSDate(),true);var k=D.getDay();var S=m._checkDateSelected(D);var p=m._getDateTypes(D);var E=m._checkDateEnabled(D);var i=0;if(B){E=false;}var t=0;if(w){t=C.calculateWeekNumber(D.toUTCJSDate(),h.iYear,h.sLocale,h.oLocaleData);A["describedby"]=h.sId+"-CW"+" "+h.sId+"-WNum-"+t;}if(!g){var u="";if(n<0){u=h.sId+"-WH"+k;}else{u=h.sId+"-WH"+n;}A["describedby"]=A["describedby"]+" "+u;}r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");r.addClass("sapUiCalWDay"+k);if(W){r.addStyle("width",W);}if(k==h.iFirstDayOfWeek){r.addClass("sapUiCalFirstWDay");}if(o&&h.iMonth!=D.getMonth()){r.addClass("sapUiCalItemOtherMonth");A["disabled"]=true;}if(D.isSame(h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S==4){r.addClass("sapUiCalItemSelBetween");}else if(S==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}p.forEach(function(v){if(v.type!=e.None){if(v.type===e.NonWorking){r.addClass("sapUiCalItemWeekEnd");return;}r.addClass("sapUiCalItem"+v.type);j=v.type;if(v.tooltip){r.writeAttributeEscaped('title',v.tooltip);}}});if(m.getParent()&&m.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval"&&D.getMonth()!==m.getStartDate().getMonth()){r.addClass("sapUiCalItemOtherMonth");}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(k==h.aNonWorkingDays[i]){r.addClass("sapUiCalItemWeekEnd");break;}}}else if((k>=h.iWeekendStart&&k<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(k>=h.iWeekendStart||k<=h.iWeekendEnd))){r.addClass("sapUiCalItemWeekEnd");}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-day",y);if(g){A["label"]=A["label"]+h.aWeekDaysWide[k]+" ";}A["label"]=A["label"]+h.oFormatLong.format(D.toUTCJSDate(),true);if(j!==""){c.addCalendarTypeAccInfo(A,j,h.oLegend);}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");if(!B){r.write(D.getDate());}r.write("</span>");if(w&&k==h.iFirstDayOfWeek){r.write("<span");r.writeAttribute("id",h.sId+"-WNum-"+t);r.addClass("sapUiCalWeekNum");r.writeClasses();r.writeAccessibilityState(null,{role:"rowheader",desribedby:h.sId+"-CW"});r.write(">");r.write(t);r.write("</span>");}if(g){r.write("<span");r.addClass("sapUiCalDayName");r.writeClasses();r.write(">");r.write(h.aWeekDays[k]);r.write("</span>");}if(h.sSecondaryCalendarType){r.write("<span");r.addClass("sapUiCalItemSecText");r.writeClasses();r.write(">");r.write(s.getDate());r.write("</span>");}r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthsRow',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthsRowRenderer"],function(q,C,L,I,a,c,l,D,d,e,M){"use strict";var f=d.CalendarType;
var g=C.extend("sap.ui.unified.calendar.MonthsRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
g.prototype.init=function(){this._oFormatYyyymm=D.getInstance({pattern:"yyyyMMdd",calendarType:f.Gregorian});this._oFormatLong=D.getInstance({pattern:"MMMM y"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
g.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonths){q.sap.clearDelayedCall(this._sInvalidateMonths);}};
g.prototype.onAfterRendering=function(){_.call(this);w.call(this);};
g.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){z.call(this,true);s.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;v.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;v.call(this);}}};
g.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateMonths){if(this._bInvalidateSync){x.call(this);}else{this._sInvalidateMonths=q.sap.delayedCall(0,this,x);}}};
g.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
g.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("selectedDates");return b;};
g.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
g.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("specialDates");return b;};
g.prototype.setDate=function(b){n.call(this,c.fromLocalJSDate(b),false);return this;};
g.prototype._setDate=function(b){var i=b.toLocalJSDate();this.setProperty("date",i,true);this._oDate=b;};
g.prototype._getDate=function(){if(!this._oDate){this._oDate=new c();}return this._oDate;};
g.prototype.setStartDate=function(S){a._checkJSDateObject(S);var b,Y,O;Y=S.getFullYear();a._checkYearInValidRange(Y);b=c.fromLocalJSDate(S);this.setProperty("startDate",S,true);this._oStartDate=b;this._oStartDate.setDate(1);if(this.getDomRef()){O=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.setDate(O);}}return this;};
g.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=new c();this._oStartDate.setDate(1);}return this._oStartDate;};
g.prototype.displayDate=function(b){n.call(this,c.fromLocalJSDate(b),true);return this;};
g.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
g.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var b=this._getLocale();var i=new e(b);this._oLocaleData=L.getInstance(i);}return this._oLocaleData;};
g.prototype._getFormatLong=function(){var b=this._getLocale();if(this._oFormatLong.oLocale.toString()!=b){var i=new e(b);this._oFormatLong=D.getInstance({style:"long"},i);}return this._oFormatLong;};
g.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
g.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
g.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
g.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
g.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
g.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
g.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
g.prototype._checkDateSelected=function(b){var R,S,E,T,A=0,B=0,F=0,i,G,H;a._checkCalendarDate(b);G=this.getSelectedDates();H=new c(b);H.setDate(1);T=H.toUTCJSDate().getTime();for(i=0;i<G.length;i++){R=G[i];S=R.getStartDate();A=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);A=S.toUTCJSDate().getTime();}E=R.getEndDate();B=0;if(E){E=c.fromLocalJSDate(E);E.setDate(1);B=E.toUTCJSDate().getTime();}if(T==A&&!E){F=1;break;}else if(T==A&&E){F=2;if(E&&T==B){F=5;}break;}else if(E&&T==B){F=3;break;}else if(E&&T>A&&T<B){F=4;break;}if(this.getSingleSelection()){break;}}return F;};
g.prototype._getDateType=function(b){a._checkCalendarDate(b);var T,R,i,S,A=0,E,B=0,F,G=this.getSpecialDates(),H=new c(b);H.setDate(1);F=H.toUTCJSDate().getTime();for(i=0;i<G.length;i++){R=G[i];S=R.getStartDate();A=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);A=S.toUTCJSDate().getTime();}E=R.getEndDate();B=0;if(E){E=c.fromLocalJSDate(E);E.setDate(a._daysInMonth(E));B=E.toUTCJSDate().getTime();}if((F==A&&!E)||(F>=A&&F<=B)){T={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return T;};
g.prototype._checkMonthEnabled=function(b){a._checkCalendarDate(b);var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(a._isOutside(b,P._oMinDate,P._oMaxDate)){return false;}}return true;};
g.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){z.call(this,true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){var O=this._getDate();var F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);if(!F.isSame(O)){this._setDate(F);s.call(this,F,true);this._bMoveChange=true;}}};
g.prototype.onmouseup=function(E){if(this._bMouseMove){z.call(this,true);var F=this._getDate();var b=this._oItemNavigation.getItemDomRefs();for(var i=0;i<b.length;i++){var $=q(b[i]);if($.attr("data-sap-month")==this._oFormatYyyymm.format(F.toUTCJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);}s.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;v.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;v.call(this);}};
g.prototype.onsapselect=function(E){var S=s.call(this,this._getDate());if(S){v.call(this);}E.stopPropagation();E.preventDefault();};
g.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
g.prototype.onsappageupmodifiers=function(E){var F=new c(this._getDate());var Y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(Y-10);}else{var i=this.getMonths();if(i<=12){F.setYear(Y-1);}else{F.setMonth(F.getMonth()-i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
g.prototype.onsappagedownmodifiers=function(E){var F=new c(this._getDate());var Y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(Y+10);}else{var i=this.getMonths();if(i<=12){F.setYear(Y+1);}else{F.setMonth(F.getMonth()+i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
g.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var b=this._getLocaleData();var A=b.getMonthsStandAlone("wide");var B=this.$("months").children();var E=this._getStartDate().getMonth();for(var i=0;i<B.length;i++){var $=q(q(B[i]).children(".sapUiCalItemText"));$.text(A[(i+E)%12]);}w.call(this);};
g.prototype.checkDateFocusable=function(b){a._checkJSDateObject(b);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new c(S);E.setDate(1);E.setMonth(E.getMonth()+this.getMonths());var i=c.fromLocalJSDate(b);return i.isSameOrAfter(S)&&i.isBefore(E);};
g.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
function _(){var b=this._getDate();var Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var A=0;var R=this.$("months").get(0);var B=this.$("months").children(".sapUiCalItem");for(var i=0;i<B.length;i++){var $=q(B[i]);if($.attr("data-sap-month")===Y){A=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,h,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,j,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(B);this._oItemNavigation.setFocusedIndex(A);this._oItemNavigation.setPageSize(B.length);}
function h(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}var O=this._getDate();var F=new c(O);var A=this._oItemNavigation.getItemDomRefs();var $=q(A[i]);F=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));F.setDate(1);this._setDate(F);this.fireFocus({date:F.toLocalJSDate(),notVisible:false});if(E.type=="mousedown"){m.call(this,E,F,i);}}
function j(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();m.call(this,E,F,i);}}
function k(b){var E=b.getParameter("event");var i=this.getMonths();var O=this._getDate();var F=new c(O);if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setMonth(F.getMonth()+1);break;case"sapprevious":case"sappreviousmodifiers":F.setMonth(F.getMonth()-1);break;case"sappagedown":F.setMonth(F.getMonth()+i);break;case"sappageup":F.setMonth(F.getMonth()-i);break;default:break;}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});}}
function m(E,F,i){if(E.button){return;}var S=s.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){z.call(this,true);this._bMoveChange=false;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){y.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function n(b,N){a._checkCalendarDate(b);var Y=b.getYear();a._checkYearInValidRange(Y);var F=true;if(!this.getDate()||!b.isSame(c.fromLocalJSDate(this.getDate()))){var i=new c(b);i.setDate(1);F=this.checkDateFocusable(b.toLocalJSDate());if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",b.toLocalJSDate(),true);this._oDate=i;}if(this.getDomRef()){if(F){o.call(this,this._oDate,N);}else{p.call(this,N);}}}
function o(b,N){var Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var A=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<A.length;i++){$=q(A[i]);if($.attr("data-sap-month")==Y){if(document.activeElement!=A[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function p(N){var b=this._getStartDate();var $=this.$("months");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderMonths(R,this,b);R.flush($[0]);R.destroy();}r.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}
function r(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var b=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,b,S);R.flush($[0]);R.destroy();}}}
function s(b,A){if(!this._checkMonthEnabled(b)){return false;}var S=this.getSelectedDates();var B;var E=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var F=this;var G;if(P&&P.getSelectedDates){F=P;}if(this.getSingleSelection()){if(S.length>0){B=S[0];G=B.getStartDate();if(G){G=c.fromLocalJSDate(G);G.setDate(1);}}else{B=new sap.ui.unified.DateRange();F.addAggregation("selectedDates",B,true);}if(this.getIntervalSelection()&&(!B.getEndDate()||A)&&G){var H;if(b.isBefore(G)){H=G;G=b;if(!A){B.setProperty("startDate",G.toLocalJSDate(),true);B.setProperty("endDate",H.toLocalJSDate(),true);}}else if(b.isSameOrAfter(G)){H=b;if(!A){B.setProperty("endDate",H.toLocalJSDate(),true);}}t.call(this,G,H);}else{t.call(this,b);B.setProperty("startDate",b.toLocalJSDate(),true);B.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var J=this._checkDateSelected(b);if(J>0){for(i=0;i<S.length;i++){G=S[i].getStartDate();if(G){G=c.fromLocalJSDate(G);G.setDate(1);if(b.isSame(G)){F.removeAggregation("selectedDates",i,true);break;}}}}else{B=new sap.ui.unified.DateRange({startDate:b.toLocalJSDate()});F.addAggregation("selectedDates",B,true);}Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);for(i=0;i<E.length;i++){$=q(E[i]);if($.attr("data-sap-month")==Y){if(J>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function t(S,E){var b=this._oItemNavigation.getItemDomRefs();var $;var i=0;var A=false;var B=false;if(!E){var Y=this._oFormatYyyymm.format(S.toUTCJSDate(),true);for(i=0;i<b.length;i++){$=q(b[i]);A=false;B=false;if($.attr("data-sap-month")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");A=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}u.call(this,$,A,B);}}else{var F;for(i=0;i<b.length;i++){$=q(b[i]);A=false;B=false;F=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));F.setDate(1);if(F.isSame(S)){$.addClass("sapUiCalItemSelStart");A=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&F.isSame(E)){$.addClass("sapUiCalItemSelEnd");B=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(F,S,E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&F.isSame(E)){$.addClass("sapUiCalItemSelEnd");B=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}u.call(this,$,A,B);}}}
function u($,S,E){if(!this.getIntervalSelection()){return;}var b="";var A=[];var B=this.getId();var F=false;b=$.attr("aria-describedby");if(b){A=b.split(" ");}var G=-1;var H=-1;for(var i=0;i<A.length;i++){var J=A[i];if(J==(B+"-Start")){G=i;}if(J==(B+"-End")){H=i;}}if(G>=0&&!S){A.splice(G,1);F=true;if(H>G){H--;}}if(H>=0&&!E){A.splice(H,1);F=true;}if(G<0&&S){A.push(B+"-Start");F=true;}if(H<0&&E){A.push(B+"-End");F=true;}if(F){b=A.join(" ");$.attr("aria-describedby",b);}}
function v(){if(this._bMouseMove){z.call(this,true);}this.fireSelect();}
function w(){if(!this._bNamesLengthChecked){var i=0;var A=this.$("months").children();var T=false;var B=this.getMonths();var E=Math.ceil(12/B);var F=0;var G=this._getLocaleData();var H=G.getMonthsStandAlone("wide");var $;for(var b=0;b<E;b++){if(B<12){for(i=0;i<A.length;i++){$=q(q(A[i]).children(".sapUiCalItemText"));$.text(H[(i+F)%12]);}F=F+B;if(F>11){F=11;}}for(i=0;i<A.length;i++){var J=A[i];if(Math.abs(J.clientWidth-J.scrollWidth)>1){T=true;break;}}if(T){break;}}if(B<12){F=this._getStartDate().getMonth();for(i=0;i<A.length;i++){$=q(q(A[i]).children(".sapUiCalItemText"));$.text(H[(i+F)%12]);}}if(T){this._bLongMonth=false;var K=G.getMonthsStandAlone("abbreviated");F=this._getStartDate().getMonth();for(i=0;i<A.length;i++){$=q(q(A[i]).children(".sapUiCalItemText"));$.text(K[(i+F)%12]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function x(){this._sInvalidateMonths=undefined;p.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
function y(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function z(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return g;});
sap.ui.predefine('sap/ui/unified/calendar/MonthsRowRenderer',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegendRenderer','sap/ui/unified/library'],function(q,C,a,b,l){"use strict";var c=l.CalendarDayType;var M={};
M.render=function(r,m){var d=m._getStartDate();var t=m.getTooltip_AsString();var i=m.getId();var A={value:i+"-Descr",append:true};r.write("<div");r.writeControlData(m);r.addClass("sapUiCalMonthsRow");r.addClass("sapUiCalRow");r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+m._rb.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+m._rb.getText("CALENDAR_START_MONTH")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+m._rb.getText("CALENDAR_END_MONTH")+"</span>");}this.renderRow(r,m,d);r.write("</div>");};
M.renderRow=function(r,m,d){var i=m.getId();this.renderHeader(r,m,d);r.write("<div id=\""+i+"-months\" class=\"sapUiCalItems\">");this.renderMonths(r,m,d);r.write("</div>");};
M.renderHeader=function(r,m,d){C._checkCalendarDate(d);if(m._getShowHeader()){var L=m._getLocaleData();var i=m.getId();r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,m,L,d);r.write("</div>");}};
M.renderHeaderLine=function(r,m,L,d){C._checkCalendarDate(d);var I=m.getId();var e=m.getMonths();var o=new a(d);var w="";var y=0;var Y=[];var i=0;for(i=0;i<e;i++){y=o.getYear();if(Y.length>0&&Y[Y.length-1].iYear==y){Y[Y.length-1].iMonths++;}else{Y.push({iYear:y,iMonths:1});}o.setMonth(o.getMonth()+1);}for(i=0;i<Y.length;i++){var f=Y[i];w=(100/e*f.iMonths)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(f.iYear);r.write("</div>");}};
M.renderMonths=function(r,m,d){var h=this.getHelper(m,d);var e=m.getMonths();var w=(100/e)+"%";var o=new a(d);o.setDate(1);for(var i=0;i<e;i++){this.renderMonth(r,m,o,h,w);o.setMonth(o.getMonth()+1);}};
M.getHelper=function(m,d){C._checkCalendarDate(d);var h={};h.sLocale=m._getLocale();h.oLocaleData=m._getLocaleData();h.oToday=new a();h.sCurrentMonth=m._rb.getText("CALENDAR_CURRENT_MONTH");h.sId=m.getId();h.oFormatLong=m._getFormatLong();if(m._bLongMonth||!m._bNamesLengthChecked){h.aMonthNames=h.oLocaleData.getMonthsStandAlone("wide");}else{h.aMonthNames=h.oLocaleData.getMonthsStandAlone("abbreviated");h.aMonthNamesWide=h.oLocaleData.getMonthsStandAlone("wide");}var L=m.getLegend();if(L){var o=sap.ui.getCore().byId(L);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=o;}else{q.sap.log.warning("CalendarLegend "+L+" does not exist!",m);}}return h;};
M.renderMonth=function(r,m,d,h,w){C._checkCalendarDate(d);var A={role:"gridcell",selected:false,label:"",describedby:""};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=h.aMonthNamesWide[d.getMonth()];}var y=m._oFormatYyyymm.format(d.toUTCJSDate(),true);var s=m._checkDateSelected(d);var t=m._getDateType(d);var e=m._checkMonthEnabled(d);r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");if(w){r.addStyle("width",w);}if(C._isSameMonthAndYear(d,h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sCurrentMonth+" ";}if(s>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}if(s==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(s==4){r.addClass("sapUiCalItemSelBetween");}else if(s==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(t&&t.type!=c.None){r.addClass("sapUiCalItem"+t.type);if(t.tooltip){r.writeAttributeEscaped('title',t.tooltip);}}if(!e){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-month",y);A["label"]=A["label"]+h.oFormatLong.format(d.toUTCJSDate(),true);if(t&&t.type!=c.None){b.addCalendarTypeAccInfo(A,t.type,h.oLegend);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");r.write(h.aMonthNames[d.getMonth()]);r.write("</span>");r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRow',['sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library',"./OneMonthDatesRowRenderer"],function(D,C,a,l,O){"use strict";
var b=D.extend("sap.ui.unified.calendar.OneMonthDatesRow",{metadata:{library:"sap.ui.unified"}});
b.prototype.init=function(){D.prototype.init.apply(this,arguments);this.iMode=2;};
b.prototype.setMode=function(m){var s=this.getSelectedDates(),S,c=this.iMode!==m;this.iMode=m;if(c&&s.length){if(this.iMode<2){S=this.getStartDate();}s[0].setProperty('startDate',S,true);}return this;};
b.prototype.getMode=function(){return this.iMode;};
b.prototype.selectDate=function(d){if(this.iMode<2&&this.getSelectedDates().length){this.getSelectedDates()[0].setStartDate(d);}return this;};
b.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.setDate.apply(this,arguments);return this;};
b.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.displayDate.apply(this,arguments);return this;};
b.prototype.onsaphome=function(e){var c=a.fromLocalJSDate(this.getStartDate());i(e);this._setDate(c);this._focusDate(c);this.fireFocus({date:c.toLocalJSDate(),otherMonth:false});};
b.prototype.onsapend=function(e){var s=this.getStartDate(),L;L=a.fromLocalJSDate(s);L.setDate(C._daysInMonth(L));i(e);this._setDate(L);this._focusDate(L);this.fireFocus({date:L.toLocalJSDate(),otherMonth:false});};
function i(e){e.stopPropagation();e.preventDefault();e.stopImmediatePropagation(true);}
return b;});
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRowRenderer',['sap/ui/core/Renderer','./MonthRenderer','./DatesRowRenderer'],function(R,M,D){"use strict";var O=R.extend(D);["getClass","renderMonth","renderDays","renderHeader"].forEach(function(h){O[h]=function(r,d){if(d.iMode<2){return M[h].apply(M,arguments);}else{return D[h].apply(D,arguments);}};});return O;},true);
sap.ui.predefine('sap/ui/unified/calendar/TimesRow',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./TimesRowRenderer"],function(q,C,L,I,a,U,l,D,c,b,T){"use strict";var d=c.CalendarType;
var e=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
e.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:d.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
e.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateTimes){q.sap.clearDelayedCall(this._sInvalidateTimes);}};
e.prototype.onAfterRendering=function(){_.call(this);};
e.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){w.call(this,true);p.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;t.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}}};
e.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateTimes){if(this._bInvalidateSync){u.call(this);}else{this._sInvalidateTimes=q.sap.delayedCall(0,this,u);}}};
e.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
e.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
e.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
e.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
e.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};
e.prototype.setDate=function(i){k.call(this,i,false);return this;};
e.prototype._setDate=function(i){var x=a._createLocalDate(i,true);this.setProperty("date",x,true);this._oUTCDate=i;};
e.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};
e.prototype.setStartDate=function(S){a._checkJSDateObject(S);var y=S.getFullYear();a._checkYearInValidRange(y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S,true);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};
e.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};
e.prototype.displayDate=function(i){k.call(this,i,true);return this;};
e.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
e.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var x=new b(i);this._oLocaleData=L.getInstance(x);}return this._oLocaleData;};
e.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var x=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},x);}return this._oFormatLong;};
e.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var x=new b(i);var y=this.getIntervalMinutes();var z=this._getLocaleData();var P;this._oFormatTimeAmPm=undefined;if(y%60==0){P=z.getPreferredHourSymbol();if(z.getTimePattern("short").search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},x);}}else{P=z.getTimePattern("short");P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},x);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},x);}return this._oFormatTime;};
e.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var x=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},x);}return this._oFormatDate;};
e.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
e.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
e.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
e.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
e.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
e.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};
e.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
e.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
e.prototype._checkDateSelected=function(x){if(!(x instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var y=this.getSelectedDates();var M=new U(x.getTime());M=this._getIntervalStart(M);var z=M.getTime();for(var i=0;i<y.length;i++){var R=y[i];var A=R.getStartDate();var B=0;if(A){A=a._createUniversalUTCDate(A,undefined,true);A=this._getIntervalStart(A);B=A.getTime();}var E=R.getEndDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);F=E.getTime();}if(z==B&&!E){S=1;break;}else if(z==B&&E){S=2;if(E&&z==F){S=5;}break;}else if(E&&z==F){S=3;break;}else if(E&&z>B&&z<F){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
e.prototype._getDateType=function(x){if(!(x instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var y;var S=this.getSpecialDates();var M=new U(x.getTime());M=this._getIntervalStart(M);var z=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var A=R.getStartDate();var B=0;if(A){A=a._createUniversalUTCDate(A,undefined,true);A=this._getIntervalStart(A);B=A.getTime();}var E=R.getEndDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);E.setUTCMinutes(E.getUTCMinutes()+this.getIntervalMinutes()-1);F=E.getTime();}else if(A.getUTCHours()==0&&A.getUTCMinutes()==0&&A.getUTCSeconds()==0&&A.getUTCMilliseconds()==0){E=new U(A.getTime());E.setUTCDate(E.getUTCDate()+1);F=E.getTime();}if((z==B&&!E)||(z>=B&&z<=F)){y={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return y;};
e.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var x=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(x<P._oMinDate.getTime()||x>P._oMaxDate.getTime()){return false;}}return true;};
e.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){w.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._setDate(F);p.call(this,F,true);this._bMoveChange=true;}}};
e.prototype.onmouseup=function(E){if(this._bMouseMove){w.call(this,true);var F=this._getDate();var x=this._oItemNavigation.getItemDomRefs();for(var i=0;i<x.length;i++){var $=q(x[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var y=q(E.target);if(y.hasClass("sapUiCalItemText")){y=y.parent();}if(y.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(y.attr("data-sap-time"),true).getTime());}p.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;t.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}};
e.prototype.onsapselect=function(E){var S=p.call(this,this._getDate());if(S){t.call(this);}E.stopPropagation();E.preventDefault();};
e.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
e.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
e.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
e.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var x=a._createUniversalUTCDate(i,undefined,true);if(x.getTime()>=S.getTime()&&x.getTime()<E.getTime()){return true;}else{return false;}};
e.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
e.prototype._getIntervalStart=function(i){var x=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=x){S.setUTCMinutes(S.getUTCMinutes()+M);}var y=new U(S.getTime());y.setUTCMinutes(y.getUTCMinutes()-M);return y;};
function _(){var x=this._getDate();var y=this._oFormatYyyyMMddHHmm.format(x.getJSDate(),true);var z=0;var R=this.$("times").get(0);var A=this.$("times").children(".sapUiCalItem");for(var i=0;i<A.length;i++){var $=q(A[i]);if($.attr("data-sap-time")===y){z=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,f,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,g,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,h,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(A);this._oItemNavigation.setFocusedIndex(z);this._oItemNavigation.setPageSize(A.length);}
function f(i){var x=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var y=this._oItemNavigation.getItemDomRefs();var $=q(y[x]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._setDate(F);this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){j.call(this,E,F,x);}}
function g(i){var x=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();j.call(this,E,F,x);}}
function h(i){var E=i.getParameter("event");var x=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*x);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*x);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}
function j(E,F,i){if(E.button){return;}var S=p.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){w.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){v.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function k(i,N){a._checkJSDateObject(i);var y=i.getFullYear();a._checkYearInValidRange(y);var F=true;if(!q.sap.equal(this.getDate(),i)){var x=a._createUniversalUTCDate(i,undefined,true);x=this._getIntervalStart(x);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i,true);this._oUTCDate=x;}if(this.getDomRef()){if(F){m.call(this,this._oUTCDate,N);}else{n.call(this,N);}}}
function m(x,N){var y=this._oFormatYyyyMMddHHmm.format(x.getJSDate(),true);var z=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<z.length;i++){$=q(z[i]);if($.attr("data-sap-time")==y){if(document.activeElement!=z[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function n(N){var i=this._getStartDate();var $=this.$("times");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(R,this,i);R.flush($[0]);R.destroy();}o.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}
function o(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var i=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,i,S);R.flush($[0]);R.destroy();}}}
function p(x,M){if(!this._checkTimeEnabled(x)){return false;}var S=this.getSelectedDates();var y;var z=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var A=this;var B;if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){y=S[0];B=y.getStartDate();if(B){B=a._createUniversalUTCDate(B,undefined,true);B=this._getIntervalStart(B);}}else{y=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",y,true);}if(this.getIntervalSelection()&&(!y.getEndDate()||M)&&B){var E;if(x.getTime()<B.getTime()){E=B;B=x;if(!M){y.setProperty("startDate",a._createLocalDate(new Date(B.getTime()),true),true);y.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true),true);}}else if(x.getTime()>=B.getTime()){E=x;if(!M){y.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true),true);}}r.call(this,B,E);}else{r.call(this,x);y.setProperty("startDate",a._createLocalDate(new Date(x.getTime()),true),true);y.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var F=this._checkDateSelected(x);if(F>0){for(i=0;i<S.length;i++){B=S[i].getStartDate();if(B){B=a._createUniversalUTCDate(B,undefined,true);B=this._getIntervalStart(B);if(x.getTime()==B.getTime()){A.removeAggregation("selectedDates",i,true);break;}}}}else{y=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(x.getTime()),true)});A.addAggregation("selectedDates",y,true);}Y=this._oFormatYyyyMMddHHmm.format(x.getJSDate(),true);for(i=0;i<z.length;i++){$=q(z[i]);if($.attr("data-sap-time")==Y){if(F>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function r(S,E){var x=this._oItemNavigation.getItemDomRefs();var $;var i=0;var y=false;var z=false;if(!E){var Y=this._oFormatYyyyMMddHHmm.format(S.getJSDate(),true);for(i=0;i<x.length;i++){$=q(x[i]);y=false;z=false;if($.attr("data-sap-time")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");y=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}s.call(this,$,y,z);}}else{var A;for(i=0;i<x.length;i++){$=q(x[i]);y=false;z=false;A=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(A.getTime()==S.getTime()){$.addClass("sapUiCalItemSelStart");y=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&A.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");z=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&A.getTime()>S.getTime()&&A.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&A.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");z=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}s.call(this,$,y,z);}}}
function s($,S,E){if(!this.getIntervalSelection()){return;}var x="";var y=[];var z=this.getId();var A=false;x=$.attr("aria-describedby");if(x){y=x.split(" ");}var B=-1;var F=-1;for(var i=0;i<y.length;i++){var G=y[i];if(G==(z+"-Start")){B=i;}if(G==(z+"-End")){F=i;}}if(B>=0&&!S){y.splice(B,1);A=true;if(F>B){F--;}}if(F>=0&&!E){y.splice(F,1);A=true;}if(B<0&&S){y.push(z+"-Start");A=true;}if(F<0&&E){y.push(z+"-End");A=true;}if(A){x=y.join(" ");$.attr("aria-describedby",x);}}
function t(){if(this._bMouseMove){w.call(this,true);}this.fireSelect();}
function u(){this._sInvalidateTimes=undefined;n.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
function v(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function w(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return e;});
sap.ui.predefine('sap/ui/unified/calendar/TimesRowRenderer',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarLegendRenderer','sap/ui/unified/library'],function(q,C,U,a,l){"use strict";var b=l.CalendarDayType;var T={};
T.render=function(r,t){var d=t._getStartDate();var s=t.getTooltip_AsString();var i=t.getId();var A={value:i+"-Descr",append:true};r.write("<div");r.writeControlData(t);r.addClass("sapUiCalTimesRow");r.addClass("sapUiCalRow");r.writeClasses();if(s){r.writeAttributeEscaped("title",s);}if(t._getShowHeader()){A.value=A.value+" "+i+"-Head";}r.writeAccessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+t._rb.getText("CALENDAR_DIALOG")+"</span>");if(t.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+t._rb.getText("CALENDAR_START_TIME")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+t._rb.getText("CALENDAR_END_TIME")+"</span>");}this.renderRow(r,t,d);r.write("</div>");};
T.renderRow=function(r,t,d){var i=t.getId();this.renderHeader(r,t,d);r.write("<div id=\""+i+"-times\" class=\"sapUiCalItems\">");this.renderTimes(r,t,d);r.write("</div>");};
T.renderHeader=function(r,t,d){if(t._getShowHeader()){var L=t._getLocaleData();var i=t.getId();r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,t,L,d);r.write("</div>");}};
T.renderHeaderLine=function(r,t,L,d){var f=t._getFormatDate();var I=t.getId();var c=t.getItems();var o=t._getIntervalStart(d);var m=t.getIntervalMinutes();var w="";var D=0;var e=[];var i=0;for(i=0;i<c;i++){D=f.format(o,true);if(e.length>0&&e[e.length-1].sDay==D){e[e.length-1].iItems++;}else{e.push({sDay:D,iItems:1});}o.setUTCMinutes(o.getUTCMinutes()+m);}for(i=0;i<e.length;i++){var g=e[i];w=(100/c*g.iItems)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(g.sDay);r.write("</div>");}};
T.renderTimes=function(r,t,d){var h=this.getHelper(t,d);var I=t.getItems();var w=(100/I)+"%";var o=t._getIntervalStart(d);var O="";var A="";for(var i=0;i<I;i++){if(h.oFormatTimeAmPm){A=h.oFormatTimeAmPm.format(o,true);if(O==A){A="";}else{O=A;}}this.renderTime(r,t,o,h,w,A);o.setUTCMinutes(o.getUTCMinutes()+h.iMinutes);}};
T.getHelper=function(t,d){var h={};h.sLocale=t._getLocale();h.oLocaleData=t._getLocaleData();h.oNow=C._createUniversalUTCDate(new Date(),undefined,true);h.sCurrentTime=t._rb.getText("CALENDAR_CURRENT_TIME");h.sId=t.getId();h.oFormatLong=t._getFormatLong();h.oFormatTime=t._getFormatTime();h.oFormatTimeAmPm=t._oFormatTimeAmPm;h.iMinutes=t.getIntervalMinutes();var L=t.getLegend();if(L){var o=sap.ui.getCore().byId(L);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+t);}h.oLegend=o;}else{q.sap.log.warning("CalendarLegend "+L+" does not exist!",t);}}return h;};
T.renderTime=function(r,t,d,h,w,A){var m={role:"gridcell",selected:false,label:"",describedby:""};var y=t._oFormatYyyyMMddHHmm.format(d.getJSDate(),true);var s=t._checkDateSelected(d);var o=t._getDateType(d);var e=t._checkTimeEnabled(d);r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");if(w){r.addStyle("width",w);}var n=new U(d.getTime());n.setUTCMinutes(n.getUTCMinutes()+h.iMinutes);if(d.getTime()<=h.oNow.getTime()&&n.getTime()>h.oNow.getTime()){r.addClass("sapUiCalItemNow");m["label"]=h.sCurrentTime+" ";}if(s>0){r.addClass("sapUiCalItemSel");m["selected"]=true;}if(s==2){r.addClass("sapUiCalItemSelStart");m["describedby"]=m["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.addClass("sapUiCalItemSelEnd");m["describedby"]=m["describedby"]+" "+h.sId+"-End";}else if(s==4){r.addClass("sapUiCalItemSelBetween");}else if(s==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");m["describedby"]=m["describedby"]+" "+h.sId+"-Start";m["describedby"]=m["describedby"]+" "+h.sId+"-End";}if(o&&o.type!=b.None){r.addClass("sapUiCalItem"+o.type);if(o.tooltip){r.writeAttributeEscaped('title',o.tooltip);}}if(!e){r.addClass("sapUiCalItemDsbl");m["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-time",y);m["label"]=m["label"]+h.oFormatLong.format(d,true);if(o&&o.type!=b.None){a.addCalendarTypeAccInfo(m,o.type,h.oLegend);}r.writeAccessibilityState(null,m);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");r.write(h.oFormatTime.format(d,true));if(A){r.write("<span");r.addClass("sapUiCalItemTextAmPm");r.writeClasses();r.write(">");r.write(A);r.write("</span>");}r.write("</span>");r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/unified/calendar/YearPicker',['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library',"./YearPickerRenderer",'jquery.sap.keycodes'],function(q,C,D,I,a,b,U,l,c,d,Y){"use strict";var e=d.CalendarType;
var f=C.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2000},years:{type:"int",group:"Appearance",defaultValue:20},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});
f.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._oYearFormat=c.getDateInstance({format:"y",calendarType:s});this._oFormatYyyymmdd=c.getInstance({pattern:"yyyyMMdd",calendarType:e.Gregorian});this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());};
f.prototype.onAfterRendering=function(){_.call(this);};
f.prototype.setYear=function(y){this.setProperty("year",y,true);y=this.getProperty("year");var i=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());i.setDate(1);i.setMonth(0);i.setYear(y);this.setDate(i.toLocalJSDate());return this;};
f.prototype.setDate=function(i){var p,y,r,F;i&&a._checkJSDateObject(i);y=i.getFullYear();a._checkYearInValidRange(y);p=b.fromLocalJSDate(i,this.getPrimaryCalendarType());p.setMonth(0);p.setDate(1);this.setProperty("date",i,true);this.setProperty("year",p.getYear(),true);this._oDate=p;if(this.getDomRef()){r=this.getYears();F=new b(this._oDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.floor(r/2));o.call(this,F,Math.floor(r/2));}return this;};
f.prototype._getDate=function(){if(!this._oDate){var y=this.getYear();this._oDate=new b(y,0,1,this.getPrimaryCalendarType());}return this._oDate;};
f.prototype.setPrimaryCalendarType=function(s){this.setProperty("primaryCalendarType",s);this._oYearFormat=c.getDateInstance({format:"y",calendarType:s});if(this._oDate){this._oDate=new b(this._oDate,s);this._oDate.setMonth(0);this._oDate.setDate(1);}this._oMinDate=new b(this._oMinDate,s);this._oMaxDate=new b(this._oMaxDate,s);return this;};
f.prototype.nextPage=function(){n.call(this,true,this._oItemNavigation.getFocusedIndex());return this;};
f.prototype.previousPage=function(){n.call(this,false,this._oItemNavigation.getFocusedIndex());return this;};
f.prototype.onsapspace=function(E){E.preventDefault();};
f.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var s=m.call(this,i);if(s){this.fireSelect();}};
f.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
f.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){var i=this._oItemNavigation.getFocusedIndex();m.call(this,i);this.fireSelect();}};
f.prototype.getFirstRenderedDate=function(){var F;if(this.getDomRef()){var i=this._oItemNavigation.getItemDomRefs();F=this._oFormatYyyymmdd.parse(q(i[0]).attr("data-sap-year-start"),true);}return F;};
f.prototype._isValueInThreshold=function(r,v,t){var L=r-t,u=r+t;return v>=L&&v<=u;};
f.prototype._checkFirstDate=function(i){var y=this.getYears();var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(i.isAfter(M)&&i.getYear()!=M.getYear()){i=new b(M,this.getPrimaryCalendarType());i.setMonth(0);i.setDate(1);}else if(i.isBefore(this._oMinDate)&&i.getYear()!=this._oMinDate.getYear()){i=new b(this._oMinDate,this.getPrimaryCalendarType());i.setMonth(0);i.setDate(1);}return i;};
f.prototype._checkDateEnabled=function(i){var E=true;if((i.isAfter(this._oMaxDate)&&i.getYear()!=this._oMaxDate.getYear())||(i.isBefore(this._oMinDate)&&i.getYear()!=this._oMinDate.getYear())){E=false;}return E;};
function _(){var y=this.getYears();var i=this._getDate().getYear();var M=this._oMinDate.getYear();var p=this._oMaxDate.getYear();var r=this.getDomRef();var s=this.$().find(".sapUiCalItem");var t=Math.floor(y/2);if(i>p-Math.floor(y/2)){t=t+i-p+Math.floor(y/2);}else if(i<=M+Math.floor(y/2)){t=i-M;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,g,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,h,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(s);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);this._oItemNavigation.setFocusedIndex(t);this._oItemNavigation.setPageSize(s.length);}
function g(i){var p=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){j.call(this,E,p);}}
function h(i){var p=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){j.call(this,E,p);}}
function j(E,i){if(E.button||D.support.touch){return;}var s=m.call(this,i);if(s){this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}
function k(i){var E=i.getParameter("event");if(E.type){var y=this.getYears();var p=this.getColumns();if(p==0){p=y;}switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN&&p<y){n.call(this,true,this._oItemNavigation.getFocusedIndex()-y+p,true);}else{n.call(this,true,0,true);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP&&p<y){n.call(this,false,y-p+this._oItemNavigation.getFocusedIndex(),true);}else{n.call(this,false,y-1,true);}break;case"sappagedown":n.call(this,true,this._oItemNavigation.getFocusedIndex(),true);break;case"sappageup":n.call(this,false,this._oItemNavigation.getFocusedIndex(),true);break;default:break;}}}
function m(p){var r=this._oItemNavigation.getItemDomRefs();var $=q(r[p]);if($.hasClass("sapUiCalItemDsbl")){return false;}var y=$.attr("data-sap-year-start");var s=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y));var t=this.getId()+"-y"+y;for(var i=0;i<r.length;i++){$=q(r[i]);if($.attr("id")==t){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}this.setProperty("date",s.toLocalJSDate(),true);this.setProperty("year",s.getYear(),true);return true;}
function n(F,s,i){var p=this._oItemNavigation.getItemDomRefs();var r=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(p[0]).attr("data-sap-year-start")),this.getPrimaryCalendarType());var y=this.getYears();if(F){var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(r.isBefore(M)){r.setYear(r.getYear()+y);if(r.isAfter(M)){s=s+(r.getYear()-M.getYear());if(s>y-1){s=y-1;}r=this._oMaxDate;r.setMonth(0);r.setDate(1);}}else{return;}}else{if(r.isAfter(this._oMinDate)){r.setYear(r.getYear()-y);if(r.isBefore(this._oMinDate)){s=s-(this._oMinDate.getYear()-r.getYear());if(s<0){s=0;}r=new b(this._oMinDate,this.getPrimaryCalendarType());}}else{return;}}o.call(this,r,s);if(i){this.firePageChange();}}
function o(F,s){var p=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var E=false;var r=this._checkFirstDate(F);var S;if(!r.isSame(F)){S=new b(F,this.getPrimaryCalendarType());S.setYear(S.getYear()+s);F=r;E=true;}var t=this._oItemNavigation.getItemDomRefs();var u=new b(F,this.getPrimaryCalendarType());for(var i=0;i<t.length;i++){var y=this._oFormatYyyymmdd.format(u.toUTCJSDate(),true);var $=q(t[i]);$.attr("id",this.getId()+"-y"+y);$.text(this._oYearFormat.format(U.getInstance(u.toUTCJSDate(),u.getCalendarType()),true));$.attr("data-sap-year-start",y);if($.hasClass("sapUiCalItemSel")&&y!=p){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else if(!$.hasClass("sapUiCalItemSel")&&y==p){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}var v=true;if(E){v=this._checkDateEnabled(u);if(u.isSame(S)){s=i;}}if(v){$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}else{$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}u.setYear(u.getYear()+1);}this._oItemNavigation.focusItem(s);}
return f;});
sap.ui.predefine('sap/ui/unified/calendar/YearPickerRenderer',['sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate'],function(C,U){"use strict";var Y={};
Y.render=function(r,y){var t=y.getTooltip_AsString();var I=y.getId();var c=y._getDate();var a=c.getYear();var b=y.getYears();var d=y.getColumns();var w="";r.write("<div");r.writeControlData(y);r.addClass("sapUiCalYearPicker");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(y,{role:"grid",readonly:"true",multiselectable:"false"});r.write(">");var D=new C(c,y.getPrimaryCalendarType());D.setYear(D.getYear()-Math.floor(b/2));var e=false;var f=y._checkFirstDate(D);if(!f.isSame(D)){D=f;e=true;}if(d>0){w=(100/d)+"%";}else{w=(100/b)+"%";}for(var i=0;i<b;i++){var s=y._oFormatYyyymmdd.format(D.toUTCJSDate(),true);var A={role:"gridcell"};var E=true;if(e){E=y._checkDateEnabled(D);}if(d>0&&i%d==0){r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");}r.write("<div");r.writeAttribute("id",I+"-y"+s);r.addClass("sapUiCalItem");if(D.getYear()==a){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-year-start",s);r.addStyle("width",w);r.writeClasses();r.writeStyles();r.writeAccessibilityState(null,A);r.write(">");r.write(y._oYearFormat.format(U.getInstance(D.toUTCJSDate(),D.getCalendarType()),true));r.write("</div>");D.setYear(D.getYear()+1);if(d>0&&((i+1)%d==0)){r.write("</div>");}}r.write("</div>");};
return Y;},true);
sap.ui.predefine('sap/ui/unified/library',['jquery.sap.global','sap/ui/core/Core','sap/ui/base/Object','jquery.sap.dom','jquery.sap.script'],function(q,C,B){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.unified",version:"1.54.7",dependencies:["sap.ui.core"],designtime:"sap/ui/unified/designtime/library.designtime",types:["sap.ui.unified.CalendarDayType","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.ColorPickerMode"],interfaces:["sap.ui.unified.IProcessableBlobs"],controls:["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],elements:["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],extensions:{"sap.ui.support":{publicRules:true}}});var t=sap.ui.unified;t.CalendarDayType={None:"None",NonWorking:"NonWorking",Type01:"Type01",Type02:"Type02",Type03:"Type03",Type04:"Type04",Type05:"Type05",Type06:"Type06",Type07:"Type07",Type08:"Type08",Type09:"Type09",Type10:"Type10",Type11:"Type11",Type12:"Type12",Type13:"Type13",Type14:"Type14",Type15:"Type15",Type16:"Type16",Type17:"Type17",Type18:"Type18",Type19:"Type19",Type20:"Type20"};t.StandardCalendarLegendItem={Today:"Today",WorkingDay:"WorkingDay",NonWorkingDay:"NonWorkingDay",Selected:"Selected"};t.CalendarIntervalType={Hour:"Hour",Day:"Day",Month:"Month",Week:"Week",OneMonth:"One Month"};t.GroupAppointmentsMode={Collapsed:"Collapsed",Expanded:"Expanded"};t.CalendarAppointmentVisualization={Standard:"Standard",Filled:"Filled"};t.ContentSwitcherAnimation={None:"None",Fade:"Fade",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",Rotate:"Rotate",SlideRight:"SlideRight",SlideOver:"SlideOver"};t.ColorPickerMode={HSV:"HSV",HSL:"HSL"};t._ContentRenderer=B.extend("sap.ui.unified._ContentRenderer",{constructor:function(c,s,o,a){B.apply(this);this._id=s;this._cntnt=o;this._ctrl=c;this._rm=sap.ui.getCore().createRenderManager();this._cb=a||function(){};},destroy:function(){this._rm.destroy();delete this._rm;delete this._id;delete this._cntnt;delete this._cb;delete this._ctrl;if(this._rerenderTimer){q.sap.clearDelayedCall(this._rerenderTimer);delete this._rerenderTimer;}B.prototype.destroy.apply(this,arguments);},render:function(){if(!this._rm){return;}if(this._rerenderTimer){q.sap.clearDelayedCall(this._rerenderTimer);}this._rerenderTimer=q.sap.delayedCall(0,this,function(){var $=q.sap.byId(this._id);var d=$.length>0;if(d){if(typeof(this._cntnt)==="string"){var c=this._ctrl.getAggregation(this._cntnt,[]);for(var i=0;i<c.length;i++){this._rm.renderControl(c[i]);}}else{this._cntnt(this._rm);}this._rm.flush($[0]);}this._cb(d);});}});t._iNumberOfOpenedShellOverlays=0;if(!t.ColorPickerHelper){t.ColorPickerHelper={isResponsive:function(){return false;},factory:{createLabel:function(){throw new Error("no Label control available");},createInput:function(){throw new Error("no Input control available");},createSlider:function(){throw new Error("no Slider control available");},createRadioButtonGroup:function(){throw new Error("no RadioButtonGroup control available");},createRadioButtonItem:function(){throw new Error("no RadioButtonItem control available");}},bFinal:false};}if(!t.FileUploaderHelper){t.FileUploaderHelper={createTextField:function(i){throw new Error("no TextField control available!");},setTextFieldContent:function(T,w){throw new Error("no TextField control available!");},createButton:function(){throw new Error("no Button control available!");},addFormClass:function(){return null;},bFinal:false};}t.calendar=t.calendar||{};return t;});
sap.ui.predefine('sap/ui/unified/Menu',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/Control','sap/ui/Device','sap/ui/core/Popup','./MenuItemBase','./library','sap/ui/core/library','sap/ui/unified/MenuRenderer','jquery.sap.script','jquery.sap.keycodes','jquery.sap.events'],function(q,E,C,D,P,M,l,c,a){"use strict";var b=P.Dock;var O=c.OpenState;
var d=C.extend("sap.ui.unified.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItemBase",multiple:true,singularName:"item"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
(function(w){d.prototype.bCozySupported=true;d._DELAY_SUBMENU_TIMER=300;d._DELAY_SUBMENU_TIMER_EXT=400;
d.prototype.init=function(){var t=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this._bOpenedAsContextMenu=false;this.fAnyEventHandlerProxy=q.proxy(function(e){var r=this.getRootMenu();if(r!=this||!this.bOpen||!this.getDomRef()||(e.type!="mousedown"&&e.type!="touchstart")){return;}r.handleOuterEvent(this.getId(),e);},this);this.fOrientationChangeHandler=function(){t.close();};this.bUseTopStyle=false;};
d.prototype.exit=function(){if(this.oPopup){this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup;}q.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this._resetDelayedRerenderItems();this._detachResizeHandler();};
d.prototype.invalidate=function(o){if(o instanceof M&&this.getDomRef()){this._delayedRerenderItems();}else{C.prototype.invalidate.apply(this,arguments);}};
d.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();};
d.prototype.onAfterRendering=function(){if(this.$().parent().attr("id")!="sap-ui-static"){q.sap.log.error("sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.");this.close();this.$().remove();}var I=this.getItems();for(var i=0;i<I.length;i++){if(I[i].onAfterRendering&&I[i].getDomRef()){I[i].onAfterRendering();}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this);}g(this);};
d.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===O.OPEN){g(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}};
d.prototype.setPageSize=function(S){return this.setProperty("pageSize",S,true);};
d.prototype.addItem=function(i){this.addAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
d.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e,!!this.getDomRef());this._delayedRerenderItems();return this;};
d.prototype.removeItem=function(i){this.removeAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
d.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return r;};
d.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this;};
d.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return;}this._resetDelayedRerenderItems();this._discardOpenSubMenuDelayed();this._itemRerenderTimer=q.sap.delayedCall(0,this,function(){var o=this.getDomRef();if(o){var r=sap.ui.getCore().createRenderManager();a.renderItems(r,this);r.flush(o);r.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}});};
d.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){q.sap.clearDelayedCall(this._itemRerenderTimer);delete this._itemRerenderTimer;}};
d.prototype._detachResizeHandler=function(){if(this._hasResizeListener){D.resize.detachHandler(this._handleResizeChange,this);this._hasResizeListener=false;}};
d.prototype.open=function(W,o,m,e,i,j,k){if(this.bOpen){return;}s(this,true);this.oOpenerRef=o;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,m,e,i,j||"0 0",k||"_sapUiCommonsMenuFlip _sapUiCommonsMenuFlip",true);this.bOpen=true;D.resize.attachHandler(this._handleResizeChange,this);this._hasResizeListener=true;var n=this.getDomRef();q(n).attr("tabIndex",0).focus();if(W){this.setHoveredItem(this.getNextSelectableItem(-1));}q.sap.bindAnyEvent(this.fAnyEventHandlerProxy);if(D.support.orientation&&this.getRootMenu()===this){q(w).bind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true;}};
d.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition);};
d.prototype.openAsContextMenu=function(e,o){o=o instanceof E?o.getDomRef():o;var x=e.pageX-q(o).offset().left,y=e.pageY-q(o).offset().top,r=sap.ui.getCore().getConfiguration().getRTL(),i=b;if(r){x=o.clientWidth-x;}this._iX=e.clientX;this._iY=e.clientY;this._bOpenedAsContextMenu=true;this.open(true,o,i.BeginTop,i.BeginTop,o,x+" "+y,'fit');};
d.prototype._handleOpened=function(){var m,W,i,e,r,B,R,j,k,n;if(!this._bOpenedAsContextMenu){return;}m=this.$();W=q(w);i=this._iX;e=this._iY;r=W.scrollLeft()+W.width();B=W.scrollTop()+W.height();R=sap.ui.getCore().getConfiguration().getRTL();j=false;k=m.width();n=m.height();if(e+n>B){e=e-n;j=true;}if(R){if((r-i)+k>r){i=r-(i+k);j=true;}else{i=r-i;j=true;}}else{if(i+k>r){i=i-k;j=true;}}this._bOpenedAsContextMenu=false;j&&this.oPopup.setPosition("begin top","begin top",W,i+" "+e,"flip");};
d.prototype.close=function(){if(!this.bOpen||d._dbg){return;}this._discardOpenSubMenuDelayed();s(this,false);delete this._bFixed;q.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this.bOpen=false;this.closeSubmenu();this.setHoveredItem();q(this.getDomRef()).attr("tabIndex",-1);this.getPopup().close(0);this._detachResizeHandler();this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null;}};
d.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus();}catch(e){q.sap.log.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e);}}this.oOpenerRef=undefined;}};
d.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation();};
d.prototype.onsapnext=function(e){if(e.keyCode!=q.sap.KeyCodes.ARROW_DOWN){if(this.oHoveredItem&&this.oHoveredItem.getSubmenu()&&this.checkEnabled(this.oHoveredItem)){this.openSubmenu(this.oHoveredItem,true);}return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;this.setHoveredItem(this.getNextSelectableItem(i));e.preventDefault();e.stopPropagation();};
d.prototype.onsapprevious=function(e){if(e.keyCode!=q.sap.KeyCodes.ARROW_UP){if(this.isSubMenu()){this.close();}e.preventDefault();e.stopPropagation();return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;this.setHoveredItem(this.getPreviousSelectableItem(i));e.preventDefault();e.stopPropagation();};
d.prototype.onsaphome=function(e){this.setHoveredItem(this.getNextSelectableItem(-1));e.preventDefault();e.stopPropagation();};
d.prototype.onsapend=function(e){this.setHoveredItem(this.getPreviousSelectableItem(this.getItems().length));e.preventDefault();e.stopPropagation();};
d.prototype.onsappagedown=function(e){if(this.getPageSize()<1){this.onsapend(e);return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i+=this.getPageSize();if(i>=this.getItems().length){this.onsapend(e);return;}this.setHoveredItem(this.getNextSelectableItem(i-1));e.preventDefault();e.stopPropagation();};
d.prototype.onsappageup=function(e){if(this.getPageSize()<1){this.onsaphome(e);return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i-=this.getPageSize();if(i<0){this.onsaphome(e);return;}this.setHoveredItem(this.getPreviousSelectableItem(i+1));e.preventDefault();e.stopPropagation();};
d.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation();};
d.prototype.onkeyup=function(e){if(this.oHoveredItem&&(q(e.target).prop("tagName")!="INPUT")){var o=this.oHoveredItem.getDomRef();q(o).attr("tabIndex",0).focus();}if(!this._sapSelectOnKeyDown){return;}else{this._sapSelectOnKeyDown=false;}if(!q.sap.PseudoEvents.sapselect.fnCheck(e)){return;}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation();};
d.prototype.onsapbackspace=function(e){if(q(e.target).prop("tagName")!="INPUT"){e.preventDefault();}};
d.prototype.onsapbackspacemodifiers=d.prototype.onsapbackspace;
d.prototype.onsapescape=function(e){this.close();e.preventDefault();e.stopPropagation();};
d.prototype.onsaptabnext=d.prototype.onsapescape;d.prototype.onsaptabprevious=d.prototype.onsapescape;
d.prototype.onmouseover=function(e){if(!D.system.desktop){return;}var i=this.getItemByDomRef(e.target);if(!this.bOpen||!i||i==this.oHoveredItem){return;}if(this.oOpenedSubMenu&&q.sap.containsOrEquals(this.oOpenedSubMenu.getDomRef(),e.target)){return;}this.setHoveredItem(i);if(q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){if(!D.browser.msie&&!D.browser.edge){this.getDomRef().focus();}}if(D.browser.msie){this.getDomRef().focus();}this._openSubMenuDelayed(i);};
d.prototype._openSubMenuDelayed=function(i){if(!i){return;}this._discardOpenSubMenuDelayed();this._delayedSubMenuTimer=q.sap.delayedCall(i.getSubmenu()&&this.checkEnabled(i)?d._DELAY_SUBMENU_TIMER:d._DELAY_SUBMENU_TIMER_EXT,this,function(){this.closeSubmenu();if(!i.getSubmenu()||!this.checkEnabled(i)){return;}this.setHoveredItem(i);this.openSubmenu(i,false,true);});};
d.prototype._discardOpenSubMenuDelayed=function(i){if(this._delayedSubMenuTimer){q.sap.clearDelayedCall(this._delayedSubMenuTimer);this._delayedSubMenuTimer=null;}};
d.prototype.onmouseout=function(e){if(!D.system.desktop){return;}if(q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){if(!this.oOpenedSubMenu||!(this.oOpenedSubMenu.getParent()===this.oHoveredItem)){this.setHoveredItem(null);}this._discardOpenSubMenuDelayed();}};
d.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.bOpen){return;}this.getRootMenu().handleOuterEvent(this.getId(),e);};
d.prototype.handleOuterEvent=function(m,e){var i=false,t=this.getPopup().touchEnabled;this.bIgnoreOpenerDOMRef=false;if(e.type=="mousedown"||e.type=="touchstart"){if(t&&(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose"))){return;}var j=this;while(j&&!i){if(q.sap.containsOrEquals(j.getDomRef(),e.target)){i=true;}j=j.oOpenedSubMenu;}}else if(e.type=="sapfocusleave"){if(t){return;}if(e.relatedControlId){var j=this;while(j&&!i){if((j.oOpenedSubMenu&&j.oOpenedSubMenu.getId()==e.relatedControlId)||q.sap.containsOrEquals(j.getDomRef(),q.sap.byId(e.relatedControlId).get(0))){i=true;}j=j.oOpenedSubMenu;}}if(!i){this.bIgnoreOpenerDOMRef=true;}}if(!i){this.close();}};
d.prototype.getItemByDomRef=function(o){var I=this.getItems(),L=I.length;for(var i=0;i<L;i++){var e=I[i],j=e.getDomRef();if(q.sap.containsOrEquals(j,o)){return e;}}return null;};
d.prototype.selectItem=function(i,W,e){if(!i||!(i instanceof M&&this.checkEnabled(i))){return;}var S=i.getSubmenu();if(!S){this.getRootMenu().close();}else{if(!D.system.desktop&&this.oOpenedSubMenu===S){this.closeSubmenu();}else{this.openSubmenu(i,W);}}i.fireSelect({item:i,ctrlKey:e});this.getRootMenu().fireItemSelect({item:i});};
d.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof d;};
d.prototype.getRootMenu=function(){var t=this;while(t.isSubMenu()){t=t.getParent().getParent();}return t;};
d.prototype.getMenuLevel=function(){var L=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();L++;}return L;};
d.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachClosed(this._menuClosed,this);this.oPopup.attachOpened(this._handleOpened,this);}return this.oPopup;};
d.prototype.setHoveredItem=function(i){if(this.oHoveredItem){this.oHoveredItem.hover(false,this);}if(!i){this.oHoveredItem=null;q(this.getDomRef()).removeAttr("aria-activedescendant");return;}this.oHoveredItem=i;i.hover(true,this);this._setActiveDescendant(this.oHoveredItem);this.scrollToItem(this.oHoveredItem);};
d.prototype._setActiveDescendant=function(i){if(sap.ui.getCore().getConfiguration().getAccessibility()&&i){var t=this;t.$().removeAttr("aria-activedescendant");setTimeout(function(){if(t.oHoveredItem===i){t.$().attr("aria-activedescendant",t.oHoveredItem.getId());}},10);}};
d.prototype.openSubmenu=function(i,W,e){var S=i.getSubmenu();if(!S){return;}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==S){this.closeSubmenu();}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=(e&&this.oOpenedSubMenu._bFixed)||(!e&&!this.oOpenedSubMenu._bFixed);this.oOpenedSubMenu._bringToFront();}else{this.oOpenedSubMenu=S;var j=P.Dock;S.open(W,this,j.BeginTop,j.EndTop,i,"0 0");}};
d.prototype.closeSubmenu=function(i,I){if(this.oOpenedSubMenu){if(i&&this.oOpenedSubMenu._bFixed){return;}if(I){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true;}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null;}};
d.prototype.scrollToItem=function(i){var m=this.getDomRef(),I=i?i.getDomRef():null;if(!I||!m){return;}var e=m.scrollTop,j=I.offsetTop,k=q(m).height(),n=q(I).height();if(e>j){m.scrollTop=j;}else if((j+n)>(e+k)){m.scrollTop=Math.ceil(j+n-k);}};
d.prototype._bringToFront=function(){q.sap.byId(this.getPopup().getId()).mousedown();};
d.prototype.checkEnabled=function(i){return i&&i.getEnabled()&&this.getEnabled();};
d.prototype.getNextSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I+1;i<e.length;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=0;i<=I;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
d.prototype.getPreviousSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I-1;i>=0;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=e.length-1;i>=I;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
d.prototype.setRootMenuTopStyle=function(u){this.getRootMenu().bUseTopStyle=u;d.rerenderMenu(this.getRootMenu());};
d.rerenderMenu=function(m){var I=m.getItems();for(var i=0;i<I.length;i++){var S=I[i].getSubmenu();if(S){d.rerenderMenu(S);}}m.invalidate();m.rerender();};
d.prototype.focus=function(){if(this.bOpen){C.prototype.focus.apply(this,arguments);this._setActiveDescendant(this.oHoveredItem);}};
d.prototype.isCozy=function(){if(!this.bCozySupported){return false;}if(this.hasStyleClass("sapUiSizeCozy")){return true;}if(f(this.oOpenerRef)){return true;}if(f(this.getParent())){return true;}return false;};
function f(r){if(!r){return false;}r=r.$?r.$():q(r);return r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy").hasClass("sapUiSizeCozy");}
function s(m,o){var p=m.getParent();if(p&&p instanceof M){p.onSubmenuToggle(o);}}
function g(m){var e=m.getMaxVisibleItems(),j=document.documentElement.clientHeight-10,$=m.$();if(e>0){var I=m.getItems();for(var i=0;i<I.length;i++){if(I[i].getDomRef()){j=Math.min(j,I[i].$().outerHeight(true)*e);break;}}}if($.outerHeight(true)>j){$.css("max-height",j+"px").toggleClass("sapUiMnuScroll",true);}else{$.css("max-height","").toggleClass("sapUiMnuScroll",false);}}
/*!
	 * The following code is taken from
	 * jQuery UI 1.10.3 - 2013-11-18
	 * jquery.ui.position.js
	 *
	 * http://jqueryui.com
	 * Copyright 2013 jQuery Foundation and other contributors; Licensed MIT
	 */

function _(e){var i=q(w);e.within={element:i,isWindow:true,offset:i.offset()||{left:0,top:0},scrollLeft:i.scrollLeft(),scrollTop:i.scrollTop(),width:i.width(),height:i.height()};e.collisionPosition={marginLeft:0,marginTop:0};return e;}
var h={fit:{left:function(p,e){var i=e.within,j=i.isWindow?i.scrollLeft:i.offset.left,o=i.width,k=p.left-e.collisionPosition.marginLeft,m=j-k,n=k+e.collisionWidth-o-j,r;if(e.collisionWidth>o){if(m>0&&n<=0){r=p.left+m+e.collisionWidth-o-j;p.left+=m-r;}else if(n>0&&m<=0){p.left=j;}else{if(m>n){p.left=j+o-e.collisionWidth;}else{p.left=j;}}}else if(m>0){p.left+=m;}else if(n>0){p.left-=n;}else{p.left=Math.max(p.left-k,p.left);}},top:function(p,e){var i=e.within,j=i.isWindow?i.scrollTop:i.offset.top,o=e.within.height,k=p.top-e.collisionPosition.marginTop,m=j-k,n=k+e.collisionHeight-o-j,r;if(e.collisionHeight>o){if(m>0&&n<=0){r=p.top+m+e.collisionHeight-o-j;p.top+=m-r;}else if(n>0&&m<=0){p.top=j;}else{if(m>n){p.top=j+o-e.collisionHeight;}else{p.top=j;}}}else if(m>0){p.top+=m;}else if(n>0){p.top-=n;}else{p.top=Math.max(p.top-k,p.top);}}},flip:{left:function(p,e){var i=e.within,j=i.offset.left+i.scrollLeft,o=i.width,k=i.isWindow?i.scrollLeft:i.offset.left,m=p.left-e.collisionPosition.marginLeft,n=m-k,r=m+e.collisionWidth-o-k,t=e.my[0]==="left"?-e.elemWidth:e.my[0]==="right"?e.elemWidth:0,u=e.at[0]==="left"?e.targetWidth:e.at[0]==="right"?-e.targetWidth:0,v=-2*e.offset[0],x,y;if(n<0){x=p.left+t+u+v+e.collisionWidth-o-j;if(x<0||x<Math.abs(n)){p.left+=t+u+v;}}else if(r>0){y=p.left-e.collisionPosition.marginLeft+t+u+v-k;if(y>0||Math.abs(y)<r){p.left+=t+u+v;}}},top:function(p,e){var i=e.within,j=i.offset.top+i.scrollTop,o=i.height,k=i.isWindow?i.scrollTop:i.offset.top,m=p.top-e.collisionPosition.marginTop,n=m-k,r=m+e.collisionHeight-o-k,t=e.my[1]==="top",u=t?-e.elemHeight:e.my[1]==="bottom"?e.elemHeight:0,v=e.at[1]==="top"?e.targetHeight:e.at[1]==="bottom"?-e.targetHeight:0,x=-2*e.offset[1],y,z;if(n<0){z=p.top+u+v+x+e.collisionHeight-o-j;if((p.top+u+v+x)>n&&(z<0||z<Math.abs(n))){p.top+=u+v+x;}}else if(r>0){y=p.top-e.collisionPosition.marginTop+u+v+x-k;if((p.top+u+v+x)>r&&(y>0||Math.abs(y)<r)){p.top+=u+v+x;}}}},flipfit:{left:function(){h.flip.left.apply(this,arguments);h.fit.left.apply(this,arguments);},top:function(){h.flip.top.apply(this,arguments);h.fit.top.apply(this,arguments);}}};q.ui.position._sapUiCommonsMenuFlip={left:function(p,e){if(q.ui.position.flipfit){q.ui.position.flipfit.left.apply(this,arguments);return;}e=_(e);h.flipfit.left.apply(this,arguments);},top:function(p,e){if(q.ui.position.flipfit){q.ui.position.flipfit.top.apply(this,arguments);return;}e=_(e);h.flipfit.top.apply(this,arguments);}};})(window);return d;});
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/unified/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/unified/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.unified","type":"library","embeds":[],"applicationVersion":{"version":"1.54.7"},"title":"Unified controls intended for both, mobile and desktop scenarios","description":"Unified controls intended for both, mobile and desktop scenarios","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.54","libs":{"sap.ui.core":{"minVersion":"1.54.7"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],"elements":["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],"types":["sap.ui.unified.CalendarDayType","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.ColorPickerMode"],"interfaces":["sap.ui.unified.IProcessableBlobs"]}}}}'
}});
//# sourceMappingURL=library-preload.js.map