/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m,e){"use strict";var f=l.Importance;var g=m.ButtonType;var P=m.PlacementType;var h=l.ObjectPageHeaderDesign;var j=l.ObjectPageHeaderPictureShape;var k=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:j.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:h.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"}});k.prototype._iAvailablePercentageForActions=0.3;k.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};k.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs");},aggregation:"links"});k.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};k.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};k.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};k.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};k._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,s,t){return I.createControlByURI({id:this._getParentAugmentedId(i,s),tooltip:t,src:I.getIconURI(s),visible:false});},_getButton:function(i,s,t,T){return new b({id:this._getParentAugmentedId(i,t),tooltip:T,icon:s,type:g.Transparent});},_getParentAugmentedId:function(i,s){return i.getId()+"-"+s;}};k.prototype._lazyLoadInternalAggregation=function(s,S){if(!this.getAggregation(s)){this.setAggregation(s,k._internalAggregationFactory[s](this),S);}return this.getAggregation(s);};k.prototype._applyActionProperty=function(s,i){var t=i[0];if(this.getProperty(s)!==t){i.unshift(s);this.setProperty.apply(this,i);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};k.prototype._applyObjectImageProperty=function(s,i){var t=i[0];if(this.getProperty(s)!==t){i.unshift(s);this.setProperty.apply(this,i);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};k.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};k.prototype.setObjectTitle=function(N){var s=this.getProperty("objectTitle"),i=s!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));if(i&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":s,"newValue":N});}return this;};var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var G=function(s){var i="set"+s.charAt(0).toUpperCase()+s.slice(1);k.prototype[i]=function(){var t=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,s,t);};};var n=function(s){var i="set"+s.charAt(0).toUpperCase()+s.slice(1);k.prototype[i]=function(){var t=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,s,t);};};var r=function(s,S,t){var i="set"+s.charAt(0).toUpperCase()+s.slice(1);S[i]=function(){var u=Array.prototype.slice.call(arguments);u.unshift(s);t.setProperty.apply(t,u);return this.setProperty.apply(this,u);};};p.forEach(G);o.forEach(n);k.prototype._destroyObjectImage=function(){var s="_objectImage",i=this.getAggregation(s);if(i){i.destroy();this.setAggregation(s,null);}};k.prototype.onBeforeRendering=function(){var s=this.getSideContentButton();if(s&&!s.getTooltip()){s.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var i=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._oActionSheetButtonMap={};if(i.length>1||this._hasOneButtonShowText(i)){i.forEach(function(t){if(t instanceof b&&!(t instanceof O)){t._bInternalVisible=t.getVisible();t._getInternalVisible=function(){return this._bInternalVisible;};t._setInternalVisible=function(v,w){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(w){this.invalidate();}}};t.setVisible=function(v){t._setInternalVisible(v,true);b.prototype.setVisible.call(this,v);};t.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};}if(t instanceof b&&(t.getType()==="Default"||t.getType()==="Unstyled")){t.setProperty("type",g.Transparent,false);}if(t instanceof b&&t.getVisible()){var u=this._createActionSheetButton(t);this._oActionSheetButtonMap[t.getId()]=u;this._oOverflowActionSheet.addButton(u);r("text",t,u);r("icon",t,u);r("enabled",t,u);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._bFirstRendering=false;};k.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};k.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),s=this.getParent(),$=s?s.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};k.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};k.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();this._adaptLayout();this._clearImageNotFoundHandler();$.error(this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};k.prototype._onHeaderResize=function(){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._adjustHeaderHeights==="function"){this.getParent()._adjustHeaderHeights();}};k.prototype._attachDetachActionButtonsHandler=function(i){var s=this.getActions()||[];if(s.length<1){return;}s.forEach(function(t){if(t instanceof b){var u=this._oActionSheetButtonMap[t.getId()];if(i){t.attachEvent("_change",this._adaptLayout,this);if(u){u.attachEvent("_change",this._adaptOverflow,this);}}else{t.detachEvent("_change",this._adaptLayout,this);if(u){u.detachEvent("_change",this._adaptOverflow,this);}}}},this);};k.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),s=sap.ui.getCore().byId(i.data("originalId"));if(s.firePress){s.firePress({overflowButtonId:this._oOverflowButton.getId()});}this._oOverflowActionSheet.close();};k._actionImportanceMap={"Low":3,"Medium":2,"High":1};k._sortActionsByImportance=function(i,s){var t=(i instanceof O)?i.getImportance():f.High,u=(s instanceof O)?s.getImportance():f.High,v=k._actionImportanceMap[t]-k._actionImportanceMap[u];if(v===0){return i.position-s.position;}return v;};k.prototype._hasOneButtonShowText=function(i){var s=false;if(i.length!==1){return s;}if(i[0]instanceof O){s=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){s=(i[0].getText()!="");}return s;};k.prototype._adaptLayout=function(E){this._adaptLayoutForDomElement(null,E);};k.prototype._adaptLayoutForDomElement=function($,E){var i=this._findById($,"identifierLine"),s=i.width(),t=this._getActionsWidth(),u=t/s,v=this._iAvailablePercentageForActions*s,w=this._oOverflowButton.$(),x=this._findById($,"actions"),y=x.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(u>this._iAvailablePercentageForActions){this._adaptActions(v);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){y.css("visibility","visible");}if(y.filter(":visible").length===y.length){w.hide();}this._adaptObjectPageHeaderIndentifierLine($);};k.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){q.sap.clearDelayedCall(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=q.sap.delayedCall(0,this,function(){this._adaptLayoutTimeout=null;this._adaptLayout();});};k.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),s=i.width(),t=this._findById($,"subtitle"),u=this._findById($,"innerTitle"),v=this._findById($,"identifierLineContainer"),S,T,w=this._findById($,"actions"),x=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),y=w.width()+x.width(),z=this.$().parents().hasClass('sapUiSizeCompact')?7:3;if(t.length){if(t.hasClass("sapOPHSubtitleBlock")){t.removeClass("sapOPHSubtitleBlock");}S=t.outerHeight()+t.position().top;T=u.outerHeight()+u.position().top;if(Math.abs(S-T)>z){t.addClass("sapOPHSubtitleBlock");}}v.width((0.95-(y/s))*100+"%");};k.prototype._adaptActions=function(s){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,$=this._oOverflowButton.$(),v=$.show().width(),t=this.getActions(),u=t.length,w;for(var i=0;i<u;i++){t[i].position=i;}t.sort(k._sortActionsByImportance);t.forEach(function(x){w=this._oActionSheetButtonMap[x.getId()];if(w){v+=x.$().width();if(s>v&&!M){this._setActionButtonVisibility(x,true);$.hide();}else{this._setActionButtonVisibility(x,false);$.show();}}},this);};k.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(s){return s.getVisible();});this._oOverflowButton.$().toggle(H);};k.prototype._setActionButtonVisibility=function(i,v){var s=this._oActionSheetButtonMap[i.getId()];if(s){if(i.getVisible()){i._setInternalVisible(v);s.setVisible(!v);}else{s.setVisible(false);}}};k.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};k.prototype._findById=function($,i){if(!i){return null;}if($){i=this.getId()+'-'+i;return q.sap.byId(i,$);}return this.$(i);};k.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),s=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((s&&s.getLinks().length)?s:null);};k.prototype._notifyParentOfChanges=function(i){var s=this.getParent();if(s&&typeof s._headerTitleChangeHandler==="function"){s._headerTitleChangeHandler(i);}};k.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};k.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};k.prototype._getAdaptableContent=function(){return this.getNavigationBar();};k.prototype.isDynamic=function(){return false;};k.prototype.getCompatibleHeaderContentClass=function(){return d;};k.prototype.supportsTitleInHeaderContent=function(){return true;};k.prototype.supportsAdaptLayoutForDomElement=function(){return true;};k.prototype.getTitleText=function(){return this.getObjectTitle();};k.prototype.snap=function(){this._adaptLayout();};k.prototype.unSnap=function(){this._adaptLayout();};k.prototype._toggleExpandButton=function(t){};k.prototype._setShowExpandButton=function(v){};k.prototype._focusExpandButton=function(){};k.prototype._toggleFocusableState=function(F){};return k;});
