/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","jquery.sap.keycodes"],function(q,R,C,D,S,O,a,b,c,L,A,T,d,e,l,f){"use strict";var g=e.TitleLevel;var h=l.ObjectPageSubSectionLayout;var i=C.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:h.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:g.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}}},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});i.HEADER_CALC_DELAY=350;i.DOM_CALC_DELAY=200;i.FOOTER_ANIMATION_DURATION=350;i.MAX_SNAP_POSITION_OFFSET=20;i.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;i.TITLE_LEVEL_AS_ARRAY=Object.keys(g);i.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};i.BREAK_POINTS={TABLET:1024,PHONE:600};i.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};i._getNextTitleLevelEntry=function(t){var k=i.TITLE_LEVEL_AS_ARRAY.indexOf(t),m=k!==-1,H=m&&(k!==i.TITLE_LEVEL_AS_ARRAY.length-1);if(!m){return g.Auto;}return i.TITLE_LEVEL_AS_ARRAY[H?k+1:k];};i.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._iStoredScrollPosition=0;this._bInternalAnchorBarVisible=true;this._$opWrapper=[];this._$anchorBar=[];this._$headerTitle=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iTotalHeaderSize=0;this._iREMSize=parseInt(q("body").css("font-size"),10);this._iOffset=parseInt(0.25*this._iREMSize,10);this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);};i.prototype.onBeforeRendering=function(){var H,p;this._oLazyLoading=new L(this);if(!this.getVisible()){return;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._initializeScroller();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();this._getCustomScrollBar().setScrollPosition(0);if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){p=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(p);if(p){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);};i.prototype.setToggleHeaderOnTitleClick=function(t){var o=this.getHeaderTitle(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);t=this.getProperty("toggleHeaderOnTitleClick");this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",t);this._updateToggleHeaderVisualIndicators();if(j(o)){o._toggleFocusableState(t);}return r;};i.prototype._attachTitlePressHandler=function(){var t=this.getHeaderTitle();if(j(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(i.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};i.prototype._toggleHeaderVisibility=function(s){var H=this._getHeaderContent();if(j(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!s);}};i.prototype._snapHeader=function(k){if(this._bPinned){q.sap.log.debug("ObjectPage :: aborted snapping, header is pinned",this);return;}var I;this._toggleHeaderTitle(false,true);this._moveAnchorBarToTitleArea();if(k){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._toggleHeaderVisibility(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};i.prototype._expandHeader=function(k){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(k){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();};i.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()){return;}var E=!this._bHeaderExpanded,I,k,m;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));k=this._shouldPreserveHeaderInTitleArea()||!I;this._expandHeader(k);}else{m=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(m);}};i.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(j(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(i.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};i.prototype._handleExpandButtonPressEventLifeCycle=function(k){var H=this.getHeaderTitle(),E;if(H){E=H.getAggregation("_expandButton");if(E){E[k?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};i.prototype._adjustSelectedSectionByUXRules=function(){var s=this.oCore.byId(this.getSelectedSection()),v=s&&this._sectionCanBeRenderedByUXRules(s);if(!v){if(this._oFirstVisibleSection){s=this._oFirstVisibleSection;this.setAssociation("selectedSection",s.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}var o=this.oCore.byId(this._sStoredScrolledSubSectionId),V=o&&this._sectionCanBeRenderedByUXRules(o)&&(s.indexOfSubSection(o)>=0);if(!V){this._sStoredScrolledSubSectionId=null;}};i.prototype._sectionCanBeRenderedByUXRules=function(s){if(!s||!s.getVisible()||!s._getInternalVisible()){return false;}var k=this._aSectionBases.map(function(o){return o.getId();});return(k.indexOf(s.getId())>-1);};i.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var s=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&s){return[s];}else{return this.getSections();}};i.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t;if(!this.getEnableLazyLoading()){t=this._getSectionsToRender();}else{var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;t=this._oLazyLoading.getSubsectionsToPreload(s);}this._connectModelsForSections(t);};i.prototype._grepCurrentTabSectionBases=function(){var F=[],s;this._adjustSelectedSectionByUXRules();s=this.oCore.byId(this.getSelectedSection());if(s){var k=s.getId();this._aSectionBases.forEach(function(o){if(o.getParent().getId()===k){F.push(o);}});}return F;};i.prototype.onAfterRendering=function(){this._ensureCorrectParentHeight();this._cacheDomElements();this._$opWrapper.on("scroll",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=q.sap.delayedCall(i.HEADER_CALC_DELAY,this,this._onAfterRenderingDomReady);}this._handleExpandButtonPressEventLifeCycle(true);};i.prototype._onAfterRenderingDomReady=function(){var s,o,k;if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(s){if(this.getUseIconTabBar()){this._setSelectedSectionId(s);this._setCurrentTabSection(o);}else{this.scrollToSection(s,0);}}if(D.system.desktop){this._$opWrapper.on("scroll",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){k=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(k);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);if(this._hasDynamicTitle()){this._updateMedia(this._getWidth(this));}this._updateToggleHeaderVisualIndicators();this.fireEvent("onAfterRenderingDOMReady");};i.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),s=this._calculateShiftOffset();$.css(s.sStyleAttribute,s.iMarginalsOffset+"px");};i.prototype._calculateShiftOffset=function(){var H=0,s=this.oCore.getConfiguration().getRTL()?"left":"right",k=this._hasVerticalScrollBar(),m=this._iOffset,n;if(D.system.desktop){n=q.sap.scrollbarSize().width;H=n;if(!k){H=0;m+=n;}}return{"sStyleAttribute":s,"iActionsOffset":m,"iMarginalsOffset":H};};i.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._iResizeId){R.deregister(this._iResizeId);}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};i.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new d(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this)});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};i.prototype.onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(s);}};i.prototype.onCustomScrollerScroll=function(E){var s=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(s);};i.prototype.setShowOnlyHighImportance=function(v){var o=this.getShowOnlyHighImportance();if(o!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};i.prototype.setIsHeaderContentAlwaysExpanded=function(v){var o=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(o!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};i.prototype.setShowEditHeaderButton=function(v){var o=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(o!==v){this.setProperty("showEditHeaderButton",v,true);H&&H.invalidate();}return this;};i.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};i.prototype.setSelectedSection=function(s){var k,v,m;if(s instanceof O){k=s.getId();}else if(typeof s==="string"){k=s;}if(!k){q.sap.log.warning("section or sectionID expected",this);return;}if(k===this.getSelectedSection()){return this;}this.scrollToSection(k);v=a._getClosestSection(k);m=(v instanceof a)?v.getId():v;return this.setAssociation("selectedSection",m,true);};i.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};i.prototype._cacheDomElements=function(){this._$headerTitle=q.sap.byId(this.getId()+"-headerTitle");this._$anchorBar=q.sap.byId(this.getId()+"-anchorBar");this._$stickyAnchorBar=q.sap.byId(this.getId()+"-stickyAnchorBar");this._$opWrapper=q.sap.byId(this.getId()+"-opwrapper");this._$spacer=q.sap.byId(this.getId()+"-spacer");this._$headerContent=q.sap.byId(this.getId()+"-headerContent");this._$stickyHeaderContent=q.sap.byId(this.getId()+"-stickyHeaderContent");this._$contentContainer=q.sap.byId(this.getId()+"-scroll");this._$sectionsContainer=q.sap.byId(this.getId()+"-sectionsContainer");this._bDomElementsCached=true;};i.prototype._handleExpandButtonPress=function(E){if(this._bStickyAnchorBar){this._moveHeaderToTitleArea();this._toggleHeaderTitle(true);}};i.prototype._toggleHeaderTitle=function(E,u){var H=this.getHeaderTitle();this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",!E);if(E){H&&H.unSnap(u);}else{H&&H.snap(u);}};i.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};i.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};i.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};i.prototype._applyUxRules=function(I){var s,k,v,V,m,n,o,F,p;s=this.getSections()||[];V=0;n=this.getShowAnchorBar();o=this.getUseIconTabBar();F=null;this._cleanMemory();s.forEach(function(r){if(!r.getVisible()){return true;}this._registerSectionBaseInfo(r);k=r.getSubSections()||[];v=0;p=null;k.forEach(function(t){if(!t.getVisible()){return true;}this._registerSectionBaseInfo(t);m=t.getVisibleBlocksCount();if(m===0){t._setInternalVisible(false,I);q.sap.log.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+t.getTitle()+" forced to hidden");}else{t._setInternalVisible(true,I);t._setInternalTitleVisible(true,I);v++;if(!p){p=t;}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t));}}},this);if(v==0){r._setInternalVisible(false,I);q.sap.log.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+r.getTitle()+" forced to hidden");}else{r._setInternalVisible(true,I);r._setInternalTitleVisible(true,I);if(!F){F=r;}if(this.getSubSectionLayout()===h.TitleOnTop&&v===1&&p.getTitle().trim()!==""){q.sap.log.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+r.getTitle()+" is taking its single subsection title "+p.getTitle());r._setInternalTitle(p.getTitle(),I);p._setInternalTitleVisible(false,I);}else{r._setInternalTitle("",I);}if(this._shouldApplySectionTitleLevel(r)){r._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(r));}V++;}if(o){r._setInternalTitleVisible(false,I);}},this);if(V<=1){n=false;q.sap.log.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&n){F._setInternalTitleVisible(false,I);q.sap.log.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}if(n){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(n,I);this._oFirstVisibleSection=F;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(F);};i.prototype.setUseIconTabBar=function(v){var o=this.getUseIconTabBar();if(v!=o){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};i.prototype._setCurrentTabSection=function(s,I){if(!s){return;}var o;if(s instanceof sap.uxap.ObjectPageSubSection){o=s;s=s.getParent();}else{o=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=o;};i.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=this.oCore.createRenderManager();this.getSections().forEach(function(o){if((o.getId()===s.getId())){r.renderControl(s);}else{r.cleanupControlWithoutRendering(o);}});r.flush($[0]);r.destroy();}};i.prototype.setShowAnchorBarPopover=function(v,s){var o=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v);if(v===o){return;}this._oABHelper._buildAnchorBar();this._oABHelper._getAnchorBar().setShowPopover(v);return this.setProperty("showAnchorBarPopover",v,true);};i.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};i.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};i.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};i.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,i.DOM_CALC_DELAY,this);}if(!I){q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+i.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(r){});};i.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,i.DOM_CALC_DELAY,this);}if(!I){q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+i.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(r){});};i.prototype._adjustLayoutAndUxRules=function(){var s,o;q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);if(o){this._setSelectedSectionId(s);if(this.getUseIconTabBar()){this._setCurrentTabSection(o);}this._requestAdjustLayout(true).then(function(k){if(k){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();if(!this._isClosestScrolledSection(s)||this._oScroller._$Container.is(":animated")){this.scrollToSection(s,null,0,false,true);}}.bind(this));}};i.prototype._isClosestScrolledSection=function(s){var k=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,p=this.iScreenHeight,m=this._getClosestScrolledSectionId(k,p);return m&&(s===m);};i.prototype._setSelectedSectionId=function(s){var o=this.getAggregation("_anchorBar"),k=s&&this._oSectionInfo[s];if(!k){return;}if(o&&k.buttonId){o.setSelectedButton(k.buttonId);this.setAssociation("selectedSection",s,true);}};i.prototype.isFirstRendering=function(){return this._bFirstRendering;};i.prototype._cleanMemory=function(){var o=this.getAggregation("_anchorBar");if(o){o._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};i.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(s instanceof a),sectionReference:s};this._aSectionBases.push(s);};i.prototype._triggerVisibleSubSectionsEvents=function(){if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};i.prototype.scrollToSection=function(I,k,o,m,r){var s=this.oCore.byId(I);if(!this.getDomRef()){q.sap.log.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!s){q.sap.log.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]){q.sap.log.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){q.sap.log.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var t=a._getClosestSection(s);if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}t._allowPropagationToLoadedViews(true);this._setCurrentTabSection(s);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[t.getId()].buttonId);this.setAssociation("selectedSection",t.getId(),true);}if(m){this.fireNavigate({section:a._getClosestSection(s),subSection:s instanceof b?s:s.getSubSections()[0]});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}o=o||0;s._expandSection();this._requestAdjustLayout(true);k=this._computeScrollDuration(k,s);var n=this._computeScrollPosition(s);if(this._sCurrentScrollId!=I||r){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=q.sap.delayedCall(k,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});}this._preloadSectionsOnScroll(s);this.getHeaderTitle()&&this._shiftHeaderTitle();this._scrollTo(n+o,k);}};i.prototype._computeScrollDuration=function(k,t){var m=parseInt(k,10);m=m>=0?m:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof a)||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){m=0;}return m;};i.prototype._computeScrollPosition=function(t){var F=t&&(t instanceof a),I=t.getId(),s=this._bMobileScenario||F?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(t)){s=0;}return s;};i.prototype._preloadSectionsOnScroll=function(t){var I=t.getId(),k;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){k=(t instanceof a)?t:t.getParent();this._connectModelsForSections([k]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;k=this._oLazyLoading.getSubsectionsToPreload(s,I);if(D.system.desktop){q.sap.delayedCall(50,this,function(){this._connectModelsForSections(k);});}else{this._connectModelsForSections(k);}k.forEach(function(m){this.fireEvent("subSectionEnteredViewPort",{subSection:m});},this);}};i.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};i.prototype.setDirectScrollingToSection=function(s){this.sDirectSectionId=s;};i.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};i.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};i.prototype._scrollTo=function(y,t){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){q.sap.log.debug("ObjectPageLayout :: scrolling to "+y);if((t===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}this._oScroller.scrollTo(0,y,t);}return this;};i.prototype._updateMedia=function(w){var u=function(M){Object.keys(i.DYNAMIC_HEADERS_MEDIA).forEach(function(s){var k=i.DYNAMIC_HEADERS_MEDIA[s],E=M===k;this.toggleStyleClass(k,E);},this);}.bind(this),m=i.DYNAMIC_HEADERS_MEDIA,B=i.BREAK_POINTS;if(w<=B.PHONE){u(m.PHONE);}else if(w<=B.TABLET){u(m.TABLET);}else{u(m.DESKTOP);}};i.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var k,o,s,p,P,m,n=!this._bHeaderExpanded,$=this.getDomRef();if(!$||!this._bDomReady){return false;}q.sap.log.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=$.parentElement?$.getBoundingClientRect().height:0;if(this.iScreenHeight===0){return;}var r=0;this._aSectionBases.forEach(function(t){var I=this._oSectionInfo[t.getId()],u=t.$(),v,w=false;if(!I||!u.length){return;}if(!I.isSection){r++;}I.$dom=u;var x=u.position().top;I.positionTop=Math.ceil(x);if(I.isSection){v=t.$("header");}else{v=t.$("headerTitle");}w=v.length===0;if(!w){I.positionTopMobile=Math.ceil(v.position().top)+v.outerHeight();}else{I.positionTopMobile=I.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){I.positionTopMobile-=this.iAnchorBarHeight;I.positionTop-=this.iAnchorBarHeight;}I.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",w);if(this._bMobileScenario){var y=this.oCore.byId(t.getId()).getParent();if(y instanceof a&&y._getIsHidden()){return;}if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}P=t.getId();o=t;}else{if(I.isSection){if(P){this._oSectionInfo[P].positionBottom=I.positionTop;if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}}P=t.getId();p=null;}else{if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}p=t.getId();o=t;}}},this);if(o){k=this._computeLastVisibleHeight(o);if(this._bMobileScenario&&P){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+k;}else{if(p){this._oSectionInfo[p].positionBottom=this._oSectionInfo[p].positionTop+k;}if(P&&p){this._oSectionInfo[P].positionBottom=this._oSectionInfo[p].positionTop+k;}}m=this._bStickyAnchorBar||(r>1)||this._checkContentBottomRequiresSnap(o);if(m&&!this._shouldPreserveHeaderInTitleArea()){n=true;}s=this._computeSpacerHeight(o,k,m,n);this._$spacer.height(s+"px");q.sap.log.debug("ObjectPageLayout :: bottom spacer is now "+s+"px");}this._updateCustomScrollerHeight(n);this._setSectionInfoIsDirty(false);return true;};i.prototype._updateCustomScrollerHeight=function(r){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var s=this._computeScrollableContentSize(r);s+=this._getStickyAreaHeight(r);this._getCustomScrollBar().setContentSize(s+"px");var k=(s>Math.ceil(this.iScreenHeight)),v=(k!==this._getCustomScrollBar().getVisible());if(v){this._getCustomScrollBar().setVisible(k);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};i.prototype._computeScrollableContentSize=function(s){var k=0;if(this._$contentContainer&&this._$contentContainer.length){k=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&s){k-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!s){k+=this.iAnchorBarHeight;}return k;};i.prototype._computeLastVisibleHeight=function(o){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var k=this._getSectionPositionTop(o,I);return this._$spacer.position().top-k;};i.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};i.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};i.prototype._getSectionPositionTop=function(s,k){var p=s.$().position().top;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&k){p-=this.iAnchorBarHeight;}return p;};i.prototype._getSectionPositionBottom=function(s,k){var p=this._oSectionInfo[s.getId()].positionBottom;if(!k){p+=this.iAnchorBarHeight;}return p;};i.prototype._determineSectionBaseInternalTitleLevel=function(s){var k=this.getSectionTitleLevel(),I=s instanceof a;if(k===g.Auto){return I?g.H3:g.H4;}return I?k:i._getNextTitleLevelEntry(k);};i.prototype._shouldApplySectionTitleLevel=function(s){return s.getTitleLevel()===g.Auto;};i.prototype._checkContentBottomRequiresSnap=function(s){var k=false;return this._getSectionPositionBottom(s,k)>=(this._getScrollableViewportHeight(k)+this._getSnapPosition());};i.prototype._computeSpacerHeight=function(o,k,m,s){var n,p,F;if(this.getFooter()&&this.getShowFooter()){F=this.$("footerWrapper").outerHeight();}p=this._getScrollableViewportHeight(s);if(!m){k=this._getSectionPositionBottom(o,false);}if(k<p){n=p-k;if(this._bMobileScenario){n+=(this._oSectionInfo[o.getId()].positionTopMobile-this._oSectionInfo[o.getId()].positionTop);}}else{n=0;}if(F>n){n+=F;}return n;};i.prototype._isFirstVisibleSectionBase=function(s){var k;if(s&&(this._oFirstVisibleSubSection||this._oFirstVisibleSection)){k=s.getId();return k===this._oFirstVisibleSection.getId()||k===this._oFirstVisibleSubSection.getId();}return false;};i.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var F;this._aSectionBases.every(function(o){if(o.getParent()&&(o.getParent().getId()===s.getId())){F=o;return false;}return true;});return F;};i.prototype._initAnchorBarScroll=function(){var s=this.oCore.byId(this.getSelectedSection()),k;this._requestAdjustLayout(true);k=s?this._computeScrollPosition(s):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:k}});};i.prototype._setAsCurrentSection=function(s){var o,k,m;if(this._sScrolledSectionId===s){return;}q.sap.log.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;o=this.getAggregation("_anchorBar");if(o&&this._getInternalAnchorBarVisible()){k=this.oCore.byId(s);m=k&&k instanceof b&&(k.getTitle().trim()===""||!k._getInternalTitleVisible()||k.getParent()._getIsHidden());if(m){s=k.getParent().getId();q.sap.log.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(k&&this._oSectionInfo[s]){o.setSelectedButton(this._oSectionInfo[s].buttonId);this.setAssociation("selectedSection",a._getClosestSection(s).getId(),true);this._setSectionsFocusValues(s);}}};i.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};i.prototype._onUpdateContentSize=function(E){var s;if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(this._hasDynamicTitle()){this._adjustHeaderHeights();}this._requestAdjustLayout().then(function(){s=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(s);}.bind(this));};i.prototype._onUpdateScreenSize=function(E){var t=this.getHeaderTitle(),k=E.size.width,m=E.size.height,o=E.oldSize.height,H=(m!==o),s;if(E.size.height===0||E.size.width===0){q.sap.log.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){q.sap.log.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();q.sap.delayedCall(i.HEADER_CALC_DELAY,this,function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader()){this.invalidate();}if(t&&t.isDynamic()){t._onResize(k);this._updateMedia(k);}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}s=this.getSelectedSection();if((o===0)&&H&&!this._isClosestScrolledSection(s)){this.scrollToSection(s,0);return;}this._scrollTo(this._$opWrapper.scrollTop(),0);});};i.prototype._shouldSnapHeaderOnScroll=function(s){return(s>0)&&(s>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};i.prototype._onScroll=function(E){var s=Math.max(E.target.scrollTop,0),p,H=this.getHeaderTitle(),k=this._shouldSnapHeaderOnScroll(s),m=this._shouldPreserveHeaderInTitleArea(),n=false;if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}p=this.iScreenHeight;if(p===0){return;}if(this._getSectionInfoIsDirty()){return;}if(k&&!m){p-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!m){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!m&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(k,!!(E&&E.type==="scroll"));}if(!m){this._adjustHeaderTitleBackgroundPosition(s);}q.sap.log.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");this._updateSelectionOnScroll(s);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(s,E.timeStamp,p);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(s===0){q.sap.byId(this.getId()+"-scroll").css("z-index","1000");n=false;}else if(!n){n=true;q.sap.byId(this.getId()+"-scroll").css("z-index","0");}}};i.prototype._updateSelectionOnScroll=function(s){var p=this.iScreenHeight,k,m;if(p===0){return;}k=this._getClosestScrolledSectionId(s,p);m=this._getClosestScrolledSectionId(s,p,true);if(k){var n=this.getDirectScrollingToSection();if(k!==this._sScrolledSectionId){q.sap.log.debug("ObjectPageLayout :: closest id "+k,"----------------------------------------");var n=this.getDirectScrollingToSection();if(n&&n!==k){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(k);}else if(k===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(m!==this._sScrolledSubSectionId){this._sScrolledSubSectionId=m;this.fireEvent("_sectionChange",{section:this.oCore.byId(k),subSection:this.oCore.byId(m)});}}};i.prototype._getSnapPosition=function(){var s=this.iHeaderContentHeight,t=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;if(t<i.MAX_SNAP_POSITION_OFFSET){s-=t;}return s;};i.prototype._getClosestScrolledSectionId=function(s,p,k){k=!!k;s=Math.ceil(s);if(this.getUseIconTabBar()&&this._oCurrentTabSection){return this._oCurrentTabSection.getId();}var m=s+p,n,t=k||this._bMobileScenario;q.each(this._oSectionInfo,function(I,o){var r,u,v;r=this.oCore.byId(I);if(!r){return;}u=r.getParent();v=u instanceof a&&u._getIsHidden();if(o.isSection||(t&&!v)){if(!n&&(o.sectionReference._getInternalVisible()===true)){if(o.isSection&&k){n=this._getFirstVisibleSubSection(o.sectionReference).getId();}else{n=I;}}if(o.isSection&&k){return true;}if(o.positionTop<=m&&s<=o.positionBottom){if(o.positionTop<=s&&o.positionBottom>s){n=I;return false;}}}}.bind(this));return n;};i.prototype._toggleHeader=function(s,u){var H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!s,u);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}};i.prototype._restoreFocusAfter=function(m){var o=this.oCore.byId(this.oCore.getCurrentFocusedControlId());m.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){o&&o.$().focus();}}return this;};i.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};i.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._toggleHeaderStyleRules(false);}return this;};i.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.toggleClass("sapContrastPlus",!s);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",s);this._$anchorBar.css("visibility",v);this.fireToggleAnchorBar({fixed:s});};i.prototype.getScrollDelegate=function(){return this._oScroller;};i.prototype.setHeaderTitle=function(H,s){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});}this.setAggregation("headerTitle",H,s);if(H){this._createHeaderContent();}return this;};i.prototype.invalidate=function(o){if(this.getUseIconTabBar()&&o&&(o instanceof a)&&!o.isActive()){return;}C.prototype.invalidate.apply(this,arguments);};i.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),o=this.getAggregation("_headerContent"),n;var k=H?H.getCompatibleHeaderContentClass():c;if(!(o instanceof k)){var n=k.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable());this.setAggregation("_headerContent",n,true);}};i.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};i.prototype._adjustHeaderTitleBackgroundPosition=function(s){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};i.prototype._adjustHeaderHeights=function(){var t=this.getHeaderTitle(),p=true;if(t&&!t.supportsAdaptLayoutForDomElement()){p=false;}if(this._$headerTitle.length>0){this.iHeaderContentHeight=this._$headerContent[0].parentElement?Math.ceil(this._$headerContent[0].getBoundingClientRect().height):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.height():this._$anchorBar.height();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(p);}else{this.iHeaderTitleHeight=this._$headerTitle.is(":visible")?this._$headerTitle.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(p);}this._adjustHeaderBackgroundSize();q.sap.log.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{q.sap.log.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};i.prototype._appendTitleCloneToDOM=function(E){var $=this._$headerTitle.clone();$.css({position:"absolute"});$.css({left:"-10000px",top:"-10000px",width:this._$headerTitle.width()+"px"});$.toggleClass("sapUxAPObjectPageHeaderStickied",E);$.appendTo(this._$headerTitle.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptLayoutForDomElement($);}return $;};i.prototype._obtainSnappedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();this._$opWrapper.css("overflow-y","auto");}else if(t&&t.snap){t.snap(false);H=t.$().outerHeight();t.unSnap(false);}return H;};i.prototype._obtainExpandedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();this._$opWrapper.css("overflow-y","auto");}else if(t&&t.unSnap){t.unSnap(false);H=t.$().outerHeight();t.snap(false);}return H;};i.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),s=l.ObjectPageHeaderDesign.Light;if(H!=null){s=H.getHeaderDesign();}return s;};i.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};i.prototype._setSectionsFocusValues=function(s){var k=this._getVisibleSections()||[],$,F='0',n='-1',t="tabIndex",o,m=k[0];k.forEach(function(p){$=p.$();if(s===p.sId){$.attr(t,F);o=p;p._setSubSectionsFocusValues();}else{$.attr(t,n);p._disableSubSectionsFocus();}});if(!o&&k.length>0){m.$().attr(t,F);m._setSubSectionsFocusValues();o=m;}return o;};i.prototype.setShowHeaderContent=function(s){var o=this.getShowHeaderContent(),H;if(o!==s){if(o&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",s);H=this._getHeaderContent();if(H){H.setProperty("visible",s);}}return this;};i.prototype._headerTitleChangeHandler=function(I){var r;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}r=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);this._getHeaderContent().invalidate();r.destroy();};i.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};i.prototype.insertHeaderContent=function(o,I,s){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",o,I,s);}return this._getHeaderContent().insertAggregation("content",o,I,s);};i.prototype.addHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.addAggregation("headerContent",o,s);}return this._getHeaderContent().addAggregation("content",o,s);};i.prototype.removeAllHeaderContent=function(s){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",s);}return this._getHeaderContent().removeAllAggregation("content",s);};i.prototype.removeHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",o,s);}return this._getHeaderContent().removeAggregation("content",o,s);};i.prototype.destroyHeaderContent=function(s){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",s);}return this._getHeaderContent().destroyAggregation("content",s);};i.prototype.indexOfHeaderContent=function(o){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",o);}return this._getHeaderContent().indexOfAggregation("content",o);};i.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};i.prototype._checkAlwaysShowContentHeader=function(){var H=this._getHeaderContent();return H&&H.supportsAlwaysExpanded()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};i.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(o){o.connectToModels();});};i.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};i.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};i.prototype._shiftHeaderTitle=function(){var s=this._calculateShiftOffset(),k=s.sStyleAttribute,p=s.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+k,p+"px");};i.prototype._isFirstSection=function(s){var k=this._getVisibleSections();if(s===k[0]){return true;}return false;};i.prototype._isPositionWithinSection=function(s,o){if(!o||!this._bDomReady||!this._oSectionInfo[o.getId()]){return;}var k=this._computeScrollPosition(o),m=q(o.getDomRef()).height(),n=k+m;return((s>=k)&&(s<n));};i.prototype._restoreScrollPosition=function(){var s=this.oCore.byId(this._sStoredScrolledSubSectionId);if(!s){return;}if(this._isPositionWithinSection(this._iStoredScrollPosition,s)){this._scrollTo(this._iStoredScrollPosition,0);}else{this.scrollToSection(s.getId(),0);}};i.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady){return;}this._iStoredScrollPosition=this._oScroller.getScrollTop();this._sStoredScrolledSubSectionId=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true);this._oCurrentTabSection=null;};i.prototype.onkeyup=function(E){var F,o;if(E.which===q.sap.KeyCodes.TAB){F=this.oCore.getCurrentFocusedControlId();o=F&&this.oCore.byId(F);if(o&&this._isFirstSection(o)){this._scrollTo(0,0);}}};i.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};i.prototype._toggleFooter=function(s){var u=this.oCore.getConfiguration().getAnimation(),F=this.getFooter();if(!j(F)){return;}F.toggleStyleClass("sapUxAPObjectPageFloatingFooterShow",s);F.toggleStyleClass("sapUxAPObjectPageFloatingFooterHide",!s);if(this._iFooterWrapperHideTimeout){q.sap.clearDelayedCall(this._iFooterWrapperHideTimeout);}if(u){if(!s){this._iFooterWrapperHideTimeout=q.sap.delayedCall(i.FOOTER_ANIMATION_DURATION,this,function(){this.$("footerWrapper").toggleClass("sapUiHidden",!s);});}else{this.$("footerWrapper").toggleClass("sapUiHidden",!s);this._iFooterWrapperHideTimeout=null;}q.sap.delayedCall(i.FOOTER_ANIMATION_DURATION,this,function(){F.removeStyleClass("sapUxAPObjectPageFloatingFooterShow");});}this._requestAdjustLayout();};i.prototype.clone=function(){var o,H;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);o=C.prototype.clone.apply(this,arguments);H=this._getHeaderContent();o.setAggregation("_headerContent",H.clone(),true);return o;};i.prototype._cloneProxiedAggregations=function(s){var o=this.mAggregations[s];if(Array.isArray(o)&&o.length===0){o=this["get"+s.charAt(0).toUpperCase()+s.slice(1)]();}this.mAggregations[s]=o;};i.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};i.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};i.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};i.prototype._headerBiggerThanAllowedToBeFixed=function(){var k=this._getOwnHeight();return this._getEntireHeaderHeight()>i.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*k;};i.prototype._getOwnHeight=function(){return this._getHeight(this);};i.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};i.prototype._getEntireHeaderHeight=function(){var t=0,H=0,o=this.getHeaderTitle(),k=this._getHeaderContent();if(j(o)){t=o.$().outerHeight();}if(j(k)){H=k.$().outerHeight();}return t+H;};i.prototype._onPinUnpinButtonPress=function(E){if(this._bPinned){this._unPin(E);}else{this._pin(E);}};i.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(j($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}};i.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(j($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};i.prototype._togglePinButtonARIAState=function(p){var H=this._getHeaderContent();if(j(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(p);}};i.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};i.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};i.prototype._hasDynamicTitle=function(){var t=this.getHeaderTitle();return t&&t.isDynamic();};i.prototype._attachVisualIndicatorsPressHandlers=function(p,o){var t=this.getHeaderTitle(),H=this._getHeaderContent();if(j(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(i.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){p.call(o);this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(j(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(i.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){p.call(o);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};i.prototype._updateToggleHeaderVisualIndicators=function(){var H,k,E;if(!this.getToggleHeaderOnTitleClick()||this._bPinned){k=false;E=false;}else{H=this._bHeaderExpanded;k=H;E=!H;}this._toggleCollapseVisualIndicator(k);this._toggleExpandVisualIndicator(E);};i.prototype._focusCollapseVisualIndicator=function(){var o=this._getHeaderContent();if(j(o)){o._focusCollapseButton();}};i.prototype._focusExpandVisualIndicator=function(){var o=this.getHeaderTitle();if(j(o)){o._focusExpandButton();}};i.prototype._toggleExpandVisualIndicator=function(t){var o=this.getHeaderTitle();if(j(o)){o._toggleExpandButton(t);}};i.prototype._toggleCollapseVisualIndicator=function(t){var o=this._getHeaderContent();if(j(o)){o._toggleCollapseButton(t);}};i.prototype._attachVisualIndicatorMouseOverHandlers=function(o,k,m){var H=this._getHeaderContent();if(j(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(i.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,o,m);H.attachEvent(i.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,k,m);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};i.prototype._attachTitleMouseOverHandlers=function(o,k,m){var t=this.getHeaderTitle();if(j(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(i.EVENTS.TITLE_MOUSE_OVER,o,m);t.attachEvent(i.EVENTS.TITLE_MOUSE_OUT,k,m);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};i.prototype._suppressScroll=function(){this._bSuppressScroll=true;};i.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollPosition){this._scrollTo(this._iStoredScrollPosition,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};i.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};i.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};i.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};i.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};i.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};i.prototype._setSectionInfoIsDirty=function(k){this.bSectionInfoIsDirty=k;};function j(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(k){return j(k);});}return i;});
