/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/layout/Grid","sap/ui/layout/GridData","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","./library","sap/m/library","./ObjectPageSubSectionRenderer","jquery.sap.keycodes"],function(q,G,a,O,b,B,c,D,S,d,l,m,e){"use strict";var f=m.ButtonType;var g=l.ObjectPageSubSectionMode;var h=l.ObjectPageSubSectionLayout;var i=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:g.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"}});i.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;i.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._oObserver=new d(i.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._attachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._switchSubSectionMode(this.getMode());};i.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};i.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};i.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};i.prototype._observeChanges=function(C){var o=C.object,s=C.name,M=C.mutation,j=C.child,H;if(o===this){if(s==="actions"){if(M==="insert"){this._observeAction(j);}else if(M==="remove"){this._unobserveAction(j);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};i.prototype._observeAction=function(C){this._oObserver.observe(C,{properties:["visible"]});};i.prototype._unobserveAction=function(C){this._oObserver.unobserve(C,{properties:["visible"]});};i.prototype._unStashControls=function(){S.getStashedControls(this.getId()).forEach(function(C){C.setStashed(false);});};i.prototype.connectToModels=function(){var j=this.getBlocks()||[],M=this.getMoreBlocks()||[],C=this.getMode();this._unStashControls();j.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});if(M.length>0&&C===g.Expanded){M.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});}};i.prototype._allowPropagationToLoadedViews=function(A){var j=this.getBlocks()||[],M=this.getMoreBlocks()||[];j.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});M.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});};i.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return O.prototype.clone.apply(this,arguments);};i.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(k){p[k].forEach(function(o){o.destroy();});});};i.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};i.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._$spacer=q.sap.byId(o.getId()+"-spacer");};i.prototype.onBeforeRendering=function(){var o=this._getObjectPageLayout();if(!o){return;}if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(o);this.refreshSeeMoreVisibility();};i.prototype._applyLayout=function(L){var v,o=this._getGrid(),C=this.getMode(),s=L.getSubSectionLayout(),j=this._calculateLayoutConfiguration(s,L),k=this.getBlocks(),A=k.concat(this.getMoreBlocks());this._oLayoutConfig=j;this._resetLayoutData(A);if(C===g.Expanded){v=A;}else{v=k;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(n){this._setBlockMode(n,C);o.addAggregation("content",n,true);},this);}catch(E){q.sap.log.error("ObjectPageSubSection :: error while building layout "+s+": "+E);}return this;};i.prototype._calculateLayoutConfiguration=function(L,o){var j={M:2,L:3,XL:4},k=j.L,E=j.XL,t=(L===h.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){k-=1;E-=1;}if(u){k-=1;}j.L=k;j.XL=E;return j;};i.prototype.refreshSeeMoreVisibility=function(){var j=!!this.getMoreBlocks().length,s=this._getSeeMoreButton(),$=s.$(),k=this.$();if(!j){j=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(k.length){k.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",j);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",j);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",j);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",j);return j;};i.prototype.setMode=function(M){if(this.getMode()!==M){this._switchSubSectionMode(M);if(this._bRenderedFirstTime){this.rerender();}}return this;};i.prototype.onkeydown=function(E){if(E.keyCode===q.sap.KeyCodes.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof i){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};i.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};i.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};i.prototype._calcBlockColumnLayout=function(j,C){var k=12,v,M,L,X,n;M={iRemaining:C.M,iColumnConfig:C.M};L={iRemaining:C.L,iColumnConfig:C.L};X={iRemaining:C.XL,iColumnConfig:C.XL};n=[X,L,M];v=j.filter(function(o){return o.getVisible&&o.getVisible();});v.forEach(function(o,I){n.forEach(function(p){p.iCalculatedSize=this._calculateBlockSize(o,p.iRemaining,v,I,p.iColumnConfig);},this);o.setLayoutData(new a(o.getId()+"-layoutData",{spanS:k,spanM:M.iCalculatedSize*(k/M.iColumnConfig),spanL:L.iCalculatedSize*(k/L.iColumnConfig),spanXL:X.iCalculatedSize*(k/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));n.forEach(function(p){p.iRemaining-=p.iCalculatedSize;if(p.iRemaining<1){p.iRemaining=p.iColumnConfig;}});},this);return v;};i.prototype._calculateBlockSize=function(o,r,v,C,M){var j,F=M,k;if(!this._hasAutoLayout(o)){return Math.min(M,parseInt(o.getColumnLayout(),10));}for(k=1;k<=F;k++){j=this._calcLayout(v[C+k]);if(j<r){r-=j;}else{break;}}return r;};i.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout(),10);}return L;};i.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};i.prototype._onDesktopMediaRange=function(C){return this._onMediaRange(C,["LargeDesktop","Desktop"]);};i.prototype._onTabletMediaRange=function(C){return this._onMediaRange(C,["Tablet"]);};i.prototype._onPhoneMediaRange=function(C){return this._onMediaRange(C,["Phone"]);};i.prototype._onMediaRange=function(C,j){var M=C||this._getCurrentMediaContainerRange();return j.indexOf(M.name)>-1;};i.prototype._synchronizeBlockLayouts=function(C){if(this._getUseTitleOnTheLeft()){this.$("header").toggleClass("titleOnLeftLayout",this._onDesktopMediaRange(C));}this._toggleBlockLayoutResponsiveStyles(C);};i.prototype._toggleBlockLayoutResponsiveStyles=function(C){this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerDesktop",this._onDesktopMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerTablet",this._onTabletMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerPhone",this._onPhoneMediaRange(C));};i.prototype._getMediaString=function(C){if(this._onPhoneMediaRange(C)){return"Phone";}if(this._onTabletMediaRange(C)){return"Tablet";}return"Desktop";};i.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};i.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};i.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};i.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};i.prototype.addAggregation=function(A,o,s){var j;if(o instanceof b){o.getContent().forEach(function(C){this.addAggregation(A,C,true);},this);o.removeAllContent();o.destroy();this.invalidate();return this;}if(this.hasProxy(A)){j=this._getAggregation(A);j.push(o);this._setAggregation(A,j,s);if(o instanceof B||o instanceof b){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};i.prototype.insertBlock=function(o,I){q.sap.log.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};i.prototype.insertMoreBlock=function(o,I){q.sap.log.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};i.prototype.removeAllAggregation=function(A,s){var I;if(this.hasProxy(A)){I=this._getAggregation(A);this._setAggregation(A,[],s);return I.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};i.prototype.removeAggregation=function(A,o){var r=false,I;if(this.hasProxy(A)){I=this._getAggregation(A);I.forEach(function(j,k){if(j.getId()===o.getId()){I.splice(k,1);this._setAggregation(A,I);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};i.prototype.indexOfAggregation=function(A,o){var I=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(j,k){if(j.getId()===o.getId()){I=k;return true;}},this);return I;}return O.prototype.indexOfAggregation.apply(this,arguments);};i.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};i.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};i.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:f.Transparent,iconFirst:false}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};i.prototype._seeMoreLessControlPressHandler=function(E){var C=this.getMode(),t,M=this.getMoreBlocks()||[];if(C===g.Expanded){t=g.Collapsed;}else{t=g.Expanded;M.forEach(function(o){if(o instanceof B){o.setMode(C);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};i.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===g.Collapsed){this.setProperty("mode",g.Collapsed,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",g.Expanded,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_LESS"));}};i.prototype._setBlockMode=function(o,M){if(o instanceof B){o.setMode(M);}else{q.sap.log.debug("ObjectPageSubSection :: cannot propagate mode "+M+" to "+o.getMetadata().getName());}};i.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabIndex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};i.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o&&(o.getSubSectionLayout()===h.TitleOnLeft);};i.prototype._resetLayoutData=function(j){j.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};i.prototype.getVisibleBlocksCount=function(){var v=S.getStashedControls(this.getId()).length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(M){if(M.getVisible&&!M.getVisible()){return true;}v++;});return v;};return i;});
