/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/Device","sap/ui/core/Control","sap/m/library","sap/m/ToggleButton","sap/m/Button","./DynamicPageHeaderRenderer"],function(l,D,C,m,T,B,a){"use strict";var b=m.ButtonType;var c=C.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_collapseButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPageHeader.designtime"}});c._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};c.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_EXPANDED:"aria-expanded",ARIA_LABEL:"aria-label",LABEL_EXPANDED:c._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_SNAPPED:c._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:c._getResourceBundle().getText("PIN_HEADER"),LABEL_UNPINNED:c._getResourceBundle().getText("UNPIN_HEADER"),TOOLTIP_COLLAPSE_BUTTON:c._getResourceBundle().getText("COLLAPSE_HEADER_BUTTON_TOOLTIP"),STATE_TRUE:"true",STATE_FALSE:"false"};c.prototype.init=function(){this._bShowCollapseButton=true;};c.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();};c.prototype._togglePinButton=function(v){this._getPinButton().setPressed(v);};c.prototype._setShowPinBtn=function(v){this._getPinButton().$().toggleClass("sapUiHidden",!v);};c.prototype._pinUnpinFireEvent=function(){this.fireEvent("_pinUnpinPress");};c.prototype._onCollapseButtonPress=function(){this.fireEvent("_headerVisualIndicatorPress");};c.prototype._onCollapseButtonMouseOver=function(){this.fireEvent("_visualIndicatorMouseOver");};c.prototype._onCollapseButtonMouseOut=function(){this.fireEvent("_visualIndicatorMouseOut");};c.prototype._initARIAState=function(){var $=this.$();$.attr(c.ARIA.ARIA_EXPANDED,c.ARIA.STATE_TRUE);$.attr(c.ARIA.ARIA_LABEL,c.ARIA.LABEL_EXPANDED);};c.prototype._initPinButtonARIAState=function(){var $;if(this.getPinnable()){$=this._getPinButtonJQueryRef();$.attr(c.ARIA.ARIA_CONTROLS,this.getId());}};c.prototype._updateARIAState=function(e){var $=this.$();if(e){$.attr(c.ARIA.ARIA_EXPANDED,c.ARIA.STATE_TRUE);$.attr(c.ARIA.ARIA_LABEL,c.ARIA.LABEL_EXPANDED);}else{$.attr(c.ARIA.ARIA_EXPANDED,c.ARIA.STATE_FALSE);$.attr(c.ARIA.ARIA_LABEL,c.ARIA.LABEL_SNAPPED);}};c.prototype._updateARIAPinButtonState=function(p){var P=this._getPinButton();if(p){P.setTooltip(c.ARIA.LABEL_UNPINNED);}else{P.setTooltip(c.ARIA.LABEL_PINNED);}};c.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var p=new T({id:this.getId()+"-pinBtn",icon:"sap-icon://pushpin-off",tooltip:c.ARIA.LABEL_PINNED,type:b.Transparent,press:this._pinUnpinFireEvent.bind(this)});this.setAggregation("_pinButton",p,true);}return this.getAggregation("_pinButton");};c.prototype._getCollapseButton=function(){if(!this.getAggregation("_collapseButton")){var o=new B({id:this.getId()+"-collapseBtn",icon:"sap-icon://slim-arrow-up",press:this._onCollapseButtonPress.bind(this),tooltip:c.ARIA.TOOLTIP_COLLAPSE_BUTTON}).addStyleClass("sapFDynamicPageToggleHeaderIndicator");o.onmouseover=this._onCollapseButtonMouseOver.bind(this);o.onmouseout=this._onCollapseButtonMouseOut.bind(this);this.setAggregation("_collapseButton",o,true);}return this.getAggregation("_collapseButton");};c.prototype._toggleCollapseButton=function(t){this._setShowCollapseButton(t);this._getCollapseButton().$().toggleClass("sapUiHidden",!t);};c.prototype._getShowCollapseButton=function(){return this._bShowCollapseButton;};c.prototype._setShowCollapseButton=function(v){this._bShowCollapseButton=!!v;};c.prototype._focusCollapseButton=function(){this._getCollapseButton().$().focus();};c.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().focus();};c.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$();};c.prototype._getState=function(){var d=this.getContent(),h=d.length>0,H=this.getPinnable()&&h&&!D.system.phone,p=this._getPinButton(),o=this._getCollapseButton();o.toggleStyleClass("sapUiHidden",!this._getShowCollapseButton());return{content:d,headerHasContent:h,headerPinnable:H,hasContent:d.length>0,pinButton:p,collapseButton:o};};return c;});
