/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/base/DataType','sap/ui/core/CSSColor','sap/ui/core/delegate/ItemNavigation','./Button','./Dialog','./library','./ColorPaletteRenderer'],function(C,D,a,b,I,B,c,l,d){"use strict";var e;var f;var g=l.ButtonType;var h=a.getType("boolean");var i="sapMColorPaletteSquare";var S=5;var M=2;var j=15;var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");var k=C.extend("sap.m.ColorPalette",{metadata:{library:"sap.m",properties:{colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]}},aggregations:{_defaultColorButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_moreColorsButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}}});k.prototype.init=function(){this._oDefaultColor=null;this._bShowDefaultColorButton=false;this._bShowMoreColorsButton=false;this._oMoreColorsDialog=null;this._oItemNavigation=null;};k.prototype.exit=function(){if(this._oMoreColorsDialog){this._oMoreColorsDialog.destroy();delete this._oMoreColorsDialog;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};k.prototype.setColors=function(n){n=this.validateProperty("colors",n);if(n.length<M||n.length>j){throw new Error("Cannot set property 'colors' - array must has minimum 2 and maximum 15 elements");}return this.setProperty("colors",n);};k.prototype.ontap=function(E){var t=jQuery(E.target),s,$;$=t.closest("."+i);if(!$.length){return;}s=$.attr("data-sap-ui-color");this._fireColorSelect(s,false,E);};k.prototype.onsaptabnext=k.prototype.onsaptabprevious=function(E){var o=this._getShowDefaultColorButton()&&jQuery.sap.containsOrEquals(E.target,this._getDefaultColorButton().getDomRef()),O=this._getShowMoreColorsButton()&&jQuery.sap.containsOrEquals(E.target,this._getMoreColorsButton().getDomRef());if(O){this.fireEvent("_colorNotSelected",{_originalEvent:E});return;}if(o){this._fireColorSelect(this._getDefaultColor(),true,E);return;}k.prototype.ontap.apply(this,arguments);};k.prototype.onsapspace=k.prototype.onsapenter=k.prototype.ontap;k.prototype.onAfterRendering=function(){this._ensureItemNavigation();};k.prototype._createDefaultColorButton=function(){return new B(this.getId()+"-btnDefaultColor",{width:"100%",type:g.Transparent,text:L.getText("COLOR_PALETTE_DEFAULT_COLOR"),visible:this._getShowDefaultColorButton(),press:function(E){this._fireColorSelect(this._getDefaultColor(),true,E);}.bind(this)});};k.prototype._getDefaultColor=function(){return this._oDefaultColor;};k.prototype._setDefaultColor=function(n){if(!b.isValid(n)){throw new Error("Cannot set internal property '_defaultColor' - invalid value: "+n);}this._oDefaultColor=n;return this;};k.prototype._getShowDefaultColorButton=function(){return this._bShowDefaultColorButton;};k.prototype._setShowDefaultColorButton=function(v){if(!h.isValid(v)){throw new Error("Cannot set internal property 'showDefaultColorButton' - invalid value: "+v);}this._bShowDefaultColorButton=v;if(v&&!this._getDefaultColorButton()){this.setAggregation("_defaultColorButton",this._createDefaultColorButton());}if(this._getDefaultColorButton()){this._getDefaultColorButton().setVisible(v);}return this;};k.prototype._getDefaultColorButton=function(){return this.getAggregation("_defaultColorButton");};k.prototype._createMoreColorsButton=function(){return new B(this.getId()+"-btnMoreColors",{width:"100%",type:g.Transparent,text:L.getText("COLOR_PALETTE_MORE_COLORS"),visible:this._getShowMoreColorsButton(),press:this._openColorPicker.bind(this)});};k.prototype._getShowMoreColorsButton=function(){return this._bShowMoreColorsButton;};k.prototype._setShowMoreColorsButton=function(v){if(!h.isValid(v)){throw new Error("Cannot set internal property 'showMoreColorsButton' - invalid value: "+v);}this._bShowMoreColorsButton=v;if(v&&!this._getMoreColorsButton()){this.setAggregation("_moreColorsButton",this._createMoreColorsButton());}if(this._getMoreColorsButton()){this._getMoreColorsButton().setVisible(v);}return this;};k.prototype._getMoreColorsButton=function(){return this.getAggregation("_moreColorsButton");};k.prototype._openColorPicker=function(){this.fireEvent("_beforeOpenColorPicker");this._ensureMoreColorsDialog().open();};k.prototype._ensureMoreColorsDialog=function(){if(!this._oMoreColorsDialog){this._oMoreColorsDialog=this._createMoreColorsDialog();}return this._oMoreColorsDialog;};k.prototype._createMoreColorsDialog=function(){var o=new c(this.getId()+"-moreColorsDialog",{contentWidth:D.system.phone?"":"29rem",stretch:!!D.system.phone,title:L.getText("COLOR_PALETTE_MORE_COLORS_TITLE")});this._ensureUnifiedLibrary();o.addContent(o._oColorPicker=new e({mode:f.HSL}));o.setBeginButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CONFIRM"),press:function(E){o.close();if(o._oColorPicker.getColorString()){this._fireColorSelect(o._oColorPicker.getColorString(),false,E);}}.bind(this)}));o.setEndButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CANCEL"),press:function(){o.close();}}));return o;};k.prototype._ensureUnifiedLibrary=function(){var u;if(!e){sap.ui.getCore().loadLibrary("sap.ui.unified");u=sap.ui.require("sap/ui/unified/library");e=sap.ui.requireSync("sap/ui/unified/ColorPicker");f=u.ColorPickerMode;}};k.prototype._focusFirstElement=function(){var F=this._getShowDefaultColorButton()?this._getDefaultColorButton().getDomRef():this._getAllSwatches()[0];F.focus();};k.prototype._fireColorSelect=function(n,o,O){this.fireColorSelect({value:n,defaultAction:o,_originalEvent:O});};k.prototype._ensureItemNavigation=function(){var n=[],o=this._getDefaultColorButton(),p=this._getMoreColorsButton();if(!this._oItemNavigation){this._oItemNavigation=new m(this);this.addDelegate(this._oItemNavigation);}if(o&&o.getVisible()){n.push(o.getDomRef());}n=n.concat(this._getAllSwatches());if(p&&p.getVisible()){n.push(p.getDomRef());}this._oItemNavigation.setRootDomRef(this.getDomRef());this._oItemNavigation.setItemDomRefs(n);};k.prototype._getAllSwatches=function(){return this.$().find("."+i).get();};var m=I.extend("sap.ui.core.delegate.ItemNavigation",{constructor:function(o){I.apply(this);this._oColorPalette=o;}});m.prototype._onHomeEnd=function(E){var n,N,A,H=E.type==="saphome";if(!jQuery(E.target).hasClass(i)){return;}E.preventDefault();E.stopPropagation();n=jQuery(E.target).index();A=this._oColorPalette._getAllSwatches();N=this._calcIndexOfBorderSwatch(H,n,A.length);A[N].focus();};m.prototype.onsaphome=m.prototype.onsapend=m.prototype._onHomeEnd;m.prototype._calcIndexOfBorderSwatch=function(H,n,s){var o;if(H){o=Math.floor(n/S)*S;}else{o=Math.floor(n/S)*S+(S-1);if(o>s){o=s-1;}}return o;};k.prototype._ItemNavigation=m;k.prototype._ColorsHelper={RGB_TO_NAMED_COLORS_MAP:{"#FFB200":"gold","#FF8C00":"darkorange","#CD5C5C":"indianred","#8B008B":"darkmagenta","#6495ED":"cornflowerblue","#00BFFF":"deepskyblue","#008B8B":"darkcyan","#6B8E23":"olivedrab","#2F4F4F":"darkslategray","#F0FFFF":"azure","#FFFFFF":"white","#D3D3D3":"lightgray","#A9A9A9":"darkgray","#696969":"dimgray","#000000":"black"},NAME_COLORS_TO_RGB_MAP:{"gold":"#FFB200","darkorange":"#FF8C00","indianred":"#CD5C5C","darkmagenta":"#8B008B","cornflowerblue":"#6495ED","deepskyblue":"#00BFFF","darkcyan":"#008B8B","olivedrab":"#6B8E23","darkslategray":"#2F4F4F","azure":"#F0FFFF","white":"#FFFFFF","lightgray":"#D3D3D3","darkgray":"#A9A9A9","dimgray":"#696969","black":"#000000"},getNamedColor:function(s){var H="";if(!s||s.toLowerCase().indexOf("hsl")!==-1){return undefined;}if(s.indexOf("#")===-1){return this.NAME_COLORS_TO_RGB_MAP[s.toLowerCase()]?s.toLowerCase():undefined;}if(s.length===4){H=["#",s[1],s[1],s[2],s[2],s[3],s[3]].join("");}else{H=s;}H=H.toUpperCase();return this.RGB_TO_NAMED_COLORS_MAP[H];}};return k;});
