/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Text','./Title','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ValueStateSupport','./library','sap/ui/Device','sap/ui/core/library','./ComboBoxBaseRenderer','jquery.sap.keycodes'],function(q,D,C,T,B,a,b,c,I,d,V,l,e,f,g){"use strict";var P=l.PlacementType;var h=f.ValueState;var j=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});j.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};j.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};j.prototype.loadItems=function(i,o){var k=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(k){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(k){i.call(this);}};j.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,m,n,k;i<this.aMessageQueue.length;i++){m=this.aMessageQueue.shift();i--;k=(i+1)===this.aMessageQueue.length;n=k?null:this.aMessageQueue[i+1];if(typeof m.action==="function"){if((m.name==="input")&&!k&&(n.name==="input")){continue;}m.action.call(this);}}};j.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};j.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};j.prototype.getPickerInvisibleTextId=function(){return I.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};j.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(e.system.phone?"Dialog":"Dropdown");if(e.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;};j.prototype.onBeforeRendering=function(){var n=this.getValueState()===h.None;C.prototype.onBeforeRendering.apply(this,arguments);if(!this.isPickerDialog()&&n){this._showValueStateText(false);}};j.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;};j.prototype.ontouchstart=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(this.isOpenArea(E.target)){this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};j.prototype.ontouchend=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(!this.isOpen()&&this.isOpenArea(E.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};j.prototype.ontap=function(E){C.prototype.ontap.apply(this,arguments);var i=this.getRenderer().CSS_CLASS_COMBOBOXBASE,o=E.srcControl,p;if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(o.isOpenArea&&o.isOpenArea(E.target)){if(this.isOpen()){this.close();this.removeStyleClass(i+"Pressed");return;}this.loadItems();this.bOpenedByKeyboardOrButton=true;if(this.isPlatformTablet()){p=this.getPicker();p.setInitialFocus(p);}this.open();}if(this.isOpen()){this.addStyleClass(i+"Pressed");}};j.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===q.sap.KeyCodes.F4){this.onF4(E);}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};j.prototype.onF4=function(E){E.preventDefault();};j.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};j.prototype.onsaphide=j.prototype.onsapshow;j.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),F=r&&r.getFocusDomRef();if(p&&q.sap.containsOrEquals(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};j.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};j.prototype.addContent=function(p){};j.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};j.prototype.setPickerType=function(p){this._sPickerType=p;};j.prototype.getPickerType=function(){return this._sPickerType;};j.prototype.setValueState=function(v){var A,s=this.getValueStateText(),S=(v===h.None?false:this.getShowValueStateMessage());this._sOldValueState=this.getValueState();C.prototype.setValueState.apply(this,arguments);this._showValueStateText(S);if(s){this._setValueStateText(s);}else{A=V.getAdditionalText(this);this._setValueStateText(A);}this._alignValueStateStyles();return this;};j.prototype.setValueStateText=function(t){C.prototype.setValueStateText.apply(this,arguments);this._setValueStateText(this.getValueStateText());return this;};j.prototype.setShowValueStateMessage=function(s){C.prototype.setShowValueStateMessage.apply(this,arguments);this._showValueStateText(this.getShowValueStateMessage());return this;};j.prototype._showValueStateText=function(s){var o;if(this.isPickerDialog()){if(this._oPickerValueStateText){this._oPickerValueStateText.setVisible(s);}}else{o=this._getPickerCustomHeader();if(o){o.setVisible(s);}}};j.prototype._setValueStateText=function(t){var H;if(this.isPickerDialog()){this._oPickerValueStateText=this.getPickerValueStateText();this._oPickerValueStateText.setText(t);}else{H=this._getPickerCustomHeader();if(H){H.getContentLeft()[0].setText(t);}}};j.prototype._getPickerCustomHeader=function(){var i,o,p=this.getPicker(),s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"PickerTitle";if(!p){return null;}if(p.getCustomHeader()){return p.getCustomHeader();}i=new c({textAlign:"Left"}).addStyleClass(s);o=new a({visible:false,contentLeft:i});p.setCustomHeader(o);return o;};j.prototype._alignValueStateStyles=function(){var o=this._sOldValueState,i=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Picker",p=i+"ValueState",O=i+o+"State",s=i+this.getValueState()+"State",k;if(this.isPickerDialog()&&this._oPickerValueStateText){this._oPickerValueStateText.addStyleClass(p);this._oPickerValueStateText.removeStyleClass(O);this._oPickerValueStateText.addStyleClass(s);}else{k=this._getPickerCustomHeader();if(k){k.addStyleClass(p);k.removeStyleClass(O);k.addStyleClass(s);}}};j.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};j.prototype.onPropertyChange=function(o,i){var n=o.getParameter("newValue"),p=o.getParameter("name"),m="set"+p.charAt(0).toUpperCase()+p.slice(1),k=(i&&i.srcControl)||this.getPickerTextField();if(/\bvalue\b|\benabled\b|\bname\b|\bplaceholder\b|\beditable\b|\btextAlign\b|\btextDirection\b|\bvalueState\b/.test(p)&&k&&(typeof k[m]==="function")){k[m](n);}};j.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};j.prototype.isPlatformTablet=function(){var n=!e.system.combi,t=e.system.tablet&&n;return t;};j.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};j.prototype.getPickerValueStateText=function(){var p=this.getPicker();if(!this._oPickerValueStateText){this._oPickerValueStateText=new b({width:"100%"});p.insertContent(this._oPickerValueStateText,0);}return this._oPickerValueStateText;};j.prototype.createPicker=function(p){};j.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};j.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};j.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p.getSubHeader();return s&&s.getContent()[0]||null;};j.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};j.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),i=o._handleEvent;o._handleEvent=function(E){i.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){t._handleEvent(E);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();},ariaLabelledBy:t.getPickerInvisibleTextId()||undefined});};j.prototype.createPickerHeader=function(){var t=this,i=d.getIconURI("decline");return new a({contentMiddle:new c(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};j.prototype.revertSelection=function(){};j.prototype.updatePickerHeaderTitle=function(){var p=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),L,i;if(!p){return;}i=this.getLabels();if(i.length){L=i[0];if(L&&(typeof L.getText==="function")){this.getPickerTitle().setText(L.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};j.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};j.prototype.hasContent=function(){return this.getItems().length>0;};j.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};j.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};j.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};j.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};j.prototype.isItemSelected=function(){};j.prototype.getKeys=function(k){k=k||this.getItems();for(var i=0,K=[];i<k.length;i++){K[i]=k[i].getKey();}return K;};j.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};j.prototype.findItem=function(p,v){var L=this.getList();return L?L.findItem(p,v):null;};j.prototype.getItemByText=function(t){return this.findItem("text",t);};j.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),k=i&&i.getDomRef();if(!p||!o||!k){return;}var m=o.scrollTop,n=k.offsetTop,r=o.clientHeight,s=k.offsetHeight;if(m>n){o.scrollTop=n;}else if((n+s)>(m+r)){o.scrollTop=Math.ceil(n+s-r);}};j.prototype.clearFilter=function(){for(var i=0,k=this.getItems();i<k.length;i++){k[i].bVisible=true;}};j.prototype.onItemChange=function(o){};j.prototype.clearSelection=function(){};j.prototype.setInternalBusyIndicator=function(i){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};j.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};j.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};j.prototype.insertItem=function(i,k){this.insertAggregation("items",i,k,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};j.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};j.prototype.getFirstItem=function(){return this.getItems()[0]||null;};j.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};j.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};j.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};j.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};j.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};j.prototype.removeItem=function(i){var L=this.getList();i=L?L.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};j.prototype.removeAllItems=function(){var L=this.getList(),k=L?L.removeAllItems():[];this.clearSelection();for(var i=0;i<k.length;i++){k[i].detachEvent("_change",this.onItemChange,this);}return k;};j.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}return this;};return j;});
