/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','./DatePicker','./library','sap/ui/core/LocaleData','sap/ui/core/format/DateFormat','./DateRangeSelectionRenderer'],function(q,D,a,l,L,b,c){"use strict";var d=a.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}},designtime:"sap/m/designtime/DateRangeSelection.designtime"}});d.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};d.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=j.call(this);var s=h.call(this);var A=F.sAllowedCharacters+s+" ";var C=String.fromCharCode(E.charCode);if(C&&F.sAllowedCharacters&&A.indexOf(C)<0){E.preventDefault();}};d.prototype._getPlaceholder=function(){var p=this.getPlaceholder(),B,o,i,r;if(!p){B=this.getBinding("value");i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();r=L.getInstance(i);if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){o=B.getType();if(o.oFormatOptions&&o.oFormatOptions.format){p=r.getCustomDateTimePattern(o.oFormatOptions.format);}else{p=r.getDatePattern("medium");}}else{p=this.getDisplayFormat();if(!p){p="medium";}if(this._checkStyle(p)){p=r.getDatePattern(p);}}var s=h.call(this);if(s&&s!==""){p=p+" "+s+" "+p;}}return p;};d.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v);this._bValid=true;var i=[undefined,undefined];if(v){i=this._parseValue(v);if(!g.call(this,i[0],i[1])[0]){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid dates",this);}}this.setProperty("dateValue",_(i[0]));this.setProperty("secondDateValue",_(i[1]));if(this.getDomRef()){var o=this._formatValue(i[0],i[1]);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};function _(B){return(typeof B==='number')?new Date(B):B;}function e(B){return(B&&B.getTime)?B.getTime():B;}d.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);q.sap.log.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};d.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var o=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",o,true);if(this.getDomRef()&&(this._$input.val()!==o)){this._$input.val(o);this._curpos=this._$input.cursorPos();}return this;};d.prototype.setFrom=function(F){this.setDateValue(F);return this;};d.prototype.getFrom=function(){return this.getDateValue();};d.prototype.setTo=function(t){this.setSecondDateValue(t);return this;};d.prototype.getTo=function(){return this.getSecondDateValue();};d.prototype.setDateValue=function(o){if(this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),o)){return this;}a.prototype._dateValidation.call(this,o);this._syncDateObjectsToValue(o,this.getSecondDateValue());return this;};d.prototype.setSecondDateValue=function(s){if(this._isValidDate(s)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getSecondDateValue(),s)){return this;}this._bValid=true;if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;}this.setProperty("secondDateValue",s);this._syncDateObjectsToValue(this.getDateValue(),s);return this;};d.prototype.setMinDate=function(o){a.prototype.setMinDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()<this._oMinDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date range",this);}}return this;};d.prototype.setMaxDate=function(o){a.prototype.setMaxDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date range",this);}}return this;};d.prototype._checkMinMaxDate=function(){a.prototype._checkMinMaxDate.apply(this,arguments);var s=this.getSecondDateValue();if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){q.sap.log.error("secondDateValue "+s.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain secondDateValue/value accordingly.",this);}};d.prototype._parseValue=function(v){var F;var i=[];var o,p;var B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){i=B.getType().parseValue(v,"string");if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){i=i.map(function(u){return new Date(u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate(),u.getUTCHours(),u.getUTCMinutes(),u.getUTCSeconds());});}return i;}var s=h.call(this);v=v.trim();if(s&&v){v=n(v,[s," "]);i=v.split(s);if(i.length===2){if(i[0].slice(i[0].length-1,i[0].length)==" "){i[0]=i[0].slice(0,i[0].length-1);}if(i[1].slice(0,1)==" "){i[1]=i[1].slice(1);}}else{i=v.split(" "+s+" ");}if(v.indexOf(s)===-1){var r=v.split(" ");if(r.length===2){i=r;}}}if(v&&i.length<=2){F=j.call(this);if((!s||s==="")||i.length===1){o=F.parse(v);}else if(i.length===2){o=F.parse(i[0]);p=F.parse(i[1]);if(!o||!p){o=undefined;p=undefined;}}}return[o,p];};d.prototype._formatValue=function(o,s){var v="",i=h.call(this),F,B,p,r;p=o;r=s;if(p){B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){if(B.getType().oFormatOptions&&B.getType().oFormatOptions.source&&B.getType().oFormatOptions.source.pattern==="timestamp"){v=B.getType().formatValue([e(o),e(s)],"string");}else{if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){p=new Date(Date.UTC(o.getFullYear(),o.getMonth(),o.getDate(),o.getHours(),o.getMinutes(),o.getSeconds()));if(s){r=new Date(Date.UTC(s.getFullYear(),s.getMonth(),s.getDate(),s.getHours(),s.getMinutes(),s.getSeconds()));}}v=B.getType().formatValue([p,r],"string");}}else{F=j.call(this);if(i&&i!==""&&r){v=F.format(p)+" "+i+" "+F.format(r);}else{v=F.format(p);}}}return v;};d.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var i=[undefined,undefined];this._bValid=true;if(v!=""){i=this._parseValue(v);i=g.call(this,i[0],i[1]);if(i[0]){v=this._formatValue(i[0],i[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",_(i[0]),true);this.setProperty("secondDateValue",_(i[1]),true);}this._setLabelVisibility();if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}f.call(this,this._bValid);}};d.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var i=this._parseValue(v);v=this._formatValue(i[0],i[1]);return v;};d.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var i=this._parseValue(v);v=this._formatValue(i[0],i[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}this._setLabelVisibility();return this;};d.prototype.onsappageup=function(){};d.prototype.onsappageupmodifiers=function(){};d.prototype.onsappagedown=function(){};d.prototype.onsappagedownmodifiers=function(){};d.prototype._fillDateRange=function(){a.prototype._fillDateRange.apply(this,arguments);var E=this.getSecondDateValue();if(E&&E.getTime()>=this._oMinDate.getTime()&&E.getTime()<=this._oMaxDate.getTime()){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};d.prototype._selectDate=function(E){var s=this._oCalendar.getSelectedDates();if(s.length>0){var o=s[0].getStartDate();var i=s[0].getEndDate();if(o&&i){var p=this.getDateValue();var r=this.getSecondDateValue();var v;if(!q.sap.equal(o,p)||!q.sap.equal(i,r)){if(q.sap.equal(i,r)){this.setDateValue(o);}else{this.setProperty("dateValue",o,true);this.setSecondDateValue(i);}v=this.getValue();f.call(this,true);if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this._curpos=v.length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(o,i);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}f.call(this,true);}}this._oPopup.close();}}};d.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=a.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var o=this.getDateValue();if(o){v=this._formatValue(o,this.getSecondDateValue());}}i.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return i;};d.prototype._syncDateObjectsToValue=function(o,s){var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}};function f(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}function g(o,s){var F,S;if(o&&o.getTime){F=o.getTime();}else if(typeof o==='number'){F=o;}if(s&&s.getTime){S=s.getTime();}else if(typeof s==='number'){S=s;}if(o&&s&&F>S){var t=o;o=s;s=t;}if((o&&(F<this._oMinDate.getTime()||F>this._oMaxDate.getTime()))||(s&&(S<this._oMinDate.getTime()||S>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[o,s];}}function h(){var s=this.getDelimiter();if(!s){if(!this._sLocaleDelimiter){var o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var i=L.getInstance(o);var p=i.getIntervalPattern();var I=p.indexOf("{0}")+3;var r=p.indexOf("{1}");s=p.slice(I,r);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}this._sLocaleDelimiter=s;}else{s=this._sLocaleDelimiter;}}return s;}function j(){var p=(this.getDisplayFormat()||"medium");var F;var C=this.getDisplayFormatType();if(p==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}else{if(this._checkStyle(p)){F=b.getInstance({style:p,strictParsing:true,calendarType:C});}else{F=b.getInstance({pattern:p,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=F;}return F;}function k(v,E){return v&&E&&v.lastIndexOf(E)===v.length-E.length;}function m(v,s){return v&&s&&v.indexOf(s)===0;}function n(v,p){var i=0,t=p;if(!t){t=[" "];}while(i<t.length){if(k(v,t[i])){v=v.substring(0,v.length-t[i].length);i=0;continue;}i++;}i=0;while(i<t.length){if(m(v,t[i])){v=v.substring(t[i].length);i=0;continue;}i++;}return v;}return d;});
