/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./List','./library','sap/ui/model/ChangeReason','sap/ui/model/Filter','./FacetFilterListRenderer'],function(q,L,l,C,F,a){"use strict";var b=l.ListMode;var c=l.FacetFilterListDataType;var d=L.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:c.String}},events:{listOpen:{},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}}}}});d.prototype.setTitle=function(t){this.setProperty("title",t,true);this._updateFacetFilterButtonText();return this;};d.prototype.setMultiSelect=function(v){this.setProperty("multiSelect",v,true);var m=v?b.MultiSelect:b.SingleSelectMaster;this.setMode(m);return this;};d.prototype.setMode=function(m){if(m===b.MultiSelect||m===b.SingleSelectMaster){L.prototype.setMode.call(this,m);this.setProperty("multiSelect",m===b.MultiSelect?true:false,true);}return this;};d.prototype._applySearch=function(){var s=this._getSearchValue();if(s!=null){this._search(s,true);this._updateSelectAllCheckBox();}};d.prototype.getSelectedItems=function(){var s=[];var o={};var e=sap.m.ListBase.prototype.getSelectedItems.apply(this,arguments);e.forEach(function(i){s.push(new sap.m.FacetFilterItem({text:i.getText(),key:i.getKey(),selected:true}));o[i.getKey()]=true;});var S=this.getSelectedKeys();var f=Object.getOwnPropertyNames(S);if(e.length<f.length){f.forEach(function(k){if(!o[k]){s.push(new sap.m.FacetFilterItem({text:S[k],key:k,selected:true}));}});}return s;};d.prototype.getSelectedItem=function(){var i=sap.m.ListBase.prototype.getSelectedItem.apply(this,arguments);var s=Object.getOwnPropertyNames(this.getSelectedKeys());if(!i&&s.length>0){i=new sap.m.FacetFilterItem({text:this.getSelectedKeys()[s[0]],key:s[0],selected:true});}return i;};d.prototype.removeSelections=function(A){if(this._allowRemoveSelections){A?this.setSelectedKeys():sap.m.ListBase.prototype.removeSelections.call(this,A);}return this;};d.prototype.getSelectedKeys=function(){var r={};var k=this._oSelectedKeys;Object.getOwnPropertyNames(k).forEach(function(e){r[e]=k[e];});return r;};d.prototype.setSelectedKeys=function(k){this._oSelectedKeys={};var K=false;k&&Object.getOwnPropertyNames(k).forEach(function(e){this._addSelectedKey(e,k[e]);K=true;},this);if(K){this.setActive(true);this._selectItemsByKeys();}else{sap.m.ListBase.prototype.removeSelections.call(this);}};d.prototype._getNonGroupItems=function(){var i=[];this.getItems().forEach(function(I){if(I.getMode()!==b.None){i.push(I);}});return i;};d.prototype.removeSelectedKey=function(k,t){if(this._removeSelectedKey(k,t)){this._getNonGroupItems().forEach(function(i){var I=i.getKey()||i.getText();k===I&&i.setSelected(false);});}};d.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};sap.m.ListBase.prototype.removeSelections.call(this,true);};d.prototype.removeItem=function(i){var I=sap.m.ListBase.prototype.removeItem.apply(this,arguments);if(!this._filtering){I&&I.getSelected()&&this.removeSelectedKey(I.getKey(),I.getText());return I;}};d.prototype.init=function(){this._firstTime=true;this._saveBindInfo;this._oSelectedKeys={};L.prototype.init.call(this);this.setMode(b.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue="";this.attachUpdateFinished(function(e){var u=e.getParameter("reason");u=u?u.toLowerCase():u;if(u==="change"){var B=this.getBinding("items"),m=B?B.getModel():null;if(m&&m.getProperty(B.getPath())){this._iAllItemsCount=m.getProperty(B.getPath()).length||0;}}if(u!=="growing"&&u!==C.Filter.toLowerCase()){this._oSelectedKeys={};this._getNonGroupItems().forEach(function(i){if(i.getSelected()){this._addSelectedKey(i.getKey(),i.getText());}},this);}if(u!==C.Filter.toLowerCase()){this._selectItemsByKeys();}this._updateFacetFilterButtonText();this._updateSelectAllCheckBox();});this._allowRemoveSelections=true;this._bOriginalActiveState;this._iAllItemsCount;};d.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._searchValue="";this._allowRemoveSelections=false;sap.m.ListBase.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true;}};d.prototype._fireListCloseEvent=function(){var s=this.getSelectedItems();var S=this.getSelectedKeys();var A=s.length===0;this._firstTime=true;this.fireListClose({selectedItems:s,selectedKeys:S,allSelected:A});};d.prototype._updateActiveState=function(){var o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||(o&&o.getSelected())){this.setActive(true);}};d.prototype._handleSearchEvent=function(e){var s=e.getParameters()["query"];if(s===undefined){s=e.getParameters()["newValue"];}this._search(s);this._updateSelectAllCheckBox();};d.prototype._search=function(s,f){var e;var n=0;function i(m){return m instanceof sap.ui.model.odata.ODataModel||m instanceof sap.ui.model.odata.v2.ODataModel;}if(f||(s!==this._searchValue)){this._searchValue=s;var B=this.getBinding("items");var o=this.getBindingInfo("items");if(o&&o.binding){e=o.binding.aFilters;if(e.length>0){n=e[0].aFilters.length;if(this._firstTime){this._saveBindInfo=e[0].aFilters[0];this._firstTime=false;}}}if(B){if(s||n>0){var p=this.getBindingInfo("items").template.getBindingInfo("text").parts[0].path;if(p){var u=new F(p,sap.ui.model.FilterOperator.Contains,s);if(this.getEnableCaseInsensitiveSearch()&&i(B.getModel())){var E="'"+String(s).replace(/'/g,"''")+"'";E=E.toLowerCase();u=new F("tolower("+p+")",sap.ui.model.FilterOperator.Contains,E);}if(n>1){var g=new F([u,this._saveBindInfo],true);}else{if(this._saveBindInfo>""&&u.sPath!=this._saveBindInfo.sPath){var g=new F([u,this._saveBindInfo],true);}else{if(s==""){var g=[];}else{var g=new F([u],true);}}}B.filter(g,sap.ui.model.FilterType.Control);}}else{B.filter([],sap.ui.model.FilterType.Control);}}else{q.sap.log.warning("No filtering performed","The list must be defined with a binding for search to work",this);}}};d.prototype._getSearchValue=function(){return this._searchValue;};d.prototype._updateSelectAllCheckBox=function(){var i=this._getNonGroupItems(),I=i.length,o,A,s;function e(f){return f.getSelected();}if(this.getMultiSelect()){o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));A=I>0&&I===i.filter(e).length;s=this.getActive()&&A;o&&o.setSelected(s);}};d.prototype._addSelectedKey=function(k,t){if(!k&&!t){q.sap.log.error("Both sKey and sText are not defined. At least one must be defined.");return;}if(this.getMode()===b.SingleSelectMaster){this.removeSelectedKeys();}if(!k){k=t;}this._oSelectedKeys[k]=t||k;};d.prototype._removeSelectedKey=function(k,t){if(!k&&!t){q.sap.log.error("Both sKey and sText are not defined. At least one must be defined.");return false;}if(!k){k=t;}delete this._oSelectedKeys[k];return true;};d.prototype._setSearchValue=function(v){this._searchValue=v;};d.prototype._isItemSelected=function(i){return!!(this._oSelectedKeys[i&&(i.getKey()||i.getText())]);};d.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this);}};d.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(i){i.setSelected(this._isItemSelected(i));},this);this._updateFacetFilterButtonText();};d.prototype._handleSelectAllClick=function(s){var A;this._getNonGroupItems().forEach(function(i){if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}i.setSelected(s,true);},this);A=this._getOriginalActiveState()||s;this.setActive(A);q.sap.delayedCall(0,this,this._updateSelectAllCheckBox);};d.prototype.onItemTextChange=function(i,n){var k=i.getKey();if(this._oSelectedKeys[k]&&n&&!this._filtering){this._oSelectedKeys[k]=n;}};d.prototype.onItemSelectedChange=function(i,s){var A;if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}sap.m.ListBase.prototype.onItemSelectedChange.apply(this,arguments);A=this._getOriginalActiveState()||s||this.getSelectedItems().length>1;this.setActive(A);!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();q.sap.delayedCall(0,this,this._updateSelectAllCheckBox);};d.prototype.updateItems=function(r){this._filtering=r===C.Filter;sap.m.ListBase.prototype.updateItems.apply(this,arguments);this._filtering=false;if(!this.getGrowing()||r===C.Filter){this._selectItemsByKeys();}};d.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState;};d.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive();};return d;});
