/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./FormattedTextAnchorGenerator','./FormattedTextRenderer'],function(q,l,C,F,a){"use strict";var L=l.LinkConversion;var b=C.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:L.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}}});var _={ATTRIBS:{'style':1,'class':1,'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'abbr':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1}},c={ATTRIBS:{'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'em':1,'strong':1,'u':1}},d=_;b.prototype.init=function(){};function s(t,f){var w;var g,v,h=t==="a";var j=d.ELEMENTS[t].cssClass||"";for(var i=0;i<f.length;i+=2){g=f[i];v=f[i+1];if(!d.ATTRIBS[g]&&!d.ATTRIBS[t+"::"+g]){w='FormattedText: <'+t+'> with attribute ['+g+'="'+v+'"] is not allowed';q.sap.log.warning(w,this);f[i+1]=null;continue;}if(g=="href"){if(!q.sap.validateUrl(v)){q.sap.log.warning("FormattedText: incorrect href attribute:"+v,this);f[i+1]="#";h=false;}}if(g=="target"){h=false;}if(j&&g.toLowerCase()=="class"){f[i+1]=j+" "+v;j="";}}if(h){f.push("target");f.push("_blank");}if(j){f.push("class");f.push(j);}return f;}function p(t,f){if(d.ELEMENTS[t]){return s(t,f);}else{var w='<'+t+'> is not allowed';q.sap.log.warning(w,this);}}function e(t){return q.sap._sanitizeHTML(t,{tagPolicy:p,uriRewriter:function(u){if(q.sap.validateUrl(u)){return u;}}});}function o(E){var n=window.open();n.opener=null;n.location=E.currentTarget.href;E.preventDefault();}b.prototype.onAfterRendering=function(){this.$().find('a[target="_blank"]').on("click",o);};b.prototype._getDisplayHtml=function(){var t=this.getHtmlText(),A=this.getConvertLinksToAnchorTags();if(A===l.LinkConversion.None){return t;}t=F.generateAnchors(t,A,this.getConvertedLinksDefaultTarget());return e(t);};b.prototype.setHtmlText=function(t){return this.setProperty("htmlText",e(t));};b.prototype._setUseLimitedRenderingRules=function(f){d=f?c:_;};return b;});
