/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/library','sap/ui/Device','./InputBaseRenderer','jquery.sap.keycodes'],function(q,l,C,E,I,V,M,c,D,a){"use strict";var T=c.TextDirection;var b=c.TextAlign;var d=c.ValueState;var f=C.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:d.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:b.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/InputBase.designtime"}});E.call(f.prototype);I.insertFontFaceStyle();M.call(f.prototype);f.prototype.bShowLabelAsPlaceholder=!D.support.input.placeholder;f.prototype._getPlaceholder=function(){return this.getPlaceholder();};f.prototype._setLabelVisibility=function(){if(!this.bShowLabelAsPlaceholder){return;}var v=this.$("inner").val();this.$("placeholder").css("display",v?"none":"inline");};f.prototype._getInputValue=function(v){v=(v===undefined)?this.$("inner").val()||"":v.toString();if(this.getMaxLength&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}return v;};f.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName;}return this._sInputTagElementName;};f.prototype.init=function(){this._lastValue="";this.bRenderingPhase=false;this.bFocusoutDueRendering=false;this._bIgnoreNextInputEventNonASCII=false;this.bAfterRenderingWasCalled=false;this._oValueStateMessage=new V(this);};f.prototype.onBeforeRendering=function(){if(this._bCheckDomValue&&!this.bRenderingPhase){this._sDomValue=this._getInputValue();}this.bRenderingPhase=true;};f.prototype.onAfterRendering=function(){if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}this._bCheckDomValue=false;this._setLabelVisibility();this.bRenderingPhase=false;this.bAfterRenderingWasCalled=true;};f.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy();}this._oValueStateMessage=null;};f.prototype.ontouchstart=function(e){e.setMarked();};f.prototype.onfocusin=function(e){this._bIgnoreNextInput=!this.bShowLabelAsPlaceholder&&D.browser.msie&&D.browser.version>9&&!!this.getPlaceholder()&&!this._getInputValue()&&this._getInputElementTagName()==="INPUT";this.$().toggleClass("sapMFocus",true);if(this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};f.prototype.onfocusout=function(e){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};f.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e);}};f.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering;};f.prototype.getChangeEventParams=function(){return{};};f.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()&&this.bShowLabelAsPlaceholder&&e.target.id===this.getId()+"-placeholder"){this.focus();}};f.prototype.onChange=function(e,p,n){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(n);if(v!==this._lastValue){this.setValue(v);if(e){this._bIgnoreNextInputEventNonASCII=false;}v=this.getValue();this._lastValue=v;this.fireChangeEvent(v,p);return true;}else{this._bCheckDomValue=false;}};f.prototype.fireChangeEvent=function(v,p){var o=q.extend({value:v,newValue:v},p);this.fireChange(o);};f.prototype.onValueRevertedByEscape=function(v,p){this.fireEvent("liveChange",{value:v,escPressed:true,previousValue:p,newValue:v});};f.prototype.onsapenter=function(e){this.onChange(e);};f.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this._lastValue){e.setMarked();e.preventDefault();this.updateDomValue(this._lastValue);this.onValueRevertedByEscape(this._lastValue,v);}};f.prototype.oninput=function(e){if(this._bIgnoreNextInput&&this.bAfterRenderingWasCalled){this._bIgnoreNextInput=false;this.bAfterRenderingWasCalled=false;e.setMarked("invalid");return;}this.bAfterRenderingWasCalled=false;if(!this.getEditable()){e.setMarked("invalid");return;}if(this._bIgnoreNextInputEventNonASCII&&this.getValue()===this._lastValue){this._bIgnoreNextInputEventNonASCII=false;e.setMarked("invalid");return;}if(document.activeElement!==e.target&&D.browser.msie&&this.getValue()===this._lastValue){e.setMarked("invalid");return;}this._bCheckDomValue=true;this._setLabelVisibility();};f.prototype.onkeydown=function(e){if(this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==q.sap.KeyCodes.BACKSPACE){e.preventDefault();}};f.prototype.oncut=function(e){};f.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};f.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};f.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};f.prototype.getFocusInfo=function(){var F=C.prototype.getFocusInfo.call(this),o=this.getFocusDomRef();q.extend(F,{cursorPos:0,selectionStart:0,selectionEnd:0});if(o){F.cursorPos=q(o).cursorPos();try{F.selectionStart=o.selectionStart;F.selectionEnd=o.selectionEnd;}catch(e){}}return F;};f.prototype.applyFocusInfo=function(F){C.prototype.applyFocusInfo.call(this,F);this.$("inner").cursorPos(F.cursorPos);this.selectText(F.selectionStart,F.selectionEnd);return this;};f.prototype.bindToInputEvent=function(e){if(this._oInputEventDelegate){this.removeEventDelegate(this._oInputEventDelegate);}this._oInputEventDelegate={oninput:e};return this.addEventDelegate(this._oInputEventDelegate);};f.prototype.updateDomValue=function(v){if(!this.isActive()){return this;}v=this._getInputValue(v);if(D.browser.msie&&D.browser.version>9&&!/^[\x00-\x7F]*$/.test(v)){this._bIgnoreNextInput=true;}if(this._getInputValue()!==v){this.$("inner").val(v);this._bCheckDomValue=true;}this._setLabelVisibility();return this;};f.prototype.closeValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.close();}};f.prototype.getDomRefForValueStateMessage=function(){return this.getFocusDomRef();};f.prototype.iOpenMessagePopupDuration=0;f.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};f.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(s){return sap.ui.getCore().byId(s);});var o=sap.ui.require("sap/ui/core/LabelEnablement");if(o){L=L.concat(o.getReferencingLabels(this).map(function(s){return sap.ui.getCore().byId(s);}));}return L;};f.prototype.openValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.open();}};f.prototype.updateValueStateClasses=function(v,o){var t=this.$(),i=this.$("inner"),m=d;if(o!==m.None){t.removeClass("sapMInputBaseState sapMInputBase"+o);i.removeClass("sapMInputBaseStateInner sapMInputBase"+o+"Inner");}if(v!==m.None){t.addClass("sapMInputBaseState sapMInputBase"+v);i.addClass("sapMInputBaseStateInner sapMInputBase"+v+"Inner");}};f.prototype.shouldValueStateMessageBeOpened=function(){return(this.getValueState()!==d.None)&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage();};f.prototype.setValueState=function(v){var o=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(v===o){return this;}var e=this.getDomRef();if(!e){return this;}var i=this.$("inner"),m=d;if(v===m.Error){i.attr("aria-invalid","true");}else{i.removeAttr("aria-invalid");}this.updateValueStateClasses(v,o);if(i[0]===document.activeElement){if(v===m.None){this.closeValueStateMessage();}else if(this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}}return this;};f.prototype.setValueStateText=function(t){this.setProperty("valueStateText",t,true);this.$("message").text(this.getValueStateText());return this;};f.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(D.browser.msie&&D.browser.version>9&&!/^[\x00-\x7F]*$/.test(v)){this._bIgnoreNextInputEventNonASCII=true;}if(v!==this.getProperty("value")){this._lastValue=v;}this.setProperty("value",v,true);return this;};f.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};f.prototype.getIdForLabel=function(){return this.getId()+"-inner";};f.prototype.setTooltip=function(t){var o=this.getDomRef();this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!o){return this;}var s=this.getTooltip_AsString();if(s){o.setAttribute("title",s);}else{o.removeAttribute("title");}if(sap.ui.getCore().getConfiguration().getAccessibility()){var e=this.getDomRef("describedby"),A=this.getRenderer().getDescribedByAnnouncement(this),g=this.getId()+"-describedby",h="aria-describedby",F=this.getFocusDomRef(),i=F.getAttribute(h);if(!e&&A){e=document.createElement("span");e.id=g;e.setAttribute("aria-hidden","true");e.className="sapUiInvisibleText";if(this.getAriaDescribedBy){F.setAttribute(h,(this.getAriaDescribedBy().join(" ")+" "+g).trim());}else{F.setAttribute(h,g);}o.appendChild(e);}else if(e&&!A){o.removeChild(e);var j=e.id;if(i&&j){F.setAttribute(h,i.replace(j,"").trim());}}if(e){e.textContent=A;}}return this;};f.prototype.getAccessibilityInfo=function(){var r=this.getRequired()?'Required':'',R=this.getRenderer();return{role:R.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValue()||"",R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this),r].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};Object.defineProperty(f.prototype,"_$input",{get:function(){return this.$("inner");}});return f;});
