/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/core/EnabledPropagator','sap/ui/core/library','sap/ui/Device','./LinkRenderer'],function(q,l,C,I,E,c,D,L){"use strict";var T=c.TextDirection;var a=c.TextAlign;var b=C.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Link.designtime",properties:{text:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},validateUrl:{type:"boolean",group:"Data",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:a.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true}}}});E.call(b.prototype);b.prototype.onBeforeRendering=function(){};b.prototype.onsapspace=function(e){if(this.getEnabled()||this.getHref()){e.setMarked();e.preventDefault();}};b.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE){this._handlePress(e);if(this.getHref()&&!e.isDefaultPrevented()){e.preventDefault();e.setMarked();var o=document.createEvent('MouseEvents');o.initEvent('click',false,true);this.getDomRef().dispatchEvent(o);}}};b.prototype._handlePress=function(e){if(this.getEnabled()){e.setMarked();if(!this.firePress()||!this.getHref()){e.preventDefault();}}else{e.preventDefault();}};b.prototype.onsapenter=b.prototype._handlePress;if(D.support.touch){b.prototype.ontap=b.prototype._handlePress;}else{b.prototype.onclick=b.prototype._handlePress;}b.prototype.ontouchstart=function(e){if(this.getEnabled()){e.setMarked();}};b.prototype.setText=function(t){var $=this.$();this.setProperty("text",t,true);t=this.getProperty("text");if(this.writeText){this.writeText(t);}else{$.text(t);}if(t){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}return this;};b.prototype.setHref=function(u){var i=this._isHrefValid(u);this.setProperty("href",u,true);if(!i){this.$().removeAttr("href");q.sap.log.warning(this+": The href tag of the link was not set since it's not valid.");return this;}if(this.getEnabled()){u=this.getProperty("href");if(!u){this.$().removeAttr("href");}else{this.$().attr("href",u);}}return this;};b.prototype.setSubtle=function(s){this.setProperty("subtle",s,true);var $=this.$();if($.length){$.toggleClass("sapMLnkSubtle",s);if(s){b._addToDescribedBy($,this._sAriaLinkSubtleId);}else{b._removeFromDescribedBy($,this._sAriaLinkSubtleId);}}if(s&&!b.prototype._sAriaLinkSubtleId){b.prototype._sAriaLinkSubtleId=I.getStaticId("sap.m","LINK_SUBTLE");}return this;};b.prototype.setEmphasized=function(e){this.setProperty("emphasized",e,true);var $=this.$();if($.length){$.toggleClass("sapMLnkEmphasized",e);if(e){b._addToDescribedBy($,this._sAriaLinkEmphasizedId);}else{b._removeFromDescribedBy($,this._sAriaLinkEmphasizedId);}}if(e&&!b.prototype._sAriaLinkEmphasizedId){b.prototype._sAriaLinkEmphasizedId=I.getStaticId("sap.m","LINK_EMPHASIZED");}return this;};b.prototype.setWrapping=function(w){this.setProperty("wrapping",w,true);this.$().toggleClass("sapMLnkWrapping",w);return this;};b.prototype.setEnabled=function(e){e=this.validateProperty("enabled",e);if(e!==this.getProperty("enabled")){this.setProperty("enabled",e,true);var $=this.$();$.toggleClass("sapMLnkDsbl",!e);if(e){$.attr("disabled",false);if(this.getText()){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}$.removeAttr("aria-disabled");if(this.getHref()){$.attr("href",this.getHref());}}else{$.attr("disabled",true);$.attr("tabindex","-1");$.attr("aria-disabled",true);$.removeAttr("href");}}return this;};b.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().toggleClass("sapMLnkMaxWidth",!w);this.$().css("width",w);return this;};b.prototype.setTarget=function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;};b.prototype._isHrefValid=function(u){return this.getValidateUrl()?q.sap.validateUrl(u):true;};b._addToDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A){$.attr("aria-describedby",A+" "+i);}else{$.attr("aria-describedby",i);}};b._removeFromDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A&&A.indexOf(i)!==-1){A=A.replace(i,'');if(A.length>1){$.attr("aria-describedby",A);}else{$.removeAttr("aria-describedby");}}};b.prototype.getAccessibilityInfo=function(){return{role:"link",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LINK"),description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()};};b.prototype.getFormDoNotAdjustWidth=function(){return true;};return b;});
