/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Icon','sap/m/Button','sap/ui/model/BindingMode','sap/ui/Device','sap/m/CheckBox','./ListItemBaseRenderer','jquery.sap.keycodes'],function(q,l,C,I,a,B,b,D,c,L){"use strict";var d=l.ListKeyboardMode;var e=l.ListMode;var f=l.ListType;var g=l.ButtonType;var h=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:f.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:"None"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designtime:"sap/m/designtime/ListItemBase.designtime"}});h.getAccessibilityText=function(o,i){if(!o||!o.getVisible||!o.getVisible()){return"";}var A;if(o.getAccessibilityInfo){A=o.getAccessibilityInfo();}if(!A||!o.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(o.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var j=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" "+A.description+" ",T=o.getTooltip_AsString();if(A.enabled===false){t+=j.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=j.getText("CONTROL_READONLY")+" ";}if(!A.type&&T&&t.indexOf(T)==-1){t=T+" "+t;}A.children.forEach(function(k){t+=h.getAccessibilityText(k)+" ";});t=t.trim();if(i&&!t){t=j.getText("CONTROL_EMPTY");}return t;};h.getDefaultAccessibilityInfo=function(o){if(!o){return null;}var N=window.Node,i=window.NodeFilter,t=document.createTreeWalker(o,i.SHOW_TEXT+i.SHOW_ELEMENT,function(n){if(n.type===N.ELEMENT_NODE){if(n.classList.contains("sapUiInvisibleText")){return i.FILTER_SKIP;}if(n.getAttribute("aria-hidden")=="true"||n.style.visibility=="hidden"||n.style.display=="none"){return i.FILTER_REJECT;}return i.FILTER_SKIP;}return i.FILTER_ACCEPT;},false);var T=[];while(t.nextNode()){var n=t.currentNode;if(n.nodeType===N.TEXT_NODE){var s=(n.nodeValue||"").trim();if(s){T.push(s);}}}return{description:T.join(" ")};};h.prototype.DetailIconURI=I.getIconURI("edit");h.prototype.DeleteIconURI=I.getIconURI("sys-cancel");h.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");h.prototype.TagName="li";h.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;};h.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();};h.prototype.getBindingContextPath=function(m){var o=this.getList();if(o&&!m){m=(o.getBindingInfo("items")||{}).model;}var i=this.getBindingContext(m);if(i){return i.getPath();}};h.prototype.isSelectedBoundTwoWay=function(){var o=this.getBinding("selected");if(o&&o.getBindingMode()==b.TwoWay){return true;}};h.prototype.getList=function(){var p=this.getParent();if(p instanceof sap.m.ListBase){return p;}};h.prototype.getListProperty=function(p,F){var o=this.getList();if(o){p=q.sap.charToUpperCase(p);return o["get"+p]();}return F;};h.prototype.informList=function(E,p,P){var o=this.getList();if(o){var m="onItem"+E;if(o[m]){o[m](this,p,P);}}};h.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};h.prototype.getAccessibilityType=function(o){return o.getText("ACC_CTR_TYPE_OPTION");};h.prototype.getGroupAnnouncement=function(){return this.$().prevAll(".sapMGHLI:first").text();};h.prototype.getAccessibilityDescription=function(o){var O=[],t=f,T=this.getType(),H=this.getHighlight(),s=this.getTooltip_AsString();if(this.getSelected()){O.push(o.getText("LIST_ITEM_SELECTED"));}if(H!="None"){O.push(o.getText("LIST_ITEM_STATE_"+H.toUpperCase()));}if(this.getUnread()&&this.getListProperty("showUnread")){O.push(o.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){O.push(o.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(T==t.Navigation){O.push(o.getText("LIST_ITEM_NAVIGATION"));}else{if(T==t.Detail||T==t.DetailAndActive){O.push(o.getText("LIST_ITEM_DETAIL"));}if(T==t.Active||T==t.DetailAndActive){O.push(o.getText("LIST_ITEM_ACTIVE"));}}O.push(this.getGroupAnnouncement()||"");if(this.getContentAnnouncement){O.push((this.getContentAnnouncement(o)||"").trim());}if(s){O.push(s);}return O.join(" ");};h.prototype.getAccessibilityInfo=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(o),description:this.getAccessibilityDescription(o),focusable:true};};h.prototype.getMode=function(){return this.getListProperty("mode","");};h.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var i=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":i.length,"aria-posinset":i.index(t)+1},A));};h.prototype.getDeleteControl=function(){if(this._oDeleteControl){return this._oDeleteControl;}this._oDeleteControl=new B({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:g.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(E){this.informList("Delete");},this);this._oDeleteControl._bExcludeFromTabChain=true;return this._oDeleteControl;};h.prototype.getDetailControl=function(){if(this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new B({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:g.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this);this._oDetailControl._bExcludeFromTabChain=true;return this._oDetailControl;};h.prototype.getNavigationControl=function(){if(this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new a({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};h.prototype.getSingleSelectControl=function(){if(this._oSingleSelectControl){return this._oSingleSelectControl;}this._oSingleSelectControl=new sap.m.RadioButton({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oSingleSelectControl;};h.prototype.getMultiSelectControl=function(){if(this._oMultiSelectControl){return this._oMultiSelectControl;}this._oMultiSelectControl=new c({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oMultiSelectControl;};h.prototype.getModeControl=function(u){var m=this.getMode(),i=e;if(!m||m==i.None){return;}if(m==i.Delete){return this.getDeleteControl();}var s=null;if(m==i.MultiSelect){s=this.getMultiSelectControl();}else{s=this.getSingleSelectControl();}if(s&&u){s.setSelected(this.getSelected());}return s;};h.prototype.getTypeControl=function(){var t=this.getType(),T=f;if(t==T.Detail||t==T.DetailAndActive){return this.getDetailControl();}if(t==T.Navigation){return this.getNavigationControl();}};h.prototype.destroyControls=function(i){i.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};h.prototype.isActionable=function(){return this.getListProperty("includeItemInSelection")||this.getMode()==e.SingleSelectMaster||(this.getType()!=f.Inactive&&this.getType()!=f.Detail);};h.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};h.prototype.isSelectable=function(){var m=this.getMode();return!(m==e.None||m==e.Delete);};h.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};h.prototype.isSelected=h.prototype.getSelected;h.prototype.setSelected=function(s,i){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!i){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};h.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};h.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};h.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};h.prototype.isGroupHeader=function(){return this._bGroupHeader;};h.prototype.isIncludedIntoSelection=function(){var m=this.getMode(),M=e;return(m==M.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(m==M.SingleSelectLeft||m==M.SingleSelect||m==M.MultiSelect)));};h.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!="None");}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};h.prototype.hasActiveType=function(){var t=f,T=this.getType();return(T==t.Active||T==t.Navigation||T==t.DetailAndActive);};h.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==f.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};h.prototype.ontap=function(E){if(this._eventHandledByControl){return E.setMarked();}var t=window.getSelection().toString().replace("\n","");if(t){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==e.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(D.os.ios){this.focus();}q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}this.informList("Press",E.srcControl);};h.prototype.ontouchstart=function(E){this._eventHandledByControl=E.isMarked();var t=E.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||E.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=q.sap.delayedCall(100,this,function(){this.setActive(true);});};h.prototype.ontouchmove=function(E){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-E.targetTouches[0].clientY)>10||Math.abs(this._touchedX-E.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};h.prototype.ontouchend=function(E){if(E.targetTouches.length==0&&this.hasActiveType()){this._timeoutIdEnd=q.sap.delayedCall(100,this,function(){this.setActive(false);});}};h.prototype.ontouchcancel=h.prototype.ontouchend;h.prototype._activeHandlingNav=function(){};h.prototype._activeHandlingInheritor=function(){};h.prototype._inactiveHandlingInheritor=function(){};h.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(D.system.Desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};h.prototype.onsapspace=function(E){if(E.srcControl!==this){return;}E.preventDefault();if(E.isMarked()||!this.isSelectable()){return;}if(this.getMode()==e.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}E.setMarked();};h.prototype.onsapenter=function(E){var o=this.getList();if(E.isMarked()||!o){return;}var k=d;if(E.srcControl!==this&&o.getKeyboardMode()==k.Edit){o.setKeyboardMode(k.Navigation);this._switchFocus(E);return;}if(E.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(E);}else if(this.hasActiveType()){E.setMarked();this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}o.onItemPress(this,E.srcControl);};h.prototype.onsapdelete=function(E){if(E.isMarked()||E.srcControl!==this||this.getMode()!=e.Delete){return;}this.informList("Delete");E.preventDefault();E.setMarked();};h.prototype._switchFocus=function(E){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(E.srcControl!==this){o._iLastFocusPosOfItem=t.index(E.target);this.focus();}else if(t.length){var F=o._iLastFocusPosOfItem||0;F=t[F]?F:-1;t.eq(F).focus();}E.preventDefault();E.setMarked();};h.prototype.onkeydown=function(E){if(E.isMarked()){return;}var k=q.sap.KeyCodes;if(E.which==k.F7){this._switchFocus(E);return;}if(E.which==k.F2){if(E.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();E.preventDefault();E.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);var K=d;o.setKeyboardMode(o.getKeyboardMode()==K.Edit?K.Navigation:K.Edit);this._switchFocus(E);}}}};h.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};h.prototype.onsaptabnext=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==d.Edit){return;}var i=this.getTabbables().get(-1)||this.getDomRef();if(E.target===i){o.forwardTab(true);E.setMarked();}};h.prototype.onsaptabprevious=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==d.Edit){return;}if(E.target===this.getDomRef()){o.forwardTab(false);E.setMarked();}};h.prototype.onfocusin=function(E){var o=this.getList();if(!o||E.isMarked()){return;}if(E.srcControl===this){o.onItemFocusIn(this);return;}if(o.getKeyboardMode()==d.Edit||!q(E.target).is(":sapFocusable")){return;}q.sap.delayedCall(0,o,"setItemFocusable",[this]);E.setMarked();};h.prototype.onsapup=function(E){if(E.isMarked()||E.srcControl===this||this.getListProperty("keyboardMode")===d.Navigation){return;}this.informList("ArrowUpDown",E);};h.prototype.oncontextmenu=function(E){if(this._bGroupHeader){return;}if(q(document.activeElement).is(":focusable")&&document.activeElement!==this.getDomRef()&&E.srcControl!==this.getModeControl()){return;}this.informList("ContextMenu",E);};h.prototype.onsapdown=h.prototype.onsapup;return h;});
