/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./Button','./SplitButton','sap/ui/Device','sap/ui/core/EnabledPropagator','sap/ui/core/library',"./MenuButtonRenderer"],function(q,l,C,B,S,D,E,c,M){"use strict";var a=l.MenuButtonMode;var T=c.TextDirection;var b=l.ButtonType;var d=C.extend("sap.m.MenuButton",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:b.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:a.Regular},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{defaultAction:{}},defaultAggregation:"menu",designtime:"sap/m/designtime/MenuButton.designtime"}});E.call(d.prototype);d.prototype.init=function(){this._initButtonControl();};d.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null;}if(this._sDefaultIcon){this._sDefaultIcon=null;}if(this._iInitialWidth){this._iInitialWidth=null;}if(this._lastActionItemId){this._lastActionItemId=null;}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this);}};d.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText();}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon();}this._updateButtonControl();this._attachMenuEvents();};d.prototype.onAfterRendering=function(){q.sap.delayedCall(0,this,"_setInitialBtnWidth");this._setAriaHasPopup();};d.prototype._setInitialBtnWidth=function(){var i;if(this._isSplitButton()&&!this._iInitialWidth){i=this.$().outerWidth();if(i){this._iInitialWidth=i+1;}}};d.prototype._setAriaHasPopup=function(){if(this._isSplitButton()){this._getButtonControl()._getArrowButton().$().attr("aria-haspopup","true");}else{this._getButtonControl().$().attr("aria-haspopup","true");}};d.prototype.setButtonMode=function(m){var t=this.getTooltip();C.prototype.setProperty.call(this,"buttonMode",m,true);this._getButtonControl().destroy();this._initButtonControl();for(var k in this.mProperties){if(this.mProperties.hasOwnProperty(k)&&k!=="buttonMode"&&k!=="useDefaultActionOnly"&&k!=="width"){this._getButtonControl().setProperty(k,this.mProperties[k],true);}}if(t){this._getButtonControl().setTooltip(t);}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText());}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon());}this.invalidate();return this;};d.prototype._initButton=function(){var o=new B({width:"100%"});o.attachPress(this._handleButtonPress,this);return o;};d.prototype._initSplitButton=function(){var o=new S({width:"100%"});o.attachPress(this._handleActionPress,this);o.attachArrowPress(this._handleButtonPress,this);return o;};d.prototype._initButtonControl=function(){var o;if(this._isSplitButton()){o=this._initSplitButton();}else{o=this._initButton();}this.setAggregation("_button",o,true);};d.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText());};d.prototype._getButtonControl=function(){return this.getAggregation("_button");};d.prototype._handleButtonPress=function(w){var m=this.getMenu();if(!m){return;}if(!m.getTitle()){m.setTitle(this.getText());}m.openBy(this,w);this._writeAriaAttributes();if(this._isSplitButton()&&!D.system.phone){this._getButtonControl().setArrowState(true);}};d.prototype._handleActionPress=function(){var L=this._getLastSelectedItem(),o;if(!this.getUseDefaultActionOnly()&&L){o=sap.ui.getCore().byId(L);this.getMenu().fireItemSelected({item:o});}else{this.fireDefaultAction();}};d.prototype._menuClosed=function(){if(this._isSplitButton()){this._getButtonControl().setArrowState(false);}};d.prototype._menuItemSelected=function(e){var m=e.getParameter("item");this.fireEvent("_menuItemSelected",{item:m});if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!m){return;}this._lastActionItemId=m.getId();!!this._sDefaultText&&this.setText(m.getText());!!this._sDefaultIcon&&this.setIcon(m.getIcon());};d.prototype._getLastSelectedItem=function(){return this._lastActionItemId;};d.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this);}};d.prototype._isSplitButton=function(){return this.getButtonMode()===a.Split;};d.prototype.setProperty=function(p,v,s){function i(t){var e=[b.Up,b.Back,b.Unstyled];return e.indexOf(t)!==-1;}if(p==="type"&&i(v)){return this;}if(p==='text'){this._sDefaultText=v;}switch(p){case'activeIcon':case'iconDensityAware':case'textDirection':this._getButtonControl().setProperty(p,v);break;}return C.prototype.setProperty.apply(this,arguments);};d.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return C.prototype.setTooltip.apply(this,arguments);};d.prototype.setText=function(v){B.prototype.setProperty.call(this,'text',v);this._getButtonControl().setText(v);return this;};d.prototype.setType=function(v){B.prototype.setProperty.call(this,'type',v);this._getButtonControl().setType(v);return this;};d.prototype.setIcon=function(v){B.prototype.setProperty.call(this,'icon',v);this._getButtonControl().setIcon(v);return this;};d.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef();};d.prototype.onsapup=function(e){this.openMenuByKeyboard();};d.prototype.onsapdown=function(e){this.openMenuByKeyboard();};d.prototype.onsapupmodifiers=function(e){this.openMenuByKeyboard();};d.prototype.onsapdownmodifiers=function(e){this.openMenuByKeyboard();};d.prototype.onsapshow=function(e){this.openMenuByKeyboard();!!e&&e.preventDefault();};d.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(true);}};d.prototype._writeAriaAttributes=function(){if(this.getMenu()){this.$().attr("aria-controls",this.getMenu().getDomRefId());}};return d;});
