/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ColumnListItem','./P13nPanel','./SearchField','./Table','./library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/m/ScrollContainer','./P13nSelectionItem'],function(q,C,P,S,T,l,a,J,B,R,b){"use strict";var c=l.ToolbarDesign;var L=l.ListType;var d=l.ListMode;var e=l.P13nPanelType;var f=P.extend("sap.m.P13nSelectionPanel",{metadata:{library:"sap.m",aggregations:{selectionItems:{type:"sap.m.P13nSelectionItem",multiple:true,singularName:"selectionItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{changeSelectionItems:{parameters:{items:{type:"object[]"}}}}},renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var g=o.getAggregation("content");if(g){g.forEach(function(h){r.renderControl(h);});}r.write("</div>");}});f.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var m=new J({linkPressMap:{},items:[],countOfSelectedItems:0,countOfItems:0});m.setDefaultBindingMode(B.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nSelectionPanel");this.setType(e.selection);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new b({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);var t=this;this._fnHandleResize=function(){var g=false,i,h;if(t.getParent){var $=null,j,H;var p=t.getParent();var o=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&o.$().length>0){i=s.$()[0].clientHeight;j=$.children()[0].clientHeight;H=o?o.$()[0].clientHeight:0;h=j-H;if(i!==h){s.setHeight(h+'px');g=true;}}}}return g;};this._sContainerResizeListener=R.register(s,this._fnHandleResize);};f.prototype.onBeforeRendering=function(){this._updateInternalModel();};f.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};f.prototype.getOkPayload=function(){this._updateInternalModel();var m=this._getInternalModel().getProperty("/items");return{selectionItems:m.map(function(M){return{columnKey:M.columnKey,selected:M.persistentSelected};})};};f.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};f.prototype.addItem=function(i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",i);return this;};f.prototype.insertItem=function(i,I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",i,I);return this;};f.prototype.removeItem=function(i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}i=this.removeAggregation("items",i);return i;};f.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};f.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};f.prototype.addSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("selectionItems",s);return this;};f.prototype.insertSelectionItem=function(s,i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("selectionItems",s,i);return this;};f.prototype.updateSelectionItems=function(r){this.updateAggregation("selectionItems");if(r===a.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};f.prototype.removeSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("selectionItems",s);};f.prototype.removeAllSelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("selectionItems");};f.prototype.destroySelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("selectionItems");return this;};f.prototype.onBeforeNavigationFrom=function(){return true;};f.prototype._notifyChange=function(){var g=this.getChangeNotifier();if(g){g(this);}};f.prototype._getInternalModel=function(){return this.getModel("$sapmP13nSelectionPanel");};f.prototype._createTable=function(){var t=this;this._oTable=new T({mode:d.MultiSelect,rememberSelections:false,selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,g){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,g]);}}})})],items:{path:"/items",templateShareable:false,template:new C({cells:[new sap.m.Link({href:"{href}",text:"{text}",target:"{target}",enabled:{path:'href',formatter:function(v){if(!v){this.addStyleClass("sapUiCompSmartLink");}return!!v;}},press:function(E){var o=t._getInternalModel().getProperty("/linkPressMap")[this.getText()+"---"+this.getHref()];if(o){o(E);}}})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};f.prototype._createToolbar=function(){var t=this;var o=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{design:c.Auto,content:[new sap.m.ToolbarSpacer(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})})]});o.setModel(this._getInternalModel());this.addAggregation("content",o);};f.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};f.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var m=this._getInternalModel().getProperty("/items");m.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});this._getInternalModel().setProperty("/items",m);};f.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return!!m.visible;});};f.prototype._getModelItemByColumnKey=function(s){var m=this._getInternalModel().getProperty("/items").filter(function(M){return M.columnKey===s;});return m[0];};f.prototype._updateCounts=function(m){var i=0;var g=0;m.forEach(function(M){i++;if(M.persistentSelected){g++;}});this._getInternalModel().setProperty("/countOfItems",i);this._getInternalModel().setProperty("/countOfSelectedItems",g);};f.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};f.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};f.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};f.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};f.prototype._isFilteredByShowSelected=function(){return false;};f.prototype._updateControlLogic=function(){var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}};f.prototype._fireChangeSelectionItems=function(){this._bIgnoreUpdateInternalModel=true;var m=this._getInternalModel().getProperty("/items");this.fireChangeSelectionItems({items:m.map(function(M){return{columnKey:M.columnKey,selected:M.persistentSelected};})});this._bIgnoreUpdateInternalModel=false;};f.prototype._onSelectionChange=function(){this._selectTableItem();};f.prototype._selectTableItem=function(){var m=this._getInternalModel().getProperty("/items");this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._fireChangeSelectionItems();this._notifyChange();};f.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');this._getVisibleModelItems().forEach(function(m){m.visible=false;if(m.text&&m.text.match(r)){m.visible=true;}if(m.tooltip&&m.tooltip.match(r)){m.visible=true;}});this._getInternalModel().refresh();};f.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._getInternalModel().setProperty("/items",this.getItems().map(function(i){return{columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),href:i.getHref(),target:i.getTarget(),persistentSelected:i.getVisible()};},this));this.getSelectionItems().forEach(function(s){var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}if(s.getSelected()!==undefined){M.persistentSelected=s.getSelected();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var m=this._getInternalModel().getProperty("/items");this._updateCounts(m);this._getInternalModel().setProperty("/items",m);};return f;});
