/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/delegate/ScrollEnablement","sap/m/Title","sap/m/Button","sap/m/Bar","sap/ui/core/ContextMenuSupport","sap/ui/core/library","sap/ui/Device","sap/ui/core/Element","./PageRenderer"],function(q,l,C,S,T,B,a,b,c,D,E,P){"use strict";var A=c.AccessibleLandmarkRole;var d=l.ButtonType;var e=l.PageBackgroundDesign;var f=c.TitleLevel;var g="div";var H="header";var F="footer";var h=C.extend("sap.m.Page",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:f.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},navButtonText:{type:"string",group:"Misc",defaultValue:null,deprecated:true},navButtonTooltip:{type:"string",group:"Misc",defaultValue:null},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:e.Standard},navButtonType:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:d.Back,deprecated:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},contentOnlyBusy:{type:"boolean",group:"Appearance",defaultValue:false},floatingFooter:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.m.IBar",multiple:false},footer:{type:"sap.m.IBar",multiple:false},subHeader:{type:"sap.m.IBar",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent",forwarding:{getter:"_getInternalHeader",aggregation:"contentRight"}},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false},_internalHeader:{type:"sap.m.IBar",multiple:false,visibility:"hidden"}},events:{navButtonTap:{deprecated:true},navButtonPress:{}},designtime:"sap/m/designtime/Page.designtime"}});b.apply(h.prototype);h.FOOTER_ANIMATION_DURATION=350;h.prototype._hasScrolling=function(){return this.getEnableScrolling();};h.prototype.onBeforeRendering=function(){if(this._oScroller&&!this._hasScrolling()){this._oScroller.destroy();this._oScroller=null;}else if(this._hasScrolling()&&!this._oScroller){this._oScroller=new S(this,null,{scrollContainerId:this.getId()+"-cont",horizontal:false,vertical:true});}if(this._headerTitle){this._headerTitle.setLevel(this.getTitleLevel());}};h.prototype.onAfterRendering=function(){q.sap.delayedCall(10,this,this._adjustFooterWidth);};h.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._navBtn){this._navBtn.destroy();this._navBtn=null;}if(this._appIcon){this._appIcon.destroy();this._appIcon=null;}};h.prototype.setBackgroundDesign=function(s){var i=this.getBackgroundDesign();this.setProperty("backgroundDesign",s,true);this.$().removeClass("sapMPageBg"+i).addClass("sapMPageBg"+this.getBackgroundDesign());return this;};h.prototype.setTitle=function(t){var w=!this._headerTitle;this._headerTitle=this._headerTitle||new T(this.getId()+"-title",{level:this.getTitleLevel()});this._headerTitle.setText(t);if(w){this._updateHeaderContent(this._headerTitle,"middle",0);}this.setProperty("title",t,true);return this;};h.prototype._ensureNavButton=function(){var s=this.getNavButtonTooltip()||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PAGE_NAVBUTTON_TEXT");if(!this._navBtn){var n=this.getNavButtonType();this._navBtn=new B(this.getId()+"-navButton",{press:q.proxy(function(){this.fireNavButtonPress();this.fireNavButtonTap();},this)});if(D.os.android&&n==d.Back){this._navBtn.setType(d.Up);}else{this._navBtn.setType(n);}}this._navBtn.setTooltip(s);};h.prototype.setShowNavButton=function(s){var o=!!this.getShowNavButton();if(s===o){return this;}this.setProperty("showNavButton",s,true);if(s){this._ensureNavButton();if(this._appIcon){this._updateHeaderContent(this._appIcon,"left",-1);}this._updateHeaderContent(this._navBtn,"left",0);}else if(this._navBtn){this._updateHeaderContent(this._navBtn,"left",-1);}return this;};h.prototype.setShowFooter=function(s){if(this.getDomRef()){(s)?this.$().addClass("sapMPageWithFooter"):this.$().removeClass("sapMPageWithFooter");}var $=q(this.getDomRef()).find(".sapMPageFooter").last(),u=sap.ui.getCore().getConfiguration().getAnimation();if(!this.getFloatingFooter()){this.setProperty("showFooter",s);return this;}this.setProperty("showFooter",s,true);$.removeClass("sapUiHidden");$.toggleClass("sapMPageFooterControlShow",s);$.toggleClass("sapMPageFooterControlHide",!s);if(s){return this;}if(u){q.sap.delayedCall(h.FOOTER_ANIMATION_DURATION,this,function(){$.toggleClass("sapUiHidden",!s);});}else{$.toggleClass("sapUiHidden",!s);}return this;};h.prototype.setNavButtonType=function(n){this._ensureNavButton();if(!D.os.ios&&n==d.Back){this._navBtn.setType(d.Up);}else{this._navBtn.setType(n);}this.setProperty("navButtonType",n,true);return this;};h.prototype.setNavButtonText=function(t){this._ensureNavButton();this.setProperty("navButtonText",t,true);return this;};h.prototype.setNavButtonTooltip=function(t){this.setProperty("navButtonTooltip",t,true);this._ensureNavButton();return this;};h.prototype.setIcon=function(i){var o=this.getIcon();if(o===i){return this;}this.setProperty("icon",i,true);return this;};h.prototype._adjustFooterWidth=function(){if(!this.getShowFooter()||!this.getFloatingFooter()||!this.getFooter()){return;}var $=q(this.getDomRef()).find(".sapMPageFooter").last();if(this._contentHasScroll()){$.css("right",q.position.scrollbarWidth()+"px");$.css("width","initial");}else{$.css("right",0);$.css("width","");}};h.prototype._contentHasScroll=function(){var $=q.sap.byId(this.getId()+"-cont",this.getDomRef());return $[0].scrollHeight>$.innerHeight();};h.prototype._updateHeaderContent=function(o,s,i){var I=this._getInternalHeader();if(I){switch(s){case"left":if(i==-1){if(I.getContentLeft()){I.removeContentLeft(o);}}else{if(I.indexOfContentLeft(o)!=i){I.insertContentLeft(o,i);I.invalidate();}}break;case"middle":if(i==-1){if(I.getContentMiddle()){I.removeContentMiddle(o);}}else{if(I.indexOfContentMiddle(o)!=i){I.insertContentMiddle(o,i);I.invalidate();}}break;case"right":if(i==-1){if(I.getContentRight()){I.removeContentRight(o);}}else{if(I.indexOfContentRight(o)!=i){I.insertContentRight(o,i);I.invalidate();}}break;default:break;}}};h.prototype._getInternalHeader=function(){var i=this.getAggregation("_internalHeader");if(!i){this.setAggregation("_internalHeader",new a(this.getId()+"-intHeader"),true);i=this.getAggregation("_internalHeader");if(this.getShowNavButton()&&this._navBtn){this._updateHeaderContent(this._navBtn,"left",0);}if(this.getTitle()&&this._headerTitle){this._updateHeaderContent(this._headerTitle,"middle",0);}}return i;};h.prototype._getAnyHeader=function(){var o=this.getCustomHeader();if(o){return o.addStyleClass("sapMPageHeader");}return this._getInternalHeader().addStyleClass("sapMPageHeader");};h.prototype.getScrollDelegate=function(){return this._oScroller;};h.prototype._formatLandmarkInfo=function(L,p){if(L){var r=L["get"+p+"Role"]()||"",s=L["get"+p+"Label"]()||"";if(r===A.None){r='';}return{role:r.toLowerCase(),label:s};}return{};};h.prototype._getHeaderTag=function(L){if(L&&L.getHeaderRole()!==A.None){return g;}return H;};h.prototype._getSubHeaderTag=function(L){if(L&&L.getSubHeaderRole()!==A.None){return g;}return H;};h.prototype._getFooterTag=function(L){if(L&&L.getFooterRole()!==A.None){return g;}return F;};h.prototype.scrollTo=function(y,t){if(this._oScroller){this._oScroller.scrollTo(0,y,t);}return this;};h.prototype.scrollToElement=function(o,t){if(o instanceof E){o=o.getDomRef();}if(this._oScroller){this._oScroller.scrollToElement(o,t);}return this;};h.prototype.setContentOnlyBusy=function(i){this.setProperty("contentOnlyBusy",i,true);this.$().toggleClass("sapMPageBusyCoversAll",!i);return this;};h.prototype.setCustomHeader=function(o){this.setAggregation("customHeader",o);if(o&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":o});}return this;};h.prototype._getAdaptableContent=function(){return this._getAnyHeader();};return h;});
