/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','./RadioButtonGroup','sap/ui/core/library','./RadioButtonRenderer'],function(l,C,E,R,c,a){"use strict";var T=c.TextAlign;var V=c.ValueState;var b=c.TextDirection;var d=C.extend("sap.m.RadioButton",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},selected:{type:"boolean",group:"Data",defaultValue:false},groupName:{type:"string",group:"Behavior",defaultValue:'sapMRbDefaultGroup'},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},useEntireWidth:{type:"boolean",group:"Appearance",defaultValue:false},activeHandling:{type:"boolean",group:"Appearance",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin}},events:{select:{parameters:{selected:{type:"boolean"}}}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/RadioButton.designtime"}});E.call(d.prototype);d.prototype._groupNames={};var K={HOME:"first",END:"last",NEXT:"next",PREV:"prev"};d.prototype.ontap=function(e){if(!this.getEnabled()||!this.getEditable()){return;}var p=this.getParent();if(p instanceof R&&(!p.getEnabled()||!p.getEditable())){return;}e&&e.setMarked();this.applyFocusInfo();if(!this.getSelected()){this.setSelected(true);var t=this;setTimeout(function(){t.fireSelect({selected:true});},0);}};d.prototype.ontouchstart=function(e){e.originalEvent._sapui_handledByControl=true;if(this.getEnabled()&&this.getActiveHandling()){this.$().toggleClass("sapMRbBTouched",true);}};d.prototype.ontouchend=function(e){this.$().toggleClass("sapMRbBTouched",false);};d.prototype.onsapnext=function(e){this._keyboardHandler(K.NEXT,true);e.setMarked();return this;};d.prototype.onsapnextmodifiers=function(e){this._keyboardHandler(K.NEXT,!e.ctrlKey);e.setMarked();return this;};d.prototype.onsapprevious=function(e){this._keyboardHandler(K.PREV,true);e.setMarked();return this;};d.prototype.onsappreviousmodifiers=function(e){this._keyboardHandler(K.PREV,!e.ctrlKey);e.setMarked();return this;};d.prototype.onsaphome=function(e){this._keyboardHandler(K.HOME,true);e.setMarked();return this;};d.prototype.onsaphomemodifiers=function(e){this._keyboardHandler(K.HOME,!e.ctrlKey);e.setMarked();return this;};d.prototype.onsapend=function(e){this._keyboardHandler(K.END,true);e.setMarked();return this;};d.prototype.onsapendmodifiers=function(e){this._keyboardHandler(K.END,!e.ctrlKey);e.setMarked();return this;};d.prototype._keyboardHandler=function(p,s){if(this.getParent()instanceof R){return;}var n=this._getNextFocusItem(p);n.focus();if(s&&!n.getSelected()&&n.getEditable()&&n.getEnabled()){n.setSelected(true);setTimeout(function(){n.fireSelect({selected:true});},0);}};d.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"radio",type:B.getText("ACC_CTR_TYPE_RADIO"),description:(this.getText()||"")+(this.getSelected()?(" "+B.getText("ACC_CTR_STATE_CHECKED")):""),enabled:this.getEnabled(),editable:this.getEditable()};};d.prototype._getNextFocusItem=function(n){var v=this._groupNames[this.getGroupName()].filter(function(r){return(r.getDomRef()&&r.getEnabled());});var B=v.indexOf(this),i=B,e=v.length;switch(n){case K.NEXT:i=B===e-1?B:B+1;break;case K.PREV:i=B===0?0:i-1;break;case K.HOME:i=0;break;case K.END:i=e-1;break;}return v[i]||this;};d.prototype.onsapselect=function(e){e.preventDefault();this.ontap(e);};d.prototype.setEnabled=function(e){this.setProperty("enabled",e,false);return this;};d.prototype.setSelected=function(s){var o,S=this.getSelected(),g=this.getGroupName(),e=this._groupNames[g],L=e&&e.length;this.setProperty("selected",s,true);this._changeGroupName(this.getGroupName());if(!!s&&g&&g!==""){for(var i=0;i<L;i++){o=e[i];if(o instanceof d&&o!==this&&o.getSelected()){o.fireSelect({selected:false});o.setSelected(false);}}}if((S!==!!s)&&this.getDomRef()){this.$().toggleClass("sapMRbSel",s);if(s){this.getDomRef().setAttribute("aria-checked","true");this.getDomRef("RB").checked=true;this.getDomRef("RB").setAttribute("checked","checked");}else{this.getDomRef().removeAttribute("aria-checked");this.getDomRef("RB").checked=false;this.getDomRef("RB").removeAttribute("checked");}}return this;};d.prototype.setText=function(t){this.setProperty("text",t,true);if(this._oLabel){this._oLabel.setText(this.getText());}else{this._createLabel("text",this.getText());}this.toggleStyleClass("sapMRbHasLabel",!!t);return this;};d.prototype._setWidth=function(u){if(!u){this._setLableWidth();}else{this._setLableWidth("auto");}};d.prototype._setLableWidth=function(w){w=w||this.getWidth();if(this._oLabel){this._oLabel.setWidth(w);}else{this._createLabel("width",w);}};d.prototype.setTextDirection=function(D){this.setProperty("textDirection",D,true);if(this._oLabel){this._oLabel.setTextDirection(this.getTextDirection());}else{this._createLabel("textDirection",this.getTextDirection());}return this;};d.prototype.setGroupName=function(g){this._changeGroupName(g,this.getGroupName());return this.setProperty("groupName",g,true);};d.prototype.onBeforeRendering=function(){this._setWidth(this.getUseEntireWidth());return this._changeGroupName(this.getGroupName());};d.prototype.onAfterRendering=function(){var g=this.getGroupName();this._setAriaPositionAttributes(g);};d.prototype.exit=function(){var g=this.getGroupName(),e=this._groupNames[g],G=e&&e.indexOf(this);this._iTabIndex=null;if(this._oLabel){this._oLabel.destroy();}if(G>=-1){e.splice(G,1);}};d.prototype._createLabel=function(p,v){this._oLabel=new sap.m.Label(this.getId()+"-label").addStyleClass("sapMRbBLabel").setParent(this,null,true);this._oLabel.setProperty(p,v,false);};d.prototype.setTabIndex=function(t){var f=this.getFocusDomRef();this._iTabIndex=t;if(f){f.setAttribute("tabindex",t);}return this;};d.prototype.setTextAlign=function(A){this.setProperty("textAlign",A,true);if(this._oLabel){this._oLabel.setTextAlign(this.getTextAlign());}else{this._createLabel("textAlign",this.getTextAlign());}return this;};d.prototype._changeGroupName=function(n,o){var N=this._groupNames[n],O=this._groupNames[o];if(O&&O.indexOf(this)!==-1){O.splice(O.indexOf(this),1);this._setAriaPositionAttributes(o);}if(!N){N=this._groupNames[n]=[];}if(N.indexOf(this)===-1){N.push(this);this._setAriaPositionAttributes(n);}};d.prototype._setAriaPositionAttributes=function(g){var G=this._groupNames[g],r=0,i;if(!G.length||!this.getDomRef()){return;}i=G.reduce(function(i,o){return o.getDomRef()?++i:i;},0);G.forEach(function(o){var e=o.getDomRef();if(e){e.setAttribute("aria-posinset",++r);e.setAttribute("aria-setsize",i);}});};return d;});
