/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/library','./RadioButtonGroupRenderer'],function(q,l,C,I,c,R){"use strict";var T=c.TextDirection;var V=c.ValueState;var a=C.extend("sap.m.RadioButtonGroup",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/RadioButtonGroup.designtime",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},columns:{type:"int",group:"Appearance",defaultValue:1},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},selectedIndex:{type:"int",group:"Data",defaultValue:0},enabled:{type:"boolean",group:"Behavior",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},defaultAggregation:"buttons",aggregations:{buttons:{type:"sap.m.RadioButton",multiple:true,singularName:"button",bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selectedIndex:{type:"int"}}}}}});a.prototype.exit=function(){this.destroyButtons();if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};a.prototype.onBeforeRendering=function(){if(this.getSelectedIndex()>this.getButtons().length){q.sap.log.warning("Invalid index, set to 0");this.setSelectedIndex(0);}};a.prototype.onAfterRendering=function(){this._initItemNavigation();var v;if(this.getVisible()){v=this.aRBs.filter(function(b){return b.getVisible();});}else{v=[];}for(var i=0;i<v.length;i++){var r=v[i].getDomRef();r.setAttribute("aria-posinset",i+1);r.setAttribute("aria-setsize",v.length);}};a.prototype._initItemNavigation=function(){var d=[];var h=false;var r=this.getEnabled();for(var i=0;i<this.aRBs.length;i++){d.push(this.aRBs[i].getDomRef());h=h||this.aRBs[i].getEnabled();}if(!h||!r){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}return;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(this.getDomRef());this._oItemNavigation.setItemDomRefs(d);this._oItemNavigation.setCycling(true);this._oItemNavigation.setColumns(this.getColumns());this._oItemNavigation.setSelectedIndex(this.getSelectedIndex());this._oItemNavigation.setFocusedIndex(this.getSelectedIndex());this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});};a.prototype.setSelectedIndex=function(s){var i=this.getSelectedIndex();var h=document.activeElement&&document.activeElement.parentNode&&document.activeElement.parentNode.parentNode===this.getDomRef();var b=!!(this.aRBs&&this.aRBs[s]);if(s<-1){q.sap.log.warning("Invalid index, will not be changed");return this;}this.setProperty("selectedIndex",s,true);if(!isNaN(i)&&this.aRBs&&this.aRBs[i]){this.aRBs[i].setSelected(false);}if(this.aRBs&&this.aRBs[s]){this.aRBs[s].setSelected(true);}if(this._oItemNavigation){this._oItemNavigation.setSelectedIndex(s);this._oItemNavigation.setFocusedIndex(s);}if(b&&h){this.aRBs[s].getDomRef().focus();}return this;};a.prototype.setSelectedButton=function(s){var b=this.getButtons();if(s){if(b){for(var i=0;i<b.length;i++){if(s.getId()==b[i].getId()){this.setSelectedIndex(i);break;}}}}else{this.setSelectedIndex(-1);}return this;};a.prototype.getSelectedButton=function(){return this.getButtons()[this.getSelectedIndex()];};a.prototype.addButton=function(b){if(!this._bUpdateButtons&&this.getSelectedIndex()===undefined){this.setSelectedIndex(0);}if(!this.aRBs){this.aRBs=[];}var i=this.aRBs.length;this.aRBs[i]=this._createRadioButton(b,i);this.addAggregation("buttons",this.aRBs[i]);return this;};a.prototype.insertButton=function(b,d){if(!this.aRBs){this.aRBs=[];}var L=this.aRBs.length,m=this.getButtons().length;d=Math.max(Math.min(d,m),0);if(!this._bUpdateButtons){if(this.getSelectedIndex()===undefined||L==0){this.setSelectedIndex(0);}else if(this.getSelectedIndex()>=d){this.setProperty("selectedIndex",this.getSelectedIndex()+1,true);}}if(d>=L){this.aRBs[d]=this._createRadioButton(b,d);}else{for(var i=(L);i>d;i--){this.aRBs[i]=this.aRBs[i-1];if((i-1)==d){this.aRBs[i-1]=this._createRadioButton(b,d);}}}this.insertAggregation("buttons",b,d);return this;};a.prototype._createRadioButton=function(b,i){if(this.iIDCount==undefined){this.iIDCount=0;}else{this.iIDCount++;}b.setValueState(this.getValueState());b.setGroupName(this.getId());if(i==this.getSelectedIndex()){b.setSelected(true);}b.attachEvent("select",this._handleRBSelect,this);return b;};a.prototype.removeButton=function(e){var i=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e);}if(typeof(e)=="object"){i=this.indexOfButton(e);}var b=this.removeAggregation("buttons",i);if(!this.aRBs){this.aRBs=[];}if(!this.aRBs[i]){return null;}this.aRBs.splice(i,1);if(!this._bUpdateButtons){if(this.aRBs.length==0){this.setSelectedIndex(-1);}else if(this.getSelectedIndex()==i){this.setSelectedIndex(0);}else{if(this.getSelectedIndex()>i){this.setProperty("selectedIndex",this.getSelectedIndex()-1,true);}}}return b;};a.prototype.removeAllButtons=function(){if(!this._bUpdateButtons){this.setSelectedIndex(-1);}return this.removeAllAggregation("buttons");};a.prototype.destroyButtons=function(){this.destroyAggregation("buttons");if(!this._bUpdateButtons){this.setSelectedIndex(-1);}if(this.aRBs){while(this.aRBs.length>0){this.aRBs[0].destroy();this.aRBs.splice(0,1);}}return this;};a.prototype.updateButtons=function(){this._bUpdateButtons=true;this.updateAggregation("buttons");this._bUpdateButtons=undefined;};a.prototype.clone=function(){var b=this.getButtons();var i=0;for(i=0;i<b.length;i++){b[i].detachEvent("select",this._handleRBSelect,this);}var o=C.prototype.clone.apply(this,arguments);for(i=0;i<b.length;i++){b[i].attachEvent("select",this._handleRBSelect,this);}return o;};a.prototype._handleRBSelect=function(o){for(var i=0;i<this.aRBs.length;i++){if(this.aRBs[i].getId()==o.getParameter("id")&&o.getParameter("selected")){this.setSelectedIndex(i);this.fireSelect({selectedIndex:i});break;}}};a.prototype.setValueState=function(v){this.setProperty("valueState",v,false);if(this.aRBs){for(var i=0;i<this.aRBs.length;i++){this.aRBs[i].setValueState(v);}}return this;};a.prototype._handleAfterFocus=function(o){var i=o.getParameter("index");var e=o.getParameter("event");if(e.keyCode===undefined){return;}if(i!=this.getSelectedIndex()&&!(e.ctrlKey||e.metaKey)&&this.aRBs[i].getEditable()&&this.aRBs[i].getEnabled()&&this.getEditable()&&this.getEnabled()){this.setSelectedIndex(i);this.fireSelect({selectedIndex:i});this.aRBs[i].fireSelect({selected:true});}};return a;});
