/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['jquery.sap.global','./library','./SliderUtilities','sap/ui/core/Control','sap/ui/core/library','./delegate/ValueStateMessage','./SliderTooltipRenderer'],function(q,L,S,C,c,V,a){"use strict";var b=c.ValueState;var d=C.extend("sap.m.SliderTooltip",{metadata:{interfaces:["sap.m.ISliderTooltip"],library:"sap.m",properties:{value:{type:"float",group:"Data",defaultValue:0,bindable:"bindable"},min:{type:"float",group:"Data",defaultValue:0},max:{type:"float",group:"Data",defaultValue:100},editable:{type:"boolean",defaultValue:false},step:{type:"float",group:"Data",defaultValue:1},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:b.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"float"},valid:{type:"boolean"}}}}}});d.prototype.init=function(){this._oValueStateMessage=new V(this);this._fLastValidValue=0;};d.prototype.getValueStateText=function(){return"";};d.prototype.getFocusDomRef=function(){return this.$("input");};d.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};d.prototype.setValue=function(v){v=this.validateProperty("value",v);if(this.getDomRef()){this.getFocusDomRef().val(v);}this._fLastValidValue=v;this.setValueState(b.None);return this.setProperty("value",parseFloat(v),true);};d.prototype.setEditable=function(e){e=this.validateProperty("editable",e);if(this.getDomRef()){this.getFocusDomRef().toggleClass(S.CONSTANTS.TOOLTIP_CLASS+"NotEditable");}return this.setProperty("editable",e,true);};d.prototype.setValueState=function(v){var e,o;v=this.validateProperty("valueState",v);this.setProperty("valueState",v,true);e=(v===b.Error);o=this.getDomRef()&&e;this._oValueStateMessage[o?"open":"close"]();this.$().toggleClass(S.CONSTANTS.TOOLTIP_CLASS+"ErrorState",e);return this;};d.prototype.onfocusout=function(e){var v=parseFloat(this.getFocusDomRef().val());this._validateValue(v);};d.prototype.onsapenter=function(e){var v=parseFloat(this.getFocusDomRef().val());this._validateValue(v);};d.prototype.onsapescape=function(e){this.setValue(this._fLastValidValue);this.setValueState(b.None);};d.prototype._validateValue=function(v){if(this._isValueValid(v)){this.setValue(v);this.fireChange({value:v});}else{this.setValueState(b.Error);}};d.prototype._isValueValid=function(v){return!(isNaN(v)||v<this.getMin()||v>this.getMax());};return d;});
