/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./Tokenizer','sap/ui/core/library','sap/ui/core/Icon','./TokenRenderer','jquery.sap.keycodes'],function(q,l,C,T,c,I,a){"use strict";var b=c.TextDirection;var d=C.extend("sap.m.Token",{metadata:{library:"sap.m",properties:{selected:{type:"boolean",group:"Misc",defaultValue:false},key:{type:"string",group:"Misc",defaultValue:""},text:{type:"string",group:"Misc",defaultValue:""},editable:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit}},aggregations:{deleteIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{"delete":{},press:{},select:{},deselect:{}}}});d.prototype.init=function(){var t=this;this._deleteIcon=new I({id:t.getId()+"-icon",src:"sap-icon://sys-cancel",noTabStop:true,press:function(e){var p=t.getParent();t.fireDelete({token:t});if(p instanceof T){p._onTokenDelete(t);}e.preventDefault();}});this._deleteIcon.addStyleClass("sapMTokenIcon");this.setAggregation("deleteIcon",this._deleteIcon);this._deleteIcon.setUseIconTooltip(false);};d.prototype.ontouchstart=function(e){if(e.target.id===this.getId()+"-icon"){e.preventDefault();}};d.prototype.setSelected=function(s){if(this.getSelected()===s){return this;}var $=this.$();if($){$.toggleClass("sapMTokenSelected",s);$.attr('aria-selected',s);}this.setProperty("selected",s,true);return this;};d.prototype.setEditable=function(e){var p=this.getParent();this.setProperty("editable",e,true);this.$().toggleClass("sapMTokenReadOnly",!e);if(p instanceof T){p.invalidate();}return this;};d.prototype._onTokenPress=function(e){var s=this.getSelected(),f=e.ctrlKey||e.metaKey,S=e.shiftKey,n=true,p;if(f){n=!s;}this.setSelected(n);this.firePress();if(s!=n){if(n){this.fireSelect();}else{this.fireDeselect();}}p=this.getParent();if(p instanceof T){p._onTokenSelect(this,f,S);}if(this.getSelected()){this.focus();}};d.prototype._changeSelection=function(s){if(this.getSelected()==s){return;}this.setSelected(s);if(s){this.fireSelect();}else{this.fireDeselect();}};d.prototype.ontap=function(e){if(e.target.id==this._deleteIcon.getId()){e.setMark("tokenDeletePress",true);return;}this._onTokenPress(e);};d.prototype.onsapfocusleave=function(e){if(this.getParent()instanceof T){return;}this.setSelected(false);};d.prototype.onsapbackspace=function(e){this._deleteToken(e);};d.prototype.onsapdelete=function(e){this._deleteToken(e);};d.prototype._deleteToken=function(e){if(this.getParent()instanceof T){return;}if(this.getEditable()){this.fireDelete({token:this});}e.preventDefault();};d.prototype.onsapspace=function(e){this._onTokenPress(e);if(e){e.preventDefault();e.stopPropagation();}};d.prototype.onkeydown=function(e){if((e.ctrlKey||e.metaKey)&&e.which===q.sap.KeyCodes.SPACE){this.onsapspace(e);e.preventDefault();}};return d;});
