/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/ColumnHeader',['sap/ui/core/Control','sap/ui/core/Icon','./ColumnHeaderRenderer'],function(C,I,a){"use strict";
var b=C.extend("sap.m.ColumnHeader",{
library:"sap.m",
metadata:{properties:{text:{type:"string",defaultValue:null},sorted:{type:"boolean",defaultValue:false},sortOrder:{type:"string",defaultValue:null},filtered:{type:"boolean",defaultValue:false}},defaultAggregations:"viewSettingsPopover",aggregations:{viewSettingsPopover:{type:"sap.m.ViewSettingsPopover",multiple:false},_sortIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_filterIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}
});
b.prototype.setViewSettingsPopover=function(v){this.setAggregation("viewSettingsPopover",v,true);this._attachViewSettingsPopoverEvents();return this;};
b.prototype.setSortOrder=function(s){this.setProperty("sortOrder",s);var i=s==="Ascending"?"sap-icon://sort-ascending":"sap-icon://sort-descending";var S=this.getAggregation("_sortIcon");if(!S){this.setAggregation("_sortIcon",new I({src:i,visible:this.getSorted()}));}else{S.setSrc(i);}return this;};
b.prototype.setSorted=function(s){this.setProperty("sorted",s);var S=this.getAggregation("_sortIcon");if(!s&&!S){return this;}if(s){if(!S){this.setAggregation("_sortIcon",new I({src:this.getSortOrder()==="Ascending"?"sap-icon://sort-ascending":"sap-icon://sort-descending"}));}else{S.setVisible(true);}}else{S.setVisible(false);}return this;};
b.prototype.setFiltered=function(f){this.setProperty("filtered",f);var F=this.getAggregation("_filterIcon");if(!f&&!F){return this;}if(f){if(!F){this.setAggregation("_filterIcon",new I({src:"sap-icon://filter"}));}else{F.setVisible(true);}}else{F.setVisible(false);}return this;};
b.prototype.setTableAdapter=function(A){this._oAdapter=A;};
b.prototype.getTableAdapter=function(){return this._oAdapter||{interactive:true,rowAggregation:"items"};};
b.prototype.onclick=function(e){if(this._isInteractive()){this._openColumnActions();}};
b.prototype.onsapselect=b.prototype.onclick;
b.prototype._openColumnActions=function(){var v=this.getViewSettingsPopover();if(v!=null){var $=this.$();v.openBy(this);v._getPopover(this).setOffsetY(-$.outerHeight());}};
b.prototype._attachViewSettingsPopoverEvents=function(){var v=this.getViewSettingsPopover();if(v){this._detachViewSettingsPopoverEvents(v);v.attachSortSelected(this.onSortSelected,this);v.attachFilterSelected(this.onFilterSelected,this);}};
b.prototype._detachViewSettingsPopoverEvents=function(v){v.detachSortSelected(this.onSortSelected,this);v.detachFilterSelected(this.onFilterSelected,this);};
b.prototype.onSortSelected=function(){if(!this.getSorted()){this.setSorted(true);}if(this.getSortOrder()===""||this.getSortOrder()==="Descending"){this.setSortOrder("Ascending");}else{this.setSortOrder("Descending");}};
b.prototype.onFilterSelected=function(){this.setFiltered(true);};
b.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),A=this.getText()+" ";if(this._isInteractive()){if(this.getSortOrder()){A+=B.getText("COLUMNHEADER_SORTED")+" ";A+=(this.getSortOrder()==="Ascending"?B.getText("COLUMNHEADER_SORTED_ASCENDING"):B.getText("COLUMNHEADER_SORTED_DESCENDING"))+" ";}if(this.getFiltered()){A+=B.getText("COLUMNHEADER_FILTERED")+" ";}A+=B.getText("COLUMNHEADER_ACCESS_COLUMN_ACTIONS");return{role:"button",focusable:true,description:A};}return{focusable:false,description:A};};
b.prototype._isInteractive=function(){return this.getTableAdapter().interactive&&!!this.getViewSettingsPopover();};
b.prototype.exit=function(){this._oAdapter=null;};
return b;});
sap.ui.predefine('sap/m/CustomTreeItem',['./TreeItemBase','./ListItemBase','./library',"./CustomTreeItemRenderer"],function(T,L,l,C){"use strict";
var a=T.extend("sap.m.CustomTreeItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});
a.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/m/CustomTreeItemRenderer',['./TreeItemBaseRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var C=R.extend(T);
C.renderLIAttributes=function(r,l){r.addClass("sapMCTI");T.renderLIAttributes.apply(this,arguments);};
C.renderLIContent=function(r,l){l.getContent().forEach(function(c){r.renderControl(c);});};
return C;},true);
sap.ui.predefine('sap/m/P13nColumnsItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nColumnsItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Misc"},index:{type:"int",group:"Appearance"},visible:{type:"boolean",group:"Appearance"},width:{type:"string",group:"Misc"},total:{type:"boolean"}}}});
return P;});
sap.ui.predefine('sap/m/P13nColumnsPanel',['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nColumnsItem','./SearchField','./Table','./library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/ui/core/IconPool','sap/m/ScrollContainer'],function(q,C,P,c,S,T,l,d,J,B,R,I,e){"use strict";var O=l.OverflowToolbarPriority;var f=l.ButtonType;var g=l.ToolbarDesign;var L=l.ListType;var h=l.ListMode;var i=l.P13nPanelType;
var j=P.extend("sap.m.P13nColumnsPanel",{
metadata:{library:"sap.m",properties:{visibleItemsThreshold:{type:"int",group:"Behavior",defaultValue:-1}},aggregations:{columnsItems:{type:"sap.m.P13nColumnsItem",multiple:true,singularName:"columnsItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{addColumnsItem:{parameters:{newItem:{type:"sap.m.P13nColumnsItem"}}},changeColumnsItems:{parameters:{newItems:{type:"sap.m.P13nColumnsItem[]"},existingItems:{type:"sap.m.P13nColumnsItem[]"},items:{type:"object[]"}}},setData:{}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}
});
j.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bTableItemsChanged=false;this._bOnAfterRenderingFirstTimeExecuted=false;var m=new J({items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});m.setDefaultBindingMode(B.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nColumnsPanel");this.setType(i.columns);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("COLUMSPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new e({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);var t=this;this._fnHandleResize=function(){var b=false,a,k;if(t.getParent){var $=null,n,H;var p=t.getParent();var o=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&o.$().length>0){a=s.$()[0].clientHeight;n=$.children()[0].clientHeight;H=o?o.$()[0].clientHeight:0;k=n-H;if(a!==k){s.setHeight(k+'px');b=true;}}}}return b;};this._sContainerResizeListener=R.register(s,this._fnHandleResize);};
j.prototype.reInitialize=function(){};
j.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
j.prototype.onAfterRendering=function(){if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);var t=this;this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};
j.prototype.getOkPayload=function(){this._updateInternalModel();var m=this._getInternalModel().getProperty("/items");return{tableItems:m.map(function(M){return{columnKey:M.columnKey,index:M.persistentIndex===-1?undefined:M.persistentIndex,visible:M.persistentSelected,width:M.width};}),tableItemsChanged:this._bTableItemsChanged,selectedItems:m.filter(function(M){return M.persistentSelected;}).map(function(M){return{columnKey:M.columnKey};})};};
j.prototype.getResetPayload=function(){return{oPanel:this};};
j.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
j.prototype.addItem=function(o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",o);return this;};
j.prototype.insertItem=function(o,a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",o,a);return this;};
j.prototype.removeItem=function(o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}o=this.removeAggregation("items",o);return o;};
j.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
j.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
j.prototype.addColumnsItem=function(o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("columnsItems",o);return this;};
j.prototype.insertColumnsItem=function(o,a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("columnsItems",o,a);return this;};
j.prototype.updateColumnsItems=function(r){this.updateAggregation("columnsItems");if(r===d.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
j.prototype.removeColumnsItem=function(o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("columnsItems",o);};
j.prototype.removeAllColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("columnsItems");};
j.prototype.destroyColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("columnsItems");return this;};
j.prototype.onBeforeNavigationFrom=function(){var m=this._getSelectedModelItems();var v=this.getVisibleItemsThreshold();return!(m&&v!==-1&&m.length>v);};
j.prototype._notifyChange=function(){this._bTableItemsChanged=true;var a=this.getChangeNotifier();if(a){a(this);}};
j.prototype._scrollToSelectedItem=function(o){if(!o){return;}sap.ui.getCore().applyChanges();if(!!o.getDomRef()){o.focus();}};
j.prototype._getInternalModel=function(){return this.getModel("$sapmP13nColumnsPanel");};
j.prototype._createTable=function(){this._oTable=new T({mode:h.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(a,b){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[a,b]);}}})})],items:{path:"/items",templateShareable:false,template:new C({cells:[new sap.m.Text({text:"{text}"})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
j.prototype._createToolbar=function(){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{design:g.Auto,content:[new sap.m.ToolbarSpacer(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new sap.m.Button({text:{path:'/showOnlySelectedItems',formatter:function(s){return s?r.getText('COLUMNSPANEL_SHOW_ALL'):r.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(s){return s?r.getText('COLUMNSPANEL_SHOW_ALL'):r.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:f.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.High})}),new sap.m.OverflowToolbarButton({icon:I.getIconURI("collapse-group"),text:r.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:r.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:f.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveToTop,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.Low,group:2})}),new sap.m.OverflowToolbarButton({icon:I.getIconURI("slim-arrow-up"),text:r.getText('COLUMNSPANEL_MOVE_UP'),tooltip:r.getText('COLUMNSPANEL_MOVE_UP'),type:f.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveUp,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.High,group:1})}),new sap.m.OverflowToolbarButton({icon:I.getIconURI("slim-arrow-down"),text:r.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:r.getText('COLUMNSPANEL_MOVE_DOWN'),type:f.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveDown,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.High,group:1})}),new sap.m.OverflowToolbarButton({icon:I.getIconURI("expand-group"),text:r.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:r.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:f.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.Low,group:2})})]});o.setModel(this._getInternalModel());this.addAggregation("content",o);};
j.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
j.prototype.onPressButtonMoveUp=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())-1]);};
j.prototype.onPressButtonMoveDown=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())+1]);};
j.prototype.onPressButtonMoveToBottom=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.length-1]);};
j.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
j.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
j.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var m=this._getInternalModel().getProperty("/items");m.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});this._getInternalModel().setProperty("/items",m);};
j.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return!!m.visible;});};
j.prototype._moveMarkedTableItem=function(t,o){var m=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(t));var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(o));var a=this._getModelItemIndexByColumnKey(m.columnKey);var b=this._getModelItemIndexByColumnKey(M.columnKey);this._moveModelItems(a,b);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();};
j.prototype._moveModelItems=function(a,b){var m=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>m.length-1||b>m.length-1){return false;}this._removeStyleOfMarkedTableItem();var M=m.splice(a,1);m.splice(b,0,M[0]);this._updateModelItemsPersistentIndex(m);this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
j.prototype._getModelItemByColumnKey=function(s){var m=this._getInternalModel().getProperty("/items").filter(function(M){return M.columnKey===s;});return m[0];};
j.prototype._updateCounts=function(m){var a=0;var b=0;m.forEach(function(M){a++;if(M.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};
j.prototype._sortModelItemsByPersistentIndex=function(m){m.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};
j.prototype._getColumnKeyByTableItem=function(t){var a=this._oTable.indexOfItem(t);if(a<0){return null;}return this._oTable.getBinding("items").getContexts()[a].getObject().columnKey;};
j.prototype._getModelItemIndexByColumnKey=function(s){var a=-1;this._getInternalModel().getProperty("/items").some(function(m,b){if(m.columnKey===s){a=b;return true;}});return a;};
j.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return m.persistentSelected;});};
j.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(t){return t.getVisible();});};
j.prototype._getTableItemByColumnKey=function(s){var a=this._oTable.getBinding("items").getContexts();var t=this._oTable.getItems().filter(function(o,b){return a[b].getObject().columnKey===s;});return t[0];};
j.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
j.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
j.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
j.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
j.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
j.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",v.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",v.indexOf(this._getMarkedTableItem())>-1&&v.indexOf(this._getMarkedTableItem())<v.length-1);var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!b&&!s);}};
j.prototype._updateModelItemsPersistentIndex=function(m){var p=-1;m.forEach(function(M){M.persistentIndex=-1;if(M.persistentSelected){p++;M.persistentIndex=p;}});};
j.prototype._fireSetData=function(){this._bIgnoreUpdateInternalModel=true;this.fireSetData();this._bIgnoreUpdateInternalModel=false;};
j.prototype._fireChangeColumnsItems=function(){this._bIgnoreUpdateInternalModel=true;var m=this._getInternalModel().getProperty("/items");var E={newItems:[],existingItems:[],items:m.map(function(M){return{columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,width:M.width,total:M.total};})};m.forEach(function(M){var o=this._getColumnsItemByColumnKey(M.columnKey);if(o){o.setVisible(M.persistentSelected);o.setIndex(M.persistentIndex===-1?undefined:M.persistentIndex);if(M.width!==undefined){o.setWidth(M.width);}if(M.total!==undefined){o.setTotal(M.total);}E.existingItems.push(o);}else{E.newItems.push(new c({columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,width:M.width,total:M.total}));}},this);this.fireChangeColumnsItems(E);this._bIgnoreUpdateInternalModel=false;};
j.prototype._getColumnsItemByColumnKey=function(s){var a=this.getColumnsItems().filter(function(o){return o.getColumnKey()===s;});return a[0];};
j.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
j.prototype._setColumnKeyOfMarkedItem=function(s){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",s);};
j.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
j.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
j.prototype._selectTableItem=function(){this._updateControlLogic();var m=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(m);this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();var v=this.getValidationExecutor();if(v){v();}};
j.prototype._switchMarkedTableItemTo=function(t){this._removeStyleOfMarkedTableItem();var s=this._getColumnKeyByTableItem(t);if(s){this._setColumnKeyOfMarkedItem(s);t.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
j.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
j.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(m){m.visible=false;if(typeof m.text==="string"&&m.text.match(r)){m.visible=true;}if(typeof m.tooltip==="string"&&m.tooltip.match(r)){m.visible=true;}});this._getInternalModel().refresh();};
j.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();var m=this._getInternalModel().getProperty("/items");this._getInternalModel().setProperty("/items",this.getItems().map(function(o){return{columnKey:o.getColumnKey(),visible:true,text:o.getText(),tooltip:o.getTooltip(),persistentIndex:-1,persistentSelected:o.getVisible(),width:undefined,total:undefined};},this));this.getColumnsItems().forEach(function(o){var a=this._getModelItemByColumnKey(o.getColumnKey());if(!a){return;}if(o.getIndex()!==undefined){a.persistentIndex=o.getIndex();}if(o.getVisible()!==undefined){a.persistentSelected=o.getVisible();}if(o.getWidth()!==undefined){a.width=o.getWidth();}if(o.getTotal()!==undefined){a.total=o.getTotal();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());if(q(M).not(m).length!==0||q(m).not(M).length!==0){this._bTableItemsChanged=true;}};
return j;});
sap.ui.predefine('sap/m/P13nConditionPanel',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/core/ResizeHandler','sap/ui/core/Item'],function(q,a,C,D,N,I,b,c,d,R,e){"use strict";var V=d.ValueState;var B=a.ButtonType;var T=a.ToolbarDesign;var f=d.TextAlign;var O=a.OverflowToolbarPriority;var G;
var P=C.extend("sap.m.P13nConditionPanel",{
metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},
renderer:function(r,o){r.write("<section");r.writeControlData(o);r.addClass("sapMConditionPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMConditionPanelContent");r.addClass("sapMConditionPanelBG");r.writeClasses();r.write(">");var g=o.getAggregation("content");var l=g.length;for(var i=0;i<l;i++){r.renderControl(g[i]);}r.write("</div>");r.write("</section>");}
});
P.prototype.setConditions=function(g){if(!g){q.sap.log.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<g.length;i++){this._addCondition2Map(g[i]);}this._clearConditions();this._fillConditions();};
P.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};
P.prototype.addCondition=function(o){if(this._bIgnoreSetConditions){return;}o.index=this._iConditions;this._addCondition2Map(o);this._addCondition(o);};
P.prototype.insertCondition=function(o,i){if(this._bIgnoreSetConditions){return;}if(i!==undefined){o.index=i;}this._addCondition2Map(o);this._addCondition(o);};
P.prototype.removeCondition=function(v){this._clearConditions();if(typeof v=="string"){this._removeConditionFromMap(v);}if(typeof v=="object"){this._removeConditionFromMap(v.key);}this._fillConditions();};
P.prototype._addCondition2Map=function(o){if(!o.key){o.key="condition_"+this._iConditions;if(this.getExclude()){o.key="x"+o.key;}}this._iConditions++;this._oConditionsMap[o.key]=o;this._aConditionKeys.push(o.key);};
P.prototype._removeConditionFromMap=function(k){this._iConditions--;delete this._oConditionsMap[k];var i=this._aConditionKeys.indexOf(k);if(i>=0){this._aConditionKeys.splice(i,1);}};
P.prototype.getConditions=function(){var o;var g=[];if(this._oConditionsMap){for(var h in this._oConditionsMap){o=this._oConditionsMap[h];var v=o.value;if(!v){v=this._getFormatedConditionText(o.operation,o.value1,o.value2,o.exclude,o.keyField,o.showIfGrouped);}if(!o._oGrid||o._oGrid.select.getSelected()){g.push({"key":h,"text":v,"exclude":o.exclude,"operation":o.operation,"keyField":o.keyField,"value1":o.value1,"value2":o.operation===sap.m.P13nConditionOperation.BT?o.value2:null,"showIfGrouped":o.showIfGrouped});}}}return g;};
P.prototype.setOperations=function(o,t){t=t||"default";this._oTypeOperations[t]=o;this._updateAllOperations();};
P.prototype.setValues=function(v,t){t=t||"default";this._oTypeValues[t]=v;};
P.prototype.addOperation=function(o,t){t=t||"default";this._oTypeOperations[t].push(o);this._updateAllOperations();};
P.prototype.removeAllOperations=function(t){t=t||"default";this._oTypeOperations[t]=[];this._updateAllOperations();};
P.prototype.getOperations=function(t){t=t||"default";return this._oTypeOperations[t];};
P.prototype.setKeyFields=function(k){this._aKeyFields=k;this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
P.prototype.addKeyField=function(k){this._aKeyFields.push(k);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
P.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};
P.prototype.getKeyFields=function(){return this._aKeyFields;};
P.prototype.setAlwaysShowAddIcon=function(E){this.setProperty("alwaysShowAddIcon",E);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};
P.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};
P.prototype.setContainerQuery=function(E){this._unregisterResizeHandler();this.setProperty("containerQuery",E);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};
P.prototype._updateConditionFieldSpans=function(m){if(this._aConditionsFields){var g=m==="Desktop";if(g){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var t=m==="Tablet";if(t){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};
P.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");G=G||sap.ui.requireSync("sap/ui/layout/Grid");this.addStyleClass("sapMConditionPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=b.media._predefinedRangeSets[b.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=b.media._predefinedRangeSets[b.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new G({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new c({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new c({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":b.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];this._oButtonGroupSpan={"SpanFilter":"L1 M2 S2","SpanSort":b.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};
P.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var t=this;this._oPrevButton=new sap.m.Button({icon:I.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(E){t._iFirstConditionIndex=Math.max(0,t._iFirstConditionIndex-t._iConditionPageSize);t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow})});this._oNextButton=new sap.m.Button({icon:I.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(E){t._iFirstConditionIndex+=t._iConditionPageSize;t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow})});this._oRemoveAllButton=new sap.m.Button({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(E){t._aConditionKeys.forEach(function(k,i){if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}},t);this._iFirstConditionIndex=0;t.removeAllConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.Low})});this._oAddButton=new sap.m.Button({icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),visible:true,press:function(E){var o=t._createConditionRow(t._oConditionsGrid,undefined,null,0);t._changeField(o);setTimeout(function(){o.keyField.focus();});t._updatePaginatorToolbar();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.Low})});this._oHeaderText=new sap.m.Text({wrapping:false,layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow})});this._oPageText=new sap.m.Text({wrapping:false,textAlign:f.Center,layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow})});this._oFilterField=new sap.m.SearchField({width:"12rem",layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.High})});this._oPaginatorToolbar=new sap.m.OverflowToolbar({height:"3rem",design:T.Transparent,content:[this._oHeaderText,new sap.m.ToolbarSpacer(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};
P.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var g=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var o=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}o.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(o&&o.setHeaderToolbar){if(!o.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);o.setHeaderToolbar(this._oPaginatorToolbar);o.attachExpand(function(E){this._setToolbarElementVisibility(E.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}var h=this._sOrgHeaderText+(i>0?" ("+i+")":"");o.setHeaderText(h);this._oHeaderText.setText(h);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(g+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(g>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var n=0;this._oConditionsGrid.getContent().forEach(function(j){if(j.select.getSelected()){n++;}},this);if(p==g&&(i-this._iFirstConditionIndex)>n){this._clearConditions();this._fillConditions();}};
P.prototype._setToolbarElementVisibility=function(v){this._oPrevButton.setVisible(v);this._oNextButton.setVisible(v);this._oPageText.setVisible(v);this._oFilterField.setVisible(false);this._oAddButton.setVisible(v);this._oRemoveAllButton.setVisible(v);};
P.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};
P.prototype._clearConditions=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(o){for(var F in this._aConditionsFields){var h=this._aConditionsFields[F];if(o[h["ID"]]&&o.getContent().indexOf(o[h["ID"]])===-1){o[h["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};
P.prototype._fillConditions=function(){var o,s;var i=0,m=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var p=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(m,this._iFirstConditionIndex+p));for(i=this._iFirstConditionIndex;i<n;i++){s=this._aConditionKeys[i];o=this._oConditionsMap[s];this._createConditionRow(this._oConditionsGrid,o,s);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<m){this._createConditionRow(this._oConditionsGrid);}};
P.prototype._addCondition=function(o){var i=0;var m=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var g in this._oConditionsMap){if(i<m&&o===this._oConditionsMap[g]){this._createConditionRow(this._oConditionsGrid,o,g,i);}i++;}}this._updatePaginatorToolbar();};
P.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions(),10);};
P.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};
P.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};
P.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}b.media.detachHandler(this._handleMediaChange,this,b.media.RANGESETS.SAP_STANDARD);};
P.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this._oConditionsGrid,q.proxy(this._onGridResize,this));this._onGridResize();}else{b.media.attachHandler(this._handleMediaChange,this,b.media.RANGESETS.SAP_STANDARD);}};
P.prototype._getKeyFromConditionGrid=function(o){var k=o.data("_key");if(!k){k=this._createConditionKey();}return k;};
P.prototype._createConditionKey=function(){var i=0;var k;do{k="condition_"+i;if(this.getExclude()){k="x"+k;}i++;}while(this._oConditionsMap[k]);return k;};
P.prototype._createConditionRow=function(t,o,k,p){var g=null;var h;var i=this;if(p===undefined){p=t.getContent().length;}var j=new G({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",k);for(var F in this._aConditionsFields){var l;var m=this._aConditionsFields[F];switch(m["Control"]){case"CheckBox":l=new sap.m.CheckBox({enabled:false,visible:false,layoutData:new sap.ui.layout.GridData({span:m["Span"+this._sConditionType]})});if(m["ID"]==="showIfGrouped"){l.setEnabled(true);l.setText(m["Label"]);l.attachSelect(function(){i._changeField(j);});l.setSelected(o?o.showIfGrouped:true);}else{if(o){l.setSelected(true);l.setEnabled(true);}}break;case"ComboBox":if(m["ID"]==="keyField"){l=new sap.m.ComboBox({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var n=q.proxy(l.setSelectedKey,l);l.setSelectedKey=function(k){n(k);var z=i.getValidationExecutor();if(z){z();}};var r=q.proxy(l.setSelectedItem,l);l.setSelectedItem=function(z){r(z);var E=i.getValidationExecutor();if(E){E();}};l.setLayoutData(new sap.ui.layout.GridData({span:m["Span"+this._sConditionType]}));this._fillKeyFieldListItems(l,this._aKeyFields);if(l.attachSelectionChange){l.attachSelectionChange(function(E){var z=i.getValidationExecutor();if(z){z();}i._handleSelectionChangeOnKeyField(t,j);});}if(l.attachChange){l.attachChange(function(E){j.keyField.close();i._handleChangeOnKeyField(t,j);});}if(l.setSelectedItem){if(o){l.setSelectedKey(o.keyField);this._aKeyFields.forEach(function(K,z){var E=K.key;if(E===undefined){E=K;}if(o.keyField===E){l.setSelectedItem(l.getItems()[z]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!k){h=t.getContent()[p-1];if(h.keyField.getSelectedKey()){l.setSelectedKey(h.keyField.getSelectedKey());}else{if(!l.getSelectedItem()&&l.getItems().length>0){l.setSelectedItem(l.getItems()[0]);}}}else{this._aKeyFields.some(function(K,z){if(K.isDefault){l.setSelectedItem(l.getItems()[z]);return true;}if(!l.getSelectedItem()&&K.type!=="boolean"){l.setSelectedItem(l.getItems()[z]);}},this);if(!l.getSelectedItem()&&l.getItems().length>0){l.setSelectedItem(l.getItems()[0]);}}}else{this._aKeyFields.forEach(function(K,z){if(K.isDefault){l.setSelectedItem(l.getItems()[z]);}},this);}}}}if(m["ID"]==="operation"){l=new sap.m.Select({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new sap.ui.layout.GridData({span:m["Span"+this._sConditionType]})});l.attachChange(function(){i._handleChangeOnOperationField(t,j);});j[m["ID"]]=l;this._updateOperationItems(t,j);if(o){var K=this._getCurrentKeyFieldItem(j.keyField);var s=this._oTypeOperations["default"];if(K){if(K.type&&this._oTypeOperations[K.type]){s=this._oTypeOperations[K.type];}if(K.operations){s=K.operations;}}s.some(function(z,E){if(o.operation===z){l.setSelectedKey(z);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&k===null){var h=t.getContent()[p-1];l.setSelectedKey(h.operation.getSelectedKey());}}}}if(l.getSelectedItem&&l.getSelectedItem()){l.setTooltip(l.getSelectedItem().getTooltip()||l.getSelectedItem().getText());}break;case"TextField":var u=this._getCurrentKeyFieldItem(j.keyField);l=this._createValueField(u,m,j);l.oTargetGrid=t;if(o&&o[m["ID"]]!==undefined){var v=o[m["ID"]];var w;if(l instanceof sap.m.Select){if(typeof v==="string"&&u.type==="boolean"){v=v==="true";}if(typeof v==="boolean"){l.setSelectedIndex(v?2:1);}else{l.setSelectedItem(l.getItemByKey(v.toString()));}}else{if(typeof v==="string"&&j.oFormatter instanceof N){w=parseFloat(v);v=j.oFormatter.format(w);}if(typeof v==="string"&&j.oFormatter){w=j.oFormatter.parse(v);}else{w=v;}if(!isNaN(w)&&w!==null&&j.oFormatter){v=j.oFormatter.format(w);l.setValue(v);}else{if(!w&&v&&j.oFormatter instanceof D){w=new Date(v);v=j.oFormatter.format(w);l.setValue(v);}else{l.setValue(w);}}}}break;case"Label":l=new sap.m.Label({text:m["Text"]+":",visible:this.getShowLabel(),layoutData:new sap.ui.layout.GridData({span:m["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");l.oTargetGrid=t;break;}j[m["ID"]]=l;j.addContent(l);}g=new sap.ui.layout.HorizontalLayout({layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");j.addContent(g);j["ButtonContainer"]=g;var x=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("sys-cancel"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){i._handleRemoveCondition(this.oTargetGrid,j);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});x.oTargetGrid=t;g.addContent(x);j["remove"]=x;var A=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){i._handleAddCondition(this.oTargetGrid,j);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});A.oTargetGrid=t;A.addStyleClass("conditionAddBtnFloatRight");g.addContent(A);j["add"]=A;t.insertContent(j,p);this._updateOperationItems(t,j);this._changeOperationValueFields(t,j);this._updateAllConditionsEnableStates();this._updateConditionButtons(t);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(o){var y=this._getFormatedConditionText(o.operation,o.value1,o.value2,o.exclude,o.keyField,o.showIfGrouped);o._oGrid=j;o.value=y;this._oConditionsMap[k]=o;}return j;};
P.prototype._handleRemoveCondition=function(t,o){var i=t.getContent().indexOf(o);this._removeCondition(t,o);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(i>=0){i=Math.min(i,t.getContent().length-1);var o=t.getContent()[i];setTimeout(function(){o.remove.focus();});}this._updatePaginatorToolbar();};
P.prototype._handleAddCondition=function(t,s){var p=t.getContent().indexOf(s);var o=this._createConditionRow(t,undefined,null,p+1);this._changeField(o);setTimeout(function(){o.keyField.focus();});this._updatePaginatorToolbar();};
P.prototype._getCurrentKeyFieldItem=function(k){if(k.getSelectedKey&&k.getSelectedKey()){var K=k.getSelectedKey();var i=this._aKeyFields;for(var g in i){var o=i[g];if(o.key===K){return o;}}}return null;};
P.prototype._createValueField=function(o,F,g){var h;var s=o?o.type:"";var t=this;var p={value:F["Value"],width:"100%",placeholder:F["Label"],change:function(E){t._validateFormatFieldValue(E);t._changeField(g);},layoutData:new sap.ui.layout.GridData({span:F["Span"+this._sConditionType]})};switch(s){case"boolean":case"enum":var j=[];var v=o.values||this._oTypeValues[s]||["",false,true];v.forEach(function(i,m){j.push(new e({key:s==="boolean"?(m===v.length-1).toString():i.toString(),text:i.toString()}));});p={width:"100%",items:j,change:function(){t._changeField(g);},layoutData:new sap.ui.layout.GridData({span:F["Span"+this._sConditionType]})};g.oFormatter=null;h=new sap.m.Select(p);break;case"numeric":var k;if(o.precision||o.scale){k={};if(o.precision){k["maxIntegerDigits"]=parseInt(o.precision,10);}if(o.scale){k["maxFractionDigits"]=parseInt(o.scale,10);}}g.oFormatter=N.getFloatInstance(k);h=new sap.m.Input(p);break;case"date":g.oFormatter=D.getDateInstance(q.extend({},o.formatSettings,{strictParsing:true}));if(o.formatSettings&&o.formatSettings.style){p.displayFormat=o.formatSettings.style;}h=new sap.m.DatePicker(p);break;case"time":g.oFormatter=D.getTimeInstance(q.extend({},o.formatSettings,{strictParsing:true}));h=new sap.m.TimePicker(p);break;case"datetime":g.oFormatter=D.getDateTimeInstance(q.extend({},o.formatSettings,{strictParsing:true}));if(o.formatSettings&&o.formatSettings.style){p.displayFormat=o.formatSettings.style;}h=new sap.m.DateTimePicker(p);break;case"stringdate":g.oFormatter=new sap.m.P13nConditionStringDateFormatter(q.extend({},o.formatSettings,{strictParsing:true}));if(o.formatSettings&&o.formatSettings.style){p.displayFormat=o.formatSettings.style;}h=new sap.m.DatePicker(p);break;default:if(s=="numc"){g.oFormatter={format:function(i){return this.oType.formatValue(i,"string");},parse:function(i){try{this.oType.validateValue(i,"string");}catch(m){return NaN;}return this.oType.parseValue(i,"string");},oType:new sap.ui.model.odata.type.String({},o.formatSettings)};}else{g.oFormatter=null;}h=new sap.m.Input(p);if(this._fSuggestCallback){var o=this._getCurrentKeyFieldItem(g.keyField);if(o&&o.key){var S=this._fSuggestCallback(h,o.key);if(S){h._oSuggestProvider=S;}}}}if(s!=="boolean"&&s!=="enum"){h.onpaste=function(E){var m;if(window.clipboardData){m=window.clipboardData.getData("Text");}else{m=E.originalEvent.clipboardData.getData('text/plain');}var g=E.srcControl.getParent();var n=m.split(/\r\n|\r|\n/g);var r=g.operation;var u=r.getSelectedKey();if(n&&n.length>1&&u!=="BT"){setTimeout(function(){var L=n?n.length:0;var K=t._getCurrentKeyFieldItem(g.keyField);var r=g.operation;for(var i=0;i<L;i++){if(t._aConditionKeys.length>=t._getMaxConditionsAsNumber()){break;}if(n[i]){var w={"key":t._createConditionKey(),"exclude":t.getExclude(),"operation":r.getSelectedKey(),"keyField":K.key,"value1":n[i],"value2":null};t._addCondition2Map(w);t.fireDataChange({key:w.key,index:w.index,operation:"add",newData:w});}}t._clearConditions();t._fillConditions();},0);}};}if(o&&o.maxLength&&h.setMaxLength){var l=-1;if(typeof o.maxLength==="string"){l=parseInt(o.maxLength,10);}if(typeof o.maxLength==="number"){l=o.maxLength;}if(l>0&&(!h.getShowSuggestion||!h.getShowSuggestion())){h.setMaxLength(l);}}return h;};
P.prototype._fillOperationListItems=function(o,g,t){if(t==="_STRING_"){t="";}if(t==="_TIME_"||t==="_DATETIME_"){t="_DATE_";}if(t==="_BOOLEAN_"||t==="_NUMC_"){t="";}o.destroyItems();for(var i in g){var s=this._oRb.getText("CONDITIONPANEL_OPTION"+t+g[i]);if(q.sap.startsWith(s,"CONDITIONPANEL_OPTION")){s=this._oRb.getText("CONDITIONPANEL_OPTION"+g[i]);}o.addItem(new sap.ui.core.ListItem({key:g[i],text:s,tooltip:s}));}};
P.prototype._fillKeyFieldListItems=function(o,i){o.destroyItems();for(var g in i){var h=i[g];o.addItem(new sap.ui.core.ListItem({key:h.key,text:h.text,tooltip:h.tooltip?h.tooltip:h.text}));}o.setEditable(o.getItems().length>1);};
P.prototype._handleChangeOnOperationField=function(t,o){this._changeOperationValueFields(t,o);this._changeField(o);};
P.prototype._handleSelectionChangeOnKeyField=function(t,o){if(this._sConditionType==="Filter"){this._updateOperationItems(t,o);this._createAndUpdateValueFields(t,o);this._changeOperationValueFields(t,o);}this._changeField(o);};
P.prototype._handleChangeOnKeyField=function(t,o){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false,false,o.keyField);}};
P.prototype._createAndUpdateAllKeyFields=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(o){this._createAndUpdateValueFields(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};
P.prototype._createAndUpdateValueFields=function(t,o){var g=this._getCurrentKeyFieldItem(o.keyField);var h=function(o,i,j){var s=i.getValue?i.getValue():"";var k=o.indexOfContent(i);o.removeContent(i);if(i._oSuggestProvider){i._oSuggestProvider.destroy();i._oSuggestProvider=null;}i.destroy();var l=this._aConditionsFields[j];i=this._createValueField(g,l,o);o[l["ID"]]=i;o.insertContent(i,k===-1?0:k);var v,m;if(o.oFormatter&&s){v=o.oFormatter.parse(s);if(!isNaN(v)&&v!==null){m=o.oFormatter.format(v);i.setValue(m);}}if(!m&&!o.oFormatter&&s){i.setValue(s);}};q.proxy(h,this)(o,o.value1,5);q.proxy(h,this)(o,o.value2,6);};
P.prototype._updateAllOperations=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(o){this._updateOperationItems(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};
P.prototype._updateOperationItems=function(t,o){var s="";var k=this._getCurrentKeyFieldItem(o.keyField);var g=o.operation;var h=this._oTypeOperations["default"];var i=g.getSelectedItem();if(k&&!this.getExclude()){if(k.type&&k.type!==""&&this._oTypeOperations[k.type]){s=k.type;h=this._oTypeOperations[s];}if(k.operations){h=k.operations;}}this._fillOperationListItems(g,h,s?"_"+s.toUpperCase()+"_":"");if(i&&g.getItemByKey(i.getKey())){g.setSelectedKey(i.getKey());}else{g.setSelectedItem(g.getItems()[0]);}this._sConditionType="Filter";if(h[0]===sap.m.P13nConditionOperation.Ascending||h[0]===sap.m.P13nConditionOperation.Descending){this._sConditionType="Sort";}if(h[0]===sap.m.P13nConditionOperation.GroupAscending||h[0]===sap.m.P13nConditionOperation.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(o);};
P.prototype._updateKeyFieldItems=function(t,F,A,o){var n=t.getContent().length;var i;var u={};if(!F){for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var K=k.getSelectedKey();if(K!=null&&K!==""){u[K]=true;}}}for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var s=t.getContent()[i].select;var g=k.getSelectedKey();var j=0;var h=this._aKeyFields;if(k!==o){if(A){j=h.length-1;}else{k.destroyItems();}for(j;j<h.length;j++){var l=h[j];if(l.key==null||l.key===""||!u[l.key]||l.key===g){k.addItem(new sap.ui.core.ListItem({key:l.key,text:l.text,tooltip:l.tooltip?l.tooltip:l.text}));}}k.setEditable(k.getItems().length>1);}if(g){k.setSelectedKey(g);}else if(k.getItems().length>0){k.setSelectedItem(k.getItems()[0]);}if(!s.getSelected()){this._aKeyFields.some(function(m,p){if(m.isDefault){k.setSelectedItem(k.getItems()[p]);return true;}if(!k.getSelectedItem()){if(m.type!=="boolean"){k.setSelectedItem(k.getItems()[p]);}}},this);}if(k.getSelectedItem()){k.setTooltip(k.getSelectedItem().getTooltip()||k.getSelectedItem().getText());}}};
P.prototype._changeOperationValueFields=function(t,o){var g=o.operation;var s=g.getSelectedKey();var v=o.value1;var h=o.value2;var S=o.showIfGrouped;if(!s){return;}if(s===sap.m.P13nConditionOperation.BT){if(v.setPlaceholder&&v.getPlaceholder()!==this._sFromLabelText){v.setPlaceholder(this._sFromLabelText);}if(!v.getVisible()){v.setVisible(true);o.insertContent(v,o.getContent().length-1);}if(h.setPlaceholder&&h.getPlaceholder()!==this._sToLabelText){h.setPlaceholder(this._sToLabelText);}if(!h.getVisible()){h.setVisible(true);o.insertContent(h,o.getContent().length-1);}}else{if(s===sap.m.P13nConditionOperation.GroupAscending||s===sap.m.P13nConditionOperation.GroupDescending){if(v.getVisible()){v.setVisible(false);o.removeContent(v);}if(h.getVisible()){h.setVisible(false);o.removeContent(h);}if(g.getVisible()){g.setVisible(false);o.removeContent(g);}S.setVisible(this._getMaxConditionsAsNumber()!=1);}else{if(s===sap.m.P13nConditionOperation.NotEmpty||s===sap.m.P13nConditionOperation.Empty||s===sap.m.P13nConditionOperation.Initial||s===sap.m.P13nConditionOperation.Ascending||s===sap.m.P13nConditionOperation.Descending||s===sap.m.P13nConditionOperation.Total||s===sap.m.P13nConditionOperation.Average||s===sap.m.P13nConditionOperation.Minimum||s===sap.m.P13nConditionOperation.Maximum){if(v.getVisible()){v.setVisible(false);o.removeContent(v);}if(h.getVisible()){h.setVisible(false);o.removeContent(h);}o.removeContent(S);}else{if(v.setPlaceholder&&v.getPlaceholder()!==this._sValueLabelText){v.setPlaceholder(this._sValueLabelText);}if(!v.getVisible()){v.setVisible(true);o.insertContent(v,o.getContent().length-1);}if(h.getVisible()){h.setVisible(false);o.removeContent(h);}}}}this._adjustValue1Span(o);};
P.prototype._adjustValue1Span=function(o){if(this._sConditionType==="Filter"&&o.value1&&o.operation){var g=o.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(g.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=o.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};
P.prototype._getIndexOfCondition=function(o){var i=-1;o.getParent().getContent().some(function(g){if(g.select.getSelected()){i++;}return(g===o);},this);return i+this._iFirstConditionIndex;};
P.prototype._makeFieldValid=function(o,v){if(v){o.setValueState(V.None);o.setValueStateText("");}else{o.setValueState(V.Warning);o.setValueStateText(this._sValidationDialogFieldMessage);}};
P.prototype._validateFormatFieldValue=function(E){var o=E.oSource;var g=o.getParent();var v;if(o.getDateValue&&E){v=E.getParameter("value");var h=E.getParameter("valid");this._makeFieldValid(o,h);return;}else{v=o.getValue&&o.getValue();}if(!g){return;}if(this.getDisplayFormat()==="UpperCase"&&v){v=v.toUpperCase();o.setValue(v);}if(g.oFormatter&&v){var i=g.oFormatter.parse(v);var h=!isNaN(i)&&i!==null;this._makeFieldValid(o,h);if(h){v=g.oFormatter.format(i);o.setValue(v);}}else{this._makeFieldValid(o,true);}};
P.prototype._changeField=function(o,E){var k=o.keyField.getSelectedKey();if(o.keyField.getSelectedItem()){o.keyField.setTooltip(o.keyField.getSelectedItem().getTooltip()||o.keyField.getSelectedItem().getText());}else{o.keyField.setTooltip(null);}var s=o.operation.getSelectedKey();if(o.operation.getSelectedItem()){o.operation.setTooltip(o.operation.getSelectedItem().getTooltip()||o.operation.getSelectedItem().getText());}else{o.operation.setTooltip(null);}var v=this._getValueTextFromField(o.value1,o.oFormatter);var g=v;if(o.oFormatter&&v){g=o.oFormatter.parse(v);if(isNaN(g)||g===null){v="";}}if(s==="BT"&&o.value1.setMinDate){if(o.value2&&o.value2.setMinDate){o.value2.setMinDate(g instanceof Date?g:null);}}var h=this._getValueTextFromField(o.value2,o.oFormatter);var i=h;if(o.oFormatter&&h){i=o.oFormatter.parse(h);if(isNaN(i)||i===null){h="";}}var j=this._getCurrentKeyFieldItem(o.keyField);var l=j?j.type:"";if(l==="boolean"){var m=j.values||this._oTypeValues[l]||["",false,true];var t=m[m.length-1].toString();g=v===t;i=null;}if(j&&j.type==="numc"){if([sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.EndsWith].indexOf(s)!=-1){g=o.oFormatter.format(g);}}var S=o.showIfGrouped.getSelected();var n=this.getExclude();var p=o.select;var r="";var K;if(k===""||k==null){k=null;K=this._getKeyFromConditionGrid(o);this._removeConditionFromMap(K);this._enableCondition(o,false);var u=this._getIndexOfCondition(o);if(p.getSelected()){p.setSelected(false);p.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:u,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(o,true);r=this._getFormatedConditionText(s,v,h,n,k,S);var w={"value":r,"exclude":n,"operation":s,"keyField":k,"value1":g,"value2":s===sap.m.P13nConditionOperation.BT?i:null,"showIfGrouped":S};K=this._getKeyFromConditionGrid(o);if(r!==""){p.setSelected(true);p.setEnabled(true);var s="update";if(!this._oConditionsMap[K]){s="add";}this._oConditionsMap[K]=w;if(s==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(o),0,K);}o.data("_key",K);this.fireDataChange({key:K,index:this._getIndexOfCondition(o),operation:s,newData:w});}else if(this._oConditionsMap[K]!==undefined){this._removeConditionFromMap(K);o.data("_key",null);var u=this._getIndexOfCondition(o);if(p.getSelected()){p.setSelected(false);p.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:u,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};
P.prototype._getValueTextFromField=function(o,F){if(o.getDateValue&&o.getDateValue()){return F.format(o.getDateValue());}if(o instanceof sap.m.Select){return o.getSelectedItem()?o.getSelectedItem().getText():"";}return o.getValue();};
P.prototype._updateAllConditionsEnableStates=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(o){var k=this._getCurrentKeyFieldItem(o.keyField);var K=k&&k.key!==undefined?k.key:k;var E=K!==""&&K!==null;this._enableCondition(o,E);},this);};
P.prototype._enableCondition=function(o,E){o.operation.setEnabled(E);o.value1.setEnabled(E);o.value2.setEnabled(E);o.showIfGrouped.setEnabled(E);};
P.prototype._removeCondition=function(t,o){var k=this._getKeyFromConditionGrid(o);var i=-1;if(o.select.getSelected()){i=this._getIndexOfCondition(o);}this._removeConditionFromMap(k);o.destroy();if(t.getContent().length<1){this._createConditionRow(t);}else{this._updateConditionButtons(t);}if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}};
P.prototype._updateConditionButtons=function(t){var m=this._getMaxConditionsAsNumber();var n=t.getContent().length;for(var i=0;i<n;i++){var A=t.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<m))||(i===n-1&&i<m-1)){A.removeStyleClass("displayNone");}else{A.addStyleClass("displayNone");}var r=t.getContent()[i].remove;if(m===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){r.addStyleClass("displayNone");}else{r.removeStyleClass("displayNone");}}};
P.prototype.validateConditions=function(){var t=this;var g=function(h){var v=true;for(var i=0;i<h.length;i++){var o=h[i];var j=t._checkCondition(o,i===h.length-1);v=v&&j;}return v;};return g(this._oConditionsGrid.getContent());};
P.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(o){var v=o.value1;var g=o.value2;v.setValueState(V.None);v.setValueStateText("");g.setValueState(V.None);g.setValueStateText("");},this);};
P.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(o){if(o.value1.getValueState()!==V.None||o.value2.getValueState()!==V.None){i.push(o);}},this);i.forEach(function(o){this._removeCondition(this._oConditionsGrid,o);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};
P.prototype._checkCondition=function(o,i){var v=true;var g=o.value1;var h=o.value2;var j=g&&(g.getVisible()&&!this._getValueTextFromField(g,o.oFormatter));var k=g&&g.getVisible()&&g.getValueState?g.getValueState():V.None;var l=h&&(h.getVisible()&&!this._getValueTextFromField(h,o.oFormatter));var m=h&&h.getVisible()&&h.getValueState?h.getValueState():V.None;var s=o.operation.getSelectedKey();if(s===sap.m.P13nConditionOperation.BT){if(!j?l:!l){if(j){g.setValueState(V.Warning);g.setValueStateText(this._sValidationDialogFieldMessage);}if(l){h.setValueState(V.Warning);h.setValueStateText(this._sValidationDialogFieldMessage);}v=false;}else if(k!==V.None||m!==V.None){v=false;}else{g.setValueState(V.None);g.setValueStateText("");h.setValueState(V.None);h.setValueStateText("");}}if((g.getVisible()&&g.getValueState&&g.getValueState()!==V.None)||(h.getVisible()&&h.getValueState&&h.getValueState()!==V.None)){v=false;}return v;};
P.prototype._getFormatedConditionText=function(o,v,s,E,k,S){var g="";var K=null;if(this._aKeyFields&&this._aKeyFields.length>1){for(var i=0;i<this._aKeyFields.length;i++){var h=this._aKeyFields[i];if(typeof h!=="string"){if(h.key===k&&h.text){K=h.text;}}}}switch(o){case sap.m.P13nConditionOperation.EQ:if(v!==""&&v!==undefined){g="="+v;}break;case sap.m.P13nConditionOperation.GT:if(v!==""&&v!==undefined){g=">"+v;}break;case sap.m.P13nConditionOperation.GE:if(v!==""&&v!==undefined){g=">="+v;}break;case sap.m.P13nConditionOperation.LT:if(v!==""&&v!==undefined){g="<"+v;}break;case sap.m.P13nConditionOperation.LE:if(v!==""&&v!==undefined){g="<="+v;}break;case sap.m.P13nConditionOperation.Contains:if(v!==""&&v!==undefined){g="*"+v+"*";}break;case sap.m.P13nConditionOperation.StartsWith:if(v!==""&&v!==undefined){g=v+"*";}break;case sap.m.P13nConditionOperation.EndsWith:if(v!==""&&v!==undefined){g="*"+v;}break;case sap.m.P13nConditionOperation.BT:if(v!==""&&v!==undefined){if(s!==""){g=v+"..."+s;}}break;case sap.m.P13nConditionOperation.Initial:g="=''";break;case sap.m.P13nConditionOperation.Empty:g="''";break;case sap.m.P13nConditionOperation.NotEmpty:g="!''";break;case sap.m.P13nConditionOperation.Ascending:g="ascending";break;case sap.m.P13nConditionOperation.GroupAscending:g="ascending";g+=" showIfGrouped:"+S;break;case sap.m.P13nConditionOperation.Descending:g="descending";break;case sap.m.P13nConditionOperation.GroupDescending:g="descending";g+=" showIfGrouped:"+S;break;case sap.m.P13nConditionOperation.Total:g="total";break;case sap.m.P13nConditionOperation.Average:g="average";break;case sap.m.P13nConditionOperation.Minimum:g="minimum";break;case sap.m.P13nConditionOperation.Maximum:g="maximum";break;}if(E&&g!==""){g="!("+g+")";}if(K&&g!==""){g=K+": "+g;}return g;};
P.prototype._updateLayout=function(r){if(!this._oConditionsGrid){return;}var g=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var h=n;if(r.name==="Tablet"){h=5;}if(r.name==="Phone"){h=3;}if(this._sConditionType==="Filter"){for(var i=0;i<g.length;i++){var j=g[i];j.ButtonContainer.removeStyleClass("floatRight");j.removeContent(j.ButtonContainer);j.insertContent(j.ButtonContainer,h);if(!this.getAlwaysShowAddIcon()){if(h!==n){j.ButtonContainer.removeContent(j.add);j.addContent(j.add);}else{j.removeContent(j.add);j.ButtonContainer.addContent(j.add);}}}}};
P.prototype._onGridResize=function(){if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var g=this._oConditionsGrid.getContent()[0];if(g.remove&&g.remove.$().position()){var w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var t=g.remove.$().position().left-w+g.remove.$().width();this._oPaginatorToolbar.setWidth(t+"px");}}var h=this._oConditionsGrid.getDomRef();if(!h){return;}if(!q(h).is(":visible")){return;}var w=h.clientWidth;var r={};if(w<=this._iBreakPointTablet){r.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){r.name="Tablet";}else{r.name="Desktop";}if(r.name==="Phone"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Tablet"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Desktop"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}};
sap.m.P13nConditionOperation={BT:"BT",EQ:"EQ",Contains:"Contains",StartsWith:"StartsWith",EndsWith:"EndsWith",LT:"LT",LE:"LE",GT:"GT",GE:"GE",Initial:"Initial",Empty:"Empty",NotEmpty:"NotEmpty",Ascending:"Ascending",Descending:"Descending",GroupAscending:"GroupAscending",GroupDescending:"GroupDescending",Total:"Total",Average:"Average",Minimum:"Minimum",Maximum:"Maximum"};
sap.m.P13nConditionStringDateFormatter=function(F){F=q.extend({},F,{UTC:false});this.parseFormatter=D.getDateInstance({UTC:false,pattern:"yyyyMMdd"});this.displayFormatter=D.getDateInstance(F);this.format=function(v){if(v===null||v===undefined||v==""){return null;}if(!(v instanceof Date)){v=this.parseFormatter.parse(v);}return this.displayFormatter.format(v);};this.parse=function(v){if(v!=null&&v!=""){var o=this.parseFormatter.parse(v,true);if(o){v=this.parseFormatter.format(o);return v;}}return null;};};
return P;});
sap.ui.predefine('sap/m/P13nDialog',['jquery.sap.global','./Dialog','./library','sap/ui/core/EnabledPropagator','sap/m/DialogRenderer','sap/ui/core/library','sap/ui/Device'],function(q,D,l,E,a,c,b){"use strict";var O=l.OverflowToolbarPriority;var L=l.ListType;var P=l.P13nPanelType;var d=l.ListMode;var M=c.MessageType;var B=l.ButtonType;
var e=D.extend("sap.m.P13nDialog",{
metadata:{library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},
renderer:function(r,C){a.render.apply(this,arguments);var i=C._getVisiblePanelID();var p=C.getVisiblePanel();if(i&&p){r.write("<div");r.writeAttribute("id",i);r.write(">");r.renderControl(p);r.write("</div>");}}
});
E.apply(e.prototype,[true]);
e.prototype.init=function(o){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._mValidationListener={};this._mVisibleNavigationItems={};this._createDialog();};
e.prototype.setShowReset=function(s){this.setProperty("showReset",s);if(this.getButtons()&&this.getButtons()[2]){this.getButtons()[2].setVisible(s);}return this;};
e.prototype.setShowResetEnabled=function(f){this.setProperty("showResetEnabled",f,true);if(this.getButtons()&&this.getButtons()[2]){this.getButtons()[2].setEnabled(f);}return this;};
e.prototype.addPanel=function(p){this.addAggregation("panels",p);this._mVisibleNavigationItems[p.getType()]=p.getVisible();p.beforeNavigationTo();p.setValidationExecutor(q.proxy(this._callValidationExecutor,this));p.setValidationListener(q.proxy(this._registerValidationListener,this));p.setChangeNotifier(q.proxy(this._callChangeNotifier,this));this._updateDialog();return this;};
e.prototype.insertPanel=function(p,i){this.insertAggregation("panels",p,i);this._mVisibleNavigationItems[p.getType()]=p.getVisible();p.beforeNavigationTo();p.setValidationExecutor(q.proxy(this._callValidationExecutor,this));p.setValidationListener(q.proxy(this._registerValidationListener,this));p.setChangeNotifier(q.proxy(this._callChangeNotifier,this));this._updateDialog();return this;};
e.prototype.removePanel=function(p){p=this.removeAggregation("panels",p);delete this._mVisibleNavigationItems[p.getType()];p.setValidationExecutor();p.setValidationListener();p.setChangeNotifier();var n=this._getNavigationControl();if(n){b.system.phone?n.removeItem(p&&this._getNavigationItemByPanel(p)):n.removeItem(p&&this._getNavigationItemByPanel(p));}this._updateDialog();return p;};
e.prototype.removeAllPanels=function(){var p=this.removeAllAggregation("panels");this._mVisibleNavigationItems={};var n=this._getNavigationControl();if(n){b.system.phone?n.removeAllItems():n.removeAllItems();}return p;};
e.prototype.destroyPanels=function(){this.destroyAggregation("panels");this._mVisibleNavigationItems={};var n=this._getNavigationControl();if(n){b.system.phone?n.destroyItems():n.destroyItems();}return this;};
e.prototype._createDialog=function(){if(b.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new sap.m.Bar({contentLeft:new sap.m.Button({visible:false,type:B.Back,press:function(o){t._backToList();}}),contentMiddle:new sap.m.Title({text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H1"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};
e.prototype._showValidationDialog=function(C,f,v){var w=[];var g=[];this._prepareMessages(f,v,w,g);q.sap.require("sap.m.MessageBox");var m="";if(g.length){g.forEach(function(o,i,h){m=(h.length>1?"• ":"")+o.messageText+"\n"+m;});sap.m.MessageBox.show(m,{icon:sap.m.MessageBox.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[sap.m.MessageBox.Action.CLOSE],styleClass:!!this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}else if(w.length){w.forEach(function(o,i,h){m=(h.length>1?"• ":"")+o.messageText+"\n"+m;});m=m+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");sap.m.MessageBox.show(m,{icon:sap.m.MessageBox.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),sap.m.MessageBox.Action.IGNORE],onClose:function(A){if(A===sap.m.MessageBox.Action.IGNORE){C();}},styleClass:!!this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}};
e.prototype._prepareMessages=function(f,v,w,g){if(!f.length&&!v.length){return;}f.forEach(function(p){switch(p){case P.filter:v.push({messageType:M.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case P.columns:v.push({messageType:M.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;case P.dimeasure:v.push({messageType:M.Error,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_CHARTTYPE")});break;default:q.sap.log.error("Panel type '"+p+"' is not supported jet.");}});var u=v.filter(function(m,I,h){for(var i=++I;i<h.length;i++){if(m.messageText===h[i].messageText){return false;}}return true;});u.forEach(function(m){if(m.messageType===M.Warning){w.push(m);}else if(m.messageType===M.Error){g.push(m);}});};
e.prototype._mapPanelToNavigationItem=function(p){if(!p){return null;}return b.system.phone?new sap.m.StandardListItem({type:L.Navigation,title:p.getBindingPath("title")?q.extend(true,{},p.getBindingInfo("title")):p.getTitle()}):new sap.m.SegmentedButtonItem({text:p.getBindingPath("title")?q.extend(true,{},p.getBindingInfo("title")):p.getTitle()});};
e.prototype._switchPanel=function(n){var p=this._getPanelByNavigationItem(n);this.setVerticalScrolling(p.getVerticalScrolling());if(b.system.phone){var N=this._getNavigationControl();if(N){N.setVisible(false);p.beforeNavigationTo();p.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(p.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(o){if(o===p){o.beforeNavigationTo();o.setVisible(true);}else{o.setVisible(false);}},this);}this.invalidate();this.rerender();};
e.prototype._backToList=function(){var n=this._getNavigationControl();if(n){n.setVisible(true);var p=this.getVisiblePanel();p.setVisible(false);this._updateDialogTitle();this.getCustomHeader().getContentLeft()[0].setVisible(false);}};
e.prototype.getVisiblePanel=function(){var p=null;this.getPanels().some(function(o){if(o.getVisible()){p=o;return true;}});return p;};
e.prototype._getPanelByNavigationItem=function(n){for(var i=0,p=this.getPanels(),f=p.length;i<f;i++){if(p[i].data("sapMP13nDialogNavigationItem")===n){return p[i];}}return null;};
e.prototype._getNavigationItemByPanel=function(p){if(!p){return null;}return p.data("sapMP13nDialogNavigationItem");};
e.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var C=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&C){var p=q.find("#"+i);q(p).appendTo(q(C));}};
e.prototype._getVisiblePanelID=function(){var p=this.getVisiblePanel();if(p){return this.getId()+"-panel_"+p.getId();}return null;};
e.prototype._updateDialogTitle=function(){var p=this.getVisiblePanel();var t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");if(!this._isNavigationControlExpected()&&p){switch(p.getType()){case P.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case P.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case P.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case P.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case P.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=p.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(b.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};
e.prototype._registerValidationListener=function(p,C){if(this.getPanels().indexOf(p)&&C&&this._mValidationListener[p.getType()]===undefined){this._mValidationListener[p.getType()]=C;}};
e.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!q.isEmptyObject(this._mValidationListener)){var t=this;v(this._getPayloadOfPanels()).then(function(V){var r=t._distributeValidationResult(V);for(var T in t._mValidationListener){var C=t._mValidationListener[T];C(r[T]||[]);}});}};
e.prototype._callChangeNotifier=function(p){if(this.getShowReset()){this.setShowResetEnabled(true);}};
e.prototype._distributeValidationResult=function(r){var o={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(o[t]===undefined){o[t]=[];}o[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return o;};
e.prototype._createOKButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow}),press:function(){t.setBusy(true);var p=t._getPayloadOfPanels();var f=function(){t.setBusy(false);t.fireOk({payload:p});};var F=[];var C=function(){t.getPanels().forEach(function(o){if(F.indexOf(o.getType())>-1){o.onAfterNavigationFrom();}});f();};t.getPanels().forEach(function(o){if(!o.onBeforeNavigationFrom()){F.push(o.getType());}});var v=[];var V=t.getValidationExecutor();if(V){V(p).then(function(v){if(F.length||v.length){t.setBusy(false);t._showValidationDialog(C,F,v);}else{f();}});}else{if(F.length||v.length){t.setBusy(false);t._showValidationDialog(C,F,v);}else{f();}}}});};
e.prototype._createCancelButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow}),press:function(){t.fireCancel();}});};
e.prototype._createResetButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){t.setShowResetEnabled(false);var p={};t.getPanels().forEach(function(o){p[o.getType()]=o.getResetPayload();});t.fireReset({payload:p});}});};
e.prototype._getPayloadOfPanels=function(){var p={};this.getPanels().forEach(function(o){p[o.getType()]=o.getOkPayload();});return p;};
e.prototype._updateDialog=function(){var n=this._getNavigationControl();n.destroyItems();var i=this._determineInitialVisiblePanelType();this.getPanels().forEach(function(p){var N=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",N);n.addItem(N);var v=b.system.phone?this._mVisibleNavigationItems[p.getType()]&&this._getCountOfVisibleNavigationItems()===1:this._mVisibleNavigationItems[p.getType()]&&i===p.getType();p.setVisible(v);if(v){if(!b.system.phone){this.setVerticalScrolling(p.getVerticalScrolling());}}N.setVisible(this._mVisibleNavigationItems[p.getType()]);if(v&&n.setSelectedItem){n.setSelectedItem(N);}}.bind(this));this._updateDialogTitle();this._setVisibleOfNavigationControl(this._isNavigationControlExpected());};
e.prototype._determineInitialVisiblePanelType=function(){if(this.getInitialVisiblePanelType()&&this._mVisibleNavigationItems[this.getInitialVisiblePanelType()]){return this.getInitialVisiblePanelType();}var t;this.getPanels().some(function(p){if(this._mVisibleNavigationItems[p.getType()]){t=p.getType();return true;}}.bind(this));return t;};
e.prototype._isNavigationControlExpected=function(){return this._getCountOfVisibleNavigationItems()>1;};
e.prototype._getCountOfVisibleNavigationItems=function(){var C=0;for(var t in this._mVisibleNavigationItems){C=this._mVisibleNavigationItems[t]?C+1:C;}return C;};
e.prototype._isNavigationControlExists=function(){return b.system.phone?this.getContent().length>0:(!!this.getSubHeader()&&this.getSubHeader().getContentLeft().length>0);};
e.prototype._getNavigationControl=function(){if(!this._isNavigationControlExists()){this._createNavigationControl();}return b.system.phone?this.getContent()[0]:this.getSubHeader().getContentLeft()[0];};
e.prototype._setVisibleOfNavigationControl=function(v){if(!this._isNavigationControlExists()){return;}return b.system.phone?this.getContent()[0].setVisible(v):this.getSubHeader().setVisible(v);};
e.prototype._createNavigationControl=function(){if(b.system.phone){this.addContent(new sap.m.List({mode:d.None,itemPress:function(o){this._switchPanel(o.getParameter("listItem"));}.bind(this)}));}else{this.setSubHeader(new sap.m.Bar({contentLeft:new sap.m.SegmentedButton({width:'100%',selectionChange:function(o){this._switchPanel(o.getParameter("item"));}.bind(this)})}));}return this._getNavigationControl();};
e.prototype.exit=function(){D.prototype.exit.apply(this,arguments);this._mValidationListener={};this._mVisibleNavigationItems={};};
return e;});
sap.ui.predefine('sap/m/P13nDimMeasureItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nDimMeasureItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string"},index:{type:"int",defaultValue:-1},visible:{type:"boolean"},role:{type:"string"}}}});
return P;});
sap.ui.predefine('sap/m/P13nDimMeasurePanel',['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nDimMeasureItem','./SearchField','./Table','./library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/m/ScrollContainer'],function(q,C,P,c,S,T,l,d,J,B,R,I,e,f,g){"use strict";var O=l.OverflowToolbarPriority;var h=l.ButtonType;var i=l.ToolbarDesign;var L=l.ListType;var j=l.ListMode;var k=l.P13nPanelType;
var m=P.extend("sap.m.P13nDimMeasurePanel",{
metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{dimMeasureItems:{type:"sap.m.P13nDimMeasureItem",multiple:true,singularName:"dimMeasureItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}},events:{changeDimMeasureItems:{},changeChartType:{}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}
});
m.prototype.init=function(){var t=this;this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.oAvailableRoleTypes={Dimension:[{key:"category",text:r.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"category2",text:r.getText('COLUMNSPANEL_CHARTROLE_CATEGORY2')},{key:"series",text:r.getText('COLUMNSPANEL_CHARTROLE_SERIES')}],Measure:[{key:"axis1",text:r.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:r.getText('COLUMNSPANEL_CHARTROLE_AXIS2')},{key:"axis3",text:r.getText('COLUMNSPANEL_CHARTROLE_AXIS3')},{key:"axis4",text:r.getText('COLUMNSPANEL_CHARTROLE_AXIS4')}]};var M=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(B.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nDimMeasurePanel");this.setType(k.dimeasure);this.setTitle(r.getText("CHARTPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new g({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);this._fnHandleResize=function(){var b=false,a,n;if(t.getParent){var $=null,o,H;var p=t.getParent();var u=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&u.$().length>0){a=s.$()[0].clientHeight;o=$.children()[0].clientHeight;H=u?u.$()[0].clientHeight:0;n=o-H;if(a!==n){s.setHeight(n+'px');b=true;}}}}return b;};this._sContainerResizeListener=R.register(s,this._fnHandleResize);};
m.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
m.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();t._getToolbar()._resetAndInvalidateToolbar();},0);}};
m.prototype.getOkPayload=function(){this._updateInternalModel();this._getInternalModel().getProperty("/items").forEach(function(M){if(this._getDimMeasureItemByColumnKey(M.columnKey)){return;}if(!M.persistentSelected){return;}this.addAggregation("dimMeasureItems",new c({columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role}));},this);return{dimMeasureItems:this.getDimMeasureItems(),chartTypeKey:this.getChartTypeKey()};};
m.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}if(this.oInvisibleChartTypeText){this.oInvisibleChartTypeText.destroy();this.oInvisibleChartTypeText=null;}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
m.prototype.addItem=function(o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",o);return this;};
m.prototype.insertItem=function(o,a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",o,a);return this;};
m.prototype.removeItem=function(o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}o=this.removeAggregation("items",o);return o;};
m.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
m.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
m.prototype.addDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("dimMeasureItems",D);return this;};
m.prototype.insertDimMeasureItem=function(D,a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("dimMeasureItems",D,a);return this;};
m.prototype.updateDimMeasureItems=function(r){this.updateAggregation("dimMeasureItems");if(r===d.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
m.prototype.removeDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("dimMeasureItems",D);};
m.prototype.removeAllDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("dimMeasureItems");};
m.prototype.destroyDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("dimMeasureItems");return this;};
m.prototype.setChartTypeKey=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.setProperty("chartTypeKey",s);return this;};
m.prototype.addAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("availableChartTypes",a);return this;};
m.prototype.insertAvailableChartType=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("availableChartTypes",a,b);return this;};
m.prototype.removeAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("availableChartTypes",a);};
m.prototype.removeAllAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("availableChartTypes");};
m.prototype.destroyAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("availableChartTypes");return this;};
m.prototype.onBeforeNavigationFrom=function(){var s=this.getChartTypeKey();var D=[];var M=[];this.getDimMeasureItems().forEach(function(o){var a=this._getModelItemByColumnKey(o.getColumnKey());if(!a){return;}if(a.aggregationRole==="Dimension"){D.push(o);}else if(a.aggregationRole==="Measure"){M.push(o);}},this);D=D.filter(function(o){return o.getVisible();}).map(function(o){return{name:o.getColumnKey()};});M=M.filter(function(o){return o.getVisible();}).map(function(o){return{name:o.getColumnKey()};});sap.ui.getCore().loadLibrary("sap.chart");var r;try{r=sap.chart.api.getChartTypeLayout(s,D,M);}catch(E){return false;}return r.errors.length===0;};
m.prototype._notifyChange=function(){var a=this.getChangeNotifier();if(a){a(this);}};
m.prototype._scrollToSelectedItem=function(o){if(!o){return;}sap.ui.getCore().applyChanges();if(!!o.getDomRef()){o.focus();}};
m.prototype._getInternalModel=function(){return this.getModel("$sapmP13nDimMeasurePanel");};
m.prototype._createTable=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTable=new T({mode:j.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(a,b){return r.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[a,b]);}}})}),new sap.m.Column({header:new sap.m.Text({text:r.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new sap.m.Column({header:new sap.m.Text({text:r.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",templateShareable:false,template:new C({cells:[new sap.m.Text({text:"{text}"}),new sap.m.Text({text:{path:'',formatter:function(M){if(M.aggregationRole==="Dimension"){return r.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(M.aggregationRole==="Measure"){return r.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new sap.m.Select({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(s,b){var a=b.getObject();return new I({key:a.key,text:a.text});}},change:q.proxy(this._onRoleChange,this)})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
m.prototype._createToolbar=function(){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=new e({text:r.getText('COLUMNSPANEL_CHARTTYPE')});this.oInvisibleChartTypeText=o;var a=new sap.m.ComboBox({placeholder:o.getText(),selectedKey:{path:'/selectedChartTypeKey'},ariaLabelledBy:o,items:{path:'/availableChartTypes',templateShareable:false,template:new I({key:"{key}",text:"{text}"})},selectionChange:q.proxy(this._onChartTypeChange,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:false,stayInOverflow:false})});var b=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{design:i.Auto,content:[o,a,new sap.m.ToolbarSpacer(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new sap.m.Button({text:{path:'/showOnlySelectedItems',formatter:function(s){return s?r.getText('COLUMNSPANEL_SHOW_ALL'):r.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(s){return s?r.getText('COLUMNSPANEL_SHOW_ALL'):r.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:h.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.High})}),new sap.m.OverflowToolbarButton({icon:f.getIconURI("collapse-group"),text:r.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:r.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:h.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveToTop,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.Low,group:2})}),new sap.m.OverflowToolbarButton({icon:f.getIconURI("slim-arrow-up"),text:r.getText('COLUMNSPANEL_MOVE_UP'),tooltip:r.getText('COLUMNSPANEL_MOVE_UP'),type:h.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveUp,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.High,group:1})}),new sap.m.OverflowToolbarButton({icon:f.getIconURI("slim-arrow-down"),text:r.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:r.getText('COLUMNSPANEL_MOVE_DOWN'),type:h.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveDown,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.High,group:1})}),new sap.m.OverflowToolbarButton({icon:f.getIconURI("expand-group"),text:r.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:r.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:h.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:O.Low,group:2})})]});b.setModel(this._getInternalModel());this.addAggregation("content",b);};
m.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
m.prototype.onPressButtonMoveUp=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())-1]);};
m.prototype.onPressButtonMoveDown=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())+1]);};
m.prototype.onPressButtonMoveToBottom=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.length-1]);};
m.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
m.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
m.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(o){if(o.persistentSelected){o.visible=true;return;}o.visible=!s;});this._getInternalModel().setProperty("/items",M);};
m.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
m.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
m.prototype._moveMarkedTableItem=function(t,o){var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(t));var a=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(o));var b=this._getModelItemIndexByColumnKey(M.columnKey);var n=this._getModelItemIndexByColumnKey(a.columnKey);this._moveModelItems(b,n);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeDimMeasureItems();this._notifyChange();};
m.prototype._moveModelItems=function(a,b){var M=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>M.length-1||b>M.length-1){return false;}this._removeStyleOfMarkedTableItem();var n=M.splice(a,1);M.splice(b,0,n[0]);this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
m.prototype._getModelItemByColumnKey=function(s){var M=this._getInternalModel().getProperty("/items").filter(function(o){return o.columnKey===s;});return M[0];};
m.prototype._updateCounts=function(M){var a=0;var b=0;M.forEach(function(o){a++;if(o.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};
m.prototype._sortModelItemsByPersistentIndex=function(M){M.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};
m.prototype._getColumnKeyByTableItem=function(t){var a=this._oTable.indexOfItem(t);if(a<0){return null;}return this._oTable.getBinding("items").getContexts()[a].getObject().columnKey;};
m.prototype._getModelItemIndexByColumnKey=function(s){var a=-1;this._getInternalModel().getData().items.some(function(M,b){if(M.columnKey===s){a=b;return true;}});return a;};
m.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return M.persistentSelected;});};
m.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(t){return t.getVisible();});};
m.prototype._getTableItemByColumnKey=function(s){var a=this._oTable.getBinding("items").getContexts();var t=this._oTable.getItems().filter(function(o,b){return a[b].getObject().columnKey===s;});return t[0];};
m.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
m.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
m.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
m.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
m.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
m.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",v.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",v.indexOf(this._getMarkedTableItem())>-1&&v.indexOf(this._getMarkedTableItem())<v.length-1);var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!b&&!s);}};
m.prototype._updateModelItemsPersistentIndex=function(M){var p=-1;M.forEach(function(o){o.persistentIndex=-1;if(o.persistentSelected){p++;o.persistentIndex=p;}});};
m.prototype._fireChangeDimMeasureItems=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeDimMeasureItems({items:this._getInternalModel().getProperty("/items").map(function(M){return{columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role};})});this._bIgnoreUpdateInternalModel=false;};
m.prototype._fireChangeChartType=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeChartType({chartTypeKey:this._getInternalModel().getProperty("/selectedChartTypeKey")});this._bIgnoreUpdateInternalModel=false;};
m.prototype._getDimMeasureItemByColumnKey=function(s){var D=this.getDimMeasureItems().filter(function(o){return o.getColumnKey()===s;});return D[0];};
m.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
m.prototype._setColumnKeyOfMarkedItem=function(s){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",s);};
m.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
m.prototype._onChartTypeChange=function(E){this._fireChangeChartType();this._notifyChange();};
m.prototype._onRoleChange=function(E){this._fireChangeDimMeasureItems();this._notifyChange();};
m.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
m.prototype._selectTableItem=function(){this._updateControlLogic();var M=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeDimMeasureItems();this._notifyChange();};
m.prototype._switchMarkedTableItemTo=function(t){this._removeStyleOfMarkedTableItem();var s=this._getColumnKeyByTableItem(t);if(s){this._setColumnKeyOfMarkedItem(s);t.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
m.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
m.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(M){var o=this._getTableItemByColumnKey(M.columnKey);var a=o.getCells();M.visible=false;if(a[0]&&a[0].getText().match(r)){M.visible=true;}if(a[1]&&a[1].getText().match(r)){M.visible=true;}if(a[2]&&a[2].getSelectedItem()&&a[2].getSelectedItem().getText().match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}},this);this._getInternalModel().refresh();};
m.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();this._getInternalModel().setProperty("/items",this.getItems().map(function(o){return{columnKey:o.getColumnKey(),visible:true,text:o.getText(),tooltip:o.getTooltip(),aggregationRole:o.getAggregationRole(),availableRoleTypes:this.oAvailableRoleTypes[o.getAggregationRole()],role:o.getRole(),persistentIndex:-1,persistentSelected:undefined};},this));this._getInternalModel().setProperty("/selectedChartTypeKey",this.getChartTypeKey());this._getInternalModel().setProperty("/availableChartTypes",this.getAvailableChartTypes().map(function(a){return{key:a.getKey(),text:a.getText()};},this));this.getDimMeasureItems().forEach(function(D){var o=this._getModelItemByColumnKey(D.getColumnKey());if(!o){return;}if(D.getIndex()!==undefined){o.persistentIndex=D.getIndex();}if(D.getVisible()!==undefined){o.persistentSelected=D.getVisible();}if(D.getRole()!==undefined){o.role=D.getRole();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());};
return m;});
sap.ui.predefine('sap/m/P13nFilterItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nFilterItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},value1:{type:"string",group:"Misc",defaultValue:null},value2:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},exclude:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setOperation=function(o){return this.setProperty("operation",o,true);};
P.prototype.setColumnKey=function(k){return this.setProperty("columnKey",k,true);};
P.prototype.setValue1=function(k){return this.setProperty("value1",k,true);};
P.prototype.setValue2=function(k){return this.setProperty("value2",k,true);};
P.prototype.setExclude=function(k){return this.setProperty("exclude",k,true);};
return P;});
sap.ui.predefine('sap/m/P13nFilterPanel',['./P13nConditionPanel','./P13nPanel','./library','sap/m/Panel'],function(P,a,l,b){"use strict";var c=l.P13nPanelType;
var d=a.extend("sap.m.P13nFilterPanel",{
metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{}}},
renderer:function(r,C){r.write("<section");r.writeControlData(C);r.addClass("sapMFilterPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMFilterPanelContent");r.addClass("sapMFilterPanelBG");r.writeClasses();r.write(">");var e=C.getAggregation("content");var L=e.length;for(var i=0;i<L;i++){r.renderControl(e[i]);}r.write("</div>");r.write("</section>");}
});
d.prototype.setConditions=function(C){var I=[];var e=[];if(C.length){for(var i=0;i<C.length;i++){var o=C[i];if(!o.exclude){I.push(o);}else{e.push(o);}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(e);if(e.length>0){this._oExcludePanel.setExpanded(true);}return this;};
d.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var e=this._oExcludeFilterPanel.getConditions();return i.concat(e);};
d.prototype.setContainerQuery=function(C){this.setProperty("containerQuery",C);this._oIncludeFilterPanel.setContainerQuery(C);this._oExcludeFilterPanel.setContainerQuery(C);return this;};
d.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m);return this;};
d.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions();};
d.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions();};
d.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors();};
d.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
d.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
d.prototype.setIncludeOperations=function(o,t){t=t||"default";this._aIncludeOperations[t]=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}};
d.prototype.getIncludeOperations=function(t){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations(t);}};
d.prototype.setExcludeOperations=function(o,t){t=t||"default";this._aExcludeOperations[t]=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}};
d.prototype.getExcludeOperations=function(t){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations(t);}};
d.prototype.setKeyFields=function(k){this._aKeyFields=k;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setKeyFields(this._aKeyFields);}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields(this._aKeyFields);}};
d.prototype.getKeyFields=function(){return this._aKeyFields;};
d.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
d.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
d.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes(),10);var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes(),10);if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin");this._oIncludePanel.addStyleClass("panelNoHeader");}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false);this._oExcludePanel.addStyleClass("panelNoHeader");}};
d.prototype.init=function(){this.setType(c.filter);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FILTERPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];this.addStyleClass("sapMFilterPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aIncludeOperations={};if(!this._aIncludeOperations["default"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE]);}if(!this._aIncludeOperations["string"]){this.setIncludeOperations([sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.StartsWith,sap.m.P13nConditionOperation.EndsWith,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"string");}if(!this._aIncludeOperations["date"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"date");}if(!this._aIncludeOperations["time"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"time");}if(!this._aIncludeOperations["datetime"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"datetime");}if(!this._aIncludeOperations["numeric"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"numeric");}if(!this._aIncludeOperations["numc"]){this.setIncludeOperations([sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.EndsWith,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"numc");}if(!this._aIncludeOperations["boolean"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ],"boolean");}this._aExcludeOperations={};if(!this._aExcludeOperations["default"]){this.setExcludeOperations([sap.m.P13nConditionOperation.EQ]);}this._oIncludePanel=new b({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aIncludeOperations){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new b({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aExcludeOperations){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel();};
d.prototype.exit=function(){var e=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=e(this._aKeyFields);this._aIncludeOperations=e(this._aIncludeOperations);this._aExcludeOperations=e(this._aExcludeOperations);this._oRb=e(this._oRb);};
d.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i),maxLength:g("maxLength",o,i),type:g("type",o,i),formatSettings:g("formatSettings",o,i),precision:g("precision",o,i),scale:g("scale",o,i),isDefault:g("isDefault",o,i),values:g("values",o,i)});var n=k.length;if(k[n-1].maxLength===1||k[n-1].maxLength==="1"){k[n-1].operations=[sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE];}});this.setKeyFields(k);var C=[];m=(this.getBindingInfo("filterItems")||{}).model;this.getFilterItems().forEach(function(f){var o=f.getBindingContext(m);if(f.getBinding("key")&&o){o.getObject()[f.getBinding("key").getPath()]=f.getKey();}C.push({key:f.getKey(),keyField:g("columnKey",o,f),operation:g("operation",o,f),value1:g("value1",o,f),value2:g("value2",o,f),exclude:g("exclude",o,f)});});this.setConditions(C);}};
d.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);this._bUpdateRequired=true;return r;};
d.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.addFilterItem=function(f){this.addAggregation("filterItems",f,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.insertFilterItem=function(f,i){this.insertAggregation("filterItems",f,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.updateFilterItems=function(r){this.updateAggregation("filterItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
d.prototype.removeFilterItem=function(f){f=this.removeAggregation("filterItems",f,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return f;};
d.prototype.removeAllFilterItems=function(){var f=this.removeAllAggregation("filterItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return f;};
d.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var C=e.getParameter("index");var f;var I=-1;var E=e.getSource()===t._oExcludeFilterPanel;t.getFilterItems().some(function(g,i){if((!g.getExclude()&&!E)||(g.getExclude()&&E)){C--;}I=i;return C<0;},this);if(o==="update"){f=t.getFilterItems()[I];if(f){f.setExclude(n.exclude);f.setColumnKey(n.keyField);f.setOperation(n.operation);f.setValue1(n.value1);f.setValue2(n.value2);}t.fireUpdateFilterItem({key:k,index:I,filterItemData:f});t._notifyChange();}if(o==="add"){if(C>=0){I++;}f=new sap.m.P13nFilterItem({key:k,columnKey:n.keyField,exclude:n.exclude,operation:n.operation});f.setValue1(n.value1);f.setValue2(n.value2);t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:I,filterItemData:f});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:I});t._bIgnoreBindCalls=false;t._notifyChange();}};};
d.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return d;});
sap.ui.predefine('sap/m/P13nGroupItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nGroupItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},showIfGrouped:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
P.prototype.setShowIfGrouped=function(v){return this.setProperty("showIfGrouped",v,true);};
return P;});
sap.ui.predefine('sap/m/P13nGroupPanel',['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library'],function(q,P,a,l){"use strict";var c=l.P13nPanelType;
var d=a.extend("sap.m.P13nGroupPanel",{
metadata:{library:"sap.m",properties:{maxGroups:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},groupItems:{type:"sap.m.P13nGroupItem",multiple:true,singularName:"groupItem",bindable:"bindable"}},events:{addGroupItem:{parameters:{}},removeGroupItem:{},updateGroupItem:{}}},
renderer:function(r,C){r.write("<section");r.writeControlData(C);r.addClass("sapMGroupPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMGroupPanelContent");r.addClass("sapMGroupPanelBG");r.writeClasses();r.write(">");var b=C.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
d.prototype.setMaxGroups=function(m){this.setProperty("maxGroups",m);if(this._oGroupPanel){this._oGroupPanel.setMaxConditions(m);}};
d.prototype._getConditions=function(){return this._oGroupPanel.getConditions();};
d.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oGroupPanel.setContainerQuery(b);};
d.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oGroupPanel.setLayoutMode(m);};
d.prototype.validateConditions=function(){return this._oGroupPanel.validateConditions();};
d.prototype.removeInvalidConditions=function(){this._oGroupPanel.removeInvalidConditions();};
d.prototype.removeValidationErrors=function(){this._oGroupPanel.removeValidationErrors();};
d.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
d.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
d.prototype.setOperations=function(o){this._aOperations=o;if(this._oGroupPanel){this._oGroupPanel.setOperations(this._aOperations);}};
d.prototype.init=function(){this.setType(c.group);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("GROUPPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];this.addStyleClass("sapMGroupPanel");if(!this._aOperations){this.setOperations([sap.m.P13nConditionOperation.GroupAscending,sap.m.P13nConditionOperation.GroupDescending]);}this._oGroupPanel=new P({maxConditions:this.getMaxGroups(),autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange(),validationExecutor:q.proxy(this._callValidationExecutor,this)});this._oGroupPanel.setOperations(this._aOperations);this._oGroupPanel._sAddRemoveIconTooltipKey="GROUP";this.addAggregation("content",this._oGroupPanel);};
d.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};
d.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var b=i.getBinding(n);if(b&&o){return o.getObject()[b.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oGroupPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("groupItems")||{}).model;this.getGroupItems().forEach(function(G){var o=G.getBindingContext(m);if(G.getBinding("key")){o.getObject()[G.getBinding("key").getPath()]=G.getKey();}C.push({key:G.getKey(),keyField:g("columnKey",o,G),operation:g("operation",o,G),showIfGrouped:g("showIfGrouped",o,G)});});this._oGroupPanel.setConditions(C);}};
d.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
d.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.addGroupItem=function(g){this.addAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.insertGroupItem=function(g,i){this.insertAggregation("groupItems",g,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.updateGroupItems=function(r){this.updateAggregation("groupItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
d.prototype.removeGroupItem=function(g){g=this.removeAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
d.prototype.removeAllGroupItems=function(){var g=this.removeAllAggregation("groupItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
d.prototype.destroyGroupItems=function(){this.destroyAggregation("groupItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var i=e.getParameter("index");var g;if(o==="update"){g=t.getGroupItems()[i];if(g){g.setColumnKey(n.keyField);g.setOperation(n.operation);g.setShowIfGrouped(n.showIfGrouped);}t.fireUpdateGroupItem({key:k,index:i,groupItemData:g});t._notifyChange();}if(o==="add"){g=new sap.m.P13nGroupItem({key:k,columnKey:n.keyField,operation:n.operation,showIfGrouped:n.showIfGrouped});t._bIgnoreBindCalls=true;t.fireAddGroupItem({key:k,index:i,groupItemData:g});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveGroupItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
d.prototype.getOkPayload=function(){if(!this.getModel()){return null;}var s=[];this._oGroupPanel._oConditionsGrid.getContent().forEach(function(C){var o=C.keyField;s.push(o.getSelectedKey());});return{selectedColumnKeys:s};};
d.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v){v();}};
d.prototype._updateValidationResult=function(v){this._oGroupPanel._oConditionsGrid.getContent().forEach(function(C){var o=C.keyField;o.setValueStateText("");o.setValueState("None");var s=o.getSelectedKey();v.forEach(function(r){if(r.columnKey===s){o.setValueStateText(r.messageText);o.setValueState(r.messageType);}});});};
d.prototype.setValidationListener=function(L){this.setProperty("validationListener",L);if(L){L(this,q.proxy(this._updateValidationResult,this));}};
d.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return d;});
sap.ui.predefine('sap/m/P13nItem',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var P=E.extend("sap.m.P13nItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:"text"},precision:{type:"string",group:"Misc",defaultValue:null},formatSettings:{type:"object",group:"Misc",defaultValue:null,since:"1.52"},scale:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"string",group:"Misc",defaultValue:null},width:{type:"string",group:"Misc",defaultValue:null},isDefault:{type:"boolean",group:"Misc",defaultValue:false},values:{type:"string[]",group:"Misc",defaultValue:null},role:{type:"string",defaultValue:null},aggregationRole:{type:"string",defaultValue:null},href:{type:"string",defaultValue:null},target:{type:"string",defaultValue:null},press:{type:"object",defaultValue:null}}}});
return P;});
sap.ui.predefine('sap/m/P13nPanel',['./library','sap/ui/core/Control'],function(l,C){"use strict";
var P=C.extend("sap.m.P13nPanel",{
metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLarge:{type:"string",group:"Appearance",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},validationExecutor:{type:"object",group:"Misc",defaultValue:null},validationListener:{type:"object",group:"Misc",defaultValue:null},changeNotifier:{type:"object",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.P13nItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{beforeNavigationTo:{}}},
renderer:function(r,c){r.write("<span");r.writeControlData(c);r.addClass("sapMP13nPanel");r.writeClasses();r.write(">");r.write("</span>");}
});
P.prototype.getOkPayload=function(){return{};};
P.prototype.getResetPayload=function(){return{};};
P.prototype.beforeNavigationTo=function(){this.fireBeforeNavigationTo();};
P.prototype.onBeforeNavigationFrom=function(){return true;};
P.prototype.onAfterNavigationFrom=function(){};
return P;});
sap.ui.predefine('sap/m/P13nSelectionItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nSelectionItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",defaultValue:undefined},selected:{type:"boolean",defaultValue:false}}}});
return P;});
sap.ui.predefine('sap/m/P13nSelectionPanel',['jquery.sap.global','./ColumnListItem','./P13nPanel','./SearchField','./Table','./library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/m/ScrollContainer','./P13nSelectionItem'],function(q,C,P,S,T,l,a,J,B,R,b){"use strict";var c=l.ToolbarDesign;var L=l.ListType;var d=l.ListMode;var e=l.P13nPanelType;
var f=P.extend("sap.m.P13nSelectionPanel",{
metadata:{library:"sap.m",aggregations:{selectionItems:{type:"sap.m.P13nSelectionItem",multiple:true,singularName:"selectionItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{changeSelectionItems:{parameters:{items:{type:"object[]"}}}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var g=o.getAggregation("content");if(g){g.forEach(function(h){r.renderControl(h);});}r.write("</div>");}
});
f.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var m=new J({linkPressMap:{},items:[],countOfSelectedItems:0,countOfItems:0});m.setDefaultBindingMode(B.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nSelectionPanel");this.setType(e.selection);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new b({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);var t=this;this._fnHandleResize=function(){var g=false,i,h;if(t.getParent){var $=null,j,H;var p=t.getParent();var o=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&o.$().length>0){i=s.$()[0].clientHeight;j=$.children()[0].clientHeight;H=o?o.$()[0].clientHeight:0;h=j-H;if(i!==h){s.setHeight(h+'px');g=true;}}}}return g;};this._sContainerResizeListener=R.register(s,this._fnHandleResize);};
f.prototype.onBeforeRendering=function(){this._updateInternalModel();};
f.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};
f.prototype.getOkPayload=function(){this._updateInternalModel();var m=this._getInternalModel().getProperty("/items");return{selectionItems:m.map(function(M){return{columnKey:M.columnKey,selected:M.persistentSelected};})};};
f.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
f.prototype.addItem=function(i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",i);return this;};
f.prototype.insertItem=function(i,I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",i,I);return this;};
f.prototype.removeItem=function(i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}i=this.removeAggregation("items",i);return i;};
f.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
f.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
f.prototype.addSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("selectionItems",s);return this;};
f.prototype.insertSelectionItem=function(s,i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("selectionItems",s,i);return this;};
f.prototype.updateSelectionItems=function(r){this.updateAggregation("selectionItems");if(r===a.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
f.prototype.removeSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("selectionItems",s);};
f.prototype.removeAllSelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("selectionItems");};
f.prototype.destroySelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("selectionItems");return this;};
f.prototype.onBeforeNavigationFrom=function(){return true;};
f.prototype._notifyChange=function(){var g=this.getChangeNotifier();if(g){g(this);}};
f.prototype._getInternalModel=function(){return this.getModel("$sapmP13nSelectionPanel");};
f.prototype._createTable=function(){var t=this;this._oTable=new T({mode:d.MultiSelect,rememberSelections:false,selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,g){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,g]);}}})})],items:{path:"/items",templateShareable:false,template:new C({cells:[new sap.m.Link({href:"{href}",text:"{text}",target:"{target}",enabled:{path:'href',formatter:function(v){if(!v){this.addStyleClass("sapUiCompSmartLink");}return!!v;}},press:function(E){var o=t._getInternalModel().getProperty("/linkPressMap")[this.getText()+"---"+this.getHref()];if(o){o(E);}}})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
f.prototype._createToolbar=function(){var t=this;var o=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{design:c.Auto,content:[new sap.m.ToolbarSpacer(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})})]});o.setModel(this._getInternalModel());this.addAggregation("content",o);};
f.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
f.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var m=this._getInternalModel().getProperty("/items");m.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});this._getInternalModel().setProperty("/items",m);};
f.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return!!m.visible;});};
f.prototype._getModelItemByColumnKey=function(s){var m=this._getInternalModel().getProperty("/items").filter(function(M){return M.columnKey===s;});return m[0];};
f.prototype._updateCounts=function(m){var i=0;var g=0;m.forEach(function(M){i++;if(M.persistentSelected){g++;}});this._getInternalModel().setProperty("/countOfItems",i);this._getInternalModel().setProperty("/countOfSelectedItems",g);};
f.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
f.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
f.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
f.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
f.prototype._isFilteredByShowSelected=function(){return false;};
f.prototype._updateControlLogic=function(){var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}};
f.prototype._fireChangeSelectionItems=function(){this._bIgnoreUpdateInternalModel=true;var m=this._getInternalModel().getProperty("/items");this.fireChangeSelectionItems({items:m.map(function(M){return{columnKey:M.columnKey,selected:M.persistentSelected};})});this._bIgnoreUpdateInternalModel=false;};
f.prototype._onSelectionChange=function(){this._selectTableItem();};
f.prototype._selectTableItem=function(){var m=this._getInternalModel().getProperty("/items");this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._fireChangeSelectionItems();this._notifyChange();};
f.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');this._getVisibleModelItems().forEach(function(m){m.visible=false;if(m.text&&m.text.match(r)){m.visible=true;}if(m.tooltip&&m.tooltip.match(r)){m.visible=true;}});this._getInternalModel().refresh();};
f.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._getInternalModel().setProperty("/items",this.getItems().map(function(i){return{columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),href:i.getHref(),target:i.getTarget(),persistentSelected:i.getVisible()};},this));this.getSelectionItems().forEach(function(s){var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}if(s.getSelected()!==undefined){M.persistentSelected=s.getSelected();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var m=this._getInternalModel().getProperty("/items");this._updateCounts(m);this._getInternalModel().setProperty("/items",m);};
return f;});
sap.ui.predefine('sap/m/P13nSortItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nSortItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
return P;});
sap.ui.predefine('sap/m/P13nSortPanel',['./P13nConditionPanel','./P13nPanel','./library'],function(P,a,l){"use strict";var c=l.P13nPanelType;
var d=a.extend("sap.m.P13nSortPanel",{
metadata:{library:"sap.m",properties:{containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},sortItems:{type:"sap.m.P13nSortItem",multiple:true,singularName:"sortItem",bindable:"bindable"}},events:{addSortItem:{},removeSortItem:{},updateSortItem:{}}},
renderer:function(r,C){if(!C.getVisible()){return;}r.write("<section");r.writeControlData(C);r.addClass("sapMSortPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMSortPanelContent");r.addClass("sapMSortPanelBG");r.writeClasses();r.write(">");var b=C.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
d.prototype._getConditions=function(){return this._oSortPanel.getConditions();};
d.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oSortPanel.setContainerQuery(b);return this;};
d.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oSortPanel.setLayoutMode(m);return this;};
d.prototype.validateConditions=function(){return this._oSortPanel.validateConditions();};
d.prototype.removeInvalidConditions=function(){this._oSortPanel.removeInvalidConditions();};
d.prototype.removeValidationErrors=function(){this._oSortPanel.removeValidationErrors();};
d.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
d.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
d.prototype.setOperations=function(o){this._aOperations=o;if(this._oSortPanel){this._oSortPanel.setOperations(this._aOperations);}return this;};
d.prototype.init=function(){this.setType(c.sort);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("SORTPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];this.addStyleClass("sapMSortPanel");if(!this._aOperations){this.setOperations([sap.m.P13nConditionOperation.Ascending,sap.m.P13nConditionOperation.Descending]);}this._oSortPanel=new P({autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oSortPanel.setOperations(this._aOperations);this._oSortPanel._sAddRemoveIconTooltipKey="SORT";this.addAggregation("content",this._oSortPanel);};
d.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};
d.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var b=i.getBinding(n);if(b&&o){return o.getObject()[b.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oSortPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("sortItems")||{}).model;this.getSortItems().forEach(function(s){var o=s.getBindingContext(m);if(s.getBinding("key")){o.getObject()[s.getBinding("key").getPath()]=s.getKey();}C.push({key:s.getKey(),keyField:g("columnKey",o,s),operation:g("operation",o,s)});});this._oSortPanel.setConditions(C);}};
d.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
d.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.addSortItem=function(s){this.addAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.insertSortItem=function(s,i){this.insertAggregation("sortItems",s,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype.updateSortItems=function(r){this.updateAggregation("sortItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
d.prototype.removeSortItem=function(s){s=this.removeAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
d.prototype.removeAllSortItems=function(){var s=this.removeAllAggregation("sortItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
d.prototype.destroySortItems=function(){this.destroyAggregation("sortItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
d.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var i=e.getParameter("index");var s;if(o==="update"){s=t.getSortItems()[i];if(s){s.setColumnKey(n.keyField);s.setOperation(n.operation);}t.fireUpdateSortItem({key:k,index:i,sortItemData:s});t._notifyChange();}if(o==="add"){s=new sap.m.P13nSortItem({key:k,columnKey:n.keyField,operation:n.operation});t._bIgnoreBindCalls=true;t.fireAddSortItem({key:k,index:i,sortItemData:s});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveSortItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
d.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return d;});
sap.ui.predefine('sap/m/QuickView',['./library','sap/ui/Device','sap/ui/core/IconPool','./QuickViewBase','./ResponsivePopover','./NavContainer','./Page','./Bar','./Button','./QuickViewRenderer'],function(l,D,I,Q,R,N,P,B,a,b){"use strict";var c=l.PlacementType;
var d=Q.extend("sap.m.QuickView",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Misc",defaultValue:c.Right},width:{type:'sap.ui.core.CSSSize',group:'Dimension',defaultValue:'320px'}},aggregations:{},designtime:"sap/m/designtime/QuickView.designtime",events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}}}}});
d.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);var t=this;this._oPopover=new R(this.getId()+'-quickView',{placement:this.getPlacement(),content:[this._oNavContainer],contentWidth:this.getWidth(),showHeader:false,showCloseButton:false,afterOpen:function(e){t._afterOpen(e);t.fireAfterOpen({openBy:e.getParameter("openBy")});},afterClose:function(e){t.fireAfterClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});},beforeOpen:function(e){t.fireBeforeOpen({openBy:e.getParameter("openBy")});},beforeClose:function(e){t.fireBeforeClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});t._bRendered=false;}});this._oPopover.addStyleClass('sapMQuickView');var p=this._oPopover.getAggregation("_popup");p.addEventDelegate({onBeforeRendering:this._initializeQuickView,onAfterRendering:this._setLinkWidth,onkeydown:this._onPopupKeyDown},this);var t=this;var s=p._fnAdjustPositionAndArrow;if(s){p._fnAdjustPositionAndArrow=function(){s.apply(p,arguments);t._adjustContainerHeight();};}this._bItemsChanged=true;this._oPopover.addStyleClass("sapMQuickView");};
d.prototype._initializeQuickView=function(){this._bRendered=true;if(this._bItemsChanged){this._clearContainerHeight();this._initPages();var p=this.getAggregation("pages");if(!p&&D.system.phone){this._addEmptyPage();}this._bItemsChanged=false;}};
d.prototype.exit=function(){this._bRendered=false;this._bItemsChanged=true;if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
d.prototype.invalidate=function(){};
d.prototype._createPage=function(q){return q._createPage();};
d.prototype._onPopupKeyDown=function(e){this._processKeyboard(e);};
d.prototype._afterOpen=function(e){if(D.system.phone){this._restoreFocus();}};
d.prototype._addEmptyPage=function(){var p=new P({customHeader:new B().addStyleClass("sapMQuickViewHeader")});var t=this;var C=p.getCustomHeader();C.addContentRight(new a({icon:I.getIconURI("decline"),press:function(){t._oPopover.close();}}));p.addStyleClass('sapMQuickViewPage');this._oNavContainer.addPage(p);};
d.prototype._clearContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&$[0].style.height){$[0].style.height='';}};
d.prototype._adjustContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&!$[0].style.height){$[0].style.height=$.height()+'px';}};
d.prototype._setLinkWidth=function(){this._oPopover.$().find(".sapMLnk").css("width","auto");};
d.prototype.getCloseButton=function(){if(!D.system.phone){return undefined;}var p=this._oNavContainer.getCurrentPage();var o=p.getCustomHeader().getContentRight()[0];return o;};
d.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
d.prototype.setWidth=function(w){if(this._oPopover){this._oPopover.setContentWidth(w);this.setProperty('width',w,true);}return this;};
d.prototype.openBy=function(C){this._bItemsChanged=true;this._oPopover.openBy(C);return this;};
d.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getFieldGroupIds","setFieldGroupIds","getBusy","setBusy","setTooltip","getTooltip"].forEach(function(n){d.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var r=this._oPopover.getAggregation("_popup")[n].apply(this._oPopover.getAggregation("_popup"),arguments);return r===this._oPopover.getAggregation("_popup")?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(f){d.prototype["_"+f+"Old"]=d.prototype[f];d.prototype[f]=function(){var n,r;if(["removeAggregation","removeAllAggregation","destroyAggregation"].indexOf(f)!==-1){n=[arguments[0],true];}else{n=[arguments[0],arguments[1],true];}r=d.prototype["_"+f+"Old"].apply(this,n);this._bItemsChanged=true;if(this._oPopover){if(arguments[0]!="pages"){this._oPopover[f].apply(this._oPopover,arguments);}if(this._bRendered){this._initializeQuickView();}}if(["removeAggregation","removeAllAggregation"].indexOf(f)!==-1){return r;}return this;};});return d;});
sap.ui.predefine('sap/m/QuickViewBase',['jquery.sap.global','./library','sap/ui/core/Control','jquery.sap.dom'],function(q,l,C){"use strict";
var Q=C.extend("sap.m.QuickViewBase",{metadata:{library:"sap.m",properties:{},defaultAggregation:"pages",aggregations:{pages:{type:"sap.m.QuickViewPage",multiple:true,singularName:"page",bindable:"bindable"}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},navOrigin:{type:"sap.ui.core.Control"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},isTopPage:{type:"boolean"},navOrigin:{type:"sap.ui.core.Control"}}}}}});
Q.prototype.navigateBack=function(){if(!this._oNavContainer.currentPageIsTopPage()){this._setNavOrigin(null);this._oNavContainer.back();}};
Q.prototype.getNavContainer=function(){return this._oNavContainer;};
Q.prototype._initPages=function(){var n=this._oNavContainer;n.destroyPages();n.init();var p=this.getAggregation("pages");if(!p){return;}var I=this.getId();for(var i=0;i<p.length;i++){var o=p[i];o._oPage=null;var N={hasBackButton:i>0,popover:this._oPopover,navContainer:n,quickViewId:I,quickView:this};o.setNavContext(N);var P=this._createPage(o);this._oNavContainer.addPage(P);}};
Q.prototype._processKeyboard=function(e){if(e.shiftKey&&e.which===q.sap.KeyCodes.ENTER){this.navigateBack();e.preventDefault();}};
Q.prototype._createPage=function(o){return o;};
Q.prototype._navigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q.sap.byId(F).index();var a=q.sap.byId(T).index();if(a==-1||a>i){t.addStyleClass('sapMNavItemOffset');}else{f.addStyleClass('sapMNavItemOffset');}f.$().parents('.sapMPanelContent').scrollTop(0);var p=e.getParameters();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireNavigate(p);};
Q.prototype._afterNavigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q.sap.byId(F).index();var a=q.sap.byId(T).index();if(a>i){t.removeStyleClass('sapMNavItemOffset');}else{f.removeStyleClass('sapMNavItemOffset');}var p=e.getParameters();p.isTopPage=this._oNavContainer.currentPageIsTopPage();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireAfterNavigate(p);this._setLinkWidth();q.sap.delayedCall(0,this,this._restoreFocus);};
Q.prototype._restoreFocus=function(){var p=this._oNavContainer.getCurrentPage();var f=this._oNavContainer._mFocusObject[p.getId()];if(!f){var c=p.getContent();if(c&&c.length>1){f=c[1].$().firstFocusableDomRef();}}if(f){q.sap.focus(f);}};
Q.prototype._setLinkWidth=function(){};
Q.prototype._setNavOrigin=function(c){this._navOrigin=c;};
return Q;});
sap.ui.predefine('sap/m/QuickViewCard',['./library','./QuickViewBase','./NavContainer','./Page','./ScrollContainer','./QuickViewCardRenderer'],function(l,Q,N,P,S,a){"use strict";
var b=Q.extend("sap.m.QuickViewCard",{metadata:{library:"sap.m",properties:{showVerticalScrollBar:{type:"boolean",group:"Behavior",defaultValue:true}},designtime:"sap/m/designtime/QuickViewCard.designtime"}});
b.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);};
b.prototype.onBeforeRendering=function(){this._initPages();};
b.prototype.onAfterRendering=function(){this._setLinkWidth();};
b.prototype.exit=function(){if(this._oNavContainer){this._oNavContainer.destroy();}};
b.prototype.onkeydown=function(e){this._processKeyboard(e);};
b.prototype._createPage=function(q){var c=q._createPageContent();q._mPageContent=null;var C=new S(this.getId()+'-'+q.getPageId(),{horizontal:false,vertical:false});if(c.header){C.addContent(c.header);}C.addContent(c.form);C.addStyleClass('sapMQuickViewPage');return C;};
b.prototype._setLinkWidth=function(){this.$().find(".sapMLnk").css("width","auto");};
return b;});
sap.ui.predefine('sap/m/QuickViewGroupElement',['./library','sap/ui/core/Element','./Link','./Text','sap/ui/core/CustomData'],function(l,E,L,T,C){"use strict";var G=l.QuickViewGroupElementType;
var a=E.extend("sap.m.QuickViewGroupElement",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},label:{type:"string",group:"Misc",defaultValue:""},value:{type:"string",group:"Misc",defaultValue:""},url:{type:"string",group:"Misc",defaultValue:""},target:{type:"string",group:"Misc",defaultValue:"_blank"},type:{type:"sap.m.QuickViewGroupElementType",group:"Misc",defaultValue:G.text},pageLinkId:{type:"string",group:"Misc",defaultValue:""},emailSubject:{type:"string",group:"Misc",defaultValue:""}}}});
a.prototype._getGroupElementValue=function(q){if(!this.getValue()){return null;}switch(this.getType()){case G.email:var h="mailto:"+this.getValue();var s=this.getEmailSubject();if(s){h+='?subject='+s;}return new L({href:h,text:this.getValue(),wrapping:true});case G.phone:case G.mobile:return new L({href:"tel:"+this.getValue(),text:this.getValue()});case G.link:return new L({href:this.getUrl(),text:this.getValue(),target:this.getTarget()});case G.pageLink:var b=this.getPageLinkId();if(q){b=q+'-'+b;}return new L({href:"#",text:this.getValue(),customData:[new C({key:"pageNumber",value:b})]});default:return new T({text:this.getValue()});}};
a.prototype.setProperty=function(){E.prototype.setProperty.apply(this,arguments);var g=this.getParent();if(!g){return;}var p=g.getParent();if(p){p._updatePage();}};
return a;});
sap.ui.predefine('sap/m/QuickViewPage',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/layout/form/SimpleForm','sap/ui/layout/VerticalLayout','sap/ui/layout/HorizontalLayout','./Page','./Button','./Bar','./Title','./Image','./Link','./Text','./Label','./HBox','sap/ui/core/Icon','sap/ui/core/Title','sap/ui/core/CustomData','sap/ui/core/library','sap/ui/layout/library','sap/ui/Device','sap/ui/layout/form/ResponsiveGridLayout','./QuickViewPageRenderer'],function(q,l,C,I,S,V,H,P,B,a,T,b,L,c,d,f,g,h,i,m,n,D,R,Q){"use strict";var U=l.URLHelper;var o=n.form.SimpleFormLayout;var p=m.TitleLevel;var r=l.QuickViewGroupElementType;var s=l.ButtonType;
var t=C.extend("sap.m.QuickViewPage",{metadata:{library:"sap.m",properties:{pageId:{type:"string",group:"Misc",defaultValue:""},header:{type:"string",group:"Misc",defaultValue:""},title:{type:"string",group:"Misc",defaultValue:""},titleUrl:{type:"string",group:"Misc",defaultValue:""},crossAppNavCallback:{type:"object",group:"Misc"},description:{type:"string",group:"Misc",defaultValue:""},icon:{type:"string",group:"Misc",defaultValue:""}},defaultAggregation:"groups",aggregations:{groups:{type:"sap.m.QuickViewGroup",multiple:true,singularName:"group",bindable:"bindable"}}}});
t.prototype.init=function(){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');var G=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService;if(G){this.oCrossAppNavigator=G("CrossApplicationNavigation");}};
t.prototype.onBeforeRendering=function(){this._destroyPageContent();this._createPageContent();};
t.prototype.getPageContent=function(){return this._mPageContent;};
t.prototype.setNavContext=function(e){this._mNavContext=e;};
t.prototype.getNavContext=function(){return this._mNavContext;};
t.prototype.setPageTitleControl=function(e){this._oPageTitle=e;};
t.prototype.getPageTitleControl=function(){return this._oPageTitle;};
t.prototype._createPage=function(){var e=this._createPageContent();var N=this.getNavContext();var j;if(this._oPage){j=this._oPage;j.destroyContent();j.setCustomHeader(new a());}else{j=this._oPage=new P(N.quickViewId+'-'+this.getPageId(),{customHeader:new a()});j.addEventDelegate({onAfterRendering:this.onAfterRenderingPage},this);}if(this.getHeader()===""&&N.quickView.getPages().length===1&&!D.system.phone){j.setShowHeader(false);j.addStyleClass('sapMQuickViewPageWithoutHeader');}if(e.header){j.addContent(e.header);}j.addContent(e.form);var k=j.getCustomHeader();k.addContentMiddle(new T({text:this.getHeader()}).addStyleClass("sapMQuickViewTitle"));if(N.hasBackButton){k.addContentLeft(new B({type:s.Back,tooltip:this._oResourceBundle.getText("PAGE_NAVBUTTON_TEXT"),press:function(){if(N.navContainer){N.quickView._setNavOrigin(null);N.navContainer.back();}}}));}if(N.popover&&D.system.phone){k.addContentRight(new B({icon:I.getIconURI("decline"),press:function(){N.popover.close();}}));}j.addStyleClass('sapMQuickViewPage');return j;};
t.prototype.onAfterRenderingPage=function(){if(this._bItemsChanged){var N=this.getNavContext();if(N){N.quickView._restoreFocus();}this._bItemsChanged=false;}};
t.prototype._createPageContent=function(){var F=this._createForm();var e=this._getPageHeaderContent();var j=this.getPageTitleControl();if(e&&j){F.addAriaLabelledBy(j);}this._mPageContent={form:F,header:e};return this._mPageContent;};
t.prototype._createForm=function(){var G=this.getAggregation("groups"),F=new S({maxContainerCols:1,editable:false,layout:o.ResponsiveGridLayout});if(G){for(var j=0;j<G.length;j++){if(G[j].getVisible()){this._renderGroup(G[j],F);}}}return F;};
t.prototype._getPageHeaderContent=function(){var e,v=new V(),j=new H(),k=this.getIcon(),u=this.getTitle(),w=this.getDescription(),x=this.getTitleUrl();if(!k&&!u&&!w){return null;}if(k){if(this.getIcon().indexOf("sap-icon")==0){e=new g({src:k,decorative:!x,useIconTooltip:false,tooltip:u});}else{e=new b({src:k,decorative:false,tooltip:u}).addStyleClass("sapUiIcon");}e.addStyleClass("sapMQuickViewThumbnail");if(x){e.attachPress(this._crossApplicationNavigation(this));}j.addContent(e);}var y;if(x){y=new L({text:u,href:x,target:"_blank"});}else if(this.getCrossAppNavCallback()){y=new L({text:u});y.attachPress(this._crossApplicationNavigation(this));}else{y=new T({text:u,level:p.H1});}this.setPageTitleControl(y);var z=new c({text:w});v.addContent(y);v.addContent(z);j.addContent(v);return j;};
t.prototype._renderGroup=function(G,F){var e=G.getAggregation("elements");var j,u,v;if(G.getHeading()){F.addContent(new h({text:G.getHeading(),level:p.H2}));}if(!e){return;}var N=this.getNavContext();for(var k=0;k<e.length;k++){j=e[k];if(!j.getVisible()){continue;}v=new d({text:j.getLabel()});var w;if(N){w=N.quickViewId;}u=j._getGroupElementValue(w);F.addContent(v);if(!u){F.addContent(new c({text:""}));continue;}v.setLabelFor(u.getId());if(j.getType()==r.pageLink){u.attachPress(this._attachPressLink(this));}if(j.getType()==r.mobile&&!D.system.desktop){var x=new g({src:I.getIconURI("post"),tooltip:this._oResourceBundle.getText("QUICKVIEW_SEND_SMS"),decorative:false,customData:[new i({key:"phoneNumber",value:j.getValue()})],press:this._mobilePress});var y=new f({items:[u,x]});F.addContent(y);}else{F.addContent(u);}}};
t.prototype._crossApplicationNavigation=function(e){return function(){if(e.getCrossAppNavCallback()&&e.oCrossAppNavigator){var j=e.getCrossAppNavCallback();if(typeof j=="function"){var k=j();var u=e.oCrossAppNavigator.hrefForExternal({target:{semanticObject:k.target.semanticObject,action:k.target.action},params:k.params});U.redirect(u);}}else if(e.getTitleUrl()){window.open(e.getTitleUrl(),"_blank");}};};
t.prototype._destroyPageContent=function(){if(!this._mPageContent){return;}if(this._mPageContent.form){this._mPageContent.form.destroy();}if(this._mPageContent.header){this._mPageContent.header.destroy();}this._mPageContent=null;};
t.prototype.exit=function(){this._oResourceBundle=null;if(this._oPage){this._oPage.destroy();this._oPage=null;}else{this._destroyPageContent();}this._mNavContext=null;};
t.prototype._attachPressLink=function(j){var N=j.getNavContext();return function(e){e.preventDefault();var k=this.getCustomData()[0].getValue();if(N.navContainer&&k){N.quickView._setNavOrigin(this);N.navContainer.to(k);}};};
t.prototype._mobilePress=function(){var e="sms://"+q.sap.encodeURL(this.getCustomData()[0].getValue());window.location.replace(e);};
t.prototype._updatePage=function(){var N=this.getNavContext();if(N&&N.quickView._bRendered){this._bItemsChanged=true;N.popover.focus();if(N.quickView.indexOfPage(this)==0){N.quickView._clearContainerHeight();}this._createPage();N.popover.$().css('display','block');N.quickView._adjustContainerHeight();N.quickView._restoreFocus();}};
["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){t.prototype["_"+F+"Old"]=t.prototype[F];t.prototype[F]=function(){var e=t.prototype["_"+F+"Old"].apply(this,arguments);this._updatePage();if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return e;}return this;};});
t.prototype.setProperty=function(){C.prototype.setProperty.apply(this,arguments);this._updatePage();};
return t;});
/*
 * !UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/ColumnHeaderRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){var s=c.getId();var i=c._isInteractive();r.write("<div");r.writeControlData(c);if(i){r.writeAttribute("tabindex",0);r.writeAttribute("role","button");r.addClass("sapMColumnHeaderFocusable");r.writeAttributeEscaped("aria-labelledby",s+"-info");r.addClass("sapMColumnHeaderActive");}r.addClass("sapMColumnHeader");r.writeClasses();r.write(">");this.renderText(r,c);this.renderIcons(r,c);if(i&&sap.ui.getCore().getConfiguration().getAccessibility()){r.write("<span");r.writeAttributeEscaped("id",s+"-info");r.addClass("sapUiInvisibleText");r.writeClasses();r.writeAttributeEscaped("aria-hidden","true");r.write(">");r.writeEscaped(c.getAccessibilityInfo().description);r.write("</span>");}r.write("</div>");};
C.renderText=function(r,c){r.write("<div");r.addClass("sapMColumnHeaderText");r.writeClasses();r.write(">");r.writeEscaped(c.getText());r.write("</div>");};
C.renderIcons=function(r,c){r.write("<div");r.addClass("sapMColumnHeaderIcons");r.writeClasses();r.write(">");this.renderSortIcon(r,c);this.renderFilterIcon(r,c);r.write("</div>");};
C.renderSortIcon=function(r,c){var s=c.getAggregation("_sortIcon");if(!s){return;}r.renderControl(s);};
C.renderFilterIcon=function(r,c){var f=c.getAggregation("_filterIcon");if(!f){return;}r.renderControl(f);};
return C;},true);
/*!
 * @copyright@
 */
sap.ui.predefine('sap/m/NumericContentRenderer',['./library'],function(l){"use strict";var N={};
N.render=function(r,c){var v=c.getValue();var i=c.getIndicator();var s=c.getScale();var S=c.getState();var I=l.DeviationIndicator.None!==i&&v!=="";var w=c.getWithMargin();var W;if(w){W="";}else{W="WithoutMargin";}if(c.getFormatterValue()){var f=c._parseFormattedValue(v);s=f.scale;v=f.value;}var b=s&&v;r.write("<div");r.writeControlData(c);var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.writeAttributeEscaped("aria-label",t);r.writeAttribute("role","img");if(S==l.LoadState.Failed||S==l.LoadState.Loading){r.writeAttribute("aria-disabled","true");}if(c.getAnimateTextChange()){r.addStyle("opacity","0.25");}if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();r.addClass("sapMNC");r.addClass(W);if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNCInner");r.addClass(W);r.writeClasses();r.write(">");if(w){this._renderScaleAndIndicator(r,c,I,b,W,i,s);this._renderValue(r,c,W,v);}else{this._renderValue(r,c,W,v);this._renderScaleAndIndicator(r,c,I,b,W,i,s);}r.write("</div>");r.write("</div>");};
N._prepareAndRenderIcon=function(r,c,i){if(i){var s,L=l.LoadState,C=c.getState();for(s in L){if(L.hasOwnProperty(s)&&s!==C){i.removeStyleClass(s);}else if(L.hasOwnProperty(s)&&s===C){i.addStyleClass(s);}}i.addStyleClass("sapMNCIconImage");r.renderControl(i);}};
N._renderScaleAndIndicator=function(r,c,i,a,w,t,b){if(i||a){var s=c.getState();var C=c.getValueColor();r.write("<div");r.addClass("sapMNCIndScale");r.addClass(w);r.addClass(s);r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-indicator");r.addClass("sapMNCIndicator");r.addClass(t);r.addClass(s);r.addClass(C);r.writeClasses();r.write("/>");if(a){r.write("<div");r.writeAttribute("id",c.getId()+"-scale");r.addClass("sapMNCScale");r.addClass(s);r.addClass(C);r.writeClasses();r.write(">");r.writeEscaped(b.substring(0,3));r.write("</div>");}r.write("</div>");}};
N._renderValue=function(r,c,w,v){var e;if(c.getNullifyValue()){e="0";}else{e="";}r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMNCValue");r.addClass(w);r.addClass(c.getValueColor());r.addClass(c.getState());r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-value-scr");r.addClass("sapMNCValueScr");r.addClass(w);r.writeClasses();r.write(">");this._prepareAndRenderIcon(r,c,c._oIcon);var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else{if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped(e);}}r.write("</div>");r.write("</div>");};
return N;},true);
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/AccButton',['./Button','./AccButtonRenderer'],function(B,A){"use strict";
var a=B.extend("sap.m.AccButton",{metadata:{library:"sap.m",properties:{"tabIndex":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHidden":{type:"string",defaultValue:null,bindable:"bindable"}}}});
return a;});
sap.ui.predefine('sap/m/AccButtonRenderer',['./ButtonRenderer','sap/ui/core/Renderer'],function(B,R){"use strict";var A=R.extend(B);
A.renderAccessibilityAttributes=function(r,c){if(c.getTabIndex()){r.writeAttribute("tabindex",c.getTabIndex());}if(c.getAriaHidden()){r.writeAttribute("aria-hidden",c.getAriaHidden());}};
return A;},true);
sap.ui.predefine('sap/m/ActionListItem',['./ListItemBase','./library','./ActionListItemRenderer'],function(L,l,A){"use strict";var a=l.ListMode;var b=l.ListType;
var c=L.extend("sap.m.ActionListItem",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
c.prototype.init=function(){this.setType(b.Active);L.prototype.init.apply(this,arguments);};
c.prototype.getMode=function(){return a.None;};
c.prototype.onsapspace=c.prototype.onsapenter;
c.prototype.getContentAnnouncement=function(){return this.getText();};
return c;});
sap.ui.predefine('sap/m/ActionListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var A=R.extend(L);
A.renderLIAttributes=function(r,l){r.addClass("sapMALI");};
A.renderLIContent=function(r,l){var i=l.getText();if(i){r.write("<div class='sapMALIText'>");r.writeEscaped(i);r.write("</div>");}};
return A;},true);
sap.ui.predefine('sap/m/ActionSelect',['./Select','sap/ui/core/InvisibleText','./library','./ActionSelectRenderer'],function(S,I,l,A){"use strict";
var a=S.extend("sap.m.ActionSelect",{metadata:{library:"sap.m",associations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"}}}});
a.prototype.init=function(){S.prototype.init.call(this);this.getList().addEventDelegate({onfocusin:this.onfocusinList},this);};
a.prototype.hasContent=function(){return S.prototype.hasContent.call(this)||!!this.getButtons().length;};
a.prototype.addContent=function(){var c=sap.ui.getCore(),p=this.getPicker();this.getButtons().forEach(function(b){p.addContent(c.byId(b));});};
a.prototype._onBeforeRenderingPopover=function(){S.prototype._onBeforeRenderingPopover.call(this);this._updateTutorMessage();};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var p=this.getPicker(),r=this.getRenderer();p.addStyleClass(r.CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker-CTX");};
a.prototype.createPickerCloseButton=function(){};
a.prototype.removeButton=function(b){var p=this.getPicker();if(p){if(typeof b==="number"){b=this.getButtons()[b];}p.removeContent(b);}return this.removeAssociation("buttons",b);};
a.prototype.removeAllButtons=function(){var p=this.getPicker();if(p){this.getButtons().forEach(function(b){p.removeContent(b);});}return this.removeAllAssociation("buttons");};
a.prototype.onsaptabprevious=function(e){var b=this.getButtons(),p=this.getPicker(),i;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=b.length-1;i>=0;i--){if(sap.ui.getCore().byId(b[i]).getEnabled()){sap.ui.getCore().byId(b[i]).focus();e.preventDefault();break;}}}};
a.prototype.onsaptabnext=function(e){var b=this.getButtons(),p=this.getPicker(),i;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=0;i<b.length;i++){if(sap.ui.getCore().byId(b[i]).getEnabled()){sap.ui.getCore().byId(b[i]).focus();e.preventDefault();break;}}}};
a.prototype.onsapfocusleave=function(e){var b=this.getButtons();var k=(b.indexOf(e.relatedControlId)==-1);if(k){S.prototype.onsapfocusleave.apply(this,arguments);}this._toggleListFocusIndication(true);};
a.prototype.onfocusinList=function(e){if(document.activeElement!==this.getList().getDomRef()){this.focus();}};
a.prototype.onfocusin=function(){S.prototype.onfocusin.apply(this,arguments);this._toggleListFocusIndication(false);};
a.prototype._toggleListFocusIndication=function(r){var s=this.getSelectedItem();if(this.isOpen()&&s){s.$().toggleClass("sapMActionSelectItemWithoutFocus",r);}};
a.prototype._updateTutorMessage=function(){var p=this.getPicker(),b=p.getAriaLabelledBy(),h=!!this.getButtons().length,t;if(!this._sTutorMessageId){this._sTutorMessageId=this.getId()+"-tutorMessage";this._oTutorMessageText=new I(this._sTutorMessageId,{text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTION_SELECT_TUTOR_MESSAGE")}).toStatic();}t=(b.indexOf(this._sTutorMessageId)===-1);if(t&&h){p.addAriaLabelledBy(this._sTutorMessageId);}else{if(!h){p.removeAriaLabelledBy(this._sTutorMessageId);}}};
a.prototype.exit=function(){if(this._oTutorMessageText){this._oTutorMessageText.destroy();this._oTutorMessageText=null;}};
return a;});
sap.ui.predefine('sap/m/ActionSelectRenderer',['sap/ui/core/Renderer','./SelectRenderer'],function(R,S){"use strict";var A=R.extend(S);A.ACTION_SELECT_CSS_CLASS="sapMActionSelect";
A.addClass=function(r,a){r.addClass(A.ACTION_SELECT_CSS_CLASS);};
return A;},true);
sap.ui.predefine('sap/m/ActionSheet',['jquery.sap.global','./Dialog','./Popover','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/base/ManagedObject','sap/ui/Device','./ActionSheetRenderer'],function(q,D,P,l,C,I,a,M,b,A){"use strict";var B=l.ButtonType;var c=l.DialogType;var d=l.PlacementType;
var e=C.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:d.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},defaultAggregation:"buttons",events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{origin:{type:"sap.m.Button"}},afterClose:{origin:{type:"sap.m.Button"}},cancelButtonPress:{}},designtime:"sap/m/designtime/ActionSheet.designtime"}});
e.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);};
e.prototype.exit=function(){b.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null;}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null;}this._clearItemNavigation();};
e.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
e.prototype._setItemNavigation=function(){var f=this._getAllButtons(),g=[],o=this.getDomRef();if(o){this._oItemNavigation.setRootDomRef(o);for(var i=0;i<f.length;i++){if(f[i].getEnabled()&&f[i].getVisible()){g.push(f[i].getFocusDomRef());}}if(this._oCancelButton){g.push(this._oCancelButton.getFocusDomRef());}this._oItemNavigation.setItemDomRefs(g);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}};
e.prototype.onBeforeRendering=function(){this._clearItemNavigation();};
e.prototype.onAfterRendering=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();};
e.prototype.sapfocusleave=function(){this.close();};
e.prototype.openBy=function(o){var t=this;if(!this._parent){var O=this.getParent();if(O){this.setParent(null);}if(!b.system.phone){this._parent=new P({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(){t.fireBeforeClose();},afterClose:function(){if(t.getShowCancelButton()){t.fireCancelButtonTap();t.fireCancelButtonPress();}t.fireAfterClose();},ariaLabelledBy:this.getPopupHiddenLabelId()||undefined}).addStyleClass("sapMActionSheetPopover");if(b.browser.internet_explorer){this._parent._fnAdjustPositionAndArrow=q.proxy(function(){P.prototype._adjustPositionAndArrow.apply(this);var $=this.$(),f=$.children(".sapMPopoverCont")[0].getBoundingClientRect().width;q.each($.find(".sapMActionSheet > .sapMBtn"),function(i,g){var h=q(g),j;h.css("width","");j=g.getBoundingClientRect().width;if(j<=f){h.css("width","100%");}});},this._parent);}}else{this._parent=new D({title:this.getTitle(),type:c.Standard,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(E){t.fireBeforeClose({origin:E.getParameter("origin")});},afterClose:function(E){t.fireAfterClose({origin:E.getParameter("origin")});b.resize.detachHandler(t._fnOrientationChange);}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.addAriaLabelledBy(this.getPopupHiddenLabelId()||undefined);}if(!b.system.phone){this._parent.setBeginButton(this._getCancelButton());}if(b.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){D.prototype._setDimensions.apply(this);this.$("cont").css("max-height","");};this._parent._adjustScrollingPane=function(){var h=this.$().height();this.$("cont").css("max-height",h);if(this._oScroller){this._oScroller.refresh();}};}}if(O){O.addDependent(this._parent);}}if(!b.system.phone){this._parent.openBy(o);}else{this._parent.open();b.resize.attachHandler(this._fnOrientationChange);}};
e.prototype.close=function(o){if(this._parent){this._parent.close();}};
e.prototype.isOpen=function(o){return!!this._parent&&this._parent.isOpen();};
e.prototype._createCancelButton=function(){if(!this._oCancelButton){var s=(this.getCancelButtonText())?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),t=this;this._oCancelButton=new sap.m.Button(this.getId()+'-cancelBtn',{text:s,type:B.Reject,press:function(){if(b.system.phone&&t._parent){t._parent._oCloseTrigger=this;}t.close();t.fireCancelButtonTap();t.fireCancelButtonPress();}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(b.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true);}}return this;};
e.prototype._getCancelButton=function(){if(b.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton;}return null;};
e.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t);}return this;};
e.prototype._preProcessActionButton=function(o){var t=o.getType();if(t!==B.Accept&&t!==B.Reject){o.setType(B.Transparent);}o.addStyleClass("sapMBtnInverted");this._parent&&this._parent.invalidate();return this;};
e.prototype.setShowCancelButton=function(v){if(this._parent){if(b.system.phone){this.setProperty("showCancelButton",v,false);}}else{this.setProperty("showCancelButton",v,true);}return this;};
e.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._parent&&b.system.phone){this._parent.setTitle(t);this._parent.toggleStyleClass("sapMDialog-NoHeader",!t);}if(this._parent){if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle");}}return this;};
e.prototype.setPlacement=function(p){this.setProperty("placement",p,true);if(!b.system.phone){if(this._parent){this._parent.setPlacement(p);}}return this;};
e.prototype._buttonSelected=function(){if(b.system.phone&&this._parent){this._parent._oCloseTrigger=this;}this.close();};
e.prototype._orientationChange=function(){this._parent._adjustScrollingPane();};
e.prototype._addAriaHiddenTexts=function(o){var s=o.getId(),i;if(sap.ui.getCore().getConfiguration().getAccessibility()){i=new a(s+"-actionSheetHiddenText");this.addAggregation("_invisibleAriaTexts",i,false);o.addAriaLabelledBy(i.getId());}};
e.prototype._removeAriaHiddenTexts=function(o){o.getAriaLabelledBy().forEach(function(i){var f=sap.ui.getCore().byId(i);if(f instanceof a&&i.indexOf("actionSheetHiddenText")>-1){this.removeAggregation("_invisibleAriaTexts",f,false);o.removeAriaLabelledBy(f);f.destroy();}},this);};
e.prototype.addButton=function(o){this.addAggregation("buttons",o,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};
e.prototype.insertButton=function(o,i){this.insertAggregation("buttons",o,i,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};
e.prototype.removeButton=function(o){var r=this.removeAggregation("buttons",o,false);if(r){r.detachPress(this._buttonSelected,this);this._removeAriaHiddenTexts(r);}return r;};
e.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",false),t=this;q.each(r,function(i,o){o.detachPress(t._buttonSelected,t);t._removeAriaHiddenTexts(o);});return r;};
e.prototype.clone=function(){var f=this.getButtons();for(var i=0;i<f.length;i++){f[i].detachPress(this._buttonSelected,this);}var o=C.prototype.clone.apply(this,arguments);for(var j=0;j<f.length;j++){f[j].attachPress(this._buttonSelected,this);}return o;};
e.prototype._getAllButtons=function(){return this.getButtons();};
e.prototype.getPopupHiddenLabelId=function(){return a.getStaticId("sap.m","ACTIONSHEET_AVAILABLE_ACTIONS");};
e.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};
return e;});
sap.ui.predefine('sap/m/ActionSheetRenderer',["sap/ui/Device"],function(D){"use strict";var A={};
A.render=function(r,c){var a=c._getAllButtons(),I=c.getAggregation("_invisibleAriaTexts"),R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),b=a.length,d=sap.ui.getCore().getConfiguration().getAccessibility(),v=a.filter(function(B){return B.getVisible();}).length,C,i,m,B,V=1,g=function(o){return I.filter(function(e){return e.getId().indexOf(o.getId())>-1;})[0];};for(i=0;i<b;i++){B=a[i];B.removeStyleClass("sapMActionSheetButtonNoIcon");if(B.getIcon()&&B.getVisible()){m=true;}else{B.addStyleClass("sapMActionSheetButtonNoIcon");}}r.write("<div");r.writeControlData(c);r.addClass("sapMActionSheet");if(m){r.addClass("sapMActionSheetMixedButtons");}r.writeClasses();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}d&&r.writeAttributeEscaped("role","presentation");r.write(">");for(i=0;i<b;i++){B=a[i];r.renderControl(a[i].addStyleClass("sapMActionSheetButton"));if(d&&B.getVisible()){C=g(B);if(C){C.setText(R.getText('ACTIONSHEET_BUTTON_INDEX',[V,v]));r.renderControl(C);}V++;}}if(D.system.phone&&c.getShowCancelButton()){r.renderControl(c._getCancelButton());}r.write("</div>");};
return A;},true);
sap.ui.predefine('sap/m/App',['jquery.sap.global','./NavContainer','./library','./AppRenderer'],function(q,N,l,A){"use strict";
var a=N.extend("sap.m.App",{metadata:{library:"sap.m",properties:{homeIcon:{type:"any",group:"Misc",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1}},events:{orientationChange:{deprecated:true,parameters:{landscape:{type:"boolean"}}}}}});
a.prototype.init=function(){N.prototype.init.apply(this,arguments);this.addStyleClass("sapMApp");q.sap.initMobile({viewport:!this._debugZoomAndScroll,statusBar:"default",hideBrowser:true,preventScroll:!this._debugZoomAndScroll,rootId:this.getId()});q(window).bind("resize",q.proxy(this._handleOrientationChange,this));};
a.prototype.onBeforeRendering=function(){if(N.prototype.onBeforeRendering){N.prototype.onBeforeRendering.apply(this,arguments);}q.sap.initMobile({homeIcon:this.getHomeIcon()});};
a.prototype.onAfterRendering=function(){if(N.prototype.onAfterRendering){N.prototype.onAfterRendering.apply(this,arguments);}var r=this.getDomRef().parentNode;while(r&&r!==document.documentElement){var $=q(r);if($.attr("data-sap-ui-root-content")){break;}if(!r.style.height){r.style.height="100%";}r=r.parentNode;}};
a.prototype.exit=function(){q(window).unbind("resize",this._handleOrientationChange);if(this._sInitTimer){q.sap.clearDelayedCall(this._sInitTimer);}};
a.prototype._handleOrientationChange=function(){var $=q(window);var i=$.width()>$.height();if(this._oldIsLandscape!==i){this.fireOrientationChange({landscape:i});this._oldIsLandscape=i;}};
a.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){q.sap.log.warning("Invalid value "+o+" for App.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};
return a;});
sap.ui.predefine('sap/m/AppRenderer',['./NavContainerRenderer','sap/ui/core/Renderer','sap/m/library'],function(N,R,l){"use strict";var B=l.BackgroundHelper;var A={};var A=R.extend(N);
A.renderAttributes=function(r,c){B.addBackgroundColorStyles(r,c.getBackgroundColor(),c.getBackgroundImage());};
A.renderBeforeContent=function(r,c){B.renderBackgroundImageTag(r,c,"sapMAppBG",c.getBackgroundImage(),c.getBackgroundRepeat(),c.getBackgroundOpacity());};
return A;},true);
sap.ui.predefine('sap/m/AssociativeOverflowToolbar',['./OverflowToolbar','./OverflowToolbarRenderer','./Toolbar'],function(O,a,T){"use strict";
var A=O.extend("sap.m.AssociativeOverflowToolbar",{
metadata:{associations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},
renderer:a
});
A.prototype.getContent=function(){var b=this.getAssociation("content")||[];return b.map(function(c){return sap.ui.getCore().byId(c);});};
A.prototype.exit=function(){O.prototype.exit.apply(this,arguments);return this._callToolbarMethod('destroyContent',[true]);};
A.prototype.indexOfContent=function(c){var b=this.getAssociation("content")||[];return b.indexOf(c.getId());};
A.prototype._callToolbarMethod=function(f,b){switch(f){case'addContent':return this.addAssociation("content",b[0]);case'getContent':return this.getContent();case'insertContent':return this.addAssociation("content",b[0],b[3]);case'removeContent':return sap.ui.getCore().byId(this.removeAssociation("content",b[0],b[1],b[2]))||null;case'destroyContent':var c=this.removeAllAssociation("content",b[0]).map(function(d){return sap.ui.getCore().byId(d);});c.forEach(function(d){if(d){d.destroy();}});return this;case'removeAllContent':return this.removeAllAssociation("content",b[0]).map(function(d){return sap.ui.getCore().byId(d);});default:return T.prototype[f].apply(this,b);}};
return A;});
sap.ui.predefine('sap/m/Bar',['jquery.sap.global','./BarInPageEnabler','./library','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/Device','./BarRenderer'],function(q,B,l,C,R,D,a){"use strict";var b=l.BarDesign;
var c=C.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:b.Auto}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/Bar.designtime"}});
c.prototype.onBeforeRendering=function(){this._removeAllListeners();};
c.prototype.onAfterRendering=function(){this._handleResize();};
c.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};
c.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null;}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null;};
c._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];
c.prototype._removeAllListeners=function(){var t=this;c._aResizeHandlers.forEach(function(i){t._removeListenerFailsave(i);});};
c.prototype._removeListenerFailsave=function(L){if(this[L]){R.deregister(this[L]);this[L]=null;}};
c.prototype._handleResize=function(){this._removeAllListeners();var e=!!this.getContentLeft().length,f=!!this.getContentMiddle().length,g=!!this.getContentRight().length;if(!this.getVisible()){return;}if(!e&&!f&&!g){return;}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._updatePosition(e,f,g);this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._handleResize,this));if(this.getEnableFlexBox()){return;}if(e){this._sResizeListenerIdLeft=R.register(this._$LeftBar[0],q.proxy(this._handleResize,this));}if(f){this._sResizeListenerIdMid=R.register(this._$MidBarPlaceHolder[0],q.proxy(this._handleResize,this));}if(g){this._sResizeListenerIdRight=R.register(this._$RightBar[0],q.proxy(this._handleResize,this));}};
c.prototype._updatePosition=function(e,f,g){if(!e&&!g&&f){return;}if(e&&!f&&!g){return;}if(!e&&!f&&g){return;}var i=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:'hidden'});var r=this._$RightBar.outerWidth(true);if(r>i){if(e){this._$LeftBar.css({width:"0px"});}if(f){this._$MidBarPlaceHolder.css({width:"0px"});}this._$RightBar.css({width:i+"px"});return;}var L=this._getBarContainerWidth(this._$LeftBar);if(i<(L+r)){L=i-r;this._$LeftBar.css({width:L+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return;}this._$MidBarPlaceHolder.css(this._getMidBarCss(r,i,L));};
c.prototype._getMidBarCss=function(r,i,L){var m=this._$MidBarPlaceHolder.outerWidth(true),e=sap.ui.getCore().getConfiguration().getRTL(),s=e?"right":"left",M={visibility:""};if(this.getEnableFlexBox()){m=i-L-r-parseInt(this._$MidBarPlaceHolder.css('margin-left'),10)-parseInt(this._$MidBarPlaceHolder.css('margin-right'),10);M.position="absolute";M.width=m+"px";M[s]=L;return M;}var S=i-L-r,f=(i/2)-(m/2),g=L>f,h=(i/2)+(m/2),j=(i-r)<h;if(S>0&&(g||j)){M.position="absolute";M.width=S+"px";M.left=e?r:L;}return M;};
c.prototype._getBarContainerWidth=function($){var i,e=0,f=$.children(),g=0;if(D.browser.webkit||D.browser.firefox||D.browser.edge){for(i=0;i<f.length;i++){g+=q(f[i]).outerWidth(true);}e=$.outerWidth(true);}else{var o;for(i=0;i<f.length;i++){o=window.getComputedStyle(f[i]);if(o.width=="auto"){g+=q(f[i]).width()+1;}else{g+=parseFloat(o.width);}g+=parseFloat(o.marginLeft);g+=parseFloat(o.marginRight);g+=parseFloat(o.paddingLeft);g+=parseFloat(o.paddingRight);}var h=window.getComputedStyle($[0]);e+=parseFloat(h.width);e+=parseFloat(h.marginLeft);e+=parseFloat(h.marginRight);e+=parseFloat(h.paddingLeft);e+=parseFloat(h.paddingRight);}if(e<g){e=g;}return e;};
var d=B.extend("sap.m.BarInAnyContentEnabler",{});
d.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer"}};
d.prototype.getContext=function(){var p=B.prototype.getContext.call();for(var k in d.mContexts){p[k]=d.mContexts[k];}return p;};
c.prototype.getContext=d.prototype.getContext;c.prototype.isContextSensitive=d.prototype.isContextSensitive;c.prototype.setHTMLTag=d.prototype.setHTMLTag;c.prototype.getHTMLTag=d.prototype.getHTMLTag;c.prototype.applyTagAndContextClassFor=d.prototype.applyTagAndContextClassFor;c.prototype._applyContextClassFor=d.prototype._applyContextClassFor;c.prototype._applyTag=d.prototype._applyTag;c.prototype._getContextOptions=d.prototype._getContextOptions;c.prototype._setRootAccessibilityRole=d.prototype._setRootAccessibilityRole;c.prototype._getRootAccessibilityRole=d.prototype._getRootAccessibilityRole;return c;});
sap.ui.predefine('sap/m/BarInPageEnabler',['sap/ui/base/Object','sap/m/library','jquery.sap.global'],function(O,l,q){"use strict";var I=l.IBarHTMLTag;var c={footer:{contextClass:"sapMFooter-CTX sapContrast sapContrastPlus",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"},header:{contextClass:"sapMHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_HEADER"},subheader:{contextClass:"sapMSubHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_SUBHEADER"}};var a="sapMIBar";
var B=O.extend("sap.m.BarInPageEnabler",{
isContextSensitive:function(){return this.getDesign&&this.getDesign()==="Auto";},
setHTMLTag:function(n){if(n===this.sTag){return this;}this.sTag=n;return this;},
getHTMLTag:function(){if(!this.hasOwnProperty("sTag")){this.sTag=I.Div;}return this.sTag;},
getContext:function(){return c;},
_getRootAccessibilityRole:function(){var r=this._sRootAccessibilityRole||"toolbar";return r;},
_setRootAccessibilityRole:function(r){this._sRootAccessibilityRole=r;return this;},
applyTagAndContextClassFor:function(C){this._applyTag(C);return this._applyContextClassFor(C);},
_applyContextClassFor:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.isContextSensitive){q.sap.log.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}if(!this.getRenderer().shouldAddIBarContext()){this.addStyleClass(a+"-CTX");}if(this.isContextSensitive()){this.addStyleClass(o.contextClass);}return this;},
_applyTag:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.setHTMLTag){q.sap.log.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}this.setHTMLTag(o.tag);return this;},
_getContextOptions:function(C){var o;if(this.getContext){o=this.getContext();}else{o=c;}var b=o[C];if(!b){q.sap.log.error("The context "+C+" is not known",this);return null;}return b;},
render:function(r,C){var t=C.getHTMLTag().toLowerCase();r.write("<"+t);r.addClass(a);if(this.shouldAddIBarContext(C)){r.addClass(a+"-CTX");}r.writeControlData(C);B.renderTooltip(r,C);this.decorateRootElement(r,C);r.writeClasses();r.writeStyles();r.write(">");this.renderBarContent(r,C);r.write("</"+t+">");}
});
B.renderTooltip=function(r,C){var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}};
B.addChildClassTo=function(C){C.addStyleClass("sapMBarChild");};
return B;});
sap.ui.predefine('sap/m/BarRenderer',['jquery.sap.global','./BarInPageEnabler','sap/ui/Device'],function(q,B,D){"use strict";var a={};a.render=B.prototype.render;
a.decorateRootElement=function(r,c){r.addClass("sapMBar");r.addClass(this.getContext(c));r.writeAccessibilityState(c,{"role":c._getRootAccessibilityRole()});if(c.getTranslucent()&&(D.support.touch||q.sap.simulateMobileOnDesktop)){r.addClass("sapMBarTranslucent");}r.addClass("sapMBar-CTX");};
a.shouldAddIBarContext=function(){return true;};
a.renderBarContent=function(r,c){var C="</div>";r.write("<div id='"+c.getId()+"-BarLeft' ");r.addClass('sapMBarLeft');r.addClass('sapMBarContainer');r.writeClasses();w("left",r,c);r.write(">");this.renderAllControls(c.getContentLeft(),r,c);r.write(C);r.write("<div id='"+c.getId()+"-BarMiddle' ");r.addClass('sapMBarMiddle');r.writeClasses();r.write(">");if(c.getEnableFlexBox()){c._oflexBox=c._oflexBox||new sap.m.HBox(c.getId()+"-BarPH",{alignItems:"Center"}).addStyleClass("sapMBarPH").setParent(c,null,true);var b=!!c.getContentLeft().length,d=!!c.getContentMiddle().length,e=!!c.getContentRight().length;if(d&&!b&&!e){c._oflexBox.addStyleClass("sapMBarFlexBoxWidth100");}c.getContentMiddle().forEach(function(m){c._oflexBox.addItem(m);});r.renderControl(c._oflexBox);}else{r.write("<div id='"+c.getId()+"-BarPH' ");r.addClass('sapMBarPH');r.addClass('sapMBarContainer');w("middle",r,c);r.writeClasses();r.write(">");this.renderAllControls(c.getContentMiddle(),r,c);r.write(C);}r.write(C);r.write("<div id='"+c.getId()+"-BarRight'");r.addClass('sapMBarRight');r.addClass('sapMBarContainer');if(sap.ui.getCore().getConfiguration().getRTL()){r.addClass("sapMRTL");}r.writeClasses();w("right",r,c);r.write(">");this.renderAllControls(c.getContentRight(),r,c);r.write(C);};
a.renderAllControls=function(c,r,b){c.forEach(function(C){B.addChildClassTo(C,b);r.renderControl(C);});};
a._mContexts={Header:"sapMHeader-CTX",SubHeader:"sapMSubHeader-CTX",Footer:"sapMFooter-CTX",Default:"sapMContent-CTX"};
a.getContext=function(c){var d=c.getDesign(),C=a._mContexts;return C[d]||C.Default;};
function w(A,r,c){var C=!!c.getContentLeft().length,b=!!c.getContentMiddle().length,d=!!c.getContentRight().length;function e(){r.addStyle("width","100%");r.writeStyles();}switch(A.toLowerCase()){case"left":if(C&&!b&&!d){e();}break;case"middle":if(b&&!C&&!d){e();}break;case"right":if(d&&!C&&!b){e();}break;default:q.sap.log.error("Cannot determine which of the three content aggregations is alone");}}
return a;},true);
sap.ui.predefine('sap/m/Breadcrumbs',["sap/ui/core/Control","sap/m/Text","sap/m/Link","sap/m/Select","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device","sap/m/library","./BreadcrumbsRenderer"],function(C,T,L,S,I,a,R,b,D,l,B){"use strict";var c=l.SelectType;
var d=C.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",interfaces:["sap.m.IBreadcrumbs"],designtime:"sap/m/designtime/Breadcrumbs.designtime",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links"}});
d.prototype.onBeforeRendering=function(){this.bRenderingPhase=true;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._bControlsInfoCached){this._updateSelect(true);}};
d.prototype.onAfterRendering=function(){if(!this._sResizeListenerId){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}if(!this._bControlsInfoCached){this._updateSelect(true);return;}this._configureKeyboardHandling();this.bRenderingPhase=false;};
d.prototype.onThemeChanged=function(){this._resetControl();};
d.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();};
d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
d.prototype._getAugmentedId=function(s){return this.getId()+"-"+s;};
d.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new S({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:b.getIconURI("slim-arrow-down"),type:c.IconOnly,tooltip:B._getResourceBundleText("BREADCRUMB_SELECT_TOOLTIP")})));}return this.getAggregation("_select");};
d.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){this.setAggregation("_currentLocation",new T({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation"));}return this.getAggregation("_currentLocation");};
function f(A,e){var g=Array.prototype.slice.apply(e);g.unshift(A);return g;}
d.prototype.insertLink=function(o,i){var r=this.insertAggregation.apply(this,f("links",arguments));this._registerControlListener(o);this._resetControl();return r;};
d.prototype.addLink=function(o){var r=this.addAggregation.apply(this,f("links",arguments));this._registerControlListener(o);this._resetControl();return r;};
d.prototype.removeLink=function(o){var r=this.removeAggregation.apply(this,f("links",arguments));this._deregisterControlListener(r);this._resetControl();return r;};
d.prototype.removeAllLinks=function(){var e=this.getAggregation("links",[]);var r=this.removeAllAggregation.apply(this,f("links",arguments));e.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
d.prototype.destroyLinks=function(){var e=this.getAggregation("links",[]);var r=this.destroyAggregation.apply(this,f("links",arguments));e.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
d.prototype._decorateSelect=function(s){s.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);s._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);s._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);s.onsapescape=this._onSelectEscPress.bind(this);return s;};
d.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation());};
d.prototype._onSelectBeforeOpenDialog=function(){var s=this._getSelect();if(this.getCurrentLocationText()&&D.system.phone){s.setSelectedIndex(0);}else{s.setSelectedItem(null);}S.prototype._onBeforeOpenDialog.call(s);this._removeItemNavigation();};
d.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation();};
d.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation());};
d.prototype._onSelectEscPress=function(){this._getSelect().close();};
d.prototype._createSelectItem=function(i){return new I({key:i.getId(),text:i.getText()});};
d.prototype._selectChangeHandler=function(e){var o,s,g,h=e.getParameter("selectedItem");if(!h){return;}if(!this._getSelect().isOpen()){return;}o=sap.ui.getCore().byId(h.getKey());if(!(o instanceof L)){return;}s=o.getHref();g=o.getTarget();o.firePress();if(s){if(g){window.open(s,g);}else{window.location.href=s;}}};
d.prototype._getItemsForMobile=function(){var i=this.getLinks();if(this.getCurrentLocationText()){i.push(this._getCurrentLocation());}return i;};
d.prototype._updateSelect=function(i){var s=this._getSelect(),e,o=this._getControlDistribution();if(!this._bControlDistributionCached||i){s.destroyItems();e=D.system.phone?this._getItemsForMobile():o.aControlsForSelect;e.map(this._createSelectItem).reverse().forEach(s.insertItem,s);this._bControlDistributionCached=true;this.invalidate(this);}s.setVisible(!!o.aControlsForSelect.length);if(!this._sResizeListenerId&&!this.bRenderingPhase){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}};
d.prototype._getControlsForBreadcrumbTrail=function(){var v;if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail;}v=this.getLinks().filter(function(o){return o.getVisible();});if(this.getCurrentLocationText()){return v.concat([this._getCurrentLocation()]);}return v;};
d.prototype._getControlInfo=function(o){return{id:o.getId(),control:o,width:o.$().parent().outerWidth(true),bCanOverflow:o instanceof L};};
d.prototype._getControlDistribution=function(m){m=m||this._iContainerSize;this._iContainerSize=m;this._oDistributedControls=this._determineControlDistribution(m);return this._oDistributedControls;};
d.prototype._getSelectWidth=function(){return this._getSelect().getVisible()&&this._iSelectWidth||0;};
d.prototype._determineControlDistribution=function(m){var i,o,e=this._getControlsInfo().aControlInfo,s=this._getSelectWidth(),g=[],h=[],u=s;for(i=e.length-1;i>=0;i--){o=e[i];u+=o.width;if(e.length-1===i){h.push(o.control);continue;}if(i===0){u-=s;}if(u>m&&o.bCanOverflow){g.unshift(o.control);}else{h.unshift(o.control);}}return{aControlsForBreadcrumbTrail:h,aControlsForSelect:g};};
d.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=this._getSelect().$().parent().outerWidth(true)||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=this.$().outerWidth(true);this._bControlsInfoCached=true;}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize};};
d.prototype._handleScreenResize=function(e){var i=this._oDistributedControls.aControlsForBreadcrumbTrail.length,o=this._getControlDistribution(e.size.width),g=o.aControlsForBreadcrumbTrail.length;if(i!==g){this._updateSelect(true);}return this;};
d.prototype._getItemsToNavigate=function(){var i=this._getControlsForBreadcrumbTrail().slice(),s=this._getSelect();if(s.getVisible()){i.unshift(s);}return i;};
d.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new a();}return this._itemNavigation;};
d.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null;}};
d.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),s=-1,e=this._getItemsToNavigate(),n=[];if(e.length===0){return;}e.forEach(function(o,g){if(g===0){o.$().attr("tabIndex","0");}o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});i.setCycling(false);i.setPageSize(d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);i.setRootDomRef(this.getDomRef());i.setItemDomRefs(n);i.setSelectedIndex(s);return this;};
d.prototype._registerControlListener=function(o){if(o){o.attachEvent("_change",this._resetControl,this);}};
d.prototype._deregisterControlListener=function(o){if(o){o.detachEvent("_change",this._resetControl,this);}};
d.prototype.setCurrentLocationText=function(t){var o=this._getCurrentLocation(),r=this.setProperty("currentLocationText",t,true);if(o.getText()!==t){o.setText(t);this._resetControl();}return r;};
d.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this;};
return d;});
sap.ui.predefine('sap/m/BreadcrumbsRenderer',["sap/m/Text"],function(T){"use strict";var B={};
B.render=function(r,c){var C=c._getControlsForBreadcrumbTrail(),s=c._getSelect();r.write("<ul");r.writeControlData(c);r.addClass("sapMBreadcrumbs");r.writeClasses();r.writeAttribute("role","navigation");r.writeAttributeEscaped("aria-label",B._getResourceBundleText("BREADCRUMB_LABEL"));r.write(">");if(s.getVisible()){this._renderControlInListItem(r,s,false,"sapMBreadcrumbsSelectItem");}C.forEach(function(o){this._renderControlInListItem(r,o,o instanceof T);},this);r.write("</ul>");};
B._renderControlInListItem=function(r,c,s,a){r.write("<li");r.writeAttribute("role","presentation");r.writeAttribute("aria-hidden","true");r.addClass("sapMBreadcrumbsItem");r.addClass(a);r.writeClasses();r.write(">");r.renderControl(c);if(!s){r.write("<span");r.addClass("sapMBreadcrumbsSeparator");r.writeClasses();r.write(">/</span>");}r.write("</li>");};
B._getResourceBundleText=function(t){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(t);};
return B;},true);
sap.ui.predefine('sap/m/BusyDialog',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Dialog','sap/m/BusyIndicator','sap/m/Label','sap/m/Button'],function(q,l,C,D,B,L,a,P,b){"use strict";
var c=C.extend("sap.m.BusyDialog",{
metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:''},title:{type:"string",group:"Appearance",defaultValue:''},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},cancelButtonText:{type:"string",group:"Misc",defaultValue:''},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{close:{parameters:{cancelPressed:{type:"boolean"}}}},designtime:"sap/m/designtime/BusyDialog.designtime"},
renderer:function(r,o){}
});
c.prototype.init=function(){this._busyIndicator=new B(this.getId()+'-busyInd',{visible:true});function o(){if(sap.ui.getCore().getConfiguration().getAccessibility()){this._$content.attr('role','application');}}this._oDialog=new D(this.getId()+'-Dialog',{content:this._busyIndicator,showHeader:false,afterOpen:o,afterClose:this._fnCloseHandler.bind(this),initialFocus:this._busyIndicator}).addStyleClass('sapMBusyDialog');this._oDialog.close=function(){};this._oDialog.addEventDelegate({onBeforeRendering:function(){var t=this.getText(),d=this.getTitle(),s=this.getShowCancelButton()||this.getCancelButtonText();if(!t&&!d&&!s){this._oDialog.addStyleClass('sapMBusyDialog-Light');}else{this._oDialog.removeStyleClass('sapMBusyDialog-Light');}}},this);this._oDialog.oPopup.onsapescape=function(e){this.close(true);}.bind(this);};
c.prototype.exit=function(){this._busyIndicator.destroy();this._busyIndicator=null;if(this._cancelButton){this._cancelButton.destroy();this._cancelButton=null;}if(this._oLabel){this._oLabel.destroy();this._oLabel=null;}if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}};
c.prototype.open=function(){q.sap.log.debug("sap.m.BusyDialog.open called at "+new Date().getTime());if(this.getAriaLabelledBy()&&!this._oDialog._$dialog){var t=this;this.getAriaLabelledBy().forEach(function(i){t._oDialog.addAriaLabelledBy(i);});}if(!document.body||!sap.ui.getCore().isInitialized()){setTimeout(function(){this.open();}.bind(this),50);}else{this._oDialog.open();}return this;};
c.prototype.close=function(i){this._isClosedFromUserInteraction=i;D.prototype.close.call(this._oDialog);return this;};
c.prototype._fnCloseHandler=function(){this.fireClose({cancelPressed:this._isClosedFromUserInteraction||false});};
c.prototype.setTitle=function(t){this.setProperty('title',t,true);this._oDialog.setTitle(t).setShowHeader(!!t);return this;};
c.prototype.setTooltip=function(t){this._oDialog.setTooltip(t);return this;};
c.prototype.getTooltip=function(){this._oDialog.getTooltip();return this;};
c.prototype.setText=function(t){this.setProperty('text',t,true);if(!this._oLabel){if(t){this._oLabel=new L(this.getId()+'-TextLabel',{text:t}).addStyleClass('sapMBusyDialogLabel');this._oDialog.insertAggregation('content',this._oLabel,0);this._oDialog.addAriaLabelledBy(this._oLabel.getId());}}else{if(t){this._oLabel.setText(t).setVisible(true);}else{this._oLabel.setVisible(false);}}return this;};
c.prototype.setCustomIcon=function(i){this.setProperty("customIcon",i,true);this._busyIndicator.setCustomIcon(i);return this;};
c.prototype.setCustomIconRotationSpeed=function(s){this.setProperty("customIconRotationSpeed",s,true);this._busyIndicator.setCustomIconRotationSpeed(s);return this;};
c.prototype.setCustomIconDensityAware=function(i){this.setProperty("customIconDensityAware",i,true);this._busyIndicator.setCustomIconDensityAware(i);return this;};
c.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._busyIndicator.setCustomIconWidth(w);return this;};
c.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._busyIndicator.setCustomIconHeight(h);return this;};
c.prototype.setShowCancelButton=function(i){this.setProperty("showCancelButton",i,false);if(i){this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
c.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,false);if(t){this._getCancelButton().setText(t);this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
c.prototype.getDomRef=function(){return this._oDialog&&this._oDialog.getDomRef();};
c.prototype._destroyTheCancelButton=function(){this._oDialog.destroyEndButton();this._cancelButton=null;};
c.prototype._getCancelButton=function(){var d=this.getCancelButtonText();d=d?d:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");return this._cancelButton?this._cancelButton:this._cancelButton=new a(this.getId()+'busyCancelBtn',{text:d,press:function(){this.close(true);}.bind(this)});};
return c;});
sap.ui.predefine('sap/m/BusyIndicator',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/library',"./BusyIndicatorRenderer"],function(q,l,C,c,B){"use strict";var T=c.TextDirection;
var a=C.extend("sap.m.BusyIndicator",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:""},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"1rem"},design:{type:"string",group:"Appearance",defaultValue:"auto"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
a.prototype.init=function(){this.setBusyIndicatorDelay(0);};
a.prototype.setText=function(t){this.setProperty("text",t,true);this._createLabel("setText",t);return this;};
a.prototype.setTextDirection=function(d){this.setProperty("textDirection",d,true);this._createLabel("setTextDirection",d);return this;};
a.prototype.setCustomIcon=function(s){this.setProperty("customIcon",s,false);this._createCustomIcon("setSrc",s);return this;};
a.prototype.setCustomIconRotationSpeed=function(s){if(isNaN(s)||s<0){s=0;}if(s!==this.getCustomIconRotationSpeed()){this.setProperty("customIconRotationSpeed",s,true);this._setRotationSpeed();}return this;};
a.prototype.setCustomIconDensityAware=function(A){this.setProperty("customIconDensityAware",A,true);this._createCustomIcon("setDensityAware",A);return this;};
a.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._createCustomIcon("setWidth",w);return this;};
a.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._createCustomIcon("setHeight",h);return this;};
a.prototype.setSize=function(s){this.setProperty("size",s,true);var d=this.getDomRef();if(d){d.style.fontSize=s;}return this;};
a.prototype.onBeforeRendering=function(){if(this.getCustomIcon()){this.setBusy(false);}else{this.setBusy(true,"busy-area");}};
a.prototype.exit=function(){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._busyLabel){this._busyLabel.destroy();this._busyLabel=null;}};
a.prototype._createCustomIcon=function(n,v){if(!this._iconImage){this._iconImage=new sap.m.Image(this.getId()+"-icon",{width:"44px",height:"44px"}).addStyleClass("sapMBsyIndIcon");this._iconImage.addEventDelegate({onAfterRendering:function(){this._setRotationSpeed();}},this);}this._iconImage[n](v);this._setRotationSpeed();};
a.prototype._createLabel=function(n,v){if(!this._busyLabel){this._busyLabel=new sap.m.Label(this.getId()+"-label",{labelFor:this.getId(),textAlign:"Center"});}this._busyLabel[n](v);};
a.prototype._setRotationSpeed=function(){if(!this._iconImage){return;}if(q.support.cssAnimations){var $=this._iconImage.$();var r=this.getCustomIconRotationSpeed()+"ms";$.css("-webkit-animation-duration",r).css("animation-duration",r);$.css("display","none");setTimeout(function(){$.css("display","inline");},0);}else{this._rotateCustomIcon();}};
a.prototype._rotateCustomIcon=function(){if(!this._iconImage){return;}var $=this._iconImage.$();if(!$[0]||!$[0].offsetWidth){return;}var r=this.getCustomIconRotationSpeed();if(!r){return;}if(!this._fnRotateCustomIcon){this._fnRotateCustomIcon=q.proxy(this._rotateCustomIcon,this);}var R=this._fnRotateCustomIcon;if(!this._$CustomRotator){this._$CustomRotator=q({deg:0});}var b=this._$CustomRotator;if(b.running){return;}b[0].deg=0;b.animate({deg:360},{duration:r,easing:"linear",step:function(n){b.running=true;$.css("-ms-transform",'rotate('+n+'deg)');},complete:function(){b.running=false;window.setTimeout(R,10);}});};
return a;});
sap.ui.predefine('sap/m/BusyIndicatorRenderer',[],function(){"use strict";var B={};
B.render=function(r,b){this.startBusyIndicator(r,b);this.renderBusyIndication(r,b);this.renderLabel(r,b);this.endBusyIndicator(r);};
B.startBusyIndicator=function(r,b){var a={role:"progressbar",valuemin:"0",valuemax:"100"};r.write("<div tabindex='0' ");r.writeControlData(b);r.addClass("sapMBusyIndicator");r.writeClasses();r.addStyle("font-size",b.getSize());r.writeStyles();r.writeAccessibilityState(b,a);this.renderTooltip(r,b.getTooltip_AsString());r.write(">");};
B.renderTooltip=function(r,t){if(t){r.writeAttributeEscaped("title",t);}};
B.renderBusyIndication=function(r,b){if(b.getCustomIcon()){r.renderControl(b._iconImage);}else{r.write("<div class='sapMBusyIndicatorBusyArea'");r.writeAttribute("id",b.getId()+"-busy-area");r.write("></div>");}};
B.renderLabel=function(r,b){if(b.getText()){r.renderControl(b._busyLabel);}};
B.endBusyIndicator=function(r){r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/m/Button',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/ContextMenuSupport','sap/ui/core/library','./ButtonRenderer','jquery.sap.keycodes'],function(q,l,C,E,I,D,a,c,B){"use strict";var T=c.TextDirection;var b=l.ButtonType;
var d=C.extend("sap.m.Button",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:b.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}},designtime:"sap/m/designtime/Button.designtime"}});
E.call(d.prototype);a.apply(d.prototype);
d.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._iconBtn){this._iconBtn.destroy();}};
d.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;};
d.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive;}};
d.prototype.ontouchstart=function(e){e.setMarked();if(this._bRenderActive){delete this._bRenderActive;}if(e.targetTouches.length===1){this._activeButton();}if(this.getEnabled()&&this.getVisible()){if(D.browser.safari&&(e.originalEvent&&e.originalEvent.type==="mousedown")){this.focus();e.preventDefault();}}};
d.prototype.ontouchend=function(e){this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;if(e.originalEvent&&e.originalEvent.type in{mouseup:1,touchend:1}){this.ontap(e);}}};
d.prototype.ontouchcancel=function(){this._inactiveButton();};
d.prototype.ontap=function(e){e.setMarked();if(this.getEnabled()&&this.getVisible()){if((e.originalEvent&&e.originalEvent.type==="touchend")){this.focus();}this.fireTap({});this.firePress({});}};
d.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){e.setMarked();this._activeButton();}if(e.which===q.sap.KeyCodes.ENTER){this.firePress({});}};
d.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){e.setMarked();this._inactiveButton();}if(e.which===q.sap.KeyCodes.SPACE){this.firePress({});}};
d.prototype.onfocusout=function(){this._inactiveButton();};
d.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive");}this._bActive=this.getEnabled();if(this._bActive){if(this.getIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon());}}};
d.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive");}this._bActive=false;if(this.getEnabled()){if(this.getIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getIcon());}}};
d.prototype._isHoverable=function(){return this.getEnabled()&&D.system.desktop;};
d.prototype._getImage=function(i,s,A,e){if(this._image&&(this._image.getSrc()!==s)){this._image.destroy();this._image=undefined;}var o=this._image;var f=this.getIconFirst();if(!!o){o.setSrc(s);if(o instanceof sap.m.Image){o.setActiveSrc(A);o.setDensityAware(e);}}else{o=I.createControlByURI({id:i,src:s,activeSrc:A,densityAware:e,useIconTooltip:false},sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.toggleStyleClass("sapMBtnIconLeft",f);o.toggleStyleClass("sapMBtnIconRight",!f);this._image=o;return this._image;};
d.prototype._getInternalIconBtn=function(i,s){var o=this._iconBtn;if(o){o.setSrc(s);}else{o=I.createControlByURI({id:i,src:s,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.addStyleClass("sapMBtnIconLeft");this._iconBtn=o;return this._iconBtn;};
d.prototype._isUnstyled=function(){var u=false;if(this.getType()===b.Unstyled){u=true;}return u;};
d.prototype.setText=function(t){var v=this.getText();if(t===null||t===undefined){t="";}if(v!==t){var o=this.getDomRef("content");var s=!!o;this.setProperty("text",t,s);if(s){t=this.getText();o.innerHTML=q.sap.encodeHTML(t);this.$("inner").toggleClass("sapMBtnText",!!t);}}return this;};
d.prototype.setIcon=function(i){var v=this.getIcon()||"";i=i||"";if(v!==i){var s=!!v&&!!i&&I.isIconURI(i)===I.isIconURI(v);this.setProperty("icon",i,s);if(s&&this._image){this._image.setSrc(i);}}return this;};
d.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner");};
d.prototype._getText=function(){return this.getText();};
d.prototype._getTooltip=function(){var t=this.getTooltip_AsString();if(!t&&!this.getText()){var i=I.getIconInfo(this.getIcon());if(i&&i.text){t=i.text;}}return t;};
d.prototype.getAccessibilityInfo=function(){var s=this.getText()||this.getTooltip_AsString();if(!s&&this.getIcon()){var i=I.getIconInfo(this.getIcon());if(i){s=i.text||i.name;}}return{role:"button",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:s,focusable:this.getEnabled(),enabled:this.getEnabled()};};
return d;});
sap.ui.predefine('sap/m/ButtonRenderer',['jquery.sap.global','sap/ui/Device','sap/ui/core/library','sap/ui/core/IconPool','sap/m/library','sap/ui/core/InvisibleText'],function(q,D,c,I,l,a){"use strict";var B=l.ButtonType;var T=c.TextDirection;var b={};
b.render=function(R,o){var t=o.getType();var e=o.getEnabled();var w=o.getWidth();var s=o._getTooltip();var d=o._getText();var f=o.getTextDirection();var i=D.browser.internet_explorer||D.browser.edge;var g=(f===T.Inherit)&&!i;var h=I.getIconURI("nav-back");R.write("<button");R.writeControlData(o);R.addClass("sapMBtnBase");if(!o._isUnstyled()){R.addClass("sapMBtn");if((t===B.Back||t===B.Up)&&o.getIcon()&&!d){R.addClass("sapMBtnBack");}}var m={};var j=b.getButtonTypeAriaLabelId(t);if(j){m["describedby"]={value:j,append:true};}if(d&&o.getAriaLabelledBy()&&o.getAriaLabelledBy().length>0){m["labelledby"]={value:o.getId()+"-content",append:true};}if(this.renderAccessibilityAttributes){this.renderAccessibilityAttributes(R,o,m);}R.writeAccessibilityState(o,m);if(!e){R.writeAttribute("disabled","disabled");if(!o._isUnstyled()){R.addClass("sapMBtnDisabled");}}else{switch(t){case B.Accept:case B.Reject:case B.Emphasized:R.addClass("sapMBtnInverted");break;default:break;}}if(s){R.writeAttributeEscaped("title",s);}R.writeClasses();if(w!=""||w.toLowerCase()==="auto"){R.addStyle("width",w);R.writeStyles();}r(o,R);R.write(">");R.write("<span");R.writeAttribute("id",o.getId()+"-inner");if(!o._isUnstyled()){R.addClass("sapMBtnInner");}if(o._isHoverable()){R.addClass("sapMBtnHoverable");}if(e){R.addClass("sapMFocusable");if(i){R.addClass("sapMIE");}}if(!o._isUnstyled()){if(d){R.addClass("sapMBtnText");}if(t===B.Back||t===B.Up){R.addClass("sapMBtnBack");}if(o.getIcon()){if(o.getIconFirst()){R.addClass("sapMBtnIconFirst");}else{R.addClass("sapMBtnIconLast");}}}if(this.renderButtonAttributes){this.renderButtonAttributes(R,o);}if(!o._isUnstyled()&&t!==""){R.addClass("sapMBtn"+q.sap.encodeHTML(t));}R.writeClasses();r(o,R);R.write(">");if(t===B.Back||t===B.Up){this.writeInternalIconPoolHtml(R,o,h);}if(o.getIcon()){this.writeImgHtml(R,o);}if(d){R.write("<span ");R.addClass("sapMBtnContent");if(f!==T.Inherit){R.writeAttribute("dir",f.toLowerCase());}R.writeClasses();R.writeAttribute("id",o.getId()+"-content");R.write(">");if(g){R.write("<bdi>");}R.writeEscaped(d);if(g){R.write("</bdi>");}R.write("</span>");}if(i&&e){R.write('<span class="sapMBtnFocusDiv"></span>');}R.write("</span>");R.write("</button>");};
b.writeImgHtml=function(R,o){R.renderControl(o._getImage((o.getId()+"-img"),o.getIcon(),o.getActiveIcon(),o.getIconDensityAware()));};
b.writeInternalIconPoolHtml=function(R,o,u){R.renderControl(o._getInternalIconBtn((o.getId()+"-iconBtn"),u));};
function r(o,R){if(o._bExcludeFromTabChain){R.writeAttribute("tabindex",-1);}}
var A={Accept:"BUTTON_ARIA_TYPE_ACCEPT",Reject:"BUTTON_ARIA_TYPE_REJECT",Emphasized:"BUTTON_ARIA_TYPE_EMPHASIZED"};
b.getButtonTypeAriaLabelId=function(t){return a.getStaticId("sap.m",A[t]);};
return b;},true);
sap.ui.predefine('sap/m/Carousel',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/library','./CarouselRenderer','sap/ui/thirdparty/mobify-carousel','sap/ui/core/IconPool','jquery.sap.keycodes'],function(q,l,C,D,R,c,a){"use strict";var B=c.BusyIndicatorSize;var I=l.ImageHelper;var b=l.CarouselArrowsPlacement;var P=l.PlacementType;
var d=C.extend("sap.m.Carousel",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Carousel.designtime",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:P.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:b.Content}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"}}}}}});
d._INNER_SELECTOR=".sapMCrslInner";d._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";d._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";d._CONTROLS=".sapMCrslControls";d._ITEM_SELECTOR=".sapMCrslItem";d._LEFTMOST_CLASS="sapMCrslLeftmost";d._RIGHTMOST_CLASS="sapMCrslRightmost";d._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";d._MODIFIERNUMBERFORKEYBOARDHANDLING=10;d._BULLETS_TO_NUMBERS_THRESHOLD=9;
d.prototype.init=function(){this._aScrollContainers=[];this._fnAdjustAfterResize=q.proxy(function(){var $=this.$().find(d._INNER_SELECTOR);this._oMobifyCarousel.resize($);},this);this.data("sap-ui-fastnavgroup","true",true);};
d.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('afterSlide');this._cleanUpScrollContainer();this._fnAdjustAfterResize=null;this._aScrollContainers=null;this._$InnerDiv=null;};
d.prototype._cleanUpScrollContainer=function(){var s;while(this._aScrollContainers&&this._aScrollContainers.length>0){s=this._aScrollContainers.pop();s.removeAllContent();if(s&&typeof s.destroy==='function'){s.destroy();}}};
d.prototype.ontouchstart=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchstart(e);}};
d.prototype.ontouchmove=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(e);}};
d.prototype.ontouchend=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchend(e);}};
d.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}return this;};
d.prototype.onAfterRendering=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();}this.$().carousel();this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(sap.ui.getCore().getConfiguration().getRTL());var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{var o=sap.ui.getCore();if(o.isThemeApplied()){this._moveToPage(i+1);}else{o.attachThemeChanged(this._handleThemeLoad,this);}if(sap.zen&&sap.zen.commons&&this.getParent()instanceof sap.zen.commons.layout.PositionContainer){if(this._isCarouselUsedWithCommonsLayout===undefined){q.sap.delayedCall(0,this,"invalidate");this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('afterSlide',q.proxy(function(e,f,n){if(e.target!==this.getDomRef()){return;}if(n>0){this._changePage(n);}},this));this._$InnerDiv=this.$().find(d._INNER_SELECTOR)[0];this._sResizeListenerId=R.register(this._$InnerDiv,this._fnAdjustAfterResize);this.$().find('.sapMCrslItemTableCell').focus(function(e){e.preventDefault();q(e.target).parents('.sapMCrsl').focus();return false;});var s='sap.m.IconTabBar';var p=this.getParent();while(p){if(p.getMetadata().getName()==s){var t=this;p.attachExpand(function(e){var E=e.getParameter('expand');if(E&&i>0){t._moveToPage(i+1);}});break;}p=p.getParent();}};
d.prototype._handleThemeLoad=function(){var o,A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(i>0){this._moveToPage(i+1);}}o=sap.ui.getCore();o.detachThemeChanged(this._handleThemeLoad,this);};
d.prototype._moveToPage=function(i){this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i);this._changePage(i);};
d.prototype._changePage=function(n){this._adjustHUDVisibility(n);var o=this.getActivePage();var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);var t=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("CAROUSEL_PAGE_INDICATOR_TEXT",[n,this.getPages().length]);q.sap.log.debug("sap.m.Carousel: firing pageChanged event: old page: "+o+", new page: "+N);if(!D.system.desktop){q(document.activeElement).blur();}this.firePageChanged({oldActivePageId:o,newActivePageId:N});this.$('slide-number').text(t);};
d.prototype._adjustHUDVisibility=function(n){if(D.system.desktop&&!this.getLoop()&&this.getPages().length>1){var h=this.$('hud');h.removeClass(d._LATERAL_CLASSES);if(n===1){h.addClass(d._LEFTMOST_CLASS);}else if(n===this.getPages().length){h.addClass(d._RIGHTMOST_CLASS);}}};
d.prototype.setActivePage=function(p){var s=null;if(typeof(p)=='string'){s=p;}else if(p instanceof C){s=p.getId();}if(s){if(s===this.getActivePage()){return this;}var i=this._getPageNumber(s);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",s,true);return this;};
d.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",h);return this;};
d.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};
d.prototype.setLoop=function(L){this.setProperty("loop",L,true);if(this._oMobifyCarousel){this._oMobifyCarousel.setLoop(L);}return this;};
d.prototype._getNavigationArrow=function(n){var p={src:"sap-icon://slim-arrow-"+n,useIconTooltip:false};if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=I.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p);}return this._oArrowLeft;}else if(n==="right"){if(!this._oArrowRight){this._oArrowRight=I.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p);}return this._oArrowRight;}};
d.prototype._createScrollContainer=function(p){var i;var s=D.system.desktop&&this.getArrowsPlacement()===b.PageIndicator;if(s){i="sapMCrslImg";}else{i="sapMCrslImgNoArrows";}var f=p instanceof sap.m.Image?"sapMCrslItemTableCell "+i:"sapMCrslItemTableCell",o=new sap.ui.core.HTML({content:"<div class='sapMCrslItemTable'>"+"<div class='"+f+"'></div>"+"</div>",afterRendering:function(e){var r=sap.ui.getCore().createRenderManager();r.render(p,this.getDomRef().firstChild);r.destroy();p=null;}});var S=new sap.m.ScrollContainer({horizontal:false,vertical:false,content:[o],width:'100%',height:'100%'});S.setParent(this,null,true);this._aScrollContainers.push(S);return S;};
d.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.prev();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};
d.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.next();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};
d.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};
d.prototype.onsaptabprevious=function(e){this._bDirection=false;this._fnOnTabPress(e);};
d.prototype.onsaptabnext=function(e){this._bDirection=true;this._fnOnTabPress(e);};
d.prototype.onfocusin=function(e){this.saveLastFocusReference(e);this._bDirection=undefined;};
d.prototype.onsapskipforward=function(e){e.preventDefault();this._handleGroupNavigation(e,false);};
d.prototype.onsapskipback=function(e){e.preventDefault();this._handleGroupNavigation(e,true);};
d.prototype.onkeydown=function(e){if(e.keyCode==q.sap.KeyCodes.F7){this._handleF7Key(e);return;}if(e.target!=this.getDomRef()){return;}switch(e.keyCode){case 189:case q.sap.KeyCodes.NUMPAD_MINUS:this._fnSkipToIndex(e,-1);break;case q.sap.KeyCodes.PLUS:case q.sap.KeyCodes.NUMPAD_PLUS:this._fnSkipToIndex(e,1);break;}};
d.prototype.onsapescape=function(e){var f;if(e.target===this.$()[0]&&this._lastActivePageNumber){f=this._lastActivePageNumber+1;this._oMobifyCarousel.move(f);this._changePage(f);}};
d.prototype.onsapright=function(e){this._fnSkipToIndex(e,1);};
d.prototype.onsapup=function(e){this._fnSkipToIndex(e,-1);};
d.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1);};
d.prototype.onsapdown=function(e){this._fnSkipToIndex(e,1);};
d.prototype.onsaphome=function(e){this._fnSkipToIndex(e,0);};
d.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length);};
d.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,d._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
d.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,d._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
d.prototype.onsappageup=function(e){this._fnSkipToIndex(e,d._MODIFIERNUMBERFORKEYBOARDHANDLING);};
d.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-d._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
d.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-d._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
d.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-d._MODIFIERNUMBERFORKEYBOARDHANDLING);};
d.prototype._fnOnTabPress=function(e){if(e.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};
d.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown");e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=q.sap.KeyCodes.F6;E.shiftKey=s;q.sap.handleF6GroupNavigation(E);};
d.prototype.saveLastFocusReference=function(e){if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}this._lastFocusablePageElement[this.getActivePage()]=e.target;};
d.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this.getActivePage()];}};
d.prototype._fnSkipToIndex=function(e,n){var f=n;if(e.target!==this.getDomRef()){return;}e.preventDefault();if(n!==0){f=this._getPageNumber(this.getActivePage())+1+n;}this._oMobifyCarousel.move(f);};
d.prototype._handleF7Key=function(e){var A;e.preventDefault();A=this._getActivePageLastFocusedElement();if(e.target===this.$()[0]&&A){A.focus();}else{this.$().focus();}};
d.prototype.setShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};
d.prototype.getShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};
d.prototype.setBusyIndicatorSize=function(s){if(!(s in B)){s=B.Medium;}return C.prototype.setBusyIndicatorSize.call(this,s);};
return d;});
sap.ui.predefine('sap/m/CarouselRenderer',["sap/m/library","sap/ui/Device"],function(l,D){"use strict";var C=l.CarouselArrowsPlacement;var P=l.PlacementType;var a={};a._BULLETS_TO_NUMBERS_THRESHOLD=9;
a.render=function(r,c){var p=c.getPages(),i=p.length,s=c.getPageIndicatorPlacement(),A=c.getArrowsPlacement(),I=c.getId(),b=a._BULLETS_TO_NUMBERS_THRESHOLD,d=c._getPageNumber(c.getActivePage());this._renderOpeningDiv(r,c);if(s===P.Top){this._renderPageIndicatorAndArrows({rm:r,iPageCount:i,sId:I,iIndex:d,iBulletsToNumbersThreshold:b,sArrowsPlacement:A,bBottom:false,bShowPageIndicator:c.getShowPageIndicator()},c);}this._renderInnerDiv(r,c,p,s);if(D.system.desktop&&i>1&&A===C.Content){this._renderHudArrows(r,c);}if(s===P.Bottom){this._renderPageIndicatorAndArrows({rm:r,iPageCount:i,sId:I,iIndex:d,iBulletsToNumbersThreshold:b,sArrowsPlacement:A,bBottom:true,bShowPageIndicator:c.getShowPageIndicator()},c);}this._renderClosingDiv(r);};
a._renderOpeningDiv=function(r,c){var t=c.getTooltip_AsString();r.write("<div");r.writeControlData(c);r.writeAttribute("data-sap-ui-customfastnavgroup","true");r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.addClass("sapMCrsl");r.addClass("sapMCrslFluid");r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}r.writeAttributeEscaped("tabindex","0");r.writeAccessibilityState(c,{role:"list"});r.write(">");};
a._renderInnerDiv=function(r,c,p,s){r.write("<div class='sapMCrslInner");c._cleanUpScrollContainer();if(p.length>1&&(c.getShowPageIndicator()||c.getArrowsPlacement()===C.PageIndicator)){if(s===P.Bottom){r.write(" sapMCrslBottomOffset");if(c.getArrowsPlacement()===C.PageIndicator){r.write(" sapMCrslBottomArrowsOffset");}}else{r.write(" sapMCrslTopOffset");if(c.getArrowsPlacement()===C.PageIndicator){r.write(" sapMCrslTopArrowsOffset");}}}r.write("'>");var R=function(o,i,A){r.write("<div class='sapMCrslItem");r.write("' id='"+c.sId+"-"+o.sId+"-slide'");r.writeAccessibilityState(o,{role:"listitem",posinset:i+1,setsize:A.length});r.write(">");r.renderControl(c._createScrollContainer(o,i));r.write("</div>");};p.forEach(R);r.write("</div>");};
a._renderClosingDiv=function(r){r.write('</div>');};
a._renderPageIndicatorAndArrows=function(s,c){var r=s.rm,p=s.iPageCount,S=D.system.desktop&&s.sArrowsPlacement===C.PageIndicator,b=s.bBottom,I=s.sId,d=s.iIndex,B=s.iBulletsToNumbersThreshold,e=s.bShowPageIndicator,f=e?'':'opacity: 0',R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),o="",t=R.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[d+1,p]);if(p<=1){return;}if(!e&&!S){return;}if(b){o+=" sapMCrslControlsBottom";}else{o+=" sapMCrslControlsTop";}if(S){r.write('<div');r.addClass("sapMCrslControls");r.addClass(o);r.writeClasses();r.write('>');r.write('<div class="sapMCrslControlsContainer'+o+'">');}else{r.write('<div class="sapMCrslControlsNoArrows'+o+'">');}if(S){this._renderPrevArrow(r,c);}var g=I+'-pageIndicator';r.write('<div id="'+g+'" style="'+f+'"');if(p<B){r.write(' class="sapMCrslBulleted">');for(var i=1;i<=p;i++){r.write("<span role='img' data-slide="+i+" aria-label='"+R.getText('CAROUSEL_POSITION',[i,p])+"'>"+i+"</span>");}}else{r.write(' class="sapMCrslNumeric">');r.write('<span id='+I+'-'+'slide-number>'+t+'</span>');}r.write('</div>');if(S){this._renderNextArrow(r,c);}if(!S){r.write('</div>');}if(S){r.write('</div>');r.write('</div>');}};
a._renderHudArrows=function(r,c){var b;if(c.getShowPageIndicator()){if(c.getPageIndicatorPlacement()===P.Top){b="sapMCrslHudTop";}else if(c.getPageIndicatorPlacement()===P.Bottom){b="sapMCrslHudBottom";}}else{b="sapMCrslHudMiddle";}var h=c.getId()+'-hud';r.write('<div id="'+h+'" class="sapMCrslHud '+b+'">');this._renderPrevArrow(r,c);this._renderNextArrow(r,c);r.write("</div>");};
a._renderPrevArrow=function(r,c){r.write("<a class='sapMCrslPrev' href='#' data-slide='prev' tabindex='-1'><div class='sapMCrslArrowInner'>");r.renderControl(c._getNavigationArrow('left'));r.write("</div></a>");};
a._renderNextArrow=function(r,c){r.write("<a class='sapMCrslNext' href='#' data-slide='next' tabindex='-1'><div class='sapMCrslArrowInner'>");r.renderControl(c._getNavigationArrow('right'));r.write("</div></a>");};
return a;},true);
sap.ui.predefine('sap/m/CheckBox',['jquery.sap.global','./Label','./library','sap/ui/Device','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/EnabledPropagator','sap/ui/core/library','./CheckBoxRenderer'],function(q,L,l,D,C,I,E,c,a){"use strict";var V=c.ValueState;var T=c.TextAlign;var b=c.TextDirection;
var d=C.extend("sap.m.CheckBox",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{selected:{type:"boolean",group:"Data",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},useEntireWidth:{type:"boolean",group:"Appearance",defaultValue:false},activeHandling:{type:"boolean",group:"Misc",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{_label:{type:"sap.m.Label",group:"Behavior",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selected:{type:"boolean"}}}},designtime:"sap/m/designtime/CheckBox.designtime"}});
E.call(d.prototype);
d.prototype.init=function(){this.addActiveState(this);I.insertFontFaceStyle();};
d.prototype.exit=function(){this._oLabel=null;delete this._iTabIndex;};
d.prototype.setSelected=function(s){s=!!s;if(s==this.getSelected()){return this;}this.$("CbBg").toggleClass("sapMCbMarkChecked",s);this.$().attr("aria-checked",s);var o=this.getDomRef("CB");if(o){s?o.setAttribute('checked','checked'):o.removeAttribute('checked');}this.setProperty("selected",s,true);return this;};
d.prototype.setText=function(t){var o=this._getLabel(),h=!!t;this.setProperty("text",t,true);o.setText(t);this.$().toggleClass("sapMCbHasLabel",h);return this;};
d.prototype.setWidth=function(w){this.setProperty("width",w,true);this._setWidth();return this;};
d.prototype.setUseEntireWidth=function(u){this.setProperty("useEntireWidth",u,true);this._setWidth();return this;};
d.prototype.setTextDirection=function(s){var o=this._getLabel();this.setProperty("textDirection",s,true);o.setTextDirection(s);return this;};
d.prototype.setTextAlign=function(A){var o=this._getLabel();this.setProperty("textAlign",A,true);o.setTextAlign(A);return this;};
d.prototype.setWrapping=function(w){var o=this._getLabel();this.setProperty("wrapping",w,true);o.setWrapping(w);this.$().toggleClass("sapMCbWrapped",w);return this;};
d.prototype.addActiveState=function(o){if(D.os.blackberry){o.addDelegate({ontouchstart:function(e){q(o.getDomRef()).addClass("sapMActive");},ontouchend:function(e){q(o.getDomRef()).removeClass("sapMActive");}});}};
d.prototype.ontouchstart=function(e){e.originalEvent._sapui_handledByControl=true;};
d.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()&&!this.getDisplayOnly()){this.$().focus();var s=!this.getSelected();this.setSelected(s);this.fireSelect({selected:s});e&&e.setMarked();}};
d.prototype.onsapspace=function(e){this.ontap(e);if(e){e.preventDefault();e.stopPropagation();}};
d.prototype.onsapenter=function(e){this.ontap(e);};
d.prototype.setTabIndex=function(t){this._iTabIndex=t;this.$("CbBg").attr("tabindex",t);return this;};
d.prototype.getTabIndex=function(){if(this.hasOwnProperty("_iTabIndex")){return this._iTabIndex;}return(this.getEnabled()&&!this.getDisplayOnly())?0:-1;};
d.prototype._getLabel=function(){if(!this._oLabel){this._oLabel=new L(this.getId()+"-label",{labelFor:this.getId()}).addStyleClass("sapMCbLabel");this.setAggregation("_label",this._oLabel,true);}return this.getAggregation("_label");};
d.prototype._setWidth=function(){var o=this._getLabel(),$=this.$(),w=this.getWidth();if(this.getUseEntireWidth()){o.setWidth("");$.outerWidth(w);}else{$.outerWidth("");o.setWidth(w);}};
d.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"checkbox",type:B.getText("ACC_CTR_TYPE_CHECKBOX"),description:(this.getText()||"")+(this.getSelected()?(" "+B.getText("ACC_CTR_STATE_CHECKED")):""),focusable:this.getEnabled()&&!this.getDisplayOnly(),enabled:this.getEnabled(),editable:this.getEditable()};};
d.prototype.getFormDoNotAdjustWidth=function(){return this.getText()?false:true;};
return d;});
sap.ui.predefine('sap/m/CheckBoxRenderer',['sap/ui/core/library','sap/ui/core/ValueStateSupport','sap/ui/Device'],function(c,V,D){"use strict";var a=c.ValueState;var C={};
C.render=function(r,o){var i=o.getId(),e=o.getEnabled(),d=o.getDisplayOnly(),E=o.getEditable(),I=e&&!d,b=e&&d,f=o.getAggregation("_label"),g=a.Error===o.getValueState(),h=a.Warning===o.getValueState(),u=o.getUseEntireWidth();r.write("<div");r.addClass("sapMCb");if(!E){r.addClass("sapMCbRo");}if(b){r.addClass("sapMCbDisplayOnly");}if(!e){r.addClass("sapMCbBgDis");}if(g){r.addClass("sapMCbErr");}else if(h){r.addClass("sapMCbWarn");}if(o.getText()){r.addClass("sapMCbHasLabel");}if(o.getWrapping()){r.addClass("sapMCbWrapped");}r.writeControlData(o);r.writeClasses();if(u){r.addStyle("width",o.getWidth());r.writeStyles();}var t=V.enrichTooltip(o,o.getTooltip_AsString());if(t){r.writeAttributeEscaped("title",t);}if(I){r.writeAttribute("tabindex",o.getTabIndex());}r.writeAccessibilityState(o,{role:"checkbox",selected:null,checked:o.getSelected(),describedby:t?i+"-Descr":undefined});if(b){r.writeAttribute("aria-readonly",true);}r.write(">");r.write("<div id='");r.write(o.getId()+"-CbBg'");r.addClass("sapMCbBg");if(I&&E&&D.system.desktop){r.addClass("sapMCbHoverable");}if(!o.getActiveHandling()){r.addClass("sapMCbActiveStateOff");}r.addClass("sapMCbMark");if(o.getSelected()){r.addClass("sapMCbMarkChecked");}r.writeClasses();r.write(">");r.write("<input type='CheckBox' id='");r.write(o.getId()+"-CB'");if(o.getSelected()){r.writeAttribute("checked","checked");}if(o.getName()){r.writeAttributeEscaped('name',o.getName());}if(!e){r.write(" disabled=\"disabled\"");}if(!E){r.write(" readonly=\"readonly\"");}r.write(" /></div>");r.renderControl(f);if(t&&sap.ui.getCore().getConfiguration().getAccessibility()){r.write("<span id=\""+i+"-Descr\" class=\"sapUiHidden\">");r.writeEscaped(t);r.write("</span>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/m/ColorPalette',['sap/ui/core/Control','sap/ui/Device','sap/ui/base/DataType','sap/ui/core/CSSColor','sap/ui/core/delegate/ItemNavigation','./Button','./Dialog','./library','./ColorPaletteRenderer'],function(C,D,a,b,I,B,c,l,d){"use strict";var e;var f;var g=l.ButtonType;var h=a.getType("boolean");var i="sapMColorPaletteSquare";var S=5;var M=2;var j=15;var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var k=C.extend("sap.m.ColorPalette",{metadata:{library:"sap.m",properties:{colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]}},aggregations:{_defaultColorButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_moreColorsButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}}});
k.prototype.init=function(){this._oDefaultColor=null;this._bShowDefaultColorButton=false;this._bShowMoreColorsButton=false;this._oMoreColorsDialog=null;this._oItemNavigation=null;};
k.prototype.exit=function(){if(this._oMoreColorsDialog){this._oMoreColorsDialog.destroy();delete this._oMoreColorsDialog;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
k.prototype.setColors=function(n){n=this.validateProperty("colors",n);if(n.length<M||n.length>j){throw new Error("Cannot set property 'colors' - array must has minimum 2 and maximum 15 elements");}return this.setProperty("colors",n);};
k.prototype.ontap=function(E){var t=jQuery(E.target),s,$;$=t.closest("."+i);if(!$.length){return;}s=$.attr("data-sap-ui-color");this._fireColorSelect(s,false,E);};
k.prototype.onsaptabnext=k.prototype.onsaptabprevious=function(E){var o=this._getShowDefaultColorButton()&&jQuery.sap.containsOrEquals(E.target,this._getDefaultColorButton().getDomRef()),O=this._getShowMoreColorsButton()&&jQuery.sap.containsOrEquals(E.target,this._getMoreColorsButton().getDomRef());if(O){this.fireEvent("_colorNotSelected",{_originalEvent:E});return;}if(o){this._fireColorSelect(this._getDefaultColor(),true,E);return;}k.prototype.ontap.apply(this,arguments);};k.prototype.onsapspace=k.prototype.onsapenter=k.prototype.ontap;
k.prototype.onAfterRendering=function(){this._ensureItemNavigation();};
k.prototype._createDefaultColorButton=function(){return new B(this.getId()+"-btnDefaultColor",{width:"100%",type:g.Transparent,text:L.getText("COLOR_PALETTE_DEFAULT_COLOR"),visible:this._getShowDefaultColorButton(),press:function(E){this._fireColorSelect(this._getDefaultColor(),true,E);}.bind(this)});};
k.prototype._getDefaultColor=function(){return this._oDefaultColor;};
k.prototype._setDefaultColor=function(n){if(!b.isValid(n)){throw new Error("Cannot set internal property '_defaultColor' - invalid value: "+n);}this._oDefaultColor=n;return this;};
k.prototype._getShowDefaultColorButton=function(){return this._bShowDefaultColorButton;};
k.prototype._setShowDefaultColorButton=function(v){if(!h.isValid(v)){throw new Error("Cannot set internal property 'showDefaultColorButton' - invalid value: "+v);}this._bShowDefaultColorButton=v;if(v&&!this._getDefaultColorButton()){this.setAggregation("_defaultColorButton",this._createDefaultColorButton());}if(this._getDefaultColorButton()){this._getDefaultColorButton().setVisible(v);}return this;};
k.prototype._getDefaultColorButton=function(){return this.getAggregation("_defaultColorButton");};
k.prototype._createMoreColorsButton=function(){return new B(this.getId()+"-btnMoreColors",{width:"100%",type:g.Transparent,text:L.getText("COLOR_PALETTE_MORE_COLORS"),visible:this._getShowMoreColorsButton(),press:this._openColorPicker.bind(this)});};
k.prototype._getShowMoreColorsButton=function(){return this._bShowMoreColorsButton;};
k.prototype._setShowMoreColorsButton=function(v){if(!h.isValid(v)){throw new Error("Cannot set internal property 'showMoreColorsButton' - invalid value: "+v);}this._bShowMoreColorsButton=v;if(v&&!this._getMoreColorsButton()){this.setAggregation("_moreColorsButton",this._createMoreColorsButton());}if(this._getMoreColorsButton()){this._getMoreColorsButton().setVisible(v);}return this;};
k.prototype._getMoreColorsButton=function(){return this.getAggregation("_moreColorsButton");};
k.prototype._openColorPicker=function(){this.fireEvent("_beforeOpenColorPicker");this._ensureMoreColorsDialog().open();};
k.prototype._ensureMoreColorsDialog=function(){if(!this._oMoreColorsDialog){this._oMoreColorsDialog=this._createMoreColorsDialog();}return this._oMoreColorsDialog;};
k.prototype._createMoreColorsDialog=function(){var o=new c(this.getId()+"-moreColorsDialog",{contentWidth:D.system.phone?"":"29rem",stretch:!!D.system.phone,title:L.getText("COLOR_PALETTE_MORE_COLORS_TITLE")});this._ensureUnifiedLibrary();o.addContent(o._oColorPicker=new e({mode:f.HSL}));o.setBeginButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CONFIRM"),press:function(E){o.close();if(o._oColorPicker.getColorString()){this._fireColorSelect(o._oColorPicker.getColorString(),false,E);}}.bind(this)}));o.setEndButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CANCEL"),press:function(){o.close();}}));return o;};
k.prototype._ensureUnifiedLibrary=function(){var u;if(!e){sap.ui.getCore().loadLibrary("sap.ui.unified");u=sap.ui.require("sap/ui/unified/library");e=sap.ui.requireSync("sap/ui/unified/ColorPicker");f=u.ColorPickerMode;}};
k.prototype._focusFirstElement=function(){var F=this._getShowDefaultColorButton()?this._getDefaultColorButton().getDomRef():this._getAllSwatches()[0];F.focus();};
k.prototype._fireColorSelect=function(n,o,O){this.fireColorSelect({value:n,defaultAction:o,_originalEvent:O});};
k.prototype._ensureItemNavigation=function(){var n=[],o=this._getDefaultColorButton(),p=this._getMoreColorsButton();if(!this._oItemNavigation){this._oItemNavigation=new m(this);this.addDelegate(this._oItemNavigation);}if(o&&o.getVisible()){n.push(o.getDomRef());}n=n.concat(this._getAllSwatches());if(p&&p.getVisible()){n.push(p.getDomRef());}this._oItemNavigation.setRootDomRef(this.getDomRef());this._oItemNavigation.setItemDomRefs(n);};
k.prototype._getAllSwatches=function(){return this.$().find("."+i).get();};
var m=I.extend("sap.ui.core.delegate.ItemNavigation",{constructor:function(o){I.apply(this);this._oColorPalette=o;}});
m.prototype._onHomeEnd=function(E){var n,N,A,H=E.type==="saphome";if(!jQuery(E.target).hasClass(i)){return;}E.preventDefault();E.stopPropagation();n=jQuery(E.target).index();A=this._oColorPalette._getAllSwatches();N=this._calcIndexOfBorderSwatch(H,n,A.length);A[N].focus();};
m.prototype.onsaphome=m.prototype.onsapend=m.prototype._onHomeEnd;
m.prototype._calcIndexOfBorderSwatch=function(H,n,s){var o;if(H){o=Math.floor(n/S)*S;}else{o=Math.floor(n/S)*S+(S-1);if(o>s){o=s-1;}}return o;};
k.prototype._ItemNavigation=m;k.prototype._ColorsHelper={RGB_TO_NAMED_COLORS_MAP:{"#FFB200":"gold","#FF8C00":"darkorange","#CD5C5C":"indianred","#8B008B":"darkmagenta","#6495ED":"cornflowerblue","#00BFFF":"deepskyblue","#008B8B":"darkcyan","#6B8E23":"olivedrab","#2F4F4F":"darkslategray","#F0FFFF":"azure","#FFFFFF":"white","#D3D3D3":"lightgray","#A9A9A9":"darkgray","#696969":"dimgray","#000000":"black"},NAME_COLORS_TO_RGB_MAP:{"gold":"#FFB200","darkorange":"#FF8C00","indianred":"#CD5C5C","darkmagenta":"#8B008B","cornflowerblue":"#6495ED","deepskyblue":"#00BFFF","darkcyan":"#008B8B","olivedrab":"#6B8E23","darkslategray":"#2F4F4F","azure":"#F0FFFF","white":"#FFFFFF","lightgray":"#D3D3D3","darkgray":"#A9A9A9","dimgray":"#696969","black":"#000000"},getNamedColor:function(s){var H="";if(!s||s.toLowerCase().indexOf("hsl")!==-1){return undefined;}if(s.indexOf("#")===-1){return this.NAME_COLORS_TO_RGB_MAP[s.toLowerCase()]?s.toLowerCase():undefined;}if(s.length===4){H=["#",s[1],s[1],s[2],s[2],s[3],s[3]].join("");}else{H=s;}H=H.toUpperCase();return this.RGB_TO_NAMED_COLORS_MAP[H];}};return k;});
sap.ui.predefine('sap/m/ColorPalettePopover',['sap/ui/core/Control','sap/ui/Device','./Button','./ResponsivePopover','./ColorPalette','./library'],function(C,D,B,R,a,l){"use strict";var P=l.PlacementType;
var b=C.extend("sap.m.ColorPalettePopover",{
metadata:{library:"sap.m",publicMethods:["openBy","close"],properties:{defaultColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]},showDefaultColorButton:{type:"boolean",group:"Appearance",defaultValue:true},showMoreColorsButton:{type:"boolean",group:"Appearance",defaultValue:true}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}},
renderer:{}
});
var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");var F={COLOR_PALETTE_PROPS:{colors:"setColors",defaultColor:"_setDefaultColor",showDefaultColorButton:"_setShowDefaultColorButton",showMoreColorsButton:"_setShowMoreColorsButton"},POPOVER_METHODS:{getDomRef:"",close:""}};
b.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null;};
b.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null;}};
b.prototype.openBy=function(o){return R.prototype.openBy.apply(this._ensurePopover(),arguments);};
b.prototype._getPalette=function(){return this._ensurePopover().getContent()[0];};
b.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover();}return this._oPopover;};
b.prototype._createPopover=function(){var p,c=this._createColorPalette(),d;p=new R(this.getId()+"-colorPalettePopover",{showHeader:D.system.phone,placement:P.VerticalPreferredBottom,showArrow:false,showCloseButton:false,title:L.getText("COLOR_PALETTE_TITLE"),content:c,afterOpen:c._focusFirstElement.bind(c)}).addStyleClass("sapMColorPaletteContainer");if(D.system.phone){p.setEndButton(new B({text:L.getText("COLOR_PALETTE_CANCEL"),press:function(){p.close();}}));}c.attachEvent("_beforeOpenColorPicker",function(){p.close();});c.attachEvent("_colorNotSelected",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();}.bind(this));c.attachEvent("colorSelect",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();this.fireColorSelect({"value":e.getParameter("value"),"defaultAction":e.getParameter("defaultAction")});}.bind(this));d={onAfterRendering:function(){var $=this.$();$.attr("aria-modal","true");$.attr("aria-label",this.getTitle());}};p.addEventDelegate(d,p);p._onAfterRenderingDelegate=d;return p;};
b.prototype._createColorPalette=function(){var c=new a(this.getId()+"-palette");c._setShowDefaultColorButton(this.getShowDefaultColorButton());c._setShowMoreColorsButton(this.getShowMoreColorsButton());return c;};
b.prototype._handleNextOrPreviousUponPaletteClose=function(e){var o=e.getParameter("_originalEvent");if(!o){return;}if(o.type==="saptabnext"||o.type==="saptabprevious"){o.stopPropagation();o.preventDefault();}};
b.prototype.setProperty=function(p,v,s){var t;if(F.COLOR_PALETTE_PROPS[p]!==undefined){t=F.COLOR_PALETTE_PROPS[p]||p;a.prototype[t].call(this._getPalette(),v);}return C.prototype.setProperty.apply(this,arguments);};
Object.keys(F.POPOVER_METHODS).forEach(function(s){var t=F.COLOR_PALETTE_PROPS[s]||s;b.prototype[s]=function(){if(this._bPopoverDestroying){return null;}var p=this._ensurePopover();return p[t].apply(p,arguments);};});return b;});
sap.ui.predefine('sap/m/ColorPaletteRenderer',['sap/ui/Device'],function(D){"use strict";var C={};var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");
C.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMColorPalette");r.writeClasses();r.writeAttribute("tabIndex","0");r.write(">");if(c._getShowDefaultColorButton()){this.renderDefaultColorButton(r,c);this.renderSeparator(r);}this.renderSwatches(r,c);if(c._getShowMoreColorsButton()){this.renderSeparator(r);this.renderMoreColorsButton(r,c);if(D.system.phone){this.renderSeparator(r);}}r.write("</div>");};
C.renderSwatches=function(r,c){var s=c.getColors();r.write("<div");r.addClass("sapMColorPaletteContent");r.writeClasses();r.writeAccessibilityState(c,{"role":"region","label":l.getText("COLOR_PALETTE_SWATCH_CONTAINER_TITLE")});r.write(">");s.forEach(function(a,i){this.renderSquare(r,c,a,i);},this);r.write("</div>");};
C.renderSquare=function(r,c,s,i){var n=c._ColorsHelper.getNamedColor(s),a=l.getText("COLOR_PALETTE_PREDEFINED_COLOR",[i+1,n||l.getText("COLOR_PALETTE_PREDEFINED_COLOR_CUSTOM")]);r.write("<div");r.addClass("sapMColorPaletteSquare");r.writeClasses();r.writeAttribute("data-sap-ui-color",s);r.writeAttribute("tabindex","-1");r.writeAttribute("title",a);r.writeAccessibilityState(c,{"role":"button","label":a});r.write(">");r.write("<div");r.addStyle("background-color",s);r.writeStyles();r.write("></div>");r.write("</div>");};
C.renderSeparator=function(r){r.write("<div");r.addClass("sapMColorPaletteSeparator");r.writeClasses();r.write(">");r.write("<hr/>");r.write("</div>");};
C.renderDefaultColorButton=function(r,c){r.renderControl(c._getDefaultColorButton());};
C.renderMoreColorsButton=function(r,c){r.renderControl(c._getMoreColorsButton());};
return C;},true);
sap.ui.predefine('sap/m/Column',['jquery.sap.global','./library','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/library','sap/ui/Device'],function(q,l,E,R,c,D){"use strict";var P=l.PopinDisplay;var V=c.VerticalAlign;var T=c.TextAlign;
var C=E.extend("sap.m.Column",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},hAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit},styleClass:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},minScreenWidth:{type:"string",group:"Behavior",defaultValue:null},demandPopin:{type:"boolean",group:"Behavior",defaultValue:false},popinHAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin,deprecated:true},popinDisplay:{type:"sap.m.PopinDisplay",group:"Appearance",defaultValue:P.Block},mergeDuplicates:{type:"boolean",group:"Behavior",defaultValue:false},mergeFunctionName:{type:"string",group:"Misc",defaultValue:'getText'}},defaultAggregation:"header",aggregations:{header:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/m/designtime/Column.designtime"}});
C.prototype._index=-1;C.prototype._screen="";C.prototype._media=null;
C.prototype.exit=function(){this._clearMedia();};
C.prototype._clearMedia=function(){if(this._media&&this._minWidth){this._detachMediaContainerWidthChange(this._notifyResize,this,this.getId());D.media.removeRangeSet(this.getId());this._media=null;}};
C.prototype._addMedia=function(){delete this._bShouldAddMedia;if(this._minWidth){D.media.initRangeSet(this.getId(),[parseFloat(this._minWidth)]);this._attachMediaContainerWidthChange(this._notifyResize,this,this.getId());this._media=this._getCurrentMediaContainerRange(this.getId());if(this._media){this._media.matches=!!this._media.from;}}};
C.prototype._notifyResize=function(m){if(this._media.from===m.from){return;}this._media=m;this._media.matches=!!m.from;q.sap.delayedCall(0,this,function(){var p=this.getParent();this.fireEvent("media",this);if(p&&p.onColumnResize){p.onColumnResize(this);}});};
C.prototype._validateMinWidth=function(w){if(!w){return;}if(Object.prototype.toString.call(w)!="[object String]"){throw new Error('expected string for property "minScreenWidth" of '+this);}if(Object.keys(l.ScreenSizes).indexOf(w.toLowerCase())!=-1){return;}if(!/^\d+(\.\d+)?(px|em|rem)$/i.test(w)){throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of '+this);}};
C.prototype._isWidthPredefined=function(w){var t=this,u=w.replace(/[^a-z]/ig,""),b=parseFloat(l.BaseFontSize)||16;q.each(l.ScreenSizes,function(s,a){if(u!="px"){a/=b;}if(a+u==w){t._minWidth=this+"px";t._screen=s;return false;}});if(this._minWidth){return true;}if(u=="px"){this._minWidth=w;}else{this._minWidth=parseFloat(w)*b+"px";}};
C.prototype.applyAlignTo=function(o,a){a=a||this.getHAlign();if(a===T.Initial||!o.getMetadata().getProperties().textAlign||o.getTextAlign()===a){return o;}o.setProperty("textAlign",a,true);var d=o.getDomRef();a=this.getCssAlign(a);if(d&&a){d.style.textAlign=a;}return o;};
C.prototype.getCssAlign=function(a){a=a||this.getHAlign();if(a===T.Begin||a===T.End||a===T.Initial){a=R.getTextAlign(a);}return a.toLowerCase();};
C.prototype.getStyleClass=function(r){var a=this.getProperty("styleClass");if(!r){return a;}if(this._screen&&(!this.getDemandPopin()||!window.matchMedia)){a+=" sapMSize-"+this._screen;}else if(this._media&&!this._media.matches){a+=" sapMListTblNone";}return a.trim();};
C.prototype.setIndex=function(n){this._index=+n;};
C.prototype.setOrder=function(n){this._order=+n;};
C.prototype.getOrder=function(){return this.hasOwnProperty("_order")?this._order:this.getInitialOrder();};
C.prototype.setInitialOrder=function(n){this._initialOrder=+n;};
C.prototype.getInitialOrder=function(){if(this.hasOwnProperty("_initialOrder")){return this._initialOrder;}var p=this.getParent();if(p&&p.indexOfColumn){return p.indexOfColumn(this);}return-1;};
C.prototype.setDisplay=function(t,d){if(!t||this._index<0){return;}var i=this._index+1,p=this.getParent(),a=d?"table-cell":"none",h=t.querySelector("tr > th:nth-child("+i+")"),b=t.querySelectorAll("tr > td:nth-child("+i+")"),e=b.length;h.style.display=a;h.setAttribute("aria-hidden",!d);for(i=0;i<e;i++){b[i].style.display=a;b[i].setAttribute("aria-hidden",!d);}if(p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}};
C.prototype.setDisplayViaMedia=function(t){var p=this.getParent(),d=this._media&&this._media.matches;if(!this.getDemandPopin()&&this._screen&&p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}else{this.setDisplay(t,d);}};
C.prototype.setVisible=function(v){if(v==this.getVisible()){return this;}var p=this.getParent(),t=p&&p.getTableDomRef&&p.getTableDomRef(),s=t&&this._index>=0;this.setProperty("visible",v,s);if(s){this.setDisplay(t,v);}return this;};
C.prototype.setMinScreenWidth=function(w){var p=this.getParent();if(w==this.getMinScreenWidth()){return this;}this._validateMinWidth(w);this._clearMedia();this._minWidth=0;this._screen="";if(w){w=w.toLowerCase();var a=l.ScreenSizes[w];if(a){this._screen=w;this._minWidth=a+"px";}else{this._isWidthPredefined(w);}if(p&&p.isActive()){this._addMedia();}else{this._bShouldAddMedia=true;}}return this.setProperty("minScreenWidth",w);};
C.prototype.setDemandPopin=function(v){if(v==this.getDemandPopin()){return this;}if(!this.getMinScreenWidth()){return this.setProperty("demandPopin",v,true);}return this.setProperty("demandPopin",v);};
C.prototype.isPopin=function(){if(!this.getDemandPopin()){return false;}if(this._media){return!this._media.matches;}return false;};
C.prototype.isHidden=function(){if(this._media){return!this._media.matches;}if(this._screen&&this._minWidth){return parseFloat(this._minWidth)>window.innerWidth;}return false;};
C.prototype.setLastValue=function(v){if(this.getMergeDuplicates()){this._lastValue=v;}return this;};
C.prototype.clearLastValue=function(){return this.setLastValue(NaN);};
C.prototype.getLastValue=function(){return this._lastValue;};
C.prototype.onItemsRemoved=function(){this.clearLastValue();};
return C;});
sap.ui.predefine('sap/m/ColumnListItem',['jquery.sap.global','sap/ui/core/Element','./ListItemBase','./library','sap/ui/core/library','./ColumnListItemRenderer'],function(q,E,L,l,c,C){"use strict";var a=l.ListType;var V=c.VerticalAlign;
var b=L.extend("sap.m.ColumnListItem",{metadata:{library:"sap.m",properties:{vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell",bindable:"bindable"}}}});
var T=E.extend("sap.m.TablePopin",{ontap:function(e){if(e.isMarked()){return;}if(e.srcControl===this||!q(e.target).is(":sapFocusable")){this.getParent().focus();}}});
b.prototype.TagName="tr";
b.prototype.init=function(){L.prototype.init.call(this);this._bNeedsTypeColumn=false;this._aClonedHeaders=[];};
b.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.call(this);this._checkTypeColumn();};
b.prototype.exit=function(){L.prototype.exit.call(this);this._checkTypeColumn(false);this._destroyClonedHeaders();if(this._oPopin){this._oPopin.destroy(true);this._oPopin=null;}};
b.prototype.setVisible=function(v){L.prototype.setVisible.call(this,v);if(!v&&this.hasPopin()){this.removePopin();}return this;};
b.prototype.getTable=function(){var p=this.getParent();if(p instanceof sap.m.Table){return p;}if(p&&p.getMetadata().getName()=="sap.m.Table"){return p;}};
b.prototype.getPopin=function(){if(!this._oPopin){this._oPopin=new T({id:this.getId()+"-sub"}).addEventDelegate({ontouchstart:this.ontouchstart,ontouchmove:this.ontouchmove,ontap:this.ontap,ontouchend:this.ontouchend,ontouchcancel:this.ontouchcancel,onsaptabnext:this.onsaptabnext,onsaptabprevious:this.onsaptabprevious,onsapup:this.onsapup,onsapdown:this.onsapdown,oncontextmenu:this.oncontextmenu},this).setParent(this,null,true);}return this._oPopin;};
b.prototype.$Popin=function(){return this.$("sub");};
b.prototype.hasPopin=function(){return this._oPopin;};
b.prototype.removePopin=function(){this._oPopin&&this.$Popin().remove();};
b.prototype.getTabbables=function(){return this.$().add(this.$Popin()).find(":sapTabbable");};
b.prototype.getAccessibilityType=function(B){return B.getText("ACC_CTR_TYPE_ROW");};
b.prototype.getContentAnnouncement=function(B){var t=this.getTable();if(!t){return;}var A="",d=this.getCells(),e=t.getColumns(true);e.forEach(function(o){var f=d[o.getInitialOrder()];if(!f||!o.getVisible()||(o.isHidden()&&!o.isPopin())){return;}var h=o.getHeader();if(h&&h.getVisible()){A+=L.getAccessibilityText(h)+" ";}A+=L.getAccessibilityText(f,true)+" ";});return A;};
b.prototype.updateSelectedDOM=function(s,t){L.prototype.updateSelectedDOM.apply(this,arguments);if(this.hasPopin()){this.$Popin().attr("aria-selected",s);}};
b.prototype._checkTypeColumn=function(n){if(n==undefined){n=this._needsTypeColumn();}if(this._bNeedsTypeColumn!=n){this._bNeedsTypeColumn=n;this.informList("TypeColumnChange",n);}};
b.prototype._needsTypeColumn=function(){var t=this.getType(),m=a;return this.getVisible()&&(t==m.Detail||t==m.Navigation||t==m.DetailAndActive);};
b.prototype._addClonedHeader=function(h){return this._aClonedHeaders.push(h);};
b.prototype._destroyClonedHeaders=function(){if(this._aClonedHeaders.length){this._aClonedHeaders.forEach(function(o){o.destroy("KeepDom");});this._aClonedHeaders=[];}};
b.prototype._activeHandlingInheritor=function(){this._toggleActiveClass(true);};
b.prototype._inactiveHandlingInheritor=function(){this._toggleActiveClass(false);};
b.prototype._toggleActiveClass=function(s){if(this.hasPopin()){this.$Popin().toggleClass("sapMLIBActive",s);}};
return b;});
sap.ui.predefine('sap/m/ColumnListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer','./ColumnHeader','./Label','sap/ui/core/library','sap/ui/Device','sap/m/library'],function(q,L,R,C,a,c,D,l){"use strict";var P=l.PopinDisplay;var V=c.VerticalAlign;var b=l.PopinLayout;var d=R.extend(L);
d.render=function(r,o){var t=o.getTable();if(!t){return;}L.render.apply(this,arguments);if(o.getVisible()&&t.hasPopin()){this.renderPopin(r,o,t);}};
d.renderHighlight=function(r,o){r.write('<td class="sapMListTblHighlightCell" aria-hidden="true">');L.renderHighlight.apply(this,arguments);r.write('</td>');};
d.renderType=function(r,o){r.write('<td class="sapMListTblNavCol" aria-hidden="true">');L.renderType.apply(this,arguments);r.write('</td>');};
d.renderModeContent=function(r,o){r.write('<td class="sapMListTblSelCol" aria-hidden="true">');L.renderModeContent.apply(this,arguments);r.write('</td>');};
d.renderCounter=function(r,o){};
d.getAriaRole=function(o){return"";};
d.renderLIAttributes=function(r,o){r.addClass("sapMListTblRow");var A=o.getVAlign();if(A!=V.Inherit){r.addClass("sapMListTblRow"+A);}var t=o.getTable();if(t&&t.getAlternateRowColors()){var p=t.indexOfItem(o);if(p%2==0){r.addClass("sapMListTblRowAlternate");}}};
d.renderLIContentWrapper=function(r,o){var t=o.getTable();if(!t){return;}var e=t.getColumns(true),f=o.getCells();o._destroyClonedHeaders();e.forEach(function(g,i){var h,H,j=true,k=f[g.getInitialOrder()];if(!k||!g.getVisible()||g.isPopin()){g.setIndex(-1);return;}r.write("<td");r.addClass("sapMListTblCell");r.writeAttribute("id",o.getId()+"_cell"+i);r.writeAttribute("data-sap-ui-column",g.getId());if(g){h=g.getStyleClass(true);h&&r.addClass(q.sap.encodeHTML(h));H=g.getHeader();if(H){r.writeAttribute("headers",H.getId());}if(!t.hasPopin()&&g.getMergeDuplicates()){var F=g.getMergeFunctionName(),m=F.split("#"),s=m[1],n=m[0];if(typeof k[n]!="function"){q.sap.log.warning("mergeFunctionName property is defined on "+g+" but this is not function of "+k);}else{var p=g.getLastValue(),u=k[n](s);if(p===u){j=sap.ui.getCore().getConfiguration().getAccessibility();k.addStyleClass("sapMListTblCellDupCnt");r.addClass("sapMListTblCellDup");}else{g.setLastValue(u);}}}g.getVAlign()!="Inherit"&&r.addStyle("vertical-align",g.getVAlign().toLowerCase());var A=g.getCssAlign();if(A){r.addStyle("text-align",A);}r.writeStyles();}r.writeClasses();r.write(">");if(j){this.applyAriaLabelledBy(H,k);r.renderControl(g.applyAlignTo(k));}r.write("</td>");},this);};
d.applyAriaLabelledBy=function(h,o){if(o){o.removeAssociation("ariaLabelledBy",o.data("ariaLabelledBy")||undefined,true);}if(h&&h.getText&&o.getAriaLabelledBy&&h.getVisible()){o.addAssociation("ariaLabelledBy",h,true);o.data("ariaLabelledBy",h.getId());}};
d.renderPopin=function(r,o,t){o.removePopin();r.write("<tr");r.addClass("sapMListTblSubRow");r.writeElementData(o.getPopin());r.writeAttribute("tabindex","-1");if(o.isSelectable()){r.writeAttribute("aria-selected",o.getSelected());}r.writeClasses();r.write(">");this.renderHighlight(r,o);r.write("<td");r.writeAttribute("id",o.getId()+"-subcell");r.writeAttribute("colspan",t.getColSpan());var p=t.getPopinLayout();if(D.browser.msie||D.browser.edge){p=b.Block;}r.write("><div");r.addClass("sapMListTblSubCnt");r.addClass("sapMListTblSubCnt"+p);r.writeClasses();r.write(">");var e=o.getCells(),f=t.getColumns(true);f.forEach(function(g){if(!g.getVisible()||!g.isPopin()){return;}var h=e[g.getInitialOrder()],H=g.getHeader();if(!H&&!h){return;}var s=g.getStyleClass(),i=g.getPopinDisplay();r.write("<div");r.addClass("sapMListTblSubCntRow");s&&r.addClass(q.sap.encodeHTML(s));r.writeClasses();r.write(">");if(H&&i!=P.WithoutHeader){r.write("<div");r.addClass("sapMListTblSubCntHdr");r.writeClasses();r.write(">");if(H instanceof C){var j=H.getText();H=new a({text:j});}else{H=H.clone();}g.addDependent(H);o._addClonedHeader(H);g.applyAlignTo(H,"Begin");r.renderControl(H);r.write("</div>");r.write("<div class='sapMListTblSubCntSpr'>:</div>");}if(h){r.write("<div");r.addClass("sapMListTblSubCntVal");r.addClass("sapMListTblSubCntVal"+i);r.writeClasses();r.write(">");g.applyAlignTo(h,"Begin");this.applyAriaLabelledBy(H,h);r.renderControl(h);r.write("</div>");}r.write("</div>");},this);r.write("</div></td></tr>");};
d.addLegacyOutlineClass=function(r,o){};
return d;},true);
sap.ui.predefine('sap/m/ComboBox',['jquery.sap.global','./ComboBoxTextField','./ComboBoxBase','./Popover','./SelectList','./library','sap/ui/Device','sap/ui/core/Item','./ComboBoxRenderer','jquery.sap.keycodes'],function(q,C,a,P,S,l,D,I,b){"use strict";
var c=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});
function h(o,i){if(!i){return;}var d=o.getFocusDomRef(),e=d.selectionStart,g=d.selectionEnd,j=e!==g,t=d.value.substring(0,d.selectionStart),k=this.getSelectedItem();if(i!==k){o.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:i});i=this.getSelectedItem();if(!q.sap.startsWithIgnoreCase(i.getText(),t)||!j){e=0;}o.selectText(e,d.value.length);}this.scrollToItem(i);}
function s(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}
function f(i){var o=this.getSelectedItem(),d=o&&o.getDomRef(),e=o&&d.offsetTop,g=o&&d.offsetHeight,p=this.getPicker(),j=p.getDomRef("cont"),k=j.clientHeight;if(o&&((e+g)>(k))){if(!i){this.getList().$().css("visibility","hidden");}else{j.scrollTop=e-g/2;this.getList().$().css("visibility","visible");}}}
c.prototype._handleAriaActiveDescendant=function(i){var d=this.getFocusDomRef(),A="aria-activedescendant";if(d){if(i&&i.getDomRef()&&this.isOpen()){d.setAttribute(A,i.getId());}else{d.removeAttribute(A);}}};
c.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};
c.getMetadata().forwardAggregation("items",{getter:c.prototype.getList,aggregation:"items"});
c.prototype._setItemVisibility=function(i,v){var o=i&&i.$(),d="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;o.length&&o.removeClass(d);}else{i.bVisible=false;o.length&&o.addClass(d);}};
c.prototype._highlightList=function(v){var i=this.getVisibleItems(),d=v.length,v=v.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&'),r=new RegExp("^"+v,"i");i.forEach(function(o){var e=o.getDomRef(),g,j;if(e===null){return;}g=e.children[1];j=Array.prototype.filter.call(e.children,function(k){return k.tagName.toLowerCase()!=="b";})[0]||e;j.innerHTML=this._boldItemRef(o.getText(),r,d);if(g&&o.getAdditionalText){g.innerHTML=this._boldItemRef(o.getAdditionalText(),r,d);}},this);};
c.prototype._boldItemRef=function(i,r,d){var R;var t="<b>"+q.sap.encodeHTML(i.slice(0,d))+"</b>";var p=i.split(r);if(p.length===1){R=q.sap.encodeHTML(i);}else{R=p.map(function(e){return q.sap.encodeHTML(e);}).join(t);}return R;};
c.prototype.setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};
c.prototype.createDropdown=function(){var t=this;var d=new P(this.getDropdownSettings());d.setInitialFocus(this);d.open=function(){return this.openBy(t);};return d;};
c.prototype.createPickerTextField=function(){var t=new C({width:"100%",showValueStateMessage:false,showButton:false}).addEventDelegate({onsapenter:function(){this.updateDomValue(t.getValue());this.onChange();}},this);return t;};
c.prototype.revertSelection=function(){var p,o=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){p=this._sValueBeforeOpen;}else{p=this._oSelectedItemBeforeOpen.getText();}o&&o.setValue(p);};
c.prototype.filterItems=function(o,d){var p=o.properties,v=o.value,e=v==="",m=false,t=false,M=[],F=[],g=null;this._oFirstItemTextMatched=null;p.forEach(function(k){M.push("get"+k.charAt(0).toUpperCase()+k.slice(1));});d=d||this.getItems();for(var i=0;i<d.length;i++){g=d[i];m=e;for(var j=0;j<M.length;j++){if(q.sap.startsWithIgnoreCase(g[M[j]](),v)){m=true;if(M[j]==="getText"){t=true;}}}if(m){F.push(g);}if(!this._oFirstItemTextMatched&&t){this._oFirstItemTextMatched=g;}this._setItemVisibility(g,m);}return F;};
c.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this.bIsFocused=false;};
c.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();};
c.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;};
c.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};
c.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};
c.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var L=this.getList(),F=this.getFocusDomRef();if(L){L.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};
c.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);f.call(this,false);};
c.prototype.onAfterRenderingList=function(){if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var L=this.getList(),F=this.getFocusDomRef();this._highlightList(this._sInputValueBeforeOpen);if(L){L.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};
c.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);if(e.isMarked("invalid")){return;}var t=(this.getPickerType()==="Dropdown");this.loadItems(function(){var o=this.getSelectedItem(),v=e.target.value,E=v==="",d=e.srcControl,V;if(E&&!this.bOpenedByKeyboardOrButton){V=this.getItems();}else{V=this.filterItems({properties:this._getFilters(),value:v});}var i=!!V.length;var F=V[0];var T=(F&&q.sap.startsWithIgnoreCase(F.getText(),v));var g=this.getFilterSecondaryValues();var j=D.system.desktop;if(!E&&F&&F.getEnabled()){if(d._bDoTypeAhead){if(g&&this._oFirstItemTextMatched){d.updateDomValue(this._oFirstItemTextMatched.getText());this.setSelection(this._oFirstItemTextMatched);}else if(g){if(T){d.updateDomValue(F.getText());}else{d.updateDomValue(F.getAdditionalText());}this.setSelection(F);}else{d.updateDomValue(F.getText());this.setSelection(F);}}if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(d._bDoTypeAhead){if(j){s.call(d,v.length,d.getValue().length);}else{setTimeout(s.bind(d,v.length,d.getValue().length),0);}}}if(E||!i||(!d._bDoTypeAhead&&(this._getSelectedItemText()!==v))){this.setSelection(null);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}this._sInputValueBeforeOpen=v;if(this.isOpen()){this._highlightList(v);}if(i){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(t){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(t&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&t){this.open();}};
c.prototype.onSelectionChange=function(o){var i=o.getParameter("selectedItem"),p=this.getChangeEventParams(),d=(i!==this.getSelectedItem());this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(d){p.itemPressed=true;this.onChange(null,p);}};
c.prototype.onItemPress=function(o){var i=o.getParameter("item"),t=i.getText(),p=this.getChangeEventParams(),d=(i!==this.getSelectedItem());this.updateDomValue(t);if(this.getPickerType()==="Dropdown"&&!d){p.itemPressed=true;this.onChange(null,p);}this.close();this.setProperty("value",i.getText(),true);setTimeout(this.selectText.bind(this,this.getValue().length,this.getValue().length),0);};
c.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()],d=this.getFocusDomRef();if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");if(d){d.setAttribute("aria-owns",this.getList().getId());}this.addContent();p&&p.call(this);};
c.prototype.onBeforeOpenDropdown=function(){};
c.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}p.setValue(this._sValueBeforeOpen);};
c.prototype.onAfterOpen=function(){var d=this.getFocusDomRef(),i=this.getSelectedItem();if(d){d.setAttribute("aria-expanded","true");i&&d.setAttribute("aria-activedescendant",i.getId());}f.call(this,true);};
c.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var d=this.getFocusDomRef();if(d){d.removeAttribute("aria-owns");d.removeAttribute("aria-activedescendant");}this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");};
c.prototype.onAfterClose=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("aria-expanded","false");}this.clearFilter();this._sInputValueBeforeOpen="";if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===d)){this.openValueStateMessage();}};
c.prototype.onItemChange=function(o){var d=this.getAssociation("selectedItem"),n=o.getParameter("newValue"),p=o.getParameter("name");if(d===o.getParameter("id")){switch(p){case"text":if(!this.isBound("value")){this.setValue(n);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(n);}break;}}};
c.prototype.onkeydown=function(e){var o=e.srcControl;a.prototype.onkeydown.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}var k=q.sap.KeyCodes;o._bDoTypeAhead=(e.which!==k.BACKSPACE)&&(e.which!==k.DELETE);};
c.prototype.oncut=function(e){var o=e.srcControl;a.prototype.oncut.apply(o,arguments);o._bDoTypeAhead=false;};
c.prototype.onsapenter=function(e){var o=e.srcControl,i=o.getSelectedItem();if(i&&this.getFilterSecondaryValues()){o.updateDomValue(i.getText());}a.prototype.onsapenter.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}if(o.isOpen()){o.close();}};
c.prototype.onsapdown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToNextSelectableItem(){var d=this.getSelectableItems();var n=d[d.indexOf(this.getSelectedItem())+1];h.call(this,o,n);});};
c.prototype.onsapup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){var d=this.getSelectableItems();var p=d[d.indexOf(this.getSelectedItem())-1];h.call(this,o,p);});};
c.prototype.onsaphome=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var F=this.getSelectableItems()[0];h.call(this,o,F);});};
c.prototype.onsapend=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToLastSelectableItem(){var L=this.findLastEnabledItem(this.getSelectableItems());h.call(this,o,L);});};
c.prototype.onsappagedown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var d=this.getSelectableItems(),i=d.indexOf(this.getSelectedItem())+10,g;i=(i>d.length-1)?d.length-1:Math.max(0,i);g=d[i];h.call(this,o,g);});};
c.prototype.onsappageup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var d=this.getSelectableItems(),i=d.indexOf(this.getSelectedItem())-10,g;i=(i>d.length-1)?d.length-1:Math.max(0,i);g=d[i];h.call(this,o,g);});};
c.prototype.onsapshow=function(e){var d,i;a.prototype.onsapshow.apply(this,arguments);if(!this.getValue()){d=this.getSelectableItems();i=d[0];if(i){this.setSelection(i);this.updateDomValue(i.getText());this.fireSelectionChange({selectedItem:i});setTimeout(function(){this.selectText(0,i.getText().length);}.bind(this),0);}}};
c.prototype.onsaphide=c.prototype.onsapshow;
c.prototype.onfocusin=function(e){var d=this.getPickerType()==="Dropdown";if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(d&&!this.isPlatformTablet()){this.focus();}}else{if(d){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bIsFocused&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}this.bIsFocused=true;}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}this.$().addClass("sapMFocus");};
c.prototype.onsapfocusleave=function(e){this.bIsFocused=false;var t,p,r,F,o=e.srcControl,i=o.getSelectedItem();if(i&&this.getFilterSecondaryValues()){o.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}p=this.getAggregation("picker");if(!e.relatedControlId||!p){return;}t=this.isPlatformTablet();r=sap.ui.getCore().byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(q.sap.containsOrEquals(p.getFocusDomRef(),F)&&!t){this.focus();}};
c.prototype.setSelection=function(i){var L=this.getList(),k;if(L){L.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof I)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}k=i?i.getKey():"";this.setProperty("selectedKey",k,true);this._handleAriaActiveDescendant(i);this.toggleStyleClass(this.getRenderer().CSS_CLASS_COMBOBOX+"SelectionActive",!!k);};
c.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};
c.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());this._sValue=this.getValue();}}};
c.prototype.isFiltered=function(){var L=this.getList();return L&&(L.getVisibleItems().length!==L.getItems().length);};
c.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};
c.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var d=this.getRenderer().CSS_CLASS_COMBOBOXBASE;o.setHorizontalScrolling(false).addStyleClass(d+"Picker").addStyleClass(d+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.createList());return o;};
c.prototype.createList=function(){var r=this.getRenderer();this._oList=new S({width:"100%",busyIndicatorDelay:0}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List").addEventDelegate({ontap:function(e){this.close();},onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this).attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);return this._oList;};
c.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};
c.prototype.getDefaultSelectedItem=function(){return null;};
c.prototype.getChangeEventParams=function(){return{itemPressed:false};};
c.prototype.clearSelection=function(){this.setSelection(null);};
c.prototype.selectText=function(i,d){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=d;return this;};
c.prototype.addAggregation=function(A,o,d){if(A==="items"&&!d&&!this.isInvalidateSuppressed()){this.invalidate(o);}return a.prototype.addAggregation.apply(this,arguments);};
c.prototype.setAssociation=function(A,i,d){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.setAssociation.apply(L,arguments);}return a.prototype.setAssociation.apply(this,arguments);};
c.prototype.setProperty=function(p,v,d){var L=this.getList();if(/selectedKey|selectedItemId/.test(p)){L&&S.prototype.setProperty.apply(L,arguments);}return a.prototype.setProperty.apply(this,arguments);};
c.prototype.removeAllAssociation=function(A,d){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(L,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};
c.prototype.clone=function(d){var o=a.prototype.clone.apply(this,arguments),L=this.getList();if(!this.isBound("items")&&L){for(var i=0,e=L.getItems();i<e.length;i++){o.addItem(e[i].clone());}o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};
c.prototype.findAggregatedObjects=function(){var L=this.getList();if(L){return S.prototype.findAggregatedObjects.apply(L,arguments);}return[];};
c.prototype.setShowSecondaryValues=function(A){this.setProperty("showSecondaryValues",A,true);var L=this.getList();if(L){L.setShowSecondaryValues(A);}return this;};
c.prototype.getItems=function(){var L=this.getList();return L?L.getItems():[];};
c.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof I)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};
c.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};
c.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var d=(k===""),e=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(d){this.setSelection(null);if(!e){this.setValue("");}return this;}var i=this.getItemByKey(k);if(i){this.setSelection(i);if(!e){this.setValue(this._getSelectedItemText(i));}return this;}this._sValue=this.getValue();return this.setProperty("selectedKey",k);};
c.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:sap.ui.getCore().byId(v)||null;};
c.prototype.updateItems=function(){var r,o=this.getSelectedItem(),r=a.prototype.updateItems.apply(this,arguments);q.sap.clearDelayedCall(this._debounceItemsUpdate);this._debounceItemsUpdate=q.sap.delayedCall(0,this,"_syncItemsSelection",[o]);return r;};
c.prototype._syncItemsSelection=function(o){var H,n,d=this.getSelectedKey();if(!o||o===this.getSelectedItem()){return;}n=this.getItems();H=n.some(function(i){return d===i.getKey();});this.setSelectedItem(H&&d?this.getItemByKey(d):null);};
c.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var o;if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){o=this.getDefaultSelectedItem();this.setSelection(o);this.setValue(v);}return i;};
return c;});
sap.ui.predefine('sap/m/ComboBoxBase',['jquery.sap.global','./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Text','./Title','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ValueStateSupport','./library','sap/ui/Device','sap/ui/core/library','./ComboBoxBaseRenderer','jquery.sap.keycodes'],function(q,D,C,T,B,a,b,c,I,d,V,l,e,f,g){"use strict";var P=l.PlacementType;var h=f.ValueState;
var j=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});
j.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};
j.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};
j.prototype.loadItems=function(i,o){var k=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(k){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(k){i.call(this);}};
j.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,m,n,k;i<this.aMessageQueue.length;i++){m=this.aMessageQueue.shift();i--;k=(i+1)===this.aMessageQueue.length;n=k?null:this.aMessageQueue[i+1];if(typeof m.action==="function"){if((m.name==="input")&&!k&&(n.name==="input")){continue;}m.action.call(this);}}};
j.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};
j.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};
j.prototype.getPickerInvisibleTextId=function(){return I.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};
j.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(e.system.phone?"Dialog":"Dropdown");if(e.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;};
j.prototype.onBeforeRendering=function(){var n=this.getValueState()===h.None;C.prototype.onBeforeRendering.apply(this,arguments);if(!this.isPickerDialog()&&n){this._showValueStateText(false);}};
j.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;};
j.prototype.ontouchstart=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(this.isOpenArea(E.target)){this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};
j.prototype.ontouchend=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(!this.isOpen()&&this.isOpenArea(E.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};
j.prototype.ontap=function(E){C.prototype.ontap.apply(this,arguments);var i=this.getRenderer().CSS_CLASS_COMBOBOXBASE,o=E.srcControl,p;if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(o.isOpenArea&&o.isOpenArea(E.target)){if(this.isOpen()){this.close();this.removeStyleClass(i+"Pressed");return;}this.loadItems();this.bOpenedByKeyboardOrButton=true;if(this.isPlatformTablet()){p=this.getPicker();p.setInitialFocus(p);}this.open();}if(this.isOpen()){this.addStyleClass(i+"Pressed");}};
j.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===q.sap.KeyCodes.F4){this.onF4(E);}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};
j.prototype.onF4=function(E){E.preventDefault();};
j.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};
j.prototype.onsaphide=j.prototype.onsapshow;
j.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),F=r&&r.getFocusDomRef();if(p&&q.sap.containsOrEquals(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};
j.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
j.prototype.addContent=function(p){};
j.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};
j.prototype.setPickerType=function(p){this._sPickerType=p;};
j.prototype.getPickerType=function(){return this._sPickerType;};
j.prototype.setValueState=function(v){var A,s=this.getValueStateText(),S=(v===h.None?false:this.getShowValueStateMessage());this._sOldValueState=this.getValueState();C.prototype.setValueState.apply(this,arguments);this._showValueStateText(S);if(s){this._setValueStateText(s);}else{A=V.getAdditionalText(this);this._setValueStateText(A);}this._alignValueStateStyles();return this;};
j.prototype.setValueStateText=function(t){C.prototype.setValueStateText.apply(this,arguments);this._setValueStateText(this.getValueStateText());return this;};
j.prototype.setShowValueStateMessage=function(s){C.prototype.setShowValueStateMessage.apply(this,arguments);this._showValueStateText(this.getShowValueStateMessage());return this;};
j.prototype._showValueStateText=function(s){var o;if(this.isPickerDialog()){if(this._oPickerValueStateText){this._oPickerValueStateText.setVisible(s);}}else{o=this._getPickerCustomHeader();if(o){o.setVisible(s);}}};
j.prototype._setValueStateText=function(t){var H;if(this.isPickerDialog()){this._oPickerValueStateText=this.getPickerValueStateText();this._oPickerValueStateText.setText(t);}else{H=this._getPickerCustomHeader();if(H){H.getContentLeft()[0].setText(t);}}};
j.prototype._getPickerCustomHeader=function(){var i,o,p=this.getPicker(),s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"PickerTitle";if(!p){return null;}if(p.getCustomHeader()){return p.getCustomHeader();}i=new c({textAlign:"Left"}).addStyleClass(s);o=new a({visible:false,contentLeft:i});p.setCustomHeader(o);return o;};
j.prototype._alignValueStateStyles=function(){var o=this._sOldValueState,i=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Picker",p=i+"ValueState",O=i+o+"State",s=i+this.getValueState()+"State",k;if(this.isPickerDialog()&&this._oPickerValueStateText){this._oPickerValueStateText.addStyleClass(p);this._oPickerValueStateText.removeStyleClass(O);this._oPickerValueStateText.addStyleClass(s);}else{k=this._getPickerCustomHeader();if(k){k.addStyleClass(p);k.removeStyleClass(O);k.addStyleClass(s);}}};
j.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};
j.prototype.onPropertyChange=function(o,i){var n=o.getParameter("newValue"),p=o.getParameter("name"),m="set"+p.charAt(0).toUpperCase()+p.slice(1),k=(i&&i.srcControl)||this.getPickerTextField();if(/\bvalue\b|\benabled\b|\bname\b|\bplaceholder\b|\beditable\b|\btextAlign\b|\btextDirection\b|\bvalueState\b/.test(p)&&k&&(typeof k[m]==="function")){k[m](n);}};
j.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};
j.prototype.isPlatformTablet=function(){var n=!e.system.combi,t=e.system.tablet&&n;return t;};
j.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};
j.prototype.getPickerValueStateText=function(){var p=this.getPicker();if(!this._oPickerValueStateText){this._oPickerValueStateText=new b({width:"100%"});p.insertContent(this._oPickerValueStateText,0);}return this._oPickerValueStateText;};
j.prototype.createPicker=function(p){};
j.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};
j.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};
j.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p.getSubHeader();return s&&s.getContent()[0]||null;};
j.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};
j.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),i=o._handleEvent;o._handleEvent=function(E){i.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){t._handleEvent(E);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();},ariaLabelledBy:t.getPickerInvisibleTextId()||undefined});};
j.prototype.createPickerHeader=function(){var t=this,i=d.getIconURI("decline");return new a({contentMiddle:new c(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};
j.prototype.revertSelection=function(){};
j.prototype.updatePickerHeaderTitle=function(){var p=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),L,i;if(!p){return;}i=this.getLabels();if(i.length){L=i[0];if(L&&(typeof L.getText==="function")){this.getPickerTitle().setText(L.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};
j.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};
j.prototype.hasContent=function(){return this.getItems().length>0;};
j.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};
j.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};
j.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};
j.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};
j.prototype.isItemSelected=function(){};
j.prototype.getKeys=function(k){k=k||this.getItems();for(var i=0,K=[];i<k.length;i++){K[i]=k[i].getKey();}return K;};
j.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};
j.prototype.findItem=function(p,v){var L=this.getList();return L?L.findItem(p,v):null;};
j.prototype.getItemByText=function(t){return this.findItem("text",t);};
j.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),k=i&&i.getDomRef();if(!p||!o||!k){return;}var m=o.scrollTop,n=k.offsetTop,r=o.clientHeight,s=k.offsetHeight;if(m>n){o.scrollTop=n;}else if((n+s)>(m+r)){o.scrollTop=Math.ceil(n+s-r);}};
j.prototype.clearFilter=function(){for(var i=0,k=this.getItems();i<k.length;i++){k[i].bVisible=true;}};
j.prototype.onItemChange=function(o){};
j.prototype.clearSelection=function(){};
j.prototype.setInternalBusyIndicator=function(i){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};
j.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};
j.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};
j.prototype.insertItem=function(i,k){this.insertAggregation("items",i,k,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};
j.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};
j.prototype.getFirstItem=function(){return this.getItems()[0]||null;};
j.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};
j.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};
j.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};
j.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};
j.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};
j.prototype.removeItem=function(i){var L=this.getList();i=L?L.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};
j.prototype.removeAllItems=function(){var L=this.getList(),k=L?L.removeAllItems():[];this.clearSelection();for(var i=0;i<k.length;i++){k[i].detachEvent("_change",this.onItemChange,this);}return k;};
j.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}return this;};
return j;});
sap.ui.predefine('sap/m/ComboBoxBaseRenderer',['./ComboBoxTextFieldRenderer','sap/ui/core/Renderer'],function(C,R){"use strict";var a=R.extend(C);a.CSS_CLASS_COMBOBOXBASE="sapMComboBoxBase";
a.getAccessibilityState=function(c){var A=C.getAccessibilityState.call(this,c);A.expanded=c.isOpen();return A;};
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);var b=a.CSS_CLASS_COMBOBOXBASE;r.addClass(b);if(!c.getEnabled()){r.addClass(b+"Disabled");}if(!c.getEditable()){r.addClass(b+"Readonly");}};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOXBASE+"Arrow");};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxRenderer',['./ComboBoxBaseRenderer','sap/ui/core/Renderer'],function(C,R){"use strict";var a=R.extend(C);a.CSS_CLASS_COMBOBOX="sapMComboBox";
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX);};
a.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Inner");};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Arrow");};
a.addPlaceholderClasses=function(r,c){C.addPlaceholderClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Placeholder");};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxTextField',['./InputBase','./library','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device',"./ComboBoxTextFieldRenderer"],function(I,l,a,c,D,C){"use strict";var V=c.ValueState;
var b=I.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_buttonLabelText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}}}});
b.prototype.init=function(){I.prototype.init.apply(this,arguments);var r,A;if(sap.ui.getCore().getConfiguration().getAccessibility()){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");A=new a({text:r.getText("COMBOBOX_BUTTON")});this.setAggregation("_buttonLabelText",A,true);}};
b.prototype.updateValueStateClasses=function(v,o){I.prototype.updateValueStateClasses.apply(this,arguments);var m=V,d=this.getRenderer().CSS_CLASS_COMBOBOXTEXTFIELD,$=this.$();if(o!==m.None){$.removeClass(d+"State "+d+o);}if(v!==m.None){$.addClass(d+"State "+d+v);}};
b.prototype.getOpenArea=function(){return this.getDomRef("arrow");};
b.prototype.isOpenArea=function(d){var o=this.getOpenArea();return o&&o.contains(d);};
b.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();var v=this.getValue(),i=v.length;this.setValue(v);this.selectText(i,i);};
b.prototype.bShowLabelAsPlaceholder=D.browser.msie;
b.prototype.getValue=function(){var d=this.getFocusDomRef();if(d){return d.value;}return this.getProperty("value");};
b.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};
b.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_COMBO");return i;};
return b;});
sap.ui.predefine('sap/m/ComboBoxTextFieldRenderer',['jquery.sap.global','./InputBaseRenderer','sap/ui/core/Renderer'],function(q,I,R){"use strict";var C=R.extend(I);C.CSS_CLASS_COMBOBOXTEXTFIELD="sapMComboBoxTextField";
C.writeInnerAttributes=function(r,c){r.writeAttribute("autocomplete","off");r.writeAttribute("autocorrect","off");r.writeAttribute("autocapitalize","off");r.writeAttribute("type","text");};
C.writeOuterAttributes=function(r,c){if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","combobox");}};
C.getAriaRole=function(){};
C.getAccessibilityState=function(c){var a=I.getAccessibilityState.call(this,c);a.autocomplete="both";return a;};
C.addOuterStyles=function(r,c){r.addStyle("max-width",c.getMaxWidth());};
C.addOuterClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a);if(!c.getEnabled()){r.addClass(a+"Disabled");}if(!c.getEditable()){r.addClass(a+"Readonly");}};
C.addPaddingClass=q.noop;
C.addInnerClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a+"Inner");if(!c.getEditable()){r.addClass(a+"InnerReadonly");}if(c.getShowButton()){r.addClass(a+"InnerWidthExtraPadding");}};
C.addValueStateClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a+"State");r.addClass(a+c.getValueState());};
C.writeDecorations=function(r,c){if(c.getShowButton()){this.renderButton(r,c);}};
C.renderButton=function(r,c){var i=c.getId(),b=i+"-arrow",a=sap.ui.getCore().getConfiguration().getAccessibility(),A=c.getAggregation("_buttonLabelText");r.write('<span tabindex="-1" ');r.writeAttribute("id",b);if(a){r.writeAttribute("role","button");r.writeAttribute("aria-labelledby",A.getId());}this.addButtonClasses(r,c);r.writeClasses();r.write(">");a&&r.renderControl(A);r.write("</span>");};
C.addButtonClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD+"Arrow";r.addClass(a);if(!c.getEnabled()){r.addClass(a+"Disabled");}};
return C;},true);
sap.ui.predefine('sap/m/CustomListItem',['./ListItemBase','./library','./CustomListItemRenderer'],function(L,l,C){"use strict";
var a=L.extend("sap.m.CustomListItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/CustomListItem.designtime"}});
a.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/m/CustomListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var C=R.extend(L);
C.renderLIAttributes=function(r,l){r.addClass("sapMCLI");};
C.renderLIContent=function(r,l){var c=l.getContent();var a=c.length;for(var i=0;i<a;i++){r.renderControl(c[i]);}};
return C;},true);
sap.ui.predefine('sap/m/CustomTile',['./Tile','./library','./CustomTileRenderer'],function(T,l,C){"use strict";
var a=T.extend("sap.m.CustomTile",{metadata:{library:"sap.m",designtime:"sap/m/designtime/CustomTile.designtime",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}}}});
return a;});
sap.ui.predefine('sap/m/CustomTileRenderer',['./TileRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var C=R.extend(T);
C.render=function(r,c){var t,v;r.write("<div tabindex=\"0\"");r.writeControlData(c);r.addClass("sapMCustomTile");r.writeClasses();if(c._invisible){r.addStyle("visibility","hidden");r.writeStyles();}if(c.getParent()instanceof sap.m.TileContainer){t=c.getParent();v=t._getVisibleTiles();r.writeAccessibilityState(c,{role:"option",posinset:t._indexOfVisibleTile(c,v)+1,setsize:v.length});}r.write(">");r.write("<div id=\""+c.getId()+"-remove\" class=\"sapMTCRemove\"></div>");r.write("<div class=\"sapMCustomTileContent\">");this._renderContent(r,c);r.write("</div></div>");};
C._renderContent=function(r,t){r.renderControl(t.getContent());};
return C;},true);
sap.ui.predefine('sap/m/DatePicker',['jquery.sap.global','sap/ui/Device','./InputBase','./DateTimeField','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer"],function(q,D,I,a,U,l,C,c,b){"use strict";var T=c.TextAlign;var d=c.CalendarType;var e;
var f=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"}}}},designtime:"sap/m/designtime/DatePicker.designtime"}});
f.prototype.init=function(){I.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);};
f.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){q.sap.clearDelayedCall(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};
f.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=q.sap.delayedCall(0,this,o);}};
f.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();};
f.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};
f.prototype.getWidth=function(w){return this.getProperty("width")||"100%";};
f.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;I.prototype.applyFocusInfo.apply(this,arguments);};
f.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};
f.prototype.onsapshow=function(E){g.call(this);E.preventDefault();};
f.prototype.onsaphide=f.prototype.onsapshow;
f.prototype.onsappageup=function(E){i.call(this,1,"day");E.preventDefault();};
f.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){i.call(this,1,"month");}else{i.call(this,1,"year");}E.preventDefault();};
f.prototype.onsappagedown=function(E){i.call(this,-1,"day");E.preventDefault();};
f.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){i.call(this,-1,"month");}else{i.call(this,-1,"year");}E.preventDefault();};
f.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var s=String.fromCharCode(E.charCode);if(s&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(s)<0){E.preventDefault();}};
f.prototype.onclick=function(E){if(q(E.target).hasClass("sapUiIcon")){g.call(this);}};
f.prototype._dateValidation=function(p){this._bValid=true;if(p&&(p.getTime()<this._oMinDate.getTime()||p.getTime()>this._oMaxDate.getTime())){this._bValid=false;}this.setProperty("dateValue",p);return p;};
f.prototype.setMinDate=function(p){if(this._isValidDate(p)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getMinDate(),p)){return this;}if(p){var y=p.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(p.getTime());var r=this.getDateValue();if(r&&r.getTime()<p.getTime()){q.sap.log.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",p);if(this._oCalendar){this._oCalendar.setMinDate(p);}this._oMinDate.setHours(0,0,0,0);return this;};
f.prototype.setMaxDate=function(p){if(this._isValidDate(p)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getMaxDate(),p)){return this;}if(p){var y=p.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(p.getTime());var r=this.getDateValue();if(r&&r.getTime()>p.getTime()){q.sap.log.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",p);if(this._oCalendar){this._oCalendar.setMaxDate(p);}this._oMaxDate.setHours(23,59,59,999);return this;};
f.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var p=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(p.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",p,true);this.setProperty("maxDate",M,true);if(this._oCalendar){this._oCalendar.setMinDate(p);this._oCalendar.setMaxDate(M);}}var r=this.getDateValue();if(r&&(r.getTime()<this._oMinDate.getTime()||r.getTime()>this._oMaxDate.getTime())){q.sap.log.error("dateValue "+r.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};
f.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};
f.prototype._handleDateValidation=function(p){this._bValid=true;if(!p||p.getTime()<this._oMinDate.getTime()||p.getTime()>this._oMaxDate.getTime()){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}this.setProperty("dateValue",p);};
f.prototype.setDisplayFormatType=function(s){if(s){var F=false;for(var t in d){if(t==s){F=true;break;}}if(!F){throw new Error(s+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",s,true);this.setDisplayFormat(this.getDisplayFormat());return this;};
f.prototype.setSecondaryCalendarType=function(s){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",s,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(s);}return this;};
f.prototype.addSpecialDate=function(s){n.call(this,s);this.addAggregation("specialDates",s,true);o.call(this);return this;};
f.prototype.insertSpecialDate=function(s,p){n.call(this,s);this.insertAggregation("specialDates",s,p,true);o.call(this);return this;};
f.prototype.removeSpecialDate=function(s){var r=this.removeAggregation("specialDates",s,true);o.call(this);return r;};
f.prototype.removeAllSpecialDates=function(){var r=this.removeAllAggregation("specialDates",true);o.call(this);return r;};
f.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);o.call(this);return this;};
f.prototype.setLegend=function(L){this.setAssociation("legend",L,true);var s=this.getLegend();if(s){var p=sap.ui.require("sap/ui/unified/CalendarLegend");L=sap.ui.getCore().byId(s);if(L&&!(typeof p=="function"&&L instanceof p)){throw new Error(L+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(s);}return this;};
f.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var O=this._formatValue(this.getDateValue());if(v==O&&this._bValid){return;}var p;this._bValid=true;if(v!=""){p=this._parseValue(v,true);if(!p||p.getTime()<this._oMinDate.getTime()||p.getTime()>this._oMaxDate.getTime()){this._bValid=false;p=undefined;}else{v=this._formatValue(p);}}if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}if(p){v=this._formatValue(p,true);}if(this._lastValue!==v||(p&&this.getDateValue()&&p.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=v;this.setProperty("value",v,true);var N=this.getValue();if(this._bValid&&v==N){this.setProperty("dateValue",p,true);}v=N;if(this._oPopup&&this._oPopup.isOpen()){if(this._bValid){p=this.getDateValue();}this._oCalendar.focusDate(p);var s=this._oDateRange.getStartDate();if((!s&&p)||(s&&p&&s.getTime()!=p.getTime())){this._oDateRange.setStartDate(new Date(p.getTime()));}else if(s&&!p){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(v,{valid:this._bValid});}};
f.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var p=this._parseValue(v,true);v=this._formatValue(p,true);return v;};
f.prototype.updateDomValue=function(v){if(this.isActive()&&(this._$input.val()!==v)){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var p=this._parseValue(v,true);v=this._formatValue(p);this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};
f.prototype._storeInputSelection=function(p){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:p.selectionStart,iEnd:p.selectionEnd};p.selectionStart=0;p.selectionEnd=0;}};
f.prototype._restoreInputSelection=function(p){if((D.browser.msie||D.browser.edge)&&!D.support.touch){p.selectionStart=this._oInputSelBeforePopupOpen.iStart;p.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};
function _(){this._createPopup();this._createPopupContent();var s;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){s=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.calendarType;}if(!s){s=this.getDisplayFormatType();}if(s){this._oCalendar.setPrimaryCalendarType(s);}var v=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(v!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}
f.prototype._createPopup=function(){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setDurations(0,0);this._oPopup.attachOpened(j,this);this._oPopup.attachClosed(k,this);}};
f.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup.setAutoCloseAreas([this.getDomRef()]);var p=sap.ui.core.Popup.Dock;var A;if(this.getTextAlign()==T.End){A=p.EndBottom+"-4";this._oPopup.open(0,p.EndTop,A,this,null,"fit",true);}else{A=p.BeginBottom+"-4";this._oPopup.open(0,p.BeginTop,A,this,null,"fit",true);}};
f.prototype._getVisibleDatesRange=function(p){var v=p._getVisibleDays();return new sap.ui.unified.DateRange({startDate:v[0].toLocalJSDate(),endDate:v[v.length-1].toLocalJSDate()});};
f.prototype._createPopupContent=function(){if(!this._oCalendar){if(!e){sap.ui.getCore().loadLibrary("sap.ui.unified");e=sap.ui.requireSync("sap/ui/unified/Calendar");}this._oCalendar=new e(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new sap.ui.unified.DateRange();this._oCalendar.addSelectedDate(this._oDateRange);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._selectDate,this);this._oCalendar.attachCancel(h,this);this._oCalendar.attachEvent("_renderMonth",m,this);this._oCalendar.setPopupMode(true);this._oCalendar.setParent(this,undefined,true);this._oPopup.setContent(this._oCalendar);}}};
f.prototype._fillDateRange=function(){var p=this.getDateValue();if(p&&p.getTime()>=this._oMinDate.getTime()&&p.getTime()<=this._oMaxDate.getTime()){this._oCalendar.focusDate(new Date(p.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=p.getTime()){this._oDateRange.setStartDate(new Date(p.getTime()));}}else{var r=this.getInitialFocusedDateValue();var F=r?r:new Date();var M=this._oMaxDate.getTime()+86400000;if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};
f.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var p=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var s=this.getDateValue();if(s){v=this._formatValue(s);}}p.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");p.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return p;};
function g(){if(this.getEditable()&&this.getEnabled()){if(!this._oPopup||!this._oPopup.isOpen()){_.call(this);}else{h.call(this);}}}
f.prototype._selectDate=function(E){var p=this.getDateValue();var r=this._getSelectedDate();var v="";if(!q.sap.equal(r,p)){this.setDateValue(new Date(r.getTime()));v=this.getValue();this.fireChangeEvent(v,{valid:true});if(this.getDomRef()&&(D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(r);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);this._lastValue=v;}this.setProperty("value",v,true);this.fireChangeEvent(v,{valid:true});}}else if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this.focus();}this._oPopup.close();};
f.prototype._getSelectedDate=function(){var s=this._oCalendar.getSelectedDates();var p;if(s.length>0){p=s[0].getStartDate();}return p;};
function h(E){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this.focus();}}}
function i(N,u){var O=this.getDateValue();var p=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var s;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){s=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.calendarType;}if(!s){s=this.getDisplayFormatType();}var r=U.getInstance(new Date(O.getTime()),s);O=U.getInstance(new Date(O.getTime()),s);switch(u){case"day":r.setDate(r.getDate()+N);break;case"month":r.setMonth(r.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(r.getMonth()!=M){r.setDate(r.getDate()-1);}break;case"year":r.setFullYear(r.getFullYear()+N);while(r.getMonth()!=O.getMonth()){r.setDate(r.getDate()-1);}break;default:break;}if(r.getTime()<this._oMinDate.getTime()){r=new U(this._oMinDate.getTime());}else if(r.getTime()>this._oMaxDate.getTime()){r=new U(this._oMaxDate.getTime());}if(!q.sap.equal(this.getDateValue(),r.getJSDate())){this.setDateValue(new Date(r.getTime()));this._curpos=p;this._$input.cursorPos(this._curpos);var v=this.getValue();this.fireChangeEvent(v,{valid:true});}}}
function j(E){this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);}
function k(E){this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));}
function m(E){var p=E.getParameter("days");if(p>this._renderedDays){this._renderedDays=p;this._oPopup._applyPosition(this._oPopup._oLastPosition);}}
function n(s){var p=sap.ui.require("sap/ui/unified/DateTypeRange");if(s&&!(p&&s instanceof p)){throw new Error(s+"is not valid for aggregation \"specialDates\" of "+this);}}
function o(){if(this._oPopup&&this._oPopup.isOpen()){this._oCalendar._bDateRangeChanged=true;this._oCalendar.invalidate();}}
return f;});
sap.ui.predefine('sap/m/DatePickerRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var D=R.extend(I);
D.addOuterClasses=function(r,d){r.addClass("sapMDP");if(d.getEnabled()&&d.getEditable()){r.addClass("sapMInputVH");}};
D.writeDecorations=function(r,d){if(d.getEnabled()&&d.getEditable()){var c=["sapMInputValHelpInner"];var a={};a["id"]=d.getId()+"-icon";a["tabindex"]="-1";a["title"]=null;r.write('<div class="sapMInputValHelp">');r.writeIcon(this._getIcon(),c,a);r.write("</div>");}};
D._getIcon=function(){return"sap-icon://appointment-2";};
D.writeInnerValue=function(r,d){if(d._bValid){r.writeAttributeEscaped("value",d._formatValue(d.getDateValue()));}else{r.writeAttributeEscaped("value",d.getValue());}};
D.writeInnerAttributes=function(r,d){r.writeAttribute("type","text");if(d._bMobile){r.writeAttribute("readonly","readonly");}};
D.getAriaRole=function(d){return"combobox";};
D.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATEPICKER_DATE_TYPE")+" "+b;};
D.getAccessibilityState=function(d){var a=I.getAccessibilityState.apply(this,arguments);a["autocomplete"]="none";a["haspopup"]=true;a["expanded"]=false;if(d._bMobile&&d.getEnabled()&&d.getEditable()){a["readonly"]=false;}return a;};
return D;},true);
sap.ui.predefine('sap/m/DateRangeSelection',['jquery.sap.global','sap/ui/Device','./DatePicker','./library','sap/ui/core/LocaleData','sap/ui/core/format/DateFormat','./DateRangeSelectionRenderer'],function(q,D,a,l,L,b,c){"use strict";
var d=a.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}},designtime:"sap/m/designtime/DateRangeSelection.designtime"}});
d.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};
d.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=j.call(this);var s=h.call(this);var A=F.sAllowedCharacters+s+" ";var C=String.fromCharCode(E.charCode);if(C&&F.sAllowedCharacters&&A.indexOf(C)<0){E.preventDefault();}};
d.prototype._getPlaceholder=function(){var p=this.getPlaceholder(),B,o,i,r;if(!p){B=this.getBinding("value");i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();r=L.getInstance(i);if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){o=B.getType();if(o.oFormatOptions&&o.oFormatOptions.format){p=r.getCustomDateTimePattern(o.oFormatOptions.format);}else{p=r.getDatePattern("medium");}}else{p=this.getDisplayFormat();if(!p){p="medium";}if(this._checkStyle(p)){p=r.getDatePattern(p);}}var s=h.call(this);if(s&&s!==""){p=p+" "+s+" "+p;}}return p;};
d.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v);this._bValid=true;var i=[undefined,undefined];if(v){i=this._parseValue(v);if(!g.call(this,i[0],i[1])[0]){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid dates",this);}}this.setProperty("dateValue",_(i[0]));this.setProperty("secondDateValue",_(i[1]));if(this.getDomRef()){var o=this._formatValue(i[0],i[1]);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
function _(B){return(typeof B==='number')?new Date(B):B;}
function e(B){return(B&&B.getTime)?B.getTime():B;}
d.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);q.sap.log.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};
d.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var o=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",o,true);if(this.getDomRef()&&(this._$input.val()!==o)){this._$input.val(o);this._curpos=this._$input.cursorPos();}return this;};
d.prototype.setFrom=function(F){this.setDateValue(F);return this;};
d.prototype.getFrom=function(){return this.getDateValue();};
d.prototype.setTo=function(t){this.setSecondDateValue(t);return this;};
d.prototype.getTo=function(){return this.getSecondDateValue();};
d.prototype.setDateValue=function(o){if(this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),o)){return this;}a.prototype._dateValidation.call(this,o);this._syncDateObjectsToValue(o,this.getSecondDateValue());return this;};
d.prototype.setSecondDateValue=function(s){if(this._isValidDate(s)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getSecondDateValue(),s)){return this;}this._bValid=true;if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;}this.setProperty("secondDateValue",s);this._syncDateObjectsToValue(this.getDateValue(),s);return this;};
d.prototype.setMinDate=function(o){a.prototype.setMinDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()<this._oMinDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date range",this);}}return this;};
d.prototype.setMaxDate=function(o){a.prototype.setMaxDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date range",this);}}return this;};
d.prototype._checkMinMaxDate=function(){a.prototype._checkMinMaxDate.apply(this,arguments);var s=this.getSecondDateValue();if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){q.sap.log.error("secondDateValue "+s.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain secondDateValue/value accordingly.",this);}};
d.prototype._parseValue=function(v){var F;var i=[];var o,p;var B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){i=B.getType().parseValue(v,"string");if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){i=i.map(function(u){return new Date(u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate(),u.getUTCHours(),u.getUTCMinutes(),u.getUTCSeconds());});}return i;}var s=h.call(this);v=v.trim();if(s&&v){v=n(v,[s," "]);i=v.split(s);if(i.length===2){if(i[0].slice(i[0].length-1,i[0].length)==" "){i[0]=i[0].slice(0,i[0].length-1);}if(i[1].slice(0,1)==" "){i[1]=i[1].slice(1);}}else{i=v.split(" "+s+" ");}if(v.indexOf(s)===-1){var r=v.split(" ");if(r.length===2){i=r;}}}if(v&&i.length<=2){F=j.call(this);if((!s||s==="")||i.length===1){o=F.parse(v);}else if(i.length===2){o=F.parse(i[0]);p=F.parse(i[1]);if(!o||!p){o=undefined;p=undefined;}}}return[o,p];};
d.prototype._formatValue=function(o,s){var v="",i=h.call(this),F,B,p,r;p=o;r=s;if(p){B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){if(B.getType().oFormatOptions&&B.getType().oFormatOptions.source&&B.getType().oFormatOptions.source.pattern==="timestamp"){v=B.getType().formatValue([e(o),e(s)],"string");}else{if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){p=new Date(Date.UTC(o.getFullYear(),o.getMonth(),o.getDate(),o.getHours(),o.getMinutes(),o.getSeconds()));if(s){r=new Date(Date.UTC(s.getFullYear(),s.getMonth(),s.getDate(),s.getHours(),s.getMinutes(),s.getSeconds()));}}v=B.getType().formatValue([p,r],"string");}}else{F=j.call(this);if(i&&i!==""&&r){v=F.format(p)+" "+i+" "+F.format(r);}else{v=F.format(p);}}}return v;};
d.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var i=[undefined,undefined];this._bValid=true;if(v!=""){i=this._parseValue(v);i=g.call(this,i[0],i[1]);if(i[0]){v=this._formatValue(i[0],i[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",_(i[0]),true);this.setProperty("secondDateValue",_(i[1]),true);}this._setLabelVisibility();if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}f.call(this,this._bValid);}};
d.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var i=this._parseValue(v);v=this._formatValue(i[0],i[1]);return v;};
d.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var i=this._parseValue(v);v=this._formatValue(i[0],i[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}this._setLabelVisibility();return this;};
d.prototype.onsappageup=function(){};
d.prototype.onsappageupmodifiers=function(){};
d.prototype.onsappagedown=function(){};
d.prototype.onsappagedownmodifiers=function(){};
d.prototype._fillDateRange=function(){a.prototype._fillDateRange.apply(this,arguments);var E=this.getSecondDateValue();if(E&&E.getTime()>=this._oMinDate.getTime()&&E.getTime()<=this._oMaxDate.getTime()){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};
d.prototype._selectDate=function(E){var s=this._oCalendar.getSelectedDates();if(s.length>0){var o=s[0].getStartDate();var i=s[0].getEndDate();if(o&&i){var p=this.getDateValue();var r=this.getSecondDateValue();var v;if(!q.sap.equal(o,p)||!q.sap.equal(i,r)){if(q.sap.equal(i,r)){this.setDateValue(o);}else{this.setProperty("dateValue",o,true);this.setSecondDateValue(i);}v=this.getValue();f.call(this,true);if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this._curpos=v.length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(o,i);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}f.call(this,true);}}this._oPopup.close();}}};
d.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=a.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var o=this.getDateValue();if(o){v=this._formatValue(o,this.getSecondDateValue());}}i.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return i;};
d.prototype._syncDateObjectsToValue=function(o,s){var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}};
function f(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}
function g(o,s){var F,S;if(o&&o.getTime){F=o.getTime();}else if(typeof o==='number'){F=o;}if(s&&s.getTime){S=s.getTime();}else if(typeof s==='number'){S=s;}if(o&&s&&F>S){var t=o;o=s;s=t;}if((o&&(F<this._oMinDate.getTime()||F>this._oMaxDate.getTime()))||(s&&(S<this._oMinDate.getTime()||S>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[o,s];}}
function h(){var s=this.getDelimiter();if(!s){if(!this._sLocaleDelimiter){var o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var i=L.getInstance(o);var p=i.getIntervalPattern();var I=p.indexOf("{0}")+3;var r=p.indexOf("{1}");s=p.slice(I,r);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}this._sLocaleDelimiter=s;}else{s=this._sLocaleDelimiter;}}return s;}
function j(){var p=(this.getDisplayFormat()||"medium");var F;var C=this.getDisplayFormatType();if(p==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}else{if(this._checkStyle(p)){F=b.getInstance({style:p,strictParsing:true,calendarType:C});}else{F=b.getInstance({pattern:p,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=F;}return F;}
function k(v,E){return v&&E&&v.lastIndexOf(E)===v.length-E.length;}
function m(v,s){return v&&s&&v.indexOf(s)===0;}
function n(v,p){var i=0,t=p;if(!t){t=[" "];}while(i<t.length){if(k(v,t[i])){v=v.substring(0,v.length-t[i].length);i=0;continue;}i++;}i=0;while(i<t.length){if(m(v,t[i])){v=v.substring(t[i].length);i=0;continue;}i++;}return v;}
return d;});
sap.ui.predefine('sap/m/DateRangeSelectionRenderer',['sap/ui/core/Renderer','./DatePickerRenderer'],function(R,D){"use strict";var a=R.extend(D);
a.writeInnerValue=function(r,c){if(c._bValid){r.writeAttributeEscaped("value",c._formatValue(c.getDateValue(),c.getSecondDateValue()));}else{r.writeAttributeEscaped("value",c.getValue());}};
return a;},true);
sap.ui.predefine('sap/m/DateTimeField',['jquery.sap.global','sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','./InputBase','sap/ui/core/LocaleData','sap/ui/core/library','sap/ui/core/format/DateFormat','./DateTimeFieldRenderer'],function(q,S,O,I,L,c,D,a){"use strict";var C=c.CalendarType;
var b=I.extend("sap.m.DateTimeField",{metadata:{"abstract":true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null},initialFocusedDateValue:{type:"object",group:"Data",defaultValue:null}}}});
b.prototype.setValue=function(v){v=this.validateProperty("value",v);var o=this.getValue();if(v===o){return this;}else{this._lastValue=v;}this.setProperty("value",v);this._bValid=true;var d;if(v){d=this._parseValue(v);if(!d||d.getTime()<this._oMinDate.getTime()||d.getTime()>this._oMaxDate.getTime()){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}}this.setProperty("dateValue",d);if(this.getDomRef()){var s;if(d){s=this._formatValue(d);}else{s=v;}if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
b.prototype.setDateValue=function(d){if(this._isValidDate(d)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),d)){return this;}d=this._dateValidation(d);var v=this._formatValue(d,true);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v);if(this.getDomRef()){var o=this._formatValue(d);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
b.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var V=this.getValue();if(V){this._handleDateValidation(this._parseValue(V));}return this;};
b.prototype.setDisplayFormat=function(d){this.setProperty("displayFormat",d,true);this.updateDomValue(this._formatValue(this.getDateValue()));return this;};
b.prototype.getDisplayFormatType=function(){return null;};
b.prototype._dateValidation=function(d){this._bValid=true;this.setProperty("dateValue",d);return d;};
b.prototype._handleDateValidation=function(d){this._bValid=true;this.setProperty("dateValue",d);};
b.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this._getDisplayFormatPattern();if(!p){p=this._getDefaultDisplayStyle();}if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}}return p;};
b.prototype._getLocaleBasedPattern=function(p){return L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getDatePattern(p);};
b.prototype._parseValue=function(v,d){return this._getFormatter(d).parse(v);};
b.prototype._formatValue=function(d,v){if(d){return this._getFormatter(!v).format(d);}return"";};
b.prototype._getDefaultDisplayStyle=function(){return"medium";};
b.prototype._getDefaultValueStyle=function(){return"short";};
b.prototype._getFormatter=function(d){var p=this._getBoundValueTypePattern(),r=false,f,B=this.getBinding("value"),s;if(B&&B.oType&&B.oType.oOutputFormat){r=!!B.oType.oOutputFormat.oFormatOptions.relative;s=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){if(d){p=(this.getDisplayFormat()||this._getDefaultDisplayStyle());s=this.getDisplayFormatType();}else{p=(this.getValueFormat()||this._getDefaultValueStyle());s=C.Gregorian;}}if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}if(d){if(p===this._sUsedDisplayPattern&&s===this._sUsedDisplayCalendarType){f=this._oDisplayFormat;}}else{if(p===this._sUsedValuePattern&&s===this._sUsedValueCalendarType){f=this._oValueFormat;}}if(f){return f;}return this._getFormatterInstance(f,p,r,s,d);};
b.prototype._getFormatterInstance=function(f,p,r,s,d){if(this._checkStyle(p)){f=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:s},d);}else{f=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:s},d);}if(d){this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=s;this._oDisplayFormat=f;}else{this._sUsedValuePattern=p;this._sUsedValueCalendarType=s;this._oValueFormat=f;}return f;};
b.prototype._getFormatInstance=function(A,d){return D.getInstance(A);};
b.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};
b.prototype._getDisplayFormatPattern=function(){var p=this._getBoundValueTypePattern();if(p){return p;}p=this.getDisplayFormat();if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};
b.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType&&B.getType();if(o instanceof S){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};
b.prototype._isValidDate=function(d){return d&&q.type(d)!=="date";};
return b;});
sap.ui.predefine('sap/m/DateTimeFieldRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var D=R.extend(I);return D;},true);
sap.ui.predefine('sap/m/DateTimeInput',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/type/DateTime','sap/ui/model/odata/type/ODataType','sap/ui/core/library','sap/ui/Device','./DateTimeInputRenderer'],function(q,C,l,D,T,a,O,c,b,d){"use strict";var e=l.DateTimeInputType;var f=c.TextDirection;var g=c.TextAlign;var V=c.ValueState;
var h=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DateTimeInput.designtime",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:g.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:f.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:e.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});
!(function(p,$,o){var i=l.getLocaleData();$.extend(p,{_types:{Date:{valueFormat:i.getDatePattern("short"),displayFormat:i.getDatePattern("medium")},Time:{valueFormat:i.getTimePattern("short"),displayFormat:i.getTimePattern("short")},DateTime:{valueFormat:i.getDateTimePattern("short"),displayFormat:i.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,n){["valueFormat","displayFormat"].forEach(function(F){var r=p._types;r.DateTime[F]=r.DateTime[F].replace("{"+n+"}",r[t][F]);});});}(h.prototype,q,b));
h.prototype.init=function(){this.setType(e.Date);};
h.prototype.onBeforeRendering=function(){k.call(this);};
h.prototype.getFocusDomRef=function(){var p=_.call(this);return p.getFocusDomRef();};
h.prototype.getIdForLabel=function(){var p=_.call(this);return p.getIdForLabel();};
function j(t){var p;switch(t){case e.DateTime:q.sap.require("sap.m.DateTimePicker");p=new sap.m.DateTimePicker(this.getId()+"-Picker");break;case e.Time:q.sap.require("sap.m.TimePicker");p=new sap.m.TimePicker(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:q.sap.require("sap.m.DatePicker");p=new sap.m.DatePicker(this.getId()+"-Picker");break;}p.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);p.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){p.setDateValue(this.getDateValue());}p.setEnabled(this.getEnabled());p.setEditable(this.getEditable());p.setValueState(this.getValueState());p.setValueStateText(this.getValueStateText());p.setShowValueStateMessage(this.getShowValueStateMessage());p.setName(this.getName());p.setPlaceholder(this.getPlaceholder());p.setTextAlign(this.getTextAlign());p.setTextDirection(this.getTextDirection());p.setWidth("100%");p.attachChange(m,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){p.addAriaLabelledBy(A[i]);}return p;}
h.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var p=j.call(this,t);this.setAggregation("_picker",p);this.setProperty("type",t);return this;};
h.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
h.prototype.setValue=function(v){k.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var p=_.call(this);p.setValue(v);var o=p.getDateValue();this.setProperty("dateValue",o,true);return this;};
h.prototype.setDateValue=function(o){if(this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}k.call(this);this.setProperty("dateValue",o,true);var p=_.call(this);p.setDateValue(o);var v=p.getValue();this.setProperty("value",v,true);return this;};
h.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var p=_.call(this);p.setDisplayFormat(s||this._types[this.getType()].displayFormat);return this;};
h.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var p=_.call(this);p.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};
h.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);var p=_.call(this);p.setEnabled(E);return this;};
h.prototype.setEditable=function(E){this.setProperty("editable",E,true);var p=_.call(this);p.setEditable(E);return this;};
h.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var p=_.call(this);p.setValueState(v);return this;};
h.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var p=_.call(this);p.setValueStateText(v);return this;};
h.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var p=_.call(this);p.setShowValueStateMessage(s);return this;};
h.prototype.setName=function(n){this.setProperty("name",n,true);var p=_.call(this);p.setName(n);return this;};
h.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);var P=_.call(this);P.setPlaceholder(p);return this;};
h.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var p=_.call(this);p.setTextAlign(t);return this;};
h.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var p=_.call(this);p.setTextDirection(t);return this;};
h.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.addAriaLabelledBy(i);return this;};
h.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.removeAriaLabelledBy(i);return this;};
h.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var p=_.call(this);p.removeAllAriaLabelledBy();return this;};
h.prototype.getAccessibilityInfo=function(){var p=_.call(this);return p&&p.getAccessibilityInfo?p.getAccessibilityInfo():null;};
h.prototype._getPickerByTypeAndPattern=function(t,p,i){var r=/[DdYyMLWwGQUur]/,R=/[HhKkmsa]/,n=R.test(i),o=r.test(i),s=n&&!o,u=o&&!n,v=o&&n,N,w;switch(t){case e.Time:case e.Date:case e.DateTime:if(s&&p.getMetadata().getName()!=="sap.m.TimePicker"){N=e.Time;}else if(u&&p.getMetadata().getName()!=="sap.m.DatePicker"){N=e.Date;}else if(v&&p.getMetadata().getName()!=="sap.m.DateTimePicker"){N=e.DateTime;}break;default:{throw"Invalid type: "+t+". Expected is one of the sap.m.DateTimeInputType";}}if(N){this.destroyAggregation("_picker");w=j.call(this,N);this.setAggregation("_picker",w);}return w||p;};
h.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType()&&B.getType();if(o instanceof D||o instanceof T||o instanceof a){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};
function _(){return this.getAggregation("_picker");}
h.prototype._isValidDate=function(o){return o&&q.type(o)!=="date";};
function k(){if(this._getBoundValueTypePattern()){var p=this._getBoundValueTypePattern();var P=_.call(this);P=this._getPickerByTypeAndPattern(this.getType(),P,p);if(P.getValueFormat()!=p){P.setValueFormat(p);}if(P.getDisplayFormat()!=p){P.setDisplayFormat(p);}}}
function m(E){var v=E.getParameter("value");var o;var i=E.getParameter("valid");this.setProperty("value",v,true);if(i){o=E.oSource.getDateValue();this.setProperty("dateValue",o,true);}this.fireChange({value:v,newValue:v,valid:i,dateValue:o,newDateValue:o});}
return h;});
sap.ui.predefine('sap/m/DateTimeInputRenderer',[],function(){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDTI");var w=c.getWidth();if(w){r.addStyle("width",w);}r.writeStyles();r.writeClasses();r.write(">");var p=c.getAggregation("_picker");if(p){r.renderControl(p);}r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DateTimePicker',['jquery.sap.global','./DatePicker','sap/ui/model/type/Date','sap/ui/unified/DateRange','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/LocaleData','./DateTimePickerRenderer','jquery.sap.keycodes'],function(q,D,a,b,l,C,c,d,L,e){"use strict";var P=l.PlacementType;
var f=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",aggregations:{_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/DateTimePicker.designtime"}});
var g=C.extend("DateTimePickerPopup",{
metadata:{aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},timeSliders:{type:"sap.ui.core.Control",multiple:false}}},
renderer:function(r,p){r.write("<div");r.writeControlData(p);r.addClass("sapMDateTimePopupCont");r.addClass("sapMTimePickerDropDown");r.writeClasses();r.write(">");var s=p.getAggregation("_switcher");if(s&&s.getVisible()){r.write("<div");r.addClass("sapMTimePickerSwitch");r.writeClasses();r.write(">");r.renderControl(s);r.write("</div>");}var i=p.getCalendar();if(i){r.renderControl(i);}r.write("<div");r.addClass("sapMTimePickerSep");r.writeClasses();r.write(">");r.write("</div>");var S=p.getTimeSliders();if(S){r.renderControl(S);}r.write("</div>");},
init:function(){},
onBeforeRendering:function(){var s=this.getAggregation("_switcher");if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){if(!s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=r.getText("DATETIMEPICKER_DATE");var t=r.getText("DATETIMEPICKER_TIME");s=new sap.m.SegmentedButton(this.getId()+"-Switch",{selectedKey:"Cal",items:[new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Cal",{key:"Cal",text:i}),new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Sli",{key:"Sli",text:t})]});s.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",s,true);}else{s.setVisible(true);s.setSelectedKey("Cal");}}else if(s){s.setVisible(false);}},
onAfterRendering:function(){if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var s=this.getAggregation("_switcher");var K=s.getSelectedKey();this._switchVisibility(K);if(c.system.phone){this._adjustTimePickerHeightOnPhone();}}},
_adjustTimePickerHeightOnPhone:function(){var s=this.getAggregation("_switcher"),S=s.$().children(0).css("height").replace('px','');this.$().css("height",(document.documentElement.clientHeight-parseInt(S,10))+"px");},
_handleSelect:function(E){this._switchVisibility(E.getParameter("key"));},
_switchVisibility:function(K){var i=this.getCalendar();var s=this.getTimeSliders();if(!i||!s){return;}if(K=="Cal"){i.$().css("display","");s.$().css("display","none");}else{i.$().css("display","none");s.$().css("display","");s._updateSlidersValues();s._onOrientationChanged();s.openFirstSlider();}},
switchToTime:function(){var s=this.getAggregation("_switcher");if(s&&s.getVisible()){s.setSelectedKey("Sli");this._switchVisibility("Sli");}},
getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates();}
});
f.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};
f.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oSliders){this._oSliders.destroy();delete this._oSliders;}this._oPopupContent=undefined;};
f.prototype.setDisplayFormat=function(s){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oSliders){this._oSliders.setDisplayFormat(n.call(this));}return this;};
f.prototype.setMinDate=function(i){D.prototype.setMinDate.call(this,i);if(i){this._oMinDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};
f.prototype.setMaxDate=function(i){D.prototype.setMaxDate.call(this,i);if(i){this._oMaxDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};
f.prototype._getFormatInstance=function(A,i){var M=q.extend({},A);var s=-1;if(M.style){s=M.style.indexOf("/");}if(i){var j=q.extend({},M);if(s>0){j.style=j.style.substr(0,s);}this._oDisplayFormatDate=d.getInstance(j);}return d.getDateTimeInstance(M);};
f.prototype._checkStyle=function(p){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(p.indexOf("/")>0){var s=["short","medium","long","full"];var S=false;for(var i=0;i<s.length;i++){var r=s[i];for(var j=0;j<s.length;j++){var t=s[j];if(p==r+"/"+t){S=true;break;}}if(S){break;}}return S;}return false;};
f.prototype._parseValue=function(v,i){var j=D.prototype._parseValue.apply(this,arguments);if(i&&!j){j=this._oDisplayFormatDate.parse(v);if(j){var O=this.getDateValue();if(!O){O=new Date();}j.setHours(O.getHours());j.setMinutes(O.getMinutes());j.setSeconds(O.getSeconds());j.setMilliseconds(O.getMilliseconds());}}return j;};
f.prototype._getLocaleBasedPattern=function(p){var i=L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),s=p.indexOf("/");if(s>0){return i.getCombinedDateTimePattern(p.substr(0,s),p.substr(s+1));}else{return i.getCombinedDateTimePattern(p,p);}};
f.prototype._createPopup=function(){if(!this._oPopup){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var O=r.getText("TIMEPICKER_SET");var s=r.getText("TIMEPICKER_CANCEL");this._oPopupContent=new g(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oPopup=new sap.m.ResponsivePopover(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:P.VerticalPreferedBottom,beginButton:new sap.m.Button(this.getId()+"-OK",{text:O,press:q.proxy(_,this)}),endButton:new sap.m.Button(this.getId()+"-Cancel",{text:s,press:q.proxy(h,this)}),content:this._oPopupContent});this._oPopup.addStyleClass("sapMDateTimePopup");var p=this._oPopup.getAggregation("_popup");if(p.setShowArrow){p.setShowArrow(false);}this._oPopup.attachAfterOpen(k,this);this._oPopup.attachAfterClose(m,this);if(c.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(E){var K=q.sap.KeyCodes,i=E.which||E.keyCode,A=E.altKey;if((A&&(i===K.ARROW_UP||i===K.ARROW_DOWN))||i===K.F4){_.call(this,E);this.focus();E.preventDefault();}}};this._oPopup.addEventDelegate(this._oPopoverKeydownEventDelegate,this);}this.setAggregation("_popup",this._oPopup,true);}};
f.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));var p=this._oPopup.getAggregation("_popup");p.oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);var s=this._oPopup.getContent()[0]&&this._oPopup.getContent()[0].getTimeSliders();if(s){q.sap.delayedCall(0,s,s._updateSlidersValues);}};
f.prototype._createPopupContent=function(){var N=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(N){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(o,this);var t=this,H=this._oCalendar._hideMonthPicker,i=this._oCalendar._hideYearPicker;this._oCalendar._hideMonthPicker=function(s){H.apply(this,arguments);if(!s){t._selectFocusedDateValue(new b().setStartDate(this._getFocusedDate().toLocalJSDate()));}};this._oCalendar._hideYearPicker=function(s){i.apply(this,arguments);if(!s){t._selectFocusedDateValue(new b().setStartDate(this._getFocusedDate().toLocalJSDate()));}};}if(!this._oSliders){q.sap.require("sap.m.TimePickerSliders");this._oSliders=new sap.m.TimePickerSliders(this.getId()+"-Sliders",{displayFormat:n.call(this),localeId:this.getLocaleId()})._setShouldOpenSliderAfterRendering(true);this._oPopupContent.setTimeSliders(this._oSliders);}};
f.prototype._selectFocusedDateValue=function(i){var j=this._oCalendar;j.removeAllSelectedDates();j.addSelectedDate(i);return this;};
f.prototype._fillDateRange=function(){var i=this.getDateValue();if(i){i=new Date(i.getTime());}else{i=this._getInitialFocusedDateValue();var M=this._oMaxDate.getTime()+86400000;if(i.getTime()<this._oMinDate.getTime()||i.getTime()>M){i=this._oMinDate;}}this._oCalendar.focusDate(i);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(i);}this._oSliders._setTimeValues(i);};
f.prototype._getSelectedDate=function(){var i=D.prototype._getSelectedDate.apply(this,arguments);if(i){var j=this._oSliders.getTimeValues();var p=this._oSliders._getDisplayFormatPattern();if(p.search("h")>=0||p.search("H")>=0){i.setHours(j.getHours());}if(p.search("m")>=0){i.setMinutes(j.getMinutes());}if(p.search("s")>=0){i.setSeconds(j.getSeconds());}if(i.getTime()<this._oMinDate.getTime()){i=new Date(this._oMinDate.getTime());}else if(i.getTime()>this._oMaxDate.getTime()){i=new Date(this._oMaxDate.getTime());}}return i;};
f.prototype._getInitialFocusedDateValue=function(){return this.getInitialFocusedDateValue()||new Date();};
f.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};
f.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};
function _(E){this._selectDate();}
function h(E){this.onsaphide(E);this._oCalendar.removeAllSelectedDates();this._oCalendar.addSelectedDate(new b().setStartDate(this._getInitialFocusedDateValue()));}
function k(E){this.$("inner").attr("aria-expanded",true);this._oCalendar.focus();this._oSliders._onOrientationChanged();}
function m(){this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));}
function n(){var s=this.getDisplayFormat();var t;var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof a)){s=B.oType.getOutputPattern();}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.pattern;}else{s=this.getDisplayFormat();}if(!s){s="medium";}var S=s.indexOf("/");if(S>0&&this._checkStyle(s)){s=s.substr(S+1);}if(s=="short"||s=="medium"||s=="long"||s=="full"){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var j=L.getInstance(i);t=j.getTimePattern(s);}else{t=s;}return t;}
function o(E){this._oPopupContent.switchToTime();}
return f;});
sap.ui.predefine('sap/m/DateTimePickerRenderer',['sap/ui/core/Renderer','./DatePickerRenderer','./InputBaseRenderer'],function(R,D,I){"use strict";var a=R.extend(D);
a._getIcon=function(){return"sap-icon://date-time";};
a.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATETIMEPICKER_TYPE")+" "+b;};
return a;},true);
sap.ui.predefine('sap/m/Dialog',['jquery.sap.global','./Bar','./InstanceManager','./AssociativeOverflowToolbar','./ToolbarSpacer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/RenderManager','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/library','./DialogRenderer','jquery.sap.mobile'],function(q,B,I,A,T,l,C,a,P,S,R,b,c,D,M,d,f){"use strict";var O=d.OpenState;var g=l.DialogType;var V=d.ValueState;
var h=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:g.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"any",group:"Behavior",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_title:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"}});
h._bPaddingByDefault=(sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);h._mIcons={};h._mIcons[V.Success]=a.getIconURI("message-success");h._mIcons[V.Warning]=a.getIconURI("message-warning");h._mIcons[V.Error]=a.getIconURI("message-error");
h.prototype.init=function(){var t=this;this._externalIcon=undefined;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._scrollContentList=["NavContainer","Page","ScrollContainer","SplitContainer","MultiInput"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");if(q.device.is.iphone&&!this._bMessageType){this.oPopup.setModal(true,"sapMDialogTransparentBlk");}else{this.oPopup.setModal(true,"sapMDialogBlockLayerInit");}this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(p,F){var s;var e;t._setDimensions();t._adjustScrollingPane();p.at={};if(t._oManuallySetPosition){p.at.left=t._oManuallySetPosition.x;p.at.top=t._oManuallySetPosition.y;}else{if(window.scrollY===undefined){s=window.pageYOffset;}else{s=window.scrollY;}if(s<0){s=0;}p.at.top='calc(50% + '+s+'px)';if(t._bRTL){p.at.left='auto';}else{if(window.scrollX===undefined){e=window.pageXOffset;}else{e=window.scrollX;}if(e<0){e=0;}p.at.left='calc(50% + '+e+'px)';}}t._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,p);t._registerContentResizeHandler();};if(h._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}};
h.prototype.onBeforeRendering=function(){if(this._hasSingleScrollableContent()){this.setProperty("verticalScrolling",false);this.setProperty("horizontalScrolling",false);q.sap.log.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}this._createToolbarButtons();if(sap.ui.getCore().getConfiguration().getAccessibility()&&this.getState()!=V.None){var v=new b({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",v);this.addAriaLabelledBy(v.getId());}};
h.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}if(this.getType()===g.Message||(D.system.phone&&!this.getStretch())){this.$("footer").removeClass("sapContrast sapContrastPlus");}};
h.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};
h.prototype.open=function(){var p=this.oPopup;p.setInitialFocusId(this.getId());var o=p.getOpenState();switch(o){case O.OPEN:case O.OPENING:return this;case O.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();p.attachOpened(this._handleOpened,this);p.setContent(this);p.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};
h.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var p=this.oPopup;var e=this.oPopup.getOpenState();if(!(e===O.CLOSED||e===O.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});p.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;p.close();this._deregisterContentResizeHandler();}return this;};
h.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};
h.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};
h.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};
h.prototype.onfocusin=function(e){var s=e.target;if(s.id===this.getId()+"-firstfe"){var L=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(L){q.sap.focus(L);}}else if(s.id===this.getId()+"-lastfe"){var F=(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(F){q.sap.focus(F);}}};
h.prototype._getPromiseWrapper=function(){var t=this;return{reject:function(){t.currentPromise.reject();},resolve:function(){t.currentPromise.resolve();}};};
h.prototype.onsapescape=function(e){var E=this.getEscapeHandler(),p={},t=this;if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}if(typeof E==='function'){new window.Promise(function(r,i){p.resolve=r;p.reject=i;t.currentPromise=p;E(t._getPromiseWrapper());}).then(function(r){t.close();}).catch(function(){q.sap.log.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};
h.prototype._openAnimation=function(r,i,o){r.addClass("sapMDialogOpen");r.css("display","block");setTimeout(o,300);};
h.prototype._closeAnimation=function(r,i,e){r.removeClass("sapMDialogOpen");setTimeout(e,300);};
h.prototype._setDimensions=function(){var $=this.$(),s=this.getStretch(),e=this.getStretchOnPhone()&&D.system.phone,m=this._bMessageType,o={};if(!s){if(!this._oManuallySetSize){o.width=this.getContentWidth()||undefined;o.height=this.getContentHeight()||undefined;}else{o.width=this._oManuallySetSize.width;o.height=this._oManuallySetSize.height;}}if(o.width=='auto'){o.width=undefined;}if(o.height=='auto'){o.height=undefined;}if((s&&!m)||(e)){this.$().addClass('sapMDialogStretched');}$.css(o);if(!s&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};
h.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};
h.prototype._reposition=function(){};
h.prototype._repositionAfterOpen=function(){};
h.prototype._reapplyPosition=function(){this._adjustScrollingPane();};
h.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),i=e[0].clientWidth,k,s=this.getContentHeight(),m=this.getContentWidth(),n,o=Math.floor(window.innerWidth*0.9),p=2,r=D.browser;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(!s||s=='auto'){k=e.scrollTop();e.css({height:'auto'});n=parseFloat($.height())+p;e.height(Math.round(n));e.scrollTop(k);}if((r.internet_explorer||r.edge)&&(!m||m=='auto')&&!this.getStretch()&&i<e[0].scrollWidth&&e.width()<o){var v=e.width()-i;e.css({width:Math.min(e.width()+v,o)+"px"});}if(!this.getStretch()&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}if(D.browser.chrome){var F=this.$("footer");F.css("height","auto");setTimeout(function(){F.css("height","");},10);}};
h.prototype._applyCustomTranslate=function(){var $=this.$(),t,s,i=$.innerWidth(),e=$.innerHeight();if(D.system.desktop&&(i%2!==0||e%2!==0)){if(!this._bRTL){t='-'+Math.floor(i/2)+"px";}else{t=Math.floor(i/2)+"px";}s='-'+Math.floor(e/2)+"px";$.css('transform','translate('+t+','+s+') scale(1)');}else{$.css('transform','');}};
h.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header");this._header._setRootAccessibilityRole("heading");this.setAggregation("_header",this._header,false);}};
h.prototype._hasSingleScrollableContent=function(){var e=this.getContent(),i;while(e.length===1&&e[0]instanceof sap.ui.core.mvc.View){e=e[0].getContent();}if(e.length===1){for(i=0;i<this._scrollContentList.length;i++){if(e[0]instanceof l[this._scrollContentList[i]]){return true;}}}return false;};
h.prototype._initBlockLayerAnimation=function(){this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};};
h.prototype._clearBlockLayerAnimation=function(){if(q.device.is.iphone&&!this._bMessageType){delete this.oPopup._showBlockLayer;this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};}};
h.prototype._getFocusId=function(){return this.getInitialFocus()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElementId()||this._getFirstVisibleButtonId()||this.getId();};
h.prototype._getFirstVisibleButtonId=function(){var o=this.getBeginButton(),e=this.getEndButton(),k=this.getButtons(),s="";if(o&&o.getVisible()){s=o.getId();}else if(e&&e.getVisible()){s=e.getId();}else if(k&&k.length>0){for(var i=0;i<k.length;i++){if(k[i].getVisible()){s=k[i].getId();break;}}}return s;};
h.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');var r;var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};
h.prototype._getFirstFocusableContentElementId=function(){var r="";var $=this.$("cont");var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};
h.prototype._setInitialFocus=function(){var F=this._getFocusId();var o=sap.ui.getCore().byId(F);var e;if(o){if(o.getVisible&&!o.getVisible()){this.focus();return;}e=o.getFocusDomRef();}e=e||q.sap.domById(F);if(!e){this.setInitialFocus("");e=sap.ui.getCore().byId(this._getFocusId());}if(!this.getInitialFocus()){this.setAssociation('initialFocus',e?e.id:this.getId(),true);}if(D.system.desktop||(e&&!/input|textarea|select/i.test(e.tagName))){q.sap.focus(e);}else{this.focus();}};
h.prototype.getScrollDelegate=function(){return this._oScroller;};
h.prototype._composeAggreNameInHeader=function(p){var H;if(p==="Begin"){H="contentLeft";}else if(p==="End"){H="contentRight";}else{H="content"+p;}return H;};
h.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(i){return i.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};
h.prototype._setButton=function(o,p,s){return this;};
h.prototype._getButton=function(p){var s=p.toLowerCase()+"Button",e="_o"+this._firstLetterUpperCase(p)+"Button";if(D.system.phone){return this.getAggregation(s,null,true);}else{return this[e];}};
h.prototype._getButtonFromHeader=function(p){if(this._header){var H=this._composeAggreNameInHeader(this._firstLetterUpperCase(p)),e=this._header.getAggregation(H);return e&&e[0];}else{return null;}};
h.prototype._firstLetterUpperCase=function(v){return v.charAt(0).toUpperCase()+v.slice(1);};
h.prototype._getAnyHeader=function(){var o=this.getCustomHeader();if(o){return o._setRootAccessibilityRole("heading");}else{var s=this.getShowHeader();if(!s){return null;}this._createHeader();return this._header;}};
h.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){c.deregister(this._resizeListenerId);this._resizeListenerId=null;}D.resize.detachHandler(this._onResize,this);};
h.prototype._registerResizeHandler=function(){var _=this.$("scroll");this._resizeListenerId=c.register(_.get(0),q.proxy(this._onResize,this));D.resize.attachHandler(this._onResize,this);this._onResize();};
h.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){c.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};
h.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=c.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};
h.prototype._attachHandler=function(o){var t=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){t._oCloseTrigger=this;}};}if(o){o.addDelegate(this._oButtonDelegate,true,o);}};
h.prototype._createToolbarButtons=function(){var t=this._getToolbar();var e=this.getButtons();var i=this.getBeginButton();var k=this.getEndButton(),m=this,n=[i,k];n.forEach(function(o){if(o&&m._oButtonDelegate){o.removeDelegate(m._oButtonDelegate);}});t.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}t.addContent(this._toolbarSpacer);n.forEach(function(o){m._attachHandler(o);});if(e&&e.length){e.forEach(function(o){t.addContent(o);});}else{if(i){t.addContent(i);}if(k){t.addContent(k);}}};
h.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders");this._oToolbar._isControlsInfoCached=function(){return false;};this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};
h.prototype.getValueStateString=function(v){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");switch(v){case(V.Success):return r.getText("LIST_ITEM_STATE_SUCCESS");case(V.Warning):return r.getText("LIST_ITEM_STATE_WARNING");case(V.Error):return r.getText("LIST_ITEM_STATE_ERROR");default:return"";}};
h.prototype.setSubHeader=function(o){this.setAggregation("subHeader",o);if(o){o.setVisible=function(i){this.$().toggleClass('sapMDialogWithSubHeader',i);o.setProperty("visible",i);}.bind(this);}return this;};
h.prototype.setLeftButton=function(v){if(!(v instanceof sap.m.Button)){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};
h.prototype.setRightButton=function(v){if(!(v instanceof sap.m.Button)){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};
h.prototype.getLeftButton=function(){var o=this.getBeginButton();return o?o.getId():null;};
h.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};
h.prototype.getAggregation=function(s,o,p){var e=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(s==='buttons'&&e.length===0){this.getBeginButton()&&e.push(this.getBeginButton());this.getEndButton()&&e.push(this.getEndButton());}return e;};
h.prototype.getAriaLabelledBy=function(){var e=this._getAnyHeader(),i=this.getAssociation("ariaLabelledBy",[]).slice();var s=this.getSubHeader();if(s){i.unshift(s.getId());}if(e){i.unshift(e.getId());}return i;};
h.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._headerTitle){this._headerTitle.setText(t);}else{this._headerTitle=new sap.m.Title(this.getId()+"-title",{text:t,level:"H1"}).addStyleClass("sapMDialogTitle");this._createHeader();this._header.addContentMiddle(this._headerTitle);}return this;};
h.prototype.setState=function(s){var F={},$=this.$(),n;F[s]=true;this.setProperty("state",s,true);for(n in f._mStateClasses){$.toggleClass(f._mStateClasses[n],!!F[n]);}this.setIcon(h._mIcons[s],true);return this;};
h.prototype.setIcon=function(i,e){if(!e){this._externalIcon=i;}else{if(this._externalIcon){i=this._externalIcon;}}if(i){if(i!==this.getIcon()){if(this._iconImage){this._iconImage.setSrc(i);}else{this._iconImage=a.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},sap.m.Image).addStyleClass("sapMDialogIcon");this._createHeader();this._header.insertAggregation("contentMiddle",this._iconImage,0);}}}else{var s=this.getState();if(!e&&s!==V.None){if(this._iconImage){this._iconImage.setSrc(h._mIcons[s]);}}else{if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}}}this.setProperty("icon",i,true);return this;};
h.prototype.setType=function(t){var o=this.getType();if(o===t){return this;}this._bMessageType=(t===g.Message);return this.setProperty("type",t,false);};
h.prototype.setStretch=function(s){this._bStretchSet=true;return this.setProperty("stretch",s);};
h.prototype.setStretchOnPhone=function(s){if(this._bStretchSet){q.sap.log.warning("sap.m.Dialog: stretchOnPhone property is deprecated. Setting stretchOnPhone property is ignored when there's already stretch property set.");return this;}this.setProperty("stretchOnPhone",s);return this.setProperty("stretch",s&&D.system.phone);};
h.prototype.setVerticalScrolling=function(v){var o=this.getVerticalScrolling(),H=this._hasSingleScrollableContent();if(H){q.sap.log.warning("sap.m.Dialog: property verticalScrolling automatically reset to false. See documentation.");v=false;}if(o===v){return this;}this.$().toggleClass("sapMDialogVerScrollDisabled",!v);this.setProperty("verticalScrolling",v);if(this._oScroller){this._oScroller.setVertical(v);}return this;};
h.prototype.setHorizontalScrolling=function(v){var o=this.getHorizontalScrolling(),H=this._hasSingleScrollableContent();if(H){q.sap.log.warning("sap.m.Dialog: property horizontalScrolling automatically reset to false. See documentation.");v=false;}if(o===v){return this;}this.$().toggleClass("sapMDialogHorScrollDisabled",!v);this.setProperty("horizontalScrolling",v);if(this._oScroller){this._oScroller.setHorizontal(v);}return this;};
h.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};
h.prototype.forceInvalidate=C.prototype.invalidate;
h.prototype.invalidate=function(o){if(this.isOpen()){this.forceInvalidate(o);}};
function j(e){var $=q(e);var o=$.control(0);if(!o||o.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}
if(D.system.desktop){h.prototype.ondblclick=function(e){if(j(e.target)){this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._$dialog.removeClass('sapMDialogTouched');}};h.prototype.onmousedown=function(e){if(e.which===3){return;}if(this.getStretch()||(!this.getDraggable()&&!this.getResizable())){return;}var t;var i=this;var $=q(document);var k=q(e.target);var r=k.hasClass('sapMDialogResizeHandler')&&this.getResizable();var m=function(z){t=t?clearTimeout(t):setTimeout(function(){z();},0);};var w=window.innerWidth;var n=window.innerHeight;var o={x:e.pageX,y:e.pageY,width:i._$dialog.width(),height:i._$dialog.height(),outerHeight:i._$dialog.outerHeight(),offset:{x:e.offsetX?e.offsetX:e.originalEvent.layerX,y:e.offsetY?e.offsetY:e.originalEvent.layerY},position:{x:i._$dialog.offset().left,y:i._$dialog.offset().top}};function p(){var z=i.$(),E=i.$('cont'),F,G;$.off("mouseup mousemove");if(r){i._$dialog.removeClass('sapMDialogResizing');F=parseInt(z[0].style.height,10)||parseInt(z.height(),10);G=parseInt(z.css("border-top-width"),10)+parseInt(z.css("border-bottom-width"),10);E.height(F+G);}}if((j(e.target)&&this.getDraggable())||r){i._bDisableRepositioning=true;i._$dialog.addClass('sapDialogDisableTransition');i._$dialog.addClass('sapMDialogTouched');i._oManuallySetPosition={x:o.position.x,y:o.position.y};i._$dialog.css({left:Math.min(Math.max(0,i._oManuallySetPosition.x),w-o.width),top:Math.min(Math.max(0,i._oManuallySetPosition.y),n-o.height),width:o.width,height:o.height,transform:""});}if(j(e.target)&&this.getDraggable()){$.on("mousemove",function(z){if(z.buttons===0){p();return;}m(function(){i._bDisableRepositioning=true;i._oManuallySetPosition={x:z.pageX-e.pageX+o.position.x,y:z.pageY-e.pageY+o.position.y};i._$dialog.css({left:Math.min(Math.max(0,i._oManuallySetPosition.x),w-o.width),top:Math.min(Math.max(0,i._oManuallySetPosition.y),n-o.outerHeight),transform:""});});});}else if(r){i._$dialog.addClass('sapMDialogResizing');var s={};var u=parseInt(i._$dialog.css('min-width'),10);var v=o.x+o.width-u;var x=k.width()-e.offsetX;var y=k.height()-e.offsetY;$.on("mousemove",function(z){m(function(){i._bDisableRepositioning=true;i.$('cont').height('').width('');if(z.pageY+y>n){z.pageY=n-y;}if(z.pageX+x>w){z.pageX=w-x;}i._oManuallySetSize={width:o.width+z.pageX-o.x,height:o.height+z.pageY-o.y};if(i._bRTL){s.left=Math.min(Math.max(z.pageX,0),v);s.transform="";i._oManuallySetSize.width=o.width+o.x-Math.max(z.pageX,0);}s.width=i._oManuallySetSize.width;s.height=i._oManuallySetSize.height;i._$dialog.css(s);});});}else{return;}$.on("mouseup",p);e.preventDefault();e.stopPropagation();};}
h.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};
return h;});
sap.ui.predefine('sap/m/DialogRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/library"],function(l,D,c){"use strict";var a=l.DialogType;var V=c.ValueState;var b={};b._mStateClasses={};b._mStateClasses[V.None]="";b._mStateClasses[V.Success]="sapMDialogSuccess";b._mStateClasses[V.Warning]="sapMDialogWarning";b._mStateClasses[V.Error]="sapMDialogError";
b.render=function(r,C){var d=C.getId(),t=C.getType(),h=C._getAnyHeader(),s=C.getSubHeader(),m=(t===a.Message),L=C.getBeginButton(),R=C.getEndButton(),H=C.getHorizontalScrolling(),v=C.getVerticalScrolling(),S=C.getState(),e=C.getStretch(),f=C.getStretchOnPhone()&&D.system.phone,g=C.getResizable(),j=C.getDraggable(),o=C.getAggregation("_valueState");var k=C.getContentWidth()&&C.getContentWidth()!='auto'?' width: '+C.getContentWidth()+';':'';var n=C.getContentHeight()&&C.getContentHeight()!='auto'?' height: '+C.getContentHeight()+';':'';var p="style='"+k+n+"'";r.write('<div '+p);r.writeControlData(C);r.addClass("sapMDialog");r.addClass("sapMDialog-CTX");r.addClass("sapMPopup-CTX");if(C.isOpen()){r.addClass("sapMDialogOpen");}if(window.devicePixelRatio>1){r.addClass("sapMDialogHighPixelDensity");}if(C._bDisableRepositioning){r.addClass("sapMDialogTouched");}if(e||(f)){r.addClass("sapMDialogStretched");}r.addClass(b._mStateClasses[S]);var q=!C._oToolbar&&!L&&!R;var u=C._oToolbar&&C._isToolbarEmpty()&&!L&&!R;if(q||u){r.addClass("sapMDialog-NoFooter");}if(!h){r.addClass("sapMDialog-NoHeader");}if(S==="Error"||S==="Warning"){r.writeAccessibilityState(C,{role:"alertdialog"});}else{r.writeAccessibilityState(C,{role:"dialog"});}if(C._forceDisableScrolling){r.addClass("sapMDialogWithScrollCont");}if(s&&s.getVisible()){r.addClass("sapMDialogWithSubHeader");}if(m){r.addClass("sapMMessageDialog");}if(!v){r.addClass("sapMDialogVerScrollDisabled");}if(!H){r.addClass("sapMDialogHorScrollDisabled");}if(D.system.phone){r.addClass("sapMDialogPhone");}if(j&&!e){r.addClass("sapMDialogDraggable");}if(l._bSizeCompact){r.addClass("sapUiSizeCompact");}r.writeClasses();var T=C.getTooltip_AsString();if(T){r.writeAttributeEscaped("title",T);}r.writeAttribute("tabindex","-1");r.write(">");if(D.system.desktop){if(g&&!e){r.writeIcon("sap-icon://resize-corner",["sapMDialogResizeHandler"],{"title":""});}r.write('<span id="'+C.getId()+'-firstfe" tabindex="0"/>');}if(h){h._applyContextClassFor("header");r.write("<header");r.addClass("sapMDialogTitle");r.writeClasses();r.write(">");r.renderControl(h);r.write("</header>");}if(s){s._applyContextClassFor("subheader");r.write("<header");r.addClass("sapMDialogSubHeader");r.writeClasses();r.write(">");r.renderControl(s);r.write("</header>");}if(o){r.renderControl(o);}r.write('<section id="'+d+'-cont" class="sapMDialogSection">');r.write('<div id="'+d+'-scroll" class="sapMDialogScroll">');r.write('<div id="'+d+'-scrollCont" class="sapMDialogScrollCont');if(C.getStretch()||n){r.write(' sapMDialogStretchContent');}r.write('">');var w=C.getContent();for(var i=0;i<w.length;i++){r.renderControl(w[i]);}r.write("</div>");r.write("</div>");r.write("</section>");if(!(q||u)){r.write("<footer");r.addClass("sapMDialogFooter");r.writeClasses();r.write(">");C._oToolbar._applyContextClassFor("footer");r.renderControl(C._oToolbar);r.write("</footer>");}if(D.system.desktop){r.write('<span id="'+C.getId()+'-lastfe" tabindex="0"/>');}r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/m/DisplayListItem',['./ListItemBase','./library','sap/ui/core/library','./DisplayListItemRenderer'],function(L,l,c,D){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.DisplayListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null},valueTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}}}});
a.prototype.getContentAnnouncement=function(){return this.getLabel()+" "+this.getValue();};
return a;});
sap.ui.predefine('sap/m/DisplayListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer','sap/ui/core/library'],function(L,R,c){"use strict";var T=c.TextDirection;var D=R.extend(L);
D.renderLIAttributes=function(r,l){r.addClass("sapMDLI");};
D.renderLIContent=function(r,l){var i=l.getLabel();if(i){r.write("<label for='"+l.getId()+"-value' class='sapMDLILabel'>");r.writeEscaped(l.getLabel());r.write("</label>");}var a=l.getValue();var v=l.getValueTextDirection();if(a){r.write("<div id='"+l.getId()+"-value' class='sapMDLIValue'");if(v!=T.Inherit){r.writeAttribute("dir",v.toLowerCase());}r.write(">");r.writeEscaped(l.getValue());r.write("</div>");}};
return D;},true);
sap.ui.predefine('sap/m/DraftIndicator',["sap/ui/core/Control","sap/m/Label","sap/m/library","jquery.sap.global","./DraftIndicatorRenderer"],function(C,L,l,q,D){"use strict";var a=l.DraftIndicatorState;
var b=C.extend("sap.m.DraftIndicator",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DraftIndicator.designtime",properties:{state:{type:"sap.m.DraftIndicatorState",group:"Behavior",defaultValue:a.Clear},minDisplayTime:{type:"int",group:"Behavior",defaultValue:1500}},aggregations:{_label:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});
var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");b._oTEXTS={};b._oTEXTS[a.Saving]=B.getText("DRAFT_INDICATOR_SAVING_DRAFT");b._oTEXTS[a.Saved]=B.getText("DRAFT_INDICATOR_DRAFT_SAVED");b._oTEXTS[a.Clear]="";
b.prototype.init=function(){this.aQueue=[];this.iDelayedCallId=null;};
b.prototype.exit=function(){this._resetDraftTimer();};
b.prototype.setState=function(s){this.setProperty("state",s);this._addToQueue(s);if(s===a.Saving){this._addToQueue(a.Clear);}return this;};
b.prototype._getLabel=function(){var c=this.getAggregation('_label');if(!c){var c=new L({id:this.getId()+"-label"});this.setAggregation('_label',c,true);c=this.getAggregation('_label');}return c;};
b.prototype.showDraftSaving=function(){this._addToQueue(a.Saving);this._addToQueue(a.Clear);};
b.prototype.showDraftSaved=function(){this._addToQueue(a.Saved);};
b.prototype.clearDraftState=function(){this._addToQueue(a.Clear);};
b.prototype._addToQueue=function(s){this.aQueue.push(s);this._processQueue();};
b.prototype._processQueue=function(){if(this.iDelayedCallId){return;}var n=this.aQueue.shift();var t=this.getMinDisplayTime();if(!n){return;}this._applyState(n);if(n===a.Clear){this._proceed();return;}this.iDelayedCallId=q.sap.delayedCall(t,this,this._proceed);};
b.prototype._proceed=function(){this._resetDraftTimer();this._processQueue();};
b.prototype._applyState=function(s){this._getLabel().setText(b._oTEXTS[s]);};
b.prototype._resetDraftTimer=function(){q.sap.clearDelayedCall(this.iDelayedCallId);this.iDelayedCallId=null;};
return b;});
sap.ui.predefine('sap/m/DraftIndicatorRenderer',[],function(){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDraftIndicator");r.writeClasses();r.write(">");var l=c._getLabel();r.renderControl(l);r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/FacetFilter',['jquery.sap.global','./NavContainer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/Icon','sap/ui/model/Filter','./FacetFilterRenderer','jquery.sap.keycodes'],function(q,N,l,C,I,a,b,D,M,c,F,d){"use strict";var T=l.ToolbarDesign;var L=l.ListType;var e=l.ListMode;var f=l.FacetFilterListDataType;var B=l.ButtonType;var P=l.PlacementType;var g=l.FacetFilterType;
var h=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:g.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});
h.SCROLL_STEP=264;
h.prototype.setType=function(t){var s=this.getAggregation("summaryBar");if(D.system.phone){this.setProperty("type",g.Light);s.setActive(true);}else{this.setProperty("type",t);s.setActive(t===g.Light);}if(t===g.Light){if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}}return this;};
h.prototype.setShowReset=function(v){this.setProperty("showReset",v);var s=this.getAggregation("summaryBar");if(v){if(this.getShowSummaryBar()||this.getType()===g.Light){this._addResetToSummary(s);}}else{if(this.getShowSummaryBar()||this.getType()===g.Light){this._removeResetFromSummary(s);}}return this;};
h.prototype.setShowSummaryBar=function(v){this.setProperty("showSummaryBar",v);if(v){var s=this.getAggregation("summaryBar");if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}s.setActive(this.getType()===g.Light);}return this;};
h.prototype.setLiveSearch=function(v){this.setProperty("liveSearch",v);if(this._displayedList){var o=this._displayedList;var s=sap.ui.getCore().byId(o.getAssociation("search"));s.detachLiveChange(o._handleSearchEvent,o);if(v){s.attachLiveChange(o._handleSearchEvent,o);}}return this;};
h.prototype.getLists=function(){var i=this.getAggregation("lists");if(!i){i=[];}if(this._displayedList){i.splice(this._listAggrIndex,0,this._displayedList);}return i;};
h.prototype.removeList=function(o){var i=M.prototype.removeAggregation.call(this,"lists",o);this._removeList(i);return i;};
h.prototype.removeAggregation=function(){var o=M.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(o);}return o;};
h.prototype.openFilterDialog=function(){var o=this._getFacetDialog();var n=this._getFacetDialogNavContainer();o.addContent(n);this.getLists().forEach(function(i){i._preserveOriginalActiveState();});o.setInitialFocus(n.getPages()[0].getContent()[0].getItems()[0]);o.open();return this;};
h.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this._getSummaryBar();this.setAggregation("resetButton",this._createResetButton());if(q.sap.touchEventMode==="ON"&&!D.system.phone){this._enableTouchSupport();}if(D.system.phone){this.setType(g.Light);}};
h.prototype.exit=function(){var o;sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(i){o=sap.ui.getCore().byId(i);if(o){o.destroy();}});this._aOwnedLabels=null;}};
h.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===g.Light){var s=this.getAggregation("summaryBar");var t=s.getContent()[0];t.setText(this._getSummaryText());t.setTooltip(this._getSummaryText());}sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);};
h.prototype.onAfterRendering=function(){if(this.getType()!==g.Light&&!D.system.phone){sap.ui.getCore().attachIntervalTimer(this._checkOverflow,this);}if(this.getType()!==g.Light){this._startItemNavigation();}};
h.prototype._startItemNavigation=function(){var o=this.getDomRef(),r=o.getElementsByClassName("sapMFFHead"),j=[];if(r.length>0){for(var i=0;i<r[0].childNodes.length;i++){if(r[0].childNodes[i].id.indexOf("ff")<0&&r[0].childNodes[i].id.indexOf("icon")<0&&r[0].childNodes[i].id.indexOf("add")<0){j.push(r[0].childNodes[i]);}if(r[0].childNodes[i].id.indexOf("add")>=0){j.push(r[0].childNodes[i]);}}}if(j!=""){this._aDomRefs=j;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new a();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=r;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(o);this.oItemNavigation.setItemDomRefs(j);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};
h.prototype.onsapdelete=function(E){var o,i;if(this.getType()===g.Light){return;}if(!this.getShowPersonalization()){return;}o=sap.ui.getCore().byId(E.target.id);if(!o){return;}i=sap.ui.getCore().byId(o.getAssociation("list"));if(!i){return;}if(!i.getShowRemoveFacetIcon()){return;}i.removeSelections(true);i.setSelectedKeys();i.setProperty("active",false,true);this.invalidate();var t=this.$().find(":sapTabbable");q(t[t.length-1]).focus();var n=this.oItemNavigation.getFocusedIndex();q(E.target).blur();this.oItemNavigation.setFocusedIndex(n+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if(t[k].id.indexOf("add")>=0){q(t[k]).focus();}}}};
h.prototype.onsaptabnext=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).focus();E.preventDefault();E.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}};
h.prototype.onsaptabprevious=function(E){if(this.getType()===g.Light){return;}if(E.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).focus();E.preventDefault();E.setMarked();return;}if(E.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=E.target.id){q(this._previousTarget).focus();E.preventDefault();E.setMarked();return;}if(E.target.id.indexOf("add")>=0||E.target.parentNode.className=="sapMFFHead"){this._previousTarget=E.target;q(this.$().find(":sapTabbable")[0]).focus();}};
h.prototype.onsapend=function(E){if(this.getType()===g.Light){return;}if(this._addTarget!=null){q(this._addTarget).focus();E.preventDefault();E.setMarked();}else{q(this._aRows[this._aRows.length-1]).focus();E.preventDefault();E.setMarked();}this._previousTarget=E.target;};
h.prototype.onsaphome=function(E){if(this.getType()===g.Light){return;}q(this._aRows[0]).focus();E.preventDefault();E.setMarked();this._previousTarget=E.target;};
h.prototype.onsappageup=function(E){this._previousTarget=E.target;};
h.prototype.onsappagedown=function(E){this._previousTarget=E.target;};
h.prototype.onsapincreasemodifiers=function(E){if(this.getType()===g.Light){return;}if(E.which==q.sap.KeyCodes.ARROW_RIGHT){this._previousTarget=E.target;var i=this.oItemNavigation.getFocusedIndex()-1;var n=i+this._pageSize;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();}};
h.prototype.onsapdecreasemodifiers=function(E){if(this.getType()===g.Light){return;}var i=0;if(E.which==q.sap.KeyCodes.ARROW_LEFT){this._previousTarget=E.target;i=this.oItemNavigation.getFocusedIndex()+1;var n=i-this._pageSize;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();}};
h.prototype.onsapdownmodifiers=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;var i=0;i=this.oItemNavigation.getFocusedIndex()-1;var n=i+this._pageSize;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
h.prototype.onsapupmodifiers=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;var i=0;i=this.oItemNavigation.getFocusedIndex();if(i!=0){i=i+1;}var n=i-this._pageSize;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
h.prototype.onsapexpand=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;var n=this.oItemNavigation.getFocusedIndex()+1;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
h.prototype.onsapcollapse=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;var n=this.oItemNavigation.getFocusedIndex()-1;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
h.prototype.onsapdown=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFResetDiv"){q(E.target).focus();E.preventDefault();E.setMarked();return;}};
h.prototype.onsapup=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFResetDiv"){q(E.target).focus();E.preventDefault();E.setMarked();}};
h.prototype.onsapleft=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFResetDiv"){q(E.target).focus();E.preventDefault();E.setMarked();}};
h.prototype.onsapright=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFResetDiv"){q(E.target).focus();E.preventDefault();E.setMarked();}};
h.prototype.onsapescape=function(E){if(this.getType()===g.Light){return;}if(E.target.parentNode.className=="sapMFFResetDiv"){return;}var n=this._lastCategoryFocusIndex;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
h.prototype._getPopover=function(){var p=this.getAggregation("popover");if(!p){var t=this;p=new sap.m.Popover({placement:P.Bottom,beforeOpen:function(E){if(t._displayedList){t._displayedList._setSearchValue("");}this.setCustomHeader(t._createFilterItemsSearchFieldBar(t._displayedList));var s=this.getSubHeader();if(!s){this.setSubHeader(t._createSelectAllCheckboxBar(t._displayedList));}i(t._displayedList);},afterClose:function(E){t._addDelegateFlag=true;if(D.browser.internet_explorer&&D.browser.version<10){q.sap.delayedCall(100,t,t._handlePopoverAfterClose);}else{t._handlePopoverAfterClose();}},horizontalScrolling:false});this.setAggregation("popover",p,true);p.setContentWidth("30%");if(D.browser.internet_explorer&&D.browser.version<10){p.setContentWidth("30%");}p.addStyleClass("sapMFFPop");var i=function(o){if(!o){return;}var j=t._getFacetRemoveIcon(o);if(j){j._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(p);}else{p.destroyAggregation("footer");}return p;};
h.prototype._handlePopoverAfterClose=function(){var p=this.getAggregation("popover"),o=this._displayedList;if(!p){return;}var i=this._getFacetRemoveIcon(o);if(i&&i._bTouchStarted){return;}this._restoreListFromDisplayContainer(p);this._displayRemoveIcon(false,o);o._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){q.sap.delayedCall(0,this,function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;});}};
h.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};
h.prototype._openPopover=function(p,o){if(!p.isOpen()){var i=sap.ui.getCore().byId(o.getAssociation("list"));i.fireListOpen({});this._moveListToDisplayContainer(i,p);p.openBy(o);if(i.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,i);}if(i.getWordWrap()){p.setContentWidth("30%");}i._applySearch();}return this;};
h.prototype._getAddFacetButton=function(){var o=this.getAggregation("addFacetButton");if(!o){var t=this;var o=new sap.m.Button(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:B.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(E){t.openFilterDialog();}});this.setAggregation("addFacetButton",o,true);}return o;};
h.prototype._getButtonForList=function(o){if(this._buttons[o.getId()]){this._setButtonText(o);return this._buttons[o.getId()];}var t=this;var i=new sap.m.Button({type:B.Transparent,press:function(E){var j=this;var O=function(){var p=t._getPopover();t._openPopover(p,j);};o._preserveOriginalActiveState();if(D.browser.internet_explorer&&D.browser.version<10){q.sap.delayedCall(100,this,O);}else{var p=t._getPopover();if(p.isOpen()){q.sap.delayedCall(100,this,function(){if(p.isOpen()){return;}t._oOpenPopoverDeferred=q.Deferred();t._oOpenPopoverDeferred.promise().done(O);});}else{q.sap.delayedCall(100,this,O);}}}});this._buttons[o.getId()]=i;this.addAggregation("buttons",i);i.setAssociation("list",o.getId(),true);this._setButtonText(o);return i;};
h.prototype._setButtonText=function(o){var i=this._buttons[o.getId()];if(o._iAllItemsCount===undefined&&o.getMaxItemsCount()){o._iAllItemsCount=o.getMaxItemsCount();}if(i){var t="";var s=Object.getOwnPropertyNames(o._oSelectedKeys);var j=s.length;if(j===1){var S=o._oSelectedKeys[s[0]];t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[o.getTitle(),S]);}else if(j>0&&j===(o._iAllItemsCount?o._iAllItemsCount:0)){t=this._bundle.getText("FACETFILTER_ALL_SELECTED",[o.getTitle()]);}else if(j>0){t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[o.getTitle(),j]);}else{t=o.getTitle();}i.setText(t);i.setTooltip(t);}};
h.prototype._getFacetRemoveIcon=function(o){var t=this,i=this._removeFacetIcons[o.getId()];if(!i){i=new c({src:I.getIconURI("sys-cancel"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){i._bPressed=true;}});i.addDelegate({ontouchstart:function(){i._bTouchStarted=true;i._bPressed=false;},ontouchend:function(){t._displayRemoveIcon(false,o);i._bTouchStarted=false;q.sap.delayedCall(100,this,p);}},true);var p=function(){if(i._bPressed){o.removeSelections(true);o.setSelectedKeys();o.setProperty("active",false,true);}t._handlePopoverAfterClose();};i.setAssociation("list",o.getId(),true);i.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[o.getId()]=i;this.addAggregation("removeFacetIcons",i);this._displayRemoveIcon(false,o);}return i;};
h.prototype._displayRemoveIcon=function(i,o){if(this.getShowPersonalization()){var j=this._removeFacetIcons[o.getId()];if(i){j.removeStyleClass("sapMFFLHiddenRemoveIcon");j.addStyleClass("sapMFFLVisibleRemoveIcon");}else{j.removeStyleClass("sapMFFLVisibleRemoveIcon");j.addStyleClass("sapMFFLHiddenRemoveIcon");}}};
h.prototype._getFacetDialogNavContainer=function(){var n=new N({autoFocus:false});var o=this._createFacetPage();n.addPage(o);n.setInitialPage(o);var t=this;n.attachAfterNavigate(function(E){var i=E.getParameters()["to"];var j=E.getParameters()['from'];if(j===o){var k=i.getContent(0)[1].getItems()[0];if(k){k.focus();}}if(i===o){j.destroySubHeader();j.destroyContent();t._selectedFacetItem.invalidate();i.invalidate();q.sap.focus(t._selectedFacetItem);t._selectedFacetItem=null;}});return n;};
h.prototype._createFacetPage=function(){var o=this._createFacetList();var i=new sap.m.SearchField({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(E){var j=o.getBinding("items");if(j){var k=new F("text",sap.ui.model.FilterOperator.Contains,E.getParameters()["newValue"]);j.filter([k]);}}});var p=new sap.m.Page({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new sap.m.Bar({contentMiddle:i}),content:[o]});return p;};
h.prototype._createFilterItemsPage=function(){var t=this;var p=new sap.m.Page({showNavButton:true,enableScrolling:true,navButtonPress:function(E){var n=E.getSource().getParent();t._navFromFilterItemsPage(n);}});return p;};
h.prototype._getFilterItemsPage=function(n){var o=n.getPages()[1];if(o){n.removePage(o);o.destroy();}var p=this._createFilterItemsPage();n.addPage(p);return p;};
h.prototype._createFilterItemsSearchFieldBar=function(o){var t=this;var s=true;if(o.getDataType()!=f.String){s=false;}var S=new sap.m.SearchField({value:o._getSearchValue(),width:"100%",enabled:s,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(E){t._displayedList._handleSearchEvent(E);}});if(this.getLiveSearch()){S.attachLiveChange(o._handleSearchEvent,o);}var i=new sap.m.Bar({contentMiddle:S});o.setAssociation("search",S);return i;};
h.prototype._getFacetDialog=function(){var o=this.getAggregation("dialog");if(!o){var t=this;o=new sap.m.Dialog({showHeader:false,stretch:D.system.phone?true:false,afterClose:function(){t._addDelegateFlag=true;t._invalidateFlag=true;var n=this.getContent()[0];var i=n.getPages()[1];if(n.getCurrentPage()===i){var j=t._restoreListFromDisplayContainer(i);j._updateActiveState();j._fireListCloseEvent();j._search("");}this.destroyAggregation("content",true);t.invalidate();},beginButton:new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){t._closeDialog();}}),contentHeight:"500px"});o.addStyleClass("sapMFFDialog");o.onsapentermodifiers=function(E){if(E.shiftKey&&!E.ctrlKey&&!E.altKey){var n=this.getContent()[0];t._navFromFilterItemsPage(n);}};this.setAggregation("dialog",o,true);}return o;};
h.prototype._closeDialog=function(){var o=this.getAggregation("dialog");if(o&&o.isOpen()){o.close();this._fireConfirmEvent();}};
h.prototype._closePopover=function(){var p=this.getAggregation("popover");if(p&&p.isOpen()){p.close();}};
h.prototype._createFacetList=function(){var o=new sap.m.List({mode:e.None,items:{path:"/items",template:new sap.m.StandardListItem({title:"{text}",counter:"{count}",type:L.Navigation,customData:[new sap.ui.core.CustomData({key:"index",value:"{index}"})]})}});var j=[];for(var i=0;i<this.getLists().length;i++){var k=this.getLists()[i];j.push({text:k.getTitle(),count:k.getAllCount(),index:i});}var m=new sap.ui.model.json.JSONModel({items:j});if(j.length>100){m.setSizeLimit(j.length);}var t=this;o.attachUpdateFinished(function(){for(var i=0;i<o.getItems().length;i++){var n=this.getItems()[i];n.detachPress(t._handleFacetListItemPress,t);n.attachPress(t._handleFacetListItemPress,t);}});o.setModel(m);return o;};
h.prototype._createSelectAllCheckboxBar=function(o){if(!o.getMultiSelect()){return null;}var s=o.getActive()&&o.getItems().length>0&&Object.getOwnPropertyNames(o._oSelectedKeys).length===o.getItems().length;var i=new sap.m.CheckBox(o.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:s,select:function(E){i.setSelected(E.getParameter("selected"));o._handleSelectAllClick(E.getParameter("selected"));}});o.setAssociation("allcheckbox",i);var j=new sap.m.Bar();j.addEventDelegate({ontap:function(E){if(E.srcControl===this){o._handleSelectAllClick(i.getSelected());}}},j);j.addContentLeft(i);j.addStyleClass("sapMFFCheckbar");return j;};
h.prototype._handleFacetListItemPress=function(E){this._navToFilterItemsPage(E.getSource());};
h.prototype._navToFilterItemsPage=function(o){this._selectedFacetItem=o;var n=this.getAggregation("dialog").getContent()[0];var i=o.getCustomData();var j=i[0].getValue();var k=this.getLists()[j];this._listIndexAgg=this.indexOfAggregation("lists",k);if(this._listIndexAgg==j){var m=this._getFilterItemsPage(n);k.fireListOpen({});this._moveListToDisplayContainer(k,m);m.setSubHeader(this._createFilterItemsSearchFieldBar(k));var p=this._createSelectAllCheckboxBar(k);if(p){m.insertContent(p,0);}m.setTitle(k.getTitle());n.to(m);}};
h.prototype._navFromFilterItemsPage=function(n){var o=n.getPages()[1];var i=this._restoreListFromDisplayContainer(o);i._updateActiveState();i._fireListCloseEvent();i._search("");this._selectedFacetItem.setCounter(i.getAllCount());n.backToTop();};
h.prototype._moveListToDisplayContainer=function(o,i){this._listAggrIndex=this.indexOfAggregation("lists",o);M.prototype.removeAggregation.call(this,"lists",o,true);i.addAggregation("content",o,false);o.setAssociation("facetFilter",this,true);this._displayedList=o;};
h.prototype._restoreListFromDisplayContainer=function(o){var i=o.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",i,this._listAggrIndex,i.getActive());this._listAggrIndex=-1;this._displayedList=null;return i;};
h.prototype._getSequencedLists=function(){var m=-1;var s=[];var k=this.getLists();if(k.length>0){for(var i=0;i<k.length;i++){if(k[i].getActive()){if(k[i].getSequence()<-1){k[i].setSequence(-1);}else if(k[i].getSequence()>m){m=k[i].getSequence();}s.push(k[i]);}else if(!k[i].getRetainListSequence()){k[i].setSequence(-1);}}for(var j=0;j<s.length;j++){if(s[j].getSequence()<=-1){m+=1;s[j].setSequence(m);}}if(s.length>1){s.sort(function(n,o){return n.getSequence()-o.getSequence();});}}return s;};
h.prototype._getSummaryBar=function(){var s=this.getAggregation("summaryBar");if(!s){var t=new sap.m.Text({maxLines:1});var i=this;s=new sap.m.Toolbar({content:[t],active:this.getType()===g.Light?true:false,design:T.Info,press:function(E){i.openFilterDialog();}});s._setRootAccessibilityRole("button");this.setAggregation("summaryBar",s);}return s;};
h.prototype._createResetButton=function(){var t=this;var o=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(E){t._addDelegateFlag=true;t._invalidateFlag=true;t.fireReset();var j=t.getLists();for(var i=0;i<j.length;i++){j[i]._searchValue="";j[i]._applySearch();q.sap.focus(j[i].getItems()[0]);}t.invalidate();}});return o;};
h.prototype._addOKButtonToPopover=function(p){var o=p.getFooter();if(!o){var t=this;var o=new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),width:"100%",press:function(){t._closePopover();}});p.setFooter(o);}return o;};
h.prototype._getSummaryText=function(){var k=", ";var S=" ";var s="";var m=true;var n=this.getLists();if(n.length>0){for(var i=0;i<n.length;i++){var o=n[i];if(o.getActive()){var p=this._getSelectedItemsText(o);var t="";for(var j=0;j<p.length;j++){t=t+p[j]+k;}if(t){t=t.substring(0,t.lastIndexOf(k)).trim();if(m){s=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[o.getTitle(),t]);m=false;}else{s=s+S+this._bundle.getText("FACETFILTER_INFOBAR_AND")+S+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[o.getTitle(),t]);}}}}}if(!s){s=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return s;};
h.prototype._getSelectedItemsText=function(o){var t=o.getSelectedItems().map(function(v){return v.getText();});o._oSelectedKeys&&Object.getOwnPropertyNames(o._oSelectedKeys).forEach(function(v){t.indexOf(o._oSelectedKeys[v])===-1&&t.push(o._oSelectedKeys[v]);});return t;};
h.prototype._addResetToSummary=function(s){if(s.getContent().length===1){s.addContent(new sap.m.ToolbarSpacer({width:""}));var o=this._createResetButton();s.addContent(o);o.addStyleClass("sapUiSizeCompact");o.addStyleClass("sapMFFRefresh");o.addStyleClass("sapMFFBtnHoverable");}};
h.prototype._removeResetFromSummary=function(s){if(s.getContent().length===3){var S=s.removeAggregation("content",1);S.destroy();var o=s.removeAggregation("content",1);o.destroy();}};
h.prototype._removeList=function(o){if(o){var i=this._buttons[o.getId()];if(i){this.removeAggregation("buttons",i);i.destroy();}var r=this._removeFacetIcons[o.getId()];if(r){this.removeAggregation("removeIcons",r);r.destroy();}delete this._buttons[o.getId()];delete this._removeFacetIcons[o.getId()];}};
h.prototype._getScrollingArrow=function(n){var A=null;var p={src:"sap-icon://navigation-"+n+"-arrow"};if(n==="left"){A=this.getAggregation("arrowLeft");if(!A){p.id=this.getId()+"-arrowScrollLeft";A=I.createControlByURI(p);var j=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<j.length;i++){A.addStyleClass(j[i]);A.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",A);}}else if(n==="right"){A=this.getAggregation("arrowRight");if(!A){p.id=this.getId()+"-arrowScrollRight";A=I.createControlByURI(p);var k=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<k.length;i++){A.addStyleClass(k[i]);A.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",A);}}else{q.sap.log.error("Scrolling arrow name "+n+" is not valid");}return A;};
h.prototype._checkOverflow=function(){var o=this.getDomRef("head"),$=q(o),i=this.$(),s=false,S=false,j=false,k=null,m=null,n=null;if(o){k=o.scrollLeft;m=o.scrollWidth;n=o.clientWidth;if(m>n){if(m-n==1){m=n;}else{j=true;}}i.toggleClass("sapMFFScrolling",j);i.toggleClass("sapMFFNoScrolling",!j);this._lastScrolling=j;if(!this._bRtl){s=k>0;S=(m>n)&&(m>k+n);}else{S=$.scrollLeftRTL()>0;s=$.scrollRightRTL()>0;}if((S!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){i.toggleClass("sapMFFNoScrollBack",!s);i.toggleClass("sapMFFNoScrollForward",!S);}}};
h.prototype.onclick=function(E){var t=E.target.id;if(t){var i=this.getId(),o=E.target;E.preventDefault();if(t==i+"-arrowScrollLeft"){o.tabIndex=-1;o.focus();this._scroll(-h.SCROLL_STEP,500);}else if(t==i+"-arrowScrollRight"){o.tabIndex=-1;o.focus();this._scroll(h.SCROLL_STEP,500);}}};
h.prototype._scroll=function(i,j){var o=this.getDomRef("head");var s=o.scrollLeft;if(!D.browser.internet_explorer&&this._bRtl){i=-i;}var S=s+i;q(o).stop(true,true).animate({scrollLeft:S},j);};
h.prototype._enableTouchSupport=function(){var t=this;var i=function(m){var s=t.getType();if(s===g.Light){return;}m.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("head").scrollLeft;t.startTouchX=m.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var j=function(m){var s=t.getType();if(s===g.Light){return;}var n=m.touches[0].pageX-t.startTouchX;var o=t.getDomRef("head");var p=o.scrollLeft;var r=t.startScrollX-n;o.scrollLeft=r;t._bTouchNotMoved=false;var u=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(u>0){t._velocity=(r-p)/u;}m.preventDefault();};var k=function(m){var s=t.getType();if(s===g.Light){return;}if(t._bTouchNotMoved===false){m.preventDefault();var o=t.getDomRef("head");var n=50;var p=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var r=t._velocity*n;o.scrollLeft=o.scrollLeft+r;if(Math.abs(t._velocity)<p){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},n);}else if(t._bTouchNotMoved===true){t.onclick(m);m.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.addEventDelegate({ontouchstart:i},this);this.addEventDelegate({ontouchend:k},this);this.addEventDelegate({ontouchmove:j},this);};
return h;});
sap.ui.predefine('sap/m/FacetFilterItem',['./ListItemBase','./library','./FacetFilterItemRenderer'],function(L,l,F){"use strict";
var a=L.extend("sap.m.FacetFilterItem",{metadata:{library:"sap.m",properties:{key:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},count:{type:"int",group:"Misc",defaultValue:null,deprecated:true}}}});
a.prototype.setCount=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
a.prototype.setCounter=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
a.prototype.init=function(){this.attachEvent("_change",this._itemTextChange);L.prototype.init.apply(this);this.addStyleClass("sapMFFLI");};
a.prototype.exit=function(){L.prototype.exit.apply(this);this.detachEvent("_change",this._itemTextChange);};
a.prototype._itemTextChange=function(e){if(e.getParameter("name")==="text"){this.informList("TextChange",e.getParameter("newValue"));}};
return a;});
sap.ui.predefine('sap/m/FacetFilterItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var F=R.extend(L);
F.renderLIContent=function(r,c){r.write("<div");if(c.getParent()&&c.getParent().getWordWrap()){r.addClass("sapMFFLITitleWrap");}else{r.addClass("sapMFFLITitle");}r.writeClasses();r.write(">");r.writeEscaped(c.getText());r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterList',['jquery.sap.global','./List','./library','sap/ui/model/ChangeReason','sap/ui/model/Filter','./FacetFilterListRenderer'],function(q,L,l,C,F,a){"use strict";var b=l.ListMode;var c=l.FacetFilterListDataType;
var d=L.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:c.String}},events:{listOpen:{},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}}}}});
d.prototype.setTitle=function(t){this.setProperty("title",t,true);this._updateFacetFilterButtonText();return this;};
d.prototype.setMultiSelect=function(v){this.setProperty("multiSelect",v,true);var m=v?b.MultiSelect:b.SingleSelectMaster;this.setMode(m);return this;};
d.prototype.setMode=function(m){if(m===b.MultiSelect||m===b.SingleSelectMaster){L.prototype.setMode.call(this,m);this.setProperty("multiSelect",m===b.MultiSelect?true:false,true);}return this;};
d.prototype._applySearch=function(){var s=this._getSearchValue();if(s!=null){this._search(s,true);this._updateSelectAllCheckBox();}};
d.prototype.getSelectedItems=function(){var s=[];var o={};var e=sap.m.ListBase.prototype.getSelectedItems.apply(this,arguments);e.forEach(function(i){s.push(new sap.m.FacetFilterItem({text:i.getText(),key:i.getKey(),selected:true}));o[i.getKey()]=true;});var S=this.getSelectedKeys();var f=Object.getOwnPropertyNames(S);if(e.length<f.length){f.forEach(function(k){if(!o[k]){s.push(new sap.m.FacetFilterItem({text:S[k],key:k,selected:true}));}});}return s;};
d.prototype.getSelectedItem=function(){var i=sap.m.ListBase.prototype.getSelectedItem.apply(this,arguments);var s=Object.getOwnPropertyNames(this.getSelectedKeys());if(!i&&s.length>0){i=new sap.m.FacetFilterItem({text:this.getSelectedKeys()[s[0]],key:s[0],selected:true});}return i;};
d.prototype.removeSelections=function(A){if(this._allowRemoveSelections){A?this.setSelectedKeys():sap.m.ListBase.prototype.removeSelections.call(this,A);}return this;};
d.prototype.getSelectedKeys=function(){var r={};var k=this._oSelectedKeys;Object.getOwnPropertyNames(k).forEach(function(e){r[e]=k[e];});return r;};
d.prototype.setSelectedKeys=function(k){this._oSelectedKeys={};var K=false;k&&Object.getOwnPropertyNames(k).forEach(function(e){this._addSelectedKey(e,k[e]);K=true;},this);if(K){this.setActive(true);this._selectItemsByKeys();}else{sap.m.ListBase.prototype.removeSelections.call(this);}};
d.prototype._getNonGroupItems=function(){var i=[];this.getItems().forEach(function(I){if(I.getMode()!==b.None){i.push(I);}});return i;};
d.prototype.removeSelectedKey=function(k,t){if(this._removeSelectedKey(k,t)){this._getNonGroupItems().forEach(function(i){var I=i.getKey()||i.getText();k===I&&i.setSelected(false);});}};
d.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};sap.m.ListBase.prototype.removeSelections.call(this,true);};
d.prototype.removeItem=function(i){var I=sap.m.ListBase.prototype.removeItem.apply(this,arguments);if(!this._filtering){I&&I.getSelected()&&this.removeSelectedKey(I.getKey(),I.getText());return I;}};
d.prototype.init=function(){this._firstTime=true;this._saveBindInfo;this._oSelectedKeys={};L.prototype.init.call(this);this.setMode(b.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue="";this.attachUpdateFinished(function(e){var u=e.getParameter("reason");u=u?u.toLowerCase():u;if(u==="change"){var B=this.getBinding("items"),m=B?B.getModel():null;if(m&&m.getProperty(B.getPath())){this._iAllItemsCount=m.getProperty(B.getPath()).length||0;}}if(u!=="growing"&&u!==C.Filter.toLowerCase()){this._oSelectedKeys={};this._getNonGroupItems().forEach(function(i){if(i.getSelected()){this._addSelectedKey(i.getKey(),i.getText());}},this);}if(u!==C.Filter.toLowerCase()){this._selectItemsByKeys();}this._updateFacetFilterButtonText();this._updateSelectAllCheckBox();});this._allowRemoveSelections=true;this._bOriginalActiveState;this._iAllItemsCount;};
d.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._searchValue="";this._allowRemoveSelections=false;sap.m.ListBase.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true;}};
d.prototype._fireListCloseEvent=function(){var s=this.getSelectedItems();var S=this.getSelectedKeys();var A=s.length===0;this._firstTime=true;this.fireListClose({selectedItems:s,selectedKeys:S,allSelected:A});};
d.prototype._updateActiveState=function(){var o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||(o&&o.getSelected())){this.setActive(true);}};
d.prototype._handleSearchEvent=function(e){var s=e.getParameters()["query"];if(s===undefined){s=e.getParameters()["newValue"];}this._search(s);this._updateSelectAllCheckBox();};
d.prototype._search=function(s,f){var e;var n=0;function i(m){return m instanceof sap.ui.model.odata.ODataModel||m instanceof sap.ui.model.odata.v2.ODataModel;}if(f||(s!==this._searchValue)){this._searchValue=s;var B=this.getBinding("items");var o=this.getBindingInfo("items");if(o&&o.binding){e=o.binding.aFilters;if(e.length>0){n=e[0].aFilters.length;if(this._firstTime){this._saveBindInfo=e[0].aFilters[0];this._firstTime=false;}}}if(B){if(s||n>0){var p=this.getBindingInfo("items").template.getBindingInfo("text").parts[0].path;if(p){var u=new F(p,sap.ui.model.FilterOperator.Contains,s);if(this.getEnableCaseInsensitiveSearch()&&i(B.getModel())){var E="'"+String(s).replace(/'/g,"''")+"'";E=E.toLowerCase();u=new F("tolower("+p+")",sap.ui.model.FilterOperator.Contains,E);}if(n>1){var g=new F([u,this._saveBindInfo],true);}else{if(this._saveBindInfo>""&&u.sPath!=this._saveBindInfo.sPath){var g=new F([u,this._saveBindInfo],true);}else{if(s==""){var g=[];}else{var g=new F([u],true);}}}B.filter(g,sap.ui.model.FilterType.Control);}}else{B.filter([],sap.ui.model.FilterType.Control);}}else{q.sap.log.warning("No filtering performed","The list must be defined with a binding for search to work",this);}}};
d.prototype._getSearchValue=function(){return this._searchValue;};
d.prototype._updateSelectAllCheckBox=function(){var i=this._getNonGroupItems(),I=i.length,o,A,s;function e(f){return f.getSelected();}if(this.getMultiSelect()){o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));A=I>0&&I===i.filter(e).length;s=this.getActive()&&A;o&&o.setSelected(s);}};
d.prototype._addSelectedKey=function(k,t){if(!k&&!t){q.sap.log.error("Both sKey and sText are not defined. At least one must be defined.");return;}if(this.getMode()===b.SingleSelectMaster){this.removeSelectedKeys();}if(!k){k=t;}this._oSelectedKeys[k]=t||k;};
d.prototype._removeSelectedKey=function(k,t){if(!k&&!t){q.sap.log.error("Both sKey and sText are not defined. At least one must be defined.");return false;}if(!k){k=t;}delete this._oSelectedKeys[k];return true;};
d.prototype._setSearchValue=function(v){this._searchValue=v;};
d.prototype._isItemSelected=function(i){return!!(this._oSelectedKeys[i&&(i.getKey()||i.getText())]);};
d.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this);}};
d.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(i){i.setSelected(this._isItemSelected(i));},this);this._updateFacetFilterButtonText();};
d.prototype._handleSelectAllClick=function(s){var A;this._getNonGroupItems().forEach(function(i){if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}i.setSelected(s,true);},this);A=this._getOriginalActiveState()||s;this.setActive(A);q.sap.delayedCall(0,this,this._updateSelectAllCheckBox);};
d.prototype.onItemTextChange=function(i,n){var k=i.getKey();if(this._oSelectedKeys[k]&&n&&!this._filtering){this._oSelectedKeys[k]=n;}};
d.prototype.onItemSelectedChange=function(i,s){var A;if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}sap.m.ListBase.prototype.onItemSelectedChange.apply(this,arguments);A=this._getOriginalActiveState()||s||this.getSelectedItems().length>1;this.setActive(A);!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();q.sap.delayedCall(0,this,this._updateSelectAllCheckBox);};
d.prototype.updateItems=function(r){this._filtering=r===C.Filter;sap.m.ListBase.prototype.updateItems.apply(this,arguments);this._filtering=false;if(!this.getGrowing()||r===C.Filter){this._selectItemsByKeys();}};
d.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState;};
d.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive();};
return d;});
sap.ui.predefine('sap/m/FacetFilterListRenderer',['./ListRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var F=R.extend(L);return F;},true);
sap.ui.predefine('sap/m/FacetFilterRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/InvisibleText"],function(l,D,I){"use strict";var F=l.FacetFilterType;var a={};
a.render=function(r,c){switch(c.getType()){case F.Simple:a.renderSimpleFlow(r,c);break;case F.Light:a.renderSummaryBar(r,c);break;}};
a.renderSimpleFlow=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFF");if(c.getShowSummaryBar()){r.write(">");a.renderSummaryBar(r,c);}else{if(c._lastScrolling){r.addClass("sapMFFScrolling");}else{r.addClass("sapMFFNoScrolling");}if(c.getShowReset()){r.addClass("sapMFFResetSpacer");}r.writeClasses();r.write(">");if(D.system.desktop){r.renderControl(c._getScrollingArrow("left"));}r.write("<div");r.writeAttribute("id",c.getId()+"-head");r.addClass("sapMFFHead");r.writeClasses();r.write(">");a.renderFacetFilterListButtons(c,r);if(c.getShowPersonalization()){r.renderControl(c.getAggregation("addFacetButton"));}r.write("</div>");if(D.system.desktop){r.renderControl(c._getScrollingArrow("right"));}if(c.getShowReset()){r.write("<div");r.addClass("sapMFFResetDiv");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("resetButton"));r.write("</div>");}}r.write("</div>");};
a.renderSummaryBar=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFF");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("summaryBar"));r.write("</div>");};
a.getAriaAnnouncement=function(k,b){return I.getStaticId("sap.m",b||"FACETFILTER_"+k.toUpperCase());};
a.getAriaDescribedBy=function(c){var d=[];if(c.getShowPersonalization()){d.push(this.getAriaAnnouncement("ARIA_REMOVE"));}d=d.concat(c._aAriaPositionTextIds);return d.join(" ");};
a.getAccessibilityState=function(c){return{describedby:{value:this.getAriaDescribedBy(c),append:true}};};
a.renderFacetFilterListButtons=function(c,r){var L=c._getSequencedLists(),b=L.length,B,i,p,A,o=[],n=[],f=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTER_ARIA_FACET_FILTER"),R=this.getAriaAnnouncement("ARIA_REMOVE");for(i=0;i<b;i++){B=c._getButtonForList(L[i]);o=B.removeAllAriaDescribedBy();o.forEach(d);p=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTERLIST_ARIA_POSITION",[(i+1),b]);A=new I({text:f+" "+p}).toStatic();c._aOwnedLabels.push(A.getId());B.addAriaDescribedBy(A);n.push(A.getId());if(c.getShowPersonalization()){B.addAriaDescribedBy(a.getAriaAnnouncement("ARIA_REMOVE"));}r.renderControl(B);if(c.getShowPersonalization()){r.renderControl(c._getFacetRemoveIcon(L[i]));}}c._aAriaPositionTextIds=n;function d(s){if(R!==s){var e=sap.ui.getCore().byId(s);if(e){e.destroy();}}}};
return a;},true);
sap.ui.predefine('sap/m/FeedContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/Device','./FeedContentRenderer','jquery.sap.keycodes'],function(q,l,C,T,D,F){"use strict";var S=l.Size;
var a=C.extend("sap.m.FeedContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null},"value":{type:"string",group:"Misc",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Misc",defaultValue:null},"truncateValueTo":{type:"int",group:"Misc",defaultValue:4}},defaultAggregation:"_contentTextAgr",aggregations:{"_contentTextAgr":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
a.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentTextAgr",this._oContentText,true);this.setTooltip("{AltText}");};
a.prototype.onBeforeRendering=function(){this.$().unbind("mouseenter",this._addTooltip);this.$().unbind("mouseleave",this._removeTooltip);};
a.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));};
a.prototype.exit=function(){this._oContentText=null;};
a.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
a.prototype._removeTooltip=function(){this.$().attr("title",null);};
a.prototype.getAltText=function(){var A="";var i=true;if(this.getAggregation("_contentTextAgr").getText()){A+=this.getAggregation("_contentTextAgr").getText();i=false;}if(this.getSubheader()){if(i){A+=""+this.getSubheader();}else{A+="\n"+this.getSubheader();}i=false;}if(this.getValue()){if(i){A+=""+this.getValue();}else{A+="\n"+this.getValue();}}return A;};
a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
a.prototype.setContentText=function(t){this._oContentText.setText(t);return this;};
a.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
a.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
a.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
a.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
return a;});
sap.ui.predefine('sap/m/FeedContentRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var s=c.getSubheader();var v=c.getValue();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttribute("id",c.getId()+"-feed-content");r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",t);r.addClass("sapMFC");if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");if(v){r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMFCValue");r.addClass(c.getValueColor());r.writeClasses();r.write(">");var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped("");}r.write("</div>");}r.write("<div");r.addClass("sapMFCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMFCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FeedInput',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/TextArea","sap/m/Button","./FeedInputRenderer"],function(q,l,C,I,T,B,F){"use strict";var a=l.ButtonType;
var b=C.extend("sap.m.FeedInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedInput.designtime",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},maxLength:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Appearance",defaultValue:"Post something here"},value:{type:"string",group:"Data",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},buttonTooltip:{type:"sap.ui.core.TooltipBase",group:"Accessibility",defaultValue:"Submit"},ariaLabelForPicture:{type:"string",group:"Accessibility",defaultValue:null}},events:{post:{parameters:{value:{type:"string"}}}}}});
b.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setProperty("placeholder",o.getText("FEEDINPUT_PLACEHOLDER"),true);this.setProperty("buttonTooltip",o.getText("FEEDINPUT_SUBMIT"),true);};
b.prototype.exit=function(){if(this._oTextArea){this._oTextArea.destroy();}if(this._oButton){this._oButton.destroy();}if(this._oImageControl){this._oImageControl.destroy();}};
b.prototype.setIconDensityAware=function(i){this.setProperty("iconDensityAware",i,true);var c=sap.ui.require("sap/m/Image");if(this._getImageControl()instanceof c){this._getImageControl().setDensityAware(i);}return this;};
b.prototype.setMaxLength=function(m){this.setProperty("maxLength",m,true);this._getTextArea().setMaxLength(m);return this;};
b.prototype.setValue=function(v){this.setProperty("value",v,true);this._getTextArea().setValue(v);this._enablePostButton();return this;};
b.prototype.setPlaceholder=function(v){this.setProperty("placeholder",v,true);this._getTextArea().setPlaceholder(v);return this;};
b.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);this._getTextArea().setEnabled(e);this._enablePostButton();return this;};
b.prototype.setButtonTooltip=function(v){this.setProperty("buttonTooltip",v,true);this._getPostButton().setTooltip(v);return this;};
b.prototype._getTextArea=function(){if(!this._oTextArea){this._oTextArea=new T(this.getId()+"-textArea",{rows:3,value:null,maxLength:this.getMaxLength(),placeholder:this.getPlaceholder(),height:"100%",liveChange:q.proxy(function(e){var v=e.getParameter("value");this.setProperty("value",v,true);this._enablePostButton();},this)});this._oTextArea.setParent(this);}return this._oTextArea;};
b.prototype._getPostButton=function(){if(!this._oButton){this._oButton=new B(this.getId()+"-button",{enabled:false,type:a.Default,icon:"sap-icon://feeder-arrow",tooltip:this.getButtonTooltip(),press:q.proxy(function(){this._oTextArea.focus();this.firePost({value:this.getValue()});this.setValue(null);},this)});this._oButton.setParent(this);}return this._oButton;};
b.prototype._enablePostButton=function(){var p=this._isControlEnabled();var o=this._getPostButton();o.setEnabled(p);};
b.prototype._isControlEnabled=function(){var v=this.getValue();return this.getEnabled()&&q.type(v)==="string"&&v.trim().length>0;};
b.prototype._getImageControl=function(){var i=this.getIcon()||I.getIconURI("person-placeholder"),s=this.getId()+'-icon',p={src:i,alt:this.getAriaLabelForPicture(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false},c=['sapMFeedInImage'];this._oImageControl=l.ImageHelper.getImageControl(s,this._oImageControl,this,p,c);return this._oImageControl;};
return b;});
sap.ui.predefine('sap/m/FeedInputRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var m=c.getId();r.write("<div");r.writeControlData(c);r.addClass("sapMFeedIn");if(!c.getShowIcon()){r.addClass("sapMFeedInNoIcon");}if(!c.getEnabled()){r.addClass("sapMFeedInDisabled");}r.writeClasses();r.write(">");if(!!c.getShowIcon()){this._addImage(r,c,m);}r.write('<div id="'+m+'-container"');r.addClass("sapMFeedInContainer");r.writeClasses();r.write(">");var t=c._getTextArea();r.renderControl(t);r.renderControl(c._getPostButton());r.write("</div>");r.write("</div>");};
F._addImage=function(r,c,m){r.write('<figure id="'+m+'-figure" class ="sapMFeedInFigure');if(!!c.getIcon()){r.write('">');}else{r.write(' sapMFeedListItemIsDefaultIcon">');}r.renderControl(c._getImageControl());r.write('</figure>');};
return F;},true);
sap.ui.predefine('sap/m/FeedListItem',["./ListItemBase","./Link","./library","./FormattedText","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/Button","sap/ui/Device","./FeedListItemRenderer"],function(L,a,l,F,C,I,B,D,b){"use strict";var c=l.ListType;var d=l.ImageHelper;var e=l.LinkConversion;var f=l.ButtonType;
var g=L.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedListItem.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:e.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},defaultAggregation:"actions",aggregations:{actions:{type:"sap.m.FeedListItemAction",multiple:true},_text:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_actionButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}}});
g._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");g._nMaxCharactersMobile=300;g._nMaxCharactersDesktop=500;g._sTextShowMore=g._oRb.getText("TEXT_SHOW_MORE");g._sTextShowLess=g._oRb.getText("TEXT_SHOW_LESS");
g.prototype.init=function(){L.prototype.init.apply(this);this.setAggregation("_text",new F(this.getId()+"-formattedText"),true);this.setAggregation("_actionButton",new B({id:this.getId()+"-actionButton",type:f.Transparent,icon:"sap-icon://overflow",press:[this._onActionButtonPress,this]}),true);};
g.prototype._onActionButtonPress=function(){sap.ui.require(["sap/m/ActionSheet"],this._openActionSheet.bind(this));};
g.prototype._openActionSheet=function(A){var o=this.getAggregation("_actionSheet");var h=this.getActions();var j;if(!(o&&o instanceof A)){o=new A({id:this.getId()+"-actionSheet",beforeOpen:[this._onBeforeOpenActionSheet,this]});this.setAggregation("_actionSheet",o,true);}o.destroyAggregation("buttons",true);for(var i=0;i<h.length;i++){j=h[i];o.addButton(new B({icon:j.getIcon(),text:j.getText(),press:j.firePress.bind(j,{"item":this})}));}o.openBy(this.getAggregation("_actionButton"));};
g.prototype._onBeforeOpenActionSheet=function(h){var A,t;if(D.system.phone){return;}t=sap.ui.getCore().getConfiguration().getTheme();A=h.getSource().getParent();A.removeStyleClass("sapContrast sapContrastPlus");if(t==="sap_belize"){A.addStyleClass("sapContrast");}else if(t==="sap_belize_plus"){A.addStyleClass("sapContrastPlus");}};
g.prototype.invalidate=function(){C.prototype.invalidate.apply(this,arguments);delete this._bTextExpanded;if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.setProperty("text",g._sTextShowMore,true);}};
g.prototype.onBeforeRendering=function(){this.$("realtext").find('a[target="_blank"]').off("click");var o=this.getAggregation("_text");o.setProperty("convertLinksToAnchorTags",this.getConvertLinksToAnchorTags(),true);o.setProperty("convertedLinksDefaultTarget",this.getConvertedLinksDefaultTarget(),true);if(this.getConvertLinksToAnchorTags()===l.LinkConversion.None){o.setHtmlText(this.getText());}else{o.setProperty("htmlText",this.getText(),true);}this._sFullText=o._getDisplayHtml().replace(/\n/g,"<br>");this._sShortText=this._getCollapsedText();this._bEmptyTagsInShortTextCleared=false;};
g.prototype.onAfterRendering=function(){if(this._checkTextIsExpandable()&&!this._bTextExpanded){this._clearEmptyTagsInCollapsedText();}var r=this.$("realtext");F.prototype.onAfterRendering.apply({$:function(){return r;}});};
g.prototype.exit=function(){this.$("realtext").find('a[target="_blank"]').off("click");if(this._oLinkControl){this._oLinkControl.destroy();}if(this._oImageControl){this._oImageControl.destroy();}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy();}L.prototype.exit.apply(this);};
g.prototype.ontap=function(E){if(E.srcControl){if((!this.getIconActive()&&this._oImageControl&&E.srcControl.getId()===this._oImageControl.getId())||(!this.getSenderActive()&&this._oLinkControl&&E.srcControl.getId()===this._oLinkControl.getId())||(!this._oImageControl||(E.srcControl.getId()!==this._oImageControl.getId())&&(!this._oLinkControl||(E.srcControl.getId()!==this._oLinkControl.getId()))&&(!this._oLinkExpandCollapse||(E.srcControl.getId()!==this._oLinkExpandCollapse.getId())))){L.prototype.ontap.apply(this,[E]);}}};
g.prototype.onfocusin=function(E){if(this._oImageControl){var $=this.$("icon");if(E.target.id===this.getId()){$.removeAttr("alt");}else{$.attr("alt"," ");}}};
g.prototype._getImageControl=function(){var i=this.getIcon();var s=i?i:I.getIconURI("person-placeholder");var h=this.getId()+'-icon';var p={src:s,alt:encodeURI(this.getSender()),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false};var j;if(this.getIconActive()){j=['sapMFeedListItemImage'];}else{j=['sapMFeedListItemImageInactive'];}var t=this;this._oImageControl=d.getImageControl(h,this._oImageControl,this,p,j);if(this.getIconActive()){this._oImageControl.attachPress(function(){t.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});});}return this._oImageControl;};
g.prototype._getLinkSender=function(w){if(!this._oLinkControl){var t=this;this._oLinkControl=new a({press:function(){t.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});}});this._oLinkControl.setParent(this,null,true);}if(w){this._oLinkControl.setProperty("text",this.getSender()+g._oRb.getText("COLON"),true);}else{this._oLinkControl.setProperty("text",this.getSender(),true);}this._oLinkControl.setProperty("enabled",this.getSenderActive(),true);return this._oLinkControl;};
g.prototype._activeHandlingInheritor=function(){var A=this.getActiveIcon();if(this._oImageControl&&A){this._oImageControl.setSrc(A);}};
g.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon()?this.getIcon():I.getIconURI("person-placeholder");if(this._oImageControl){this._oImageControl.setSrc(s);}};
g.prototype._getCollapsedText=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(D.system.phone){this._nMaxCollapsedLength=g._nMaxCharactersMobile;}else{this._nMaxCollapsedLength=g._nMaxCharactersDesktop;}}var p=this._convertHtmlToPlainText(this._sFullText);var t=null;if(p&&p.length>this._nMaxCollapsedLength){var s=p.substring(0,this._nMaxCollapsedLength);var n=s.lastIndexOf(" ");if(n>0){s=s.substr(0,n);}if(p.length===this._sFullText.length){t=s;}else{t=this._convertPlainToHtmlText(s);}}return t;};
g.prototype._clearEmptyTagsInCollapsedText=function(){var r;if(this._bEmptyTagsInShortTextCleared){return;}this._bEmptyTagsInShortTextCleared=true;do{r=this.$("realtext").find(":empty").remove();}while(r.length>0);this._sShortText=this.$("realtext").html();};
g.prototype._toggleTextExpanded=function(){var $=this.$("realtext");var h=this.$("threeDots");if(this._bTextExpanded){$.html(this._sShortText.replace(/&#xa;/g,"<br>"));h.text(" ... ");this._oLinkExpandCollapse.setText(g._sTextShowMore);this._bTextExpanded=false;this._clearEmptyTagsInCollapsedText();}else{$.html(this._sFullText.replace(/&#xa;/g,"<br>"));h.text("  ");this._oLinkExpandCollapse.setText(g._sTextShowLess);this._bTextExpanded=true;}};
g.prototype._getLinkExpandCollapse=function(){if(!this._oLinkExpandCollapse){this._oLinkExpandCollapse=new a({text:g._sTextShowMore,press:[this._toggleTextExpanded,this]});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true);}return this._oLinkExpandCollapse;};
g.prototype._convertHtmlToPlainText=function(h){var r=/(<([^>]+)>)/ig;return h.replace(r,"");};
g.prototype._convertPlainToHtmlText=function(h){var s=this._sFullText;var r=/(<([^>]+)>)/ig;var E=s.split(r);var t="";for(var i=0;i<E.length;i++){if(E[i].length===0){continue;}if(h.length>0&&E[i].indexOf(h.trim())!==-1){E[i]=h;}if(/^<.+>$/.test(E[i])){t=t+E[i];E[i+1]="";continue;}if(h.indexOf(E[i].trim())===-1){continue;}else{h=h.replace(E[i],"");}t=t+E[i];}return t;};
g.prototype._checkTextIsExpandable=function(){return this._sShortText!==null;};
g.prototype.setType=function(t){if(this.getType()!==t){if(t===c.Navigation){this.setProperty("type",c.Active);}else{this.setProperty("type",t);}}return this;};
g.prototype.setUnread=function(v){return this.setProperty("unread",false,true);};
return g;});
sap.ui.predefine('sap/m/FeedListItemAction',["sap/ui/core/Element"],function(E){"use strict";
var F=E.extend("sap.m.FeedListItemAction",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},key:{type:"string",group:"Misc",defaultValue:""}},events:{press:{}}}});
return F;});
sap.ui.predefine('sap/m/FeedListItemRenderer',["./ListItemBaseRenderer","sap/ui/core/Renderer","sap/ui/Device"],function(L,R,D){"use strict";var F=R.extend(L);
F.renderLIAttributes=function(r,c){r.addClass("sapMFeedListItemTitleDiv");r.addClass("sapMFeedListShowSeparatorsAll");};
F.renderLIContent=function(r,c){var m=c.getId(),i=D.system.phone;r.write('<div');r.addClass('sapMFeedListItem');r.writeClasses();r.write('>');if(c.getShowIcon()){this._writeImageControl(r,c,m);}if(c.getActions().length>0){r.write("<div");r.writeAttributeEscaped("id",m+"-action-button");r.addClass('sapMFeedListItemActionButton');r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_actionButton"));r.write("</div>");}if(i){r.write('<div class= "sapMFeedListItemHeader sapUiSelectable ');if(c.getShowIcon()){r.write('sapMFeedListItemHasFigure ');}if(c.getSender()&&c.getTimestamp()){r.write('sapMFeedListItemFullHeight');}r.write('" >');if(c.getSender()){r.write('<p id="'+m+'-name" class="sapMFeedListItemTextName sapUiSelectable">');r.renderControl(c._getLinkSender(false));r.write('</p>');}if(c.getTimestamp()){r.write('<p id="'+m+'-timestamp" class="sapMFeedListItemTimestamp sapUiSelectable">');r.writeEscaped(c.getTimestamp());r.write('</p>');}r.write('</div>');r.write('<div class="sapMFeedListItemText sapUiSelectable">');r.write('<span id="'+m+'-realtext" class="sapMFeedListItemText sapUiSelectable">');if(c._checkTextIsExpandable()){this._writeCollapsedText(r,c,m);}else{r.write(c._sFullText);r.write('</span>');}r.write('</div>');if(c.getInfo()){r.write('<p class="sapMFeedListItemFooter sapUiSelectable">');if(c.getInfo()){r.write('<span id="'+m+'-info" class="sapMFeedListItemInfo sapUiSelectable">');r.writeEscaped(c.getInfo());r.write('</span>');}r.write('</p>');}}else{r.write('<div class= "sapMFeedListItemText ');if(c.getShowIcon()){r.write('sapMFeedListItemHasFigure');}r.write('" >');r.write('<div id="'+m+'-text" class="sapMFeedListItemTextText sapUiSelectable">');if(c.getSender()){r.write('<span id="'+m+'-name" class="sapMFeedListItemTextName sapUiSelectable">');r.renderControl(c._getLinkSender(true));r.write('</span>');}r.write('<span id="'+m+'-realtext" class="sapMFeedListItemTextString sapUiSelectable">');if(c._checkTextIsExpandable()){this._writeCollapsedText(r,c,m);}else{r.write(c._sFullText);r.write('</span>');}r.write('</div>');if(c.getInfo()||c.getTimestamp()){r.write('<p class="sapMFeedListItemFooter sapUiSelectable">');if(!sap.ui.getCore().getConfiguration().getRTL()){if(c.getInfo()){this._writeInfo(r,c,m);if(c.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}}if(c.getTimestamp()){this._writeTimestamp(r,c,m);}}else{if(c.getTimestamp()){this._writeTimestamp(r,c,m);}if(c.getInfo()){if(c.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}this._writeInfo(r,c,m);}}r.write('</p>');}r.write('</div>');}r.write('</div>');};
F._writeImageControl=function(r,c,i){r.write('<figure id="'+i+'-figure"');r.addClass('sapMFeedListItemFigure');if(!c.getIcon()){r.addClass('sapMFeedListItemIsDefaultIcon');}r.writeClasses();r.write('>');r.renderControl(c._getImageControl());r.write('</figure>');};
F._writeCollapsedText=function(r,c,i){if(c._bTextExpanded){r.write(c._sFullText);r.write('</span>');r.write('<span id="'+i+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32");r.write('</span>');}else{r.write(c._sShortText);r.write('</span>');r.write('<span id="'+i+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32&#46&#46&#46&#32");r.write('</span>');}var l=c._getLinkExpandCollapse();l.addStyleClass("sapMFeedListItemLinkExpandCollapse");r.renderControl(l);};
F._writeTimestamp=function(r,c,i){r.write('<span id="'+i+'-timestamp" class="sapMFeedListItemTimestampText sapUiSelectable">');r.writeEscaped(c.getTimestamp());r.write('</span>');};
F._writeInfo=function(r,c,i){r.write('<span id="'+i+'-info" class="sapMFeedListItemInfoText sapUiSelectable">');r.writeEscaped(c.getInfo());r.write('</span>');};
return F;},true);
sap.ui.predefine('sap/m/Fiori20Adapter',['jquery.sap.global','sap/ui/base/Object','sap/ui/base/EventProvider','sap/ui/base/ManagedObjectObserver','sap/ui/Device'],function(q,O,E,M,D){"use strict";var e=new E(),i,c;
var H=O.extend("HeaderAdapter",{constructor:function(o,A){if(!o||!A){q.sap.log.error("Cannot initialize: Invalid arguments.");return;}this._oHeader=o;this._oStyledPage=null;this._oTitleInfo=null;this._oSubTitleInfo=null;this._oBackButtonInfo=null;this._oAdaptOptions=A;}});
H.prototype.adapt=function(){var s=this._oAdaptOptions.bStylePage,C=this._oAdaptOptions.bCollapseHeader;if(s){this._toggleStyle("sapF2Adapted",true,true);}this._adaptTitle();this._adaptBackButton();if(C){this._collapseHeader();}return this.getAdaptedContent();};
H.prototype.getAdaptedContent=function(){return{oTitleInfo:this._oTitleInfo,oSubTitleInfo:this._oSubTitleInfo,oBackButtonInfo:this._oBackButtonInfo,oStyledPage:this._oStyledPage};};
H.prototype._adaptTitle=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bMoveTitle!==true){return false;}this._oTitleInfo=this._detectTitle();this._oSubTitleInfo=this._detectSubTitle();var s=!!this._oTitleInfo||!!this._oSubTitleInfo;if(this._oTitleInfo){this._oTitleInfo.oControl.toggleStyleClass("sapF2AdaptedTitle",true);}return s;};
H.prototype._adaptBackButton=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bHideBackButton!==true){return false;}var j,B=false;this._oBackButtonInfo=this._detectBackButton();if(this._oBackButtonInfo){j=this._oBackButtonInfo.oControl.getVisible();this._oBackButtonInfo.oControl.toggleStyleClass("sapF2AdaptedNavigation",j);B=true;}return B;};
H.prototype._toggleStyle=function(s,A,S){var p=this._oHeader.getParent();if(!p){return;}this._oStyledPage=p;if(A===true){p.addStyleClass(s,S);}else if(A===false){p.removeStyleClass(s,S);}else if(A===undefined){p.hasStyleClass(s)?p.removeStyleClass(s,S):p.addStyleClass(s,S);}};
H._isAdaptableHeader=function(o){if(!o||!f(o,"sap/m/Bar")){return false;}var p=o.getParent();return p&&(f(p,"sap/m/Page")||f(p,"sap/m/MessagePage")||f(p,"sap/uxap/ObjectPageHeader"));};
H.prototype._detectTitle=function(){var t;if(H._isAdaptableHeader(this._oHeader)){var m=this._oHeader.getContentMiddle();if(m.length===1&&a(m[0])){var T=m[0];t={id:T.getId(),text:T.getText(),oControl:T,sChangeEventId:"_change"};}}return t;};
H.prototype._detectSubTitle=function(p){if(f(p,"sap/uxap/ObjectPageHeader")){var o=p.getHeaderTitle();if(o){return{id:o.getId(),text:o.getObjectTitle(),oControl:o,sChangeEventId:"_titleChange"};}}};
H.prototype._detectBackButton=function(){var B,o;if(H._isAdaptableHeader(this._oHeader)){B=this._oHeader.getContentLeft();if(B.length>0&&f(B[0],"sap/m/Button")&&(B[0].getType()==="Back"||B[0].getType()==="Up"||B[0].getIcon()==="sap-icon://nav-back")){o=B[0];return{id:o.getId(),oControl:o,sChangeEventId:"_change"};}}};
H.prototype._collapseHeader=function(){var t=this._oTitleInfo,B=this._oBackButtonInfo,j,m,k,l,n,o,A;if(H._isAdaptableHeader(this._oHeader)){j=this._oHeader.getContentLeft();m=this._oHeader.getContentMiddle();k=this._oHeader.getContentRight();l=(j.length===1)&&(h(j[0])||B);n=(m.length===1)&&(h(m[0])||t);o=(k.length===1)&&h(k[0]);A=(j.length===0||l)&&(m.length===0||n)&&((k.length===0)||o);this._toggleStyle("sapF2CollapsedHeader",A,true);}};
var F=O.extend("sap.m.Fiori20Adapter",{});
F.attachViewChange=function(l,L){e.attachEvent("adaptedViewChange",l,L);};
F.detachViewChange=function(l,L){e.detachEvent("adaptedViewChange",l,L);};
F.traverse=function(C,A){i={aViewTitles:{},aViewSubTitles:{},aViewBackButtons:{},aChangeListeners:{}};c=null;this._doBFS([{oNode:C,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}};
F._doBFS=function(Q){var n=Q.shift();if(!n){return;}var N=n.oNode,A=n.oAdaptOptions,s=A.iSearchDepth;A=this._applyRules(A,N);if(!this._isAdaptationRequired(N,A)||(s<=0)){return;}var I=this._isTopNavigableView(N);if(I){this._setAsCurrentlyAdaptedTopViewId(N.getId());}var o=this._processNode(N,A);var C=this._getNodeChildren(N),j=q.extend({},A,{iSearchDepth:this._updateSearchDepth(s,N)});if(o){var t=!!o.oTitleInfo,B=!!o.oBackButton,p=!!o.oStyledPage;j=q.extend(j,{bMoveTitle:A.bMoveTitle&&!t,bHideBackButton:A.bHideBackButton&&!B,bStylePage:A.bStylePage&&!p});}C.forEach(function(k){if(k){Q.push({oNode:k,oAdaptOptions:j});}});this._doBFS(Q);};
F._processNode=function(C,A){this._attachDefferedAdaptationListeners(C,A);if(H._isAdaptableHeader(C)){return this._adaptHeader(C,A);}if(C.getParent()&&f(C.getParent(),"sap/m/NavContainer")){return this._getCachedViewInfoToMerge(C.getId());}};
F._attachDefferedAdaptationListeners=function(C,A){this._attachAdaptableContentChange(C,A);this._attachNavigablePageChange(C,A);if(f(C,"sap/m/Page")){this._attachModifyAggregation(C,"content",A);}if((A.bLateAdaptation===true)&&f(C,"sap/m/Bar")){this._attachModifyAggregation(C,"contentLeft",A,C);this._attachModifyAggregation(C,"contentMiddle",A,C);this._attachModifyAggregation(C,"contentRight",A,C);}if(f(C,"sap/ui/core/ComponentContainer")){var o=C.getComponentInstance();if(!o&&C.getName()&&!C.getDomRef()){var t=this;var j={onBeforeRendering:function(){C.removeEventDelegate(j);t._doBFS([{oNode:C.getComponentInstance(),oAdaptOptions:A}]);if(t._getCurrentlyAdaptedTopViewId()){t._fireViewChange(t._getCurrentlyAdaptedTopViewId(),A);}}};C.addEventDelegate(j,this);}}};
F._checkHasListener=function(k){return i.aChangeListeners[k];};
F._setHasListener=function(k,v){i.aChangeListeners[k]=v;};
F._attachAdaptableContentChange=function(C,A){if(!C._getAdaptableContent||!q.isFunction(C._getAdaptableContent)){return;}var k=C.getId()+"_adaptableContentChange";if(this._checkHasListener(k)){return;}var o=this._getCurrentlyAdaptedTopViewId();var j=function(l){var m=l.getParameter("adaptableContent");this._setAsCurrentlyAdaptedTopViewId(o);this._doBFS([{oNode:m,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}}.bind(this);C.attachEvent("_adaptableContentChange",j);this._setHasListener(k,j);};
F._attachNavigablePageChange=function(C,A){if(!f(C,"sap/m/NavContainer")){return;}var k=C.getId()+"navigate";if(this._checkHasListener(k)){return;}var o=function(j){var n=j.getParameter("to");A=this._applyRules(A,n);this._doBFS([{oNode:n,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}}.bind(this);C.attachNavigate(o);this._setHasListener(k,o);};
F._attachModifyAggregation=function(C,A,o,j){var k=C.getId()+A;if(this._checkHasListener(k)){return;}var l=this._getCurrentlyAdaptedTopViewId(),m=function(p){var s=p.mutation,r=p.object;if((s==="add")||(s==="insert")){this._setAsCurrentlyAdaptedTopViewId(l);this._doBFS([{oNode:j?j:r,oAdaptOptions:o}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),o);}}}.bind(this),n=new M(m);n.observe(C,{aggregations:[A]});this._setHasListener(k,n);};
F._getNodeChildren=function(C){if(C._getAdaptableContent&&q.isFunction(C._getAdaptableContent)){var j=[C._getAdaptableContent()];if(f(C,"sap/m/Page")){j=j.concat(C.getContent());}return j;}if(f(C,"sap/m/SplitContainer")){return[].concat(C.getAggregation("_navMaster"),C.getAggregation("_navDetail"));}if(f(C,"sap/uxap/ObjectPageLayout")){return[C.getHeaderTitle()];}if(f(C,"sap/ui/core/ComponentContainer")){return[C.getComponentInstance()];}if(f(C,"sap/ui/core/UIComponent")){return[C.getAggregation("rootControl")];}return C.findAggregatedObjects(false,g);};
F._updateSearchDepth=function(s,C){if(f(C,"sap/ui/core/mvc/View")||f(C,"sap/ui/core/Component")||f(C,"sap/ui/core/ComponentContainer")){return s;}return s-1;};
F._getTotalCachedInfoToMerge=function(v){var V=sap.ui.getCore().byId(v),C=this._getCachedViewInfoToMerge(v),j,k,s,S,o,p,l;if(!D.system.phone&&this._isTopSplitContainerSubView(V)){p=V.getParent();o=p&&p.getParent();if(o){j=o._oMasterNav&&(o._oMasterNav.getId()===p.getId());k=o._oDetailNav&&(o._oDetailNav.getId()===p.getId());}}if(j){s=o.getCurrentDetailPage();S=s&&s.getId();l=this._getCachedViewInfoToMerge(S);C=this._mergeSplitViewInfos(C,l);}if(k){s=o.getCurrentMasterPage();S=s&&s.getId();l=this._getCachedViewInfoToMerge(S);C=this._mergeSplitViewInfos(l,C);}C.sViewId=(j||k)?o.getId():v;return C;};
F._isTopSplitContainerSubView=function(C){var p=C&&C.getParent();return this._isTopmostNavContainer(p)&&f(p.getParent(),"sap/m/SplitContainer");};
F._mergeSplitViewInfos=function(m,o){q.each(m,function(k,v){m[k]=v||o[k];});return m;};
F._getCachedViewInfoToMerge=function(v){var B=(i.aViewBackButtons[v])?i.aViewBackButtons[v].oControl:undefined;return{oTitleInfo:i.aViewTitles[v],oSubTitleInfo:i.aViewSubTitles[v],oBackButton:B};};
F._applyRules=function(A,C){var p=C.getParent();if(f(p,"sap/m/SplitContainer")){var I=D.system.phone,m=A.bMoveTitle,j=A.bHideBackButton;if(m){m=I;}if(j&&!D.system.phone){j='initialPage';}return q.extend({},A,{bMoveTitle:m,bHideBackButton:j});}if(f(p,"sap/m/NavContainer")){if(A.bHideBackButton==='initialPage'){var k=p._getActualInitialPage()&&(p._getActualInitialPage().getId()===C.getId());return q.extend({},A,{bHideBackButton:k});}}if((A.bMoveTitle===false)||(A.bHideBackButton===false)){return q.extend({},A,{bCollapseHeader:false});}return A;};
F._getCurrentlyAdaptedTopViewId=function(){return c;};
F._setAsCurrentlyAdaptedTopViewId=function(v){c=v;};
F._isTopNavigableView=function(n){var p=n.getParent();return p&&this._isTopmostNavContainer(p);};
F._isTopmostNavContainer=function(C){var o,n=C;while(n){if(f(n,"sap/m/NavContainer")){o=n;}n=n.getParent();}return o&&(o.getId()===C.getId());};
F._adaptHeader=function(o,A){if(!o||!A){return;}var j=new H(o,A),k=j.adapt();var t=this._getCurrentlyAdaptedTopViewId();if(k.oTitleInfo){i.aViewTitles[t]=k.oTitleInfo;this._registerTextChangeListener(i.aViewTitles,t,A);}if(k.oSubTitleInfo){i.aViewSubTitles[t]=k.oSubTitleInfo;this._registerTextChangeListener(i.aViewSubTitles,t,A);}if(k.oBackButtonInfo){if(k.oBackButtonInfo.oControl.getVisible()){i.aViewBackButtons[t]=k.oBackButtonInfo;}this._registerVisibilityChangeListener(k.oBackButtonInfo,i.aViewBackButtons,t,A);}return k;};
F._registerTextChangeListener=function(t,v,A){var T=t[v];if(T&&T.oControl&&T.sChangeEventId&&!i.aChangeListeners[T.id]){var C=function(o){var T=t[v];T.text=o.getParameter("newValue");this._fireViewChange(v,A);}.bind(this);T.oControl.attachEvent(T.sChangeEventId,C);i.aChangeListeners[T.id]=C;}};
F._registerVisibilityChangeListener=function(C,j,v,A){var V;if(C&&C.oControl&&C.sChangeEventId&&!i.aChangeListeners[C.id]){var k=function(o){V=o.getParameter("newValue");if(!V){q.each(j,function(I,l){if(l.oControl.getId()===C.oControl.getId()){delete j[I];}});}var p=C.oControl.getParent();if(H._isAdaptableHeader(p)){F._adaptHeader(p,A);this._fireViewChange(v,A);}}.bind(this);C.oControl.attachEvent(C.sChangeEventId,k);i.aChangeListeners[C.id]=k;}};
F._fireViewChange=function(v,A){var t=this._getTotalCachedInfoToMerge(v);t.oAdaptOptions=A;e.fireEvent("adaptedViewChange",t);};
F._isAdaptationRequired=function(n,A){if(!n||this._isNonAdaptableControl(n)){return false;}for(var o in A){if(A.hasOwnProperty(o)&&((A[o]===true)||(A[o]==="initialPage"))){return true;}}return false;};
F._isNonAdaptableControl=function(C){return b(C);};
function a(C){return d(C,["sap/m/Label","sap/m/Text","sap/m/Title"]);}
function b(C){return d(C,["sap/m/List","sap/m/Table","sap/ui/table/Table","sap/ui/table/TreeTable"]);}
function d(C,t){if(!C||!t){return;}return t.some(function(T){return f(C,T);});}
function f(C,t){var T=sap.ui.require(t);return T&&(C instanceof T);}
function g(o){return o&&(o.sParentAggregationName!=="dependents");}
function h(o){return o&&(typeof o.getVisible==="function")&&(o.getVisible()===false);}
return F;});
sap.ui.predefine('sap/m/FlexBox',['jquery.sap.global','./FlexBoxStylingHelper','./FlexItemData','./library','sap/ui/core/Control','sap/ui/core/RenderManager','./FlexBoxRenderer'],function(q,F,a,l,C,R,b){"use strict";var B=l.BackgroundDesign;var c=l.FlexAlignContent;var d=l.FlexWrap;var e=l.FlexAlignItems;var f=l.FlexJustifyContent;var g=l.FlexRendertype;var h=l.FlexDirection;
var j=C.extend("sap.m.FlexBox",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},displayInline:{type:"boolean",group:"Appearance",defaultValue:false},direction:{type:"sap.m.FlexDirection",group:"Appearance",defaultValue:h.Row},fitContainer:{type:"boolean",group:"Appearance",defaultValue:false},renderType:{type:"sap.m.FlexRendertype",group:"Misc",defaultValue:g.Div},justifyContent:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:f.Start},alignItems:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:e.Stretch},wrap:{type:"sap.m.FlexWrap",group:"Appearance",defaultValue:d.NoWrap},alignContent:{type:"sap.m.FlexAlignContent",group:"Appearance",defaultValue:c.Stretch},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Transparent}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"}},designtime:"sap/m/designtime/FlexBox.designtime"}});
j.prototype.init=function(){if(this instanceof sap.m.HBox&&(this.getDirection()!==h.Row||this.getDirection()!==h.RowReverse)){this.setDirection('Row');}if(this instanceof sap.m.VBox&&(this.getDirection()!==h.Column||this.getDirection()!==h.ColumnReverse)){this.setDirection('Column');}this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};};
j.prototype.addItem=function(i){this.addAggregation("items",i);this._onItemInserted(i);return this;};
j.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I);this._onItemInserted(i);return this;};
j.prototype.removeItem=function(i){var I=this.removeAggregation("items",i);this._onItemRemoved(I);return I;};
j.prototype.removeAllItems=function(){var I=this.getItems();for(var i=0;i<I.length;i++){this._onItemRemoved(I[i]);}return this.removeAllAggregation("items");};
j.prototype._onItemInserted=function(i){if(i&&!(i instanceof j)){i.attachEvent("_change",this._onItemChange,this);if(this.getRenderType()===g.Bare){i.addEventDelegate(this._oItemDelegate,i);}}};
j.prototype._onItemRemoved=function(i){if(i&&!(i instanceof j)){i.detachEvent("_change",this._onItemChange,this);if(this.getRenderType()===g.Bare){i.removeEventDelegate(this._oItemDelegate,i);}}};
j.prototype._onItemChange=function(o){if(o.getParameter("name")!=="visible"||(this.getRenderType()!==g.List&&this.getRenderType()!==g.Div)){return;}var i=sap.ui.getCore().byId(o.getParameter("id")),w=null;if(i.getLayoutData()){w=q.sap.byId(i.getLayoutData().getId());}else{w=q.sap.byId(R.createInvisiblePlaceholderId(i)).parent();}if(o.getParameter("newValue")){w.removeClass("sapUiHiddenPlaceholder").removeAttr("aria-hidden");}else{w.addClass("sapUiHiddenPlaceholder").attr("aria-hidden","true");}};
j.prototype._onAfterItemRendering=function(){var L=this.getLayoutData();if(L instanceof a){F.setFlexItemStyles(null,L);}};
j.prototype.setRenderType=function(v){var o=this.getRenderType(),i=this.getItems();if(v===o){return this;}this.setProperty("renderType",v);if(o==="Bare"){i.forEach(this._onItemRemoved,this);}if(v==="Bare"){i.forEach(this._onItemInserted,this);}return this;};
j.prototype.setDisplayInline=function(i){this.setProperty("displayInline",i,true);this.$().toggleClass("sapMFlexBoxInline",this.getDisplayInline());return this;};
j.prototype.setDirection=function(v){this.setProperty("direction",v,true);if(this.getDirection()===h.Column||this.getDirection()===h.ColumnReverse){this.$().removeClass("sapMHBox").addClass("sapMVBox");}else{this.$().removeClass("sapMVBox").addClass("sapMHBox");}if(this.getDirection()===h.RowReverse||this.getDirection()===h.ColumnReverse){this.$().addClass("sapMFlexBoxReverse");}else{this.$().removeClass("sapMFlexBoxReverse");}return this;};
j.prototype.setFitContainer=function(v){this.setProperty("fitContainer",v,true);this.$().toggleClass("sapMFlexBoxFit",this.getFitContainer());return this;};
j.prototype.setWrap=function(v){var o=this.getWrap();this.setProperty("wrap",v,true);this.$().removeClass("sapMFlexBoxWrap"+o).addClass("sapMFlexBoxWrap"+this.getWrap());return this;};
j.prototype.setJustifyContent=function(v){var o=this.getJustifyContent();this.setProperty("justifyContent",v,true);this.$().removeClass("sapMFlexBoxJustify"+o).addClass("sapMFlexBoxJustify"+this.getJustifyContent());return this;};
j.prototype.setAlignItems=function(v){var o=this.getAlignItems();this.setProperty("alignItems",v,true);this.$().removeClass("sapMFlexBoxAlignItems"+o).addClass("sapMFlexBoxAlignItems"+this.getAlignItems());return this;};
j.prototype.setAlignContent=function(v){var o=this.getAlignContent();this.setProperty("alignContent",v,true);this.$().removeClass("sapMFlexBoxAlignContent"+o).addClass("sapMFlexBoxAlignContent"+this.getAlignContent());return this;};
j.prototype.setHeight=function(v){this.setProperty("height",v,true);this.$().css("height",this.getHeight());return this;};
j.prototype.setWidth=function(v){this.setProperty("width",v,true);this.$().css("width",this.getWidth());return this;};
j.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
j.prototype.getAccessibilityInfo=function(){return{children:this.getItems()};};
return j;});
sap.ui.predefine('sap/m/FlexBoxCssPropertyMap',[],function(){"use strict";var F={'spec0907':{'order':{'<number>':{'box-ordinal-group':'<integer>'}},'flex-grow':{'<number>':{'box-flex':'<number>'}},'flex-shrink':null,'flex-basis':null},'specie10':{'order':{'<number>':{'flex-order':'<number>'}},'flex-grow':{'<number>':{'flex-positive':'<number>','flex-preferred-size':'auto'}},'flex-shrink':{'<number>':{'flex-negative':'<number>'}},'flex-basis':{'<number>':{'flex-preferred-size':'<number>'}}}};return F;},true);
sap.ui.predefine('sap/m/FlexBoxRenderer',['jquery.sap.global','./FlexBoxStylingHelper','sap/m/library'],function(q,F,l){"use strict";var a=l.FlexDirection;var b=l.FlexRendertype;if(!q.support.flexBoxLayout&&!q.support.newFlexBoxLayout&&!q.support.ie10FlexBoxLayout){q.sap.log.warning("This browser does not support flexible box layouts natively.");}var c=function(C,m){var e=sap.ui.require(m);return typeof e==='function'&&(C instanceof e);};var d={};
d.render=function(r,C){if(C.getRenderType()===b.List){r.write('<ul');}else{r.write('<div');}r.writeControlData(C);var p=C.getParent();if(c(C.getParent(),"sap/m/FlexBox")){r.addClass("sapMFlexItem");var L=C.getLayoutData();if(L instanceof sap.m.FlexItemData){F.setFlexItemStyles(r,L);}if(p.getRenderType()===b.List){r.write('<li');}}else if(C.getFitContainer()){r.addClass("sapMFlexBoxFit");}r.addClass("sapMFlexBox");if(C.getDisplayInline()){r.addClass("sapMFlexBoxInline");}if(C.getDirection()===a.Column||C.getDirection()===a.ColumnReverse){r.addClass("sapMVBox");}else{r.addClass("sapMHBox");}if(C.getDirection()===a.RowReverse||C.getDirection()===a.ColumnReverse){r.addClass("sapMFlexBoxReverse");}r.addClass("sapMFlexBoxJustify"+C.getJustifyContent());r.addClass("sapMFlexBoxAlignItems"+C.getAlignItems());r.addClass("sapMFlexBoxWrap"+C.getWrap());r.addClass("sapMFlexBoxAlignContent"+C.getAlignContent());r.addClass("sapMFlexBoxBG"+C.getBackgroundDesign());r.writeClasses();if(C.getHeight()){r.addStyle("height",C.getHeight());}if(C.getWidth()){r.addStyle("width",C.getWidth());}r.writeStyles();var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");d.renderItems(C,r);if(C.getRenderType()===b.List){r.write("</ul>");}else{r.write("</div>");}};
d.renderItems=function(C,r){var e=C.getItems(),w='';for(var i=0;i<e.length;i++){if(c(e[i],'sap/m/FlexBox')||C.getRenderType()===b.Bare){w="";}else if(C.getRenderType()===b.List){w="li";}else{w="div";}d.renderItem(e[i],w,r);}};
d.renderItem=function(i,w,r){if(w){r.write('<'+w);if(i instanceof sap.m.ScrollContainer){r.addClass("sapMFlexBoxScroll");}if(!i.getVisible()){r.addClass("sapUiHiddenPlaceholder");}}var L=i.getLayoutData();if(w&&!L){i.setAggregation("layoutData",new sap.m.FlexItemData(),true);L=i.getLayoutData();}if(!(L instanceof sap.m.FlexItemData)){q.sap.log.warning(L+" set on "+i+" is not of type sap.m.FlexItemData");}else{if(w&&L.getId()){r.writeAttributeEscaped("id",L.getId());}if(L.getStyleClass()){d.addItemClass(q.sap.encodeHTML(L.getStyleClass()),i,w,r);}d.addItemClass("sapMFlexItemAlign"+L.getAlignSelf(),i,w,r);d.addItemClass("sapMFlexBoxBG"+L.getBackgroundDesign(),i,w,r);if(w){F.setFlexItemStyles(r,L);}}d.addItemClass("sapMFlexItem",i,w,r);if(w){r.writeStyles();r.writeClasses();r.write(">");}r.renderControl(i);if(w){r.write('</'+w+'>');}};
d.addItemClass=function(C,i,w,r){if(w){r.addClass(C);}else{i.addStyleClass(C);}};
return d;},true);
sap.ui.predefine('sap/m/FlexBoxStylingHelper',['jquery.sap.global','./FlexBoxCssPropertyMap','sap/ui/Device'],function(q,F,D){"use strict";var a={};
a.setFlexItemStyles=function(r,l){r=r||null;var o=''+l.getOrder(),g=''+l.getGrowFactor(),s=''+l.getShrinkFactor(),b=l.getBaseSize().toLowerCase(),m=l.getMinHeight(),M=l.getMaxHeight(),c=l.getMinWidth(),d=l.getMaxWidth();if(typeof o!=='undefined'){a.setStyle(r,l,"order",o);}if(typeof g!=='undefined'){a.setStyle(r,l,"flex-grow",g);}if(q.support.newFlexBoxLayout||q.support.ie10FlexBoxLayout){if(typeof s!=='undefined'){a.setStyle(r,l,"flex-shrink",s);}if(typeof b!=='undefined'){a.setStyle(r,l,"flex-basis",b);}}if(typeof m!=='undefined'){a.setStyle(r,l,"min-height",m);}if(typeof M!=='undefined'){a.setStyle(r,l,"max-height",M);}if(typeof c!=='undefined'){a.setStyle(r,l,"min-width",c);}if(typeof d!=='undefined'){a.setStyle(r,l,"max-width",d);}};
a.setStyle=function(r,l,p,v){if(typeof(v)==="string"){v=v.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();}if(q.support.flexBoxPrefixed){if(D.browser.webkit){this.sVendorPrefix="-webkit-";}else if(D.browser.mozilla){this.sVendorPrefix="-moz-";}else if(D.browser.internet_explorer){this.sVendorPrefix="-ms-";}}else{this.sVendorPrefix="";}if(q.support.newFlexBoxLayout||["min-height","max-height","min-width","max-width"].indexOf(p)!==-1){a.writeStyle(r,l,p,v);}else if(q.support.flexBoxLayout||q.support.ie10FlexBoxLayout){a.setOldSpecStyle(r,l,p,v);}};
a.setOldSpecStyle=function(r,l,p,v){var s="";if(this.sVendorPrefix=="-ms-"){s="specie10";}else{s="spec0907";}if(F[s][p]!==null&&F[s][p]!=="<idem>"){var L=null;if(typeof(F[s][p])==="object"){if(F[s][p]["<number>"]){L={};for(var k in F[s][p]["<number>"]){if(F[s][p]["<number>"][k]==="<number>"){L[k]=v;}else{L[k]=F[s][p]["<number>"][k];}}}else{L=F[s][p][v];}}else{L=F[s][p][v];}if(L!==null&&L!=="<idem>"){if(typeof(L)==="object"){for(var b in L){a.writeStyle(r,l,b,L[b]);}}}}};
a.writeStyle=function(r,l,p,v){var P="";var V="";if(p!=="display"){P=this.sVendorPrefix;}else{V=this.sVendorPrefix;}if(D.browser.internet_explorer&&(p==="flex-basis"||p==="flex-preferred-size")){P="";if(l.getParent()){if(l.getParent().getParent().getDirection().indexOf("Row")>-1){p="width";}else{p="height";}}}if(r){if(v==="0"||v){r.addStyle(P+p,V+v);}}else{if(l.$().length){if(v!=="0"&&!v){l.$().css(P+p,null);}else{l.$().css(P+p,V+v);}}else{if(l.getParent()){if(v!=="0"&&!v){l.getParent().$().css(P+p,null);}else{l.getParent().$().css(P+p,V+v);}}}}};
return a;},true);
sap.ui.predefine('sap/m/FlexItemData',['./FlexBoxStylingHelper','./library','sap/ui/core/LayoutData'],function(F,l,L){"use strict";var B=l.BackgroundDesign;var a=l.FlexAlignSelf;
var b=L.extend("sap.m.FlexItemData",{metadata:{library:"sap.m",properties:{alignSelf:{type:"sap.m.FlexAlignSelf",group:"Misc",defaultValue:a.Auto},order:{type:"int",group:"Misc",defaultValue:0},growFactor:{type:"float",group:"Misc",defaultValue:0},shrinkFactor:{type:"float",group:"Misc",defaultValue:1},baseSize:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},styleClass:{type:"string",group:"Misc",defaultValue:''},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Transparent}}}});
b.prototype.setAlignSelf=function(v){var o=this.getAlignSelf();this.setProperty("alignSelf",v,true);this.$().removeClass("sapMFlexItemAlign"+o).addClass("sapMFlexItemAlign"+this.getAlignSelf());return this;};
b.prototype.setOrder=function(v){this.setProperty("order",v,true);F.setStyle(null,this,"order",this.getOrder());return this;};
b.prototype.setGrowFactor=function(v){this.setProperty("growFactor",v,true);F.setStyle(null,this,"flex-grow",this.getGrowFactor());return this;};
b.prototype.setShrinkFactor=function(v){this.setProperty("shrinkFactor",v,true);F.setStyle(null,this,"flex-shrink",this.getShrinkFactor());return this;};
b.prototype.setBaseSize=function(v){this.setProperty("baseSize",v,true);F.setStyle(null,this,"flex-basis",this.getBaseSize());return this;};
b.prototype.setMinHeight=function(v){this.setProperty("minHeight",v,true);this.$().css("min-height",this.getMinHeight());return this;};
b.prototype.setMaxHeight=function(v){this.setProperty("maxHeight",v,true);this.$().css("max-height",this.getMaxHeight());return this;};
b.prototype.setMinWidth=function(v){this.setProperty("minWidth",v,true);this.$().css("min-width",this.getMinWidth());return this;};
b.prototype.setMaxWidth=function(v){this.setProperty("maxWidth",v,true);this.$().css("max-width",this.getMaxWidth());return this;};
b.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
b.prototype.setStyleClass=function(v){var o=this.getStyleClass();this.setProperty("styleClass",v,true);this.$().removeClass(o).addClass(this.getStyleClass());return this;};
return b;});
sap.ui.predefine('sap/m/FormattedText',['jquery.sap.global','./library','sap/ui/core/Control','./FormattedTextAnchorGenerator','./FormattedTextRenderer'],function(q,l,C,F,a){"use strict";var L=l.LinkConversion;
var b=C.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:L.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}}});
var _={ATTRIBS:{'style':1,'class':1,'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'abbr':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1}},c={ATTRIBS:{'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'em':1,'strong':1,'u':1}},d=_;
b.prototype.init=function(){};
function s(t,f){var w;var g,v,h=t==="a";var j=d.ELEMENTS[t].cssClass||"";for(var i=0;i<f.length;i+=2){g=f[i];v=f[i+1];if(!d.ATTRIBS[g]&&!d.ATTRIBS[t+"::"+g]){w='FormattedText: <'+t+'> with attribute ['+g+'="'+v+'"] is not allowed';q.sap.log.warning(w,this);f[i+1]=null;continue;}if(g=="href"){if(!q.sap.validateUrl(v)){q.sap.log.warning("FormattedText: incorrect href attribute:"+v,this);f[i+1]="#";h=false;}}if(g=="target"){h=false;}if(j&&g.toLowerCase()=="class"){f[i+1]=j+" "+v;j="";}}if(h){f.push("target");f.push("_blank");}if(j){f.push("class");f.push(j);}return f;}
function p(t,f){if(d.ELEMENTS[t]){return s(t,f);}else{var w='<'+t+'> is not allowed';q.sap.log.warning(w,this);}}
function e(t){return q.sap._sanitizeHTML(t,{tagPolicy:p,uriRewriter:function(u){if(q.sap.validateUrl(u)){return u;}}});}
function o(E){var n=window.open();n.opener=null;n.location=E.currentTarget.href;E.preventDefault();}
b.prototype.onAfterRendering=function(){this.$().find('a[target="_blank"]').on("click",o);};
b.prototype._getDisplayHtml=function(){var t=this.getHtmlText(),A=this.getConvertLinksToAnchorTags();if(A===l.LinkConversion.None){return t;}t=F.generateAnchors(t,A,this.getConvertedLinksDefaultTarget());return e(t);};
b.prototype.setHtmlText=function(t){return this.setProperty("htmlText",e(t));};
b.prototype._setUseLimitedRenderingRules=function(f){d=f?c:_;};
return b;});
sap.ui.predefine('sap/m/FormattedTextAnchorGenerator',["jquery.sap.global","sap/ui/base/Metadata","sap/m/library"],function(q,M,l){"use strict";var L=l.LinkConversion;var A=M.createClass("sap.m.FormattedTextAnchorGenerator",{});var c=/(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;()$]*[-A-Z0-9+&@#\/%=~_|])/gim;var W=/(www\.[^\s><]+(\b|$))/gim;var d="//";var D=/<(?:"[^"]*"['"]*|'[^']*'['"]*|[^'">])+(?!\/\s\*)>/gim;var E=/<a[^>]*>([^<]+)<\/a>/gim;var e=[D,E];
A.generateAnchors=function(t,s,T){if(s===L.ProtocolOnly){t=A._createAnchors(t,c,T);}if(s===L.All){t=A._createAnchors(t,c,T);t=A._createAnchors(t,W,T,d);}return t;};
A._createPositionObject=function(i,a){return{iStartPos:i,iEndPos:i+a};};
A._isNested=function(f,s){return f.iStartPos<s.iStartPos&&f.iEndPos>s.iEndPos;};
A._isAllowed=function(b,C){return b.some(function(B){return A._isNested(B,C);});};
A._shouldBeProcessed=function(u,C,b){return q.sap.validateUrl(u)&&!A._isAllowed(b,C);};
A._scanForEntitiesToSkip=function(r,t){var a=[],C;while((C=r.exec(t))!==null){a.push(A._createPositionObject(C.index,C[0].length));}return a;};
A._getEntitiesToSkipWhileSearchingForLinks=function(t){return e.map(function(s){return A._scanForEntitiesToSkip(s,t);}).reduce(function(a,b){return a.concat(b);});};
A._createAnchors=function(t,r,T,p){var a=A._getEntitiesToSkipWhileSearchingForLinks(t),C;p=p||'';C=function(P){var o=A._createPositionObject(arguments[3],P.length);if(!A._shouldBeProcessed(P,o,a)){return P;}return"<a href=\""+p+P+"\" target=\""+T+"\">"+P+"</a>";};return t.replace(r,C);};
return A;},false);
sap.ui.predefine('sap/m/FormattedTextRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFT");r.writeClasses();if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}r.addStyle("width",c.getWidth()||null);r.addStyle("height",c.getHeight()||null);r.writeStyles();r.write(">");r.write(c._getDisplayHtml());r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/GenericTile',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool','sap/m/Button','sap/m/GenericTileRenderer','sap/m/GenericTileLineModeRenderer','sap/ui/Device','sap/ui/core/ResizeHandler','jquery.sap.events'],function(q,l,C,T,H,I,a,B,G,L,D,R){"use strict";var b=l.GenericTileScope;var c=l.LoadState;var F=l.FrameType;var S=l.Size;var d=l.GenericTileMode;var e="GenericTileDeviceSet";
var f=C.extend("sap.m.GenericTile",{
metadata:{library:"sap.m",properties:{"mode":{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:d.ContentMode},"header":{type:"string",group:"Appearance",defaultValue:null},"subheader":{type:"string",group:"Appearance",defaultValue:null},"failedText":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto},"frameType":{type:"sap.m.FrameType",group:"Misc",defaultValue:F.OneByOne},"backgroundImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"headerImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"state":{type:"sap.m.LoadState",group:"Misc",defaultValue:c.Loaded},"imageDescription":{type:"string",group:"Accessibility",defaultValue:null},"scope":{type:"sap.m.GenericTileScope",group:"Misc",defaultValue:b.Display},"ariaLabel":{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"tileContent",aggregations:{"tileContent":{type:"sap.m.TileContent",multiple:true,bindable:"bindable"},"icon":{type:"sap.ui.core.Control",multiple:false},"_titleText":{type:"sap.m.Text",multiple:false,visibility:"hidden"},"_failedMessageText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{parameters:{"scope":{type:"sap.m.GenericTileScope"},"action":{type:"string"},"domRef":{type:"any"}}}}},
renderer:function(r,o){if(o.getMode()===l.GenericTileMode.LineMode){L.render(r,o);}else{G.render(r,o);}}
});
f._Action={Press:"Press",Remove:"Remove"};f.LINEMODE_SIBLING_PROPERTIES=["state","subheader","header","scope"];
f.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!D.media.hasRangeSet(e)){D.media.initRangeSet(e,[450],"px",["small","large"]);}this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._sFailedToLoad=this._oRb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._oRb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.375rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.setBusyIndicatorDelay(0);this._bTilePress=true;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
f.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
f.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._oTitle.clampHeight();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
f.prototype._initScopeContent=function(t){switch(this.getScope()){case l.GenericTileScope.Actions:if(this.getState&&this.getState()===l.LoadState.Disabled){break;}this._oMoreIcon=this._oMoreIcon||a.createControlByURI({id:this.getId()+"-action-more",size:"1rem",useIconTooltip:false,src:"sap-icon://overflow"}).addStyleClass("sapMPointer").addStyleClass(t+"MoreIcon");this._oRemoveButton=this._oRemoveButton||new B({id:this.getId()+"-action-remove",icon:"sap-icon://decline",tooltip:this._oRb.getText("GENERICTILE_REMOVEBUTTON_TEXT")}).addStyleClass("sapUiSizeCompact").addStyleClass(t+"RemoveButton");this._oRemoveButton._bExcludeFromTabChain=true;break;default:}};
f.prototype.exit=function(){if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,e);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());this._$RootNode=null;}this._clearAnimationUpdateQueue();this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();if(this._oMoreIcon){this._oMoreIcon.destroy();}if(this._oRemoveButton){this._oRemoveButton.destroy();}};
f.prototype.onBeforeRendering=function(){var s=!!this.getSubheader();if(this.getMode()===l.GenericTileMode.HeaderMode){this._applyHeaderMode(s);}else{this._applyContentMode(s);}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setDisabled(this.getState()===l.LoadState.Disabled);}this._initScopeContent("sapMGT");this._generateFailedText();this.$().unbind("mouseenter",this._updateAriaAndTitle);this.$().unbind("mouseleave",this._removeTooltipFromControl);if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,e);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());}if(this.getFrameType()===l.FrameType.Auto){this.setProperty("frameType",l.FrameType.OneByOne,true);}};
f.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._updateAriaAndTitle.bind(this));this.$().bind("mouseleave",this._removeTooltipFromControl.bind(this));var m=this.getMode();if(m===l.GenericTileMode.LineMode&&this._isScreenLarge()){this.$().parent().addClass("sapMGTLineModeContainer");this._updateHoverStyle(true);if(this.getParent()instanceof C){this._sParentResizeListenerId=R.register(this.getParent(),this._handleResize.bind(this));}else{this._sParentResizeListenerId=R.register(this.$().parent(),this._handleResize.bind(this));}}if(m===l.GenericTileMode.LineMode&&this._bUpdateLineTileSiblings){this._updateLineTileSiblings();this._bUpdateLineTileSiblings=false;}if(m===l.GenericTileMode.LineMode){D.media.attachHandler(this._handleMediaChange,this,e);}};
f.prototype._handleResize=function(){if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&this.getParent()){this._queueAnimationEnd();}};
f.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};
f.prototype._calculateStyleData=function(){this.$("lineBreak").remove();if(!this._isScreenLarge()||!this.getDomRef()||this.$().is(":hidden")){return null;}var $=this.$(),E=this.$("endMarker"),s=this.$("startMarker");if(E.length===0||s.length===0){return null;}var g=this._getLineCount(),h,j,k=Math.ceil(L._getCSSPixelValue(this,"margin-top")),m,A=this.$().parent().innerWidth(),n=Math.ceil(L._getCSSPixelValue(this,"min-height")),o=L._getCSSPixelValue(this,"line-height"),p=this.$().is(":not(:first-child)")&&g>1,r=q("<span><br /></span>"),i=0,t=sap.ui.getCore().getConfiguration().getRTL(),u=E.position();if(p){r.attr("id",this.getId()+"-lineBreak");$.prepend(r);g=this._getLineCount();u=E.position();}var v={rtl:t,lineBreak:p,startOffset:s.offset(),endOffset:E.offset(),availableWidth:A,lines:[]};var w;if(D.browser.msie||D.browser.edge){w=r.find("br").position();}else{w=r.position();}var x=w;if(!(D.browser.mozilla||D.browser.msie||D.browser.edge)&&w.left<u.left){x=u;}v.positionLeft=p?w.left:$.position().left;v.positionRight=p?$.width()-x.left:v.availableWidth-$.position().left;if(!p&&g>1){v.positionRight=s.parent().innerWidth()-(s.position().left+s.width());}for(i;i<g;i++){if(p&&i===0){continue;}if(g===1){h=t?v.availableWidth-v.positionLeft:v.positionLeft;m=$.width();}else if(i===g-1){h=0;m=t?$.width()-u.left:u.left;}else if(p&&i===1){h=0;m=A;}else{h=0;m=A;}j=i*o+k;v.lines.push({offset:{x:h,y:j},width:m,height:n});}return v;};
f.prototype._getStyleData=function(){var s=this._calculateStyleData();if(!q.sap.equal(this._oStyleData,s)){delete this._oStyleData;this._oStyleData=s;return true;}return false;};
f.prototype._getAnimationEvents=function(){return"transitionend.sapMGT$id animationend.sapMGT$id".replace(/\$id/g,q.sap.camelCase(this.getId()));};
f.prototype._updateHoverStyle=function(g){if(!this._getStyleData()&&!g){return;}this._clearAnimationUpdateQueue();this._cHoverStyleUpdates=-1;this._oAnimationEndCallIds={};if(this._oStyleData&&this._oStyleData.lineBreak&&this.getUIArea()){this._$RootNode=q(this.getUIArea().getRootNode());this._$RootNode.on(this._getAnimationEvents(),this._queueAnimationEnd.bind(this));}this._queueAnimationEnd();};
f.prototype._queueAnimationEnd=function(E){if(E){var t=q(E.target);if(t.is(".sapMGT, .sapMGT *")){return false;}}if(typeof this._cHoverStyleUpdates!=="number"){this._cHoverStyleUpdates=-1;}if(!this._oAnimationEndCallIds){this._oAnimationEndCallIds={};}this._cHoverStyleUpdates++;this._oAnimationEndCallIds[this._cHoverStyleUpdates]=q.sap.delayedCall(10,this,this._handleAnimationEnd,[this._cHoverStyleUpdates]);};
f.prototype._handleAnimationEnd=function(h){delete this._oAnimationEndCallIds[h];if(this._cHoverStyleUpdates===h){this._getStyleData();L._updateHoverStyle.call(this);}};
f.prototype._clearAnimationUpdateQueue=function(){for(var k in this._oAnimationEndCallIds){q.sap.clearDelayedCall(this._oAnimationEndCallIds[k]);delete this._oAnimationEndCallIds[k];}};
f.prototype._getLineCount=function(){var o=this.getDomRef().getBoundingClientRect(),g=L._getCSSPixelValue(this,"line-height");return Math.round(o.height/g);};
f.prototype.getBoundingRects=function(){var p=this.$().offset();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()){this._getStyleData();var r=[],s,o;this.$().find(".sapMGTLineStyleHelper").each(function(){s=q(this);o=s.offset();r.push({offset:{x:o.left,y:o.top},width:s.width(),height:s.height()});});return r;}else{return[{offset:{x:p.left,y:p.top},width:this.$().width(),height:this.$().height()}];}};
f.prototype._updateLineTileSiblings=function(){var p=this.getParent();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&p){var i=p.indexOfAggregation(this.sParentAggregationName,this);var s=p.getAggregation(this.sParentAggregationName).splice(i+1);for(i=0;i<s.length;i++){var o=s[i];if(o instanceof l.GenericTile&&o.getMode()===l.GenericTileMode.LineMode){o._updateHoverStyle();}}}};
f.prototype.ontouchstart=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.addStyleClass("sapMGTLineModePress");}if(D.browser.internet_explorer&&this.getState()!==l.LoadState.Disabled){this.$().focus();}};
f.prototype.ontouchcancel=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}};
f.prototype.ontouchend=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.removeStyleClass("sapMGTLineModePress");}if(D.browser.internet_explorer&&this.getState()!==l.LoadState.Disabled){this.$().focus();}};
f.prototype.ontap=function(g){var p;if(this._bTilePress&&this.getState()!==l.LoadState.Disabled){this.$().focus();p=this._getEventParams(g);this.firePress(p);g.preventDefault();}};
f.prototype.onkeydown=function(g){if(q.sap.PseudoEvents.sapselect.fnCheck(g)&&this.getState()!==l.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}g.preventDefault();}};
f.prototype._updateAriaLabel=function(){var A=this._getAriaText(),t=this.$(),i=false;if(t.attr("aria-label")!==A){t.attr("aria-label",A);i=true;}return i;};
f.prototype.onkeyup=function(g){var p,h=false,s=this.getScope(),A=s===l.GenericTileScope.Actions;if(A&&(q.sap.PseudoEvents.sapdelete.fnCheck(g)||q.sap.PseudoEvents.sapbackspace.fnCheck(g))){p={scope:s,action:f._Action.Remove,domRef:this._oRemoveButton.getPopupAnchorDomRef()};h=true;}if(q.sap.PseudoEvents.sapselect.fnCheck(g)&&this.getState()!==l.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}p=this._getEventParams(g);h=true;}if(h){this.firePress(p);g.preventDefault();}this._updateAriaLabel();};
f.prototype.setProperty=function(p){C.prototype.setProperty.apply(this,arguments);if(this.getMode()===l.GenericTileMode.LineMode&&f.LINEMODE_SIBLING_PROPERTIES.indexOf(p)!==-1){this._bUpdateLineTileSiblings=true;}return this;};
f.prototype.getHeader=function(){return this._oTitle.getText();};
f.prototype.setHeader=function(t){this._oTitle.setText(t);return this;};
f.prototype.setHeaderImage=function(u){var v=!q.sap.equal(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=a.createControlByURI({id:this.getId()+"-icon-image",src:u},l.Image);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};
f.prototype._applyHeaderMode=function(s){if(s){this._oTitle.setMaxLines(4);}else{this._oTitle.setMaxLines(5);}this._changeTileContentContentVisibility(false);};
f.prototype._applyContentMode=function(s){if(s){this._oTitle.setMaxLines(2);}else{this._oTitle.setMaxLines(3);}this._changeTileContentContentVisibility(true);};
f.prototype._changeTileContentContentVisibility=function(v){var t;t=this.getTileContent();for(var i=0;i<t.length;i++){t[i].setRenderContent(v);}};
f.prototype._getHeaderAriaAndTooltipText=function(){var t="";var i=true;if(this.getHeader()){t+=this.getHeader();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){t+=(i?"":"\n")+this.getImageDescription();}return t;};
f.prototype._getContentAriaAndTooltipText=function(){var t="";var g=true;var h=this.getTileContent();for(var i=0;i<h.length;i++){if(q.isFunction(h[i]._getAriaAndTooltipText)){t+=(g?"":"\n")+h[i]._getAriaAndTooltipText();}else if(h[i].getTooltip_AsString()){t+=(g?"":"\n")+h[i].getTooltip_AsString();}g=false;}return t;};
f.prototype._getAriaAndTooltipText=function(){var A=(this.getTooltip_AsString()&&!this._isTooltipSuppressed())?this.getTooltip_AsString():(this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText());switch(this.getState()){case l.LoadState.Disabled:return"";case l.LoadState.Loading:return A+"\n"+this._sLoading;case l.LoadState.Failed:return A+"\n"+this._oFailedText.getText();default:if(q.trim(A).length===0){return"";}else{return A;}}};
f.prototype._getAriaText=function(){var A=this.getTooltip_Text();var s=this.getAriaLabel();if(!A||this._isTooltipSuppressed()){A=this._getAriaAndTooltipText();}if(this.getScope()===l.GenericTileScope.Actions){A=this._oRb.getText("GENERICTILE_ACTIONS_ARIA_TEXT")+" "+A;}if(s){A=s+" "+A;}return A;};
f.prototype._getTooltipText=function(){var t=this.getTooltip_Text();if(this._isTooltipSuppressed()===true){t=null;}return t;};
f.prototype._checkFooter=function(t,g){var s=g.getState();var A=this.getScope()===l.GenericTileScope.Actions||this._bShowActionsView===true;if(s===l.LoadState.Failed||A&&s!==l.LoadState.Disabled){t.setRenderFooter(false);}else{t.setRenderFooter(true);}};
f.prototype._generateFailedText=function(){var s=this.getFailedText();var g=s?s:this._sFailedToLoad;this._oFailedText.setText(g);this._oFailedText.setTooltip(g);};
f.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&t.length>0&&q.trim(t).length===0){return true;}else{return false;}};
f.prototype._isHeaderTextTruncated=function(){var o,m,h,w;if(this.getMode()===l.GenericTileMode.LineMode){h=this.$("hdr-text");if(h.length>0){w=Math.ceil(h[0].getBoundingClientRect().width);return(h[0]&&w<h[0].scrollWidth);}else{return false;}}else{o=this.getAggregation("_titleText").getDomRef("inner");m=this.getAggregation("_titleText").getClampHeight(o);return(m<o.scrollHeight);}};
f.prototype._isSubheaderTextTruncated=function(){var s=this.$("subHdr-text"),w;if(s.length>0){w=Math.ceil(s[0].getBoundingClientRect().width);return(s[0]&&w<s[0].scrollWidth);}else{return false;}};
f.prototype._setTooltipFromControl=function(){var o,t="";var g=true;var h=this.getTileContent();if(this._isHeaderTextTruncated()){t=this._oTitle.getText();g=false;}if(this._isSubheaderTextTruncated()){t+=(g?"":"\n")+this.getSubheader();g=false;}if(this.getScope()!==l.GenericTileScope.Actions){for(var i=0;i<h.length;i++){o=h[i].getContent();if(o&&o.getMetadata().getLibraryName()==="sap.suite.ui.microchart"){t+=(g?"":"\n")+o.getTooltip_AsString();}g=false;}}if(t&&!this._getTooltipText()&&!this._isTooltipSuppressed()){this.$().attr("title",t);this._bTooltipFromControl=true;}};
f.prototype._updateAriaAndTitle=function(){var A=this._getAriaAndTooltipText();var s=this._getAriaText();var t=this.$();if(t.attr("title")!==A){t.attr("aria-label",s);}if(this.getScope()===l.GenericTileScope.Actions){t.find('*:not(.sapMGTRemoveButton)').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");}else{t.find('*').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");}this._setTooltipFromControl();};
f.prototype._removeTooltipFromControl=function(){if(this._bTooltipFromControl){this.$().removeAttr("title");this._bTooltipFromControl=false;}};
f.prototype._isScreenLarge=function(){return this._getCurrentMediaContainerRange(e).name==="large";};
f.prototype._getEventParams=function(E){var p,A=f._Action.Press,s=this.getScope(),o=this.getDomRef();if(s===l.GenericTileScope.Actions&&E.target.id.indexOf("-action-remove")>-1){A=f._Action.Remove;o=this._oRemoveButton.getPopupAnchorDomRef();}else if(s===l.GenericTileScope.Actions){o=this._oMoreIcon.getDomRef();}p={scope:s,action:A,domRef:o};return p;};
f.prototype._handleMediaChange=function(){this._bUpdateLineTileSiblings=true;this.invalidate();};
f.prototype.setPressEnabled=function(v){this._bTilePress=v;};
f.prototype.showActionsView=function(v){if(this._bShowActionsView!==v){this._bShowActionsView=v;this.invalidate();}};
return f;});
sap.ui.predefine('sap/m/GenericTileLineModeRenderer',["sap/m/library","jquery.sap.global"],function(l,q){"use strict";var G=l.GenericTileScope;var L=l.LoadState;var a={};
a.render=function(r,c){var t=c._getTooltipText(),i=c._isScreenLarge(),A=c._getAriaText(),s=q.sap.encodeCSS("sapMGTScope"+c.getScope()),h=c.hasListeners("press");this._bRTL=sap.ui.getCore().getConfiguration().getRTL();r.write("<span");r.writeControlData(c);r.writeAttributeEscaped("aria-label",A);if(h){r.writeAttribute("role","button");}else{r.writeAttribute("role","presentation");}r.addClass("sapMGT");r.addClass(s);r.addClass("sapMGTLineMode");this._writeDirection(r);if(t){r.writeAttributeEscaped("title",t);}var S=c.getState();if(S!==L.Disabled){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}else{r.addClass("sapMGTDisabled");}if(S===L.Failed){r.addClass("sapMGTFailed");}r.writeClasses();r.write(">");if(i){r.write("<div");r.writeAttribute("id",c.getId()+"-startMarker");r.addClass("sapMGTStartMarker");r.writeClasses();r.write("/>");this._renderFailedIcon(r,c);this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("<div");r.writeAttribute("id",c.getId()+"-endMarker");r.addClass("sapMGTEndMarker");r.writeClasses();r.write(">");if(c.getScope()===G.Actions){this._renderActionsScope(r,c);}r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-styleHelper");r.addClass("sapMGTStyleHelper");r.writeClasses();r.write("/>");}else{if(c.getState()!==L.Disabled){this._renderFocusDiv(r,c);}r.write("<div");r.writeAttribute("id",c.getId()+"-touchArea");r.addClass("sapMGTTouchArea");r.writeClasses();r.write(">");this._renderFailedIcon(r,c);r.write("<span");r.writeAttribute("id",c.getId()+"-lineModeHelpContainer");r.addClass("sapMGTLineModeHelpContainer");r.writeClasses();r.write(">");this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("</span>");if(c.getScope()===G.Actions){this._renderActionsScope(r,c);}r.write("</div>");}r.write("</span>");};
a._writeDirection=function(r){if(this._bRTL){r.writeAttribute("dir","rtl");}};
a._renderFailedIcon=function(r,c){if(c.getState()===L.Failed){if(c._isCompact()){c._oWarningIcon.setSize("1.25rem");}else{c._oWarningIcon.setSize("1.375rem");}r.renderControl(c._oWarningIcon.addStyleClass("sapMGTLineModeFailedIcon"));}};
a._renderHeader=function(r,c){r.write("<span");this._writeDirection(r);r.addClass("sapMGTHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-hdr-text");r.write(">");r.writeEscaped(c._oTitle.getText());r.write("</span>");};
a._renderSubheader=function(r,c){r.write("<span");this._writeDirection(r);r.addClass("sapMGTSubHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-subHdr-text");r.write(">");r.writeEscaped(c.getSubheader());r.write("</span>");};
a._renderActionsScope=function(r,c){if(c.getState()!==L.Disabled){r.write("<span");r.writeAttribute("id",c.getId()+"-actions");r.addClass("sapMGTActionsContainer");r.writeClasses();r.write(">");r.renderControl(c._oMoreIcon);r.renderControl(c._oRemoveButton);r.write("</span>");}};
a._updateHoverStyle=function(){var s=this.$("styleHelper"),o,i=0,h="";s.empty();if(!this._oStyleData||this.$().is(":hidden")){return;}if(this._oStyleData.rtl){s.css("right",-this._oStyleData.positionRight);}else{s.css("left",-this._oStyleData.positionLeft);}for(i;i<this._oStyleData.lines.length;i++){o=this._oStyleData.lines[i];var r=q("<div class='sapMGTLineStyleHelper'><div class='sapMGTLineStyleHelperInner' /></div>");if(this._oStyleData.rtl){r.css("right",o.offset.x+"px");}else{r.css("left",o.offset.x+"px");}r.css({top:o.offset.y+"px",width:o.width+"px",height:o.height});h+=r.outerHTML();}s.html(h);};
a._renderFocusDiv=function(r,c){r.write("<div");r.writeAttribute("id",c.getId()+"-focus");r.addClass("sapMGTFocusDiv");r.writeClasses();r.write(">");r.write("</div>");};
a._getCSSPixelValue=function(o,p){var O=o instanceof q?o:o.$(),m=(O.css(p)||"").match(/([^a-zA-Z\%]*)(.*)/),v=parseFloat(m[1]),u=m[2];return(u==="px")?v:v*16;};
return a;},true);
sap.ui.predefine('sap/m/GenericTileRenderer',["sap/m/library","jquery.sap.global"],function(l,q){"use strict";var G=l.GenericTileMode;var a=l.GenericTileScope;var L=l.LoadState;var b={};
b.render=function(r,c){var t=c._getTooltipText();var A=c._getAriaText();var h=c.getHeaderImage();var H=c.hasListeners("press");var s=c.getState();var S=c.getScope();var d=q.sap.encodeCSS("sapMGTState"+s);var e=q.sap.encodeCSS("sapMGTScope"+S);r.write("<div");r.writeControlData(c);if(t){r.writeAttributeEscaped("title",t);}r.addClass("sapMGT");r.addClass(d);r.addClass(e);if(S!==a.Actions&&c._bShowActionsView){r.addClass("sapMGTScopeActions");}r.addClass(c.getFrameType());if(H){r.writeAttribute("role","button");}else{r.writeAttribute("role","presentation");}r.writeAttributeEscaped("aria-label",A);if(s!==L.Disabled){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}if(c.getBackgroundImage()){r.write(" style='background-image:url(");r.writeEscaped(c.getBackgroundImage());r.write(");'");r.addClass("sapMGTBackgroundImage");}if(c.getMode()===G.HeaderMode){r.addClass("sapMGTHeaderMode");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMGTHdrContent");r.addClass(c.getFrameType());if(t){r.writeAttributeEscaped("title",t);}r.writeClasses();r.write(">");if(h){r.renderControl(c._oImage);}this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("</div>");r.write("<div");r.addClass("sapMGTContent");r.writeClasses();r.writeAttribute("id",c.getId()+"-content");r.write(">");var T=c.getTileContent();var f=T.length;for(var i=0;i<f;i++){c._checkFooter(T[i],c);r.renderControl(T[i]);}r.write("</div>");if(s!==L.Loaded){this._renderStateOverlay(r,c,t);}if(s!==L.Disabled){this._renderHoverOverlay(r,c);this._renderFocusDiv(r,c);}if(S===a.Actions){this._renderActionsScope(r,c);}r.write("</div>");};
b._renderFocusDiv=function(r,c){r.write("<div");r.addClass("sapMGTFocusDiv");r.writeClasses();r.writeAttribute("id",c.getId()+"-focus");r.write(">");r.write("</div>");};
b._renderStateOverlay=function(r,c,t){var s=c.getState();r.write("<div");r.addClass("sapMGTOverlay");r.writeClasses();r.writeAttribute("id",c.getId()+"-overlay");if(t){r.writeAttributeEscaped("title",t);}r.write(">");switch(s){case L.Loading:c._oBusy.setBusy(s==L.Loading);r.renderControl(c._oBusy);break;case L.Failed:r.write("<div");r.writeAttribute("id",c.getId()+"-failed-ftr");r.addClass("sapMGenericTileFtrFld");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-failed-icon");r.addClass("sapMGenericTileFtrFldIcn");r.writeClasses();r.write(">");r.renderControl(c._oWarningIcon);r.write("</div>");if(c.getScope()!==a.Actions&&!c._bShowActionsView){r.write("<div");r.writeAttribute("id",c.getId()+"-failed-text");r.addClass("sapMGenericTileFtrFldTxt");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_failedMessageText"));r.write("</div>");}r.write("</div>");break;default:}r.write("</div>");};
b._renderActionsScope=function(r,c){if(c.getState()!==L.Disabled){r.renderControl(c._oRemoveButton);r.renderControl(c._oMoreIcon);}};
b._renderHoverOverlay=function(r,c){r.write("<div");if(c.getBackgroundImage()){r.addClass("sapMGTWithImageHoverOverlay");}else{r.addClass("sapMGTWithoutImageHoverOverlay");}r.writeClasses();r.writeAttribute("id",c.getId()+"-hover-overlay");r.write(">");r.write("</div>");};
b._renderHeader=function(r,c){r.write("<div");r.addClass("sapMGTHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-hdr-text");r.write(">");r.renderControl(c._oTitle);r.write("</div>");};
b._renderSubheader=function(r,c){r.write("<div");r.addClass("sapMGTSubHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-subHdr-text");r.write(">");r.writeEscaped(c.getSubheader());r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/m/GroupHeaderListItem',['./ListItemBase','./library','sap/ui/core/library','./GroupHeaderListItemRenderer'],function(L,l,c,G){"use strict";var a=l.ListMode;var T=c.TextDirection;
function i(o){var F=sap.ui.require('sap/m/Table');return typeof F==='function'&&(o instanceof F);}
var b=L.extend("sap.m.GroupHeaderListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},count:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}}}});
b.prototype.getMode=function(){return a.None;};
b.prototype.shouldClearLastValue=function(){return true;};
b.prototype.getTable=function(){var p=this.getParent();if(i(p)){return p;}if(p&&p.getMetadata().getName()=="sap.m.Table"){return p;}};
b.prototype.onBeforeRendering=function(){var p=this.getParent();if(i(p)){p.getColumns().forEach(function(C){C.clearLastValue();});this.TagName="tr";}};
b.prototype.getAccessibilityType=function(B){var t=this.getTable()?"ROW":"OPTION";return B.getText("LIST_ITEM_GROUP_HEADER")+" "+B.getText("ACC_CTR_TYPE_"+t);};
b.prototype.getContentAnnouncement=function(){return this.getTitle();};
b.prototype.getGroupAnnouncement=function(){};
return b;});
sap.ui.predefine('sap/m/GroupHeaderListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer','sap/ui/core/library'],function(L,R,c){"use strict";var T=c.TextDirection;var G=R.extend(L);
G.renderType=function(r,l){var t=l.getTable();t&&r.write('<td class="sapMListTblNavCol">');L.renderType.apply(this,arguments);t&&r.write('</td>');};
G.renderCounter=function(r,l){};
G.renderLIAttributes=function(r,l){r.addClass("sapMGHLI");if(l.getUpperCase()){r.addClass("sapMGHLIUpperCase");}};
G.renderLIContentWrapper=function(r,l){var t=l.getTable();if(t){r.write('<td class="sapMGHLICell"');r.writeAttribute("colspan",t.getColSpan());r.write(">");}L.renderLIContentWrapper.apply(this,arguments);if(t){r.write("</td>");}};
G.renderLIContent=function(r,l){var t=l.getTitleTextDirection();r.write("<span class='sapMGHLITitle'");if(t!=T.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");r.writeEscaped(l.getTitle());r.write("</span>");var C=l.getCount()||l.getCounter();if(C){r.write("<span class='sapMGHLICounter'>");r.writeEscaped(" ("+C+")");r.write("</span>");}};
G.addLegacyOutlineClass=function(r,l){if(!l.getTable()){L.addLegacyOutlineClass.apply(this,arguments);}};
G.getAriaRole=function(l){if(l.getTable()){return"row";}return L.getAriaRole.apply(this,arguments);};
return G;},true);
sap.ui.predefine('sap/m/GrowingEnablement',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/format/NumberFormat','sap/m/library','sap/ui/model/ChangeReason','sap/ui/base/ManagedObjectMetadata','sap/ui/core/HTML'],function(q,B,N,l,C,M,H){"use strict";var L=l.ListType;var a=l.ListGrowingDirection;
var G=B.extend("sap.m.GrowingEnablement",{
constructor:function(c){B.apply(this);this._oControl=c;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var r=this._oControl.getItems(true).length;this._iRenderedDataItems=r;this._iLimit=r;this._bLoading=false;this._sGroupingPath="";this._bDataRequested=false;this._oContainerDomRef=null;this._iLastItemsCount=0;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;},
destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null;}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(this._oRM){this._oRM.destroy();this._oRM=null;}this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oContainerDomRef=null;this._oControl=null;},
render:function(r){r.write("<div");r.addClass("sapMListUl");r.addClass("sapMGrowingList");r.writeAttribute("id",this._oControl.getId()+"-triggerList");r.addStyle("display","none");r.writeClasses();r.writeStyles();r.write(">");r.renderControl(this._getTrigger());r.write("</div>");},
onAfterRendering:function(){var c=this._oControl;if(c.getGrowingScrollToLoad()){var s=l.getScrollDelegate(c);if(s){this._oScrollDelegate=s;s.setGrowingList(this.onScrollToLoad.bind(this),c.getGrowingDirection());}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(!this._bLoading){this._updateTriggerDelayed(false);}},
setTriggerText:function(t){this._oControl.$("triggerText").text(t);},
reset:function(){this._iLimit=0;},
shouldReset:function(c){var m=C;return c==m.Sort||c==m.Filter||c==m.Context;},
getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems};},
onScrollToLoad:function(){if(!this._bLoading&&this._oControl.getGrowingDirection()==a.Upwards){var s=this._oScrollDelegate;this._oScrollPosition={left:s.getScrollLeft(),top:s.getScrollHeight()};}this.requestNewPage();},
requestNewPage:function(){if(!this._oControl||this._bLoading){return;}var b=this._oControl.getBinding("items");if(b&&!b.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){if(this._oControl.getMetadata().hasProperty("enableBusyIndicator")){this._bParentEnableBusyIndicator=this._oControl.getEnableBusyIndicator();this._oControl.setEnableBusyIndicator(false);}this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing");}},
_onBeforePageLoaded:function(c){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),c);},
_onAfterPageLoaded:function(c){this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),c);if(this._oControl.setEnableBusyIndicator){this._oControl.setEnableBusyIndicator(this._bParentEnableBusyIndicator);}},
_getTrigger:function(){var t=this._oControl.getId()+"-trigger",T=this._oControl.getGrowingTriggerText();T=T||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(T);return this._oTrigger;}this._oTrigger=new sap.m.CustomListItem({id:t,busyIndicatorDelay:0,type:L.Active,content:new H({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLITitleDiv sapMGrowingListTriggerText">'+'<span class="sapMSLITitle" id="'+t+'Text">'+q.sap.encodeHTML(T)+'</span>'+'</div>'+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'</div>'})}).setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addEventDelegate({onsapenter:function(e){this.requestNewPage();e.preventDefault();},onsapspace:function(e){this.requestNewPage();e.preventDefault();},onAfterRendering:function(e){this._oTrigger.$().attr({"tabindex":0,"role":"button","aria-labelledby":t+"Text"+" "+t+"Info"});}},this);this._oTrigger.getList=function(){};this._oTrigger.TagName="div";return this._oTrigger;},
_getListItemInfo:function(){this._iLastItemsCount=this._oControl.getItems(true).length;return("[ "+this._iRenderedDataItems+" / "+N.getFloatInstance().format(this._oControl.getMaxItemsCount())+" ]");},
_getGroupingPath:function(b){var s=b.aSorters||[];var S=s[0]||{};return(S.fnGroup)?S.sPath||"":"";},
_getDomIndex:function(i){if(typeof i!="number"){return i;}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return(i*2);}return i;},
_getHasScrollbars:function(){if(!this._oScrollDelegate){return false;}if(this._iRenderedDataItems>=40){return true;}return this._oScrollDelegate.getMaxScrollTop()>80;},
destroyListItems:function(s){this._oControl.destroyItems(s);this._iRenderedDataItems=0;this._aChunk=[];},
addListItem:function(c,b,s){var o=this._oControl,d=b.binding,i=this.createListItem(c,b);if(d.isGrouped()){var I=o.getItems(true),e=I[I.length-1],m=b.model,g=d.getGroup(i.getBindingContext(m));if(e&&e.isGroupHeader()){o.removeAggregation("items",e,true);this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,e,s);e=I[I.length-1];}if(!e||g.key!==d.getGroup(e.getBindingContext(m)).key){var f=(b.groupHeaderFactory)?b.groupHeaderFactory(g):null;if(o.getGrowingDirection()==a.Upwards){this.applyPendingGroupItem();this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,f,s);}else{this.appendGroupItem(g,f,s);}}}o.addAggregation("items",i,s);if(s){this._aChunk.push(i);}},
applyPendingGroupItem:function(){if(this._fnAppendGroupItem){this._fnAppendGroupItem();this._fnAppendGroupItem=undefined;}},
appendGroupItem:function(g,o,s){o=this._oControl.addItemGroup(g,o,s);if(s){this._aChunk.push(o);}},
createListItem:function(c,b){this._iRenderedDataItems++;var i=b.factory(M.uid("clone"),c);return i.setBindingContext(c,b.model);},
updateItemsBindingContext:function(b,m){if(!b.length){return;}var I=this._oControl.getItems(true);for(var i=0,c=0,o;i<I.length;i++){o=I[i];if(!o.isGroupHeader()){o.setBindingContext(b[c++],m);}}},
applyChunk:function(I,d){this.applyPendingGroupItem();var b=this._aChunk.length;if(!b){return;}if(this._oControl.getGrowingDirection()==a.Upwards){this._aChunk.reverse();if(I===true){I=0;}else if(typeof I=="number"){I=this._iRenderedDataItems-b-I;}}d=d||this._oContainerDomRef;this._oRM=this._oRM||sap.ui.getCore().createRenderManager();for(var i=0;i<b;i++){this._oRM.renderControl(this._aChunk[i]);}this._oRM.flush(d,false,this._getDomIndex(I));this._aChunk=[];},
addListItems:function(c,b,s){for(var i=0;i<c.length;i++){this.addListItem(c[i],b,s);}},
rebuildListItems:function(c,b,s){this.destroyListItems(s);this.addListItems(c,b,s);if(s){var h=this._oContainerDomRef.contains(document.activeElement);this.applyChunk(false);h&&this._oControl.focus();}else{this.applyPendingGroupItem();}},
insertListItem:function(c,b,i){var I=this.createListItem(c,b);this._oControl.insertAggregation("items",I,i,true);this._aChunk.push(I);},
deleteListItem:function(i){this._oControl.getItems(true)[i].destroy(true);this._iRenderedDataItems--;},
refreshItems:function(c){if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(c);}if(!this._iLimit||this.shouldReset(c)||!this._oControl.getItems(true).length){this._iLimit=this._oControl.getGrowingThreshold();}this._oControl.getBinding("items").getContexts(0,this._iLimit);},
updateItems:function(c){var o=this._oControl,b=o.getBinding("items"),d=o.getBindingInfo("items"),I=o.getItems(true);if(!this._iLimit||this.shouldReset(c)||!I.length){this._iLimit=o.getGrowingThreshold();}if(this._bDataRequested){this._bDataRequested=false;}else{this._onBeforePageLoaded(c);}var e=b.getContexts(0,this._iLimit)||[];if(e.dataRequested){this._bDataRequested=true;if(e.diff&&!e.diff.length){return;}}this._oContainerDomRef=o.getItemsContainerDomRef();var D=e.diff,f=false,v;if(!e.length){this.destroyListItems();}else if(!this._oContainerDomRef){this.rebuildListItems(e,d);}else if(!D||!I.length&&D.length){this.rebuildListItems(e,d,true);}else if(b.isGrouped()||o.checkGrowingFromScratch()){if(this._sGroupingPath!=this._getGroupingPath(b)){f=true;}else{for(var i=0;i<D.length;i++){var g=D[i],h=e[g.index];if(g.type=="delete"){f=true;break;}else if(g.index!=this._iRenderedDataItems){f=true;break;}else{this.addListItem(h,d,true);v=true;}}}}else{if(this._sGroupingPath){o.removeGroupHeaders(true);}v=-1;var j=-1;for(var i=0;i<D.length;i++){var g=D[i],k=g.index,h=e[k];if(g.type=="delete"){if(v!=-1){this.applyChunk(v);j=-1;v=-1;}this.deleteListItem(k);}else{if(v==-1){v=k;}else if(j>-1&&k!=j+1){this.applyChunk(v);v=k;}this.insertListItem(h,d,k);j=k;}}}if(f){this.rebuildListItems(e,d,true);}else if(this._oContainerDomRef&&D){this.updateItemsBindingContext(e,d.model);this.applyChunk(v);}this._oContainerDomRef=null;this._sGroupingPath=this._getGroupingPath(b);if(!this._bDataRequested){this._onAfterPageLoaded(c);}},
_updateTriggerDelayed:function(b){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&window.cancelAnimationFrame(this._iTriggerTimer);this._iTriggerTimer=window.requestAnimationFrame(this._updateTrigger.bind(this,b));}else{this._updateTrigger(b);}},
_updateTrigger:function(b){var t=this._oTrigger,c=this._oControl;if(!t||!c||!c.shouldRenderItems()||!c.getDomRef()){return;}var o=c.getBinding("items");if(!o){return;}t.setBusy(b);t.$().toggleClass("sapMGrowingListBusyIndicatorVisible",b);if(b){t.setActive(false);c.$("triggerList").css("display","");}else{var i=c.getItems(true),I=i.length,d=o.getLength()||0,e=o.isLengthFinal(),h=c.getGrowingScrollToLoad(),T=t.getDomRef();if(T&&T.contains(document.activeElement)){(i[this._iLastItemsCount]||c).focus();}if(!I||!this._iLimit||(e&&this._iLimit>=d)||(h&&this._getHasScrollbars())){c.$("triggerList").css("display","none");}else{if(e){c.$("triggerInfo").css("display","block").text(this._getListItemInfo());}t.$().removeClass("sapMGrowingListBusyIndicatorVisible");c.$("triggerList").css("display","");}if(h&&this._oScrollPosition===undefined&&c.getGrowingDirection()==a.Upwards){this._oScrollPosition={left:0,top:0};}if(I>0&&this._oScrollPosition){var s=this._oScrollDelegate,S=this._oScrollPosition;s.scrollTo(S.left,s.getScrollHeight()-S.top);this._oScrollPosition=null;}}}
});
return G;});
sap.ui.predefine('sap/m/GrowingList',['./List','./library','./GrowingListRenderer'],function(L,l,G){"use strict";
var a=L.extend("sap.m.GrowingList",{metadata:{deprecated:true,library:"sap.m",properties:{threshold:{type:"int",group:"Misc",defaultValue:20},triggerText:{type:"string",group:"Appearance",defaultValue:null},scrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false}}}});
a.prototype._isIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMGrowingList").compareTo("1.16")>=0;};
a.prototype.init=function(){L.prototype.init.call(this);if(!this._isIncompatible()){this.setGrowing();}};
a.prototype.setGrowing=function(){return L.prototype.setGrowing.call(this,true);};
!(function(g,o){["Threshold","TriggerText","ScrollToLoad"].forEach(function(p){g["set"+p]=o["setGrowing"+p];g["get"+p]=o["getGrowing"+p];});}(a.prototype,L.prototype));return a;});
sap.ui.predefine('sap/m/GrowingListRenderer',['jquery.sap.global','./ListRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var G=R.extend(L);
G.render=function(r,c){if(c._isIncompatible()){q.sap.log.warning("Does not render sap.m.GrowingList#"+c.getId()+" when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!");}else{L.render.call(this,r,c);}};
return G;},true);
sap.ui.predefine('sap/m/HBox',['./FlexBox','./library','./HBoxRenderer'],function(F,l,H){"use strict";
var a=F.extend("sap.m.HBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/HBox.designtime"}});
return a;});
sap.ui.predefine('sap/m/HBoxRenderer',['./FlexBoxRenderer'],function(F){"use strict";var H={};
H.render=function(r,c){F.render.apply(this,[r,c]);};
return H;},true);
sap.ui.predefine('sap/m/HeaderContainer',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ItemNavigation','sap/ui/core/library','sap/ui/base/ManagedObject','sap/ui/core/Icon','./HeaderContainerRenderer','jquery.sap.events'],function(q,l,C,D,I,c,M,a,H){"use strict";var O=c.Orientation;
var b=C.extend("sap.m.HeaderContainerItemContainer",{
metadata:{defaultAggregation:"item",aggregations:{item:{type:"sap.ui.core.Control",multiple:false}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMHdrCntrItemCntr");r.addClass("sapMHrdrCntrInner");r.writeClasses();r.write(">");r.renderControl(o.getAggregation("item"));r.write("</div>");}
});
var d=C.extend("sap.m.HeaderContainer",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{scrollStep:{type:"int",defaultValue:300,group:"Behavior"},scrollStepByItem:{type:"int",defaultValue:1,group:"Behavior"},scrollTime:{type:"int",defaultValue:500,group:"Behavior"},showOverflowItem:{type:"boolean",defaultValue:true,group:"Behavior"},showDividers:{type:"boolean",defaultValue:true,group:"Appearance"},orientation:{type:"sap.ui.core.Orientation",defaultValue:O.Horizontal,group:"Appearance"},backgroundDesign:{type:"sap.m.BackgroundDesign",defaultValue:l.BackgroundDesign.Transparent,group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_scrollContainer:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},_prevButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
d.prototype.init=function(){this._aItemEnd=[];this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oScrollCntr=new l.ScrollContainer(this.getId()+"-scrl-cntnr",{width:"100%",height:"100%",horizontal:!D.system.desktop});this.setAggregation("_scrollContainer",this._oScrollCntr,true);if(D.system.desktop){this._oArrowPrev=new l.Button({id:this.getId()+"-scrl-prev-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_PREV_SECTION"),press:function(e){e.cancelBubble();this._scroll(this._getScrollValue(false),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this._oArrowPrev._bExcludeFromTabChain=true;this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new l.Button({id:this.getId()+"-scrl-next-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_NEXT_SECTION"),press:function(e){e.cancelBubble();this._scroll(this._getScrollValue(true),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this._oArrowNext._bExcludeFromTabChain=true;this.setAggregation("_nextButton",this._oArrowNext,true);}else if(D.system.phone||D.system.tablet){this._oArrowPrev=new a({id:this.getId()+"-scrl-prev-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new a({id:this.getId()+"-scrl-next-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this.setAggregation("_nextButton",this._oArrowNext,true);}this._oScrollCntr.addDelegate({onAfterRendering:function(){if(D.system.desktop){var f=this._oScrollCntr.getDomRef("scroll");var F=this._oScrollCntr.$("scroll");var e=F.find(".sapMHrdrCntrInner").attr("tabindex","0");if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.BeforeFocus,this._handleBeforeFocus,this);if(D.browser.msie||D.browser.edge){this._oItemNavigation.attachEvent(I.Events.FocusAgain,this._handleFocusAgain,this);}}this._oItemNavigation.setRootDomRef(f);this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setTabIndex0();this._oItemNavigation.setCycling(false);}}.bind(this)});sap.ui.getCore().attachIntervalTimer(this._checkOverflow,this);};
d.prototype.onBeforeRendering=function(){if(!this.getHeight()){q.sap.log.warning("No height provided",this);}if(!this.getWidth()){q.sap.log.warning("No width provided",this);}if(D.system.desktop){this._oArrowPrev.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}else if(D.system.phone||D.system.tablet){this._oArrowPrev.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}};
d.prototype.onAfterRendering=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._checkOverflow();};
d.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);};
d.prototype.onsaptabnext=function(e){var f=this.$().find(":focusable");var t=f.index(e.target);var n=f.eq(t+1).get(0);var F=this._getParentCell(e.target);var T;if(n){T=this._getParentCell(n);}if((F&&T&&F.id!==T.id)||(n&&n.id===this.getId()+"-after")||(n&&n.id===this.getId()+"-scrl-prev-button")||(n&&n.id===this.getId()+"-scrl-next-button")){var L=f.last().get(0);if(L){this._bIgnoreFocusIn=true;L.focus();}}};
d.prototype.onsaptabprevious=function(e){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");var f=this.$().find(":focusable");var t=f.index(e.target);var p=f.eq(t-1).get(0);var F=this._getParentCell(e.target);var T;if(p){T=this._getParentCell(p);}if(!T||F&&F.id!==T.id){var s=this.$().attr("tabindex");this.$().attr("tabindex","0");this.$().focus();if(!s){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",s);}}};
d.prototype.setOrientation=function(v){this.setProperty("orientation",v);if(v===O.Horizontal&&!D.system.desktop){this._oScrollCntr.setHorizontal(true);this._oScrollCntr.setVertical(false);}else if(!D.system.desktop){this._oScrollCntr.setHorizontal(false);this._oScrollCntr.setVertical(true);}return this;};
d.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};
d.prototype.getAggregation=function(A,o,s){return this._callMethodInManagedObject("getAggregation",A,o,s);};
d.prototype.setAggregation=function(A,o,s){return this._callMethodInManagedObject("setAggregation",A,o,s);};
d.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};
d.prototype.insertAggregation=function(A,o,i,s){return this._callMethodInManagedObject("insertAggregation",A,o,i,s);};
d.prototype.addAggregation=function(A,o,s){return this._callMethodInManagedObject("addAggregation",A,o,s);};
d.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};
d.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};
d.prototype.destroyAggregation=function(A,s){return this._callMethodInManagedObject("destroyAggregation",A,s);};
d.prototype._setScrollInProcess=function(v){this.bScrollInProcess=v;};
d.prototype._scroll=function(i,e){this._setScrollInProcess(true);q.sap.delayedCall(e+300,this,this._setScrollInProcess,[false]);if(this.getOrientation()===O.Horizontal){this._hScroll(i,e);}else{this._vScroll(i,e);}};
d.prototype._vScroll=function(e,f){var o=this._oScrollCntr.getDomRef(),s=o.scrollTop,S=o.scrollHeight,i=s+e,g=o.clientHeight,p=parseFloat(this.$("scroll-area").css("padding-top")),r;if(i<=0){r=this._calculateRemainingScrolling(e,f,s);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrTopPadding");}else if(i+g+p>=S){r=this._calculateRemainingScrolling(e,f,S-g-s);this.$("scroll-area").css("transition","padding "+r+"s");if(g+e>S&&g!==S){this.$().removeClass("sapMHrdrBottomPadding");this.$().addClass("sapMHrdrTopPadding");}else{this.$().removeClass("sapMHrdrBottomPadding");}}else{this.$("scroll-area").css("transition","padding "+f/1000+"s");}this._oScrollCntr.scrollTo(0,i,f);};
d.prototype._hScroll=function(e,f){var o=this._oScrollCntr.getDomRef();var s,S,i,g,p,r;if(!this._bRtl){S=o.scrollLeft;g=o.scrollWidth;i=o.clientWidth+(D.browser.msie?1:0);s=S+e;p=parseFloat(this.$("scroll-area").css("padding-left"));if(s<=0){r=this._calculateRemainingScrolling(e,f,S);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrLeftPadding");}else if(s+o.clientWidth+p>=g){r=this._calculateRemainingScrolling(e,f,g-i-S);this.$("scroll-area").css("transition","padding "+r+"s");if(i+e>g&&i!==g){this.$().removeClass("sapMHrdrRightPadding");this.$().addClass("sapMHrdrLeftPadding");}else{this.$().removeClass("sapMHrdrRightPadding");}}else{this.$("scroll-area").css("transition","padding "+f/1000+"s");}this._oScrollCntr.scrollTo(s,0,f);}else{s=q(o).scrollRightRTL()+e;this._oScrollCntr.scrollTo((s>0)?s:0,0,f);}};
d.prototype._collectItemSize=function(){var s=0,e=this.getContent(),f=this.getOrientation()===O.Horizontal?"outerWidth":"outerHeight";this._aItemEnd=[];e.forEach(function(o,i){s+=o.$().parent()[f](true);this._aItemEnd[i]=s;},this);};
d.prototype._getScrollValue=function(f){if(!this._oScrollCntr){return 0;}var h=this.getOrientation()===O.Horizontal,$=this._oScrollCntr.$(),e=this.$("prev-button-container"),g=this.$("next-button-container"),s=h?$[0].scrollLeft:$[0].scrollTop,j=this.getContent(),t=0,S=0,m;var G=function(k){var S=0,B=0;var o=10;if(this._bRtl&&h){if(!e.is(":visible")){B=e.width();}if(!g.is(":visible")){B=g.width();}}for(var i=0;i<j.length&&i<k;i++){S+=n(j[i]);}return S!==0?S+o-B:0;}.bind(this);var n=function(o){return h?o.$().parent().outerWidth(true):o.$().parent().outerHeight(true);};var E=function(){var S=this._getSize(true),o,A=0;for(var i=t;i<j.length;i++){if(!j[i].$().is(":visible")){o=n(j[i])+G(i)-S-s;for(var k=t;k<j.length&&k<i;k++){if(m+A>o){break;}t++;A+=n(j[k]);}m+=A;break;}}}.bind(this);if(this.getScrollStepByItem()>0){s=h&&this._bRtl?$.scrollRightRTL():s;for(var i=0;i<j.length;i++){S+=n(j[i]);if(S>=s){t=i;break;}}t=(f?1:-1)*this.getScrollStepByItem()+t;if(t<0){t=0;}if(t>=j.length){t=j.length-1;}m=G(t)-s;if(f&&!this.getShowOverflowItem()){E();}return m;}return f?this.getScrollStep():-this.getScrollStep();};
d.prototype._calculateRemainingScrolling=function(e,f,g){return Math.abs(g*f/(1000*e));};
d.prototype._checkOverflow=function(){if(this.getOrientation()===O.Horizontal){this._checkHOverflow();}else{this._checkVOverflow();}};
d.prototype._getFirstItemOffset=function(t){var $=this.getContent()[0]&&this.getContent()[0].$(),e=$&&$.parent(),f=e&&e[0]&&e[0][t];return f||0;};
d.prototype._checkVOverflow=function(){var B=this._oScrollCntr.getDomRef(),o,$;if(B){var f=this._getFirstItemOffset("offsetTop");var s=Math.ceil(B.scrollTop);var S=false;var e=false;var r=B.scrollHeight;var g=B.clientHeight;if(Math.abs(r-g)===1){r=g;}if(s>f){S=true;}if((r>g)&&(s+g<r)){e=true;}e=this._checkForOverflowItem(e);$=this.$("prev-button-container");o=$.is(":visible");if(o&&!S){$.hide();this.$().removeClass("sapMHrdrTopPadding");}if(!o&&S){$.show();this.$().addClass("sapMHrdrTopPadding");}$=this.$("next-button-container");var h=$.is(":visible");if(h&&!e){$.hide();this.$().removeClass("sapMHrdrBottomPadding");}if(!h&&e){$.show();this.$().addClass("sapMHrdrBottomPadding");}}};
d.prototype._checkHOverflow=function(){var B=this._oScrollCntr.getDomRef(),$;if(B){var f=this._getFirstItemOffset("offsetLeft");var s=Math.ceil(B.scrollLeft);var S=false;var e=false;var r=B.scrollWidth;var g=B.clientWidth;if(Math.abs(r-g)===1){r=g;}if(this._bRtl){var i=q(B).scrollLeftRTL();if(i>((D.browser.msie||D.browser.edge)?1:0)){e=true;}}else if(s>f){S=true;}if(r-5>g){if(this._bRtl){if(q(B).scrollRightRTL()>1){S=true;}}else if(s+g<r){e=true;}}$=this.$("prev-button-container");e=this._checkForOverflowItem(e);var o=$.is(":visible");if(o&&!S){$.hide();this.$().removeClass("sapMHrdrLeftPadding");}if(!o&&S){$.show();this.$().addClass("sapMHrdrLeftPadding");}$=this.$("next-button-container");var h=$.is(":visible");if(h&&!e){$.hide();this.$().removeClass("sapMHrdrRightPadding");}if(!h&&e){$.show();this.$().addClass("sapMHrdrRightPadding");}}};
d.prototype._getSize=function(A){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,e=this.$("next-button-container"),f=!e.is(":visible")&&A,F=h?"width":"height";return $[F]()-(f?e[F]():0);};
d.prototype._checkForOverflowItem=function(s){if(this._oScrollCntr&&!this.getShowOverflowItem()){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,S=!h?$[0].scrollTop:(this._bRtl?$.scrollRightRTL():$[0].scrollLeft),f=h?"width":"height",e=this._getSize(s),g=this.getContent();this._collectItemSize();this._aItemEnd.forEach(function(E,i){var j=g[i].$(),k=j.parent(),v=j.is(":visible");if(s&&E>S+e){if(i===0||this._aItemEnd[i-1]<=S){k.css(f,"auto");j.show();}else if(v){k[f](k[f]());j.hide();s=true;}}else{if(!v){k.css(f,"auto");j.show();}}},this);}return s;};
d.prototype._handleBorderReached=function(e){if(D.browser.msie&&this.bScrollInProcess){return;}var i=e.getParameter("index");if(i===0){this._scroll(this._getScrollValue(false),this.getScrollTime());}else if(i===this.getContent().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime());}};
d.prototype._handleFocusAgain=function(e){e.getParameter("event").preventDefault();};
d.prototype._handleBeforeFocus=function(e){var o=e.getParameter("event");if(q(o.target).hasClass("sapMHdrCntrItemCntr")||q(o.target).hasClass("sapMScrollContScroll")||q.sap.PseudoEvents.sapprevious.fnCheck(o)||q.sap.PseudoEvents.sapnext.fnCheck(o)){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");}else{this.$().find(".sapMHdrCntrItemCntr").css("border-color","transparent");}};
d.prototype._unWrapHeaderContainerItemContainer=function(w){if(w instanceof b){w=w.getItem();}else if(q.isArray(w)){for(var i=0;i<w.length;i++){if(w[i]instanceof b){w[i]=w[i].getItem();}}}return w;};
d._AGGREGATION_FUNCTIONS=["validateAggregation","validateAggregation","getAggregation","setAggregation","indexOfAggregation","removeAggregation"];d._AGGREGATION_FUNCTIONS_FOR_INSERT=["insertAggregation","addAggregation"];
d.prototype._callMethodInManagedObject=function(f,A){var e=Array.prototype.slice.call(arguments);if(A==="content"){var o=e[2];e[1]="content";if(o instanceof C){if(q.inArray(f,d._AGGREGATION_FUNCTIONS)>-1&&o.getParent()instanceof b){e[2]=o.getParent();}else if(q.inArray(f,d._AGGREGATION_FUNCTIONS_FOR_INSERT)>-1){e[2]=new b({item:o});}}return this._unWrapHeaderContainerItemContainer(this._oScrollCntr[f].apply(this._oScrollCntr,e.slice(1)));}else{return M.prototype[f].apply(this,e.slice(1));}};
d.prototype._getParentCell=function(o){return q(o).parents(".sapMHrdrCntrInner").andSelf(".sapMHrdrCntrInner").get(0);};
d.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;return;}if(e.target.id===this.getId()+"-after"){this._restoreLastFocused();}};
d.prototype._restoreLastFocused=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var L=this._oItemNavigation.getFocusedIndex();var $=q(n[L]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");t.eq(-1).add($).eq(-1).focus();};
return d;});
sap.ui.predefine('sap/m/HeaderContainerRenderer',['jquery.sap.global','sap/ui/core/library'],function(q,c){"use strict";var O=c.Orientation;var H={};
H.render=function(r,C){var t=C.getTooltip_AsString();var o=C.getOrientation();if(o){o=q.sap.encodeCSS(o);}var b=q.sap.encodeCSS("sapMHdrCntrBG"+C.getBackgroundDesign());r.write("<div");r.writeControlData(C);if(t&&(typeof t==="string")){r.writeAttributeEscaped("title",t);}r.addClass("sapMHdrCntr");r.addClass(o);if(C.getShowDividers()){r.addClass("sapMHrdrCntrDvdrs");}r.writeClasses();if(C.getHeight()){r.addStyle("height",C.getHeight());}else{r.addStyle("height",(C.getOrientation()===O.Horizontal)?"auto":"100%");}if(C.getWidth()){r.addStyle("width",C.getWidth());}else{r.addStyle("width",(C.getOrientation()===O.Horizontal)?"100%":"auto");}r.writeStyles();var d="";var a=C.getContent();for(var i=0;a&&i<a.length;i++){d+=a[i].getId()+" ";}r.writeAttribute("aria-labelledby",d);r.write(">");r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-scroll-area");r.addClass("sapMHdrCntrCntr");r.addClass(o);r.addClass(b);r.writeClasses();r.write(">");r.renderControl(C.getAggregation("_scrollContainer"));r.write("</div>");var B=C.getAggregation("_prevButton");if(B){r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-prev-button-container");r.addClass("sapMHdrCntrBtnCntr");r.addClass("sapMHdrCntrLeft");r.addClass(o);r.writeClasses();r.write(">");r.renderControl(B);r.write("</div>");}B=C.getAggregation("_nextButton");if(B){r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-next-button-container");r.addClass("sapMHdrCntrBtnCntr");r.addClass("sapMHdrCntrRight");r.addClass(o);r.writeClasses();r.write(">");r.renderControl(B);r.write("</div>");}r.write("<div");r.writeAttribute("id",C.getId()+"-after");r.writeAttribute("tabindex","0");r.write("/>");r.write("</div>");};
return H;},true);
sap.ui.predefine('sap/m/IconTabBar',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/base/ManagedObject','./IconTabBarRenderer'],function(q,l,C,M,I){"use strict";var a=l.IconTabHeaderMode;var B=l.BackgroundDesign;
var b=C.extend("sap.m.IconTabBar",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},stretchContentHeight:{type:"boolean",group:"Appearance",defaultValue:false},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid},headerMode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:a.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},headerBackgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",forwarding:{getter:"_getIconTabHeader",aggregation:"items",forwardBinding:true}},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_header:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},selectedItem:{type:"sap.m.IconTabFilter"},selectedKey:{type:"string"}}},expand:{parameters:{expand:{type:"boolean"},collapse:{type:"boolean"}}}},designtime:"sap/m/designtime/IconTabBar.designtime"}});
b.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments);var i=this._getIconTabHeader();c.setAggregation("_header",i.clone(),true);return c;};
b.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);if(this.$().length){this._toggleExpandCollapse(e);}return this;};
b.prototype.setExpandable=function(e){this.setProperty("expandable",e,true);return this;};
b.prototype.setHeaderMode=function(m){this.setProperty("headerMode",m,true);this._getIconTabHeader().setMode(m);return this;};
b.prototype.setHeaderBackgroundDesign=function(h){this.setProperty("headerBackgroundDesign",h,true);this._getIconTabHeader().setBackgroundDesign(h);return this;};
b.prototype.setShowOverflowSelectList=function(v){this.setProperty("showOverflowSelectList",v,true);this._getIconTabHeader().setShowOverflowSelectList(v);return this;};
b.prototype.setEnableTabReordering=function(v){this.setProperty("enableTabReordering",v,true);this._getIconTabHeader().setEnableTabReordering(v);return this;};
b.prototype._rerenderContent=function(c){var $=this.$("content");if(c&&($.length>0)){var r=sap.ui.getCore().createRenderManager();for(var i=0;i<c.length;i++){r.renderControl(c[i]);}r.flush($[0]);r.destroy();}};
b.prototype._toggleExpandCollapse=function(e){var $=this.$("content");var s=this._getIconTabHeader().oSelectedItem;if(e===undefined){e=!this.getExpanded();}if(s){s.$().toggleClass("sapMITBSelected",e);s.$().attr({'aria-expanded':e});if(e){s.$().attr({'aria-selected':e});}else{s.$().removeAttr('aria-selected');}}this._iAnimationCounter=(this._iAnimationCounter===undefined?1:++this._iAnimationCounter);if(e){if(s){if(this.$("content").children().length===0){var S=s.getContent();if(S.length>0){this._rerenderContent(S);}else{this._rerenderContent(this.getContent());}}$.stop(true,true).slideDown('400',q.proxy(this.onTransitionEnded,this,e));this.$("containerContent").toggleClass("sapMITBContentClosed",!e);}}else{this.$("contentArrow").hide();$.stop(true,true).slideUp('400',q.proxy(this.onTransitionEnded,this,e));}if(!e||s){this.setProperty("expanded",e,true);}this.fireExpand({expand:e,collapse:!e});return this;};
b.prototype.onTransitionEnded=function(e){var $=this.$("content"),c=this.$("containerContent"),d=this.$("contentArrow");if(this._iAnimationCounter===1){c.toggleClass("sapMITBContentClosed",!e);if(e){d.show();$.css("display","block");}else{d.hide();$.css("display","none");}}this._iAnimationCounter=(this._iAnimationCounter>0?--this._iAnimationCounter:0);return this;};
b.prototype._getIconTabHeader=function(){var c=this.getAggregation("_header");if(!c){c=new sap.m.IconTabHeader(this.getId()+"--header",{});this.setAggregation("_header",c,true);}return c;};
b.prototype.setShowSelection=function(v){this._getIconTabHeader().setShowSelection(v);return this;};
b.prototype.getShowSelection=function(){return this._getIconTabHeader().getShowSelection();};
b.prototype.setSelectedKey=function(v){this._getIconTabHeader().setSelectedKey(v);return this;};
b.prototype.getSelectedKey=function(){return this._getIconTabHeader().getSelectedKey();};
b.prototype.setSelectedItem=function(i,A){return this._getIconTabHeader().setSelectedItem(i,A);};
return b;});
sap.ui.predefine('sap/m/IconTabBarDragAndDropUtil',[],function(){"use strict";var I={handleDrop:function(d,D,o){var b=this.indexOfItem(D),i=this.indexOfItem(o),$=D.$(),a=o.$(),A=0,r=sap.ui.getCore().getConfiguration().getRTL();if(r){if(d==="Before"){$.insertAfter(a);A=b<i?i:i+1;}else{$.insertBefore(a);A=b<i?i-1:i;}}else{if(d==="Before"){$.insertBefore(a);A=b<i?i-1:i;}else{$.insertAfter(a);A=b<i?i:i+1;}}I._handleConfigurationAfterDragAndDrop.call(this,D,A);},_updateAccessibilityInfo:function(){var i=this.getAggregation("items"),a=1,o;i.forEach(function(b){o=b.getDomRef();if(o&&o.getAttribute("aria-posinset")!==null){o.setAttribute("aria-posinset",a++);}});},_handleConfigurationAfterDragAndDrop:function(i,a){this.removeAggregation('items',i,true);this.insertAggregation('items',i,a,true);I._updateAccessibilityInfo.call(this);},moveItem:function(i,k){var $=i.$(),a=this.getAggregation("items"),b=this.indexOfItem(i),r=sap.ui.getCore().getConfiguration().getRTL(),n;switch(k){case 36:n=0;break;case 35:n=a.length-1;break;case 37:if(r){if(b===a.length-1){return;}n=b+1;}else{if(b===0){return;}n=b-1;}break;case 39:if(r){if(b===0){return;}n=b-1;}else{if(b===a.length-1){return;}n=b+1;}break;case 40:if(b===a.length-1){return;}n=b+1;break;case 38:if(b===0){return;}n=b-1;break;default:return;}var c=jQuery.sap.byId(a[n].sId);if(k===37||k===38||k===36){if(r&&k!==38){$.insertAfter(c);}else{$.insertBefore(c);}}else if(k===39||k===40||k===35){if(r&&k!==40){$.insertBefore(c);}else{$.insertAfter(c);}}I._handleConfigurationAfterDragAndDrop.call(this,i,n);return true;}};return I;});
sap.ui.predefine('sap/m/IconTabBarRenderer',[],function(){"use strict";var I={};I._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault'];
I.render=function(r,c){var C=c.getContent(),h=c._getIconTabHeader();r.write("<div ");r.writeControlData(c);r.addClass("sapMITB");if(c.getStretchContentHeight()){r.addClass("sapMITBStretch");}if(!c.getApplyContentPadding()){r.addClass("sapMITBNoContentPadding");}r.addClass("sapMITBBackgroundDesign"+c.getBackgroundDesign());r.writeClasses();r.write(">");if(!c._bHideHeader){r.renderControl(h);}r.write("<div id='"+c.getId()+"-containerContent' ");r.addClass("sapMITBContainerContent");if(!c.getExpanded()){r.addClass("sapMITBContentClosed");}r.writeClasses();r.write(">");r.write("<div id='"+c.getId()+"-content' class='sapMITBContent' role='tabpanel' ");if(!c.getExpanded()){r.write("style='display: none'");}r.write(">");if(c.getExpanded()){if(h.oSelectedItem&&h.oSelectedItem.getContent()){var o=h.oSelectedItem.getContent();if(o.length>0){C=o;}}if(C.length>0){for(var i=0;i<C.length;i++){r.renderControl(C[i]);}}}r.write("</div>");r.write("</div>");r.write("</div>");};
return I;},true);
sap.ui.predefine('sap/m/IconTabBarSelectList',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/dnd/DragDropInfo','./IconTabBarDragAndDropUtil','./IconTabBarSelectListRenderer'],function(q,l,C,I,D,a,b){"use strict";
var c=C.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTabFilter",multiple:true,singularName:"item"},dragDropConfig:{name:"dragDropConfig",type:"sap.ui.core.dnd.DragDropInfo",multiple:true}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}}});
c.prototype.init=function(){this._itemNavigation=new I();this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);};
c.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}};
c.prototype.onAfterRendering=function(){this._initItemNavigation();};
c.prototype.onBeforeRendering=function(){if(!this._iconTabHeader){return;}if(!this._iconTabHeader.getEnableTabReordering()&&this.getDragDropConfig().length){this.destroyDragDropConfig();}else if(this._iconTabHeader.getEnableTabReordering()&&!this.getDragDropConfig().length){var d=new D({sourceAggregation:"items",targetAggregation:"items",dropPosition:"Between",dragEnter:this._visualizeIndicator.bind(this),drop:this._handleDragAndDrop.bind(this)});this.addAggregation("dragDropConfig",d,true);}};
c.prototype._initItemNavigation=function(){var d,e=this.getItems(),f=[];for(var i=0;i<e.length;i++){d=e[i];f.push(d.getDomRef());}this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(f);};
c.prototype.getVisibleItems=function(){var d=this.getItems(),v=[],e;for(var i=0;i<d.length;i++){e=d[i];if(e.getVisible()){v.push(e);}}return v;};
c.prototype.setSelectedItem=function(i){if(this._selectedItem){this._deselectItem(this._selectedItem);}if(i){this._selectItem(i);}this._selectedItem=i;};
c.prototype.getSelectedItem=function(){return this._selectedItem;};
c.prototype._deselectItem=function(i){var $=i.$();if($){$.removeClass('sapMITBSelectItemSelected');$.removeAttr('aria-selected');}};
c.prototype._selectItem=function(i){var $=i.$();if($){$.addClass('sapMITBSelectItemSelected');$.attr('aria-selected',true);}};
c.prototype.ontap=function(e){var $=q(e.target);if(!$.hasClass('sapMITBSelectItem')){$=$.parent(".sapMITBSelectItem");}var s=sap.ui.getCore().byId($[0].id);if(s&&s.getEnabled()){e.preventDefault();if(s!=this.getSelectedItem()){this._selectItem(s);this.fireSelectionChange({selectedItem:s});}}if(this._iconTabHeader){this._iconTabHeader._closeOverflow();}};
c.prototype.onsapenter=c.prototype.ontap;c.prototype.onsapspace=c.prototype.ontap;
c.prototype.checkIconOnly=function(d){var e,f=d.length;for(var i=0;i<f;i++){e=d[i];if(e.getText()||e.getCount()){return false;}}return true;};
c.prototype._handleDragAndDrop=function(e){var d=e.getParameter("dropPosition"),o=e.getParameter("draggedControl"),f=e.getParameter("droppedControl");a.handleDrop.call(this._iconTabHeader,d,o._tabFilter,f._tabFilter);this._iconTabHeader._initItemNavigation();a.handleDrop.call(this,d,o,f);this._initItemNavigation();o.$().focus();};
c.prototype._visualizeIndicator=function(e){var i=e.getParameter("dragSession").getIndicator();if(i){i.style.zIndex=100;}};
c.prototype.ondragrearranging=function(e){if(!this._iconTabHeader.getEnableTabReordering()){return;}var t=sap.ui.getCore().byId(e.target.id),k=e.keyCode;a.moveItem.call(this,t,k);this._initItemNavigation();t.$().focus();this._iconTabHeader._moveTab(t._tabFilter,k);};
c.prototype.onsaphomemodifiers=c.prototype.ondragrearranging;c.prototype.onsapendmodifiers=c.prototype.ondragrearranging;c.prototype.onsapincreasemodifiers=c.prototype.ondragrearranging;c.prototype.onsapdecreasemodifiers=c.prototype.ondragrearranging;return c;});
sap.ui.predefine('sap/m/IconTabBarSelectListRenderer',[],function(){'use strict';var I={};
I.render=function(r,c){var i,a,b=c.getVisibleItems(),d=b.length,e=c._iconTabHeader,f=true;if(e){e._checkTextOnly(b);f=e._bTextOnly;c._bIconOnly=c.checkIconOnly(b);}r.write('<ul');r.writeAttribute('role','listbox');r.writeControlData(c);r.addClass('sapMITBSelectList');if(f){r.addClass('sapMITBSelectListTextOnly');}r.writeClasses();r.write('>');for(i=0;i<d;i++){a=b[i];a.renderInSelectList(r,c,i,d);}r.write('</ul>');};
return I;},true);
sap.ui.predefine('sap/m/IconTabFilter',['./library','sap/ui/core/Item','sap/ui/core/Renderer','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/core/Control'],function(l,I,R,a,b,c,C){"use strict";var T=c.TextAlign;var d=c.TextDirection;var e=l.ImageHelper;var f=l.IconTabFilterDesign;var g=c.IconColor;
var h=I.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface"],library:"sap.m",designtime:"sap/m/designtime/IconTabFilter.designtime",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:g.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:f.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
h._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];
h.prototype._getImageControl=function(i,p,j){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(P.src){this._oImageControl=e.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,i,j);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};
h.prototype.exit=function(E){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,E);}if(this._invisibleText){this._invisibleText.destroy();this._invisibleText=null;}};
h.prototype.invalidate=function(){var i=this.getParent(),o,O;if(!i){return;}o=i.getParent();if(!(o instanceof sap.m.IconTabBar)){i.invalidate();return;}O=o.getParent();if(O instanceof sap.m.ObjectHeader){O.invalidate();}else{o.invalidate();}};
h.prototype.setProperty=function(p,v,s){switch(p){case'enabled':case'textDirection':case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(p)===v){return this;}C.prototype.setProperty.call(this,p,v,true);if(!s){var i=this.getParent();if(i instanceof sap.m.IconTabHeader){i.invalidate();}}break;default:C.prototype.setProperty.apply(this,arguments);break;}return this;};
h.prototype._getNonEmptyKey=function(){var k=this.getKey();if(k){return k;}return this.getId();};
h.prototype.render=function(r,v,i){var t=this;if(!t.getVisible()){return;}var j=this.getParent(),k=j.getParent(),m=k instanceof sap.m.IconTabBar,n=sap.ui.getCore().getLibraryResourceBundle('sap.m'),o='role="tab"',p=t.getId(),q=t.getCount(),s=t.getText(),u=t.getIcon(),w=t.getDesign(),x=t.getIconColor(),y=x==='Positive'||x==='Critical'||x==='Negative',z=w===f.Horizontal,A=m&&k.getUpperCase(),B=j._bTextOnly,D=j._bInLine||j.isInlineMode();if(m){o+=' aria-controls="'+k.sId+'-content" ';}if(s.length||q!==''||u){o+='aria-labelledby="';var E=[];if(s.length){E.push(p+'-text');}if(q!==''){E.push(p+'-count');}if(u){E.push(p+'-icon');}if(y){E.push(p+'-iconColor');}o+=E.join(' ');o+='"';}r.write('<div '+o+' ');if(v!==undefined&&i!==undefined){r.writeAccessibilityState({posinset:v+1,setsize:i});}r.writeElementData(t);r.addClass('sapMITBItem');if(!q){r.addClass('sapMITBItemNoCount');}if(z){r.addClass('sapMITBHorizontal');}else{r.addClass('sapMITBVertical');}if(t.getShowAll()){r.addClass('sapMITBAll');}else{r.addClass('sapMITBFilter');r.addClass('sapMITBFilter'+x);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.writeAttribute('aria-selected',false);var F=t.getTooltip_AsString();if(F){r.writeAttributeEscaped('title',F);}r.writeClasses();r.write('>');if(!D){r.write('<div id="'+p+'-tab" class="sapMITBTab">');if(!t.getShowAll()||!u){if(y){r.write('<div id="'+p+'-iconColor" style="display: none;">'+n.getText('ICONTABBAR_ICONCOLOR_'+x.toUpperCase())+'</div>');}r.renderControl(t._getImageControl(['sapMITBFilterIcon','sapMITBFilter'+x],j,h._aAllIconColors));}if(!t.getShowAll()&&!u&&!B){r.write('<span class="sapMITBFilterNoIcon"> </span>');}if(z&&!t.getShowAll()){r.write('</div>');r.write('<div class="sapMITBHorizontalWrapper">');}r.write('<span id="'+p+'-count" ');r.addClass('sapMITBCount');r.writeClasses();r.write('>');if(q===''&&z){r.write('&nbsp;');}else{r.writeEscaped(q);}r.write('</span>');if(!z){r.write('</div>');}}if(s.length){r.write('<div id="'+p+'-text" ');r.addClass('sapMITBText');if(A){r.addClass('sapMITBTextUpperCase');}if(D){r.writeAttribute('dir','ltr');}r.writeClasses();r.write('>');r.writeEscaped(j._getDisplayText(t));r.write('</div>');}if(!D&&z){r.write('</div>');}r.write('<div class="sapMITBContentArrow"></div>');r.write('</div>');};
h.prototype.renderInSelectList=function(r,s,v,i){var t=this;if(this._invisibleText){this._invisibleText.destroy();this._invisibleText=null;}if(!t.getVisible()){return;}var j=true,k,m=s._iconTabHeader,n=sap.ui.getCore().getLibraryResourceBundle('sap.m');if(m){j=m._bTextOnly;k=s._bIconOnly;}r.write('<li');r.writeElementData(t);r.writeAttribute('tabindex','-1');r.writeAttribute('role','option');if(v!==undefined&&i!==undefined){r.writeAttribute('aria-posinset',v+1);r.writeAttribute('aria-setsize',i);}var o=t.getTooltip_AsString();if(o){r.writeAttributeEscaped('title',o);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.addClass('sapMITBSelectItem');if(s.getSelectedItem()==t){r.addClass('sapMITBSelectItemSelected');r.writeAttribute('aria-selected',true);}var p=t.getIconColor();r.addClass('sapMITBFilter'+p);r.writeClasses();var q=t.getId(),u=p=='Positive'||p=='Critical'||p=='Negative';var w=' aria-labelledby="';if(!k){w+=q+'-text ';}if(!j&&t.getIcon()){w+=q+'-icon ';}if(u){this._invisibleText=new b({text:n.getText('ICONTABBAR_ICONCOLOR_'+p.toUpperCase())});w+=this._invisibleText.getId();}w+='"';r.write(w+'>');if(this._invisibleText){r.renderControl(this._invisibleText);}if(!j){this._renderIcon(r);}if(!k){this._renderText(r);}r.write('</li>');};
h.prototype._renderIcon=function(r){var i=this.getIcon();if(i){var j=a.getIconInfo(i);var k=['sapMITBSelectItemIcon'];if(j&&!j.suppressMirroring){k.push('sapUiIconMirrorInRTL');}r.writeIcon(i,k,{id:this.getId()+'-icon','aria-hidden':true});}else{r.write('<span class="sapUiIcon"></span>');}};
h.prototype._renderText=function(r){var t=this.getText(),i=this.getCount(),j=sap.ui.getCore().getConfiguration().getRTL(),k=this.getTextDirection();r.write('<span');r.writeAttribute('id',this.getId()+'-text');r.writeAttribute('dir','ltr');r.addClass('sapMText');r.addClass('sapMTextNoWrap');r.addClass('sapMITBText');r.writeClasses();if(k!==d.Inherit){r.writeAttribute('dir',k.toLowerCase());}var m=R.getTextAlign(T.Begin,k);if(m){r.addStyle('text-align',m);r.writeStyles();}if(i){if(j){t='('+i+') '+t;}else{t+=' ('+i+')';}}r.write('>');r.writeEscaped(t);r.write('</span>');};
return h;});
sap.ui.predefine('sap/m/IconTabHeader',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/IconPool','sap/ui/core/delegate/ScrollEnablement','./IconTabBarSelectList','./Button','./ResponsivePopover','./IconTabFilter','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Icon','sap/ui/core/dnd/DragDropInfo','./IconTabBarDragAndDropUtil','./IconTabHeaderRenderer'],function(q,l,C,E,I,a,S,b,B,R,c,D,d,e,f,g,h){"use strict";var t=l.touch;var j=l.ImageHelper;var P=l.PlacementType;var k=l.ButtonType;var m=l.BackgroundDesign;var n=l.IconTabHeaderMode;
var o=C.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:n.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:m.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item"},dragDropConfig:{name:"dragDropConfig",type:"sap.ui.core.dnd.DragDropInfo",multiple:true}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});
E.apply(o.prototype,[true]);o.SCROLL_STEP=264;
o.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iCurrentScrollLeft=0;this.startScrollX=0;this.startTouchX=0;this._scrollable=null;this._aTabKeys=[];this._oItemNavigation=new I().setCycling(false);this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._oScroller=new S(this,this.getId()+"-head",{horizontal:true,vertical:false,nonTouchScrolling:true});};
o.prototype.isTouchScrollingDisabled=function(){return this.getShowOverflowSelectList()&&this.getParent().getMetadata().getName()=='sap.tnt.ToolHeader';};
o.prototype._getSelectList=function(){var i=this;if(!this._oSelectList){this._oSelectList=new b({selectionChange:function(p){var T=p.getParameter('selectedItem');i.setSelectedItem(T._tabFilter);}});this._oSelectList._iconTabHeader=this;}return this._oSelectList;};
o.prototype._getOverflowButton=function(){if(!this._oOverflowButton){this._oOverflowButton=new B({id:this.getId()+'-overflow',icon:"sap-icon://overflow",type:k.Transparent,press:this._overflowButtonPress.bind(this)});}return this._oOverflowButton;};
o.prototype._overflowButtonPress=function(i){if(!this._oPopover){this._oPopover=new R({showArrow:false,showHeader:false,placement:P.Vertical,offsetX:0,offsetY:0}).addStyleClass('sapMITBPopover');if(D.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}this.addDependent(this._oPopover);}var s=this._getSelectList();this._setSelectListItems();this._oPopover.removeAllContent();this._oPopover.addContent(s);this._oPopover.setInitialFocus(s.getSelectedItem());this._oPopover.openBy(this._getOverflowButton());};
o.prototype._createPopoverCloseButton=function(){var i=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("SELECT_CANCEL_BUTTON"),press:function(){i._closeOverflow();}});};
o.prototype._closeOverflow=function(){if(!D.system.desktop){this._oPopover.close();}if(this.oSelectedItem){this.oSelectedItem.$().focus();}};
o.prototype._setSelectListItems=function(){if(!this.getShowOverflowSelectList()){return;}var s,T,p=this._getSelectList(),r=this.getTabFilters();p.destroyItems();for(var i=0;i<r.length;i++){T=r[i];s=T.clone();s._tabFilter=T;p.addItem(s);if(T==this.oSelectedItem){p.setSelectedItem(s);}}};
o.prototype._findSelectItem=function(T){var s=this._getSelectList(),p=s.getItems(),r;for(var i=0;i<p.length;i++){r=p[i];if(r._tabFilter==T){return r;}}};
o.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var p=this.getItems();var r=-1;var s;for(var i=0;i<p.length;i++){s=p[i];if(s instanceof c==false){continue;}r++;if(this.oSelectedItem==s){break;}}this._oItemNavigation.setFocusedIndex(r);};
o.prototype._onItemNavigationAfterFocus=function(i){var H=this.getDomRef("head"),p=i.getParameter("index"),$=i.getParameter('event');if($.keyCode===undefined){return;}this._iCurrentScrollLeft=H.scrollLeft;this._checkOverflow();if(p!==null&&p!==undefined){this._scrollIntoView(this.getTabFilters()[p],0);}};
o.prototype.getTabFilters=function(){var i=this.getItems();var T=[];i.forEach(function(p){if(p instanceof c){T.push(p);}});return T;};
o.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oOverflowButton){this._oOverflowButton.destroy();this._oOverflowButton=null;}};
o.prototype.onBeforeRendering=function(){var p=this.getItems(),s=this.getSelectedKey(),i=0,r=this.getParent(),u=r instanceof sap.m.IconTabBar,v=r&&r.getMetadata().getName()=='sap.tnt.ToolHeader';this._bRtl=sap.ui.getCore().getConfiguration().getRTL();if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(p.length>0){if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){for(;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i]._getNonEmptyKey()===s){this.oSelectedItem=p[i];break;}}}if(!this.oSelectedItem&&(u||!s)){for(i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i].getVisible()){this.oSelectedItem=p[i];break;}}}}if(!v&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i].getVisible()){this.oSelectedItem=p[i];break;}}}if(this.oSelectedItem){this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);}}this._isTouchScrollingDisabled=this.isTouchScrollingDisabled();this._oScroller.setHorizontal(!this._isTouchScrollingDisabled&&(!this.getEnableTabReordering()||!D.system.desktop));if(!this.getEnableTabReordering()&&this.getDragDropConfig().length){this.destroyDragDropConfig();}else if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){var w=new f({sourceAggregation:"items",targetAggregation:"items",dropPosition:"Between",dropLayout:"Horizontal",drop:this._handleDragAndDrop.bind(this)});this.addAggregation("dragDropConfig",w,true);}if(this._sResizeListenerNoFlexboxSupportId){d.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};
o.prototype.setSelectedKey=function(K){var p=this.getTabFilters(),i=0,r=this.getParent(),s=r instanceof sap.m.IconTabBar,u;if(p.length>0){K=K||p[0]._getNonEmptyKey();}if(this.$().length){for(;i<p.length;i++){if(p[i]._getNonEmptyKey()===K){this.setSelectedItem(p[i],true);u=true;break;}}if(!u&&!s&&K){this.setSelectedItem(null);}}this.setProperty("selectedKey",K,true);return this;};
o.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this.oSelectedItem.$().removeClass("sapMITBSelected");this.oSelectedItem=null;}return this;}if(!i.getEnabled()){return this;}if(this.getShowOverflowSelectList()){var s=this._findSelectItem(i);if(s){this._getSelectList().setSelectedItem(s);}}var p=this.getParent();var r=p instanceof sap.m.IconTabBar;var u=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){u=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&r&&p.getExpandable()||this.oSelectedItem!==i)){this.oSelectedItem.$().removeClass("sapMITBSelected").attr('aria-selected',false).removeAttr('aria-expanded');}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&r&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(r){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(!r){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}if(r&&(p.getExpandable()||p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});var v=this.oSelectedItem.getContent();if(v.length>0){p._rerenderContent(v);}else{if(!u){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}if(this.oSelectedItem.$().length>0){this._scrollIntoView(i,500);}else{this._scrollAfterRendering=true;}}this.oSelectedItem=i;var w=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",w,true);if(r){p.setProperty("selectedKey",w,true);}if(!A){if(r){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:w,item:this.oSelectedItem,key:w});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:w,item:this.oSelectedItem,key:w});}}return this;};
o.prototype.getVisibleTabFilters=function(){var p=this.getTabFilters(),v=[],r;for(var i=0;i<p.length;i++){r=p[i];if(r.getVisible()){v.push(r);}}return v;};
o.prototype._getFirstVisibleItem=function(p){for(var i=0;i<p.length;i++){if(p[i].getVisible()){return p[i];}}return null;};
o.prototype._initItemNavigation=function(){var i=this,H=this.getDomRef("head"),p=this.getItems(),T=[],s=-1;p.forEach(function(r){if(r instanceof c){var u=i.getFocusDomRef(r);q(u).attr("tabindex","-1");T.push(u);if(r===i.oSelectedItem){s=T.indexOf(u);}}});if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(H);this._oItemNavigation.setItemDomRefs(T);this._oItemNavigation.setSelectedIndex(s);};
o.prototype.onAfterRendering=function(){if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._afterIscroll,this),q.proxy(this._scrollPreparation,this));}var p=this.getParent();var i=p instanceof sap.m.IconTabBar;if(this.oSelectedItem&&(!i||i&&p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}q.sap.delayedCall(350,this,"_checkOverflow");if(this.oSelectedItem){this._scrollIntoView(this.oSelectedItem,500);}this._initItemNavigation();if(this.getShowOverflowSelectList()){this.$('overflow').attr('tabindex',-1);}this._sResizeListenerId=d.register(this.getDomRef(),q.proxy(this._fnResize,this));if(!q.support.newFlexBoxLayout&&i&&p.getStretchContentHeight()){this._sResizeListenerNoFlexboxSupportId=d.register(p.getDomRef(),q.proxy(this._fnResizeNoFlexboxSupport,this));this._fnResizeNoFlexboxSupport();}this._bCheckIfIntoView=true;};
o.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");};
o.prototype.addItem=function(i){if(!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();if(this._aTabKeys.indexOf(K)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+K+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(K);}this.addAggregation("items",i);};
o.prototype.insertItem=function(i,p){if(!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();if(this._aTabKeys.indexOf(K)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+K+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(K);}this.insertAggregation("items",i,p);};
o.prototype.removeAllItems=function(){this._aTabKeys=[];this.removeAllAggregation("items");};
o.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(K),1);}return i;};
o.prototype.updateAggregation=function(){this.oSelectedItem=null;return C.prototype.updateAggregation.apply(this,arguments);};
o.prototype.removeAggregation=function(A,O,s){var i=this.getTabFilters();var p=C.prototype.removeAggregation.apply(this,arguments);if(s){return p;}if(p&&p==this.oSelectedItem&&A=='items'){var r=q.inArray(p,i);i=this.getTabFilters();r=Math.max(0,Math.min(r,i.length-1));var u=i[r];if(u){this.setSelectedItem(u,true);}else{var v=this.getParent();if(v instanceof sap.m.IconTabBar&&v.getExpanded()){v.$("content").children().remove();}}}return p;};
o.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(i instanceof sap.m.IconTabBar&&i.getExpanded()){i.$("content").children().remove();}}return C.prototype.removeAllAggregation.apply(this,arguments);};
o.prototype._getDisplayText=function(i){var T=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){T='('+s+') '+T;}else{T+=' ('+s+')';}}}return T;};
o.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==n.Inline;};
o.prototype._checkTextOnly=function(p){if(p.length>0){for(var i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)){if(p[i].getIcon()){this._bTextOnly=false;return false;}}}}this._bTextOnly=true;return true;};
o.prototype._checkNoText=function(p){if(p.length>0){for(var i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)){if(p[i].getText().length>0){return false;}}}}return true;};
o.prototype._checkInLine=function(p){var r;if(p.length>0){for(var i=0;i<p.length;i++){r=p[i];if(!(r instanceof sap.m.IconTabSeparator)){if(r.getIcon()||r.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};
o.prototype._checkScrolling=function(H){var $=this.$();var s=false;var i=this.getDomRef("scrollContainer");var p=this.getDomRef("head");if(p&&i){if(p.offsetWidth>i.offsetWidth){s=true;}}if(this._scrollable!==s){$.toggleClass("sapMITBScrollable",s);$.toggleClass("sapMITBNotScrollable",!s);this._scrollable=s;}this._setTabsVisibility();return s;};
o.prototype._getScrollingArrow=function(N){var s=a.getIconURI("slim-arrow-"+N);var p={src:s,useIconTooltip:false};var i=this._bTextOnly?"TextOnly":"";var L="sapMITBArrowScrollLeft"+i;var r="sapMITBArrowScrollRight"+i;var u=["sapMITBArrowScroll",L];var v=["sapMITBArrowScroll",r];if(this._bInLine){u.push('sapMITBArrowScrollLeftInLine');v.push('sapMITBArrowScrollRightInLine');}if(N==="left"){if(!this._oArrowLeft){this._oArrowLeft=j.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p,u);}return this._oArrowLeft;}if(N==="right"){if(!this._oArrowRight){this._oArrowRight=j.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p,v);}return this._oArrowRight;}};
o.prototype._checkOverflow=function(){var i=this.getDomRef("head");var $=this.$();if(this._checkScrolling(i)&&i){var s=false;var p=false;var r=this.getDomRef("scrollContainer");var u=this.getDomRef("head");if(this._oScroller.getScrollLeft()>0){s=true;}if((this._oScroller.getScrollLeft()+r.offsetWidth)<u.offsetWidth){p=true;}if((p!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){this._bPreviousScrollForward=p;this._bPreviousScrollBack=s;$.toggleClass("sapMITBScrollBack",s);$.toggleClass("sapMITBNoScrollBack",!s);$.toggleClass("sapMITBScrollForward",p);$.toggleClass("sapMITBNoScrollForward",!p);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};
o.prototype._handleActivation=function(i){var T=i.target.id,p=i.srcControl,s,$=q(i.target);if(p instanceof B){return;}var r=q.sap.byId(T);if(q.inArray(this.$("content")[0],r.parents())>-1){}else{if(T){var u=this.getId();i.preventDefault();if(T==u+"-arrowScrollLeft"&&D.system.desktop){var v=this._oScroller.getScrollLeft()-o.SCROLL_STEP;if(v<0){v=0;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[v,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else if(T==u+"-arrowScrollRight"&&D.system.desktop){var v=this._oScroller.getScrollLeft()+o.SCROLL_STEP;var w=this.$("scrollContainer").width();var H=this.$("head").width();if(v>(H-w)){v=H-w;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[v,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else{if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){s=i.srcControl.getId().replace(/-icon$/,"");p=sap.ui.getCore().byId(s);if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}else if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}}else{if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}}};
o.prototype._scrollIntoView=function(i,p){var $=i.$(),s,N,r;if($.length>0){var u=this.$('head');var H=u.innerWidth()-u.width();var v=$.outerWidth(true);var w=$.position().left-H/2;s=this._oScroller.getScrollLeft();r=this.$("scrollContainer").width();N=0;if(w-s<0||w-s>r-v){if(w-s<0){N+=w;}else{N+=Math.min(w,w+v-r);N=Math.round(N);}this._scrollPreparation();this._iCurrentScrollLeft=N;q.sap.delayedCall(0,this._oScroller,"scrollTo",[N,0,p]);q.sap.delayedCall(p,this,"_afterIscroll");}}return this;};
o.prototype._scroll=function(i,p){this._scrollPreparation();var r=this.getDomRef("head");var s=r.scrollLeft;var u=D.browser.msie||D.browser.edge;if(!u&&this._bRtl){i=-i;}var v=s+i;q(r).stop(true,true).animate({scrollLeft:v},p,q.proxy(this._adjustAndShowArrow,this));this._iCurrentScrollLeft=v;};
o.prototype._adjustAndShowArrow=function(){this._$bar&&this._$bar.toggleClass("sapMITBScrolling",false);this._$bar=null;if(D.system.desktop){this._checkOverflow();}};
o.prototype._scrollPreparation=function(){if(!this._$bar){this._$bar=this.$().toggleClass("sapMITBScrolling",true);}};
o.prototype._afterIscroll=function(){this._checkOverflow();this._adjustAndShowArrow();this._setTabsVisibility();};
o.prototype._fnResize=function(){this._checkOverflow();if(this.oSelectedItem&&this._bCheckIfIntoView){this._scrollIntoView(this.oSelectedItem,0);if(!this._isTouchScrollingDisabled){this._bCheckIfIntoView=false;}}this._setTabsVisibility();};
o.prototype._fnResizeNoFlexboxSupport=function(){var $=this.getParent().$("containerContent"),i=$.outerHeight(true)-$.height();$.height(this.getParent().$().height()-$.position().top-i);};
o.prototype._setTabsVisibility=function(){if(!this._isTouchScrollingDisabled){return;}var T=this.getItems(),p,$,H,i;for(i=0;i<T.length;i++){p=T[i];$=p.$();if(!$.hasClass('sapMITBSelected')&&!this._isTabIntoView($)){$.addClass('sapMITBFilterHidden');}else{H=true;$.removeClass('sapMITBFilterHidden');}}if(!H){for(i=0;i<T.length;i++){p=T[i];$=p.$();if(this._isTabIntoView($,true)){$.removeClass('sapMITBFilterHidden');break;}}}this._moveVisibleTabs();};
o.prototype._isTabIntoView=function($,s){if(!$.length){return false;}var i=this._oScroller.getScrollLeft(),p=this.$("scrollContainer").width(),r=this.$('head'),H=r.innerWidth()-r.width(),u=$.css('padding-left'),v=$.width()+parseFloat(u),w=Math.ceil($.position().left-H/2);if(w-i<0||(!s&&(w+v-i>p))){return false;}return true;};
o.prototype._moveVisibleTabs=function(){if(!this._oScroller){return;}var s=this._oScroller.getScrollLeft(),$=this.$('head'),H=$.innerWidth()-$.width(),i=this.$().find('.sapMITBFilter:not(.sapMITBFilterHidden)').first(),p,r;if(!i.length){return;}r=i.position().left-H/2;if(!this._bRtl&&r-s>2){p=s-r;$.css('transform','translate('+p+'px)');}else{$.css('transform','');}return true;};
o.prototype.onExit=function(){if(this._sResizeListenerNoFlexboxSupportId){d.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};
o.prototype.getFocusDomRef=function(F){var T=F||this.oSelectedItem;if(!T){return null;}return T.getDomRef();};
o.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).focus();}};
o.prototype.ontouchstart=function(i){var T=i.targetTouches[0];this._iActiveTouch=T.identifier;this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;this._iTouchDragX=0;this._iTouchDragY=0;var $=q(i.target);if($.hasClass('sapMITBArrowScroll')){i.preventDefault();}};
o.prototype.ontouchmove=function(i){if(this._iActiveTouch===undefined){return;}var T=t.find(i.changedTouches,this._iActiveTouch);if(!T||T.pageX===this._iTouchStartPageX){return;}this._iTouchDragX+=Math.abs(this._iTouchStartPageX-T.pageX);this._iTouchDragY+=Math.abs(this._iTouchStartPageY-T.pageY);this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;};
o.prototype.ontouchend=function(i){if(this._iActiveTouch===undefined){return;}var M=D.system.desktop?5:15;if((this._scrollable&&this._iTouchDragX>M)||this._iTouchDragY>M){return;}var p=0;var L=1;var r;if(i.which===r||i.which===p||i.which===L){this._handleActivation(i);}this._iActiveTouch=undefined;};
o.prototype.ontouchcancel=o.prototype.ontouchend;
o.prototype.onsapselect=function(i){this._handleActivation(i);};
o.prototype._handleDragAndDrop=function(i){var p=i.getParameter("dropPosition"),r=i.getParameter("draggedControl"),s=i.getParameter("droppedControl");g.handleDrop.call(this,p,r,s);this._initItemNavigation();r.$().focus();};
o.prototype._moveTab=function(T,K){var r=g.moveItem.call(this,T,K);this._initItemNavigation();if(r){this._scrollIntoView(T,0);}};
o.prototype.ondragrearranging=function(i){if(!this.getEnableTabReordering()){return;}var T=sap.ui.getCore().byId(i.target.id);this._moveTab(T,i.keyCode);T.$().focus();};
o.prototype.onsaphomemodifiers=o.prototype.ondragrearranging;o.prototype.onsapendmodifiers=o.prototype.ondragrearranging;o.prototype.onsapincreasemodifiers=o.prototype.ondragrearranging;o.prototype.onsapdecreasemodifiers=o.prototype.ondragrearranging;return o;});
sap.ui.predefine('sap/m/IconTabHeaderRenderer',['sap/m/library'],function(l){"use strict";var I=l.IconTabFilterDesign;var a={};
a.render=function(r,c){if(!c.getVisible()){return;}var b=c.getItems(),d=b.length,v=c.getVisibleTabFilters(),V=v.length,e=0,t=c._checkTextOnly(b),n=c._checkNoText(b),f=c._checkInLine(b)||c.isInlineMode(),s=c.getShowOverflowSelectList(),o,g,h;var j=c.getParent();var u=j&&j instanceof sap.m.IconTabBar&&j.getUpperCase();r.write("<div role='tablist' ");r.addClass("sapMITH");r.addClass("sapContrastPlus");r.addClass("sapMITHBackgroundDesign"+c.getBackgroundDesign());if(s){r.addClass("sapMITHOverflowList");}if(c._scrollable){r.addClass("sapMITBScrollable");if(c._bPreviousScrollForward){r.addClass("sapMITBScrollForward");}else{r.addClass("sapMITBNoScrollForward");}if(c._bPreviousScrollBack){r.addClass("sapMITBScrollBack");}else{r.addClass("sapMITBNoScrollBack");}}else{r.addClass("sapMITBNotScrollable");}if(u){r.addClass("sapMITBTextUpperCase");}r.writeControlData(c);r.writeClasses();r.write(">");r.renderControl(c._getScrollingArrow("left"));r.write("<div id='"+c.getId()+"-scrollContainer' aria-hidden='true' class='sapMITBScrollContainer'>");r.write("<div id='"+c.getId()+"-head' aria-hidden='true' ");r.addClass("sapMITBHead");if(t){r.addClass("sapMITBTextOnly");}if(n){r.addClass("sapMITBNoText");}if(f){r.addClass("sapMITBInLine");}r.writeClasses();r.write(">");for(var i=0;i<d;i++){o=b[i];o.render(r,e,V);if(o instanceof sap.m.IconTabFilter){g=o.getDesign()===I.Horizontal;if(g){h=true;}if(o.getVisible()){e++;}}}r.write("</div>");r.write("</div>");r.renderControl(c._getScrollingArrow("right"));if(s){var O=c._getOverflowButton();if(f){O.addStyleClass('sapMBtnInline');}else if(t){O.addStyleClass('sapMBtnTextOnly');}else if(n||h){O.addStyleClass('sapMBtnNoText');}r.renderControl(O);}r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/IconTabSeparator',['./library','sap/ui/core/Element','sap/ui/core/Item'],function(l,E,I){"use strict";var a=l.ImageHelper;
var b=E.extend("sap.m.IconTabSeparator",{metadata:{interfaces:["sap.m.IconTab"],library:"sap.m",designtime:"sap/m/designtime/IconTabSeparator.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},visible:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}}}});
b.prototype._getImageControl=function(c,p){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=a.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,c);return this._oImageControl;};
b.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,e);}};
b.prototype.render=function(r){if(!this.getVisible()){return;}var i=this.getIcon(),c=this.getParent(),d=sap.ui.getCore().getLibraryResourceBundle('sap.m'),e='';if(i){e+='role="img" aria-label="'+d.getText("ICONTABBAR_NEXTSTEP")+'"';}else{e+='role="separator"';}r.write('<div '+e+' ');r.writeElementData(this);r.addClass("sapMITBItem");r.addClass("sapMITBSep");if(!i){r.addClass("sapMITBSepLine");}r.writeClasses();r.write(">");if(i){r.renderControl(this._getImageControl(['sapMITBSepIcon'],c));}r.write("</div>");};
b.prototype.renderInSelectList=function(r,s){};
return b;});
sap.ui.predefine('sap/m/Image',['jquery.sap.global','./library','sap/ui/core/Control','./ImageRenderer','jquery.sap.keycodes'],function(q,l,C,I){"use strict";var a=l.ImageMode;
var b=C.extend("sap.m.Image",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Image.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null},densityAware:{type:"boolean",group:"Misc",defaultValue:true},activeSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},mode:{type:"sap.m.ImageMode",group:"Misc",defaultValue:"Image"},backgroundSize:{type:"string",group:"Appearance",defaultValue:"cover"},backgroundPosition:{type:"string",group:"Appearance",defaultValue:"initial"},backgroundRepeat:{type:"string",group:"Appearance",defaultValue:"no-repeat"}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{},press:{},load:{},error:{}}}});
b._currentDevicePixelRatio=(function(){var r=(window.devicePixelRatio===undefined?1:window.devicePixelRatio);if(r<=1){r=1;}else{r*=2;r=Math.round(r);r/=2;}if(r>2){r=2;}return r;}());
b.prototype.onload=function(e){var w,h;if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}this._bVersion2Tried=false;var d=this.$(),D=d[0];if(this.getMode()===a.Background){d.css("background-image","url(\""+this._oImage.src+"\")");}if(!this._isWidthOrHeightSet()){if(this._iLoadImageDensity>1){w=Math.round(D.getBoundingClientRect().width);h=Math.round(D.getBoundingClientRect().height);if((w===D.naturalWidth)&&(h===D.naturalHeight)){d.width(w/this._iLoadImageDensity);}}}d.removeClass("sapMNoImg");this.fireLoad();};
b.prototype.onerror=function(e){if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}var D=this.$(),m=this.getMode(),s=(m===a.Image)?D.attr("src"):this._oImage.src,d=b._currentDevicePixelRatio,c=this._isActiveState?this.getActiveSrc():this.getSrc();D.addClass("sapMNoImg");if(!s||this._iLoadImageDensity===1){D.removeClass("sapMNoImg");this.fireError();return;}if(d===2||d<1){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));}else if(d===1.5){if(this._bVersion2Tried){setTimeout(q.proxy(function(){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));},this),0);}else{setTimeout(q.proxy(function(){this._iLoadImageDensity=2;this._updateDomSrc(this._generateSrcByDensity(c,2));this._bVersion2Tried=true;},this),0);}}};
b.prototype.setDetailBox=function(L){var c=this.getDetailBox();if(L){if(L===c){return this;}if(c){this.detachPress(this._fnLightBoxOpen,c);}this._fnLightBoxOpen=L.open;this.attachPress(this._fnLightBoxOpen,L);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,c);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",L);};
b.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments),o=c.getDetailBox();if(o){c.detachPress(this._fnLightBoxOpen,this.getDetailBox());c._fnLightBoxOpen=o.open;c.attachPress(c._fnLightBoxOpen,o);}return c;};
b.prototype.onBeforeRendering=function(){this._defaultEventTriggered=false;};
b.prototype.onAfterRendering=function(){var d=this.$(),m=this.getMode(),D;if(m===a.Image){d.on("load",q.proxy(this.onload,this));d.on("error",q.proxy(this.onerror,this));D=d[0];}if(m===a.Background){D=this._oImage;}if(D&&D.complete&&!this._defaultEventTriggered){if(D.naturalWidth>0){this.onload({});}else{this.onerror({});}}};
b.prototype.exit=function(){if(this._oImage){q(this._oImage).off("load",this.onload).off("error",this.onerror);this._oImage=null;}else{this.$().off("load",this.onload).off("error",this.onerror);}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};
b.prototype.ontouchstart=function(e){if(e.srcControl.mEventRegistry["press"]||e.srcControl.mEventRegistry["tap"]){e.setMarked();}if(e.targetTouches.length===1&&this.getActiveSrc()){this._updateDomSrc(this._getDensityAwareActiveSrc());this._isActiveState=true;}};
b.prototype.ontouchend=function(e){if(e.targetTouches.length===0&&this.getActiveSrc()){this._isActiveState=false;this._updateDomSrc(this._getDensityAwareSrc());this.$().removeClass("sapMNoImg");}};
b.prototype.setSrc=function(s){if(s===this.getSrc()){return this;}this.setProperty("src",s,true);var d=this.getDomRef();if(d){this._updateDomSrc(this._getDensityAwareSrc());}return this;};
b.prototype.setActiveSrc=function(A){if(!A){A="";}return this.setProperty("activeSrc",A,true);};
b.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
b.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation");}else{this.$().removeAttr("role");}}return this;};
b.prototype.ontap=function(e){this.fireTap({});this.firePress({});};
b.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){this.firePress({});e.stopPropagation();}};
b.prototype._updateDomSrc=function(s){var d=this.$(),m=this.getMode();if(d.length){if(m===a.Image){d.attr("src",s);}else{d.addClass("sapMNoImg");q(this._oImage).attr("src",s);}}};
b.prototype._preLoadImage=function(s){if(this.getMode()!==a.Background){return;}var i=q(this._oImage);if(!this._oImage){this._oImage=new window.Image();i=q(this._oImage);i.on("load",q.proxy(this.onload,this)).on("error",q.proxy(this.onerror,this));}this._oImage.src=s;};
b.prototype._isWidthOrHeightSet=function(){return(this.getWidth()&&this.getWidth()!=='')||(this.getHeight()&&this.getHeight()!=='');};
b.prototype._getDensityAwareSrc=function(){var s=this.getSrc(),D=this.getDensityAware(),d=D?b._currentDevicePixelRatio:1;this._iLoadImageDensity=d;if(d===1){return s;}return this._generateSrcByDensity(s,d);};
b.prototype._getDensityAwareActiveSrc=function(){var A=this.getActiveSrc(),D=this.getDensityAware(),d=D?b._currentDevicePixelRatio:1;this._iLoadImageDensity=d;if(d===1){return A;}return this._generateSrcByDensity(A,d);};
b.prototype._generateSrcByDensity=function(s,d){if(!s){return"";}if(this._isDataUri(s)){this._iLoadImageDensity=1;return s;}if(d===1){return s;}var L=s.lastIndexOf("."),i=s.lastIndexOf("/"),n=s.substring(0,L),e=s.substring(L);if(L===-1||(i>L)){return s+"@"+d;}n=n+"@"+d;return n+e;};
b.prototype._isDataUri=function(s){return s?s.indexOf("data:")===0:false;};
b.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(this.getDecorative()&&!this.getUseMap()&&!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||"",focusable:h};};
b.prototype.getFormDoNotAdjustWidth=function(){return true;};
return b;});
sap.ui.predefine('sap/m/ImageContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Image','sap/ui/core/IconPool','sap/ui/Device','./ImageContentRenderer','jquery.sap.keycodes'],function(q,l,C,I,a,D,b){"use strict";
var c=C.extend("sap.m.ImageContent",{metadata:{library:"sap.m",properties:{"src":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"description":{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"_content",aggregations:{"_content":{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
c.prototype.onBeforeRendering=function(){var i,u,d;i=this.getAggregation("_content");u=this.getSrc();d=this.getDescription();if(!i||u!==i.getSrc()||d!==i.getAlt()){if(i){i.destroy();i=null;}i=a.createControlByURI({id:this.getId()+"-icon-image",src:u,alt:d,decorative:false},I);this.setAggregation("_content",i,true);this._setPointerOnImage();}if(d){this.setTooltip(d.trim());}};
c.prototype._setPointerOnImage=function(){var i=this.getAggregation("_content");if(i&&this.hasListeners("press")){i.addStyleClass("sapMPointer");}else if(i&&i.hasStyleClass("sapMPointer")){i.removeStyleClass("sapMPointer");}};
c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
c.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
c.prototype.attachEvent=function(e,d,f,g){C.prototype.attachEvent.call(this,e,d,f,g);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnImage();}return this;};
c.prototype.detachEvent=function(e,f,d){C.prototype.detachEvent.call(this,e,f,d);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnImage();}return this;};
c.prototype.getAltText=function(){var o=this.getAggregation("_content");if(o&&o.getAlt()!==""){return o.getAlt();}else if(o){return o.getAccessibilityInfo().description;}};
return c;});
sap.ui.predefine('sap/m/ImageContentRenderer',[],function(){"use strict";var I={};
I.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMImageContent");var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");var C=c.getAggregation("_content");if(C){C.addStyleClass("sapMImageContentImageIcon");r.renderControl(C);}r.write("</div>");};
return I;},true);
sap.ui.predefine('sap/m/ImageRenderer',['jquery.sap.global','sap/m/library'],function(q,l){"use strict";var I=l.ImageMode;var a={};
a.render=function(r,i){var m=i.getMode(),b=i.getAlt(),t=i.getTooltip_AsString(),h=i.hasListeners("press"),L=i.getDetailBox(),u=i.getUseMap(),c=i.getAriaLabelledBy(),d=i.getAriaDescribedBy();if(L){r.write("<span class=\"sapMLightBoxImage\"");r.writeControlData(i);r.write(">");r.write("<span class=\"sapMLightBoxMagnifyingGlass\"></span>");}r.write(m===I.Image?"<img":"<span");if(!L){r.writeControlData(i);}if(!i.getDecorative()&&c&&c.length>0){r.writeAttributeEscaped("aria-labelledby",c.join(" "));}if(!i.getDecorative()&&d&&d.length>0){r.writeAttributeEscaped("aria-describedby",d.join(" "));}if(m===I.Image){r.writeAttributeEscaped("src",i._getDensityAwareSrc());}else{i._preLoadImage(i._getDensityAwareSrc());r.addStyle("background-size",q.sap.encodeHTML(i.getBackgroundSize()));r.addStyle("background-position",q.sap.encodeHTML(i.getBackgroundPosition()));r.addStyle("background-repeat",q.sap.encodeHTML(i.getBackgroundRepeat()));}r.addClass("sapMImg");if(i.hasListeners("press")||i.hasListeners("tap")){r.addClass("sapMPointer");}if(u||!i.getDecorative()||h){r.addClass("sapMImgFocusable");}r.writeClasses();if(u){if(!(q.sap.startsWith(u,"#"))){u="#"+u;}r.writeAttributeEscaped("useMap",u);}if(i.getDecorative()&&!u&&!h){r.writeAttribute("role","presentation");r.writeAttribute("aria-hidden","true");r.write(" alt=''");}else{if(b||t){r.writeAttributeEscaped("alt",b||t);}}if(b||t){r.writeAttributeEscaped("aria-label",b||t);}if(t){r.writeAttributeEscaped("title",t);}if(h){r.writeAttribute("role","button");r.writeAttribute("tabIndex",0);}if(i.getWidth()&&i.getWidth()!=''){r.addStyle("width",i.getWidth());}if(i.getHeight()&&i.getHeight()!=''){r.addStyle("height",i.getHeight());}r.writeStyles();r.write(" />");if(L){r.write("</span>");}};
return a;},true);
sap.ui.predefine('sap/m/Input',['jquery.sap.global','./Bar','./Dialog','./InputBase','./List','./Popover','sap/ui/core/Item','./ColumnListItem','./StandardListItem','./DisplayListItem','sap/ui/core/ListItem','./Table','./Toolbar','./ToolbarSpacer','./library','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Control','./InputRenderer'],function(q,B,D,I,L,P,a,C,S,b,c,T,d,e,l,f,g,h,R,j,k){"use strict";var m=l.ListMode;var n=l.PlacementType;var o=l.ListType;var p=l.InputTextFormatMode;var r=l.InputType;
var s=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:r.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:p.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ColumnListItem",multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"}});
f.insertFontFaceStyle();
s._wordStartsWithValue=function(t,v){var i;while(t){if(q.sap.startsWithIgnoreCase(t,v)){return true;}i=t.indexOf(' ');if(i==-1){break;}t=t.substring(i+1);}return false;};
s._DEFAULTFILTER=function(v,i){if(i instanceof c&&s._wordStartsWithValue(i.getAdditionalText(),v)){return true;}return s._wordStartsWithValue(i.getText(),v);};
s._DEFAULTFILTER_TABULAR=function(v,t){var u=t.getCells(),i=0;for(;i<u.length;i++){if(u[i].getText){if(s._wordStartsWithValue(u[i].getText(),v)){return true;}}}return false;};
s._DEFAULTRESULT_TABULAR=function(t){var u=t.getCells(),i=0;for(;i<u.length;i++){if(u[i].getText){return u[i].getText();}}return"";};
s.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=s._DEFAULTFILTER;this._bUseDialog=h.system.phone;this._bFullScreen=h.system.phone;this._iSetCount=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");};
s.prototype.exit=function(){this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggestionPopup){this._oSuggestionPopup.destroy();this._oSuggestionPopup=null;}if(this._oList){this._oList.destroy();this._oList=null;}if(this._oSuggestionTable){this._oSuggestionTable.destroy();this._oSuggestionTable=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}};
s.prototype._resizePopup=function(F){var t=this;if(F){this._shouldResizePopup=true;}if(this._oList&&this._oSuggestionPopup&&this._shouldResizePopup){if(this.getMaxSuggestionWidth()){this._oSuggestionPopup.setContentWidth(this.getMaxSuggestionWidth());}else{this._oSuggestionPopup.setContentWidth((this.$().outerWidth())+"px");}setTimeout(function(){if(t._oSuggestionPopup&&t._oSuggestionPopup.isOpen()&&t._oSuggestionPopup.$().outerWidth()<t.$().outerWidth()){t._oSuggestionPopup.setContentWidth((t.$().outerWidth())+"px");}},0);}};
s.prototype.onBeforeRendering=function(){var i=this.getSelectedKey();I.prototype.onBeforeRendering.call(this);this._deregisterEvents();if(i){this.setSelectedKey(i);}if(this.getShowSuggestion()){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}else{this._removeShowMoreButton();}}};
s.prototype.onAfterRendering=function(){var t=this;I.prototype.onAfterRendering.call(this);if(!this._bFullScreen){this._sPopupResizeHandler=R.register(this.getDomRef(),function(){t._resizePopup();});}if(this._bUseDialog&&this.getEditable()&&this.getEnabled()){this.$().on("click",q.proxy(function(E){if(this._onclick){this._onclick(E);}if(this.getShowSuggestion()&&this._oSuggestionPopup&&E.target.id!=this.getId()+"-vhi"){this._resizePopup(true);this._oSuggestionPopup.open();}},this));}};
s.prototype._getDisplayText=function(i){var t=this.getTextFormatter();if(t){return t(i);}var u=i.getText(),K=i.getKey(),v=this.getTextFormatMode();switch(v){case p.Key:return K;case p.ValueKey:return u+' ('+K+')';case p.KeyValue:return'('+K+') '+u;default:return u;}};
s.prototype._onValueUpdated=function(i){if(this._bSelectingItem||i===this._sSelectedValue){return;}var K=this.getSelectedKey(),H;if(K===''){return;}if(this._hasTabularSuggestions()){H=!!this._oSuggestionTable.getSelectedItem();}else{H=!!this._oList.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};
s.prototype._updateSelectionFromList=function(){if(this._iPopupListSelectedIndex<0){return false;}var i=this._oList.getSelectedItem();if(i){if(this._hasTabularSuggestions()){this.setSelectionRow(i,true);}else{this.setSelectionItem(i._oItem,true);}}return true;};
s.prototype.setSelectionItem=function(i,t){if(!i){this.setAssociation("selectedItem",null,true);this.setProperty("selectedKey",'',true);this.setValue('');return;}this._bSelectingItem=true;var u=this._iSetCount,N;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(t){this.fireSuggestionItemSelected({selectedItem:i});}if(u!==this._iSetCount){N=this.getValue();}else{N=this._getDisplayText(i);}this._sSelectedValue=N;this.updateInputField(N);this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!h.support.touch){this._doSelect();}this._bSelectingItem=false;};
s.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};
s.prototype.setSelectedKey=function(K){K=this.validateProperty("selectedKey",K);if(this._hasTabularSuggestions()){this.setProperty("selectedKey",K,true);return this;}if(!K){this.setSelectionItem();return this;}var i=this.getSuggestionItemByKey(K);if(i){this.setSelectionItem(i);}else{this.setProperty("selectedKey",K,true);}return this;};
s.prototype.getSuggestionItemByKey=function(K){var t=this.getSuggestionItems()||[],u,i;for(i=0;i<t.length;i++){u=t[i];if(u.getKey()===K){return u;}}};
s.prototype.setSelectionRow=function(i,t){if(!i){this.setAssociation("selectedRow",null,true);this.setProperty("selectedKey",'',true);this.setValue('');return;}this._bSelectingItem=true;var u,v=this.getSuggestionRowValidator();if(v){u=v(i);if(!(u instanceof a)){u=null;}}var w=this._iSetCount,K="",N;this.setAssociation("selectedRow",i,true);if(u){K=u.getKey();}this.setProperty("selectedKey",K,true);if(t){this.fireSuggestionItemSelected({selectedRow:i});}if(w!==this._iSetCount){N=this.getValue();}else{if(u){N=this._getDisplayText(u);}else{N=this._fnRowResultFilter?this._fnRowResultFilter(i):s._DEFAULTRESULT_TABULAR(i);}}this._sSelectedValue=N;this.updateInputField(N);this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!h.support.touch){this._doSelect();}this._bSelectingItem=false;};
s.prototype.setSelectedRow=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof C)){return this;}this.setSelectionRow(i);return this;};
s.prototype._getValueHelpIcon=function(){var t=this,v=this.getAggregation("_valueHelpIcon"),u;if(v){return v;}u=f.getIconURI("value-help");v=f.createControlByURI({id:this.getId()+"-vhi",src:u,useIconTooltip:false,noTabStop:true});v.addStyleClass("sapMInputValHelpInner");v.attachPress(function(i){if(!t.getValueHelpOnly()){this.getParent().focus();t.bValueHelpRequested=true;t.fireValueHelpRequest({fromSuggestions:false});}});this.setAggregation("_valueHelpIcon",v);return v;};
s.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){this.fireValueHelpRequest({fromSuggestions:false});}};
s.prototype.ontap=function(E){I.prototype.ontap.call(this,E);this._fireValueHelpRequestForValueHelpOnly();};
s.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};
s.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
s.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=s._DEFAULTFILTER;return this;}this._fnFilter=F;return this;};
s.prototype.setRowResultFunction=function(F){var i;if(F===null||F===undefined){this._fnRowResultFilter=s._DEFAULTRESULT_TABULAR;return this;}this._fnRowResultFilter=F;i=this.getSelectedRow();if(i){this.setSelectedRow(i);}return this;};
s.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};
s.prototype._doSelect=function(i,E){if(h.support.touch){return;}var t=this._$input[0];if(t){var $=this._$input;t.focus();$.selectText(i?i:0,E?E:$.val().length);}return this;};
s.prototype._scrollToItem=function(i){var t=this._oSuggestionPopup,u=this._oList,v,w,x,y,z;if(!(t instanceof P)||!u){return;}v=t.getScrollDelegate();if(!v){return;}var A=u.getItems()[i],E=A&&A.getDomRef();if(!E){return;}w=t.getDomRef("cont").getBoundingClientRect();x=E.getBoundingClientRect();y=w.top-x.top;z=x.bottom-w.bottom;if(y>0){v.scrollTo(v._scrollX,Math.max(v._scrollY-y,0));}else if(z>0){v.scrollTo(v._scrollX,v._scrollY+z);}};
s.prototype._isSuggestionItemSelectable=function(i){return i.getVisible()&&(this._hasTabularSuggestions()||i.getType()!==o.Inactive);};
s.prototype._isIncrementalType=function(){var t=this.getType();if(t==="Number"||t==="Date"||t==="Datetime"||t==="Month"||t==="Time"||t==="Week"){return true;}return false;};
s.prototype._onsaparrowkey=function(E,i,t){if(!this.getEnabled()||!this.getEditable()){return;}if(i!=="up"&&i!=="down"){return;}if(this._isIncrementalType()){E.setMarked();}if(!this._oSuggestionPopup||!this._oSuggestionPopup.isOpen()){return;}E.preventDefault();E.stopPropagation();var F=false,u=this._oList,v=this.getSuggestionItems(),w=u.getItems(),x=this._iPopupListSelectedIndex,N,O=x;if(i==="up"&&x===0){return;}if(i=="down"&&x===w.length-1){return;}var y;if(t>1){if(i=="down"&&x+t>=w.length){i="up";t=1;w[x].setSelected(false);y=x;x=w.length-1;F=true;}else if(i=="up"&&x-t<0){i="down";t=1;w[x].setSelected(false);y=x;x=0;F=true;}}if(x===-1){x=0;if(this._isSuggestionItemSelectable(w[x])){O=x;F=true;}else{i="down";}}if(i==="down"){while(x<w.length-1&&(!F||!this._isSuggestionItemSelectable(w[x]))){w[x].setSelected(false);x=x+t;F=true;t=1;if(y===x){break;}}}else{while(x>0&&(!F||!w[x].getVisible()||!this._isSuggestionItemSelectable(w[x]))){w[x].setSelected(false);x=x-t;F=true;t=1;if(y===x){break;}}}if(!this._isSuggestionItemSelectable(w[x])){if(O>=0){w[O].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",w[O].getId());}return;}else{w[x].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",w[x].getId());}if(h.system.desktop){this._scrollToItem(x);}if(C&&w[x]instanceof C){N=this._getInputValue(this._fnRowResultFilter(w[x]));}else{var z=(v[0]instanceof c?true:false);if(z){N=this._getInputValue(w[x].getLabel());}else{N=this._getInputValue(w[x].getTitle());}}this.setDOMValue(N);this._sSelectedSuggViaKeyboard=N;this._doSelect();this._iPopupListSelectedIndex=x;};
s.prototype.onsapup=function(E){this._onsaparrowkey(E,"up",1);};
s.prototype.onsapdown=function(E){this._onsaparrowkey(E,"down",1);};
s.prototype.onsappageup=function(E){this._onsaparrowkey(E,"up",5);};
s.prototype.onsappagedown=function(E){this._onsaparrowkey(E,"down",5);};
s.prototype.onsaphome=function(E){if(this._oList){this._onsaparrowkey(E,"up",this._oList.getItems().length);}};
s.prototype.onsapend=function(E){if(this._oList){this._onsaparrowkey(E,"down",this._oList.getItems().length);}};
s.prototype.onsapescape=function(E){var i;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){E.originalEvent._sapui_handledByControl=true;this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){i=this._lastValue;this.setValue(this._sBeforeSuggest);this._lastValue=i;}this._sBeforeSuggest=undefined;}return;}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};
s.prototype.onsapenter=function(E){this.cancelPendingSuggest();if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){if(!this._updateSelectionFromList()){this._closeSuggestionPopup();}}if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};
s.prototype.onsapfocusleave=function(E){var i=this._oSuggestionPopup;if(i instanceof P){if(E.relatedControlId&&q.sap.containsOrEquals(i.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this._bPopupHasFocus=true;this.focus();}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}var F=sap.ui.getCore().byId(E.relatedControlId);if(!(i&&F&&q.sap.containsOrEquals(i.getDomRef(),F.getFocusDomRef()))){I.prototype.onsapfocusleave.apply(this,arguments);}this.bValueHelpRequested=false;};
s.prototype.onmousedown=function(E){var i=this._oSuggestionPopup;if((i instanceof P)&&i.isOpen()){E.stopPropagation();}};
s.prototype._deregisterEvents=function(){if(this._sPopupResizeHandler){R.deregister(this._sPopupResizeHandler);this._sPopupResizeHandler=null;}if(this._bUseDialog&&this._oSuggestionPopup){this.$().off("click");}};
s.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();this._bSuspendInvalidate=false;return this;};
s.prototype.invalidate=function(){if(!this._bSuspendInvalidate){j.prototype.invalidate.apply(this,arguments);}};
s.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){q.sap.clearDelayedCall(this._iSuggestDelay);this._iSuggestDelay=null;}};
s.prototype._triggerSuggest=function(v){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!v){v="";}if(v.length>=this.getStartSuggestion()){this._iSuggestDelay=q.sap.delayedCall(300,this,function(){if(this._sPrevSuggValue!==v){this._bBindingUpdated=false;this.fireSuggest({suggestValue:v});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=v;}});}else if(this._bUseDialog){if(this._oList instanceof T){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oList&&this._oList.destroyItems){this._oList.destroyItems();}}else if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){q.sap.delayedCall(0,this,function(){var N=this.getDOMValue()||'';if(N<this.getStartSuggestion()){this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}});}};
(function(){
s.prototype.setShowSuggestion=function(V){this.setProperty("showSuggestion",V,true);this._iPopupListSelectedIndex=-1;if(V){this._lazyInitializeSuggestionPopup(this);}else{v(this);}return this;};
s.prototype.setShowTableSuggestionValueHelp=function(V){this.setProperty("showTableSuggestionValueHelp",V,true);if(!this._oSuggestionPopup){return this;}if(V){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};
s.prototype._getShowMoreButton=function(){var i=this,M=this._oRb;return this._oShowMoreButton||(this._oShowMoreButton=new sap.m.Button({text:M.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){if(i.getShowTableSuggestionValueHelp()){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();}}}));};
s.prototype._getButtonToolbar=function(){var i=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new d({content:[new e(),i]}));};
s.prototype._addShowMoreButton=function(i){if(!this._oSuggestionPopup||!i&&!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){var y=this._getShowMoreButton();this._oSuggestionPopup.setEndButton(y);}else{var z=this._getButtonToolbar();this._oSuggestionPopup.setFooter(z);}};
s.prototype._removeShowMoreButton=function(){if(!this._oSuggestionPopup||!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){this._oSuggestionPopup.setEndButton(null);}else{this._oSuggestionPopup.setFooter(null);}};
s.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var i=this.getDOMValue();if(this.getValueLiveUpdate()){this.setProperty("value",i,true);this._onValueUpdated(i);}this.fireLiveChange({value:i,newValue:i});if(this.getShowSuggestion()&&!this._bUseDialog){this._triggerSuggest(i);}};
s.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};
s.prototype._refreshItemsDelayed=function(){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=q.sap.delayedCall(0,this,x,[this]);};
s.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();u(this);return this;};
s.prototype.insertSuggestionItem=function(i,y){this.insertAggregation("suggestionItems",y,i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();u(this);return this;};
s.prototype.removeSuggestionItem=function(i){var y=this.removeAggregation("suggestionItems",i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return y;};
s.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return i;};
s.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};
s.prototype.addSuggestionRow=function(i){i.setType(o.Active);this.addAggregation("suggestionRows",i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();u(this);return this;};
s.prototype.insertSuggestionRow=function(i,y){i.setType(o.Active);this.insertAggregation("suggestionRows",i,y);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();u(this);return this;};
s.prototype.removeSuggestionRow=function(i){var y=this.removeAggregation("suggestionRows",i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return y;};
s.prototype.removeAllSuggestionRows=function(){var i=this.removeAllAggregation("suggestionRows");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return i;};
s.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};
s.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){u(this,arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true;}return I.prototype.bindAggregation.apply(this,arguments);};
s.prototype._lazyInitializeSuggestionPopup=function(){if(!this._oSuggestionPopup){t(this);}};
s.prototype._closeSuggestionPopup=function(){if(this._oSuggestionPopup){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._oSuggestionPopup.close();if(!this._bUseDialog&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage();}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;}};
function t(i){var M=i._oRb;if(i._bUseDialog){i._oPopupInput=new s(i.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueHelp:i.getShowValueHelp(),valueHelpRequest:function(E){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();},liveChange:function(E){var V=E.getParameter("newValue");i.setDOMValue(i._getInputValue(i._oPopupInput.getValue()));i._triggerSuggest(V);i.fireLiveChange({value:V,newValue:V});}}).addStyleClass("sapMInputSuggInDialog");}i._oSuggestionPopup=!i._bUseDialog?(new P(i.getId()+"-popup",{showArrow:false,showHeader:false,placement:n.Vertical,initialFocus:i,horizontalScrolling:true}).attachAfterClose(function(){i._updateSelectionFromList();if(i._oList instanceof T){i._oList.removeSelections(true);}else{i._oList.destroyItems();}i._shouldResizePopup=false;}).attachBeforeOpen(function(){i._sBeforeSuggest=i.getValue();})):(new D(i.getId()+"-popup",{beginButton:new sap.m.Button(i.getId()+"-popup-closeButton",{text:M.getText("MSGBOX_CLOSE"),press:function(){i._closeSuggestionPopup();}}),stretch:i._bFullScreen,contentHeight:i._bFullScreen?undefined:"20rem",customHeader:new B(i.getId()+"-popup-header",{contentMiddle:i._oPopupInput.addEventDelegate({onsapenter:function(){if(!(sap.m.MultiInput&&i instanceof sap.m.MultiInput)){i._closeSuggestionPopup();}}},this)}),horizontalScrolling:false,initialFocus:i._oPopupInput}).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(i.getPlaceholder());i._oPopupInput.setMaxLength(i.getMaxLength());}).attachBeforeClose(function(){i.setDOMValue(i._getInputValue(i._oPopupInput.getValue()));i.onChange();if(i instanceof sap.m.MultiInput&&i._bUseDialog){i._onDialogClose();}}).attachAfterClose(function(){if(i instanceof sap.m.MultiInput&&i._isMultiLineMode){i._showIndicator();}if(i._oList){if(T&&!(i._oList instanceof T)){i._oList.destroyItems();}else{i._oList.removeSelections(true);}}}).attachAfterOpen(function(){var V=i.getValue();i._oPopupInput.setValue(V);i._triggerSuggest(V);x(i);}));i._oSuggestionPopup.addStyleClass("sapMInputSuggestionPopup");i._oSuggestionPopup.addAriaLabelledBy(g.getStaticId("sap.m","INPUT_AVALIABLE_VALUES"));i.addDependent(i._oSuggestionPopup);if(!i._bUseDialog){w(i._oSuggestionPopup,i);}if(i._oList){i._oSuggestionPopup.addContent(i._oList);}if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton();}}
function u(i,y){if(i._bIsBeingDestroyed||i._oList){return;}if(!i._hasTabularSuggestions()&&!y){i._oList=new L(i.getId()+"-popup-list",{showNoData:false,mode:m.SingleSelectMaster,rememberSelections:false,itemPress:function(E){var F=E.getParameter("listItem");i.setSelectionItem(F._oItem,true);}});i._oList.addEventDelegate({onAfterRendering:i._highlightListText.bind(i)});}else{if(i._fnFilter===s._DEFAULTFILTER){i._fnFilter=s._DEFAULTFILTER_TABULAR;}if(!i._fnRowResultFilter){i._fnRowResultFilter=s._DEFAULTRESULT_TABULAR;}i._oList=i._getSuggestionsTable();if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton(y);}}if(i._oSuggestionPopup){if(i._bUseDialog){i._oSuggestionPopup.addAggregation("content",i._oList,true);var z=i._oSuggestionPopup.$("scrollCont")[0];if(z){var A=sap.ui.getCore().createRenderManager();A.renderControl(i._oList);A.flush(z);A.destroy();}}else{i._oSuggestionPopup.addContent(i._oList);}}}
function v(i){if(i._oSuggestionPopup){if(i._oList instanceof T){i._oSuggestionPopup.removeAllContent();i._removeShowMoreButton();}i._oSuggestionPopup.destroy();i._oSuggestionPopup=null;}if(i._oList instanceof L){i._oList.destroy();i._oList=null;}}
function w(i,y){i.open=function(){this.openBy(y,false,true);};i.oPopup.setAnimations(function($,z,O){O();},function($,z,A){A();});}
function x(y){var z=y.getShowSuggestion();var A=y._oRb;y._iPopupListSelectedIndex=-1;if(!z||!y._bShouldRefreshListItems||!y.getDomRef()||(!y._bUseDialog&&!y.$().hasClass("sapMInputFocused"))){return false;}var E,F=y.getSuggestionItems(),G=y.getSuggestionRows(),H=y.getDOMValue()||"",J=y._oList,K=y.getFilterSuggests(),M=[],N=0,O=y._oSuggestionPopup,Q={ontouchstart:function(X){(X.originalEvent||X)._sapui_cancelAutoClose=true;}},U,i;if(y._oList){if(y._oList instanceof T){J.removeSelections(true);}else{J.destroyItems();}}if(H.length<y.getStartSuggestion()){if(!y._bUseDialog){y._iPopupListSelectedIndex=-1;this.cancelPendingSuggest();O.close();}else{if(y._hasTabularSuggestions()&&y._oList){y._oList.addStyleClass("sapMInputSuggestionTableHidden");}}y.$("SuggDescr").text("");y.$("inner").removeAttr("aria-haspopup");y.$("inner").removeAttr("aria-activedescendant");return false;}if(y._hasTabularSuggestions()){if(y._bUseDialog&&y._oList){y._oList.removeStyleClass("sapMInputSuggestionTableHidden");}for(i=0;i<G.length;i++){if(!K||y._fnFilter(H,G[i])){G[i].setVisible(true);M.push(G[i]);}else{G[i].setVisible(false);}}y._oSuggestionTable.invalidate();}else{var V=(F[0]instanceof c?true:false);for(i=0;i<F.length;i++){E=F[i];if(!K||y._fnFilter(H,E)){if(V){U=new b(E.getId()+"-dli");U.setLabel(E.getText());U.setValue(E.getAdditionalText());}else{U=new S(E.getId()+"-sli");U.setTitle(E.getText());}U.setType(E.getEnabled()?o.Active:o.Inactive);U._oItem=E;U.addEventDelegate(Q);M.push(U);}}}N=M.length;var W="";if(N>0){if(N==1){W=A.getText("INPUT_SUGGESTIONS_ONE_HIT");}else{W=A.getText("INPUT_SUGGESTIONS_MORE_HITS",N);}y.$("inner").attr("aria-haspopup","true");if(!y._hasTabularSuggestions()){for(i=0;i<N;i++){J.addItem(M[i]);}}if(!y._bUseDialog){if(y._sCloseTimer){clearTimeout(y._sCloseTimer);y._sCloseTimer=null;}if(!O.isOpen()&&!y._sOpenTimer&&(this.getValue().length>=this.getStartSuggestion())){y._sOpenTimer=setTimeout(function(){y._resizePopup(true);y._sOpenTimer=null;O.open();},0);}}}else{W=A.getText("INPUT_SUGGESTIONS_NO_HIT");y.$("inner").removeAttr("aria-haspopup");y.$("inner").removeAttr("aria-activedescendant");if(!y._bUseDialog){if(O.isOpen()){y._sCloseTimer=setTimeout(function(){y._iPopupListSelectedIndex=-1;y.cancelPendingSuggest();O.close();},0);}}else{if(y._hasTabularSuggestions()&&y._oList){y._oList.addStyleClass("sapMInputSuggestionTableHidden");}}}y.$("SuggDescr").text(W);}
})();
s.prototype._createHighlightedText=function(i){var t=i.innerText,v=this.getValue().toLowerCase(),u=v.length,w=t.toLowerCase(),x,y='';if(!s._wordStartsWithValue(t,v)){return q.sap.encodeHTML(t);}var z=w.indexOf(v);if(z>0){z=w.indexOf(' '+v)+1;}if(z>-1){y+=q.sap.encodeHTML(t.substring(0,z));x=t.substring(z,z+u);y+='<span class="sapMInputHighlight">'+q.sap.encodeHTML(x)+'</span>';y+=q.sap.encodeHTML(t.substring(z+u));}else{y=q.sap.encodeHTML(t);}return y;};
s.prototype._highlightListText=function(){if(!this.getEnableSuggestionsHighlighting()){return;}var i,t,u=this._oList.$().find('.sapMDLILabel, .sapMSLITitleOnly, .sapMDLIValue');for(i=0;i<u.length;i++){t=u[i];t.innerHTML=this._createHighlightedText(t);}};
s.prototype._highlightTableText=function(){if(!this.getEnableSuggestionsHighlighting()){return;}var i,t,u=this._oSuggestionTable.$().find('tbody .sapMLabel');for(i=0;i<u.length;i++){t=u[i];t.innerHTML=this._createHighlightedText(t);}};
s.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.$().addClass("sapMInputFocused");if(!this._bUseDialog&&this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){this.closeValueStateMessage();}if(!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};
s.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.bValueHelpRequested=true;this.fireValueHelpRequest({fromSuggestions:false});E.preventDefault();E.stopPropagation();};
s.prototype.onsaphide=s.prototype.onsapshow;
s.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};
s.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.$().removeClass("sapMInputFocused");this.closeValueStateMessage(this);};
s.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};
s.prototype._getSuggestionsTable=function(){if(this._bIsBeingDestroyed){return;}var t=this;if(!this._oSuggestionTable){this._oSuggestionTable=new T(this.getId()+"-popup-table",{mode:m.SingleSelectMaster,showNoData:false,showSeparators:"All",width:"100%",enableBusyIndicator:false,rememberSelections:false,selectionChange:function(E){var i=E.getParameter("listItem");t.setSelectionRow(i,true);}});this._oSuggestionTable.addEventDelegate({onAfterRendering:this._highlightTableText.bind(this)});if(this._bUseDialog){this._oSuggestionTable.addStyleClass("sapMInputSuggestionTableHidden");}this._oSuggestionTable.updateItems=function(){T.prototype.updateItems.apply(this,arguments);t._refreshItemsDelayed();return this;};}return this._oSuggestionTable;};
s.prototype._fireSuggestionItemSelectedEvent=function(){if(this._iPopupListSelectedIndex>=0){var i=this._oList.getItems()[this._iPopupListSelectedIndex];if(i){if(C&&i instanceof C){this.fireSuggestionItemSelected({selectedRow:i});}else{this.fireSuggestionItemSelected({selectedItem:i._oItem});}}this._iPopupListSelectedIndex=-1;}};
s.prototype.clone=function(){var i=j.prototype.clone.apply(this,arguments),t;t=this.getBindingInfo("suggestionColumns");if(t){i.bindAggregation("suggestionColumns",q.extend({},t));}else{this.getSuggestionColumns().forEach(function(u){i.addSuggestionColumn(u.clone(),true);});}t=this.getBindingInfo("suggestionRows");if(t){i.bindAggregation("suggestionRows",q.extend({},t));}else{this.getSuggestionRows().forEach(function(u){i.addSuggestionRow(u.clone(),true);});}i.setRowResultFunction(this._fnRowResultFilter);return i;};
s.prototype.setValue=function(v){this._iSetCount++;I.prototype.setValue.call(this,v);this._onValueUpdated(v);return this;};
s.prototype.setDOMValue=function(v){this._$input.val(v);};
s.prototype.getDOMValue=function(){return this._$input.val();};
s.prototype.updateInputField=function(N){if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()&&this._bUseDialog){this._oPopupInput.setValue(N);this._oPopupInput._doSelect();}else{N=this._getInputValue(N);this.setDOMValue(N);this.onChange(null,null,N);}};
s.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};
s.prototype.preventChangeOnFocusLeave=function(E){return this.bFocusoutDueRendering||this.bValueHelpRequested;};
return s;});
sap.ui.predefine('sap/m/InputBase',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/library','sap/ui/Device','./InputBaseRenderer','jquery.sap.keycodes'],function(q,l,C,E,I,V,M,c,D,a){"use strict";var T=c.TextDirection;var b=c.TextAlign;var d=c.ValueState;
var f=C.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:d.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:b.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/InputBase.designtime"}});
E.call(f.prototype);I.insertFontFaceStyle();M.call(f.prototype);f.prototype.bShowLabelAsPlaceholder=!D.support.input.placeholder;
f.prototype._getPlaceholder=function(){return this.getPlaceholder();};
f.prototype._setLabelVisibility=function(){if(!this.bShowLabelAsPlaceholder){return;}var v=this.$("inner").val();this.$("placeholder").css("display",v?"none":"inline");};
f.prototype._getInputValue=function(v){v=(v===undefined)?this.$("inner").val()||"":v.toString();if(this.getMaxLength&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}return v;};
f.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName;}return this._sInputTagElementName;};
f.prototype.init=function(){this._lastValue="";this.bRenderingPhase=false;this.bFocusoutDueRendering=false;this._bIgnoreNextInputEventNonASCII=false;this.bAfterRenderingWasCalled=false;this._oValueStateMessage=new V(this);};
f.prototype.onBeforeRendering=function(){if(this._bCheckDomValue&&!this.bRenderingPhase){this._sDomValue=this._getInputValue();}this.bRenderingPhase=true;};
f.prototype.onAfterRendering=function(){if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}this._bCheckDomValue=false;this._setLabelVisibility();this.bRenderingPhase=false;this.bAfterRenderingWasCalled=true;};
f.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy();}this._oValueStateMessage=null;};
f.prototype.ontouchstart=function(e){e.setMarked();};
f.prototype.onfocusin=function(e){this._bIgnoreNextInput=!this.bShowLabelAsPlaceholder&&D.browser.msie&&D.browser.version>9&&!!this.getPlaceholder()&&!this._getInputValue()&&this._getInputElementTagName()==="INPUT";this.$().toggleClass("sapMFocus",true);if(this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
f.prototype.onfocusout=function(e){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};
f.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e);}};
f.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering;};
f.prototype.getChangeEventParams=function(){return{};};
f.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()&&this.bShowLabelAsPlaceholder&&e.target.id===this.getId()+"-placeholder"){this.focus();}};
f.prototype.onChange=function(e,p,n){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(n);if(v!==this._lastValue){this.setValue(v);if(e){this._bIgnoreNextInputEventNonASCII=false;}v=this.getValue();this._lastValue=v;this.fireChangeEvent(v,p);return true;}else{this._bCheckDomValue=false;}};
f.prototype.fireChangeEvent=function(v,p){var o=q.extend({value:v,newValue:v},p);this.fireChange(o);};
f.prototype.onValueRevertedByEscape=function(v,p){this.fireEvent("liveChange",{value:v,escPressed:true,previousValue:p,newValue:v});};
f.prototype.onsapenter=function(e){this.onChange(e);};
f.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this._lastValue){e.setMarked();e.preventDefault();this.updateDomValue(this._lastValue);this.onValueRevertedByEscape(this._lastValue,v);}};
f.prototype.oninput=function(e){if(this._bIgnoreNextInput&&this.bAfterRenderingWasCalled){this._bIgnoreNextInput=false;this.bAfterRenderingWasCalled=false;e.setMarked("invalid");return;}this.bAfterRenderingWasCalled=false;if(!this.getEditable()){e.setMarked("invalid");return;}if(this._bIgnoreNextInputEventNonASCII&&this.getValue()===this._lastValue){this._bIgnoreNextInputEventNonASCII=false;e.setMarked("invalid");return;}if(document.activeElement!==e.target&&D.browser.msie&&this.getValue()===this._lastValue){e.setMarked("invalid");return;}this._bCheckDomValue=true;this._setLabelVisibility();};
f.prototype.onkeydown=function(e){if(this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==q.sap.KeyCodes.BACKSPACE){e.preventDefault();}};
f.prototype.oncut=function(e){};
f.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};
f.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};
f.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};
f.prototype.getFocusInfo=function(){var F=C.prototype.getFocusInfo.call(this),o=this.getFocusDomRef();q.extend(F,{cursorPos:0,selectionStart:0,selectionEnd:0});if(o){F.cursorPos=q(o).cursorPos();try{F.selectionStart=o.selectionStart;F.selectionEnd=o.selectionEnd;}catch(e){}}return F;};
f.prototype.applyFocusInfo=function(F){C.prototype.applyFocusInfo.call(this,F);this.$("inner").cursorPos(F.cursorPos);this.selectText(F.selectionStart,F.selectionEnd);return this;};
f.prototype.bindToInputEvent=function(e){if(this._oInputEventDelegate){this.removeEventDelegate(this._oInputEventDelegate);}this._oInputEventDelegate={oninput:e};return this.addEventDelegate(this._oInputEventDelegate);};
f.prototype.updateDomValue=function(v){if(!this.isActive()){return this;}v=this._getInputValue(v);if(D.browser.msie&&D.browser.version>9&&!/^[\x00-\x7F]*$/.test(v)){this._bIgnoreNextInput=true;}if(this._getInputValue()!==v){this.$("inner").val(v);this._bCheckDomValue=true;}this._setLabelVisibility();return this;};
f.prototype.closeValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.close();}};
f.prototype.getDomRefForValueStateMessage=function(){return this.getFocusDomRef();};
f.prototype.iOpenMessagePopupDuration=0;
f.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};
f.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(s){return sap.ui.getCore().byId(s);});var o=sap.ui.require("sap/ui/core/LabelEnablement");if(o){L=L.concat(o.getReferencingLabels(this).map(function(s){return sap.ui.getCore().byId(s);}));}return L;};
f.prototype.openValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.open();}};
f.prototype.updateValueStateClasses=function(v,o){var t=this.$(),i=this.$("inner"),m=d;if(o!==m.None){t.removeClass("sapMInputBaseState sapMInputBase"+o);i.removeClass("sapMInputBaseStateInner sapMInputBase"+o+"Inner");}if(v!==m.None){t.addClass("sapMInputBaseState sapMInputBase"+v);i.addClass("sapMInputBaseStateInner sapMInputBase"+v+"Inner");}};
f.prototype.shouldValueStateMessageBeOpened=function(){return(this.getValueState()!==d.None)&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage();};
f.prototype.setValueState=function(v){var o=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(v===o){return this;}var e=this.getDomRef();if(!e){return this;}var i=this.$("inner"),m=d;if(v===m.Error){i.attr("aria-invalid","true");}else{i.removeAttr("aria-invalid");}this.updateValueStateClasses(v,o);if(i[0]===document.activeElement){if(v===m.None){this.closeValueStateMessage();}else if(this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}}return this;};
f.prototype.setValueStateText=function(t){this.setProperty("valueStateText",t,true);this.$("message").text(this.getValueStateText());return this;};
f.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(D.browser.msie&&D.browser.version>9&&!/^[\x00-\x7F]*$/.test(v)){this._bIgnoreNextInputEventNonASCII=true;}if(v!==this.getProperty("value")){this._lastValue=v;}this.setProperty("value",v,true);return this;};
f.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};
f.prototype.getIdForLabel=function(){return this.getId()+"-inner";};
f.prototype.setTooltip=function(t){var o=this.getDomRef();this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!o){return this;}var s=this.getTooltip_AsString();if(s){o.setAttribute("title",s);}else{o.removeAttribute("title");}if(sap.ui.getCore().getConfiguration().getAccessibility()){var e=this.getDomRef("describedby"),A=this.getRenderer().getDescribedByAnnouncement(this),g=this.getId()+"-describedby",h="aria-describedby",F=this.getFocusDomRef(),i=F.getAttribute(h);if(!e&&A){e=document.createElement("span");e.id=g;e.setAttribute("aria-hidden","true");e.className="sapUiInvisibleText";if(this.getAriaDescribedBy){F.setAttribute(h,(this.getAriaDescribedBy().join(" ")+" "+g).trim());}else{F.setAttribute(h,g);}o.appendChild(e);}else if(e&&!A){o.removeChild(e);var j=e.id;if(i&&j){F.setAttribute(h,i.replace(j,"").trim());}}if(e){e.textContent=A;}}return this;};
f.prototype.getAccessibilityInfo=function(){var r=this.getRequired()?'Required':'',R=this.getRenderer();return{role:R.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValue()||"",R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this),r].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};
Object.defineProperty(f.prototype,"_$input",{get:function(){return this.$("inner");}});return f;});
sap.ui.predefine('sap/m/InputBaseRenderer',['sap/ui/core/Renderer','sap/ui/core/library','sap/ui/Device'],function(R,c,D){"use strict";var T=c.TextDirection;var V=c.ValueState;var I={};
I.render=function(r,C){var v=C.getValueState(),t=C.getTextDirection(),s=R.getTextAlign(C.getTextAlign(),t),a=sap.ui.getCore().getConfiguration().getAccessibility();r.write("<div");r.writeControlData(C);this.addOuterStyles(r,C);this.addControlWidth(r,C);r.writeStyles();r.addClass("sapMInputBase");this.addPaddingClass(r,C);this.addCursorClass(r,C);this.addOuterClasses(r,C);if(!C.getEnabled()){r.addClass("sapMInputBaseDisabled");}if(!C.getEditable()){r.addClass("sapMInputBaseReadonly");}if(v!==V.None){this.addValueStateClasses(r,C);}r.writeClasses();this.writeOuterAttributes(r,C);var b=C.getTooltip_AsString();if(b){r.writeAttributeEscaped("title",b);}r.write(">");this.prependInnerContent(r,C);if(C.bShowLabelAsPlaceholder){r.write("<span");r.writeAttribute("id",C.getId()+"-placeholder");if(s){r.addStyle("text-align",s);}this.addPlaceholderClasses(r,C);this.addPlaceholderStyles(r,C);r.writeClasses();r.writeStyles();r.write(">");r.writeEscaped(C._getPlaceholder());r.write("</span>");}r.write('<div ');r.addClass("sapMInputDivWrapper");if(!C.getEnabled()){r.addClass("sapMInputBaseDisabledInner");}else if(!C.getEditable()){r.addClass("sapMInputBaseReadonlyInner");}r.writeClasses();this.addWrapperStyles(r,C);r.writeStyles();r.write('>');this.openInputTag(r,C);this.writeInnerId(r,C);if(C.getName()){r.writeAttributeEscaped("name",C.getName());}if(!C.bShowLabelAsPlaceholder&&C._getPlaceholder()){r.writeAttributeEscaped("placeholder",C._getPlaceholder());}if(C.getMaxLength&&C.getMaxLength()>0){r.writeAttribute("maxlength",C.getMaxLength());}if(!C.getEnabled()){r.writeAttribute("disabled","disabled");}else if(!C.getEditable()){r.writeAttribute("readonly","readonly");}if(t!=T.Inherit){r.writeAttribute("dir",t.toLowerCase());}this.writeInnerValue(r,C);if(a){this.writeAccessibilityState(r,C);}if(D.browser.mozilla){if(b){r.writeAttributeEscaped("x-moz-errormessage",b);}else{r.writeAttribute("x-moz-errormessage"," ");}}this.writeInnerAttributes(r,C);r.addClass("sapMInputBaseInner");if(v!==V.None){this.addValueStateInnerClasses(r,C);}this.addInnerClasses(r,C);r.writeClasses();if(s){r.addStyle("text-align",s);}this.addInnerStyles(r,C);r.writeStyles();r.write(">");this.writeInnerContent(r,C);this.closeInputTag(r,C);r.write('</div>');this.writeDecorations(r,C);if(a){this.renderAriaLabelledBy(r,C);this.renderAriaDescribedBy(r,C);}r.write("</div>");};
I.getAriaRole=function(C){return"textbox";};
I.getAriaLabelledBy=function(C){if(this.getLabelledByAnnouncement(C)){return C.getId()+"-labelledby";}};
I.getLabelledByAnnouncement=function(C){return C._getPlaceholder()||"";};
I.renderAriaLabelledBy=function(r,C){var a=this.getLabelledByAnnouncement(C);if(a){r.write("<span");r.writeAttribute("id",C.getId()+"-labelledby");r.writeAttribute("aria-hidden","true");r.addClass("sapUiInvisibleText");r.writeClasses();r.write(">");r.writeEscaped(a.trim());r.write("</span>");}};
I.getAriaDescribedBy=function(C){if(this.getDescribedByAnnouncement(C)){return C.getId()+"-describedby";}};
I.getDescribedByAnnouncement=function(C){return C.getTooltip_AsString()||"";};
I.renderAriaDescribedBy=function(r,C){var a=this.getDescribedByAnnouncement(C);if(a){r.write("<span");r.writeAttribute("id",C.getId()+"-describedby");r.writeAttribute("aria-hidden","true");r.addClass("sapUiInvisibleText");r.writeClasses();r.write(">");r.writeEscaped(a.trim());r.write("</span>");}};
I.getAccessibilityState=function(C){var a=this.getAriaLabelledBy(C),A=this.getAriaDescribedBy(C),r=this.getAriaRole(C),m={};if(r){m.role=r;}if(C.getValueState()===V.Error){m.invalid=true;}if(a){m.labelledby={value:a.trim(),append:true};}if(A){m.describedby={value:A.trim(),append:true};}return m;};
I.writeAccessibilityState=function(r,C){r.writeAccessibilityState(C,this.getAccessibilityState(C));};
I.openInputTag=function(r,C){r.write("<input");};
I.writeInnerValue=function(r,C){r.writeAttributeEscaped("value",C.getValue());};
I.addCursorClass=function(r,C){};
I.addPaddingClass=function(r,C){r.addClass("sapMInputBaseWidthPadding");};
I.addOuterStyles=function(r,C){};
I.addControlWidth=function(r,C){if(C.getWidth()){r.addStyle("width",C.getWidth());}};
I.addOuterClasses=function(r,C){};
I.writeOuterAttributes=function(r,C){};
I.addInnerStyles=function(r,C){};
I.addWrapperStyles=function(r,C){};
I.addInnerClasses=function(r,C){};
I.writeInnerAttributes=function(r,C){};
I.prependInnerContent=function(r,C){};
I.writeInnerContent=function(r,C){};
I.writeDecorations=function(r,C){};
I.closeInputTag=function(r,C){};
I.addPlaceholderStyles=function(r,C){};
I.addPlaceholderClasses=function(r,C){r.addClass("sapMInputBasePlaceholder");};
I.addValueStateInnerClasses=function(r,C){r.addClass("sapMInputBaseStateInner");r.addClass("sapMInputBase"+C.getValueState()+"Inner");};
I.addValueStateClasses=function(r,C){r.addClass("sapMInputBaseState");r.addClass("sapMInputBase"+C.getValueState());};
I.writeInnerId=function(r,C){r.writeAttribute("id",C.getId()+"-inner");};
return I;},true);
sap.ui.predefine('sap/m/InputListItem',['./ListItemBase','./library','sap/ui/core/library','./InputListItemRenderer'],function(L,l,c,I){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.InputListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},labelTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/InputListItem.designtime"}});
a.prototype.getContentAnnouncement=function(){var A=this.getLabel();this.getContent().forEach(function(C){A+=L.getAccessibilityText(C)+" ";});return A;};
return a;});
sap.ui.predefine('sap/m/InputListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer','sap/ui/core/library'],function(L,R,c){"use strict";var T=c.TextDirection;var I=R.extend(L);
I.renderLIAttributes=function(r,l){r.addClass("sapMILI");};
I.renderLIContent=function(r,l){var s=l.getLabel();if(s){var a=l.getId()+"-label",b=l.getLabelTextDirection();r.write('<span id="'+a+'" class="sapMILILabel"');if(b!==T.Inherit){r.writeAttribute("dir",b.toLowerCase());}r.write('>');r.writeEscaped(s);r.write('</span>');}r.write('<div class="sapMILIDiv sapMILI-CTX">');l.getContent().forEach(function(C){if(a&&C.addAriaLabelledBy&&C.getAriaLabelledBy().indexOf(a)==-1){C.addAssociation("ariaLabelledBy",a,true);}r.renderControl(C);});r.write('</div>');};
return I;},true);
sap.ui.predefine('sap/m/InputRenderer',['sap/ui/core/InvisibleText','sap/ui/core/Renderer','./InputBaseRenderer','sap/m/library'],function(I,R,a,l){"use strict";var b=l.InputType;var c=R.extend(a);
c.addOuterClasses=function(r,C){r.addClass("sapMInput");if(C.getShowValueHelp()&&C.getEnabled()&&C.getEditable()){r.addClass("sapMInputVH");if(C.getValueHelpOnly()){r.addClass("sapMInputVHO");}}if(C.getDescription()){r.addClass("sapMInputDescription");}};
c.addOuterStyles=function(r,C){};
c.writeInnerAttributes=function(r,C){r.writeAttribute("type",C.getType().toLowerCase());if(C.getType()==b.Number){r.writeAttribute("step","any");}if(C.getType()==b.Number&&sap.ui.getCore().getConfiguration().getRTL()){r.writeAttribute("dir","ltr");r.addStyle("text-align","right");}if(C.getShowSuggestion()){r.writeAttribute("autocomplete","off");}if((!C.getEnabled()&&C.getType()=="Password")||(C.getShowSuggestion()&&C._bUseDialog)||(C.getValueHelpOnly()&&C.getEnabled()&&C.getEditable()&&C.getShowValueHelp())){r.writeAttribute("readonly","readonly");}};
c.addInnerClasses=function(r,C){};
c.addWrapperStyles=function(r,C){if(C.getDescription()){r.addStyle("width",C.getFieldWidth()||"50%");}};
c.writeDecorations=function(r,C){var i=C.getId(),d=C.getDescription();if(!d){this.writeValueHelpIcon(r,C);}else{r.write("<span>");this.writeValueHelpIcon(r,C);r.write('<span id="'+C.getId()+'-Descr" class="sapMInputDescriptionText">');r.writeEscaped(d);r.write("</span></span>");}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){r.write("<span id=\""+i+"-SuggDescr\" class=\"sapUiPseudoInvisibleText\" role=\"status\" aria-live=\"polite\"></span>");}}};
c.writeValueHelpIcon=function(r,C){if(C.getShowValueHelp()&&C.getEnabled()&&C.getEditable()){r.write('<div class="sapMInputValHelp" tabindex="-1">');r.renderControl(C._getValueHelpIcon());r.write("</div>");}};
c.addPlaceholderStyles=function(r,C){if(C.getDescription()){r.addStyle("width",C.getFieldWidth()||"50%");}};
c.getAriaLabelledBy=function(C){var d=a.getAriaLabelledBy.call(this,C)||"";if(C.getDescription()){d=d+" "+C.getId()+"-Descr";}return d;};
c.getAriaDescribedBy=function(C){var A=a.getAriaDescribedBy.apply(this,arguments);function d(s){A=A?A+" "+s:s;}if(C.getShowValueHelp()&&C.getEnabled()&&C.getEditable()){d(I.getStaticId("sap.m","INPUT_VALUEHELP"));if(C.getValueHelpOnly()){d(I.getStaticId("sap.m","INPUT_DISABLED"));}}if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){d(C.getId()+"-SuggDescr");}return A;};
c.getAriaRole=function(C){return"";};
c.getAccessibilityState=function(C){var A=a.getAccessibilityState.apply(this,arguments);if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){A.autocomplete="list";}return A;};
return c;},true);
sap.ui.predefine('sap/m/InstanceManager',['jquery.sap.global'],function(q){"use strict";var I={};(function(){var r={},e=[];var p="_POPOVER_",d="_DIALOG_",l="_LIGHTBOX_";
I.addInstance=function(c,i){if(!r[c]){r[c]=[];}if(r[c].indexOf(i)===-1){r[c].push(i);}return this;};
I.removeInstance=function(c,o){var C=r[c],i;if(!C){q.sap.log.warning("Can't remove control from a non-managed category id: "+c);return null;}i=C.indexOf(o);return(i===-1)?null:C.splice(i,1);};
I.getInstancesByCategoryId=function(c){return r[c]||e;};
I.isInstanceManaged=function(c,i){var C=r[c];if(!C||!i){return false;}return C.indexOf(i)!==-1;};
I.isCategoryEmpty=function(c){var C=r[c];return!C||C.length===0;};
I.addPopoverInstance=function(P){if(typeof P.close==="function"){I.addInstance(p,P);}else{q.sap.log.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addDialogInstance=function(D){if(typeof D.close==="function"){I.addInstance(d,D);}else{q.sap.log.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addLightBoxInstance=function(L){if(typeof L.close==="function"){I.addInstance(l,L);}else{q.sap.log.warning("In method addLightBoxInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.removePopoverInstance=function(P){return I.removeInstance(p,P);};
I.removeDialogInstance=function(D){return I.removeInstance(d,D);};
I.removeLightBoxInstance=function(L){return I.removeInstance(l,L);};
I.hasOpenPopover=function(){return!I.isCategoryEmpty(p);};
I.hasOpenDialog=function(){return!I.isCategoryEmpty(d);};
I.hasOpenLightBox=function(){return!I.isCategoryEmpty(l);};
I.isDialogOpen=function(D){return I.isInstanceManaged(d,D);};
I.isPopoverOpen=function(P){return I.isInstanceManaged(p,P);};
I.isLightBoxOpen=function(L){return I.isInstanceManaged(l,L);};
I.getOpenPopovers=function(){return I.getInstancesByCategoryId(p);};
I.getOpenDialogs=function(){return I.getInstancesByCategoryId(d);};
I.getOpenLightBoxes=function(){return I.getInstancesByCategoryId(l);};
I.closeAllPopovers=function(){var a=I.getOpenPopovers(),i;for(i=0;i<a.length;i++){a[i].close();}return this;};
I.closeAllDialogs=function(c){var D,a=[],b=I.getOpenDialogs(),f,i;for(i=0;i<b.length;i++){f=b[i];if(c){D=new q.Deferred().done();a.push(D);f.attachEvent("afterClose",(function(g){return function(){g.resolve();};}(D)));}f.close();}if(c){q.when.apply(this,a).then(c);}return this;};
I.closeAllLightBoxes=function(){var i=I.getOpenLightBoxes(),L=i.length,a;for(a=0;a<L;a+=1){i[a].close();}return this;};
}());return I;},true);
sap.ui.predefine('sap/m/Label',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/LabelEnablement','sap/ui/core/library','./LabelRenderer'],function(q,l,C,L,c,a){"use strict";var T=c.TextDirection;var b=c.TextAlign;var d=l.LabelDesign;var V=c.VerticalAlign;
var e=C.extend("sap.m.Label",{metadata:{interfaces:["sap.ui.core.Label","sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent"],library:"sap.m",properties:{design:{type:"sap.m.LabelDesign",group:"Appearance",defaultValue:d.Standard},text:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:b.Begin},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},required:{type:"boolean",group:"Misc",defaultValue:false},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/m/designtime/Label.designtime"}});
e.prototype.setText=function(t){var v=this.getText();if(v!==t){this.setProperty("text",t,true);this.$("bdi").html(q.sap.encodeHTML(this.getProperty("text")));if(t){this.$().removeClass("sapMLabelNoText");}else{this.$().addClass("sapMLabelNoText");}}return this;};
e.prototype.setTooltip=function(t){var v=this.getTooltip();if(v!==t){this.setAggregation("tooltip",t,true);this.$().attr("title",this.getTooltip());}return this;};
e.prototype.setDisplayOnly=function(f){if(typeof f!=="boolean"){q.sap.log.error("DisplayOnly property should be boolean. The new value will not be set");return this;}this.$().toggleClass("sapMLabelDisplayOnly",f);return C.prototype.setProperty.call(this,"displayOnly",f);};
e.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};
e.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true,propsUnrelatedToSize:["design","required","displayOnly"]};function g(f){var h=f&&f.getLayoutData();if(i(h,"sap/m/OverflowToolbarLayoutData")){return h.getGroup();}}o.onBeforeEnterOverflow=function(f){var I=false,t,s,h,j,k;t=f.getParent();if(!i(t,"sap/m/OverflowToolbar")){return;}s=f.getLabelFor();h=s&&sap.ui.getCore().byId(s);if(!h||(t.indexOfContent(h)<0)){return;}j=g(f);k=g(h);I=j&&(j===k);f.toggleStyleClass("sapMLabelMediumMarginTop",I,true);};o.onAfterExitOverflow=function(f){f.toggleStyleClass("sapMLabelMediumMarginTop",false,true);};return o;};
L.enrich(e.prototype);
function i(o,m){if(o&&m){var f=sap.ui.require(m);return(typeof f==='function')&&(o instanceof f);}}
return e;});
sap.ui.predefine('sap/m/LabelRenderer',['sap/ui/core/Renderer','sap/m/library','sap/ui/core/library'],function(R,l,c){"use strict";var T=c.TextDirection;var L=l.LabelDesign;var a={};
a.render=function(b,o){var r=a,t=o.getTextDirection(),s=o.getTextAlign(),w=o.getWidth(),d=o.getText(),e=o.getTooltip_AsString(),f=o.getLabelForRendering(),h=f?"label":"span",D=o.isDisplayOnly(),v=o.getVAlign();b.write("<"+h);b.writeControlData(o);b.addClass("sapMLabel");b.addClass("sapUiSelectable");if(o.isWrapping()){b.addClass("sapMLabelWrapped");}if(o.getDesign()==L.Bold){b.addStyle("font-weight","bold");}if(o.isRequired()){b.addClass("sapMLabelRequired");}if(f){sap.ui.core.LabelEnablement.writeLabelForAttribute(b,o);}else if(o.getParent()instanceof sap.m.Toolbar){b.addClass("sapMLabelTBHeader");}if(t!==T.Inherit){b.writeAttribute("dir",t.toLowerCase());}if(w){b.addStyle("width",w);}else{b.addClass("sapMLabelMaxWidth");}if(s){s=r.getTextAlign(s,t);if(s){b.addStyle("text-align",s);}}if(d==""){b.addClass("sapMLabelNoText");}if(D){b.addClass("sapMLabelDisplayOnly");}if(v!=sap.ui.core.VerticalAlign.Inherit){b.addStyle("vertical-align",v.toLowerCase());}b.writeStyles();b.writeClasses();if(e){b.writeAttributeEscaped("title",e);}b.write(">");b.write("<bdi id=\""+o.getId()+"-bdi\" >");if(d){b.writeEscaped(d);}b.write("</bdi>");b.write("</"+h+">");if(!f&&o.isDisplayOnly&&o.isDisplayOnly()){b.write('<span id="'+o.getId()+'-colon" class="sapUiPseudoInvisibleText">:</span>');}};
a.getTextAlign=R.getTextAlign;return a;},true);
sap.ui.predefine('sap/m/LightBox',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/m/Text','sap/m/Button','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/core/Icon','sap/ui/layout/VerticalLayout','./InstanceManager','sap/ui/core/InvisibleText','sap/ui/core/library','./LightBoxRenderer'],function(q,l,C,P,T,B,R,D,I,V,a,b,c,L){'use strict';var d=c.TextAlign;var e=l.ButtonType;var f=l.LightBoxLoadingStates;
var g=C.extend('sap.m.LightBox',{metadata:{interfaces:['sap.ui.core.PopupInterface'],library:'sap.m',aggregations:{imageContent:{type:'sap.m.LightBoxItem',multiple:true,bindable:"bindable"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:'hidden'},_errorIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:'hidden'},_errorTitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_errorSubtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_verticalLayout:{type:'sap.ui.layout.VerticalLayout',multiple:false,visibility:'hidden'},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},events:{},defaultAggregation:'imageContent',designtime:"sap/m/designtime/LightBox.designtime"}});
g.prototype.init=function(){this._createPopup();this._width=0;this._height=0;this._isRendering=true;this._resizeListenerId=null;this._$lightBox=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._closeButtonText=this._rb.getText("LIGHTBOX_CLOSE_BUTTON");if(sap.ui.getCore().getConfiguration().getAccessibility()){this.setAggregation("_invisiblePopupText",new b());}};
g.prototype.onBeforeRendering=function(){var i=this._getImageContent(),n=i._getNativeImage(),s=i.getImageSrc(),S=i._getImageState();this._createErrorControls();if(n.src!==s){n.src=s;}if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}switch(S){case f.Loading:this._timeoutId=setTimeout(function(){i._setImageState(f.TimeOutError);},10000);break;case f.Loaded:clearTimeout(this._timeoutId);this._calculateSizes(n);break;case f.Error:clearTimeout(this._timeoutId);break;default:break;}var o=this.getAggregation('_invisiblePopupText');if(i&&o){o.setText(this._rb.getText("LIGHTBOX_ARIA_ENLARGED",i.getTitle()));}this._isRendering=true;};
g.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._resizeListenerId){this._onResizeHandler=this._onResize.bind(this);D.resize.attachHandler(this._onResizeHandler);this._resizeListenerId=R.register(this,this._onResizeHandler);}};
g.prototype.forceInvalidate=C.prototype.invalidate;
g.prototype.invalidate=function(o){var i=this._getImageContent();if(this.isOpen()){if(i&&i.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};
g.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnOpened,this);this._oPopup.detachClosed(this._fnClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._resizeListenerId){D.resize.detachHandler(this._onResizeHandler);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}a.removeLightBoxInstance(this);};
g.prototype.open=function(){var i=this._getImageContent();this._oPopup.setContent(this);if(i&&i.getImageSrc()){this._oPopup.open(300,'center center','center center',document.body,null);a.addLightBoxInstance(this);}return this;};
g.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};
g.prototype.close=function(){if(this._resizeListenerId){D.resize.detachHandler(this._onResizeHandler);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._oPopup.close();a.removeLightBoxInstance(this);return this;};
g.prototype._getCloseButton=function(){var i=this.getAggregation('_closeButton');if(!i){i=new B({id:this.getId()+'-closeButton',text:this._closeButtonText,type:e.Transparent,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',i,true);}return i;};
g.prototype._getBusyIndicator=function(){var i=this.getAggregation("_busy");if(!i){i=new sap.m.BusyIndicator();this.setAggregation("_busy",i,true);}return i;};
g.prototype._imageStateChanged=function(n){var s=n===f.Loaded||n===f.Error;if(s&&!this._isRendering){this.rerender();}};
g.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnOpened,this);this._oPopup.attachClosed(this._fnClosed,this);};
g.prototype._fnOpened=function(){var t=this;q('#sap-ui-blocklayer-popup').on("click",function(){t.close();});};
g.prototype._fnClosed=function(){q('#sap-ui-blocklayer-popup').off("click");};
g.prototype._createErrorControls=function(){var r=this._rb;var i;var j;if(this._getImageContent()._getImageState()===f.TimeOutError){i=r.getText('LIGHTBOX_IMAGE_TIMED_OUT');j=r.getText('LIGHTBOX_IMAGE_TIMED_OUT_DETAILS');}else{i=r.getText('LIGHTBOX_IMAGE_ERROR');j=r.getText('LIGHTBOX_IMAGE_ERROR_DETAILS');}if(!this.getAggregation('_verticalLayout')){var k=new T({text:i,textAlign:d.Center}).addStyleClass("sapMLightBoxErrorTitle"),m=new T({text:j,textAlign:d.Center}).addStyleClass("sapMLightBoxErrorSubtitle"),n=new I({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation('_verticalLayout',new V({content:[n,k,m]}).addStyleClass('sapMLightBoxVerticalLayout'));}};
g.prototype._onResize=function(){var m=h()/2+'px',t=m,i=m,j='',k='',o=this._getImageContent(),n=this.getDomRef(),p,r,s=h(),u=2;if(o._getImageState()===f.Loaded){this._calculateSizes(o._getNativeImage());p=this._width;r=this._height;this._$lightBox.width(p);this._$lightBox.height(r);}else{p=n.clientWidth;r=n.clientHeight;}if(window.innerWidth>p+s){i='50%';k=Math.round(-p/2);}if(window.innerHeight>r+s){t='50%';j=Math.round(-r/2);}if(sap.ui.getCore().getConfiguration().getTheme()==='sap_hcb'){j-=u;k-=u;}this._$lightBox.css({'top':t,'margin-top':j,'left':i,'margin-left':k});};
g.prototype._calculateSizes=function(i){var F=this._calculateFooterHeightInPx(),j=288-F,k=this._getImageContent().getAggregation("_image"),m;this._setImageSize(k,i.naturalWidth,i.naturalHeight);this._calculateAndSetLightBoxSize(k);m=this._pxToNumber(k.getHeight());this.toggleStyleClass('sapMLightBoxMinSize',(m<j));this._isBusy=false;};
g.prototype._calculateFooterHeightInPx=function(){var i=this.$().parents().hasClass('sapUiSizeCompact');var s=this._getImageContent().getSubtitle();var j=2.5;if(!i){j+=0.5;}if(s){j+=1.5;}return j*16;};
g.prototype._calculateAndSetLightBoxSize=function(i){var j,k=(20*16),m=(18*16),F=this._calculateFooterHeightInPx();j=this._pxToNumber(i.getHeight());this._width=Math.max(k,this._pxToNumber(i.getWidth()));this._height=Math.max(m,j+F);};
g.prototype._setImageSize=function(i,j,k){var m=this._calculateFooterHeightInPx(),n=this._getDimensions(j,k,m);i.setWidth(n.width+'px');i.setHeight(n.height+'px');};
g.prototype._getDimensions=function(i,j,k){var m=20*16,n=18*16,$=q(window),w=$.height(),o=$.width(),p=h(),r=Math.max(o-p,m),s=Math.max(w-p,n),t;s-=k;if(j<=s){if(i<=r){}else{j*=r/i;i=r;}}else{if(i<=r){i*=s/j;j=s;}else{t=Math.max(i/r,j/s);i/=t;j/=t;}}return{width:Math.round(i),height:Math.round(j)};};
g.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};
g.prototype._getImageContent=function(){var r=this.getAggregation('imageContent');return r&&r[0];};
function h(){var s=D.system;if(s.desktop){return 4*16;}if(s.tablet){return 2*16;}return 0;}
return g;});
sap.ui.predefine('sap/m/LightBoxItem',['./library','sap/ui/core/Element','./Image','./Text','sap/ui/core/library'],function(l,E,I,T,c){"use strict";var O=c.OpenState;var L=l.LightBoxLoadingStates;
var a=E.extend("sap.m.LightBoxItem",{metadata:{library:"sap.m",properties:{imageSrc:{type:'sap.ui.core.URI',group:'Appearance',multiple:false,defaultValue:''},alt:{type:'string',group:'Appearance',multiple:false,defaultValue:''},title:{type:'string',group:'Appearance',multiple:false,defaultValue:''},subtitle:{type:'string',group:'Appearance',multiple:false,defaultValue:''}},aggregations:{_image:{type:'sap.m.Image',multiple:false,visibility:'hidden'},_title:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_subtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'}}}});
a.prototype.init=function(){this._createNativeImage();this.setAggregation('_image',new I({decorative:false,densityAware:false}),true);this.setAggregation('_title',new T({wrapping:false}),true);this.setAggregation('_subtitle',new T({wrapping:false}),true);};
a.prototype._createNativeImage=function(){var t=this;this._imageState=L.Loading;this._oImage=new window.Image();this._oImage.onload=function(e){if(this.complete&&t._imageState===L.Loading){t._setImageState(L.Loaded);}};this._oImage.onerror=function(e){t._setImageState(L.Error);};};
a.prototype.exit=function(){this._oImage=null;};
a.prototype._setImageState=function(i){if(i!==this._imageState){this._imageState=i;if(this.getParent()){this.getParent()._imageStateChanged(i);}}};
a.prototype._getImageState=function(){return this._imageState;};
a.prototype._getNativeImage=function(){return this._oImage;};
a.prototype.setImageSrc=function(i){var o=this.getAggregation("_image"),b=this.getParent();if(this.getImageSrc()===i){return this;}this._imageState=L.Loading;if(b&&b._oPopup.getOpenState()===O.OPEN){this._oImage.src=i;}this.setProperty("imageSrc",i,false);o.setSrc(i);return this;};
a.prototype.setAlt=function(b){var i=this.getAggregation("_image");this.setProperty("alt",b,false);i.setAlt(b);return this;};
a.prototype.setTitle=function(t){var o=this.getAggregation("_title");this.setProperty("title",t,false);o.setText(t);return this;};
a.prototype.setSubtitle=function(s){var b=this.getAggregation("_subtitle");this.setProperty("subtitle",s,false);b.setText(s);return this;};
return a;});
sap.ui.predefine('sap/m/LightBoxRenderer',["sap/m/library"],function(l){'use strict';var L=l.LightBoxLoadingStates;var a={};var c='sapMLightBox';var b='sapMLightBoxTwoLines';var d='sapMLightBoxImageContainer';var e='sapMLightBoxImageContainerTwoHeaders';var f='sapMLightBoxError';var g='sapMLightBoxErrorContainer';var h='sapMLightBoxErrorContainerTwoHeaders';var i='sapMLightBoxFooter';var j='sapContrast';var k='sapContrastPlus';var m='sapMLightBoxTitleSection';var n='sapMLightBoxTitle';var o='sapMLightBoxSubtitle';var p='sapMLightBoxFooterTwoLines';
a.render=function(r,C){var q=C._getImageContent();var s=q._getImageState();var t=C.getAggregation('_invisiblePopupText');r.write('<div');r.writeControlData(C);r.addClass(c);if(q.getSubtitle()){r.addClass(b);}if(s!==L.Error){r.addStyle('width',C._width+'px');r.addStyle('height',C._height+'px');}else{r.addClass(f);}r.writeAccessibilityState({role:'dialog',labelledby:t&&t.getId()});r.writeClasses();r.writeStyles();r.write('>');r.renderControl(t);if(s===L.Loading){this.renderBusyState(r,C);}else if(s===L.TimeOutError||s===L.Error){this.renderError(r,C);}else{this.renderImage(r,C);}this.renderFooter(r,C,q);r.write('</div>');C._isRendering=false;};
a.renderImage=function(r,C){var q=C._getImageContent();if(q.getSubtitle()){r.write('<div class="'+e+'">');}else{r.write('<div class="'+d+'">');}r.renderControl(q.getAggregation('_image'));r.write('</div>');};
a.renderError=function(r,C){var q=C._getImageContent(),v=C.getAggregation('_verticalLayout');if(q.getSubtitle()){r.write('<div class="'+h+'">');}else{r.write('<div class="'+g+'">');}r.renderControl(v);r.write('</div>');};
a.renderBusyState=function(r,C){r.renderControl(C._getBusyIndicator());};
a.renderFooter=function(r,C,I){var t=I.getAggregation("_title"),s=I.getAggregation("_subtitle");r.write('<div');r.addClass(i);r.addClass(j);r.addClass(k);if(I.getSubtitle()){r.addClass(p);}r.writeClasses();r.write('>');r.write('<div class="'+m+'">');if(t){r.renderControl(t.addStyleClass(n));}if(s&&s.getText()){r.renderControl(s.addStyleClass(o));}r.write('</div>');r.renderControl(C._getCloseButton());r.write('</div>');};
return a;},true);
sap.ui.predefine('sap/m/Link',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/core/EnabledPropagator','sap/ui/core/library','sap/ui/Device','./LinkRenderer'],function(q,l,C,I,E,c,D,L){"use strict";var T=c.TextDirection;var a=c.TextAlign;
var b=C.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Link.designtime",properties:{text:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},validateUrl:{type:"boolean",group:"Data",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:a.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true}}}});
E.call(b.prototype);
b.prototype.onBeforeRendering=function(){};
b.prototype.onsapspace=function(e){if(this.getEnabled()||this.getHref()){e.setMarked();e.preventDefault();}};
b.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE){this._handlePress(e);if(this.getHref()&&!e.isDefaultPrevented()){e.preventDefault();e.setMarked();var o=document.createEvent('MouseEvents');o.initEvent('click',false,true);this.getDomRef().dispatchEvent(o);}}};
b.prototype._handlePress=function(e){if(this.getEnabled()){e.setMarked();if(!this.firePress()||!this.getHref()){e.preventDefault();}}else{e.preventDefault();}};
b.prototype.onsapenter=b.prototype._handlePress;if(D.support.touch){b.prototype.ontap=b.prototype._handlePress;}else{b.prototype.onclick=b.prototype._handlePress;}
b.prototype.ontouchstart=function(e){if(this.getEnabled()){e.setMarked();}};
b.prototype.setText=function(t){var $=this.$();this.setProperty("text",t,true);t=this.getProperty("text");if(this.writeText){this.writeText(t);}else{$.text(t);}if(t){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}return this;};
b.prototype.setHref=function(u){var i=this._isHrefValid(u);this.setProperty("href",u,true);if(!i){this.$().removeAttr("href");q.sap.log.warning(this+": The href tag of the link was not set since it's not valid.");return this;}if(this.getEnabled()){u=this.getProperty("href");if(!u){this.$().removeAttr("href");}else{this.$().attr("href",u);}}return this;};
b.prototype.setSubtle=function(s){this.setProperty("subtle",s,true);var $=this.$();if($.length){$.toggleClass("sapMLnkSubtle",s);if(s){b._addToDescribedBy($,this._sAriaLinkSubtleId);}else{b._removeFromDescribedBy($,this._sAriaLinkSubtleId);}}if(s&&!b.prototype._sAriaLinkSubtleId){b.prototype._sAriaLinkSubtleId=I.getStaticId("sap.m","LINK_SUBTLE");}return this;};
b.prototype.setEmphasized=function(e){this.setProperty("emphasized",e,true);var $=this.$();if($.length){$.toggleClass("sapMLnkEmphasized",e);if(e){b._addToDescribedBy($,this._sAriaLinkEmphasizedId);}else{b._removeFromDescribedBy($,this._sAriaLinkEmphasizedId);}}if(e&&!b.prototype._sAriaLinkEmphasizedId){b.prototype._sAriaLinkEmphasizedId=I.getStaticId("sap.m","LINK_EMPHASIZED");}return this;};
b.prototype.setWrapping=function(w){this.setProperty("wrapping",w,true);this.$().toggleClass("sapMLnkWrapping",w);return this;};
b.prototype.setEnabled=function(e){e=this.validateProperty("enabled",e);if(e!==this.getProperty("enabled")){this.setProperty("enabled",e,true);var $=this.$();$.toggleClass("sapMLnkDsbl",!e);if(e){$.attr("disabled",false);if(this.getText()){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}$.removeAttr("aria-disabled");if(this.getHref()){$.attr("href",this.getHref());}}else{$.attr("disabled",true);$.attr("tabindex","-1");$.attr("aria-disabled",true);$.removeAttr("href");}}return this;};
b.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().toggleClass("sapMLnkMaxWidth",!w);this.$().css("width",w);return this;};
b.prototype.setTarget=function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;};
b.prototype._isHrefValid=function(u){return this.getValidateUrl()?q.sap.validateUrl(u):true;};
b._addToDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A){$.attr("aria-describedby",A+" "+i);}else{$.attr("aria-describedby",i);}};
b._removeFromDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A&&A.indexOf(i)!==-1){A=A.replace(i,'');if(A.length>1){$.attr("aria-describedby",A);}else{$.removeAttr("aria-describedby");}}};
b.prototype.getAccessibilityInfo=function(){return{role:"link",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LINK"),description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()};};
b.prototype.getFormDoNotAdjustWidth=function(){return true;};
return b;});
sap.ui.predefine('sap/m/LinkRenderer',['sap/ui/core/Renderer','sap/ui/core/LabelEnablement','sap/ui/core/library'],function(R,L,c){"use strict";var T=c.TextDirection;var a={};
a.render=function(r,C){var t=C.getTextDirection(),s=R.getTextAlign(C.getTextAlign(),t),S=C.getAriaLabelledBy().indexOf(C.getId())===-1&&(C.getAriaLabelledBy().length>0||L.getReferencingLabels(C).length>0||(C.getParent()&&C.getParent().enhanceAccessibilityState)),A={role:'link',labelledby:S?{value:C.getId(),append:true}:undefined},h=C.getHref(),i=h&&C._isHrefValid(h);r.write("<a");r.writeControlData(C);r.addClass("sapMLnk");if(C.getSubtle()){r.addClass("sapMLnkSubtle");if(A.describedby){A.describedby+=" "+C._sAriaLinkSubtleId;}else{A.describedby=C._sAriaLinkSubtleId;}}if(C.getEmphasized()){r.addClass("sapMLnkEmphasized");if(A.describedby){A.describedby+=" "+C._sAriaLinkEmphasizedId;}else{A.describedby=C._sAriaLinkEmphasizedId;}}if(!C.getEnabled()){r.addClass("sapMLnkDsbl");r.writeAttribute("disabled","true");r.writeAttribute("tabIndex","-1");}else if(C.getText()){r.writeAttribute("tabIndex","0");}else{r.writeAttribute("tabIndex","-1");}if(C.getWrapping()){r.addClass("sapMLnkWrapping");}if(C.getTooltip_AsString()){r.writeAttributeEscaped("title",C.getTooltip_AsString());}if(i&&C.getEnabled()){r.writeAttributeEscaped("href",h);}if(C.getTarget()){r.writeAttributeEscaped("target",C.getTarget());}if(C.getWidth()){r.addStyle("width",C.getWidth());}else{r.addClass("sapMLnkMaxWidth");}if(s){r.addStyle("text-align",s);}if(t!==T.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.writeAccessibilityState(C,A);r.writeClasses();r.writeStyles();r.write(">");if(this.writeText){this.writeText(r,C);}else{this.renderText(r,C);}r.write("</a>");};
a.renderText=function(r,C){r.writeEscaped(C.getText());};
return a;},true);
sap.ui.predefine('sap/m/List',['./ListBase','./library','./ListRenderer'],function(L,l,a){"use strict";var B=l.BackgroundDesign;
var b=L.extend("sap.m.List",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid}},aggregations:{columns:{type:"sap.m.Column",multiple:true,singularName:"column",deprecated:true}}}});
b.prototype.onBeforeRendering=function(){if(L.prototype.onBeforeRendering){L.prototype.onBeforeRendering.call(this);}if(!this.getColumns().length||this._isColumnsIncompatible()){return;}var p=sap.ui.requireSync("sap/m/Table").prototype;Object.keys(p).forEach(function(k){this[k]=p[k];},this);if(!this.mProperties.hasOwnProperty("backgroundDesign")){this.setBackgroundDesign("Translucent");}};
b.prototype._isColumnsIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMListAsTable").compareTo("1.16")>=0;};
return b;});
sap.ui.predefine('sap/m/ListBase',['jquery.sap.global','./GroupHeaderListItem','./ListItemBase','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/LabelEnablement','sap/ui/Device','sap/m/GrowingEnablement','./ListBaseRenderer','jquery.sap.keycodes'],function(q,G,L,l,C,I,a,b,D,c,d){"use strict";var f=l.ListType;var g=l.ListKeyboardMode;var h=l.ListGrowingDirection;var S=l.SwipeDirection;var j=l.ListSeparators;var k=l.ListMode;var m=l.ListHeaderDesign;
var n=C.extend("sap.m.ListBase",{metadata:{library:"sap.m",properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:m.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:k.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:j.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:S.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:h.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:g.Navigation}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable"},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},dragDropConfig:{name:"dragDropConfig",type:"sap.ui.core.dnd.DragDropBase",multiple:true,singularName:"dragDropConfig"},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}}},designtime:"sap/m/designtime/ListBase.designtime"}});
n.prototype.bAnnounceDetails=true;
n.getInvisibleText=function(){return this.oInvisibleText||(this.oInvisibleText=new a().toStatic());};
n.prototype.sNavItemClass="sapMLIB";
n.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this.data("sap-ui-fastnavgroup","true",true);};
n.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};
n.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(D.system.desktop){this._bItemNavigationInvalidated=true;}};
n.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};
n.prototype.refreshItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(r);}else{if(!this._bReceivingData){this._updateStarted(r);this._bReceivingData=true;}this.refreshAggregation("items");}};
n.prototype.updateItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(r);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(r);}this.updateAggregation("items");this._updateFinished();}};
n.prototype.setBindingContext=function(){this._resetItemsBinding();return C.prototype.setBindingContext.apply(this,arguments);};
n.prototype._bindAggregation=function(N,B){function e(B,E,H){B.events=B.events||{};if(!B.events[E]){B.events[E]=H;}else{var o=B.events[E];B.events[E]=function(){H.apply(this,arguments);o.apply(this,arguments);};}}if(N==="items"){this._resetItemsBinding();e(B,"dataRequested",this._onBindingDataRequestedListener.bind(this));e(B,"dataReceived",this._onBindingDataReceivedListener.bind(this));}C.prototype._bindAggregation.call(this,N,B);};
n.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
n.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId;});};
n.prototype.destroyItems=function(s){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!s){this.invalidate();}return this;};
n.prototype.removeAllItems=function(A){this._oSelectedItem=null;return this.removeAllAggregation("items");};
n.prototype.removeItem=function(i){var o=this.removeAggregation("items",i);if(o&&o===this._oSelectedItem){this._oSelectedItem=null;}return o;};
n.prototype.getItems=function(r){if(r){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};
n.prototype.getId=function(s){var i=this.sId;return s?i+"-"+s:i;};
n.prototype.setGrowing=function(e){e=!!e;if(this.getGrowing()!=e){this.setProperty("growing",e,!e);if(e){this._oGrowingDelegate=new c(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};
n.prototype.setGrowingThreshold=function(t){return this.setProperty("growingThreshold",t,true);};
n.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};
n.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);this.$("nodata-text").text(this.getNoDataText());return this;};
n.prototype.getNoDataText=function(e){if(e&&this._bBusy){return"";}var N=this.getProperty("noDataText");N=N||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return N;};
n.prototype.getSelectedItem=function(){var e=this.getItems(true);for(var i=0;i<e.length;i++){if(e[i].getSelected()){return e[i];}}return null;};
n.prototype.setSelectedItem=function(o,s,F){if(this.indexOfItem(o)<0){q.sap.log.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){o.setSelected((s===undefined)?true:!!s);F&&this._fireSelectionChangeEvent([o]);}};
n.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};
n.prototype.setSelectedItemById=function(i,s){var o=sap.ui.getCore().byId(i);return this.setSelectedItem(o,s);};
n.prototype.getSelectedContexts=function(A){var B=this.getBindingInfo("items"),M=(B||{}).model,o=this.getModel(M);if(!B||!o){return[];}if(A&&this.getRememberSelections()){return this._aSelectedPaths.map(function(p){return o.getContext(p);});}return this.getSelectedItems().map(function(i){return i.getBindingContext(M);});};
n.prototype.removeSelections=function(A,F,e){var i=[];this._oSelectedItem=null;A&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(o){if(!o.getSelected()){return;}if(e&&o.isSelectedBoundTwoWay()){return;}o.setSelected(false,true);i.push(o);!A&&this._updateSelectedPaths(o);},this);if(F&&i.length){this._fireSelectionChangeEvent(i);}return this;};
n.prototype.selectAll=function(F){if(this.getMode()!="MultiSelect"){return this;}var e=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);e.push(i);this._updateSelectedPaths(i);}},this);if(F&&e.length){this._fireSelectionChangeEvent(e,F);}return this;};
n.prototype.getLastMode=function(M){return this._sLastMode;};
n.prototype.setMode=function(M){M=this.validateProperty("mode",M);var o=this.getMode();if(o==M){return this;}this._bSelectionMode=M.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);}else{var s=this.getSelectedItems();if(s.length>1){this.removeSelections(true);}else if(o===k.MultiSelect){this._oSelectedItem=s[0];}}return this.setProperty("mode",M);};
n.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};
n.prototype.setRememberSelections=function(r){this.setProperty("rememberSelections",r,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};
n.prototype.setSelectedContextPaths=function(s){this._aSelectedPaths=s||[];};
n.prototype.getSelectedContextPaths=function(A){if(!A||(A&&this.getRememberSelections())){return this._aSelectedPaths.slice(0);}return this.getSelectedItems().map(function(i){return i.getBindingContextPath();});};
n.prototype.isAllSelectableSelected=function(){if(this.getMode()!=k.MultiSelect){return false;}var i=this.getItems(true),s=this.getSelectedItems().length,e=i.filter(function(o){return o.isSelectable();}).length;return(i.length>0)&&(s==e);};
n.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};
n.prototype.getActiveItem=function(){return this._bActiveItem;};
n.prototype.onItemDOMUpdate=function(o){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}};
n.prototype.onItemActiveChange=function(o,A){this._bActiveItem=A;};
n.prototype.onItemHighlightChange=function(i,N){this._iItemNeedsHighlight+=(N?1:-1);if(this._iItemNeedsHighlight==1&&N){this.$("listUl").addClass("sapMListHighlight");}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight");}};
n.prototype.onItemSelectedChange=function(o,s){if(this.getMode()==k.MultiSelect){this._updateSelectedPaths(o,s);return;}if(s){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=o;}else if(this._oSelectedItem===o){this._oSelectedItem=null;}this._updateSelectedPaths(o,s);};
n.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};
n.prototype.checkGrowingFromScratch=function(){};
n.prototype.onBeforePageLoaded=function(o,s){this._fireUpdateStarted(s,o);this.fireGrowingStarted(o);};
n.prototype.onAfterPageLoaded=function(o,s){this._fireUpdateFinished(o);this.fireGrowingFinished(o);};
n.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};
n.prototype.getMaxItemsCount=function(){var B=this.getBinding("items");if(B&&B.getLength){return B.getLength()||0;}return this.getItems(true).length;};
n.prototype.shouldRenderItems=function(){return true;};
n.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};
n.prototype._updateStarted=function(r){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(r);}};
n.prototype._fireUpdateStarted=function(r,i){this._sUpdateReason=q.sap.charToUpperCase(r||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};
n.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};
n.prototype._fireUpdateFinished=function(i){this._hideBusyIndicator();q.sap.delayedCall(0,this,function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});});};
n.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=q.sap.delayedCall(this.getBusyIndicatorDelay(),this,function(){this.$("nodata-text").text("");});this.setBusy(true,"listUl");}};
n.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");q.sap.clearDelayedCall(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};
n.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var p=i.getBindingContextPath();if(p){var s=(this._aSelectedPaths.indexOf(p)>-1);i.setSelected(s);}};
n.prototype.onItemInserted=function(i,s){if(s){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()||i.getSelected()){return;}var p=i.getBindingContextPath();if(p&&this._aSelectedPaths.indexOf(p)>-1){i.setSelected(true);}};
n.prototype.onItemSelect=function(o,s){if(this.getMode()==k.MultiSelect){this._fireSelectionChangeEvent([o]);}else if(this._bSelectionMode&&s){this._fireSelectionChangeEvent([o]);}};
n.prototype._fireSelectionChangeEvent=function(e,s){var o=e&&e[0];if(!o){return;}this.fireSelectionChange({listItem:o,listItems:e,selected:o.getSelected(),selectAll:!!s});this.fireSelect({listItem:o});};
n.prototype.onItemDelete=function(o){this.fireDelete({listItem:o});};
n.prototype.onItemPress=function(o,s){if(o.getType()==f.Inactive){return;}q.sap.delayedCall(0,this,function(){this.fireItemPress({listItem:o,srcControl:s});});};
n.prototype._updateSelectedPaths=function(i,s){if(!this.getRememberSelections()||!this.isBound("items")){return;}var p=i.getBindingContextPath();if(!p){return;}s=(s===undefined)?i.getSelected():s;var e=this._aSelectedPaths.indexOf(p);if(s){e<0&&this._aSelectedPaths.push(p);}else{e>-1&&this._aSelectedPaths.splice(e,1);}};
n.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};
n.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};
n.prototype._getTouchBlocker=function(){return this.$().children();};
n.prototype._getSwipeContainer=function(){return this._$swipeContainer||(q.sap.require("sap.m.InstanceManager"),this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"}));};
n.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};
n.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),e=this._getSwipeContainer();this.$().prepend(e.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var r=sap.ui.getCore().createRenderManager();r.render(this.getSwipeContent(),e.empty()[0]);r.destroy();}return this;};
n.prototype._swipeIn=function(){var t=this,$=t._getTouchBlocker(),i=t._getSwipeContainer();t._isSwipeActive=true;t._renderSwipeContent();sap.m.InstanceManager.addDialogInstance(t);window.document.activeElement.blur();q(window).on("resize.swp",function(){t._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!i[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});i.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");i.css("opacity",1).focus();$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!i[0].firstChild.contains(e.target)){t.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};
n.prototype._onSwipeOut=function(e){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof e=="function"){e.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;sap.m.InstanceManager.removeDialogInstance(this);};
n.prototype.swipeOut=function(e){if(!this._isSwipeActive){return this;}var t=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._onSwipeOut(e);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};
n.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};
n.prototype.close=n.prototype._removeSwipeContent;
n.prototype._onSwipe=function(e){var o=this.getSwipeContent(),s=e.srcControl;if(o&&s&&!this._isSwipeActive&&this!==s&&!this._eventHandledByControl&&D.support.touch){for(var i=s;i&&!(i instanceof L);i=i.oParent);if(i instanceof L){this._swipedItem=i;this.fireSwipe({listItem:this._swipedItem,swipeContent:o,srcControl:s},true)&&this._swipeIn();}}};
n.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};
n.prototype.onswipeleft=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"RightToLeft":"LeftToRight";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};
n.prototype.onswiperight=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"LeftToRight":"RightToLeft";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};
n.prototype.setSwipeDirection=function(s){return this.setProperty("swipeDirection",s,true);};
n.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};
n.prototype.setSwipeContent=function(o){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!o);return this.setAggregation("swipeContent",o,!this._isSwipeActive);};
n.prototype.invalidate=function(o){if(o&&o===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return this;}return C.prototype.invalidate.apply(this,arguments);};
n.prototype.addItemGroup=function(o,H,s){H=H||new G({title:o.text||o.key});H._bGroupHeader=true;this.addAggregation("items",H,s);return H;};
n.prototype.removeGroupHeaders=function(s){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(s);}});};
n.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LIST");};
n.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return"";}var s="",M=k,e=this.getMode(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(b.isRequired(this)){s+=B.getText("LIST_REQUIRED")+" ";}if(e==M.MultiSelect){s+=B.getText("LIST_MULTISELECTABLE")+" ";}else if(e==M.Delete){s+=B.getText("LIST_DELETABLE")+" ";}else if(e!=M.None){s+=B.getText("LIST_SELECTABLE")+" ";}if(this.isGrouped()){s+=B.getText("LIST_GROUPED")+" ";}return s;};
n.prototype.getAccessibilityDescription=function(){var s=this.getAriaLabelledBy().map(function(A){var o=sap.ui.getCore().byId(A);return L.getAccessibilityText(o);}).join(" ");var H=this.getHeaderToolbar();if(H){var t=H.getTitleControl();if(t){s+=t.getText()+" ";}}else{s+=this.getHeaderText()+" ";}s+=this.getAccessibilityStates()+" ";return s;};
n.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityDescription().trim(),focusable:true};};
n.prototype.getAccessbilityPosition=function(i){var s=0,e=this.getVisibleItems(),p=e.indexOf(i)+1,B=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&B&&B.isLengthFinal()){s=B.getLength();if(B.isGrouped()){s+=e.filter(function(i){return i.isGroupHeader()&&i.getVisible();}).length;}}else{s=e.length;}return{setSize:s,posInset:p};};
n.prototype.onItemFocusIn=function(i){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}var o=i.getDomRef(),p=this.getAccessbilityPosition(i);if(!i.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",o.id);o.setAttribute("aria-posinset",p.posInset);o.setAttribute("aria-setsize",p.setSize);}else{var A=i.getAccessibilityInfo(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=A.type+" ";s+=B.getText("LIST_ITEM_POSITION",[p.posInset,p.setSize])+" ";s+=A.description;this.updateInvisibleText(s,o);return s;}};
n.prototype.updateInvisibleText=function(t,i,p){var o=n.getInvisibleText(),F=q(i||document.activeElement);if(this.bAnnounceDetails){this.bAnnounceDetails=false;t=this.getAccessibilityInfo().description+" "+t;}o.setText(t.trim());F.addAriaLabelledBy(o.getId(),p);window.setTimeout(function(){F.removeAriaLabelledBy(o.getId());},0);};
n.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};
n.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};
n.prototype._startItemNavigation=function(i){if(!D.system.desktop){return;}var K=this.getKeyboardMode(),e=g;if(K==e.Edit&&!this.getItems(true).length){return;}if(i&&!this.getNavigationRoot().contains(document.activeElement)){this._bItemNavigationInvalidated=true;return;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);var t=(K==e.Edit)?-1:0;this._setItemNavigationTabIndex(t);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}this._oItemNavigation.setPageSize(this.getGrowingThreshold());var N=this.getNavigationRoot();this._oItemNavigation.setRootDomRef(N);this.setNavigationItems(this._oItemNavigation,N);this._bItemNavigationInvalidated=false;};
n.prototype.setNavigationItems=function(i,N){var e=q(N).children(".sapMLIB").get();i.setItemDomRefs(e);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==h.Upwards){i.setFocusedIndex(e.length-1);}else{i.setFocusedIndex(0);}}};
n.prototype.getItemNavigation=function(){return this._oItemNavigation;};
n.prototype._setItemNavigationTabIndex=function(t){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=t;this._oItemNavigation.iTabIndex=t;}};
n.prototype.setKeyboardMode=function(K){this.setProperty("keyboardMode",K,true);if(this.isActive()){var t=(K==g.Edit)?-1:0;this.$("nodata").prop("tabIndex",~t);this.$("listUl").prop("tabIndex",t);this.$("after").prop("tabIndex",t);this._setItemNavigationTabIndex(t);}return this;};
n.prototype.setItemFocusable=function(o){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var e=i.indexOf(o.getDomRef());if(e>=0){this._oItemNavigation.setFocusedIndex(e);}};
n.prototype.forwardTab=function(F){this._bIgnoreFocusIn=true;this.$(F?"after":"before").focus();};
n.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==g.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};
n.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==g.Edit){return;}var t=e.target.id;if(t==this.getId("nodata")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};
n.prototype._navToSection=function(F){var t;var i=0;var s=F?1:-1;var e=this._aNavSections.length;this._aNavSections.some(function(p,r){var u=q.sap.domById(p);if(u&&u.contains(document.activeElement)){i=r;return true;}});var o=this.getItemsContainerDomRef();var $=q.sap.byId(this._aNavSections[i]);if($[0]===o&&this._oItemNavigation){$.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+s+e)%e;t=q.sap.byId(this._aNavSections[i]);if(t[0]===o&&this._oItemNavigation){var r=t.data("redirect");var p=this._oItemNavigation.getItemDomRefs();var T=p[r]||o.children[0];t=q(T);}if(t.is(":focusable")){t.focus();return true;}},this);return t;};
n.prototype.onsapshow=function(e){if(e.isMarked()||e.which==q.sap.KeyCodes.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};
n.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};
n.prototype.onkeydown=function(e){var i=(e.which==q.sap.KeyCodes.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!i||!q(e.target).hasClass(this.sNavItemClass)){return;}e.preventDefault();if(this.getMode()!==k.MultiSelect){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};
n.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}};
n.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var N=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(N[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");var F=t.eq(-1).add($).eq(-1);this.bAnnounceDetails=true;F.focus();};
n.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}var t=e.target;if(t.id==this.getId("nodata")){this.updateInvisibleText(this.getNoDataText(),t);}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==g.Edit||t.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};
n.prototype.onsapfocusleave=function(e){if(this._oItemNavigation&&!this.bAnnounceDetails&&!this.getNavigationRoot().contains(document.activeElement)){this.bAnnounceDetails=true;}};
n.prototype.onItemArrowUpDown=function(o,e){var i=this.getItems(true),p=i.indexOf(o)+(e.type=="sapup"?-1:1),r=i[p];if(r&&r.isGroupHeader()){r=i[p+(e.type=="sapup"?-1:1)];}if(!r){return;}var t=r.getTabbables(),F=o.getTabbables().index(e.target),E=t.eq(t[F]?F:-1);E[0]?E.focus():r.focus();e.preventDefault();e.setMarked();};
n.prototype.getAggregationDomRef=function(A){if(A=="items"){return this.getItemsContainerDomRef();}};
n.prototype.onItemContextMenu=function(o,e){var i=this.getContextMenu();if(!i){return;}var E=this.fireBeforeOpenContextMenu({listItem:o,column:sap.ui.getCore().byId(q(e.target).closest(".sapMListTblCell",this.getNavigationRoot()).attr("data-sap-ui-column"))});if(E){e.setMarked();e.preventDefault();var B,p=this.getBindingInfo("items");if(p){B=o.getBindingContext(p.model);i.setBindingContext(B);}i.openAsContextMenu(e,o);}};
n.prototype.isGrouped=function(){var B=this.getBinding("items");return B&&B.isGrouped();};
n.prototype.setContextMenu=function(o){this.setAggregation("contextMenu",o,true);};
n.prototype.destroyContextMenu=function(){this.destroyAggregation("contextMenu",true);};
return n;});
sap.ui.predefine('sap/m/ListBaseRenderer',['./ListItemBaseRenderer','sap/m/library','sap/ui/Device'],function(L,l,D){"use strict";var a=l.ListGrowingDirection;var b=l.ListKeyboardMode;var T=l.ToolbarDesign;var c={};c.ModeOrder={None:0,Delete:1,MultiSelect:-1,SingleSelect:1,SingleSelectLeft:-1,SingleSelectMaster:0};
c.render=function(r,C){r.write("<div");r.addClass("sapMList");r.writeControlData(C);if(C.getInset()){r.addClass("sapMListInsetBG");}if(C.getWidth()){r.addStyle("width",C.getWidth());}if(C.getBackgroundDesign){r.addClass("sapMListBG"+C.getBackgroundDesign());}var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}this.renderContainerAttributes(r,C);r.writeStyles();r.writeClasses();r.write(">");var h=C.getHeaderText();var H=C.getHeaderToolbar();if(H){H.setDesign(T.Transparent,true);H.addStyleClass("sapMListHdrTBar");H.addStyleClass("sapMTBHeader-CTX");r.renderControl(H);}else if(h){r.write("<header class='sapMListHdr'");r.writeAttribute("id",C.getId("header"));r.write(">");r.writeEscaped(h);r.write("</header>");}var I=C.getInfoToolbar();if(I){I.setDesign(T.Info,true);I.addStyleClass("sapMListInfoTBar");r.renderControl(I);}var d=C.getItems(),s=C.getShowNoData(),R=C.shouldRenderItems()&&d.length,e=C.getKeyboardMode()==b.Edit?-1:0,u=C.getGrowingDirection()==a.Upwards&&C.getGrowing();if(u){this.renderGrowing(r,C);}if(R||s){this.renderDummyArea(r,C,"before",-1);}this.renderListStartAttributes(r,C);r.writeAccessibilityState(C,this.getAccessibilityState(C));r.addClass("sapMListUl");if(C._iItemNeedsHighlight){r.addClass("sapMListHighlight");}r.writeAttribute("id",C.getId("listUl"));if(R||s){r.writeAttribute("tabindex",e);}r.addClass("sapMListShowSeparators"+C.getShowSeparators());r.addClass("sapMListMode"+C.getMode());C.getInset()&&r.addClass("sapMListInset");r.writeClasses();r.writeStyles();r.write(">");this.renderListHeadAttributes(r,C);if(R){if(u){d.reverse();}for(var i=0;i<d.length;i++){r.renderControl(d[i]);}}if(!R&&s){this.renderNoData(r,C);}this.renderListEndAttributes(r,C);if(R||s){this.renderDummyArea(r,C,"after",e);}if(!u){this.renderGrowing(r,C);}if(C.getFooterText()){r.write("<footer class='sapMListFtr'");r.writeAttribute("id",C.getId("footer"));r.write(">");r.writeEscaped(C.getFooterText());r.write("</footer>");}r.write("</div>");};
c.renderContainerAttributes=function(r,C){};
c.renderListHeadAttributes=function(r,C){};
c.renderListStartAttributes=function(r,C){r.write("<ul");C.addNavSection(C.getId("listUl"));};
c.getAriaRole=function(C){return"listbox";};
c.getAriaLabelledBy=function(C){};
c.getAriaDescribedBy=function(C){if(C.getFooterText()){return C.getId("footer");}};
c.getAccessibilityState=function(C){return{role:this.getAriaRole(C),multiselectable:C._bSelectionMode?C.getMode()=="MultiSelect":undefined,labelledby:{value:this.getAriaLabelledBy(C),append:true},describedby:{value:this.getAriaDescribedBy(C),append:true}};};
c.renderListEndAttributes=function(r,C){r.write("</ul>");};
c.renderNoData=function(r,C){r.write("<li");r.writeAttribute("tabindex",C.getKeyboardMode()==b.Navigation?-1:0);r.writeAttribute("id",C.getId("nodata"));r.addClass("sapMLIB sapMListNoData sapMLIBTypeInactive");L.addFocusableClasses.call(L,r);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMListNoDataText");r.writeAttribute("id",C.getId("nodata-text"));r.writeClasses();r.write(">");r.writeEscaped(C.getNoDataText(true));r.write("</div>");r.write("</li>");};
c.renderDummyArea=function(r,C,A,t){r.write("<div");r.writeAttribute("id",C.getId(A));r.writeAttribute("tabindex",t);if(D.system.desktop){r.addClass("sapMListDummyArea").writeClasses();}r.write("></div>");};
c.renderGrowing=function(r,C){var g=C._oGrowingDelegate;if(!g){return;}g.render(r);};
return c;},true);
sap.ui.predefine('sap/m/ListItemBase',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Icon','sap/m/Button','sap/ui/model/BindingMode','sap/ui/Device','sap/m/CheckBox','./ListItemBaseRenderer','jquery.sap.keycodes'],function(q,l,C,I,a,B,b,D,c,L){"use strict";var d=l.ListKeyboardMode;var e=l.ListMode;var f=l.ListType;var g=l.ButtonType;
var h=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:f.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:"None"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designtime:"sap/m/designtime/ListItemBase.designtime"}});
h.getAccessibilityText=function(o,i){if(!o||!o.getVisible||!o.getVisible()){return"";}var A;if(o.getAccessibilityInfo){A=o.getAccessibilityInfo();}if(!A||!o.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(o.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var j=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" "+A.description+" ",T=o.getTooltip_AsString();if(A.enabled===false){t+=j.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=j.getText("CONTROL_READONLY")+" ";}if(!A.type&&T&&t.indexOf(T)==-1){t=T+" "+t;}A.children.forEach(function(k){t+=h.getAccessibilityText(k)+" ";});t=t.trim();if(i&&!t){t=j.getText("CONTROL_EMPTY");}return t;};
h.getDefaultAccessibilityInfo=function(o){if(!o){return null;}var N=window.Node,i=window.NodeFilter,t=document.createTreeWalker(o,i.SHOW_TEXT+i.SHOW_ELEMENT,function(n){if(n.type===N.ELEMENT_NODE){if(n.classList.contains("sapUiInvisibleText")){return i.FILTER_SKIP;}if(n.getAttribute("aria-hidden")=="true"||n.style.visibility=="hidden"||n.style.display=="none"){return i.FILTER_REJECT;}return i.FILTER_SKIP;}return i.FILTER_ACCEPT;},false);var T=[];while(t.nextNode()){var n=t.currentNode;if(n.nodeType===N.TEXT_NODE){var s=(n.nodeValue||"").trim();if(s){T.push(s);}}}return{description:T.join(" ")};};
h.prototype.DetailIconURI=I.getIconURI("edit");h.prototype.DeleteIconURI=I.getIconURI("sys-cancel");h.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");h.prototype.TagName="li";
h.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;};
h.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();};
h.prototype.getBindingContextPath=function(m){var o=this.getList();if(o&&!m){m=(o.getBindingInfo("items")||{}).model;}var i=this.getBindingContext(m);if(i){return i.getPath();}};
h.prototype.isSelectedBoundTwoWay=function(){var o=this.getBinding("selected");if(o&&o.getBindingMode()==b.TwoWay){return true;}};
h.prototype.getList=function(){var p=this.getParent();if(p instanceof sap.m.ListBase){return p;}};
h.prototype.getListProperty=function(p,F){var o=this.getList();if(o){p=q.sap.charToUpperCase(p);return o["get"+p]();}return F;};
h.prototype.informList=function(E,p,P){var o=this.getList();if(o){var m="onItem"+E;if(o[m]){o[m](this,p,P);}}};
h.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};
h.prototype.getAccessibilityType=function(o){return o.getText("ACC_CTR_TYPE_OPTION");};
h.prototype.getGroupAnnouncement=function(){return this.$().prevAll(".sapMGHLI:first").text();};
h.prototype.getAccessibilityDescription=function(o){var O=[],t=f,T=this.getType(),H=this.getHighlight(),s=this.getTooltip_AsString();if(this.getSelected()){O.push(o.getText("LIST_ITEM_SELECTED"));}if(H!="None"){O.push(o.getText("LIST_ITEM_STATE_"+H.toUpperCase()));}if(this.getUnread()&&this.getListProperty("showUnread")){O.push(o.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){O.push(o.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(T==t.Navigation){O.push(o.getText("LIST_ITEM_NAVIGATION"));}else{if(T==t.Detail||T==t.DetailAndActive){O.push(o.getText("LIST_ITEM_DETAIL"));}if(T==t.Active||T==t.DetailAndActive){O.push(o.getText("LIST_ITEM_ACTIVE"));}}O.push(this.getGroupAnnouncement()||"");if(this.getContentAnnouncement){O.push((this.getContentAnnouncement(o)||"").trim());}if(s){O.push(s);}return O.join(" ");};
h.prototype.getAccessibilityInfo=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(o),description:this.getAccessibilityDescription(o),focusable:true};};
h.prototype.getMode=function(){return this.getListProperty("mode","");};
h.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var i=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":i.length,"aria-posinset":i.index(t)+1},A));};
h.prototype.getDeleteControl=function(){if(this._oDeleteControl){return this._oDeleteControl;}this._oDeleteControl=new B({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:g.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(E){this.informList("Delete");},this);this._oDeleteControl._bExcludeFromTabChain=true;return this._oDeleteControl;};
h.prototype.getDetailControl=function(){if(this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new B({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:g.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this);this._oDetailControl._bExcludeFromTabChain=true;return this._oDetailControl;};
h.prototype.getNavigationControl=function(){if(this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new a({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};
h.prototype.getSingleSelectControl=function(){if(this._oSingleSelectControl){return this._oSingleSelectControl;}this._oSingleSelectControl=new sap.m.RadioButton({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oSingleSelectControl;};
h.prototype.getMultiSelectControl=function(){if(this._oMultiSelectControl){return this._oMultiSelectControl;}this._oMultiSelectControl=new c({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oMultiSelectControl;};
h.prototype.getModeControl=function(u){var m=this.getMode(),i=e;if(!m||m==i.None){return;}if(m==i.Delete){return this.getDeleteControl();}var s=null;if(m==i.MultiSelect){s=this.getMultiSelectControl();}else{s=this.getSingleSelectControl();}if(s&&u){s.setSelected(this.getSelected());}return s;};
h.prototype.getTypeControl=function(){var t=this.getType(),T=f;if(t==T.Detail||t==T.DetailAndActive){return this.getDetailControl();}if(t==T.Navigation){return this.getNavigationControl();}};
h.prototype.destroyControls=function(i){i.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};
h.prototype.isActionable=function(){return this.getListProperty("includeItemInSelection")||this.getMode()==e.SingleSelectMaster||(this.getType()!=f.Inactive&&this.getType()!=f.Detail);};
h.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};
h.prototype.isSelectable=function(){var m=this.getMode();return!(m==e.None||m==e.Delete);};
h.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};
h.prototype.isSelected=h.prototype.getSelected;
h.prototype.setSelected=function(s,i){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!i){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};
h.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};
h.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};
h.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};
h.prototype.isGroupHeader=function(){return this._bGroupHeader;};
h.prototype.isIncludedIntoSelection=function(){var m=this.getMode(),M=e;return(m==M.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(m==M.SingleSelectLeft||m==M.SingleSelect||m==M.MultiSelect)));};
h.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!="None");}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};
h.prototype.hasActiveType=function(){var t=f,T=this.getType();return(T==t.Active||T==t.Navigation||T==t.DetailAndActive);};
h.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==f.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};
h.prototype.ontap=function(E){if(this._eventHandledByControl){return E.setMarked();}var t=window.getSelection().toString().replace("\n","");if(t){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==e.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(D.os.ios){this.focus();}q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}this.informList("Press",E.srcControl);};
h.prototype.ontouchstart=function(E){this._eventHandledByControl=E.isMarked();var t=E.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||E.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=q.sap.delayedCall(100,this,function(){this.setActive(true);});};
h.prototype.ontouchmove=function(E){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-E.targetTouches[0].clientY)>10||Math.abs(this._touchedX-E.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};
h.prototype.ontouchend=function(E){if(E.targetTouches.length==0&&this.hasActiveType()){this._timeoutIdEnd=q.sap.delayedCall(100,this,function(){this.setActive(false);});}};
h.prototype.ontouchcancel=h.prototype.ontouchend;
h.prototype._activeHandlingNav=function(){};
h.prototype._activeHandlingInheritor=function(){};
h.prototype._inactiveHandlingInheritor=function(){};
h.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(D.system.Desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};
h.prototype.onsapspace=function(E){if(E.srcControl!==this){return;}E.preventDefault();if(E.isMarked()||!this.isSelectable()){return;}if(this.getMode()==e.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}E.setMarked();};
h.prototype.onsapenter=function(E){var o=this.getList();if(E.isMarked()||!o){return;}var k=d;if(E.srcControl!==this&&o.getKeyboardMode()==k.Edit){o.setKeyboardMode(k.Navigation);this._switchFocus(E);return;}if(E.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(E);}else if(this.hasActiveType()){E.setMarked();this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}o.onItemPress(this,E.srcControl);};
h.prototype.onsapdelete=function(E){if(E.isMarked()||E.srcControl!==this||this.getMode()!=e.Delete){return;}this.informList("Delete");E.preventDefault();E.setMarked();};
h.prototype._switchFocus=function(E){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(E.srcControl!==this){o._iLastFocusPosOfItem=t.index(E.target);this.focus();}else if(t.length){var F=o._iLastFocusPosOfItem||0;F=t[F]?F:-1;t.eq(F).focus();}E.preventDefault();E.setMarked();};
h.prototype.onkeydown=function(E){if(E.isMarked()){return;}var k=q.sap.KeyCodes;if(E.which==k.F7){this._switchFocus(E);return;}if(E.which==k.F2){if(E.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();E.preventDefault();E.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);var K=d;o.setKeyboardMode(o.getKeyboardMode()==K.Edit?K.Navigation:K.Edit);this._switchFocus(E);}}}};
h.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};
h.prototype.onsaptabnext=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==d.Edit){return;}var i=this.getTabbables().get(-1)||this.getDomRef();if(E.target===i){o.forwardTab(true);E.setMarked();}};
h.prototype.onsaptabprevious=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==d.Edit){return;}if(E.target===this.getDomRef()){o.forwardTab(false);E.setMarked();}};
h.prototype.onfocusin=function(E){var o=this.getList();if(!o||E.isMarked()){return;}if(E.srcControl===this){o.onItemFocusIn(this);return;}if(o.getKeyboardMode()==d.Edit||!q(E.target).is(":sapFocusable")){return;}q.sap.delayedCall(0,o,"setItemFocusable",[this]);E.setMarked();};
h.prototype.onsapup=function(E){if(E.isMarked()||E.srcControl===this||this.getListProperty("keyboardMode")===d.Navigation){return;}this.informList("ArrowUpDown",E);};
h.prototype.oncontextmenu=function(E){if(this._bGroupHeader){return;}if(q(document.activeElement).is(":focusable")&&document.activeElement!==this.getDomRef()&&E.srcControl!==this.getModeControl()){return;}this.informList("ContextMenu",E);};
h.prototype.onsapdown=h.prototype.onsapup;return h;});
sap.ui.predefine('sap/m/ListItemBaseRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/InvisibleText"],function(l,D,I){"use strict";var L=l.ListType;var a=l.ListMode;var b={};
b.renderInvisible=function(r,o){this.openItemTag(r,o);r.writeInvisiblePlaceholderData(o);r.write(">");this.closeItemTag(r,o);};
b.renderHighlight=function(r,o){var h=o.getHighlight();if(h=="None"){return;}r.write("<div");r.addClass("sapMLIBHighlight");r.addClass("sapMLIBHighlight"+h);r.writeClasses();r.write("></div>");};
b.isModeMatched=function(m,o){var O=(sap.m.ListBaseRenderer||{}).ModeOrder||{};return(O[m]==o);};
b.renderMode=function(r,o,O){var m=o.getMode();if(!this.isModeMatched(m,O)){return;}var M=o.getModeControl(true);if(M){this.renderModeContent(r,o,M);}};
b.renderModeContent=function(r,o,m){this.decorateMode(m,o);r.renderControl(m);};
b.decorateMode=function(m,o){m.removeStyleClass("sapMLIBSelectAnimation sapMLIBUnselectAnimation");if(!sap.ui.getCore().getConfiguration().getAnimation()||!o.getListProperty("modeAnimationOn")){return;}var M=o.getMode(),s=o.getListProperty("lastMode");if(!s||s==M){return;}if(M==a.None){m.addStyleClass("sapMLIBUnselectAnimation");}else{m.addStyleClass("sapMLIBSelectAnimation");}};
b.renderCounter=function(r,o){var c=o.getCounter();if(c){this.renderCounterContent(r,o,c);}};
b.renderCounterContent=function(r,o,c){r.write("<div");r.writeAttribute("id",o.getId()+"-counter");var A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_COUNTER",c);r.writeAttribute("aria-label",A);r.addClass("sapMLIBCounter");r.writeClasses();r.write(">");r.write(c);r.write("</div>");};
b.renderType=function(r,o){var t=o.getTypeControl();if(t){r.renderControl(t);}};
b.openItemTag=function(r,o){r.write("<"+o.TagName);};
b.closeItemTag=function(r,o){r.write("</"+o.TagName+">");};
b.renderTabIndex=function(r,o){r.writeAttribute("tabindex","-1");};
b.renderTooltip=function(r,o){var t=o.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}};
b.addFocusableClasses=function(r,o){if(D.system.desktop){r.addClass("sapMLIBFocusable");this.addLegacyOutlineClass(r,o);}};
b.addLegacyOutlineClass=function(r,o){if(D.browser.msie||D.browser.edge){r.addClass("sapMLIBLegacyOutline");}};
b.getAriaAnnouncement=function(k,B){return I.getStaticId("sap.m",B||"LIST_ITEM_"+k.toUpperCase());};
b.getAriaRole=function(o){return"option";};
b.getAriaLabelledBy=function(o){if(!o.getContentAnnouncement&&o.getAriaLabelledBy().length){return o.getId();}};
b.getAriaDescribedBy=function(o){if(o.getContentAnnouncement){return"";}var d=[],t=o.getType(),T=L;if(o.getListProperty("showUnread")&&o.getUnread()){d.push(this.getAriaAnnouncement("unread"));}if(o.getMode()==a.Delete){d.push(this.getAriaAnnouncement("deletable"));}if(t==T.Navigation){d.push(this.getAriaAnnouncement("navigation"));}else{if(t==T.Detail||t==T.DetailAndActive){d.push(this.getAriaAnnouncement("detail"));}if(t==T.Active||t==T.DetailAndActive){d.push(this.getAriaAnnouncement("active"));}}return d.join(" ");};
b.getAccessibilityState=function(o){var A=this.getAriaLabelledBy(o),s=this.getAriaDescribedBy(o),m={role:this.getAriaRole(o)};if(o.isSelectable()){m.selected=o.getProperty("selected");}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}return m;};
b.renderLIContent=function(r,o){};
b.renderLIAttributes=function(r,o){};
b.renderContentFormer=function(r,o){this.renderHighlight(r,o);this.renderMode(r,o,-1);};
b.renderContentLatter=function(r,o){this.renderCounter(r,o);this.renderType(r,o);this.renderMode(r,o,1);};
b.renderLIContentWrapper=function(r,o){r.write('<div class="sapMLIBContent"');r.writeAttribute("id",o.getId()+"-content");r.write(">");this.renderLIContent(r,o);r.write('</div>');};
b.render=function(r,o){if(!o.getVisible()){this.renderInvisible(r,o);return false;}this.openItemTag(r,o);r.writeControlData(o);r.addClass("sapMLIB");r.addClass("sapMLIB-CTX");r.addClass("sapMLIBShowSeparator");r.addClass("sapMLIBType"+o.getType());if(D.system.desktop&&o.isActionable()){r.addClass("sapMLIBActionable");r.addClass("sapMLIBHoverable");}if(o.getSelected()){r.addClass("sapMLIBSelected");}if(o.getListProperty("showUnread")&&o.getUnread()){r.addClass("sapMLIBUnread");}this.addFocusableClasses(r,o);this.renderTooltip(r,o);this.renderTabIndex(r,o);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(o,this.getAccessibilityState(o));}this.renderLIAttributes(r,o);r.writeClasses();r.writeStyles();r.write(">");this.renderContentFormer(r,o);this.renderLIContentWrapper(r,o);this.renderContentLatter(r,o);this.closeItemTag(r,o);};
return b;},true);
sap.ui.predefine('sap/m/ListRenderer',['jquery.sap.global','sap/ui/core/Renderer','./ListBaseRenderer'],function(q,R,L){"use strict";var a=R.extend(L);
a.render=function(r,c){if(!c.getColumns().length){L.render.call(this,r,c);return;}if(c._isColumnsIncompatible()){q.sap.log.warning("Does not render sap.m.List#"+c.getId()+" with columns aggregation when compatibility version is 1.16 or higher. Instead use sap.m.Table control!");return;}q.sap.require("sap.m.TableRenderer");var o=q.extend({},this,sap.m.TableRenderer);L.render.call(o,r,c);};
return a;},true);
sap.ui.predefine('sap/m/MaskEnabler',['sap/ui/core/Control','./InputBase','jquery.sap.global','sap/ui/Device','sap/ui/core/library','jquery.sap.keycodes'],function(C,I,q,D,c){"use strict";var T=c.TextDirection;var M=function(){var E='^';this.init=M.init=function(){I.prototype.init.call(this);this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;this._setDefaultRules();};this.exit=M.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;};this.onBeforeRendering=function(){if(this._isMaskEnabled()){var v=this._validateDependencies();if(v){q.sap.log.warning("Invalid mask input: "+v);}}I.prototype.onBeforeRendering.apply(this,arguments);};this.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);};this.onfocusin=M.onfocusin=function(e){this._sOldInputValue=this._getInputValue();I.prototype.onfocusin.apply(this,arguments);if(this._isMaskEnabled()){if(!this._oTempValue.differsFromOriginal()||!this._isValidInput(this._sOldInputValue)){this._applyMask();}this._positionCaret(true);}};this.onfocusout=function(e){if(this._isMaskEnabled()){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);q(document).off('.sapMIBtouchstart');if(this.bRenderingPhase){return;}this.closeValueStateMessage();this._inputCompletedHandler();}else{this._setValue();I.prototype.onfocusout.apply(this,arguments);}};this.oninput=function(e){if(this._isChromeOnAndroid()){this._onInputForAndroidHandler(e);return;}I.prototype.oninput.apply(this,arguments);if(this._isMaskEnabled()){this._applyMask();this._positionCaret(false);}};this.onkeypress=function(e){if(this._isMaskEnabled()){this._keyPressHandler(e);}};this.onkeydown=M.onkeydown=function(e){if(this._isMaskEnabled()){var k=this._parseKeyBoardEvent(e),B=D.browser,i;i=(k.bBackspace||k.bDelete)&&B.msie&&B.version<10;if(!i){I.prototype.onkeydown.apply(this,arguments);}this._keyDownHandler(e,k);}else{var k=this._parseKeyBoardEvent(e);if(k.bEnter){this._setValue();}I.prototype.onkeydown.apply(this,arguments);}};this.onsapenter=function(e){};this.onsapfocusleave=function(e){};this.setValue=M.setValue=function(v){v=this.validateProperty('value',v);I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(this._isMaskEnabled()){if(!this._oTempValue){this._setupMaskVariables();}if(this._oTempValue._aInitial.join('')!==v){this._applyRules(v);}}return this;};this.addAggregation=function(A,o,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.addAggregation.apply(this,arguments);if(!this._bSkipSetupMaskVariables){this._setupMaskVariables();}return this;}return C.prototype.addAggregation.apply(this,arguments);};this.insertAggregation=function(A,o,i,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.insertAggregation.apply(this,arguments);this._setupMaskVariables();return this;}return C.prototype.insertAggregation.apply(this,arguments);};this._validateRegexAgainstPlaceHolderSymbol=function(r){if(new RegExp(r.getRegex()).test(this.getPlaceholderSymbol())){q.sap.log.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false;}return true;};this.setPlaceholderSymbol=function(s){var S;if(!/^.$/i.test(s)){q.sap.log.error("Invalid placeholder symbol string given");return this;}S=this.getRules().some(function(r){return new RegExp(r.getRegex()).test(s);});if(S){q.sap.log.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.");}else{this.setProperty("placeholderSymbol",s);this._setupMaskVariables();}return this;};this.setMask=function(m){if(!m){var e="Setting an empty mask is pointless. Make sure you set it with a non-empty value.";q.sap.log.warning(e);return this;}this.setProperty("mask",m,true);this._setupMaskVariables();return this;};this._isCharAllowed=function(s,i){return this._oRules.applyCharAt(s,i);};this._feedReplaceChar=function(s,p,d){return s;};this._setValue=function(){var v=this._getInputValue();if(this._sOldInputValue!==v){I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};var a=function(d){this._aInitial=d.slice(0);this._aContent=d;};a.prototype.setCharAt=function(s,p){this._aContent[p]=s;};a.prototype.charAt=function(p){return this._aContent[p];};a.prototype.toString=function(){return this._aContent.join('');};a.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial);};a.prototype.differsFrom=function(v){var i=0;if(v.length!==this._aContent.length){return true;}for(;i<v.length;i++){if(v[i]!==this._aContent[i]){return true;}}return false;};a.prototype.getSize=function(){return this._aContent.length;};var b=function(r){this._aRules=r;};b.prototype.nextTo=function(i){if(typeof i==="undefined"){i=-1;}do{i++;}while(i<this._aRules.length&&!this._aRules[i]);return i;};b.prototype.previousTo=function(i){do{i--;}while(!this._aRules[i]&&i>0);return i;};b.prototype.hasRuleAt=function(i){return!!this._aRules[i];};b.prototype.applyCharAt=function(s,i){return this._aRules[i].test(s);};this._setDefaultRules=function(){this._bSkipSetupMaskVariables=true;this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"a",regex:"[A-Za-z]"}),true);this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"9",regex:"[0-9]"}),true);this._bSkipSetupMaskVariables=false;};this._validateDependencies=function(){var p=this.getPlaceholderSymbol(),r=this.getRules(),m=[],e=[];if(!this.getMask()){e.push("Empty mask");}if(r.length){m=[];r.every(function(R){var s=R.getMaskFormatSymbol(),d=s!==p,f;f=!m.some(function(S){return s===S;});m.push(s);if(!d){e.push("Placeholder symbol is the  same as the existing rule's mask format symbol");}if(!f){e.push("Duplicated rule's maskFormatSymbol ["+s+"]");}return d&&f;});}return e.length?e.join(". "):null;};this._removeRuleWithSymbol=function(s){var S=this._findRuleBySymbol(s,this.getRules());if(S){this.removeAggregation('rules',S.oRule);S.oRule.destroy();}};this._findRuleBySymbol=function(m,r){var R=null;if(typeof m!=="string"||m.length!==1){q.sap.log.error(m+" is not a valid mask rule symbol");return null;}q.each(r,function(i,o){if(o.getMaskFormatSymbol()===m){R={oRule:o,iIndex:i};return false;}});return R;};this._getTextSelection=function(){var _=q(this.getFocusDomRef());if(!_&&(_.length===0||_.is(":hidden"))){return;}return{iFrom:_[0].selectionStart,iTo:_[0].selectionEnd,bHasSelection:(_[0].selectionEnd-_[0].selectionStart!==0)};};this._setCursorPosition=function(p){if(p<0){p=0;}q(this.getFocusDomRef()).cursorPos(p);return this;};this._getCursorPosition=function(){return q(this.getFocusDomRef()).cursorPos();};this._setupMaskVariables=function(){var r=this.getRules(),m=this.getMask(),s=this._getSkipIndexes(m),d=this._getMaskArray(m,s),p=this.getPlaceholderSymbol(),i=this._buildMaskValueArray(d,p,r,s),t=this._buildRules(d,r,s);this._oTempValue=new a(i);this._iMaskLength=t.length;this._oRules=new b(t);this._iUserInputStartPosition=this._oRules.nextTo();};this._getMaskArray=function(m,s){var l=Array.isArray(s)?s.length:0,d=(m)?m.split(""):[],i;for(i=0;i<l;i++){d.splice(s[i],1);}return d;};this._getSkipIndexes=function(m){var l=(m)?m.length:0,i,s=[],p=0,L=false;for(i=0;i<l;i++){if(m[i]===E&&!L){s.push(i-p);L=true;p++;}else{L=false;}}return s;};this._applyMask=function(){var m=this._getInputValue();if(!this.getEditable()){return;}this._applyAndUpdate(m);};this._resetTempValue=function(f,t){var i,p=this.getPlaceholderSymbol();if(typeof f==="undefined"||f===null){f=0;t=this._oTempValue.getSize()-1;}for(i=f;i<=t;i++){if(this._oRules.hasRuleAt(i)){this._oTempValue.setCharAt(p,i);}}};this._applyAndUpdate=function(m){this._applyRules(m);this.updateDomValue(this._oTempValue.toString());};this._findFirstPlaceholderPosition=function(){return this._oTempValue.toString().indexOf(this.getPlaceholderSymbol());};this._applyRules=function(i){var s,d=0,m,p=this.getPlaceholderSymbol(),e;if(this._oTempValue.toString()===i){return;}for(m=0;m<this._iMaskLength;m++){if(this._oRules.hasRuleAt(m)){this._oTempValue.setCharAt(p,m);e=false;if(i.length){do{s=i.charAt(d);d++;if(this._oRules.applyCharAt(s,m)){this._oTempValue.setCharAt(s,m);e=true;}}while(!e&&(d<i.length));}if(!e){this._resetTempValue(m+1,this._iMaskLength-1);break;}}else{if(this._oTempValue.charAt(m)===i.charAt(d)){d++;}}}};this._keyPressHandler=function(e,k){var s,p,d;if(!this.getEditable()){return;}k=k||this._parseKeyBoardEvent(e);if(k.bCtrlKey||k.bAltKey||k.bMetaKey||k.bBeforeSpace){return;}s=this._getTextSelection();if(!k.bEnter&&!k.bShiftLeftOrRightArrow&&!k.bHome&&!k.bEnd&&!(k.bShift&&k.bDelete)&&!(k.bCtrlKey&&k.bInsert)&&!(k.bShift&&k.bInsert)){if(s.bHasSelection){this._resetTempValue(s.iFrom,s.iTo-1);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,s.iFrom));}p=this._oRules.nextTo(s.iFrom-1);if(p<this._iMaskLength){d=this._feedReplaceChar(k.sChar,p,this._getInputValue());this._feedNextString(d,p);}e.preventDefault();}};this.oncut=function(e){var s=this._getTextSelection(),m=this._getMinBrowserDelay(),B=s.iFrom,i=s.iTo;I.prototype.oncut(e);if(!s.bHasSelection||!this._isMaskEnabled()){return;}i=i-1;this._resetTempValue(B,i);q.sap.delayedCall(m,this,function updateDomAndCursor(v,p,o){this._oTempValue._aContent=o;this.updateDomValue(v);q.sap.delayedCall(m,this,this._setCursorPosition,[p]);},[this._oTempValue.toString(),Math.max(this._iUserInputStartPosition,B),this._oTempValue._aContent.slice(0)]);};this._keyDownHandler=function(e,k){var d,s,i,n,k=k||this._parseKeyBoardEvent(e);if(!this.getEditable()){return;}if(!k.bShift&&(k.bArrowRight||k.bArrowLeft)){i=this._getCursorPosition();s=this._getTextSelection();d=this._determineArrowKeyDirection(k,s);if(this._isRtlMode()&&s.bHasSelection){n=this._determineRtlCaretPositionFromSelection(d);}else{n=this._oRules[d](i);}if(this._isWebkitProblematicCase()){n=this._fixWebkitBorderPositions(n,d);}this._setCursorPosition(n);e.preventDefault();}else if(k.bEscape){this._applyAndUpdate(this._sOldInputValue);this._positionCaret(true);e.preventDefault();}else if(k.bEnter){this._inputCompletedHandler(e);}else if((k.bCtrlKey&&k.bInsert)||(k.bShift&&k.bInsert)){I.prototype.onkeydown.apply(this,arguments);}else if((!k.bShift&&k.bDelete)||k.bBackspace){this._revertKey(k);e.preventDefault();}else if(this._isChromeOnAndroid()){this._oKeyDownStateAndroid={sValue:this._oTempValue.toString(),iCursorPosition:this._getCursorPosition()};}};this._revertKey=function(k){var s=this._getTextSelection(),B=s.iFrom,e=s.iTo;if(!s.bHasSelection){if(k.bBackspace){B=this._oRules.previousTo(B);}}if(k.bBackspace||(k.bDelete&&s.bHasSelection)){e=e-1;}this._resetTempValue(B,e);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,B));};this._feedNextString=function(n,p){var N,A=false,d=n.split(""),s;while(d.length){s=d.splice(0,1)[0];if(this._oRules.applyCharAt(s,p)){A=true;this._oTempValue.setCharAt(s,p);p=this._oRules.nextTo(p);}}if(A){N=p;this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(N);}};this._inputCompletedHandler=function(){var n=this._getInputValue(),t,v,e,d;if(this._oTempValue.differsFrom(n)){this._applyAndUpdate(n);}t=this._oTempValue.differsFromOriginal();v=t?this._oTempValue.toString():"";e=!this._sOldInputValue||!this.getValue();d=!n;if(e&&(d||!t)){this.updateDomValue("");return;}if(this._sOldInputValue!==this._oTempValue.toString()){I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};this._buildMaskValueArray=function(m,p,r,s){return m.map(function(d,i){var n=s.indexOf(i)===-1,R=this._findRuleBySymbol(d,r);return(n&&R)?p:d;},this);};this._buildRules=function(m,r,s){var t=[],S,l=m.length,i=0;for(;i<l;i++){if(s.indexOf(i)===-1){S=this._findRuleBySymbol(m[i],r);t.push(S?new RegExp(S.oRule.getRegex()):null);}else{t.push(null);}}return t;};this._parseKeyBoardEvent=function(e){var p=e.which||e.keyCode,k=q.sap.KeyCodes,A=p===k.ARROW_RIGHT,d=p===k.ARROW_LEFT,s=e.shiftKey;return{iCode:p,sChar:String.fromCharCode(p),bCtrlKey:e.ctrlKey,bAltKey:e.altKey,bMetaKey:e.metaKey,bShift:s,bInsert:p===q.sap.KeyCodes.INSERT,bBackspace:p===k.BACKSPACE,bDelete:p===k.DELETE,bEscape:p===k.ESCAPE,bEnter:p===k.ENTER,bIphoneEscape:(D.system.phone&&D.os.ios&&p===127),bArrowRight:A,bArrowLeft:d,bHome:p===q.sap.KeyCodes.HOME,bEnd:p===q.sap.KeyCodes.END,bShiftLeftOrRightArrow:s&&(d||A),bBeforeSpace:p<k.SPACE};};this._positionCaret=function(s){var m=this.getMask(),i=this._getMinBrowserDelay(),e;clearTimeout(this._iCaretTimeoutId);e=this._findFirstPlaceholderPosition();if(e<0){e=m.length;}this._iCaretTimeoutId=q.sap.delayedCall(i,this,function(){if(this.getFocusDomRef()!==document.activeElement){return;}if(s&&(e===(m.length))){this.selectText(0,e);}else{this._setCursorPosition(e);}});};this._getMinBrowserDelay=function(){return!D.browser.msie?4:50;};this._isValidInput=function(s){var l=s.length,i=0,d;for(;i<l;i++){d=s[i];if(this._oRules.hasRuleAt(i)&&(!this._oRules.applyCharAt(d,i)&&d!==this.getPlaceholderSymbol())){return false;}if(!this._oRules.hasRuleAt(i)&&d!==this._oTempValue.charAt(i)){return false;}}return true;};this._isRtlChar=function(s){var l='A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'+'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF',r='\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC',d=new RegExp('^[^'+l+']*['+r+']');return d.test(s);};this._fixWebkitBorderPositions=function(i,d){var t=this._oTempValue.toString().length;if(d==='nextTo'){if(i===0||i===t||i===1){i=0;}else if(i===t+1){i=1;}}else{if(i===0||i===t-1){i=t;}else if(i===-1||i===t){i=t-1;}}return i;};this._containsRtlChars=function(){var t=this._oTempValue.toString(),d=false;for(var i=0;i<t.length;i++){d=this._isRtlChar(t[i]);}return d;};this._isRtlMode=function(){return sap.ui.getCore().getConfiguration().getRTL()||(this.getTextDirection()===T.RTL);};this._isWebkitProblematicCase=function(){return D.browser.webkit&&this._isRtlMode()&&!this._containsRtlChars();};this._determineArrowKeyDirection=function(k,s){var d;if(!this._isRtlMode()||!this._containsRtlChars()||s.bHasSelection){if(k.bArrowRight){d='nextTo';}else{d='previousTo';}}else{if(k.bArrowRight){d='previousTo';}else{d='nextTo';}}return d;};this._determineRtlCaretPositionFromSelection=function(d,w){var n,s=this._getTextSelection();if(w){if(d==='nextTo'){if(!this._containsRtlChars()){n=s.iFrom;}else{n=s.iTo;}}else{if(!this._containsRtlChars()){n=s.iTo;}else{n=s.iFrom;}}}else{if(d==='nextTo'){if(!this._containsRtlChars()){n=s.iTo;}else{n=s.iFrom;}}else{if(!this._containsRtlChars()){n=s.iFrom;}else{n=s.iTo;}}}return n;};this._onInputForAndroidHandler=function(e){var k;if(!this._oKeyDownStateAndroid){return;}k=this._buildKeyboardEventInfo(this._oKeyDownStateAndroid.sValue,this._getInputValue());this.updateDomValue(this._oKeyDownStateAndroid.sValue);q.sap.delayedCall(0,this,function(i,K,o){this._setCursorPosition(K.iCursorPosition);if(o.bBackspace){this._revertKey(o);}else{this._keyPressHandler(i,o);}},[e,this._oKeyDownStateAndroid,k]);delete this._oKeyDownStateAndroid;e.preventDefault();};this._buildKeyboardEventInfo=function(o,n){var N="",i;if(!o&&!n){return{};}if(o&&n&&n.length<o.length){return{bBackspace:true};}for(i=0;i<n.length;i++){if(o[i]!==n[i]){N=n[i];break;}}return{sChar:N};};this._isChromeOnAndroid=function(){return D.browser.chrome&&D.os.android;};};return M;},true);
sap.ui.predefine('sap/m/MaskInput',['./InputBase','./MaskEnabler','./MaskInputRenderer'],function(I,M,a){"use strict";
var b=I.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}}}});
M.call(b.prototype);
b.prototype._isMaskEnabled=function(){return true;};
return b;});
sap.ui.predefine('sap/m/MaskInputRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var M=R.extend(I);
M.getLabelledByAnnouncement=function(c){var m=c.getMask(),p=c.getPlaceholder()||"",t=c.getTooltip_AsString()||"",r,s,a="";if(m&&m.length){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");s=r.getText("MASKINPUT_SCREENREADER_TAG");if(t){t=" "+t+" ";}if(p){p=" "+p+" ";}a=s+p+t;return a;}return I.getLabelledByAnnouncement.apply(this,arguments);};
M.getDescribedByAnnouncement=function(c){var m=c.getMask(),s=c.getPlaceholderSymbol(),r,a="";if(m.length&&s){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");a=r.getText("MASKINPUT_SCREENREADER_DESCRIPTION",[s,m]);return jQuery.trim(a);}return I.getDescribedByAnnouncement.apply(this,arguments);};
return M;},true);
sap.ui.predefine('sap/m/MaskInputRule',['jquery.sap.global','sap/ui/core/Element'],function(q,E){"use strict";
var M=E.extend("sap.m.MaskInputRule",{metadata:{library:"sap.m",properties:{maskFormatSymbol:{type:"string",group:"Misc",defaultValue:"*"},regex:{type:"string",group:"Misc",defaultValue:"[a-zA-Z0-9]"}}}});
M.prototype.setMaskFormatSymbol=function(n){var i=v.call(this,n);if(i){this.setProperty("maskFormatSymbol",n);}return this;};
M.prototype.setRegex=function(n){var i=a.call(this,n);if(i){this.setProperty("regex",n);}return this;};
M.prototype.toString=function(){return this.getMaskFormatSymbol()+":"+this.getRegex();};
function v(n){if(/^.$/i.test(n)){return true;}q.sap.log.error("The mask format symbol '"+n+"' is not valid");return false;}
function a(r){if(/.+/i.test(r)){return true;}q.sap.log.error("The regex value '"+r+"' is not valid");return false;}
return M;});
sap.ui.predefine('sap/m/Menu',['jquery.sap.global','./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/Device','sap/ui/core/EnabledPropagator'],function(q,l,C,B,D,N,L,P,M,U,a,b,E){"use strict";var c=l.ListType;var d=l.ListMode;
var e=C.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}}});
E.call(e.prototype);e.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';e.UNFIFIED_MENU_ITEMS_PROPS=a.getMetadata().getAllProperties();e.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';e.MENU_LIST_ITEMS_PROPS=M.getMetadata().getAllProperties();
e.prototype.init=function(){if(b.system.phone){this._initDialog();}this._bIsInitialized=false;};
e.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};
e.prototype.invalidate=function(){};
e.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};
e.prototype.openBy=function(o,w){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}var h=sap.ui.core.Popup.Dock;this._getMenu().open(w,o,h.BeginTop,h.BeginBottom,o,"0 -2");}};
e.prototype.close=function(){if(b.system.phone){this._getDialog().close();}else{this._getVisualParent().close();}};
e.prototype._initDialog=function(){var o=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});o.addStyleClass("sapMRespMenuDialog");o.removeStyleClass("sapUiPopupWithPadding");this.setAggregation("_dialog",o,true);};
e.prototype._getDialog=function(){return this.getAggregation("_dialog");};
e.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();};
e.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};
e.prototype._initMenuForItems=function(i,p){var m=new U();m.isCozy=this._isMenuCozy.bind(this,m);this.addStyleClass('sapMMenu');m.aCustomStyleClasses=this.aCustomStyleClasses;m.mCustomStyleClassMap=this.mCustomStyleClassMap;i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};
e.prototype._menuClosed=function(){this.fireClosed();};
e.prototype._getMenu=function(){return this.getAggregation("_menu");};
e.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:f.bind(this)});};
function f(){this._getDialog().close();}
e.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};
e.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};
e.prototype._initAllPages=function(){this._initPageForParent(this);};
e.prototype._initPageForParent=function(p){var i=p.getItems(),h=p instanceof e,s=h?p.getTitle():p.getText(),o=new L({mode:d.None}),j=new P({title:s,showNavButton:!h,content:o});if(!h){this._setBackButtonTooltipForPageWithParent(p,j);}j.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(j);i.forEach(function(I){this._addListItemFromItem(I,j);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return j;};
e.prototype._handleListItemPress=function(o){var h=o.getParameter("listItem"),m=sap.ui.getCore().byId(h.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}m.firePress();};
e.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var h=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=h instanceof e?h.getTitle():h.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};
e.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:c.Active,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i,tooltip:i.getTooltip(),visible:i.getVisible()});};
e.prototype._createVisualMenuItemFromItem=function(i){return new a({id:this._generateUnifiedMenuItemId(i.getId()),icon:i.getIcon(),text:i.getText(),startsSection:i.getStartsSection(),tooltip:i.getTooltip(),visible:i.getVisible(),enabled:i.getEnabled()});};
e.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var h=['aggregationChanged','propertyChanged'];h.forEach(function(s){var j='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[j],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};
e.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var h=['aggregationChanged','propertyChanged'];h.forEach(function(s){var j='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[j],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};
e.prototype._connectVisualItem=function(i,o,I){if(!o||sap.ui.getCore().byId(i._getVisualControl())){return;}if(b.system.phone){this._addListItemFromItem(i,o,I);var h=o.getContent()[0];this._updateListInset(h);}else{this._addVisualMenuItemFromItem(i,o,I);}};
e.prototype._updateListInset=function(o){var h=false,I="sapMListIcons",j=o.getItems();for(var i=0;i<j.length;i++){if(j[i].getIcon()){h=true;break;}}if(h){o.addStyleClass(I);}else{o.removeStyleClass(I);}};
e.prototype._handleMenuItemSelect=function(o){var u=o.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}if(m){m.firePress();}};
e.prototype._generateListItemId=function(m){return m+e.LIST_ITEMS_ID_SUFFIX;};
e.prototype._generateUnifiedMenuItemId=function(m){return m+e.UNIFIED_MENU_ITEMS_ID_SUFFIX;};
e.prototype._findMenuItemByUnfdMenuItem=function(u){var h=[],o=u,I,j,i;do{h.push(o.getId());o=o.getParent().getParent();}while(o instanceof a);I=this.getItems();do{j=h.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===j){if(h.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(h.length);return null;};
e.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(g(m.oOpenerRef)){return true;}return false;};
function g(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}
e.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent());}return this;};
e.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent(),i);}return this;};
e.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};
e.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};
e.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m;if(v){m=v.getParent();m.removeItem(v);if(b.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}}};
e.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};
e.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};
e.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};
e.prototype._onPropertyChanged=function(o){var p=o.getParameter("propertyKey"),h=o.getParameter("propertyValue"),t=b.system.phone?e.MENU_LIST_ITEMS_PROPS:e.UNFIFIED_MENU_ITEMS_PROPS,G=b.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,T;if(b.system.phone&&p==='text'){p='title';}if(!t[p]){return;}T=G(o.getSource().getId());if(T){sap.ui.getCore().byId(T).setProperty(p,h);if(b.system.phone&&this._getDialog().isOpen()){this._getDialog().close();}}};
e.prototype._onAggregationChanged=function(o){var A=o.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(o);break;}};
e.prototype._onItemsAggregationChanged=function(o){var I=o.getSource(),m=o.getParameter("methodName"),h=o.getParameter("methodParams"),j;if(m==="add"||m==="insert"){if(m==="insert"){j=h.index;}this._addOrInsertItem(I,h.item,j);}if(m==="remove"){this._removeVisualItem(h.item,I);}if(m==="removeall"){for(var i=0;i<h.items.length;i++){this._removeVisualItem(h.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};
e.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._connectVisualItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(b.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};
e.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};
e.prototype.getDomRefId=function(){if(b.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};
e.prototype.openAsContextMenu=function(o,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}this._getMenu().openAsContextMenu(o,O);}};
["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(m){e.prototype[m]=function(s,S){var o=this._getDialog();C.prototype[m].apply(this,arguments);if(o){o[m].apply(o,arguments);}return this;};});return e;});
sap.ui.predefine('sap/m/MenuButton',['jquery.sap.global','./library','sap/ui/core/Control','./Button','./SplitButton','sap/ui/Device','sap/ui/core/EnabledPropagator','sap/ui/core/library',"./MenuButtonRenderer"],function(q,l,C,B,S,D,E,c,M){"use strict";var a=l.MenuButtonMode;var T=c.TextDirection;var b=l.ButtonType;
var d=C.extend("sap.m.MenuButton",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:b.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:a.Regular},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{defaultAction:{}},defaultAggregation:"menu",designtime:"sap/m/designtime/MenuButton.designtime"}});
E.call(d.prototype);
d.prototype.init=function(){this._initButtonControl();};
d.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null;}if(this._sDefaultIcon){this._sDefaultIcon=null;}if(this._iInitialWidth){this._iInitialWidth=null;}if(this._lastActionItemId){this._lastActionItemId=null;}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this);}};
d.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText();}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon();}this._updateButtonControl();this._attachMenuEvents();};
d.prototype.onAfterRendering=function(){q.sap.delayedCall(0,this,"_setInitialBtnWidth");this._setAriaHasPopup();};
d.prototype._setInitialBtnWidth=function(){var i;if(this._isSplitButton()&&!this._iInitialWidth){i=this.$().outerWidth();if(i){this._iInitialWidth=i+1;}}};
d.prototype._setAriaHasPopup=function(){if(this._isSplitButton()){this._getButtonControl()._getArrowButton().$().attr("aria-haspopup","true");}else{this._getButtonControl().$().attr("aria-haspopup","true");}};
d.prototype.setButtonMode=function(m){var t=this.getTooltip();C.prototype.setProperty.call(this,"buttonMode",m,true);this._getButtonControl().destroy();this._initButtonControl();for(var k in this.mProperties){if(this.mProperties.hasOwnProperty(k)&&k!=="buttonMode"&&k!=="useDefaultActionOnly"&&k!=="width"){this._getButtonControl().setProperty(k,this.mProperties[k],true);}}if(t){this._getButtonControl().setTooltip(t);}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText());}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon());}this.invalidate();return this;};
d.prototype._initButton=function(){var o=new B({width:"100%"});o.attachPress(this._handleButtonPress,this);return o;};
d.prototype._initSplitButton=function(){var o=new S({width:"100%"});o.attachPress(this._handleActionPress,this);o.attachArrowPress(this._handleButtonPress,this);return o;};
d.prototype._initButtonControl=function(){var o;if(this._isSplitButton()){o=this._initSplitButton();}else{o=this._initButton();}this.setAggregation("_button",o,true);};
d.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText());};
d.prototype._getButtonControl=function(){return this.getAggregation("_button");};
d.prototype._handleButtonPress=function(w){var m=this.getMenu();if(!m){return;}if(!m.getTitle()){m.setTitle(this.getText());}m.openBy(this,w);this._writeAriaAttributes();if(this._isSplitButton()&&!D.system.phone){this._getButtonControl().setArrowState(true);}};
d.prototype._handleActionPress=function(){var L=this._getLastSelectedItem(),o;if(!this.getUseDefaultActionOnly()&&L){o=sap.ui.getCore().byId(L);this.getMenu().fireItemSelected({item:o});}else{this.fireDefaultAction();}};
d.prototype._menuClosed=function(){if(this._isSplitButton()){this._getButtonControl().setArrowState(false);}};
d.prototype._menuItemSelected=function(e){var m=e.getParameter("item");this.fireEvent("_menuItemSelected",{item:m});if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!m){return;}this._lastActionItemId=m.getId();!!this._sDefaultText&&this.setText(m.getText());!!this._sDefaultIcon&&this.setIcon(m.getIcon());};
d.prototype._getLastSelectedItem=function(){return this._lastActionItemId;};
d.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this);}};
d.prototype._isSplitButton=function(){return this.getButtonMode()===a.Split;};
d.prototype.setProperty=function(p,v,s){function i(t){var e=[b.Up,b.Back,b.Unstyled];return e.indexOf(t)!==-1;}if(p==="type"&&i(v)){return this;}if(p==='text'){this._sDefaultText=v;}switch(p){case'activeIcon':case'iconDensityAware':case'textDirection':this._getButtonControl().setProperty(p,v);break;}return C.prototype.setProperty.apply(this,arguments);};
d.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return C.prototype.setTooltip.apply(this,arguments);};
d.prototype.setText=function(v){B.prototype.setProperty.call(this,'text',v);this._getButtonControl().setText(v);return this;};
d.prototype.setType=function(v){B.prototype.setProperty.call(this,'type',v);this._getButtonControl().setType(v);return this;};
d.prototype.setIcon=function(v){B.prototype.setProperty.call(this,'icon',v);this._getButtonControl().setIcon(v);return this;};
d.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef();};
d.prototype.onsapup=function(e){this.openMenuByKeyboard();};
d.prototype.onsapdown=function(e){this.openMenuByKeyboard();};
d.prototype.onsapupmodifiers=function(e){this.openMenuByKeyboard();};
d.prototype.onsapdownmodifiers=function(e){this.openMenuByKeyboard();};
d.prototype.onsapshow=function(e){this.openMenuByKeyboard();!!e&&e.preventDefault();};
d.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(true);}};
d.prototype._writeAriaAttributes=function(){if(this.getMenu()){this.$().attr("aria-controls",this.getMenu().getDomRefId());}};
return d;});
sap.ui.predefine('sap/m/MenuButtonRenderer',[],function(){"use strict";var M={};M.CSS_CLASS="sapMMenuBtn";
M.render=function(r,m){var w=m.getWidth();r.write("<div");r.writeControlData(m);this.writeAriaAttributes(r,m);r.addClass(M.CSS_CLASS);r.addClass(M.CSS_CLASS+m.getButtonMode());r.writeClasses();if(w!=""||w.toLowerCase()==="auto"){r.addStyle("width",w);}else if(m._isSplitButton()&&m._iInitialWidth){r.addStyle("width",m._iInitialWidth+"px");}r.writeStyles();r.write(">");r.renderControl(m._getButtonControl());r.write("</div>");};
M.writeAriaAttributes=function(r,m){r.writeAttribute("aria-haspopup","true");};
return M;},true);
sap.ui.predefine('sap/m/MenuItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var M=I.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"String"},methodName:{type:"String"},methodParams:{type:"Object"}}}}}});
M.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null;}if(this._sVisualParent){this._sVisualParent=null;}if(this._sVisualControl){this._sVisualControl=null;}};
M.prototype.setProperty=function(p,P){I.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:p,propertyValue:P});};
M.prototype.addAggregation=function(a,o,s){I.prototype.addAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"add",methodParams:{item:o}});return this;};
M.prototype.insertAggregation=function(a,o,i,s){I.prototype.insertAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"insert",methodParams:{item:o,index:i}});return this;};
M.prototype.removeAggregation=function(a,o,s){var O=I.prototype.removeAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"remove",methodParams:{item:O}});return O;};
M.prototype.removeAllAggregation=function(a,s){var o=I.prototype.removeAllAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"removeall",methodParams:{items:o}});return o;};
M.prototype.destroyAggregation=function(a,s){this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"destroy"});return I.prototype.destroyAggregation.apply(this,arguments);};
M.prototype.destroy=function(){var v=sap.ui.getCore().byId(this._getVisualControl());if(v){v.destroy();}return I.prototype.destroy.apply(this,arguments);};
M.prototype._setVisualChild=function(c){this._setInternalRef(c,"_sVisualChild");};
M.prototype._setVisualParent=function(c){this._setInternalRef(c,"_sVisualParent");};
M.prototype._setVisualControl=function(c){this._setInternalRef(c,"_sVisualControl");};
M.prototype._setInternalRef=function(c,i){if(!c||typeof c==="string"){this[i]=c;}else if(c.getId){this[i]=c.getId();}};
M.prototype._getVisualChild=function(){return this._sVisualChild;};
M.prototype._getVisualParent=function(){return this._sVisualParent;};
M.prototype._getVisualControl=function(){return this._sVisualControl;};
return M;});
sap.ui.predefine('sap/m/MenuListItem',['./ListItemBase','./library','sap/ui/core/IconPool','sap/ui/core/library','./MenuListItemRenderer'],function(L,l,I,c,M){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.MenuListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{menuItem:{type:"sap.m.MenuItem",multiple:false}}}});
a.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._imageRightArrow){this._imageRightArrow.destroy();}L.prototype.exit.apply(this,arguments);};
a.prototype._getImage=function(i,s,S,b){var o=this._image;if(o){o.setSrc(S);if(o instanceof sap.m.Image){o.setDensityAware(b);}}else{o=I.createControlByURI({id:i,src:S,densityAware:b,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}if(o instanceof sap.m.Image){o.addStyleClass(s,true);}else{o.addStyleClass(s+"Icon",true);}this._image=o;return this._image;};
a.prototype._getIconArrowRight=function(){if(!this._imageRightArrow){this._imageRightArrow=I.createControlByURI({id:this.getId()+"-arrowRight",src:"sap-icon://slim-arrow-right",useIconTooltip:false},sap.m.Image).setParent(this,null,true);this._imageRightArrow.addStyleClass("sapMMenuLIArrowRightIcon",true);}return this._imageRightArrow;};
a.prototype._hasSubItems=function(){return!!(this.getMenuItem()&&sap.ui.getCore().byId(this.getMenuItem()).getItems().length);};
return a;});
sap.ui.predefine('sap/m/MenuListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer','sap/m/library','sap/ui/core/library'],function(L,R,l,c){"use strict";var T=c.TextDirection;var a=l.ListType;var M=R.extend(L);
M.openItemTag=function(r,o){if(o.getStartsSection()){r.write("<li ");r.write("role=\"separator\" ");r.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");}L.openItemTag(r,o);};
M.renderLIAttributes=function(r,o){r.addClass("sapMSLI");if(o.getIcon()){r.addClass("sapMSLIIcon");}if(o.getType()==a.Detail||o.getType()==a.DetailAndActive){r.addClass("sapMSLIDetail");}if(o._hasSubItems()){r.addClass("sapMMenuLIHasChildren");}};
M.renderLIContent=function(r,o){var t=o.getTitleTextDirection();if(o.getIcon()){r.renderControl(o._getImage((o.getId()+"-img"),"sapMMenuLIImgThumb",o.getIcon(),o.getIconDensityAware()));}r.write("<div");r.addClass("sapMSLIDiv");r.addClass("sapMSLITitleDiv");r.writeClasses();r.write(">");if(o._bNoFlex){r.write('<div class="sapMLIBNoFlex">');}r.write("<div");r.addClass("sapMSLITitleOnly");r.writeClasses();if(t!==T.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");r.writeEscaped(o.getTitle());r.write("</div>");if(o._bNoFlex){r.write('</div>');}r.write("</div>");if(o._hasSubItems()){r.renderControl(o._getIconArrowRight());}};
return M;},true);
sap.ui.predefine('sap/m/MessageBox',['jquery.sap.global','./Button','./Dialog','./Text','./FormattedText','./Link','./VBox','sap/ui/core/IconPool','sap/ui/core/ElementMetadata','sap/ui/core/library','sap/ui/core/Control','sap/m/library'],function(q,B,D,T,F,L,V,I,E,c,C,l){"use strict";var a=l.DialogType;var b=c.TextDirection;var M={};M.Action={OK:"OK",CANCEL:"CANCEL",YES:"YES",NO:"NO",ABORT:"ABORT",RETRY:"RETRY",IGNORE:"IGNORE",CLOSE:"CLOSE",DELETE:"DELETE"};M.Icon={NONE:undefined,INFORMATION:"INFORMATION",WARNING:"WARNING",ERROR:"ERROR",SUCCESS:"SUCCESS",QUESTION:"QUESTION"};(function(){var A=M.Action,d=M.Icon,m={"INFORMATION":"sapMMessageBoxInfo","WARNING":"sapMMessageBoxWarning","ERROR":"sapMMessageBoxError","SUCCESS":"sapMMessageBoxSuccess","QUESTION":"sapMMessageBoxQuestion","STANDARD":"sapMMessageBoxStandard"},e={"INFORMATION":I.getIconURI("message-information"),"WARNING":I.getIconURI("message-warning"),"ERROR":I.getIconURI("message-error"),"SUCCESS":I.getIconURI("message-success"),"QUESTION":I.getIconURI("question-mark")};var _=function(){if(M._rb!==sap.ui.getCore().getLibraryResourceBundle("sap.m")){M._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");}};
M.show=function(v,o){var f,g,h,r=null,t=this,j=[],i,s,k,n,p,u,w,x={id:E.uid("mbox"),initialFocus:null,textDirection:b.Inherit,verticalScrolling:true,horizontalScrolling:true,details:"",contentWidth:null};_();if(typeof o==="string"||arguments.length>2){s=arguments[1];k=arguments[2];n=arguments[3];p=arguments[4];u=arguments[5];w=arguments[6];o={icon:s,title:k,actions:n,onClose:p,id:u,styleClass:w};}if(o&&o.hasOwnProperty("details")){x.icon=d.INFORMATION;x.actions=[A.OK,A.CANCEL];o=q.extend({},x,o);}o=q.extend({},x,o);if(typeof o.actions!=="undefined"&&!q.isArray(o.actions)){o.actions=[o.actions];}if(!o.actions||o.actions.length===0){o.actions=[A.OK];}function y(K){var N;if(M.Action.hasOwnProperty(K)){N=t._rb.getText("MSGBOX_"+K);}var O=new B({id:E.uid("mbox-btn-"),text:N||K,press:function(){r=K;f.close();}});return O;}for(i=0;i<o.actions.length;i++){j.push(y(o.actions[i]));}function z(o,g){if(typeof o.details=='object'){o.details="<pre>"+JSON.stringify(o.details,null,'\t').replace(/{/gi,"\\{")+"</pre>";}var K=new F().setVisible(false).setHtmlText(o.details);var S=new L({text:t._rb.getText("MSGBOX_LINK_TITLE"),press:function(){var N=f.getInitialFocus();f.addAriaLabelledBy(K);K.setVisible(true);S.setVisible(false);if(N&&N!==S.getId()){f._setInitialFocus();}else{j[0].focus();}}});S.addStyleClass("sapMMessageBoxLinkText");K.addStyleClass("sapMMessageBoxDetails");return new V({items:[g,S,K]});}function G(){if(typeof o.onClose==="function"){o.onClose(r);}f.detachAfterClose(G);f.destroy();}function H(){var i=0;var K=null;if(o.initialFocus){if(o.initialFocus instanceof C){K=o.initialFocus;}if(typeof o.initialFocus==="string"){for(i=0;i<j.length;i++){if(M.Action.hasOwnProperty(o.initialFocus)){if(t._rb.getText("MSGBOX_"+o.initialFocus).toLowerCase()===j[i].getText().toLowerCase()){K=j[i];break;}}else{if(o.initialFocus.toLowerCase()===j[i].getText().toLowerCase()){K=j[i];break;}}}}}return K;}if(typeof(v)==="string"){h=new T({textDirection:o.textDirection}).setText(v).addStyleClass("sapMMsgBoxText");g=h;}else if(v instanceof C){h=v.addStyleClass("sapMMsgBoxText");}if(o&&o.hasOwnProperty("details")&&o.details!==""){h=z(o,h);}function J(){if(sap.ui.getCore().getConfiguration().getAccessibility()){f.$().attr("role","alertdialog");}}f=new D({id:o.id,type:a.Message,title:o.title,content:h,icon:e[o.icon],initialFocus:H(),verticalScrolling:o.verticalScrolling,horizontalScrolling:o.horizontalScrolling,afterOpen:J,afterClose:G,buttons:j,ariaLabelledBy:g?g.getId():undefined,contentWidth:o.contentWidth});if(m[o.icon]){f.addStyleClass(m[o.icon]);}else{f.addStyleClass(m.STANDARD);}if(o.styleClass){f.addStyleClass(o.styleClass);}f.open();};
M.alert=function(v,o){_();var f={icon:d.NONE,title:this._rb.getText("MSGBOX_TITLE_ALERT"),actions:A.OK,id:E.uid("alert"),initialFocus:null},g,t,s,S;if(typeof o==="function"||arguments.length>2){g=arguments[1];t=arguments[2];s=arguments[3];S=arguments[4];o={onClose:g,title:t,id:s,styleClass:S};}o=q.extend({},f,o);return M.show(v,o);};
M.confirm=function(v,o){_();var f={icon:d.QUESTION,title:this._rb.getText("MSGBOX_TITLE_CONFIRM"),actions:[A.OK,A.CANCEL],id:E.uid("confirm"),initialFocus:null},g,t,s,S;if(typeof o==="function"||arguments.length>2){g=arguments[1];t=arguments[2];s=arguments[3];S=arguments[4];o={onClose:g,title:t,id:s,styleClass:S};}o=q.extend({},f,o);return M.show(v,o);};
M.error=function(v,o){_();var f={icon:d.ERROR,title:this._rb.getText("MSGBOX_TITLE_ERROR"),actions:[A.CLOSE],id:E.uid("error"),initialFocus:null};o=q.extend({},f,o);return M.show(v,o);};
M.information=function(v,o){_();var f={icon:d.INFORMATION,title:this._rb.getText("MSGBOX_TITLE_INFO"),actions:[A.OK],id:E.uid("info"),initialFocus:null};o=q.extend({},f,o);return M.show(v,o);};
M.warning=function(v,o){_();var f={icon:d.WARNING,title:this._rb.getText("MSGBOX_TITLE_WARNING"),actions:[A.OK],id:E.uid("warning"),initialFocus:null};o=q.extend({},f,o);return M.show(v,o);};
M.success=function(v,o){_();var f={icon:d.SUCCESS,title:this._rb.getText("MSGBOX_TITLE_SUCCESS"),actions:[A.OK],id:E.uid("success"),initialFocus:null};o=q.extend({},f,o);return M.show(v,o);};
}());return M;},true);
sap.ui.predefine('sap/m/MessageItem',["jquery.sap.global","./library","sap/ui/core/Item","sap/ui/core/library"],function(q,l,I,c){"use strict";var M=c.MessageType;
var a=I.extend("sap.m.MessageItem",{metadata:{library:"sap.m",properties:{type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:M.Error},title:{type:"string",group:"Appearance",defaultValue:""},subtitle:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Appearance",defaultValue:""},markupDescription:{type:"boolean",group:"Appearance",defaultValue:false},longtextUrl:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},counter:{type:"int",group:"Misc",defaultValue:null},groupName:{type:"string",group:"Misc",defaultValue:""}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"}}}});
a.prototype.setProperty=function(p,v,s){var P=this.getParent(),t=this.getType().toLowerCase(),b=["description","type","groupName"],u=function(n,i){if(i._oMessagePopoverItem.getId()===this.getId()&&i.getMetadata().getProperty(n)){i.setProperty(n,v);}};if(b.indexOf(p)===-1&&P&&("_bItemsChanged"in P)&&!P._bItemsChanged){P._oLists&&P._oLists.all&&P._oLists.all.getItems&&P._oLists.all.getItems().forEach(u.bind(this,p));P._oLists&&P._oLists[t]&&P._oLists[t].getItems&&P._oLists[t].getItems().forEach(u.bind(this,p));}if(typeof this._updatePropertiesFn==="function"){this._updatePropertiesFn();}return I.prototype.setProperty.apply(this,arguments);};
a.prototype._updateProperties=function(b){this._updatePropertiesFn=b;};
a.prototype.setDescription=function(d){if(typeof d==='undefined'){d='';}if(this.getMarkupDescription()){d=q.sap._sanitizeHTML(d);}this.setProperty("description",d,true);return this;};
a.prototype.setType=function(t){if(t===M.None){t=M.Information;q.sap.log.warning("The provided None type is handled and rendered as Information type");}return this.setProperty("type",t,true);};
return a;});
sap.ui.predefine('sap/m/MessagePage',['jquery.sap.global','./library','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/Text','sap/m/Image','sap/m/Button','sap/m/Title','sap/m/FormattedText','./MessagePageRenderer'],function(q,l,c,C,I,T,a,B,b,F,M){"use strict";var d=c.TextAlign;var e=c.TextDirection;var f=l.ButtonType;var g=l.BarDesign;
var h=C.extend("sap.m.MessagePage",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:"No matching items found."},description:{type:"string",group:"Misc",defaultValue:"Check the filter settings."},title:{type:"string",group:"Misc",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:"sap-icon://documents"},iconAlt:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:e.Inherit},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{customText:{type:"sap.m.Link",multiple:false},customDescription:{type:"sap.m.Link",multiple:false},buttons:{type:"sap.m.Button",multiple:true},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_description:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{navButtonPress:{}},designtime:"sap/m/designtime/MessagePage.designtime"}});
h.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=new b(this.getId()+"-title");this._oNavButton=new B(this.getId()+"-navButton",{type:f.Back,press:q.proxy(function(){this.fireNavButtonPress();},this)});this.setAggregation("_internalHeader",new sap.m.Bar(this.getId()+"-intHeader",{design:g.Header,contentMiddle:[t]}));this.setProperty("text",o.getText("MESSAGE_PAGE_TEXT"),true);this.setProperty("description",o.getText("MESSAGE_PAGE_DESCRIPTION"),true);};
h.prototype.exit=function(){if(this._oNavButton){this._oNavButton.destroy();this._oNavButton=null;}if(this._oIconControl){this._oIconControl.destroy();this._oIconControl=null;}};
h.prototype.setTitle=function(t){this.setProperty("title",t,true);var o=this._getInternalHeader().getContentMiddle()[0];o.setText(t);return this;};
h.prototype.setText=function(t){this.setProperty("text",t,true);var o=this.getAggregation("_text");o&&o.setText(t);return this;};
h.prototype.setDescription=function(D){this.setProperty("description",D,true);var o=this.getAggregation("_formattedText"),i=this.getAggregation("_description");o&&o.setHtmlText(D);i&&i.setText(D);return this;};
h.prototype.setShowNavButton=function(s){this.setProperty("showNavButton",s,true);var H=this._getInternalHeader();if(s){H.addContentLeft(this._oNavButton);}else{H.removeAllContentLeft();}return this;};
h.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var D=this.getDomRef();if(D){if(t===e.Inherit){D.removeAttribute("dir");}else{D.dir=t.toLowerCase();}}return this;};
h.prototype.setIcon=function(i){var v=this.getIcon()||"";i=i||"";if(v!==i){var s=!!v&&!!i&&I.isIconURI(i)===I.isIconURI(v);this.setProperty("icon",i,s);if(s&&this._oIconControl){this._oIconControl.setSrc(i);}}return this;};
h.prototype.setEnableFormattedText=function(E){var o;if(E){o=this._getFormattedText();o.setHtmlText(this.getDescription());}return this.setProperty("enableFormattedText",E);};
h.prototype._getIconControl=function(){if(this._oIconControl){this._oIconControl.destroy();this._oIconControl=null;}this._oIconControl=I.createControlByURI({id:this.getId()+"-pageIcon",src:this.getIcon(),height:"8rem",width:"8rem",useIconTooltip:true,decorative:false,alt:this.getIconAlt()},a).addStyleClass("sapMMessagePageIcon");return this._oIconControl;};
h.prototype._getText=function(){if(this.getAggregation("customText")){return this.getAggregation("customText");}if(!this.getAggregation("_text")){var t=new T(this.getId()+"-text",{id:this.getId()+"-customText",text:this.getText(),textAlign:d.Center,textDirection:this.getTextDirection()});this.setAggregation("_text",t);}return this.getAggregation("_text");};
h.prototype._getDescription=function(){if(this.getAggregation("customDescription")){return this.getAggregation("customDescription");}if(this.getEnableFormattedText()){return this._getFormattedText();}if(!this.getAggregation("_description")){var D=new T(this.getId()+"-description",{id:this.getId()+"-customDescription",text:this.getDescription(),textAlign:d.Center,textDirection:this.getTextDirection()});this.setAggregation("_description",D);}return this.getAggregation("_description");};
h.prototype._getAnyHeader=function(){return this._getInternalHeader();};
h.prototype._getInternalHeader=function(){return this.getAggregation("_internalHeader");};
h.prototype._getFormattedText=function(){var o=this.getAggregation("_formattedText");if(!o){o=new F(this.getId()+"-formattedText");this.setAggregation("_formattedText",o);}return o;};
return h;});
sap.ui.predefine('sap/m/MessagePageRenderer',['sap/ui/core/library'],function(c){"use strict";var T=c.TextDirection;var M={};
M.render=function(r,m){this.startOpeningDiv(r,m);this.renderHeader(r,m);this.startInnerDivs(r);this.renderContent(r,m);this.endInnerDivs(r);this.endOpeningDiv(r);};
M.startOpeningDiv=function(r,m){r.write("<div");r.writeControlData(m);r.addClass("sapMMessagePage");r.writeClasses();if(m.getTextDirection()!=T.Inherit){r.writeAttribute("dir",m.getTextDirection().toLowerCase());}r.write(">");};
M.renderHeader=function(r,m){if(m.getShowHeader()){r.renderControl(m.getAggregation("_internalHeader"));}};
M.startInnerDivs=function(r){r.write("<div");r.addClass("sapMMessagePageInner");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMMessagePageContentWrapper");r.writeClasses();r.write(">");};
M.renderContent=function(r,m){if(m.getIcon()){r.renderControl(m._getIconControl());}r.renderControl(m._getText().addStyleClass("sapMMessagePageMainText"));r.renderControl(m._getDescription().addStyleClass("sapMMessagePageDescription"));this.renderButtons(r,m);};
M.renderButtons=function(r,m){var b=m.getButtons();if(b.length>0){r.write("<div");r.addClass("sapMMessagePageButtonsWrapper");r.writeClasses();r.write(">");for(var i=0;i<b.length;i++){r.renderControl(b[i]);}r.write("</div>");}};
M.endInnerDivs=function(r){r.write("</div>");r.write("</div>");};
M.endOpeningDiv=function(r){r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MessagePopover',["jquery.sap.global","./ResponsivePopover","./Button","./Toolbar","./Bar","sap/ui/core/Control","sap/ui/core/IconPool","./semantic/SemanticPage","./Popover","./MessageView","sap/ui/Device","./MessagePopoverRenderer"],function(q,R,B,T,a,C,I,S,P,M,D,b){"use strict";
var c=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",altTypes:["sap.m.MessagePopoverItem"],multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false,forwarding:{idSuffix:"-messageView",aggregation:"headerButton"}}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});
function d(n){return n.charAt(0).toUpperCase()+n.slice(1);}
var e="sapMMsgPopover",f="320px",g="440px",h={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},A=["asyncDescriptionHandler","asyncURLHandler"],i={asyncDescriptionHandler:function(j){var l=j.item.getLongtextUrl();if(l){q.ajax({type:"GET",url:l,success:function(k){j.item.setDescription(k);j.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+l;q.sap.log.error(E);j.promise.reject(E);}});}}};
c.setDefaultHandlers=function(m){A.forEach(function(F){if(m.hasOwnProperty(F)){i[F]=m[F];}});};
c.prototype.init=function(){var t=this;var p;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._oMessageView.addEventDelegate({onBeforeRendering:function(){var s=t._oMessageView._oSegmentedButton.getVisible(),j=!t.getInitiallyExpanded()||s;t._oMessageView._oSegmentedButton.setVisible(j);t._oMessageView._listPage.setShowHeader(true);}});this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:g,contentHeight:f,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._oMessageView._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(e);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(D.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(i.hasOwnProperty(F)){this['set'+d(F)](i[F]);}},this);};
c.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover);}};
c.prototype.onBeforeRenderingPopover=function(){if(this._bItemsChanged){var j=this.getItems();var t=this;this._oMessageView.destroyItems();j.forEach(function(k){k._updateProperties(function(){t._bItemsChanged=true;});this._oMessageView.addItem(k.clone("","",{cloneChildren:true,cloneBinding:true}));},this);this._bItemsChanged=false;}this._setInitialFocus();};
c.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null;}};
c.prototype.exit=function(){this._oResourceBundle=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
c.prototype.openBy=function(o){var r=this._oPopover.getAggregation("_popup"),p=o.getParent();if(r instanceof P){if((p instanceof T||p instanceof a||p instanceof S)){r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(o);}return this;};
c.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};
c.prototype.isOpen=function(){return this._oPopover.isOpen();};
c.prototype.toggle=function(o){if(this.isOpen()){this.close();}else{this.openBy(o);}return this;};
c.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
c.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
c.prototype._initMessageView=function(){var t=this,m;m=new M(this.getId()+"-messageView",{listSelect:function(E){t.fireListSelect({messageTypeFilter:E.getParameter('messageTypeFilter')});},itemSelect:function(E){t.fireItemSelect({messageTypeFilter:E.getParameter('messageTypeFilter'),item:E.getParameter('item')});},longtextLoaded:function(){t.fireLongtextLoaded();},urlValidated:function(){t.fireUrlValidated();}});return m;};
c.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(e+"-init")){this._expandMsgPopover();}};
c.prototype._restoreExpansionDefaults=function(){if(!this.getInitiallyExpanded()){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none");}else{this._expandMsgPopover();}};
c.prototype._expandMsgPopover=function(){var s,H=f,s=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&s!=="0px"){H=parseFloat(s)?s:H;}this._oPopover.setContentHeight(H).removeStyleClass(e+"-init");};
c.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(e+"-init").setContentHeight("auto");};
c.prototype._insertCloseBtn=function(o){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),j=new B({icon:h["close"],visible:!D.system.phone,tooltip:s,press:this.close.bind(this)}).addStyleClass(e+"CloseBtn");o.insertContent(j,3,true);};
c.prototype._setInitialFocus=function(){if(this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||'all']);}};
c.prototype._afterNavigate=function(){q.sap.delayedCall(0,this,"_restoreFocus");};
c.prototype._restoreFocus=function(){if(this._oMessageView._isListPage()){var r=this._oRestoreFocus&&this._oRestoreFocus.control(0);r&&r.focus();}else{this._oMessageView._oBackButton.focus();}};
c.prototype.setAsyncDescriptionHandler=function(j){this.setProperty('asyncDescriptionHandler',j,true);this._oMessageView.setProperty('asyncDescriptionHandler',j,true);return this;};
c.prototype.setAsyncURLHandler=function(j){this.setProperty('asyncURLHandler',j,true);this._oMessageView.setProperty('asyncURLHandler',j,true);return this;};
c.prototype.setModel=function(m,n){this._oMessageView.setModel(m,n);return C.prototype.setModel.apply(this,arguments);};
["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(n){c.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var p=this._oPopover;var r=p[n].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){c.prototype["_"+F+"Old"]=c.prototype[F];c.prototype[F]=function(){var r=c.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return c;});
sap.ui.predefine('sap/m/MessagePopoverItem',["./library","./MessageItem"],function(l,M){"use strict";
var a=M.extend("sap.m.MessagePopoverItem",{});
return a;});
sap.ui.predefine('sap/m/MessagePopoverRenderer',[],function(){"use strict";var M={};
M.render=function(r,c){};
return M;},true);
sap.ui.predefine('sap/m/MessageStrip',["jquery.sap.global","./library","sap/ui/core/Control","./MessageStripUtilities","./Text","./Link","./FormattedText","sap/ui/core/library","sap/ui/Device","./MessageStripRenderer"],function(q,l,C,M,T,L,F,c,D,a){"use strict";var b=c.MessageType;
var d=C.extend("sap.m.MessageStrip",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MessageStrip.designtime",properties:{text:{type:"string",group:"Appearance",defaultValue:""},type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:b.Information},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},showCloseButton:{type:"boolean",group:"Appearance",defaultValue:false},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{close:{}}}});
d.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this.setAggregation("_text",new T());};
d.prototype.setText=function(t){var f=this.getAggregation("_formattedText");if(f){f.setHtmlText(t);}this.getAggregation("_text").setText(t);return this.setProperty("text",t);};
d.prototype.setType=function(t){if(t===b.None){q.sap.log.warning(M.MESSAGES.TYPE_NOT_SUPPORTED);t=b.Information;}return this.setProperty("type",t);};
d.prototype.setEnableFormattedText=function(e){var f=this.getAggregation("_formattedText");if(e){if(!f){f=new F();f._setUseLimitedRenderingRules(true);this.setAggregation("_formattedText",f);}f.setHtmlText(this.getText());}return this.setProperty("enableFormattedText",e);};
d.prototype.setAggregation=function(n,o,s){if(n==="link"&&o instanceof L){o.addAriaLabelledBy(this.getId());}C.prototype.setAggregation.call(this,n,o,s);return this;};
d.prototype.ontap=M.handleMSCloseButtonInteraction;d.prototype.onsapenter=M.handleMSCloseButtonInteraction;d.prototype.onsapspace=M.handleMSCloseButtonInteraction;
d.prototype.ontouchmove=function(e){e.setMarked();};
d.prototype.close=function(){var f=function(){this.fireClose();this.setVisible(false);}.bind(this);if(!sap.ui.getCore().getConfiguration().getAnimation()){f();return;}if(D.browser.internet_explorer&&D.browser.version<10){M.closeTransitionWithJavascript.call(this,f);}else{M.closeTransitionWithCSS.call(this,f);}};
return d;});
sap.ui.predefine('sap/m/MessageStripRenderer',["./MessageStripUtilities"],function(M){"use strict";var a={};
a.render=function(r,c){this.startMessageStrip(r,c);this.renderAriaTypeText(r,c);if(c.getShowIcon()){this.renderIcon(r,c);}this.renderTextAndLink(r,c);if(c.getShowCloseButton()){this.renderCloseButton(r);}this.endMessageStrip(r);};
a.startMessageStrip=function(r,c){r.write("<div");r.addClass(M.CLASSES.ROOT);r.addClass(M.CLASSES.ROOT+c.getType());r.writeControlData(c);r.writeClasses();r.writeAttribute(M.ATTRIBUTES.CLOSABLE,c.getShowCloseButton());r.writeAccessibilityState(c,M.getAccessibilityState.call(c));r.write(">");};
a.renderAriaTypeText=function(r,c){r.write("<span class='sapUiPseudoInvisibleText'>");r.write(M.getAriaTypeText.call(c));r.write("</span>");};
a.renderIcon=function(r,c){r.write("<div class='"+M.CLASSES.ICON+"'>");r.writeIcon(M.getIconURI.call(c),null,{"title":null});r.write("</div>");};
a.renderTextAndLink=function(r,c){var f=c.getAggregation("_formattedText");r.write("<div class='"+M.CLASSES.MESSAGE+"'>");if(c.getEnableFormattedText()&&f){r.renderControl(f);}else{r.renderControl(c.getAggregation("_text"));}r.renderControl(c.getLink());r.write("</div>");};
a.renderCloseButton=function(r){r.write("<button");r.writeAttribute("class",M.CLASSES.CLOSE_BUTTON);r.writeAttribute("title",M.RESOURCE_BUNDLE.getText("CLOSE"));r.write("></button>");};
a.endMessageStrip=function(r){r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/MessageStripUtilities',function(){"use strict";var M={};M.MESSAGES={TYPE_NOT_SUPPORTED:"Value 'sap.ui.core.MessageType.None' for property 'type' is not supported."+"Defaulting to 'sap.ui.core.MessageType.Information'"};M.CLASSES={ROOT:"sapMMsgStrip",ICON:"sapMMsgStripIcon",MESSAGE:"sapMMsgStripMessage",CLOSE_BUTTON:"sapMMsgStripCloseButton",CLOSING_TRANSITION:"sapMMsgStripClosing"};M.ATTRIBUTES={CLOSABLE:"data-sap-ui-ms-closable"};M.RESOURCE_BUNDLE=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");
M.getIconURI=function(){var t=this.getType(),c=this.getCustomIcon(),i="sap-icon://message-"+t.toLowerCase();return c||i;};
M.getAriaTypeText=function(){var b="MESSAGE_STRIP_"+this.getType().toUpperCase(),a=M.RESOURCE_BUNDLE.getText(b);if(this.getShowCloseButton()){a+=" "+M.RESOURCE_BUNDLE.getText("MESSAGE_STRIP_CLOSABLE");}return a;};
M.handleMSCloseButtonInteraction=function(e){if(M.isMSCloseButtonPressed(e.target)){this.close();}};
M.isMSCloseButtonPressed=function(t){return t.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1||t.parentNode.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1;};
M.closeTransitionWithJavascript=function(c){this.$().animate({opacity:0},{duration:200,complete:c});};
M.closeTransitionWithCSS=function(c){this.$().addClass(M.CLASSES.CLOSING_TRANSITION).one("webkitTransitionEnd transitionend",c);};
M.getAccessibilityState=function(){return{role:"alert",live:"assertive",labelledby:this.getId()};};
return M;});
sap.ui.predefine('sap/m/MessageToast',['jquery.sap.global','./InstanceManager','sap/ui/core/Popup','sap/ui/core/library','sap/ui/core/Control','sap/ui/Device'],function(q,I,P,c,C,D){"use strict";var a=c.Dock;var d=c.CSSSize;var M={};var O="0 -64",e="sapMMessageToast",E="sapUiSelectable",B="sapContrast",f="sapContrastPlus";M._mSettings={duration:3000,width:"15em",my:"center bottom",at:"center bottom",of:document.defaultView,offset:"0 0",collision:"fit fit",onClose:null,animationTimingFunction:"ease",animationDuration:1000,autoClose:true,closeOnBrowserNavigation:true};M._aPopups=[];M._iOpenedPopups=0;M._bBoundedEvents=false;
M._validateSettings=function(s){this._isFiniteInteger(s.duration);this._validateWidth(s.width);this._validateDockPosition(s.my);this._validateDockPosition(s.at);this._validateOf(s.of);this._validateOffset(s.offset);this._validateCollision(s.collision);this._validateOnClose(s.onClose);this._validateAutoClose(s.autoClose);this._validateAnimationTimingFunction(s.animationTimingFunction);this._isFiniteInteger(s.animationDuration);};
M._isFiniteInteger=function(N){if(typeof N!=="number"||!isFinite(N)||!(Math.floor(N)===N)||N<=0){q.sap.log.error('"iNumber" needs to be a finite positive nonzero integer on '+this+"._isFiniteInteger");}};
M._validateWidth=function(w){if(!d.isValid(w)){q.sap.log.error(w+' is not of type '+'"sap.ui.core.CSSSize" for property "width" on '+this+"._validateWidth");}};
M._validateDockPosition=function(s){if(!a.isValid(s)){q.sap.log.error('"'+s+'"'+' is not of type '+'"sap.ui.core.Popup.Dock" on '+this+"._validateDockPosition");}};
M._validateOf=function(v){if(!(v instanceof q)&&!(v&&v.nodeType===1)&&!(v instanceof C)&&v!==window){q.sap.log.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on '+this+"._validateOf");}};
M._validateOffset=function(o){if(typeof o!=="string"){q.sap.log.error(o+' is of type '+typeof o+', expected "string" for property "offset" on '+this+"._validateOffset");}};
M._validateCollision=function(s){var r=/^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;if(!r.test(s)){q.sap.log.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on '+this+"._validateOffset");}};
M._validateOnClose=function(b){if(typeof b!=="function"&&b!==null){q.sap.log.error('"onClose" should be a function or null on '+this+"._validateOnClose");}};
M._validateAutoClose=function(b){if(typeof b!=="boolean"){q.sap.log.error('"autoClose" should be a boolean on '+this+"._validateAutoClose");}};
M._validateAnimationTimingFunction=function(t){var r=/^(ease|linear|ease-in|ease-out|ease-in-out)$/i;if(!r.test(t)){q.sap.log.error('"animationTimingFunction" should be a string, expected values: '+"ease, linear, ease-in, ease-out, ease-in-out on "+this+"._validateAnimationTimingFunction");}};
function h(o){for(var p=["my","at","of","offset"],i=0;i<p.length;i++){if(o[p[i]]!==undefined){return false;}}return true;}
function g(s){var m=document.createElement("div");m.className=e+" "+E+" "+B+" "+f;if(sap.ui.getCore().getConfiguration().getAccessibility()){m.setAttribute("role","alert");m.setAttribute("aria-label"," ");}m.style.width=s.width;m.appendChild(document.createTextNode(s.message));return m;}
function n(o){if(o){if(h(o)){o.offset=O;}if(o.of&&o.of.nodeType===9){o.of=document.defaultView;}}else{o={offset:O};}return o;}
M._handleResizeEvent=function(){if(D.system.phone||D.system.tablet){this._resetPosition(this._aPopups);}q.sap.delayedCall(0,this,"_applyPositions",[this._aPopups]);};
M._handleMouseDownEvent=function(o){var i=o.target.hasAttribute("class")&&o.target.getAttribute("class").indexOf(e)!==-1;if(i||o.isMarked("delayedMouseEvent")){return;}this._aPopups.forEach(function(p){p&&p.__bAutoClose&&p.close();});};
M._resetPosition=function(p){for(var i=0,m;i<p.length;i++){m=p[i]&&p[i].getContent();if(m){m.style.visibility="hidden";m.style.left=0;}}};
M._applyPositions=function(p){for(var i=0,o,m;i<p.length;i++){o=p[i];if(o){m=o._oPosition;if(D.system.phone||D.system.tablet){q.sap.delayedCall(0,this,"_applyPosition",[o,m]);}else{o.setPosition(m.my,m.at,m.of,m.offset);}}}};
M._applyPosition=function(p,m){var m=m||p._oPosition,o=p.getContent();p.setPosition(m.my,m.at,m.of,m.offset);o.style.visibility="visible";};
M._setCloseAnimation=function(m,i,b,s){var j="opacity "+s.animationTimingFunction+" "+s.animationDuration+"ms",t="webkitTransitionEnd."+e+" transitionend."+e;if(sap.ui.getCore().getConfiguration().getAnimation()&&s.animationDuration>0){m[0].style.webkitTransition=j;m[0].style.transition=j;m[0].style.opacity=0;m.on(t,function handleMTTransitionEnd(){m.off(t);b();});}else{b();}};
M.show=function(m,o){var t=this,s=q.extend({},this._mSettings,{message:m}),p=new P(),i,b,j="mousedown."+e+" touchstart."+e,k,l;o=n(o);q.extend(s,o);this._validateSettings(s);b=g(s);i=this._aPopups.push(p)-1;p.setContent(b);p.setPosition(s.my,s.at,s.of,s.offset,s.collision);if(q.support.cssTransitions){p.setAnimations(function fnMessageToastOpen($,v,w){w();},function fnMessageToastClose($,v,w){t._setCloseAnimation($,v,w,s);});}p.setShadow(false);p.__bAutoClose=s.autoClose;if(s.closeOnBrowserNavigation){I.addPopoverInstance(p);}if(!this._bBoundedEvents){q(window).on("resize."+e,this._handleResizeEvent.bind(this));q(document).on(j,this._handleMouseDownEvent.bind(this));this._bBoundedEvents=true;}p.open();this._iOpenedPopups++;function r(){I.removePopoverInstance(t._aPopups[i]);q(t._aPopups[i].getContent()).remove();t._aPopups[i].detachClosed(r);t._aPopups[i].destroy();t._aPopups[i]=null;t._iOpenedPopups--;if(t._iOpenedPopups===0){t._aPopups=[];q(window).off("resize."+e);q(document).off(j);t._bBoundedEvents=false;}if(typeof s.onClose==="function"){s.onClose.call(t);}}p.attachClosed(r);k=q.sap.delayedCall(s.duration,p,"close");function u(){q.sap.clearDelayedCall(k);k=null;function v(){l=q.sap.delayedCall(s.duration,p,"close");p.getContent().removeEventListener("mouseleave",v);}p.getContent().addEventListener("mouseleave",v);q.sap.clearDelayedCall(l);l=null;}p.getContent().addEventListener("touchstart",u);p.getContent().addEventListener("mouseover",u);if(D.system.desktop){p.getContent().addEventListener("mouseleave",function(){k=q.sap.delayedCall(s.duration,p,"close");});}};
M.toString=function(){return"sap.m.MessageToast";};
return M;},true);
sap.ui.predefine('sap/m/MessageView',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./List","./StandardListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./MessageItem","./GroupHeaderListItem","sap/ui/core/library","sap/ui/base/ManagedObject","./MessageViewRenderer","jquery.sap.keycodes"],function(q,C,a,I,H,b,B,T,c,L,S,l,d,e,P,N,f,M,G,g,h,j){"use strict";var V=g.ValueState;var k=g.MessageType;var m=l.ListType;
var n=C.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false},showDetailsPageHeader:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false},_navContainer:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});
var o="sapMMsgView";var p={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")};var r=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var D={asyncDescriptionHandler:function(i){var s=i.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(t){i.item.setDescription(t);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);i.promise.reject(E);}});}}};
n.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};
n.prototype.init=function(){var t=this;this._bHasHeaderButton=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};
n.prototype.onBeforeRendering=function(){var i,s=this.getItems();this._clearLists();this._detailsPage.setShowHeader(this.getShowDetailsPageHeader());if(this.getGroupItems()){i=this._groupItems(s);this._fillGroupedLists(i);}else{this._fillLists(s);}var t=this.getHeaderButton();if(t){this._bHasHeaderButton=true;this._oListHeader.insertContent(t,2);}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");if(s.length===1&&this._oLists.all.getItems()[0].getType()===m.Navigation){this._fnHandleForwardNavigation(this._oLists.all.getItems()[0],"show");this._navContainer._pageStack[this._navContainer._pageStack.length-1].transition="slide";}if(!this.getBindingInfo("items")&&!s.length){this._makeAutomaticBinding();}};
n.prototype._fillGroupedLists=function(i){var s=Object.keys(i),u=s.indexOf(""),U,t;if(u!==-1){U=i[""];t=Object.keys(U);t.forEach(function(v){var w=U[v];this._fillLists(w);delete i[""];s.splice(u,1);},this);}s.forEach(function(v){this._fillListsWithGroups(v,i[v]);},this);};
n.prototype._fillListsWithGroups=function(s,i){var t=Object.keys(i),u=new G({title:s}),v;this._oLists["all"].addAggregation("items",u,true);t.forEach(function(w){this._oLists[w.toLowerCase()].addAggregation("items",u.clone(),true);v=i[w];this._fillLists(v);},this);};
n.prototype.exit=function(){if(this._oLists){this._destroyLists();}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy();}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;};
n.prototype._makeAutomaticBinding=function(){var t=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new M({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate});};
n.prototype._groupItems=function(i){var s={},t,u;i.forEach(function(v){t=v.getGroupName();u=v.getType();s[t]=s[t]||{};var w=s[t];if(w[u]){w[u].push(v);}else{w[u]=[v];}});return s;};
n.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==q.sap.KeyCodes.ENTER){this.navigateBack();}};
n.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};
n.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};
n.prototype._createListHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDescr";var t=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var u=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var v=this.getId()+"-HeadingDescr";var w=new H(v,{content:"<span id=\""+v+"\" style=\"display: none;\" role=\"heading\">"+u+"</span>"});this._oSegmentedButton=new e(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new c(),t,w]});return this._oListHeader;};
n.prototype._createDetailsHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDetDescr";var t=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var u=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var v=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var w=this.getId()+"-BackBtnDetDescr";var x=new H(w,{content:"<span id=\""+w+"\" style=\"display: none;\">"+v+"</span>"});this._oBackButton=new B({icon:p["back"],press:this.navigateBack.bind(this),ariaLabelledBy:x,tooltip:u}).addStyleClass(o+"BackBtn");this._oDetailsHeader=new T({content:[this._oBackButton,new c(),t,x]});return this._oDetailsHeader;};
n.prototype._createNavigationPages=function(){this._listPage=new P(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new P(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgPopoverItemDisabledLink")!==-1||t.className.indexOf("sapMMsgPopoverItemPendingLink")!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage]});this.setAggregation("_navContainer",this._navContainer);return this;};
n.prototype._createLists=function(){this._oLists={};r.forEach(function(s){this._oLists[s]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[s],true);},this);return this;};
n.prototype._clearLists=function(){r.forEach(function(s){if(this._oLists[s]){this._oLists[s].destroyAggregation("items",true);}},this);return this;};
n.prototype._destroyLists=function(){r.forEach(function(s){this._oLists[s]=null;},this);this._oLists=null;};
n.prototype._fillLists=function(i){i.forEach(function(s){var t=this._mapItemToListItem(s),u=this._mapItemToListItem(s);this._oLists["all"].addAggregation("items",t,true);this._oLists[s.getType().toLowerCase()].addAggregation("items",u,true);},this);};
n.prototype._mapItemToListItem=function(i){if(!i){return null;}var t=i.getType(),s=this._getItemType(i),u=new S({title:h.escapeSettingsValue(i.getTitle()),description:h.escapeSettingsValue(i.getSubtitle()),counter:i.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"\r",type:s}).addStyleClass(o+"Item").addStyleClass(o+"Item"+t);if(s!==m.Navigation){u.addEventDelegate({onAfterRendering:function(){var v=this.getDomRef().querySelector(".sapMSLITitleDiv > div");if(v.offsetWidth<v.scrollWidth){this.setType(m.Navigation);}}},u);}u._oMessageItem=i;return u;};
n.prototype._mapInfoState=function(t){if(!t){return null;}switch(t){case k.Warning:return V.Warning;case k.Error:return V.Error;case k.Success:return V.Success;case k.Information:case k.None:return V.None;default:q.sap.log.warning("The provided MessageType is not mapped to a specific ValueState",t);return null;}};
n.prototype._mapIcon=function(i){if(!i){return null;}return p[i.toLowerCase()];};
n.prototype._getItemType=function(i){return(i.getDescription()||i.getMarkupDescription()||i.getLongtextUrl())?m.Navigation:m.Inactive;};
n.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};
n.prototype._fillSegmentedButton=function(){var t=this;var i=function(v){return function(){t._fnFilterList(v);};};r.forEach(function(v){var w=this._oLists[v],x=w.getItems().filter(function(z){return(z instanceof S);}).length,y;if(x>0){y=new B(this.getId()+"-"+v,{text:v=="all"?this._oResourceBundle.getText("MESSAGEPOPOVER_ALL"):x,icon:p[v],press:i(v)}).addStyleClass(o+"Btn"+v.charAt(0).toUpperCase()+v.slice(1));this._oSegmentedButton.addButton(y,true);}},this);var s=this._oSegmentedButton.getButtons().length>2;this._oSegmentedButton.setVisible(s);var u=s||this._bHasHeaderButton;this._listPage.setShowHeader(u);return this;};
n.prototype._setIcon=function(i,s){this._previousIconTypeClass=o+"DescIcon"+i.getType();this._oMessageIcon=new b({src:s.getIcon()}).addStyleClass(o+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};
n.prototype._setTitle=function(i){this._oMessageTitleText=new d(this.getId()+"MessageTitleText",{text:h.escapeSettingsValue(i.getTitle())}).addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",this._oMessageTitleText);};
n.prototype._setDescription=function(i){var s=i.getLink();this._oLastSelectedItem=i;if(i.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+i.getDescription()+"</div>"});}else{this._oMessageDescriptionText=new d(this.getId()+"MessageDescriptionText",{text:h.escapeSettingsValue(i.getDescription())}).addStyleClass("sapMMsgViewDescriptionText");}this._detailsPage.addContent(this._oMessageDescriptionText);if(s){var t=this._createLinkCopy(s);this._detailsPage.addContent(t);t.addStyleClass("sapMMsgViewDescriptionLink");}};
n.prototype._createLinkCopy=function(i){var s,t=i.clone("","",{cloneChildren:false,cloneBindings:false}),u=i.getCustomData()||[];s=Object.keys(i.getMetadata().getProperties());s.forEach(function(v){t.setProperty(v,i.getProperty(v));});t.destroyCustomData();u.forEach(function(v){var w=new a({key:v.getKey(),value:v.getValue()});t.addCustomData(w);});return t;};
n.prototype._iNextValidationTaskId=0;
n.prototype._validateURL=function(u){if(q.sap.validateUrl(u)){return u;}q.sap.log.warning("You have entered invalid URL");return"";};
n.prototype._queueValidation=function(i){var s=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var t={};var u=new window.Promise(function(w,x){t.resolve=w;t.reject=x;var y={url:i,id:v,promise:t};s(y);});u.id=v;return u;};
n.prototype._getTagPolicy=function(){var t=this,i;var s=html.makeTagPolicy(this._validateURL());return function customTagPolicy(u,v){var w,x=false;if(u.toUpperCase()==="A"){for(i=0;i<v.length;){if(v[i]==="href"){x=true;w=v[i+1];v.splice(0,2);continue;}i+=2;}}v=s(u,v);if(x&&typeof t.getAsyncURLHandler()==="function"){v=v||[];var y="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink";var z=v.indexOf("class");if(z>-1){v[z+1]+=y;}else{v.unshift(y);v.unshift("class");}var E=v.indexOf("id");if(E>-1){v.splice(E+1,1);v.splice(E,1);}var F=t._queueValidation(w);v.push("href");v.push(w);v.push("target");v.push("_blank");v.push("id");v.push("sap-ui-"+t.getId()+"-link-under-validation-"+F.id);F.then(function(J){var $=q.sap.byId("sap-ui-"+t.getId()+"-link-under-validation-"+J.id);if(J.allowed){q.sap.log.info("Allow link "+w);}else{q.sap.log.info("Disallow link "+w);}$.removeClass("sapMMsgViewItemPendingLink");$.toggleClass("sapMMsgViewItemDisabledLink",!J.allowed);t.fireUrlValidated();}).catch(function(){q.sap.log.warning("Async URL validation could not be performed.");});}return v;};};
n.prototype._sanitizeDescription=function(i){q.sap.require("jquery.sap.encoder");q.sap.require("sap.ui.thirdparty.caja-html-sanitizer");var s=i.getDescription();if(i.getMarkupDescription()){var t=this._getTagPolicy();s=html.sanitizeWithPolicy(s,t);}i.setDescription(s);this._setDescription(i);};
n.prototype._fnHandleForwardNavigation=function(i,t){var s=i._oMessageItem,u=this._detailsPage.getContent()||[],v=this.getAsyncDescriptionHandler();this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:s,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._clearDetailsPage.call(this,u);if(typeof v==="function"&&!!s.getLongtextUrl()){s.setMarkupDescription(true);var w={};var x=new window.Promise(function(z,E){w.resolve=z;w.reject=E;});var y=function(){this._detailsPage.setBusy(false);this._navigateToDetails.call(this,s,i,t,true);}.bind(this);x.then(y).catch(function(){q.sap.log.warning("Async description loading could not be performed.");y();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);v({promise:w,item:s});}else{this._navigateToDetails.call(this,s,i,t,false);}this._listPage.$().attr("aria-hidden","true");};
n.prototype._fnHandleItemPress=function(E){this._fnHandleForwardNavigation(E.getParameter("listItem"),"slide");};
n.prototype._navigateToDetails=function(i,s,t,u){this._setTitle(i);this._sanitizeDescription(i);this._setIcon(i,s);this._detailsPage.rerender();this.fireLongtextLoaded();if(!u){this._navContainer.to(this._detailsPage,t);}};
n.prototype._clearDetailsPage=function(i){i.forEach(function(s){s.destroy();},this);};
n.prototype.navigateBack=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};
n.prototype._fnFilterList=function(s){r.forEach(function(i){if(i!=s&&this._oLists[i].getVisible()){this._oLists[i].setVisible(false);}},this);this._sCurrentList=s;this._oLists[s].setVisible(true);this._listPage.rerender();this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};
n.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};
n.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage;};
return n;});
sap.ui.predefine('sap/m/MessageViewRenderer',function(){"use strict";var M={};var C="sapMMsgView";
M.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeStyles();r.addClass(C);r.writeClasses();r.write(">");r.renderControl(c._navContainer);r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MultiComboBox',['jquery.sap.global','./InputBase','./ComboBoxTextField','./ComboBoxBase','./Input','./ToggleButton','./List','./Popover','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/ui/core/Item','./MultiComboBoxRenderer','jquery.sap.xml','jquery.sap.keycodes'],function(q,I,C,a,b,T,L,P,l,E,c,d,D,e,M){"use strict";var f=l.ListType;var g=l.ListMode;var V=d.ValueState;var O=d.OpenState;
var h=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}}}});
c.insertFontFaceStyle();E.apply(h.prototype,[true]);
h.prototype.onsapend=function(o){sap.m.Tokenizer.prototype.onsapend.apply(this._oTokenizer,arguments);};
h.prototype.onsaphome=function(o){sap.m.Tokenizer.prototype.onsaphome.apply(this._oTokenizer,arguments);};
h.prototype.onsapdown=function(o){if(!this.getEnabled()||!this.getEditable()){return;}o.setMarked();o.preventDefault();var i=this.getSelectableItems();var j=i[0];if(j&&this.isOpen()){this.getListItem(j).focus();return;}if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
h.prototype.onsapup=function(o){if(!this.getEnabled()||!this.getEditable()){return;}o.setMarked();o.preventDefault();if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
h.prototype.onsapshow=function(o){var i=this.getList(),p=this.getPicker(),s=this.getSelectableItems(),S=this.getSelectedItems(),j,k=i.getItemNavigation(),m,n;n=q(document.activeElement).control()[0];if(n instanceof sap.m.Token){j=this._getItemByToken(n);}else{j=S.length?this._getItemByListItem(this.getList().getSelectedItems()[0]):s[0];}m=this.getItems().indexOf(j);if(k){k.setSelectedIndex(m);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=m;}p.setInitialFocus(i);a.prototype.onsapshow.apply(this,arguments);};
h.prototype.onsaphide=h.prototype.onsapshow;
h.prototype._selectItemByKey=function(o){var v,p,j,i,k,m=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(o){o.setMarked();}v=this._getUnselectedItems(m?"":this.getValue());for(i=0;i<v.length;i++){if(v[i].getText().toUpperCase()===this.getValue().toUpperCase()){j=v[i];k=true;break;}}if(k){p={item:j,id:j.getId(),key:j.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||q.sap.startsWithIgnoreCase(j.getText(),this.getValue())){if(this.getListItem(j).isSelected()){this.setValue('');}else{this.setSelection(p);}}}else{this._bPreventValueRemove=true;this._showWrongValueVisualEffect();}if(o){this.close();}};
h.prototype.onsapenter=function(o){I.prototype.onsapenter.apply(this,arguments);if(this.getValue()){this._selectItemByKey(o);}};
h.prototype.onsaptabnext=function(o){var i=this.getValue();if(i){var s=this._getUnselectedItemsStartingText(i);if(s.length===1){this._selectItemByKey(o);}else{this._showWrongValueVisualEffect();}}};
h.prototype.onsapfocusleave=function(o){var p=this.getAggregation("picker"),t=this.isPlatformTablet(),i=sap.ui.getCore().byId(o.relatedControlId),F=i&&i.getFocusDomRef(),s=this.getValue();if(!p||!p.getFocusDomRef()||!F||!q.contains(p.getFocusDomRef(),F)){this.setValue(null);if(s){this.fireChangeEvent("",{value:s});}if(!(i instanceof sap.m.Token)){this._oTokenizer.scrollToEnd();}}if(p&&F){if(q.sap.equal(p.getFocusDomRef(),F)&&!t&&!this.isPickerDialog()){this.focus();}}};
h.prototype.onfocusin=function(o){var i=this.getPickerType()==="Dropdown";if(o.target===this.getFocusDomRef()){this.getEditable()&&this.addStyleClass("sapMMultiComboBoxFocus");}if(o.target===this.getOpenArea()&&i&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
h.prototype._handleItemTap=function(o){if(o.target.childElementCount===0||o.target.childElementCount===2){this._bCheckBoxClicked=false;if(this.isOpen()&&!this._isListInSuggestMode()){this.close();}}};
h.prototype._handleItemPress=function(o){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){this.clearFilter();var i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}}};
h.prototype._handleSelectionLiveChange=function(o){var i=o.getParameter("listItem");var j=o.getParameter("selected");var n=this._getItemByListItem(i);if(i.getType()==="Inactive"){return;}if(!n){return;}var p={item:n,id:n.getId(),key:n.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(j){this.fireChangeEvent(n.getText());this.setSelection(p);}else{this.fireChangeEvent(n.getText());this.removeSelection(p);}if(this._bCheckBoxClicked){this.setValue(this._sOldValue);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){i.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};
h.prototype.onkeydown=function(o){a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bIsPasteEvent=(o.ctrlKey||o.metaKey)&&(o.which===q.sap.KeyCodes.V);if(this.getValue().length===0&&(o.ctrlKey||o.metaKey)&&(o.which===q.sap.KeyCodes.A)&&this._hasTokens()){this._oTokenizer.focus();this._oTokenizer.selectAllTokens(true);o.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}};
h.prototype.oninput=function(o){a.prototype.oninput.apply(this,arguments);var i=o.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bIsPasteEvent){i.updateDomValue(this._sOldValue||"");return;}if(!this._bCompositionStart&&!this._bCompositionEnd){this._handleInputValidation(o,false);}};
h.prototype.filterItems=function(i,v){i.forEach(function(o){var m=q.sap.startsWithIgnoreCase(o.getText(),v);if(v===""){m=true;if(!this.bOpenedByKeyboardOrButton){return;}}var j=this.getListItem(o);if(j){j.setVisible(m);}},this);};
h.prototype.onkeyup=function(o){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};
h.prototype._showWrongValueVisualEffect=function(){var o=this.getValueState();if(o===V.Error){return;}if(this.isPickerDialog()){this.getPickerTextField().setValueState(V.Error);q.sap.delayedCall(1000,this.getPickerTextField(),"setValueState",[o]);}else{this.setValueState(V.Error);q.sap.delayedCall(1000,this,"setValueState",[o]);}};
h.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var r=this.getRenderer(),i=r.CSS_CLASS_MULTICOMBOBOX;o.setHorizontalScrolling(false).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(i+"Picker").addStyleClass(i+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return o;};
h.prototype.createPickerTextField=function(){return new b();};
h.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var i=this.getItems();var o=this.getList();if(o){this._synchronizeSelectedItemAndKey(i);o.destroyItems();this._clearTokenizer();this._fillList(i);if(o.getItemNavigation()){this._iFocusedIndex=o.getItemNavigation().getFocusedIndex();}this.setEditable(this.getEditable());}};
h.prototype.onBeforeRenderingPicker=function(){var o=this["_onBeforeRendering"+this.getPickerType()];if(o){o.call(this);}};
h.prototype.onAfterRenderingPicker=function(){var o=this["_onAfterRendering"+this.getPickerType()];if(o){o.call(this);}};
h.prototype.onBeforeOpen=function(){var p=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();if(p){p.call(this);}};
h.prototype.onAfterOpen=function(){if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}this.closeValueStateMessage();};
h.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};
h.prototype.onAfterClose=function(){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this.clearFilter();!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this._getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});};
h.prototype._onBeforeOpenDialog=function(){};
h.prototype._onBeforeOpenDropdown=function(){var p=this.getPicker(),o=this.getDomRef(),w;if(o&&p){w=(o.offsetWidth/parseFloat(l.BaseFontSize))+"rem";p.setContentMinWidth(w);}};
h.prototype._decoratePopover=function(p){var t=this;p.open=function(){return this.openBy(t);};};
h.prototype.createDropdown=function(){var o=new P(this.getDropdownSettings());o.setInitialFocus(this);this._decoratePopover(o);return o;};
h.prototype.createDialog=function(){var o=a.prototype.createDialog.apply(this,arguments),s=this._createFilterSelectedButton();o.getSubHeader().addContent(s);return o;};
h.prototype._createFilterSelectedButton=function(){var i=c.getIconURI("multiselect-all"),r=this.getRenderer(),t=this;return new T({icon:i,press:t._filterSelectedItems.bind(this)}).addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"ToggleButton");};
h.prototype._getFilterSelectedButton=function(){return this.getPicker().getSubHeader().getContent()[1];};
h.prototype._filterSelectedItems=function(o){var B=o.oSource,i,m,v=this.getPickerTextField().getValue(),p=B.getPressed(),j=this.getVisibleItems(),k=this.getItems(),s=this.getSelectedItems();if(p){j.forEach(function(n){m=s.indexOf(n)>-1?true:false;i=this.getListItem(n);if(i){i.setVisible(m);}},this);}else{this.filterItems(k,v);}};
h.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};
h.prototype.createList=function(){var r=this.getRenderer();this._oList=new L({width:"100%",mode:g.MultiSelect,includeItemInSelection:true,rememberSelections:false}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"List").attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);this._oList.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};
h.prototype.setSelection=function(o){if(o.item&&this.isItemSelected(o.item)){return;}if(!o.item){return;}if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),true);}var t=new sap.m.Token({key:o.key});t.setText(o.item.getText());t.setTooltip(o.item.getText());o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:true});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
h.prototype.removeSelection=function(o){if(o.item&&!this.isItemSelected(o.item)){return;}if(!o.item){return;}this.removeAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),false);}if(!o.tokenUpdated){var t=this._getTokenByItem(o.item);o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this._oTokenizer.removeToken(t);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:false});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
h.prototype._synchronizeSelectedItemAndKey=function(j){if(!j.length){q.sap.log.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}var s=this.getSelectedKeys()||this._aCustomerKeys;var k=this.getKeys(this.getSelectedItems());if(s.length){for(var i=0,K=null,o=null,m=null,n=s.length;i<n;i++){K=s[i];if(k.indexOf(K)>-1){if(this._aCustomerKeys.length&&(m=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(m,1);}continue;}o=this.getItemByKey(""+K);if(o){if(this._aCustomerKeys.length&&(m=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(m,1);}this.setSelection({item:o,id:o.getId(),key:o.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}return;}};
h.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};
h.prototype.updateItems=function(r){var k,i,K=this.getSelectedKeys();var u=a.prototype.updateItems.apply(this,arguments);i=this.getSelectedItems();k=(i.length===K.length)&&i.every(function(o){return o&&o.getKey&&K.indexOf(o.getKey())>-1;});if(!k){i=K.map(this.getItemByKey,this);this.setSelectedItems(i);}return u;};
h.prototype._getSelectedItemsOf=function(j){for(var i=0,k=j.length,s=[];i<k;i++){if(this.getListItem(j[i]).isSelected()){s.push(j[i]);}}return s;};
h.prototype._getLastSelectedItem=function(){var t=this._oTokenizer.getTokens();var o=t.length?t[t.length-1]:null;if(!o){return null;}return this._getItemByToken(o);};
h.prototype._getOrderedSelectedItems=function(){var j=[];for(var i=0,t=this._oTokenizer.getTokens(),k=t.length;i<k;i++){j[i]=this._getItemByToken(t[i]);}return j;};
h.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=sap.ui.getCore().byId(document.activeElement.id);if(this.getList()&&q.sap.containsOrEquals(this.getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};
h.prototype._getFocusedItem=function(){var o=this._getFocusedListItem();return this._getItemByListItem(o);};
h.prototype._isRangeSelectionSet=function(o){var $=o.getDomRef();return $.indexOf(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"ItemRangeSelection")>-1?true:false;};
h.prototype._hasTokens=function(){return this._oTokenizer.getTokens().length>0;};
h.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};
h.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};
h.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};
h.prototype._decorateListItem=function(o){o.addDelegate({onkeyup:function(i){var j=null;if(i.which==q.sap.KeyCodes.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();j=this._getLastSelectedItem();if(j){this.getListItem(j).focus();}return;}},onkeydown:function(i){var j=null,k=null;if(i.shiftKey&&i.which==q.sap.KeyCodes.ARROW_DOWN){k=this._getCurrentItem();j=this._getNextVisibleItemOf(k);}if(i.shiftKey&&i.which==q.sap.KeyCodes.ARROW_UP){k=this._getCurrentItem();j=this._getPreviousVisibleItemOf(k);}if(i.shiftKey&&i.which===q.sap.KeyCodes.SPACE){k=this._getCurrentItem();this._selectPreviousItemsOf(k);}if(j&&j!==k){if(this.getListItem(k).isSelected()){this.setSelection({item:j,id:j.getId(),key:j.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(j);}else{this.removeSelection({item:j,id:j.getId(),key:j.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(j);}return;}this._resetCurrentItem();if((i.ctrlKey||i.metaKey)&&i.which==q.sap.KeyCodes.A){i.setMarked();i.preventDefault();var v=this.getSelectableItems();var s=this._getSelectedItemsOf(v);if(s.length!==v.length){v.forEach(function(j){this.setSelection({item:j,id:j.getId(),key:j.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{v.forEach(function(j){this.removeSelection({item:j,id:j.getId(),key:j.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);o.addEventDelegate({onsapbackspace:function(i){i.preventDefault();},onsapshow:function(i){i.setMarked();if(i.keyCode===q.sap.KeyCodes.F4){i.preventDefault();}if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(i){this.onsapshow(i);},onsapenter:function(i){i.setMarked();this.close();},onsaphome:function(i){i.setMarked();i.preventDefault();var v=this.getSelectableItems();var j=v[0];this.getListItem(j).focus();},onsapend:function(i){i.setMarked();i.preventDefault();var v=this.getSelectableItems();var j=v[v.length-1];this.getListItem(j).focus();},onsapup:function(i){i.setMarked();i.preventDefault();var v=this.getSelectableItems();var j=v[0];var k=q(document.activeElement).control()[0];if(k===this.getListItem(j)){this.focus();i.stopPropagation(true);}},onfocusin:function(i){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(i){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(i){var p=this.getAggregation("picker");var j=sap.ui.getCore().byId(i.relatedControlId);if(p&&j&&q.sap.equal(p.getFocusDomRef(),j.getFocusDomRef())){if(i.srcControl){i.srcControl.focus();}}}},this);if(D.support.touch){o.addEventDelegate({ontouchstart:function(i){i.setMark("cancelAutoClose");}});}};
h.prototype._createTokenizer=function(){var t=new sap.m.Tokenizer({tokens:[]}).attachTokenChange(this._handleTokenChange,this);t.setParent(this);t.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return t;};
h.prototype._onAfterRenderingTokenizer=function(){this._oTokenizer.scrollToEnd();};
h.prototype._handleTokenChange=function(o){var t=o.getParameter("type");var i=o.getParameter("token");var j=null;if(t!==sap.m.Tokenizer.TokenChangeType.Removed&&t!==sap.m.Tokenizer.TokenChangeType.Added){return;}if(t===sap.m.Tokenizer.TokenChangeType.Removed){j=(i&&this._getItemByToken(i));if(j&&this.isItemSelected(j)){this.removeSelection({item:j,id:j.getId(),key:j.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});!this.isPickerDialog()&&this.focus();this.fireChangeEvent("");}}};
h.prototype.onAfterRenderingList=function(){var o=this.getList();if(this._iFocusedIndex!=null&&o.getItems().length>this._iFocusedIndex){o.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};
h.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated){this.getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};
h.prototype.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);var p=this.getPicker();var o=q(this.getDomRef());var B=o.find(this.getRenderer().DOT_CSS_CLASS_MULTICOMBOBOX+"Border");p._oOpenBy=B[0];};
h.prototype.onfocusout=function(o){this.removeStyleClass("sapMMultiComboBoxFocus");a.prototype.onfocusout.apply(this,arguments);};
h.prototype.onpaste=function(o){var s;if(window.clipboardData){s=window.clipboardData.getData("Text");}else{s=o.originalEvent.clipboardData.getData('text/plain');}var S=this._oTokenizer._parseString(s);if(S&&S.length>0){this.getSelectableItems().forEach(function(i){if(q.inArray(i.getText(),S)>-1){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};
h.prototype.onsapbackspace=function(o){if(!this.getEnabled()||!this.getEditable()){o.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._oTokenizer,arguments);o.preventDefault();};
h.prototype.onsapdelete=function(o){if(!this.getEnabled()||!this.getEditable()){return;}if(this.getValue()&&!this._isCompleteTextSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._oTokenizer,arguments);};
h.prototype.onsapnext=function(o){if(o.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===this._oTokenizer||this._oTokenizer.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};
h.prototype.onsapprevious=function(o){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(o.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._oTokenizer,arguments);}}};
h.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};
h.prototype._getItemsStartingText=function(t,i){var j=[],s=i?this.getEnabledItems():this.getSelectableItems();s.forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){j.push(o);}},this);return j;};
h.prototype._getUnselectedItemsStartingText=function(t){var i=[];this._getUnselectedItems().forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){i.push(o);}},this);return i;};
h.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
h.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false;}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false;}return true;};
h.prototype._selectPreviousItemsOf=function(i){var j;do{j=true;var p=this._getPreviousVisibleItemOf(i);if(p){var o=this.getListItem(p);if(o){j=this.getListItem(p).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=p;}while(!j);};
h.prototype._getNextVisibleItemOf=function(i){var j=this.getSelectableItems();var k=j.indexOf(i)+1;if(k<=0||k>j.length-1){return null;}return j[k];};
h.prototype._getPreviousVisibleItemOf=function(i){var j=this.getSelectableItems();var k=j.indexOf(i)-1;if(k<0){return null;}return j[k];};
h.prototype._getNextUnselectedItemOf=function(i){var j=this._getUnselectedItems();var k=j.indexOf(i)+1;if(k<=0||k>j.length-1){return null;}return j[k];};
h.prototype._getPreviousUnselectedItemOf=function(i){var j=this._getUnselectedItems();var k=j.indexOf(i)-1;if(k<0){return null;}return j[k];};
h.prototype._getNextTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());var s=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:s[0];};
h.prototype._getPreviousTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var s=this._getUnselectedItems();if(s.length>0){return s[s.length-1];}else{return null;}}};
h.prototype.findFirstEnabledItem=function(j){j=j||this.getItems();for(var i=0;i<j.length;i++){if(j[i].getEnabled()){return j[i];}}return null;};
h.prototype.getVisibleItems=function(){for(var i=0,o,j=this.getItems(),v=[];i<j.length;i++){o=this.getListItem(j[i]);if(o&&o.getVisible()){v.push(j[i]);}}return v;};
h.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};
h.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!q.isArray(i)){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(o){if(!(o instanceof e)&&(typeof o!=="string")){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof o==="string"){o=sap.ui.getCore().byId(o);}this.setSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",suppressInvalidate:true});},this);return this;};
h.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};
h.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};
h.prototype.removeAllSelectedItems=function(){var i=[];var j=this.getAssociation("selectedItems",[]);j.forEach(function(o){var k=this.removeSelectedItem(o);if(k){i.push(k.getId());}},this);return i;};
h.prototype.removeSelectedKeys=function(k){var i=[],j;if(!k||!k.length||!q.isArray(k)){return i;}var o;k.forEach(function(K){o=this.getItemByKey(K);if(o){this.removeSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",fireChangeEvent:false,suppressInvalidate:true});i.push(o);}if(this._aCustomerKeys.length&&(j=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(j,1);}},this);return i;};
h.prototype.setSelectedKeys=function(k){this.removeAllSelectedItems();this._aCustomerKeys=[];this.addSelectedKeys(k);return this;};
h.prototype.addSelectedKeys=function(k){k=this.validateProperty("selectedKeys",k);k.forEach(function(K){var i=this.getItemByKey(K);if(i){this.addSelectedItem(i);}else if(K!=null){this._aCustomerKeys.push(K);}},this);return this;};
h.prototype.getSelectedKeys=function(){var i=this.getSelectedItems()||[],k=[];i.forEach(function(o){k.push(o.getKey());},this);if(this._aCustomerKeys.length){k=k.concat(this._aCustomerKeys);}return k;};
h.prototype._getUnselectedItems=function(){return q(this.getSelectableItems()).not(this.getSelectedItems()).get();};
h.prototype.getSelectedItems=function(){var i=[],j=this.getAssociation("selectedItems")||[];j.forEach(function(s){var o=sap.ui.getCore().byId(s);if(o){i.push(o);}},this);return i;};
h.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};
h.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
h.prototype.setEditable=function(i){a.prototype.setEditable.apply(this,arguments);this._oTokenizer.setEditable(i);return this;};
h.prototype.clearFilter=function(){this.getItems().forEach(function(i){this.getListItem(i).setVisible(i.getEnabled()&&this.getSelectable(i));},this);};
h.prototype._isListInSuggestMode=function(){return this.getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};
h.prototype._mapItemToListItem=function(i){if(!i){return null;}var s=this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Item";var j=(this.isItemSelected(i))?s+"Selected":"";var o=new sap.m.StandardListItem({type:f.Active,visible:i.getEnabled()}).addStyleClass(s+" "+j);o.setTooltip(i.getTooltip());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem",o);o.setTitle(i.getText());if(j){var t=new sap.m.Token({key:i.getKey()});t.setText(i.getText());t.setTooltip(i.getText());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);}this.setSelectable(i,i.getEnabled());this._decorateListItem(o);return o;};
h.prototype._findMappedItem=function(o,j){for(var i=0,j=j||this.getItems(),k=j.length;i<k;i++){if(this.getListItem(j[i])===o){return j[i];}}return null;};
h.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var o=this.getListItem(i);if(o){o.setVisible(s);}var t=this._getTokenByItem(i);if(t){t.setVisible(s);}};
h.prototype.getSelectable=function(i){return i._bSelectable;};
h.prototype._fillList=function(j){if(!j){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(m){if(m.srcControl.isSelected()){m.setMarked();}}};}for(var i=0,o,k=j.length;i<k;i++){o=this._mapItemToListItem(j[i]);o.removeEventDelegate(this._oListItemEnterEventDelegate);o.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this.getList().addAggregation("items",o,true);if(this.isItemSelected(j[i])){this.getList().setSelectedItem(o,true);}}};
h.prototype._handleInputValidation=function(o,i){var v=o.target.value,j,k,m,r,u,s;var n=i?q(o.target).control(0):o.srcControl;j=this._getItemsStartingText(v,true);k=!!j.length;if(!k&&v!==""){u=i?this._sComposition:(this._sOldValue||"");n.updateDomValue(u);if(this._iOldCursorPos){q(n.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();return;}m=this.getEnabledItems();r=this._sOldInput&&this._sOldInput.length>v.length;if(this.isPickerDialog()){s=this._getFilterSelectedButton();if(s!=null&&s.getPressed()){s.setPressed(false);}}if(r){m=this.getItems();}this.filterItems(m,v);if((!this.getValue()||!k)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}this._sOldInput=v;};
h.prototype.init=function(){C.prototype.init.apply(this,arguments);this.createList();this.bItemsUpdated=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this.setPickerType(D.system.phone?"Dialog":"Dropdown");this._oTokenizer=this._createTokenizer();this._aCustomerKeys=[];this._aInitiallySelectedItems=[];this._bCompositionStart=false;this._bCompositionEnd=false;this._sComposition="";this.attachBrowserEvent("compositionstart",function(){this._bCompositionStart=true;this._bCompositionEnd=false;},this);this.attachBrowserEvent("compositionend",function(o){this._bCompositionStart=false;this._bCompositionEnd=true;this._handleInputValidation(o,true);this._bCompositionEnd=false;this._sComposition=o.target.value;},this);};
h.prototype.clearSelection=function(){this.removeAllSelectedItems();};
h.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().addItem(this._mapItemToListItem(i));}return this;};
h.prototype.insertItem=function(i,j){this.insertAggregation("items",i,j,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().insertItem(this._mapItemToListItem(i),j);}return this;};
h.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};
h.prototype.getItemByKey=function(k){return this.findItem("key",k);};
h.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getList()){this.getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};
h.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};
h.prototype.findItem=function(p,v){var m="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,j=this.getItems();i<j.length;i++){if(j[i][m]()===v){return j[i];}}return null;};
h.prototype._clearTokenizer=function(){this._oTokenizer.destroyAggregation("tokens",true);};
h.prototype.getList=function(){return this._oList;};
h.prototype.exit=function(){a.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null;}};
h.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems();}this._oTokenizer.destroyTokens();return this;};
h.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this.getList()){this.getList().removeAllItems();}return i;};
h.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};
h.prototype._getItemByToken=function(t){return this._getItemBy(t,"Token");};
h.prototype._getItemBy=function(o,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,j=this.getItems(),k=j.length;i<k;i++){if(j[i].data(s)===o){return j[i];}}return null;};
h.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};
h.prototype.getAccessibilityInfo=function(){var t=this.getSelectedItems().map(function(o){return o.getText();}).join(" ");var i=a.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");i.description=((i.description||"")+" "+t).trim();return i;};
return h;});
sap.ui.predefine('sap/m/MultiComboBoxRenderer',['./ComboBoxBaseRenderer','sap/ui/core/Renderer'],function(C,R){"use strict";var M=R.extend(C);M.CSS_CLASS_MULTICOMBOBOX="sapMMultiComboBox";M.DOT_CSS_CLASS_MULTICOMBOBOX=".sapMMultiComboBox";
M.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX);if(c._hasTokens()){r.addClass("sapMMultiComboBoxHasToken");}};
M.writeInnerAttributes=function(r,c){var i=c._oTokenizer&&c._oTokenizer.getTokensInfoId();C.writeInnerAttributes.apply(this,arguments);r.writeAttribute("aria-describedby",i);};
M.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX+"InputInner");};
M.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX+"Arrow");};
M.openInputTag=function(r,c){r.write('<div class="sapMMultiComboBoxBorder"');r.writeAttribute("id",c.getId()+"-border");r.write(">");r.renderControl(c._oTokenizer);r.write("<div class=\"sapMMultiComboBoxInputContainer\">");C.openInputTag.call(this,r,c);};
M.closeInputTag=function(r,c){C.closeInputTag.call(this,r,c);r.write("</div>");r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MultiEditField',["jquery.sap.global","sap/ui/core/XMLComposite","./library","sap/ui/core/Item"],function(q,X,l,I){"use strict";
var M=X.extend("sap.m.MultiEditField",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{selectedItem:{type:"sap.ui.core.Item",group:"Data",defaultValue:null,invalidate:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:true,invalidate:true},nullable:{type:"boolean",group:"Behavior",defaultValue:true,invalidate:true},required:{type:"boolean",group:"Behavior",defaultValue:false,invalidate:true}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,bindable:"bindable"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});
M.prototype.init=function(){if(!M.prototype._oRb){M.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");}this._getKeepAll=q.sap.getter(new I({key:"keep",text:"< "+this._oRb.getText("MULTI_EDIT_KEEP_TEXT")+" >"}));this._getBlank=q.sap.getter(new I({key:"blank",text:"< "+this._oRb.getText("MULTI_EDIT_BLANK_TEXT")+" >"}));this._getValueHelp=q.sap.getter(new I({key:"new",text:"< "+this._oRb.getText("MULTI_EDIT_NEW_TEXT")+" >"}));this.byId("select").getParent=this.getParent.bind(this);this._oLastSelectedItem=this._getKeepAll();};
M.prototype.onBeforeRendering=function(){this.insertAggregation("items",this._getKeepAll(),0,true);if(this.getNullable()){this.insertAggregation("items",this._getBlank(),1,true);}else{this.removeAggregation("items",this._getBlank(),true);}if(this.getShowValueHelp()){this.insertAggregation("items",this._getValueHelp(),this.getNullable()?2:1,true);}else{this.removeAggregation("items",this._getValueHelp(),true);}var s=this.getSelectedItem();if(s){s=this._getInternalItem(s);this.byId("select").setSelectedItem(s);}};
M.prototype.setSelectedItem=function(s){var i=this._getExternalItem(s)||s;var o;if(i&&this.indexOfItem(i)>=0&&!this._isSpecialValueItem(i)){o=this._getInternalItem(s);if(o){this.byId("select").setSelectedItem(o);}this._oLastSelectedItem=i;return this.setProperty("selectedItem",i);}return this;};
M.prototype.exit=function(){this._getKeepAll().destroy();this._getBlank().destroy();this._getValueHelp().destroy();var i=this.byId("itemTemplate");if(i){i.destroy();}};
M.prototype.getFormDoNotAdjustWidth=function(){return true;};
M.prototype.isBlankSelected=function(){return this._getExternalItem(this.byId("select").getSelectedItem())===this._getBlank();};
M.prototype.isKeepExistingSelected=function(){return this._getExternalItem(this.byId("select").getSelectedItem())===this._getKeepAll();};
M.prototype._isSpecialValueItem=function(i){return i===this._getKeepAll()||i===this._getBlank()||i===this._getValueHelp();};
M.prototype._handleSelectionChange=function(e){var i=this._getExternalItem(e.getParameter("selectedItem"));if(i&&!this._isSpecialValueItem(i)){this.fireChange({selectedItem:i});}else if(i===this._getValueHelp()){this.fireEvent("_valueHelpRequest");}if(i!==this._getValueHelp()){this._oLastSelectedItem=i;this.setProperty("selectedItem",i,true);}};
M.prototype.resetSelection=function(){this.byId("select").setSelectedItem(this._getInternalItem(this._oLastSelectedItem));};
M.prototype._getExternalItem=function(i){var a=this.byId("select").indexOfItem(i);if(a>=0){return this.getItems()[a];}return null;};
M.prototype._getInternalItem=function(i){var a=this.indexOfItem(i);if(a>=0){return this.byId("select").getItems()[a];}return null;};
M.prototype._getInternalDomRef=function(){var s=this.byId("select");return s&&s.getDomRef();};
M.prototype._getInternalUIArea=function(){return this.byId("select").getUIArea();};
return M;});
sap.ui.predefine('sap/m/MultiInput',['jquery.sap.global','./Input','./Tokenizer','./Token','./library','sap/ui/core/EnabledPropagator','sap/ui/Device','./MultiInputRenderer','jquery.sap.keycodes'],function(q,I,T,a,l,E,D,M){"use strict";
var b=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiInput.designtime",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}}}});
E.apply(b.prototype,[true]);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
b.prototype.init=function(){I.prototype.init.call(this);this._bIsValidating=false;this._tokenizer=new T();this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.attachTokenChange(this._onTokenChange,this);this._tokenizer.attachTokenUpdate(this._onTokenUpdate,this);this.setShowValueHelp(true);this.setShowSuggestion(true);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(function(){this._bValueHelpOpen=true;},this);};
b.prototype._onTokenChange=function(c){var t=this.getTokens(),L=t.length;this.fireTokenChange(c.getParameters());this.invalidate();if(this._bUseDialog&&this._tokenizer.getParent()instanceof sap.m.Dialog){this._showAllTokens();return;}var f=q.sap.containsOrEquals(this.getDomRef(),document.activeElement);if(c.getParameter("type")==="tokensChanged"&&c.getParameter("removedTokens").length>0&&f){this.focus();}if(c.getParameter("type")==="added"&&L>1&&this.getEditable()&&this._isMultiLineMode&&!this.$("border").hasClass("sapMMultiInputMultiModeBorder")){this._showIndicator();}if(c.getParameter("type")==="removed"&&this._isMultiLineMode){if(L<2){this._removeIndicator();}}};
b.prototype._onTokenUpdate=function(c){var e=this.fireTokenUpdate(c.getParameters());if(!e){c.preventDefault();}else{this.invalidate();}};
b.prototype._onSuggestionItemSelected=function(e){var i=null,t=null,c=this,o=this._tokenizer.getTokens().length;if(this.getMaxTokens()&&o>=this.getMaxTokens()||this._bValueHelpOpen){return;}if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){t=new a({text:i.getText(),key:i.getKey()});}}if(i){var d=this.getValue();this._tokenizer._addValidateToken({text:d,token:t,suggestionObject:i,validationCallback:function(v){if(v){c.setValue("");}}});}if(this._bUseDialog&&this._tokenizer.getParent()instanceof sap.m.Dialog){var n=this._tokenizer.getTokens().length;if(o<n){this.setValue("");}if(this._tokenizer.getVisible()===false){this._tokenizer.setVisible(true);}if(this._oList instanceof sap.m.Table){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else{this._oList.destroyItems();}var s=this._oSuggestionPopup.getScrollDelegate();if(s){s.scrollTo(0,0,0);}this._oPopupInput.focus();}};
b.prototype._onLiveChange=function(e){this._tokenizer._removeSelectedTokens();if(this._bUseDialog&&this._isMultiLineMode){var v=e.getParameter("newValue");if(this._oSuggestionPopup&&this._oSuggestionPopup.getContent().length>1&&v.length>0){this._tokenizer.setVisible(false);}else{this._tokenizer.setVisible(true);}}};
b.prototype._showIndicator=function(){var t=this.getTokens(),i=t.length;this._tokenizer.setVisible(true);if(i>1){if(this.$().find(".sapMMultiInputIndicator").length!==0){this._removeIndicator();}var s="<span class=\"sapMMultiInputIndicator\">"+r.getText("MULTIINPUT_SHOW_MORE_TOKENS",i-1)+"</span>";this.$().find(".sapMMultiInputInputContainer").prepend(s);this._setValueInvisible();this._bShowIndicator=true;}};
b.prototype._setValueInvisible=function(){this.$("inner").css("opacity","0");};
b.prototype._setValueVisible=function(){this.$("inner").css("opacity","1");};
b.prototype._showAllTokens=function(){this._tokenizer.setVisible(true);this._removeIndicator();};
b.prototype._removeIndicator=function(){this.$().find(".sapMMultiInputIndicator").remove();this._bShowIndicator=false;};
b.prototype.setEnableMultiLineMode=function(m){this.setProperty("enableMultiLineMode",m,true);if(m){this.$().addClass("sapMMultiInputMultiLine");}else{this.$().removeClass("sapMMultiInputMultiLine");}this.closeMultiLine();var t=this;if(this._bUseDialog){m=true;}if(m){if(this.getEditable()){this._showIndicator();}this._isMultiLineMode=true;if(this.getDomRef()){setTimeout(function(){t._tokenizer.scrollToEnd();},0);}}else{this._isMultiLineMode=false;this._showAllTokens();this._setValueVisible();if(this.getDomRef()){setTimeout(function(){t._tokenizer.scrollToEnd();},0);}}return this;};
b.prototype._openMultiLineOnPhone=function(){var t=this;if(!this.getEditable()){return;}this._oSuggestionPopup.open();this._oSuggestionPopup.insertContent(this._tokenizer,0);this._tokenizer.setReverseTokens(true);var v=this._oPopupInput.getValue();if(this._oSuggestionPopup&&this._oSuggestionPopup.getContent().length>1&&v.length>0){this._tokenizer.setVisible(false);}else{this._tokenizer.setVisible(true);}this._tokenizer._oScroller.setHorizontal(false);this._tokenizer.addStyleClass("sapMTokenizerMultiLine");if(this._oSuggestionTable.getItems().length===0){this._oPopupInput.onsapenter=function(e){t._validateCurrentText();t._setValueInvisible();};}};
b.prototype.onmousedown=function(e){if(e.target==this.getDomRef('border')){e.preventDefault();e.stopPropagation();}};
b.prototype._openMultiLineOnDesktop=function(){var t=this;this._setValueVisible();this.$("border").addClass("sapMMultiInputMultiModeBorder");if(this._$input){this._$input.parents('.sapMMultiInputBorder').addClass("sapMMultiInputMultiModeInputContainer");}this.$().find(".sapMInputValHelp").attr("tabindex","-1");var p=this.getParent();this._originalOverflow=null;if(p&&p.$&&p.$().css("overflow")==="hidden"){this._originalOverflow=p.$().css("overflow");p.$().css("overflow","visible");}var P;if(this.$().closest('.sapUiVlt').length!==0){P=this.$().closest('.sapUiVlt');}else if(this.$().parent('[class*="sapUiRespGridSpan"]').length!==0){P=this.$().parent('[class*="sapUiRespGridSpan"]');}else if(this.$().parents(".sapUiRFLContainer").length!==0){P=this.$().parents(".sapUiRFLContainer");}if(P&&P.length>0&&P.css("overflow")==="hidden"){P.css("overflow","visible");}t._showAllTokens();t._tokenizer.scrollToStart();};
b.prototype.openMultiLine=function(){var t=this.getTokens();if(!this.getEditable()){return;}if(this.getEnableMultiLineMode()&&t.length>0&&!D.system.phone){this._openMultiLineOnDesktop();}};
b.prototype.closeMultiLine=function(){if(!this.getEditable()){return;}if(this._bUseDialog){this._oSuggestionPopup.close();this._tokenizer.setVisible(true);}else{this.$("border").removeClass("sapMMultiInputMultiModeBorder");if(this._$input){this._$input.parents('.sapMMultiInputBorder').removeClass("sapMMultiInputMultiModeInputContainer");}this.$().find(".sapMInputValHelp").removeAttr("tabindex");if(this._originalOverflow){var p=this.getParent();p.$().css("overflow",this._originalOverflow);}}if(this.getTokens().length>1&&this._isMultiLineMode){this._showIndicator();}};
b.prototype.getScrollDelegate=function(){return this._tokenizer._oScroller;};
b.prototype.onBeforeRendering=function(){var t=this.getAggregation("tokenizer");if(t){t.toggleStyleClass("sapMTokenizerEmpty",t.getTokens().length===0);}I.prototype.onBeforeRendering.apply(this,arguments);};
b.prototype.onAfterRendering=function(){this._tokenizer.scrollToEnd();I.prototype.onAfterRendering.apply(this,arguments);};
b.prototype.addValidator=function(v){this._tokenizer.addValidator(v);};
b.prototype.removeValidator=function(v){this._tokenizer.removeValidator(v);};
b.prototype.removeAllValidators=function(){this._tokenizer.removeAllValidators();};
b.prototype.onsapnext=function(e){if(e.isMarked()){return;}var f=q(document.activeElement).control()[0];if(!f){return;}if(this._tokenizer===f||this._tokenizer.$().find(f.$()).length>0){this._scrollAndFocus();}};
b.prototype.onsapbackspace=function(e){if(this.getCursorPosition()>0||!this.getEditable()||this.getValue().length>0){return;}T.prototype.onsapbackspace.apply(this._tokenizer,arguments);e.preventDefault();e.stopPropagation();};
b.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!this._completeTextIsSelected()){return;}T.prototype.onsapdelete.apply(this._tokenizer,arguments);};
b.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.TAB){this._tokenizer._changeAllTokensSelection(false);}if((e.ctrlKey||e.metaKey)&&e.which===q.sap.KeyCodes.A){if(this._tokenizer.getTokens().length>0){this._tokenizer.focus();this._tokenizer._changeAllTokensSelection(true);e.preventDefault();}}if((e.ctrlKey||e.metaKey)&&(e.which===q.sap.KeyCodes.C||e.which===q.sap.KeyCodes.INSERT)){this._tokenizer._copy();}if(((e.ctrlKey||e.metaKey)&&e.which===q.sap.KeyCodes.X)||(e.shiftKey&&e.which===q.sap.KeyCodes.DELETE)){if(this.getEditable()){this._tokenizer._cut();}else{this._tokenizer._copy();}}};
b.prototype.onpaste=function(e){var o,i,v=[],A=[];if(this.getValueHelpOnly()){return;}if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}var s=this._tokenizer._parseString(o);if(s.length<=1){return;}setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){var c="";for(i=0;i<s.length;i++){if(s[i]){var t=this._convertTextToToken(s[i],true);if(t){v.push(t);}else{c=s[i];}}}this.updateDomValue(c);for(i=0;i<v.length;i++){if(this._tokenizer._addUniqueToken(v[i])){A.push(v[i]);}}if(A.length>0){this.fireTokenUpdate({addedTokens:A,removedTokens:[],type:T.TokenUpdateType.Added});}}if(A.length){this.cancelPendingSuggest();}}}.bind(this),0);};
b.prototype._convertTextToToken=function(t,c){var d=null,i=null,e=null,o=this._tokenizer.getTokens().length;if(!this.getEditable()){return null;}t=t.trim();if(!t){return null;}if(this._getIsSuggestionPopupOpen()||c){if(this._hasTabularSuggestions()){i=this._oSuggestionTable._oSelectedItem;}else{i=this._getSuggestionItem(t);}}if(i&&i.getText&&i.getKey){e=new a({text:i.getText(),key:i.getKey()});}var f=this;d=this._tokenizer._validateToken({text:t,token:e,suggestionObject:i,validationCallback:function(v){f._bIsValidating=false;if(v){f.setValue("");if(f._bUseDialog&&f._isMultiLineMode&&f._oSuggestionTable.getItems().length===0){var n=f._tokenizer.getTokens().length;if(o<n){f._oPopupInput.setValue("");}if(f._tokenizer.getVisible()===false){f._tokenizer.setVisible(true);}f._setAllTokenVisible();}}}});return d;};
b.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this.getCursorPosition()===0){if(e.srcControl===this){T.prototype.onsapprevious.apply(this._tokenizer,arguments);e.preventDefault();}}};
b.prototype._scrollAndFocus=function(){this._tokenizer.scrollToEnd();this.$().find("input").focus();};
b.prototype.onsaphome=function(e){if(this._tokenizer._checkFocus()){T.prototype.onsaphome.apply(this._tokenizer,arguments);}};
b.prototype.onsapend=function(e){if(this._tokenizer._checkFocus()){T.prototype.onsapend.apply(this._tokenizer,arguments);e.preventDefault();}};
b.prototype.onsapenter=function(e){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}var v=true;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){if(this._hasTabularSuggestions()){v=!this._oSuggestionTable.getSelectedItem();}else{v=!this._oList.getSelectedItem();}}if(v){this._validateCurrentText();}this.focus();};
b.prototype._checkFocus=function(){return this.getDomRef()&&q.sap.containsOrEquals(this.getDomRef(),document.activeElement);};
b.prototype.onsapfocusleave=function(e){var p=this._oSuggestionPopup,n=false,N=false,c=this._checkFocus(),R;if(p instanceof sap.m.Popover){if(e.relatedControlId){R=sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef();n=q.sap.containsOrEquals(p.getFocusDomRef(),R);N=q.sap.containsOrEquals(this._tokenizer.getFocusDomRef(),R);}}if(!N&&!n&&!this._isMultiLineMode){this._tokenizer.scrollToEnd();}I.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating||this._bValueHelpOpen){return;}if(!this._bUseDialog&&!n&&e.relatedControlId!==this.getId()&&e.relatedControlId!==this._tokenizer.getId()&&!N&&!(this._isMultiLineMode&&this._bShowIndicator)){this._validateCurrentText(true);}if(!this._bUseDialog&&this._isMultiLineMode&&this.getDomRef("inner").style.opacity=="1"&&this.getEditable()){if(c||n){return;}this.closeMultiLine();this._showIndicator();}T.prototype.onsapfocusleave.apply(this._tokenizer,arguments);if(!this._bUseDialog&&this._isMultiLineMode&&this._bShowIndicator){var $=this.$().find(".sapMMultiInputBorder");$.scrollTop(0);}};
b.prototype._onDialogClose=function(){this._validateCurrentText();this._tokenizer._oScroller.setHorizontal(true);this._tokenizer.removeStyleClass("sapMTokenizerMultiLine");this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.setReverseTokens(false);this._tokenizer.invalidate();};
b.prototype.ontap=function(e){if(document.activeElement===this._$input[0]||document.activeElement===this._tokenizer.getDomRef()){this._tokenizer.selectAllTokens(false);}if(e&&e.isMarked("tokenDeletePress")){return;}I.prototype.ontap.apply(this,arguments);};
b.prototype._onclick=function(e){if(this._bUseDialog){this._openMultiLineOnPhone();}};
b.prototype.onfocusin=function(e){this._bValueHelpOpen=false;if(this.getEditable()&&this.getEnableMultiLineMode()&&(!e.target.classList.contains("sapMInputValHelp")&&!e.target.classList.contains("sapMInputValHelpInner"))){this.openMultiLine();}if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);}};
b.prototype.onsapescape=function(e){this._tokenizer.selectAllTokens(false);this.selectText(0,0);I.prototype.onsapescape.apply(this,arguments);};
b.prototype._validateCurrentText=function(e){var o=this._tokenizer.getTokens().length;var t=this.getValue();if(!t||!this.getEditable()){return;}t=t.trim();if(!t){return;}var i=null;if(e||this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){i=this._oSuggestionTable._oSelectedItem;}else{i=this._getSuggestionItem(t,e);}}var c=null;if(i&&i.getText&&i.getKey){c=new a({text:i.getText(),key:i.getKey()});}var d=this;if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this._tokenizer._addValidateToken({text:t,token:c,suggestionObject:i,validationCallback:function(v){d._bIsValidating=false;if(v){d.setValue("");if(d._bUseDialog&&d._isMultiLineMode&&d._oSuggestionTable.getItems().length===0){var n=d._tokenizer.getTokens().length;if(o<n){d._oPopupInput.setValue("");}if(d._tokenizer.getVisible()===false){d._tokenizer.setVisible(true);}}}}});}};
b.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
b.prototype._completeTextIsSelected=function(){var i=this._$input[0];if(i.selectionStart!==0){return false;}if(i.selectionEnd!==this.getValue().length){return false;}return true;};
b.prototype._getIsSuggestionPopupOpen=function(){return this._oSuggestionPopup&&this._oSuggestionPopup.isOpen();};
b.prototype.setEditable=function(e){e=this.validateProperty("editable",e);if(e===this.getEditable()){return this;}if(e&&(this.getEnableMultiLineMode()||this._bUseDialog)&&this.getTokens().length>1){this._bShowIndicator=true;}else{this._bShowIndicator=false;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}this._tokenizer.setEditable(e);return this;};
b.prototype._findItem=function(t,c,e,g){if(!t){return;}if(!(c&&c.length)){return;}t=t.toLowerCase();var d=c.length;for(var i=0;i<d;i++){var f=c[i];var h=g(f);if(!h){continue;}h=h.toLowerCase();if(h===t){return f;}if(!e&&h.indexOf(t)===0){return f;}}};
b.prototype._getSuggestionItem=function(t,e){var c=null;var d=null;if(this._hasTabularSuggestions()){c=this.getSuggestionRows();d=this._findItem(t,c,e,function(R){var f=R.getCells();var g=null;if(f){var i;for(i=0;i<f.length;i++){if(f[i].getText){g=f[i].getText();break;}}}return g;});}else{c=this.getSuggestionItems();d=this._findItem(t,c,e,function(d){return d.getText();});}return d;};
b.getMetadata().forwardAggregation("tokens",{getter:function(){return this._tokenizer;},aggregation:"tokens",forwardBinding:true});
b.prototype.clone=function(){var c,t;this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);this._tokenizer.detachTokenChange(this._onTokenChange,this);this._tokenizer.detachTokenUpdate(this._onTokenUpdate,this);c=I.prototype.clone.apply(this,arguments);c.destroyAggregation("tokenizer");c._tokenizer=null;t=this._tokenizer.clone();c._tokenizer=t;c.setAggregation("tokenizer",t,true);this._tokenizer.attachTokenChange(this._onTokenChange,this);this._tokenizer.attachTokenUpdate(this._onTokenUpdate,this);c._tokenizer.attachTokenChange(c._onTokenChange,c);c._tokenizer.attachTokenUpdate(c._onTokenUpdate,c);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);return c;};
b.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("border");};
b.prototype.setTokens=function(t){var v,V=[],i;if(Array.isArray(t)){for(i=0;i<t.length;i++){v=this.validateAggregation("tokens",t[i],true);V.push(v);}this._tokenizer.setTokens(V);}else{throw new Error("\""+t+"\" is of type "+typeof t+", expected array for aggregation tokens of "+this);}return this;};
b.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};b.WaitForAsyncValidation="sap.m.Tokenizer.WaitForAsyncValidation";b.prototype.getDomRefForValueStateMessage=b.prototype.getPopupAnchorDomRef;
b.prototype.updateInputField=function(n){I.prototype.updateInputField.call(this,n);this.setDOMValue('');};
b.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};
return b;});
sap.ui.predefine('sap/m/MultiInputRenderer',['./InputRenderer','sap/ui/core/Renderer'],function(I,R){"use strict";var M=R.extend(I);
M.addOuterClasses=function(r,c){I.addOuterClasses.call(this,r,c);r.addClass("sapMMultiInput");if(c.getEnableMultiLineMode()){r.addClass("sapMMultiInputMultiLine");}if(c.getTokens().length>0){r.addClass("sapMMultiInputNoPlaceholder");}};
M.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments),i=c.getAggregation("tokenizer")&&c.getAggregation("tokenizer").getTokensInfoId();if(a){a=a+" "+i;}else{a=i;}return a;};
M.openInputTag=function(r,c){r.write('<div id="'+c.getId()+'-border"');r.addClass('sapMMultiInputBorder');if(c.getTokens().length>0){r.addClass("sapMMultiInputNarrowBorder");}if(c.getEnableMultiLineMode()||c._bUseDialog){c._isMultiLineMode=true;if(c.getEditable()){c._showIndicator();}else{c._showAllTokens();}}r.writeClasses();r.write('>');M._renderTokens(r,c);M._renderInput(r,c);};
M._renderTokens=function(r,c){r.renderControl(c.getAggregation("tokenizer"));};
M._renderInput=function(r,c){r.write("<div class=\"sapMMultiInputInputContainer\">");if(c._isMultiLineMode&&c._bShowIndicator===true){var t=c.getTokens().length;r.write("<span class=\"sapMMultiInputIndicator\">");if(t>1){var m=sap.ui.getCore().getLibraryResourceBundle("sap.m");r.write(m.getText("MULTIINPUT_SHOW_MORE_TOKENS",t-1));}r.write("</span>");}I.openInputTag.call(this,r,c);};
M.writeDecorations=function(r,c){};
M.closeInputTag=function(r,c){I.closeInputTag.call(this,r,c);r.write("</div>");I.writeValueHelpIcon(r,c);r.write("</div>");r.write("<div class=\"sapMMultiInputShadowDiv\"></div>");};
M.addInnerStyles=function(r,c){if(c._isMultiLineMode&&c._bShowIndicator===true&&c.getTokens().length>1){r.addStyle("opacity",0);}};
M.addControlWidth=function(r,c){if(!c.getWidth()||c.getWidth()==="auto"){r.addStyle("width","100%");}else{I.addControlWidth.call(this,r,c);}};
return M;},true);
sap.ui.predefine('sap/m/NavContainer',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/Device','./NavContainerRenderer','jquery.sap.events'],function(q,a,C,R,D,N){"use strict";
var b=C.extend("sap.m.NavContainer",{metadata:{library:"sap.m",properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},visible:{type:"boolean",group:"Appearance",defaultValue:true},defaultTransitionName:{type:"string",group:"Appearance",defaultValue:"slide"}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{initialPage:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
var u=sap.ui.getCore().getConfiguration().getAnimation(),g=function(d){return u?d:0;},h=function(c){return!!(c&&c.getParent());};
b.prototype.init=function(){this._pageStack=[];this._aQueue=[];this._mVisitedPages={};this._mFocusObject={};this._iTransitionsCompleted=0;this._bNeverRendered=true;this._bNavigating=false;this._bRenderingInProgress=false;};
b.prototype.exit=function(){this._mFocusObject=null;};
b.prototype.onBeforeRendering=function(){var p=this.getCurrentPage();if(this._bNeverRendered&&p){var c=p.getId();if(!this._mVisitedPages[c]){this._mVisitedPages[c]=true;var n={from:null,fromId:null,to:p,toId:c,firstTime:true,isTo:false,isBack:false,isBackToPage:false,isBackToTop:false,direction:"initial"};var e=q.Event("BeforeFirstShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);e=q.Event("BeforeShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}}};
b.prototype.onAfterRendering=function(){var p=this.getCurrentPage(),f,n,c,e;if(this._bNeverRendered&&p){this._bNeverRendered=false;delete this._bNeverRendered;c=p.getId();if(!this._isInsideAPopup()&&this.getAutoFocus()){f=b._applyAutoFocusTo(c);if(f){this._mFocusObject[c]=f;}}n={from:null,fromId:null,to:p,toId:c,firstTime:true,isTo:false,isBack:false,isBackToTop:false,isBackToPage:false,direction:"initial"};e=q.Event("AfterShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}};
b.prototype._getActualInitialPage=function(){var p=this.getInitialPage();if(p){var c=sap.ui.getCore().byId(p);if(c){return c;}else{q.sap.log.error("NavContainer: control with ID '"+p+"' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: "+this.getPages().length+").");}}var d=this.getPages();return(d.length>0?d[0]:null);};
b.prototype.getPage=function(p){var P=this.getPages();for(var i=0;i<P.length;i++){if(P[i]&&(P[i].getId()==p)){return P[i];}}return null;};
b.prototype._ensurePageStackInitialized=function(d){if(this._pageStack.length===0){var p=this._getActualInitialPage();if(p){this._pageStack.push({id:p.getId(),isInitial:true,data:d||{}});}}return this._pageStack;};
b.prototype.getCurrentPage=function(){var s=this._ensurePageStackInitialized();if(s.length>=1){return this.getPage(s[s.length-1].id);}else{q.sap.log.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");return undefined;}};
b.prototype.getPreviousPage=function(){var s=this._ensurePageStackInitialized();if(s.length>1){return this.getPage(s[s.length-2].id);}else if(s.length==1){return undefined;}else{q.sap.log.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");}};
b.prototype.currentPageIsTopPage=function(){var s=this._ensurePageStackInitialized();return(s.length===1);};
b.prototype.insertPreviousPage=function(p,t,d){var s=this._ensurePageStackInitialized();if(this._pageStack.length>0){var i=s.length-1;var c={id:p,transition:t,data:d};if(i===0){c.isInitial=true;delete s[s.length-1].isInitial;}s.splice(i,0,c);}else{q.sap.log.warning(this+": insertPreviousPage called with empty page stack; ignoring");}return this;};
b._applyAutoFocusTo=function(i){var f=q.sap.byId(i).firstFocusableDomRef();if(f){q.sap.focus(f);}return f;};
b.prototype._applyAutoFocus=function(n){var p=n.toId,d,A=this.getAutoFocus(),c=n.isBack||n.isBackToPage||n.isBackToTop;if(!n.bFocusInsideFromPage){return;}if(c){d=this._mFocusObject!=null?this._mFocusObject[p]:null;if(d){q.sap.focus(d);}else if(A){b._applyAutoFocusTo(p);}}else if(n.isTo&&A){b._applyAutoFocusTo(p);}};
b.prototype._afterTransitionCallback=function(n,d,B){var e=q.Event("AfterShow",n);e.data=d||{};e.backData=B||{};e.srcControl=this;n.to._handleEvent(e);e=q.Event("AfterHide",n);e.srcControl=this;n.from._handleEvent(e);this._iTransitionsCompleted++;this._bNavigating=false;this._applyAutoFocus(n);this.fireAfterNavigate(n);q.sap.log.info(this+": _afterTransitionCallback called, to: "+n.toId);if(n.to.hasStyleClass("sapMNavItemHidden")){q.sap.log.warning(this.toString()+": target page '"+n.toId+"' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");n.to.removeStyleClass("sapMNavItemHidden");}this._dequeueNavigation();};
b.prototype._dequeueNavigation=function(){var n=this._aQueue.shift();if(typeof n==="function"){n();}};
b.prototype._isInPageStack=function(p){return this._pageStack.some(function(P){return P.id===p;});};
b.prototype._safeBackToPage=function(p,t,d,T){var c;if(!this.getPage(p)){return this;}c=this.getCurrentPage();if(c&&c.getId()===p){return this;}if(this._isInPageStack(p)){return this.backToPage(p,d,T);}else{d=d||{};d.safeBackToPage=true;return this.to(p,t,d,T);}};
b.prototype._isFocusInControl=function(c){return q(document.activeElement).closest(c.$()).length>0;};
b.prototype.to=function(p,t,d,T,f){if(p instanceof C){p=p.getId();}if(typeof(t)!=="string"){T=d;d=t;}t=t||this.getDefaultTransitionName();T=T||{};d=d||{};var F={id:p,transition:t,data:d};this._ensurePageStackInitialized(d);if(this._bNavigating){q.sap.log.info(this.toString()+": Cannot navigate to page "+p+" because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this.to(p,t,d,T,true);},this));return this;}if(this._bNeverRendered){this._oToDataBeforeRendering=d;}var o=this.getCurrentPage();if(o&&(o.getId()===p)){q.sap.log.warning(this.toString()+": Cannot navigate to page "+p+" because this is the current page.");if(f){this._dequeueNavigation();}if(this._pageStack.length===1){this._pageStack[0].transition=F.transition;}return this;}var c=this.getPage(p);if(c){if(!o){q.sap.log.warning("Navigation triggered to page with ID '"+p+"', but the current page is not known/aggregated by "+this);return this;}var n={from:o,fromId:o.getId(),to:c,toId:p,firstTime:!this._mVisitedPages[p],isTo:true,isBack:false,isBackToTop:false,isBackToPage:false,direction:"to",bFocusInsideFromPage:this._isFocusInControl(o)};if(n.bFocusInsideFromPage){this._mFocusObject[o.getId()]=document.activeElement;}var e=this.fireNavigate(n);if(e){a.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;o._handleEvent(E);if(!this._mVisitedPages[p]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.data=d||{};E.backData={};c._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.data=d||{};E.backData={};c._handleEvent(E);this._pageStack.push(F);q.sap.log.info(this.toString()+": navigating to page '"+p+"': "+c.toString());this._mVisitedPages[p]=true;if(!this.getDomRef()){q.sap.log.info("'Hidden' 'to' navigation in not-rendered NavContainer "+this.toString());if(this._bRenderingInProgress){q.sap.delayedCall(0,this,this.invalidate);}return this;}var i;if(!(i=c.getDomRef())||i.parentNode!=this.getDomRef()||R.isPreservedContent(i)){c.addStyleClass("sapMNavItemRendering");q.sap.log.debug("Rendering 'to' page '"+c.toString()+"' for 'to' navigation");var r=sap.ui.getCore().createRenderManager();r.render(c,this.getDomRef());r.destroy();c.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}var j=b.transitions[t]||b.transitions["slide"];var k=this._iTransitionsCompleted;var l=this;window.setTimeout(function(){if(l&&(l._iTransitionsCompleted<k+1)){q.sap.log.warning("Transition '"+t+"' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var s=(d.safeBackToPage||T.safeBackToPage)?"back":"to";j[s].call(this,o,c,q.proxy(function(){this._afterTransitionCallback(n,d);},this),T);}else{q.sap.log.info("Navigation to page with ID '"+p+"' has been aborted by the application");}}else{q.sap.log.warning("Navigation triggered to page with ID '"+p+"', but this page is not known/aggregated by "+this);}return this;};
b.prototype.back=function(c,t){this._backTo("back",c,t);return this;};
b.prototype.backToPage=function(p,c,t){this._backTo("backToPage",c,t,p);return this;};
b.prototype.backToTop=function(c,t){this._backTo("backToTop",c,t);return this;};
b.prototype._backTo=function(t,c,T,r){if(this._bNavigating){q.sap.log.warning(this.toString()+": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this._backTo(t,c,T,r);},this));return this;}if(this._pageStack.length<=1){if(this._pageStack.length===1&&!this._pageStack[0].isInitial){throw new Error("Initial page not found on the stack. How did this happen?");}return this;}else{if(r instanceof C){r=r.getId();}var f=this._pageStack[this._pageStack.length-1];var d=f.transition;var F=this.getPage(f.id);var o;var e;if(t==="backToTop"){o=this._getActualInitialPage();e=null;}else if(t==="backToPage"){var i=this._findClosestPreviousPageInfo(r);if(!i){q.sap.log.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page was not found among the previous pages.");return this;}o=sap.ui.getCore().byId(i.id);if(!o){q.sap.log.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page does not exist anymore.");return this;}e=i.data;}else{o=this.getPreviousPage();e=this._pageStack[this._pageStack.length-2].data;}if(!o){q.sap.log.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");return;}var j=o.getId();c=c||{};T=T||{};var n={from:F,fromId:F.getId(),to:o,toId:j,firstTime:!this._mVisitedPages[j],isTo:false,isBack:(t==="back"),isBackToPage:(t==="backToPage"),isBackToTop:(t==="backToTop"),direction:t,bFocusInsideFromPage:this._isFocusInControl(F)};var k=this.fireNavigate(n);if(k){a.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;F._handleEvent(E);if(!this._mVisitedPages[j]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.backData=c||{};E.data={};o._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.backData=c||{};E.data=e||{};o._handleEvent(E);this._pageStack.pop();q.sap.log.info(this.toString()+": navigating back to page "+o.toString());this._mVisitedPages[j]=true;if(t==="backToTop"){this._pageStack=[];q.sap.log.info(this.toString()+": navigating back to top");this.getCurrentPage();}else if(t==="backToPage"){var p=[],l;while(this._pageStack[this._pageStack.length-1].id!==r){l=this._pageStack.pop();p.push(l.id);}q.sap.log.info(this.toString()+": navigating back to specific page "+o.toString()+" across the pages: "+p.join(", "));}if(!this.getDomRef()){q.sap.log.info("'Hidden' back navigation in not-rendered NavContainer "+this.toString());return this;}var m=b.transitions[d]||b.transitions["slide"];var s=this._iTransitionsCompleted;var v=this;window.setTimeout(function(){if(v&&(v._iTransitionsCompleted<s+1)){q.sap.log.warning("Transition '"+d+"' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var w;if(!(w=o.getDomRef())||w.parentNode!=this.getDomRef()||R.isPreservedContent(w)){o.addStyleClass("sapMNavItemRendering");q.sap.log.debug("Rendering 'to' page '"+o.toString()+"' for back navigation");var x=sap.ui.getCore().createRenderManager();var y=this.$().children().index(F.getDomRef());x.renderControl(o);x.flush(this.getDomRef(),false,y);x.destroy();o.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}if(F.getId()===o.getId()){q.sap.log.info("Transition is skipped when navigating back to the same page instance"+o.toString());this._afterTransitionCallback(n,e,c);return this;}m.back.call(this,F,o,q.proxy(function(){this._afterTransitionCallback(n,e,c);},this),T);}}return this;};
b.prototype._findClosestPreviousPageInfo=function(r){for(var i=this._pageStack.length-2;i>=0;i--){var c=this._pageStack[i];if(c.id===r){return c;}}return null;};
b.transitions=b.transitions||{};b.transitions["show"]={to:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();},back:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();}};if(q.support.cssTransitions){b.transitions["slide"]={to:function(f,t,c){f.addStyleClass("sapMNavItemCenter");window.setTimeout(function(){t.addStyleClass("sapMNavItemRight");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");}if(h(f)){f.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemLeft");}c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemRight");f.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemLeft");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(400));},g(60));},0);},back:function(f,t,c){t.addStyleClass("sapMNavItemLeft");t.removeStyleClass("sapMNavItemHidden");f.addStyleClass("sapMNavItemCenter");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");}if(h(f)){f.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRight");}c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);if(D.browser.webkit){window.setTimeout(function(){t.$().css("box-shadow","0em 1px 0em rgba(128, 128, 1280, 0.1)");window.setTimeout(function(){t.$().css("box-shadow","");},g(50));},0);}t.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemLeft");f.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemRight");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(400));},g(100));}};}else{b.transitions["slide"]={to:function(f,t,c){var T=t.$();T.css("left","100%");t.removeStyleClass("sapMNavItemHidden");T.animate({left:"0%"},g(300));var F=f.$();F.animate({left:"-100%"},g(300),function(){f.addStyleClass("sapMNavItemHidden");F.css("left","0");c();});},back:function(f,t,c){var T=t.$();T.css("left","-100%");t.removeStyleClass("sapMNavItemHidden");T.animate({left:"0%"},g(300));var F=f.$();F.animate({left:"100%"},g(300),function(){f.addStyleClass("sapMNavItemHidden");F.css("left","0");c();});}};}if(q.support.cssTransitions){b.transitions["fade"]={to:function(f,t,c){t.addStyleClass("sapMNavItemTransparent");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var A=null;var T=true;A=function(){q(this).unbind("webkitTransitionEnd transitionend");T=false;if(h(f)){f.addStyleClass("sapMNavItemHidden");}if(h(t)){t.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");}c();};t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){if(T){A.apply(t.$());}},g(600));},g(10));},back:function(f,t,c){f.addStyleClass("sapMNavItemOpaque");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var A=null;var T=true;A=function(){q(this).unbind("webkitTransitionEnd transitionend");T=false;if(h(f)){f.removeStyleClass("sapMNavItemFading").addStyleClass("sapMNavItemHidden");f.removeStyleClass("sapMNavItemTransparent");}c();};f.$().bind("webkitTransitionEnd transitionend",A);f.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");f.addStyleClass("sapMNavItemTransparent");window.setTimeout(function(){if(T){A.apply(t.$());}},g(600));},g(10));}};}else{b.transitions["fade"]={to:function(f,t,c){var T=t.$();T.css("opacity","0");t.removeStyleClass("sapMNavItemHidden");T.animate({opacity:"1"},g(500),function(){f.addStyleClass("sapMNavItemHidden");c();});},back:function(f,t,c){var F=f.$();t.removeStyleClass("sapMNavItemHidden");F.animate({opacity:"0"},g(500),function(){f.addStyleClass("sapMNavItemHidden");F.css("opacity","1");c();});}};}if(q.support.cssTransitions){b.transitions["flip"]={to:function(f,t,c){var d=this;window.setTimeout(function(){d.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemFlipping");}if(h(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious");}d.$().removeClass("sapMNavFlip");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));},0);},back:function(f,t,c){var d=this;d.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipPrevious");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemFlipping");}if(h(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext");}d.$().removeClass("sapMNavFlip");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));}};}else{b.transitions["flip"]=b.transitions["slide"];}if(q.support.cssTransitions){b.transitions["door"]={to:function(f,t,c){var d=this;window.setTimeout(function(){d.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorInNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext");}if(h(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious");}d.$().removeClass("sapMNavDoor");c();}};f.$().bind("webkitAnimationEnd animationend",A);t.$().bind("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));},0);},back:function(f,t,c){var d=this;d.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorOutNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext");}if(h(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious");}d.$().removeClass("sapMNavDoor");c();}};f.$().bind("webkitAnimationEnd animationend",A);t.$().bind("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));}};}else{b.transitions["door"]=b.transitions["slide"];}
b.prototype.addCustomTransition=function(n,t,B){if(b.transitions[n]){q.sap.log.warning("Transition with name "+n+" already exists in "+this+". It is now being replaced by custom transition.");}b.transitions[n]={to:t,back:B};return this;};
b.addCustomTransition=b.prototype.addCustomTransition;b.prototype.forceInvalidation=b.prototype.invalidate;
b.prototype.invalidate=function(s){if(s==this){}else if(!s){this.forceInvalidation();}else if(s instanceof C){var I=false,p=this.getPages(),l=p.length;for(var i=0;i<l;i++){if(p[i]===s){I=true;break;}}if((!I||s===this.getCurrentPage())&&!this._isInsideAPopup()){this.forceInvalidation();}}else{this.forceInvalidation();}};
b.prototype._isInsideAPopup=function(){var s;s=function(c){if(!c){return false;}if(c.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return s(c.getParent());};return s(this);};
b.prototype.removePage=function(p){p=this.removeAggregation("pages",p,p!==this.getCurrentPage());this._onPageRemoved(p);return p;};
b.prototype._onPageRemoved=function(p){if(!p){return;}p.$().remove();p.removeStyleClass("sapMNavItemHidden");p.removeStyleClass("sapMNavItem");var s=this._ensurePageStackInitialized();this._pageStack=s.filter(function(P){return p.getId()!==P.id;});};
b.prototype.removeAllPages=function(){var p=this.getPages();if(!p){return[];}for(var i=0;i<p.length;i++){this._onPageRemoved(p[i]);}return this.removeAllAggregation("pages");};
b.prototype.addPage=function(p){var P=this.getPages();if(q.inArray(p,P)>-1){return this;}this.addAggregation("pages",p,true);p.addStyleClass("sapMNavItem");var i=P.length;if(i===0&&this.getPages().length===1&&this.getDomRef()){this._ensurePageStackInitialized();this.rerender();this._fireAdaptableContentChange(p);}return this;};
b.prototype.insertPage=function(p,i){var P=this.getPages().length;this.insertAggregation("pages",p,i,true);p.addStyleClass("sapMNavItem");if(P===0&&this.getPages().length===1&&this.getDomRef()){this._ensurePageStackInitialized();this.rerender();this._fireAdaptableContentChange(p);}return this;};
b.prototype._getAdaptableContent=function(){return this.getCurrentPage();};
b.prototype._fireAdaptableContentChange=function(p){if(p&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":p});}};
return b;});
sap.ui.predefine('sap/m/NavContainerRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){c._bRenderingInProgress=true;if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);r.addClass("sapMNav");if(c.getWidth()){r.addStyle("width",c.getWidth());}var h=c.getHeight();if(h&&h!="100%"){r.addStyle("height",h);}if(this.renderAttributes){this.renderAttributes(r,c);}r.writeClasses();r.writeStyles();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");if(this.renderBeforeContent){this.renderBeforeContent(r,c);}var C=c.getCurrentPage();if(C){C.removeStyleClass("sapMNavItemHidden");r.renderControl(C);}r.write("</div>");c._bRenderingInProgress=false;};
return N;},true);
sap.ui.predefine('sap/m/NewsContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/Device','./NewsContentRenderer','jquery.sap.keycodes'],function(q,l,C,T,D,N){"use strict";
var a=C.extend("sap.m.NewsContent",{metadata:{library:"sap.m",designtime:"sap/m/designtime/NewsContent.designtime",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"_contentText",aggregations:{"_contentText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
a.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentText",this._oContentText,true);this.setTooltip("{AltText}");};
a.prototype.onBeforeRendering=function(){this._setPointerOnContentText();this.$().unbind("mouseenter",this._addTooltip);this.$().unbind("mouseleave",this._removeTooltip);};
a.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));};
a.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
a.prototype._removeTooltip=function(){this.$().attr("title",null);};
a.prototype._setPointerOnContentText=function(){var t=this.getAggregation("_contentText");if(t&&this.hasListeners("press")){t.addStyleClass("sapMPointer");}else if(t&&t.hasStyleClass("sapMPointer")){t.removeStyleClass("sapMPointer");}};
a.prototype.getAltText=function(){var A="";var i=true;if(this.getAggregation("_contentText").getText()){A+=this.getAggregation("_contentText").getText();i=false;}if(this.getSubheader()){if(i){A+=""+this.getSubheader();}else{A+="\n"+this.getSubheader();}}return A;};
a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
a.prototype.setContentText=function(t){this._oContentText.setText(t);return this.setProperty("contentText",t,true);};
a.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
a.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
a.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnContentText();}return this;};
a.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnContentText();}return this;};
return a;});
sap.ui.predefine('sap/m/NewsContentRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){var s=c.getSubheader();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttribute("id",c.getId()+"-news-content");r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",t);r.addClass("sapMNwC");if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNwCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMNwCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/m/NotificationListBase',['./library','sap/ui/core/Control','./ListItemBase','./Text','./Image','./OverflowToolbar','sap/ui/core/Icon','sap/ui/core/library','sap/ui/core/Element'],function(l,C,L,T,I,O,a,c,E){'use strict';var P=c.Priority;
var N=L.extend('sap.m.NotificationListBase',{metadata:{library:'sap.m',properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:P.None},title:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance',defaultValue:''},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI',multiple:false}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_headerTitle:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_dateTime:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_authorName:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_authorImage:{type:'sap.ui.core.Control',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"},_collapseButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"}},events:{close:{}}}});
N.prototype.init=function(){this.setAggregation('_overflowToolbar',new O());};
N.prototype.setTitle=function(t){var r=this.setProperty('title',t);this._getHeaderTitle().setText(t);return r;};
N.prototype.setDatetime=function(d){var r=this.setProperty('datetime',d);this._getDateTimeText().setText(d);return r;};
N.prototype.setAuthorName=function(b){var r=this.setProperty('authorName',b);this._getAuthorName().setText(b);return r;};
N.prototype.clone=function(){var b=C.prototype.clone.apply(this,arguments);var o=this.getAggregation('_overflowToolbar');b.setAggregation("_overflowToolbar",o.clone(),true);return b;};
N.prototype.close=function(){var p=this.getParent();this.fireClose();if(p&&p instanceof E){var d={onAfterRendering:function(){p.focus();p.removeEventDelegate(d);}};p.addEventDelegate(d);}};
N.getMetadata().forwardAggregation("buttons",{getter:function(){return this.getAggregation('_overflowToolbar');},aggregation:"content",forwardBinding:true});
N.prototype._getHeaderTitle=function(){var t=this.getAggregation("_headerTitle");if(!t){t=new T({id:this.getId()+'-title',text:this.getTitle(),maxLines:2});this.setAggregation("_headerTitle",t,true);}return t;};
N.prototype._getDateTimeText=function(){var d=this.getAggregation('_dateTime');if(!d){d=new T({id:this.getId()+'-datetime',text:this.getDatetime()}).addStyleClass('sapMNLI-Datetime');this.setAggregation('_dateTime',d,true);}return d;};
N.prototype._getAuthorName=function(){var b=this.getAggregation('_authorName');if(!b){b=new T({text:this.getAuthorName()}).addStyleClass('sapMNLI-Text');this.setAggregation('_authorName',b,true);}return b;};
N.prototype._getAuthorImage=function(){var b=this.getAggregation('_authorImage');if(!b){var d=this.getAuthorPicture();var e=this.getAuthorName();if(i(d)){b=new a({src:d,alt:e});}else{b=new I({src:d,alt:e});}this.setAggregation('_authorImage',b,true);}return b;};
N.prototype._getToolbar=function(){var t=this.getAggregation("_overflowToolbar");if(!t){t=new O();this.setAggregation("_overflowToolbar",t,true);}return t;};
function i(s){if(!s){return false;}var r=window.URI.parse(s);return(r.protocol&&r.protocol=='sap-icon');}
return N;});
sap.ui.predefine('sap/m/NotificationListGroup',['jquery.sap.global','./library','./NotificationListBase','sap/ui/core/InvisibleText','./ListItemBase','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/m/Button','./NotificationListGroupRenderer','jquery.sap.keycodes'],function(q,l,N,I,L,a,c,D,B,b){'use strict';var P=c.Priority;var d=l.ButtonType;
var e=N.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true},showEmptyGroup:{type:'boolean',group:'Behavior',defaultValue:false},enableCollapseButtonWhenEmpty:{type:'boolean',group:'Behavior',defaultValue:false}},defaultAggregation:'items',aggregations:{items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'},_ariaDetailsText:{type:'sap.ui.core.InvisibleText',multiple:false,visibility:'hidden'}},events:{onCollapse:{parameters:{collapsed:{type:'boolean'}}}}}});
e.prototype.init=function(){N.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');var _=new B(this.getId()+'-closeButton',{type:d.Transparent,icon:a.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',_,true);var g=new B({type:d.Transparent,press:function(){this.setCollapsed(!this.getCollapsed());}.bind(this)});this.setAggregation('_collapseButton',g,true);this._maxNumberReached=false;this._ariaLabbeledByIds='';this.setAggregation('_ariaDetailsText',new I());this._resourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');};
e.prototype.setCollapsed=function(g){this._toggleCollapsed();this.setProperty('collapsed',g,true);this.fireOnCollapse({collapsed:g});return this;};
e.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=P.None;if(n){n.forEach(function(i){p=f(p,i.getPriority());});}else{p=this.getProperty('priority');}return p;};
e.prototype.getUnread=function(){var n=this.getItems();if(n.length){return n.some(function(i){return i.getUnread();});}return this.getProperty('unread');};
e.prototype.onBeforeRendering=function(){var n=this.getItems();var g=n.length;var h=this.getAggregation('_collapseButton');this._maxNumberOfNotifications=D.system.desktop?400:100;h.setEnabled(this._getCollapseButtonEnabled(),true);this._maxNumberReached=g>this._maxNumberOfNotifications;n.forEach(function(i){i.addEventDelegate({onfocusin:this._notificationFocusHandler},this);i.addEventDelegate({onkeydown:this._notificationNavigationHandler},this);}.bind(this));this._updateAccessibilityInfo();this._updateCollapseButtonText(this.getCollapsed());this._maxNumberOfNotificationsTitle=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_TITLE',g-this._maxNumberOfNotifications);this._maxNumberOfNotificationsBody=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_BODY');};
e.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};
e.prototype._getHeaderTitle=function(){var t=N.prototype._getHeaderTitle.call(this);t.addStyleClass('sapMNLG-Title');if(this.getUnread()){t.addStyleClass('sapMNLGTitleUnread');}return t;};
e.prototype._getDateTimeText=function(){var g=N.prototype._getDateTimeText.call(this);g.setTextAlign('End');return g;};
e.prototype._toggleCollapsed=function(){var n=!this.getCollapsed();this._updateCollapseButtonText(n);this.$().toggleClass('sapMNLG-Collapsed',n);this.$().toggleClass('sapMNLG-NoNotifications',this._getVisibleItemsCount()<=0);};
e.prototype._getVisibleItemsCount=function(){var i=this.getItems();var r=0;i.forEach(function(g){if(g.getVisible()){r+=1;}});return r;};
e.prototype._getCollapseButtonEnabled=function(){if(this._getVisibleItemsCount()>0){return true;}return this.getEnableCollapseButtonWhenEmpty();};
e.prototype._notificationFocusHandler=function(g){L.prototype.onfocusin.call(this,g);var t=g.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var h=n.indexOfItem(t);var i=t.getDomRef();i.setAttribute('aria-posinset',h+1);i.setAttribute('aria-setsize',n.getItems().length);};
e.prototype._notificationNavigationHandler=function(g){L.prototype.onkeydown.call(this,g);var t=g.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var h=n.indexOfItem(t);switch(g.which){case q.sap.KeyCodes.ARROW_UP:if(h==0){return;}var p=h-1;n.getItems()[p].focus();break;case q.sap.KeyCodes.ARROW_DOWN:var i=h+1;if(i==n.getItems().length){return;}n.getItems()[i].focus();break;default:return;}};
e.prototype._updateAccessibilityInfo=function(){var g=this.getAuthorName();var i=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var u=this.getUnread()?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_UNREAD'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_READ');var h='';var j=this.getAggregation('_ariaDetailsText');if(g){h+=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+g+' ';}h+=i+' '+u;j.setText(h);this._ariaLabbeledByIds=this._getHeaderTitle().getId()+' '+j.getId();};
e.prototype._updateCollapseButtonText=function(g){var h=g?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_EXPAND'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this.getAggregation('_collapseButton').setText(h,true);};
function f(g,s){if(g==s){return g;}if((g=='None')){return s;}if((g=='Low')&&(s!='None')){return s;}if((g=='Medium')&&(s!='None'&&s!='Low')){return s;}return g;}
return e;});
sap.ui.predefine('sap/m/NotificationListGroupRenderer',["sap/ui/core/library"],function(c){'use strict';var P=c.Priority;var N={};var a='sapMNLG';var b='sapMNLB';var d='sapMLIB';var e='sapMNLB-AuthorPicture';var f='sapMNLB-Header';var g='sapMNLG-Header';var h='sapMNLG-Body';var i='sapMNLB-SubHeader';var j='sapMNLG-SubHeader';var k='sapMNLB-CloseButton';var l='sapMNLB-Priority';var m='sapMNLG-Details';var n='sapMNLB-Bullet';var o='sapMNLG-Description';var p='sapMNLG-Collapsed';var q='sapMNLGNoHdrFooter';var r='sapMNLG-MaxNotifications';var s='sapMNLG-NoNotifications';
N.render=function(R,C){if(C.getVisible()){var v=C._getVisibleItemsCount();var _=C.getShowEmptyGroup()||(v>0);R.write('<li');R.addClass(a);R.addClass(b);R.addClass(d);if(!_){R.addClass(q);}if(C.getCollapsed()){R.addClass(p);}if(v==0){R.addClass(s);}R.writeClasses();R.writeControlData(C);R.writeAttribute('tabindex','0');R.writeAccessibilityState(C,{labelledby:C._ariaLabbeledByIds});R.write('>');if(_){this.renderHeader(R,C);this.renderSubHeader(R,C);this.renderBody(R,C);}R.write('</li>');}else{this.renderInvisibleItem(R,C);}};
N.renderHeader=function(R,C){R.write('<div');R.addClass(f);R.addClass(g);R.writeClasses();R.write('>');this.renderInvisibleInfoText(R,C);this.renderPriorityArea(R,C);this.renderCloseButton(R,C);this.renderTitle(R,C);this.renderDetails(R,C);R.write('</div>');};
N.renderTitle=function(R,C){R.renderControl(C._getHeaderTitle());};
N.renderCloseButton=function(R,C){if(C.getShowCloseButton()){R.renderControl(C.getAggregation('_closeButton').addStyleClass(k));}};
N.renderAuthorPicture=function(R,C){if(!C.getAuthorPicture()){return;}R.write('<div');R.addClass(e);R.writeClasses();R.write('>');R.renderControl(C._getAuthorImage());R.write('</div>');};
N.renderDetails=function(R,C){R.write('<div class="'+m+'">');this.renderAuthorPicture(R,C);R.write('<div class="'+o+'">');this.renderAuthorName(R,C);if(C.getAuthorName()!=""&&C.getDatetime()!=""){R.write('<span class="'+n+'">&#x00B7</span>');}this.renderDatetime(R,C);R.write('</div></div>');};
N.renderInvisibleInfoText=function(R,C){R.renderControl(C.getAggregation('_ariaDetailsText'));};
N.renderAuthorName=function(R,C){R.renderControl(C._getAuthorName());};
N.renderSubHeader=function(R,C){var t=C.getButtons();R.write('<div');R.addClass(j);R.addClass(i);R.writeClasses();R.write('>');this.renderPriorityArea(R,C);this.renderCollapseGroupButton(R,C);if(t&&t.length&&C.getShowButtons()){R.renderControl(C.getAggregation('_overflowToolbar'));}R.write('</div>');};
N.renderPriorityArea=function(R,C){R.write('<div');var t='';var u=C.getPriority();switch(u){case(P.Low):t='sapMNLB-Low';break;case(P.Medium):t='sapMNLB-Medium';break;case(P.High):t='sapMNLB-High';break;default:t='sapMNLB-None';break;}R.addClass(l);R.addClass(t);R.writeClasses();R.write('>');R.write('</div>');};
N.renderCollapseGroupButton=function(R,C){R.renderControl(C.getAggregation('_collapseButton'));};
N.renderInvisibleItem=function(R,C){R.write("<li");R.writeInvisiblePlaceholderData(C);R.write(">");R.write("</li>");};
N.renderBody=function(R,C){R.write('<ul class='+h+'>');this.renderNotifications(R,C);if(C._maxNumberReached){this.renderMaxNumberReachedMessage(R,C);}R.write('</ul>');};
N.renderDatetime=function(R,C){R.renderControl(C._getDateTimeText());};
N.renderNotifications=function(R,C){var t=C.getItems();var u=t.length;if(u){for(var v=0;v<C._maxNumberOfNotifications;v++){R.renderControl(t[v]);}}};
N.renderMaxNumberReachedMessage=function(R,C){var t='<span>'+C._maxNumberOfNotificationsTitle+'</span> <br>'+C._maxNumberOfNotificationsBody;R.write('<div');R.addClass(r);R.writeClasses();R.write('>');R.write(t);R.write('</div>');};
return N;},true);
sap.ui.predefine('sap/m/NotificationListItem',['./library','./NotificationListBase','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ResizeHandler','sap/m/Button','./NotificationListItemRenderer'],function(l,N,I,a,R,B,b){'use strict';var c=l.ButtonType;
var d=N.extend('sap.m.NotificationListItem',{metadata:{library:'sap.m',properties:{description:{type:'string',group:'Appearance',defaultValue:''},truncate:{type:'boolean',group:'Appearance',defaultValue:true},hideShowMoreButton:{type:'boolean',group:'Appearance',defaultValue:false}},aggregations:{processingMessage:{type:'sap.m.MessageStrip',multiple:false},_bodyText:{type:'sap.m.Text',multiple:false,visibility:"hidden"}}}});
d.prototype.init=function(){N.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._expandText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_MORE');this._collapseText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_LESS');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');this.setType('Active');var _=new B(this.getId()+'-closeButton',{type:c.Transparent,icon:a.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation("_closeButton",_,true);var e=new B({type:c.Transparent,text:this.getTruncate()?this._expandText:this._collapseText,id:this.getId()+'-expandCollapseButton',press:function(){this._deregisterResize();this.setProperty("truncate",!this.getTruncate(),true);e.setText(this.getTruncate()?this._expandText:this._collapseText);this.$().find('.sapMNLI-Header').toggleClass('sapMNLI-TitleWrapper--is-expanded');this.$().find('.sapMNLI-TextWrapper').toggleClass('sapMNLI-TextWrapper--is-expanded',this.getDescription());this._registerResize();}.bind(this)});this.setAggregation("_collapseButton",e,true);this._ariaDetailsText=new I({id:this.getId()+'-info'}).toStatic();};
d.prototype.setDescription=function(e){var r=this.setProperty('description',e);this._getDescriptionText().setText(e);return r;};
d.prototype.setDatetime=function(e){var r=N.prototype.setDatetime.call(this,e);this._updateAriaAdditionalInfo();return r;};
d.prototype.setUnread=function(u){var r=this.setProperty('unread',u,true);var t=this.getAggregation('_headerTitle');if(t){t.toggleStyleClass('sapMNLI-Unread',this.getUnread());}return r;};
d.prototype.setPriority=function(p,s){var r=this.setProperty('priority',p,s);this._updateAriaAdditionalInfo();return r;};
d.prototype.setAuthorPicture=function(e,s){var r=this.setProperty('authorPicture',e,s);this._getAuthorImage().setSrc(e);return r;};
d.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};
d.prototype.onBeforeRendering=function(){this._updateAriaAdditionalInfo();this._deregisterResize();};
d.prototype.onAfterRendering=function(){this._registerResize();};
d.prototype.exit=function(){this._deregisterResize();if(this._ariaDetailsText){this._ariaDetailsText.destroy();this._ariaDetailsText=null;}};
d.prototype._getDescriptionText=function(){var e=this.getAggregation('_bodyText');if(!e){e=new sap.m.Text({id:this.getId()+'-body',text:this.getDescription(),maxLines:2}).addStyleClass('sapMNLI-Text');this.setAggregation("_bodyText",e,true);}return e;};
d.prototype._activeHandling=function(){this.$().toggleClass("sapMNLIActive",this._active);};
d.prototype._updateAriaAdditionalInfo=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var e=this.getUnread()?r.getText('NOTIFICATION_LIST_ITEM_UNREAD'):r.getText('NOTIFICATION_LIST_ITEM_READ');var f=r.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var g=this.getAuthorName();var h=e+' ';if(g){h+=r.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+this.getAuthorName()+' ';}h+=f;this._ariaDetailsText.setText(h);};
d.prototype._canTruncate=function(){var t=this.getDomRef('title').offsetHeight;var e=this.getDomRef('title').parentElement.offsetHeight;var f;var g;if(this._getDescriptionText().getText()){f=this.getDomRef("body").offsetHeight;g=this.getDomRef("body").parentElement.offsetHeight;}return f>g||t>e;};
d.prototype._showHideTruncateButton=function(){var n=this.getDomRef();if(this._canTruncate()&&(!this.getHideShowMoreButton())){this.getDomRef('expandCollapseButton').classList.remove('sapMNLI-CollapseButtonHide');if(this.getTruncate()){this.getAggregation('_collapseButton').setText(this._expandText);n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');if(this.getDescription()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');}}else{this.getAggregation('_collapseButton').setText(this._collapseText);this.$().find('.sapMNLI-TextWrapper').toggleClass('sapMNLI-TextWrapper--is-expanded',this.getDescription());n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--is-expanded');}}else{this.getDomRef('expandCollapseButton').classList.add('sapMNLI-CollapseButtonHide');}if(this.getDescription()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--initial-overwrite');}if(this.getTitle()){n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--initial-overwrite');}};
d.prototype._deregisterResize=function(){if(this._sNotificationResizeHandler){R.deregister(this._sNotificationResizeHandler);this._sNotificationResizeHandler=null;}};
d.prototype._registerResize=function(){var t=this;var n=this.getDomRef();if(!n){return;}t._resizeNotification();this._sNotificationResizeHandler=R.register(n,function(){t._resizeNotification();});};
d.prototype._resizeNotification=function(){var n=this.getDomRef();var e=sap.ui.getCore();if(n.offsetWidth>=640){n.classList.add('sapMNLI-LSize');}else{n.classList.remove('sapMNLI-LSize');}if(this._getDescriptionText().getText()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');n.querySelector('.sapMNLI-TextWrapper').classList.add('sapMNLI-TextWrapper--initial-overwrite');}n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--initial-overwrite');if(e.isThemeApplied()){this._showHideTruncateButton();}else{e.attachThemeChanged(this._showHideTruncateButton,this);}};
return d;});
sap.ui.predefine('sap/m/NotificationListItemRenderer',["sap/ui/core/library"],function(c){'use strict';var P=c.Priority;var N={};var a='sapMNLI';var b='sapMNLB';var d='sapMNLI-TextWrapper';var e='sapMLIB';var f='sapMNLB-AuthorPicture';var g='sapMNLB-Priority';var h='sapMNLB-Header';var i='sapMNLI-Header';var j='sapMNLI-Body';var k='sapMNLI-Description';var l='sapMNLI-Details';var m='sapMNLB-Bullet';var n='sapMNLB-Footer';var o='sapMNLI-Footer';var p='sapMNLI-No-Footer';var q='sapMNLB-CloseButton';var r='sapMNLI-CollapseButton';var s='sapMNLI-TitleWrapper--initial-overwrite';var t='sapMNLI-TextWrapper--initial-overwrite';
N.render=function(R,C){if(C.getVisible()){var v=C.getId();var w=(v+'-title')+' '+(v+'-body')+' '+(v+'-info');R.write('<li');R.addClass(a);R.addClass(b);R.addClass(e);R.writeControlData(C);R.writeAttribute('tabindex','0');R.writeAccessibilityState(C,{role:"listitem",labelledby:w});R.writeClasses();R.write('>');this.renderPriorityArea(R,C);this.renderMessageStrip(R,C);this.renderHeader(R,C);this.renderBody(R,C);this.renderFooter(R,C);R.write('</li>');}else{this.renderInvisibleItem(R,C);}};
N.renderPriorityArea=function(R,C){R.write('<div');var v='';switch(C.getPriority()){case(P.Low):v='sapMNLB-Low';break;case(P.Medium):v='sapMNLB-Medium';break;case(P.High):v='sapMNLB-High';break;default:v='sapMNLB-None';break;}R.addClass(g);R.addClass(v);R.writeClasses();R.write('>');R.write('</div>');};
N.renderMessageStrip=function(R,C){R.renderControl(C.getProcessingMessage());};
N.renderAuthorPicture=function(R,C){if(!C.getAuthorPicture()){return;}R.write('<div');R.addClass(f);R.writeClasses();R.write('>');R.renderControl(C._getAuthorImage());R.write('</div>');};
N.renderCloseButton=function(R,C){if(C.getShowCloseButton()){R.renderControl(C.getAggregation('_closeButton').addStyleClass(q));}};
N.renderCollapseButton=function(R,C){R.renderControl(C.getAggregation('_collapseButton').addStyleClass(r));};
N.renderHeader=function(R,C){R.write('<div');R.addClass(h);R.addClass(i);R.addClass(s);if(u(C)){R.addClass(p);}R.writeClasses();R.write('>');this.renderCloseButton(R,C);this.renderTitle(R,C);R.write('</div>');};
N.renderTitle=function(R,C){R.renderControl(C._getHeaderTitle());};
N.renderBody=function(R,C){if(!C._getDescriptionText().getText()&&!C.getAuthorName()&&!C.getDatetime()&&!C.getAuthorPicture()){return;}R.write('<div');R.addClass(j);if(u(C)){R.addClass(p);}R.writeClasses();R.write('>');this.renderAuthorPicture(R,C);R.write('<div class='+k+'>');this.renderDescription(R,C);this.renderDetails(R,C);R.write('</div>');this.renderAriaText(R,C);R.write('</div>');};
N.renderDescription=function(R,C){if(!C._getDescriptionText().getText()){return;}R.write('<div');R.addClass(d);R.addClass(t);R.writeClasses();R.write('>');R.renderControl(C._getDescriptionText());R.write('</div>');};
N.renderDetails=function(R,C){if(!C.getAuthorName()&&!C.getDatetime()){return;}R.write('<div class="'+l+'">');this.renderAuthorName(R,C);if(C.getAuthorName()){R.write('<span class="'+m+'">&#x00B7</span>');}this.renderDatetime(R,C);R.write('</div>');};
N.renderDatetime=function(R,C){R.renderControl(C._getDateTimeText());};
N.renderAuthorName=function(R,C){R.renderControl(C._getAuthorName());};
N.renderAriaText=function(R,C){R.renderControl(C._ariaDetailsText);};
N.renderFooter=function(R,C){var B=C.getButtons();R.write('<div');R.addClass(o);R.addClass(n);R.writeClasses();R.write('>');this.renderCollapseButton(R,C);if(B&&B.length&&C.getShowButtons()){R.renderControl(C.getAggregation('_overflowToolbar'));}R.write('</div>');};
N.renderInvisibleItem=function(R,C){R.write("<li");R.writeInvisiblePlaceholderData(C);R.write(">");R.write("</li>");};
function u(C){return C.getHideShowMoreButton()&&(!C.getShowButtons()||!C.getButtons());}
return N;},true);
sap.ui.predefine('sap/m/NumericContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/Image','./NumericContentRenderer','jquery.sap.keycodes'],function(q,l,C,I,a,N){"use strict";
var b=C.extend("sap.m.NumericContent",{metadata:{library:"sap.m",properties:{"animateTextChange":{type:"boolean",group:"Behavior",defaultValue:true},"formatterValue":{type:"boolean",group:"Data",defaultValue:false},"icon":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"iconDescription":{type:"string",group:"Accessibility",defaultValue:null},"indicator":{type:"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},"nullifyValue":{type:"boolean",group:"Behavior",defaultValue:true},"scale":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Appearance",defaultValue:"Auto"},"truncateValueTo":{type:"int",group:"Appearance",defaultValue:4},"value":{type:"string",group:"Data",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},"width":{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},"withMargin":{type:"boolean",group:"Appearance",defaultValue:true},"state":{type:"sap.m.LoadState",group:"Behavior",defaultValue:"Loaded"}},events:{"press":{}}}});
b.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setTooltip("{AltText}");};
b.prototype.onBeforeRendering=function(){this.$().unbind("mouseenter",this._addTooltip);this.$().unbind("mouseleave",this._removeTooltip);};
b.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));if(l.LoadState.Loaded==this.getState()||this.getAnimateTextChange()){q.sap.byId(this.getId()).animate({opacity:"1"},1000);}};
b.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
b.prototype._removeTooltip=function(){this.$().attr("title",null);};
b.prototype.exit=function(){if(this._oIcon){this._oIcon.destroy();}};
b.prototype.getAltText=function(){var v=this.getValue();var s=this.getScale();var e;var m=this._rb.getText(("SEMANTIC_COLOR_"+this.getValueColor()).toUpperCase());var A="";if(this.getNullifyValue()){e="0";}else{e="";}if(this.getIconDescription()){A=A.concat(this.getIconDescription());A=A.concat("\n");}if(v){A=A.concat(v+s);}else{A=A.concat(e);}A=A.concat("\n");if(this.getIndicator()&&this.getIndicator()!==l.DeviationIndicator.None){A=A.concat(this._rb.getText(("NUMERICCONTENT_DEVIATION_"+this.getIndicator()).toUpperCase()));A=A.concat("\n");}A=A.concat(m);return A;};
b.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var T=this.getAltText();if(typeof t==="string"||t instanceof String){T=t.split("{AltText}").join(T).split("((AltText))").join(T);return T;}if(t){return t;}else{return"";}};
b.prototype.setIcon=function(u){var v=!q.sap.equal(this.getIcon(),u);if(v){if(this._oIcon){this._oIcon.destroy();this._oIcon=undefined;}if(u){this._oIcon=I.createControlByURI({id:this.getId()+"-icon-image",src:u},a);}}this._setPointerOnIcon();return this.setProperty("icon",u);};
b.prototype._setPointerOnIcon=function(){if(this._oIcon&&this.hasListeners("press")){this._oIcon.addStyleClass("sapMPointer");}else if(this._oIcon&&this._oIcon.hasStyleClass("sapMPointer")){this._oIcon.removeStyleClass("sapMPointer");}};
b.prototype.ontap=function(e){this.$().focus();this.firePress();e.preventDefault();};
b.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
b.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE){e.preventDefault();}};
b.prototype.attachEvent=function(e,d,f,c){C.prototype.attachEvent.call(this,e,d,f,c);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnIcon();}return this;};
b.prototype.detachEvent=function(e,f,c){C.prototype.detachEvent.call(this,e,f,c);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnIcon();}return this;};
b.prototype._parseFormattedValue=function(v){var t=v.replace(String.fromCharCode(8206),"").replace(String.fromCharCode(8207),"");return{scale:t.replace(/[+-., \d]*(.*)$/g,"$1").trim().replace(/\.$/,""),value:t.replace(/([+-., \d]*).*$/g,"$1").trim()};};
return b;});
sap.ui.predefine('sap/m/ObjectAttribute',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/library','sap/m/Text','./ObjectAttributeRenderer'],function(q,l,C,c,T,O){"use strict";var a=c.TextDirection;
var b=C.extend("sap.m.ObjectAttribute",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectAttribute.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:a.Inherit}},aggregations:{customContent:{type:"sap.ui.core.Control",multiple:false},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{parameters:{domRef:{type:"string"}}}}}});
b.prototype.init=function(){this.setAggregation('_textControl',new T());};
b.prototype._getUpdatedTextControl=function(){var A=this.getAggregation('customContent')||this.getAggregation('_textControl'),t=this.getTitle(),s=this.getAggregation('customContent')?this.getAggregation('customContent').getText():this.getText(),d=this.getTextDirection(),p=this.getParent(),P=sap.ui.getCore().getConfiguration().getRTL(),m=O.MAX_LINES.MULTI_LINE,w=true,o='';if(d===a.LTR&&P){o='\u200e';}if(d===a.RTL&&!P){o='\u200f';}s=o+s+o;if(t){s=s.replace(new RegExp(t+":\\s+","gi"),"");s=t+": "+s;}A.setProperty('text',s,true);if(p instanceof sap.m.ObjectListItem){w=false;m=O.MAX_LINES.SINGLE_LINE;}this._setControlWrapping(A,w,m);return A;};
b.prototype._setControlWrapping=function(A,w,m){if(A instanceof sap.m.Link){A.setProperty('wrapping',w,true);}if(A instanceof T){A.setProperty('maxLines',m,true);}};
b.prototype.ontap=function(e){if(this._isSimulatedLink()&&(e.target.id!=this.getId())){this.firePress({domRef:this.getDomRef()});}};
b.prototype.onsapenter=function(e){if(this._isSimulatedLink()){this.firePress({domRef:this.getDomRef()});e.setMarked();}};
b.prototype.onsapspace=function(e){this.onsapenter(e);};
b.prototype._isEmpty=function(){if(this.getAggregation('customContent')&&!(this.getAggregation('customContent')instanceof sap.m.Link||this.getAggregation('customContent')instanceof T)){q.sap.log.warning("Only sap.m.Link or sap.m.Text are allowed in \"sap.m.ObjectAttribute.customContent\" aggregation");return true;}return!(this.getText().trim()||this.getTitle().trim());};
b.prototype.ontouchstart=function(e){if(this._isSimulatedLink()){e.originalEvent._sapui_handledByControl=true;}};
b.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("text");};
b.prototype._isSimulatedLink=function(){return(this.getActive()&&this.getText()!=="")&&!this.getAggregation('customContent');};
return b;});
sap.ui.predefine('sap/m/ObjectAttributeRenderer',["sap/ui/core/library"],function(c){"use strict";var T=c.TextDirection;var O={MAX_LINES:{SINGLE_LINE:1,MULTI_LINE:2}};
O.render=function(r,o){var p=o.getParent(),t=o.getTooltip_AsString();if(o._isEmpty()){return;}r.write("<div");r.writeControlData(o);r.addClass("sapMObjectAttributeDiv");if(o._isSimulatedLink()){r.addClass("sapMObjectAttributeActive");r.writeAttribute("tabindex","0");r.writeAccessibilityState(o,{role:"link"});}r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}r.write(">");if(o.getActive()&&!o.getCustomContent()||(p instanceof sap.m.ObjectHeader)){this.renderActiveTitle(r,o);this.renderActiveText(r,o,p);}else{r.renderControl(o._getUpdatedTextControl());}r.write("</div>");};
O.renderActiveTitle=function(r,o){if(!o.getProperty("title")){return;}r.write("<span id=\""+o.getId()+"-title\"");r.addClass("sapMObjectAttributeTitle");r.writeClasses();r.write(">");r.writeEscaped(o.getProperty("title"));r.write("</span>");r.write("<span id=\""+o.getId()+"-colon\"");r.addClass("sapMObjectAttributeColon");r.writeClasses();r.write(">");r.write(":&nbsp;");r.write("</span>");};
O.renderActiveText=function(r,o,p){var t=o.getTextDirection(),a=o.getAggregation("customContent");r.write("<span id=\""+o.getId()+"-text\"");r.addClass("sapMObjectAttributeText");if(t&&t!==T.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.writeClasses();r.write(">");if(a&&p){if((p instanceof sap.m.ObjectHeader)&&!o.getParent().getResponsive()){o._setControlWrapping(a,true,O.MAX_LINES.MULTI_LINE);}else{o._setControlWrapping(a,false,O.MAX_LINES.SINGLE_LINE);}r.renderControl(a);}else{r.writeEscaped(o.getProperty("text"));}r.write("</span>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectHeader',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/m/Text','./ObjectHeaderRenderer'],function(q,l,C,I,c,D,T,O){"use strict";var B=l.BackgroundDesign;var a=c.TextAlign;var b=l.ImageHelper;var d=l.ObjectMarkerType;var e=c.TitleLevel;var f=c.TextDirection;var V=c.ValueState;
var g=C.extend("sap.m.ObjectHeader",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectHeader.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null},intro:{type:"string",group:"Misc",defaultValue:null},introActive:{type:"boolean",group:"Misc",defaultValue:null},titleActive:{type:"boolean",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconActive:{type:"boolean",group:"Misc",defaultValue:null},iconAlt:{type:"string",group:"Accessibility",defaultValue:null},iconTooltip:{type:"string",group:"Accessibility",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},markFavorite:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},markFlagged:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showMarkers:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},numberState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:V.None},condensed:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"},responsive:{type:"boolean",group:"Behavior",defaultValue:false},fullScreenOptimized:{type:"boolean",group:"Appearance",defaultValue:false},titleHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},titleTarget:{type:"string",group:"Behavior",defaultValue:null},introHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},introTarget:{type:"string",group:"Behavior",defaultValue:null},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:f.Inherit},introTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:f.Inherit},numberTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:f.Inherit},titleSelectorTooltip:{type:"string",group:"Misc",defaultValue:"Options"},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:e.H1}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},firstStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},secondStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},statuses:{type:"sap.ui.core.Control",multiple:true,singularName:"status"},_objectNumber:{type:"sap.m.ObjectNumber",multiple:false,visibility:"hidden"},additionalNumbers:{type:"sap.m.ObjectNumber",multiple:true,singularName:"additionalNumber"},headerContainer:{type:"sap.m.ObjectHeaderContainer",multiple:false},markers:{type:"sap.m.ObjectMarker",multiple:true,singularName:"marker"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{titlePress:{parameters:{domRef:{type:"object"}}},introPress:{parameters:{domRef:{type:"object"}}},iconPress:{parameters:{domRef:{type:"object"}}},titleSelectorPress:{parameters:{domRef:{type:"object"}}}}}});
g.prototype.init=function(){var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTitleArrowIcon=I.createControlByURI({id:this.getId()+"-titleArrow",src:I.getIconURI("arrow-down"),decorative:false,visible:false,tooltip:L.getText("OH_SELECT_ARROW_TOOLTIP"),size:"1.375rem",press:function(E){}});this._fNumberWidth=undefined;this._titleText=new T(this.getId()+"-titleText");this._titleText.setMaxLines(3);};
g.prototype.insertAttribute=function(A,i){var r=this.insertAggregation("attributes",A,i);this._registerControlListener(A);return r;};
g.prototype.addAttribute=function(A){var r=this.addAggregation("attributes",A);this._registerControlListener(A);return r;};
g.prototype.removeAttribute=function(A){var r=this.removeAggregation("attributes",A);this._deregisterControlListener(r);return r;};
g.prototype.removeAllAttributes=function(){var A=this.removeAllAggregation("attributes");A.forEach(this._deregisterControlListener,this);return A;};
g.prototype.destroyAttributes=function(){var A=this.getAggregation("attributes");if(A!==null){A.forEach(this._deregisterControlListener,this);}return this.destroyAggregation("attributes");};
g.prototype.insertStatus=function(s,i){var r=this.insertAggregation("statuses",s,i);this._registerControlListener(s);return r;};
g.prototype.addStatus=function(s){var r=this.addAggregation("statuses",s);this._registerControlListener(s);return r;};
g.prototype.removeStatus=function(s){var r=this.removeAggregation("statuses",s);this._deregisterControlListener(r);return r;};
g.prototype.removeAllStatuses=function(){var s=this.removeAllAggregation("statuses");s.forEach(this._deregisterControlListener,this);return s;};
g.prototype.destroyStatuses=function(){var s=this.getAggregation("statuses");if(s!==null){s.forEach(this._deregisterControlListener,this);}return this.destroyAggregation("statuses");};
g.prototype._registerControlListener=function(o){if(o){o.attachEvent("_change",this.invalidate,this);}};
g.prototype._deregisterControlListener=function(o){if(o){o.detachEvent("_change",this.invalidate,this);}};
g.prototype.setCondensed=function(h){this.setProperty("condensed",h);if(this.getCondensed()){this._oTitleArrowIcon.setSize("1rem");}else{this._oTitleArrowIcon.setSize("1.375rem");}return this;};
g.prototype.setNumber=function(n){this.setProperty("number",n);this._getObjectNumber().setNumber(n);return this;};
g.prototype.setNumberUnit=function(u){this.setProperty("numberUnit",u);this._getObjectNumber().setUnit(u);return this;};
g.prototype.setNumberState=function(s){this.setProperty("numberState",s,true);this._getObjectNumber().setState(s);return this;};
g.prototype.setTitleSelectorTooltip=function(t){this.setProperty("titleSelectorTooltip",t,false);this._oTitleArrowIcon.setTooltip(t);return this;};
g.prototype.setMarkFavorite=function(m){return this._setOldMarkers(d.Favorite,m);};
g.prototype.setMarkFlagged=function(m){return this._setOldMarkers(d.Flagged,m);};
g.prototype.setShowMarkers=function(m){var M,A=this.getMarkers(),i;this.setProperty("showMarkers",m,false);for(i=0;i<A.length;i++){M=A[i].getType();if((M===d.Flagged&&this.getMarkFlagged())||(M===d.Favorite&&this.getMarkFavorite())){A[i].setVisible(m);}}return this;};
g.prototype._setOldMarkers=function(m,M){var A=this.getMarkers(),h=false,i,o={Flagged:"-flag",Favorite:"-favorite"};this.setProperty("mark"+m,M,false);if(!this.getShowMarkers()){M=false;}for(i=0;i<A.length;i++){if(A[i].getType()===m){h=true;A[i].setVisible(M);break;}}if(!h){this.insertAggregation("markers",new sap.m.ObjectMarker({id:this.getId()+o[m],type:m,visible:M}));}return this;};
g.prototype._getVisibleMarkers=function(){var A=this.getMarkers(),v=[],i;for(i=0;i<A.length;i++){if(A[i].getVisible()){v.push(A[i]);}}return v;};
g.prototype._getObjectNumber=function(){var o=this.getAggregation("_objectNumber");if(!o){o=new sap.m.ObjectNumber(this.getId()+"-number",{emphasized:false});this.setAggregation("_objectNumber",o,true);}return o;};
g.prototype.getFocusDomRef=function(){if(this.getResponsive()){return this.$("txt");}else{return this.$("title");}};
g.prototype.ontap=function(E){var s=E.target.id;if(this.getIntroActive()&&s===this.getId()+"-intro"){if(!this.getIntroHref()){this.fireIntroPress({domRef:q.sap.domById(s)});}}else if(!this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-title"||q(E.target).parent().attr('id')===this.getId()+"-title"||s===this.getId()+"-titleText-inner")){if(!this.getTitleHref()){E.preventDefault();s=this.getId()+"-title";this.fireTitlePress({domRef:q.sap.domById(s)});}}else if(this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-txt"||q(E.target).parent().attr('id')===this.getId()+"-txt")){if(!this.getTitleHref()){E.preventDefault();s=this.getId()+"-txt";this.fireTitlePress({domRef:q.sap.domById(s)});}}else if(this.getIconActive()&&(s===this.getId()+"-img"||s===this.getId()+"-icon")){this.fireIconPress({domRef:q.sap.domById(s)});}else if(s===this.getId()+"-titleArrow"){this.fireTitleSelectorPress({domRef:q.sap.domById(s)});}};
g.prototype._handleSpaceOrEnter=function(E){var s=E.target.id;E.setMarked();if(!this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-title"||q(E.target).parent().attr('id')===this.getId()+"-title"||s===this.getId()+"-titleText-inner")){if(E.type==="sapspace"){E.preventDefault();}s=this.getId()+"-title";if(!this.getTitleHref()){E.preventDefault();this.fireTitlePress({domRef:q.sap.domById(s)});}else{if(E.type==="sapspace"){this._linkClick(E,s);}}}else if(this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-txt"||q(E.target).parent().attr('id')===this.getId()+"-txt")){if(E.type==="sapspace"){E.preventDefault();}s=this.getId()+"-txt";if(!this.getTitleHref()){E.preventDefault();this.fireTitlePress({domRef:q.sap.domById(s)});}else{if(E.type==="sapspace"){this._linkClick(E,s);}}}else if(this.getIntroActive()&&s===this.getId()+"-intro"){if(E.type==="sapspace"){E.preventDefault();}if(!this.getIntroHref()){this.fireIntroPress({domRef:q.sap.domById(s)});}}else if(this.getIconActive()&&q(E.target).is('.sapMOHIcon,.sapMOHRIcon')){if(E.type==="sapspace"){E.preventDefault();}var i=q.sap.domById(this.getId()+"-icon");if(!i){i=q.sap.domById(this.getId()+"-img");}this.fireIconPress({domRef:i});}else if(s===this.getId()+"-titleArrow"){if(E.type==="sapspace"){E.preventDefault();}this.fireTitleSelectorPress({domRef:q.sap.domById(s)});}};
g.prototype.onsapspace=g.prototype._handleSpaceOrEnter;g.prototype.onsapenter=g.prototype._handleSpaceOrEnter;
g.prototype._linkClick=function(E,s){E.setMarked();var o=document.createEvent('MouseEvents');o.initEvent('click',false,true);q.sap.domById(s).dispatchEvent(o);};
g.prototype._onOrientationChange=function(){var i=this.getId();if(D.system.tablet&&this.getFullScreenOptimized()&&(this._hasAttributes()||this._hasStatus())){this._rerenderStates();}if(D.system.phone){if(D.orientation.portrait){if(this.getTitle().length>50){this._rerenderTitle(50);}if(this.getIcon()){q.sap.byId(i+"-titlediv").removeClass("sapMOHRTitleIcon");q.sap.byId(i+"-titleIcon").addClass("sapMOHRHideIcon");}}else{if(D.orientation.landscape){if(this.getTitle().length>80){this._rerenderTitle(80);}if(this.getIcon()){q.sap.byId(i+"-titlediv").addClass("sapMOHRTitleIcon");q.sap.byId(i+"-titleIcon").removeClass("sapMOHRHideIcon");}}}this._adjustNumberDiv();}this._adjustIntroDiv();};
g.prototype._rerenderTitle=function(n){var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderTitle(r,this,n);r.destroy();};
g.prototype._rerenderStates=function(){var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderResponsiveStates(r,this);r.destroy();};
g.prototype.exit=function(){if(!D.system.phone){this._detachMediaContainerWidthChange(this._rerenderOHR,this,D.media.RANGESETS.SAP_STANDARD);}if(D.system.tablet||D.system.phone){D.orientation.detachHandler(this._onOrientationChange,this);}if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=undefined;}if(this._oTitleArrowIcon){this._oTitleArrowIcon.destroy();this._oTitleArrowIcon=undefined;}if(this._titleText){this._titleText.destroy();this._titleText=undefined;}if(this._introText){this._introText.destroy();this._introText=undefined;}};
g.prototype._getImageControl=function(){var i=this.getId()+"-img";var s="2.5rem";var p=q.extend({src:this.getIcon(),tooltip:this.getIconTooltip(),alt:this.getIconAlt(),useIconTooltip:false,densityAware:this.getIconDensityAware()},I.isIconURI(this.getIcon())?{size:s}:{});this._oImageControl=b.getImageControl(i,this._oImageControl,this,p);return this._oImageControl;};
g.prototype.onBeforeRendering=function(){if(D.system.tablet||D.system.phone){D.orientation.detachHandler(this._onOrientationChange,this);}if(!D.system.phone){this._detachMediaContainerWidthChange(this._rerenderOHR,this,D.media.RANGESETS.SAP_STANDARD);}if(this._introText){this._introText.destroy();this._introText=undefined;}};
g.prototype.onAfterRendering=function(){var o=this.getAggregation("_objectNumber");var p=sap.ui.getCore().getConfiguration().getRTL();var $=this.$("titleArrow");$.attr("role","button");if(this.getResponsive()){this._adjustIntroDiv();if(o&&o.getNumber()){if(D.system.desktop&&q('html').hasClass("sapUiMedia-Std-Desktop")&&this.getFullScreenOptimized()&&this._iCountVisAttrStat>=1&&this._iCountVisAttrStat<=3){o.setTextAlign(p?a.Right:a.Left);}else{o.setTextAlign(p?a.Left:a.Right);}}this._adjustNumberDiv();if(D.system.tablet||D.system.phone){D.orientation.attachHandler(this._onOrientationChange,this);}if(!D.system.phone){this._attachMediaContainerWidthChange(this._rerenderOHR,this,D.media.RANGESETS.SAP_STANDARD);}}else{var t=p?a.Left:a.Right;if(o&&o.getNumber()){o.setTextAlign(t);}if(this.getAdditionalNumbers()){this._setTextAlignANum(t);}}};
g.prototype._rerenderOHR=function(){this.invalidate();};
g.prototype._adjustNumberDiv=function(){var i=this.getId();var o=this.getAggregation("_objectNumber");var p=sap.ui.getCore().getConfiguration().getRTL();if(o&&o.getNumber()){var $=q.sap.byId(i+"-number");var h=q.sap.byId(i+"-titlediv");if(this._isMediaSize("Phone")){if($.hasClass("sapMObjectNumberBelowTitle")){o.setTextAlign(p?a.Left:a.Right);$.removeClass("sapMObjectNumberBelowTitle");h.removeClass("sapMOHRTitleDivFull");}var n=$.parent().width()*0.4;if($.outerWidth()>n){o.setTextAlign(p?a.Right:a.Left);$.addClass("sapMObjectNumberBelowTitle");h.addClass("sapMOHRTitleDivFull");}}}};
g.prototype._adjustIntroDiv=function(){var i=this.getId();var $=q.sap.byId(i+"-txt");var h=q.sap.byId(i+"-titleArrow");var j=q.sap.byId(i+"-intro");if(j.parent().hasClass("sapMOHRIntroMargin")){j.parent().removeClass("sapMOHRIntroMargin");}if(h.height()!==null&&($.height()<h.height())){j.parent().addClass("sapMOHRIntroMargin");}};
g._escapeId=function(i){return i?"#"+i.replace(/(:|\.)/g,'\\$1'):"";};
g.prototype._hasBottomContent=function(){return(this._hasAttributes()||this._hasStatus()||this._hasMarkers());};
g.prototype._hasIcon=function(){return!!this.getIcon().trim();};
g.prototype._hasAttributes=function(){var h=this.getAttributes();if(h&&h.length>0){for(var i=0;i<h.length;i++){if(!h[i]._isEmpty()){return true;}}}return false;};
g.prototype._hasStatus=function(){var h=((this.getFirstStatus()&&!this.getFirstStatus()._isEmpty())||(this.getSecondStatus()&&!this.getSecondStatus()._isEmpty()));if(!h&&this.getStatuses()&&this.getStatuses().length>0){var s=this.getStatuses();for(var i=0;i<s.length;i++){if(s[i]instanceof sap.m.ObjectStatus&&!s[i]._isEmpty()){h=true;break;}else if(s[i]instanceof sap.m.ProgressIndicator){h=true;break;}}}return h;};
g.prototype._hasMarkers=function(){var m=this.getMarkers(),h=this.getShowMarkers()&&(this.getMarkFavorite()||this.getMarkFlagged()),H=m&&m.length;return(h||H);};
g.prototype._getDefaultBackgroundDesign=function(){if(this.getCondensed()){return B.Solid;}else{if(this.getResponsive()){return B.Translucent;}else{return B.Transparent;}}};
g.prototype._getBackground=function(){if(this.getBackgroundDesign()===undefined){return this._getDefaultBackgroundDesign();}else{return this.getBackgroundDesign();}};
g.prototype._setTextAlignANum=function(t){var n=this.getAdditionalNumbers();for(var i=0;i<n.length;i++){n[i].setTextAlign(t);}};
g.prototype._isMediaSize=function(r){return this._getCurrentMediaContainerRange(D.media.RANGESETS.SAP_STANDARD).name===r;};
return g;});
sap.ui.predefine('sap/m/ObjectHeaderRenderer',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/library','sap/m/library','sap/ui/Device'],function(q,C,c,l,D){"use strict";var T=c.TextDirection;var B=l.BackgroundDesign;var a=c.TitleLevel;var O={};
O._isEmptyObject=function(o){if(!o){return true;}if((!o._isEmpty||!o._isEmpty())&&(!o.getVisible||o.getVisible())){return false;}return true;};
O._isEmptyArray=function(A){if(A){for(var i=0;i<A.length;i++){if(!O._isEmptyObject(A[i])){return false;}}}return true;};
O._isEmptyRow=function(L,r){return O._isEmptyObject(L)&&O._isEmptyArray(r);};
O._renderObjects=function(r,o,b){for(var i=0;i<o.length;i++){if(o[i]instanceof C){this._renderChildControl(r,b,o[i]);}}};
O._computeChildControlsToBeRendered=function(o){o.__controlsToBeRendered={};var b=o.getAttributes();for(var i=0;i<b.length;i++){o.__controlsToBeRendered[b[i].getId()]=b[i];}b=o.getStatuses();for(var i=0;i<b.length;i++){o.__controlsToBeRendered[b[i].getId()]=b[i];}var d=o.getFirstStatus();if(d){o.__controlsToBeRendered[d.getId()]=d;}d=o.getSecondStatus();if(d){o.__controlsToBeRendered[d.getId()]=d;}d=o.getAggregation("_objectNumber");if(d){o.__controlsToBeRendered[d.getId()]=d;}};
O._cleanupNotRenderedChildControls=function(r,o){for(var i in o.__controlsToBeRendered){r.cleanupControlWithoutRendering(o.__controlsToBeRendered[i]);}delete o.__controlsToBeRendered;};
O._getMarkers=function(o){return o._getVisibleMarkers();};
O._renderIntro=function(r,o,i,I){if(o.getIntroActive()){o._introText=new sap.m.Link(o.getId()+"-intro");o._introText.setText(o.getIntro());o._introText.setHref(o.getIntroHref());o._introText.setTarget(o.getIntroTarget());o._introText.press=o.introPress;}else{o._introText=new sap.m.Text(o.getId()+"-intro");o._introText.setText(o.getIntro());o._introText.setMaxLines(3);}o._introText.setTextDirection(o.getIntroTextDirection());r.write("<div");r.addClass(i);if(o.getIntroActive()){r.addClass(I);}r.writeClasses();r.write(">");this._renderChildControl(r,o,o._introText);r.write("</div>");};
O._renderAttribute=function(r,o,A,f){r.write("<div");r.addClass("sapMOHAttr");r.writeClasses();if(f){r.addStyle("width","100%");r.writeStyles();}r.write(">");this._renderChildControl(r,o,A);r.write("</div>");};
O._getVisibleStatuses=function(o){var v=[];if(o.getFirstStatus()&&o.getFirstStatus().getVisible()){v.push([o.getFirstStatus()]);}if(o.getSecondStatus()&&o.getSecondStatus().getVisible()){v.push([o.getSecondStatus()]);}if(o.getStatuses()){var s=o.getStatuses();for(var i=0;i<s.length;i++){if(!s[i].getVisible||s[i].getVisible()){if(s[i]instanceof sap.m.ObjectStatus||s[i]instanceof sap.m.ProgressIndicator){v.push([s[i]]);}else{q.sap.log.warning("Only sap.m.ObjectStatus or sap.m.ProgressIndicator are allowed in \"sap.m.ObjectHeader.statuses\" aggregation."+" Current object is "+s[i].constructor.getMetadata().getName()+" with id \""+s[i].getId()+"\"");}}}}return v;};
O._getVisibleAttribsAndStatuses=function(o){var r=[],A=o.getAttributes(),v=[];for(var j=0;j<A.length;j++){if(A[j].getVisible()){v.push(A[j]);}}var V=this._getVisibleStatuses(o);r[0]=v;r[1]=V;return r;};
O._renderRow=function(r,o,L,R){if(O._isEmptyRow(L,R)){return;}r.write("<div");r.addClass("sapMOHAttrRow");r.writeClasses();r.write(">");if(!O._isEmptyObject(L)){this._renderAttribute(r,o,L,O._isEmptyArray(R));}else if(O._isEmptyObject(L)&&!O._isEmptyArray(R)){if(R[0]instanceof sap.m.ProgressIndicator){r.write("<div");r.addClass("sapMOHAttr");r.writeClasses();r.write(">");r.write("</div>");}}if(!O._isEmptyArray(R)){r.write("<div");if(R[0]instanceof sap.m.ProgressIndicator){r.addClass("sapMOHStatusFixedWidth");}else if(R[0]instanceof sap.m.ObjectMarker){r.addClass("sapMOHStatusFixedWidth");r.addClass("sapMObjStatusMarker");}else{r.addClass("sapMOHStatus");}r.writeClasses();r.write(">");O._renderObjects(r,R,o);r.write("</div>");}r.write("</div>");};
O._renderAttributesAndStatuses=function(r,o){var A=o.getAttributes();var v=[];for(var j=0;j<A.length;j++){if(A[j].getVisible()){v.push(A[j]);}}var i=v.length;var m=[];var M=O._getMarkers(o);if(!o.getResponsive()&&!O._isEmptyArray(M)){m.push(M);}var V=this._getVisibleStatuses(o);m=m.concat(V);var b=m.length;var n=i>b?i:b;if(!o.getResponsive()){for(var d=0;d<n;d++){this._renderRow(r,o,v[d],m[d]);}}};
O._renderNumber=function(r,o){var n=o.getAdditionalNumbers();if(!o.getNumber()&&(n&&!n.length)){return;}r.write("<div");r.writeAttribute("id",o.getId()+"-numberdiv");r.addClass("sapMOHNumberDiv");r.writeClasses();r.write(">");var b=o.getAggregation("_objectNumber");if(b&&b.getNumber()){b.setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,b);}r.write("</div>");if(!o.getCondensed()){this._renderAdditionalNumbers(r,o);}};
O._renderAdditionalNumbers=function(r,o){var n=o.getAdditionalNumbers();if(n&&!n.length){return;}if(n.length===1){r.write("<div");r.addClass("additionalOHNumberSeparatorDiv");r.writeClasses();r.write("></div>");}for(var i=0;i<n.length;i++){r.write("<div");r.writeAttribute("id",o.getId()+"-additionalNumber"+i);r.addClass("sapMOHNumberDiv additionalOHNumberDiv");if(n.length===1){r.addClass("sapMOHOnlyANumber");}r.writeClasses();r.write(">");n[i].setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,n[i]);r.write("</div>");}};
O._renderTitle=function(r,o){o._oTitleArrowIcon.setVisible(o.getShowTitleSelector());if(o.getShowTitleSelector()&&o._oTitleArrowIcon.getVisible()){r.write("<div");r.addClass("sapMOHTitleAndArrow");r.writeClasses();r.write(">");}if(o.getTitle()){var t=(o.getTitleLevel()===a.Auto)?a.H1:o.getTitleLevel();o._titleText.setText(o.getTitle());o._titleText.setTextDirection(o.getTitleTextDirection());if(o.getTitleActive()){r.write("<a");if(o.getTitleHref()){r.writeAttributeEscaped("href",o.getTitleHref());if(o.getTitleTarget()){r.writeAttributeEscaped("target",o.getTitleTarget());}}r.writeAccessibilityState({role:"link",haspopup:!o.getTitleHref()});}else{r.write("<div");}r.writeAttribute("id",o.getId()+"-title");r.addClass("sapMOHTitle");if(o.getTitleActive()){r.writeAttribute("tabindex","0");r.addClass("sapMOHTitleActive");}if(o.getShowTitleSelector()){r.addClass("sapMOHTitleFollowArrow");}r.writeClasses();r.write(">");r.write("<"+t+">");this._renderChildControl(r,o,o._titleText);r.write("</"+t+">");if(o.getTitleActive()){r.write("</a>");}else{r.write("</div>");}}if(o.getShowTitleSelector()){r.write("<span");r.addClass("sapMOHTitleArrow");r.writeClasses();r.write(">");this._renderChildControl(r,o,o._oTitleArrowIcon);r.write("</span>");}if(o.getShowTitleSelector()&&o._oTitleArrowIcon.getVisible()){r.write("</div>");}};
O._renderFullTitle=function(r,o){var n=o.getAdditionalNumbers();if(!o.getNumber()&&(n&&!n.length)){r.addClass("sapMOHTitleDivFull");}};
O._renderFullOH=function(r,o){var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(o.getIntro()){this._renderIntro(r,o,"sapMOHIntro","sapMOHIntroActive");}r.write("<div");r.addClass("sapMOHTopRow");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",o.getId()+"-titlediv");r.addClass("sapMOHTitleDiv");if(o._hasIcon()){r.addClass("sapMOHTitleIcon");}this._renderFullTitle(r,o);r.writeClasses();r.write(">");if(o._hasIcon()){r.write("<div");r.addClass("sapMOHIcon");if(o.getIconActive()){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");r.writeAccessibilityState({role:"link",haspopup:true,label:L.getText("OH_ARIA_ICON")});}r.writeClasses();r.write(">");this._renderChildControl(r,o,o._getImageControl());r.write("</div>");}this._renderTitle(r,o);r.write("</div>");this._renderNumber(r,o);r.write("<div class=\"sapMOHDivider\"></div>");r.write("</div>");if(o._hasBottomContent()){r.write("<div");r.addClass("sapMOHBottomRow");r.writeClasses();r.write(">");this._renderAttributesAndStatuses(r,o);r.write("<div class=\"sapMOHDivider\"></div>");r.write("</div>");}};
O._renderCondensedOH=function(r,o){r.write("<div");r.writeAttribute("id",o.getId()+"-titlediv");r.addClass("sapMOHTitleDiv");this._renderFullTitle(r,o);r.writeClasses();r.write(">");this._renderTitle(r,o);r.write("</div>");this._renderNumber(r,o);var f=o.getAttributes()[0];if(f&&!f._isEmpty()){this._renderAttribute(r,o,f);}};
O.render=function(r,o){if(o.getResponsive()){this._renderResponsive(r,o);return;}this._computeChildControlsToBeRendered(o);var b=o.getCondensed();r.write("<div");r.writeControlData(o);r.addClass("sapMOH");if(o._getBackground()!==B.Transparent){r.addClass("sapContrastPlus");}if(b){r.addClass("sapMOHC");}r.addClass("sapMOHBg"+o._getBackground());r.writeClasses();var t=o.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.writeAccessibilityState({role:"region",labelledby:{value:o.getId()+"-titleText-inner",append:true}});r.write(">");if(b){this._renderCondensedOH(r,o);}else{this._renderFullOH(r,o);}r.write("<div class=\"sapMOHLastDivider\"></div>");r.write("</div>");this._cleanupNotRenderedChildControls(r,o);};
O._renderChildControl=function(r,o,b){r.renderControl(b);if(!o.getResponsive()&&o.__controlsToBeRendered){o.__controlsToBeRendered[b.getId()]=undefined;}};
O._renderResponsive=function(r,o){var s=this._hasResponsiveStates(o),t=this._hasResponsiveTabs(o),h=o.getHeaderContainer();r.write("<div");r.addClass("sapMOHROuter");r.writeClasses();var b=o.getTooltip_AsString();if(b){r.writeAttributeEscaped("title",b);}r.writeAccessibilityState({role:"region",labelledby:{value:o.getId()+"-txt",append:true}});r.writeControlData(o);r.write(">");r.write("<div");r.addClass("sapMOHR");if(o._getBackground()!==B.Transparent){r.addClass("sapContrastPlus");}if(t){r.addClass("sapMOHRNoBorder");}r.addClass("sapMOHRBg"+o._getBackground());r.writeClasses();r.write(">");r.write("<div");if(D.system.desktop&&o._isMediaSize("Desktop")&&o.getFullScreenOptimized()&&o._iCountVisAttrStat>=1&&o._iCountVisAttrStat<=3){r.addClass("sapMOHRStatesOneOrThree");}r.writeClasses();r.write(">");this._renderResponsiveTitleBlock(r,o);if(s){this._renderResponsiveStates(r,o);}r.write("</div>");if(t){this._renderResponsiveTabs(r,o);}r.write("</div>");if(h&&h instanceof sap.m.IconTabBar){this._renderChildControl(r,o,h);}r.write("</div>");if(!o.getTitle()){if(!o.getBinding("title")){q.sap.log.warning("The title shouldn't be empty!");}}};
O._renderResponsiveTitleBlock=function(r,o){var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");r.write("<div");r.writeAttribute("id",o.getId()+"-titlenumdiv");r.addClass("sapMOHRTitleNumberDiv");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",o.getId()+"-titlediv");r.addClass("sapMOHRTitleDiv");if(o._hasIcon()){if(D.system.phone||o._isMediaSize("Phone")){if(D.orientation.landscape||(o._isMediaSize("Phone")&&!D.system.phone)){r.addClass("sapMOHRTitleIcon");}}else{r.addClass("sapMOHRTitleIcon");}}if(!o.getNumber()){r.addClass("sapMOHRTitleDivFull");}r.writeClasses();r.write(">");this._renderResponsiveTitle(r,o);if(o._hasIcon()){r.write("<div");r.writeAttribute("id",o.getId()+"-titleIcon");r.addClass("sapMOHRIcon");if((D.system.phone&&D.orientation.portrait)){r.addClass("sapMOHRHideIcon");}if(o.getIconActive()){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");r.writeAccessibilityState({role:"link",haspopup:true,label:L.getText("OH_ARIA_ICON")});}r.writeClasses();r.write(">");this._renderChildControl(r,o,o._getImageControl());r.write("</div>");}r.write("</div>");this._renderResponsiveNumber(r,o);r.write("</div>");};
O._renderResponsiveStates=function(r,o){r.write("<div");r.writeAttribute("id",o.getId()+"-states");r.addClass("sapMOHRStates");r.writeClasses();r.write(">");this._renderResponsiveRow(r,o);r.write("</div>");};
O._renderResponsiveRow=function(r,o){var v=[];v=this._getVisibleAttribsAndStatuses(o);var V=v[0].concat(v[1]),i=v[0].length,b=V.length,R=1,s='';if(b===0){return;}if(D.system.desktop){if(!o.getFullScreenOptimized()){if(b>=1&&b<=4){R=2;s='sapMOHRTwoCols';}if(b>=5){R=3;s='sapMOHRThreeCols';}}else{if(b>=1&&b<=3){R=1;s='sapMOHROneCols';}if(b>=4){R=4;s='sapMOHRFourCols';}}}if((D.system.tablet&&!D.system.desktop)||(D.system.desktop&&o._isMediaSize("Tablet"))){if(!o.getFullScreenOptimized()||(D.orientation.portrait&&o.getFullScreenOptimized())){R=2;s='sapMOHRTwoCols';}else{if(o.getFullScreenOptimized()&&(D.orientation.landscape||(D.system.desktop&&o._isMediaSize("Tablet")))){if(b>=1&&b<=2){R=2;s='sapMOHRTwoCols';}if(b>=3){R=3;s='sapMOHRThreeCols';}}}}if(D.system.phone||(D.system.desktop&&o._isMediaSize("Phone"))){R=1;s='sapMOHROneCols';}this._renderResponsiveStatesColumn(r,o,R,V,i,s);};
O._renderResponsiveStatesColumn=function(r,o,R,v,b,s){var d=Math.floor(v.length/R);var e=v.length%R;var f=0;var g=1;for(var i=0;i<v.length;i++){if(f==0){r.write("<div");r.addClass("sapMOHRStatesCont"+g);r.addClass(s);r.writeClasses();r.write(">");}if(i<b){this._renderResponsiveAttribute(r,o,v[i]);}else{this._renderResponsiveStatus(r,o,v[i]);}f++;if((f==d&&g>e)||(f==(d+1)&&g<=e)||i==v.length-1){r.write("</div>");f=0;g++;}}};
O._renderResponsiveAttribute=function(r,o,A){r.write("<div");r.addClass("sapMOHRAttr");r.writeClasses();r.write(">");this._renderChildControl(r,o,A);r.write("</div>");};
O._renderResponsiveStatus=function(r,o,s){r.write("<div");r.addClass("sapMOHRStatus");r.writeClasses();r.write(">");this._renderChildControl(r,o,s[0]);r.write("</div>");};
O._renderResponsiveMarkers=function(r,o){var m=[],t=o.getTitleTextDirection(),p=sap.ui.getCore().getConfiguration().getRTL();m=o._getVisibleMarkers();r.write("<span");r.addClass("sapMObjStatusMarker");if((t===T.LTR&&p)||(t===T.RTL&&!p)){r.addClass("sapMObjStatusMarkerOpposite");}r.writeClasses();r.writeAttribute("id",o.getId()+"-markers");r.write(">");for(var i=0;i<m.length;i++){this._renderChildControl(r,o,m[i]);}r.write("</span>");};
O._renderResponsiveNumber=function(r,o){var b=o.getAggregation("_objectNumber");if(b&&b.getNumber()){b.setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,b);}};
O._hasResponsiveStates=function(o){var A=o.getAttributes(),v=[];if(!(o._hasAttributes()||o._hasStatus())){o._iCountVisAttrStat=0;return false;}for(var j=0;j<A.length;j++){if(A[j].getVisible()){v.push(A[j]);}}var V=this._getVisibleStatuses(o);o._iCountVisAttrStat=v.length+V.length;return!!(v.length+V.length);};
O._hasResponsiveTabs=function(o){var h=o.getHeaderContainer(),i;if(h){if(h instanceof sap.m.IconTabBar){i=h._getIconTabHeader();if(i.getVisible()){o._iCountVisTabs=i.getItems().length;return!!i.getItems().length;}}else if(h.getMetadata().getName()==="sap.m.HeaderContainer"){return!!h.getContent().length;}else if(h.getMetadata().getName()==="sap.suite.ui.commons.HeaderContainer"){return!!h.getItems().length;}}return false;};
O._renderResponsiveTabs=function(r,o){var h=o.getHeaderContainer(),i;r.write("<div class=\"sapMOHRTabs"+(h instanceof sap.m.IconTabBar?" sapMOHRTabsITB":"")+"\">");if(h){if(h instanceof sap.m.IconTabBar){i=h._getIconTabHeader();this._renderChildControl(r,o,i);h._bHideHeader=true;}else if(h.getMetadata().getName()==="sap.m.HeaderContainer"||h.getMetadata().getName()==="sap.suite.ui.commons.HeaderContainer"){this._renderChildControl(r,o,h);}else{q.sap.log.warning("The control "+h+" is not supported for aggregation \"headerContainer\"");}}r.write("</div>");};
O._renderResponsiveTitle=function(r,o){var n;o._oTitleArrowIcon.setVisible(o.getShowTitleSelector());r.write("<div");r.writeAttribute("id",o.getId()+"-title");r.addClass("sapMOHRTitle");if(o.getTitle().length&&o.getTitleActive()){r.addClass("sapMOHRTitleActive");}if(o.getShowTitleSelector()){r.addClass("sapMOHRTitleFollowArrow");}r.writeClasses();r.write(">");if((D.system.phone&&D.orientation.portrait)){n=50;}else{n=80;}r.write("<div");r.writeAttribute("id",o.getId()+"-title-arrow");r.addStyle("display","inline-block");r.writeStyles();r.write(">");this._renderResponsiveTitleAndArrow(r,o,n);r.write("</div>");if(o.getIntro()){this._renderIntro(r,o,"sapMOHRIntro","sapMOHRIntroActive");}r.write("</div>");};
O._rerenderTitle=function(r,o,n){var i=o.getId();this._renderResponsiveTitleAndArrow(r,o,n);r.flush(q.sap.byId(i+"-title-arrow"));};
O._renderResponsiveTitleAndArrow=function(r,o,n){var s,e='',t=o.getTitleTextDirection();var m=!!o._getVisibleMarkers().length;var b=(o.getTitleLevel()===a.Auto)?a.H1:o.getTitleLevel();r.write("<"+b+">");r.write("<span");r.addClass("sapMOHRTitleTextContainer");r.writeClasses();if(t!=T.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");if(o.getTitle().length&&o.getTitleActive()){r.write("<a");if(o.getTitleHref()){r.writeAttributeEscaped("href",o.getTitleHref());if(o.getTitleTarget()){r.writeAttributeEscaped("target",o.getTitleTarget());}}r.writeAttribute("tabindex","0");r.writeAccessibilityState({role:"link",haspopup:!o.getTitleHref()});}else{r.write("<span");}r.writeAttribute("id",o.getId()+"-txt");r.addClass("sapMOHRTitleText");r.writeClasses();r.write(">");r.write("<span");r.addClass("sapMOHRTitleTextWrappable");r.writeClasses();r.write(">");if(o.getTitle().length>n){s=o.getTitle().substr(0,n).trim();e='...';}else{s=o.getTitle();}if(m){var d=s.substr(s.lastIndexOf(" ")+1);var f=s.substr(0,s.lastIndexOf(" ")+1);if(d.length===1){d=s;f='';}r.writeEscaped(f);r.write("</span>");r.writeEscaped(d);r.write(e);if(o.getTitleActive()){r.write("</a>");}else{r.write("</span>");}this._renderResponsiveMarkers(r,o);r.write("</span>");}else{if(!e){r.writeEscaped(s);}else{r.writeEscaped(s+e);}if(o.getTitleActive()){r.write("</span></a></span>");}else{r.write("</span></span></span>");}}if(o.getShowTitleSelector()){r.write("<span");r.addClass("sapMOHRTitleArrow");r.writeClasses();r.write(">");this._renderChildControl(r,o,o._oTitleArrowIcon);r.write("</span>");}r.write("</"+b+">");};
O._rerenderResponsiveStates=function(r,o){var i=o.getId(),v=this._getVisibleAttribsAndStatuses(o),V=v[0].concat(v[1]),b=v[0].length,d=V.length,R=1,s='';if(d===0){return;}if(D.orientation.portrait){R=2;s='sapMOHRTwoCols';}else{if(d>=1&&d<=2){R=2;s='sapMOHRTwoCols';}if(d>=3){R=3;s='sapMOHRThreeCols';}}this._renderResponsiveStatesColumn(r,o,R,V,b,s);r.flush(q.sap.byId(i+"-states")[0]);};
return O;},true);
sap.ui.predefine('sap/m/ObjectIdentifier',['./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','sap/ui/base/ManagedObject','./ObjectIdentifierRenderer'],function(l,C,I,a,c,D,M,O){"use strict";var T=c.TextDirection;
var b=C.extend("sap.m.ObjectIdentifier",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectIdentifier.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},badgeNotes:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgePeople:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgeAttachments:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},titleActive:{type:"boolean",group:"Misc",defaultValue:false},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},aggregations:{_titleControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{titlePress:{parameters:{domRef:{type:"object"}}}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
b.prototype.init=function(){var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(sap.ui.getCore().getConfiguration().getAccessibility()){b.OI_ARIA_ROLE=L.getText("OI_ARIA_ROLE");this._createAriaInfoTextControl();}};
b.prototype.exit=function(){if(this._attachmentsIcon){this._attachmentsIcon.destroy();this._attachmentsIcon=null;}if(this._peopleIcon){this._peopleIcon.destroy();this._peopleIcon=null;}if(this._notesIcon){this._notesIcon.destroy();this._notesIcon=null;}if(this._oAriaCustomRole){this._oAriaCustomRole.destroy();this._oAriaCustomRole=null;}};
b.prototype._getAttachmentsIcon=function(){if(!this._attachmentsIcon){this._attachmentsIcon=this._getIcon(I.getIconURI("attachment"),this.getId()+"-attachments");}return this._attachmentsIcon;};
b.prototype._getPeopleIcon=function(){if(!this._peopleIcon){this._peopleIcon=this._getIcon(I.getIconURI("group"),this.getId()+"-people");}return this._peopleIcon;};
b.prototype._getNotesIcon=function(){if(!this._notesIcon){this._notesIcon=this._getIcon(I.getIconURI("notes"),this.getId()+"-notes");}return this._notesIcon;};
b.prototype._getIcon=function(u,i){var s=D.system.phone?"1em":"1em";var o;o=this._icon||I.createControlByURI({src:u,id:i+"-icon",size:s,useIconTooltip:false},sap.m.Image);o.setSrc(u);return o;};
b.prototype._getTitleControl=function(){var t=this.getAggregation("_titleControl");if(!t){if(this.getProperty("titleActive")){t=new sap.m.Link({id:this.getId()+"-link",text:M.escapeSettingsValue(this.getProperty("title")),ariaLabelledBy:this._oAriaCustomRole});}else{t=new sap.m.Text({id:this.getId()+"-txt",text:M.escapeSettingsValue(this.getProperty("title"))});}this.setAggregation("_titleControl",t,true);}t.setVisible(!!this.getTitle());return t;};
b.prototype._updateTitleControl=function(i){var r,t=this._getTitleControl();if(i&&t instanceof sap.m.Text){this.destroyAggregation("_titleControl",true);t=new sap.m.Link({id:this.getId()+"-link",text:M.escapeSettingsValue(this.getProperty("title")),ariaLabelledBy:this._oAriaCustomRole});this.setAggregation("_titleControl",t,true);}else if(!i&&t instanceof sap.m.Link){this.destroyAggregation("_titleControl",true);t=new sap.m.Text({id:this.getId()+"-txt",text:M.escapeSettingsValue(this.getProperty("title"))});this.setAggregation("_titleControl",t,true);}if(this.$("title").length){t.setProperty("text",this.getProperty("title"),true);r=sap.ui.getCore().createRenderManager();r.renderControl(t);r.flush(this.$("title")[0]);r.destroy();}return t;};
b.prototype._getTextControl=function(){var t=this.getAggregation("_textControl");if(!t){t=new sap.m.Text({text:M.escapeSettingsValue(this.getProperty("text"))});this.setAggregation("_textControl",t,true);}t.setTextDirection(this.getTextDirection());t.setVisible(!!this.getText());return t;};
b.prototype.setTitle=function(t){var o=this._getTitleControl();o.setProperty("text",t,false);o.setVisible(!!o.getText());this.setProperty("title",t,true);this.$("text").toggleClass("sapMObjectIdentifierTextBellow",!!this.getProperty("text")&&!!this.getProperty("title"));return this;};
b.prototype.setText=function(t){this.setProperty("text",t,true);var o=this._getTextControl();o.setProperty("text",t,false);this.$("text").toggleClass("sapMObjectIdentifierTextBellow",!!this.getProperty("text")&&!!this.getProperty("title"));return this;};
b.prototype.setTitleActive=function(v){var p=this.getProperty("titleActive");if(p!=v){this.setProperty("titleActive",v,true);this._updateTitleControl(v);}return this;};
b.prototype._handlePress=function(e){var o=e.target;if(this.getTitleActive()&&this.$("title")[0].firstChild==o){this.fireTitlePress({domRef:o});e.setMarked();}};
b.prototype.onsapenter=function(e){b.prototype._handlePress.apply(this,arguments);};
b.prototype.onsapspace=function(e){b.prototype._handlePress.apply(this,arguments);};
b.prototype.ontap=function(e){b.prototype._handlePress.apply(this,arguments);};
b.prototype.addAssociation=function(A,i,s){var t=this.getAggregation("_titleControl");if(A==="ariaLabelledBy"){if(this.getTitleActive()&&t instanceof sap.m.Link){t.addAssociation("ariaLabelledBy",i,true);}}return C.prototype.addAssociation.apply(this,arguments);};
b.prototype.removeAssociation=function(A,o,s){var t=this.getAggregation("_titleControl");if(A==="ariaLabelledBy"){if(this.getTitleActive()&&t instanceof sap.m.Link){t.removeAssociation("ariaLabelledBy",o,true);}}return C.prototype.removeAssociation.apply(this,arguments);};
b.prototype._createAriaInfoTextControl=function(){if(!this._oAriaCustomRole){this._oAriaCustomRole=new a(this.getId()+"-oIHiddenText",{text:b.OI_ARIA_ROLE});}return this._oAriaCustomRole;};
return b;});
sap.ui.predefine('sap/m/ObjectIdentifierRenderer',[],function(){"use strict";var O={};
O.render=function(r,o){var t;if(!o.getVisible()){return;}r.write("<div");r.writeControlData(o);r.writeAccessibilityState(o);r.addClass("sapMObjectIdentifier");r.writeClasses();t=o.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");r.write("<div");r.addClass("sapMObjectIdentifierTopRow");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMObjectIdentifierIcons");r.writeClasses();r.write(">");if(o.getBadgeAttachments()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getAttachmentsIcon());r.write("</span>");}if(o.getBadgeNotes()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getNotesIcon());r.write("</span>");}if(o.getBadgePeople()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getPeopleIcon());r.write("</span>");}r.write("</div>");r.write("<div id='"+o.getId()+"-title'");r.addClass("sapMObjectIdentifierTitle");r.writeClasses();r.write(">");r.renderControl(o._getTitleControl());r.renderControl(o._oAriaCustomRole);r.write("</div>");r.write("</div>");r.write("<div id='"+o.getId()+"-text'");r.addClass("sapMObjectIdentifierText");if(!!o.getProperty("text")&&!!o.getProperty("title")){r.addClass("sapMObjectIdentifierTextBellow");}r.writeClasses();r.write(">");r.renderControl(o._getTextControl());r.write("</div>");r.write("</div>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectListItem',['./ListItemBase','./library','sap/ui/core/IconPool','sap/m/ObjectNumber','sap/ui/core/library','./ObjectListItemRenderer'],function(L,l,I,O,c,a){"use strict";var b=l.ObjectMarkerType;var d=l.ImageHelper;var T=c.TextAlign;var e=c.TextDirection;var V=c.ValueState;
var f=L.extend("sap.m.ObjectListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null},intro:{type:"string",group:"Misc",defaultValue:nul