/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Metadata','sap/ui/base/ManagedObjectObserver','sap/m/Button','sap/m/OverflowToolbarLayoutData','sap/ui/core/IconPool','sap/m/OverflowToolbarButton','sap/m/OverflowToolbarPriority'],function(q,M,a,B,O,I,b,c){"use strict";var S=M.createClass("sap.m.semantic.ShareMenu",{constructor:function(A){if(!A){q.sap.log.error("missing argumment: constructor expects an actionsheet reference",this);return;}this._oActionSheet=A;this._oContentObserver=new a(this._updateShareBtnVisibility.bind(this));this._setMode(S._Mode.initial);}});S._Mode={initial:"initial",button:"button",actionSheet:"actionSheet"};S.prototype.getBaseButton=function(){return this._oBaseButton;};S.prototype.getAggregation=function(n){if(n==="content"){return this.getContent();}};S.prototype.addAggregation=function(n,o,s){if(n==="content"){return this.addContent(o,s);}};S.prototype.insertAggregation=function(n,o,i,s){if(n==="content"){return this.insertContent(o,i,s);}};S.prototype.indexOfAggregation=function(n,o){if(n==="content"){return this.indexOfContent(o);}};S.prototype.removeAggregation=function(n,o,s){if(n==="content"){return this.removeContent(o,s);}};S.prototype.removeAllAggregation=function(n,s){if(n==="content"){return this.removeAllContent(s);}};S.prototype.getContent=function(){var m=this._getMode();if(m===S._Mode.initial){return[];}else if(m===S._Mode.button){return[this._oBaseButton];}else{return this._oActionSheet.getAggregation("buttons")||[];}};S.prototype.addContent=function(o,s){var m=this._getMode();this._observeButton(o);if(m===S._Mode.initial){this._setMode(S._Mode.button,s,o);return this;}if(m===S._Mode.button){this._setMode(S._Mode.actionSheet,s);}this._preProcessOverflowToolbarButton(o);this._oActionSheet.addButton(o,s);this._updateShareBtnVisibility();return this;};S.prototype.insertContent=function(o,i,s){var m=this._getMode();this._observeButton(o);if(m===S._Mode.initial){this._setMode(S._Mode.button,s,o);return this;}if(m===S._Mode.button){this._setMode(S._Mode.actionSheet,s);}this._preProcessOverflowToolbarButton(o);this._oActionSheet.insertButton(o,i,s);this._updateShareBtnVisibility();return this;};S.prototype.indexOfContent=function(o){if((this._getMode()===S._Mode.button)&&(o===this._oBaseButton)){return 0;}if(this._getMode()===S._Mode.actionSheet){return this._oActionSheet.indexOfAggregation("buttons",o);}return-1;};S.prototype.removeContent=function(o,s){var r,m=this._getMode();if(m===S._Mode.actionSheet){r=this._oActionSheet.removeButton(o,s);this._postProcessOverflowToolbarButton(o);this._unobserveButton(o);if(r){if(this._oActionSheet.getAggregation("buttons").length===1){this._setMode(S._Mode.button,s);}}this._updateShareBtnVisibility();return r;}if(m===S._Mode.button){var l=this._oBaseButton;this._setMode(S._Mode.initial,s);return l;}return r;};S.prototype.removeAllContent=function(s){var r;if(this._getMode()===S._Mode.actionSheet){r=this._oActionSheet.removeAllButtons(s);r.forEach(function(o){this._postProcessOverflowToolbarButton(o);this._unobserveButton(o);},this);this._updateShareBtnVisibility();}else if(this._getMode()===S._Mode.button){r=[this._oBaseButton];}this._setMode(S._Mode.initial,s);return r;};S.prototype.destroy=function(s){this._oActionSheet.destroy(s);if(this._oShareMenuBtn){this._oShareMenuBtn.destroy(s);this._oShareMenuBtn=null;}if(this._oContentObserver){this._oContentObserver.disconnect();this._oContentObserver=null;}};S.prototype._setBaseButton=function(o,s){if(this._oBaseButton===o){return this;}var d=this._oBaseButton;this._oBaseButton=o;if(d){var p=d.getParent(),P=d.sParentAggregationName;if(p){p.removeAggregation(P,d,s);p.addAggregation(P,this._oBaseButton,s);}}return this;};S.prototype._getMode=function(){return this._mode;};S.prototype._setMode=function(m,s,o){if(!S._Mode[m]){q.sap.log.error("unknown shareMenu mode "+m,this);return this;}if(this._mode===m){return this;}if(S._Mode.initial===m){this._setBaseButton(this._getShareMenuButton().applySettings({visible:false}));this._mode=S._Mode.initial;return this;}if(m===S._Mode.button){if(this._mode===S._Mode.initial){this._setBaseButton(o);}else if(this._mode===S._Mode.actionSheet){var l=this._oActionSheet.getAggregation("buttons")[0];this._oActionSheet.removeButton(l,s);this._postProcessOverflowToolbarButton(l);this._setBaseButton(l);}this._mode=S._Mode.button;return this;}if(m===S._Mode.actionSheet){var d=this._oBaseButton;this._setBaseButton(this._getShareMenuButton().applySettings({visible:true}));if(d){this._preProcessOverflowToolbarButton(d);this._oActionSheet.addButton(d,s);}this._mode=S._Mode.actionSheet;}return this;};S.prototype._getShareMenuButton=function(){if(!this._oShareMenuBtn){var t=this;this._oShareMenuBtn=new B(this._oActionSheet.getParent().getId()+"-shareButton",{icon:I.getIconURI("action"),tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("SEMANTIC_CONTROL_ACTION_SHARE"),layoutData:new O({priority:c.NeverOverflow}),press:function(){t._oActionSheet.openBy(t._oShareMenuBtn);}});this._oShareMenuBtn.addEventDelegate({onAfterRendering:function(){t._oShareMenuBtn.$().attr("aria-haspopup",true);}});}return this._oShareMenuBtn;};S.prototype._getVisibleContent=function(){return this.getContent().filter(function(o){return o.getVisible();});};S.prototype._updateShareBtnVisibility=function(){var v=this._getVisibleContent(),t=v.length>0;this._getShareMenuButton().setVisible(t);};S.prototype._preProcessOverflowToolbarButton=function(o){if(o instanceof b){o._bInOverflow=true;}};S.prototype._postProcessOverflowToolbarButton=function(o){if(o instanceof b){delete o._bInOverflow;}};S.prototype._observeButton=function(o){this._oContentObserver.observe(o,{properties:["visible"]});};S.prototype._unobserveButton=function(o){this._oContentObserver.unobserve(o,{properties:["visible"]});};return S;},false);
