/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./BindingParser','./DataType','./EventProvider','./ManagedObjectMetadata','../model/BindingMode','../model/CompositeBinding','../model/Context','../model/FormatException','../model/ListBinding','../model/Model','../model/ParseException','../model/TreeBinding','../model/Type','../model/ValidateException','jquery.sap.act','jquery.sap.script','jquery.sap.strings'],function(q,B,D,E,M,d,C,e,F,L,f,P,T,g,V){"use strict";var I;var h=E.extend("sap.ui.base.ManagedObject",{metadata:{"abstract":true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{"validationSuccess":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"validationError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"parseError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"formatError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"modelContextChange":{}},specialSettings:{id:'sap.ui.core.ID',models:'object',bindingContexts:'object',objectBindings:'object',metadataContexts:'object',Type:{type:'string',visibility:'hidden'}}},constructor:function(i,s,o){var t=this;E.call(this);if(typeof i!=='string'&&i!==undefined){o=s;s=i;i=s&&s.id;}if(!i){i=this.getMetadata().uid();}else{var p=h._fnIdPreprocessor;i=(p?p.call(this,i):i);var a=I||(I=D.getType("sap.ui.core.ID"));if(!a.isValid(i)){throw new Error("\""+i+"\" is not a valid ID.");}}this.sId=i;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=h._oEmptyPropagatedProperties;this.mSkipPropagation={};this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=h._defaultContextualSettings;this._sOwnerId=h._sOwnerId;(function(){var c=false;if(t.register){t.register();}try{if(t._initCompositeSupport){t._initCompositeSupport(s);}if(t.init){t.init();}t.applySettings(s,o);c=true;}finally{if(!c&&t.deregister){t.deregister();}}}());}},M);h.create=function(v,K,s){if(!v||v instanceof h||typeof v!=="object"||v instanceof String){return v;}function a(t){if(typeof t==="function"){return t;}if(typeof t==="string"){return q.sap.getObject(t);}}var c=a(v.Type)||a(K&&K.type);if(typeof c==="function"){return new c(v,s);}var b="Don't know how to create a ManagedObject from "+v+" ("+(typeof v)+")";q.sap.log.fatal(b);throw new Error(b);};var S;function j(i){if(!S){S=sap.ui.require("sap/ui/core/StashedControlSupport");}if(S){return S.getStashedControls(i);}return[];}h._fnIdPreprocessor=null;h._fnSettingsPreprocessor=null;h.runWithPreprocessors=function(a,p,t){var o={id:this._fnIdPreprocessor,settings:this._fnSettingsPreprocessor};p=p||{};this._fnIdPreprocessor=p.id;this._fnSettingsPreprocessor=p.settings;try{return a.call(t);}finally{this._fnIdPreprocessor=o.id;this._fnSettingsPreprocessor=o.settings;}};h.prototype.applySettings=function(s,o){if(!s||q.isEmptyObject(s)){return this;}var t=this,a=this.getMetadata(),v=a.getJSONKeys(),b=h.create,p=h._fnSettingsPreprocessor,K,c,n;function r(O){for(var i=0,w=O.length;i<w;i++){var x=O[i];if(Array.isArray(x)){r(x);}else{t[n._sMutator](b(x,n,o));}}}p&&p.call(this,s);if(s.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(s.metadataContexts,s);}if(s.models){if(typeof s.models!=="object"){throw new Error("models must be a simple object");}if(s.models instanceof f){this.setModel(s.models);}else{for(K in s.models){this.setModel(s.models[K],K==="undefined"?undefined:K);}}}if(s.bindingContexts){if(typeof s.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object");}if(s.bindingContexts instanceof e){this.setBindingContext(s.bindingContexts);}else{for(K in s.bindingContexts){this.setBindingContext(s.bindingContexts[K],K==="undefined"?undefined:K);}}}if(s.objectBindings){if(typeof s.objectBindings!=="string"&&typeof s.objectBindings!=="object"){throw new Error("binding must be a string or simple object");}if(typeof s.objectBindings==="string"||s.objectBindings.path){this.bindObject(s.objectBindings);}else{for(var K in s.objectBindings){s.objectBindings.model=K;this.bindObject(s.objectBindings[K]);}}}for(K in s){c=s[K];if((n=v[K])!==undefined){var u;switch(n._iKind){case 0:u=this.extractBindingInfo(c,o);if(u&&typeof u==="object"){this.bindProperty(K,u);}else{this[n._sMutator](u||c);}break;case 1:u=n.altTypes&&this.extractBindingInfo(c,o);if(u&&typeof u==="object"){this.bindProperty(K,u);}else{if(Array.isArray(c)){if(c.length>1){q.sap.log.error("Tried to add an array of controls to a single aggregation");}c=c[0];}this[n._sMutator](b(u||c,n,o));}break;case 2:u=this.extractBindingInfo(c,o);if(u&&typeof u==="object"){this.bindAggregation(K,u);}else{c=u||c;if(c){if(Array.isArray(c)){r(c);}else{t[n._sMutator](b(c,n,o));}}}break;case 3:this[n._sMutator](c);break;case 4:if(c){if(Array.isArray(c)){for(var i=0,l=c.length;i<l;i++){this[n._sMutator](c[i]);}}else{this[n._sMutator](c);}}break;case 5:if(typeof c=="function"){this[n._sMutator](c);}else{this[n._sMutator](c[0],c[1],c[2]);}break;case-1:default:break;}}else{}}return this;};h.escapeSettingsValue=function(v){return(typeof v==="string")?h.bindingParser.escape(v):v;};h.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId();};h.prototype.getId=function(){return this.sId;};h.prototype.setProperty=function(p,v,s){var o=this.mProperties[p];v=this.validateProperty(p,v);if(q.sap.equal(o,v)){this.mProperties[p]=v;return this;}if(s){q.sap.act.refresh();this.iSuppressInvalidate++;}this.mProperties[p]=v;if(!this.isInvalidateSuppressed()){this.invalidate();}this.updateModelProperty(p,v,o);if(this.mEventRegistry["_change"]){E.prototype.fireEvent.call(this,"_change",{"id":this.getId(),"name":p,"oldValue":o,"newValue":v});}if(this._observer){this._observer.propertyChange(this,p,o,v);}if(s){this.iSuppressInvalidate--;}return this;};h.prototype.getProperty=function(p){var v=this.mProperties[p],o=this.getMetadata().getProperty(p),t;if(!o){throw new Error("Property \""+p+"\" does not exist in "+this);}t=D.getType(o.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v instanceof String){v=v.valueOf();}return v;};h.prototype.validateProperty=function(p,v){var o=this.getMetadata().getProperty(p),t;if(!o){throw new Error("Property \""+p+"\" does not exist in "+this);}t=D.getType(o.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v==null){v=o.getDefaultValue();}else if(t instanceof D){if(t.getName()=="string"){if(!(typeof v=="string"||v instanceof String)){v=""+v;}}else if(t.getName()=="string[]"){if(typeof v=="string"){v=[v];}if(!Array.isArray(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected string[]"+" for property \""+p+"\" of "+this);}for(var i=0;i<v.length;i++){if(typeof v[i]!=="string"){v[i]=""+v[i];}}}else if(!t.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+t.getName()+" for property \""+p+"\" of "+this);}}if(t&&t.normalize&&typeof t.normalize==="function"){v=t.normalize(v);}return v;};h.prototype.isPropertyInitial=function(p){return!Object.prototype.hasOwnProperty.call(this.mProperties,p)&&!this.isBound(p);};h.prototype.resetProperty=function(p){if(this.mProperties.hasOwnProperty(p)){var o=this.getMetadata().getProperty(p);this[o._sMutator](null);if(this.mProperties[p]===o.getDefaultValue()){delete this.mProperties[p];}}return this;};h.prototype.getOriginInfo=function(p){var v=this.mProperties[p];if(!(v instanceof String&&v.originInfo)){return null;}return v.originInfo;};h.prototype.setAssociation=function(a,i,s){if(i instanceof h){i=i.getId();}else if(i!=null&&typeof i!=="string"){return this;}if(this.mAssociations[a]===i){return this;}if(s){this.iSuppressInvalidate++;}if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"remove",this.mAssociations[a]);}this.mAssociations[a]=i;if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};h.prototype.getAssociation=function(a,o){var r=this.mAssociations[a];if(!r){r=this.mAssociations[a]=o||null;}else{if(typeof r.length==='number'&&!(r.propertyIsEnumerable('length'))){return r.slice();}return r;}return r;};h.prototype.addAssociation=function(a,i,s){if(i instanceof h){i=i.getId();}else if(typeof i!=="string"){return this;}if(s){this.iSuppressInvalidate++;}var b=this.mAssociations[a];if(!b){b=this.mAssociations[a]=[i];}else{b.push(i);}if(this._observer){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};h.prototype.removeAssociation=function(a,o,s){var b=this.mAssociations[a];var c=null;if(!b){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(o)=="object"&&o.getId){o=o.getId();}if(typeof(o)=="string"){for(var i=0;i<b.length;i++){if(b[i]==o){o=i;break;}}}if(typeof(o)=="number"){if(o<0||o>=b.length){q.sap.log.warning("ManagedObject.removeAssociation called with invalid index: "+a+", "+o);}else{c=b[o];b.splice(o,1);if(this._observer){this._observer.associationChange(this,a,"remove",c);}if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return c;};h.prototype.removeAllAssociation=function(a,s){var i=this.mAssociations[a];if(!i){return[];}if(s){this.iSuppressInvalidate++;}delete this.mAssociations[a];if(this._observer){this._observer.associationChange(this,a,"remove",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return i;};h.prototype.validateAggregation=function(a,o,b,O){var c=this.getMetadata(),A=c.getManagedAggregation(a),l,t,i,n;if(!A){throw new Error("Aggregation \""+a+"\" does not exist in "+this);}if(A.multiple!==b){throw new Error("Aggregation '"+a+"' of "+this+" used with wrong cardinality (declared as "+(A.multiple?"0..n":"0..1")+")");}var p=c.getAggregationForwarder(a);if(p&&!O){p.getTarget(this).validateAggregation(p.targetAggregationName,o,b);}if(!A.multiple&&!o){return o;}t=q.sap.getObject(A.type);if(typeof t==="function"&&o instanceof t){return o;}if(o&&o.getMetadata&&o.getMetadata().isInstanceOf(A.type)){return o;}l=A.altTypes;if(l&&l.length){if(o==null){return o;}for(i=0;i<l.length;i++){t=D.getType(l[i]);if(t instanceof D){if(t.isValid(o)){return o;}}}}n="\""+o+"\" is not valid for aggregation \""+a+"\" of "+this;if(D.isInterfaceType(A.type)){return o;}else{throw new Error(n);}};h.prototype.setAggregation=function(a,o,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){o=this.validateAggregation(a,o,false,true);return b.set(this,o);}var O=this.mAggregations[a];if(O===o){return this;}o=this.validateAggregation(a,o,false);if(s){this.iSuppressInvalidate++;}this.mAggregations[a]=null;if(O instanceof h){O.setParent(null);}else{if(this._observer!=null&&O!=null){this._observer.aggregationChange(this,a,"remove",O);}}this.mAggregations[a]=o;if(o instanceof h){o.setParent(this,a,s);}else{if(!this.isInvalidateSuppressed()){this.invalidate();}if(this._observer!=null&&o!=null){this._observer.aggregationChange(this,a,"insert",o);}}if(s){this.iSuppressInvalidate--;}return this;};h.prototype.getAggregation=function(a,o){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.get(this);}var c=this.mAggregations[a];if(!c){c=this.mAggregations[a]=o||null;}if(c){if(typeof c.length==='number'&&!(c.propertyIsEnumerable('length'))){return c.slice();}return c;}else{return null;}};h.prototype.indexOfAggregation=function(a,o){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.indexOf(this,o);}var c=this.mAggregations[a];if(c){if(c.length==undefined){return-2;}for(var i=0;i<c.length;i++){if(c[i]==o){return i;}}}return-1;};h.prototype.insertAggregation=function(a,o,b,s){if(!o){return this;}o=this.validateAggregation(a,o,true,true);var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.insert(this,o,b);}var l=this.mAggregations[a]||(this.mAggregations[a]=[]);var i;if(b<0){i=0;}else if(b>l.length){i=l.length;}else{i=b;}if(i!==b){q.sap.log.warning("ManagedObject.insertAggregation: index '"+b+"' out of range [0,"+l.length+"], forced to "+i);}l.splice(i,0,o);o.setParent(this,a,s);return this;};h.prototype.addAggregation=function(a,o,s){if(!o){return this;}o=this.validateAggregation(a,o,true,true);var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.add(this,o);}var c=this.mAggregations[a];if(!c){c=this.mAggregations[a]=[o];}else{c.push(o);}o.setParent(this,a,s);return this;};h.prototype.removeAggregation=function(a,o,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.remove(this,o);}var c=this.mAggregations[a],l=null,i;if(!c){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(o)=="string"){for(i=0;i<c.length;i++){if(c[i]&&c[i].getId()===o){o=i;break;}}}if(typeof(o)=="object"){for(i=0;i<c.length;i++){if(c[i]==o){o=i;break;}}}if(typeof(o)=="number"){if(o<0||o>=c.length){q.sap.log.warning("ManagedObject.removeAggregation called with invalid index: "+a+", "+o);}else{l=c[o];c.splice(o,1);l.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return l;};h.prototype.removeAllAggregation=function(a,s){var o=this.getMetadata().getAggregationForwarder(a);if(o){return o.removeAll(this);}var c=this.mAggregations[a];if(!c){return[];}if(s){this.iSuppressInvalidate++;}delete this.mAggregations[a];for(var i=0;i<c.length;i++){c[i].setParent(null);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return c;};h.prototype.destroyAggregation=function(a,s){var o=this.getMetadata().getAggregationForwarder(a);if(o){return o.destroy(this);}var b=this.mAggregations[a],i,l;j(this.getId()).forEach(function(c){if(c.sParentAggregationName===a){c.destroy();}});if(!b){return this;}if(s){this.iSuppressInvalidate++;}delete this.mAggregations[a];if(b instanceof h){b.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",b);}}else if(Array.isArray(b)){for(i=b.length-1;i>=0;i--){l=b[i];if(l){l.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",l);}}}}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};h.prototype.invalidate=function(){if(this.oParent){this.oParent.invalidate(this);}};h.prototype.isInvalidateSuppressed=function(){var i=this.iSuppressInvalidate>0;if(this.oParent&&this.oParent instanceof h){i=i||this.oParent.isInvalidateSuppressed();}return i;};h.prototype._removeChild=function(c,a,s){if(!a){q.sap.log.error("Cannot remove aggregated child without aggregation name.",null,this);}else{if(s){this.iSuppressInvalidate++;}var i=this.indexOfAggregation(a,c);var A=this.getMetadata().getAggregation(a);if(i==-2){if(A&&this[A._sMutator]){this[A._sMutator](null);}else{this.setAggregation(a,null,s);}}else if(i>-1){if(A&&this[A._sRemoveMutator]){this[A._sRemoveMutator](i);}else{this.removeAggregation(a,i,s);}}if(s){this.iSuppressInvalidate--;}}};function k(a,b){while(a&&a!==b){a=a.oParent;}return!!a;}h.prototype.setParent=function(p,a,s){if(!p){if(this.oParent){if(this.oParent._observer){this.oParent._observer.aggregationChange(this.oParent,this.sParentAggregationName,"remove",this);}}this.oParent=null;this.sParentAggregationName=null;var o=h._oEmptyPropagatedProperties;if(o!==this.oPropagatedProperties){this.oPropagatedProperties=o;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange();}}.bind(this),0);}}this._oContextualSettings=h._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oParent){this._propagateContextualSettings();}}.bind(this),0);}q.sap.act.refresh();return;}if(k(p,this)){throw new Error("Cycle detected: new parent '"+p+"' is already a descendant of (or equal to) '"+this+"'");}if(s){q.sap.act.refresh();this.iSuppressInvalidate++;}var O=this.getParent();if(O){O._removeChild(this,this.sParentAggregationName);}this.oParent=p;this.sParentAggregationName=a;var o=p._getPropertiesToPropagate();if(o!==this.oPropagatedProperties){this.oPropagatedProperties=o;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);}this._callPropagationListener();this.fireModelContextChange();}this._applyContextualSettings(p._oContextualSettings);if(p&&!this.isInvalidateSuppressed()){p.invalidate(this);}if(s){this.iSuppressInvalidate--;}if(p._observer){p._observer.aggregationChange(p,a,"insert",this);}return this;};h.prototype._applyContextualSettings=function(c){if(this._oContextualSettings!==c){this._oContextualSettings=c;this._propagateContextualSettings();this._onContextualSettingsChanged();}};h.prototype._onContextualSettingsChanged=function(){};h.prototype._propagateContextualSettings=function(){var s=this._oContextualSettings,a,A,i;for(a in this.mAggregations){A=this.mAggregations[a];if(A instanceof h){A._applyContextualSettings(s);}else if(A instanceof Array){for(i=0;i<A.length;i++){if(A[i]instanceof h){A[i]._applyContextualSettings(s);}}}}};h.prototype._getContextualSettings=function(){return this._oContextualSettings;};h.prototype.getParent=function(){return this.oParent;};h.prototype.destroy=function(s){var t=this;this._bIsBeingDestroyed=true;if(s){this.iSuppressInvalidate++;}if(this.exit){this.exit();}if(this._exitCompositeSupport){this._exitCompositeSupport();}for(var a in this.mAggregations){this.destroyAggregation(a,s);}j(this.getId()).forEach(function(c){c.destroy();});if(this.deregister){this.deregister();}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,s);}delete this.oParent;q.each(this.mBindingInfos,function(n,b){if(b.factory){t.unbindAggregation(n,true);}else{t.unbindProperty(n,true);}});q.each(this.mObjectBindingInfos,function(n,b){t.unbindObject(n,true);});if(s){this.iSuppressInvalidate--;}if(this._observer){this._observer.objectDestroyed(this);}E.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+t.getId()+" was destroyed and cannot be used anymore.");};this.bIsDestroyed=true;};h.bindingParser=B.simpleParser;h.prototype.isBinding=function(v,K){return typeof this.extractBindingInfo(v)==="object";};h.prototype.extractBindingInfo=function(v,s){if(v&&typeof v==="object"){if(v.ui5object){delete v.ui5object;}else if(v.path!=undefined||v.parts){if(v.template){v.template=h.create(v.template);}return v;}}if(typeof v==="string"){return h.bindingParser(v,s,true);}};h.prototype.getBindingInfo=function(n){var o=this.getMetadata().getAggregationForwarder(n);if(o&&o.forwardBinding){return o.getTarget(this).getBindingInfo(o.targetAggregationName);}return this.mBindingInfos[n];};h.prototype.bindObject=function(b){var s,p,i;if(typeof b=="string"){p=b;b={path:p,parameters:arguments[1]};}else{p=b.path;}i=p.indexOf(">");if(i>0){b.model=p.substr(0,i);b.path=p.substr(i+1);}s=b.model;if(this.mObjectBindingInfos[s]){this.unbindObject(s,true);}this.mObjectBindingInfos[s]=b;if(this.getModel(s)){this._bindObject(b);}return this;};h.prototype._bindObject=function(b){var o,c,s,a,t=this;var i=function(l){t.setElementBindingContext(o.getBoundContext(),s);};s=b.model;a=this.getModel(s);c=this.getBindingContext(s);o=a.bindContext(b.path,c,b.parameters);if(b.suspended){o.suspend(true);}o.attachChange(i);b.binding=o;b.modelChangeHandler=i;o.attachEvents(b.events);o.initialize();};h.prototype.bindContext=function(p){return this.bindObject(p);};h.prototype.unbindContext=function(s){return this.unbindObject(s);};h.prototype.unbindObject=function(s,_){var b=this.mObjectBindingInfos[s];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachEvents(b.events);b.binding.destroy();}delete this.mObjectBindingInfos[s];delete this.mElementBindingContexts[s];if(!_){this.updateBindingContext(false,s);this.propagateProperties(s);this.fireModelContextChange();}}return this;};h.prototype.bindProperty=function(n,b,_,a){var s,A=true,p=this.getMetadata().getPropertyLikeSetting(n);if(!p){throw new Error("Property \""+n+"\" does not exist in "+this);}if(typeof b=="string"){b={parts:[{path:b,type:_ instanceof g?_:undefined,mode:a}],formatter:typeof _==='function'?_:undefined};}if(!b.parts){b.parts=[];b.parts[0]={path:b.path,targetType:b.targetType,type:b.type,suspended:b.suspended,formatOptions:b.formatOptions,constraints:b.constraints,model:b.model,mode:b.mode};delete b.path;delete b.targetType;delete b.mode;delete b.model;}for(var i=0;i<b.parts.length;i++){var o=b.parts[i];if(typeof o=="string"){o={path:o};b.parts[i]=o;}s=o.path.indexOf(">");if(s>0){o.model=o.path.substr(0,s);o.path=o.path.substr(s+1);}if(b.formatter&&o.mode!=d.OneWay&&o.mode!=d.OneTime){o.mode=d.OneWay;}if(!this.getModel(o.model)){A=false;}}if(this.isBound(n)){this.unbindProperty(n,true);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"property");}if(A){this._bindProperty(n,b);}return this;};h.prototype._bindProperty=function(n,b){var o,c,a,s,i=d.TwoWay,t,l,p=this.getMetadata().getPropertyLikeSetting(n),r=p._iKind===0?p.type:p.altTypes[0],u=this,v=[],w=function(y){u.updateProperty(n);var z=a.getDataState();if(z){var A=z.getControlMessages();if(A&&A.length>0){var G=sap.ui.getCore().getMessageManager();z.setControlMessages([]);if(A){G.removeMessages(A);}}z.setInvalidValue(undefined);}if(a.getBindingMode()===d.OneTime&&a.isResolved()){a.detachChange(w);a.detachEvents(b.events);a.destroy();}},x=function(){var y=a.getDataState();if(!y){return;}if(u.refreshDataState){u.refreshDataState(n,y);}};c=this.getBindingContext(b.model);b.parts.forEach(function(y){c=u.getBindingContext(y.model);o=u.getModel(y.model);t=y.type;if(typeof t=="string"){l=q.sap.getObject(t);if(typeof l!=="function"){throw new Error("Cannot find type \""+t+"\" used in control \""+u.getId()+"\"!");}t=new l(y.formatOptions,y.constraints);}a=o.bindProperty(y.path,c,b.parameters);a.setType(t,y.targetType||r);a.setFormatter(y.formatter);if(y.suspended){a.suspend(true);}s=y.mode||o.getDefaultBindingMode();a.setBindingMode(s);if(s!=d.TwoWay){i=d.OneWay;}v.push(a);});if(v.length>1||(b.formatter&&b.formatter.textFragments)){t=b.type;if(typeof t=="string"){l=q.sap.getObject(t);t=new l(b.formatOptions,b.constraints);}a=new C(v,b.useRawValues,b.useInternalValues);a.setType(t,b.targetType||r);a.setBindingMode(b.mode||i);}else{a=v[0];}a.attachChange(w);if(this.refreshDataState){a.attachAggregatedDataStateChange(x);}a.setFormatter(q.proxy(b.formatter,this));b.binding=a;b.modelChangeHandler=w;b.dataStateChangeHandler=x;a.attachEvents(b.events);a.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"property");}};h.prototype.unbindProperty=function(n,s){var b=this.mBindingInfos[n];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}b.binding.detachEvents(b.events);b.binding.destroy();}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"property");}delete this.mBindingInfos[n];if(!s){this.resetProperty(n);}}return this;};h.prototype.updateProperty=function(n){var b=this.mBindingInfos[n],o=b.binding,p=this.getMetadata().getPropertyLikeSetting(n);if(b.skipPropertyUpdate){return;}try{var v=o.getExternalValue();b.skipModelUpdate=true;this[p._sMutator](v);b.skipModelUpdate=false;}catch(a){b.skipModelUpdate=false;if(a instanceof F){this.fireFormatError({element:this,property:n,type:o.getType(),newValue:o.getValue(),oldValue:this[p._sGetter](),exception:a,message:a.message},false,true);b.skipModelUpdate=true;this.resetProperty(n);b.skipModelUpdate=false;}else{throw a;}}};h.prototype.updateModelProperty=function(n,v,o){if(this.isBound(n)){var b=this.mBindingInfos[n],a=b.binding;if(b.skipModelUpdate||(a&&a.isSuspended())){return;}if(a&&a.getBindingMode()==d.TwoWay){try{b.skipPropertyUpdate=true;a.setExternalValue(v);b.skipPropertyUpdate=false;var c=a.getExternalValue();if(v!=c){this.updateProperty(n);}if(a.hasValidation()){this.fireValidationSuccess({element:this,property:n,type:a.getType(),newValue:v,oldValue:o},false,true);}}catch(i){b.skipPropertyUpdate=false;if(i instanceof P){this.fireParseError({element:this,property:n,type:a.getType(),newValue:v,oldValue:o,exception:i,message:i.message},false,true);}else if(i instanceof V){this.fireValidationError({element:this,property:n,type:a.getType(),newValue:v,oldValue:o,exception:i,message:i.message},false,true);}else{throw i;}}}}};var m=1;h.prototype.bindAggregation=function(n,b){var p,t,s,a,o=this.getMetadata(),A=o.getAggregation(n);if(!A){throw new Error("Aggregation \""+n+"\" does not exist in "+this);}if(!A.multiple){q.sap.log.error("Binding of single aggregation \""+n+"\" of "+this+" is not supported!");}if(typeof b=="string"){p=arguments[1];t=arguments[2];s=arguments[3];a=arguments[4];b={path:p,sorter:s,filters:a};if(t instanceof h){b.template=t;}else if(typeof t==="function"){b.factory=t;}}var c=o.getAggregationForwarder(n);if(c&&c.forwardBinding){return c.getTarget(this).bindAggregation(c.targetAggregationName,b);}if(this.isBound(n)){this.unbindAggregation(n);}if(!(b.template||b.factory)){if(A._doesNotRequireFactory){b.factory=function(){throw new Error("dummy factory called unexpectedly ");};}else{throw new Error("Missing template or factory function for aggregation "+n+" of "+this+" !");}}if(b.template){if(b.template._sapui_candidateForDestroy){q.sap.log.warning("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+n+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete b.template._sapui_candidateForDestroy;}if(b.templateShareable===undefined){b.templateShareable=m;}b.factory=function(l){return b.template.clone(l);};}var i=b.path.indexOf(">");if(i>0){b.model=b.path.substr(0,i);b.path=b.path.substr(i+1);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"aggregation");}if(this.getModel(b.model)){this._bindAggregation(n,b);}return this;};h.prototype._bindAggregation=function(n,b){var t=this,o,a=function(l){var u="update"+n.substr(0,1).toUpperCase()+n.substr(1);if(t[u]){var s=l&&l.getParameter("reason");if(s){t[u](s);}else{t[u]();}}else{t.updateAggregation(n);}},c=function(l){var r="refresh"+n.substr(0,1).toUpperCase()+n.substr(1);if(t[r]){t[r](l.getParameter("reason"));}else{a(l);}};var i=this.getModel(b.model);if(this.isTreeBinding(n)){o=i.bindTree(b.path,this.getBindingContext(b.model),b.filters,b.parameters,b.sorter);}else{o=i.bindList(b.path,this.getBindingContext(b.model),b.sorter,b.filters,b.parameters);if(this.bUseExtendedChangeDetection){o.enableExtendedChangeDetection(!b.template,b.key);}}if(b.suspended){o.suspend(true);}b.binding=o;b.modelChangeHandler=a;b.modelRefreshHandler=c;o.attachChange(a);o.attachRefresh(c);o.attachEvents(b.events);o.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"aggregation");}};h.prototype.unbindAggregation=function(n,s){var o=this.getMetadata().getAggregationForwarder(n);if(o&&o.forwardBinding){return o.getTarget(this).unbindAggregation(o.targetAggregationName,s);}var b=this.mBindingInfos[n],a=this.getMetadata().getAggregation(n);if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachRefresh(b.modelRefreshHandler);b.binding.detachEvents(b.events);b.binding.destroy();}if(b.template){if(!b.templateShareable&&b.template.destroy){b.template.destroy();}if(b.templateShareable===m){b.template._sapui_candidateForDestroy=true;}}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"aggregation");}delete this.mBindingInfos[n];if(!s){this[a._sDestructor]();}}return this;};h.prototype.updateAggregation=function(n){var b=this.mBindingInfos[n],o=b.binding,a=b.factory,A=this.getMetadata().getAggregation(n),G,c,l,s=A._sMutator+"Group",t=this;function p(i,x){if(t.bUseExtendedChangeDetection){return M.uid('clone');}else{return i.getId()+"-"+x;}}function u(x,l,y,z){var H=x[A._sGetter]()||[],J,K;if(H.length>l.length){for(var i=l.length;i<H.length;i++){K=H[i];x[A._sRemoveMutator](K);K.destroy("KeepDom");}}for(var i=0;i<l.length;i++){J=l[i];K=H[i];if(y){y(J);}if(K){K.setBindingContext(J,b.model);}else{K=a(p(x,i),J);K.setBindingContext(J,b.model);x[A._sMutator](K);}if(z){z(J,K);}}}function r(x,l){var y=l.diff,z=x[A._sGetter]()||[],H,J,K,i;if(!y||z.length===0){u(x,l);return;}for(i=0;i<y.length;i++){H=y[i];switch(H.type){case"insert":K=l[H.index];J=a(p(x,H.index),K);J.setBindingContext(K,b.model);x[A._sInsertMutator](J,H.index);break;case"delete":J=x[A._sRemoveMutator](H.index);J.destroy("KeepDom");break;default:q.sap.log.error("Unknown diff type \""+H.type+"\"");}}z=x[A._sGetter]()||[];for(i=0;i<z.length;i++){z[i].setBindingContext(l[i]);}}function v(i){var N=o.getGroup(i);if(N.key!==G){var x;if(b.groupHeaderFactory){x=b.groupHeaderFactory(N);}t[s](N,x);G=N.key;}}function w(i,x){u(i,x,null,function(y,z){w(z,o.getNodeContexts(y));});}if(o instanceof L){l=o.getContexts(b.startIndex,b.length);c=o.isGrouped()&&t[s];if(c||o.bWasGrouped){this[A._sDestructor]();u(this,l,c?v:undefined);}else if(this.bUseExtendedChangeDetection){r(this,l);}else{if(!b.template){this[A._sDestructor]();}u(this,l);}o.bWasGrouped=c;}else if(o instanceof T){if(!b.template){this[A._sDestructor]();}w(this,o.getRootContexts());}};h.prototype.refreshAggregation=function(n){var b=this.mBindingInfos[n],o=b.binding;o.getContexts(b.startIndex,b.length);};h.prototype.propagateMessages=function(n,a){q.sap.log.warning("Message for "+this+", Property "+n);};h.prototype.isTreeBinding=function(n){return false;};h.prototype.updateBindings=function(u,s){var t=this,n,b;function a(b){var p=b.parts,i;if(p){if(p.length==1){return(u||p[0].model==s)&&!b.binding.updateRequired(t.getModel(p[0].model));}else{for(i=0;i<p.length;i++){if((u||p[i].model==s)&&!b.binding.aBindings[i].updateRequired(t.getModel(p[i].model))){return true;}}}}else{return(u||b.model==s)&&!b.binding.updateRequired(t.getModel(b.model));}}function c(b){var p=b.parts,i;if(p){for(i=0;i<p.length;i++){if(!t.getModel(p[i].model)){return false;}}return true;}else{return!!t.getModel(b.model);}}function r(b){if(t.refreshDataState){t.refreshDataState(n,b.binding.getDataState());}b.binding.detachChange(b.modelChangeHandler);if(b.modelRefreshHandler){b.binding.detachRefresh(b.modelRefreshHandler);}b.binding.detachEvents(b.events);b.binding.destroy();delete b.binding;delete b.modelChangeHandler;delete b.dataStateChangeHandler;delete b.modelRefreshHandler;}for(n in this.mObjectBindingInfos){b=this.mObjectBindingInfos[n];if(b.binding&&a(b)){r(b);}if(!b.binding&&c(b)){this._bindObject(b);}}for(n in this.mBindingInfos){b=this.mBindingInfos[n];if(b.binding&&a(b)){if(this._observer){var l=b.factory?"aggregation":"property";this._observer.bindingChange(this,n,"remove",b,l);}r(b);}if(!b.binding&&c(b)){if(b.factory){this._bindAggregation(n,b);}else{this._bindProperty(n,b);}}}};h.prototype.isBound=function(n){return!!this.getBindingInfo(n);};h.prototype.getObjectBinding=function(s){return this.mObjectBindingInfos[s]&&this.mObjectBindingInfos[s].binding;};h.prototype.getEventingParent=function(){return this.oParent;};h.prototype.getBinding=function(n){var i=this.getBindingInfo(n);return i&&i.binding;};h.prototype.getBindingPath=function(n){var i=this.getBindingInfo(n);return i&&(i.path||(i.parts&&i.parts[0]&&i.parts[0].path));};h.prototype.setBindingContext=function(c,s){var o=this.oBindingContexts[s];if(e.hasChanged(o,c)){if(c===undefined){delete this.oBindingContexts[s];}else{this.oBindingContexts[s]=c;}this.updateBindingContext(false,s);this.propagateProperties(s);this.fireModelContextChange();}return this;};h.prototype.setElementBindingContext=function(c,s){var o=this.mElementBindingContexts[s];if(e.hasChanged(o,c)){if(c===undefined){delete this.mElementBindingContexts[s];}else{this.mElementBindingContexts[s]=c;}this.updateBindingContext(true,s);this.propagateProperties(s);this.fireModelContextChange();}return this;};h.prototype.updateBindingContext=function(s,a,u){var o,b={},c,l,n,p,i;if(u){for(c in this.oModels){if(this.oModels.hasOwnProperty(c)){b[c]=c;}}for(c in this.oPropagatedProperties.oModels){if(this.oPropagatedProperties.oModels.hasOwnProperty(c)){b[c]=c;}}}else{b[a]=a;}for(c in b){if(b.hasOwnProperty(c)){c=c==="undefined"?undefined:c;o=this.getModel(c);p=this.mObjectBindingInfos[c];if(o&&p&&!s){if(!p.binding){this._bindObject(p);}else{l=this._getBindingContext(c);if(e.hasChanged(p.binding.getContext(),l)){p.binding.setContext(l);}}continue;}l=this.getBindingContext(c);for(n in this.mBindingInfos){var p=this.mBindingInfos[n],r=p.binding,t=p.parts;if(!r){continue;}if(t&&t.length>1){for(i=0;i<t.length;i++){if(t[i].model==c){r.aBindings[i].setContext(l);}}}else if(p.factory){if(p.model==c){r.setContext(l);}}else{if(t[0].model==c){r.setContext(l);}}}}}};h.prototype.getBindingContext=function(s){var o=this.getModel(s),a=this.mElementBindingContexts[s];if(a&&!o){return a;}else if(a&&o&&a.getModel()===o){return a;}else if(a===null){return a;}else{return this._getBindingContext(s);}};h.prototype._getBindingContext=function(s){var o=this.getModel(s),c=this.oBindingContexts[s],p=this.oPropagatedProperties.oBindingContexts[s];if(c&&!o){return this.oBindingContexts[s];}else if(c&&o&&c.getModel()===o){return this.oBindingContexts[s];}else if(c===null){return c;}else if(p&&o&&p.getModel()!==o){return undefined;}else{return p;}};h.prototype.setModel=function(o,n){if(!o&&this.oModels[n]){delete this.oModels[n];this.propagateProperties(n);this.updateBindings(false,n);this.fireModelContextChange();}else if(o&&o!==this.oModels[n]){this.oModels[n]=o;this.propagateProperties(n);this.updateBindingContext(false,n);this.updateBindings(false,n);this.fireModelContextChange();}return this;};h.prototype.addPropagationListener=function(l){this.aPropagationListeners.push(l);this.propagateProperties(false);this._callPropagationListener(l);return this;};h.prototype.removePropagationListener=function(l){var a=this.aPropagationListeners;var i=a.indexOf(l);if(i>=0){a.splice(i,1);this.propagateProperties(false);}return this;};h.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners);};h.prototype._callPropagationListener=function(l){var a;if(l){l(this);}else{a=this.getPropagationListeners();for(var i=0;i<a.length;i++){l=a[i];l(this);}}return this;};h._oEmptyPropagatedProperties={oModels:{},oBindingContexts:{},aPropagationListeners:[]};h.prototype.propagateProperties=function(n){var p=this._getPropertiesToPropagate(),u=n===true,U=n===false,N=u?undefined:n,a,A,i;for(a in this.mAggregations){if(this.mSkipPropagation[a]){continue;}A=this.mAggregations[a];if(A instanceof h){this._propagateProperties(n,A,p,u,N,U);}else if(A instanceof Array){for(i=0;i<A.length;i++){if(A[i]instanceof h){this._propagateProperties(n,A[i],p,u,N,U);}}}}};h.prototype._propagateProperties=function(n,o,p,u,N,U){if(!p){p=this._getPropertiesToPropagate();u=n===true;U=n===false;N=u?undefined:n;}if(o.oPropagatedProperties!==p){o.oPropagatedProperties=p;if(U!==true){o.updateBindings(u,N);o.updateBindingContext(false,N,u);}o.propagateProperties(n);if(U||u){o._callPropagationListener();}o.fireModelContextChange();}};h.prototype._getPropertiesToPropagate=function(){var n=q.isEmptyObject(this.oModels),N=q.isEmptyObject(this.oBindingContexts),b=this.aPropagationListeners.length===0,a=q.isEmptyObject(this.mElementBindingContexts);function c(l,o,p,r){return l?o:q.extend({},o,p,r);}function i(l,o,p){return l?o:o.concat(p);}if(N&&n&&a&&b){return this.oPropagatedProperties;}else{return{oModels:c(n,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:c((N&&a),this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:i(b,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)};}};h.prototype.getModel=function(s){return this.oModels[s]||this.oPropagatedProperties.oModels[s];};h.prototype.hasModel=function(){return!(q.isEmptyObject(this.oModels)&&q.isEmptyObject(this.oPropagatedProperties.oModels));};h.prototype.clone=function(s,a,o){var c=true,b=true;if(o){c=!!o.cloneChildren;b=!!o.cloneBindings;}if(!s){s=M.uid("clone")||q.sap.uid();}if(!a&&c){a=this.findAggregatedObjects(true).map(function(O){return O.getId();});}var n=this.getMetadata(),p=n._oClass,r=this.getId()+"-"+s,t={},u=this.mProperties,K,N,v,w=h.bindingParser.escape,i;var x=Object.keys(u);i=x.length;while(i>0){K=x[--i];if(!(this.isBound(K)&&b)){if(typeof u[K]==="string"){t[K]=w(u[K]);}else{t[K]=u[K];}}}t["models"]=this.oModels;t["bindingContexts"]=this.oBindingContexts;if(c){for(N in this.mAggregations){var A=this.mAggregations[N];if(n.hasAggregation(N)&&!(this.isBound(N)&&b)){if(A instanceof h){t[N]=A.clone(s,a);}else if(Array.isArray(A)){t[N]=[];for(var i=0;i<A.length;i++){t[N].push(A[i].clone(s,a));}}else{t[N]=A;}}}var y=j(this.getId());for(var i=0,l=y.length;i<l;i++){var z=y[i].clone(s);z.sParentId=r;z.sParentAggregationName=y[i].sParentAggregationName;}for(N in this.mAssociations){var G=this.mAssociations[N];if(Array.isArray(G)){G=G.slice(0);for(var i=0;i<G.length;i++){if(a.indexOf(G[i])>=0){G[i]+="-"+s;}}}else if(a.indexOf(G)>=0){G+="-"+s;}t[N]=G;}}v=new p(r,t);for(N in this.mObjectBindingInfos){v.mObjectBindingInfos[N]=q.extend({},this.mObjectBindingInfos[N]);}for(N in this.mEventRegistry){v.mEventRegistry[N]=this.mEventRegistry[N].slice();}if(b){for(N in this.mBindingInfos){var H=this.mBindingInfos[N];var J=q.extend({},H);if(!H.templateShareable&&H.template&&H.template.clone){J.template=H.template.clone(s,a);delete J.factory;}else if(H.templateShareable===m){H.templateShareable=J.templateShareable=true;q.sap.log.error("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+N+"' of object '"+this.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.");}delete J.binding;delete J.modelChangeHandler;delete J.dataStateChangeHandler;delete J.modelRefreshHandler;if(H.factory||H.template){v.bindAggregation(N,J);}else{v.bindProperty(N,J);}}}if(h._supportInfo){h._supportInfo.addSupportInfo(v.getId(),h._supportInfo.byId(this.getId()));}if(this._cloneMetadataContexts){this._cloneMetadataContexts(v);}return v;};h._handleLocalizationChange=function(p){var i;if(p===1){q.each(this.oModels,function(n,o){if(o&&o._handleLocalizationChange){o._handleLocalizationChange();}});}else if(p===2){q.each(this.mBindingInfos,function(n,b){var a=b.parts;if(a){for(i=0;i<a.length;i++){if(b.type&&b.type._handleLocalizationChange){b.type._handleLocalizationChange();}}if(b.modelChangeHandler){b.modelChangeHandler();}}});}};h.prototype.findAggregatedObjects=function(r,c){var A=[];if(c&&typeof c!=="function"){c=null;}function b(o){var a,i,n;for(n in o.mAggregations){a=o.mAggregations[n];if(Array.isArray(a)){for(i=0;i<a.length;i++){if(!c||c(a[i])){A.push(a[i]);}if(r){b(a[i]);}}}else if(a instanceof h){if(!c||c(a)){A.push(a);}if(r){b(a);}}}}b(this);return A;};h._defaultContextualSettings={};return h;});
