/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','./Manifest','./ComponentMetadata','./Core','sap/ui/thirdparty/URI','jquery.sap.trace'],function(q,M,a,C,b,U){"use strict";var V={JSON:"JSON",XML:"XML",HTML:"HTML",JS:"JS",Template:"Template"};function c(u){['sap-client','sap-server'].forEach(function(N){if(!u.hasSearch(N)){var v=sap.ui.getCore().getConfiguration().getSAPParam(N);if(v){u.addSearch(N,v);}}});}function d(D,m,s,S){if(s){for(var N in D){if(!m[N]&&s[N]&&s[N].uri){m[N]=S;}}}}function g(m,o,K,e){var D=o.getEntry(K);if(D!==undefined&&!q.isPlainObject(D)){return D;}var p,P;if(e&&(p=m.getParent())instanceof C){P=p.getManifestEntry(K,e);}if(P||D){D=q.extend(true,{},P,D);}return D;}function f(o,e){var i=Object.create(Object.getPrototypeOf(o));i._oMetadata=o;i._oManifest=e;for(var m in o){if(!/^(getManifest|getManifestObject|getManifestEntry|getMetadataVersion)$/.test(m)&&typeof o[m]==="function"){i[m]=o[m].bind(o);}}i.getManifest=function(){return e&&e.getJson();};i.getManifestObject=function(){return e;};i.getManifestEntry=function(K,p){return g(o,e,K,p);};i.getMetadataVersion=function(){return 2;};return i;}function r(e,o,t){var i=M._sOwnerId;try{M._sOwnerId=o;return e.call(t);}finally{M._sOwnerId=i;}}var h=M.extend("sap.ui.core.Component",{constructor:function(i,s){var e=Array.prototype.slice.call(arguments);if(typeof i!=="string"){s=i;i=undefined;}if(s&&typeof s._metadataProxy==="object"){this._oMetadataProxy=s._metadataProxy;this._oManifest=s._metadataProxy._oManifest;delete s._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy;};}if(s&&typeof s._cacheTokens==="object"){this._mCacheTokens=s._cacheTokens;delete s._cacheTokens;}if(s&&typeof s._manifestModels==="object"){this._mManifestModels=s._manifestModels;delete s._manifestModels;}else{this._mManifestModels={};}this._mServices={};M.apply(this,e);},metadata:{stereotype:"component","abstract":true,specialSettings:{componentData:'any'},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},C);h.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata().getManifest();}else{return this._oManifest.getJson();}};h.prototype.getManifestEntry=function(K){return this._getManifestEntry(K);};h.prototype._getManifestEntry=function(K,m){if(!this._oManifest){return this.getMetadata().getManifestEntry(K,m);}else{return g(this.getMetadata(),this._oManifest,K,m);}};h.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject();}else{return this._oManifest;}};h.prototype._isVariant=function(){if(this._oManifest){var m=this._oMetadataProxy._oMetadata.getManifestEntry("/sap.app/id");return m!==this.getManifestEntry("/sap.app/id");}else{return false;}};h.activateCustomizing=function(s){};h.deactivateCustomizing=function(s){};h.getOwnerIdFor=function(o){var O=(o instanceof M)&&o._sOwnerId;return O||undefined;};h.getOwnerComponentFor=function(o){var O=h.getOwnerIdFor(o);return O&&sap.ui.component(O);};h.prototype.runAsOwner=function(e){return r(e,this.getId());};h.prototype.getInterface=function(){return this;};h.prototype._initCompositeSupport=function(s){this.oComponentData=s&&s.componentData;if(!this._isVariant()){this.getMetadata().init();}else{this._oManifest.init(this);}this.initComponentModels();if(this.onWindowError){this._fnWindowErrorHandler=q.proxy(function(e){var E=e.originalEvent;this.onWindowError(E.message,E.filename,E.lineno);},this);q(window).bind("error",this._fnWindowErrorHandler);}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=q.proxy(this.onWindowBeforeUnload,this);q(window).bind("beforeunload",this._fnWindowBeforeUnloadHandler);}if(this.onWindowUnload){this._fnWindowUnloadHandler=q.proxy(this.onWindowUnload,this);q(window).bind("unload",this._fnWindowUnloadHandler);}};h.prototype.destroy=function(){for(var L in this._mServices){if(this._mServices[L].instance){this._mServices[L].instance.destroy();}}delete this._mServices;for(var m in this._mManifestModels){this._mManifestModels[m].destroy();}delete this._mManifestModels;if(this._fnWindowErrorHandler){q(window).unbind("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler;}if(this._fnWindowBeforeUnloadHandler){q(window).unbind("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler;}if(this._fnWindowUnloadHandler){q(window).unbind("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler;}if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus;}M.prototype.destroy.apply(this,arguments);sap.ui.getCore().getMessageManager().unregisterObject(this);if(!this._isVariant()){this.getMetadata().exit();}else{this._oManifest.exit(this);delete this._oManifest;}};h.prototype.getComponentData=function(){return this.oComponentData;};h.prototype.getEventBus=function(){if(!this._oEventBus){var E=sap.ui.requireSync("sap/ui/core/EventBus");this._oEventBus=new E();}return this._oEventBus;};h.prototype.initComponentModels=function(){var m=this.getMetadata();if(m.isBaseClass()){return;}var o=this._getManifestEntry("/sap.app/dataSources",true)||{};var e=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(e,o,this._mCacheTokens);};h.prototype._initComponentModels=function(m,D,e){var A=h._createManifestModelConfigurations({models:m,dataSources:D,component:this,mergeParent:true,cacheTokens:e});if(!A){return;}var i={};for(var s in A){if(!this._mManifestModels[s]){i[s]=A[s];}}var o=h._createManifestModels(i,this.toString());for(var s in o){this._mManifestModels[s]=o[s];}for(var s in this._mManifestModels){var p=this._mManifestModels[s];this.setModel(p,s||undefined);}};h.prototype.getService=function(L){if(!this._mServices[L]){this._mServices[L]={};this._mServices[L].promise=new Promise(function(R,e){sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(S){var s=this.getManifestEntry("/sap.ui5/services/"+L);var i=s.factoryName;if(!i){e(new Error("Service "+L+" not declared!"));return;}var o=S.get(i);if(o){o.createInstance({scopeObject:this,scopeType:"component",settings:s.settings||{}}).then(function(m){if(!this.bIsDestroyed){this._mServices[L].instance=m;this._mServices[L].interface=m.getInterface();R(this._mServices[L].interface);}else{e(new Error("Service "+L+" could not be loaded as its Component was destroyed."));}}.bind(this)).catch(e);}else{var E="The ServiceFactory "+i+" for Service "+L+" not found in ServiceFactoryRegistry!";var O=this.getManifestEntry("/sap.ui5/services/"+L+"/optional");if(!O){q.sap.log.error(E);}e(new Error(E));}}.bind(this));}.bind(this));}return this._mServices[L].promise;};function j(o){var s=o.getManifestEntry("/sap.ui5/services");for(var S in s){if(s[S].lazy===false){o.getService(S);}}}h.prototype.createComponent=function(u){var m={async:true};if(u&&typeof u==="object"){m.usage=u.usage;["id","async","settings","componentData"].forEach(function(N){if(u[N]!==undefined){m[N]=u[N];}});}else if(typeof u==="string"){m.usage=u;}return this._createComponent(m);};h.prototype._createComponent=function(m){if(m&&m.usage){var u=m.usage;var e=this.getManifestEntry("/sap.ui5/componentUsages/"+u);if(!e){throw new Error("Component usage \""+u+"\" not declared in Component \""+this.getManifestObject().getComponentName()+"\"!");}m=q.extend(true,e,m);}return this.runAsOwner(function(){return sap.ui.component(m);});};h._createManifestModelConfigurations=function(o){var e=o.component;var m=o.manifest||e.getManifestObject();var p=o.mergeParent;var s=o.cacheTokens||{};var L=e?e.toString():m.getComponentName();var t=sap.ui.getCore().getConfiguration();if(!o.models){return null;}var u={models:o.models,dataSources:o.dataSources||{},origin:{dataSources:{},models:{}}};if(e&&p){var v=e.getMetadata();while(v instanceof C){var w=v.getManifestObject();var x=v.getManifestEntry("/sap.app/dataSources");d(u.dataSources,u.origin.dataSources,x,w);var y=v.getManifestEntry("/sap.ui5/models");d(u.models,u.origin.models,y,w);v=v.getParent();}}var z={};for(var A in u.models){var B=u.models[A];var I=false;var D=null;if(typeof B==='string'){B={dataSource:B};}if(B.dataSource){var E=u.dataSources&&u.dataSources[B.dataSource];if(typeof E==='object'){if(E.type===undefined){E.type='OData';}if(!B.type){switch(E.type){case'OData':if(E.settings&&E.settings.odataVersion==="4.0"){B.type='sap.ui.model.odata.v4.ODataModel';}else{B.type='sap.ui.model.odata.v2.ODataModel';}break;case'JSON':B.type='sap.ui.model.json.JSONModel';break;case'XML':B.type='sap.ui.model.xml.XMLModel';break;default:}}if(B.type==='sap.ui.model.odata.v4.ODataModel'&&E.settings&&E.settings.odataVersion){B.settings=B.settings||{};B.settings.odataVersion=E.settings.odataVersion;}if(!B.uri){B.uri=E.uri;I=true;}if(E.type==='OData'&&E.settings&&typeof E.settings.maxAge==="number"){B.settings=B.settings||{};B.settings.headers=B.settings.headers||{};B.settings.headers["Cache-Control"]="max-age="+E.settings.maxAge;}if(E.type==='OData'&&E.settings&&E.settings.annotations){var F=E.settings.annotations;for(var i=0;i<F.length;i++){var G=u.dataSources[F[i]];if(!G){q.sap.log.error("Component Manifest: ODataAnnotation \""+F[i]+"\" for dataSource \""+B.dataSource+"\" could not be found in manifest","[\"sap.app\"][\"dataSources\"][\""+F[i]+"\"]",L);continue;}if(G.type!=='ODataAnnotation'){q.sap.log.error("Component Manifest: dataSource \""+F[i]+"\" was expected to have type \"ODataAnnotation\" but was \""+G.type+"\"","[\"sap.app\"][\"dataSources\"][\""+F[i]+"\"]",L);continue;}if(!G.uri){q.sap.log.error("Component Manifest: Missing \"uri\" for ODataAnnotation \""+F[i]+"\"","[\"sap.app\"][\"dataSources\"][\""+F[i]+"\"]",L);continue;}var H=new U(G.uri);if(B.type==='sap.ui.model.odata.v2.ODataModel'){["sap-language","sap-client"].forEach(function($){if(!H.hasQuery($)&&t.getSAPParam($)){H.setQuery($,t.getSAPParam($));}});var J=s.dataSources&&s.dataSources[G.uri];if(J){var K=function(){if(!H.hasQuery("sap-language")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+J+"\" for ODataAnnotation \""+F[i]+"\" ("+H.toString()+"). "+"Missing \"sap-language\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+F[i]+"\"]",L);return;}if(!H.hasQuery("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+J+"\" for ODataAnnotation \""+F[i]+"\" ("+H.toString()+"). "+"Missing \"sap-client\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+F[i]+"\"]",L);return;}if(!H.hasQuery("sap-client",t.getSAPParam("sap-client"))){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+J+"\" for ODataAnnotation \""+F[i]+"\" ("+H.toString()+"). "+"URI parameter \"sap-client="+H.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+t.getSAPParam("sap-client")+"\"","[\"sap.app\"][\"dataSources\"][\""+F[i]+"\"]",L);return;}if(H.hasQuery("sap-context-token")&&!H.hasQuery("sap-context-token",J)){var $=H.query(true)["sap-context-token"];q.sap.log.warning("Component Manifest: Overriding existing \"sap-context-token="+$+"\" with provided value \""+J+"\" for ODataAnnotation \""+F[i]+"\" ("+H.toString()+").","[\"sap.app\"][\"dataSources\"][\""+F[i]+"\"]",L);}H.setQuery("sap-context-token",J);};K();}}var N=u.origin.dataSources[F[i]]||m;var O=N.resolveUri(H).toString();B.settings=B.settings||{};B.settings.annotationURI=B.settings.annotationURI||[];B.settings.annotationURI.push(O);}}}else{q.sap.log.error("Component Manifest: dataSource \""+B.dataSource+"\" for model \""+A+"\" not found or invalid","[\"sap.app\"][\"dataSources\"][\""+B.dataSource+"\"]",L);}}if(!B.type){q.sap.log.error("Component Manifest: Missing \"type\" for model \""+A+"\"","[\"sap.ui5\"][\"models\"][\""+A+"\"]",L);continue;}if(B.type==='sap.ui.model.odata.ODataModel'&&(!B.settings||B.settings.json===undefined)){B.settings=B.settings||{};B.settings.json=true;}if(B.uri){var P=new U(B.uri);var Q=(I?u.origin.dataSources[B.dataSource]:u.origin.models[A])||m;P=Q.resolveUri(P);if(B.dataSource){c(P);if(B.type==='sap.ui.model.odata.v2.ODataModel'){D=B.settings&&B.settings.metadataUrlParams;if((!D||typeof D['sap-language']==='undefined')&&!P.hasQuery('sap-language')&&t.getSAPParam('sap-language')){B.settings=B.settings||{};D=B.settings.metadataUrlParams=B.settings.metadataUrlParams||{};D['sap-language']=t.getSAPParam('sap-language');}if(s.dataSources){var J=s.dataSources[E.uri];if(J){var R=function(){if(P.hasQuery("sap-context-token")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+J+"\" for model \""+A+"\" ("+P.toString()+"). "+"Model URI already contains parameter \"sap-context-token="+P.query(true)["sap-context-token"]+"\"","[\"sap.ui5\"][\"models\"][\""+A+"\"]",L);return;}if((!D||typeof D["sap-language"]==="undefined")&&!P.hasQuery("sap-language")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+J+"\" for model \""+A+"\" ("+P.toString()+"). "+"Missing \"sap-language\" parameter","[\"sap.ui5\"][\"models\"][\""+A+"\"]",L);return;}if(!P.hasQuery("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+J+"\" for model \""+A+"\" ("+P.toString()+"). "+"Missing \"sap-client\" parameter","[\"sap.ui5\"][\"models\"][\""+A+"\"]",L);return;}if(!P.hasQuery("sap-client",t.getSAPParam("sap-client"))){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+J+"\" for model \""+A+"\" ("+P.toString()+"). "+"URI parameter \"sap-client="+P.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+t.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+A+"\"]",L);return;}if(D&&typeof D["sap-client"]!=="undefined"){if(D["sap-client"]!==t.getSAPParam("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+J+"\" for model \""+A+"\" ("+P.toString()+"). "+"Parameter metadataUrlParams[\"sap-client\"] = \""+D["sap-client"]+"\" must be identical with configuration \"sap-client="+t.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+A+"\"]",L);return;}}if(D&&D["sap-context-token"]&&D["sap-context-token"]!==J){q.sap.log.warning("Component Manifest: Overriding existing \"sap-context-token="+D["sap-context-token"]+"\" with provided value \""+J+"\" for model \""+A+"\" ("+P.toString()+").","[\"sap.ui5\"][\"models\"][\""+A+"\"]",L);}if(!D){B.settings=B.settings||{};D=B.settings.metadataUrlParams=B.settings.metadataUrlParams||{};}D["sap-context-token"]=J;};R();}}}}B.uri=P.toString();}if(B.uriSettingName===undefined){switch(B.type){case'sap.ui.model.odata.ODataModel':case'sap.ui.model.odata.v2.ODataModel':case'sap.ui.model.odata.v4.ODataModel':B.uriSettingName='serviceUrl';break;case'sap.ui.model.resource.ResourceModel':B.uriSettingName='bundleUrl';break;default:}}var S;var T;if(e){T=e.getComponentData();}else{T=o.componentData;}S=T&&T.startupParameters&&T.startupParameters["sap-system"];if(!S){S=t.getSAPParam("sap-system");}var W=false;var X;if(S&&["sap.ui.model.odata.ODataModel","sap.ui.model.odata.v2.ODataModel"].indexOf(B.type)!=-1){W=true;X=sap.ui.requireSync("sap/ui/model/odata/ODataUtils");}if(B.uri){if(W){B.preOriginBaseUri=B.uri.split("?")[0];B.uri=X.setOrigin(B.uri,{alias:S});B.postOriginBaseUri=B.uri.split("?")[0];}if(B.uriSettingName!==undefined){B.settings=B.settings||{};if(!B.settings[B.uriSettingName]){B.settings[B.uriSettingName]=B.uri;}}else if(B.settings){B.settings=[B.uri,B.settings];}else{B.settings=[B.uri];}}else{if(W&&B.uriSettingName!==undefined&&B.settings&&B.settings[B.uriSettingName]){B.preOriginBaseUri=B.settings[B.uriSettingName].split("?")[0];B.settings[B.uriSettingName]=X.setOrigin(B.settings[B.uriSettingName],{alias:S});B.postOriginUri=B.settings[B.uriSettingName].split("?")[0];}}if(W&&B.settings&&B.settings.annotationURI){var Y=[].concat(B.settings.annotationURI);var Z=[];for(var i=0;i<Y.length;i++){Z.push(X.setAnnotationOrigin(Y[i],{alias:S,preOriginBaseUri:B.preOriginBaseUri,postOriginBaseUri:B.postOriginBaseUri}));}B.settings.annotationURI=Z;}if(B.settings&&!Array.isArray(B.settings)){B.settings=[B.settings];}z[A]=B;}return z;};h._createManifestModels=function(m,L){var e={};for(var s in m){var o=m[s];try{q.sap.require(o.type);}catch(E){q.sap.log.error("Component Manifest: Class \""+o.type+"\" for model \""+s+"\" could not be loaded. "+E,"[\"sap.ui5\"][\"models\"][\""+s+"\"]",L);continue;}var i=q.sap.getObject(o.type);if(!i){q.sap.log.error("Component Manifest: Class \""+o.type+"\" for model \""+s+"\" could not be found","[\"sap.ui5\"][\"models\"][\""+s+"\"]",L);continue;}var A=[null].concat(o.settings||[]);var F=i.bind.apply(i,A);var p=new F();e[s]=p;}return e;};function k(m,o,e){var i={afterManifest:{},afterPreload:{}};var p=q.extend(true,{},m.getEntry("/sap.app/dataSources"));var s=q.extend(true,{},m.getEntry("/sap.ui5/models"));var A=h._createManifestModelConfigurations({models:s,dataSources:p,manifest:m,componentData:o,cacheTokens:e});var P=q.sap.getUriParameters().get("sap-ui-xx-preload-component-models-"+m.getComponentName());var t=P&&P.split(",");for(var u in A){var v=A[u];if(!v.preload&&t&&t.indexOf(u)>-1){v.preload=true;q.sap.log.warning("FOR TESTING ONLY!!! Activating preload for model \""+u+"\" ("+v.type+")",m.getComponentName(),"sap.ui.core.Component");}if(v.type==="sap.ui.model.resource.ResourceModel"&&Array.isArray(v.settings)&&v.settings.length>0&&v.settings[0].async!==true){i.afterPreload[u]=v;}else if(v.preload){if(q.sap.isDeclared(v.type,true)){i.afterManifest[u]=v;}else{q.sap.log.warning("Can not preload model \""+u+"\" as required class has not been loaded: \""+v.type+"\"",m.getComponentName(),"sap.ui.core.Component");}}}return i;}function l(R,o){var m=[];var e=[];function p(i,s){if(!i._oManifest){var N=i.getComponentName();var D=q.sap.getModulePath(N,"/manifest.json");var t;if(s){t=Promise.resolve(JSON.parse(JSON.stringify(s.getRawJson())));}else{t=q.sap.loadResource({url:D,dataType:"json",async:true}).catch(function(E){q.sap.log.error("Failed to load component manifest from \""+D+"\" (component "+N+")! Reason: "+E);return{};});}m.push(t);e.push(i);}var P=i.getParent();if(P&&(P instanceof C)&&!P.isBaseClass()){p(P);}}p(R,o);return Promise.all(m).then(function(s){for(var i=0;i<s.length;i++){if(s[i]){e[i]._applyManifest(s[i]);}}});}h._fnLoadComponentCallback=null;h._fnOnInstanceCreated=null;sap.ui.component=function(v){if(!v){throw new Error("sap.ui.component cannot be called without parameter!");}if(typeof v==='string'){return sap.ui.getCore().getComponent(v);}function e(o){var N=v.name,I=v.id,m=v.componentData,p=N+'.Component',S=v.settings;var t=new o(q.extend({},S,{id:I,componentData:m,_cacheTokens:v.asyncHints&&v.asyncHints.cacheTokens}));q.sap.log.info("Component instance Id = "+t.getId());var H=t.getMetadata().handleValidation()!==undefined||v.handleValidation;if(H){if(t.getMetadata().handleValidation()!==undefined){H=t.getMetadata().handleValidation();}else{H=v.handleValidation;}sap.ui.getCore().getMessageManager().registerObject(t,H);}j(t);if(typeof h._fnOnInstanceCreated==="function"){var P=h._fnOnInstanceCreated(t,v);if(v.async&&P instanceof Promise){return P.then(function(){return t;});}}return t;}var i=n(v,{failOnError:true,createModels:true,waitFor:v.asyncHints&&v.asyncHints.waitFor});if(v.async){var s=M._sOwnerId;return i.then(function(o){return r(function(){return e(o);},s);});}else{return e(i);}};sap.ui.component.load=function(o,F){return n(o,{failOnError:F,preloadOnly:o.asyncHints&&o.asyncHints.preloadOnly});};function n(o,O){var N=o.name,u=o.url,m=sap.ui.getCore().getConfiguration(),p=/^(sync|async)$/.test(m.getComponentPreload()),s=o.manifest,t,w,x,y,z,A;function B(e){var x=new a(JSON.parse(JSON.stringify(e)));return o.async?Promise.resolve(x):x;}if(s===undefined){t=o.manifestFirst===undefined?m.getManifestFirst():!!o.manifestFirst;w=o.manifestUrl;}else{if(o.async===undefined){o.async=true;}t=!!s;w=s&&typeof s==='string'?s:undefined;x=s&&typeof s==='object'?B(s):undefined;}q.sap.interaction.setStepComponent(N);if(!x&&w){x=a.load({manifestUrl:w,componentName:N,async:o.async});}if(x&&!o.async){N=x.getComponentName();}if(!(x&&o.async)){if(!N){throw new Error("The name of the component is undefined.");}}if(N&&u){q.sap.registerModulePath(N,u);}if(t&&!x){x=a.load({manifestUrl:q.sap.getModulePath(N,"/manifest.json"),componentName:N,async:o.async,failOnError:false});}function D(){return q.sap.getResourceName(N+".Component","");}function E(e){var i=N+'.Component';if(!e){var v="The specified component controller '"+i+"' could not be found!";if(O.failOnError){throw new Error(v);}else{q.sap.log.warning(v);}}if(x){var S=f(e.getMetadata(),x);var T=function(){var W=Array.prototype.slice.call(arguments);var X;if(W.length===0||typeof W[0]==="object"){X=W[0]=W[0]||{};}else if(typeof W[0]==="string"){X=W[1]=W[1]||{};}X._metadataProxy=S;if(y){X._manifestModels=y;}var Y=Object.create(e.prototype);e.apply(Y,W);return Y;};T.getMetadata=function(){return S;};T.extend=function(){throw new Error("Extending Components created by Manifest is not supported!");};return T;}else{return e;}}function F(v,i){if(typeof v==='object'){if(v.url){q.sap.registerModulePath(v.name,v.url);}return(v.lazy&&i!==true)?undefined:v.name;}return v;}function G(i,v){var S=i+'.Component',T=sap.ui.getCore().getConfiguration().getDepCache(),W;if(p&&i!=null&&!q.sap.isDeclared(S,true)){if(v){W=q.sap.getResourceName(S,T?'-h2-preload.js':'-preload.js');return q.sap._loadJSResourceAsync(W,true);}try{W=S+'-preload';q.sap.require(W);}catch(e){q.sap.log.warning("couldn't preload component from "+W+": "+((e&&e.message)||e));}}else if(v){return Promise.resolve();}}function H(e,x,i){var v=[];var S=i?function($){v.push($);}:q.noop;x.defineResourceRoots();var T=x.getEntry("/sap.ui5/dependencies/libs");if(T){var W=[];for(var X in T){if(!T[X].lazy){W.push(X);}}if(W.length>0){q.sap.log.info("Component \""+e+"\" is loading libraries: \""+W.join(", ")+"\"");S(sap.ui.getCore().loadLibraries(W,{async:i}));}}var Y=x.getEntry("/sap.ui5/extends/component");if(Y){S(G(Y,i));}var Z=x.getEntry("/sap.ui5/dependencies/components");if(Z){for(var e in Z){if(!Z[e].lazy){S(G(e,i));}}}return i?Promise.all(v):undefined;}if(o.async){var I=o.asyncHints||{},J=[],K=function(e){e=e.then(function(v){return{result:v,rejected:false};},function(v){return{result:v,rejected:true};});return e;},L=function(e){if(e){J.push(K(e));}},P=function($){return $;},Q,R;if(x&&O.createModels){L(x.then(function(x){z=k(x,o.componentData,I.cacheTokens);return x;}).then(function(x){if(Object.keys(z.afterManifest).length>0){y=h._createManifestModels(z.afterManifest,x.getComponentName());}return x;}));}Q=[];if(Array.isArray(I.preloadBundles)){I.preloadBundles.forEach(function(v){Q.push(q.sap._loadJSResourceAsync(F(v,true),true));});}if(Array.isArray(I.libs)){R=I.libs.map(F).filter(P);Q.push(sap.ui.getCore().loadLibraries(R,{preloadOnly:true}));}Q=Promise.all(Q);if(R&&!O.preloadOnly){Q=Q.then(function(){return sap.ui.getCore().loadLibraries(R);});}L(Q);if(!x){L(G(N,true));}else{L(x.then(function(x){var e=x.getComponentName();if(u){q.sap.registerModulePath(e,u);}return G(e,true).then(function(){if(!O.createModels){return null;}var i=Object.keys(z.afterPreload);if(i.length===0){return null;}return new Promise(function(v){sap.ui.require(["sap/ui/model/resource/ResourceModel"],function(S){v(S);});}).then(function(v){function S(T){var W=z.afterPreload[T];if(Array.isArray(W.settings)&&W.settings.length>0){var X=W.settings[0];return v.loadResourceBundle(X,true).then(function(Y){X.bundle=Y;},function(Y){q.sap.log.error("Component Manifest: Could not preload ResourceBundle for ResourceModel. "+"The model will be skipped here and tried to be created on Component initialization.","[\"sap.ui5\"][\"models\"][\""+T+"\"]",e);q.sap.log.error(Y);delete z.afterPreload[T];});}else{return Promise.resolve();}}return Promise.all(i.map(S)).then(function(){if(Object.keys(z.afterPreload).length>0){var T=h._createManifestModels(z.afterPreload,x.getComponentName());if(!y){y={};}for(var W in T){y[W]=T[W];}}});});});}));A=function(e){if(typeof h._fnLoadComponentCallback==="function"){var i=q.extend(true,{},o);var v=q.extend(true,{},e);try{h._fnLoadComponentCallback(i,v);}catch(S){q.sap.log.error("Callback for loading the component \""+x.getComponentName()+"\" run into an error. The callback was skipped and the component loading resumed.",S,"sap.ui.core.Component");}}};}if(I.components){q.each(I.components,function(i,v){L(G(F(v),true));});}return Promise.all(J).then(function(v){var e=[],i=false,S;i=v.some(function(T){if(T&&T.rejected){S=T.result;return true;}e.push(T.result);});if(i){return Promise.reject(S);}return e;}).then(function(v){if(x&&A){x.then(A);}return v;}).then(function(v){q.sap.log.debug("Component.load: all promises fulfilled, then "+v);if(x){return x.then(function(e){x=e;N=x.getComponentName();return H(N,x,true);});}else{return v;}}).then(function(){if(O.preloadOnly){return true;}return new Promise(function(e,i){sap.ui.require([D()],function(v){e(v);});}).then(function(e){var i=e.getMetadata();var N=i.getComponentName();var v=q.sap.getModulePath(N,"/manifest.json");var S;if(x&&typeof s!=="object"&&(typeof w==="undefined"||w===v)){S=l(i,x);}else{S=l(i);}return S.then(function(){return E(e);});});}).then(function(e){if(!x){return e;}var i=[];var v;var S=x.getEntry("/sap.ui5/rootView");if(typeof S==="string"){v="XML";}else if(S&&typeof S==="object"&&S.type){v=S.type;}if(v&&V[v]){var T="sap/ui/core/mvc/"+V[v]+"View";i.push(T);}var W=x.getEntry("/sap.ui5/routing");if(W&&W.routes){var X=x.getEntry("/sap.ui5/routing/config/routerClass")||"sap.ui.core.routing.Router";var Y=q.sap.getResourceName(X,"");i.push(Y);}var Z=q.extend(true,{},x.getEntry("/sap.ui5/models"));var $=q.extend(true,{},x.getEntry("/sap.app/dataSources"));var _=h._createManifestModelConfigurations({models:Z,dataSources:$,manifest:x,cacheTokens:I.cacheTokens});for(var a1 in _){if(!_.hasOwnProperty(a1)){continue;}var b1=_[a1];if(!b1.type){continue;}var c1=q.sap.getResourceName(b1.type,"");if(i.indexOf(c1)===-1){i.push(c1);}}if(i.length>0){return Promise.all(i.map(function(c1){return new Promise(function(d1,e1){var f1=false;function g1(h1){if(f1){return;}q.sap.log.warning("Can not preload module \""+c1+"\". "+"This will most probably cause an error once the module is used later on.",x.getComponentName(),"sap.ui.core.Component");q.sap.log.warning(h1);f1=true;d1();}sap.ui.require([c1],d1,g1);});})).then(function(){return e;});}else{return e;}}).then(function(e){var i=O.waitFor;if(i){var v=Array.isArray(i)?i:[i];return Promise.all(v).then(function(){return e;});}return e;}).catch(function(e){if(y){for(var N in y){var i=y[N];if(i&&typeof i.destroy==="function"){i.destroy();}}}throw e;});}if(x){H(N,x);}G(N);return E(sap.ui.requireSync(D()));}return h;});
