/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Control','./RenderManager',"./HTMLRenderer"],function(q,C,R,H){"use strict";var b=R.RenderPrefixes;var c=C.extend("sap.ui.core.HTML",{metadata:{library:"sap.ui.core",properties:{content:{type:"string",group:"Misc",defaultValue:null},preferDOM:{type:"boolean",group:"Misc",defaultValue:true},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{afterRendering:{parameters:{isPreservedDOM:{type:"boolean"}}}}}});c.prototype.getDomRef=function(s){var i=s?this.getId()+"-"+s:this.getId();return q.sap.domById(b.Dummy+i)||q.sap.domById(i);};c.prototype.setContent=function(d){function p(s){if(q.parseHTML){var a=q.parseHTML(s);if(a){var e=0,f=a.length;while(e<f&&a[e].nodeType!=1){e++;}while(e<f&&a[f-1].nodeType!=1){f--;}if(e>0||f<a.length){a=a.slice(e,f);}return q(a);}}return q(s);}if(this.getSanitizeContent()){d=q.sap._sanitizeHTML(d);}this.setProperty("content",d,true);if(this.getDomRef()){var $=p(this.getContent());q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{this.invalidate();}return this;};c.prototype.setSanitizeContent=function(s){this.setProperty("sanitizeContent",s,true);if(s){this.setContent(this.getContent());}return this;};c.prototype.onBeforeRendering=function(){if(this.getPreferDOM()&&this.getDomRef()&&!R.isPreservedContent(this.getDomRef())){R.preserveContent(this.getDomRef(),true,false);}};c.prototype.onAfterRendering=function(){if(!this.getVisible()){return;}var $=q(q.sap.domById(b.Dummy+this.getId()));var a=R.findPreservedContent(this.getId());var d;var i=false;if((!this.getPreferDOM()||a.size()==0)){a.remove();d=new q(this.getContent());$.replaceWith(d);}else if(a.size()>0){$.replaceWith(a);d=a;i=true;}else{$.remove();}this._postprocessNewContent(d);this.fireAfterRendering({isPreservedDOM:i});};c.prototype._postprocessNewContent=function($){if($&&$.size()>0){if($.length>1){q.sap.log.warning("[Unsupported Feature]: "+this+" has rendered "+$.length+" root nodes!");}else{var s=$.attr("id");if(s&&s!=this.getId()){q.sap.log.warning("[Unsupported Feature]: Id of HTML Control '"+this.getId()+"' does not match with content id '"+s+"'!");}}R.markPreservableContent($,this.getId());if($.find("#"+this.getId().replace(/(:|\.)/g,'\\$1')).length===0){$.filter(":not([id])").first().attr("id",this.getId());}}else{q.sap.log.debug(""+this+" is empty after rendering, setting bOutput to false");this.bOutput=false;}};c.prototype.setDOMContent=function(d){var $=q(d);if(this.getDomRef()){q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{$.appendTo(R.getPreserveAreaRef());if(this.getUIArea()){this.getUIArea().invalidate();}this._postprocessNewContent($);}return this;};c.prototype.setTooltip=function(){q.sap.log.warning("The sap.ui.core.HTML control doesn't support tooltips. Add the tooltip to the HTML content instead.");return C.prototype.setTooltip.apply(this,arguments);};"hasStyleClass addStyleClass removeStyleClass toggleStyleClass".split(" ").forEach(function(m){c.prototype[m]=function(){q.sap.log.warning("The sap.ui.core.HTML control doesn't support custom style classes. Manage custom CSS classes in the HTML content instead.");return C.prototype[m].apply(this,arguments);};});return c;});
