/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData'],function(q,B,L,a){"use strict";var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(f){throw new Error();}});var r=/0+(\.0+)?/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(f){return f>0?Math.floor(f):Math.ceil(f);};m[R.AWAY_FROM_ZERO]=function(f){return f>0?Math.ceil(f):Math.floor(f);};m[R.HALF_TOWARDS_ZERO]=function(f){return f>0?Math.ceil(f-0.5):Math.floor(f+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(f){return f>0?Math.floor(f+0.5):Math.ceil(f-0.5);};m[R.HALF_FLOOR]=function(f){return Math.ceil(f-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",customUnits:undefined,allowedUnits:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.getInstance=function(f,l){return this.getFloatInstance(f,l);};N.getFloatInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.FLOAT);F.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,o,f);return F;};N.getIntegerInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.INTEGER);F.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,o,f);return F;};N.getCurrencyInstance=function(f,l){var F=this.createInstance(f,l),C=f&&f.currencyContext,o=this.getLocaleFormatOptions(F.oLocaleData,n.CURRENCY,C);F.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,o,f);return F;};N.getUnitInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.UNIT);F.oFormatOptions=q.extend(false,{},this.oDefaultUnitFormat,o,f);return F;};N.getPercentInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.PERCENT);F.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,o,f);return F;};N.createInstance=function(f,l){var F=Object.create(this.prototype),P;if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=l;F.oLocaleData=a.getInstance(l);F.oOriginalFormatOptions=f;if(f){if(f.pattern){P=this.parseNumberPattern(f.pattern);q.each(P,function(s,o){f[s]=o;});}if(f.emptyString!==undefined){}}return F;};N.getLocaleFormatOptions=function(l,t,C){var o,s;switch(t){case n.PERCENT:s=l.getPercentPattern();break;case n.CURRENCY:s=l.getCurrencyPattern(C);break;case n.UNIT:s=l.getDecimalPattern();break;default:s=l.getDecimalPattern();}o=this.parseNumberPattern(s);o.plusSign=l.getNumberSymbol("plusSign");o.minusSign=l.getNumberSymbol("minusSign");o.decimalSeparator=l.getNumberSymbol("decimal");o.groupingSeparator=l.getNumberSymbol("group");o.percentSign=l.getNumberSymbol("percentSign");o.pattern=s;switch(t){case n.FLOAT:case n.PERCENT:o.minFractionDigits=0;o.maxFractionDigits=99;break;case n.INTEGER:o.minFractionDigits=0;o.maxFractionDigits=0;o.groupingEnabled=false;break;case n.CURRENCY:o.minFractionDigits=undefined;o.maxFractionDigits=undefined;break;}return o;};N.parseNumberPattern=function(f){var M=0,h=0,j=0,G=false,k=0,l=0,s=f.indexOf(";"),S={Integer:0,Fraction:1},o=S.Integer;if(s!==-1){f=f.substring(0,s);}for(var i=0;i<f.length;i++){var C=f[i];switch(C){case",":if(G){k=l;l=0;}G=true;break;case".":o=S.Fraction;break;case"0":if(o===S.Integer){M++;if(G){l++;}}else{h++;j++;}break;case"#":if(o===S.Integer){if(G){l++;}}else{j++;}break;}}if(!k){k=l;l=0;}return{minIntegerDigits:M,minFractionDigits:h,maxFractionDigits:j,groupingEnabled:G,groupingSize:k,groupingBaseSize:l};};N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",f="",G="",s="",h="",P="",j=0,l=0,k=0,o=0,t=v<0,D=-1,O=q.extend({},this.oFormatOptions),u=this.oOriginalFormatOptions,w,S,x,y;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){x=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(x,O,this.oLocaleData);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(u.minFractionDigits===undefined&&u.maxFractionDigits===undefined&&u.decimals===undefined&&u.precision===undefined&&u.pattern===undefined){O.precision=2;}if(u.maxFractionDigits===undefined&&u.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if(O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,e(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var z=this.oLocaleData.getCurrencyDigits(M);if(O.maxFractionDigits===undefined){O.maxFractionDigits=z;}if(O.minFractionDigits===undefined){O.minFractionDigits=z;}}if(typeof v==="number"){v=c(v,O.maxFractionDigits,O.roundingMode);}if(v==0){t=false;}h=this.convertToDecimal(v);if(h=="NaN"){return h;}if(t){h=h.substr(1);}D=h.indexOf(".");if(D>-1){i=h.substr(0,D);f=h.substr(D+1);}else{i=h;}if(i.length<O.minIntegerDigits){i=q.sap.padLeft(i,"0",O.minIntegerDigits);}else if(i.length>O.maxIntegerDigits){i=q.sap.padLeft("","?",O.maxIntegerDigits);}if(f.length<O.minFractionDigits){f=q.sap.padRight(f,"0",O.minFractionDigits);}else if(f.length>O.maxFractionDigits){f=f.substr(0,O.maxFractionDigits);}l=i.length;if(O.groupingEnabled){k=O.groupingSize;o=O.groupingBaseSize||k;j=Math.max(l-o,0)%k||k;G=i.substr(0,j);while(l-j>=o){G+=O.groupingSeparator;G+=i.substr(j,k);j+=k;}G+=i.substr(j);}else{G=i;}if(t){s=O.minusSign;}s+=G;if(f){s+=O.decimalSeparator+f;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){y=this.oLocaleData.getPluralCategory(i+"."+f);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,y);s=S.formatString.replace(S.valueSubString,s);s=s.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){y=this.oLocaleData.getPluralCategory(i+"."+f);P=this.oLocaleData.getCurrencyFormat("short",S.key,y);P=P.replace(/'.'/g,".");}w=P.split(";");if(w.length===2){P=t?w[1]:w[0];if(t){s=s.substring(1);}}if(!O.currencyCode){M=this.oLocaleData.getCurrencySymbol(M);}s=this._composeCurrencyResult(P,s,M,{showMeasure:O.showMeasure,negative:t,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;s=P.replace(/[0#.,]+/,s);s=s.replace(/%/,O.percentSign);}if(O.showMeasure&&O.type===n.UNIT){y=this.oLocaleData.getPluralCategory(i+"."+f);var U=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!U){return"";}var A,C;if(O.customUnits&&typeof O.customUnits==="object"){A=O.customUnits[M];}else{C=this.oLocaleData.getUnitFromMapping(M)||M;A=this.oLocaleData.getUnitFormat(C);}if(A){P=A["unitPattern-count-"+y];if(!P){P=A["unitPattern-count-other"];}if(!P){return"";}s=P.replace("{0}",s);}else{return"";}}if(sap.ui.getCore().getConfiguration().getOriginInfo()){s=new String(s);s.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return s;};N.prototype._composeCurrencyResult=function(P,f,M,o){var s=o.minusSign;P=P.replace(/[0#.,]+/,f);if(o.showMeasure&&M){var h="\u00a4",i={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},j=P.indexOf(h),k=j<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(k),C=(k==="after"?M.charAt(M.length-1):M.charAt(0)),l,t=i[S.currencyMatch],u=i[S.surroundingMatch],I;P=P.replace(h,M);l=(k==="after"?P.charAt(j+M.length):P.charAt(j-1));if(t&&t.test(C)&&u&&u.test(l)){if(k==="after"){I=j+M.length;}else{I=j;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(o.negative&&k==="after"){s="\ufeff"+o.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(o.negative){P=P.replace(/-/,s);}return P;};N.prototype.parse=function(v){var o=this.oFormatOptions,P=d(o.plusSign+o.minusSign),G=d(o.groupingSeparator),D=d(o.decimalSeparator),s="^\\s*(["+P+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",f="^\\s*(["+P+"]?[0-9"+G+"]+)\\s*$",h=new RegExp(G,"g"),j=new RegExp(D,"g"),k=this.oLocaleData.getNumberSymbol("percentSign"),l,t,u,w,x,M,y,z=0,S,E;if(v===""){E=o.emptyString;if(o.parseAsString&&(o.emptyString===0||isNaN(o.emptyString))){E=o.emptyString+"";}if(o.type===n.CURRENCY){return[E,undefined];}else{return E;}}y=o.type===n.PERCENT?o.pattern:this.oLocaleData.getPercentPattern();if(y.charAt(0)==="%"){s=s.slice(0,1)+"%?"+s.slice(1);}else if(y.charAt(y.length-1)==="%"){s=s.slice(0,s.length-1)+"%?"+s.slice(s.length-1);}var U;if(o.type===n.UNIT){var A;if(o.customUnits&&typeof o.customUnits==="object"){A=o.customUnits;}else{A=this.oLocaleData.getUnitFormats();}if(o.allowedUnits){var F={};for(var i=0;i<o.allowedUnits.length;i++){var C=o.allowedUnits[i];F[C]=A[C];}A=F;}var H=p(A,v);U=H.cldrCode;if(U.length===1){M=U[0];}else if(U.length===0){return null;}else{M=undefined;}v=H.numberValue||v;}v=v.replace(/\s/g,"");S=b(v,this.oFormatOptions.style,this.oLocaleData);if(S){v=S.number;l=new RegExp(s);}else if(o.isInteger){l=new RegExp(f);}else if(o.type===n.CURRENCY){w="[^\\d\\s+-]*";u="(?:^("+w+")"+s.substring(1,s.length-1)+"$)|(?:^"+s.substring(1,s.length-1)+"("+w+")\\s*$)";l=new RegExp(u);}else{l=new RegExp(s);}if(!l.test(v)){return o.type===n.CURRENCY||o.type===n.UNIT?null:NaN;}if(o.type===n.CURRENCY){x=l.exec(v);if(x[2]){v=x[2];M=x[1]||undefined;}else{v=x[3];M=x[4]||undefined;}if(M&&!o.showMeasure){return null;}if(M){M=this.oLocaleData.getCurrencyCodeBySymbol(M)||M;}}v=v.replace(h,"");v=v.replace(o.plusSign,"+");v=v.replace(o.minusSign,"-");v=v.replace(/^\+/,"");if(S){v=v.replace(j,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(o.isInteger){z=o.parseAsString?v:parseInt(v,10);}else{v=v.replace(j,".");if(v.indexOf(k)!==-1){t=true;v=v.replace(k,"");}z=o.parseAsString?v:parseFloat(v);if(t){z=N._shiftDecimalPoint(z,-2);}}if(o.parseAsString){z=N._shiftDecimalPoint(v,0);}if(o.type===n.CURRENCY||o.type===n.UNIT){return[z,M];}return z;};N.prototype.convertToDecimal=function(v){var V=""+v,f,s,D,F,E,P;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var h=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);f=h[1]=="-";s=h[2].replace(/\./g,"");D=h[3]?h[3].length:0;F=h[4]?h[4].length:0;E=parseInt(h[5],10);if(E>0){if(E<F){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(f){V="-"+V;}return V;};N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var s=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),S;if(s&&s.formatString){S=s.formatString.replace(r,"").replace(/'.'/g,".").trim();if(S){return S;}}};N._shiftDecimalPoint=function(v,s){if(typeof s!=="number"){return NaN;}var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){s=E[1]?(+E[1]+s):s;return+(E[0]+"e"+s);}else if(typeof v==="string"){if(parseInt(v,10)===0&&s>=0){return v;}v=E[0];var D=v.indexOf("."),A,i,f;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+s;if(A<=0){v=q.sap.padLeft(v,'0',v.length-A+1);A=1;}else if(A>=v.length-1){v=q.sap.padRight(v,'0',A+1);A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);f=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return i+(f?("."+f):"");}else{return null;}};function g(v,o,l){var s,k,K,S=o.style,P=o.precision!==undefined?o.precision:2;if(S!="short"&&S!="long"){return undefined;}for(var i=0;i<14;i++){k=Math.pow(10,i);if(c(Math.abs(v)/k,P-1)<10){break;}}K=k.toString();var C=l.getDecimalFormat(S,K,"other");if(!C||C=="0"){return undefined;}else{s={};s.key=K;s.formatString=C;var f=C.match(r);if(f){s.valueSubString=f[0];var h=s.valueSubString.indexOf(".");if(h==-1){s.decimals=0;s.magnitude=k*Math.pow(10,1-s.valueSubString.length);}else{s.decimals=s.valueSubString.length-h-1;s.magnitude=k*Math.pow(10,1-h);}}else{return undefined;}}return s;}function b(v,s,l){if(s!="short"&&s!="long"){return;}var f,F=1,k=10,P=l.getPluralCategories(),C,h={number:undefined,factor:F},G=function(o,k){C=l.getDecimalFormat(s,k.toString(),o);if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var t=C.match(r);if(t){var V=t[0];var u=C.replace(V,"");if(!u){return;}var I=v.indexOf(u);if(I>=0){f=v.replace(u,"");f=f.replace(/\u200F/g,"");F=k;F*=Math.pow(10,1-V.length);if(h.number===undefined||f.length<h.number.length){h.number=f;h.factor=F;}}}}};while(k<1e14){for(var i=0;i<P.length;i++){var j=P[i];G(j,k);}k=k*10;}if(!f){return;}return h;}function c(v,M,s){if(typeof v!=="number"){return NaN;}s=s||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M,10);if(typeof s==="function"){v=s(v,M);}else{if(!M){return m[s](v);}v=N._shiftDecimalPoint(m[s](N._shiftDecimalPoint(v,M)),-M);}return v;}function d(s){return s.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}function e(v,P){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,P-i-1);}function p(u,v){var o={numberValue:undefined,cldrCode:[]};var i;var U,k;for(U in u){for(k in u[U]){if(k.indexOf("unitPattern")===0){var s=u[U][k];var C=s.indexOf("{0}")>-1;if(C){s="^"+q.sap.escapeRegExp(s).replace("\\{0\\}","(.+)")+"$";var f=new RegExp(s);var h=f.exec(v);if(h&&h[1]){if(i===undefined||h[1].length<i){i=h[1].length;o.numberValue=h[1];o.cldrCode=[U];}else if(h[1].length===i&&o.cldrCode.indexOf(U)===-1){o.cldrCode.push(U);}}}else if(s===v){o.cldrCode=[U];var j;if(q.sap.endsWith(k,"-zero")){j="0";}else if(q.sap.endsWith(k,"-one")){j="1";}else if(q.sap.endsWith(k,"-two")){j="2";}o.numberValue=j;return o;}}}}return o;}return N;});
