/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/XMLTemplateProcessor','sap/ui/core/library','./View','sap/ui/model/resource/ResourceModel','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/core/cache/CacheManager',"./XMLViewRenderer",'jquery.sap.xml','jquery.sap.script'],function(q,X,l,V,R,M,C,a,b,c){"use strict";var d=a.RenderPrefixes,f=l.mvc.ViewType,x="XMLViewCacheError",n={};var g=V.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'},cache:'Object'},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"}});sap.ui.xmlview=function(i,e){return sap.ui.view(i,e,f.XML);};g._sType=f.XML;g.asyncSupport=true;g._bUseCache=sap.ui.getCore().getConfiguration().getViewCache()&&b._isSupportedEnvironment();function v(e){if(e.parseError.errorCode!==0){var P=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}}function h(o,S){if(!S){throw new Error("mSettings must be given");}else if(S.viewName&&S.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((S.viewName||S.viewContent)&&S.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(S.viewName||S.viewContent)&&!S.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}else if(S.cache&&!(S.cache.keys&&S.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.");}}function j(o,S){o.mProperties["viewContent"]=S.viewContent;var e=q.sap.parseXML(S.viewContent);v(e);return e.documentElement;}function s(o,S){if((o._resourceBundleName||o._resourceBundleUrl)&&(!S.models||!S.models[o._resourceBundleAlias])){var e=new R({bundleName:o._resourceBundleName,bundleUrl:o._resourceBundleUrl,bundleLocale:o._resourceBundleLocale});o.setModel(e,o._resourceBundleAlias);}}function k(o){o.oAfterRenderingNotifier=new B();o.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){o.onAfterRenderingBeforeChildren();}});}function m(S){var e=sap.ui.require("sap/ui/core/Component"),o;while(S&&e){var i=e.getOwnerComponentFor(S);if(i){S=o=i;}else{if(S instanceof e){o=S;}S=S.getParent&&S.getParent();}}return o;}function p(o,e){var i=m(o),D=i?JSON.stringify(i.getManifest()):null,F=[];F=F.concat(u(o,i),y(),w(o),e.keys);return t(o,F).then(function(K){return{key:K+"("+q.sap.hashCode(D||"")+")",componentManifest:D,additionalData:e.additionalData};});}function r(K){return K;}function t(o,F){return Promise.all(F).then(function(K){K=K.filter(function(E){return E!==n;});if(K.every(r)){return K.join('_');}else{var e=new Error("Provided cache keys may not be empty or undefined.");e.name=x;return Promise.reject(e);}});}function u(o,e){var i=e&&e.getMetadata().getName();return[i||window.location.host+window.location.pathname,o.getId(),sap.ui.getCore().getConfiguration().getLanguageTag()];}function w(e){var P=e.getPreprocessors(),i=e.getPreprocessorInfo(false),F=[];function D(o){F.push(o.preprocessor.then(function(E){if(E.getCacheKey){return E.getCacheKey(i);}else{return n;}}));}for(var T in P){P[T].forEach(D);}return F;}function y(){return sap.ui.getVersionInfo({async:true}).then(function(i){var T="";if(!i.libraries){T=sap.ui.buildinfo.buildtime;}else{i.libraries.forEach(function(L){T+=L.buildTimestamp;});}return T;}).catch(function(e){q.sap.log.warning("sap.ui.getVersionInfo could not be retrieved","sap.ui.core.mvc.XMLView");q.sap.log.debug(e);return"";});}function z(e,i){var K=e.key;delete e.key;e.xml=q.sap.serializeXML(i);return b.set(K,e);}function A(e){return b.get(e.key).then(function(i){if(i&&i.componentManifest==e.componentManifest){i.xml=q.sap.parseXML(i.xml,"application/xml").documentElement;if(i.additionalData){q.extend(true,e.additionalData,i.additionalData);}return i;}});}g.prototype.initViewSettings=function(S){var e=this,_;function i(I){e._xContent=I;if(V._supportInfo){V._supportInfo({context:e._xContent,env:{caller:"view",viewinfo:q.extend(true,{},e),settings:q.extend(true,{},S||{}),type:"xmlview"}});}if(!e.isSubView()){var J={};X.parseViewAttributes(I,e,J);if(!S.async){q.sap.extend(S,J);}else{e.applySettings(J);}}else{delete S.controller;}s(e,S);k(e);}function o(I,J){if(e.hasPreprocessor("viewxml")){return X.enrichTemplateIdsPromise(I,e,J).then(function(){return e.runPreprocessor("viewxml",I,!J);});}return I;}function D(I){return e.runPreprocessor("xml",I).then(function(I){return o(I,true);});}function E(H){return q.sap.loadResource(H,{async:true}).then(function(I){return I.documentElement;});}function F(H,I){return E(H).then(D).then(function(J){if(I){z(I,J);}return J;});}function G(H,I){return p(e,I).then(function(J){return A(J).then(function(K){if(!K){return F(H,J);}else{return K.xml;}});}).catch(function(J){if(J.name===x){q.sap.log.debug(J.message,J.name,"sap.ui.core.mvc.XMLView");q.sap.log.debug("Processing the View without caching.","sap.ui.core.mvc.XMLView");return F(H);}else{return Promise.reject(J);}});}this._oContainingView=S.containingView||this;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true;}h(this,S);if(S.viewName){var H=q.sap.getResourceName(S.viewName,".view.xml");if(S.async){if(S.cache&&g._bUseCache){return G(H,S.cache).then(i);}else{return E(H).then(D).then(i);}}else{_=q.sap.loadResource(H).documentElement;}}else if(S.viewContent){if(S.viewContent.nodeType===window.Node.DOCUMENT_NODE){_=S.viewContent.documentElement;}else{_=j(this,S);}}else if(S.xmlNode){_=S.xmlNode;}if(S.async){return D(_).then(i);}else{_=this.runPreprocessor("xml",_,true);_=o(_,false);if(_&&typeof _.then==='function'){if(_.isRejected()){throw _.getResult();}_=_.getResult();}i(_);}};g.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};g.prototype.onControllerConnected=function(o){var e=this;function i(D){return M.runWithPreprocessors(D,{settings:e._fnSettingsPreprocessor});}if(!this.oAsyncState){this._aParsedContent=i(X.parseTemplate.bind(null,this._xContent,this));}else{return X.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:i}).then(function(P){e._aParsedContent=P;delete e.oAsyncState.suppressPreserve;});}};g.prototype.getControllerName=function(){return this._controllerName;};g.prototype.isSubView=function(){return this._oContainingView!=this;};g.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var i=0;i<e.length;i++){var o=e[i].getDomRef()||q.sap.domById(d.Invisible+e[i].getId());if(o){q.sap.byId(d.Dummy+e[i].getId(),this._$oldContent).replaceWith(o);}}}q.sap.byId(d.Dummy+this.getId()).replaceWith(this._$oldContent);}this._$oldContent=undefined;};g.prototype._onChildRerenderedEmpty=function(o,e){q(e).replaceWith('<div id="'+d.Dummy+o.getId()+'" class="sapUiHidden"/>');return true;};g.prototype.destroy=function(S){var $=a.findPreservedContent(this.getId());if($){$.remove();}if(S=="KeepDom"&&this.getDomRef()){this.getDomRef().removeAttribute("data-sap-ui-preserve");}V.prototype.destroy.call(this,S);};g.registerPreprocessor=function(T,P,S,o,e){T=T.toUpperCase();if(g.PreprocessorType[T]){V.registerPreprocessor(g.PreprocessorType[T],P,this.getMetadata().getClass()._sType,S,o,e);}else{q.sap.log.error("Preprocessor could not be registered due to unknown sType \""+T+"\"",this.getMetadata().getName());}};g.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};var B=C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{metadata:{library:"sap.ui.core"},renderer:function(o,e){o.write("");}});g.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return g;});
