/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/unified/Menu','sap/ui/core/Control'],function(q,l,M,C){"use strict";var a=C.extend('sap.ui.dt.MiniMenuControl',{metadata:{properties:{"maxButtonsDisplayed":{type:"int",defaultValue:4},"buttons":{type:"object[]",defaultValue:[]},styleClass:{type:"string"}},events:{Opened:{},Closed:{},OverflowButtonPressed:{}}},init:function(){var p=this.getId()+"-popover";var P=new sap.m.Popover(p,{showHeader:false,verticalScrolling:false,horizontalScrolling:false,content:new sap.m.HBox(p+"ContentBox",{renderType:"Bare"})});P.attachBrowserEvent("keydown",this._changeFocusOnArrowKey,this);P.oPopup.attachClosed(this._popupClosed,this);this.addDependent(P);P.addStyleClass("sapUiDtMiniMenu");var s=this.getId()+"-popoverExp";var o=new sap.m.Popover(s,{showHeader:false,verticalScrolling:false,horizontalScrolling:false,content:new sap.m.VBox(s+"ContentBox",{renderType:"Bare"})});o.attachBrowserEvent("keydown",this._changeFocusOnArrowKey,this);o.oPopup.attachClosed(this._popupClosed,this);this.addDependent(o);o.addStyleClass("sapUiDtMiniMenu");P.attachBrowserEvent("contextmenu",this._onContextMenu,this);o.attachBrowserEvent("contextmenu",this._onContextMenu,this);this.bOnInit=true;var S;try{S=sap.ui.getCore().getStaticAreaRef();S=sap.ui.getCore().getUIArea(S);}catch(e){q.sap.log.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}S.addContent(this,true);},exit:function(){this.getPopover(true).oPopup.detachOpened(this._popupOpened,this);this.getPopover(false).oPopup.detachOpened(this._popupOpened,this);this.getPopover(true).oPopup.detachClosed(this._popupClosed,this);this.getPopover(false).oPopup.detachClosed(this._popupClosed,this);this.getPopover(true).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(false).detachBrowserEvent("contextmenu",this._onContextMenu,this);},show:function(s,c,o){this._close=function(e){if(e.isTrusted){this.close();}}.bind(this);if(this._bUseExpPop===undefined){this._bUseExpPop=!!c;}this._bCompactMode=q(s.getDomRef()).attr("class").indexOf("sapUiSizeCompact")>-1;this._bOpenAsContextMenu=c;this._oContextMenuPosition=o;this.getPopover(true).addStyleClass(this.getStyleClass()||"");this.getPopover(false).addStyleClass(this.getStyleClass()||"");var b=this.getButtons();this._oTarget=s;if(!this._bOpenAsContextMenu){this._setButtonsForMiniMenu(b,s);}else{this._makeAllButtonsVisible(b);}if(this.bOnInit||!this.getPopover().isOpen()){this.finalizeOpening();this.bOnInit=false;}},finalizeOpening:function(){if(this._bOpenAsContextMenu&&this._oContextMenuPosition.x===null&&this._oContextMenuPosition.y===null){this._bOpenAsContextMenu=false;}this._oTarget=this._placeMiniMenu(this._oTarget,this._bOpenAsContextMenu,this._bUseExpPop);this.getPopover().openBy(this._oTarget);this._placeMiniMenuWrapper();this.getPopover().setVisible(true);this.bOpen=true;this.bOpenNew=false;this.fireOpened();},_setButtonsForMiniMenu:function(b,s){var B=this._getNumberOfEnabledButtons(b);if(B!==0){this._hideDisabledButtons(b);}this._iButtonsVisible=this._hideButtonsInOverflow(b);if(this._iButtonsVisible===this.getMaxButtonsDisplayed()&&this._iButtonsVisible!==b.length){this._replaceLastVisibleButtonWithOverflowButton(b);}else if(B<b.length&&B!=0){this.addButton(this._createOverflowButton());}B=null;},_makeAllButtonsVisible:function(b){this._iFirstVisibleButtonIndex=0;b.forEach(function(B){B.setVisible(true);B._bInOverflow=true;});},_getNumberOfEnabledButtons:function(b){var B=0;for(var i=0;i<b.length;i++){if(b[i].getEnabled()){B++;if(!this._iFirstVisibleButtonIndex){this._iFirstVisibleButtonIndex=i;}}}return B;},_hideDisabledButtons:function(b){var v=0;b.forEach(function(B){B.setVisible(B.getEnabled());if(B.getEnabled()){v++;}});return v;},_hideButtonsInOverflow:function(b){var v=0;for(var i=0;i<b.length;i++){if(v<this.getMaxButtonsDisplayed()&&b[i].getVisible()){v++;}else{b[i].setVisible(false);}}return v;},_replaceLastVisibleButtonWithOverflowButton:function(b){for(var i=b.length-1;i>=0;i--){if(b[i].getVisible()){b[i].setVisible(false);this.addButton(this._createOverflowButton());return;}}},_placeMiniMenu:function(s,c,e){this.getPopover().setShowArrow(true);var o=(s.getId&&s.getId())||s.getAttribute("overlay");var p=this._getPopoverDimensions(e,!c);var O=this._getOverlayDimensions(o);var v=this._getViewportDimensions();var P={};if(c){P=this._placeAsContextMenu(this._oContextMenuPosition,p,v);}else{P=this._placeAsMiniMenu(O,p,v);}P.top-=O.top;P.left-=O.left;q("#fakeDiv").remove();q("#"+o).append("<div id=\"fakeDiv\" overlay=\""+o+"\" style = \"position:absolute;top:"+P.top+"px;left:"+P.left+"px;\" />");o=null;return document.getElementById("fakeDiv");},_placeAsContextMenu:function(c,p,v){this.getPopover().setShowArrow(false);var P={};if(v.height-c.y>=p.height){P.top=c.y;this.getPopover().setPlacement("Bottom");}else if(c.y>=p.height){P.top=c.y;this.getPopover().setPlacement("Top");}else if(v.height>=p.height){P.top=v.height-p.height;this.getPopover().setPlacement("Bottom");}else{q.error("Your screen size is not supported!");}if(v.width-c.x>=p.width){P.left=c.x;}else if(c.x>=p.width){P.left=c.x-p.width;}else if(v.width>=p.width){P.left=v.width-p.width;}else{q.error("Your screen size is not supported!");}return P;},_placeAsMiniMenu:function(o,p,v){this.getPopover().setShowArrow(true);var P={top:null,left:null};if(o.top>=p.height&&v.width>=p.width){P=this._placeMiniMenuOnTop(o);}else if(v.height-o.top>=p.height+5&&v.height>=p.height+5&&v.width>=p.width){P=this._placeMiniMenuAtTheBottom(o,p,v);}else if(v.height>=p.height&&v.width>=p.width){P=this._placeMiniMenuSideways(o,p,v);}else{q.error("Your screen size is not supported!");}return P;},_placeMiniMenuOnTop:function(o){var p={};this.getPopover().setPlacement("Top");p.top=o.top;p.left=o.left+o.width/2;return p;},_placeMiniMenuAtTheBottom:function(o,p,v){this.getPopover().setPlacement("Bottom");var P={};P.left=o.left+o.width/2;if(o.height<60&&v.height-o.top-o.height>=p.height){P.top=o.bottom;}else if(o.top>=v.top){P.top=o.top+5;}else{P.top=v.top+5;}return P;},_placeMiniMenuSideways:function(o,p,v){var P={};P.left=this._getMiniMenuSidewaysPlacement(o,p,v);P.top=this._getMiddleOfOverlayAndViewportEdges(o,v);return P;},_getMiniMenuSidewaysPlacement:function(o,p,v){var L;if(v.width-o.right>=p.width){this.getPopover().setPlacement("Right");L=o.right;}else if(o.left>=p.width){this.getPopover().setPlacement("Left");L=o.left;}else{this.getPopover().setPlacement("Right");if(p.width<=v.width-(o.left+o.width/2)){L=(o.left+o.width/2);}else{L=v.width-p.width;}}return L;},_getMiddleOfOverlayAndViewportEdges:function(o,v){var t;if(v.top>o.top){t=v.top;}else{t=o.top;}if(v.bottom<o.bottom){t+=v.bottom;}else{t+=o.bottom;}t/=2;return t;},_placeMiniMenuWrapper:function(){q("#MiniMenuWrapper").remove();var p=q(this.getPopover().getDomRef());var A=parseInt(q("#"+this.getPopover().getId()+"-arrow").height(),10);var P=parseInt(p.css("top"),10)-p.position().top-A;var i=parseInt(p.css("left"),10)-p.position().left-A;var b=parseInt(p.css("width"),10)+2*A;var c=parseInt(p.css("height"),10)+2*A;var d=p.css("z-index")-1;q(sap.ui.getCore().getStaticAreaRef()).append("<div id=\"MiniMenuWrapper\" style = \"position:absolute;top:"+P+"px;left:"+i+"px;width:"+b+"px;height:"+c+"px;z-index:"+d+"\" />");},_getPopoverDimensions:function(e,w){var p={};var c=this._bCompactMode;var b=this._getButtonHeight(c);var B=this._getButtonWidth(c);var A=this._getArrowHeight(c);var i=this._getBaseFontSize();p.height=i*b;this._iFirstVisibleButtonIndex=null;if(e){p.height*=this.getButtons().length-1;p.width=parseInt(q("#"+this.getPopover().getId()).css("width"),10)||80;}else{p.width=i*B*this._iButtonsVisible;}if(w){var d=i*A;if(d){p.height+=2*d;p.width+=2*d;}}return p;},_getButtonHeight:function(c){return c?2:3;},_getButtonWidth:function(c){return c?2:2.5;},_getArrowHeight:function(c){if(sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.edge){return c?0.5:0.5;}else{return c?0.5625:0.5625;}},_getBaseFontSize:function(){return parseInt(q(document.documentElement).css("fontSize"),10);},_getOverlayDimensions:function(o){var O=q("#"+o).rect();O.right=O.left+O.width;O.bottom=O.top+O.height;return O;},_getViewportDimensions:function(){var v={};v.width=window.innerWidth;v.height=window.innerHeight;v.top=parseInt(q(".type_standalone").css("height"),10)||0;v.bottom=v.top+v.height;return v;},addButton:function(b,s,o){function h(){this.bOpen=false;this.bOpenNew=false;s._onItemSelected(this);}if(b.icon==null){b.icon="sap-icon://incident";}b.getText=function(o){return typeof b.text==="function"?b.text(o):b.text;};b.getEnabled=function(o){return typeof b.enabled==="function"?b.enabled(o):b.enabled;};var B;var c;if(s){B=new sap.m.Button({icon:b.icon?b.icon:"sap-icon://incident",tooltip:b.getText(o),type:"Transparent",enabled:b.getEnabled(o),press:h,layoutData:new sap.m.FlexItemData({})});B.data({id:b.id,key:b.id});c=new sap.m.Button({icon:b.icon?b.icon:"sap-icon://incident",text:b.getText(o),type:"Transparent",enabled:b.getEnabled(o),press:h,layoutData:new sap.m.FlexItemData({})});c.data({id:b.id,key:b.id});}else{B=new sap.m.Button({icon:b.icon,tooltip:b.getText(o),type:"Transparent",enabled:b.getEnabled(o),press:b.handler,layoutData:new sap.m.FlexItemData({})});c=new sap.m.Button({icon:b.icon,text:b.getText(o),type:"Transparent",enabled:b.getEnabled(o),press:b.handler,layoutData:new sap.m.FlexItemData({})});}this.setProperty("buttons",this.getProperty("buttons").concat(b));this.getFlexbox(true).addItem(c);this.getFlexbox(false).addItem(B);B=null;c=null;return this;},close:function(){if(this.getPopover()){this.getPopover(true).close();this.getPopover(false).close();if(this.getProperty("buttons").length>this.getProperty("maxButtonsDisplayed")){this.setProperty("buttons",this.getProperty("buttons").splice(0,this.getProperty("buttons").length-1));this.getFlexbox().removeItem(this.getButtons().length-1);}}return this;},removeButton:function(i){this.setProperty("buttons",this.getProperty("buttons").splice(i,1));this.getFlexbox(true).removeItem(i);return this.getFlexbox(false).removeItem(i);},removeAllButtons:function(){this.setProperty("buttons",[]);this.getFlexbox(true).removeAllItems();return this.getFlexbox(false).removeAllItems();},getButtons:function(){return this.getFlexbox().getItems();},insertButton:function(b,i){this.getFlexbox().insertItem(b,i);return this;},setButtons:function(_,s,o){this.removeAllButtons();if(o){_.forEach(function(b){this.addButton(b,s,o);}.bind(this));}else{_.forEach(function(b){this.addButton(b,s);}.bind(this));}},setMaxButtonsDisplayed:function(m){if(m<2){throw Error("maxButtonsDisplayed can't be less than two!");}this.setProperty("maxButtonsDisplayed",m);},getPopover:function(e){if(e===undefined){if(this._bUseExpPop){return this.getDependents()[1];}else{return this.getDependents()[0];}}else if(e){return this.getDependents()[1];}else{return this.getDependents()[0];}},getFlexbox:function(e){return this.getPopover(e).getContent()[0];},_createOverflowButton:function(){return{icon:"sap-icon://overflow",type:"Transparent",handler:this._onOverflowPress.bind(this),enabled:true};},setOpenNew:function(v){this.bOpenNew=v;},_onOverflowPress:function(e){this.fireOverflowButtonPressed();var b=this.getButtons();this.getPopover().close();this._bUseExpPop=true;this.getButtons()[b.length-1].setVisible(false);var f=this._placeMiniMenu(this._oTarget,false,true);this.getPopover().openBy(f);},_popupClosed:function(){q("#MiniMenuWrapper").remove();if(this.getPopover()){this.fireClosed();if(this.bOpenNew){this.bOpenNew=false;this.finalizeOpening();return;}}this.bOpen=false;},_setFocusOnButton:function(b){if(b.getEnabled()&&b.getVisible()){b.focus();return true;}},_changeFocusOnKeyStroke:function(e){if(document.activeElement){var i=document.activeElement.id;switch(e.key){case"ArrowRight":this._changeFocusOnButtons(i);break;case"ArrowLeft":this._changeFocusOnButtons(i,true);break;case"ArrowUp":this._changeFocusOnButtons(i,true);break;case"ArrowDown":this._changeFocusOnButtons(i);break;case"Tab":if(sap.ui.Device.browser.safari){if(e.shiftKey){this._changeFocusOnButtons(i,true);}else{this._changeFocusOnButtons(i);}}break;default:break;}}},_changeFocusOnButtons:function(i,p){this.getButtons().some(function(b,I,A){if(i===b.getId()){if(p){this._setFocusOnPreviousButton(A,I);}else{this._setFocusOnNextButton(A,I);}return true;}}.bind(this));},_setFocusOnNextButton:function(b,i){for(var c=i+1;c<b.length;c++){if(this._setFocusOnButton(b[c])){return;}}for(var d=0;d<i;d++){if(this._setFocusOnButton(b[d])){return;}}},_setFocusOnPreviousButton:function(b,i){for(var c=i-1;c>=0;c--){if(this._setFocusOnButton(b[c])){return;}}for(var d=b.length-1;d>=i;d--){if(this._setFocusOnButton(b[d])){return;}}},_onContextMenu:function(e){if(!this.getPopover().isOpen()){this.detachBrowserEvent("contextmenu");return;}if(e.preventDefault){e.preventDefault();}},renderer:function(){}});return a;},true);
