/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementUtil','sap/ui/base/ManagedObject','sap/ui/dt/DOMUtil'],function(q,O,E,M,D){"use strict";var a=M.extend("sap.ui.dt.MutationObserver",{metadata:{library:"sap.ui.dt",events:{domChanged:{parameters:{type:{type:"string"},elemenIds:{type:"string[]"},targetNodes:{type:"element[]"}}}}}});a.prototype.init=function(){this._fnFireDomChanged=function(){this.fireDomChanged();}.bind(this);this._onScroll=this._fireDomChangeOnScroll.bind(this);this._startMutationObserver();window.addEventListener("transitionend",this._fnFireDomChanged,true);window.addEventListener("webkitTransitionEnd",this._fnFireDomChanged,true);window.addEventListener("otransitionend",this._fnFireDomChanged,true);window.addEventListener("animationend",this._fnFireDomChanged,true);window.addEventListener("webkitAnimationEnd",this._fnFireDomChanged,true);window.addEventListener("oanimationend",this._fnFireDomChanged,true);q(window).on("resize",this._fnFireDomChanged);window.addEventListener("scroll",this._onScroll,true);this._aIgnoredMutations=[];this._aWhiteList=[];};a.prototype.exit=function(){this._stopMutationObserver();window.removeEventListener("transitionend",this._fnFireDomChanged,true);window.removeEventListener("animationend",this._fnFireDomChanged,true);q(window).off("resize",this._fnFireDomChanged);window.removeEventListener("scroll",this._onScroll,true);};a.prototype.ignoreOnce=function(p){this._aIgnoredMutations.push(p);};a.prototype.addToWhiteList=function(i){this._aWhiteList.push(i);};a.prototype.removeFromWhiteList=function(i){this._aWhiteList=this._aWhiteList.filter(function(c){return c!==i;});};a.prototype.isRelevantNode=function(n){return(document.body.contains(n)&&!D.contains('sap-ui-preserve',n)&&(this._aWhiteList.some(function(i){return(D.contains(i,n)||n.contains(document.getElementById(i)));})));};a.prototype._startMutationObserver=function(){if(this._oMutationObserver){return;}var a=window.MutationObserver;if(a){this._oMutationObserver=new a(function(m){var t=[];var e=[];m.forEach(function(o){var T=o.target;if(o.type==="characterData"){T=o.target.parentNode;}if(this.isRelevantNode(T)){var i=this._aIgnoredMutations.some(function(I,c,S){if(I.target===o.target&&(!I.type||I.type===o.type)){S.splice(c,1);return true;}});if(!i){t.push(T);var b=O.getClosestOverlayForNode(T);var s=b?b.getElement().getId():undefined;if(s){e.push(s);}}}}.bind(this));if(t.length){this.fireDomChanged({type:"mutation",elementIds:e,targetNodes:t});}}.bind(this));this._oMutationObserver.observe(window.document,{childList:true,subtree:true,attributes:true,attributeFilter:["style","class","width","height","border"],characterData:true});}else{q.sap.log.error("Mutation Observer is not available");}};a.prototype._stopMutationObserver=function(){if(this._oMutationObserver){this._oMutationObserver.disconnect();delete this._oMutationObserver;}};a.prototype._fireDomChangeOnScroll=function(e){var t=e.target;if(this.isRelevantNode(t)&&!O.getClosestOverlayForNode(t)&&t!==document){this.fireDomChanged({type:"scroll"});}};return a;},true);
