/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/dt/OverlayRegistry','sap/ui/dt/Util','./library'],function(M,O,U){"use strict";var S=M.extend("sap.ui.dt.SelectionManager",{metadata:{library:"sap.ui.dt",properties:{"mode":{type:"sap.ui.dt.SelectionMode",defaultValue:sap.ui.dt.SelectionMode.Single}},associations:{},aggregations:{},events:{"change":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}}}}});S.prototype.init=function(){this._aSelection=[];};S.prototype.exit=function(){delete this._aSelection;};S.prototype.get=function(){return this._aSelection.slice();};S.prototype.set=function(s){var b=false;var a=false;if(this._aSelection.length==0&&!s){return b;}this._aSelection.forEach(function(o){o.setSelected(false,true);b=true;},this);this._aSelection=[];this._updateMode(this.get());if(s){a=this.add(U.castArray(s));}if(a){return a;}else if(b){this.fireChange({selection:this.get()});}return b;};S.prototype.add=function(s){var b=false;if(!s){return b;}var a=U.castArray(s);a.forEach(function(o){var c=null;c=O.getOverlay(o);if(c&&(this._aSelection.indexOf(c)===-1)){if(c.setSelected(true,true).getSelected()){this._aSelection.push(c);b=true;}}},this);if(b){this._updateMode(this.get());this.fireChange({selection:this.get()});}return b;};S.prototype.remove=function(s){var b=false;if(!s){return b;}var a=U.castArray(s);a.forEach(function(o){var c=null;c=O.getOverlay(o);if(c&&(this._aSelection.indexOf(c)!==-1)){this._aSelection=this._aSelection.filter(function(i){return c!==i;});c.setSelected(false,true);b=true;}},this);if(b){this._updateMode(this.get());this.fireChange({selection:this.get()});}return b;};S.prototype._add=function(o){this._syncSelectionWithMode();this._aSelection=this._aSelection.concat(o);this.fireChange({selection:this.get()});};S.prototype._remove=function(o){this._syncSelectionWithMode();if(this._aSelection.indexOf(o)!==-1){this._aSelection=this._aSelection.filter(function(i){return o!==i;});}this.fireChange({selection:this.get()});};S.prototype._isSingleMode=function(){return this.getMode()===sap.ui.dt.SelectionMode.Single;};S.prototype._syncSelectionWithMode=function(){if(this._isSingleMode()){this._aSelection.forEach(function(o){o.setSelected(false,true);});this._aSelection=[];}};S.prototype._updateMode=function(s){if(s.length>1){this.setMode(sap.ui.dt.SelectionMode.Multi);}else{this.setMode(sap.ui.dt.SelectionMode.Single);}};return S;},true);
