/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/dt/ContextMenuControl',['jquery.sap.global','./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem'],function(q,l,M,a){"use strict";
var C=M.extend("sap.ui.dt.ContextMenuControl",{
metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}},
renderer:{}
});
C.prototype.aStyleClasses=[];
C.prototype.init=function(){M.prototype.init.apply(this,arguments);this.addStyleClass("sapUiDtContextMenu");this._fnOnKeyDown=this._onKeyDown.bind(this);q(document).keydown(this._fnOnKeyDown);this.attachBrowserEvent("contextmenu",this._onContextMenu,this);this._oOverlayDomRef=document.body;};
C.prototype.exit=function(){M.prototype.exit.apply(this,arguments);q(document).off("keydown",this._fnOnKeyDown);delete this._fnOnKeyDown;this.detachBrowserEvent("contextmenu");};
C.prototype.setOverlayDomRef=function(o){this._oOverlayDomRef=o.getDomRef();};
C.prototype.addStyleClass=function(s){if(this.aStyleClasses.indexOf(s)===-1){this.aStyleClasses.push(s);}M.prototype.addStyleClass.apply(this,arguments);};
C.prototype._createSubMenuWithBinding=function(i,r,e){var s=new M({enabled:e});i.forEach(function(I){var S=new a({text:I.text,icon:I.icon,enabled:I.enabled});S.data({id:r,key:I.id});s.addItem(S);});this.aStyleClasses.forEach(function(S){s.addStyleClass(S);});return s;};
C.prototype.setMenuItems=function(m,t){this.destroyItems();var s=[];m.forEach(function(i){if(!i.available||i.available(t)){var e=!i.enabled||i.enabled(t);var T=i.text;if(typeof i.text==="function"){T=i.text(t);}var o=new a({text:T,enabled:e});if(i.submenu){var S=this._createSubMenuWithBinding(i.submenu,i.id,e);o.setSubmenu(S);}o.data({id:i.id});if((i.startSection&&typeof(i.startSection)==="boolean")||(typeof(i.startSection)==="function"&&i.startSection(t.getElement()))){o.setStartsSection(true);}if(s.length>0){s.slice(-1)[0].addItem(o);}else{this.addItem(o);}}},this);return this;};
C.prototype.openMenu=function(o,t){if(this.getItems().length===0||!t.getDomRef()){return;}this.openAsContextMenu(o,t.getDomRef());};
C.prototype._onKeyDown=function(e){if(!this.bOpen){q(document).off("keydown",this._fnOnKeyDown);delete this._fnOnKeyDown;return;}if((e.keyCode===q.sap.KeyCodes.F10)&&(e.shiftKey===true)&&(e.altKey===false)&&(e.ctrlKey===false)){e.preventDefault();}};
C.prototype._onContextMenu=function(e){if(!this.bOpen){this.detachBrowserEvent("contextmenu");return;}if(e.preventDefault){e.preventDefault();}};
return C;},true);
sap.ui.predefine('sap/ui/dt/ManagedObjectObserver',['sap/ui/base/ManagedObject','sap/ui/dt/ElementUtil'],function(M,E){"use strict";
var a=M.extend("sap.ui.dt.ManagedObjectObserver",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{target:{type:"sap.ui.base.ManagedObject"}},events:{modified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},destroyed:{}}}});
a.prototype.init=function(){this._fnFireModified=function(e){var p=e.getParameters();if(e.sId==="_change"){e.sId="propertyChanged";}this.fireModified({type:e.sId,name:p.name,value:p.newValue,oldValue:p.oldValue,target:e.getSource()});}.bind(this);};
a.prototype.exit=function(){this.unobserve();delete this._fnFireModified;};
a.prototype.setTarget=function(t){this.unobserve();this.setAssociation("target",t);var T=this.getTargetInstance();if(T){this.observe(T);}return this;};
a.prototype.observe=function(t){this._bIsObserved=true;t.attachEvent("_change",this._fnFireModified,this);this._fnOriginalDestroy=t.destroy;t.destroy=function(){this.unobserve();var o=t.destroy.apply(t,arguments);this.fireDestroyed();return o;}.bind(this);this._fnOriginalBindProperty=t.bindProperty;t.bindProperty=function(){var o=this._fnOriginalBindProperty.apply(t,arguments);this.fireModified();return o;}.bind(this);this._fnOriginalUnBindProperty=t.unbindProperty;t.unbindProperty=function(){var o=this._fnOriginalUnBindProperty.apply(t,arguments);this.fireModified();return o;}.bind(this);this._fnOriginalBindAggregation=t.bindAggregation;t.bindAggregation=function(s){var o=this._fnOriginalBindAggregation.apply(t,arguments);this.fireModified();return o;}.bind(this);this._fnOriginalUnBindAggregation=t.unbindAggregation;t.unbindAggregation=function(s){var o=this._fnOriginalUnBindAggregation.apply(t,arguments);this.fireModified();return o;}.bind(this);this._fnOriginalSetParent=t.setParent;t.setParent=function(p,s,S){var f=false;if(!t._bInSetParent){f=true;t._bInSetParent=true;}var c=t.getParent();var o=this._fnOriginalSetParent.apply(t,arguments);if(f&&!t.__bSapUiDtSupressParentChangeEvent){t._bInSetParent=false;if(c!==p||s==="dependents"){this.fireModified({type:"setParent",value:p,oldValue:c,target:t});}}return o;}.bind(this);this._fnOriginalAddAggregation=t.addAggregation;t.addAggregation=function(s,o,S){this._bAddOrSetAggregationCall=true;var O=this._fnOriginalAddAggregation.apply(t,arguments);this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});return O;}.bind(this);this._fnOriginalSetAggregation=t.setAggregation;t.setAggregation=function(s,o,S){this._bAddOrSetAggregationCall=true;var O=this._fnOriginalSetAggregation.apply(t,arguments);this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});return O;}.bind(this);this._fnOriginalRemoveAggregation=t.removeAggregation;t.removeAggregation=function(s,o,S){this._bRemoveAggregationCall=true;var O=this._fnOriginalRemoveAggregation.apply(t,arguments);this.fireModified({type:"removeAggregation",name:s,value:o,target:t});return O;}.bind(this);this._fnOriginalInsertAggregation=t.insertAggregation;t.insertAggregation=function(s,o,i,S){this._bInsertAggregationCall=true;var O=this._fnOriginalInsertAggregation.apply(t,arguments);this.fireModified({type:"insertAggregation",name:s,value:o,target:t});return O;}.bind(this);this._fnOriginalRemoveAllAggregation=t.removeAllAggregation;t.removeAllAggregation=function(s,S){this._bRemoveAllAggregationCall=true;var r=t.getAggregation(s);var o=this._fnOriginalRemoveAllAggregation.apply(t,arguments);this.fireModified({type:"removeAllAggregation",name:s,value:r,target:t});return o;}.bind(this);this._fnOriginalDestroyAggregation=t.destroyAggregation;t.destroyAggregation=function(s,S){this._bDestroyAggregationCall=true;var r=t.getAggregation(s);var o=this._fnOriginalDestroyAggregation.apply(t,arguments);this.fireModified({type:"destroyAggregation",name:s,value:r,target:t});return o;}.bind(this);this._fnOriginalAddAssociation=t.addAssociation;t.addAssociation=function(s,o,S){this._bAddOrSetAssociationCall=true;var O=this._fnOriginalAddAssociation.apply(t,arguments);this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});return O;}.bind(this);this._fnOriginalSetAssociation=t.setAssociation;t.setAssociation=function(s,o,S){this._bAddOrSetAssociationCall=true;var O=this._fnOriginalSetAssociation.apply(t,arguments);this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});return O;}.bind(this);this._fnOriginalRemoveAssociation=t.removeAssociation;t.removeAssociation=function(s,o,S){this._bRemoveAssociationCall=true;var O=this._fnOriginalRemoveAssociation.apply(t,arguments);this.fireModified({type:"removeAggregation",name:s,value:o,target:t});return O;}.bind(this);this._fnOriginalRemoveAllAssociation=t.removeAllAssociation;t.removeAllAssociation=function(s,S){this._bRemoveAllAssociationCall=true;var r=t.getAssociation(s);var o=this._fnOriginalRemoveAllAssociation.apply(t,arguments);this.fireModified({type:"removeAllAggregation",name:s,value:r,target:t});return o;}.bind(this);this._aOriginalAddMutators={};this._aOriginalInsertMutators={};this._aOriginalRemoveMutators={};this._aOriginalRemoveAllMutators={};this._aOriginalDestructors={};var A=t.getMetadata().getAllAggregations();Object.keys(A).forEach(function(s){var o=A[s];var _=t[o._sMutator];this._aOriginalAddMutators[o.name]=_;t[o._sMutator]=function(O){this._bAddOrSetAggregationCall=false;var v;v=_.apply(t,arguments);if(!this._bAddOrSetAggregationCall){this.fireModified({type:"addOrSetAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var b=t[o._sInsertMutator];this._aOriginalInsertMutators[o.name]=b;t[o._sInsertMutator]=function(O,i){this._bInsertAggregationCall=false;var v;v=b.apply(t,arguments);if(!this._bInsertAggregationCall){this.fireModified({type:"insertAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var c=t[o._sRemoveMutator];this._aOriginalRemoveMutators[o.name]=c;t[o._sRemoveMutator]=function(O,S){this._bRemoveAggregationCall=false;var v=c.apply(t,arguments);if(!this._bRemoveAggregationCall){this.fireModified({type:"removeAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var d=t[o._sRemoveAllMutator];this._aOriginalRemoveAllMutators[o.name]=d;t[o._sRemoveAllMutator]=function(S){this._bRemoveAllAggregationCall=false;var r=this.getAggregation(s);var O=d.apply(t,arguments);if(!this._bRemoveAllAggregationCall){this.fireModified({type:"removeAllAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);var e=t[o._sDestructor];this._aOriginalDestructors[o.name]=e;t[o._sDestructor]=function(S){this._bDestroyAggregationCall=false;var r=this.getAggregation(s);var O=e.apply(t,arguments);if(!this._bDestroyAggregationCall){this.fireModified({type:"destroyAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);}.bind(this),this);var m=t.getMetadata().getAllAssociations();Object.keys(m).forEach(function(s){var o=m[s];var _=t[o._sMutator];this._aOriginalAddMutators[o.name]=_;t[o._sMutator]=function(O){this._bAddOrSetAssociationCall=false;var v;v=_.apply(t,arguments);if(!this._bAddOrSetAssociationCall){this.fireModified({type:"addOrSetAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var b=t[o._sRemoveMutator];this._aOriginalRemoveMutators[o.name]=b;t[o._sRemoveMutator]=function(O,S){this._bRemoveAssociationCall=false;var v=b.apply(t,arguments);if(!this._bRemoveAssociationCall){this.fireModified({type:"removeAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var c=t[o._sRemoveAllMutator];this._aOriginalRemoveAllMutators[o.name]=c;t[o._sRemoveAllMutator]=function(S){this._bRemoveAllAssociationCall=false;var r=this.getAssociation(s);var O=c.apply(t,arguments);if(!this._bRemoveAllAssociationCall){this.fireModified({type:"removeAllAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);}.bind(this),this);};
a.prototype.unobserve=function(){var t=this.getTargetInstance();if(this._bIsObserved&&t){this._bIsObserved=false;t.destroy=this._fnOriginalDestroy;t.bindProperty=this._fnOriginalBindProperty;t.unbindProperty=this._fnOriginalUnBindProperty;t.bindAggregation=this._fnOriginalBindAggregation;t.unbindAggregation=this._fnOriginalUnBindAggregation;t.setParent=this._fnOriginalSetParent;t.addAggregation=this._fnOriginalAddAggregation;t.removeAggregation=this._fnOriginalRemoveAggregation;t.insertAggregation=this._fnOriginalInsertAggregation;t.setAggregation=this._fnOriginalSetAggregation;t.removeAllAggregation=this._fnOriginalRemoveAllAggregation;t.destroyAggregation=this._fnOriginalDestroyAggregation;t.addAssociation=this._fnOriginalAddAssociation;t.removeAssociation=this._fnOriginalRemoveAssociation;t.setAssociation=this._fnOriginalSetAssociation;t.removeAllAssociation=this._fnOriginalRemoveAllAssociation;var A=t.getMetadata().getAllAggregations();Object.keys(A).forEach(function(s){var o=A[s];t[o._sMutator]=this._aOriginalAddMutators[o.name];t[o._sInsertMutator]=this._aOriginalInsertMutators[o.name];t[o._sRemoveMutator]=this._aOriginalRemoveMutators[o.name];t[o._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[o.name];t[o._sDestructor]=this._aOriginalDestructors[o.name];},this);var m=t.getMetadata().getAllAssociations();Object.keys(m).forEach(function(s){var o=m[s];t[o._sMutator]=this._aOriginalAddMutators[o.name];t[o._sRemoveMutator]=this._aOriginalRemoveMutators[o.name];t[o._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[o.name];},this);t.detachEvent("_change",this._fnFireModified,this);}delete this._fnOriginalDestroy;delete this._fnOriginalBindProperty;delete this._fnOriginalUnBindProperty;delete this._fnOriginalBindAggregation;delete this._fnOriginalUnBindAggregation;delete this._fnOriginalSetParent;delete this._fnOriginalAddAggregation;delete this._fnOriginalRemoveAggregation;delete this._fnOriginalInsertAggregation;delete this._fnOriginalSetAggregation;delete this._fnOriginalRemoveAllAggregations;delete this._fnOriginalDestroyAggregation;delete this._aOriginalAddMutators;delete this._aOriginalInsertMutators;delete this._aOriginalRemoveMutators;delete this._aOriginalRemoveAllMutators;delete this._aOriginalDestructors;};
a.prototype.getTargetInstance=function(){return E.getElementInstance(this.getTarget());};
return a;},true);
sap.ui.predefine('sap/ui/dt/MetadataPropagationUtil',['jquery.sap.global','sap/ui/dt/Util'],function(q,U){"use strict";var M={};
M._getParentPropagationInfo=function(a){if(!a||!a["propagationInfos"]){return false;}return q.extend([],a["propagationInfos"]);};
M._getCurrentRelevantContainerPropagation=function(e,E){var n={};if(!e.propagateRelevantContainer){return n;}else if(typeof e.propagateRelevantContainer==="function"){n.relevantContainerFunction=e.propagateRelevantContainer;n.relevantContainerElement=E;}else if(typeof e.propagateRelevantContainer==="boolean"&&e.propagateRelevantContainer){n.relevantContainerFunction=function(){return true;};n.relevantContainerElement=E;}else{var o=U.wrapError("Wrong type: it should be either a function or a boolean value and it is:"+typeof e.propagateRelevantContainer);var l='sap.ui.dt.MetadataPropagationUtil#_getCurrentRelevantContainerPropagation';o.name='Error in '+l;o.message=U.printf("{0} / {1}",l,o.message);throw o;}return n;};
M._getCurrentDesigntimePropagation=function(e,E){var n={};if(!e.propagateMetadata){return n;}else if(typeof e.propagateMetadata==="function"){n.relevantContainerElement=E;n.metadataFunction=e.propagateMetadata;}else{var o=U.wrapError("Wrong type: it should be a function and it is:"+typeof e.propagateRelevantContainer);var l='sap.ui.dt.MetadataPropagationUtil#_getCurrentDesigntimePropagation';o.name='Error in '+l;o.message=U.printf("{0} / {1}",l,o.message);throw o;}return n;};
M._setPropagationInfo=function(m,n,p){if(!p&&q.isEmptyObject(n)){return false;}m.propagationInfos=p?p:[];if(!q.isEmptyObject(n)){m.propagationInfos.push(n);}return m;};
M.propagateMetadataToAggregationOverlay=function(o,e,p){var n,m,r,a=q.extend({},o);var P=M._getParentPropagationInfo(p);if(a&&!q.isEmptyObject(a)){r=M._getCurrentRelevantContainerPropagation(a,e);m=M._getCurrentDesigntimePropagation(a,e);}if(P||!q.isEmptyObject(r)||!q.isEmptyObject(m)){n=q.extend(r,m);return M._setPropagationInfo(a,n,P);}else{return a;}};
M._getPropagation=function(p,e,c){if(!p||!p.propagationInfos){return false;}p.propagationInfos.some(function(P){return c(P);});};
M.getRelevantContainerForPropagation=function(p,e){var P=false;M._getPropagation(p,e,function(o){if(o.relevantContainerFunction&&o.relevantContainerFunction(e)){P=o.relevantContainerElement;return true;}});return P?P:false;};
M.getMetadataForPropagation=function(p,e){var r=false;M._getPropagation(p,e,function(P){if(P.metadataFunction){r=P.metadataFunction(e,P.relevantContainerElement);return r?true:false;}});return r?r:false;};
M.propagateMetadataToElementOverlay=function(t,p,e){var P=M.getRelevantContainerForPropagation(p,e);var v=M.getMetadataForPropagation(p,e);if(!P&&!v){return t;}var r=q.extend(true,{},t);if(P){r.relevantContainer=P;}if(v){if(v.actions===null){var a=e.getMetadata().getAllAggregations();var A=Object.keys(a);if(r.aggregations){A=A.concat(Object.keys(r.aggregations).filter(function(s){return A.indexOf(s)<0;}));}else{r.aggregations={};}A.forEach(function(s){if(r.aggregations[s]&&r.aggregations[s].actions){r.aggregations[s].actions=null;}});}return q.extend(true,r,v);}return r;};
return M;},true);
sap.ui.predefine('sap/ui/dt/MiniMenuControl',['jquery.sap.global','./library','sap/ui/unified/Menu','sap/ui/core/Control'],function(q,l,M,C){"use strict";
var a=C.extend('sap.ui.dt.MiniMenuControl',{
metadata:{properties:{"maxButtonsDisplayed":{type:"int",defaultValue:4},"buttons":{type:"object[]",defaultValue:[]},styleClass:{type:"string"}},events:{Opened:{},Closed:{},OverflowButtonPressed:{}}},
init:function(){var p=this.getId()+"-popover";var P=new sap.m.Popover(p,{showHeader:false,verticalScrolling:false,horizontalScrolling:false,content:new sap.m.HBox(p+"ContentBox",{renderType:"Bare"})});P.attachBrowserEvent("keydown",this._changeFocusOnArrowKey,this);P.oPopup.attachClosed(this._popupClosed,this);this.addDependent(P);P.addStyleClass("sapUiDtMiniMenu");var s=this.getId()+"-popoverExp";var o=new sap.m.Popover(s,{showHeader:false,verticalScrolling:false,horizontalScrolling:false,content:new sap.m.VBox(s+"ContentBox",{renderType:"Bare"})});o.attachBrowserEvent("keydown",this._changeFocusOnArrowKey,this);o.oPopup.attachClosed(this._popupClosed,this);this.addDependent(o);o.addStyleClass("sapUiDtMiniMenu");P.attachBrowserEvent("contextmenu",this._onContextMenu,this);o.attachBrowserEvent("contextmenu",this._onContextMenu,this);this.bOnInit=true;var S;try{S=sap.ui.getCore().getStaticAreaRef();S=sap.ui.getCore().getUIArea(S);}catch(e){q.sap.log.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}S.addContent(this,true);},
exit:function(){this.getPopover(true).oPopup.detachOpened(this._popupOpened,this);this.getPopover(false).oPopup.detachOpened(this._popupOpened,this);this.getPopover(true).oPopup.detachClosed(this._popupClosed,this);this.getPopover(false).oPopup.detachClosed(this._popupClosed,this);this.getPopover(true).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(false).detachBrowserEvent("contextmenu",this._onContextMenu,this);},
show:function(s,c,o){this._close=function(e){if(e.isTrusted){this.close();}}.bind(this);if(this._bUseExpPop===undefined){this._bUseExpPop=!!c;}this._bCompactMode=q(s.getDomRef()).attr("class").indexOf("sapUiSizeCompact")>-1;this._bOpenAsContextMenu=c;this._oContextMenuPosition=o;this.getPopover(true).addStyleClass(this.getStyleClass()||"");this.getPopover(false).addStyleClass(this.getStyleClass()||"");var b=this.getButtons();this._oTarget=s;if(!this._bOpenAsContextMenu){this._setButtonsForMiniMenu(b,s);}else{this._makeAllButtonsVisible(b);}if(this.bOnInit||!this.getPopover().isOpen()){this.finalizeOpening();this.bOnInit=false;}},
finalizeOpening:function(){if(this._bOpenAsContextMenu&&this._oContextMenuPosition.x===null&&this._oContextMenuPosition.y===null){this._bOpenAsContextMenu=false;}this._oTarget=this._placeMiniMenu(this._oTarget,this._bOpenAsContextMenu,this._bUseExpPop);this.getPopover().openBy(this._oTarget);this._placeMiniMenuWrapper();this.getPopover().setVisible(true);this.bOpen=true;this.bOpenNew=false;this.fireOpened();},
_setButtonsForMiniMenu:function(b,s){var B=this._getNumberOfEnabledButtons(b);if(B!==0){this._hideDisabledButtons(b);}this._iButtonsVisible=this._hideButtonsInOverflow(b);if(this._iButtonsVisible===this.getMaxButtonsDisplayed()&&this._iButtonsVisible!==b.length){this._replaceLastVisibleButtonWithOverflowButton(b);}else if(B<b.length&&B!=0){this.addButton(this._createOverflowButton());}B=null;},
_makeAllButtonsVisible:function(b){this._iFirstVisibleButtonIndex=0;b.forEach(function(B){B.setVisible(true);B._bInOverflow=true;});},
_getNumberOfEnabledButtons:function(b){var B=0;for(var i=0;i<b.length;i++){if(b[i].getEnabled()){B++;if(!this._iFirstVisibleButtonIndex){this._iFirstVisibleButtonIndex=i;}}}return B;},
_hideDisabledButtons:function(b){var v=0;b.forEach(function(B){B.setVisible(B.getEnabled());if(B.getEnabled()){v++;}});return v;},
_hideButtonsInOverflow:function(b){var v=0;for(var i=0;i<b.length;i++){if(v<this.getMaxButtonsDisplayed()&&b[i].getVisible()){v++;}else{b[i].setVisible(false);}}return v;},
_replaceLastVisibleButtonWithOverflowButton:function(b){for(var i=b.length-1;i>=0;i--){if(b[i].getVisible()){b[i].setVisible(false);this.addButton(this._createOverflowButton());return;}}},
_placeMiniMenu:function(s,c,e){this.getPopover().setShowArrow(true);var o=(s.getId&&s.getId())||s.getAttribute("overlay");var p=this._getPopoverDimensions(e,!c);var O=this._getOverlayDimensions(o);var v=this._getViewportDimensions();var P={};if(c){P=this._placeAsContextMenu(this._oContextMenuPosition,p,v);}else{P=this._placeAsMiniMenu(O,p,v);}P.top-=O.top;P.left-=O.left;q("#fakeDiv").remove();q("#"+o).append("<div id=\"fakeDiv\" overlay=\""+o+"\" style = \"position:absolute;top:"+P.top+"px;left:"+P.left+"px;\" />");o=null;return document.getElementById("fakeDiv");},
_placeAsContextMenu:function(c,p,v){this.getPopover().setShowArrow(false);var P={};if(v.height-c.y>=p.height){P.top=c.y;this.getPopover().setPlacement("Bottom");}else if(c.y>=p.height){P.top=c.y;this.getPopover().setPlacement("Top");}else if(v.height>=p.height){P.top=v.height-p.height;this.getPopover().setPlacement("Bottom");}else{q.error("Your screen size is not supported!");}if(v.width-c.x>=p.width){P.left=c.x;}else if(c.x>=p.width){P.left=c.x-p.width;}else if(v.width>=p.width){P.left=v.width-p.width;}else{q.error("Your screen size is not supported!");}return P;},
_placeAsMiniMenu:function(o,p,v){this.getPopover().setShowArrow(true);var P={top:null,left:null};if(o.top>=p.height&&v.width>=p.width){P=this._placeMiniMenuOnTop(o);}else if(v.height-o.top>=p.height+5&&v.height>=p.height+5&&v.width>=p.width){P=this._placeMiniMenuAtTheBottom(o,p,v);}else if(v.height>=p.height&&v.width>=p.width){P=this._placeMiniMenuSideways(o,p,v);}else{q.error("Your screen size is not supported!");}return P;},
_placeMiniMenuOnTop:function(o){var p={};this.getPopover().setPlacement("Top");p.top=o.top;p.left=o.left+o.width/2;return p;},
_placeMiniMenuAtTheBottom:function(o,p,v){this.getPopover().setPlacement("Bottom");var P={};P.left=o.left+o.width/2;if(o.height<60&&v.height-o.top-o.height>=p.height){P.top=o.bottom;}else if(o.top>=v.top){P.top=o.top+5;}else{P.top=v.top+5;}return P;},
_placeMiniMenuSideways:function(o,p,v){var P={};P.left=this._getMiniMenuSidewaysPlacement(o,p,v);P.top=this._getMiddleOfOverlayAndViewportEdges(o,v);return P;},
_getMiniMenuSidewaysPlacement:function(o,p,v){var L;if(v.width-o.right>=p.width){this.getPopover().setPlacement("Right");L=o.right;}else if(o.left>=p.width){this.getPopover().setPlacement("Left");L=o.left;}else{this.getPopover().setPlacement("Right");if(p.width<=v.width-(o.left+o.width/2)){L=(o.left+o.width/2);}else{L=v.width-p.width;}}return L;},
_getMiddleOfOverlayAndViewportEdges:function(o,v){var t;if(v.top>o.top){t=v.top;}else{t=o.top;}if(v.bottom<o.bottom){t+=v.bottom;}else{t+=o.bottom;}t/=2;return t;},
_placeMiniMenuWrapper:function(){q("#MiniMenuWrapper").remove();var p=q(this.getPopover().getDomRef());var A=parseInt(q("#"+this.getPopover().getId()+"-arrow").height(),10);var P=parseInt(p.css("top"),10)-p.position().top-A;var i=parseInt(p.css("left"),10)-p.position().left-A;var b=parseInt(p.css("width"),10)+2*A;var c=parseInt(p.css("height"),10)+2*A;var d=p.css("z-index")-1;q(sap.ui.getCore().getStaticAreaRef()).append("<div id=\"MiniMenuWrapper\" style = \"position:absolute;top:"+P+"px;left:"+i+"px;width:"+b+"px;height:"+c+"px;z-index:"+d+"\" />");},
_getPopoverDimensions:function(e,w){var p={};var c=this._bCompactMode;var b=this._getButtonHeight(c);var B=this._getButtonWidth(c);var A=this._getArrowHeight(c);var i=this._getBaseFontSize();p.height=i*b;this._iFirstVisibleButtonIndex=null;if(e){p.height*=this.getButtons().length-1;p.width=parseInt(q("#"+this.getPopover().getId()).css("width"),10)||80;}else{p.width=i*B*this._iButtonsVisible;}if(w){var d=i*A;if(d){p.height+=2*d;p.width+=2*d;}}return p;},
_getButtonHeight:function(c){return c?2:3;},
_getButtonWidth:function(c){return c?2:2.5;},
_getArrowHeight:function(c){if(sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.edge){return c?0.5:0.5;}else{return c?0.5625:0.5625;}},
_getBaseFontSize:function(){return parseInt(q(document.documentElement).css("fontSize"),10);},
_getOverlayDimensions:function(o){var O=q("#"+o).rect();O.right=O.left+O.width;O.bottom=O.top+O.height;return O;},
_getViewportDimensions:function(){var v={};v.width=window.innerWidth;v.height=window.innerHeight;v.top=parseInt(q(".type_standalone").css("height"),10)||0;v.bottom=v.top+v.height;return v;},
addButton:function(b,s,o){function h(){this.bOpen=false;this.bOpenNew=false;s._onItemSelected(this);}if(b.icon==null){b.icon="sap-icon://incident";}b.getText=function(o){return typeof b.text==="function"?b.text(o):b.text;};b.getEnabled=function(o){return typeof b.enabled==="function"?b.enabled(o):b.enabled;};var B;var c;if(s){B=new sap.m.Button({icon:b.icon?b.icon:"sap-icon://incident",tooltip:b.getText(o),type:"Transparent",enabled:b.getEnabled(o),press:h,layoutData:new sap.m.FlexItemData({})});B.data({id:b.id,key:b.id});c=new sap.m.Button({icon:b.icon?b.icon:"sap-icon://incident",text:b.getText(o),type:"Transparent",enabled:b.getEnabled(o),press:h,layoutData:new sap.m.FlexItemData({})});c.data({id:b.id,key:b.id});}else{B=new sap.m.Button({icon:b.icon,tooltip:b.getText(o),type:"Transparent",enabled:b.getEnabled(o),press:b.handler,layoutData:new sap.m.FlexItemData({})});c=new sap.m.Button({icon:b.icon,text:b.getText(o),type:"Transparent",enabled:b.getEnabled(o),press:b.handler,layoutData:new sap.m.FlexItemData({})});}this.setProperty("buttons",this.getProperty("buttons").concat(b));this.getFlexbox(true).addItem(c);this.getFlexbox(false).addItem(B);B=null;c=null;return this;},
close:function(){if(this.getPopover()){this.getPopover(true).close();this.getPopover(false).close();if(this.getProperty("buttons").length>this.getProperty("maxButtonsDisplayed")){this.setProperty("buttons",this.getProperty("buttons").splice(0,this.getProperty("buttons").length-1));this.getFlexbox().removeItem(this.getButtons().length-1);}}return this;},
removeButton:function(i){this.setProperty("buttons",this.getProperty("buttons").splice(i,1));this.getFlexbox(true).removeItem(i);return this.getFlexbox(false).removeItem(i);},
removeAllButtons:function(){this.setProperty("buttons",[]);this.getFlexbox(true).removeAllItems();return this.getFlexbox(false).removeAllItems();},
getButtons:function(){return this.getFlexbox().getItems();},
insertButton:function(b,i){this.getFlexbox().insertItem(b,i);return this;},
setButtons:function(_,s,o){this.removeAllButtons();if(o){_.forEach(function(b){this.addButton(b,s,o);}.bind(this));}else{_.forEach(function(b){this.addButton(b,s);}.bind(this));}},
setMaxButtonsDisplayed:function(m){if(m<2){throw Error("maxButtonsDisplayed can't be less than two!");}this.setProperty("maxButtonsDisplayed",m);},
getPopover:function(e){if(e===undefined){if(this._bUseExpPop){return this.getDependents()[1];}else{return this.getDependents()[0];}}else if(e){return this.getDependents()[1];}else{return this.getDependents()[0];}},
getFlexbox:function(e){return this.getPopover(e).getContent()[0];},
_createOverflowButton:function(){return{icon:"sap-icon://overflow",type:"Transparent",handler:this._onOverflowPress.bind(this),enabled:true};},
setOpenNew:function(v){this.bOpenNew=v;},
_onOverflowPress:function(e){this.fireOverflowButtonPressed();var b=this.getButtons();this.getPopover().close();this._bUseExpPop=true;this.getButtons()[b.length-1].setVisible(false);var f=this._placeMiniMenu(this._oTarget,false,true);this.getPopover().openBy(f);},
_popupClosed:function(){q("#MiniMenuWrapper").remove();if(this.getPopover()){this.fireClosed();if(this.bOpenNew){this.bOpenNew=false;this.finalizeOpening();return;}}this.bOpen=false;},
_setFocusOnButton:function(b){if(b.getEnabled()&&b.getVisible()){b.focus();return true;}},
_changeFocusOnKeyStroke:function(e){if(document.activeElement){var i=document.activeElement.id;switch(e.key){case"ArrowRight":this._changeFocusOnButtons(i);break;case"ArrowLeft":this._changeFocusOnButtons(i,true);break;case"ArrowUp":this._changeFocusOnButtons(i,true);break;case"ArrowDown":this._changeFocusOnButtons(i);break;case"Tab":if(sap.ui.Device.browser.safari){if(e.shiftKey){this._changeFocusOnButtons(i,true);}else{this._changeFocusOnButtons(i);}}break;default:break;}}},
_changeFocusOnButtons:function(i,p){this.getButtons().some(function(b,I,A){if(i===b.getId()){if(p){this._setFocusOnPreviousButton(A,I);}else{this._setFocusOnNextButton(A,I);}return true;}}.bind(this));},
_setFocusOnNextButton:function(b,i){for(var c=i+1;c<b.length;c++){if(this._setFocusOnButton(b[c])){return;}}for(var d=0;d<i;d++){if(this._setFocusOnButton(b[d])){return;}}},
_setFocusOnPreviousButton:function(b,i){for(var c=i-1;c>=0;c--){if(this._setFocusOnButton(b[c])){return;}}for(var d=b.length-1;d>=i;d--){if(this._setFocusOnButton(b[d])){return;}}},
_onContextMenu:function(e){if(!this.getPopover().isOpen()){this.detachBrowserEvent("contextmenu");return;}if(e.preventDefault){e.preventDefault();}},
renderer:function(){}
});
return a;},true);
sap.ui.predefine('sap/ui/dt/MutationObserver',['jquery.sap.global','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementUtil','sap/ui/base/ManagedObject','sap/ui/dt/DOMUtil'],function(q,O,E,M,D){"use strict";
var a=M.extend("sap.ui.dt.MutationObserver",{metadata:{library:"sap.ui.dt",events:{domChanged:{parameters:{type:{type:"string"},elemenIds:{type:"string[]"},targetNodes:{type:"element[]"}}}}}});
a.prototype.init=function(){this._fnFireDomChanged=function(){this.fireDomChanged();}.bind(this);this._onScroll=this._fireDomChangeOnScroll.bind(this);this._startMutationObserver();window.addEventListener("transitionend",this._fnFireDomChanged,true);window.addEventListener("webkitTransitionEnd",this._fnFireDomChanged,true);window.addEventListener("otransitionend",this._fnFireDomChanged,true);window.addEventListener("animationend",this._fnFireDomChanged,true);window.addEventListener("webkitAnimationEnd",this._fnFireDomChanged,true);window.addEventListener("oanimationend",this._fnFireDomChanged,true);q(window).on("resize",this._fnFireDomChanged);window.addEventListener("scroll",this._onScroll,true);this._aIgnoredMutations=[];this._aWhiteList=[];};
a.prototype.exit=function(){this._stopMutationObserver();window.removeEventListener("transitionend",this._fnFireDomChanged,true);window.removeEventListener("animationend",this._fnFireDomChanged,true);q(window).off("resize",this._fnFireDomChanged);window.removeEventListener("scroll",this._onScroll,true);};
a.prototype.ignoreOnce=function(p){this._aIgnoredMutations.push(p);};
a.prototype.addToWhiteList=function(i){this._aWhiteList.push(i);};
a.prototype.removeFromWhiteList=function(i){this._aWhiteList=this._aWhiteList.filter(function(c){return c!==i;});};
a.prototype.isRelevantNode=function(n){return(document.body.contains(n)&&!D.contains('sap-ui-preserve',n)&&(this._aWhiteList.some(function(i){return(D.contains(i,n)||n.contains(document.getElementById(i)));})));};
a.prototype._startMutationObserver=function(){if(this._oMutationObserver){return;}var a=window.MutationObserver;if(a){this._oMutationObserver=new a(function(m){var t=[];var e=[];m.forEach(function(o){var T=o.target;if(o.type==="characterData"){T=o.target.parentNode;}if(this.isRelevantNode(T)){var i=this._aIgnoredMutations.some(function(I,c,S){if(I.target===o.target&&(!I.type||I.type===o.type)){S.splice(c,1);return true;}});if(!i){t.push(T);var b=O.getClosestOverlayForNode(T);var s=b?b.getElement().getId():undefined;if(s){e.push(s);}}}}.bind(this));if(t.length){this.fireDomChanged({type:"mutation",elementIds:e,targetNodes:t});}}.bind(this));this._oMutationObserver.observe(window.document,{childList:true,subtree:true,attributes:true,attributeFilter:["style","class","width","height","border"],characterData:true});}else{q.sap.log.error("Mutation Observer is not available");}};
a.prototype._stopMutationObserver=function(){if(this._oMutationObserver){this._oMutationObserver.disconnect();delete this._oMutationObserver;}};
a.prototype._fireDomChangeOnScroll=function(e){var t=e.target;if(this.isRelevantNode(t)&&!O.getClosestOverlayForNode(t)&&t!==document){this.fireDomChanged({type:"scroll"});}};
return a;},true);
sap.ui.predefine('sap/ui/dt/OverlayUtil',['jquery.sap.global','sap/ui/dt/OverlayRegistry','sap/ui/dt/ElementUtil'],function(q,O,E){"use strict";var c={};
c.isInTargetZoneAggregation=function(e){var a=e.getParent();return a&&a.isTargetZone&&a.isTargetZone();};
c.getParentInformation=function(e){var p=e.getParentElementOverlay();if(p){var P=p.getElement();var s=e.getParentAggregationOverlay().getAggregationName();var C=E.getAggregation(P,s);var o=e.getElement();var i=C.indexOf(o);return{parent:P,aggregation:s,index:i};}else{return{parent:null,aggregation:"",index:-1};}};
c.getClosestOverlayFor=function(e){if(!e){return null;}var p=e;var P=O.getOverlay(p);while(p&&!P){p=p.getParent();P=O.getOverlay(p);}return P;};
c.getGeometry=function(g){var m,a,b,d;g.forEach(function(e){if(e){if(!m||e.position.left<m){m=e.position.left;}if(!b||e.position.top<b){b=e.position.top;}var r=e.position.left+e.size.width;if(!a||r>a){a=r;}var B=e.position.top+e.size.height;if(!d||B>d){d=B;}}});if(typeof m==="number"){return{size:{width:a-m,height:d-b},position:{left:m,top:b},visible:true};}};
c.getClosestOverlayForType=function(t,o){while(o&&!E.isInstanceOf(o.getElement(),t)){o=o.getParentElementOverlay();}return o;};
c.getClosestScrollable=function(o){if(!o){return undefined;}o=o.getParent();while(o&&o.isScrollable&&!o.isScrollable()){o=o.getParent();}return o&&o.isScrollable?o:null;};
c.getFirstDescendantByCondition=function(o,C){if(!C){throw new Error("expected condition is 'undefined' or not a function");}var a=c.getAllChildOverlays(o);for(var i=0,n=a.length;i<n;i++){var b=a[i];if(C(b)){return b;}var d=this.getFirstDescendantByCondition(b,C);if(d){return d;}}return undefined;};
c.getAllChildOverlays=function(e){var C=[],a=[];if(!e){return C;}var A=e.getChildren();for(var i=0;i<A.length;i++){a=A[i].getChildren();if(a&&a.length>0){C=C.concat(a);}}return C;};
c.getFirstChildOverlay=function(o){var C=this.getAllChildOverlays(o);if(C.length){return C[0];}return undefined;};
c.getLastChildOverlay=function(o){var C=this.getAllChildOverlays(o);if(C.length){return C[C.length-1];}return undefined;};
c.getNextSiblingOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(p){var a=p.getChildren();var i=a.indexOf(o);if(i!==a.length-1){return a[i+1];}else if(i===a.length-1){var P=o.getParentElementOverlay();a=P.getAggregationOverlays();for(i=a.indexOf(p)+1;i<a.length;i++){var b=a[i].getChildren();if(b.length){return b[0];}}}}};
c.getPreviousSiblingOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(p){var a=p.getChildren();var i=a.indexOf(o);if(i>0){return a[i-1];}else if(i===0){var P=o.getParentElementOverlay();a=P.getAggregationOverlays();for(i=a.indexOf(p)-1;i>=0;i--){var b=a[i].getChildren();if(b.length){return b[b.length-1];}}}}};
c.getNextOverlay=function(o){if(!o){return undefined;}var f=this.getFirstChildOverlay(o);if(f){return f;}var n=this.getNextSiblingOverlay(o);if(n){return n;}do{o=o.getParentElementOverlay();n=this.getNextSiblingOverlay(o);}while(o&&!n);return n;};
c.getPreviousOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(!p){return undefined;}var P=this.getPreviousSiblingOverlay(o);if(P){var l=P;do{P=l;l=this.getLastChildOverlay(P);}while(l);return P;}return o.getParentElementOverlay();};
c.getRootOverlay=function(o){var p=o;do{o=p;p=o.getParentElementOverlay();}while(p);return o;};
c.iterateOverlayElementTree=function(e,C){C(e);e.getAggregationOverlays().forEach(function(a){a.getChildren().forEach(function(o){this.iterateOverlayElementTree(o,C);},this);},this);};
c.iterateOverAggregationLikeChildren=function(e,a,C){var o=e.getElement();var v;if(e.getAggregationOverlay(a).isAssociation()){v=E.getAssociationInstances(o,a);}else{v=E.getAggregation(o,a);}E.iterateOverElements(v,C);};
c.iterateOverlayTree=function(o,C){C(o);o.getChildren().forEach(function(a){this.iterateOverlayTree(a,C);},this);};
c.isInOverlayContainer=function(n){return n&&q(n).closest(".sapUiDtOverlay, #overlay-container").length>0;};
c.getClosestOverlayForNode=function(n){var e=E.getClosestElementForNode(n);return c.getClosestOverlayFor(e);};
c.findAllSiblingOverlaysInContainer=function(o,r){var p=o.getParentElementOverlay();var R=[];if(p){if(p!==r){var P=c.findAllSiblingOverlaysInContainer(p,r);R=P.map(function(p){var a=p.getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName());return a?a.getChildren():[];}).reduce(function(f,C){return f.concat(C);},[]);}else{R=o.getParentElementOverlay().getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName()).getChildren();}}R=R.filter(function(o){return o.getDesignTimeMetadata();});return R;};
c.findAllOverlaysInContainer=function(o){var r=o.getRelevantContainer()||o.getElement();var R=O.getOverlay(r);var a=[];var m=c._findAllSiblingsAndParents(o,R,0);if(m[0]){for(var l in m){a=a.concat(m[l]);}var C=[];m[0].forEach(function(o){C=C.concat(c._findAllChildrenInContainer(o,r));});a=a.concat(C);}else{a=c._findAllChildrenInContainer(o,r);}a.push(R);a=a.filter(function(o){return o.getDesignTimeMetadata();});return a;};
c._findAllSiblingsAndParents=function(o,r,l){var p=o.getParentElementOverlay();if(!p){return[];}if(p!==r){var P=c._findAllSiblingsAndParents(p,r,l+1);var d=P[l+1].map(function(p){var a=p.getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName());return a?a.getChildren():[];}).reduce(function(a,b){return a.concat(b);},[]);P[l]=d;return P;}var C=o.getParentElementOverlay().getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName()).getChildren();var R={};R[l]=C;return R;};
c._findAllChildrenInContainer=function(e,r,_){_=_?_:[];if(e.getChildren().length>0){e.getChildren().forEach(function(a){a.getChildren().forEach(function(C){if(C.getRelevantContainer()===r){_.push(C);c._findAllChildrenInContainer(C,r,_);}});});}return _;};
c.findAllUniqueAggregationOverlaysInContainer=function(o,r){var a=c.findAllSiblingOverlaysInContainer(o,r);return a.map(function(o){return o.getParentAggregationOverlay();}).filter(function(o,p,A){return A.indexOf(o)===p;});};
c.isInAggregationBinding=function(e,a){if(a&&e.getElement().getBinding(a)){return true;}return e.isRoot()?false:(this.isInAggregationBinding(e.getParentElementOverlay(),e.getElement().sParentAggregationName));};
return c;},true);
sap.ui.predefine('sap/ui/dt/plugin/ContextMenu',['jquery.sap.global','sap/ui/dt/Plugin','sap/ui/dt/ContextMenuControl','sap/ui/dt/OverlayRegistry'],function(q,P,C,O){"use strict";
var a=P.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{library:"sap.ui.dt",properties:{contextElement:{type:"object"},styleClass:{type:"string"}},associations:{},events:{openedContextMenu:{},closedContextMenu:{}}}});
a.prototype.registerElementOverlay=function(o){o.attachBrowserEvent("contextmenu",this._onContextMenu,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);};
a.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("contextmenu",this._onContextMenu,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);};
a.prototype.init=function(){this._aMenuItems=[];};
a.prototype.exit=function(){delete this._aMenuItems;if(this._oContextMenuControl){this._oContextMenuControl.destroy();delete this._oContextMenuControl;}};
a.prototype.addMenuItem=function(m,r){var M={menuItem:m,fromPlugin:!!r};this._aMenuItems.push(M);};
a.prototype.open=function(o,t){this.setContextElement(t.getElement());this._aMenuItems=this._aMenuItems.filter(function(M){return!M.fromPlugin;});var p=this.getDesignTime().getPlugins();p.forEach(function(b){var c=b.getMenuItems(t)||[];c.forEach(function(M){this.addMenuItem(M,true);}.bind(this));}.bind(this));var m=this._aMenuItems.map(function(M){return M.menuItem;});m=this._sortMenuItems(m);this._oContextMenuControl=new C();this._oContextMenuControl.addStyleClass(this.getStyleClass());this._oContextMenuControl.setMenuItems(m,t);this._oContextMenuControl.setOverlayDomRef(t);this._oContextMenuControl.attachItemSelect(this._onItemSelected,this);this._oContextMenuControl.openMenu(o,t);this.fireOpenedContextMenu();};
a.prototype._sortMenuItems=function(m){return m.sort(function(f,s){if(!f.rank&&!s.rank){return 0;}if(!f.rank&&s.rank){return-1;}if(f.rank&&!s.rank){return 1;}return f.rank-s.rank;});};
a.prototype._onItemSelected=function(e){var s=[],E=e.getParameter("item"),c=this.getContextElement(),i=E.data("id");var m=this._aMenuItems.map(function(M){return M.menuItem;});m.some(function(I){if(i===I.id){s=this.getSelectedOverlays();if(!E.getSubmenu()){var p={};p.eventItem=E;p.contextElement=c;I.handler(s,p);}return true;}},this);};
a.prototype._onContextMenu=function(e){e.preventDefault();document.activeElement.blur();var o=O.getOverlay(e.currentTarget.id);var t=e.target.className;if(o&&o.isSelectable()&&t.indexOf("sapUiDtOverlay")>-1){if(!o.isSelected()){o.setSelected(true);}this.open(e,o);e.stopPropagation();}};
a.prototype._onKeyDown=function(e){var o=O.getOverlay(e.currentTarget.id);if((e.keyCode===q.sap.KeyCodes.F10)&&(e.shiftKey===true)&&(e.altKey===false)&&(e.ctrlKey===false)){e.preventDefault();e.stopPropagation();if(o&&o.isSelectable()){if(!o.isSelected()){o.setSelected(true);}var w=o.$().width()/2;var h=o.$().height()/2;var t=o.$().offset().top;var l=o.$().offset().left;this.open({pageX:l+w,pageY:t+h},o);}}};
return a;},true);
sap.ui.predefine('sap/ui/dt/plugin/ControlDragDrop',['sap/ui/dt/plugin/DragDrop','sap/ui/dt/plugin/ElementMover','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil'],function(D,E,a,O){"use strict";
var C=D.extend("sap.ui.dt.plugin.ControlDragDrop",{metadata:{library:"sap.ui.dt",properties:{draggableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"}},associations:{}}});
var d="sapUiDtOverlayDropZone";
C.prototype.init=function(){D.prototype.init.apply(this,arguments);this.setElementMover(new E());};
C.prototype.setElementMover=function(n){var o=this.getElementMover();if(o!==n){if(o){o.destroy();}this.setProperty("elementMover",n);}};
C.prototype.setDraggableTypes=function(b){this.getElementMover().setMovableTypes(b);return this.setProperty("draggableTypes",b);};
C.prototype.registerElementOverlay=function(o){D.prototype.registerElementOverlay.apply(this,arguments);var e=o.getElement();if(this.getElementMover().isMovableType(e)&&this.getElementMover().checkMovable(o)&&!O.isInAggregationBinding(o,e.sParentAggregationName)){o.setMovable(true);}if(this.oDraggedElement){this.getElementMover().activateTargetZonesFor(o,d);}};
C.prototype.deregisterElementOverlay=function(o){D.prototype.deregisterElementOverlay.apply(this,arguments);o.setMovable(false);if(this.oDraggedElement){this.getElementMover().deactivateTargetZonesFor(o,d);}};
C.prototype.getDraggedOverlay=function(){return this._oDraggedOverlay;};
C.prototype.onDragStart=function(o){this._oDraggedOverlay=o;this.getElementMover().setMovedOverlay(o);this.getElementMover().activateAllValidTargetZones(this.getDesignTime(),d);};
C.prototype.onDragEnd=function(o){delete this._oPreviousTarget;this.getElementMover().deactivateAllTargetZones(this.getDesignTime(),d);delete this._oDraggedOverlay;this.getElementMover().setMovedOverlay(null);};
C.prototype.onDragEnter=function(t){var o=this.getDraggedOverlay();if(t.getElement()!==o.getElement()&&t!==this._oPreviousTarget){this.getElementMover().repositionOn(o,t);}this._oPreviousTarget=t;};
C.prototype.onAggregationDragEnter=function(A){delete this._oPreviousTarget;var o=this.getDraggedOverlay();this.getElementMover().insertInto(o,A);};
return C;},true);
sap.ui.predefine('sap/ui/dt/plugin/CutPaste',['sap/ui/dt/Plugin','sap/ui/dt/plugin/ElementMover','sap/ui/dt/OverlayUtil','sap/ui/dt/OverlayRegistry'],function(P,E,O,a){"use strict";
var C=P.extend("sap.ui.dt.plugin.CutPaste",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"}},associations:{}}});
C.prototype.init=function(){this.setElementMover(new E());};
C.prototype.registerElementOverlay=function(o){var e=o.getElement();o.attachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().isMovableType(e)&&this.getElementMover().checkMovable(o)&&!O.isInAggregationBinding(o,e.sParentAggregationName)){o.setMovable(true);}if(this.getElementMover().getMovedOverlay()){this.getElementMover().activateTargetZonesFor(this.getElementMover().getMovedOverlay());}};
C.prototype.deregisterElementOverlay=function(o){o.setMovable(false);o.detachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().getMovedOverlay()){this.getElementMover().deactivateTargetZonesFor(this.getElementMover().getMovedOverlay());}};
C.prototype.setMovableTypes=function(m){this.getElementMover().setMovableTypes(m);return this.setProperty("movableTypes",m);};
C.prototype.setElementMover=function(e){e.setMovableTypes(this.getMovableTypes());return this.setProperty("elementMover",e);};
C.prototype.getCuttedOverlay=function(){return this.getElementMover().getMovedOverlay();};
C.prototype.isElementPasteable=function(t){var T=this._getTargetZoneAggregation(t);if((T)||(O.isInTargetZoneAggregation(t))){return true;}else{return false;}};
C.prototype._onKeyDown=function(e){var o=a.getOverlay(e.currentTarget.id);var c=sap.ui.Device.os.macintosh?e.metaKey:e.ctrlKey;if((e.keyCode===jQuery.sap.KeyCodes.X)&&(e.shiftKey===false)&&(e.altKey===false)&&(c===true)){this.cut(o);e.stopPropagation();}else if((e.keyCode===jQuery.sap.KeyCodes.V)&&(e.shiftKey===false)&&(e.altKey===false)&&(c===true)){if(this.getElementMover().getMovedOverlay()){this.paste(o);}e.stopPropagation();}else if(e.keyCode===jQuery.sap.KeyCodes.ESCAPE){this.stopCutAndPaste();e.stopPropagation();}};
C.prototype.cut=function(o){this.stopCutAndPaste();if(o.isMovable()){this.getElementMover().setMovedOverlay(o);o.addStyleClass("sapUiDtOverlayCutted");this.getElementMover().activateAllValidTargetZones(this.getDesignTime());}};
C.prototype._executePaste=function(t){var c=this.getElementMover().getMovedOverlay();if(!c){return false;}var r=false;if(!this._isForSameElement(c,t)){var T=this._getTargetZoneAggregation(t);if(T){this.getElementMover().insertInto(c,T);r=true;}else if(O.isInTargetZoneAggregation(t)){this.getElementMover().repositionOn(c,t);r=true;}}if(r){c.setSelected(true);setTimeout(function(){c.focus();},0);}return r;};
C.prototype.paste=function(t){var p=this._executePaste(t);if(p===true){this.stopCutAndPaste();}};
C.prototype.stopCutAndPaste=function(){var c=this.getElementMover().getMovedOverlay();if(c){c.removeStyleClass("sapUiDtOverlayCutted");this.getElementMover().setMovedOverlay(null);this.getElementMover().deactivateAllTargetZones(this.getDesignTime());}};
C.prototype._isForSameElement=function(c,t){return t.getElement()===c.getElement();};
C.prototype._getTargetZoneAggregation=function(t){var A=t.getAggregationOverlays();var p=A.filter(function(o){return o.isTargetZone();});if(p.length>0){return p[0];}else{return null;}};
return C;},true);
sap.ui.predefine('sap/ui/dt/plugin/ElementMover',['sap/ui/base/ManagedObject','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/OverlayRegistry'],function(M,E,O,a){"use strict";
var b=M.extend("sap.ui.dt.plugin.ElementMover",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{}}});
b.prototype._getMovableTypes=function(){return this.getProperty("movableTypes")||[];};
b.prototype.isMovableType=function(e){var m=this._getMovableTypes();return m.some(function(t){return E.isInstanceOf(e,t);});};
b.prototype.checkMovable=function(o){return true;};
b.prototype.getMovedOverlay=function(){return this._oMovedOverlay;};
b.prototype.setMovedOverlay=function(m){if(m){this._source=O.getParentInformation(m);}else{delete this._source;}this._oMovedOverlay=m;};
b.prototype._getSource=function(){return this._source;};
b.prototype.activateAllValidTargetZones=function(d,A){this._iterateAllAggregations(d,this._activateValidTargetZone.bind(this),A);};
b.prototype._activateValidTargetZone=function(A,s){if(this.checkTargetZone(A)){A.setTargetZone(true);if(s){A.addStyleClass(s);}}};
b.prototype.checkTargetZone=function(A,o,c){var m=o?o:this.getMovedOverlay();var g=A.getGeometry();var G=g&&g.size.height>0&&g.size.width>0;if((c&&!G)||!c&&!A.$().is(":visible")||!(A.getElement().getVisible&&A.getElement().getVisible())){return false;}var p=A.getElement();if(!p.getParent()){return false;}var d=m.getElement();var s=A.getAggregationName();if(E.isValidForAggregation(p,s,d)){return true;}};
b.prototype._deactivateTargetZone=function(A,s){A.setTargetZone(false);if(s){A.removeStyleClass(s);}};
b.prototype.activateTargetZonesFor=function(o,A){this._iterateOverlayAggregations(o,this._activateValidTargetZone.bind(this),A);};
b.prototype.deactivateTargetZonesFor=function(o,A){this._iterateOverlayAggregations(o,this._deactivateTargetZone.bind(this),A);};
b.prototype.deactivateAllTargetZones=function(d,A){this._iterateAllAggregations(d,this._deactivateTargetZone.bind(this),A);};
b.prototype._iterateAllAggregations=function(d,s,A){var o=d.getElementOverlays();o.forEach(function(c){this._iterateOverlayAggregations(c,s,A);},this);};
b.prototype._iterateOverlayAggregations=function(o,s,A){var c=o.getAggregationOverlays();c.forEach(function(d){s(d,A);});};
b.prototype.repositionOn=function(m,t){var o=m.getElement();var T=O.getParentInformation(t);var A;var p=m.getParentAggregationOverlay();var r=m.getRelevantContainer();var P=m.getParentElementOverlay();if(p&&P){var s=p.getAggregationName();A=P.getDesignTimeMetadata().getAggregation(s);}if(T.index!==-1){if(A&&A.beforeMove){A.beforeMove(r,o);}E.insertAggregation(T.parent,T.aggregation,o,T.index);if(A&&A.afterMove){A.afterMove(r,o);}}};
b.prototype.insertInto=function(m,t){var o=m.getElement();var T=t.getElement();var A;var p=m.getParentAggregationOverlay();var r=m.getRelevantContainer();var P=m.getParentElementOverlay();if(p&&P){var s=p.getAggregationName();A=P.getDesignTimeMetadata().getAggregation(s);}var c=E.getAggregation(t.getElement(),t.getAggregationName());var i=c.indexOf(o);if(!(i>-1&&i===c.length-1)){if(A&&A.beforeMove){A.beforeMove(r,o);}var d=t.getAggregationName();E.addAggregation(T,d,o);if(A&&A.afterMove){A.afterMove(r,o);}}};
b.prototype._compareSourceAndTarget=function(s,t){var p;for(p in s){switch(typeof(s[p])){case'object':if(s[p].getId()!==t[p].getId()){return false;}break;default:if(s[p]!==t[p]){return false;}}}return true;};
return b;},true);
sap.ui.predefine('sap/ui/dt/plugin/MiniMenu',['jquery.sap.global','sap/ui/dt/Plugin','sap/ui/dt/MiniMenuControl','sap/ui/Device'],function(q,P,M,D){"use strict";
var a=P.extend("sap.ui.dt.plugin.MiniMenu",{metadata:{properties:{contextElement:{type:"object"},styleClass:{type:"string"},openOnHover:{type:"boolean",defaultValue:true}},events:{openedMiniMenu:{},closedMiniMenu:{}}}});
a.prototype.init=function(){this.iMenuTouchOpeningDelay=150;this.iMenuLeftclickOpeningDelay=0;this.iMenuHoverOpeningDelay=1250;this.iMenuHoverClosingDelay=250;this.oMiniMenu=new sap.ui.dt.MiniMenuControl({maxButtonsDisplayed:4});this.oMiniMenu.attachClosed(this._miniMenuClosed,this);this.oMiniMenu.attachOverflowButtonPressed(this._pressedOverflowButton,this);this._aMenuItems=[];this._aGroupedItems=[];this._aSubMenus=[];this._aPluginsWithBusyFunction=[];this._oMousePosition={iMouseX:null,iMouseY:null};};
a.prototype.exit=function(){this.oMiniMenu.detachClosed(this._miniMenuClosed,this);this.oMiniMenu.detachOverflowButtonPressed(this._pressedOverflowButton,this);delete this._aMenuItems;if(this.oMiniMenu){this.oMiniMenu.destroy();delete this.oMiniMenu;}};
a.prototype.addMenuItem=function(m,r,p){var b={menuItem:m,fromPlugin:!!r,bPersistOneTime:p};this._aMenuItems.push(b);};
a.prototype.registerElementOverlay=function(o){o.attachBrowserEvent("click",this._onClick,this);o.attachBrowserEvent("touchstart",this._onTouch,this);o.attachBrowserEvent("contextmenu",this._onContextMenu,this);o.attachBrowserEvent("mouseover",this._onHover,this);o.attachBrowserEvent("mouseout",this._onHoverExit,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);};
a.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._onClick,this);o.detachBrowserEvent("touchstart",this._onTouch,this);o.detachBrowserEvent("contextmenu",this._onContextMenu,this);o.detachBrowserEvent("mouseover",this._onHover,this);o.detachBrowserEvent("mouseout",this._onHoverExit,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);};
a.prototype.open=function(e,o,c,i){this._bContextMenu=!!c;this._aPluginsWithBusyFunction=[];this.setContextElement(o.getElement());var p=this.getDesignTime().getPlugins();p.forEach(function(b){if(b.isBusy){this._aPluginsWithBusyFunction.push(b);}}.bind(this));this._aMenuItems=this._aMenuItems.filter(function(b){if(b.bPersistOneTime){b.bPersistOneTime=false;return true;}return!b.fromPlugin;});if(!i){this._aGroupedItems=[];this._aSubMenus=[];p.forEach(function(b){var d=b.getMenuItems(o)||[];d.forEach(function(f){if(f.group!=undefined&&!c){this._addMenuItemToGroup(f);}else if(f.submenu!=undefined){this._addSubMenu(f,e,o);}else{this.addMenuItem(f,true);}}.bind(this));}.bind(this));this._addItemGroupsToMenu(e,o);}var m=this._aMenuItems.map(function(b){return b.menuItem;});if(m.length>0){this.oMiniMenu._bUseExpPop=!!c;m=this._sortMenuItems(m);this.oMiniMenu.setButtons(m,this,o);this.oMiniMenu.setStyleClass(this.getStyleClass());if(i){this.oMiniMenu.setOpenNew(true);}this.oMiniMenu.show(o,c,{x:e.clientX,y:e.clientY});}this.fireOpenedMiniMenu();};
a.prototype._sortMenuItems=function(m){return m.sort(function(f,s){if(!f.rank&&!s.rank){return 0;}if(!f.rank&&s.rank){return-1;}if(f.rank&&!s.rank){return 1;}return f.rank-s.rank;});};
a.prototype._onContextMenu=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()){e.preventDefault();if(!this._bTouched){this._oCurrentOverlay=sap.ui.getCore().byId(e.currentTarget.id);this.oMiniMenu.close();this._bOpenedByHover=false;if(document.activeElement){document.activeElement.blur();}clearTimeout(this.hoverTimeout);this._bTouched=false;this._ensureSelection(o);clearTimeout(this.clickTimeout);this.lockMenuOpening();this.oMiniMenu.bOpenNew=true;this.open(e,o,true);e.stopPropagation();}}};
a.prototype._onItemSelected=function(e){this.oMiniMenu.close();this._ensureSelection(this._oCurrentOverlay);this.setFocusLock(true);var s=[],c=this.getContextElement(),i=e.data("id");this._aMenuItems.some(function(m){if(i===m.menuItem.id){var I=m.menuItem;s=this.getSelectedOverlays();var p={};p.eventItem=e;p.contextElement=c;I.handler(s,p);I=null;return true;}},this);};
a.prototype._onTouch=function(e){this._bTouched=true;var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()){e.stopPropagation();if(this.touchTimeout){clearTimeout(this.touchTimeout);}this.touchTimeout=setTimeout(function(){this._bTouched=true;this._startOpening(e);}.bind(this),this.iMenuTouchOpeningDelay);}};
a.prototype._onClick=function(e){if(!D.os.ios&&!e.ctrlKey){var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()){if(this.isMenuOpeningLocked()&&!this._bTouched){this.resetFocus();sap.ui.getCore().byId(e.currentTarget.id).setSelected(false);this.unlockMenuOpening();this._onHover(e);this._bTouched=false;this.oMiniMenu.close();return;}this._bTouched=false;this.clickTimeout=setTimeout(function(){this._startOpening(e,true);}.bind(this),this.iMenuLeftclickOpeningDelay);e.stopPropagation();}}};
a.prototype._startOpening=function(e,l){clearTimeout(this.hoverTimeout);this._bOpenedByHover=false;if(this._oTempTarget!=e.currentTarget.id){clearTimeout(this.clickTimeout);}this._oTempTarget=e.currentTarget.id;var o=sap.ui.getCore().byId(e.currentTarget.id);var t=e.target.className;if(o&&o.isSelectable()&&t.indexOf("sapUiDtOverlay")>-1&&(!this.isMenuOpeningLocked()||this._bTouched)){e.stopPropagation();if(this._shouldMiniMenuOpen(e,!this.oMiniMenu.bOpen)){this._ensureSelection(o);if(this._oCurrentOverlay.isSelected()||D.os.android){if(l){this.lockMenuOpening();}this.oMiniMenu.bOpenNew=true;this.open(e,o);return true;}}}};
a.prototype._onHover=function(e){if(this._oMousePosition.iMouseX===e.clientX&&this._oMousePosition.iMouseY===e.clientY){return;}var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()&&!e.ctrlKey&&this.getOpenOnHover()){e.stopPropagation();if(this._shouldMiniMenuOpen(e,true,true)){this._oMousePosition={iMouseX:e.clientX,iMouseY:e.clientY};if(this.iMenuHoverClosingDelay>=this.iMenuHoverOpeningDelay){q.error("sap.ui.dt MiniMenu iMenuHoverClosingDelay is bigger or equal to iMenuHoverOpeningDelay!");}if(this.oMiniMenu.getPopover().isOpen()){this._closingTimeout=setTimeout(function(){if(!this._bTouched&&this.oMiniMenu.getPopover().isOpen()){this.oMiniMenu.close();}}.bind(this),this.iMenuHoverClosingDelay);}this.hoverTimeout=setTimeout(function(){if(!this._bTouched){sap.ui.getCore().byId(e.currentTarget.id).focus();this._startOpening(e);this._bOpenedByHover=true;}}.bind(this),this.iMenuHoverOpeningDelay);}}};
a.prototype._onHoverExit=function(e){if(this.hoverTimeout){clearTimeout(this.hoverTimeout);this.hoverTimeout=null;}if(this._closingTimeout){clearTimeout(this._closingTimeout);this._closingTimeout=null;}};
a.prototype._onKeyDown=function(e){if((e.keyCode===q.sap.KeyCodes.F10)&&(e.shiftKey===true)&&(e.altKey===false)&&(e.ctrlKey===false)){var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()){e.preventDefault();e.clientX=o.$().offset().left+o.$().width()/2;e.clientY=o.$().offset().top+o.$().height()/2;this._onContextMenu(e);}}};
a.prototype._shouldMiniMenuOpen=function(e,o,b){if((!this.isMenuOpeningLocked()||this._bTouched)){if(!b){this._oCurrentOverlay=sap.ui.getCore().byId(e.currentTarget.id);}return true;}else{return false;}};
a.prototype._pressedOverflowButton=function(){if(!this._bTouched){this.lockMenuOpening();}this.setFocusLock(true);};
a.prototype._miniMenuClosed=function(){this._bTouched=false;this.unlockMenuOpening();this.setFocusLock(false);};
a.prototype.lockMenuOpening=function(o){if((this.oMiniMenu.getPopover(true).isOpen()||this.oMiniMenu.getPopover(false).isOpen())&&o!==true){this._bAsyncLock=true;}else{this._bOpeningLocked=true;}};
a.prototype.unlockMenuOpening=function(){this._bOpeningLocked=false;if(this._bAsyncLock){this.lockMenuOpening(true);}this._bAsyncLock=false;this.resetFocus();};
a.prototype.isMenuOpeningLocked=function(){return this._bOpeningLocked;};
a.prototype.setFocusLock=function(i){this._bFocusLocked=i;};
a.prototype.resetFocus=function(){if(!this._bFocusLocked&&this._oCurrentOverlay&&document.activeElement){if(!D.os.ios){this._oCurrentOverlay.focus();}}};
a.prototype._ensureSelection=function(o){if((!this._bTouched||D.os.ios)&&o&&!o.isSelected()){o.setSelected(true);}};
a.prototype._checkForPluginLock=function(){if(D.os.ios){return false;}if(this._aPluginsWithBusyFunction.some(function(p){return(typeof p.isBusy==="function"&&p.isBusy());})){return true;}this.setFocusLock(false);return false;};
a.prototype._addMenuItemToGroup=function(m){var g=this._aGroupedItems.some(function(_){if(_.sGroupName===m.group){_.aGroupedItems.push(m);return true;}});if(!g){this._aGroupedItems.push({sGroupName:m.group,aGroupedItems:[m]});}};
a.prototype._addSubMenu=function(m,e,o){m.submenu.forEach(function(s){s.handler=m.handler;});m.handler=function(s,e,o,O,p){this._aSubMenus.some(function(_){if(_.sSubMenuId===s){_.aSubMenuItems.forEach(function(S){this.addMenuItem(S,true,true);}.bind(this));return true;}}.bind(this));if(!this._bContextMenu){e.clientX=null;e.clientY=null;}this.oMiniMenu.close();setTimeout(function(){this.open(e,o,true,true);}.bind(this),0);this.lockMenuOpening();}.bind(this,m.id,e,o);this._aSubMenus.push({sSubMenuId:m.id,aSubMenuItems:m.submenu});this.addMenuItem(m,true);};
a.prototype._addItemGroupsToMenu=function(e,o){this._aGroupedItems.forEach(function(g,i){if(g.aGroupedItems.length===1){this.addMenuItem(g.aGroupedItems[0],true,false);}else{var h=function(i,e,o){this._aGroupedItems[i].aGroupedItems.forEach(function(m){this.addMenuItem(m,true,true);}.bind(this));e.clientX=null;e.clientY=null;this.oMiniMenu.close();setTimeout(function(){this.open(e,o,true,true);}.bind(this),0);this.lockMenuOpening();};this.addMenuItem({id:g.sGroupName+"-groupButton",enabled:true,text:g.sGroupName,icon:g.aGroupedItems[0].icon,rank:g.aGroupedItems[0].rank,handler:h.bind(this,i,e,o)},true);}}.bind(this));};
return a;},true);
sap.ui.predefine('sap/ui/dt/plugin/TabHandling',['jquery.sap.global','sap/ui/dt/Plugin','sap/ui/dt/Overlay'],function(q,P,O){"use strict";
var T=P.extend("sap.ui.dt.plugin.TabHandling",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});
T.prototype.registerElementOverlay=function(o){if(o.isRoot()){this.removeTabIndex();}};
T.prototype.deregisterElementOverlay=function(o){if(o.isRoot()){this.restoreTabIndex();}};
T.prototype.setDesignTime=function(d){P.prototype.setDesignTime.apply(this,arguments);if(d){if(!this._oMutationObserver){this._oMutationObserver=O.getMutationObserver();this._oMutationObserver.attachDomChanged(this._onDomChanged,this);}}else{this._oMutationObserver.detachDomChanged(this._onDomChanged,this);delete this._oMutationObserver;this.restoreTabIndex();}};
T.prototype.removeTabIndex=function(){var d=this.getDesignTime();var r=d.getRootElements();r.forEach(function(R){R.$().find(":focusable:not([tabIndex=-1], #overlay-container *)").each(function(i,n){n.setAttribute("data-sap-ui-dt-tabindex",n.tabIndex);n.setAttribute("tabIndex",-1);});});};
T.prototype.restoreTabIndex=function(){q("[data-sap-ui-dt-tabindex]").each(function(i,n){n.setAttribute("tabIndex",n.getAttribute("data-sap-ui-dt-tabindex"));n.removeAttribute("data-sap-ui-dt-tabindex");});};
T.prototype._onDomChanged=function(){if(this.getDesignTime().getEnabled()){this.removeTabIndex();}};
return T;},true);
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/dt/AggregationDesignTimeMetadata',['sap/ui/dt/DesignTimeMetadata'],function(D){"use strict";
var A=D.extend("sap.ui.dt.AggregationDesignTimeMetadata",{metadata:{library:"sap.ui.dt"}});
return A;},true);
sap.ui.predefine('sap/ui/dt/AggregationOverlay',['jquery.sap.global','sap/ui/dt/Overlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/ElementUtil','sap/ui/dt/Util'],function(q,O,a,E,U){"use strict";
var A=O.extend("sap.ui.dt.AggregationOverlay",{metadata:{library:"sap.ui.dt",properties:{aggregationName:{type:"string"},targetZone:{type:"boolean",defaultValue:false},scrollContainerId:{type:"int"}},events:{targetZoneChange:{parameters:{targetZone:{type:"boolean"}}}}}});
A.prototype._getAttributes=function(){return q.extend(true,{},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-aggregation":this.getAggregationName()});};
A.prototype._getChildIndex=function(c){var C=this.getChildren();var p;var P=C.indexOf(c)-1;while(P>0){p=C[P];if(p.isRendered()){break;}P--;}return P<0?0:P+1;};
A.prototype.insertChild=function(p,c){if(!(U.isInteger(p))){p=E[this.isAssociation()?'getIndexInAssociation':'getIndexInAggregation'](c.getElement(),this.getElement(),this.getAggregationName());}var P=this.indexOfAggregation('children',c);if(P!==p){if(P>-1){this.removeAggregation('children',c);}this.insertAggregation('children',c,p);if(this.isRendered()){var i=this._getChildIndex(c);var C=c.isRendered()?c.$():c.render(true);var $=q(this.getChildrenDomRef());var b=$.find('>').index(C);var I;if(b!==i){if(i>0){I=b>-1&&b<i?i:i-1;$.find('>').eq(I).after(C);}else{I=i;$.prepend(C);}}c.fireAfterRendering({domRef:C.get(0)});}this.fireChildAdded();}};
A.prototype.addChild=function(c,s){this.insertChild(this.getChildren().length,c);if(!s){this.fireChildAdded();}};
A.prototype.render=function(){if(this.getChildren().length>0||this.getDesignTimeMetadata().getDomRef()){this.addStyleClass('sapUiDtAggregationOverlay');return O.prototype.render.apply(this,arguments);}};
A.prototype._getRenderingParent=function(){if(U.isInteger(this.getScrollContainerId())){return this.getParent().getScrollContainerById(this.getScrollContainerId());}else{return O.prototype._getRenderingParent.apply(this,arguments);}};
A.prototype.getAssociatedDomRef=function(){var e=this.getElement();var s=this.getAggregationName();var d=this.getDesignTimeMetadata();return d.getAssociatedDomRef(e,d.getDomRef(),s);};
A.prototype.setTargetZone=function(t){if(this.getTargetZone()!==t){this.setProperty("targetZone",t);this.toggleStyleClass("sapUiDtOverlayTargetZone",t);this.fireTargetZoneChange({targetZone:t});}return this;};
A.prototype.isTargetZone=function(){return this.getTargetZone();};
A.prototype.isAssociation=function(){return!!this.getDesignTimeMetadata().getData().aggregationLike;};
return A;},true);
sap.ui.predefine('sap/ui/dt/ControlObserver',['jquery.sap.global','sap/ui/dt/ManagedObjectObserver'],function(q,M){"use strict";
var C=M.extend("sap.ui.dt.ControlObserver",{metadata:{library:"sap.ui.dt",properties:{},associations:{"target":{"type":"sap.ui.core.Control"}},events:{"afterRendering":{}}}});
C.prototype.init=function(){M.prototype.init.apply(this,arguments);this._oControlDelegate={onAfterRendering:this._onAfterRendering};};
C.prototype.observe=function(c){M.prototype.observe.apply(this,arguments);c.addEventDelegate(this._oControlDelegate,this);};
C.prototype.unobserve=function(){var c=this.getTargetInstance();if(c){c.removeDelegate(this._oControlDelegate,this);}M.prototype.unobserve.apply(this,arguments);};
C.prototype._onAfterRendering=function(){this.fireAfterRendering();};
return C;},true);
sap.ui.predefine('sap/ui/dt/DOMUtil',['jquery.sap.global'],function(q){"use strict";var D={};
D.getSize=function(d){var c=d.getBoundingClientRect();return{width:c.width,height:c.height};};
D.getOffsetFromParent=function(p,P,s,S){var o={left:p.left,top:p.top};if(P){o.left-=(P.left-(S?S:0));o.top-=(P.top-(s?s:0));}return o;};
D.getZIndex=function(d){var z;var e=q(d);if(e.length){z=e.zIndex()||e.css("z-index");}return z;};
D.hasVerticalScrollBar=function(d){var $=q(d);var o=$.css("overflow-y")==="auto"||$.css("overflow-y")==="scroll";return o&&$.get(0).scrollHeight>$.height();};
D.hasHorizontalScrollBar=function(d){var $=q(d);var o=$.css("overflow-x")==="auto"||$.css("overflow-x")==="scroll";return o&&$.get(0).scrollWidth>$.width();};
D.hasScrollBar=function(d){return D.hasVerticalScrollBar(d)||D.hasHorizontalScrollBar(d);};
D.getScrollbarWidth=function(){if(typeof D.getScrollbarWidth._cache==='undefined'){var o=q('<div/>').css({position:'absolute',top:'-9999px',left:'-9999px',width:'100px'}).appendTo('body');var w=o.width();o.css('overflow','scroll');var i=q('<div/>').css('width','100%').appendTo(o);var W=i.width();o.remove();D.getScrollbarWidth._cache=w-W;}return D.getScrollbarWidth._cache;};
D.getOverflows=function(d){var $=q(d);return{overflowX:$.css("overflow-x"),overflowY:$.css("overflow-y")};};
D.getGeometry=function(d,u){if(d){var o=q(d).offset();if(u){o.left=o.left-q(window).scrollLeft();o.top=o.top-q(window).scrollTop();}return{domRef:d,size:this.getSize(d),position:o,visible:this.isVisible(d)};}};
D.syncScroll=function(s,t){var $=q(t);var T=$.scrollTop();var o=$.scrollLeft();var a=q(s);var S=a.scrollTop();var b=a.scrollLeft();if(S!==T){$.scrollTop(S);}if(b!==o){$.scrollLeft(b);}};
D.getDomRefForCSSSelector=function(d,c){if(c&&d){var $=q(d);if(c===":sap-domref"){return $;}if(c.indexOf(":sap-domref")>-1){return $.find(c.replace(/:sap-domref/g,""));}return $.find(c);}else{return q();}};
D.isVisible=function(d){return d?d.offsetWidth>0||d.offsetHeight>0:false;};
D.getEscapedString=function(s){return s.replace(/([;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=>\|])/g,'\\$1');};
D.setDraggable=function(e,v){e=q(e);e.attr("draggable",v);};
D.getDraggable=function(e){e=q(e);return e.attr("draggable");};
D._copyStylesTo=function(s,d){var S="";var a="";var l=s.length;for(var i=0;i<l;i++){a=s[i];S=S+a+":"+s.getPropertyValue(a)+";";}d.style.cssText=S;};
D._copyPseudoElement=function(p,s,d){var S=window.getComputedStyle(s,p);var c=S.getPropertyValue("content");if(c&&c!=="none"){c=q.trim(c);if(c.indexOf("attr(")===0){c=c.replace("attr(","");if(c.length){c=c.substring(0,c.length-1);}c=s.getAttribute(c);}if(c===null||c===undefined){c="";}var P=q("<span></span>");if(p===":after"){P.appendTo(d);}else{P.prependTo(d);}P.text(c.replace(/(^['"])|(['"]$)/g,""));D._copyStylesTo(S,P.get(0));P.css("display","inline");}};
D.copyComputedStyle=function(s,d){s=q(s).get(0);d=q(d).get(0);var S=window.getComputedStyle(s);if(S.getPropertyValue("display")=="none"){d.style.display="none";return;}D._copyStylesTo(S,d);this._copyPseudoElement(":after",s,d);this._copyPseudoElement(":before",s,d);};
D.copyComputedStyles=function(s,d){s=q(s).get(0);d=q(d).get(0);for(var i=0;i<s.children.length;i++){this.copyComputedStyles(s.children[i],d.children[i]);}q(d).removeClass();q(d).attr("id","");q(d).attr("role","");q(d).attr("data-sap-ui","");q(d).attr("for","");q(d).attr("tabIndex",-1);this.copyComputedStyle(s,d);};
D.cloneDOMAndStyles=function(n,t){n=q(n).get(0);var c=n.cloneNode(true);this.copyComputedStyles(n,c);q(t).append(c);};
D.insertStyles=function(s){var S=document.createElement('style');S.type='text/css';if(S.styleSheet){S.styleSheet.cssText=s;}else{S.appendChild(document.createTextNode(s));}q('#overlay-container').prepend(S);};
D.contains=function(i,t){var n=document.getElementById(i);return n&&n.contains(t);};
D.appendChild=function(t,c){var s=c.scrollTop;var S=c.scrollLeft;t.appendChild(c);c.scrollTop=s;c.scrollLeft=S;};
return D;},true);
sap.ui.predefine('sap/ui/dt/DesignTime',['sap/ui/base/ManagedObject','sap/ui/dt/ElementOverlay','sap/ui/dt/AggregationOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/SelectionManager','sap/ui/dt/ElementDesignTimeMetadata','sap/ui/dt/AggregationDesignTimeMetadata','sap/ui/dt/ElementUtil','sap/ui/dt/Overlay','sap/ui/dt/OverlayUtil','sap/ui/dt/MetadataPropagationUtil','sap/ui/dt/Util','sap/ui/dt/TaskManager','./library'],function(M,E,A,O,S,a,b,c,d,e,f,U,T){"use strict";
var D=M.extend("sap.ui.dt.DesignTime",{
metadata:{library:"sap.ui.dt",properties:{selectionMode:{type:"sap.ui.dt.SelectionMode",defaultValue:sap.ui.dt.SelectionMode.Single},designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},syncing:{},synced:{},syncFailed:{}}},
constructor:function(){this._mPendingOverlays={};this._oTaskManager=new T({complete:function(o){if(o.getSource().isEmpty()){this._registerElementOverlaysInPlugins();this.fireSynced();}}.bind(this),add:function(o){if(o.getSource().count()===1){this.fireSyncing();}}.bind(this)});this._onElementOverlayDestroyed=this._onElementOverlayDestroyed.bind(this);M.apply(this,arguments);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(o){this._createOverlaysForRootElement(o.getParameter('element'));},this);this.attachEvent("enabledChanged",function(o){var v=o.getParameter('value');var $=d.getOverlayContainer();$[v?'show':'hide']();this.getRootElements().forEach(function(r){var R=O.getOverlay(r);R.setVisible(v);if(v){R.applyStyles();}});},this);}
});
D.prototype.init=function(){this._oSelectionManager=this._createSelectionManager();this._oSelectionManager.attachEvent("change",function(o){this.fireSelectionChange({selection:o.getParameter("selection")});},this);this._collectOverlaysDuringSyncing();};
D.prototype._collectOverlaysDuringSyncing=function(){this._aOverlaysCreatedInLastBatch=[];this.attachElementOverlayCreated(function(o){var n=o.getParameter("elementOverlay");this._aOverlaysCreatedInLastBatch.push(n);}.bind(this));this.attachElementOverlayDestroyed(this._onOverlayDestroyedDuringSyncing,this);};
D.prototype._onOverlayDestroyedDuringSyncing=function(o){var g=o.getParameter("elementOverlay");var i=this._aOverlaysCreatedInLastBatch.indexOf(g);if(i!==-1){this._aOverlaysCreatedInLastBatch.splice(i,1);}};
D.prototype._registerElementOverlaysInPlugins=function(){var p=this.getPlugins();this._aOverlaysCreatedInLastBatch.forEach(function(o){p.forEach(function(P){P.callElementOverlayRegistrationMethods(o);});});this._aOverlaysCreatedInLastBatch=[];};
D.prototype.exit=function(){this.detachElementOverlayDestroyed(this._onOverlayDestroyedDuringSyncing,this);this._oTaskManager.destroy();this.getPlugins().forEach(function(p){p.destroy();});this._destroyAllOverlays();this._oSelectionManager.destroy();delete this._aOverlaysCreatedInLastBatch;};
D.prototype._createSelectionManager=function(){return new S();};
D.prototype.getSelection=function(){return this.getSelectionManager().get();};
D.prototype.getSelectionManager=function(){return this._oSelectionManager;};
D.prototype.setSelectionMode=function(m){this.setProperty("selectionMode",m);this.getSelectionManager().setMode(m);return this;};
D.prototype.getPlugins=function(){return this.getAggregation("plugins")||[];};
D.prototype.addPlugin=function(p){p.setDesignTime(this);this.addAggregation("plugins",p);return this;};
D.prototype.insertPlugin=function(p,i){p.setDesignTime(this);this.insertAggregation("plugins",p,i);return this;};
D.prototype.removePlugin=function(p){this.getPlugins().forEach(function(C){if(C===p){p.setDesignTime(null);return;}});this.removeAggregation("plugins",p);return this;};
D.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(p){p.setDesignTime(null);});this.removeAllAggregation("plugins");return this;};
D.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(s){return c.getElementInstance(s);});};
D.prototype.getDesignTimeMetadataFor=function(o){var C;if(typeof o==='string'){C=o;jQuery.sap.log.error('sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance');}else{C=o.getMetadata().getName();}return(this.getDesignTimeMetadata()||{})[C];};
D.prototype.addRootElement=function(r){this.addAssociation("rootElements",r);this.fireAddRootElement({element:r});};
D.prototype._createOverlaysForRootElement=function(r){var t=this._oTaskManager.add({type:'createOverlay',element:r,root:true});this.createOverlay({element:c.getElementInstance(r),root:true,visible:this.getEnabled()}).then(function(o){d.getOverlayContainer().append(o.render());o.applyStyles();this._oTaskManager.complete(t);return o;}.bind(this),function(){jQuery.sap.log.error('sap.ui.dt: root element with id = "'+r.getId()+'" initialization is failed');this._oTaskManager.cancel(t);}.bind(this));};
D.prototype.removeRootElement=function(r){this.removeAssociation("rootElements",r);this._destroyOverlaysForElement(c.getElementInstance(r));return this;};
D.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this;};
D.prototype.getElementOverlays=function(){var g=[];this._iterateRootElements(function(r){g=g.concat(this._getAllElementOverlaysIn(r));},this);return g;};
D.prototype.createOverlay=function(v){var p=jQuery.extend({},jQuery.isPlainObject(v)?v:{element:v});var t=this._oTaskManager.add({type:'createOverlay'});if(!p.element||p.element.bIsDestroyed||!c.isElementValid(p.element)){this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","can't create overlay without element"));}else{var s=p.element.getId();var o=O.getOverlay(s);if(o){this._oTaskManager.complete(t);return Promise.resolve(o);}else if(s in this._mPendingOverlays){this._oTaskManager.complete(t);return this._mPendingOverlays[s];}else{if(typeof p.root==="undefined"&&!c.getParent(p.element)){p.root=true;}this._mPendingOverlays[s]=this._createElementOverlay(p).then(function(o){return this._createChildren(o,p.parentMetadata).then(function(){delete this._mPendingOverlays[s];if(this.bIsDestroyed){o.detachEvent('destroyed',this._onElementOverlayDestroyed);o.destroy();this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"));}else if(o.bIsDestroyed){this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"));}else{O.register(o);o.attachBeforeDestroy(function(g){O.deregister(g.getSource());});this.fireElementOverlayCreated({elementOverlay:o});this._oTaskManager.complete(t);return o;}}.bind(this));}.bind(this),function(g){throw g;}).catch(function(g){var h=U.propagateError(g,'DesignTime#createOverlay',U.printf("Failed attempt to create overlay for '{0}'",s));delete this._mPendingOverlays[s];this.fireSyncFailed({error:h});this._oTaskManager.cancel(t);return Promise.reject(h);}.bind(this));return this._mPendingOverlays[s];}}};
D.prototype._createElementOverlay=function(p){var o=p.element;return new Promise(function(r,R){new E({element:o,isRoot:p.root,visible:typeof p.visible!=="boolean"||p.visible,metadataScope:this.getScope(),designTimeMetadata:(this.getDesignTimeMetadataFor(o)instanceof a?this.getDesignTimeMetadataFor(o):U.curry(function(m,P,o,g){g=jQuery.sap.extend(true,{},g,m);this._mMetadataOriginal=g;if(P){g=f.propagateMetadataToElementOverlay(g,P,o);}return g;})(this.getDesignTimeMetadataFor(o),p.parentMetadata,o)),init:function(g){r(g.getSource());},initFailed:function(s,g){var h=g.getSource();var i=U.propagateError(g.getParameter('error'),'DesignTime#_createElementOverlay',U.printf("Can't create overlay properly (id='{0}') for '{1}'",h.getId(),s));h.detachEvent('destroyed',this._onElementOverlayDestroyed);h.detachEvent('elementDestroyed',this._onElementDestroyed);h.destroy();R(i);}.bind(this,o.getId()),destroyed:this._onElementOverlayDestroyed,elementDestroyed:this._onElementDestroyed.bind(this),selectionChange:this._onElementOverlaySelectionChange.bind(this),elementModified:this._onElementModified.bind(this)});}.bind(this));};
D.prototype._createChildren=function(o,p){return Promise.all(o.getAggregationNames().map(function(s){var g=o.getElement();var m=f.propagateMetadataToAggregationOverlay(o.getDesignTimeMetadata().getAggregation(s),g,p);var h=new A({aggregationName:s,element:g,designTimeMetadata:new b({data:m}),beforeDestroy:function(i){O.deregister(i.getSource());},destroyed:this._onAggregationOverlayDestroyed});O.register(h);return Promise.all(c[h.isAssociation()?'getAssociationInstances':'getAggregation'](g,s).map(function(g){return this.createOverlay({element:g,root:false,parentMetadata:m}).catch(function(i){return i;});},this)).then(function(C){C.map(function(i){if(i instanceof E&&!i.bIsDestroyed){h.addChild(i,true);}},this);return h;}.bind(this));},this)).then(function(g){g.forEach(function(h){if(o.bIsDestroyed){h.destroy();}else{o.addChild(h,true);}});});};
D.prototype._destroyOverlaysForElement=function(o){var g=O.getOverlay(o);if(g){g.destroy();}};
D.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(r){this._destroyOverlaysForElement(r);},this);};
D.prototype._onElementOverlayDestroyed=function(o){var g=o.getSource();var s=g.getAssociation('element');if(s in this._mPendingOverlays){return;}if(!O.hasOverlays()){d.destroyMutationObserver();d.removeOverlayContainer();}if(g.getSelected()){this.getSelectionManager()._remove(g);}this.fireElementOverlayDestroyed({elementOverlay:g});};
D.prototype._onElementDestroyed=function(o){var s=o.getParameter("targetId");this.removeRootElement(s);};
D.prototype._onAggregationOverlayDestroyed=function(o){if(!O.hasOverlays()){d.removeOverlayContainer();}};
D.prototype._onElementOverlaySelectionChange=function(o){var g=o.getSource();var s=o.getParameter("selected");this.getSelectionManager()[s?"_add":"_remove"](g);};
D.prototype._onElementModified=function(o){var p=o.getParameters();if(p.type==="addOrSetAggregation"||p.type==="insertAggregation"){this._onAddAggregation(p.value,p.target,p.name);}else if(p.type==="setParent"){setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(p.target);}}.bind(this),0);}};
D.prototype._onAddAggregation=function(o,p,s){if(c.isElementValid(o)){var P=O.getOverlay(p);var g=P.getAggregationOverlay(s);var h=O.getOverlay(o);if(!h){var t=this._oTaskManager.add({type:'createChildOverlay',element:o});h=this.createOverlay({element:o,parentMetadata:g.getDesignTimeMetadata().getData()}).then(function(i){g.insertChild(null,i);i.applyStyles();this._oTaskManager.complete(t);}.bind(this),function(v){throw v;}).catch(function(i,j,v){this._oTaskManager.cancel(t);var k=U.propagateError(v,"DesignTime#_onAddAggregation",U.printf("Failed to add new ElementOverlay (elementId='{0}') into AggregationOverlay (id='{1}')",i,j));if(!o.bIsDestroyed){jQuery.sap.log.error(U.errorToString(k));}}.bind(this,o.getId(),g.getId()));}else{if(h&&!this._isElementInRootElements(h)&&h.isRoot()){h.setIsRoot(false);}g.insertChild(null,h);h.setDesignTimeMetadata(f.propagateMetadataToElementOverlay(h._mMetadataOriginal,g.getDesignTimeMetadata().getData(),o));}}};
D.prototype._checkIfOverlayShouldBeDestroyed=function(o){var g=O.getOverlay(o);if(g&&(!this._isElementInRootElements(o)||o.sParentAggregationName==="dependents")){g.destroy();}};
D.prototype._isElementInRootElements=function(o){var F=false;this._iterateRootElements(function(r){if(c.hasAncestor(o,r)){F=true;return false;}});return F;};
D.prototype._iterateRootElements=function(s,o){var r=this.getRootElements();r.forEach(function(R){var g=c.getElementInstance(R);s.call(o||this,g);},this);};
D.prototype._getAllElementOverlaysIn=function(o){var g=[];var h=O.getOverlay(o);if(h){e.iterateOverlayElementTree(h,function(C){if(C.getDesignTimeMetadata()){g.push(C);}});}return g;};
D.prototype.setEnabled=function(v){v=!!v;if(this.getEnabled()!==v){this.setProperty('enabled',v);this.fireEnabledChanged({value:v});}};
return D;},true);
sap.ui.predefine('sap/ui/dt/DesignTimeMetadata',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/dt/ElementUtil','sap/ui/dt/DOMUtil'],function(q,M,E,D){"use strict";
var a=M.extend("sap.ui.dt.DesignTimeMetadata",{metadata:{library:"sap.ui.dt",properties:{data:{type:"any",defaultValue:{}}}}});
a.prototype.setData=function(d){this.setProperty("data",q.extend(true,{},this.getDefaultData(),d));return this;};
a.prototype.getDefaultData=function(){return{ignore:false,domRef:undefined};};
a.prototype.isIgnored=function(e){var i=this.getData().ignore;if(!i||(i&&typeof i==="function"&&!i(e))){return false;}else{return true;}};
a.prototype.getDomRef=function(){return this.getData().domRef;};
a.prototype.getAssociatedDomRef=function(e,d,A){var o=E.getDomRef(e);var b=[];b.push(e);if(A){b.push(A);}if(typeof(d)==="function"){var r=d.apply(null,b);return r?q(r):r;}else if(o&&typeof(d)==="string"){return D.getDomRefForCSSSelector(o,d);}};
a.prototype.getAction=function(A,e){var d=this.getData();if(d.actions&&d.actions[A]){var v=d.actions[A];if(typeof(v)==="function"){v=v.call(null,e);}if(typeof(v)==="string"){return{changeType:v};}else{return v;}}};
a.prototype.getLibraryText=function(e,k,A){var o=e.getMetadata();return this._lookForLibraryTextInHierarchy(o,k,A);};
a.prototype._lookForLibraryTextInHierarchy=function(m,k,A){var l;var p;var r;l=m.getLibraryName();r=this._getTextFromLibrary(l,k,A);if(!r){p=m.getParent();if(p&&p.getLibraryName){r=this._lookForLibraryTextInHierarchy(p,k,A);}else{r=k;}}return r;};
a.prototype._getTextFromLibrary=function(l,k,A){var L=sap.ui.getCore().getLibraryResourceBundle(l+".designtime");if(L&&L.hasText(k)){return L.getText(k,A);}else{L=sap.ui.getCore().getLibraryResourceBundle(l);if(L&&L.hasText(k)){return L.getText(k,A);}}};
a.prototype.getTriggers=function(){var d=this.getData();var t=[];if(d&&Array.isArray(d.triggers)){t=d.triggers;}return t;};
return a;},true);
sap.ui.predefine('sap/ui/dt/ElementDesignTimeMetadata',['jquery.sap.global','sap/ui/dt/DesignTimeMetadata','sap/ui/dt/AggregationDesignTimeMetadata'],function(q,D,A){"use strict";
var E=D.extend("sap.ui.dt.ElementDesignTimeMetadata",{metadata:{library:"sap.ui.dt"}});
E.prototype.getDefaultData=function(d){var o=D.prototype.getDefaultData.apply(this,arguments);o.aggregations={layout:{ignore:true},dependents:{ignore:true},customData:{ignore:true},layoutData:{ignore:true},tooltip:{ignore:true}};return o;};
E.prototype.hasAggregation=function(a){return!!this.getAggregations()[a];};
E.prototype.getAggregation=function(a){return this.getAggregations()[a];};
E.prototype.createAggregationDesignTimeMetadata=function(m){return new A({data:m});};
E.prototype.getAggregations=function(){var a=this.getData().aggregations||{};var m=this.getData().associations||{};Object.keys(m).forEach(function(s){var b=m[s];if(b.aggregationLike){a[s]=b;}});return a;};
E.prototype.isActionAvailableOnAggregations=function(a){var m=this.getAggregations();return Object.keys(m).some(function(s){return m[s].actions&&m[s].actions[a];});};
E.prototype.getActionDataFromAggregations=function(a,e,b){var v;var m=this.getAggregations();var c=[];for(var s in m){if(m[s].actions&&m[s].actions[a]){v=m[s].actions[a];if(typeof v==="function"){var d=[e];if(b){d=d.concat(b);}v=v.apply(null,d);}if(typeof(v)==="string"){v={changeType:v};}if(v){v.aggregation=s;}c.push(v);}}return c;};
E.prototype._getText=function(e,n){if(typeof n==="function"){return n();}else{return this.getLibraryText(e,n);}};
E.prototype.getAggregationDescription=function(a,e){var c=this.getAggregation(a).childNames;if(typeof c==="function"){c=c.call(null,e);}if(c){return{singular:this._getText(e,c.singular),plural:this._getText(e,c.plural)};}};
E.prototype.getName=function(e){var n=this.getData().name;if(typeof n==="function"){n=n.call(null,e);}if(n){return{singular:this._getText(e,n.singular),plural:this._getText(e,n.plural)};}};
E.prototype.isAggregationIgnored=function(e,a){var m=this.getAggregations();var o=m[a];var i=(o)?o.ignore:false;if(!i||(i&&typeof i==="function"&&!i(e))){return false;}else{return true;}};
E.prototype.getScrollContainers=function(){return this.getData().scrollContainers||[];};
return E;},true);
sap.ui.predefine('sap/ui/dt/ElementOverlay',['sap/ui/dt/Overlay','sap/ui/dt/ControlObserver','sap/ui/dt/ManagedObjectObserver','sap/ui/dt/ElementDesignTimeMetadata','sap/ui/dt/OverlayRegistry','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/DOMUtil','sap/ui/dt/Util','sap/ui/core/Control'],function(O,C,M,E,a,b,c,D,U,d){"use strict";var S='sapUiDtOverlayScrollContainer';
var e=O.extend("sap.ui.dt.ElementOverlay",{
metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]},metadataScope:{type:"string"}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},elementDestroyed:{parameters:{targetId:"string"}}}},
constructor:function(){this._aMetadataEnhancers=[];O.apply(this,arguments);}
});
e.prototype.asyncInit=function(){return(this.getDesignTimeMetadata()?Promise.resolve():this._loadDesignTimeMetadata()).then(function(){this._initMutationObserver();this._initControlObserver();}.bind(this));};
e.prototype._initMutationObserver=function(){if(this.isRoot()){this._subscribeToMutationObserver();}this.attachEvent('isRootChanged',function(o){if(o.getParameter('value')){this._subscribeToMutationObserver();}else{this._unsubscribeFromMutationObserver();}},this);};
e.prototype._subscribeToMutationObserver=function(){var m=O.getMutationObserver();m.addToWhiteList(this.getElement().getId());m.attachDomChanged(this._onDomChanged,this);};
e.prototype._unsubscribeFromMutationObserver=function(){var m=O.getMutationObserver();m.removeFromWhiteList(this.getAssociation('element'));m.detachDomChanged(this._onDomChanged,this);};
e.prototype._initControlObserver=function(){if(this.getElement()instanceof d){this._oObserver=new C({target:this.getElement()});}else{this._oObserver=new M({target:this.getElement()});}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this);};
e.prototype._destroyControlObserver=function(){if(this._oObserver){this._oObserver.destroy();}};
e.prototype._getAttributes=function(){return jQuery.extend(true,{},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-for":this.getElement().getId(),"draggable":this.getMovable()});};
e.prototype.render=function(){this.addStyleClass('sapUiDtElementOverlay');return O.prototype.render.apply(this,arguments);};
e.prototype.onAfterRendering=function(){var o=!this._oDomRef;O.prototype.onAfterRendering.apply(this,arguments);if(o&&this._oDomRef){var p={id:this.getId(),type:"overlayRendered"};this.fireElementModified(p);}};
e.prototype.exit=function(){this._unsubscribeFromMutationObserver();this._destroyControlObserver();if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}O.prototype.exit.apply(this,arguments);};
e.prototype._loadDesignTimeMetadata=function(){return this.getElement().getMetadata().loadDesignTime(this.getElement(),this.getMetadataScope()).then(function(m){var o=this.getElement();if(!o||o.bIsDestroyed){new Error("sap.ui.dt.ElementOverlay#loadDesignTimeMetadata / Can't set metadata to overlay which element has been destroyed already");}this.setDesignTimeMetadata(m);}.bind(this)).catch(function(v){var o=U.wrapError(v);if(U.isForeignError(o)){var l='sap.ui.dt.ElementOverlay#loadDesignTimeMetadata';o.name='Error in '+l;o.message=U.printf("{0} / Can't load designtime metadata data for overlay with id='{1}', element id='{2}' ({3}): {4}",l,this.getId(),this.getElement().getId(),this.getElement().getMetadata().getName(),o.message);}throw o;}.bind(this));};
e.prototype._setPosition=function(){O.prototype._setPosition.apply(this,arguments);this._sortChildren(this.getChildrenDomRef());this.getScrollContainers().forEach(function(s,i){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||jQuery();var f=this.getScrollContainerById(i);if($.length){var o=$.get(0);this._setSize(f,D.getGeometry(o));O.prototype._setPosition.call(this,f,D.getGeometry(o),this.$());this._handleOverflowScroll(D.getGeometry(o),f,this);this._sortChildren(f.get(0));}else{this._deleteDummyContainer(f);f.css("display","none");}},this);};
e.prototype._sortChildren=function(o){var f=function(i,j){var G=D.getGeometry(i);var k=D.getGeometry(j);var p=G&&G.position;var P=k&&k.position;if(p&&P){var B=p.top+G.size.height;var l=P.top+k.size.height;if(p.top<P.top){if(B>=l&&P.left<p.left){return 1;}else{return-1;}}else if(p.top===P.top){if(p.left===P.left){if(G.size.height<k.size.height||G.size.width<k.size.width){return-1;}else if(G.size.height>k.size.height||G.size.width>k.size.width){return 1;}else{return 0;}}else if(p.left<P.left){return-1;}else{return 1;}}else if(B<=l&&P.left>p.left){return-1;}else{return 1;}}return 0;};var g=jQuery(o).find('>:not(.sapUiDtDummyScrollContainer)').toArray();var s=g.slice().sort(f);var h=g.some(function(i,I){return i!==s[I];});if(h){s.forEach(function(i){D.appendChild(o,i);});}};
e.prototype.placeInOverlayContainer=function(){if(this._bInit){if(this.isRoot()){if(!this.isRendered()){O.getOverlayContainer().append(this.render());this.applyStyles();}else{jQuery.sap.log.error('sap.ui.dt.ElementOverlay: overlay is already rendered and can\'t be placed in overlay container. Isn\'t it already there?');}}else{jQuery.sap.log.error('sap.ui.dt.ElementOverlay: it\'s not possible to place overlay inside overlay container while it\'s part of some hierarchy');}}else{jQuery.sap.log.error('sap.ui.dt.ElementOverlay: overlay is not ready yet. Please wait until "init" event happens');}};
e.prototype.setDesignTimeMetadata=function(v){var o=this.getDesignTimeMetadata();var m;if(jQuery.isFunction(v)){if(!o){this._aMetadataEnhancers=this._aMetadataEnhancers.concat(v);}else{o.setData(v(jQuery.sap.extend(true,{},o.getData())));return;}}else if(v instanceof E){o=v;}else if(jQuery.isPlainObject(v)){m=v;var f;while(f=this._aMetadataEnhancers.shift()){m=f.call(this,m);}o=new E({data:m});}if(o){O.prototype.setDesignTimeMetadata.call(this,o);}};
e.prototype.getScrollContainers=function(){return this.getDesignTimeMetadata().getScrollContainers();};
e.prototype._renderChildren=function(){var f=O.prototype._renderChildren.apply(this,arguments);this.getScrollContainers().forEach(function(s,i){var $=jQuery("<div/>",{"class":S,"data-sap-ui-dt-scrollContainerIndex":i});if(s.aggregations){U.intersection(s.aggregations,this.getAggregationNames()).forEach(function(A){var o=this.getAggregationOverlay(A);var g=f.indexOf(o.$());o.setScrollContainerId(i);$.append(f[g]);f.splice(g,1);},this);}f.push($);},this);return f;};
e.prototype.getScrollContainerById=function(i){return jQuery(this.getChildrenDomRef()).find('>.'+S+'[data-sap-ui-dt-scrollcontainerindex="'+i+'"]');};
e.prototype.getAssociatedDomRef=function(){var o=b.getDomRef(this.getElement());if(!o){var f=this.getDesignTimeMetadata();if(!f){return undefined;}var g=f.getDomRef();if(typeof g==="function"){o=g(this.getElement());}}if(o){return jQuery(o);}return undefined;};
e.prototype.setSelectable=function(s){s=!!s;if(s!==this.isSelectable()){if(!s){this.setSelected(false);}this.toggleStyleClass("sapUiDtOverlaySelectable",s);this.setProperty("selectable",s);this.fireSelectableChange({selectable:s});}this.setFocusable(s);return this;};
e.prototype.setSelected=function(s,f){s=!!s;if(this.isSelectable()&&s!==this.isSelected()){this.setProperty("selected",s);this.toggleStyleClass("sapUiDtOverlaySelected",s);if(!f){this.fireSelectionChange({selected:s});}}return this;};
e.prototype.setMovable=function(m){m=!!m;if(this.getMovable()!==m){this.toggleStyleClass("sapUiDtOverlayMovable",m);this.setProperty("movable",m);this.fireMovableChange({movable:m});this.$()[m?'attr':'removeAttr']('draggable',m);}return this;};
e.prototype.setEditable=function(f){f=!!f;if(this.getEditable()!==f){this.toggleStyleClass("sapUiDtOverlayEditable",f);this.setProperty("editable",f);this.fireEditableChange({editable:f});}return this;};
e.prototype.getAggregationNames=function(){var o=this.getElement();var f=this.getDesignTimeMetadata();var A=o.getMetadata().getAllAggregations();return[].concat(Object.keys(A),Object.keys(f.getAggregations())).filter(function(s,i,g){return(i===g.indexOf(s)&&!f.isAggregationIgnored(o,s));});};
e.prototype._onChildAdded=function(o){var A=o.getSource();if(this.isRendered()&&!A.isRendered()){this._getRenderingContainer(A).append(A.render());}};
e.prototype._getRenderingContainer=function(A){return(U.isInteger(A.getScrollContainerId())?this.getScrollContainerById(A.getScrollContainerId()):jQuery(this.getChildrenDomRef()));};
e.prototype.addChild=function(A){if(this.isRendered()){var t=this._getRenderingContainer(A);t.append(A.getDomRef());if(U.isInteger(A.getScrollContainerId())){jQuery(this.getChildrenDomRef()).append(t);}}A.detachChildAdded(this._onChildAdded,this);A.attachChildAdded(this._onChildAdded,this);O.prototype.addChild.apply(this,arguments);};
e.prototype._onElementModified=function(o){var p=o.getParameters();var n=p.name;if(p.type==="propertyChanged"&&n==="visible"){this.setRelevantOverlays([]);this.fireElementModified(p);}else if(n){var A=this.getAggregationOverlay(n);if(A){this.setRelevantOverlays([]);this.fireElementModified(p);}}else if(o.getParameters().type==="setParent"){this.fireElementModified(p);}};
e.prototype._onDomChanged=function(o){if(this.isReady()&&this.isRoot()){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this.applyStyles();delete this._iApplyStylesRequest;}.bind(this));}};
e.prototype._onElementDestroyed=function(o){var s=o.getSource().getTarget();this.fireElementDestroyed({targetId:s});if(this._bInit){this.destroy();}else{this._bShouldBeDestroyed=true;}};
e.prototype.getAggregationOverlays=function(){return this.getAggregation("children")||[];};
e.prototype.getAggregationOverlay=function(A){return this.getChildren().filter(function(o){return o.getAggregationName()===A;}).pop();};
e.prototype.getParentElementOverlay=function(){var p=this.getParentAggregationOverlay();if(p){return p.getParent();}};
e.prototype.getParentAggregationOverlay=function(){var p=this.getParent();return p instanceof sap.ui.dt.AggregationOverlay?p:null;};
e.prototype.isSelected=function(){return this.getSelected();};
e.prototype.isSelectable=function(){return this.getSelectable();};
e.prototype.isMovable=function(){return this.getMovable();};
e.prototype.isEditable=function(){return this.getEditable();};
e.prototype._getElementInstanceVisible=function(){var o=this.getElement();if(o){var g=this.getGeometry();return g&&g.visible;}else{return false;}};
e.prototype.getElementVisibility=function(){var o=this.getElement();if(o instanceof sap.ui.core.Control){return o.getVisible();}var f=this.getDesignTimeMetadata();var g=f&&f.getData().isVisible;if(!g){return undefined;}return g(this.getElement());};
e.prototype.isElementVisible=function(){var o=this.getElement();var v=false;if(this.getDesignTimeMetadata().isIgnored(o)){v=false;}else{var g=this.getGeometry(true);if(g){v=g.visible;}else if(jQuery.isFunction(this.getDesignTimeMetadata().getData().isVisible)){v=this.getDesignTimeMetadata().getData().isVisible(o);}else if(o instanceof d){v=!!o.getDomRef()&&o.getVisible();}}return v;};
e.prototype.isVisible=function(){return(O.prototype.isVisible.apply(this,arguments)&&this.isElementVisible());};
e.prototype.getRelevantContainer=function(f){var o=this.getDesignTimeMetadata();if(o&&o.getData().relevantContainer){return o.getData().relevantContainer;}else if(f){return this.getElement();}var p=this.getParentElementOverlay();return p?p.getElement():undefined;};
return e;},true);
sap.ui.predefine('sap/ui/dt/ElementUtil',['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){"use strict";var E={};E.sACTION_MOVE='move';E.sACTION_CUT='cut';E.sACTION_PASTE='paste';E.sREORDER_AGGREGATION='reorder_aggregation';
E.iterateOverElements=function(e,c){if(e&&e.length){for(var i=0;i<e.length;i++){var o=e[i];if(o instanceof sap.ui.base.ManagedObject){c(o);}}}else if(e instanceof sap.ui.base.ManagedObject){c(e);}};
E.iterateOverAllPublicAggregations=function(e,c){var a=e.getMetadata().getAllAggregations();var A=Object.keys(a);A.forEach(function(s){var o=a[s];var v=this.getAggregation(e,s);c(o,v);},this);};
E.getElementInstance=function(e){if(typeof e==="string"){var o=sap.ui.getCore().byId(e);return o||sap.ui.getCore().getComponent(e);}else{return e;}};
E.hasAncestor=function(e,a){a=this.fixComponentContainerElement(a);var p=this.fixComponentParent(e);while(p&&p!==a){p=p.getParent();p=this.fixComponentParent(p);}return!!p;};
E.getClosestElementForNode=function(n){var c=q(n).closest("[data-sap-ui]");return c.length?sap.ui.getCore().byId(c.data("sap-ui")):undefined;};
E.getClosestElementOfType=function(s,t){var e=s;while(e&&!this.isInstanceOf(e,t)){e=e.getParent();}return e;};
E.fixComponentParent=function(e){if(this.isInstanceOf(e,"sap.ui.core.UIComponent")){var c=e.oContainer;if(c){return c.getParent();}}else{return e;}};
E.fixComponentContainerElement=function(e){if(this.isInstanceOf(e,"sap.ui.core.ComponentContainer")){if(!e.getComponentInstance()){return;}return e.getComponentInstance().getRootControl();}else{return e;}};
E.findAllPublicElements=function(e){var f=[];var i=function(e){e=this.fixComponentContainerElement(e);if(e){f.push(e);this.iterateOverAllPublicAggregations(e,function(a,v){this.iterateOverElements(v,i);}.bind(this));}}.bind(this);i(e);return f;};
E.getDomRef=function(e){if(e){var d;if(e.getDomRef){d=e.getDomRef();}if(!d&&e.getRenderedDomRef){d=e.getRenderedDomRef();}return d;}};
E.findAllPublicChildren=function(e){var f=this.findAllPublicElements(e);var i=f.indexOf(e);if(i>-1){f.splice(i,1);}return f;};
E.isElementFiltered=function(c,t){t=t||this.getControlFilter();var f=false;t.forEach(function(T){f=this.isInstanceOf(c,T);if(f){return false;}},this);return f;};
E.findClosestControlInDom=function(n){if(n&&n.getAttribute("data-sap-ui")){return sap.ui.getCore().byId(n.getAttribute("data-sap-ui"));}else if(n.parentNode){this.findClosestControlInDom(n.parentNode);}else{return null;}};
E.findAllSiblingsInContainer=function(e,c){var p=e.getParent();if(!p){return[];}if(p!==c){var P=E.findAllSiblingsInContainer(p,c);return P.map(function(p){return E.getAggregation(p,e.sParentAggregationName);}).reduce(function(a,b){return a.concat(b);},[]);}return E.getAggregation(p,e.sParentAggregationName);};
E.getAggregationAccessors=function(e,a){var m=e.getMetadata();m.getJSONKeys();var A=m.getAggregation(a);if(A){var g=A._sGetter;if(A.altTypes&&A.altTypes.length&&e[A._sGetter+"Control"]){g=A._sGetter+"Control";}return{get:g,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}else{return{};}};
E.getAggregation=function(e,a){var v;var g=this.getAggregationAccessors(e,a).get;if(g){v=e[g]();}else{v=e.getAggregation(a);}v=v&&v.splice?v:(v?[v]:[]);return v;};
E.getIndexInAggregation=function(e,p,a){return this.getAggregation(p,a).indexOf(e);};
E.addAggregation=function(p,a,e){if(this.hasAncestor(p,e)){throw new Error("Trying to add an element to itself or its successors");}var A=this.getAggregationAccessors(p,a).add;if(A){p[A](e);}else{p.addAggregation(a,e);}};
E.removeAggregation=function(p,a,e,s){var A=this.getAggregationAccessors(p,a).remove;if(A){p[A](e,s);}else{p.removeAggregation(a,e,s);}};
E.insertAggregation=function(p,a,e,i){if(this.hasAncestor(p,e)){throw new Error("Trying to add an element to itself or its successors");}if(this.getIndexInAggregation(e,p,a)!==-1){e.__bSapUiDtSupressParentChangeEvent=true;try{this.removeAggregation(p,a,e,true);}finally{delete e.__bSapUiDtSupressParentChangeEvent;}}var A=this.getAggregationAccessors(p,a).insert;if(A){p[A](e,i);}else{p.insertAggregation(a,e,i);}};
E.isValidForAggregation=function(p,a,e){var A=p.getMetadata().getAggregation(a);if(this.hasAncestor(p,e)){return false;}if(A){var t=A.type;if(A.multiple===false&&this.getAggregation(p,a)&&this.getAggregation(p,a).length>0){return false;}return this.isInstanceOf(e,t)||this.hasInterface(e,t);}};
E.getAssociationAccessors=function(e,a){var m=e.getMetadata();m.getJSONKeys();var A=m.getAssociation(a);if(A){return{get:A._sGetter,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}else{return{};}};
E.getAssociation=function(e,a){var v;var g=this.getAssociationAccessors(e,a).get;if(g){v=e[g]();}return v;};
E.getIndexInAssociation=function(e,p,a){return this.getAssociationInstances(p,a).indexOf(e);};
E.getAssociationInstances=function(e,a){var v=this.getAssociation(e,a);if(!Array.isArray(v)){v=v?[v]:[];}return v.map(function(i){return this.getElementInstance(i);},this);};
E.hasInterface=function(e,i){var I=e.getMetadata().getInterfaces();return I.indexOf(i)!==-1;};
E.isInstanceOf=function(e,t){var i=q.sap.getObject(t);if(typeof i==="function"){return e instanceof i;}else{return false;}};
E.executeActions=function(a){var t,m;for(var i=0;i<a.length;i++){var A=a[i];switch(A.changeType){case E.sACTION_MOVE:t=sap.ui.getCore().byId(A.target.parent);m=sap.ui.getCore().byId(A.element);E.insertAggregation(t,A.target.aggregation,m,A.target.index);break;case E.sACTION_CUT:t=sap.ui.getCore().byId(A.source.parent);m=sap.ui.getCore().byId(A.element);E.removeAggregation(t,A.source.aggregation,m);break;case E.sACTION_PASTE:t=sap.ui.getCore().byId(A.target.parent);m=sap.ui.getCore().byId(A.element);E.insertAggregation(t,A.target.aggregation,m,A.target.index);break;case E.sREORDER_AGGREGATION:t=sap.ui.getCore().byId(A.target.parent);var s=this.getAggregationAccessors(t,A.target.aggregation).removeAll;t[s]();var b=this.getAggregationAccessors(t,A.target.aggregation).add;for(var j=0;j<A.source.elements.length;j++){var e=sap.ui.getCore().byId(A.source.elements[j]);t[b](e);}break;default:}}};
E.isVisible=function(e){var v=false;var c;for(var i=0,n=e.length;i<n;i++){c=e.eq(i);var f=c.css("filter").match(/opacity\(([^)]*)\)/);v=c.is(":visible")&&c.css("visibility")!=="hidden"&&c.css("opacity")>0&&(f?parseFloat(f[1])>0:true);if(v){break;}}return v;};
E.isElementValid=function(e,s,a){var i=e instanceof M&&!e.bIsDestroyed;if(!i&&s&&a){q.sap.log.error(["sap.ui.dt.DesignTime: child element in aggregation "+a+" of '"+s,"' should be a descendant of 'sap.ui.base.ManagedObject' and it is a '"+typeof e+"'. ","Please ignore the aggregation '"+a+"' in the .designtime configuration"].join(''));}return i;};
E.getParent=function(e){return this.isInstanceOf(e,'sap.ui.core.Component')?e.oContainer:e.getParent();};
return E;},true);
sap.ui.predefine('sap/ui/dt/Map',['sap/ui/dt/Util'],function(U){"use strict";var c=function(){var M=function(){this.iIndex=0;this.mKeys={};this.mValues={};};M.prototype._getNextIndex=function(){return this.iIndex++;};M.prototype._findIndex=function(k){for(var i in this.mKeys){if(this.mKeys[i]===k){return+i;}}};M.prototype.forEach=function(C){Object.keys(this.mKeys).forEach(function(k){C(this.mValues[k],this.mKeys[k],this);},this);};M.prototype.clear=function(){Object.keys(this.mKeys).forEach(function(k){delete this.mKeys[k];delete this.mValues[k];},this);};M.prototype.delete=function(k){var K=this._findIndex(k);if(U.isInteger(K)){delete this.mKeys[K];delete this.mValues[K];}};M.prototype.get=function(k){var K=this._findIndex(k);return U.isInteger(K)?this.mValues[K]:undefined;};M.prototype.set=function(k,v){var n=this._getNextIndex();this.mKeys[n]=k;this.mValues[n]=v;};return M;};return'Map'in window?window.Map:c();},true);
sap.ui.predefine('sap/ui/dt/Overlay',['jquery.sap.global','sap/ui/core/Element','sap/ui/dt/MutationObserver','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/DOMUtil','sap/ui/dt/ScrollbarSynchronizer','sap/ui/dt/Util','sap/ui/dt/Map'],function(q,E,M,a,O,D,S,U,b){"use strict";var c="overlay-container";var o;var m;
var d=E.extend("sap.ui.dt.Overlay",{
metadata:{library:"sap.ui.dt",properties:{visible:{type:"boolean",defaultValue:true},focusable:{type:"boolean",defaultValue:false},isRoot:{type:"boolean",defaultValue:false}},associations:{element:{type:"sap.ui.core.Element"}},aggregations:{children:{type:"sap.ui.dt.Overlay",multiple:true},designTimeMetadata:{type:"sap.ui.dt.DesignTimeMetadata",altTypes:["function","object"],multiple:false}},events:{init:{},initFailed:{},afterRendering:{},beforeDestroy:{},destroyed:{parameters:{}},visibleChanged:{parameters:{visible:"boolean"}},geometryChanged:{},childAdded:{},scrollSynced:{},isRootChanged:{parameters:{value:{type:"boolean"}}}}},
constructor:function(){this._aStyleClasses=this._aStyleClasses.slice(0);this._oScrollbarSynchronizers=new b();this._aBindParameters=[];E.apply(this,arguments);if(!this.getElement()){throw new Error("sap.ui.dt: can't create overlay without element");}this.asyncInit().then(function(){if(this._bShouldBeDestroyed){this.fireInitFailed({error:U.createError("Overlay#asyncInit","ElementOverlay is destroyed during initialization ('"+this.getId()+"')")});}else{this._bInit=true;this.fireInit();}}.bind(this)).catch(function(e){var f=U.wrapError(e);if(U.isForeignError(f)){var l='sap.ui.dt.Overlay#asyncInit';f.name='Error in '+l;f.message=U.printf("{0} / Can't initialize overlay (id='{1}') properly: {2}",l,this.getId(),f.message);}this.fireInitFailed({error:f});}.bind(this));},
_bInit:false,
_bRendered:false,
_$DomRef:null,
_aStyleClasses:['sapUiDtOverlay'],
_bShouldBeDestroyed:false,
_aBindParameters:null
});
d.getOverlayContainer=function(){if(!o){o=q("<div/>").attr('id',c).appendTo("body");}return o;};
d.removeOverlayContainer=function(){if(o){o.remove();}o=undefined;};
d.getMutationObserver=function(){if(!m){m=new M();}return m;};
d.destroyMutationObserver=function(){if(m){m.destroy();m=null;}};
d.prototype.asyncInit=function(){return Promise.resolve();};
d.prototype._getAttributes=function(){return{"id":this.getId(),"data-sap-ui":this.getId(),"class":this._aStyleClasses.join(" "),"tabindex":this.isFocusable()?0:null};};
d.prototype._renderChildren=function(){return this.getChildren().map(function(C){return C.isRendered()?C.$():C.render();});};
d.prototype.render=function(s){if(this.isRendered()){return this.getDomRef();}this._$DomRef=q('<div/>').attr(this._getAttributes());this._$Children=q('<div/>').attr({"class":"sapUiDtOverlayChildren"}).appendTo(this._$DomRef);this._$Children.append(this._renderChildren());this._bRendered=true;if(!s){this.fireAfterRendering({domRef:this._$DomRef.get(0)});}return this._$DomRef;};
d.prototype.isInit=function(){return this._bInit;};
d.prototype.isRendered=function(){return this._bRendered;};
d.prototype.isReady=function(){return this.isInit()&&this.isRendered();};
d.prototype.addStyleClass=function(C){if(!this.hasStyleClass(C)){this._aStyleClasses.push(C);if(this.isReady()){this.$().addClass(C);}}};
d.prototype.hasStyleClass=function(C){return this._aStyleClasses.indexOf(C)!==-1;};
d.prototype.removeStyleClass=function(C){if(this.hasStyleClass(C)){this._aStyleClasses=this._aStyleClasses.filter(function(i){return i!==C;});if(this.isReady()){this.$().removeClass(C);}}};
d.prototype.toggleStyleClass=function(C){this[(this.hasStyleClass(C)?'remove':'add')+'StyleClass'](C);};
d.prototype.setElement=function(e){if(!this.getElement()){this.setAssociation("element",e);if(this._designTimeMetadataCache){this.setDesignTimeMetadata(this._designTimeMetadataCache);delete this._designTimeMetadataCache;}}};
d.prototype.destroy=function(){if(this.bIsDestroyed){q.sap.log.error('FIXME: Do not destroy overlay twice (overlayId = '+this.getId()+')!');return;}this.fireBeforeDestroy();E.prototype.destroy.apply(this,arguments);};
d.prototype.exit=function(){this._oScrollbarSynchronizers.forEach(function(s){s.destroy();});this._oScrollbarSynchronizers.clear();this.$().remove();delete this._bInit;delete this._bShouldBeDestroyed;delete this._$DomRef;delete this._oScrollbarSynchronizers;this.fireDestroyed();};
d.prototype.setDesignTimeMetadata=function(v){if(!this.getElement()){this._designTimeMetadataCache=v;}else{this.setAggregation('designTimeMetadata',v);}};
d.prototype.getDomRef=function(){return this.$().get(0);};
d.prototype.getChildrenDomRef=function(){return this._$Children.get(0);};
d.prototype.$=function(){return this._$DomRef||q();};
d.prototype.getAssociatedDomRef=function(){throw new Error("This method is abstract and needs to be implemented");};
d.prototype.getElementInstance=function(){return this.getElement();};
d.prototype.getElement=function(){return a.getElementInstance(this.getAssociation('element'));};
d.prototype.hasFocus=function(){return document.activeElement===this.getDomRef();};
d.prototype.focus=function(){this.$().focus();};
d.prototype.setFocusable=function(f){f=!!f;if(this.getFocusable()!==f){this.setProperty("focusable",f);this.toggleStyleClass("sapUiDtOverlayFocusable");this.$().attr("tabindex",f?0:null);}};
d.prototype.isFocusable=function(){return this.getFocusable();};
d.prototype._getRenderingParent=function(){return this.isRoot()?null:this.getParent().$();};
d.prototype.applyStyles=function(i){if(!(typeof i==='boolean')){i=true;}if(this.isVisible()){var g=this.getGeometry(i);if(g&&g.visible){this._setSize(this.$(),g);var r=this._getRenderingParent();if(!this.isRoot()){var p=[];this.getParent()._oScrollbarSynchronizers.forEach(function(s){if(s._bSyncing){p.push(new Promise(function(R){s.attachEventOnce('synced',R);}));}});if(p.length){Promise.all(p).then(function(){this._applySizes(g,r);this.fireGeometryChanged();}.bind(this));}else{this._applySizes(g,r);}}else{this._applySizes(g,r);}}else{this.$().css("display","none");}}else{this.$().css("display","none");}if(!p||!p.length){this.fireGeometryChanged();}};
d.prototype._applySizes=function(g,r){this._setPosition(this.$(),g,r);if(g.domRef){this._handleOverflowScroll(g,this.$(),this.getParent());}this.getChildren().forEach(function(C){C.applyStyles();});};
d.prototype._setSize=function(t,g){t.css("display","block");var s=g.size;t.css("width",s.width+"px");t.css("height",s.height+"px");};
d.prototype._setPosition=function(t,g,p){var r=sap.ui.getCore().getConfiguration().getRTL();var P=p?p.scrollTop():null;var i=p?p.scrollLeft():null;var e=p?p.offset():null;var f=D.getOffsetFromParent(g.position,e,P,i);if(r){var h=this.isRoot()?q(window).width():p.width();f.left=f.left-(h-g.size.width);}t.css("transform","translate("+f.left+"px, "+f.top+"px)");};
d.prototype.attachBrowserEvent=function(e,h,l){if(e&&(typeof(e)==="string")){if(typeof h==="function"){if(!this._aBindParameters){this._aBindParameters=[];}l=l||this;var p=h.bind(l);this._aBindParameters.push({sEventType:e,fnHandler:h,oListener:l,fnProxy:p});this.$().bind(e,p);}}return this;};
d.prototype.detachBrowserEvent=function(e,h,l){if(e&&(typeof(e)==="string")){if(typeof(h)==="function"){var $=this.$(),i,p;l=l||this;if(this._aBindParameters){for(i=this._aBindParameters.length-1;i>=0;i--){p=this._aBindParameters[i];if(p.sEventType===e&&p.fnHandler===h&&p.oListener===l){this._aBindParameters.splice(i,1);$.unbind(e,p.fnProxy);}}}}}return this;};
d.prototype._deleteDummyContainer=function($){var e=$.find(">.sapUiDtDummyScrollContainer");if(e.length){e.remove();if(this.getParent()&&this.getParent().$){var p=this.getParent().$();p.removeClass("sapUiDtOverlayWithScrollBar");p.removeClass("sapUiDtOverlayWithScrollBarVertical");p.removeClass("sapUiDtOverlayWithScrollBarHorizontal");}this._oScrollbarSynchronizers.get($.get(0)).destroy();this._oScrollbarSynchronizers.delete($.get(0));}};
d.prototype._handleOverflowScroll=function(g,$,e){var f=g.domRef;var s=g.size;var z=D.getZIndex(f);if(z){$.css("z-index",z);}var h=D.getOverflows(f);$.css("overflow-x",h.overflowX);$.css("overflow-y",h.overflowY);var i=f.scrollHeight;var j=f.scrollWidth;if(i>Math.ceil(s.height)||j>Math.ceil(s.width)){var k=$.find("> .sapUiDtDummyScrollContainer");if(!k.length){k=q("<div/>",{css:{height:i+"px",width:j+"px"}});k=q("<div class='sapUiDtDummyScrollContainer' style='height: "+i+"px; width: "+j+"px;'></div>");if(e&&D.hasVerticalScrollBar(f)){e.$().addClass("sapUiDtOverlayWithScrollBar");e.$().addClass("sapUiDtOverlayWithScrollBarVertical");}if(e&&D.hasHorizontalScrollBar(f)){e.$().addClass("sapUiDtOverlayWithScrollBar");e.$().addClass("sapUiDtOverlayWithScrollBarHorizontal");}$.append(k);var l=new S({synced:this.fireScrollSynced.bind(this)});l.addTarget(f,$.get(0));this._oScrollbarSynchronizers.set($.get(0),l);}else{k.css({"height":i,"width":j});var l=this._oScrollbarSynchronizers.get($.get(0));if(!l.hasTarget(f)){l.addTarget(f);}}}else{this._deleteDummyContainer($);}};
d.prototype.getGeometry=function(f){if(f||!this._mGeometry){var $=this.getAssociatedDomRef();var C;if($){var i=this.isRoot();C=q.makeArray($).map(function(e){return D.getGeometry(e,i);});}else{C=this.getChildren().map(function(e){return e.getGeometry(true);});}if(C.length){this._mGeometry=C.length>1?O.getGeometry(C):C[0];}else{delete this._mGeometry;}}return this._mGeometry;};
d.prototype.setVisible=function(v){v=!!v;if(this.getVisible()!==v){this.setProperty("visible",v);this.fireVisibleChanged({visible:v});}};
d.prototype.isVisible=function(){return(this.getVisible()&&(this.isRoot()?true:this.getParent().isVisible()));};
d.prototype.setIsRoot=function(v){v=!!v;if(this.getIsRoot()!==v){this.setProperty('isRoot',v);this.fireIsRootChanged({value:v});}};
d.prototype.isRoot=function(){return this.getIsRoot();};
return d;},true);
sap.ui.predefine('sap/ui/dt/OverlayRegistry',["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/Util"],function(M,E,U){"use strict";var O={};var S='sap.ui.dt.ElementOverlay';var a='sap.ui.dt.AggregationOverlay';var o={};var A={};
O.getOverlay=function(e){var I=(typeof e==="string"?e:E.getElementInstance(e)&&E.getElementInstance(e).getId());return o[I]||A[I];};
O.getOverlays=function(){return U.objectValues(o);};
O.register=function(b){if(!i(b)){var l='sap.ui.dt.OverlayRegistry#register';var e=new Error(l+' / Attempt to register illegal overlay');e.name=l;throw e;}o[b.getId()]=b;if(b.getMetadata().getName()===S){A[b.getAssociation('element')]=b;}};
O.deregister=function(b){if(!i(b)){var l='sap.ui.dt.OverlayRegistry#deregister';var e=new Error(l+' / Attempt to deregister illegal overlay');e.name=l;throw e;}delete o[b.getId()];if(b.getMetadata().getName()===S){delete A[b.getAssociation('element')];}};
O.hasOverlays=function(){return!jQuery.isEmptyObject(o);};
function i(b){return(b instanceof M&&[S,a].indexOf(b.getMetadata().getName())>-1);}
return O;},true);
sap.ui.predefine('sap/ui/dt/Plugin',['sap/ui/base/ManagedObject'],function(M){"use strict";
var P=M.extend("sap.ui.dt.Plugin",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{designTime:{type:"object",multiple:false}}}});
P.prototype.init=function(){};
P.prototype.exit=function(){this.setDesignTime(null);};
P.prototype.setDesignTime=function(d){var o=this.getDesignTime();if(o){this._deregisterOverlays(o);}this.setProperty("designTime",d);if(d){this._registerOverlays(d);}return this;};
P.prototype._registerOverlays=function(d){if(this.registerElementOverlay||this.registerAggregationOverlay){var e=d.getElementOverlays();e.forEach(this.callElementOverlayRegistrationMethods.bind(this));}};
P.prototype._deregisterOverlays=function(d){if(this.deregisterElementOverlay||this.deregisterAggregationOverlay){var o=d.getElementOverlays();o.forEach(this._callElementOverlayDeregestrationMethods.bind(this));}};
P.prototype.callAggregationOverlayRegistrationMethods=function(e){if(this.registerAggregationOverlay){var a=e.getAggregationOverlays();a.forEach(this.registerAggregationOverlay.bind(this));}};
P.prototype.callElementOverlayRegistrationMethods=function(e){if(this.registerElementOverlay){this.registerElementOverlay(e);}this.callAggregationOverlayRegistrationMethods(e);};
P.prototype._callElementOverlayDeregestrationMethods=function(e){if(this.deregisterElementOverlay){this.deregisterElementOverlay(e);}if(this.deregisterAggregationOverlay){var a=e.getAggregationOverlays();a.forEach(this.deregisterAggregationOverlay.bind(this));}};
P.prototype._onElementOverlayCreated=function(e){var o=e.getParameter("elementOverlay");this.callElementOverlayRegistrationMethods(o);};
P.prototype.getMenuItems=function(){};
P.prototype.getActionName=function(){};
P.prototype.getAction=function(o){return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getAction(this.getActionName(),o.getElement()):null;};
P.prototype.isMultiSelectionInactive=function(){return this.getNumberOfSelectedOverlays()<2;};
P.prototype.getNumberOfSelectedOverlays=function(){return this.getSelectedOverlays().length;};
P.prototype.getSelectedOverlays=function(){return this.getDesignTime().getSelectionManager().get();};
P.prototype.getActionText=function(o,a,p){var n=a.name;var e=o.getElement();if(n){if(typeof n==="function"){return n.call(null,e);}else{return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getLibraryText(e,n):"";}}else{return sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText(p);}};
P.prototype.isAvailable=function(o){return this._isEditableByPlugin(o);};
P.prototype.handler=function(o){};
P.prototype.isEnabled=function(o){};
P.prototype._getMenuItems=function(o,p){var a=this.getAction(o);if(!a||!this.isAvailable(o)){return[];}return[{id:p.pluginId,text:this.getActionText(o,a,p.pluginId),handler:function(O,p){return this.handler(O,p);}.bind(this),enabled:this.isEnabled.bind(this),rank:p.rank,icon:p.icon,group:p.group}];};
return P;},true);
sap.ui.predefine('sap/ui/dt/ScrollbarSynchronizer',['sap/ui/base/ManagedObject','sap/ui/dt/DOMUtil'],function(M,D){"use strict";
var S=M.extend("sap.ui.dt.ScrollbarSynchronizer",{
metadata:{library:"sap.ui.dt",properties:{"scrollTop":{type:"float"},"scrollLeft":{type:"float"},"targets":{type:"any[]",defaultValue:[]}},events:{synced:{}}},
_bSyncing:false,
constructor:function(){this._scrollEventHandler=this._scrollEventHandler.bind(this);M.apply(this,arguments);}
});
S.prototype.getTargets=function(){return this.getProperty('targets').slice(0);};
S.prototype.setTargets=function(t){var T=Array.isArray(t)?t:[t];this.getTargets().forEach(this.removeTarget.bind(this));this.addTarget.apply(this,T);};
S.prototype.removeTarget=function(d){this._detachScrollEvent(d);this.setProperty('targets',this.getTargets().filter(function(t){return t!==d;}));};
S.prototype.addTarget=function(){var t=Array.prototype.slice.call(arguments);if(!t.length){return;}this._removeDeadNodes();t.forEach(this._attachScrollEvent,this);var n=this.getTargets().concat(t);this.setProperty('targets',n);this._sync(n[0]);};
S.prototype.hasTarget=function(d){return this.getTargets().indexOf(d)>-1;};
S.prototype._removeDeadNodes=function(){this.getTargets().forEach(function(d){if(!document.body.contains(d)){this.removeTarget(d);}},this);};
S.prototype._attachScrollEvent=function(d){jQuery(d).on("scroll",this._scrollEventHandler);};
S.prototype._detachScrollEvent=function(d){jQuery(d).off("scroll",this._scrollEventHandler);};
S.prototype._scrollEventHandler=function(e){this._sync(e.target);};
S.prototype._sync=function(s){if(this.getScrollTop()!==s.scrollTop||this.getScrollLeft()!==s.scrollLeft){this.setScrollTop(s.scrollTop);this.setScrollLeft(s.scrollLeft);if(!this._bSyncing){this._bSyncing=true;this.animationFrame=window.requestAnimationFrame(function(){this.getTargets().filter(function(d){return s!==d;}).forEach(function(d){D.syncScroll(s,d);});this.fireSynced();this._bSyncing=false;}.bind(this));}}};
S.prototype.destroy=function(){this.getTargets().forEach(function(d){this.removeTarget(d);},this);M.prototype.destroy.apply(this,arguments);};
S.prototype.isSyncing=function(){return this._bSyncing;};
return S;},true);
sap.ui.predefine('sap/ui/dt/SelectionManager',['sap/ui/base/ManagedObject','sap/ui/dt/OverlayRegistry','sap/ui/dt/Util','./library'],function(M,O,U){"use strict";
var S=M.extend("sap.ui.dt.SelectionManager",{metadata:{library:"sap.ui.dt",properties:{"mode":{type:"sap.ui.dt.SelectionMode",defaultValue:sap.ui.dt.SelectionMode.Single}},associations:{},aggregations:{},events:{"change":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}}}}});
S.prototype.init=function(){this._aSelection=[];};
S.prototype.exit=function(){delete this._aSelection;};
S.prototype.get=function(){return this._aSelection.slice();};
S.prototype.set=function(s){var b=false;var a=false;if(this._aSelection.length==0&&!s){return b;}this._aSelection.forEach(function(o){o.setSelected(false,true);b=true;},this);this._aSelection=[];this._updateMode(this.get());if(s){a=this.add(U.castArray(s));}if(a){return a;}else if(b){this.fireChange({selection:this.get()});}return b;};
S.prototype.add=function(s){var b=false;if(!s){return b;}var a=U.castArray(s);a.forEach(function(o){var c=null;c=O.getOverlay(o);if(c&&(this._aSelection.indexOf(c)===-1)){if(c.setSelected(true,true).getSelected()){this._aSelection.push(c);b=true;}}},this);if(b){this._updateMode(this.get());this.fireChange({selection:this.get()});}return b;};
S.prototype.remove=function(s){var b=false;if(!s){return b;}var a=U.castArray(s);a.forEach(function(o){var c=null;c=O.getOverlay(o);if(c&&(this._aSelection.indexOf(c)!==-1)){this._aSelection=this._aSelection.filter(function(i){return c!==i;});c.setSelected(false,true);b=true;}},this);if(b){this._updateMode(this.get());this.fireChange({selection:this.get()});}return b;};
S.prototype._add=function(o){this._syncSelectionWithMode();this._aSelection=this._aSelection.concat(o);this.fireChange({selection:this.get()});};
S.prototype._remove=function(o){this._syncSelectionWithMode();if(this._aSelection.indexOf(o)!==-1){this._aSelection=this._aSelection.filter(function(i){return o!==i;});}this.fireChange({selection:this.get()});};
S.prototype._isSingleMode=function(){return this.getMode()===sap.ui.dt.SelectionMode.Single;};
S.prototype._syncSelectionWithMode=function(){if(this._isSingleMode()){this._aSelection.forEach(function(o){o.setSelected(false,true);});this._aSelection=[];}};
S.prototype._updateMode=function(s){if(s.length>1){this.setMode(sap.ui.dt.SelectionMode.Multi);}else{this.setMode(sap.ui.dt.SelectionMode.Single);}};
return S;},true);
sap.ui.predefine('sap/ui/dt/SelectionMode',function(){"use strict";return{Multi:"Multi",Single:"Single"};},true);
sap.ui.predefine('sap/ui/dt/TaskManager',['sap/ui/base/ManagedObject'],function(M){"use strict";
var T=M.extend("sap.ui.dt.TaskManager",{
metadata:{library:"sap.ui.dt",properties:{suppressEvents:{type:"boolean",defaultValue:false}},events:{add:{parameters:{taskId:"int"}},complete:{parameters:{taskId:"int"}}}},
constructor:function(){M.apply(this,arguments);this._aList=[];},
_iNextId:0
});
T.prototype.add=function(t){if(!jQuery.isPlainObject(t)||!t.type){throw new Error('Invalid task specified');}var i=this._iNextId++;this._aList.push(jQuery.extend({},t,{id:i}));if(!this.getSuppressEvents()){this.fireAdd({taskId:i});}return i;};
T.prototype.complete=function(t){this._aList=this._aList.filter(function(m){return m.id!==t;});if(!this.getSuppressEvents()){this.fireComplete({taskId:t});}};
T.prototype.cancel=function(t){this.complete(t);};
T.prototype.isEmpty=function(){return this.count()===0;};
T.prototype.count=function(){return this._aList.length;};
T.prototype.getList=function(){return this._aList.slice(0);};
T.prototype.getList=function(){return this._aList.slice(0);};
T.prototype.destroy=function(){this.setSuppressEvents(true);this.getList().forEach(function(t){this.cancel(t.id);},this);};
return T;});
sap.ui.predefine('sap/ui/dt/Util',['jquery.sap.global'],function(q){"use strict";var U={};var S='sap.ui.dt';
U.wrapError=function(e){var E=e instanceof Error&&e||new Error();if(typeof e==='string'){E.message=e;}return E;};
U.isForeignError=function(e){if(e instanceof Error){return e.name.indexOf(S)===-1;}else{throw U.createError('Util#isForeignError','Wrong parameter specified');}};
U.createError=function(l,m){var e=new Error();var L=S+(l?'.'+l:'');e.name='Error in '+L;e.message=m;return e;};
U.errorToString=function(e){if(typeof e==='string'){return e;}else if(e instanceof Error){var E=e.toString();if(e.stack){E+='\n'+e.stack.replace(E,'').trim();}return E;}else{throw U.createError('Util#errorToString','Wrong parameter specified');}};
U.propagateError=function(e,l,m){var E=U.wrapError(e);if(U.isForeignError(E)){var L=S+'.'+l;E.name='Error in '+L;E.message=U.printf('{0}. Original error: {1}',m,E.message||'¯\\_(ツ)_/¯');}return E;};
U.printf=function(s){var a=Array.prototype.slice.call(arguments,1);return s.replace(/{(\d+)}/g,function(m,i){return typeof a[i]!=='undefined'?a[i]:m;});};
U.curry=function(o){var a=o.length;var r=function(){var A=Array.prototype.slice.call(arguments);if(A.length>=a){return o.apply(this,A);}else{return function(){return r.apply(this,A.concat(Array.prototype.slice.call(arguments)));};}};return r;};
U.objectValues=function(o){return q.map(o,function(v){return v;});};
U.intersection=function(a,A){return a.filter(function(v){return A.indexOf(v)>-1;});};
U.isInteger=function(v){return q.isNumeric(v)&&Math.ceil(v)===v;};
U.castArray=function(v){var r=[];if(v){if(!Array.isArray(v)){r.push(v);}else{r=v;}}return r;};
return U;},true);
sap.ui.predefine('sap/ui/dt/library',['jquery.sap.global','sap/ui/core/library'],function(q){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.dt",version:"1.54.7",dependencies:["sap.ui.core"],types:["sap.ui.dt.SelectionMode"],interfaces:[],controls:[],elements:[]});sap.ui.dt.SelectionMode={Multi:"Multi",Single:"Single"};return sap.ui.dt;},true);
sap.ui.predefine('sap/ui/dt/plugin/DragDrop',['sap/ui/dt/Plugin','sap/ui/dt/DOMUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayRegistry'],function(P,D,O,E,a){"use strict";
var b=P.extend("sap.ui.dt.plugin.DragDrop",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});
var I=7;var _=false;var p=false;var o;
b.prototype._preventScrollOnTouch=function(f){if(p){f.preventDefault();}};
b.prototype.init=function(){P.prototype.init.apply(this,arguments);document.addEventListener('touchmove',this._preventScrollOnTouch,true);this._dragScrollHandler=this._dragScroll.bind(this);this._dragLeaveHandler=this._dragLeave.bind(this);this._mScrollIntervals={};};
b.prototype.exit=function(){P.prototype.exit.apply(this,arguments);document.removeEventListener('touchmove',this._preventScrollOnTouch);delete this._mElementOverlayDelegate;delete this._mAggregationOverlayDelegate;delete this._dragScrollHandler;};
b.prototype.registerElementOverlay=function(f){f.attachEvent("movableChange",this._onMovableChange,this);if(f.isMovable()){this._attachDragEvents(f);}f.attachBrowserEvent("dragover",this._onDragOver,this);f.attachBrowserEvent("dragenter",this._onDragEnter,this);f.attachBrowserEvent("dragleave",this._onDragLeave,this);};
b.prototype.registerAggregationOverlay=function(A){A.attachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._attachDragScrollHandler(A);}};
b.prototype.deregisterElementOverlay=function(f){f.detachEvent("movableChange",this._onMovableChange,this);this._detachDragEvents(f);f.detachBrowserEvent("dragover",this._onDragOver,this);f.detachBrowserEvent("dragenter",this._onDragEnter,this);f.detachBrowserEvent("dragleave",this._onDragLeave,this);};
b.prototype.deregisterAggregationOverlay=function(A){A.detachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._removeDragScrollHandler(A);this._clearScrollIntervalFor(A.$().attr("id"));}};
b.prototype._attachDragEvents=function(f){f.attachBrowserEvent("dragstart",this._onDragStart,this);f.attachBrowserEvent("drag",this._onDrag,this);f.attachBrowserEvent("dragend",this._onDragEnd,this);f.attachBrowserEvent("touchstart",this._onTouchStart,this);};
b.prototype._detachDragEvents=function(f){f.detachBrowserEvent("dragstart",this._onDragStart,this);f.detachBrowserEvent("drag",this._onDrag,this);f.detachBrowserEvent("dragend",this._onDragEnd,this);f.detachBrowserEvent("touchstart",this._onTouchStart,this);};
b.prototype.onMovableChange=function(f){};
b.prototype.onDragStart=function(f){};
b.prototype.onDragEnd=function(f){};
b.prototype.onDrag=function(f){};
b.prototype.onDragEnter=function(f){};
b.prototype.onDragLeave=function(f){};
b.prototype.onDragOver=function(f){};
b.prototype.onAggregationDragEnter=function(A){};
b.prototype.onAggregationDragOver=function(A){};
b.prototype.onAggregationDragLeave=function(A){};
b.prototype.onAggregationDrop=function(A){};
b.prototype._checkMovable=function(f){if(f.isMovable()||D.getDraggable(f.$())!==undefined){D.setDraggable(f.$(),f.isMovable());}};
b.prototype._onMovableChange=function(f){var g=f.getSource();if(g.isMovable()){this._attachDragEvents(g);}else{this._detachDragEvents(g);}this.onMovableChange(g);};
b.prototype._onDragStart=function(f){var g=a.getOverlay(f.currentTarget.id);f.stopPropagation();if(sap.ui.Device.browser.firefox&&f&&f.originalEvent&&f.originalEvent.dataTransfer&&f.originalEvent.dataTransfer.setData){f.originalEvent.dataTransfer.setData('text/plain','');}_=true;this.showGhost(g,f);this.onDragStart(g);};
b.prototype._attachTouchDragEvents=function(f){f.attachBrowserEvent("touchmove",this._onTouchMove,this);f.attachBrowserEvent("touchend",this._onTouchEnd,this);};
b.prototype._detachTouchDragEvents=function(f){f.detachBrowserEvent("touchmove",this._onTouchMove,this);f.detachBrowserEvent("touchend",this._onTouchEnd,this);};
b.prototype._onTouchStart=function(f){var t=f.touches[0].pageX;var g=f.touches[0].pageY;var T,h;var i=a.getOverlay(f.currentTarget.id);var j=function(){i.detachBrowserEvent("touchmove",T,this);i.detachBrowserEvent("touchend",h,this);i.detachBrowserEvent("contextmenu",h,this);};var G=function(k,l){var m=t-k;var n=g-l;return Math.sqrt((m*m)+(n*n));};T=function(f){var k=f.touches[0].pageX;var l=f.touches[0].pageY;var m=G(k,l);if(m>I){this.onDragStart(i);j.call(this);this._attachTouchDragEvents(i);}};h=function(f){j.call(this);p=false;};p=true;f.stopPropagation();i.attachBrowserEvent("touchmove",T,this);i.attachBrowserEvent("contextmenu",h,this);i.attachBrowserEvent("touchend",h,this);};
b.prototype._getTargetOverlay=function(f){if(f&&E.isInstanceOf(f,"sap.ui.dt.Overlay")){var t;if(E.isInstanceOf(f,"sap.ui.dt.AggregationOverlay")&&f.getTargetZone()){t=f;}else if(O.isInTargetZoneAggregation(f)){t=f;}return t?t:this._getTargetOverlay(f.getParent());}};
b.prototype._findTargetOverlayFromCoordinates=function(f,g){var h=document.elementFromPoint(f,g);var i=h?sap.ui.getCore().byId(h.id):undefined;return this._getTargetOverlay(i);};
b.prototype._onTouchMove=function(f){var g=a.getOverlay(f.currentTarget.id);this.onDrag(g);var t=f.touches||f.changedTouches;var h=t[0].pageX;var i=t[0].pageY;var T=this._findTargetOverlayFromCoordinates(h,i);if(!T){return;}if(T!==o){if(o){if(E.isInstanceOf(o,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragLeave(o);}else{this.onDragLeave(o);}}o=T;if(E.isInstanceOf(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragEnter(T);}else{this.onDragEnter(T);}}if(E.isInstanceOf(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragOver(T);}else{this.onDragOver(T);}f.stopPropagation();};
b.prototype._getValidTargetZoneAggregationOverlay=function(f){if(E.isInstanceOf(f,"sap.ui.dt.AggregationOverlay")&&f.getTargetZone()){return f;}else{return this._getValidTargetZoneAggregationOverlay(f.getParent());}};
b.prototype._onTouchEnd=function(f){var g=a.getOverlay(f.currentTarget.id);var A=this._getValidTargetZoneAggregationOverlay(g);if(A){this.onAggregationDrop(A);}this.onDragEnd(g);this._detachTouchDragEvents(g);o=undefined;p=false;};
b.prototype.showGhost=function(f,g){if(g&&g.originalEvent&&g.originalEvent.dataTransfer){g.originalEvent.dataTransfer.effectAllowed="move";g.originalEvent.dataTransfer.dropEffect="move";if(!sap.ui.Device.browser.internet_explorer&&!sap.ui.Device.browser.edge&&!sap.ui.Device.browser.msie&&g.originalEvent.dataTransfer.setDragImage){this._$ghost=this.createGhost(f,g);this._$ghost.appendTo("#overlay-container");setTimeout(function(){this._removeGhost();}.bind(this),0);g.originalEvent.dataTransfer.setDragImage(this._$ghost.get(0),g.originalEvent.pageX-f.$().offset().left,g.originalEvent.pageY-f.$().offset().top);}}};
b.prototype._removeGhost=function(){this.removeGhost();delete this._$ghost;};
b.prototype.removeGhost=function(){var $=this.getGhost();if($){$.remove();}};
b.prototype.createGhost=function(f){var g=f.getAssociatedDomRef();var $;if(!g){g=this._getAssociatedDomCopy(f);$=g;}else{$=jQuery("<div></div>");jQuery.makeArray(g).forEach(function(n){D.cloneDOMAndStyles(n,$);});}var h=jQuery("<div></div>").addClass("sapUiDtDragGhostWrapper");return h.append($.addClass("sapUiDtDragGhost"));};
b.prototype._getAssociatedDomCopy=function(f){var $=jQuery("<div></div>");f.getAggregationOverlays().forEach(function(A){A.getChildren().forEach(function(C){var g=C.getAssociatedDomRef();if(g){D.cloneDOMAndStyles(g,$);}else{D.cloneDOMAndStyles(this._getAssociatedDomCopy(C),$);}},this);},this);return $;};
b.prototype.getGhost=function(){return this._$ghost;};
b.prototype._onDragEnd=function(f){_=false;var g=a.getOverlay(f.currentTarget.id);this._removeGhost();this._clearAllScrollIntervals();this.onDragEnd(g);f.stopPropagation();};
b.prototype._onDrag=function(f){var g=a.getOverlay(f.currentTarget.id);this.onDrag(g);f.stopPropagation();};
b.prototype._onDragEnter=function(f){var g=a.getOverlay(f.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragEnter(g)){f.stopPropagation();}}f.preventDefault();};
b.prototype._onDragLeave=function(f){var g=a.getOverlay(f.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragLeave(g)){f.stopPropagation();}}f.preventDefault();};
b.prototype._onDragOver=function(f){var g=a.getOverlay(f.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragOver(g)){f.stopPropagation();}}f.preventDefault();};
b.prototype._onAggregationTargetZoneChange=function(f){var A=f.getSource();var t=f.getParameter("targetZone");if(t){this._attachAggregationOverlayEvents(A);}else{this._detachAggregationOverlayEvents(A);}};
b.prototype._attachAggregationOverlayEvents=function(A){A.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.attachBrowserEvent("dragover",this._onAggregationDragOver,this);A.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.attachBrowserEvent("drop",this._onAggregationDrop,this);};
b.prototype._detachAggregationOverlayEvents=function(A){A.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.detachBrowserEvent("dragover",this._onAggregationDragOver,this);A.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.detachBrowserEvent("drop",this._onAggregationDrop,this);};
b.prototype._onAggregationDragEnter=function(f){var A=a.getOverlay(f.currentTarget.id);this.onAggregationDragEnter(A);f.preventDefault();f.stopPropagation();};
b.prototype._onAggregationDragOver=function(f){var A=a.getOverlay(f.currentTarget.id);this.onAggregationDragOver(A);f.preventDefault();f.stopPropagation();};
b.prototype._onAggregationDragLeave=function(f){var A=a.getOverlay(f.currentTarget.id);this.onAggregationDragLeave(A);f.preventDefault();f.stopPropagation();};
b.prototype._onAggregationDrop=function(f){var A=a.getOverlay(f.currentTarget.id);this.onAggregationDrop(A);f.preventDefault();f.stopPropagation();};
var c=100;var d=20;var e=50;
b.prototype._clearScrollInterval=function(s,f){if(this._mScrollIntervals[s]){window.clearInterval(this._mScrollIntervals[s][f]);delete this._mScrollIntervals[s][f];}};
b.prototype._clearScrollIntervalFor=function(s){if(this._mScrollIntervals[s]){Object.keys(this._mScrollIntervals[s]).forEach(function(f){this._clearScrollInterval(s,f);},this);}};
b.prototype._clearAllScrollIntervals=function(){Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));};
b.prototype._checkScroll=function($,s,i){var S;var f;var g=1;if(s==="top"||s==="bottom"){S=$.height();f=$.scrollTop.bind($);}else{S=$.width();f=$.scrollLeft.bind($);}if(s==="top"||s==="left"){g=-1;}var h=Math.floor(S/4);var t=c;if(h<c){t=h;}if(i<t){this._mScrollIntervals[$.attr("id")]=this._mScrollIntervals[$.attr("id")]||{};if(!this._mScrollIntervals[$.attr("id")][s]){this._mScrollIntervals[$.attr("id")][s]=window.setInterval(function(){var j=f();f(j+g*d);},e);}}else{this._clearScrollInterval($.attr("id"),s);}};
b.prototype._dragLeave=function(f){var A=a.getOverlay(f.currentTarget.id);this._clearScrollIntervalFor(A.$().attr("id"));};
b.prototype._dragScroll=function(f){var A=a.getOverlay(f.currentTarget.id);var $=A.$();var i=f.clientX;var g=f.clientY;var h=$.offset();var H=$.height();var w=$.width();var t=h.top;var l=h.left;var B=t+H;var r=l+w;this._checkScroll($,"bottom",B-g);this._checkScroll($,"top",g-t);this._checkScroll($,"right",r-i);this._checkScroll($,"left",i-l);};
b.prototype._attachDragScrollHandler=function(f){var A;if(E.isInstanceOf(f,"sap.ui.dt.AggregationOverlay")){A=f;}else{A=f.srcControl;}if(D.hasScrollBar(A.$())){A.getDomRef().addEventListener("dragover",this._dragScrollHandler,true);A.getDomRef().addEventListener("dragleave",this._dragLeaveHandler,true);}};
b.prototype._removeDragScrollHandler=function(f){var A;if(E.isInstanceOf(f,"sap.ui.dt.AggregationOverlay")){A=f;}else{A=f.srcControl;}var g=A.getDomRef();if(g){g.removeEventListener("dragover",this._dragScrollHandler,true);}};
b.prototype.isBusy=function(){return _;};
return b;},true);
sap.ui.predefine('sap/ui/dt/plugin/MouseSelection',['sap/ui/dt/Plugin'],function(P){"use strict";
var M=P.extend("sap.ui.dt.plugin.MouseSelection",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});
M.prototype.init=function(){P.prototype.init.apply(this,arguments);};
M.prototype.registerElementOverlay=function(o){o.setSelectable(true);o.attachBrowserEvent('click',this._onClick,o);};
M.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent('click',this._onClick,o);};
M.prototype._onClick=function(e){this.setSelected(!this.getSelected());e.preventDefault();e.stopPropagation();};
return M;},true);
sap.ui.predefine('sap/ui/dt/test/Element',['jquery.sap.global','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayRegistry'],function(q,E,O){"use strict";var M=5;var a={};
a.getInfo=function(e){var m=e.getMetadata();var o=O.getOverlay(e);return{metadata:m,overlay:o};};
a.getAggregationInfo=function(e,A){var m={ignored:true,domRefDeclared:false,domRefFound:false,domRefVisible:false,overlayTooSmall:false,overlayGeometryCalculatedByChildren:false,overlayVisible:false};var d;var b=this.getInfo(e);var o=b.overlay.getAggregationOverlay(A);if(o){d=o.getDesignTimeMetadata();}if(d&&!d.isIgnored(e)){m.ignored=false;m.domRefDeclared=!!d.getDomRef();var c=o.getAssociatedDomRef();if(c){m.domRefFound=true;m.domRefVisible=q(c).is(":visible");}var g=o.getGeometry();if(g){var s=g.size;m.overlayTooSmall=(s.width<=M||s.height<=M);m.overlayGeometryCalculatedByChildren=!g.domRef;m.overlayVisible=o.$().is(":visible");}}return m;};
a.getAggregationsInfo=function(e){var A={};E.iterateOverAllPublicAggregations(e,function(o){A[o.name]=this.getAggregationInfo(e,o.name);}.bind(this));return A;};
return a;},true);
sap.ui.predefine('sap/ui/dt/test/ElementEnablementTest',['jquery.sap.global','sap/ui/dt/test/Test','sap/ui/dt/DesignTime','sap/ui/dt/test/Element'],function(q,T,D,E){"use strict";
function t(){return new Promise(function(r){function o(){sap.ui.getCore().detachThemeChanged(o);r();}sap.ui.getCore().attachThemeChanged(o);});}
function w(){if(sap.ui.getCore().isThemeApplied()){return Promise.resolve();}else{return t();}}
var a=T.extend("sap.ui.dt.test.ElementEnablementTest",{metadata:{library:"sap.ui.dt",properties:{type:{type:"string"},create:{type:"any"},timeout:{type:"int",defaultValue:0},groupPostfix:{type:"string"}}}});
a.prototype.init=function(){this._aAggregatedTestResult=null;this._aAggregatedInfoResult=null;this._sAggregation=null;this._$TestAreaDomRef=null;};
a.prototype.exit=function(){if(this._oDesignTime){this._oDesignTime.destroy();}window.clearTimeout(this._iTimeout);this._oElement.destroy();if(this._$TestAreaDomRef){this._$TestAreaDomRef.remove();delete this._$TestAreaDomRef;}};
a.prototype.run=function(){return this._setup().then(function(){this._mResult=this.createSuite("Element Enablement Test");var e=this.addGroup(this._mResult.children,this.getType(),"Given that a DesignTime is created for "+this.getType());this._testAggregations(e.children);this._mResult=this.aggregate(this._mResult);return this._mResult;}.bind(this));};
a.prototype._createElement=function(){var s=this.getType();var c=this.getCreate();var b=q.sap.getObject(s);var e;if(c){e=c();}else{e=new b();}if(e.addStyleClass){e.addStyleClass("minSize");}return e;};
a.prototype._getTestArea=function(){if(!this._$TestAreaDomRef){this._$TestAreaDomRef=q("<div id='"+this.getId()+"--testArea"+"'></div>").css({height:"500px",width:"1000px"}).appendTo("body");}return this._$TestAreaDomRef;};
a.prototype._setup=function(){window.clearTimeout(this._iTimeout);this._bNoRenderer=false;this._bErrorDuringRendering=false;return new Promise(function(r,R){w().then(function(){this._oElement=this._createElement();try{this._oElement.getRenderer();}catch(e){this._bNoRenderer=true;}if(!this._bNoRenderer){try{this._oElement.placeAt(this._getTestArea().get(0));sap.ui.getCore().applyChanges();}catch(e){this._bErrorDuringRendering=true;}if(!this._bErrorDuringRendering){this._oDesignTime=new D({rootElements:[this._oElement]});this._oDesignTime.attachEventOnce("synced",function(){if(this.getTimeout()){this._iTimeout=window.setTimeout(function(){r();},this.getTimeout());}else{r();}},this);}else{r();}}else{r();}}.bind(this));}.bind(this));};
a.prototype._testAggregations=function(b){var A=this.addGroup(b,"Aggregations","Each aggregation needs to be ignored or has a visible domRef maintained in the metadata",this.getGroupPostfix());if(this._bNoRenderer){this.addTest(A.children,true,"Control has no renderer","Control has no renderer, not supported by the element test (requires a special element test)",T.STATUS.UNKNOWN);}else if(this._bErrorDuringRendering){this.addTest(A.children,true,"Error during rendering","Element can't be rendered, not supported by the DesignTime (please, provide a create method for this element)",T.STATUS.ERROR);}else{var m=E.getAggregationsInfo(this._oElement);for(var s in m){var c=m[s];var d=this.addGroup(A.children,s,(c.ignored?"Aggregation ignored":"Aggregation tests"));if(!c.ignored){this.addTest(d.children,c.overlayVisible,"Overlay Visible","Overlay domRef is visible in DOM");if(c.domRefDeclared){this.addTest(d.children,c.domRefDeclared,"Dom Ref Declared","DomRef is declared in design time metadata");this.addTest(d.children,c.domRefFound,"Dom Ref Found","Declared DomRef is found in DOM");this.addTest(d.children,c.domRefVisible,"Dom Ref Visible","Declared DomRef is visible");}else if(c.overlayVisible){this.addTest(d.children,c.overlayGeometryCalculatedByChildren,"Overlay Geometry calculated by children","Control might work based on DT Heuristic, but safer with domRefDeclared",T.STATUS.PARTIAL_SUPPORTED);}else{this.addTest(d.children,false,"Overlay Dom Ref","Overlay domRef is not declared and aggregation overlay is not visible (please, declare domRef for this aggregation)",T.STATUS.PARTIAL_SUPPORTED);}if(c.overlayTooSmall){this.addTest(d.children,false,"Overlay too small","Aggregation Overlay is too small to be accessible, please ensure to render it big enough that it can be reach by a user. If content is needed, provide a create method for this element",T.STATUS.PARTIAL_SUPPORTED);}}}}};
return a;},true);
sap.ui.predefine('sap/ui/dt/test/ElementEnablementTest2',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/dt/test/Element','sap/ui/fl/registry/ChangeRegistry'],function(q,M,E,C){"use strict";
var a=M.extend("sap.ui.dt.test.ElementEnablementTest2",{metadata:{library:"sap.ui.dt",properties:{type:{type:"string"}}}});
a.prototype.init=function(){};
a.prototype.exit=function(){};
a.prototype.run=function(){return this._setup().then(function(d){var A;this._mResult={name:this.getType(),actions:undefined};if(!this._bError){A=this._testActions(d);}if(A){this._mResult.actions=A;}return this._mResult;}.bind(this));};
a.prototype._setup=function(){window.clearTimeout(this._iTimeout);this._bNotSupported=false;this._bError=false;var e=q.sap.getObject(this.getType());return e.getMetadata().loadDesignTime().catch(function(o){this._bError=true;}.bind(this));};
a.prototype._testActions=function(d){var A;var p;var m=[];var b=[];var c=false;var e=false;var i=0;if(!d||(!d.actions&&!d.aggregations)){this._bNotSupported=true;}else{if(d.actions){for(var s in d.actions){b[i]=s;m[i]={action:s,aggregation:"self"};i=i+1;}c=true;}if(d.aggregations){for(var f in d.aggregations){var o=d.aggregations[f];if(o.propagateMetadata){p=(p)?p+", "+f:"propagate ("+f;}for(var s in o.actions){i=b.indexOf(s);if(i===-1){b.push(s);i=b.indexOf(s);m[i]={action:s,aggregation:f};}else{m[i].aggregation=m[i].aggregation+", "+f;}e=true;}}}if(!c&&!e){this._bNotSupported=true;return A;}m.forEach(function(g){A=(A)?A+", ":"";A=A+g.action+" ("+g.aggregation+")";});if(p){p=p+")";A=A+" + "+p;}return A;}};
return a;},true);
sap.ui.predefine('sap/ui/dt/test/LibraryEnablementTest',['jquery.sap.global','sap/ui/dt/test/Test','sap/ui/dt/test/ElementEnablementTest'],function(q,T,E){"use strict";
var L=T.extend("sap.ui.dt.test.LibraryEnablementTest",{metadata:{library:"sap.ui.dt",properties:{libraryName:{type:"string"},testData:{type:"object"}}}});
L.prototype.run=function(){this._aResult=[];var t=this.getTestData()||{};var l=this.getLibraryName();var e=[];var o=sap.ui.getCore().getLoadedLibraries()[l];if(o){var a=o.controls;a.forEach(function(s){var b=t[s];if(!b&&b!==false){b={};}if(b!==false){b.type=s;var c=null;if(b.create){c=q.extend({},b);delete c.create;b.groupPostfix="with create method";}e.push(new E(b));if(c){e.push(new E(c));}}});}var r=[];var i=function(R){if(R){r.push(R);}var b=e.shift();if(b){return b.run().then(function(R){b.destroy();return i(R);});}else{return Promise.resolve(r);}};return i().then(function(r){var R=this.createSuite("Library Enablement Test");r.forEach(function(m){var c=m.children[0];var p=R.children[R.children.length-1];if(p&&c.name==p.name){p.children=p.children.concat(c.children);}else{R.children.push(c);}});R=this.aggregate(R);return R;}.bind(this));};
return L;},true);
sap.ui.predefine('sap/ui/dt/test/LibraryEnablementTest2',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/dt/test/ElementEnablementTest2'],function(q,M,E){"use strict";
var L=M.extend("sap.ui.dt.test.LibraryEnablementTest2",{});
L.prototype._fillElementArray=function(t){var e={};if(["sap.ui.richtexteditor.RichTextEditor","sap.ui.ux3.QuickView","sap.uiext.inbox.SubstitutionRulesManager","sap.ui.codeeditor.CodeEditor"].indexOf(t)===-1){e.type=t;this.aElementEnablementTest.push(new E(e));}};
L.prototype.run=function(l){this._aResult=[];this.aElementEnablementTest=[];var a=[];this._aControlsCollection=[];if(l.length===0){var v=sap.ui.getVersionInfo();v.libraries.forEach(function(b){if(b.name.indexOf("sap.ui.server")===-1&&b.name.indexOf("themelib_")===-1&&b.name.indexOf("sap.ui.dev")===-1&&b.name!=="sap.ui.core"&&b.name!=="sap.ui.fl"){sap.ui.getCore().loadLibrary(b.name);}});}else{l.forEach(function(d){sap.ui.getCore().loadLibrary(d);});}var o=sap.ui.getCore().getLoadedLibraries();for(var s in o){if(l.length>0&&l.indexOf(s)===-1){continue;}var b=sap.ui.getCore().getLoadedLibraries()[s];if(b&&s!=="sap.ui.core"){var a=b.controls;var c=b.elements;var A=a.concat(c).sort();A.forEach(this._fillElementArray,this);}}var r=[];var i=function(R){if(R&&R.actions){r.push(R);}var e=this.aElementEnablementTest.shift();if(e){return e.run().then(function(R){e.destroy();return i(R);});}else{return Promise.resolve(r);}}.bind(this);return i().then(function(r){var R={results:[]};r.forEach(function(e){R.results.push(e);});return R;});};
return L;},true);
sap.ui.predefine('sap/ui/dt/test/LibraryTest',['sap/ui/model/resource/ResourceModel','sap/ui/model/json/JSONModel','jquery.sap.global'],function(R,J,q){"use strict";var d=[],m=[],b={},l;
function h(k,B){return B.hasText(k)||B.getText(k,[],true)!==null;}
var L=function(t,Q){var p=new Promise(function(r){sap.ui.getCore().loadLibraries([t]).then(function(){var c=sap.ui.getCore().getLoadedLibraries()[t],E=c.controls.concat(c.elements);l=t;sap.ui.require(E.map(function(s){return q.sap.getResourceName(s,"");}),function(){var f=sap.ui.getCore().getLoadedLibraries();try{var g=new R({bundleUrl:sap.ui.resource(t,"messagebundle.properties"),bundleLocale:"en"}),D=new R({bundleUrl:sap.ui.resource(t+".designtime","messagebundle.properties"),bundleLocale:"en"});b.runtime=g.getResourceBundle();b.designtime=D.getResourceBundle();Object.keys(f).forEach(function(s){if(t!==s){g.enhance({bundleUrl:sap.ui.resource(s,"messagebundle.properties"),bundleLocale:"en"});D.enhance({bundleUrl:sap.ui.resource(s+".designtime","messagebundle.properties"),bundleLocale:"en"});}});}catch(e){}var j=[],C=[];for(var i=0;i<arguments.length;i++){if(arguments[i].getMetadata()._oDesignTime){j.push(arguments[i].getMetadata().loadDesignTime());C.push(arguments[i].getMetadata());}}Promise.all(j).then(function(E){var i=0;d=E;m=d.map(function(o){var k=new J(o);k._oControlMetadata=C[i];i++;return k;});a(Q);Q.start();r();});});});});return p;};var M={"/":{optional:false,check:function(c,o,C){c.strictEqual(typeof o,"object",C+" is an object");}},"/designtimeModule":{optional:false,check:function(c,s,C){c.strictEqual(typeof s,"string",C+" defines /designtimeModule : "+s);}},"/actions":{optional:true,check:function(c,A,C){Object.keys(A).forEach(function(s){if(A[s].changeType){c.strictEqual(typeof A[s].changeType,"string",C+" defines "+s+" with changetype:"+A[s].changeType);}else{if(typeof A[s]==="string"){c.strictEqual(typeof A[s],"string",C+" defines "+s+" as string");}else{c.strictEqual(typeof A[s],"function",C+" defines "+s+" as function");}}});}},"/name":{optional:true,check:function(c,e,C){if(typeof e==="string"&&e.indexOf("{")===0&&e.indexOf("}")==e.length-1){return true;}var k=["singular","plural"];k.forEach(function(K){if(typeof e[K]==="function"){c.strictEqual(typeof e[K],"function",C+" defines mandatory entry /name/"+K);}else{c.strictEqual(typeof e[K],"string",C+" defines mandatory entry /name/"+K);}});k.forEach(function(K){var D=false;if(typeof e[K]==="function"){c.strictEqual(typeof e[K],"function",C+" defines function for translation of entry /name/"+K);c.strictEqual(typeof e[K](),"string","Assuming that "+K+" with "+e[K].toString()+" returns a translation at runtime");return;}if(e[K].toUpperCase()!==e[K]){c.ok(true,"Assuming that "+K+" with "+e[K]+" needs currently no translation");return;}if(b.designtime){D=h(e[K],b.designtime);c.strictEqual(D,true,e[K]+" found in designtime message bundle");}if(b.runtime){if(D){c.strictEqual(h(e[K],b.runtime),false,e[K]+" found in runtime message bundle and designtime message bundle, please delete the entry from the runtime message bundle (messagebundle.properties + messagebundle_en.properties)");}else{c.strictEqual(h(e[K],b.runtime),true,e[K]+" found in runtime message bundle only, consider to move this text to the designtime message bundle");}}});}},"/palette":{optional:true,check:function(c,e,C){var v=["ACTION","DISPLAY","LAYOUT","LIST","INPUT","CONTAINER","CHART","TILE","DIALOG"];c.strictEqual(typeof e,"object",C+" defines optional entry /palette/");c.strictEqual(v.indexOf(e.group)>-1,true,"palette entry defines valid group "+e.group);if(e.icons){Object.keys(e.icons).forEach(function(k){var i=e.icons[k];c.strictEqual(typeof i,"string","palette/icons/"+k+" entry defines icon path "+i);var r=q.sap.sjax({url:q.sap.getResourcePath(i,"")});c.ok(r.status==="success","File "+i+" does exist. Check entry palette/icons/"+k);if(i.indexOf(".svg")===i.length-4){c.ok(r.data.documentElement&&r.data.documentElement.tagName==="svg","File "+i+" starts with a svg node");}});}}},"/templates":{optional:true,check:function(c,e,C){if(e.create){var s=e.create;c.strictEqual(typeof s,"string","templates/create entry defines fragment path to "+s);var D=q.sap.sjax({url:q.sap.getResourcePath(s,"")});c.ok(D.data.documentElement&&D.data.documentElement.localName==="FragmentDefinition","File "+s+" exists and starts with a FragmentDefinition node");}}}};
function a(Q){Q.asyncTest("Checking library.designtime.js",function(c){var e=sap.ui.getCore().getLoadedLibraries()[l];if(e.designtime){sap.ui.require([e.designtime],function(o){c.ok(o!==null,e.designtime+" loaded successfully");Q.start();});}else{c.ok(true,"No library.designtime.js "+l);Q.start();}});Q.test("Checking loaded designtime data",function(c){d.forEach(function(D){c.strictEqual(D!=null,true,"Designtime data found and loaded successful");c.strictEqual(typeof D,"object","Designtime data returned an object");});});m.forEach(function(o){var c=o._oControlMetadata,C=c.getName();Q.test(C+": Checking entries in designtime data",function(e){Object.keys(M).forEach(function(p){var f=M[p];var v=o.getProperty(p);if(v===undefined&&!f.optional){e.equal(false,true,C+" does not define mandatory entry "+p);}else if(v!==undefined&&f.optional){e.equal(true,true,C+" does define optional entry "+p);f.check(e,v,C);}else if(v!==undefined&&!f.optional){e.equal(true,true,C+" does define mandatory entry "+p);f.check(e,v,C);}});});});}
return L;},true);
sap.ui.predefine('sap/ui/dt/test/Test',['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){"use strict";
var T=M.extend("sap.ui.dt.test.Test",{metadata:{"abstract":true}});
T.STATUS={"SUPPORTED":{key:"SUPPORTED",text:"supported",value:3},"PARTIAL_SUPPORTED":{key:"PARTIAL_SUPPORTED",text:"partial supported",value:2},"NOT_SUPPORTED":{key:"NOT_SUPPORTED",text:"not supported",value:1},"ERROR":{key:"ERROR",text:"error",value:0},"UNKNOWN":{key:"UNKNOWN",text:"unknown",value:0}};T.TYPE={"TEST":"Test","GROUP":"Group","SUITE":"Suite"};
T.prototype.createSuite=function(n,m){return this.add(null,false,n,m,null,T.TYPE.SUITE);};
T.prototype.addGroup=function(p,n,m,N){return this.add(p,true,n+(N?(" ("+N+")"):""),m,null,T.TYPE.GROUP);};
T.prototype.addTest=function(p,r,n,m,s){return this.add(p,r,n,m,s,T.TYPE.TEST);};
T.prototype.add=function(p,r,n,m,s,t){if(!s){if(r){s=T.STATUS.SUPPORTED;}else{s=T.STATUS.NOT_SUPPORTED;}}var e={name:n,message:m,result:r,status:s,type:t,statistic:{},children:[]};if(p){p.push(e);}return e;};
T.prototype.run=function(){throw new Error("Abstract method");};
T.prototype.aggregate=function(r){if(r.type!=T.TYPE.TEST&&r.children.length>0){var c=r.children;var m=c.map(function(e){var C=this.aggregate(e);return{result:C.result,status:C.status};},this);if(m.length==1){m.push(m[0]);}var R=m.reduce(function(p,C){return{result:this._getResult(p,C),status:this._getStatus(p,C),statistic:this._getStatistic(p,C)};}.bind(this));r.result=R.result;r.status=R.status;r.statistic=R.statistic;}return r;};
T.prototype._getResult=function(p,c){return!p.result?false:c.result;};
T.prototype._getStatus=function(p,c){return p.status.value<c.status.value?p.status:c.status;};
T.prototype._getStatistic=function(p,c){var s=this._getStatisticObjectForEntry(p);if(p!==c){s[c.status.key]++;}return s;};
T.prototype._getStatisticObjectForEntry=function(e){var s={};if(!e.statistic){for(var S in T.STATUS){s[S]=0;}s[e.status.key]++;}else{s=e.statistic;}return s;};
return T;},true);
sap.ui.predefine('sap/ui/dt/test/report/QUnit',['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){"use strict";
var Q=M.extend("sap.ui.dt.test.report.QUnit",{
metadata:{library:"sap.ui.dt",properties:{data:{type:"object"}}},
init:function(){if(!QUnit){throw new Error("QUnit is required for this report.");}},
setData:function(d){if(d){var c=d.children;c.forEach(function(g){this._createModule(g);},this);}this.setProperty("data",d);},
_createModule:function(g){QUnit.module(g.message);g.children.forEach(function(g){this._createTest(g);},this);},
_createTest:function(g){QUnit.test(g.name+": "+g.message,function(a){g.children.forEach(function(g){this._createAssertion(g);},this);}.bind(this));},
_createAssertion:function(g){if(g.children.length>0){g.children.forEach(function(t){assert.ok(t.result,g.name+": "+t.message);});}else{assert.ok(true,g.name+": "+g.message);}}
});
return Q;},true);
sap.ui.predefine('sap/ui/dt/test/report/Statistic',['jquery.sap.global','sap/ui/core/Control','sap/ui/model/json/JSONModel','sap/ui/layout/form/SimpleForm',"sap/m/Label","sap/m/Text","./StatisticRenderer"],function(q,C,J,S,L,T,a){"use strict";
var s=C.extend("sap.ui.dt.test.report.Statistic",{
metadata:{properties:{data:{type:"object"}},aggregations:{"_form":{type:"sap.ui.layout.form.SimpleForm",hidden:true,multiple:false}}},
init:function(){this._oModel=null;this.setAggregation("_form",this._createForm());},
exit:function(){this.setData(null);},
setData:function(d){if(this._oModel){this._oModel.destroy();delete this._oModel;}if(d){this._oModel=new J(d);this._getForm().setModel(this._oModel);}else{this._getForm().setModel(null);}this.setProperty("data",d);},
_createForm:function(){var f=new sap.ui.layout.form.SimpleForm(this.getId()+"--form",{editable:false,title:"Statistics",content:[new L(this.getId()+"--form-supported-label",{text:"Supported"}),new T(this.getId()+"--form-supported-value",{text:"{/statistic/SUPPORTED}"}),new L(this.getId()+"--form-partial-supported-label",{text:"Partial Supported"}),new T(this.getId()+"--form-partial-supported-value",{text:"{/statistic/PARTIAL_SUPPORTED}"}),new L(this.getId()+"--form-not-supported-label",{text:"Not Supported"}),new T(this.getId()+"--form-not-supported-value",{text:"{/statistic/NOT_SUPPORTED}"}),new L(this.getId()+"--form-unknown-label",{text:"Unknown"}),new T(this.getId()+"--form-unknown-value",{text:"{/statistic/UNKNOWN}"}),new L(this.getId()+"--form-error-label",{text:"Error"}),new T(this.getId()+"--form-error-value",{text:"{/statistic/ERROR}"})]});return f;},
_getForm:function(){return this.getAggregation("_form");}
});
return s;},true);
sap.ui.predefine('sap/ui/dt/test/report/StatisticRenderer',['jquery.sap.global'],function(q){"use strict";var S={};
S.render=function(r,s){r.addClass("sapUiDtStatisticReport");r.write("<div");r.writeControlData(s);r.writeStyles();r.writeClasses();r.write(">");r.renderControl(s._getForm());r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/dt/test/report/Table',['jquery.sap.global','sap/ui/core/Control','sap/ui/model/json/JSONModel','sap/ui/table/TreeTable','sap/ui/table/Column','sap/m/Toolbar','sap/m/Title','sap/m/ToolbarSpacer','sap/m/Button','sap/m/SearchField','sap/m/Text','sap/m/RatingIndicator','sap/ui/model/Filter','sap/ui/model/FilterOperator',"./TableRenderer"],function(q,C,J,T,a,b,c,d,B,S,e,R,F,f,g){"use strict";
var t=C.extend("sap.ui.dt.test.report.Table",{
metadata:{properties:{data:{type:"object"}},aggregations:{"_table":{type:"sap.ui.table.TreeTable",hidden:true,multiple:false}}},
init:function(){this.setAggregation("_table",this._createTable());},
exit:function(){clearTimeout(this._iFilterTimeout);this.setData(null);},
setData:function(D){if(this._oModel){this._oModel.destroy();delete this._oModel;}if(D){this._oModel=new J(D);this._getTable().setModel(this._oModel);}else{this._getTable().setModel(null);}this.setProperty("data",D);},
filter:function(s){var m=this._getTable().getModel();if(m){if(s.length>0){var D=this.getData();var h=D.children.filter(function(E){if(s.indexOf("status=")!=-1){return E.status.value==s.substring(s.indexOf("=")+1);}else{return E.name.toLowerCase().indexOf(s.toLowerCase())!=-1;}});m.setData(h);}else{m.setData(this.getData());}}},
_createTable:function(){var t=new T(this.getId()+"--table",{selectionMode:"MultiToggle",visibleRowCount:20,enableSelectAll:false,ariaLabelledBy:"title",toolbar:this._createToolbar(),rows:"{path:'/', parameters: {arrayNames:['children']}}",columns:[this._createTextColumn("name","Name","{name}"),this._createRatingIndicatorColumn("value","Status Values","{status/value}","{status/text} ({status/value})"),this._createTextColumn("status","Status","{status/text}"),this._createTextColumn("message","Message","{message}")]});return t;},
_createToolbar:function(){return new b(this.getId()+"--toolbar",{content:[new d(this.getId()+"--toolbar-spacer"),new B(this.getId()+"--toolbar-collapse-button",{text:"Collapse all",press:this._onCollapseAll.bind(this)}),new B(this.getId()+"--toolbar-expand-button",{text:"Expand",press:this._onExpandSecondLevel.bind(this)}),new S(this.getId()+"--toolbar-search-field",{liveChange:this._onSearch.bind(this)})]});},
_onSearch:function(E){var s=E.getParameter('newValue');clearTimeout(this._iFilterTimeout);this._iFilterTimeout=setTimeout(function(){this.filter(s);}.bind(this),100);},
_createTextColumn:function(i,s,r){return this._createColumn(i,s,new e({text:r}));},
_createRatingIndicatorColumn:function(i,s,r,h){return this._createColumn(i,s,new R({maxValue:3,value:r,enabled:false,tooltip:h}));},
_createColumn:function(i,s,o){return new a(this.getId()+"--table-column-"+i,{label:s,width:"13em",template:o});},
_getTable:function(){return this.getAggregation("_table");},
_onCollapseAll:function(E){var t=this._getTable();t.collapseAll();},
_onExpandSecondLevel:function(E){var t=this._getTable();t.expandToLevel(2);}
});
return t;},true);
sap.ui.predefine('sap/ui/dt/test/report/TableRenderer',['jquery.sap.global'],function(q){"use strict";var T={};
T.render=function(r,t){r.addClass("sapUiDtTableReport");r.write("<div");r.writeControlData(t);r.writeStyles();r.writeClasses();r.write(">");r.renderControl(t._getTable());r.write("</div>");};
return T;},true);
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/dt/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/dt/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.dt","type":"library","embeds":[],"applicationVersion":{"version":"1.54.7"},"title":"SAP UI library: sap.ui.dt (by SAP, Author)","description":"SAP UI library: sap.ui.dt (by SAP, Author)","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.54","libs":{"sap.ui.core":{"minVersion":"1.54.7"}}},"library":{"i18n":false,"content":{"controls":[],"elements":[],"types":["sap.ui.dt.SelectionMode"],"interfaces":[]}}}}'
}});
//# sourceMappingURL=library-preload.js.map