/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(q,M,U,S){"use strict";var C=M.extend("sap.ui.fl.Change",{constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){U.log.error("Constructor : sap.ui.fl.Change : oFile is not defined");}this._oDefinition=f;this._sRequest='';this._bUserDependent=(f.layer==="USER");this._vRevertData=null;this.setState(C.states.NEW);},metadata:{properties:{state:{type:"string"}}}});C.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};C.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};C.prototype._isValidState=function(s){var b=false;Object.keys(C.states).some(function(k){if(C.states[k]===s){b=true;}return b;});if(!b){return false;}if((this.getState()===C.states.NEW)&&(s===C.states.DIRTY)){return false;}return true;};C.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.fileType){i=false;}if(!this._oDefinition.fileName){i=false;}if(!this._oDefinition.changeType){i=false;}if(!this._oDefinition.layer){i=false;}if(!this._oDefinition.originalLanguage){i=false;}return i;};C.prototype.isVariant=function(){return this._oDefinition.fileType==="variant";};C.prototype.getChangeType=function(){if(this._oDefinition){return this._oDefinition.changeType;}};C.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.fileType;}};C.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.originalLanguage){return this._oDefinition.originalLanguage;}return"";};C.prototype.getContext=function(){if(this._oDefinition&&this._oDefinition.context){return this._oDefinition.context;}return"";};C.prototype.getPackage=function(){return this._oDefinition.packageName;};C.prototype.getNamespace=function(){return this._oDefinition.namespace;};C.prototype.setNamespace=function(n){this._oDefinition.namespace=n;};C.prototype.getId=function(){return this._oDefinition.fileName;};C.prototype.getContent=function(){return this._oDefinition.content;};C.prototype.setContent=function(c){this._oDefinition.content=c;this.setState(C.states.DIRTY);};C.prototype.getVariantReference=function(){return this._oDefinition.variantReference||"";};C.prototype.setVariantReference=function(v){this._oDefinition.variantReference=v;this.setState(C.states.DIRTY);};C.prototype.getSelector=function(){return this._oDefinition.selector;};C.prototype.getOwnerId=function(){return this._oDefinition.support?this._oDefinition.support.user:"";};C.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.getTexts : sTextId is not defined");}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){return this._oDefinition.texts[t].value;}}return"";};C.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.setTexts : sTextId is not defined");return;}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){this._oDefinition.texts[t].value=n;this.setState(C.states.DIRTY);}}};C.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};C.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};C.prototype.isLabelReadOnly=function(){if(this._isReadOnlyDueToLayer()){return true;}return this._isReadOnlyDueToOriginalLanguage();};C.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.layer!==c);};C.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};C.prototype.markForDeletion=function(){this.setState(C.states.DELETED);};C.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Change.setRequest : sRequest is not defined");}this._sRequest=r;};C.prototype.getRequest=function(){return this._sRequest;};C.prototype.getLayer=function(){return this._oDefinition.layer;};C.prototype.getComponent=function(){return this._oDefinition.reference;};C.prototype.setComponent=function(c){this._oDefinition.reference=c;};C.prototype.getCreation=function(){return this._oDefinition.creation;};C.prototype.isUserDependent=function(){return(this._bUserDependent);};C.prototype.getPendingAction=function(){return this.getState();};C.prototype.getDefinition=function(){return this._oDefinition;};C.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this.setState(C.states.PERSISTED);}};C.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().fileName;var F=this.getDefinition().fileType;return l+"/"+n+"/"+f+"."+F;};C.prototype.addDependentControl=function(c,a,p,A){if(!c){throw new Error("Parameter vControl is mandatory");}if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}if(!this._oDefinition.dependentSelector){this._oDefinition.dependentSelector={};}if(this._oDefinition.dependentSelector[a]){throw new Error("Alias '"+a+"' already exists in the change.");}var m=p.modifier;var o=p.appComponent;if(Array.isArray(c)){var s=[];c.forEach(function(b){s.push(m.getSelector(b,o,A));});this._oDefinition.dependentSelector[a]=s;}else{this._oDefinition.dependentSelector[a]=m.getSelector(c,o,A);}delete this._aDependentIdList;};C.prototype.getDependentControl=function(a,p){var d=[];var D;if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}var m=p.modifier;var A=p.appComponent;if(!this._oDefinition.dependentSelector){return undefined;}D=this._oDefinition.dependentSelector[a];if(Array.isArray(D)){D.forEach(function(s){d.push(m.bySelector(s,A,p.view));});return d;}else{return m.bySelector(D,A,p.view);}};C.prototype.getDependentIdList=function(a){var t=this;var i;var d=[this.getSelector()];var D=[];if(!this._aDependentIdList){if(this._oDefinition.dependentSelector){d=Object.keys(this._oDefinition.dependentSelector).reduce(function(d,A){return d.concat(t._oDefinition.dependentSelector[A]);},d);}d.forEach(function(o){i=o.id;if(o.idIsLocal){i=a.createId(o.id);}if(i&&D.indexOf(i)===-1){D.push(i);}});this._aDependentIdList=D;}return this._aDependentIdList;};C.prototype.getDependentControlIdList=function(a){var i;var d=this.getDependentIdList().concat();if(d.length>0){var s=this.getSelector();i=s.id;if(s.idIsLocal){i=a.createId(s.id);}var I=d.indexOf(i);if(I>-1){d.splice(I,1);}}return d;};C.prototype.getRevertData=function(){return this._vRevertData;};C.prototype.setRevertData=function(d){this._vRevertData=d;};C.prototype.resetRevertData=function(){this.setRevertData(null);};C.createInitialFileContent=function(p){if(!p){p={};}var f;if(p.fileType){f=p.fileType;}else{f=p.isVariant?"variant":"change";}var n={fileName:p.id||U.createDefaultFileName(p.changeType),fileType:f,changeType:p.changeType||"",reference:p.reference||"",packageName:p.packageName||"",content:p.content||{},selector:p.selector||{},layer:p.layer||U.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:p.namespace||U.createNamespace(p,"changes"),creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},context:p.context||"",support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version},dependentSelector:p.dependentSelector||{},validAppVersions:p.validAppVersions||{}};return n;};return C;},true);
