/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/json/JSONModel","sap/ui/fl/Utils","sap/ui/fl/changeHandler/BaseTreeModifier","sap/ui/fl/Change","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/JsControlTreeModifier"],function(q,J,U,B,C,a,b){"use strict";var V=J.extend("sap.ui.fl.variants.VariantModel",{constructor:function(d,f,c,o){this.pSequentialImportCompleted=Promise.resolve();J.apply(this,arguments);this.bObserve=o;this.oFlexController=f;this.oComponent=c;this.oVariantController=undefined;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");if(f&&f._oChangePersistence){this.oVariantController=f._oChangePersistence._oVariantController;}if(d&&typeof d=="object"){Object.keys(d).forEach(function(k){d[k].variants.forEach(function(v){if(!d[k].currentVariant&&(v.key===d[k].defaultVariant)){d[k].currentVariant=v.key;}v.originalTitle=v.title;v.originalFavorite=v.favorite;});d[k].originalCurrentVariant=d[k].currentVariant;d[k].originalDefaultVariant=d[k].defaultVariant;});this.setData(d);}}});V.prototype.updateCurrentVariant=function(v,n){var c,m;var d;c=this.oData[v].originalCurrentVariant;if(this.oData[v].modified){d=this.oVariantController.getVariantChanges(v,c);this._removeDirtyChanges(d,v,c);this.oData[v].modified=false;}m=this.oFlexController._oChangePersistence.loadSwitchChangesMapForComponent(v,c,n);var A=U.getAppComponentForControl(this.oComponent);return Promise.resolve().then(this.oFlexController.revertChangesOnControl.bind(this.oFlexController,m.aRevert,A)).then(this.oFlexController.applyVariantChanges.bind(this.oFlexController,m.aNew,this.oComponent)).then(function(){this.oData[v].originalCurrentVariant=n;this.oData[v].currentVariant=n;if(this.oData[v].updateVariantInURL){this._updateVariantInURL(v,n);this.oVariantController.updateCurrentVariantInMap(v,n);}this.checkUpdate();}.bind(this));};V.prototype._updateVariantInURL=function(v,n){var t=this.getVariantIndexInURL(v);if(!t.parameters){return;}var p=t.parameters[this.oVariantController.sVariantTechnicalParameterName]?t.parameters[this.oVariantController.sVariantTechnicalParameterName].slice(0):[];t.index===-1?p.push(n):(p[t.index]=n);U.setTechnicalURLParameterValues(this.oComponent,this.oVariantController.sVariantTechnicalParameterName,p);};V.prototype.getVariantIndexInURL=function(v){var p=-1;var t=U.getTechnicalParametersForComponent(this.oComponent);if(t&&Array.isArray(t[this.oVariantController.sVariantTechnicalParameterName])){t[this.oVariantController.sVariantTechnicalParameterName].some(function(P,i){if(!!this.oVariantController.getVariant(v,P)){p=i;return true;}}.bind(this));}return{parameters:t,index:p};};V.prototype.getCurrentVariantReference=function(v){return this.oData[v].currentVariant;};V.prototype.getVariantManagementReference=function(v){var s="";var i=-1;Object.keys(this.oData).some(function(k){return this.oData[k].variants.some(function(o,c){if(o.key===v){s=k;i=c;return true;}});}.bind(this));return{variantManagementReference:s,variantIndex:i};};V.prototype.getVariant=function(v,s){return this.oVariantController.getVariant(s?s:this.getVariantManagementReference(v).variantManagementReference,v);};V.prototype.getVariantProperty=function(v,p){return this.getVariant(v).content.content[p];};V.prototype._addChange=function(c){var v=c.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;this.oData[s].modified=!!this.oData[s].variantsEditable;this.checkUpdate(true);return this.oVariantController.addChangeToVariant(c,s,v);};V.prototype._removeChange=function(c){var v=c.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;return this.oVariantController.removeChangeFromVariant(c,s,v);};V.prototype._removeDirtyChanges=function(v,s,c){var A=U.getAppComponentForControl(this.oComponent);var d=v.map(function(o){return o.fileName;});var f;var D=this.oFlexController._oChangePersistence.getDirtyChanges().filter(function(o){f=d.indexOf(o.getDefinition().fileName)>-1;if(f){this.oVariantController.removeChangeFromVariant(o,s,c);}return f;}.bind(this));D.forEach(function(o){this.oFlexController.deleteChange(o,A);}.bind(this));return this.oFlexController.revertChangesOnControl(D.reverse(),A);};V.prototype._getVariantTitleCount=function(n,v){var d=this.getData();return d[v].variants.reduce(function(c,o){if(n===o.title&&o.visible){c++;}return c;},0);};V.prototype._duplicateVariant=function(p){var n=p.newVariantReference,s=p.sourceVariantReference,S=this.getVariant(s);var d={content:{},controlChanges:JSON.parse(JSON.stringify(S.controlChanges)),variantChanges:{}};var c=U.isLayerAboveCurrentLayer(S.content.layer);Object.keys(S.content).forEach(function(k){if(k==="fileName"){d.content[k]=n;}else if(k==="variantReference"){if(c===0){d.content[k]=S.content["variantReference"];}else if(c===-1){d.content[k]=s;}}else if(k==="content"){d.content[k]=JSON.parse(JSON.stringify(S.content[k]));d.content.content.title=p.title;}else{d.content[k]=S.content[k];}});d.content["layer"]=p.layer;var v=d.controlChanges.slice();var D={};d.controlChanges=v.reduce(function(e,o){if(U.isLayerAboveCurrentLayer(o.layer)===0){D=q.extend(true,{},o);D.fileName=U.createDefaultFileName(o.changeType);D.variantReference=d.content.fileName;if(!D.support){D.support={};}D.support.sourceChangeFileName=o.fileName;e.push(D);}return e;},[]);return d;};V.prototype._copyVariant=function(p){var d=this._duplicateVariant(p);var v={key:d.content.fileName,layer:p.layer,title:d.content.content.title,originalTitle:d.content.content.title,favorite:true,originalFavorite:true,rename:true,change:true,remove:true,visible:true};var o=this.oFlexController.createVariant(d,this.oComponent);var c=[];[o].concat(o.getControlChanges()).forEach(function(e){c.push(this.oFlexController._oChangePersistence.addDirtyChange(e));}.bind(this));var i=this.oVariantController.addVariantToVariantManagement(o.getDefinitionWithChanges(),p.variantManagementReference);this.oData[p.variantManagementReference].variants.splice(i,0,v);return this.updateCurrentVariant(p.variantManagementReference,o.getId()).then(function(){return c;});};V.prototype.removeVariant=function(v,s,c){var d=this.oFlexController._oChangePersistence.getDirtyChanges().filter(function(o){return(o.getVariantReference&&o.getVariantReference()===v.getId())||o.getId()===v.getId();});d.forEach(function(o){this.oFlexController._oChangePersistence.deleteChange(o);}.bind(this));return this.updateCurrentVariant(c,s).then(function(){var i=this.oVariantController.removeVariantFromVariantManagement(v,c);this.oData[c].variants.splice(i,1);this.checkUpdate();}.bind(this));};V.prototype.collectModelChanges=function(v,l){var d=this.getData()[v];var m=d.variants;var c=[];var p={};m.forEach(function(o){if(o.originalTitle!==o.title){p={variantReference:o.key,changeType:"setTitle",title:o.title,originalTitle:o.originalTitle,layer:l};c.push(p);}if(o.originalFavorite!==o.favorite){p={variantReference:o.key,changeType:"setFavorite",favorite:o.favorite,originalFavorite:o.originalFavorite,layer:l};c.push(p);}if(!o.visible){p={variantReference:o.key,changeType:"setVisible",visible:false,layer:l};c.push(p);}});if(d.originalDefaultVariant!==d.defaultVariant){p={variantManagementReference:v,changeType:"setDefault",defaultVariant:d.defaultVariant,originalDefaultVariant:d.originalDefaultVariant,layer:l};c.push(p);}return c;};V.prototype.manageVariants=function(v,s,l){return new Promise(function(r){v.attachManage({resolve:r,variantManagementReference:s,layer:l},this.fnManageClickRta,this);v.openManagementDialog(true);}.bind(this));};V.prototype._setVariantProperties=function(v,p,A){var i=-1;var o;var c=null;var d=this.getData();if(p.variantReference){i=this.getVariantManagementReference(p.variantReference).variantIndex;o=d[v].variants[i];}var n={};var m={};switch(p.changeType){case"setTitle":m.title=p.title;o.title=p.title;o.originalTitle=o.title;break;case"setFavorite":m.favorite=p.favorite;o.favorite=p.favorite;o.originalFavorite=o.favorite;break;case"setVisible":m.visible=p.visible;m.createdByReset=false;o.visible=p.visible;break;case"setDefault":m.defaultVariant=p.defaultVariant;d[v].defaultVariant=p.defaultVariant;d[v].originalDefaultVariant=d[v].defaultVariant;break;default:break;}if(i>-1){var s=this.oVariantController._setVariantData(m,v,i);d[v].variants.splice(i,1);d[v].variants.splice(s,0,o);}else if(this.oVariantController._mVariantManagement[v]){this.oVariantController._mVariantManagement[v].defaultVariant=p.defaultVariant;}if(A){n.changeType=p.changeType;n.layer=p.layer;if(p.changeType==="setDefault"){n.fileType="ctrl_variant_management_change";n.selector={id:v};}else{if(p.changeType==="setTitle"){a.setTextInChange(n,"title",p.title,"XFLD");}n.fileType="ctrl_variant_change";n.selector={id:p.variantReference};}c=this.oFlexController.createBaseChange(n,p.appComponent);c.setContent(m);this.oVariantController._updateChangesForVariantManagementInMap(c.getDefinition(),v,true);this.oFlexController._oChangePersistence.addDirtyChange(c);}else{if(p.change){this.oVariantController._updateChangesForVariantManagementInMap(p.change.getDefinition(),v,false);this.oFlexController._oChangePersistence.deleteChange(p.change);}}this.setData(d);this.checkUpdate(true);return c;};V.prototype._ensureStandardVariantExists=function(v){var d=this.getData();if(!d[v]){d[v]={currentVariant:v,originalCurrentVariant:v,defaultVariant:v,originalDefaultVariant:v,variants:[{key:v,title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),originalTitle:this._oResourceBundle.getText("STANDARD_VARIANT_ORIGINAL_TITLE"),favorite:true,originalFavorite:true,visible:true}]};this.setData(d);if(this.oVariantController){var o={changes:{variantSection:{}}};var D={defaultVariant:v,variantManagementChanges:{},variants:[{content:{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",content:{title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE")}},controlChanges:[],variantChanges:{}}]};o.changes.variantSection[v]=D;this.oVariantController._setChangeFileContent(o,{});}}};V.prototype._setModelPropertiesForControl=function(v,A,c){var r=function(o,v,A){if((o.layer===U.getCurrentLayer(!A))&&(o.key!==v)){return true;}else{return false;}};this.oData[v].modified=false;this.oData[v].showFavorites=true;if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents();}c.detachManage(this.fnManageClick,this);c.detachManage(this.fnManageClickRta,this);if(A){this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(o){o.rename=true;o.change=true;o.remove=r(o,v,A);});}else{if(this.oData[v]._isEditable){c.attachManage({variantManagementReference:v},this.fnManageClick,this);this.oData[v].variantsEditable=true;this.oData[v].variants.forEach(function(o){o.remove=r(o,v,A);if(o.layer===U.getCurrentLayer(true)){o.rename=true;o.change=true;}else{o.rename=false;o.change=false;}});}else{this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(o){o.remove=false;o.rename=false;o.change=false;});}}};V.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(e,d){var c=this.collectModelChanges(d.variantManagementReference,d.layer);d.resolve(c);};this.fnManageClick=function(e,d){if(!this.oFlexController||!this.oVariantController){return;}var c=this.collectModelChanges(d.variantManagementReference,U.getCurrentLayer(true));c.forEach(function(o){o.appComponent=this.oComponent;this._setVariantProperties(d.variantManagementReference,o,true);}.bind(this));this.oFlexController._oChangePersistence.saveDirtyChanges();};};V.prototype._handleCurrentVariantChange=function(e){var p=e.getSource();var v=p.getContext().getPath().replace(/^\//,'');if(this.oData[v].currentVariant!==this.oData[v].originalCurrentVariant){this.updateCurrentVariant(v,p.getValue());}};V.prototype._handleSave=function(e){var v=e.getSource();var s=e.getParameter("def");var A=U.getAppComponentForControl(this.oComponent)||U.getAppComponentForControl(v);var c=this._getLocalId(v.getId(),A);var S=this.getCurrentVariantReference(c);if(e.getParameter("overwrite")){this.oFlexController.saveAll();this.oData[c].modified=false;this.checkUpdate(true);return Promise.resolve();}else{var n=U.createDefaultFileName("Copy");var p={variantManagementReference:c,appComponent:A,layer:U.getCurrentLayer(true),title:e.getParameter("name"),sourceVariantReference:S,newVariantReference:n};var d=this.oVariantController.getVariantChanges(c,S);return this._copyVariant(p).then(function(o){return this._removeDirtyChanges(d,c,S).then(function(){if(s){var P={changeType:"setDefault",defaultVariant:n,originalDefaultVariant:this.oData[c].defaultVariant,appComponent:A,layer:U.getCurrentLayer(true),variantManagementReference:c};this._setVariantProperties(c,P,true);}this.oFlexController.saveAll();this.oData[c].modified=false;this.checkUpdate(true);return Promise.resolve();}.bind(this));}.bind(this));}};V.prototype._getLocalId=function(i,A){return B.getSelector(i,A).id;};V.prototype.registerToModel=function(v){var s=this._getLocalId(v,U.getAppComponentForControl(v)||this.oComponent);this._ensureStandardVariantExists(s);if(v){this.oData[s]._isEditable=v.getEditable();this.oData[s].updateVariantInURL=v.getUpdateVariantInURL();v.getTitle().getBinding("text").attachChange(this._handleCurrentVariantChange,this);this._setModelPropertiesForControl(s,false,v);v.attachSave(this._handleSave,this);}};V.prototype.addControlChangesToVariant=function(c,v){var A=U.getAppComponentForControl(this.oComponent);var s=this._getLocalId(v,A),d=this.oData[s].currentVariant,S,p=[];var P={appComponent:this.oComponent,modifier:b};c.forEach(function(o){S=b.bySelector(o.getSelector(),A);o.setVariantReference(d);this._addChange(o);p.push(function(){this.oFlexController._oChangePersistence.addDirtyChange(o);this.oFlexController._oChangePersistence._addChangeAndUpdateDependencies(A,o);return this.oFlexController.checkTargetAndApplyChange(o,S,P);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};return V;},true);
