/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/core/ResizeHandler',"./AlignedFlowLayoutRenderer"],function(q,C,l,R,A){"use strict";var a=C.extend("sap.ui.layout.AlignedFlowLayout",{metadata:{library:"sap.ui.layout",properties:{minItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"12rem"},maxItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"24rem"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},endContent:{type:"sap.ui.core.Control",multiple:true}}}});a.prototype.init=function(){this._iEndItemWidth=-1;this._sResizeListenerId=R.register(this,this._onResize.bind(this));};a.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};a.prototype._onRenderingOrThemeChanged=function(){var d=this.getDomRef(),e=this.getDomRef("endItem"),E=this.getContent().length&&d&&e;if(E){var L=window.getComputedStyle(d,null),i=L.getPropertyValue("padding-top"),m=e.style;if(sap.ui.getCore().getConfiguration().getRTL()){m.left=L.getPropertyValue("padding-left");}else{m.right=L.getPropertyValue("padding-right");}m.bottom=i;}this._onResize(null,d,e);if(E){d.lastElementChild.style.width=this._iEndItemWidth+"px";}};a.prototype.onAfterRendering=a.prototype._onRenderingOrThemeChanged;a.prototype.onThemeChanged=a.prototype._onRenderingOrThemeChanged;a.prototype._onResize=function(e,d,E){if((e&&(e.size.width===e.oldSize.width))||(this.getContent().length===0)){return;}d=d||this.getDomRef();if(!d){return;}var b=this.getRenderer().CSS_CLASS+"OneLine",c=true;E=E||this.getDomRef("endItem");if(E){var L=d.lastElementChild.style;L.height="";L.display="";d.classList.remove(b);var o=this.getLastItemDomRef(),i=E.offsetHeight,f=E.offsetWidth,g=o.offsetLeft,h;if(sap.ui.getCore().getConfiguration().getRTL()){h=g;}else{var r=g+o.offsetWidth;h=d.offsetWidth-r;}this._iEndItemWidth=f;c=h>=f;if(c){if(this.checkItemsWrapping(d)){if(E.offsetTop<o.offsetTop){L.height=i+"px";L.display="block";}else{L.height="0";L.display="";}}else{if(E.offsetTop<o.offsetTop){L.height=i+"px";}L.display="block";}}else{L.height=i+"px";L.display="block";}}if(!this.checkItemsWrapping(d)&&c){d.classList.add(b);}else{d.classList.remove(b);}};a.prototype.checkItemsWrapping=function(d){d=d||this.getDomRef();if(!d){return false;}var f=d.firstElementChild,L=this.getLastItemDomRef();if(!f||!L){return false;}var F=f.offsetTop,i=L.offsetTop,b=f.offsetHeight;if(i>=(F+b)){return true;}L=this.getDomRef("endItem");return!!L&&(i>=(F+b));};a.prototype.getLastItemDomRef=function(){var c=this.getContent(),i=c.length;if(i){var o=c[i-1],b=o.getDomRef();if(b){return b.parentElement;}}return null;};a.prototype.getLastVisibleDomRef=function(){return this.getDomRef("endItem")||this.getLastItemDomRef();};a.prototype.getNumberOfSpacers=function(){var c=this.getContent().length;if(c===0){return 0;}var s=c,m=this.getMinItemWidth(),M;if(m.lastIndexOf("rem")!==-1){M=q.sap.remToPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}if(M){s=Math.abs(document.documentElement.clientWidth/M);}s=Math.min(s,c-2);s=Math.max(1,s);return Math.floor(s);};return a;});
